/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.runtime.installer.helper.content.CheckedConsumer;
import com.install4j.runtime.installer.helper.content.HttpConnection;
import com.install4j.runtime.installer.platform.win32.wininet.IgnoreCaseString;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractHttpConnectionWrapper
implements HttpConnection {
    private static final int MAX_REDIRECT = Integer.getInteger("install4j.maxHttpRedirect", 5);
    private Map<IgnoreCaseString, List<String>> requestHeaders = new HashMap<IgnoreCaseString, List<String>>();
    private String requestMethod = "GET";
    protected byte[] postData;
    private boolean acceptAllCertificates;
    private int connectTimeout;
    private int readTimeout;
    private boolean followRedirects = true;
    private boolean connectCalled;
    private URL url;

    public AbstractHttpConnectionWrapper(URL url, boolean acceptAllCertificates) {
        this.url = url;
        this.acceptAllCertificates = acceptAllCertificates;
    }

    protected abstract void checkConnected();

    protected abstract void connectNoRedirect() throws IOException;

    @Override
    public void connect() throws IOException {
        if (this.connectCalled) {
            return;
        }
        this.connectCalled = true;
        this.connectNoRedirect();
        int responseCode = this.getResponseCode();
        int redirCount = 0;
        while (this.followRedirects && responseCode >= 300 && responseCode <= 308) {
            String location = this.getHeaderField("Location");
            if (location == null) {
                return;
            }
            URI newUri = URI.create(location);
            String newMethod = AbstractHttpConnectionWrapper.redirectedMethod(responseCode, this.requestMethod);
            if (this.canRedirect(newUri) && ++redirCount < MAX_REDIRECT) {
                this.requestMethod = newMethod;
                this.url = newUri.toURL();
                this.connectNoRedirect();
                responseCode = this.getResponseCode();
                continue;
            }
            return;
        }
    }

    private boolean canRedirect(URI newUri) {
        String oldScheme;
        String newScheme = newUri.getScheme();
        return newScheme.equalsIgnoreCase(oldScheme = this.url.getProtocol()) || newScheme.equalsIgnoreCase("https");
    }

    private static String redirectedMethod(int statusCode, String orig) {
        switch (statusCode) {
            case 301: 
            case 302: {
                return orig.equals("POST") ? "GET" : orig;
            }
            case 303: {
                return "GET";
            }
        }
        return orig;
    }

    @Override
    public void setFollowRedirects(boolean value) {
        this.followRedirects = value;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public String getContentEncoding() {
        return this.getHeaderField("content-encoding");
    }

    @Override
    public String getContentType() {
        return this.getHeaderField("content-type");
    }

    @Override
    public void setRequestMethod(String requestMethod) throws ProtocolException {
        this.requestMethod = requestMethod;
    }

    @Override
    public void setRequestProperty(String key, String value) {
        this.requestHeaders.put(new IgnoreCaseString(key), new ArrayList<String>(Collections.singletonList(value)));
    }

    @Override
    public void addRequestProperty(String key, String value) {
        this.requestHeaders.computeIfAbsent(new IgnoreCaseString(key), s -> new ArrayList()).add(value);
    }

    @Override
    public void setDoOutput(CheckedConsumer<OutputStream, IOException> outputStreamConsumer) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStreamConsumer.consume(outputStream);
        this.postData = outputStream.toByteArray();
    }

    @Override
    public void setDoOutput(byte[] data) throws IOException {
        this.postData = data;
    }

    protected int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    protected int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    private void setRequestHeaderIfNotSet(String key, String value) {
        this.requestHeaders.computeIfAbsent(new IgnoreCaseString(key), s -> new ArrayList<String>(Collections.singletonList(value)));
    }

    @Override
    public void setUseCaches(boolean useCaches) {
        this.setRequestHeaderIfNotSet("cache-control", "no-cache");
        this.setRequestHeaderIfNotSet("pragma", "no-cache");
    }

    @Override
    public long getContentLengthLong() {
        String responseHeader = this.getHeaderField("content-length");
        if (responseHeader != null) {
            try {
                return Long.parseLong(responseHeader);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    protected void checkConnectedAndFound() throws IOException {
        this.checkConnected();
        if (this.getResponseCode() == 404) {
            throw new FileNotFoundException(this.getURL().toExternalForm());
        }
    }

    protected Map<IgnoreCaseString, List<String>> getRequestHeaders() {
        return this.requestHeaders;
    }

    protected String getRequestMethod() {
        return this.requestMethod;
    }

    protected long getPostContentLength() {
        return this.postData == null ? 0L : (long)this.postData.length;
    }

    protected boolean isAcceptAllCertificates() {
        return this.acceptAllCertificates;
    }
}

