<?php

namespace Reviews\Model;

/**
 * Functions for transitions model
 */
interface ITransitions
{
    const BLOCKED              = "blocked";
    const UNAUTHORIZED         = 'unauthorized';
    const NOT_A_PROJECT_MEMBER = 'notProjectMember';
    const USERS                = 'users';
    const GROUPS               = 'groups';

    /**
     * Get the allowed transitions
     * @return array
     */
    public function getAllowed() : array;

    /**
     * Get blocked transitions and the reasons
     * @return array
     */
    public function getBlocked(): array;
}
