<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.4/2843222
 */
namespace Comments\Filter;

use Application\Connection\ConnectionFactory;
use Application\Factory\InvokableService;
use Application\InputFilter\DirectInput;
use Application\InputFilter\InputFilter;
use Application\Validator\ConnectedAbstractValidator;
use Application\Validator\FlatArray;
use Interop\Container\ContainerInterface;
use Users\Validator\Users as UsersValidator;

/**
 * Class AddRemoveReaction
 * @package Comments\Filter
 */
class AddRemoveReaction extends InputFilter implements InvokableService
{
    private $services;
    public function __construct(ContainerInterface $services, array $options = null)
    {
        $this->services = $services;
        $this->addReaction();
    }

    /**
     * Validate reactions value
     */
    protected function addReaction()
    {
        $input = new DirectInput(IAddRemoveReaction::REACTIONS);
        $input->setRequired(true);
        $input->getValidatorChain()
            ->attach(new FlatArray(), true)
            ->attach(
                new UsersValidator(
                    [
                        ConnectedAbstractValidator::CONNECTION => $this->services->get(ConnectionFactory::P4)
                    ]
                )
            );
        $this->add($input);
    }
}
