<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.4/2843222
 */

namespace Authentication\Factory;

use Authentication\Service\LoginAdapterInterface;
use Interop\Container\ContainerInterface;
use Interop\Container\Exception\ContainerException;
use Laminas\ServiceManager\Exception\ServiceNotCreatedException;
use Laminas\ServiceManager\Exception\ServiceNotFoundException;
use Laminas\ServiceManager\Factory\FactoryInterface;

class LoginServiceFactory implements FactoryInterface
{
    const BASICLOGINADAPTER = 'auth_basic';
    const SSOLOGINADAPTER   = 'auth_sso';
    const SAMLLOGINADAPTER  = 'auth_saml';

    /**
     * Test create the service object
     *
     * @param ContainerInterface $container
     * @param string $requestedName
     * @param array|null $options
     * @return mixed|object
     */
    public function __invoke(
        ContainerInterface $container,
        $requestedName,
        array $options = null
    ): LoginAdapterInterface {
        return (null === $options) ? new $requestedName($container) : new $requestedName($container, $options);
    }
}
