<?php
/**
 * Perforce P4 Code Review
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.4/2843222
 */

namespace AiAnalysis;

use Application\Checker;
use InvalidArgumentException;

/**
 * Class AiAnalysisDataRetentionLifetimeChecker. Checks for correct value present in AI config data_retention_lifetime.
 * @package AiAnalysis
 */
class AiAnalysisDataRetentionLifetimeChecker extends Checker
{
    /**
     * Performs a check to see that data_retention_lifetime has correct value present in AI config.
     * @param string            $check      the name of the check
     * @param array|null        $options    optional data to assist the check
     * @throws InvalidArgumentException if input data failed due to invalid value set at config
     */
    public function check(string $check, array $options = null): void
    {
        $aiDataRetention = $options[Checker::VALUE];
        $units           = 'second|seconds|minute|minutes|hour|hours|day|days|week|weeks|month|months|year|years';
        if (!preg_match('/^\s*(\d+(\.\d+)?)\s*('.$units . ')\s*$/i', $aiDataRetention)) {
            throw new InvalidArgumentException(
                sprintf(
                    "data_retention_lifetime config value `%s` set at config.php is incorrect.".
                    " Please use units such as days, week, month along with positive number e.g 30 days, 3 months ",
                    $aiDataRetention
                )
            );
        }
    }
}
