<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.4/2843222
 */

use AiAnalysis\AiAnalysisCharLimitChecker;
use AiAnalysis\AiAnalysisChecker;
use AiAnalysis\AiAnalysisDataRetentionLifetimeChecker;
use AiAnalysis\Factory\AiServiceFactory;
use AiAnalysis\Filter\AiAnalysis;
use AiAnalysis\Filter\DiscardAnalysis;
use AiAnalysis\Filter\IAiAnalysis;
use AiAnalysis\Model\AiAnalysisDAO;
use AiAnalysis\Model\IAiReviewSummary;
use AiAnalysis\Service\GenericAIAdapter;
use AiAnalysis\Service\LMStudioAIAdapter;
use AiAnalysis\Service\OpenAIAdapter;
use Api\Controller\IndexController;
use Api\IRequest;
use Application\Checker;
use Application\Config\IConfigDefinition;
use Application\Config\IDao;
use Application\Config\Services;
use Application\Controller\IndexControllerFactory;
use AiAnalysis\Controller\AiAnalysisApi;
use Application\Factory\InvokableServiceFactory;
use Laminas\Http\Request;
use Laminas\Router\Http\Method;
use Laminas\Router\Http\Segment;

return [
    IConfigDefinition::AI_REVIEW => [
        IConfigDefinition::AI_VENDORS => [
            IConfigDefinition::AI_MODEL1 => [
                IConfigDefinition::AI_VENDOR => 'openAI',
                IConfigDefinition::AI_PACKAGE_ID => 1,
                IConfigDefinition::AI_PACKAGE_KEY => 'openaiwithexplaincodeongpt4',
                IConfigDefinition::AI_PACKAGE_VALUE => 'Open AI With Explain Code On GPT4',
                IConfigDefinition::AI_MODEL => 'gpt-4',
                IConfigDefinition::AI_PACKAGE_TYPE => 'Explain the following code',
                IConfigDefinition::API_KEY => 'openAI',
                IConfigDefinition::AI_MIN_CHAR_LIMIT => 4,
                IConfigDefinition::AI_MAX_CHAR_LIMIT => 31000,
                IConfigDefinition::API_END_POINT => '',
                IConfigDefinition::AI_COMMENT_PROMPTS => [
                    IConfigDefinition::IMPROVE_COMMENT => 'You are a writing assistant helping users improve short 
    comments or messages. Please revise this input text to make it clearer, more professional, and 
    appropriate for the intended context. Preserve the original intent and tone unless it is unclear or 
    inappropriate. If the comment is vague, suggest a more specific version. Avoid making the text 
    overly formal unless necessary.Return only the improved version of the text, without explanations. For this 
    statement: ',
                    IConfigDefinition::SUMMARIZE_TEXT => 'You are a summarization assistant helping users condense their
     writing into a clear and concise summary. Please summarize this text in a way that preserves the key 
    points and intent. Use plain language and keep the summary brief and easy to understand. If the 
    original text includes action items, decisions, or important context, make sure those are included 
    in the summary.Return only the summary, without explanations or commentary. For this statement: ',
                    IConfigDefinition::FIX_SPELLING_AND_GRAMMAR => 'You are a writing assistant helping users correct 
    spelling, grammar, and punctuation in short comments or messages. Please correct any spelling, 
    grammar, punctuation, or basic sentence structure issues. Do not change the tone, intent, or style 
    unless necessary to fix the grammar. Keep the revised version natural and readable.Return only the 
    corrected version of the text, without explanations. For this statement: ',
                    IConfigDefinition::CUSTOM_PROMPT => ''
                ]
            ]
        ],
        IConfigDefinition::ENABLED => false,
        IConfigDefinition::DATA_RETENTION_LIFETIME => '30 days',
        IConfigDefinition::AI_TIMEOUT => 30,
    ],
    'router' => [
        'routes' => [
            'api' => [
                'type' => 'literal',
                'options' => [
                    'route' => IndexController::API_BASE,
                ],
                'may_terminate' => false,
                'child_routes' => [
                    'AiAnalysis' => [
                        'type' => Segment::class,
                        'options' => [
                            'route' => '/:version/AiAnalysis',
                            'constraints' => [IRequest::VERSION => 'v11'],
                            'defaults' => [
                                'controller' => AiAnalysisApi::class
                            ],
                        ],
                        'child_routes' => [
                            'AiAnalysis-analyze' => [
                                'type' => Segment::class,
                                'options' => [
                                    'route' => '/analyzeCode',
                                ],
                                'child_routes' => [
                                    'analyzeCode' => [
                                        'type' => Method::class,
                                        'options' => [
                                            'verb' => Request::METHOD_POST,
                                            'defaults' => [
                                                'action' => 'analyzeCode'
                                            ],
                                        ],
                                    ],
                                ],
                            ],
                            'AiAnalysis-getAiPackageDetails' => [
                                'type' => Segment::class,
                                'options' => [
                                    'route' => '/getAiPackageDetails',
                                ],
                                'child_routes' => [
                                    'getAiPackageDetails' => [
                                        'type' => Method::class,
                                        'options' => [
                                            'verb' => Request::METHOD_GET,
                                            'defaults' => [
                                                'action' => 'getAiPackageDetails'
                                            ],
                                        ],
                                    ],
                                ],
                            ],
                            'AiAnalysis-discard' => [
                                'type' => Segment::class,
                                'options' => [
                                    'route' => '/discard',
                                ],
                                'child_routes' => [
                                    'discard' => [
                                        'type' => Method::class,
                                        'options' => [
                                            'verb' => Request::METHOD_DELETE,
                                            'defaults' => [
                                                'action' => 'discard'
                                            ],
                                        ],
                                    ],
                                ],
                            ],
                            'AiAnalysis-removeAiSummaries' => [
                                'type' => Segment::class,
                                'options' => [
                                    'route' => '/removeAiSummaries',
                                ],
                                'child_routes' => [
                                    'removeAiSummaries' => [
                                        'type' => Method::class,
                                        'options' => [
                                            'verb' => Request::METHOD_DELETE,
                                            'defaults' => [
                                                'action' => 'removeAiSummaries'
                                            ],
                                        ],
                                    ],
                                ],
                            ],
                            'AiAnalysis-improveCommentByAI' => [
                                'type' => Segment::class,
                                'options' => [
                                    'route' => '/improveCommentByAI',
                                ],
                                'child_routes' => [
                                    'improveCommentByAI' => [
                                        'type' => Method::class,
                                        'options' => [
                                            'verb' => Request::METHOD_POST,
                                            'defaults' => [
                                                'action' => 'improveCommentByAI'
                                            ],
                                        ],
                                    ],
                                ],
                            ],
                        ],
                    ],
                ]
            ]
        ]
    ],
    'service_manager' => [
        'aliases' => [
            IDao::AI_ANALYSIS_DAO  => AiAnalysisDAO::class,
            AiServiceFactory::OPENAIADAPTER => OpenAIAdapter::class,
            AiServiceFactory::GENERICAIADAPTER => GenericAIAdapter::class,
            AiServiceFactory::LMSTUDIOAIADAPTER => LMStudioAIAdapter::class,
            IAiAnalysis::NAME => AiAnalysis::class,
            IAiAnalysis::DISCARD_ANALYSIS_FILTER => DiscardAnalysis::class,
        ],
        'factories' => [
                AiAnalysisDAO::class => InvokableServiceFactory::class,
                OpenAIAdapter::class => AiServiceFactory::class,
                Services::OPEN_AI => OpenAIAdapter::class,
                GenericAIAdapter::class => AiServiceFactory::class,
                Services::GENERIC_AI => GenericAIAdapter::class,
                LMStudioAIAdapter::class => AiServiceFactory::class,
                Services::LM_STUDIO_AI => LMStudioAIAdapter::class,
                AiAnalysis::class => InvokableServiceFactory::class,
                AiAnalysisChecker::class => InvokableServiceFactory::class,
                AiAnalysisCharLimitChecker::class => InvokableServiceFactory::class,
                AiAnalysisDataRetentionLifetimeChecker::class => InvokableServiceFactory::class,
                DiscardAnalysis::class => InvokableServiceFactory::class,
        ],
    ],
    'controllers' => [
        'factories' => [
            AiAnalysisApi::class => IndexControllerFactory::class,
        ]
    ],
    /**
     * Map a check name of IAiReviewSummary::AI_ANALYSIS to be handled by AiAnalysisChecker
     * Map a check name of IAiReviewSummary::AI_ANALYSIS_CHAR_LIMIT to be handled by AiAnalysisCharLimitChecker
     * Map a check name of IAiReviewSummary::AI_ANALYSIS_DATA_RETENTION_LIFETIME to be handled
     * by AiAnalysisDataRetentionLifetimeChecker
     * @see ConfigCheck
     */
    Checker::CHECKERS => [
        IAiReviewSummary::AI_ANALYSIS => AiAnalysisChecker::class,
        IAiReviewSummary::AI_ANALYSIS_CHAR_LIMIT => AiAnalysisCharLimitChecker::class,
        IAiReviewSummary::AI_ANALYSIS_DATA_RETENTION_LIFETIME => AiAnalysisDataRetentionLifetimeChecker::class
    ]
];
