"use strict";

async function runOnload() {
  var displayInfoTable = document.getElementById("displayInfoTable");

  var row = displayInfoTable.insertRow(0);

  var cellLeft = row.insertCell(0);
  var textNode = document.createTextNode("ApiVersion:");
  cellLeft.appendChild(textNode);
  cellLeft.setAttribute("class", "nameFont");

  var cellRight = row.insertCell(1);
  textNode = document.createTextNode(await p4vjs.getApiVersion());
  cellRight.appendChild(textNode);

  row = displayInfoTable.insertRow(1);

  cellLeft = row.insertCell(0);
  textNode = document.createTextNode("Charset:");
  cellLeft.appendChild(textNode);
  cellLeft.setAttribute("class", "nameFont");

  cellRight = row.insertCell(1);
  textNode = document.createTextNode(await p4vjs.getCharset());
  cellRight.appendChild(textNode);

  row = displayInfoTable.insertRow(2);

  cellLeft = row.insertCell(0);
  textNode = document.createTextNode("Client Workspace:");
  cellLeft.appendChild(textNode);
  cellLeft.setAttribute("class", "nameFont");

  cellRight = row.insertCell(1);
  textNode = document.createTextNode(await p4vjs.getClient());
  cellRight.appendChild(textNode);

  row = displayInfoTable.insertRow(3);

  cellLeft = row.insertCell(0);
  textNode = document.createTextNode("Port:");
  cellLeft.appendChild(textNode);
  cellLeft.setAttribute("class", "nameFont");

  cellRight = row.insertCell(1);
  textNode = document.createTextNode(await p4vjs.getPort());
  cellRight.appendChild(textNode);

  row = displayInfoTable.insertRow(4);

  cellLeft = row.insertCell(0);
  textNode = document.createTextNode("User:");
  cellLeft.appendChild(textNode);
  cellLeft.setAttribute("class", "nameFont");

  cellRight = row.insertCell(1);
  textNode = document.createTextNode(await p4vjs.getUser());
  cellRight.appendChild(textNode);

  row = displayInfoTable.insertRow(5);

  cellLeft = row.insertCell(0);
  textNode = document.createTextNode("Server root:");
  cellLeft.appendChild(textNode);
  cellLeft.setAttribute("class", "nameFont");

  cellRight = row.insertCell(1);
  textNode = document.createTextNode(await p4vjs.getServerRootDirectory());
  cellRight.appendChild(textNode);

  row = displayInfoTable.insertRow(6);

  cellLeft = row.insertCell(0);
  textNode = document.createTextNode("Server version:");
  cellLeft.appendChild(textNode);
  cellLeft.setAttribute("class", "nameFont");

  cellRight = row.insertCell(1);
  textNode = document.createTextNode(await p4vjs.getServerVersion());
  cellRight.appendChild(textNode);

  row = displayInfoTable.insertRow(7);

  cellLeft = row.insertCell(0);
  textNode = document.createTextNode("Unicode?:");
  cellLeft.appendChild(textNode);
  cellLeft.setAttribute("class", "nameFont");

  cellRight = row.insertCell(1);
  textNode = document.createTextNode((await p4vjs.isServerUnicode() == "true" ? 'Yes' : 'No'));
  cellRight.appendChild(textNode);

  row = displayInfoTable.insertRow(7);

  cellLeft = row.insertCell(0);
  textNode = document.createTextNode("Case sensitive?:");
  cellLeft.appendChild(textNode);
  cellLeft.setAttribute("class", "nameFont");

  cellRight = row.insertCell(1);
  textNode = document.createTextNode((await p4vjs.isServerCaseSensitive() == "true" ? 'Yes' : 'No'));
  cellRight.appendChild(textNode);
}