﻿"use strict";
var pendingChange = {};
var pendingChangeStatus = "";

function loadChange() {
    var submitFS = p4vjs.getParameter("submitshelved");
    var clNumber = p4vjs.getParameter("change");

    if (submitFS)
        document.getElementById("changeID").innerHTML = "<b>Changelist Number : </b>" + clNumber + " ( <b>Submitting Shelved Files</b> )";
    else
        document.getElementById("changeID").innerHTML = "<b>Changelist Number : </b>" + clNumber;

    var selectedFiles = p4vjs.selectedFiles();
    if (selectedFiles.length) {
        var filesdisplay = selectedFiles.join('<br>');
        document.getElementById("filesID").innerHTML = "<b>Selected Files :</b><br>" + filesdisplay;
    }

    var selectedDirs = p4vjs.selectedDirectories();
    if (selectedDirs.length) {
        var dirsdisplay = selectedDirs.join('<br>');
        document.getElementById("dirsID").innerHTML = "<b>Selected Directories :</b><br>" + dirsdisplay;
    }

    getChange().then(function(theChange) {
            pendingChange = Object.assign({}, theChange);

            delete pendingChange.Files;
            delete pendingChange.depotFiles;
  
            if (pendingChangeStatus == "new") {
                 pendingChange["Files"] = parseEntries(theChange, "Files");
                 var nextButton = document.getElementById('nextButton');
                 nextButton.style.display = 'none';

                 document.getElementById("defaultID").innerHTML = "<b>HTML Action condition : </b>" + "A default change can only be saved, not submitted.";
            }
            else {
                 pendingChange["Files"] = parseEntries(theChange, "depotFile");
                 var saveButton = document.getElementById('saveButton');
                 saveButton.style.display = 'none';
          }

            delete pendingChange.Jobs;
            pendingChange["Jobs"] = parseEntries(theChange, "joblist");

            document.getElementById("description").value = pendingChange.Description;
    });
}

/**
 * Parses tagged output style array to form input format
 *
 * @return - newline seperated list of strings
 **/
function parseEntries(data, key) {
    var entries = "";

    if (data && key) {
        var index = 0;
        while (data[key + index]) {
            entries = entries + "\n\t" + data[key + index];
            index++;
        }
    }

    return entries;
}

function nextPage() {

    var result = saveForm();

    if (result.error) {
        alert("Perforce error: " + result.error);
    }
}


function saveChange() {

    var result = saveForm();

    if (result.error) {
        alert("Perforce error: " + result.error);
    }
}

/**
 * Saves the form with the new Description provided in the pre-page
 *
 * @return - true if saving change succeeded
 **/
async function saveForm() {
    var myDesc = document.getElementById("description").value;

    if (myDesc.startsWith("<enter description here>"))
        myDesc = "";

    pendingChange["Description"] = myDesc;

    var result = await p4vjs.p4(['change', '-i'], pendingChange);
    if (!result.error) {
        if (pendingChangeStatus == "new") 
           p4vjs.closeWindow();
        else
           p4vjs.nextPage();
    }

    return result;
}

/**
 * Loads the changelist passed in as an argument.
 * 
 * @return - object literal of current changelist data
 **/
async function getChange() {
    var changelist = {};

    try {
        var clNumber = p4vjs.getParameter("change");
        document.getElementById("header").innerHTML = "Submit change: " + clNumber;
        if (clNumber == "default") {
            var changelistData = await p4vjs.p4(["change", "-o"]);
            if (changelistData) {
                changelist = changelistData;
            } 
        }

        if (clNumber && parseInt(clNumber) > 0) {
            var changelistData = await p4vjs.p4(["describe", clNumber]);
            if (changelistData) {
                changelist = changelistData;
            }
        }
    } catch (e) {
        changelist = {};
    }

    return (changelist.data && changelist.data[0]) ? changelist.data[0] : {};
}

