"use strict";

var messages = {"INFO": "P4VJS Info Message", 
                "WARNING": "P4VJS Warning Message", 
                "ERROR": "P4VJS Error Message", 
                "INFOSUMMARY": "P4VJS Info Description: A more detailed summary, regarding an Info message", 
                "WARNINGSUMMARY": "P4VJS Warning Description: A more detailed summary, regarding a Warning message", 
                "ERRORSUMMARY": "P4VJS Error Description: A more detailed summary, regarding an Error message" 
             };

function setMessage(selectedValue)
{
    var inputfield = document.getElementById("messagetext");
    var mvalue = selectedValue;
    var message = messages[mvalue];
    inputfield.value = message;
}

function logMessage()
{
    var type = document.getElementById("messagetype").value;
    var message = document.getElementById("messagetext").value;

    switch(type) {
    case "INFO":
       p4vjs.writeLog(p4vjs.LogType.INFO, message);
       break;
    case "WARNING":
       p4vjs.writeLog(p4vjs.LogType.WARNING, message);
       break;
    case "ERROR":
       p4vjs.writeLog(p4vjs.LogType.ERROR, message);
       break;
    case "INFOSUMMARY":
       p4vjs.writeLog(p4vjs.LogType.INFOSUMMARY, message);
       break;
    case "WARNINGSUMMARY":
       p4vjs.writeLog(p4vjs.LogType.WARNINGSUMMARY, message);
       break;
    case "ERRORSUMMARY":
       p4vjs.writeLog(p4vjs.LogType.ERRORSUMMARY, message);
       break;
    default:
       console.log("Failed to write to log");
    }
}
