"use strict";

async function runOnLoad()
{
    try
    {
        if (p4vjs.getFileIcon == undefined)
        {
            var generalInfoHtmlText = '<p>The getFileIcon method is not implemented in this version of P4VJS</p>';
            var generalInfo = document.getElementById("generalInfo");
            generalInfo.innerHTML = generalInfoHtmlText;
        }
        else
        {
            var generalInfoHtmlText = '<p>Showing file state icons for the following files:</p>';

            var generalInfo = document.getElementById("generalInfo");
            generalInfo.innerHTML = generalInfoHtmlText;
            var fileNames =  p4vjs.selectedFiles();

            fileNames.sort();
            var imageTable = document.getElementById("imageTable");
            for (var i = 0; i < fileNames.length; i++)
            {
                var row = imageTable.insertRow(i + 1);

                // left cell
                var cellLeft = row.insertCell(0);
                var elem = document.createElement("img");
                var image = await p4vjs.getFileIcon(fileNames[i]);
                elem.setAttribute("src", image);
                cellLeft.appendChild(elem);

                // right cell
                var cellRight = row.insertCell(1);
                var textNode = document.createTextNode(fileNames[i]);
                cellRight.appendChild(textNode);
            }
        }
    }
    catch (e)
    {
        alert(e);
    }
}
