/*******************************************************************************

Copyright (c) 2001-2008, Perforce Software, Inc.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1.  Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.

2.  Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL PERFORCE SOFTWARE, INC. BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*******************************************************************************/

/*******************************************************************************
 * Name		: p4mergedata.h
 *
 * Author	: Tony Smith <tony@perforce.com> or <tony@smee.org>
 *
 * Description	: Class for holding merge data
 *
 ******************************************************************************/

class P4MergeData
{
    public:
    P4MergeData( ClientUser *ui, ClientMerge *m, StrPtr &hint, VALUE info );
    P4MergeData( ClientUser *ui, ClientResolveA *m, StrPtr &hint, VALUE info );

    void  SetDebug( int d )	{ debug = d;	}

    //	Content resolve
    VALUE	GetYourName();
    VALUE	GetTheirName();
    VALUE	GetBaseName();

    VALUE	GetYourPath();
    VALUE	GetTheirPath();
    VALUE	GetBasePath();
    VALUE	GetResultPath();

    VALUE	RunMergeTool();

    //	What type of resolve is it?
    VALUE	GetActionResolveStatus();
    VALUE	GetContentResolveStatus();

    //	Action Resolve
    VALUE	GetMergeInfo();

    VALUE	GetMergeAction();
    VALUE	GetYoursAction();
    VALUE	GetTheirAction();
    VALUE	GetType();


    VALUE	GetString();
    VALUE	GetMergeHint();

    // Wrap as Ruby object of class pClass
    VALUE	Wrap( VALUE pClass );

    // Invalidate our merger and actionMerger objects as they do not survive
    // beyond the life of a resolve while this object itself might well do so,
    // particularly in the case of an exception raised from within the block.
    void	Invalidate();

    // Ruby garbage collection
    void  GCMark();

    private:
    int				debug;
    ClientUser *	ui;
    StrBuf			hint;
    ClientMerge *	merger;
    ClientResolveA*	actionmerger;
    StrBuf			yours;
    StrBuf			theirs;
    StrBuf			base;

    VALUE			info;

};

