/*
 * Copyright 1995, 2000 Perforce Software.  All rights reserved.
 *
 * This file is part of Perforce - the FAST SCM System.
 */

/*
 * msggraph.h - definitions of graph depot specific errors
 */

class MsgGraph {

    public:

	static ErrorId CommitDataShort;
	static ErrorId UseGraph;
	static ErrorId UseCatFile;
	static ErrorId UseChanges;
	static ErrorId UseLsTree;
	static ErrorId UseDescribe;
	static ErrorId UseDiff;
	static ErrorId UseDiffTree;
	static ErrorId UseDiff2;
	static ErrorId UseDirs;
	static ErrorId UseFilelog;
	static ErrorId FollowDeletedWildcard;
	static ErrorId UseFiles;
	static ErrorId UseFstat;
	static ErrorId UseLock;
	static ErrorId UseLog;
	static ErrorId UseShowRef;
	static ErrorId UseMerge;
	static ErrorId UseMerge2;
	static ErrorId UseUndo;
	static ErrorId UseRebase;
	static ErrorId UseCherryPick;
	static ErrorId UseOpen;
	static ErrorId UseReconcile;
	static ErrorId UseRefHist;
	static ErrorId UseRevert;
	static ErrorId UseRevList;
	static ErrorId UseReceivePack;
	static ErrorId UsePackObjects;
	static ErrorId UseGraphDescribe;
	static ErrorId UseGraphSync;
	static ErrorId UseGraphProtects;
	static ErrorId UseGraphList;
	static ErrorId UseGraphCollect;
	static ErrorId UseGraphForkRepo;
	static ErrorId UseGraphDeleteRepo;
	static ErrorId UseGraphLFSPush;
	static ErrorId UseGraphLFSFetch;
	static ErrorId UseGraphLFSStat;
	static ErrorId UseGraphLFSLock;
	static ErrorId UseGraphLFSUnlock;
	static ErrorId UseGraphLFSLocks;
	static ErrorId UseGraphSubmodule;
	static ErrorId UseGraphVerify;
	static ErrorId UsePermissionG;
	static ErrorId UsePermissionR;
	static ErrorId UsePermissionS;
	static ErrorId UsePermissions;
	static ErrorId UsePermissionC;
	static ErrorId UsePermNoRef;
	static ErrorId UsePermNeedRef;
	static ErrorId UsePermBadRestrict;
	static ErrorId UsePubKey;
	static ErrorId UsePubKeyS;
	static ErrorId UseReopen;
	static ErrorId UseResolve;
	static ErrorId UseResolved;
	static ErrorId UseSwitch;
	static ErrorId UseTag;
	static ErrorId UseTags;
	static ErrorId UseUnlock;
	static ErrorId ReferenceData;
	static ErrorId ReferenceHistory;
	static ErrorId ReferenceDataShort;
	static ErrorId ReferenceDataMatch;
	static ErrorId ReferenceHeadShort;
	static ErrorId ReferenceDataEmpty;
	static ErrorId ReferenceHaveShort;
	static ErrorId RepoDefaultBranch;
	static ErrorId FileLogData;
	static ErrorId SubmoduleData;
	static ErrorId SubmoduleDeleted;
	static ErrorId SubmoduleUpdated;
	static ErrorId RepositoryData;
	static ErrorId WrongClientType;
	static ErrorId NotSupported;
	static ErrorId CmdNotSupported;
	static ErrorId CurrentBranchShort;
	static ErrorId NoSuchObject;
	static ErrorId NoSuchCommit;
	static ErrorId NoSuchDepot;
	static ErrorId PackRefSyntax;
	static ErrorId PackHeader;
	static ErrorId PackMagic;
	static ErrorId PackIndexCount;
	static ErrorId PackTypeByte;
	static ErrorId PackSizeByte;
	static ErrorId PackIdxFanoutRead;
	static ErrorId PackIdxEndOfFile;
	static ErrorId PackIdxPartial;
	static ErrorId PackOffsetEndOfFile;
	static ErrorId PackOffsetPartial;
	static ErrorId PackIdxLargeEndOfFile;
	static ErrorId PackLargeOffsetPartial;
	static ErrorId DeltaVarint;
	static ErrorId DeltaOffset;
	static ErrorId DeltaOffsetMore;
	static ErrorId DeltaOffsetBits;
	static ErrorId DeltaCopyOffset;
	static ErrorId DeltaLengthBits;
	static ErrorId DeltaCopyLength;
	static ErrorId DeltaRefBaseMissing;
	static ErrorId DeltaLengthMismatch;
	static ErrorId DeltaInsertData;
	static ErrorId CommitMissing;
	static ErrorId CommitNotUnique;
	static ErrorId TagMissing;
	static ErrorId TagNotUnique;
	static ErrorId NoEmailStart;
	static ErrorId NoEmailEnd;
	static ErrorId NoCommitDate;
	static ErrorId TreeModeEndOfFile;
	static ErrorId TreeNameEndOfFile;
	static ErrorId TreeShaEndOfFile;
	static ErrorId LbrShaSyntax;
	static ErrorId LbrWrongType;
	static ErrorId InvalidBlobHeader;
	static ErrorId LbrBadAccess;
	static ErrorId LbrPackBadAccess;
	static ErrorId LooseWriterBadAccess;
	static ErrorId LbrWriteOnly;
	static ErrorId TreeMissing;
	static ErrorId BlobMissing;
	static ErrorId LFSBlobMissing;
	static ErrorId TreeNotUnique;
	static ErrorId RcvRefSyntax;
	static ErrorId RcvFileName;
	static ErrorId NotFastForward;
	static ErrorId NotFastForward2;
	static ErrorId NotAGraphDepot;
	static ErrorId UnknownRepo;
	static ErrorId IllegalRefChar;
	static ErrorId IllegalRefSubstr;
	static ErrorId UnqualifiedRef;
	static ErrorId InvalidParentChar;
	static ErrorId NoSuchParent;
	static ErrorId RefTargetMissing;
	static ErrorId InvalidReference;
	static ErrorId InvalidRepoRef;
	static ErrorId InvalidRepo;
	static ErrorId IndexFileMissing;
	static ErrorId PackObjectCount;
	static ErrorId PackObjectMissing;
	static ErrorId PackFileMissing;
	static ErrorId PackObjectLength;
	static ErrorId InvalidRepoName;
	static ErrorId InvalidDepotName;
	static ErrorId NotASha256;
	static ErrorId LFSShaMismatch;
	static ErrorId LFSAlreadyPresent;
	static ErrorId LFSLockIdNotFound;
	static ErrorId LFSLockPathNotFound;
	static ErrorId LFSLockNotOwner;
	static ErrorId LFSLockNoLock;
	static ErrorId NotLFSFile;
	static ErrorId FileNotInRepo;
	static ErrorId AtomicPushFailed;
	static ErrorId TriggerErrorMessage;
	static ErrorId UseRepo;
	static ErrorId UseRepoo;
	static ErrorId UseRepoi;
	static ErrorId UseRepod;
	static ErrorId UseRepoc;
	static ErrorId UseRepos;
	static ErrorId ReposData;
	static ErrorId RepoSave;
	static ErrorId RepoNoChange;
	static ErrorId RepoDelete;
	static ErrorId NoSuchRepo;
	static ErrorId BadRepoName;
	static ErrorId NotInGraphDepot;
	static ErrorId CantAutocreateRepo;
	static ErrorId OutOfRepoLicenses;
	static ErrorId MustForceFork;
	static ErrorId ShowPermission;
	static ErrorId DepotHasRepos;
	static ErrorId EmptyRepo;
	static ErrorId AmbiguousRefUpdate;
	static ErrorId CantCreateRepo;
	static ErrorId CantWriteAllRepo;
	static ErrorId CantDeleteRepo;
	static ErrorId CantPruneRepo;
	static ErrorId CantChangeView;
	static ErrorId NoPermissionOnRef;
	static ErrorId RepoAccessDenied;
	static ErrorId NoMatchPermissions;
	static ErrorId NoLFSPushPerm;
	static ErrorId NoLFSFetchPerm;
	static ErrorId PubKeyData;
	static ErrorId BadPublicKey;
	static ErrorId PubKeyTooLong;
	static ErrorId PubKeyDuplicate;
	static ErrorId PubKeyUpdateAction;
	static ErrorId PubKeyDeleteAction;
	static ErrorId PubKeyNotExist;
	static ErrorId PubKeyNeedsForce;
	static ErrorId PubKeySKeyOpt1;
	static ErrorId PubKeySKeyOpt2;
	static ErrorId BlobVerified;
	static ErrorId BlobDamaged;
	static ErrorId LFSBlobVerified;
	static ErrorId LFSBlobDamaged;
	static ErrorId ArchiveImported;
	static ErrorId ReferenceAdded;
	static ErrorId ReferenceUpdated;
	static ErrorId ReferenceDeleted;
	static ErrorId ReferenceForced;
	static ErrorId ObjectStatistics;
	static ErrorId ForkTargetNotEmpty;
	static ErrorId ForkTargetIsSource;
	static ErrorId DanglingObject;
	static ErrorId NoRepoSelected;
	static ErrorId RefAlreadyExists;
	static ErrorId RefDoesntExist;
	static ErrorId RefValidation;
	static ErrorId SpecifyForce;
	static ErrorId OpenSuccess;
	static ErrorId NoMultiRepoSubmit;
	static ErrorId NoReposForSubmit;
	static ErrorId SubmitComplete;
	static ErrorId SingleRepoOnly;
	static ErrorId DiffData;
	static ErrorId NotAtHead;
	static ErrorId RepoNotHad;
	static ErrorId SyncAdd;
	static ErrorId SyncDelete;
	static ErrorId SyncUpdate;
	static ErrorId SyncIntegUpdate;
	static ErrorId SyncIntegDelete;
	static ErrorId SyncUptodate;
	static ErrorId SyncRefresh;
	static ErrorId RefAlreadySet;
	static ErrorId NoSuchTag;
	static ErrorId TagSaved;
	static ErrorId TagDeleted;
	static ErrorId NotSyncd;
	static ErrorId BranchCreated;
	static ErrorId BranchDeleted;
	static ErrorId BranchAlreadyExists;
	static ErrorId DefaultBranchReset;
	static ErrorId FilesData;
	static ErrorId ResolvedData;
	static ErrorId DescribeFile;
	static ErrorId DirsData;
	static ErrorId DetachedHead;
	static ErrorId SyncNotSameBranch;
	static ErrorId SyncNotFastForward;
	static ErrorId SyncUnknownBranch;
	static ErrorId CommitSummary;
	static ErrorId NoMergeOpenFiles;
	static ErrorId FastForwardMerge;
	static ErrorId MergePreview;
	static ErrorId BranchNotFound;
	static ErrorId ManyReposUseAll;
	static ErrorId MergeComplete;
	static ErrorId UndoComplete;
	static ErrorId CherryPickComplete;
	static ErrorId NoChangeFixes;
	static ErrorId UnsupportedFileType;
	static ErrorId ChangeViewBranch;
	static ErrorId ChangeViewFuture;
	static ErrorId SubmoduleOpen;
	static ErrorId UnknownRefType;
	static ErrorId CommitFileLog;
	static ErrorId CantUpgradePackDir;
	static ErrorId NoMatchingRepos;
	static ErrorId InvalidRevSpec;
	static ErrorId CorruptedTree;
	static ErrorId NoAdvancedMappings;
	static ErrorId CantAddToRepo;
	static ErrorId CantUpdateMirror;
	static ErrorId CantSubmitMirror;
	static ErrorId AutoLabelsOnly;
	static ErrorId LabelViewMustLimit;
	static ErrorId LabelViewMustNotLimit;
	static ErrorId RepoNotMirrored;
	static ErrorId RepoIsMirrored;
	static ErrorId GraphNotCompat;
	static ErrorId UseGraphPackInfo;
	static ErrorId InvalidDefaultBranch;
	static ErrorId LsTree;
	static ErrorId LsTreeNameOnly;
	static ErrorId MergeConflict;
	static ErrorId MergeConflictSubMod;
	static ErrorId MergeNotText;
	static ErrorId MergeSkippedResolve;
	static ErrorId CantSubmitEmpty;
	static ErrorId LFSDisabled;
	static ErrorId LFSLock;
	static ErrorId LFSLockDelete;
	static ErrorId UseUpdateRef;
	static ErrorId RepoIndexAlready;
	static ErrorId RepoIndexNone;
	static ErrorId RepoIndexSuccess;
	static ErrorId NoRepoEdgeSubmit;
	static ErrorId MirrorMissingFile;
	static ErrorId NoWriteForRef;
	static ErrorId RepoSwitchChanged;
	static ErrorId RepoAlreadyOnBranch;
	static ErrorId RepoSwitchMissing;
	static ErrorId BlobNotFoundRepo;
	static ErrorId FilelogMessage; 
	static ErrorId MergeOfMessage; 
	static ErrorId DescribeDiff;
	static ErrorId HeadChanged;
	static ErrorId SubmitCompleteWithRepo;
	static ErrorId LbrPackCacheRequiresServerLocks;
	static ErrorId Rebased;
	static ErrorId RebasedNoop;
	static ErrorId CherryPicked;
	static ErrorId CherryPickedNoop;
	static ErrorId RefUpdated;
	static ErrorId BadMergeMode;
	static ErrorId BadSource;
	static ErrorId BadTarget;
	static ErrorId BadAtRev;
	static ErrorId NoMergeRequired;
	static ErrorId EditedWasDelete;
	static ErrorId AlreadyDeleted;
	static ErrorId FileSpecific;
	static ErrorId FileSpecificData;
	static ErrorId OpenMustResolve;
	static ErrorId SyncResolve;
	static ErrorId RebaseDefaultBranchForce;

	static ErrorId NoPermOnRefRepo;
	static ErrorId NoSuchRepoGrantPerm ;
	static ErrorId NoSuchUserGrantPerm ;
	static ErrorId NoSuchGroupGrantPerm ;
	static ErrorId IdWildPerm;
	static ErrorId ReferenceHaveComb;

	static ErrorId DescribeHeader;
	static ErrorId CommitFileShort;
	static ErrorId SHANotFound;
	static ErrorId RepoHasCommit;
	static ErrorId RepoHasOpened;
	static ErrorId BranchNotMerged;
	static ErrorId DefBranchForceDel;
	static ErrorId Resolve3WayText;
	static ErrorId Resolve2WayRaw;
	static ErrorId SubmitBadState;
	static ErrorId SubmitBadStateFiles;
	static ErrorId MergeOutOfView;
	static ErrorId HaveSpecificNoRev;
	static ErrorId NotOnReplica;
	static ErrorId CommitFileLogOneline;
	static ErrorId CommitFileLogOnelineTree;
	static ErrorId WarnNoWriteAccess;
	static ErrorId BadParentNumber;
	static ErrorId RefTagUpdateNoForce;
	static ErrorId UseGraphPurgeRefhist;
	static ErrorId UnexpectedObjectType;
	static ErrorId DeletedRecords;
	static ErrorId WldDeleteRecords;
	static ErrorId UseGraphGc;
	static ErrorId ObjectSha;
	static ErrorId UseGraphRecomputeRefcnts;
	static ErrorId WldCorrectObjRefcnt;
	static ErrorId CorrectedObjRefcnt;
	static ErrorId RefcntInProgress;
	static ErrorId NoOrphanedObj;
	static ErrorId ObjectRecNotFound;
	static ErrorId RefCntAdjustNotFound;

	// Retired ErrorIds. We need to keep these so that clients
	// built with newer apis can commnunicate with older servers
	// still sending these.

	static ErrorId AmbiguousRepoName;
} ;
