<?php

namespace Projects\Validator;

use Laminas\Validator\AbstractValidator;

/**
 * Check that a job view is valid
 */
class JobView extends AbstractValidator
{
    const INVALID = 'invalid';

    protected $messageTemplates = [
        self::INVALID => "Project job filter only supports field=value[|value] conditions and the '*' wildcard.",
    ];

    /**
     * Validate that a JobView for a project comprises field=value entries
     * @param $value
     * @return bool
     */
    public function isValid($value): bool
    {
        $jobQueryStrings = preg_split('/\s+/', $value);
        foreach ($jobQueryStrings as $queryString) {
            if (!preg_match('/^([^=()|]+)=([^=()|]+)$/', $queryString)) {
                $this->error(self::INVALID);
                return false;
            }
        }
        return true;
    }
}
