<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.2/2785633
 */

namespace Application\Permissions;

use Application\Checker;

/**
 * Interface IPermissions. Define behaviour for Permissions
 * @package Application\Permissions
 */
interface IPermissions
{
    const PERMISSIONS   = 'permissions';
    const AUTHENTICATED = 'authenticated';
    const ADMIN         = 'admin';
    const MEMBER        = 'member';
    const OWNER         = 'owner';
    const IS_IMMUTABLE  = 'isImmutable';
    const SUPER         = 'super';
    const WRITE         = 'write';
    const OPEN          = 'open';
    const READ          = 'read';
    const LIST          = 'list';
    const PERM_MAX      = 'permMax';
    // Convenient checker names
    const AUTHENTICATED_CHECKER = [Checker::NAME => self::AUTHENTICATED];
    const ADMIN_CHECKER         = [Checker::NAME => self::ADMIN];
    const MEMBER_CHECKER        = [Checker::NAME => self::MEMBER];
    const OWNER_CHECKER         = [Checker::NAME => self::OWNER];
}
