<?php

namespace Application\Helper;

use Application\View\Helper\AbstractHelper;
use Laminas\View\Exception;

/**
 * Helper for retrieving the doc path.
 */
class DocPath extends AbstractHelper
{
    /**
     * Doc path
     *
     * @var string
     */
    protected $docPath;

    /**
     * Returns site's doc path.
     *
     * $file is appended to the doc path for simplicity.
     *
     * @throws Exception\RuntimeException
     * @return string
     */
    public function __invoke(): string
    {
        if (null === $this->docPath) {
            throw new Exception\RuntimeException('No Doc path provided');
        }
        return $this->docPath ;
    }

    /**
     * Set the doc path.
     *
     * @param string $docPath
     * @return self
     */
    public function setDocPath(string $docPath): DocPath
    {
        $this->docPath = substr($docPath, -1) === '/' ? $docPath : $docPath . '/';
        return $this;
    }
}
