<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.2/2785633
 */

namespace AiAnalysis\Filter;

use Application\Factory\InvokableService;

/**
 * Interface IDiff. Fields related to Diffs on a file
 * @package Reviews\Filter
 */
interface IAiAnalysis extends InvokableService
{
    // Name of service
    const NAME                    = 'aiAnalysisFilter';
    const DISCARD_ANALYSIS_FILTER = 'discardAnalysisFilter';

    // Param names
    const FILE_ID      = 'fileId';
    const REVIEW_ID    = 'reviewId';
    const TO_VERSION   = 'toVersion';
    const FROM_VERSION = 'fromVersion';
    const DIFF_CONTENT = 'diffContent';
    const FILE_NAME    = 'fileName';
    const DIFF_START   = 'diffStart';
    const DIFF_END     = 'diffEnd';
    const DIGEST       = 'digest';
    const LEFT_LINE    = 'leftLine';
    const ID           = 'id';
}
