<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.2/2785633
 */

namespace AiAnalysis\Factory;

use AiAnalysis\Service\AiServiceInterface;
use Interop\Container\ContainerInterface;
use Laminas\ServiceManager\Factory\FactoryInterface;

class AiServiceFactory implements FactoryInterface
{
    const OPENAIADAPTER     = 'openAI';
    const GENERICAIADAPTER  = 'genericAI';
    const LMSTUDIOAIADAPTER = 'lmStudioAI';
    /**
     * Test create the service object
     *
     * @param ContainerInterface $container
     * @param string $requestedName
     * @param array|null $options
     * @return mixed|object
     */
    public function __invoke(
        ContainerInterface|\Psr\Container\ContainerInterface $container,
        $requestedName,
        array $options = null
    ): AiServiceInterface {
        return (null === $options) ? new $requestedName($container) : new $requestedName($container, $options);
    }
}
