"use strict";

var branchmap = [
  '//depot/main/... //depot/rel1/...',
  '//depot/v70.2/patty/... //depot/v71.0/patty/...',
  '//depot/main/tools/build/bin/... //depot/rel1/tools/build/bin/...',
  '//depot/main/tools/build/bin/pattyscripts/... //depot/rel1/pattyscripts/...'
];

var clientmap = [
  '//depot/...  //client/depot/...',
  '//depot/v70.2/patty/... //client/patty/...',
  '//depot/main/tools/... //client/buildtools/...',
  '//depot/main/tools/build/bin/pattyscripts/... //client/pattyscripts/...'
];

var resultmap = [];

async function showResult(maplabel) {
  try {
    var mapTable = document.getElementById("listMap");

    while (mapTable.hasChildNodes()) {
      mapTable.removeChild(mapTable.firstChild);
    }

    var index = 0;
    resultmap.forEach(line => {
      var row = mapTable.insertRow(index++);
      var cell = row.insertCell(0);
      var textNode = document.createTextNode(line);
      cell.appendChild(textNode);
    });

    var mpcount = await p4vjs.mapCount(resultmap);
    document.getElementById('mapcount').innerHTML = 'number of lines in ' + maplabel + ': ' + mpcount;

  }
  catch (e) {
    alert(e);
  }
}

async function branchMap() {
  resultmap = branchmap;
  showResult('Branch Map');
}

async function clientMap() {
  resultmap = clientmap;
  showResult('Client Map');
}

async function joinMap() {
  p4vjs.mapJoin(branchmap, clientmap).then(function(result) {
    resultmap = result;
    showResult('Joined Map');
  });
}