"use strict";
async function runOnload() {
  var files;
  var p4query;

  let version = (await p4vjs.getApiVersion()).split('.').map(Number);
  let isNewVersion = version[0] >= 3 && version[1] >= 2;

  files = p4vjs.selectedFiles();
  if (files.length) {
    if (isNewVersion) {
      p4query = ["fstat", "-Orlf"].concat(files);
    }
    else {
      var quotedfiles = "";
      files.forEach((file) => {
        quotedfiles += '\"' + file + '\" ';
      });
      p4query = "fstat -Orlf " + quotedfiles;
    }
    loadQueryResult();
  }

  function loadQueryResult() {
    p4vjs.p4(p4query).then(function(result) {
      var queryResultContainer = result.data;
      var nrOfRows = queryResultContainer.length;

      // Define the attributes we are interested in.
      var col = ["clientFile", "depotFile", "fileSize", "type", "headRevision", "headChange", "headAction"];

      if (nrOfRows > 0) {
        // Create dynamic table.
        var table = document.createElement("table");
        // Create table head 
        var tHead = document.createElement("thead");


        // Create row for table head
        var hRow = document.createElement("tr");

        // Add column header to row of table head
        for (var i = 0; i < col.length; i++) {
          var th = document.createElement("th");
          th.innerHTML = col[i];
          hRow.appendChild(th);
        }
        tHead.appendChild(hRow);
        table.appendChild(tHead);

        // Create table body 
        var tBody = document.createElement("tbody");

        // Populate each cell in the table.
        for (var i = 0; i < nrOfRows; i++) {
          // only display objects that have a depotFile defined
          if (queryResultContainer[i]["depotFile"] != undefined) {
            var bRow = document.createElement("tr"); // Create row for each job 


            for (var j = 0; j < col.length; j++) {
              var td = document.createElement("td");
              var colindex = col[j];
              td.innerHTML = queryResultContainer[i][col[j]];
              bRow.appendChild(td);
            }
            tBody.appendChild(bRow)
          }
        }
        table.appendChild(tBody);

        // Finally add the newly created table with json data to a container
        var divContainer = document.getElementById("queryResultContainer");
        divContainer.innerHTML = "";
        divContainer.appendChild(table);
      }
    });
  }
}