<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.2/2785633
 */
namespace Users\Service;

use Laminas\EventManager\Event;

/**
 * @package Users\Service
 */
interface ICleanUpDeletedUsers
{
    const SERVICE = 'cleanUpDeletedUsers';

    /**
     * Handle clean up of deleted users data
     */
    public function handleCleanUpOfDeletedUsersData(string $id);
    public function cleanUpFollowersForDeletedUsers(Event $event);
    public function cleanUpWorkflowForDeletedUsers(Event $event);
    public function cleanUpTestDefinitionsForDeletedUsers(Event $event);
    public function cleanUpGroupsForDeletedUsers(Event $event);
    public function cleanUpProjectsForDeletedUsers(Event $event);
    public function cleanUpConfigForDeletedUsers(string $id);
}
