<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.2/2785633
 */

namespace Projects\Validator;

use Application\Validator\AbstractValidator;
use Projects\Model\Project as ProjectModel;

/**
 * Validator for 'members' field on projects
 */
class Members extends AbstractValidator
{
    const INVALID_MEMBERS       = "members";
    protected $messageTemplates = [];

    /**
     * MembersValidator constructor.
     * @param null $options
     */
    public function __construct($options = null)
    {
        $this->messageTemplates = [
            self::INVALID_MEMBERS => $this->tGen('Project must have at least one member or subgroup.')
        ];
        parent::__construct($options);
    }

    /**
     * Tests the validity of the field. Members are valid if they are supplied or if they are not
     * supplied, and we have Subgroups instead.
     * @param mixed $value value of members
     * @param array|null $context other fields
     * @return bool
     */
    public function isValid($value, array $context = null) : bool
    {
        if (empty($value)
            && (!isset($context[ProjectModel::FIELD_SUBGROUPS]) || empty($context[ProjectModel::FIELD_SUBGROUPS]))) {
            $this->error(self::INVALID_MEMBERS);
            return false;
        }
        return true;
    }
}
