<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.2/2785633
 */
namespace Projects\Filter;

use Laminas\Filter\AbstractFilter;
use Workflow\Model\IWorkflow;

/**
 * Filter for project and branch workflow
 */
class Workflow extends AbstractFilter
{
    /**
     * Filter the workflow
     * @param $value
     * @return mixed|null if the value is set and equals IWorkflow::NO_WORKFLOW_ID return null, otherwise just return
     * the value
     */
    public function filter($value)
    {
        return $value === IWorkflow::NO_WORKFLOW_ID ? null : $value;
    }
}
