<?php

namespace Jira\View\Helper;

use Application\Config\ConfigManager;
use Application\View\Helper\AbstractHelper;
use Jira\Module;

class Jira extends AbstractHelper
{
    const JIRA_BASE_URL        = 'baseUrl';
    const JIRA_PROJECT_ID_LIST = 'projects';

    /**
     * Provides an array of Jira related data in the format
     * [
     *  'baseUrl' => "...",
     *  'projects' => ["...","...",...]
     * ]
     * @return array|null
     * @throws \Application\Config\ConfigException
     */
    public function __invoke()
    {
        $config   = $this->services->get(ConfigManager::CONFIG);
        $jiraHost = ConfigManager::getValue($config, ConfigManager::JIRA_HOST);
        return $jiraHost ? [self::JIRA_BASE_URL=>$jiraHost,self::JIRA_PROJECT_ID_LIST=>Module::getProjects()] : null;
    }
}
