<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.2/2785633
 */
use Api\Controller\IndexController as ApiController;
use Application\Config\IDao;
use Attachments\Controller\AttachmentApi;
use Attachments\Model\AttachmentDAO;
use Laminas\Http\Request;
use Laminas\Router\Http\Method;
use Laminas\Router\Http\Segment;
use Api\IRequest;
use Attachments\Controller\IndexController;
use Application\Controller\IndexControllerFactory;

use Application\Factory\InvokableServiceFactory;
use Attachments\Filter\GetList;
use Attachments\Filter\IGetList;
use Attachments\Filter\IFile;
use Attachments\Filter\File;

return [
    'attachments' => [
        'max_file_size' => null, // in bytes; will default to php upload_max_size if blank
    ],
    'router' => [
        'routes' => [
            'attachments' => [
                'type' => Segment::class,
                'options' => [
                    'route'    => '/attachment[s]/:attachment[/][:filename]',
                    'defaults' => [
                        'controller' => IndexController::class,
                        'action'     => 'index',
                    ],
                ],
            ],
            'add-attachment' => [
                'type' => Segment::class,
                'options' => [
                    'route'    => '/attachments/add[/]',
                    'defaults' => [
                        'controller' => IndexController::class,
                        'action'     => 'add',
                    ],
                ],
            ],
            'api' => [
                'type' => 'literal',
                'options' => [
                    'route' => ApiController::API_BASE,
                ],
                'may_terminate' => false,
                'child_routes' => [
                    'attachments' => [
                        'type' => Segment::class,
                        'may_terminate' => false,
                        'options' => [
                            'route' => '/:version/attachments',
                            'constraints' => [IRequest::VERSION => 'v1[0-1]'],
                            'defaults' => [
                                'controller' => AttachmentApi::class,
                            ],
                        ],
                        'child_routes' => [
                            'list' => [
                                'type' => Method::class,
                                'options' => [
                                    'verb' => Request::METHOD_GET,
                                ],
                            ],
                            'create' => [
                                'type' => Method::class,
                                'options' => [
                                    'verb' => Request::METHOD_POST,
                                ],
                            ],
                            'attachment-id' => [
                                'type' => Segment::class,
                                'may_terminate' => false,
                                'options' => [
                                    'route' => '/:id'
                                ],
                                'child_routes' => [
                                    'content-file' => [
                                        'type' => Segment::class,
                                        'options' => [
                                            'route' => '/content/:file[/]'
                                        ],
                                        'child_routes' => [
                                            'open' => [
                                                'type' => Method::class,
                                                'options' => [
                                                    'verb' => Request::METHOD_GET,
                                                    'defaults' => [
                                                        'action' => 'openContent'
                                                    ],
                                                ],
                                            ],
                                            'download' => [
                                                'type' => Segment::class,
                                                'options' => [
                                                    'route' => 'download[/]'
                                                ],
                                                'child_routes' => [
                                                    'get-download' => [
                                                        'type' => Method::class,
                                                        'options' => [
                                                            'verb' => Request::METHOD_GET,
                                                            'defaults' => [
                                                                'action' => 'downloadContent'
                                                            ],
                                                        ],
                                                    ]
                                                ]
                                            ],
                                            'thumb' => [
                                                'type' => Segment::class,
                                                'options' => [
                                                    'route' => 'thumb[/]'
                                                ],
                                                'child_routes' => [
                                                    'get-thumb' => [
                                                        'type' => Method::class,
                                                        'options' => [
                                                            'verb' => Request::METHOD_GET,
                                                            'defaults' => [
                                                                'action' => 'thumb'
                                                            ],
                                                        ],
                                                    ]
                                                ]
                                            ]
                                        ],
                                    ],
                                ]
                            ]
                        ]
                    ],
                ]
            ],
        ],
    ],
    'controllers' => [
        'factories' => [
            IndexController::class => IndexControllerFactory::class,
            AttachmentApi::class => IndexControllerFactory::class,
        ],
    ],
    'service_manager' => [
        'aliases' => [
            IGetList::FILTER => GetList::class,
            IFile::FILTER => File::class,
            IDao::ATTACHMENT_DAO => AttachmentDAO::class
        ],
        'factories' => array_fill_keys(
            [
                GetList::class,
                AttachmentDAO::class,
                File::class
            ],
            InvokableServiceFactory::class
        )
    ]
];
