<?php

namespace Reviews\Model;

/**
 * Model to provide allowed and blocked transitions
 */
class Transitions implements ITransitions
{
    private $allowedTransitions;
    private $blocked;

    /**
     * Create the transitions model with allowed and blocked transitions
     * @param array $allowedTransitions
     * @param array $blocked
     */
    public function __construct(array $allowedTransitions, array $blocked)
    {
        $this->allowedTransitions = $allowedTransitions;
        $this->blocked            = $blocked;
    }

    /**
     * @inheritDoc
     */
    public function getAllowed() : array
    {
        return $this->allowedTransitions;
    }

    /**
     * @inheritDoc
     */
    public function getBlocked(): array
    {
        return $this->blocked;
    }
}
