/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class CustomLabel
extends JLabel
implements Scrollable {
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    private static Rectangle viewRect = new Rectangle();
    private static Insets insets = new Insets(0, 0, 0, 0);
    private boolean underlined = false;
    private boolean autoTooltip = false;

    public CustomLabel() {
    }

    public CustomLabel(String text) {
        super(text);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getWidth() / 10;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    public void setUnderlined(boolean underlined) {
        this.underlined = underlined;
        this.repaint();
    }

    public boolean getAutoTooltip() {
        return this.autoTooltip;
    }

    public void setAutoTooltip(boolean autoTooltip) {
        this.autoTooltip = autoTooltip;
        this.setToolTipText(this.getText());
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        if (this.autoTooltip) {
            this.setToolTipText(text);
        }
    }

    public void setText(short number) {
        this.setText(String.valueOf(number));
    }

    public void setText(int number) {
        this.setText(String.valueOf(number));
    }

    public void setText(double number) {
        this.setText(String.valueOf(number));
    }

    public void setText(float number) {
        this.setText(String.valueOf(number));
    }

    public void setText(long number) {
        this.setText(String.valueOf(number));
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.underlined) {
            this.getInsets(insets);
            textRect.setFrame(0.0, 0.0, 0.0, 0.0);
            iconRect.setFrame(0.0, 0.0, 0.0, 0.0);
            viewRect.setFrame(CustomLabel.insets.left, CustomLabel.insets.top, this.getWidth() - (CustomLabel.insets.right + CustomLabel.insets.left), this.getHeight() - (CustomLabel.insets.bottom + CustomLabel.insets.top));
            FontMetrics fm = g.getFontMetrics();
            SwingUtilities.layoutCompoundLabel(this, fm, this.getText(), this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), viewRect, iconRect, textRect, this.getText() == null ? 0 : this.getIconTextGap());
            Integer textShiftOffset = (Integer)UIManager.get("Button.textShiftOffset");
            int textShiftOffsetValue = textShiftOffset != null ? textShiftOffset : 0;
            g.fillRect(CustomLabel.textRect.x, CustomLabel.textRect.y + fm.getAscent() + textShiftOffsetValue + 1, CustomLabel.textRect.width, 1);
        }
    }
}

