/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.api.actions.Action;
import com.install4j.api.beans.Bean;
import com.install4j.runtime.beans.actions.FailureStrategy;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.util.StringUtil;
import org.w3c.dom.Element;

public class ActionBeanConfig
extends AbstractBeanConfig {
    private Action instance;
    private boolean multiExec = false;
    private FailureStrategy failureStrategy = FailureStrategy.CONTINUE;
    private boolean failureAskRetry = true;
    private boolean failureAskQuit = true;
    private boolean failureAskIgnore = true;
    private String errorMessage = "";
    private boolean elevate;
    private boolean executed = false;
    private boolean rolledBack = false;
    private boolean initialized = false;
    private int rollbackId = -1;

    public Action getOrInstantiateAction(boolean suppressErrors) {
        if (this.instance == null) {
            this.instance = (Action)this.instantiateBean(suppressErrors);
        }
        return this.instance;
    }

    public void setRollbackId(int rollbackId) {
        this.rollbackId = rollbackId;
    }

    public int getRollbackId() {
        return this.rollbackId;
    }

    public boolean isRolledBack() {
        return this.rolledBack;
    }

    public void setRolledBack(boolean rolledBack) {
        this.rolledBack = rolledBack;
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public void setExecuted(boolean executed) {
        this.executed = executed;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean isMultiExec() {
        return this.multiExec;
    }

    public FailureStrategy getFailureStrategy() {
        return this.failureStrategy;
    }

    public boolean isFailureAskRetry() {
        return this.failureAskRetry;
    }

    public boolean isFailureAskQuit() {
        return this.failureAskQuit;
    }

    public boolean isFailureAskIgnore() {
        return this.failureAskIgnore;
    }

    public boolean isElevate() {
        return this.elevate;
    }

    public ExecutionContext getExecutionContext() {
        return this.isElevate() ? ExecutionContext.MAXIMUM : ExecutionContext.UNELEVATED;
    }

    public String getErrorMessage() {
        return InstallerVariables.replaceVariables(this.errorMessage);
    }

    @Override
    public boolean isInstantiated() {
        return this.instance != null;
    }

    @Override
    protected void clearInstance() {
        this.instance = null;
    }

    @Override
    protected void setBean(Bean bean) {
        this.instance = (Action)bean;
    }

    public void setInstance(Action action) {
        this.instance = action;
    }

    @Override
    protected void read(Element element) {
        super.read(element);
        this.multiExec = ActionBeanConfig.readAttribute(element, "multiExec", this.multiExec);
        this.failureStrategy = this.readAttribute(element, "cancelOnFail", this.failureStrategy);
        this.failureAskRetry = ActionBeanConfig.readAttribute(element, "failureAskRetry", this.failureAskRetry);
        this.failureAskQuit = ActionBeanConfig.readAttribute(element, "failureAskQuit", this.failureAskQuit);
        this.failureAskIgnore = ActionBeanConfig.readAttribute(element, "failureAskIgnore", this.failureAskIgnore);
        this.errorMessage = ActionBeanConfig.readAttribute(element, "errorMessage", this.errorMessage);
        this.errorMessage = StringUtil.replace(this.errorMessage, "\\n", "\n");
        this.errorMessage = StringUtil.replace(this.errorMessage, "\\t", "\t");
        this.elevate = ActionBeanConfig.readAttribute(element, "elevate", this.elevate);
    }
}

