<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.5/2869592
 */
namespace Notifications\Model;

interface INotification
{
    const FIELD_THREAD_IDS = "threadIds";

    const REVIEW_TOPIC = "review-";
    const CHANGE_TOPIC = "change-";

    /**
     * Get the thread ids which are to be used
     *
     * @return  array|null     the thread ids.
     */
    public function getThreadIds(): ?array;

    /**
     * Set thread ids.
     *
     * @param   array|null     threadIds   The Thread ids used.
     */
    public function setThreadIds($threadIds);
}
