<?php

namespace Jobs\Controller;

use Api\Controller\AbstractRestfulController;
use Jobs\Filter\IGetJobs;
use Laminas\View\Model\JsonModel;

class JobApi extends AbstractRestfulController
{
    use JobTrait;
    const DATA_JOBS = 'jobs';

    /**
     * @return JsonModel
     * @see JobTrait::getJobsByFilter()
     */
    public function getList() : JsonModel
    {
        $query = $this->getRequest()->getQuery();
        return $this->getJobsByFilter($query->toArray()[IGetJobs::FILTER_PARAMETER] ?? null);
    }
}
