<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.5/2869592
 */

use Api\Controller\IndexController as ApiController;
use Api\IRequest;
use Application\Config\Services;
use Application\Controller\IndexControllerFactory;
use Application\Factory\InvokableServiceFactory;
use Authentication\Helper\ILoginHelper;
use Authentication\Helper\ILogoutHelper;
use Authentication\Service\Auth;
use Authentication\Service\BasicLoginAdapter;
use Authentication\Service\Saml;
use Authentication\Service\SamlLoginAdapter;
use Authentication\Service\SsoLoginAdapter;
use Laminas\Http\Request;
use Laminas\Router\Http\Method;
use Laminas\Router\Http\Segment;
use Authentication\Controller\AuthenticationApi;
use Authentication\Factory\LoginServiceFactory;
use Authentication\Helper\LoginHelper;
use Authentication\Helper\LogoutHelper;

return [
    'router' => [
        'routes' => [
            'api' => [
                'type' => 'literal',
                'options' => [
                    'route' => ApiController::API_BASE,
                ],
                'may_terminate' => false,
                'child_routes' => [
                    'authenticationApi' => [
                        'type' => Segment::class,
                        'options' => [
                            'route' => '/:version/session[/]',
                            'constraints' => [IRequest::VERSION => 'v1([0-1])'],
                            'defaults' => [
                                'controller' => AuthenticationApi::class,
                            ]
                        ],
                        'child_routes' => [
                            'login' => [
                                'type' => Method::class,
                                'options' => [
                                    'verb' => Request::METHOD_POST,
                                    'defaults' => [
                                        'action' => 'login',
                                    ],
                                ],
                            ],
                            'logout' => [
                                'type' => Method::class,
                                'options' => [
                                    'verb' => Request::METHOD_DELETE,
                                    'defaults' => [
                                        'action' => 'logout',
                                    ],
                                ],
                            ],
                            'auth-detail' => [
                                'type' => Method::class,
                                'options' => [
                                    'verb' => Request::METHOD_GET,
                                    'defaults' => [
                                        'action' => 'getAuthenticationDetails',
                                    ],
                                ],
                            ],
                        ],
                    ],
                    // Need to remove or explicitly set this api as response for saml in saml_idp.conf.cjs
                    // as https://domain/api/v11/loginResponse if we want get rid off
                    // https://domain/api/v10/session
                    'loginResponseApi' => [
                        'type' => Segment::class,
                        'options' => [
                            'route' => '/:version/loginResponse[/]',
                            'constraints' => [IRequest::VERSION => 'v1([0-1])'],
                            'defaults' => [
                                'controller' => AuthenticationApi::class,
                            ]
                        ],
                        'child_routes' => [
                            'loginResponse' => [
                                'type' => Method::class,
                                'options' => [
                                    'verb' => Request::METHOD_POST,
                                    'defaults' => [
                                        'action' => 'loginResponse',
                                    ],
                                ],
                            ],
                            'authenticationDetails' => [
                                'type' => Method::class,
                                'options' => [
                                    'verb' => Request::METHOD_GET,
                                    'defaults' => [
                                        'action' => 'getAuthenticationDetails',
                                    ],
                                ],
                            ],
                        ],
                    ],
                    'getSsoUrlApi' => [
                        'type' => Segment::class,
                        'options' => [
                            'route' => '/:version/get-sso-auth-url[/]',
                            'constraints' => [IRequest::VERSION => 'v1([0-1])'],
                            'defaults' => [
                                'controller' => AuthenticationApi::class,
                            ]
                        ],
                        'child_routes' => [
                            'getSsoUrl' => [
                                'type' => Method::class,
                                'options' => [
                                    'verb' => Request::METHOD_POST,
                                    'defaults' => [
                                        'action'     => 'getSsoUrl'
                                    ],
                                ],
                            ],
                        ],
                    ],
                    'samlApi' => [
                        'type' => Segment::class,
                        'options' => [
                            'route' => '/:version/saml/login[/]',
                            'constraints' => [IRequest::VERSION => 'v1([0-1])'],
                        ],
                        'child_routes' => [
                            'samlApiLogin' => [
                                'type' => Method::class,
                                'options' => [
                                    'verb' => Request::METHOD_POST,
                                    'defaults' => [
                                        'controller' => AuthenticationApi::class,
                                        'action'     => 'login'
                                    ],
                                ],
                            ],
                        ],
                    ],
                ]
            ],
        ],
    ],
    'controllers' => [
        'factories' => [
            AuthenticationApi::class => IndexControllerFactory::class,
        ],
    ],
    'service_manager' => [
        'aliases' => [
            ILogoutHelper::HELPER_NAME => LogoutHelper::class,
            ILoginHelper::HELPER_NAME => LoginHelper::class,
            LoginServiceFactory::BASICLOGINADAPTER => BasicLoginAdapter::class,
            LoginServiceFactory::SSOLOGINADAPTER => SsoLoginAdapter::class,
            LoginServiceFactory::SAMLLOGINADAPTER => SamlLoginAdapter::class,
            Services::AUTH => Auth::class,
            Services::AUTH_SAML => Saml::class,
        ],
        'factories' => [
            BasicLoginAdapter::class => LoginServiceFactory::class,
            SsoLoginAdapter::class => LoginServiceFactory::class,
            SamlLoginAdapter::class => LoginServiceFactory::class,
            LogoutHelper::class => InvokableServiceFactory::class,
            LoginHelper::class => InvokableServiceFactory::class,
            Auth::class => InvokableServiceFactory::class,
            Saml::class => InvokableServiceFactory::class,
        ],
    ],
    'security' => [
        'login_exempt' => [
            'api/authenticationApi/login',
            'api/authenticationApi/logout',
            'api/authenticationApi/auth-detail',
            'api/loginResponseApi/loginResponse',
            'api/loginResponseApi/authenticationDetails',
            'api/getSsoUrlApi/getSsoUrl',
            'api/AuthApi/session',
        ],
        'prevent_login' => [],         // specify user ids which are not permitted to login to swarm
    ],
];
