<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.5/2869592
 */

namespace AiAnalysis;

use Application\Checker;
use Application\Config\ConfigManager;
use Application\Config\IConfigDefinition;
use Application\Permissions\Exception\ForbiddenException;
use Application\Config\ConfigException;

/**
 * Class AiAnalysisChecker. Checks for AI config option set or not.
 * @package AiAnalysis
 */
class AiAnalysisChecker extends Checker
{
    const AI_FEATURE_IS_NOT_ENABLED = 'AI feature is not enabled';

    /**
     * Performs a check to see that AI feature is enabled in configuration.
     * @param string            $check      the name of the check
     * @param array|null        $options    optional data to assist the check
     * @throws ForbiddenException if AI feature is not enabled in configuration
     * @throws ConfigException
     */
    public function check(string $check, array $options = null)
    {
        // Check if AI feature is enabled in configuration
        $AiEnabled = ConfigManager::getValue(
            $this->services->get(IConfigDefinition::CONFIG),
            IConfigDefinition::AI_REVIEW_ENABLED,
            false
        );
        if (!$AiEnabled) {
            throw new ForbiddenException(self::AI_FEATURE_IS_NOT_ENABLED);
        }
    }
}
