<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.5/2869592
 */
namespace Users;

use Application\Config\Services;
use Laminas\ServiceManager\ServiceManager;

/**
 * Trait UsersTrait. Useful functions for dealing with a review
 * @package Users
 */
trait UsersTrait
{
    /**
     * Check if the current user has permission, if not an exception will be thrown
     * @param ServiceManager|null $services
     */
    public function checkCurrentUserPermission(ServiceManager $services = null): void
    {
        $checker = $services->get(Services::PERMISSIONS);
        $checker->getMaxAccessOfCurrentLoggedInUser();
    }
}
