<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.5/2869592
 */
namespace Projects\Filter;

use Laminas\Filter\AbstractFilter;
use Projects\Model\IProject;

/**
 * Filter for project or branch defaults
 */
class Defaults extends AbstractFilter
{
    /**
     * Filter defaults
     * @param mixed $value defaults value
     * @return array
     */
    public function filter($value): array
    {
        $value = empty($value) ? [] : $value;

        // normalize the posted default details to only contain our expected keys
        $defaults = [
            IProject::REVIEWERS => []
        ];
        foreach (array_keys($defaults) as $name) {
            if (isset($value[$name])) {
                if ($name === IProject::REVIEWERS && !empty($value[$name])) {
                    // If default reviewers have been passed as strings e.g. ['super']
                    // convert to ['super' => array()], otherwise use the value given
                    foreach ($value[$name] as $defaultKey => $defaultValue) {
                        if (is_array($defaultValue)) {
                            $defaults[$name][$defaultKey] = $defaultValue;
                        } else {
                            $defaults[$name][$defaultValue] = [];
                        }
                    }
                }
            }
        }
        return $defaults;
    }
}
