<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.5/2869592
 */
namespace Attachments\Filter;

use Application\InputFilter\DirectInput;
use Application\Validator\IdsValidator;
use Interop\Container\ContainerInterface;
use Laminas\InputFilter\InputFilter;

/**
 * Filter class to filter and validate the values that can be used with API calls to get lists of attachments
 */
class GetList extends InputFilter implements IGetList
{
    private $services;

    /**
     * Construct the filter, this should be done via services->get
     * @param ContainerInterface $services
     * @param array|null $options
     */
    public function __construct(ContainerInterface $services, array $options = null)
    {
        $this->services = $services;
        $this->addIdFilter();
    }

    /**
     * Enforce that an ids value must be a string, int, array of strings, or array of int. The field must be provided.
     * @return void
     */
    private function addIdFilter()
    {
        $input = new DirectInput(self::IDS);
        $input->setRequired(true);
        $input->getValidatorChain()->attach(
            new IdsValidator($this->services, self::ATTACHMENTS, [IdsValidator::ALLOW_INT => true])
        );
        $this->add($input);
    }
}
