<?php

namespace Application\Model;

use AiAnalysis\Model\IAiReviewSummary;
use Application\Config\IDao;
use Application\Config\Services;
use Application\Factory\InvokableService;
use Application\I18n\TranslatorFactory;
use Attachments\Model\IAttachmentDAO;
use Changes\Service\IChangeComparator;
use Groups\Service\IGroup;
use Projects\Helper\IFindAffected;
use Slack\Model\ISlackDAO;

/**
 * This is introduced as a convenience to get hold of services in model
 * classes that are not currently managed by a DAO.
 * @package Application\Model
 */
trait ServicesModelTrait
{
    public static $servicesVar = 'SERVICES';

    /**
     * Get the comment DAO.
     * @return IModelDAO the comment DAO
     */
    public static function getCommentDao() : IModelDAO
    {
        return $GLOBALS[self::$servicesVar]->get(IDao::COMMENT_DAO);
    }

    /**
     * Get the attachment DAO.
     * @return IAiReviewSummary the ai analysis DAO
     */
    public static function getAiAnalysisDao() : IAiReviewSummary
    {
        return $GLOBALS[self::$servicesVar]->get(IDao::AI_ANALYSIS_DAO);
    }

    /**
     * Get the attachment DAO.
     * @return IAttachmentDAO the attachment DAO
     */
    public static function getAttachmentDao() : IAttachmentDAO
    {
        return $GLOBALS[self::$servicesVar]->get(IDao::ATTACHMENT_DAO);
    }

    /**
     * Get the slack DAO.
     * @return ISlackDAO the slack DAO
     */
    public static function getSlackDao() : ISlackDAO
    {
        return $GLOBALS[self::$servicesVar]->get(IDao::SLACK_DAO);
    }

    /**
     * Get the user DAO.
     * @return IModelDAO the user DAO
     */
    public static function getUserDao() : IModelDAO
    {
        return $GLOBALS[self::$servicesVar]->get(IDao::USER_DAO);
    }

    /**
     * Get the group DAO.
     * @return IModelDAO the group DAO
     */
    public static function getGroupDao() : IModelDAO
    {
        return $GLOBALS[self::$servicesVar]->get(IDao::GROUP_DAO);
    }

    /**
     * Get the Project DAO.
     * @return IModelDAO the project DAO
     */
    public static function getProjectDao() : IModelDAO
    {
        return $GLOBALS[self::$servicesVar]->get(IDao::PROJECT_DAO);
    }

    /**
     * Get the Change DAO.
     * @return mixed the change DAO
     */
    public static function getChangeDao()
    {
        return $GLOBALS[self::$servicesVar]->get(IDao::CHANGE_DAO);
    }

    /**
     * Get the Change Comparator service.
     * @return IChangeComparator  The change comparator Service
     */
    public static function getChangeComparatorService(): IChangeComparator
    {
        return $GLOBALS[self::$servicesVar]->get(Services::CHANGE_COMPARATOR);
    }

    /**
     * Get the Change service.
     * @return mixed The change Service
     */
    public static function getChangeService()
    {
        return $GLOBALS[self::$servicesVar]->get(Services::CHANGE_SERVICE);
    }

    /**
     * Get the Workflow manager.
     * @return mixed the workflow manager
     */
    public static function getWorkflowManager()
    {
        return $GLOBALS[self::$servicesVar]->get(Services::WORKFLOW_MANAGER);
    }

    /**
     * Get the Workflow DAO.
     * @return IModelDAO the workflow DAO
     */
    public static function getWorkflowDao() : IModelDAO
    {
        return $GLOBALS[self::$servicesVar]->get(IDao::WORKFLOW_DAO);
    }

    /**
     * Get the service for running commands related to 'p4 group'
     * @return InvokableService
     */
    public static function getGroupService() : InvokableService
    {
        return $GLOBALS[self::$servicesVar]->get(IGroup::GROUP_SERVICE);
    }

    /**
     * Get the TestDefinition DAO.
     * @return IModelDAO the TestDefinition DAO
     */
    public static function getTestDefinitionDao() : IModelDAO
    {
        return $GLOBALS[self::$servicesVar]->get(IDao::TEST_DEFINITION_DAO);
    }

    /**
     * Get the services from $GLOBALS
     */
    public static function getServices()
    {
        return $GLOBALS[self::$servicesVar];
    }

    /**
     * Set the services in $GLOBALS
     * @param $services
     */
    public static function setServices($services)
    {
        $GLOBALS[self::$servicesVar] = $services;
    }

    /**
     * Get the service to find affected projects
     * @return IFindAffected
     */
    public static function getAffectedProjectsService(): IFindAffected
    {
        return $GLOBALS[self::$servicesVar]->get(Services::AFFECTED_PROJECTS);
    }

    /**
     * Get the service for translation
     * @return mixed the translator
     */
    public static function getTranslatorService()
    {
        return $GLOBALS[self::$servicesVar]->get(TranslatorFactory::SERVICE);
    }

    /**
     * Get the linkify service
     * @return mixed
     */
    public static function getLinkifyService()
    {
        return $GLOBALS[self::$servicesVar]->get(Services::LINKIFY);
    }
}
