<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.4/2843222
 */
namespace Projects\Filter;

use Application\Factory\InvokableService;
use Interop\Container\ContainerInterface;
use Projects\Validator\Branches;

/**
 * An input filter chain to deal with branch add/update
 */
class BranchesInput extends ProjectFields implements InvokableService
{
    /**
     * @param ContainerInterface $services
     * @param array|null $options
     */
    public function __construct(ContainerInterface $services, array $options = null)
    {
        parent::__construct($services, $options);
        $this->addBranches($options[Branches::EXISTING_BRANCH_IDS]??[]);
    }
}
