/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.Util;
import com.install4j.api.windows.SpecialFolder;
import com.install4j.api.windows.WinFileSystem;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import java.io.File;

public class UserDirs {
    private static boolean i4jChecked = false;
    private static boolean i4jAvailable = false;

    public static synchronized boolean isI4jLibraryAvailable() {
        if (!i4jChecked) {
            i4jChecked = true;
            try {
                FolderInfo.getWindowsDirectory();
                i4jAvailable = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return i4jAvailable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File getUserDir(String macLibrarySubDir, String linuxEnvVar, String linuxDefaultDir) {
        if (Util.isWindows()) {
            if (!UserDirs.isI4jLibraryAvailable()) return new File(System.getProperty("user.home"), "AppData\\Local");
            File dir = WinFileSystem.getSpecialFolder(SpecialFolder.LOCAL_APPDATA, false);
            if (dir == null) return FileUtil.getCanonicalFile(new File(System.getProperty("user.home"), linuxDefaultDir));
            return FileUtil.getCanonicalFile(dir);
        }
        if (Util.isMacOS()) {
            return FileUtil.getCanonicalFile(new File(System.getProperty("user.home"), "Library/" + macLibrarySubDir));
        }
        String configDir = System.getenv(linuxEnvVar);
        if (configDir == null) return FileUtil.getCanonicalFile(new File(System.getProperty("user.home"), linuxDefaultDir));
        return FileUtil.getCanonicalFile(new File(configDir));
    }

    public static File getConfigDir() {
        return UserDirs.getUserDir("Application Support", "XDG_CONFIG_HOME", ".config");
    }

    public static File getCachesDir() {
        return UserDirs.getUserDir("Caches", "XDG_CACHE_HOME", ".cache");
    }

    public static File getDataDir() {
        return UserDirs.getUserDir("Application Support", "XDG_DATA_HOME", ".local/share");
    }
}

