/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.ejt.internal.util.CommonStringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileAttributesHelper {
    private static final Pattern CHMOD_SPEC = Pattern.compile("([augo]*)([+-=])([rwxugo]+)");

    public static String getPosixFilePermissions(File file) throws IOException {
        try {
            return PosixFilePermissions.toString(Files.getPosixFilePermissions(file.toPath(), LinkOption.NOFOLLOW_LINKS));
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
    }

    public static PosixFileAttributes getFileAttributes(File file) throws IOException {
        PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(file.toPath(), PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        return posixFileAttributeView.readAttributes();
    }

    public static String translateMode(String mode, File file) throws IOException {
        if (Character.isDigit(mode.charAt(0))) {
            return CommonStringUtil.toJavaTypeMode(mode);
        }
        switch (mode.charAt(0)) {
            case 'r': 
            case 'w': 
            case 'x': {
                return mode;
            }
        }
        return FileAttributesHelper.translateChmodSpec(mode, FileAttributesHelper.getFileAttributes(file).permissions());
    }

    public static String translateChmodSpec(String mode, Set<PosixFilePermission> permissions) throws IOException {
        Matcher matcher = CHMOD_SPEC.matcher(mode);
        if (matcher.matches()) {
            String subjects = matcher.group(1);
            if (subjects.isEmpty()) {
                subjects = "a";
            }
            String operation = matcher.group(2);
            String flags = matcher.group(3);
            HashSet<PosixFilePermission> changedPermissions = new HashSet<PosixFilePermission>(permissions);
            FileAttributesHelper.changePermissions(changedPermissions, subjects, operation.charAt(0), flags);
            return PosixFilePermissions.toString(changedPermissions);
        }
        throw new IOException("Mode " + mode + " cannot be parsed");
    }

    private static void changePermissions(Set<PosixFilePermission> permissions, String subjects, char operation, String flags) throws IOException {
        for (int i = 0; i < subjects.length(); ++i) {
            FileAttributesHelper.changePermissions(permissions, subjects.charAt(i), operation, flags);
        }
    }

    private static void changePermissions(Set<PosixFilePermission> permissions, char subject, char operation, String flags) throws IOException {
        for (int i = 0; i < flags.length(); ++i) {
            FileAttributesHelper.changePermissions(permissions, subject, operation, flags.charAt(i));
        }
    }

    private static void changePermissions(Set<PosixFilePermission> permissions, char subject, char operation, char flag) throws IOException {
        HashSet<PosixFilePermission> changedPermissions = new HashSet<PosixFilePermission>();
        switch (flag) {
            case 'g': 
            case 'o': 
            case 'u': {
                char[] currentFlags;
                for (char currentFlag : currentFlags = FileAttributesHelper.getCurrentFlags(permissions, flag)) {
                    FileAttributesHelper.addChangedPermissions(changedPermissions, subject, currentFlag);
                }
                break;
            }
            default: {
                FileAttributesHelper.addChangedPermissions(changedPermissions, subject, flag);
            }
        }
        switch (operation) {
            case '+': {
                permissions.addAll(changedPermissions);
                break;
            }
            case '-': {
                permissions.removeAll(changedPermissions);
                break;
            }
            case '=': {
                permissions.removeAll(FileAttributesHelper.getAllPermissions(subject));
                permissions.addAll(changedPermissions);
                break;
            }
            default: {
                throw new IOException("Operation " + operation + " is not supported in file modes");
            }
        }
    }

    private static Collection<PosixFilePermission> getAllPermissions(char subject) throws IOException {
        switch (subject) {
            case 'u': {
                return Arrays.asList(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE);
            }
            case 'g': {
                return Arrays.asList(PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_EXECUTE);
            }
            case 'o': {
                return Arrays.asList(PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_EXECUTE);
            }
            case 'a': {
                HashSet<PosixFilePermission> allPermissions = new HashSet<PosixFilePermission>();
                allPermissions.addAll(FileAttributesHelper.getAllPermissions('u'));
                allPermissions.addAll(FileAttributesHelper.getAllPermissions('g'));
                allPermissions.addAll(FileAttributesHelper.getAllPermissions('o'));
                return allPermissions;
            }
        }
        throw new IOException("Invalid subject " + subject);
    }

    private static void addChangedPermissions(Set<PosixFilePermission> changedPermissions, char subject, char flag) throws IOException {
        switch (subject) {
            case 'a': {
                changedPermissions.add(FileAttributesHelper.getSinglePermission('u', flag));
                changedPermissions.add(FileAttributesHelper.getSinglePermission('g', flag));
                changedPermissions.add(FileAttributesHelper.getSinglePermission('o', flag));
                break;
            }
            default: {
                changedPermissions.add(FileAttributesHelper.getSinglePermission(subject, flag));
            }
        }
    }

    private static char[] getCurrentFlags(Set<PosixFilePermission> permissions, char subject) throws IOException {
        switch (subject) {
            case 'u': {
                return FileAttributesHelper.getCurrentFlags(permissions, PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE);
            }
            case 'g': {
                return FileAttributesHelper.getCurrentFlags(permissions, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_EXECUTE);
            }
            case 'o': {
                return FileAttributesHelper.getCurrentFlags(permissions, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_EXECUTE);
            }
        }
        throw new IOException("Invalid subject " + subject);
    }

    private static char[] getCurrentFlags(Set<PosixFilePermission> permissions, PosixFilePermission read, PosixFilePermission write, PosixFilePermission execute) {
        StringBuilder buffer = new StringBuilder();
        if (permissions.contains((Object)read)) {
            buffer.append('r');
        }
        if (permissions.contains((Object)write)) {
            buffer.append('w');
        }
        if (permissions.contains((Object)execute)) {
            buffer.append('x');
        }
        return buffer.toString().toCharArray();
    }

    private static PosixFilePermission getSinglePermission(char subject, char flag) throws IOException {
        switch (flag) {
            case 'r': {
                switch (subject) {
                    case 'u': {
                        return PosixFilePermission.OWNER_READ;
                    }
                    case 'g': {
                        return PosixFilePermission.GROUP_READ;
                    }
                    case 'o': {
                        return PosixFilePermission.OTHERS_READ;
                    }
                }
                FileAttributesHelper.invalidSubject(subject);
            }
            case 'w': {
                switch (subject) {
                    case 'u': {
                        return PosixFilePermission.OWNER_WRITE;
                    }
                    case 'g': {
                        return PosixFilePermission.GROUP_WRITE;
                    }
                    case 'o': {
                        return PosixFilePermission.OTHERS_WRITE;
                    }
                }
                FileAttributesHelper.invalidSubject(subject);
            }
            case 'x': {
                switch (subject) {
                    case 'u': {
                        return PosixFilePermission.OWNER_EXECUTE;
                    }
                    case 'g': {
                        return PosixFilePermission.GROUP_EXECUTE;
                    }
                    case 'o': {
                        return PosixFilePermission.OTHERS_EXECUTE;
                    }
                }
                FileAttributesHelper.invalidSubject(subject);
            }
        }
        throw new IOException("The access flag " + flag + " is not supported in file modes");
    }

    private static void invalidSubject(char subject) throws IOException {
        throw new IOException("The character " + subject + " is not supported in file modes");
    }
}

