<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.4/2843222
 */
namespace Groups\Service;

use Application\Service\P4Command;
use P4\Connection\CommandResult;
use P4\Connection\ConnectionInterface;

/**
 * A service to run 'p4 group' commands
 */
class Group extends P4Command implements IGroup
{
    /**
     * @inheritDoc
     */
    public function exists(ConnectionInterface $connection, string $groupId, array $options = []) : CommandResult
    {
        $args = ['--exists', '-o'];
        $args = array_merge($args, (array)$groupId);
        return $this->run($connection, self::GROUP_COMMAND, $options, $args);
    }
}
