<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.3/2828589
 */
namespace Projects\Filter;

use Application\Filter\FormBoolean;
use Laminas\Filter\AbstractFilter;
use Projects\Model\IProject as ModelInt;
use TestIntegration\Filter\EncodingValidator;

/**
 * Filter for legacy project test automation settings
 */
class TestAutomation extends AbstractFilter
{
    /**
     * Filter the 'tests' field to contain default values when not provided
     * @param mixed $value test field value
     * @return array
     */
    public function filter($value): array
    {
        $booleanFilter = new FormBoolean();
        $enabled       = isset($value[ModelInt::TESTS_ENABLED])
            ? $booleanFilter->filter($value[ModelInt::TESTS_ENABLED]) : false;
        return [
            ModelInt::TESTS_ENABLED => $enabled,
            ModelInt::TESTS_URL => $value[ModelInt::TESTS_URL] ?? null,
            ModelInt::TESTS_POST_BODY => isset($value[ModelInt::TESTS_POST_BODY])
                    ? is_string($value[ModelInt::TESTS_POST_BODY])
                        ? trim($value[ModelInt::TESTS_POST_BODY])
                        : $value[ModelInt::TESTS_POST_BODY]
                    : null,
            ModelInt::TESTS_POST_FORMAT => isset($value[ModelInt::TESTS_POST_FORMAT])
                ? trim($value[ModelInt::TESTS_POST_FORMAT])
                : EncodingValidator::URL,
        ];
    }
}
