<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.3/2828589
 */

namespace Comments\Validator;

use Application\I18n\TranslatorFactory;
use Application\Validator\AbstractValidator;
use Comments\Model\IComment;
use Interop\Container\ContainerInterface;
use Laminas\Validator\StringLength;

/**
 * Validate that the comment body is not empty if there are no attachments
 */
class Body extends AbstractValidator
{
    const BODY_INVALID = "commentBodyInvalid";
    protected $services;

    /**
     * Body validator constructor.
     * @param ContainerInterface $services  application services
     */
    public function __construct(ContainerInterface $services)
    {
        parent::__construct();
        $this->services = $services;
    }

    /*
     * Allow a string to have zero length if there are attachments
     */
    public function isValid($value, $context = null)
    {
        $valid = (new StringLength(['min'=>1]))->isValid($value);
        if (!$valid) {
            $valid = count($context[IComment::ATTACHMENTS]??[])>0;
        }
        if (!$valid) {
            $translator = $this->services->get(TranslatorFactory::SERVICE);

            $this->abstractOptions['messages'][self::BODY_INVALID] =
                $translator->t(
                    "Either the comment body or at least one attachment must be provided"
                );
            return false;
        }
        return true;
    }
}
