<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.3/2828589
 */
namespace Comments\Validator;

use Application\Validator\ConnectedAbstractValidator;

/**
 * Check if the given list of ids represents existing attachments.
 */
class Attachments extends ConnectedAbstractValidator
{
    const UNKNOWN_IDS = 'unknownAttachmentIds';

    protected $messageTemplates = [
        self::UNKNOWN_IDS  => "Unknown attachment id(s): %ids%"
    ];

    protected $messageVariables = [
        'ids' => 'unknownIds'
    ];

    protected $unknownIds;

    /**
     * Returns true if the values are all valid attachment ids
     *
     * @param   string|array    $value  id or list of ids to check
     * @return  boolean         true if the values are all valid attachment ids
     */
    public function isValid($value) : bool
    {
        $attachmentDAO = $this->getAttachmentDao();
        $p4            = $this->getConnection();
        $value         = (array) $value;
        $unknownIds    = array_diff($value, $attachmentDAO->exists($value, $p4));
        if (count($unknownIds)) {
            $this->unknownIds = implode(', ', $unknownIds);
            $this->error(self::UNKNOWN_IDS);
            return false;
        }

        return true;
    }
}
