<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.3/2828589
 */
namespace Comments\Filter;

use Api\IRequest;
use Application\I18n\TranslatorFactory;
use Interop\Container\ContainerInterface;

/**
 * Class EditComment. Filter to validate content when a comment is updated
 * @package Comments\Filter
 */
class EditComment extends Comment implements IComment
{
    /**
     * EditComment constructor.
     * @param ContainerInterface $services
     * @param array|null $options
     */
    public function __construct(ContainerInterface $services, array $options = null)
    {
        $this->services   = $services;
        $this->translator = $services->get(TranslatorFactory::SERVICE);
        $this->apiVersion = $options[IRequest::VERSION]??'v10';
        $this->addBodyValidator();
        $this->addTaskStateValidator();
        $this->addAttachmentsValidator();
    }
}
