<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.3/2828589
 */

namespace Application\Validator;

/**
 * Class IsStringOrNull. Simple validation to ensure a value is a string or null. Use StringLength or Regex etc.
 * for more complex validation.
 * @package Application\Validator
 */
class IsStringOrNull extends AbstractValidator
{
    const INVALID = 'invalid';

    protected $messageTemplates = [
        self::INVALID => "Invalid type given. String or Null required.",
    ];

    /**
     * Returns true if $value is a string (including an empty string) or null.
     *
     * @param   mixed   $value  value to check for string type.
     * @return  boolean         true if type is a string; false otherwise.
     */
    public function isValid($value) : bool
    {
        if (!is_string($value) && $value !== null) {
            $this->error(self::INVALID);
            return false;
        }
        return true;
    }
}
