"use strict";

async function refresh() {
  var otype = document.getElementById("type").value;
  var oname = document.getElementById("name").value;

  var objtype = p4vjs.ObjectType.PENDINGCHANGE;
  switch (otype) {
    case "Pending Change":
      objtype = p4vjs.ObjectType.PENDINGCHANGE;
      break;
    case "Submitted Change":
      objtype = p4vjs.ObjectType.SUBMITTEDCHANGE;
      break;
    case "Branch":
      objtype = p4vjs.ObjectType.BRANCH;
      break;
    case "Label":
      objtype = p4vjs.ObjectType.LABEL;
      break;
    case "Workspace":
      objtype = p4vjs.ObjectType.CLIENT;
      break;
    case "Job":
      objtype = p4vjs.ObjectType.JOB;
      break;
    case "Stream":
      objtype = p4vjs.ObjectType.STREAM;
      break;
    case "User":
      objtype = p4vjs.ObjectType.USER;
      break;
    case "Group":
      objtype = p4vjs.ObjectType.GROUP;
      break;
    default:
      return false;
  }

  p4vjs.refresh(objtype, oname).then(function(result) {
    if (result)
      document.getElementById("refreshResult").innerHTML = "<b>Refresh succeeded</b>";
    else
      document.getElementById("refreshResult").innerHTML = "<b>Refresh failed</b>";
  });
}