"use strict";

/*
  Demonstration of the Alerts API.
  
  To create an alert, you must define a function that will be called every
  time the alert is run. The function will receive the alerts API, which you
  can use to create a new alert, or update an old one.
  
  When creating an alert entry in p4admin, you would use these entries for this alert:
  
    URL: <path to>/p4admin/DemonstrationAlert.js (this file)
    Entry Point: Change.runAlert

  You are free to use the p4vjs API in your alerts.
  
  The Alerts API consists of:
  
  ## addAlert(msg, status) [async]
    Posts a new alert to the alerts box and returns the identifier.
    - msg: The message text for your alert
    - status: The status level of your alert. By default it is AlertAPI.Status.Warning.
    - return value: An identifier of the posted alert. You can save this to use on your
      next pass.
  
  ## updateAlert(id, msg, status) [async]
    Updates a posted alert.
    - id: The identifier of the alert to modify.
    - msg: The message text for your alert
    - status: The status level of your alert. By default it is AlertAPI.Status.Warning.
    - return value: none.
  
  ## deleteAlert(id) [async]
    Removes a posted alert from the alerts box.
    - id: The identifier of the alert to delete.
    - return value: none.

  ## AlertAPI.Status:
    - Info   
    - Error
    - Warning

  Recommended use of Alerts.

  The AlertBox in P4Admin is intended to be a dashboard reporting on some state in your system.
  AlertApi.addAlert returns a unique alertID.
  We recommend using this alertID to either update or delete the Alert.
  Each time AlertApi.addAlert is called, a new unique alertID is generated.

  addAlert : adds an Alert at the end of the list of Alerts.
  updateAlert : will update the Alert added previously. The Alert will maintain its position in the list.
  deleteAlert : will remove the Alert from the list.
*/

var Change = (function() {
    var alertID;

    return {
        runAlert: async function(AlertAPI) {
            // You can use the p4vjs API in your alerts
            
            var change = parseInt((await p4vjs.p4(["counter","change"])).data[0].value);

            var message = `Changes are at: ${change}`;

            let status = (change % 2 == 0) ? AlertAPI.Status.Info : AlertAPI.Status.Warning;

            if (!alertID) {
                alertID = await AlertAPI.addAlert(message, status);
            } else {
                await AlertAPI.updateAlert(alertID, message, status);
            }
        }
    };
}())
