"use strict";

var p4map = [
  '//project1/mozart/v72.3/zippy/Jamrules zippy/Jamrules',
  '//project1/mozart/v72.3/zippy/auth/... zippy/auth/...',
  '//project1/mozart/v72.3/zippy/broker/... zippy/broker/...',
  '//project1/mozart/v72.3/zippy/bdopen2/... zippy/bdopen2/...',
  '//project1/mozart/v72.3/zippy/bdpipe/... zippy/bdpipe/...',
  '//project1/mozart/v72.3/zippy/bma/... zippy/bma/...',
  '//project1/mozart/v72.3/zippy/bmc/... zippy/bmc/...',
  '//project1/mozart/v72.3/zippy/bmi/... zippy/bmi/...',
  '//project1/mozart/v72.3/zippy/bml/... zippy/bml/...',
  '//project1/mozart/v72.3/zippy/bmp/... zippy/bmp/...',
  '//project1/mozart/v72.3/zippy/bmr/... zippy/bmr/...',
  '//project1/mozart/v72.3/zippy/bmrpc/... zippy/bmrpc/...',
  '//project1/mozart/v72.3/zippy/bms/... zippy/bms/...',
  '//project1/mozart/v72.3/zippy/bmx/... zippy/bmx/...',
  '//project1/mozart/v72.3/zippy/lbr/... zippy/lbr/...',
  '//project1/mozart/v72.3/zippy/proxy/... zippy/proxy/...',
  '//project1/mozart/v72.3/zippy/server/... zippy/server/...',
  '//project1/mozart/v72.3/zippy/tests/... zippy/tests/...',
  '//project1/mozart/v72.3/tools/build/bin/build-dist-macosx tools/build/bin/build-dist-macosx',
  '//depot/main/tools/build/conf/build.conf tools/build/conf/build.conf',
  '//depot/main/tools/build/conf/zipst/... tools/build/conf/zipst/...',
  '//depot/main/tools/build/lib/perl/CPAN/... tools/build/lib/perl/CPAN/...',
  '//depot/main/tools/build/lib/perl/P4/... tools/build/lib/perl/P4/...'
];



async function runOnload() {
  try {
    var mapTable = document.getElementById("listMap");

    while (mapTable.hasChildNodes()) {
      mapTable.removeChild(mapTable.firstChild);
    }

    var index = 0;
    p4map.forEach(line => {
      var row = mapTable.insertRow(index++);
      var cell = row.insertCell(0);
      var textNode = document.createTextNode(line);
      cell.appendChild(textNode);
    });

    // hide the translation error
    var te = document.getElementById("translateError");
    te.style.display = "none";
  }
  catch (e) {
    alert(e);
  }
}

async function testInclude() {
  var inputfield = document.getElementById("pathtext");
  var path = inputfield.value;
  p4vjs.mapIncludes(p4map, path).then(function(result) {
    var match = result;
    if (match === p4vjs.MapSide.LEFT)
      alert("Matches mapping on the Left side of the map")
    else if (match === p4vjs.MapSide.RIGHT)
      alert("Matches mapping on the Right side of the map")
    else if (match === p4vjs.MapSide.BOTH)
      alert("Matches mapping on the Both sides of the map")
    else // (match === p4vjs.MapSide.NEITHER)
      alert("Does not map on either side of the map");
  });
}

async function testTranslate() {
  var picker = document.getElementById("pick");
  var side = pick.value;
  var mside = p4vjs.MapSide.NEITHER;
  if (side === "Left")
    mside = p4vjs.MapSide.LEFT;
  else if (side === "Right")
    mside = p4vjs.MapSide.RIGHT;
  else if (side === "Both")
    mside = p4vjs.MapSide.BOTH;

  var inputfield = document.getElementById("pathtrtext");
  var path = inputfield.value;

  p4vjs.mapTranslate(p4map, path, mside).then(function(result) {
    var te = document.getElementById("translateError");
    var inputfield = document.getElementById("translatetext");
    if (!result.success) {
      // show the translation error
      te.style.display = "block";
      inputfield.value = "";
    }
    else {
      te.style.display = "none";
      inputfield.value = result.translation;
    }

  });
}
