"use strict";
(async function() {
  var specDef;
  var formType = 'branch';
  var formName;

  window.runOnload = function() {
    var branchName = p4vjs.getParameter("branch");
    if (branchName) {
      formType = 'branch';
      formName = branchName;
      editForm();
      return;
    }
    var clientName = p4vjs.getParameter("workspace");
    if (clientName) {
      formType = 'client';
      formName = clientName;
      editForm();
      return;
    }
    var userName = p4vjs.getParameter("user");
    if (userName) {
      formType = 'user';
      formName = userName;
      editForm();
      return;
    }
    var jobName = p4vjs.getParameter("job");
    if (jobName) {
      formType = 'job';
      formName = jobName;
      editForm();
      return;
    }
    var streamName = p4vjs.getParameter("stream");
    if (streamName) {
      formType = 'stream';
      formName = streamName;
      editForm();
      return;
    }
    var repoName = p4vjs.getParameter("repo");
    if (repoName) {
      formType = 'repo';
      formName = repoName;
      editForm();
      return;
    }
  }

  async function editForm() {
    var obj = await p4vjs.p4(['spec', '-o', formType]);
    specDef = ParseSpecDef.parseSpecDef(obj.data[0]);
    var inputfield = document.getElementById("formname");
    var result = await p4vjs.p4([formType, '-o', formName]);
    formDescriptionFetched(result);
  }

  function formDescriptionFetched(obj) {
    var formEditor = document.getElementById("formEditor");
    formEditor.innerHTML = "";
    var index = 0;
    var specarr = specDef.data;
    var arrlength = specarr.length;
    for (var i = 0; i < arrlength; i++) {
      var key = specarr[i].name;
      var row = formEditor.insertRow(index++);

      // left cell
      var cellLeft = row.insertCell(0);
      var textNode = document.createTextNode(key);
      cellLeft.appendChild(textNode);
      cellLeft.setAttribute("class", "nameFont");

      // right cell
      var cellRight = row.insertCell(1);
      if (i == 0) {
        textNode = document.createTextNode(obj.data[0][key]);
        cellRight.appendChild(textNode);
      }
      else {
        var val = obj.data[0][key];
        var prevalues = specarr[i].values;
        // if prevalue[0] is an array, the gui should present ann array of checkboxes (TBD)
        if (prevalues != undefined && typeof prevalues[0] == "string") {
          var selectNode = document.createElement('SELECT');
          for (var j = 0; j < prevalues.length; j++) {
            var pvalue = prevalues[j];
            var stvalue = '';
            if (typeof pvalue == "string")
              stvalue = pvalue;
            var o = document.createElement("option");
            o.value = stvalue;
            o.text = stvalue;
            selectNode.appendChild(o);
          }
          cellRight.appendChild(selectNode);

          selectNode.value = val;
        }
        else {
          var inputNode = document.createElement("INPUT");
          inputNode.setAttribute('size', specarr[i].length);
          var val = obj.data[0][key];
          if (val !== 'undefined' && val != undefined) {
            inputNode.value = val;
          }
          else {
            var dataType = specarr[i].dataType;
            if (dataType == 'wlist') {
              inputNode = document.createElement("TEXTAREA");
              inputNode.setAttribute('cols', "80");
              inputNode.setAttribute('rows', "10");

              val = '';
              var line;
              for (var idx = 0;
                (line = obj.data[0][key + idx.toString()]) != undefined; ++idx) {
                val += line;
                val += String.fromCharCode(13);
              }
              inputNode.value = val;
            }
            else {
              inputNode.value = '';
            }
          }
          cellRight.appendChild(inputNode);
        }
      }
    }
  }

  window.saveForm = async function() {
    var table = document.getElementById("formEditor");
    var firstcol = table.rows[0].cells[1];

    var formData = {};
    formData[specDef.data[0].name] = firstcol.childNodes[0].wholeText;
    for (var i = 1, row; row = table.rows[i]; i++) {
      var spDef = specDef.data[i];
      var dataType = spDef.dataType;

      if (dataType != 'wlist') {
        formData[spDef.name] = row.cells[1].children[0].value.trim();
      }
      else {
        var data = row.cells[1].children[0].value;
        var arrayOfLines = data.split("\n");
        var viewData = '';
        for (var lnr = 0; lnr < arrayOfLines.length; lnr++) {
          var line = arrayOfLines[lnr];
          if (line != '' && line !== 'undefined' && line != undefined) {
            viewData += "\n\t" + line.trim();
          }
        }
        formData[spDef.name] = viewData;
      }
    }
    await p4vjs.p4([formType, '-i'], formData);

    // now refresh the updated object in P4V
    if (formType === 'branch')
      p4vjs.refresh(p4vjs.ObjectType.BRANCH, formName);
    else if (formType === 'client')
      p4vjs.refresh(p4vjs.ObjectType.CLIENT, formName);
    else if (formType === 'user')
      p4vjs.refresh(p4vjs.ObjectType.USER, formName);
    else if (formType === 'job')
      p4vjs.refresh(p4vjs.ObjectType.JOB, formName);
    else if (formType === 'stream')
      p4vjs.refresh(p4vjs.ObjectType.STREAM, formName);
    else if (formType === 'repo')
      p4vjs.refresh(p4vjs.ObjectType.REPO, formName);
  }
}());