/*
 * Copyright 2023 Perforce Software.  All rights reserved.
 *
 * This file is part of Perforce - the FAST SCM System.
 */

/*
 * msgconfig.h - definitions of help messages for config variables.
 */

class MsgConfig {

    public:
	// Debug levels
	static ErrorId Db;
	static ErrorId Diff;
	static ErrorId Dm;
	static ErrorId Dmc;
	static ErrorId Ftp;
	static ErrorId Handle;
	static ErrorId Lbr;
	static ErrorId Map;
	static ErrorId Net;
	static ErrorId Options;
	static ErrorId Peek;
	static ErrorId Rcs;
	static ErrorId Records;
	static ErrorId Rpc;
	static ErrorId Server;
	static ErrorId Spec;
	static ErrorId Track;
	static ErrorId Ob;
	static ErrorId Viewgen;
	static ErrorId Rpl;
	static ErrorId Ssl;
	static ErrorId Time;
	static ErrorId Cluster;
	static ErrorId Zk;
	static ErrorId Ldap;
	static ErrorId Dvcs;
	static ErrorId Graph;
	static ErrorId Gconn;
	static ErrorId Fovr;
	static ErrorId Script;
	static ErrorId Stg;
	static ErrorId Thread;
	static ErrorId Exts;
	static ErrorId Protect;
	static ErrorId Heartbeat;
	static ErrorId Shelve;
	static ErrorId Sqw;
	static ErrorId Stm;
	static ErrorId Pcheck;
	static ErrorId Topology;
	static ErrorId Resource;
	static ErrorId S3;
	static ErrorId Suptool;
	static ErrorId Elog;
	static ErrorId Dltxfer;
	static ErrorId Perf;
	static ErrorId WebSrv;

	// Numeric tunables
	static ErrorId ClusterJournalShared;
	static ErrorId DbCheckpointBufsize;
	static ErrorId DbCheckpointThreads;
	static ErrorId DbCheckpointWorklevel;
	static ErrorId DbCheckpointReqlevel;
	static ErrorId DbCheckpointNumfiles;
	static ErrorId DbExperimentalLogging;
	static ErrorId DbInternalRepair;
	static ErrorId DbIsalive;
	static ErrorId DbJnlackShared;
	static ErrorId DbJournalrotateWarnthresh;
	static ErrorId DbMonitorAddthresh;
	static ErrorId DbMonitorInterval;
	static ErrorId DbMonitorMinruntime;
	static ErrorId DbMonitorTermallow;
	static ErrorId DbMonitorShared;
	static ErrorId DbPageMigrate;
	static ErrorId DbPartitionDrop;
	static ErrorId DbPartitionVerify;
	static ErrorId DbPeeking;
	static ErrorId DbPeekingUsemaxlock;
	static ErrorId DbReorgDisable;
	static ErrorId DbReorgMisorder;
	static ErrorId DbReorgOccup;
	static ErrorId DbRtIo;
	static ErrorId DbTrylock;
	static ErrorId DbarrayPutcheck;
	static ErrorId DbarrayReserve;
	static ErrorId DbjournalBufsize;
	static ErrorId DbjournalWordsize;
	static ErrorId DbopenCache;
	static ErrorId DbopenCacheWide;
	static ErrorId DbopenFreepct;
	static ErrorId DbopenMismatchDelay;
	static ErrorId DbopenNofsync;
	static ErrorId DbopenPagesize;
	static ErrorId DbopenRetry;
	static ErrorId DiffBinaryRcs;
	static ErrorId DiffSlimit1;
	static ErrorId DiffSlimit2;
	static ErrorId DiffSthresh;
	static ErrorId DmAltsyncEnforce;
	static ErrorId DmAnnotateMaxsize;
	static ErrorId DmBatchDomains;
	static ErrorId DmBatchNet;
	static ErrorId DmChangeRestrictPending;
	static ErrorId DmChangeSkipkeyed;
	static ErrorId DmChangesThresh1;
	static ErrorId DmChangesThresh2;
	static ErrorId DmChangeviewOpenable;
	static ErrorId DmClientInitroot;
	static ErrorId DmClientLimitprotects;
	static ErrorId DmConfigureCommentMandatory;
	static ErrorId DmCopyAttributes;
	static ErrorId DmCopyMovewarn;
	static ErrorId DmDomainAccessupdate;
	static ErrorId DmDomainAccessforce;
	static ErrorId DmDvcsAllowcasemismatch;
	static ErrorId DmFetchPreservechangenumbers;
	static ErrorId DmFlushforce;
	static ErrorId DmFlushtry;
	static ErrorId DmFstatOutputthreshold;
	static ErrorId DmFstatMaxcontent;
	static ErrorId DmGraphEnabled;
	static ErrorId DmGrepMaxlinelength;
	static ErrorId DmGrepMaxrevs;
	static ErrorId DmGrepMaxcontext;
	static ErrorId DmHavePreload;
	static ErrorId DmInfoHide;
	static ErrorId DmIntegEngine;
	static ErrorId DmIntegMaxact;
	static ErrorId DmIntegMaxbranch;
	static ErrorId DmIntegStreamAllowDepotFilespec;
	static ErrorId DmIntegStreamspec;
	static ErrorId DmIntegTweaks;
	static ErrorId DmIntegUndo;
	static ErrorId DmIntegMultipleStreams;
	static ErrorId DmIsalive;
	static ErrorId DmKeysHide;
	static ErrorId DmLabelsSearchAutoreload;
	static ErrorId DmLockBatch;
	static ErrorId DmLocksExclBatchNet;
	static ErrorId DmLocksGlobalBatchNet;
	static ErrorId DmLocksGlobalResultBatchNet;
	static ErrorId DmMaxkey;
	static ErrorId DmOpenShowGloballocks;
	static ErrorId DmPasswordMinlength;
	static ErrorId DmPopulateSkipkeyed;
	static ErrorId DmProtectsAllowAdmin;
	static ErrorId DmProtectsExclusioncheck;
	static ErrorId DmProtectsHide;
	static ErrorId DmProtectsStreamspec;
	static ErrorId DmProxyProtects;
	static ErrorId DmQuickClients;
	static ErrorId DmQuickDomains;
	static ErrorId DmQuickHave;
	static ErrorId DmQuickInteg;
	static ErrorId DmQuickResolve;
	static ErrorId DmQuickRev;
	static ErrorId DmQuickWorking;
	static ErrorId DmRenameuserScanthresh;
	static ErrorId DmReopenBatch;
	static ErrorId DmRepoNoautocreate;
	static ErrorId DmRepoUnpack;
	static ErrorId DmResolveAttrib;
	static ErrorId DmResolveIgnoredeleted;
	static ErrorId DmRevScanThresh;
	static ErrorId DmRevcxThresh1;
	static ErrorId DmRevcxThresh2;
	static ErrorId DmRevertBatch;
	static ErrorId DmRotatelogwithjnl;
	static ErrorId DmShelveAccessupdate;
	static ErrorId DmShelveMaxfiles;
	static ErrorId DmShelveMaxsize;
	static ErrorId DmShelvePromote;
	static ErrorId DmStatusMatchlines;
	static ErrorId DmStatusMatchsize;
	static ErrorId DmStreamParentview;
	static ErrorId DmStreamComponents;
	static ErrorId DmStreamSparseBranchMax;
	static ErrorId DmSyncStreamChange;
	static ErrorId DmSubprotectsGrantAdmin;
	static ErrorId DmTopologyLastseenupdate;
	static ErrorId DmUserAccessupdate;
	static ErrorId DmUserAccessforce;
	static ErrorId DmUserAccessmode;
	static ErrorId DmUserAllowselfupdate;
	static ErrorId DmUserHideinvalid;
	static ErrorId DmUserInsecurelogin;
	static ErrorId DmUserLoginattempts;
	static ErrorId DmUserNoautocreate;
	static ErrorId DmUserNumeric;
	static ErrorId DmUserResetpassword;
	static ErrorId DmUserSetinitialpasswd;
	static ErrorId FilesysAtomicRename;
	static ErrorId FilesysBinaryscan;
	static ErrorId FilesysBufsize;
	static ErrorId FilesysCachehint;
	static ErrorId FilesysChecklinks;
	static ErrorId FilesysDetectunicode;
	static ErrorId FilesysDetectutf8;
	static ErrorId FilesysLockdelay;
	static ErrorId FilesysLocktimeout;
	static ErrorId FilesysLocktry;
	static ErrorId FilesysMaketmp;
	static ErrorId FilesysMaxmap;
	static ErrorId FilesysMaxsymlink;
	static ErrorId FilesysMaxtmp;
	static ErrorId FilesysRestrictsymlinks;
	static ErrorId FilesysUtf8Bom;
	static ErrorId FilesysExtendlowmark;
	static ErrorId FilesysWindowsLfn;
	static ErrorId FilesysClientNullsync;
	static ErrorId IndexDomainOwner;
	static ErrorId LbrAutocompress;
	static ErrorId LbrBufsize;
	static ErrorId LbrFabricate;
	static ErrorId LbrProxyCase;
	static ErrorId LbrRcsExistcheck;
	static ErrorId LbrRcsMaxlen;
	static ErrorId LbrReplicaNotransfer;
	static ErrorId LbrRetryMax;
	static ErrorId LbrStatInterval;
	static ErrorId LbrVerifyIn;
	static ErrorId LbrVerifyOut;
	static ErrorId LbrVerifyScriptOut;
	static ErrorId LbrStorageDelay;
	static ErrorId LbrStorageAllowsymlink;
	static ErrorId LbrStorageSkipkeyed;
	static ErrorId LbrStorageThreads;
	static ErrorId LbrRcsLocking;
	static ErrorId LbrUnloaddepotCompress;
	static ErrorId LogGroupMaxlen;
	static ErrorId LogOriginhost;
	static ErrorId MapJoinmax1;
	static ErrorId MapJoinmax2;
	static ErrorId MapLimitMaxlookback;
	static ErrorId MapMaxwild;
	static ErrorId MapOverlayLegacy;
	static ErrorId MergeDlEndeol;
	static ErrorId NetAutotune;
	static ErrorId NetBufsize;
	static ErrorId NetDeltaRplMinsize;
	static ErrorId NetDeltaRplThreshold;
	static ErrorId NetDeltaTransferMinsize;
	static ErrorId NetDeltaTransferThreshold;
	static ErrorId NetKeepaliveDisable;
	static ErrorId NetKeepaliveIdle;
	static ErrorId NetKeepaliveInterval;
	static ErrorId NetKeepaliveCount;
	static ErrorId NetHeartbeatInterval;
	static ErrorId NetHeartbeatWait;
	static ErrorId NetHeartbeatMissingInterval;
	static ErrorId NetHeartbeatMissingWait;
	static ErrorId NetHeartbeatMissingCount;
	static ErrorId NetMaxFaultPub;
	static ErrorId NetMaxclosewait;
	static ErrorId NetMaxwait;
	static ErrorId NetNagle;
	static ErrorId NetParallelMax;
	static ErrorId NetParallelThreads;
	static ErrorId NetParallelBatch;
	static ErrorId NetParallelBatchsize;
	static ErrorId NetParallelMin;
	static ErrorId NetParallelMinsize;
	static ErrorId NetParallelShelveThreads;
	static ErrorId NetParallelShelveBatch;
	static ErrorId NetParallelShelveMin;
	static ErrorId NetParallelSubmitThreads;
	static ErrorId NetParallelSubmitBatch;
	static ErrorId NetParallelSubmitMin;
	static ErrorId NetParallelSyncSvrthreads;
	static ErrorId NetQuickAck;
	static ErrorId NetRcvbuflowmark;
	static ErrorId NetRcvbufmaxsize;
	static ErrorId NetRcvbufsize;
	static ErrorId NetReuseport;
	static ErrorId NetRfc3484;
	static ErrorId NetSendlimit;
	static ErrorId NetTcpsize;
	static ErrorId NetBacklog;
	static ErrorId NetX3Minsize;
	static ErrorId ProxyDeliverFix;
	static ErrorId ProxyMonitorInterval;
	static ErrorId ProxyMonitorLevel;
	static ErrorId ProxyClearcachethresh;
	static ErrorId ProxySuppresswarnings;
	static ErrorId RcsMaxinsert;
	static ErrorId RcsNofsync;
	static ErrorId RmtAllowRemoteUser;
	static ErrorId RpcDelay;
	static ErrorId RpcDurablewait;
	static ErrorId RpcHimark;
	static ErrorId RpcLowmark;
	static ErrorId RpcIpaddrMismatch;
	static ErrorId RplArchiveGraph;
	static ErrorId RplAwaitjnlCount;
	static ErrorId RplAwaitjnlInterval;
	static ErrorId RplBufferRelease;
	static ErrorId RplChecksumAuto;
	static ErrorId RplChecksumChange;
	static ErrorId RplChecksumTable;
	static ErrorId RplCompress;
	static ErrorId RplCounterHook;
	static ErrorId RplDeferredSends;
	static ErrorId RplFilterExpand;
	static ErrorId RplFilterExpandBatch;
	static ErrorId RplFilterExpandThreads;
	static ErrorId RplFilterRestrict;
	static ErrorId RplFilterRestrictBatch;
	static ErrorId RplFilterRestrictThreads;
	static ErrorId RplJnlBatchSize;
	static ErrorId RplJnlwaitAdjust;
	static ErrorId RplJnlwaitInterval;
	static ErrorId RplJnlwaitMax;
	static ErrorId RplJournalAck;
	static ErrorId RplJournalAckMin;
	static ErrorId RplJournalcopyLocation;
	static ErrorId RplLabelsGlobal;
	static ErrorId RplReplayUserrp;
	static ErrorId RplTrackBehind;
	static ErrorId RplTrackBehindInterval;
	static ErrorId RplVerifyCache;
	static ErrorId RplVerifyShared;
	static ErrorId RplPullArchivedepots;
	static ErrorId RunClientextsAllow;
	static ErrorId RunMoveAllow;
	static ErrorId RunObliterateAllow;
	static ErrorId RunPruneAllow;
	static ErrorId RunRenameclientAllow;
	static ErrorId RunUnzipUserAllow;
	static ErrorId RunUsersAuthorize;
	static ErrorId LbrS3UploadRetries;
	static ErrorId ServerCommandlimits;
	static ErrorId ServerCtrlcFilecleanup;
	static ErrorId ServerExtsAllowAdmin;
	static ErrorId ServerExtsAllowUnsigned;
	static ErrorId ServerFilecharset;
	static ErrorId ServerLocksArchive;
	static ErrorId ServerLocksSync;
	static ErrorId ServerLocksGlobal;
	static ErrorId ServerAllowfetch;
	static ErrorId ServerAllowpush;
	static ErrorId ServerAllowremotelocking;
	static ErrorId ServerAllowrewrite;
	static ErrorId ServerGlobalClientViews;
	static ErrorId ServerOomAdjScore;
	static ErrorId ServerMaxcommands;
	static ErrorId ServerMaxcommandsAllow;
	static ErrorId ServerStartUnlicensed;
	static ErrorId ServerStartupAutoRestart;
	static ErrorId FiletypeBypasslock;
	static ErrorId FiletypeMaxtextsize;
	static ErrorId SpecHashbuckets;
	static ErrorId SpecCustom;
	static ErrorId StreamviewDotsLow;
	static ErrorId StreamviewSortRemap;
	static ErrorId SubmitCollisioncheck;
	static ErrorId SubmitForcenoretransfer;
	static ErrorId SubmitNoretransfer;
	static ErrorId SubmitAllowbgtransfer;
	static ErrorId SubmitAutobgtransfer;
	static ErrorId SubmitUnlockLocked;
	static ErrorId SubmitStoragefields;
	static ErrorId TraitStoredepot;
	static ErrorId SwitchStreamUnrelated;
	static ErrorId PushUnlockLocked;
	static ErrorId SysMemoryPoolfree;
	static ErrorId SysMemoryProcfree;
	static ErrorId SysMemoryPoolgrowinc;
	static ErrorId SysMemoryProcgrowinc;
	static ErrorId SysMemorySubpools;
	static ErrorId SysMemoryLimit;
	static ErrorId SysMemoryDebug;
	static ErrorId CmdMemoryPoolfree;
	static ErrorId CmdMemoryProcfree;
	static ErrorId CmdMemoryLimit;
	static ErrorId CmdMemoryFlushpool;
	static ErrorId CmdMemoryListpools;
	static ErrorId CmdMemoryChkpt;
	static ErrorId SysMemoryMiShowerrors;
	static ErrorId SysMemoryMiShowstats;
	static ErrorId SysMemoryMiVerbose;
	static ErrorId SysMemoryMiEagercommit;
	// Reuse this entry because the message content has not changed.
	static ErrorId SysMemoryMiArenaeagercommit;
	// Reuse this entry because the message content has not changed.
	static ErrorId SysMemoryMiPurgedecommits;
	static ErrorId SysMemoryMiAllowlargeospages;
	static ErrorId SysMemoryMiReservehugeospages;
	static ErrorId SysMemoryMiReservehugeospagesat;
	static ErrorId SysMemoryMiReserveosmemory;
	static ErrorId SysMemoryMiSegmentcache;
	static ErrorId SysMemoryMiDeprecatedpagereset;
	static ErrorId SysMemoryMiAbandonedpagepurge;
	static ErrorId SysMemoryMiDeprecatedsegmentreset;
	static ErrorId SysMemoryMiEagercommitdelay;
	static ErrorId SysMemoryMiPurgeDelay;
	static ErrorId SysMemoryMiUsenumanodes;
	static ErrorId SysMemoryMiLimitosalloc;
	static ErrorId SysMemoryMiOstag;
	static ErrorId SysMemoryMiMaxerrors;
	static ErrorId SysMemoryMiMaxwarnings;
	static ErrorId SysMemoryMiMaxsegmentreclaim;
	static ErrorId SysMemoryMiDestroyonexit;
	static ErrorId SysMemoryMiArenareserve;
	static ErrorId SysMemoryMiArenapurgemult;
	// Deprecated
	static ErrorId SysMemoryMiAllowdecommit;
	// Deprecated
	static ErrorId SysMemoryMiSegmentdecommitdelay;
	static ErrorId SysMemoryMiPurgeextenddelay;
	static ErrorId SysMemoryStacksize;
	static ErrorId SysPressureMaxPauseTime;
	static ErrorId SysPressureMaxPaused;
	static ErrorId SysPressureMemHigh;
	static ErrorId SysPressureMemHighDuration;
	static ErrorId SysPressureMemMedium;
	static ErrorId SysPressureMemMediumDuration;
	static ErrorId SysPressureOsCpuHigh;
	static ErrorId SysPressureOsCpuHighDuration;
	static ErrorId SysPressureOsMemHigh;
	static ErrorId SysPressureOsMemHighDuration;
	static ErrorId SysPressureOsMemMedium;
	static ErrorId SysPressureOsMemMediumDuration;
	static ErrorId SysRenameMax;
	static ErrorId SysRenameWait;
	static ErrorId SysThreadingGroups;
	static ErrorId SysTypesAllow64;
	static ErrorId RplForwardAll;
	static ErrorId RplForwardLogin;
	static ErrorId RplPullPosition;
	static ErrorId RplPullReload;
	static ErrorId SslSecondarySuite;
	static ErrorId SslClientTimeout;
	static ErrorId SslClientTlsVersionMin;
	static ErrorId SslClientTlsVersionMax;
	static ErrorId SslClientTrustName;
	static ErrorId SslClientCertValidate;
	static ErrorId SslTlsVersionMin;
	static ErrorId SslTlsVersionMax;
	static ErrorId SslEnableEtm;
	static ErrorId SslHandshakeBlocking;
	static ErrorId TriggersIo;
	static ErrorId IstatMimicIchanges;
	static ErrorId InfoP4AuthUsercheck;
	static ErrorId AuthAutologinprompt;
	static ErrorId RplSubmitNocopy;
	static ErrorId Auth2FaPersist;
	static ErrorId AuthTicketsNounlocked;
	static ErrorId AuthLicenseexpiryWarn;
	static ErrorId AuthLicenseexpiryWarnthreshold;
	static ErrorId AuthSsoAllowPasswd;
	static ErrorId AuthSsoNonldap;
	static ErrorId ZlibCompressionLevel;
	static ErrorId ZlibDisableOptim;
	static ErrorId SysTypesTextStorageBehavior;

	// String tunables
	static ErrorId SecurityDigest;
	static ErrorId SSLClientCAPath;
	static ErrorId SslClientCipherList;
	static ErrorId SslClientCipherSuites;
	static ErrorId SslCipherList;
	static ErrorId SslCipherSuites;
	static ErrorId SSLKeylogFile;

	// Configurables
	static ErrorId P4ROOT;
	static ErrorId P4PORT;
	static ErrorId P4JOURNAL;
	static ErrorId P4NAME;
	static ErrorId P4DEBUG;
	static ErrorId P4DESCRIPTION;
	static ErrorId P4LOG;
	static ErrorId P4AUDIT;
	static ErrorId P4AUTH;
	static ErrorId P4CHANGE;
	static ErrorId P4TICKETS;
	static ErrorId P4TRUST;
	static ErrorId ServiceUser;
	static ErrorId Threadingmode;
	static ErrorId P4TARGET;
	static ErrorId Security;
	static ErrorId Unicode;
	static ErrorId Monitor;
	static ErrorId MinClient;
	static ErrorId MinClientMessage;
	static ErrorId NetMimcheck;
	static ErrorId StartupN;
	static ErrorId DbReplication;
	static ErrorId LbrReplication;
	static ErrorId Statefile;
	static ErrorId JournalPrefix;
	static ErrorId JournalPrefixBackup;
	static ErrorId FilesysP4ROOTMin;
	static ErrorId FilesysP4JOURNALMin;
	static ErrorId FilesysP4LOGMin;
	static ErrorId FilesysTEMPMin;
	static ErrorId FilesysDepotMin;
	static ErrorId ServerDepotRoot;
	static ErrorId ServerExtensionsDir;
	static ErrorId ServerLocksDir;
	static ErrorId ServerlogCounterN;
	static ErrorId ServerlogFileN;
	static ErrorId ServerlogEventsN;
	static ErrorId ServerlogFormatN;
	static ErrorId ServerlogMaxmbN;
	static ErrorId ServerlogNameN;
	static ErrorId ServerlogRetainN;
	static ErrorId ServerlogVersionN;
	static ErrorId ServerlogBufszN;
	static ErrorId ServerRolechecks;
	static ErrorId SubmitIdentity;
	static ErrorId TemplateClient;
	static ErrorId TemplateLabel;
	static ErrorId DefaultChangeType;
	static ErrorId ZerosyncPrefix;
	static ErrorId RejectList;
	static ErrorId ClusterId;
	static ErrorId P4UtilsDir;
	static ErrorId ZkHostPortPairs;
	static ErrorId P4zkLogFile;
	static ErrorId MonitorLsof;
	static ErrorId AuthDefaultMethod;
	static ErrorId AuthId;
	static ErrorId AuthLdapCafile;
	static ErrorId AuthLdapOrderN;
	static ErrorId AuthLdapSslciphers;
	static ErrorId AuthLdapPagesize;
	static ErrorId AuthLdapSsllevel;
	static ErrorId AuthLdapTimeout;
	static ErrorId AuthLdapUserautocreate;
	static ErrorId AuthSsoArgs;
	static ErrorId ZkConnectTimeout;
	static ErrorId ClientReadonlyDir;
	static ErrorId ClientSendqDir;
	static ErrorId ClientBackupInterval;
	static ErrorId IdleUnloadInterval;
	static ErrorId RtMonitorfile;
	static ErrorId PullTriggerDir;
	static ErrorId LbrScanIgnore;
	static ErrorId S3ErrorRetry;
	static ErrorId S3CredErrorRetry;
	static ErrorId LbrS3MultiPart;
	static ErrorId LbrS3MultiPartSz;
} ;
