#include <stdhdrs.h>

#include "i18napi.h"
#include "charcvt.h"

CharSetCvt::MapEnt
CharSetCvtCp950toUTF8::Cp950toUCS2[] = {
	{0xA140,	0x3000},	// IDEOGRAPHIC SPACE
	{0xA141,	0xFF0C},	// FULLWIDTH COMMA
	{0xA142,	0x3001},	// IDEOGRAPHIC COMMA
	{0xA143,	0x3002},	// IDEOGRAPHIC FULL STOP
	{0xA144,	0xFF0E},	// FULLWIDTH FULL STOP
	{0xA145,	0x2027},	// HYPHENATION POINT
	{0xA146,	0xFF1B},	// FULLWIDTH SEMICOLON
	{0xA147,	0xFF1A},	// FULLWIDTH COLON
	{0xA148,	0xFF1F},	// FULLWIDTH QUESTION MARK
	{0xA149,	0xFF01},	// FULLWIDTH EXCLAMATION MARK
	{0xA14A,	0xFE30},	// PRESENTATION FORM FOR VERTICAL TWO DOT LEADER
	{0xA14B,	0x2026},	// HORIZONTAL ELLIPSIS
	{0xA14C,	0x2025},	// TWO DOT LEADER
	{0xA14D,	0xFE50},	// SMALL COMMA
	{0xA14E,	0xFE51},	// SMALL IDEOGRAPHIC COMMA
	{0xA14F,	0xFE52},	// SMALL FULL STOP
	{0xA150,	0x00B7},	// MIDDLE DOT
	{0xA151,	0xFE54},	// SMALL SEMICOLON
	{0xA152,	0xFE55},	// SMALL COLON
	{0xA153,	0xFE56},	// SMALL QUESTION MARK
	{0xA154,	0xFE57},	// SMALL EXCLAMATION MARK
	{0xA155,	0xFF5C},	// FULLWIDTH VERTICAL LINE
	{0xA156,	0x2013},	// EN DASH
	{0xA157,	0xFE31},	// PRESENTATION FORM FOR VERTICAL EM DASH
	{0xA158,	0x2014},	// EM DASH
	{0xA159,	0xFE33},	// PRESENTATION FORM FOR VERTICAL LOW LINE
	{0xA15A,	0x2574},	// BOX DRAWINGS LIGHT LEFT
	{0xA15B,	0xFE34},	// PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
	{0xA15C,	0xFE4F},	// WAVY LOW LINE
	{0xA15D,	0xFF08},	// FULLWIDTH LEFT PARENTHESIS
	{0xA15E,	0xFF09},	// FULLWIDTH RIGHT PARENTHESIS
	{0xA15F,	0xFE35},	// PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS
	{0xA160,	0xFE36},	// PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS
	{0xA161,	0xFF5B},	// FULLWIDTH LEFT CURLY BRACKET
	{0xA162,	0xFF5D},	// FULLWIDTH RIGHT CURLY BRACKET
	{0xA163,	0xFE37},	// PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET
	{0xA164,	0xFE38},	// PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET
	{0xA165,	0x3014},	// LEFT TORTOISE SHELL BRACKET
	{0xA166,	0x3015},	// RIGHT TORTOISE SHELL BRACKET
	{0xA167,	0xFE39},	// PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET
	{0xA168,	0xFE3A},	// PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET
	{0xA169,	0x3010},	// LEFT BLACK LENTICULAR BRACKET
	{0xA16A,	0x3011},	// RIGHT BLACK LENTICULAR BRACKET
	{0xA16B,	0xFE3B},	// PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET
	{0xA16C,	0xFE3C},	// PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET
	{0xA16D,	0x300A},	// LEFT DOUBLE ANGLE BRACKET
	{0xA16E,	0x300B},	// RIGHT DOUBLE ANGLE BRACKET
	{0xA16F,	0xFE3D},	// PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET
	{0xA170,	0xFE3E},	// PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET
	{0xA171,	0x3008},	// LEFT ANGLE BRACKET
	{0xA172,	0x3009},	// RIGHT ANGLE BRACKET
	{0xA173,	0xFE3F},	// PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET
	{0xA174,	0xFE40},	// PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET
	{0xA175,	0x300C},	// LEFT CORNER BRACKET
	{0xA176,	0x300D},	// RIGHT CORNER BRACKET
	{0xA177,	0xFE41},	// PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET
	{0xA178,	0xFE42},	// PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET
	{0xA179,	0x300E},	// LEFT WHITE CORNER BRACKET
	{0xA17A,	0x300F},	// RIGHT WHITE CORNER BRACKET
	{0xA17B,	0xFE43},	// PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET
	{0xA17C,	0xFE44},	// PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET
	{0xA17D,	0xFE59},	// SMALL LEFT PARENTHESIS
	{0xA17E,	0xFE5A},	// SMALL RIGHT PARENTHESIS
	{0xA1A1,	0xFE5B},	// SMALL LEFT CURLY BRACKET
	{0xA1A2,	0xFE5C},	// SMALL RIGHT CURLY BRACKET
	{0xA1A3,	0xFE5D},	// SMALL LEFT TORTOISE SHELL BRACKET
	{0xA1A4,	0xFE5E},	// SMALL RIGHT TORTOISE SHELL BRACKET
	{0xA1A5,	0x2018},	// LEFT SINGLE QUOTATION MARK
	{0xA1A6,	0x2019},	// RIGHT SINGLE QUOTATION MARK
	{0xA1A7,	0x201C},	// LEFT DOUBLE QUOTATION MARK
	{0xA1A8,	0x201D},	// RIGHT DOUBLE QUOTATION MARK
	{0xA1A9,	0x301D},	// REVERSED DOUBLE PRIME QUOTATION MARK
	{0xA1AA,	0x301E},	// DOUBLE PRIME QUOTATION MARK
	{0xA1AB,	0x2035},	// REVERSED PRIME
	{0xA1AC,	0x2032},	// PRIME
	{0xA1AD,	0xFF03},	// FULLWIDTH NUMBER SIGN
	{0xA1AE,	0xFF06},	// FULLWIDTH AMPERSAND
	{0xA1AF,	0xFF0A},	// FULLWIDTH ASTERISK
	{0xA1B0,	0x203B},	// REFERENCE MARK
	{0xA1B1,	0x00A7},	// SECTION SIGN
	{0xA1B2,	0x3003},	// DITTO MARK
	{0xA1B3,	0x25CB},	// WHITE CIRCLE
	{0xA1B4,	0x25CF},	// BLACK CIRCLE
	{0xA1B5,	0x25B3},	// WHITE UP-POINTING TRIANGLE
	{0xA1B6,	0x25B2},	// BLACK UP-POINTING TRIANGLE
	{0xA1B7,	0x25CE},	// BULLSEYE
	{0xA1B8,	0x2606},	// WHITE STAR
	{0xA1B9,	0x2605},	// BLACK STAR
	{0xA1BA,	0x25C7},	// WHITE DIAMOND
	{0xA1BB,	0x25C6},	// BLACK DIAMOND
	{0xA1BC,	0x25A1},	// WHITE SQUARE
	{0xA1BD,	0x25A0},	// BLACK SQUARE
	{0xA1BE,	0x25BD},	// WHITE DOWN-POINTING TRIANGLE
	{0xA1BF,	0x25BC},	// BLACK DOWN-POINTING TRIANGLE
	{0xA1C0,	0x32A3},	// CIRCLED IDEOGRAPH CORRECT
	{0xA1C1,	0x2105},	// CARE OF
	{0xA1C2,	0x00AF},	// MACRON
	{0xA1C3,	0xFFE3},	// FULLWIDTH MACRON
	{0xA1C4,	0xFF3F},	// FULLWIDTH LOW LINE
	{0xA1C5,	0x02CD},	// MODIFIER LETTER LOW MACRON
	{0xA1C6,	0xFE49},	// DASHED OVERLINE
	{0xA1C7,	0xFE4A},	// CENTRELINE OVERLINE
	{0xA1C8,	0xFE4D},	// DASHED LOW LINE
	{0xA1C9,	0xFE4E},	// CENTRELINE LOW LINE
	{0xA1CA,	0xFE4B},	// WAVY OVERLINE
	{0xA1CB,	0xFE4C},	// DOUBLE WAVY OVERLINE
	{0xA1CC,	0xFE5F},	// SMALL NUMBER SIGN
	{0xA1CD,	0xFE60},	// SMALL AMPERSAND
	{0xA1CE,	0xFE61},	// SMALL ASTERISK
	{0xA1CF,	0xFF0B},	// FULLWIDTH PLUS SIGN
	{0xA1D0,	0xFF0D},	// FULLWIDTH HYPHEN-MINUS
	{0xA1D1,	0x00D7},	// MULTIPLICATION SIGN
	{0xA1D2,	0x00F7},	// DIVISION SIGN
	{0xA1D3,	0x00B1},	// PLUS-MINUS SIGN
	{0xA1D4,	0x221A},	// SQUARE ROOT
	{0xA1D5,	0xFF1C},	// FULLWIDTH LESS-THAN SIGN
	{0xA1D6,	0xFF1E},	// FULLWIDTH GREATER-THAN SIGN
	{0xA1D7,	0xFF1D},	// FULLWIDTH EQUALS SIGN
	{0xA1D8,	0x2266},	// LESS-THAN OVER EQUAL TO
	{0xA1D9,	0x2267},	// GREATER-THAN OVER EQUAL TO
	{0xA1DA,	0x2260},	// NOT EQUAL TO
	{0xA1DB,	0x221E},	// INFINITY
	{0xA1DC,	0x2252},	// APPROXIMATELY EQUAL TO OR THE IMAGE OF
	{0xA1DD,	0x2261},	// IDENTICAL TO
	{0xA1DE,	0xFE62},	// SMALL PLUS SIGN
	{0xA1DF,	0xFE63},	// SMALL HYPHEN-MINUS
	{0xA1E0,	0xFE64},	// SMALL LESS-THAN SIGN
	{0xA1E1,	0xFE65},	// SMALL GREATER-THAN SIGN
	{0xA1E2,	0xFE66},	// SMALL EQUALS SIGN
	{0xA1E3,	0xFF5E},	// FULLWIDTH TILDE
	{0xA1E4,	0x2229},	// INTERSECTION
	{0xA1E5,	0x222A},	// UNION
	{0xA1E6,	0x22A5},	// UP TACK
	{0xA1E7,	0x2220},	// ANGLE
	{0xA1E8,	0x221F},	// RIGHT ANGLE
	{0xA1E9,	0x22BF},	// RIGHT TRIANGLE
	{0xA1EA,	0x33D2},	// SQUARE LOG
	{0xA1EB,	0x33D1},	// SQUARE LN
	{0xA1EC,	0x222B},	// INTEGRAL
	{0xA1ED,	0x222E},	// CONTOUR INTEGRAL
	{0xA1EE,	0x2235},	// BECAUSE
	{0xA1EF,	0x2234},	// THEREFORE
	{0xA1F0,	0x2640},	// FEMALE SIGN
	{0xA1F1,	0x2642},	// MALE SIGN
	{0xA1F2,	0x2295},	// CIRCLED PLUS
	{0xA1F3,	0x2299},	// CIRCLED DOT OPERATOR
	{0xA1F4,	0x2191},	// UPWARDS ARROW
	{0xA1F5,	0x2193},	// DOWNWARDS ARROW
	{0xA1F6,	0x2190},	// LEFTWARDS ARROW
	{0xA1F7,	0x2192},	// RIGHTWARDS ARROW
	{0xA1F8,	0x2196},	// NORTH WEST ARROW
	{0xA1F9,	0x2197},	// NORTH EAST ARROW
	{0xA1FA,	0x2199},	// SOUTH WEST ARROW
	{0xA1FB,	0x2198},	// SOUTH EAST ARROW
	{0xA1FC,	0x2225},	// PARALLEL TO
	{0xA1FD,	0x2223},	// DIVIDES
	{0xA1FE,	0xFF0F},	// FULLWIDTH SOLIDUS
	{0xA240,	0xFF3C},	// FULLWIDTH REVERSE SOLIDUS
	{0xA241,	0x2215},	// DIVISION SLASH
	{0xA242,	0xFE68},	// SMALL REVERSE SOLIDUS
	{0xA243,	0xFF04},	// FULLWIDTH DOLLAR SIGN
	{0xA244,	0xFFE5},	// FULLWIDTH YEN SIGN
	{0xA245,	0x3012},	// POSTAL MARK
	{0xA246,	0xFFE0},	// FULLWIDTH CENT SIGN
	{0xA247,	0xFFE1},	// FULLWIDTH POUND SIGN
	{0xA248,	0xFF05},	// FULLWIDTH PERCENT SIGN
	{0xA249,	0xFF20},	// FULLWIDTH COMMERCIAL AT
	{0xA24A,	0x2103},	// DEGREE CELSIUS
	{0xA24B,	0x2109},	// DEGREE FAHRENHEIT
	{0xA24C,	0xFE69},	// SMALL DOLLAR SIGN
	{0xA24D,	0xFE6A},	// SMALL PERCENT SIGN
	{0xA24E,	0xFE6B},	// SMALL COMMERCIAL AT
	{0xA24F,	0x33D5},	// SQUARE MIL
	{0xA250,	0x339C},	// SQUARE MM
	{0xA251,	0x339D},	// SQUARE CM
	{0xA252,	0x339E},	// SQUARE KM
	{0xA253,	0x33CE},	// SQUARE KM CAPITAL
	{0xA254,	0x33A1},	// SQUARE M SQUARED
	{0xA255,	0x338E},	// SQUARE MG
	{0xA256,	0x338F},	// SQUARE KG
	{0xA257,	0x33C4},	// SQUARE CC
	{0xA258,	0x00B0},	// DEGREE SIGN
	{0xA259,	0x5159},	// CJK UNIFIED IDEOGRAPH
	{0xA25A,	0x515B},	// CJK UNIFIED IDEOGRAPH
	{0xA25B,	0x515E},	// CJK UNIFIED IDEOGRAPH
	{0xA25C,	0x515D},	// CJK UNIFIED IDEOGRAPH
	{0xA25D,	0x5161},	// CJK UNIFIED IDEOGRAPH
	{0xA25E,	0x5163},	// CJK UNIFIED IDEOGRAPH
	{0xA25F,	0x55E7},	// CJK UNIFIED IDEOGRAPH
	{0xA260,	0x74E9},	// CJK UNIFIED IDEOGRAPH
	{0xA261,	0x7CCE},	// CJK UNIFIED IDEOGRAPH
	{0xA262,	0x2581},	// LOWER ONE EIGHTH BLOCK
	{0xA263,	0x2582},	// LOWER ONE QUARTER BLOCK
	{0xA264,	0x2583},	// LOWER THREE EIGHTHS BLOCK
	{0xA265,	0x2584},	// LOWER HALF BLOCK
	{0xA266,	0x2585},	// LOWER FIVE EIGHTHS BLOCK
	{0xA267,	0x2586},	// LOWER THREE QUARTERS BLOCK
	{0xA268,	0x2587},	// LOWER SEVEN EIGHTHS BLOCK
	{0xA269,	0x2588},	// FULL BLOCK
	{0xA26A,	0x258F},	// LEFT ONE EIGHTH BLOCK
	{0xA26B,	0x258E},	// LEFT ONE QUARTER BLOCK
	{0xA26C,	0x258D},	// LEFT THREE EIGHTHS BLOCK
	{0xA26D,	0x258C},	// LEFT HALF BLOCK
	{0xA26E,	0x258B},	// LEFT FIVE EIGHTHS BLOCK
	{0xA26F,	0x258A},	// LEFT THREE QUARTERS BLOCK
	{0xA270,	0x2589},	// LEFT SEVEN EIGHTHS BLOCK
	{0xA271,	0x253C},	// BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
	{0xA272,	0x2534},	// BOX DRAWINGS LIGHT UP AND HORIZONTAL
	{0xA273,	0x252C},	// BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
	{0xA274,	0x2524},	// BOX DRAWINGS LIGHT VERTICAL AND LEFT
	{0xA275,	0x251C},	// BOX DRAWINGS LIGHT VERTICAL AND RIGHT
	{0xA276,	0x2594},	// UPPER ONE EIGHTH BLOCK
	{0xA277,	0x2500},	// BOX DRAWINGS LIGHT HORIZONTAL
	{0xA278,	0x2502},	// BOX DRAWINGS LIGHT VERTICAL
	{0xA279,	0x2595},	// RIGHT ONE EIGHTH BLOCK
	{0xA27A,	0x250C},	// BOX DRAWINGS LIGHT DOWN AND RIGHT
	{0xA27B,	0x2510},	// BOX DRAWINGS LIGHT DOWN AND LEFT
	{0xA27C,	0x2514},	// BOX DRAWINGS LIGHT UP AND RIGHT
	{0xA27D,	0x2518},	// BOX DRAWINGS LIGHT UP AND LEFT
	{0xA27E,	0x256D},	// BOX DRAWINGS LIGHT ARC DOWN AND RIGHT
	{0xA2A1,	0x256E},	// BOX DRAWINGS LIGHT ARC DOWN AND LEFT
	{0xA2A2,	0x2570},	// BOX DRAWINGS LIGHT ARC UP AND RIGHT
	{0xA2A3,	0x256F},	// BOX DRAWINGS LIGHT ARC UP AND LEFT
	{0xA2A4,	0x2550},	// BOX DRAWINGS DOUBLE HORIZONTAL
	{0xA2A5,	0x255E},	// BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE
	{0xA2A6,	0x256A},	// BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE
	{0xA2A7,	0x2561},	// BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE
	{0xA2A8,	0x25E2},	// BLACK LOWER RIGHT TRIANGLE
	{0xA2A9,	0x25E3},	// BLACK LOWER LEFT TRIANGLE
	{0xA2AA,	0x25E5},	// BLACK UPPER RIGHT TRIANGLE
	{0xA2AB,	0x25E4},	// BLACK UPPER LEFT TRIANGLE
	{0xA2AC,	0x2571},	// BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT
	{0xA2AD,	0x2572},	// BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT
	{0xA2AE,	0x2573},	// BOX DRAWINGS LIGHT DIAGONAL CROSS
	{0xA2AF,	0xFF10},	// FULLWIDTH DIGIT ZERO
	{0xA2B0,	0xFF11},	// FULLWIDTH DIGIT ONE
	{0xA2B1,	0xFF12},	// FULLWIDTH DIGIT TWO
	{0xA2B2,	0xFF13},	// FULLWIDTH DIGIT THREE
	{0xA2B3,	0xFF14},	// FULLWIDTH DIGIT FOUR
	{0xA2B4,	0xFF15},	// FULLWIDTH DIGIT FIVE
	{0xA2B5,	0xFF16},	// FULLWIDTH DIGIT SIX
	{0xA2B6,	0xFF17},	// FULLWIDTH DIGIT SEVEN
	{0xA2B7,	0xFF18},	// FULLWIDTH DIGIT EIGHT
	{0xA2B8,	0xFF19},	// FULLWIDTH DIGIT NINE
	{0xA2B9,	0x2160},	// ROMAN NUMERAL ONE
	{0xA2BA,	0x2161},	// ROMAN NUMERAL TWO
	{0xA2BB,	0x2162},	// ROMAN NUMERAL THREE
	{0xA2BC,	0x2163},	// ROMAN NUMERAL FOUR
	{0xA2BD,	0x2164},	// ROMAN NUMERAL FIVE
	{0xA2BE,	0x2165},	// ROMAN NUMERAL SIX
	{0xA2BF,	0x2166},	// ROMAN NUMERAL SEVEN
	{0xA2C0,	0x2167},	// ROMAN NUMERAL EIGHT
	{0xA2C1,	0x2168},	// ROMAN NUMERAL NINE
	{0xA2C2,	0x2169},	// ROMAN NUMERAL TEN
	{0xA2C3,	0x3021},	// HANGZHOU NUMERAL ONE
	{0xA2C4,	0x3022},	// HANGZHOU NUMERAL TWO
	{0xA2C5,	0x3023},	// HANGZHOU NUMERAL THREE
	{0xA2C6,	0x3024},	// HANGZHOU NUMERAL FOUR
	{0xA2C7,	0x3025},	// HANGZHOU NUMERAL FIVE
	{0xA2C8,	0x3026},	// HANGZHOU NUMERAL SIX
	{0xA2C9,	0x3027},	// HANGZHOU NUMERAL SEVEN
	{0xA2CA,	0x3028},	// HANGZHOU NUMERAL EIGHT
	{0xA2CB,	0x3029},	// HANGZHOU NUMERAL NINE
	{0xA2CC,	0x5341},	// CJK UNIFIED IDEOGRAPH
	{0xA2CD,	0x5344},	// CJK UNIFIED IDEOGRAPH
	{0xA2CE,	0x5345},	// CJK UNIFIED IDEOGRAPH
	{0xA2CF,	0xFF21},	// FULLWIDTH LATIN CAPITAL LETTER A
	{0xA2D0,	0xFF22},	// FULLWIDTH LATIN CAPITAL LETTER B
	{0xA2D1,	0xFF23},	// FULLWIDTH LATIN CAPITAL LETTER C
	{0xA2D2,	0xFF24},	// FULLWIDTH LATIN CAPITAL LETTER D
	{0xA2D3,	0xFF25},	// FULLWIDTH LATIN CAPITAL LETTER E
	{0xA2D4,	0xFF26},	// FULLWIDTH LATIN CAPITAL LETTER F
	{0xA2D5,	0xFF27},	// FULLWIDTH LATIN CAPITAL LETTER G
	{0xA2D6,	0xFF28},	// FULLWIDTH LATIN CAPITAL LETTER H
	{0xA2D7,	0xFF29},	// FULLWIDTH LATIN CAPITAL LETTER I
	{0xA2D8,	0xFF2A},	// FULLWIDTH LATIN CAPITAL LETTER J
	{0xA2D9,	0xFF2B},	// FULLWIDTH LATIN CAPITAL LETTER K
	{0xA2DA,	0xFF2C},	// FULLWIDTH LATIN CAPITAL LETTER L
	{0xA2DB,	0xFF2D},	// FULLWIDTH LATIN CAPITAL LETTER M
	{0xA2DC,	0xFF2E},	// FULLWIDTH LATIN CAPITAL LETTER N
	{0xA2DD,	0xFF2F},	// FULLWIDTH LATIN CAPITAL LETTER O
	{0xA2DE,	0xFF30},	// FULLWIDTH LATIN CAPITAL LETTER P
	{0xA2DF,	0xFF31},	// FULLWIDTH LATIN CAPITAL LETTER Q
	{0xA2E0,	0xFF32},	// FULLWIDTH LATIN CAPITAL LETTER R
	{0xA2E1,	0xFF33},	// FULLWIDTH LATIN CAPITAL LETTER S
	{0xA2E2,	0xFF34},	// FULLWIDTH LATIN CAPITAL LETTER T
	{0xA2E3,	0xFF35},	// FULLWIDTH LATIN CAPITAL LETTER U
	{0xA2E4,	0xFF36},	// FULLWIDTH LATIN CAPITAL LETTER V
	{0xA2E5,	0xFF37},	// FULLWIDTH LATIN CAPITAL LETTER W
	{0xA2E6,	0xFF38},	// FULLWIDTH LATIN CAPITAL LETTER X
	{0xA2E7,	0xFF39},	// FULLWIDTH LATIN CAPITAL LETTER Y
	{0xA2E8,	0xFF3A},	// FULLWIDTH LATIN CAPITAL LETTER Z
	{0xA2E9,	0xFF41},	// FULLWIDTH LATIN SMALL LETTER A
	{0xA2EA,	0xFF42},	// FULLWIDTH LATIN SMALL LETTER B
	{0xA2EB,	0xFF43},	// FULLWIDTH LATIN SMALL LETTER C
	{0xA2EC,	0xFF44},	// FULLWIDTH LATIN SMALL LETTER D
	{0xA2ED,	0xFF45},	// FULLWIDTH LATIN SMALL LETTER E
	{0xA2EE,	0xFF46},	// FULLWIDTH LATIN SMALL LETTER F
	{0xA2EF,	0xFF47},	// FULLWIDTH LATIN SMALL LETTER G
	{0xA2F0,	0xFF48},	// FULLWIDTH LATIN SMALL LETTER H
	{0xA2F1,	0xFF49},	// FULLWIDTH LATIN SMALL LETTER I
	{0xA2F2,	0xFF4A},	// FULLWIDTH LATIN SMALL LETTER J
	{0xA2F3,	0xFF4B},	// FULLWIDTH LATIN SMALL LETTER K
	{0xA2F4,	0xFF4C},	// FULLWIDTH LATIN SMALL LETTER L
	{0xA2F5,	0xFF4D},	// FULLWIDTH LATIN SMALL LETTER M
	{0xA2F6,	0xFF4E},	// FULLWIDTH LATIN SMALL LETTER N
	{0xA2F7,	0xFF4F},	// FULLWIDTH LATIN SMALL LETTER O
	{0xA2F8,	0xFF50},	// FULLWIDTH LATIN SMALL LETTER P
	{0xA2F9,	0xFF51},	// FULLWIDTH LATIN SMALL LETTER Q
	{0xA2FA,	0xFF52},	// FULLWIDTH LATIN SMALL LETTER R
	{0xA2FB,	0xFF53},	// FULLWIDTH LATIN SMALL LETTER S
	{0xA2FC,	0xFF54},	// FULLWIDTH LATIN SMALL LETTER T
	{0xA2FD,	0xFF55},	// FULLWIDTH LATIN SMALL LETTER U
	{0xA2FE,	0xFF56},	// FULLWIDTH LATIN SMALL LETTER V
	{0xA340,	0xFF57},	// FULLWIDTH LATIN SMALL LETTER W
	{0xA341,	0xFF58},	// FULLWIDTH LATIN SMALL LETTER X
	{0xA342,	0xFF59},	// FULLWIDTH LATIN SMALL LETTER Y
	{0xA343,	0xFF5A},	// FULLWIDTH LATIN SMALL LETTER Z
	{0xA344,	0x0391},	// GREEK CAPITAL LETTER ALPHA
	{0xA345,	0x0392},	// GREEK CAPITAL LETTER BETA
	{0xA346,	0x0393},	// GREEK CAPITAL LETTER GAMMA
	{0xA347,	0x0394},	// GREEK CAPITAL LETTER DELTA
	{0xA348,	0x0395},	// GREEK CAPITAL LETTER EPSILON
	{0xA349,	0x0396},	// GREEK CAPITAL LETTER ZETA
	{0xA34A,	0x0397},	// GREEK CAPITAL LETTER ETA
	{0xA34B,	0x0398},	// GREEK CAPITAL LETTER THETA
	{0xA34C,	0x0399},	// GREEK CAPITAL LETTER IOTA
	{0xA34D,	0x039A},	// GREEK CAPITAL LETTER KAPPA
	{0xA34E,	0x039B},	// GREEK CAPITAL LETTER LAMDA
	{0xA34F,	0x039C},	// GREEK CAPITAL LETTER MU
	{0xA350,	0x039D},	// GREEK CAPITAL LETTER NU
	{0xA351,	0x039E},	// GREEK CAPITAL LETTER XI
	{0xA352,	0x039F},	// GREEK CAPITAL LETTER OMICRON
	{0xA353,	0x03A0},	// GREEK CAPITAL LETTER PI
	{0xA354,	0x03A1},	// GREEK CAPITAL LETTER RHO
	{0xA355,	0x03A3},	// GREEK CAPITAL LETTER SIGMA
	{0xA356,	0x03A4},	// GREEK CAPITAL LETTER TAU
	{0xA357,	0x03A5},	// GREEK CAPITAL LETTER UPSILON
	{0xA358,	0x03A6},	// GREEK CAPITAL LETTER PHI
	{0xA359,	0x03A7},	// GREEK CAPITAL LETTER CHI
	{0xA35A,	0x03A8},	// GREEK CAPITAL LETTER PSI
	{0xA35B,	0x03A9},	// GREEK CAPITAL LETTER OMEGA
	{0xA35C,	0x03B1},	// GREEK SMALL LETTER ALPHA
	{0xA35D,	0x03B2},	// GREEK SMALL LETTER BETA
	{0xA35E,	0x03B3},	// GREEK SMALL LETTER GAMMA
	{0xA35F,	0x03B4},	// GREEK SMALL LETTER DELTA
	{0xA360,	0x03B5},	// GREEK SMALL LETTER EPSILON
	{0xA361,	0x03B6},	// GREEK SMALL LETTER ZETA
	{0xA362,	0x03B7},	// GREEK SMALL LETTER ETA
	{0xA363,	0x03B8},	// GREEK SMALL LETTER THETA
	{0xA364,	0x03B9},	// GREEK SMALL LETTER IOTA
	{0xA365,	0x03BA},	// GREEK SMALL LETTER KAPPA
	{0xA366,	0x03BB},	// GREEK SMALL LETTER LAMDA
	{0xA367,	0x03BC},	// GREEK SMALL LETTER MU
	{0xA368,	0x03BD},	// GREEK SMALL LETTER NU
	{0xA369,	0x03BE},	// GREEK SMALL LETTER XI
	{0xA36A,	0x03BF},	// GREEK SMALL LETTER OMICRON
	{0xA36B,	0x03C0},	// GREEK SMALL LETTER PI
	{0xA36C,	0x03C1},	// GREEK SMALL LETTER RHO
	{0xA36D,	0x03C3},	// GREEK SMALL LETTER SIGMA
	{0xA36E,	0x03C4},	// GREEK SMALL LETTER TAU
	{0xA36F,	0x03C5},	// GREEK SMALL LETTER UPSILON
	{0xA370,	0x03C6},	// GREEK SMALL LETTER PHI
	{0xA371,	0x03C7},	// GREEK SMALL LETTER CHI
	{0xA372,	0x03C8},	// GREEK SMALL LETTER PSI
	{0xA373,	0x03C9},	// GREEK SMALL LETTER OMEGA
	{0xA374,	0x3105},	// BOPOMOFO LETTER B
	{0xA375,	0x3106},	// BOPOMOFO LETTER P
	{0xA376,	0x3107},	// BOPOMOFO LETTER M
	{0xA377,	0x3108},	// BOPOMOFO LETTER F
	{0xA378,	0x3109},	// BOPOMOFO LETTER D
	{0xA379,	0x310A},	// BOPOMOFO LETTER T
	{0xA37A,	0x310B},	// BOPOMOFO LETTER N
	{0xA37B,	0x310C},	// BOPOMOFO LETTER L
	{0xA37C,	0x310D},	// BOPOMOFO LETTER G
	{0xA37D,	0x310E},	// BOPOMOFO LETTER K
	{0xA37E,	0x310F},	// BOPOMOFO LETTER H
	{0xA3A1,	0x3110},	// BOPOMOFO LETTER J
	{0xA3A2,	0x3111},	// BOPOMOFO LETTER Q
	{0xA3A3,	0x3112},	// BOPOMOFO LETTER X
	{0xA3A4,	0x3113},	// BOPOMOFO LETTER ZH
	{0xA3A5,	0x3114},	// BOPOMOFO LETTER CH
	{0xA3A6,	0x3115},	// BOPOMOFO LETTER SH
	{0xA3A7,	0x3116},	// BOPOMOFO LETTER R
	{0xA3A8,	0x3117},	// BOPOMOFO LETTER Z
	{0xA3A9,	0x3118},	// BOPOMOFO LETTER C
	{0xA3AA,	0x3119},	// BOPOMOFO LETTER S
	{0xA3AB,	0x311A},	// BOPOMOFO LETTER A
	{0xA3AC,	0x311B},	// BOPOMOFO LETTER O
	{0xA3AD,	0x311C},	// BOPOMOFO LETTER E
	{0xA3AE,	0x311D},	// BOPOMOFO LETTER EH
	{0xA3AF,	0x311E},	// BOPOMOFO LETTER AI
	{0xA3B0,	0x311F},	// BOPOMOFO LETTER EI
	{0xA3B1,	0x3120},	// BOPOMOFO LETTER AU
	{0xA3B2,	0x3121},	// BOPOMOFO LETTER OU
	{0xA3B3,	0x3122},	// BOPOMOFO LETTER AN
	{0xA3B4,	0x3123},	// BOPOMOFO LETTER EN
	{0xA3B5,	0x3124},	// BOPOMOFO LETTER ANG
	{0xA3B6,	0x3125},	// BOPOMOFO LETTER ENG
	{0xA3B7,	0x3126},	// BOPOMOFO LETTER ER
	{0xA3B8,	0x3127},	// BOPOMOFO LETTER I
	{0xA3B9,	0x3128},	// BOPOMOFO LETTER U
	{0xA3BA,	0x3129},	// BOPOMOFO LETTER IU
	{0xA3BB,	0x02D9},	// DOT ABOVE
	{0xA3BC,	0x02C9},	// MODIFIER LETTER MACRON
	{0xA3BD,	0x02CA},	// MODIFIER LETTER ACUTE ACCENT
	{0xA3BE,	0x02C7},	// CARON
	{0xA3BF,	0x02CB},	// MODIFIER LETTER GRAVE ACCENT
	{0xA3E1,	0x20AC},	// EURO SIGN
	{0xA440,	0x4E00},	// CJK UNIFIED IDEOGRAPH
	{0xA441,	0x4E59},	// CJK UNIFIED IDEOGRAPH
	{0xA442,	0x4E01},	// CJK UNIFIED IDEOGRAPH
	{0xA443,	0x4E03},	// CJK UNIFIED IDEOGRAPH
	{0xA444,	0x4E43},	// CJK UNIFIED IDEOGRAPH
	{0xA445,	0x4E5D},	// CJK UNIFIED IDEOGRAPH
	{0xA446,	0x4E86},	// CJK UNIFIED IDEOGRAPH
	{0xA447,	0x4E8C},	// CJK UNIFIED IDEOGRAPH
	{0xA448,	0x4EBA},	// CJK UNIFIED IDEOGRAPH
	{0xA449,	0x513F},	// CJK UNIFIED IDEOGRAPH
	{0xA44A,	0x5165},	// CJK UNIFIED IDEOGRAPH
	{0xA44B,	0x516B},	// CJK UNIFIED IDEOGRAPH
	{0xA44C,	0x51E0},	// CJK UNIFIED IDEOGRAPH
	{0xA44D,	0x5200},	// CJK UNIFIED IDEOGRAPH
	{0xA44E,	0x5201},	// CJK UNIFIED IDEOGRAPH
	{0xA44F,	0x529B},	// CJK UNIFIED IDEOGRAPH
	{0xA450,	0x5315},	// CJK UNIFIED IDEOGRAPH
	{0xA451,	0x5341},	// CJK UNIFIED IDEOGRAPH
	{0xA452,	0x535C},	// CJK UNIFIED IDEOGRAPH
	{0xA453,	0x53C8},	// CJK UNIFIED IDEOGRAPH
	{0xA454,	0x4E09},	// CJK UNIFIED IDEOGRAPH
	{0xA455,	0x4E0B},	// CJK UNIFIED IDEOGRAPH
	{0xA456,	0x4E08},	// CJK UNIFIED IDEOGRAPH
	{0xA457,	0x4E0A},	// CJK UNIFIED IDEOGRAPH
	{0xA458,	0x4E2B},	// CJK UNIFIED IDEOGRAPH
	{0xA459,	0x4E38},	// CJK UNIFIED IDEOGRAPH
	{0xA45A,	0x51E1},	// CJK UNIFIED IDEOGRAPH
	{0xA45B,	0x4E45},	// CJK UNIFIED IDEOGRAPH
	{0xA45C,	0x4E48},	// CJK UNIFIED IDEOGRAPH
	{0xA45D,	0x4E5F},	// CJK UNIFIED IDEOGRAPH
	{0xA45E,	0x4E5E},	// CJK UNIFIED IDEOGRAPH
	{0xA45F,	0x4E8E},	// CJK UNIFIED IDEOGRAPH
	{0xA460,	0x4EA1},	// CJK UNIFIED IDEOGRAPH
	{0xA461,	0x5140},	// CJK UNIFIED IDEOGRAPH
	{0xA462,	0x5203},	// CJK UNIFIED IDEOGRAPH
	{0xA463,	0x52FA},	// CJK UNIFIED IDEOGRAPH
	{0xA464,	0x5343},	// CJK UNIFIED IDEOGRAPH
	{0xA465,	0x53C9},	// CJK UNIFIED IDEOGRAPH
	{0xA466,	0x53E3},	// CJK UNIFIED IDEOGRAPH
	{0xA467,	0x571F},	// CJK UNIFIED IDEOGRAPH
	{0xA468,	0x58EB},	// CJK UNIFIED IDEOGRAPH
	{0xA469,	0x5915},	// CJK UNIFIED IDEOGRAPH
	{0xA46A,	0x5927},	// CJK UNIFIED IDEOGRAPH
	{0xA46B,	0x5973},	// CJK UNIFIED IDEOGRAPH
	{0xA46C,	0x5B50},	// CJK UNIFIED IDEOGRAPH
	{0xA46D,	0x5B51},	// CJK UNIFIED IDEOGRAPH
	{0xA46E,	0x5B53},	// CJK UNIFIED IDEOGRAPH
	{0xA46F,	0x5BF8},	// CJK UNIFIED IDEOGRAPH
	{0xA470,	0x5C0F},	// CJK UNIFIED IDEOGRAPH
	{0xA471,	0x5C22},	// CJK UNIFIED IDEOGRAPH
	{0xA472,	0x5C38},	// CJK UNIFIED IDEOGRAPH
	{0xA473,	0x5C71},	// CJK UNIFIED IDEOGRAPH
	{0xA474,	0x5DDD},	// CJK UNIFIED IDEOGRAPH
	{0xA475,	0x5DE5},	// CJK UNIFIED IDEOGRAPH
	{0xA476,	0x5DF1},	// CJK UNIFIED IDEOGRAPH
	{0xA477,	0x5DF2},	// CJK UNIFIED IDEOGRAPH
	{0xA478,	0x5DF3},	// CJK UNIFIED IDEOGRAPH
	{0xA479,	0x5DFE},	// CJK UNIFIED IDEOGRAPH
	{0xA47A,	0x5E72},	// CJK UNIFIED IDEOGRAPH
	{0xA47B,	0x5EFE},	// CJK UNIFIED IDEOGRAPH
	{0xA47C,	0x5F0B},	// CJK UNIFIED IDEOGRAPH
	{0xA47D,	0x5F13},	// CJK UNIFIED IDEOGRAPH
	{0xA47E,	0x624D},	// CJK UNIFIED IDEOGRAPH
	{0xA4A1,	0x4E11},	// CJK UNIFIED IDEOGRAPH
	{0xA4A2,	0x4E10},	// CJK UNIFIED IDEOGRAPH
	{0xA4A3,	0x4E0D},	// CJK UNIFIED IDEOGRAPH
	{0xA4A4,	0x4E2D},	// CJK UNIFIED IDEOGRAPH
	{0xA4A5,	0x4E30},	// CJK UNIFIED IDEOGRAPH
	{0xA4A6,	0x4E39},	// CJK UNIFIED IDEOGRAPH
	{0xA4A7,	0x4E4B},	// CJK UNIFIED IDEOGRAPH
	{0xA4A8,	0x5C39},	// CJK UNIFIED IDEOGRAPH
	{0xA4A9,	0x4E88},	// CJK UNIFIED IDEOGRAPH
	{0xA4AA,	0x4E91},	// CJK UNIFIED IDEOGRAPH
	{0xA4AB,	0x4E95},	// CJK UNIFIED IDEOGRAPH
	{0xA4AC,	0x4E92},	// CJK UNIFIED IDEOGRAPH
	{0xA4AD,	0x4E94},	// CJK UNIFIED IDEOGRAPH
	{0xA4AE,	0x4EA2},	// CJK UNIFIED IDEOGRAPH
	{0xA4AF,	0x4EC1},	// CJK UNIFIED IDEOGRAPH
	{0xA4B0,	0x4EC0},	// CJK UNIFIED IDEOGRAPH
	{0xA4B1,	0x4EC3},	// CJK UNIFIED IDEOGRAPH
	{0xA4B2,	0x4EC6},	// CJK UNIFIED IDEOGRAPH
	{0xA4B3,	0x4EC7},	// CJK UNIFIED IDEOGRAPH
	{0xA4B4,	0x4ECD},	// CJK UNIFIED IDEOGRAPH
	{0xA4B5,	0x4ECA},	// CJK UNIFIED IDEOGRAPH
	{0xA4B6,	0x4ECB},	// CJK UNIFIED IDEOGRAPH
	{0xA4B7,	0x4EC4},	// CJK UNIFIED IDEOGRAPH
	{0xA4B8,	0x5143},	// CJK UNIFIED IDEOGRAPH
	{0xA4B9,	0x5141},	// CJK UNIFIED IDEOGRAPH
	{0xA4BA,	0x5167},	// CJK UNIFIED IDEOGRAPH
	{0xA4BB,	0x516D},	// CJK UNIFIED IDEOGRAPH
	{0xA4BC,	0x516E},	// CJK UNIFIED IDEOGRAPH
	{0xA4BD,	0x516C},	// CJK UNIFIED IDEOGRAPH
	{0xA4BE,	0x5197},	// CJK UNIFIED IDEOGRAPH
	{0xA4BF,	0x51F6},	// CJK UNIFIED IDEOGRAPH
	{0xA4C0,	0x5206},	// CJK UNIFIED IDEOGRAPH
	{0xA4C1,	0x5207},	// CJK UNIFIED IDEOGRAPH
	{0xA4C2,	0x5208},	// CJK UNIFIED IDEOGRAPH
	{0xA4C3,	0x52FB},	// CJK UNIFIED IDEOGRAPH
	{0xA4C4,	0x52FE},	// CJK UNIFIED IDEOGRAPH
	{0xA4C5,	0x52FF},	// CJK UNIFIED IDEOGRAPH
	{0xA4C6,	0x5316},	// CJK UNIFIED IDEOGRAPH
	{0xA4C7,	0x5339},	// CJK UNIFIED IDEOGRAPH
	{0xA4C8,	0x5348},	// CJK UNIFIED IDEOGRAPH
	{0xA4C9,	0x5347},	// CJK UNIFIED IDEOGRAPH
	{0xA4CA,	0x5345},	// CJK UNIFIED IDEOGRAPH
	{0xA4CB,	0x535E},	// CJK UNIFIED IDEOGRAPH
	{0xA4CC,	0x5384},	// CJK UNIFIED IDEOGRAPH
	{0xA4CD,	0x53CB},	// CJK UNIFIED IDEOGRAPH
	{0xA4CE,	0x53CA},	// CJK UNIFIED IDEOGRAPH
	{0xA4CF,	0x53CD},	// CJK UNIFIED IDEOGRAPH
	{0xA4D0,	0x58EC},	// CJK UNIFIED IDEOGRAPH
	{0xA4D1,	0x5929},	// CJK UNIFIED IDEOGRAPH
	{0xA4D2,	0x592B},	// CJK UNIFIED IDEOGRAPH
	{0xA4D3,	0x592A},	// CJK UNIFIED IDEOGRAPH
	{0xA4D4,	0x592D},	// CJK UNIFIED IDEOGRAPH
	{0xA4D5,	0x5B54},	// CJK UNIFIED IDEOGRAPH
	{0xA4D6,	0x5C11},	// CJK UNIFIED IDEOGRAPH
	{0xA4D7,	0x5C24},	// CJK UNIFIED IDEOGRAPH
	{0xA4D8,	0x5C3A},	// CJK UNIFIED IDEOGRAPH
	{0xA4D9,	0x5C6F},	// CJK UNIFIED IDEOGRAPH
	{0xA4DA,	0x5DF4},	// CJK UNIFIED IDEOGRAPH
	{0xA4DB,	0x5E7B},	// CJK UNIFIED IDEOGRAPH
	{0xA4DC,	0x5EFF},	// CJK UNIFIED IDEOGRAPH
	{0xA4DD,	0x5F14},	// CJK UNIFIED IDEOGRAPH
	{0xA4DE,	0x5F15},	// CJK UNIFIED IDEOGRAPH
	{0xA4DF,	0x5FC3},	// CJK UNIFIED IDEOGRAPH
	{0xA4E0,	0x6208},	// CJK UNIFIED IDEOGRAPH
	{0xA4E1,	0x6236},	// CJK UNIFIED IDEOGRAPH
	{0xA4E2,	0x624B},	// CJK UNIFIED IDEOGRAPH
	{0xA4E3,	0x624E},	// CJK UNIFIED IDEOGRAPH
	{0xA4E4,	0x652F},	// CJK UNIFIED IDEOGRAPH
	{0xA4E5,	0x6587},	// CJK UNIFIED IDEOGRAPH
	{0xA4E6,	0x6597},	// CJK UNIFIED IDEOGRAPH
	{0xA4E7,	0x65A4},	// CJK UNIFIED IDEOGRAPH
	{0xA4E8,	0x65B9},	// CJK UNIFIED IDEOGRAPH
	{0xA4E9,	0x65E5},	// CJK UNIFIED IDEOGRAPH
	{0xA4EA,	0x66F0},	// CJK UNIFIED IDEOGRAPH
	{0xA4EB,	0x6708},	// CJK UNIFIED IDEOGRAPH
	{0xA4EC,	0x6728},	// CJK UNIFIED IDEOGRAPH
	{0xA4ED,	0x6B20},	// CJK UNIFIED IDEOGRAPH
	{0xA4EE,	0x6B62},	// CJK UNIFIED IDEOGRAPH
	{0xA4EF,	0x6B79},	// CJK UNIFIED IDEOGRAPH
	{0xA4F0,	0x6BCB},	// CJK UNIFIED IDEOGRAPH
	{0xA4F1,	0x6BD4},	// CJK UNIFIED IDEOGRAPH
	{0xA4F2,	0x6BDB},	// CJK UNIFIED IDEOGRAPH
	{0xA4F3,	0x6C0F},	// CJK UNIFIED IDEOGRAPH
	{0xA4F4,	0x6C34},	// CJK UNIFIED IDEOGRAPH
	{0xA4F5,	0x706B},	// CJK UNIFIED IDEOGRAPH
	{0xA4F6,	0x722A},	// CJK UNIFIED IDEOGRAPH
	{0xA4F7,	0x7236},	// CJK UNIFIED IDEOGRAPH
	{0xA4F8,	0x723B},	// CJK UNIFIED IDEOGRAPH
	{0xA4F9,	0x7247},	// CJK UNIFIED IDEOGRAPH
	{0xA4FA,	0x7259},	// CJK UNIFIED IDEOGRAPH
	{0xA4FB,	0x725B},	// CJK UNIFIED IDEOGRAPH
	{0xA4FC,	0x72AC},	// CJK UNIFIED IDEOGRAPH
	{0xA4FD,	0x738B},	// CJK UNIFIED IDEOGRAPH
	{0xA4FE,	0x4E19},	// CJK UNIFIED IDEOGRAPH
	{0xA540,	0x4E16},	// CJK UNIFIED IDEOGRAPH
	{0xA541,	0x4E15},	// CJK UNIFIED IDEOGRAPH
	{0xA542,	0x4E14},	// CJK UNIFIED IDEOGRAPH
	{0xA543,	0x4E18},	// CJK UNIFIED IDEOGRAPH
	{0xA544,	0x4E3B},	// CJK UNIFIED IDEOGRAPH
	{0xA545,	0x4E4D},	// CJK UNIFIED IDEOGRAPH
	{0xA546,	0x4E4F},	// CJK UNIFIED IDEOGRAPH
	{0xA547,	0x4E4E},	// CJK UNIFIED IDEOGRAPH
	{0xA548,	0x4EE5},	// CJK UNIFIED IDEOGRAPH
	{0xA549,	0x4ED8},	// CJK UNIFIED IDEOGRAPH
	{0xA54A,	0x4ED4},	// CJK UNIFIED IDEOGRAPH
	{0xA54B,	0x4ED5},	// CJK UNIFIED IDEOGRAPH
	{0xA54C,	0x4ED6},	// CJK UNIFIED IDEOGRAPH
	{0xA54D,	0x4ED7},	// CJK UNIFIED IDEOGRAPH
	{0xA54E,	0x4EE3},	// CJK UNIFIED IDEOGRAPH
	{0xA54F,	0x4EE4},	// CJK UNIFIED IDEOGRAPH
	{0xA550,	0x4ED9},	// CJK UNIFIED IDEOGRAPH
	{0xA551,	0x4EDE},	// CJK UNIFIED IDEOGRAPH
	{0xA552,	0x5145},	// CJK UNIFIED IDEOGRAPH
	{0xA553,	0x5144},	// CJK UNIFIED IDEOGRAPH
	{0xA554,	0x5189},	// CJK UNIFIED IDEOGRAPH
	{0xA555,	0x518A},	// CJK UNIFIED IDEOGRAPH
	{0xA556,	0x51AC},	// CJK UNIFIED IDEOGRAPH
	{0xA557,	0x51F9},	// CJK UNIFIED IDEOGRAPH
	{0xA558,	0x51FA},	// CJK UNIFIED IDEOGRAPH
	{0xA559,	0x51F8},	// CJK UNIFIED IDEOGRAPH
	{0xA55A,	0x520A},	// CJK UNIFIED IDEOGRAPH
	{0xA55B,	0x52A0},	// CJK UNIFIED IDEOGRAPH
	{0xA55C,	0x529F},	// CJK UNIFIED IDEOGRAPH
	{0xA55D,	0x5305},	// CJK UNIFIED IDEOGRAPH
	{0xA55E,	0x5306},	// CJK UNIFIED IDEOGRAPH
	{0xA55F,	0x5317},	// CJK UNIFIED IDEOGRAPH
	{0xA560,	0x531D},	// CJK UNIFIED IDEOGRAPH
	{0xA561,	0x4EDF},	// CJK UNIFIED IDEOGRAPH
	{0xA562,	0x534A},	// CJK UNIFIED IDEOGRAPH
	{0xA563,	0x5349},	// CJK UNIFIED IDEOGRAPH
	{0xA564,	0x5361},	// CJK UNIFIED IDEOGRAPH
	{0xA565,	0x5360},	// CJK UNIFIED IDEOGRAPH
	{0xA566,	0x536F},	// CJK UNIFIED IDEOGRAPH
	{0xA567,	0x536E},	// CJK UNIFIED IDEOGRAPH
	{0xA568,	0x53BB},	// CJK UNIFIED IDEOGRAPH
	{0xA569,	0x53EF},	// CJK UNIFIED IDEOGRAPH
	{0xA56A,	0x53E4},	// CJK UNIFIED IDEOGRAPH
	{0xA56B,	0x53F3},	// CJK UNIFIED IDEOGRAPH
	{0xA56C,	0x53EC},	// CJK UNIFIED IDEOGRAPH
	{0xA56D,	0x53EE},	// CJK UNIFIED IDEOGRAPH
	{0xA56E,	0x53E9},	// CJK UNIFIED IDEOGRAPH
	{0xA56F,	0x53E8},	// CJK UNIFIED IDEOGRAPH
	{0xA570,	0x53FC},	// CJK UNIFIED IDEOGRAPH
	{0xA571,	0x53F8},	// CJK UNIFIED IDEOGRAPH
	{0xA572,	0x53F5},	// CJK UNIFIED IDEOGRAPH
	{0xA573,	0x53EB},	// CJK UNIFIED IDEOGRAPH
	{0xA574,	0x53E6},	// CJK UNIFIED IDEOGRAPH
	{0xA575,	0x53EA},	// CJK UNIFIED IDEOGRAPH
	{0xA576,	0x53F2},	// CJK UNIFIED IDEOGRAPH
	{0xA577,	0x53F1},	// CJK UNIFIED IDEOGRAPH
	{0xA578,	0x53F0},	// CJK UNIFIED IDEOGRAPH
	{0xA579,	0x53E5},	// CJK UNIFIED IDEOGRAPH
	{0xA57A,	0x53ED},	// CJK UNIFIED IDEOGRAPH
	{0xA57B,	0x53FB},	// CJK UNIFIED IDEOGRAPH
	{0xA57C,	0x56DB},	// CJK UNIFIED IDEOGRAPH
	{0xA57D,	0x56DA},	// CJK UNIFIED IDEOGRAPH
	{0xA57E,	0x5916},	// CJK UNIFIED IDEOGRAPH
	{0xA5A1,	0x592E},	// CJK UNIFIED IDEOGRAPH
	{0xA5A2,	0x5931},	// CJK UNIFIED IDEOGRAPH
	{0xA5A3,	0x5974},	// CJK UNIFIED IDEOGRAPH
	{0xA5A4,	0x5976},	// CJK UNIFIED IDEOGRAPH
	{0xA5A5,	0x5B55},	// CJK UNIFIED IDEOGRAPH
	{0xA5A6,	0x5B83},	// CJK UNIFIED IDEOGRAPH
	{0xA5A7,	0x5C3C},	// CJK UNIFIED IDEOGRAPH
	{0xA5A8,	0x5DE8},	// CJK UNIFIED IDEOGRAPH
	{0xA5A9,	0x5DE7},	// CJK UNIFIED IDEOGRAPH
	{0xA5AA,	0x5DE6},	// CJK UNIFIED IDEOGRAPH
	{0xA5AB,	0x5E02},	// CJK UNIFIED IDEOGRAPH
	{0xA5AC,	0x5E03},	// CJK UNIFIED IDEOGRAPH
	{0xA5AD,	0x5E73},	// CJK UNIFIED IDEOGRAPH
	{0xA5AE,	0x5E7C},	// CJK UNIFIED IDEOGRAPH
	{0xA5AF,	0x5F01},	// CJK UNIFIED IDEOGRAPH
	{0xA5B0,	0x5F18},	// CJK UNIFIED IDEOGRAPH
	{0xA5B1,	0x5F17},	// CJK UNIFIED IDEOGRAPH
	{0xA5B2,	0x5FC5},	// CJK UNIFIED IDEOGRAPH
	{0xA5B3,	0x620A},	// CJK UNIFIED IDEOGRAPH
	{0xA5B4,	0x6253},	// CJK UNIFIED IDEOGRAPH
	{0xA5B5,	0x6254},	// CJK UNIFIED IDEOGRAPH
	{0xA5B6,	0x6252},	// CJK UNIFIED IDEOGRAPH
	{0xA5B7,	0x6251},	// CJK UNIFIED IDEOGRAPH
	{0xA5B8,	0x65A5},	// CJK UNIFIED IDEOGRAPH
	{0xA5B9,	0x65E6},	// CJK UNIFIED IDEOGRAPH
	{0xA5BA,	0x672E},	// CJK UNIFIED IDEOGRAPH
	{0xA5BB,	0x672C},	// CJK UNIFIED IDEOGRAPH
	{0xA5BC,	0x672A},	// CJK UNIFIED IDEOGRAPH
	{0xA5BD,	0x672B},	// CJK UNIFIED IDEOGRAPH
	{0xA5BE,	0x672D},	// CJK UNIFIED IDEOGRAPH
	{0xA5BF,	0x6B63},	// CJK UNIFIED IDEOGRAPH
	{0xA5C0,	0x6BCD},	// CJK UNIFIED IDEOGRAPH
	{0xA5C1,	0x6C11},	// CJK UNIFIED IDEOGRAPH
	{0xA5C2,	0x6C10},	// CJK UNIFIED IDEOGRAPH
	{0xA5C3,	0x6C38},	// CJK UNIFIED IDEOGRAPH
	{0xA5C4,	0x6C41},	// CJK UNIFIED IDEOGRAPH
	{0xA5C5,	0x6C40},	// CJK UNIFIED IDEOGRAPH
	{0xA5C6,	0x6C3E},	// CJK UNIFIED IDEOGRAPH
	{0xA5C7,	0x72AF},	// CJK UNIFIED IDEOGRAPH
	{0xA5C8,	0x7384},	// CJK UNIFIED IDEOGRAPH
	{0xA5C9,	0x7389},	// CJK UNIFIED IDEOGRAPH
	{0xA5CA,	0x74DC},	// CJK UNIFIED IDEOGRAPH
	{0xA5CB,	0x74E6},	// CJK UNIFIED IDEOGRAPH
	{0xA5CC,	0x7518},	// CJK UNIFIED IDEOGRAPH
	{0xA5CD,	0x751F},	// CJK UNIFIED IDEOGRAPH
	{0xA5CE,	0x7528},	// CJK UNIFIED IDEOGRAPH
	{0xA5CF,	0x7529},	// CJK UNIFIED IDEOGRAPH
	{0xA5D0,	0x7530},	// CJK UNIFIED IDEOGRAPH
	{0xA5D1,	0x7531},	// CJK UNIFIED IDEOGRAPH
	{0xA5D2,	0x7532},	// CJK UNIFIED IDEOGRAPH
	{0xA5D3,	0x7533},	// CJK UNIFIED IDEOGRAPH
	{0xA5D4,	0x758B},	// CJK UNIFIED IDEOGRAPH
	{0xA5D5,	0x767D},	// CJK UNIFIED IDEOGRAPH
	{0xA5D6,	0x76AE},	// CJK UNIFIED IDEOGRAPH
	{0xA5D7,	0x76BF},	// CJK UNIFIED IDEOGRAPH
	{0xA5D8,	0x76EE},	// CJK UNIFIED IDEOGRAPH
	{0xA5D9,	0x77DB},	// CJK UNIFIED IDEOGRAPH
	{0xA5DA,	0x77E2},	// CJK UNIFIED IDEOGRAPH
	{0xA5DB,	0x77F3},	// CJK UNIFIED IDEOGRAPH
	{0xA5DC,	0x793A},	// CJK UNIFIED IDEOGRAPH
	{0xA5DD,	0x79BE},	// CJK UNIFIED IDEOGRAPH
	{0xA5DE,	0x7A74},	// CJK UNIFIED IDEOGRAPH
	{0xA5DF,	0x7ACB},	// CJK UNIFIED IDEOGRAPH
	{0xA5E0,	0x4E1E},	// CJK UNIFIED IDEOGRAPH
	{0xA5E1,	0x4E1F},	// CJK UNIFIED IDEOGRAPH
	{0xA5E2,	0x4E52},	// CJK UNIFIED IDEOGRAPH
	{0xA5E3,	0x4E53},	// CJK UNIFIED IDEOGRAPH
	{0xA5E4,	0x4E69},	// CJK UNIFIED IDEOGRAPH
	{0xA5E5,	0x4E99},	// CJK UNIFIED IDEOGRAPH
	{0xA5E6,	0x4EA4},	// CJK UNIFIED IDEOGRAPH
	{0xA5E7,	0x4EA6},	// CJK UNIFIED IDEOGRAPH
	{0xA5E8,	0x4EA5},	// CJK UNIFIED IDEOGRAPH
	{0xA5E9,	0x4EFF},	// CJK UNIFIED IDEOGRAPH
	{0xA5EA,	0x4F09},	// CJK UNIFIED IDEOGRAPH
	{0xA5EB,	0x4F19},	// CJK UNIFIED IDEOGRAPH
	{0xA5EC,	0x4F0A},	// CJK UNIFIED IDEOGRAPH
	{0xA5ED,	0x4F15},	// CJK UNIFIED IDEOGRAPH
	{0xA5EE,	0x4F0D},	// CJK UNIFIED IDEOGRAPH
	{0xA5EF,	0x4F10},	// CJK UNIFIED IDEOGRAPH
	{0xA5F0,	0x4F11},	// CJK UNIFIED IDEOGRAPH
	{0xA5F1,	0x4F0F},	// CJK UNIFIED IDEOGRAPH
	{0xA5F2,	0x4EF2},	// CJK UNIFIED IDEOGRAPH
	{0xA5F3,	0x4EF6},	// CJK UNIFIED IDEOGRAPH
	{0xA5F4,	0x4EFB},	// CJK UNIFIED IDEOGRAPH
	{0xA5F5,	0x4EF0},	// CJK UNIFIED IDEOGRAPH
	{0xA5F6,	0x4EF3},	// CJK UNIFIED IDEOGRAPH
	{0xA5F7,	0x4EFD},	// CJK UNIFIED IDEOGRAPH
	{0xA5F8,	0x4F01},	// CJK UNIFIED IDEOGRAPH
	{0xA5F9,	0x4F0B},	// CJK UNIFIED IDEOGRAPH
	{0xA5FA,	0x5149},	// CJK UNIFIED IDEOGRAPH
	{0xA5FB,	0x5147},	// CJK UNIFIED IDEOGRAPH
	{0xA5FC,	0x5146},	// CJK UNIFIED IDEOGRAPH
	{0xA5FD,	0x5148},	// CJK UNIFIED IDEOGRAPH
	{0xA5FE,	0x5168},	// CJK UNIFIED IDEOGRAPH
	{0xA640,	0x5171},	// CJK UNIFIED IDEOGRAPH
	{0xA641,	0x518D},	// CJK UNIFIED IDEOGRAPH
	{0xA642,	0x51B0},	// CJK UNIFIED IDEOGRAPH
	{0xA643,	0x5217},	// CJK UNIFIED IDEOGRAPH
	{0xA644,	0x5211},	// CJK UNIFIED IDEOGRAPH
	{0xA645,	0x5212},	// CJK UNIFIED IDEOGRAPH
	{0xA646,	0x520E},	// CJK UNIFIED IDEOGRAPH
	{0xA647,	0x5216},	// CJK UNIFIED IDEOGRAPH
	{0xA648,	0x52A3},	// CJK UNIFIED IDEOGRAPH
	{0xA649,	0x5308},	// CJK UNIFIED IDEOGRAPH
	{0xA64A,	0x5321},	// CJK UNIFIED IDEOGRAPH
	{0xA64B,	0x5320},	// CJK UNIFIED IDEOGRAPH
	{0xA64C,	0x5370},	// CJK UNIFIED IDEOGRAPH
	{0xA64D,	0x5371},	// CJK UNIFIED IDEOGRAPH
	{0xA64E,	0x5409},	// CJK UNIFIED IDEOGRAPH
	{0xA64F,	0x540F},	// CJK UNIFIED IDEOGRAPH
	{0xA650,	0x540C},	// CJK UNIFIED IDEOGRAPH
	{0xA651,	0x540A},	// CJK UNIFIED IDEOGRAPH
	{0xA652,	0x5410},	// CJK UNIFIED IDEOGRAPH
	{0xA653,	0x5401},	// CJK UNIFIED IDEOGRAPH
	{0xA654,	0x540B},	// CJK UNIFIED IDEOGRAPH
	{0xA655,	0x5404},	// CJK UNIFIED IDEOGRAPH
	{0xA656,	0x5411},	// CJK UNIFIED IDEOGRAPH
	{0xA657,	0x540D},	// CJK UNIFIED IDEOGRAPH
	{0xA658,	0x5408},	// CJK UNIFIED IDEOGRAPH
	{0xA659,	0x5403},	// CJK UNIFIED IDEOGRAPH
	{0xA65A,	0x540E},	// CJK UNIFIED IDEOGRAPH
	{0xA65B,	0x5406},	// CJK UNIFIED IDEOGRAPH
	{0xA65C,	0x5412},	// CJK UNIFIED IDEOGRAPH
	{0xA65D,	0x56E0},	// CJK UNIFIED IDEOGRAPH
	{0xA65E,	0x56DE},	// CJK UNIFIED IDEOGRAPH
	{0xA65F,	0x56DD},	// CJK UNIFIED IDEOGRAPH
	{0xA660,	0x5733},	// CJK UNIFIED IDEOGRAPH
	{0xA661,	0x5730},	// CJK UNIFIED IDEOGRAPH
	{0xA662,	0x5728},	// CJK UNIFIED IDEOGRAPH
	{0xA663,	0x572D},	// CJK UNIFIED IDEOGRAPH
	{0xA664,	0x572C},	// CJK UNIFIED IDEOGRAPH
	{0xA665,	0x572F},	// CJK UNIFIED IDEOGRAPH
	{0xA666,	0x5729},	// CJK UNIFIED IDEOGRAPH
	{0xA667,	0x5919},	// CJK UNIFIED IDEOGRAPH
	{0xA668,	0x591A},	// CJK UNIFIED IDEOGRAPH
	{0xA669,	0x5937},	// CJK UNIFIED IDEOGRAPH
	{0xA66A,	0x5938},	// CJK UNIFIED IDEOGRAPH
	{0xA66B,	0x5984},	// CJK UNIFIED IDEOGRAPH
	{0xA66C,	0x5978},	// CJK UNIFIED IDEOGRAPH
	{0xA66D,	0x5983},	// CJK UNIFIED IDEOGRAPH
	{0xA66E,	0x597D},	// CJK UNIFIED IDEOGRAPH
	{0xA66F,	0x5979},	// CJK UNIFIED IDEOGRAPH
	{0xA670,	0x5982},	// CJK UNIFIED IDEOGRAPH
	{0xA671,	0x5981},	// CJK UNIFIED IDEOGRAPH
	{0xA672,	0x5B57},	// CJK UNIFIED IDEOGRAPH
	{0xA673,	0x5B58},	// CJK UNIFIED IDEOGRAPH
	{0xA674,	0x5B87},	// CJK UNIFIED IDEOGRAPH
	{0xA675,	0x5B88},	// CJK UNIFIED IDEOGRAPH
	{0xA676,	0x5B85},	// CJK UNIFIED IDEOGRAPH
	{0xA677,	0x5B89},	// CJK UNIFIED IDEOGRAPH
	{0xA678,	0x5BFA},	// CJK UNIFIED IDEOGRAPH
	{0xA679,	0x5C16},	// CJK UNIFIED IDEOGRAPH
	{0xA67A,	0x5C79},	// CJK UNIFIED IDEOGRAPH
	{0xA67B,	0x5DDE},	// CJK UNIFIED IDEOGRAPH
	{0xA67C,	0x5E06},	// CJK UNIFIED IDEOGRAPH
	{0xA67D,	0x5E76},	// CJK UNIFIED IDEOGRAPH
	{0xA67E,	0x5E74},	// CJK UNIFIED IDEOGRAPH
	{0xA6A1,	0x5F0F},	// CJK UNIFIED IDEOGRAPH
	{0xA6A2,	0x5F1B},	// CJK UNIFIED IDEOGRAPH
	{0xA6A3,	0x5FD9},	// CJK UNIFIED IDEOGRAPH
	{0xA6A4,	0x5FD6},	// CJK UNIFIED IDEOGRAPH
	{0xA6A5,	0x620E},	// CJK UNIFIED IDEOGRAPH
	{0xA6A6,	0x620C},	// CJK UNIFIED IDEOGRAPH
	{0xA6A7,	0x620D},	// CJK UNIFIED IDEOGRAPH
	{0xA6A8,	0x6210},	// CJK UNIFIED IDEOGRAPH
	{0xA6A9,	0x6263},	// CJK UNIFIED IDEOGRAPH
	{0xA6AA,	0x625B},	// CJK UNIFIED IDEOGRAPH
	{0xA6AB,	0x6258},	// CJK UNIFIED IDEOGRAPH
	{0xA6AC,	0x6536},	// CJK UNIFIED IDEOGRAPH
	{0xA6AD,	0x65E9},	// CJK UNIFIED IDEOGRAPH
	{0xA6AE,	0x65E8},	// CJK UNIFIED IDEOGRAPH
	{0xA6AF,	0x65EC},	// CJK UNIFIED IDEOGRAPH
	{0xA6B0,	0x65ED},	// CJK UNIFIED IDEOGRAPH
	{0xA6B1,	0x66F2},	// CJK UNIFIED IDEOGRAPH
	{0xA6B2,	0x66F3},	// CJK UNIFIED IDEOGRAPH
	{0xA6B3,	0x6709},	// CJK UNIFIED IDEOGRAPH
	{0xA6B4,	0x673D},	// CJK UNIFIED IDEOGRAPH
	{0xA6B5,	0x6734},	// CJK UNIFIED IDEOGRAPH
	{0xA6B6,	0x6731},	// CJK UNIFIED IDEOGRAPH
	{0xA6B7,	0x6735},	// CJK UNIFIED IDEOGRAPH
	{0xA6B8,	0x6B21},	// CJK UNIFIED IDEOGRAPH
	{0xA6B9,	0x6B64},	// CJK UNIFIED IDEOGRAPH
	{0xA6BA,	0x6B7B},	// CJK UNIFIED IDEOGRAPH
	{0xA6BB,	0x6C16},	// CJK UNIFIED IDEOGRAPH
	{0xA6BC,	0x6C5D},	// CJK UNIFIED IDEOGRAPH
	{0xA6BD,	0x6C57},	// CJK UNIFIED IDEOGRAPH
	{0xA6BE,	0x6C59},	// CJK UNIFIED IDEOGRAPH
	{0xA6BF,	0x6C5F},	// CJK UNIFIED IDEOGRAPH
	{0xA6C0,	0x6C60},	// CJK UNIFIED IDEOGRAPH
	{0xA6C1,	0x6C50},	// CJK UNIFIED IDEOGRAPH
	{0xA6C2,	0x6C55},	// CJK UNIFIED IDEOGRAPH
	{0xA6C3,	0x6C61},	// CJK UNIFIED IDEOGRAPH
	{0xA6C4,	0x6C5B},	// CJK UNIFIED IDEOGRAPH
	{0xA6C5,	0x6C4D},	// CJK UNIFIED IDEOGRAPH
	{0xA6C6,	0x6C4E},	// CJK UNIFIED IDEOGRAPH
	{0xA6C7,	0x7070},	// CJK UNIFIED IDEOGRAPH
	{0xA6C8,	0x725F},	// CJK UNIFIED IDEOGRAPH
	{0xA6C9,	0x725D},	// CJK UNIFIED IDEOGRAPH
	{0xA6CA,	0x767E},	// CJK UNIFIED IDEOGRAPH
	{0xA6CB,	0x7AF9},	// CJK UNIFIED IDEOGRAPH
	{0xA6CC,	0x7C73},	// CJK UNIFIED IDEOGRAPH
	{0xA6CD,	0x7CF8},	// CJK UNIFIED IDEOGRAPH
	{0xA6CE,	0x7F36},	// CJK UNIFIED IDEOGRAPH
	{0xA6CF,	0x7F8A},	// CJK UNIFIED IDEOGRAPH
	{0xA6D0,	0x7FBD},	// CJK UNIFIED IDEOGRAPH
	{0xA6D1,	0x8001},	// CJK UNIFIED IDEOGRAPH
	{0xA6D2,	0x8003},	// CJK UNIFIED IDEOGRAPH
	{0xA6D3,	0x800C},	// CJK UNIFIED IDEOGRAPH
	{0xA6D4,	0x8012},	// CJK UNIFIED IDEOGRAPH
	{0xA6D5,	0x8033},	// CJK UNIFIED IDEOGRAPH
	{0xA6D6,	0x807F},	// CJK UNIFIED IDEOGRAPH
	{0xA6D7,	0x8089},	// CJK UNIFIED IDEOGRAPH
	{0xA6D8,	0x808B},	// CJK UNIFIED IDEOGRAPH
	{0xA6D9,	0x808C},	// CJK UNIFIED IDEOGRAPH
	{0xA6DA,	0x81E3},	// CJK UNIFIED IDEOGRAPH
	{0xA6DB,	0x81EA},	// CJK UNIFIED IDEOGRAPH
	{0xA6DC,	0x81F3},	// CJK UNIFIED IDEOGRAPH
	{0xA6DD,	0x81FC},	// CJK UNIFIED IDEOGRAPH
	{0xA6DE,	0x820C},	// CJK UNIFIED IDEOGRAPH
	{0xA6DF,	0x821B},	// CJK UNIFIED IDEOGRAPH
	{0xA6E0,	0x821F},	// CJK UNIFIED IDEOGRAPH
	{0xA6E1,	0x826E},	// CJK UNIFIED IDEOGRAPH
	{0xA6E2,	0x8272},	// CJK UNIFIED IDEOGRAPH
	{0xA6E3,	0x827E},	// CJK UNIFIED IDEOGRAPH
	{0xA6E4,	0x866B},	// CJK UNIFIED IDEOGRAPH
	{0xA6E5,	0x8840},	// CJK UNIFIED IDEOGRAPH
	{0xA6E6,	0x884C},	// CJK UNIFIED IDEOGRAPH
	{0xA6E7,	0x8863},	// CJK UNIFIED IDEOGRAPH
	{0xA6E8,	0x897F},	// CJK UNIFIED IDEOGRAPH
	{0xA6E9,	0x9621},	// CJK UNIFIED IDEOGRAPH
	{0xA6EA,	0x4E32},	// CJK UNIFIED IDEOGRAPH
	{0xA6EB,	0x4EA8},	// CJK UNIFIED IDEOGRAPH
	{0xA6EC,	0x4F4D},	// CJK UNIFIED IDEOGRAPH
	{0xA6ED,	0x4F4F},	// CJK UNIFIED IDEOGRAPH
	{0xA6EE,	0x4F47},	// CJK UNIFIED IDEOGRAPH
	{0xA6EF,	0x4F57},	// CJK UNIFIED IDEOGRAPH
	{0xA6F0,	0x4F5E},	// CJK UNIFIED IDEOGRAPH
	{0xA6F1,	0x4F34},	// CJK UNIFIED IDEOGRAPH
	{0xA6F2,	0x4F5B},	// CJK UNIFIED IDEOGRAPH
	{0xA6F3,	0x4F55},	// CJK UNIFIED IDEOGRAPH
	{0xA6F4,	0x4F30},	// CJK UNIFIED IDEOGRAPH
	{0xA6F5,	0x4F50},	// CJK UNIFIED IDEOGRAPH
	{0xA6F6,	0x4F51},	// CJK UNIFIED IDEOGRAPH
	{0xA6F7,	0x4F3D},	// CJK UNIFIED IDEOGRAPH
	{0xA6F8,	0x4F3A},	// CJK UNIFIED IDEOGRAPH
	{0xA6F9,	0x4F38},	// CJK UNIFIED IDEOGRAPH
	{0xA6FA,	0x4F43},	// CJK UNIFIED IDEOGRAPH
	{0xA6FB,	0x4F54},	// CJK UNIFIED IDEOGRAPH
	{0xA6FC,	0x4F3C},	// CJK UNIFIED IDEOGRAPH
	{0xA6FD,	0x4F46},	// CJK UNIFIED IDEOGRAPH
	{0xA6FE,	0x4F63},	// CJK UNIFIED IDEOGRAPH
	{0xA740,	0x4F5C},	// CJK UNIFIED IDEOGRAPH
	{0xA741,	0x4F60},	// CJK UNIFIED IDEOGRAPH
	{0xA742,	0x4F2F},	// CJK UNIFIED IDEOGRAPH
	{0xA743,	0x4F4E},	// CJK UNIFIED IDEOGRAPH
	{0xA744,	0x4F36},	// CJK UNIFIED IDEOGRAPH
	{0xA745,	0x4F59},	// CJK UNIFIED IDEOGRAPH
	{0xA746,	0x4F5D},	// CJK UNIFIED IDEOGRAPH
	{0xA747,	0x4F48},	// CJK UNIFIED IDEOGRAPH
	{0xA748,	0x4F5A},	// CJK UNIFIED IDEOGRAPH
	{0xA749,	0x514C},	// CJK UNIFIED IDEOGRAPH
	{0xA74A,	0x514B},	// CJK UNIFIED IDEOGRAPH
	{0xA74B,	0x514D},	// CJK UNIFIED IDEOGRAPH
	{0xA74C,	0x5175},	// CJK UNIFIED IDEOGRAPH
	{0xA74D,	0x51B6},	// CJK UNIFIED IDEOGRAPH
	{0xA74E,	0x51B7},	// CJK UNIFIED IDEOGRAPH
	{0xA74F,	0x5225},	// CJK UNIFIED IDEOGRAPH
	{0xA750,	0x5224},	// CJK UNIFIED IDEOGRAPH
	{0xA751,	0x5229},	// CJK UNIFIED IDEOGRAPH
	{0xA752,	0x522A},	// CJK UNIFIED IDEOGRAPH
	{0xA753,	0x5228},	// CJK UNIFIED IDEOGRAPH
	{0xA754,	0x52AB},	// CJK UNIFIED IDEOGRAPH
	{0xA755,	0x52A9},	// CJK UNIFIED IDEOGRAPH
	{0xA756,	0x52AA},	// CJK UNIFIED IDEOGRAPH
	{0xA757,	0x52AC},	// CJK UNIFIED IDEOGRAPH
	{0xA758,	0x5323},	// CJK UNIFIED IDEOGRAPH
	{0xA759,	0x5373},	// CJK UNIFIED IDEOGRAPH
	{0xA75A,	0x5375},	// CJK UNIFIED IDEOGRAPH
	{0xA75B,	0x541D},	// CJK UNIFIED IDEOGRAPH
	{0xA75C,	0x542D},	// CJK UNIFIED IDEOGRAPH
	{0xA75D,	0x541E},	// CJK UNIFIED IDEOGRAPH
	{0xA75E,	0x543E},	// CJK UNIFIED IDEOGRAPH
	{0xA75F,	0x5426},	// CJK UNIFIED IDEOGRAPH
	{0xA760,	0x544E},	// CJK UNIFIED IDEOGRAPH
	{0xA761,	0x5427},	// CJK UNIFIED IDEOGRAPH
	{0xA762,	0x5446},	// CJK UNIFIED IDEOGRAPH
	{0xA763,	0x5443},	// CJK UNIFIED IDEOGRAPH
	{0xA764,	0x5433},	// CJK UNIFIED IDEOGRAPH
	{0xA765,	0x5448},	// CJK UNIFIED IDEOGRAPH
	{0xA766,	0x5442},	// CJK UNIFIED IDEOGRAPH
	{0xA767,	0x541B},	// CJK UNIFIED IDEOGRAPH
	{0xA768,	0x5429},	// CJK UNIFIED IDEOGRAPH
	{0xA769,	0x544A},	// CJK UNIFIED IDEOGRAPH
	{0xA76A,	0x5439},	// CJK UNIFIED IDEOGRAPH
	{0xA76B,	0x543B},	// CJK UNIFIED IDEOGRAPH
	{0xA76C,	0x5438},	// CJK UNIFIED IDEOGRAPH
	{0xA76D,	0x542E},	// CJK UNIFIED IDEOGRAPH
	{0xA76E,	0x5435},	// CJK UNIFIED IDEOGRAPH
	{0xA76F,	0x5436},	// CJK UNIFIED IDEOGRAPH
	{0xA770,	0x5420},	// CJK UNIFIED IDEOGRAPH
	{0xA771,	0x543C},	// CJK UNIFIED IDEOGRAPH
	{0xA772,	0x5440},	// CJK UNIFIED IDEOGRAPH
	{0xA773,	0x5431},	// CJK UNIFIED IDEOGRAPH
	{0xA774,	0x542B},	// CJK UNIFIED IDEOGRAPH
	{0xA775,	0x541F},	// CJK UNIFIED IDEOGRAPH
	{0xA776,	0x542C},	// CJK UNIFIED IDEOGRAPH
	{0xA777,	0x56EA},	// CJK UNIFIED IDEOGRAPH
	{0xA778,	0x56F0},	// CJK UNIFIED IDEOGRAPH
	{0xA779,	0x56E4},	// CJK UNIFIED IDEOGRAPH
	{0xA77A,	0x56EB},	// CJK UNIFIED IDEOGRAPH
	{0xA77B,	0x574A},	// CJK UNIFIED IDEOGRAPH
	{0xA77C,	0x5751},	// CJK UNIFIED IDEOGRAPH
	{0xA77D,	0x5740},	// CJK UNIFIED IDEOGRAPH
	{0xA77E,	0x574D},	// CJK UNIFIED IDEOGRAPH
	{0xA7A1,	0x5747},	// CJK UNIFIED IDEOGRAPH
	{0xA7A2,	0x574E},	// CJK UNIFIED IDEOGRAPH
	{0xA7A3,	0x573E},	// CJK UNIFIED IDEOGRAPH
	{0xA7A4,	0x5750},	// CJK UNIFIED IDEOGRAPH
	{0xA7A5,	0x574F},	// CJK UNIFIED IDEOGRAPH
	{0xA7A6,	0x573B},	// CJK UNIFIED IDEOGRAPH
	{0xA7A7,	0x58EF},	// CJK UNIFIED IDEOGRAPH
	{0xA7A8,	0x593E},	// CJK UNIFIED IDEOGRAPH
	{0xA7A9,	0x599D},	// CJK UNIFIED IDEOGRAPH
	{0xA7AA,	0x5992},	// CJK UNIFIED IDEOGRAPH
	{0xA7AB,	0x59A8},	// CJK UNIFIED IDEOGRAPH
	{0xA7AC,	0x599E},	// CJK UNIFIED IDEOGRAPH
	{0xA7AD,	0x59A3},	// CJK UNIFIED IDEOGRAPH
	{0xA7AE,	0x5999},	// CJK UNIFIED IDEOGRAPH
	{0xA7AF,	0x5996},	// CJK UNIFIED IDEOGRAPH
	{0xA7B0,	0x598D},	// CJK UNIFIED IDEOGRAPH
	{0xA7B1,	0x59A4},	// CJK UNIFIED IDEOGRAPH
	{0xA7B2,	0x5993},	// CJK UNIFIED IDEOGRAPH
	{0xA7B3,	0x598A},	// CJK UNIFIED IDEOGRAPH
	{0xA7B4,	0x59A5},	// CJK UNIFIED IDEOGRAPH
	{0xA7B5,	0x5B5D},	// CJK UNIFIED IDEOGRAPH
	{0xA7B6,	0x5B5C},	// CJK UNIFIED IDEOGRAPH
	{0xA7B7,	0x5B5A},	// CJK UNIFIED IDEOGRAPH
	{0xA7B8,	0x5B5B},	// CJK UNIFIED IDEOGRAPH
	{0xA7B9,	0x5B8C},	// CJK UNIFIED IDEOGRAPH
	{0xA7BA,	0x5B8B},	// CJK UNIFIED IDEOGRAPH
	{0xA7BB,	0x5B8F},	// CJK UNIFIED IDEOGRAPH
	{0xA7BC,	0x5C2C},	// CJK UNIFIED IDEOGRAPH
	{0xA7BD,	0x5C40},	// CJK UNIFIED IDEOGRAPH
	{0xA7BE,	0x5C41},	// CJK UNIFIED IDEOGRAPH
	{0xA7BF,	0x5C3F},	// CJK UNIFIED IDEOGRAPH
	{0xA7C0,	0x5C3E},	// CJK UNIFIED IDEOGRAPH
	{0xA7C1,	0x5C90},	// CJK UNIFIED IDEOGRAPH
	{0xA7C2,	0x5C91},	// CJK UNIFIED IDEOGRAPH
	{0xA7C3,	0x5C94},	// CJK UNIFIED IDEOGRAPH
	{0xA7C4,	0x5C8C},	// CJK UNIFIED IDEOGRAPH
	{0xA7C5,	0x5DEB},	// CJK UNIFIED IDEOGRAPH
	{0xA7C6,	0x5E0C},	// CJK UNIFIED IDEOGRAPH
	{0xA7C7,	0x5E8F},	// CJK UNIFIED IDEOGRAPH
	{0xA7C8,	0x5E87},	// CJK UNIFIED IDEOGRAPH
	{0xA7C9,	0x5E8A},	// CJK UNIFIED IDEOGRAPH
	{0xA7CA,	0x5EF7},	// CJK UNIFIED IDEOGRAPH
	{0xA7CB,	0x5F04},	// CJK UNIFIED IDEOGRAPH
	{0xA7CC,	0x5F1F},	// CJK UNIFIED IDEOGRAPH
	{0xA7CD,	0x5F64},	// CJK UNIFIED IDEOGRAPH
	{0xA7CE,	0x5F62},	// CJK UNIFIED IDEOGRAPH
	{0xA7CF,	0x5F77},	// CJK UNIFIED IDEOGRAPH
	{0xA7D0,	0x5F79},	// CJK UNIFIED IDEOGRAPH
	{0xA7D1,	0x5FD8},	// CJK UNIFIED IDEOGRAPH
	{0xA7D2,	0x5FCC},	// CJK UNIFIED IDEOGRAPH
	{0xA7D3,	0x5FD7},	// CJK UNIFIED IDEOGRAPH
	{0xA7D4,	0x5FCD},	// CJK UNIFIED IDEOGRAPH
	{0xA7D5,	0x5FF1},	// CJK UNIFIED IDEOGRAPH
	{0xA7D6,	0x5FEB},	// CJK UNIFIED IDEOGRAPH
	{0xA7D7,	0x5FF8},	// CJK UNIFIED IDEOGRAPH
	{0xA7D8,	0x5FEA},	// CJK UNIFIED IDEOGRAPH
	{0xA7D9,	0x6212},	// CJK UNIFIED IDEOGRAPH
	{0xA7DA,	0x6211},	// CJK UNIFIED IDEOGRAPH
	{0xA7DB,	0x6284},	// CJK UNIFIED IDEOGRAPH
	{0xA7DC,	0x6297},	// CJK UNIFIED IDEOGRAPH
	{0xA7DD,	0x6296},	// CJK UNIFIED IDEOGRAPH
	{0xA7DE,	0x6280},	// CJK UNIFIED IDEOGRAPH
	{0xA7DF,	0x6276},	// CJK UNIFIED IDEOGRAPH
	{0xA7E0,	0x6289},	// CJK UNIFIED IDEOGRAPH
	{0xA7E1,	0x626D},	// CJK UNIFIED IDEOGRAPH
	{0xA7E2,	0x628A},	// CJK UNIFIED IDEOGRAPH
	{0xA7E3,	0x627C},	// CJK UNIFIED IDEOGRAPH
	{0xA7E4,	0x627E},	// CJK UNIFIED IDEOGRAPH
	{0xA7E5,	0x6279},	// CJK UNIFIED IDEOGRAPH
	{0xA7E6,	0x6273},	// CJK UNIFIED IDEOGRAPH
	{0xA7E7,	0x6292},	// CJK UNIFIED IDEOGRAPH
	{0xA7E8,	0x626F},	// CJK UNIFIED IDEOGRAPH
	{0xA7E9,	0x6298},	// CJK UNIFIED IDEOGRAPH
	{0xA7EA,	0x626E},	// CJK UNIFIED IDEOGRAPH
	{0xA7EB,	0x6295},	// CJK UNIFIED IDEOGRAPH
	{0xA7EC,	0x6293},	// CJK UNIFIED IDEOGRAPH
	{0xA7ED,	0x6291},	// CJK UNIFIED IDEOGRAPH
	{0xA7EE,	0x6286},	// CJK UNIFIED IDEOGRAPH
	{0xA7EF,	0x6539},	// CJK UNIFIED IDEOGRAPH
	{0xA7F0,	0x653B},	// CJK UNIFIED IDEOGRAPH
	{0xA7F1,	0x6538},	// CJK UNIFIED IDEOGRAPH
	{0xA7F2,	0x65F1},	// CJK UNIFIED IDEOGRAPH
	{0xA7F3,	0x66F4},	// CJK UNIFIED IDEOGRAPH
	{0xA7F4,	0x675F},	// CJK UNIFIED IDEOGRAPH
	{0xA7F5,	0x674E},	// CJK UNIFIED IDEOGRAPH
	{0xA7F6,	0x674F},	// CJK UNIFIED IDEOGRAPH
	{0xA7F7,	0x6750},	// CJK UNIFIED IDEOGRAPH
	{0xA7F8,	0x6751},	// CJK UNIFIED IDEOGRAPH
	{0xA7F9,	0x675C},	// CJK UNIFIED IDEOGRAPH
	{0xA7FA,	0x6756},	// CJK UNIFIED IDEOGRAPH
	{0xA7FB,	0x675E},	// CJK UNIFIED IDEOGRAPH
	{0xA7FC,	0x6749},	// CJK UNIFIED IDEOGRAPH
	{0xA7FD,	0x6746},	// CJK UNIFIED IDEOGRAPH
	{0xA7FE,	0x6760},	// CJK UNIFIED IDEOGRAPH
	{0xA840,	0x6753},	// CJK UNIFIED IDEOGRAPH
	{0xA841,	0x6757},	// CJK UNIFIED IDEOGRAPH
	{0xA842,	0x6B65},	// CJK UNIFIED IDEOGRAPH
	{0xA843,	0x6BCF},	// CJK UNIFIED IDEOGRAPH
	{0xA844,	0x6C42},	// CJK UNIFIED IDEOGRAPH
	{0xA845,	0x6C5E},	// CJK UNIFIED IDEOGRAPH
	{0xA846,	0x6C99},	// CJK UNIFIED IDEOGRAPH
	{0xA847,	0x6C81},	// CJK UNIFIED IDEOGRAPH
	{0xA848,	0x6C88},	// CJK UNIFIED IDEOGRAPH
	{0xA849,	0x6C89},	// CJK UNIFIED IDEOGRAPH
	{0xA84A,	0x6C85},	// CJK UNIFIED IDEOGRAPH
	{0xA84B,	0x6C9B},	// CJK UNIFIED IDEOGRAPH
	{0xA84C,	0x6C6A},	// CJK UNIFIED IDEOGRAPH
	{0xA84D,	0x6C7A},	// CJK UNIFIED IDEOGRAPH
	{0xA84E,	0x6C90},	// CJK UNIFIED IDEOGRAPH
	{0xA84F,	0x6C70},	// CJK UNIFIED IDEOGRAPH
	{0xA850,	0x6C8C},	// CJK UNIFIED IDEOGRAPH
	{0xA851,	0x6C68},	// CJK UNIFIED IDEOGRAPH
	{0xA852,	0x6C96},	// CJK UNIFIED IDEOGRAPH
	{0xA853,	0x6C92},	// CJK UNIFIED IDEOGRAPH
	{0xA854,	0x6C7D},	// CJK UNIFIED IDEOGRAPH
	{0xA855,	0x6C83},	// CJK UNIFIED IDEOGRAPH
	{0xA856,	0x6C72},	// CJK UNIFIED IDEOGRAPH
	{0xA857,	0x6C7E},	// CJK UNIFIED IDEOGRAPH
	{0xA858,	0x6C74},	// CJK UNIFIED IDEOGRAPH
	{0xA859,	0x6C86},	// CJK UNIFIED IDEOGRAPH
	{0xA85A,	0x6C76},	// CJK UNIFIED IDEOGRAPH
	{0xA85B,	0x6C8D},	// CJK UNIFIED IDEOGRAPH
	{0xA85C,	0x6C94},	// CJK UNIFIED IDEOGRAPH
	{0xA85D,	0x6C98},	// CJK UNIFIED IDEOGRAPH
	{0xA85E,	0x6C82},	// CJK UNIFIED IDEOGRAPH
	{0xA85F,	0x7076},	// CJK UNIFIED IDEOGRAPH
	{0xA860,	0x707C},	// CJK UNIFIED IDEOGRAPH
	{0xA861,	0x707D},	// CJK UNIFIED IDEOGRAPH
	{0xA862,	0x7078},	// CJK UNIFIED IDEOGRAPH
	{0xA863,	0x7262},	// CJK UNIFIED IDEOGRAPH
	{0xA864,	0x7261},	// CJK UNIFIED IDEOGRAPH
	{0xA865,	0x7260},	// CJK UNIFIED IDEOGRAPH
	{0xA866,	0x72C4},	// CJK UNIFIED IDEOGRAPH
	{0xA867,	0x72C2},	// CJK UNIFIED IDEOGRAPH
	{0xA868,	0x7396},	// CJK UNIFIED IDEOGRAPH
	{0xA869,	0x752C},	// CJK UNIFIED IDEOGRAPH
	{0xA86A,	0x752B},	// CJK UNIFIED IDEOGRAPH
	{0xA86B,	0x7537},	// CJK UNIFIED IDEOGRAPH
	{0xA86C,	0x7538},	// CJK UNIFIED IDEOGRAPH
	{0xA86D,	0x7682},	// CJK UNIFIED IDEOGRAPH
	{0xA86E,	0x76EF},	// CJK UNIFIED IDEOGRAPH
	{0xA86F,	0x77E3},	// CJK UNIFIED IDEOGRAPH
	{0xA870,	0x79C1},	// CJK UNIFIED IDEOGRAPH
	{0xA871,	0x79C0},	// CJK UNIFIED IDEOGRAPH
	{0xA872,	0x79BF},	// CJK UNIFIED IDEOGRAPH
	{0xA873,	0x7A76},	// CJK UNIFIED IDEOGRAPH
	{0xA874,	0x7CFB},	// CJK UNIFIED IDEOGRAPH
	{0xA875,	0x7F55},	// CJK UNIFIED IDEOGRAPH
	{0xA876,	0x8096},	// CJK UNIFIED IDEOGRAPH
	{0xA877,	0x8093},	// CJK UNIFIED IDEOGRAPH
	{0xA878,	0x809D},	// CJK UNIFIED IDEOGRAPH
	{0xA879,	0x8098},	// CJK UNIFIED IDEOGRAPH
	{0xA87A,	0x809B},	// CJK UNIFIED IDEOGRAPH
	{0xA87B,	0x809A},	// CJK UNIFIED IDEOGRAPH
	{0xA87C,	0x80B2},	// CJK UNIFIED IDEOGRAPH
	{0xA87D,	0x826F},	// CJK UNIFIED IDEOGRAPH
	{0xA87E,	0x8292},	// CJK UNIFIED IDEOGRAPH
	{0xA8A1,	0x828B},	// CJK UNIFIED IDEOGRAPH
	{0xA8A2,	0x828D},	// CJK UNIFIED IDEOGRAPH
	{0xA8A3,	0x898B},	// CJK UNIFIED IDEOGRAPH
	{0xA8A4,	0x89D2},	// CJK UNIFIED IDEOGRAPH
	{0xA8A5,	0x8A00},	// CJK UNIFIED IDEOGRAPH
	{0xA8A6,	0x8C37},	// CJK UNIFIED IDEOGRAPH
	{0xA8A7,	0x8C46},	// CJK UNIFIED IDEOGRAPH
	{0xA8A8,	0x8C55},	// CJK UNIFIED IDEOGRAPH
	{0xA8A9,	0x8C9D},	// CJK UNIFIED IDEOGRAPH
	{0xA8AA,	0x8D64},	// CJK UNIFIED IDEOGRAPH
	{0xA8AB,	0x8D70},	// CJK UNIFIED IDEOGRAPH
	{0xA8AC,	0x8DB3},	// CJK UNIFIED IDEOGRAPH
	{0xA8AD,	0x8EAB},	// CJK UNIFIED IDEOGRAPH
	{0xA8AE,	0x8ECA},	// CJK UNIFIED IDEOGRAPH
	{0xA8AF,	0x8F9B},	// CJK UNIFIED IDEOGRAPH
	{0xA8B0,	0x8FB0},	// CJK UNIFIED IDEOGRAPH
	{0xA8B1,	0x8FC2},	// CJK UNIFIED IDEOGRAPH
	{0xA8B2,	0x8FC6},	// CJK UNIFIED IDEOGRAPH
	{0xA8B3,	0x8FC5},	// CJK UNIFIED IDEOGRAPH
	{0xA8B4,	0x8FC4},	// CJK UNIFIED IDEOGRAPH
	{0xA8B5,	0x5DE1},	// CJK UNIFIED IDEOGRAPH
	{0xA8B6,	0x9091},	// CJK UNIFIED IDEOGRAPH
	{0xA8B7,	0x90A2},	// CJK UNIFIED IDEOGRAPH
	{0xA8B8,	0x90AA},	// CJK UNIFIED IDEOGRAPH
	{0xA8B9,	0x90A6},	// CJK UNIFIED IDEOGRAPH
	{0xA8BA,	0x90A3},	// CJK UNIFIED IDEOGRAPH
	{0xA8BB,	0x9149},	// CJK UNIFIED IDEOGRAPH
	{0xA8BC,	0x91C6},	// CJK UNIFIED IDEOGRAPH
	{0xA8BD,	0x91CC},	// CJK UNIFIED IDEOGRAPH
	{0xA8BE,	0x9632},	// CJK UNIFIED IDEOGRAPH
	{0xA8BF,	0x962E},	// CJK UNIFIED IDEOGRAPH
	{0xA8C0,	0x9631},	// CJK UNIFIED IDEOGRAPH
	{0xA8C1,	0x962A},	// CJK UNIFIED IDEOGRAPH
	{0xA8C2,	0x962C},	// CJK UNIFIED IDEOGRAPH
	{0xA8C3,	0x4E26},	// CJK UNIFIED IDEOGRAPH
	{0xA8C4,	0x4E56},	// CJK UNIFIED IDEOGRAPH
	{0xA8C5,	0x4E73},	// CJK UNIFIED IDEOGRAPH
	{0xA8C6,	0x4E8B},	// CJK UNIFIED IDEOGRAPH
	{0xA8C7,	0x4E9B},	// CJK UNIFIED IDEOGRAPH
	{0xA8C8,	0x4E9E},	// CJK UNIFIED IDEOGRAPH
	{0xA8C9,	0x4EAB},	// CJK UNIFIED IDEOGRAPH
	{0xA8CA,	0x4EAC},	// CJK UNIFIED IDEOGRAPH
	{0xA8CB,	0x4F6F},	// CJK UNIFIED IDEOGRAPH
	{0xA8CC,	0x4F9D},	// CJK UNIFIED IDEOGRAPH
	{0xA8CD,	0x4F8D},	// CJK UNIFIED IDEOGRAPH
	{0xA8CE,	0x4F73},	// CJK UNIFIED IDEOGRAPH
	{0xA8CF,	0x4F7F},	// CJK UNIFIED IDEOGRAPH
	{0xA8D0,	0x4F6C},	// CJK UNIFIED IDEOGRAPH
	{0xA8D1,	0x4F9B},	// CJK UNIFIED IDEOGRAPH
	{0xA8D2,	0x4F8B},	// CJK UNIFIED IDEOGRAPH
	{0xA8D3,	0x4F86},	// CJK UNIFIED IDEOGRAPH
	{0xA8D4,	0x4F83},	// CJK UNIFIED IDEOGRAPH
	{0xA8D5,	0x4F70},	// CJK UNIFIED IDEOGRAPH
	{0xA8D6,	0x4F75},	// CJK UNIFIED IDEOGRAPH
	{0xA8D7,	0x4F88},	// CJK UNIFIED IDEOGRAPH
	{0xA8D8,	0x4F69},	// CJK UNIFIED IDEOGRAPH
	{0xA8D9,	0x4F7B},	// CJK UNIFIED IDEOGRAPH
	{0xA8DA,	0x4F96},	// CJK UNIFIED IDEOGRAPH
	{0xA8DB,	0x4F7E},	// CJK UNIFIED IDEOGRAPH
	{0xA8DC,	0x4F8F},	// CJK UNIFIED IDEOGRAPH
	{0xA8DD,	0x4F91},	// CJK UNIFIED IDEOGRAPH
	{0xA8DE,	0x4F7A},	// CJK UNIFIED IDEOGRAPH
	{0xA8DF,	0x5154},	// CJK UNIFIED IDEOGRAPH
	{0xA8E0,	0x5152},	// CJK UNIFIED IDEOGRAPH
	{0xA8E1,	0x5155},	// CJK UNIFIED IDEOGRAPH
	{0xA8E2,	0x5169},	// CJK UNIFIED IDEOGRAPH
	{0xA8E3,	0x5177},	// CJK UNIFIED IDEOGRAPH
	{0xA8E4,	0x5176},	// CJK UNIFIED IDEOGRAPH
	{0xA8E5,	0x5178},	// CJK UNIFIED IDEOGRAPH
	{0xA8E6,	0x51BD},	// CJK UNIFIED IDEOGRAPH
	{0xA8E7,	0x51FD},	// CJK UNIFIED IDEOGRAPH
	{0xA8E8,	0x523B},	// CJK UNIFIED IDEOGRAPH
	{0xA8E9,	0x5238},	// CJK UNIFIED IDEOGRAPH
	{0xA8EA,	0x5237},	// CJK UNIFIED IDEOGRAPH
	{0xA8EB,	0x523A},	// CJK UNIFIED IDEOGRAPH
	{0xA8EC,	0x5230},	// CJK UNIFIED IDEOGRAPH
	{0xA8ED,	0x522E},	// CJK UNIFIED IDEOGRAPH
	{0xA8EE,	0x5236},	// CJK UNIFIED IDEOGRAPH
	{0xA8EF,	0x5241},	// CJK UNIFIED IDEOGRAPH
	{0xA8F0,	0x52BE},	// CJK UNIFIED IDEOGRAPH
	{0xA8F1,	0x52BB},	// CJK UNIFIED IDEOGRAPH
	{0xA8F2,	0x5352},	// CJK UNIFIED IDEOGRAPH
	{0xA8F3,	0x5354},	// CJK UNIFIED IDEOGRAPH
	{0xA8F4,	0x5353},	// CJK UNIFIED IDEOGRAPH
	{0xA8F5,	0x5351},	// CJK UNIFIED IDEOGRAPH
	{0xA8F6,	0x5366},	// CJK UNIFIED IDEOGRAPH
	{0xA8F7,	0x5377},	// CJK UNIFIED IDEOGRAPH
	{0xA8F8,	0x5378},	// CJK UNIFIED IDEOGRAPH
	{0xA8F9,	0x5379},	// CJK UNIFIED IDEOGRAPH
	{0xA8FA,	0x53D6},	// CJK UNIFIED IDEOGRAPH
	{0xA8FB,	0x53D4},	// CJK UNIFIED IDEOGRAPH
	{0xA8FC,	0x53D7},	// CJK UNIFIED IDEOGRAPH
	{0xA8FD,	0x5473},	// CJK UNIFIED IDEOGRAPH
	{0xA8FE,	0x5475},	// CJK UNIFIED IDEOGRAPH
	{0xA940,	0x5496},	// CJK UNIFIED IDEOGRAPH
	{0xA941,	0x5478},	// CJK UNIFIED IDEOGRAPH
	{0xA942,	0x5495},	// CJK UNIFIED IDEOGRAPH
	{0xA943,	0x5480},	// CJK UNIFIED IDEOGRAPH
	{0xA944,	0x547B},	// CJK UNIFIED IDEOGRAPH
	{0xA945,	0x5477},	// CJK UNIFIED IDEOGRAPH
	{0xA946,	0x5484},	// CJK UNIFIED IDEOGRAPH
	{0xA947,	0x5492},	// CJK UNIFIED IDEOGRAPH
	{0xA948,	0x5486},	// CJK UNIFIED IDEOGRAPH
	{0xA949,	0x547C},	// CJK UNIFIED IDEOGRAPH
	{0xA94A,	0x5490},	// CJK UNIFIED IDEOGRAPH
	{0xA94B,	0x5471},	// CJK UNIFIED IDEOGRAPH
	{0xA94C,	0x5476},	// CJK UNIFIED IDEOGRAPH
	{0xA94D,	0x548C},	// CJK UNIFIED IDEOGRAPH
	{0xA94E,	0x549A},	// CJK UNIFIED IDEOGRAPH
	{0xA94F,	0x5462},	// CJK UNIFIED IDEOGRAPH
	{0xA950,	0x5468},	// CJK UNIFIED IDEOGRAPH
	{0xA951,	0x548B},	// CJK UNIFIED IDEOGRAPH
	{0xA952,	0x547D},	// CJK UNIFIED IDEOGRAPH
	{0xA953,	0x548E},	// CJK UNIFIED IDEOGRAPH
	{0xA954,	0x56FA},	// CJK UNIFIED IDEOGRAPH
	{0xA955,	0x5783},	// CJK UNIFIED IDEOGRAPH
	{0xA956,	0x5777},	// CJK UNIFIED IDEOGRAPH
	{0xA957,	0x576A},	// CJK UNIFIED IDEOGRAPH
	{0xA958,	0x5769},	// CJK UNIFIED IDEOGRAPH
	{0xA959,	0x5761},	// CJK UNIFIED IDEOGRAPH
	{0xA95A,	0x5766},	// CJK UNIFIED IDEOGRAPH
	{0xA95B,	0x5764},	// CJK UNIFIED IDEOGRAPH
	{0xA95C,	0x577C},	// CJK UNIFIED IDEOGRAPH
	{0xA95D,	0x591C},	// CJK UNIFIED IDEOGRAPH
	{0xA95E,	0x5949},	// CJK UNIFIED IDEOGRAPH
	{0xA95F,	0x5947},	// CJK UNIFIED IDEOGRAPH
	{0xA960,	0x5948},	// CJK UNIFIED IDEOGRAPH
	{0xA961,	0x5944},	// CJK UNIFIED IDEOGRAPH
	{0xA962,	0x5954},	// CJK UNIFIED IDEOGRAPH
	{0xA963,	0x59BE},	// CJK UNIFIED IDEOGRAPH
	{0xA964,	0x59BB},	// CJK UNIFIED IDEOGRAPH
	{0xA965,	0x59D4},	// CJK UNIFIED IDEOGRAPH
	{0xA966,	0x59B9},	// CJK UNIFIED IDEOGRAPH
	{0xA967,	0x59AE},	// CJK UNIFIED IDEOGRAPH
	{0xA968,	0x59D1},	// CJK UNIFIED IDEOGRAPH
	{0xA969,	0x59C6},	// CJK UNIFIED IDEOGRAPH
	{0xA96A,	0x59D0},	// CJK UNIFIED IDEOGRAPH
	{0xA96B,	0x59CD},	// CJK UNIFIED IDEOGRAPH
	{0xA96C,	0x59CB},	// CJK UNIFIED IDEOGRAPH
	{0xA96D,	0x59D3},	// CJK UNIFIED IDEOGRAPH
	{0xA96E,	0x59CA},	// CJK UNIFIED IDEOGRAPH
	{0xA96F,	0x59AF},	// CJK UNIFIED IDEOGRAPH
	{0xA970,	0x59B3},	// CJK UNIFIED IDEOGRAPH
	{0xA971,	0x59D2},	// CJK UNIFIED IDEOGRAPH
	{0xA972,	0x59C5},	// CJK UNIFIED IDEOGRAPH
	{0xA973,	0x5B5F},	// CJK UNIFIED IDEOGRAPH
	{0xA974,	0x5B64},	// CJK UNIFIED IDEOGRAPH
	{0xA975,	0x5B63},	// CJK UNIFIED IDEOGRAPH
	{0xA976,	0x5B97},	// CJK UNIFIED IDEOGRAPH
	{0xA977,	0x5B9A},	// CJK UNIFIED IDEOGRAPH
	{0xA978,	0x5B98},	// CJK UNIFIED IDEOGRAPH
	{0xA979,	0x5B9C},	// CJK UNIFIED IDEOGRAPH
	{0xA97A,	0x5B99},	// CJK UNIFIED IDEOGRAPH
	{0xA97B,	0x5B9B},	// CJK UNIFIED IDEOGRAPH
	{0xA97C,	0x5C1A},	// CJK UNIFIED IDEOGRAPH
	{0xA97D,	0x5C48},	// CJK UNIFIED IDEOGRAPH
	{0xA97E,	0x5C45},	// CJK UNIFIED IDEOGRAPH
	{0xA9A1,	0x5C46},	// CJK UNIFIED IDEOGRAPH
	{0xA9A2,	0x5CB7},	// CJK UNIFIED IDEOGRAPH
	{0xA9A3,	0x5CA1},	// CJK UNIFIED IDEOGRAPH
	{0xA9A4,	0x5CB8},	// CJK UNIFIED IDEOGRAPH
	{0xA9A5,	0x5CA9},	// CJK UNIFIED IDEOGRAPH
	{0xA9A6,	0x5CAB},	// CJK UNIFIED IDEOGRAPH
	{0xA9A7,	0x5CB1},	// CJK UNIFIED IDEOGRAPH
	{0xA9A8,	0x5CB3},	// CJK UNIFIED IDEOGRAPH
	{0xA9A9,	0x5E18},	// CJK UNIFIED IDEOGRAPH
	{0xA9AA,	0x5E1A},	// CJK UNIFIED IDEOGRAPH
	{0xA9AB,	0x5E16},	// CJK UNIFIED IDEOGRAPH
	{0xA9AC,	0x5E15},	// CJK UNIFIED IDEOGRAPH
	{0xA9AD,	0x5E1B},	// CJK UNIFIED IDEOGRAPH
	{0xA9AE,	0x5E11},	// CJK UNIFIED IDEOGRAPH
	{0xA9AF,	0x5E78},	// CJK UNIFIED IDEOGRAPH
	{0xA9B0,	0x5E9A},	// CJK UNIFIED IDEOGRAPH
	{0xA9B1,	0x5E97},	// CJK UNIFIED IDEOGRAPH
	{0xA9B2,	0x5E9C},	// CJK UNIFIED IDEOGRAPH
	{0xA9B3,	0x5E95},	// CJK UNIFIED IDEOGRAPH
	{0xA9B4,	0x5E96},	// CJK UNIFIED IDEOGRAPH
	{0xA9B5,	0x5EF6},	// CJK UNIFIED IDEOGRAPH
	{0xA9B6,	0x5F26},	// CJK UNIFIED IDEOGRAPH
	{0xA9B7,	0x5F27},	// CJK UNIFIED IDEOGRAPH
	{0xA9B8,	0x5F29},	// CJK UNIFIED IDEOGRAPH
	{0xA9B9,	0x5F80},	// CJK UNIFIED IDEOGRAPH
	{0xA9BA,	0x5F81},	// CJK UNIFIED IDEOGRAPH
	{0xA9BB,	0x5F7F},	// CJK UNIFIED IDEOGRAPH
	{0xA9BC,	0x5F7C},	// CJK UNIFIED IDEOGRAPH
	{0xA9BD,	0x5FDD},	// CJK UNIFIED IDEOGRAPH
	{0xA9BE,	0x5FE0},	// CJK UNIFIED IDEOGRAPH
	{0xA9BF,	0x5FFD},	// CJK UNIFIED IDEOGRAPH
	{0xA9C0,	0x5FF5},	// CJK UNIFIED IDEOGRAPH
	{0xA9C1,	0x5FFF},	// CJK UNIFIED IDEOGRAPH
	{0xA9C2,	0x600F},	// CJK UNIFIED IDEOGRAPH
	{0xA9C3,	0x6014},	// CJK UNIFIED IDEOGRAPH
	{0xA9C4,	0x602F},	// CJK UNIFIED IDEOGRAPH
	{0xA9C5,	0x6035},	// CJK UNIFIED IDEOGRAPH
	{0xA9C6,	0x6016},	// CJK UNIFIED IDEOGRAPH
	{0xA9C7,	0x602A},	// CJK UNIFIED IDEOGRAPH
	{0xA9C8,	0x6015},	// CJK UNIFIED IDEOGRAPH
	{0xA9C9,	0x6021},	// CJK UNIFIED IDEOGRAPH
	{0xA9CA,	0x6027},	// CJK UNIFIED IDEOGRAPH
	{0xA9CB,	0x6029},	// CJK UNIFIED IDEOGRAPH
	{0xA9CC,	0x602B},	// CJK UNIFIED IDEOGRAPH
	{0xA9CD,	0x601B},	// CJK UNIFIED IDEOGRAPH
	{0xA9CE,	0x6216},	// CJK UNIFIED IDEOGRAPH
	{0xA9CF,	0x6215},	// CJK UNIFIED IDEOGRAPH
	{0xA9D0,	0x623F},	// CJK UNIFIED IDEOGRAPH
	{0xA9D1,	0x623E},	// CJK UNIFIED IDEOGRAPH
	{0xA9D2,	0x6240},	// CJK UNIFIED IDEOGRAPH
	{0xA9D3,	0x627F},	// CJK UNIFIED IDEOGRAPH
	{0xA9D4,	0x62C9},	// CJK UNIFIED IDEOGRAPH
	{0xA9D5,	0x62CC},	// CJK UNIFIED IDEOGRAPH
	{0xA9D6,	0x62C4},	// CJK UNIFIED IDEOGRAPH
	{0xA9D7,	0x62BF},	// CJK UNIFIED IDEOGRAPH
	{0xA9D8,	0x62C2},	// CJK UNIFIED IDEOGRAPH
	{0xA9D9,	0x62B9},	// CJK UNIFIED IDEOGRAPH
	{0xA9DA,	0x62D2},	// CJK UNIFIED IDEOGRAPH
	{0xA9DB,	0x62DB},	// CJK UNIFIED IDEOGRAPH
	{0xA9DC,	0x62AB},	// CJK UNIFIED IDEOGRAPH
	{0xA9DD,	0x62D3},	// CJK UNIFIED IDEOGRAPH
	{0xA9DE,	0x62D4},	// CJK UNIFIED IDEOGRAPH
	{0xA9DF,	0x62CB},	// CJK UNIFIED IDEOGRAPH
	{0xA9E0,	0x62C8},	// CJK UNIFIED IDEOGRAPH
	{0xA9E1,	0x62A8},	// CJK UNIFIED IDEOGRAPH
	{0xA9E2,	0x62BD},	// CJK UNIFIED IDEOGRAPH
	{0xA9E3,	0x62BC},	// CJK UNIFIED IDEOGRAPH
	{0xA9E4,	0x62D0},	// CJK UNIFIED IDEOGRAPH
	{0xA9E5,	0x62D9},	// CJK UNIFIED IDEOGRAPH
	{0xA9E6,	0x62C7},	// CJK UNIFIED IDEOGRAPH
	{0xA9E7,	0x62CD},	// CJK UNIFIED IDEOGRAPH
	{0xA9E8,	0x62B5},	// CJK UNIFIED IDEOGRAPH
	{0xA9E9,	0x62DA},	// CJK UNIFIED IDEOGRAPH
	{0xA9EA,	0x62B1},	// CJK UNIFIED IDEOGRAPH
	{0xA9EB,	0x62D8},	// CJK UNIFIED IDEOGRAPH
	{0xA9EC,	0x62D6},	// CJK UNIFIED IDEOGRAPH
	{0xA9ED,	0x62D7},	// CJK UNIFIED IDEOGRAPH
	{0xA9EE,	0x62C6},	// CJK UNIFIED IDEOGRAPH
	{0xA9EF,	0x62AC},	// CJK UNIFIED IDEOGRAPH
	{0xA9F0,	0x62CE},	// CJK UNIFIED IDEOGRAPH
	{0xA9F1,	0x653E},	// CJK UNIFIED IDEOGRAPH
	{0xA9F2,	0x65A7},	// CJK UNIFIED IDEOGRAPH
	{0xA9F3,	0x65BC},	// CJK UNIFIED IDEOGRAPH
	{0xA9F4,	0x65FA},	// CJK UNIFIED IDEOGRAPH
	{0xA9F5,	0x6614},	// CJK UNIFIED IDEOGRAPH
	{0xA9F6,	0x6613},	// CJK UNIFIED IDEOGRAPH
	{0xA9F7,	0x660C},	// CJK UNIFIED IDEOGRAPH
	{0xA9F8,	0x6606},	// CJK UNIFIED IDEOGRAPH
	{0xA9F9,	0x6602},	// CJK UNIFIED IDEOGRAPH
	{0xA9FA,	0x660E},	// CJK UNIFIED IDEOGRAPH
	{0xA9FB,	0x6600},	// CJK UNIFIED IDEOGRAPH
	{0xA9FC,	0x660F},	// CJK UNIFIED IDEOGRAPH
	{0xA9FD,	0x6615},	// CJK UNIFIED IDEOGRAPH
	{0xA9FE,	0x660A},	// CJK UNIFIED IDEOGRAPH
	{0xAA40,	0x6607},	// CJK UNIFIED IDEOGRAPH
	{0xAA41,	0x670D},	// CJK UNIFIED IDEOGRAPH
	{0xAA42,	0x670B},	// CJK UNIFIED IDEOGRAPH
	{0xAA43,	0x676D},	// CJK UNIFIED IDEOGRAPH
	{0xAA44,	0x678B},	// CJK UNIFIED IDEOGRAPH
	{0xAA45,	0x6795},	// CJK UNIFIED IDEOGRAPH
	{0xAA46,	0x6771},	// CJK UNIFIED IDEOGRAPH
	{0xAA47,	0x679C},	// CJK UNIFIED IDEOGRAPH
	{0xAA48,	0x6773},	// CJK UNIFIED IDEOGRAPH
	{0xAA49,	0x6777},	// CJK UNIFIED IDEOGRAPH
	{0xAA4A,	0x6787},	// CJK UNIFIED IDEOGRAPH
	{0xAA4B,	0x679D},	// CJK UNIFIED IDEOGRAPH
	{0xAA4C,	0x6797},	// CJK UNIFIED IDEOGRAPH
	{0xAA4D,	0x676F},	// CJK UNIFIED IDEOGRAPH
	{0xAA4E,	0x6770},	// CJK UNIFIED IDEOGRAPH
	{0xAA4F,	0x677F},	// CJK UNIFIED IDEOGRAPH
	{0xAA50,	0x6789},	// CJK UNIFIED IDEOGRAPH
	{0xAA51,	0x677E},	// CJK UNIFIED IDEOGRAPH
	{0xAA52,	0x6790},	// CJK UNIFIED IDEOGRAPH
	{0xAA53,	0x6775},	// CJK UNIFIED IDEOGRAPH
	{0xAA54,	0x679A},	// CJK UNIFIED IDEOGRAPH
	{0xAA55,	0x6793},	// CJK UNIFIED IDEOGRAPH
	{0xAA56,	0x677C},	// CJK UNIFIED IDEOGRAPH
	{0xAA57,	0x676A},	// CJK UNIFIED IDEOGRAPH
	{0xAA58,	0x6772},	// CJK UNIFIED IDEOGRAPH
	{0xAA59,	0x6B23},	// CJK UNIFIED IDEOGRAPH
	{0xAA5A,	0x6B66},	// CJK UNIFIED IDEOGRAPH
	{0xAA5B,	0x6B67},	// CJK UNIFIED IDEOGRAPH
	{0xAA5C,	0x6B7F},	// CJK UNIFIED IDEOGRAPH
	{0xAA5D,	0x6C13},	// CJK UNIFIED IDEOGRAPH
	{0xAA5E,	0x6C1B},	// CJK UNIFIED IDEOGRAPH
	{0xAA5F,	0x6CE3},	// CJK UNIFIED IDEOGRAPH
	{0xAA60,	0x6CE8},	// CJK UNIFIED IDEOGRAPH
	{0xAA61,	0x6CF3},	// CJK UNIFIED IDEOGRAPH
	{0xAA62,	0x6CB1},	// CJK UNIFIED IDEOGRAPH
	{0xAA63,	0x6CCC},	// CJK UNIFIED IDEOGRAPH
	{0xAA64,	0x6CE5},	// CJK UNIFIED IDEOGRAPH
	{0xAA65,	0x6CB3},	// CJK UNIFIED IDEOGRAPH
	{0xAA66,	0x6CBD},	// CJK UNIFIED IDEOGRAPH
	{0xAA67,	0x6CBE},	// CJK UNIFIED IDEOGRAPH
	{0xAA68,	0x6CBC},	// CJK UNIFIED IDEOGRAPH
	{0xAA69,	0x6CE2},	// CJK UNIFIED IDEOGRAPH
	{0xAA6A,	0x6CAB},	// CJK UNIFIED IDEOGRAPH
	{0xAA6B,	0x6CD5},	// CJK UNIFIED IDEOGRAPH
	{0xAA6C,	0x6CD3},	// CJK UNIFIED IDEOGRAPH
	{0xAA6D,	0x6CB8},	// CJK UNIFIED IDEOGRAPH
	{0xAA6E,	0x6CC4},	// CJK UNIFIED IDEOGRAPH
	{0xAA6F,	0x6CB9},	// CJK UNIFIED IDEOGRAPH
	{0xAA70,	0x6CC1},	// CJK UNIFIED IDEOGRAPH
	{0xAA71,	0x6CAE},	// CJK UNIFIED IDEOGRAPH
	{0xAA72,	0x6CD7},	// CJK UNIFIED IDEOGRAPH
	{0xAA73,	0x6CC5},	// CJK UNIFIED IDEOGRAPH
	{0xAA74,	0x6CF1},	// CJK UNIFIED IDEOGRAPH
	{0xAA75,	0x6CBF},	// CJK UNIFIED IDEOGRAPH
	{0xAA76,	0x6CBB},	// CJK UNIFIED IDEOGRAPH
	{0xAA77,	0x6CE1},	// CJK UNIFIED IDEOGRAPH
	{0xAA78,	0x6CDB},	// CJK UNIFIED IDEOGRAPH
	{0xAA79,	0x6CCA},	// CJK UNIFIED IDEOGRAPH
	{0xAA7A,	0x6CAC},	// CJK UNIFIED IDEOGRAPH
	{0xAA7B,	0x6CEF},	// CJK UNIFIED IDEOGRAPH
	{0xAA7C,	0x6CDC},	// CJK UNIFIED IDEOGRAPH
	{0xAA7D,	0x6CD6},	// CJK UNIFIED IDEOGRAPH
	{0xAA7E,	0x6CE0},	// CJK UNIFIED IDEOGRAPH
	{0xAAA1,	0x7095},	// CJK UNIFIED IDEOGRAPH
	{0xAAA2,	0x708E},	// CJK UNIFIED IDEOGRAPH
	{0xAAA3,	0x7092},	// CJK UNIFIED IDEOGRAPH
	{0xAAA4,	0x708A},	// CJK UNIFIED IDEOGRAPH
	{0xAAA5,	0x7099},	// CJK UNIFIED IDEOGRAPH
	{0xAAA6,	0x722C},	// CJK UNIFIED IDEOGRAPH
	{0xAAA7,	0x722D},	// CJK UNIFIED IDEOGRAPH
	{0xAAA8,	0x7238},	// CJK UNIFIED IDEOGRAPH
	{0xAAA9,	0x7248},	// CJK UNIFIED IDEOGRAPH
	{0xAAAA,	0x7267},	// CJK UNIFIED IDEOGRAPH
	{0xAAAB,	0x7269},	// CJK UNIFIED IDEOGRAPH
	{0xAAAC,	0x72C0},	// CJK UNIFIED IDEOGRAPH
	{0xAAAD,	0x72CE},	// CJK UNIFIED IDEOGRAPH
	{0xAAAE,	0x72D9},	// CJK UNIFIED IDEOGRAPH
	{0xAAAF,	0x72D7},	// CJK UNIFIED IDEOGRAPH
	{0xAAB0,	0x72D0},	// CJK UNIFIED IDEOGRAPH
	{0xAAB1,	0x73A9},	// CJK UNIFIED IDEOGRAPH
	{0xAAB2,	0x73A8},	// CJK UNIFIED IDEOGRAPH
	{0xAAB3,	0x739F},	// CJK UNIFIED IDEOGRAPH
	{0xAAB4,	0x73AB},	// CJK UNIFIED IDEOGRAPH
	{0xAAB5,	0x73A5},	// CJK UNIFIED IDEOGRAPH
	{0xAAB6,	0x753D},	// CJK UNIFIED IDEOGRAPH
	{0xAAB7,	0x759D},	// CJK UNIFIED IDEOGRAPH
	{0xAAB8,	0x7599},	// CJK UNIFIED IDEOGRAPH
	{0xAAB9,	0x759A},	// CJK UNIFIED IDEOGRAPH
	{0xAABA,	0x7684},	// CJK UNIFIED IDEOGRAPH
	{0xAABB,	0x76C2},	// CJK UNIFIED IDEOGRAPH
	{0xAABC,	0x76F2},	// CJK UNIFIED IDEOGRAPH
	{0xAABD,	0x76F4},	// CJK UNIFIED IDEOGRAPH
	{0xAABE,	0x77E5},	// CJK UNIFIED IDEOGRAPH
	{0xAABF,	0x77FD},	// CJK UNIFIED IDEOGRAPH
	{0xAAC0,	0x793E},	// CJK UNIFIED IDEOGRAPH
	{0xAAC1,	0x7940},	// CJK UNIFIED IDEOGRAPH
	{0xAAC2,	0x7941},	// CJK UNIFIED IDEOGRAPH
	{0xAAC3,	0x79C9},	// CJK UNIFIED IDEOGRAPH
	{0xAAC4,	0x79C8},	// CJK UNIFIED IDEOGRAPH
	{0xAAC5,	0x7A7A},	// CJK UNIFIED IDEOGRAPH
	{0xAAC6,	0x7A79},	// CJK UNIFIED IDEOGRAPH
	{0xAAC7,	0x7AFA},	// CJK UNIFIED IDEOGRAPH
	{0xAAC8,	0x7CFE},	// CJK UNIFIED IDEOGRAPH
	{0xAAC9,	0x7F54},	// CJK UNIFIED IDEOGRAPH
	{0xAACA,	0x7F8C},	// CJK UNIFIED IDEOGRAPH
	{0xAACB,	0x7F8B},	// CJK UNIFIED IDEOGRAPH
	{0xAACC,	0x8005},	// CJK UNIFIED IDEOGRAPH
	{0xAACD,	0x80BA},	// CJK UNIFIED IDEOGRAPH
	{0xAACE,	0x80A5},	// CJK UNIFIED IDEOGRAPH
	{0xAACF,	0x80A2},	// CJK UNIFIED IDEOGRAPH
	{0xAAD0,	0x80B1},	// CJK UNIFIED IDEOGRAPH
	{0xAAD1,	0x80A1},	// CJK UNIFIED IDEOGRAPH
	{0xAAD2,	0x80AB},	// CJK UNIFIED IDEOGRAPH
	{0xAAD3,	0x80A9},	// CJK UNIFIED IDEOGRAPH
	{0xAAD4,	0x80B4},	// CJK UNIFIED IDEOGRAPH
	{0xAAD5,	0x80AA},	// CJK UNIFIED IDEOGRAPH
	{0xAAD6,	0x80AF},	// CJK UNIFIED IDEOGRAPH
	{0xAAD7,	0x81E5},	// CJK UNIFIED IDEOGRAPH
	{0xAAD8,	0x81FE},	// CJK UNIFIED IDEOGRAPH
	{0xAAD9,	0x820D},	// CJK UNIFIED IDEOGRAPH
	{0xAADA,	0x82B3},	// CJK UNIFIED IDEOGRAPH
	{0xAADB,	0x829D},	// CJK UNIFIED IDEOGRAPH
	{0xAADC,	0x8299},	// CJK UNIFIED IDEOGRAPH
	{0xAADD,	0x82AD},	// CJK UNIFIED IDEOGRAPH
	{0xAADE,	0x82BD},	// CJK UNIFIED IDEOGRAPH
	{0xAADF,	0x829F},	// CJK UNIFIED IDEOGRAPH
	{0xAAE0,	0x82B9},	// CJK UNIFIED IDEOGRAPH
	{0xAAE1,	0x82B1},	// CJK UNIFIED IDEOGRAPH
	{0xAAE2,	0x82AC},	// CJK UNIFIED IDEOGRAPH
	{0xAAE3,	0x82A5},	// CJK UNIFIED IDEOGRAPH
	{0xAAE4,	0x82AF},	// CJK UNIFIED IDEOGRAPH
	{0xAAE5,	0x82B8},	// CJK UNIFIED IDEOGRAPH
	{0xAAE6,	0x82A3},	// CJK UNIFIED IDEOGRAPH
	{0xAAE7,	0x82B0},	// CJK UNIFIED IDEOGRAPH
	{0xAAE8,	0x82BE},	// CJK UNIFIED IDEOGRAPH
	{0xAAE9,	0x82B7},	// CJK UNIFIED IDEOGRAPH
	{0xAAEA,	0x864E},	// CJK UNIFIED IDEOGRAPH
	{0xAAEB,	0x8671},	// CJK UNIFIED IDEOGRAPH
	{0xAAEC,	0x521D},	// CJK UNIFIED IDEOGRAPH
	{0xAAED,	0x8868},	// CJK UNIFIED IDEOGRAPH
	{0xAAEE,	0x8ECB},	// CJK UNIFIED IDEOGRAPH
	{0xAAEF,	0x8FCE},	// CJK UNIFIED IDEOGRAPH
	{0xAAF0,	0x8FD4},	// CJK UNIFIED IDEOGRAPH
	{0xAAF1,	0x8FD1},	// CJK UNIFIED IDEOGRAPH
	{0xAAF2,	0x90B5},	// CJK UNIFIED IDEOGRAPH
	{0xAAF3,	0x90B8},	// CJK UNIFIED IDEOGRAPH
	{0xAAF4,	0x90B1},	// CJK UNIFIED IDEOGRAPH
	{0xAAF5,	0x90B6},	// CJK UNIFIED IDEOGRAPH
	{0xAAF6,	0x91C7},	// CJK UNIFIED IDEOGRAPH
	{0xAAF7,	0x91D1},	// CJK UNIFIED IDEOGRAPH
	{0xAAF8,	0x9577},	// CJK UNIFIED IDEOGRAPH
	{0xAAF9,	0x9580},	// CJK UNIFIED IDEOGRAPH
	{0xAAFA,	0x961C},	// CJK UNIFIED IDEOGRAPH
	{0xAAFB,	0x9640},	// CJK UNIFIED IDEOGRAPH
	{0xAAFC,	0x963F},	// CJK UNIFIED IDEOGRAPH
	{0xAAFD,	0x963B},	// CJK UNIFIED IDEOGRAPH
	{0xAAFE,	0x9644},	// CJK UNIFIED IDEOGRAPH
	{0xAB40,	0x9642},	// CJK UNIFIED IDEOGRAPH
	{0xAB41,	0x96B9},	// CJK UNIFIED IDEOGRAPH
	{0xAB42,	0x96E8},	// CJK UNIFIED IDEOGRAPH
	{0xAB43,	0x9752},	// CJK UNIFIED IDEOGRAPH
	{0xAB44,	0x975E},	// CJK UNIFIED IDEOGRAPH
	{0xAB45,	0x4E9F},	// CJK UNIFIED IDEOGRAPH
	{0xAB46,	0x4EAD},	// CJK UNIFIED IDEOGRAPH
	{0xAB47,	0x4EAE},	// CJK UNIFIED IDEOGRAPH
	{0xAB48,	0x4FE1},	// CJK UNIFIED IDEOGRAPH
	{0xAB49,	0x4FB5},	// CJK UNIFIED IDEOGRAPH
	{0xAB4A,	0x4FAF},	// CJK UNIFIED IDEOGRAPH
	{0xAB4B,	0x4FBF},	// CJK UNIFIED IDEOGRAPH
	{0xAB4C,	0x4FE0},	// CJK UNIFIED IDEOGRAPH
	{0xAB4D,	0x4FD1},	// CJK UNIFIED IDEOGRAPH
	{0xAB4E,	0x4FCF},	// CJK UNIFIED IDEOGRAPH
	{0xAB4F,	0x4FDD},	// CJK UNIFIED IDEOGRAPH
	{0xAB50,	0x4FC3},	// CJK UNIFIED IDEOGRAPH
	{0xAB51,	0x4FB6},	// CJK UNIFIED IDEOGRAPH
	{0xAB52,	0x4FD8},	// CJK UNIFIED IDEOGRAPH
	{0xAB53,	0x4FDF},	// CJK UNIFIED IDEOGRAPH
	{0xAB54,	0x4FCA},	// CJK UNIFIED IDEOGRAPH
	{0xAB55,	0x4FD7},	// CJK UNIFIED IDEOGRAPH
	{0xAB56,	0x4FAE},	// CJK UNIFIED IDEOGRAPH
	{0xAB57,	0x4FD0},	// CJK UNIFIED IDEOGRAPH
	{0xAB58,	0x4FC4},	// CJK UNIFIED IDEOGRAPH
	{0xAB59,	0x4FC2},	// CJK UNIFIED IDEOGRAPH
	{0xAB5A,	0x4FDA},	// CJK UNIFIED IDEOGRAPH
	{0xAB5B,	0x4FCE},	// CJK UNIFIED IDEOGRAPH
	{0xAB5C,	0x4FDE},	// CJK UNIFIED IDEOGRAPH
	{0xAB5D,	0x4FB7},	// CJK UNIFIED IDEOGRAPH
	{0xAB5E,	0x5157},	// CJK UNIFIED IDEOGRAPH
	{0xAB5F,	0x5192},	// CJK UNIFIED IDEOGRAPH
	{0xAB60,	0x5191},	// CJK UNIFIED IDEOGRAPH
	{0xAB61,	0x51A0},	// CJK UNIFIED IDEOGRAPH
	{0xAB62,	0x524E},	// CJK UNIFIED IDEOGRAPH
	{0xAB63,	0x5243},	// CJK UNIFIED IDEOGRAPH
	{0xAB64,	0x524A},	// CJK UNIFIED IDEOGRAPH
	{0xAB65,	0x524D},	// CJK UNIFIED IDEOGRAPH
	{0xAB66,	0x524C},	// CJK UNIFIED IDEOGRAPH
	{0xAB67,	0x524B},	// CJK UNIFIED IDEOGRAPH
	{0xAB68,	0x5247},	// CJK UNIFIED IDEOGRAPH
	{0xAB69,	0x52C7},	// CJK UNIFIED IDEOGRAPH
	{0xAB6A,	0x52C9},	// CJK UNIFIED IDEOGRAPH
	{0xAB6B,	0x52C3},	// CJK UNIFIED IDEOGRAPH
	{0xAB6C,	0x52C1},	// CJK UNIFIED IDEOGRAPH
	{0xAB6D,	0x530D},	// CJK UNIFIED IDEOGRAPH
	{0xAB6E,	0x5357},	// CJK UNIFIED IDEOGRAPH
	{0xAB6F,	0x537B},	// CJK UNIFIED IDEOGRAPH
	{0xAB70,	0x539A},	// CJK UNIFIED IDEOGRAPH
	{0xAB71,	0x53DB},	// CJK UNIFIED IDEOGRAPH
	{0xAB72,	0x54AC},	// CJK UNIFIED IDEOGRAPH
	{0xAB73,	0x54C0},	// CJK UNIFIED IDEOGRAPH
	{0xAB74,	0x54A8},	// CJK UNIFIED IDEOGRAPH
	{0xAB75,	0x54CE},	// CJK UNIFIED IDEOGRAPH
	{0xAB76,	0x54C9},	// CJK UNIFIED IDEOGRAPH
	{0xAB77,	0x54B8},	// CJK UNIFIED IDEOGRAPH
	{0xAB78,	0x54A6},	// CJK UNIFIED IDEOGRAPH
	{0xAB79,	0x54B3},	// CJK UNIFIED IDEOGRAPH
	{0xAB7A,	0x54C7},	// CJK UNIFIED IDEOGRAPH
	{0xAB7B,	0x54C2},	// CJK UNIFIED IDEOGRAPH
	{0xAB7C,	0x54BD},	// CJK UNIFIED IDEOGRAPH
	{0xAB7D,	0x54AA},	// CJK UNIFIED IDEOGRAPH
	{0xAB7E,	0x54C1},	// CJK UNIFIED IDEOGRAPH
	{0xABA1,	0x54C4},	// CJK UNIFIED IDEOGRAPH
	{0xABA2,	0x54C8},	// CJK UNIFIED IDEOGRAPH
	{0xABA3,	0x54AF},	// CJK UNIFIED IDEOGRAPH
	{0xABA4,	0x54AB},	// CJK UNIFIED IDEOGRAPH
	{0xABA5,	0x54B1},	// CJK UNIFIED IDEOGRAPH
	{0xABA6,	0x54BB},	// CJK UNIFIED IDEOGRAPH
	{0xABA7,	0x54A9},	// CJK UNIFIED IDEOGRAPH
	{0xABA8,	0x54A7},	// CJK UNIFIED IDEOGRAPH
	{0xABA9,	0x54BF},	// CJK UNIFIED IDEOGRAPH
	{0xABAA,	0x56FF},	// CJK UNIFIED IDEOGRAPH
	{0xABAB,	0x5782},	// CJK UNIFIED IDEOGRAPH
	{0xABAC,	0x578B},	// CJK UNIFIED IDEOGRAPH
	{0xABAD,	0x57A0},	// CJK UNIFIED IDEOGRAPH
	{0xABAE,	0x57A3},	// CJK UNIFIED IDEOGRAPH
	{0xABAF,	0x57A2},	// CJK UNIFIED IDEOGRAPH
	{0xABB0,	0x57CE},	// CJK UNIFIED IDEOGRAPH
	{0xABB1,	0x57AE},	// CJK UNIFIED IDEOGRAPH
	{0xABB2,	0x5793},	// CJK UNIFIED IDEOGRAPH
	{0xABB3,	0x5955},	// CJK UNIFIED IDEOGRAPH
	{0xABB4,	0x5951},	// CJK UNIFIED IDEOGRAPH
	{0xABB5,	0x594F},	// CJK UNIFIED IDEOGRAPH
	{0xABB6,	0x594E},	// CJK UNIFIED IDEOGRAPH
	{0xABB7,	0x5950},	// CJK UNIFIED IDEOGRAPH
	{0xABB8,	0x59DC},	// CJK UNIFIED IDEOGRAPH
	{0xABB9,	0x59D8},	// CJK UNIFIED IDEOGRAPH
	{0xABBA,	0x59FF},	// CJK UNIFIED IDEOGRAPH
	{0xABBB,	0x59E3},	// CJK UNIFIED IDEOGRAPH
	{0xABBC,	0x59E8},	// CJK UNIFIED IDEOGRAPH
	{0xABBD,	0x5A03},	// CJK UNIFIED IDEOGRAPH
	{0xABBE,	0x59E5},	// CJK UNIFIED IDEOGRAPH
	{0xABBF,	0x59EA},	// CJK UNIFIED IDEOGRAPH
	{0xABC0,	0x59DA},	// CJK UNIFIED IDEOGRAPH
	{0xABC1,	0x59E6},	// CJK UNIFIED IDEOGRAPH
	{0xABC2,	0x5A01},	// CJK UNIFIED IDEOGRAPH
	{0xABC3,	0x59FB},	// CJK UNIFIED IDEOGRAPH
	{0xABC4,	0x5B69},	// CJK UNIFIED IDEOGRAPH
	{0xABC5,	0x5BA3},	// CJK UNIFIED IDEOGRAPH
	{0xABC6,	0x5BA6},	// CJK UNIFIED IDEOGRAPH
	{0xABC7,	0x5BA4},	// CJK UNIFIED IDEOGRAPH
	{0xABC8,	0x5BA2},	// CJK UNIFIED IDEOGRAPH
	{0xABC9,	0x5BA5},	// CJK UNIFIED IDEOGRAPH
	{0xABCA,	0x5C01},	// CJK UNIFIED IDEOGRAPH
	{0xABCB,	0x5C4E},	// CJK UNIFIED IDEOGRAPH
	{0xABCC,	0x5C4F},	// CJK UNIFIED IDEOGRAPH
	{0xABCD,	0x5C4D},	// CJK UNIFIED IDEOGRAPH
	{0xABCE,	0x5C4B},	// CJK UNIFIED IDEOGRAPH
	{0xABCF,	0x5CD9},	// CJK UNIFIED IDEOGRAPH
	{0xABD0,	0x5CD2},	// CJK UNIFIED IDEOGRAPH
	{0xABD1,	0x5DF7},	// CJK UNIFIED IDEOGRAPH
	{0xABD2,	0x5E1D},	// CJK UNIFIED IDEOGRAPH
	{0xABD3,	0x5E25},	// CJK UNIFIED IDEOGRAPH
	{0xABD4,	0x5E1F},	// CJK UNIFIED IDEOGRAPH
	{0xABD5,	0x5E7D},	// CJK UNIFIED IDEOGRAPH
	{0xABD6,	0x5EA0},	// CJK UNIFIED IDEOGRAPH
	{0xABD7,	0x5EA6},	// CJK UNIFIED IDEOGRAPH
	{0xABD8,	0x5EFA},	// CJK UNIFIED IDEOGRAPH
	{0xABD9,	0x5F08},	// CJK UNIFIED IDEOGRAPH
	{0xABDA,	0x5F2D},	// CJK UNIFIED IDEOGRAPH
	{0xABDB,	0x5F65},	// CJK UNIFIED IDEOGRAPH
	{0xABDC,	0x5F88},	// CJK UNIFIED IDEOGRAPH
	{0xABDD,	0x5F85},	// CJK UNIFIED IDEOGRAPH
	{0xABDE,	0x5F8A},	// CJK UNIFIED IDEOGRAPH
	{0xABDF,	0x5F8B},	// CJK UNIFIED IDEOGRAPH
	{0xABE0,	0x5F87},	// CJK UNIFIED IDEOGRAPH
	{0xABE1,	0x5F8C},	// CJK UNIFIED IDEOGRAPH
	{0xABE2,	0x5F89},	// CJK UNIFIED IDEOGRAPH
	{0xABE3,	0x6012},	// CJK UNIFIED IDEOGRAPH
	{0xABE4,	0x601D},	// CJK UNIFIED IDEOGRAPH
	{0xABE5,	0x6020},	// CJK UNIFIED IDEOGRAPH
	{0xABE6,	0x6025},	// CJK UNIFIED IDEOGRAPH
	{0xABE7,	0x600E},	// CJK UNIFIED IDEOGRAPH
	{0xABE8,	0x6028},	// CJK UNIFIED IDEOGRAPH
	{0xABE9,	0x604D},	// CJK UNIFIED IDEOGRAPH
	{0xABEA,	0x6070},	// CJK UNIFIED IDEOGRAPH
	{0xABEB,	0x6068},	// CJK UNIFIED IDEOGRAPH
	{0xABEC,	0x6062},	// CJK UNIFIED IDEOGRAPH
	{0xABED,	0x6046},	// CJK UNIFIED IDEOGRAPH
	{0xABEE,	0x6043},	// CJK UNIFIED IDEOGRAPH
	{0xABEF,	0x606C},	// CJK UNIFIED IDEOGRAPH
	{0xABF0,	0x606B},	// CJK UNIFIED IDEOGRAPH
	{0xABF1,	0x606A},	// CJK UNIFIED IDEOGRAPH
	{0xABF2,	0x6064},	// CJK UNIFIED IDEOGRAPH
	{0xABF3,	0x6241},	// CJK UNIFIED IDEOGRAPH
	{0xABF4,	0x62DC},	// CJK UNIFIED IDEOGRAPH
	{0xABF5,	0x6316},	// CJK UNIFIED IDEOGRAPH
	{0xABF6,	0x6309},	// CJK UNIFIED IDEOGRAPH
	{0xABF7,	0x62FC},	// CJK UNIFIED IDEOGRAPH
	{0xABF8,	0x62ED},	// CJK UNIFIED IDEOGRAPH
	{0xABF9,	0x6301},	// CJK UNIFIED IDEOGRAPH
	{0xABFA,	0x62EE},	// CJK UNIFIED IDEOGRAPH
	{0xABFB,	0x62FD},	// CJK UNIFIED IDEOGRAPH
	{0xABFC,	0x6307},	// CJK UNIFIED IDEOGRAPH
	{0xABFD,	0x62F1},	// CJK UNIFIED IDEOGRAPH
	{0xABFE,	0x62F7},	// CJK UNIFIED IDEOGRAPH
	{0xAC40,	0x62EF},	// CJK UNIFIED IDEOGRAPH
	{0xAC41,	0x62EC},	// CJK UNIFIED IDEOGRAPH
	{0xAC42,	0x62FE},	// CJK UNIFIED IDEOGRAPH
	{0xAC43,	0x62F4},	// CJK UNIFIED IDEOGRAPH
	{0xAC44,	0x6311},	// CJK UNIFIED IDEOGRAPH
	{0xAC45,	0x6302},	// CJK UNIFIED IDEOGRAPH
	{0xAC46,	0x653F},	// CJK UNIFIED IDEOGRAPH
	{0xAC47,	0x6545},	// CJK UNIFIED IDEOGRAPH
	{0xAC48,	0x65AB},	// CJK UNIFIED IDEOGRAPH
	{0xAC49,	0x65BD},	// CJK UNIFIED IDEOGRAPH
	{0xAC4A,	0x65E2},	// CJK UNIFIED IDEOGRAPH
	{0xAC4B,	0x6625},	// CJK UNIFIED IDEOGRAPH
	{0xAC4C,	0x662D},	// CJK UNIFIED IDEOGRAPH
	{0xAC4D,	0x6620},	// CJK UNIFIED IDEOGRAPH
	{0xAC4E,	0x6627},	// CJK UNIFIED IDEOGRAPH
	{0xAC4F,	0x662F},	// CJK UNIFIED IDEOGRAPH
	{0xAC50,	0x661F},	// CJK UNIFIED IDEOGRAPH
	{0xAC51,	0x6628},	// CJK UNIFIED IDEOGRAPH
	{0xAC52,	0x6631},	// CJK UNIFIED IDEOGRAPH
	{0xAC53,	0x6624},	// CJK UNIFIED IDEOGRAPH
	{0xAC54,	0x66F7},	// CJK UNIFIED IDEOGRAPH
	{0xAC55,	0x67FF},	// CJK UNIFIED IDEOGRAPH
	{0xAC56,	0x67D3},	// CJK UNIFIED IDEOGRAPH
	{0xAC57,	0x67F1},	// CJK UNIFIED IDEOGRAPH
	{0xAC58,	0x67D4},	// CJK UNIFIED IDEOGRAPH
	{0xAC59,	0x67D0},	// CJK UNIFIED IDEOGRAPH
	{0xAC5A,	0x67EC},	// CJK UNIFIED IDEOGRAPH
	{0xAC5B,	0x67B6},	// CJK UNIFIED IDEOGRAPH
	{0xAC5C,	0x67AF},	// CJK UNIFIED IDEOGRAPH
	{0xAC5D,	0x67F5},	// CJK UNIFIED IDEOGRAPH
	{0xAC5E,	0x67E9},	// CJK UNIFIED IDEOGRAPH
	{0xAC5F,	0x67EF},	// CJK UNIFIED IDEOGRAPH
	{0xAC60,	0x67C4},	// CJK UNIFIED IDEOGRAPH
	{0xAC61,	0x67D1},	// CJK UNIFIED IDEOGRAPH
	{0xAC62,	0x67B4},	// CJK UNIFIED IDEOGRAPH
	{0xAC63,	0x67DA},	// CJK UNIFIED IDEOGRAPH
	{0xAC64,	0x67E5},	// CJK UNIFIED IDEOGRAPH
	{0xAC65,	0x67B8},	// CJK UNIFIED IDEOGRAPH
	{0xAC66,	0x67CF},	// CJK UNIFIED IDEOGRAPH
	{0xAC67,	0x67DE},	// CJK UNIFIED IDEOGRAPH
	{0xAC68,	0x67F3},	// CJK UNIFIED IDEOGRAPH
	{0xAC69,	0x67B0},	// CJK UNIFIED IDEOGRAPH
	{0xAC6A,	0x67D9},	// CJK UNIFIED IDEOGRAPH
	{0xAC6B,	0x67E2},	// CJK UNIFIED IDEOGRAPH
	{0xAC6C,	0x67DD},	// CJK UNIFIED IDEOGRAPH
	{0xAC6D,	0x67D2},	// CJK UNIFIED IDEOGRAPH
	{0xAC6E,	0x6B6A},	// CJK UNIFIED IDEOGRAPH
	{0xAC6F,	0x6B83},	// CJK UNIFIED IDEOGRAPH
	{0xAC70,	0x6B86},	// CJK UNIFIED IDEOGRAPH
	{0xAC71,	0x6BB5},	// CJK UNIFIED IDEOGRAPH
	{0xAC72,	0x6BD2},	// CJK UNIFIED IDEOGRAPH
	{0xAC73,	0x6BD7},	// CJK UNIFIED IDEOGRAPH
	{0xAC74,	0x6C1F},	// CJK UNIFIED IDEOGRAPH
	{0xAC75,	0x6CC9},	// CJK UNIFIED IDEOGRAPH
	{0xAC76,	0x6D0B},	// CJK UNIFIED IDEOGRAPH
	{0xAC77,	0x6D32},	// CJK UNIFIED IDEOGRAPH
	{0xAC78,	0x6D2A},	// CJK UNIFIED IDEOGRAPH
	{0xAC79,	0x6D41},	// CJK UNIFIED IDEOGRAPH
	{0xAC7A,	0x6D25},	// CJK UNIFIED IDEOGRAPH
	{0xAC7B,	0x6D0C},	// CJK UNIFIED IDEOGRAPH
	{0xAC7C,	0x6D31},	// CJK UNIFIED IDEOGRAPH
	{0xAC7D,	0x6D1E},	// CJK UNIFIED IDEOGRAPH
	{0xAC7E,	0x6D17},	// CJK UNIFIED IDEOGRAPH
	{0xACA1,	0x6D3B},	// CJK UNIFIED IDEOGRAPH
	{0xACA2,	0x6D3D},	// CJK UNIFIED IDEOGRAPH
	{0xACA3,	0x6D3E},	// CJK UNIFIED IDEOGRAPH
	{0xACA4,	0x6D36},	// CJK UNIFIED IDEOGRAPH
	{0xACA5,	0x6D1B},	// CJK UNIFIED IDEOGRAPH
	{0xACA6,	0x6CF5},	// CJK UNIFIED IDEOGRAPH
	{0xACA7,	0x6D39},	// CJK UNIFIED IDEOGRAPH
	{0xACA8,	0x6D27},	// CJK UNIFIED IDEOGRAPH
	{0xACA9,	0x6D38},	// CJK UNIFIED IDEOGRAPH
	{0xACAA,	0x6D29},	// CJK UNIFIED IDEOGRAPH
	{0xACAB,	0x6D2E},	// CJK UNIFIED IDEOGRAPH
	{0xACAC,	0x6D35},	// CJK UNIFIED IDEOGRAPH
	{0xACAD,	0x6D0E},	// CJK UNIFIED IDEOGRAPH
	{0xACAE,	0x6D2B},	// CJK UNIFIED IDEOGRAPH
	{0xACAF,	0x70AB},	// CJK UNIFIED IDEOGRAPH
	{0xACB0,	0x70BA},	// CJK UNIFIED IDEOGRAPH
	{0xACB1,	0x70B3},	// CJK UNIFIED IDEOGRAPH
	{0xACB2,	0x70AC},	// CJK UNIFIED IDEOGRAPH
	{0xACB3,	0x70AF},	// CJK UNIFIED IDEOGRAPH
	{0xACB4,	0x70AD},	// CJK UNIFIED IDEOGRAPH
	{0xACB5,	0x70B8},	// CJK UNIFIED IDEOGRAPH
	{0xACB6,	0x70AE},	// CJK UNIFIED IDEOGRAPH
	{0xACB7,	0x70A4},	// CJK UNIFIED IDEOGRAPH
	{0xACB8,	0x7230},	// CJK UNIFIED IDEOGRAPH
	{0xACB9,	0x7272},	// CJK UNIFIED IDEOGRAPH
	{0xACBA,	0x726F},	// CJK UNIFIED IDEOGRAPH
	{0xACBB,	0x7274},	// CJK UNIFIED IDEOGRAPH
	{0xACBC,	0x72E9},	// CJK UNIFIED IDEOGRAPH
	{0xACBD,	0x72E0},	// CJK UNIFIED IDEOGRAPH
	{0xACBE,	0x72E1},	// CJK UNIFIED IDEOGRAPH
	{0xACBF,	0x73B7},	// CJK UNIFIED IDEOGRAPH
	{0xACC0,	0x73CA},	// CJK UNIFIED IDEOGRAPH
	{0xACC1,	0x73BB},	// CJK UNIFIED IDEOGRAPH
	{0xACC2,	0x73B2},	// CJK UNIFIED IDEOGRAPH
	{0xACC3,	0x73CD},	// CJK UNIFIED IDEOGRAPH
	{0xACC4,	0x73C0},	// CJK UNIFIED IDEOGRAPH
	{0xACC5,	0x73B3},	// CJK UNIFIED IDEOGRAPH
	{0xACC6,	0x751A},	// CJK UNIFIED IDEOGRAPH
	{0xACC7,	0x752D},	// CJK UNIFIED IDEOGRAPH
	{0xACC8,	0x754F},	// CJK UNIFIED IDEOGRAPH
	{0xACC9,	0x754C},	// CJK UNIFIED IDEOGRAPH
	{0xACCA,	0x754E},	// CJK UNIFIED IDEOGRAPH
	{0xACCB,	0x754B},	// CJK UNIFIED IDEOGRAPH
	{0xACCC,	0x75AB},	// CJK UNIFIED IDEOGRAPH
	{0xACCD,	0x75A4},	// CJK UNIFIED IDEOGRAPH
	{0xACCE,	0x75A5},	// CJK UNIFIED IDEOGRAPH
	{0xACCF,	0x75A2},	// CJK UNIFIED IDEOGRAPH
	{0xACD0,	0x75A3},	// CJK UNIFIED IDEOGRAPH
	{0xACD1,	0x7678},	// CJK UNIFIED IDEOGRAPH
	{0xACD2,	0x7686},	// CJK UNIFIED IDEOGRAPH
	{0xACD3,	0x7687},	// CJK UNIFIED IDEOGRAPH
	{0xACD4,	0x7688},	// CJK UNIFIED IDEOGRAPH
	{0xACD5,	0x76C8},	// CJK UNIFIED IDEOGRAPH
	{0xACD6,	0x76C6},	// CJK UNIFIED IDEOGRAPH
	{0xACD7,	0x76C3},	// CJK UNIFIED IDEOGRAPH
	{0xACD8,	0x76C5},	// CJK UNIFIED IDEOGRAPH
	{0xACD9,	0x7701},	// CJK UNIFIED IDEOGRAPH
	{0xACDA,	0x76F9},	// CJK UNIFIED IDEOGRAPH
	{0xACDB,	0x76F8},	// CJK UNIFIED IDEOGRAPH
	{0xACDC,	0x7709},	// CJK UNIFIED IDEOGRAPH
	{0xACDD,	0x770B},	// CJK UNIFIED IDEOGRAPH
	{0xACDE,	0x76FE},	// CJK UNIFIED IDEOGRAPH
	{0xACDF,	0x76FC},	// CJK UNIFIED IDEOGRAPH
	{0xACE0,	0x7707},	// CJK UNIFIED IDEOGRAPH
	{0xACE1,	0x77DC},	// CJK UNIFIED IDEOGRAPH
	{0xACE2,	0x7802},	// CJK UNIFIED IDEOGRAPH
	{0xACE3,	0x7814},	// CJK UNIFIED IDEOGRAPH
	{0xACE4,	0x780C},	// CJK UNIFIED IDEOGRAPH
	{0xACE5,	0x780D},	// CJK UNIFIED IDEOGRAPH
	{0xACE6,	0x7946},	// CJK UNIFIED IDEOGRAPH
	{0xACE7,	0x7949},	// CJK UNIFIED IDEOGRAPH
	{0xACE8,	0x7948},	// CJK UNIFIED IDEOGRAPH
	{0xACE9,	0x7947},	// CJK UNIFIED IDEOGRAPH
	{0xACEA,	0x79B9},	// CJK UNIFIED IDEOGRAPH
	{0xACEB,	0x79BA},	// CJK UNIFIED IDEOGRAPH
	{0xACEC,	0x79D1},	// CJK UNIFIED IDEOGRAPH
	{0xACED,	0x79D2},	// CJK UNIFIED IDEOGRAPH
	{0xACEE,	0x79CB},	// CJK UNIFIED IDEOGRAPH
	{0xACEF,	0x7A7F},	// CJK UNIFIED IDEOGRAPH
	{0xACF0,	0x7A81},	// CJK UNIFIED IDEOGRAPH
	{0xACF1,	0x7AFF},	// CJK UNIFIED IDEOGRAPH
	{0xACF2,	0x7AFD},	// CJK UNIFIED IDEOGRAPH
	{0xACF3,	0x7C7D},	// CJK UNIFIED IDEOGRAPH
	{0xACF4,	0x7D02},	// CJK UNIFIED IDEOGRAPH
	{0xACF5,	0x7D05},	// CJK UNIFIED IDEOGRAPH
	{0xACF6,	0x7D00},	// CJK UNIFIED IDEOGRAPH
	{0xACF7,	0x7D09},	// CJK UNIFIED IDEOGRAPH
	{0xACF8,	0x7D07},	// CJK UNIFIED IDEOGRAPH
	{0xACF9,	0x7D04},	// CJK UNIFIED IDEOGRAPH
	{0xACFA,	0x7D06},	// CJK UNIFIED IDEOGRAPH
	{0xACFB,	0x7F38},	// CJK UNIFIED IDEOGRAPH
	{0xACFC,	0x7F8E},	// CJK UNIFIED IDEOGRAPH
	{0xACFD,	0x7FBF},	// CJK UNIFIED IDEOGRAPH
	{0xACFE,	0x8004},	// CJK UNIFIED IDEOGRAPH
	{0xAD40,	0x8010},	// CJK UNIFIED IDEOGRAPH
	{0xAD41,	0x800D},	// CJK UNIFIED IDEOGRAPH
	{0xAD42,	0x8011},	// CJK UNIFIED IDEOGRAPH
	{0xAD43,	0x8036},	// CJK UNIFIED IDEOGRAPH
	{0xAD44,	0x80D6},	// CJK UNIFIED IDEOGRAPH
	{0xAD45,	0x80E5},	// CJK UNIFIED IDEOGRAPH
	{0xAD46,	0x80DA},	// CJK UNIFIED IDEOGRAPH
	{0xAD47,	0x80C3},	// CJK UNIFIED IDEOGRAPH
	{0xAD48,	0x80C4},	// CJK UNIFIED IDEOGRAPH
	{0xAD49,	0x80CC},	// CJK UNIFIED IDEOGRAPH
	{0xAD4A,	0x80E1},	// CJK UNIFIED IDEOGRAPH
	{0xAD4B,	0x80DB},	// CJK UNIFIED IDEOGRAPH
	{0xAD4C,	0x80CE},	// CJK UNIFIED IDEOGRAPH
	{0xAD4D,	0x80DE},	// CJK UNIFIED IDEOGRAPH
	{0xAD4E,	0x80E4},	// CJK UNIFIED IDEOGRAPH
	{0xAD4F,	0x80DD},	// CJK UNIFIED IDEOGRAPH
	{0xAD50,	0x81F4},	// CJK UNIFIED IDEOGRAPH
	{0xAD51,	0x8222},	// CJK UNIFIED IDEOGRAPH
	{0xAD52,	0x82E7},	// CJK UNIFIED IDEOGRAPH
	{0xAD53,	0x8303},	// CJK UNIFIED IDEOGRAPH
	{0xAD54,	0x8305},	// CJK UNIFIED IDEOGRAPH
	{0xAD55,	0x82E3},	// CJK UNIFIED IDEOGRAPH
	{0xAD56,	0x82DB},	// CJK UNIFIED IDEOGRAPH
	{0xAD57,	0x82E6},	// CJK UNIFIED IDEOGRAPH
	{0xAD58,	0x8304},	// CJK UNIFIED IDEOGRAPH
	{0xAD59,	0x82E5},	// CJK UNIFIED IDEOGRAPH
	{0xAD5A,	0x8302},	// CJK UNIFIED IDEOGRAPH
	{0xAD5B,	0x8309},	// CJK UNIFIED IDEOGRAPH
	{0xAD5C,	0x82D2},	// CJK UNIFIED IDEOGRAPH
	{0xAD5D,	0x82D7},	// CJK UNIFIED IDEOGRAPH
	{0xAD5E,	0x82F1},	// CJK UNIFIED IDEOGRAPH
	{0xAD5F,	0x8301},	// CJK UNIFIED IDEOGRAPH
	{0xAD60,	0x82DC},	// CJK UNIFIED IDEOGRAPH
	{0xAD61,	0x82D4},	// CJK UNIFIED IDEOGRAPH
	{0xAD62,	0x82D1},	// CJK UNIFIED IDEOGRAPH
	{0xAD63,	0x82DE},	// CJK UNIFIED IDEOGRAPH
	{0xAD64,	0x82D3},	// CJK UNIFIED IDEOGRAPH
	{0xAD65,	0x82DF},	// CJK UNIFIED IDEOGRAPH
	{0xAD66,	0x82EF},	// CJK UNIFIED IDEOGRAPH
	{0xAD67,	0x8306},	// CJK UNIFIED IDEOGRAPH
	{0xAD68,	0x8650},	// CJK UNIFIED IDEOGRAPH
	{0xAD69,	0x8679},	// CJK UNIFIED IDEOGRAPH
	{0xAD6A,	0x867B},	// CJK UNIFIED IDEOGRAPH
	{0xAD6B,	0x867A},	// CJK UNIFIED IDEOGRAPH
	{0xAD6C,	0x884D},	// CJK UNIFIED IDEOGRAPH
	{0xAD6D,	0x886B},	// CJK UNIFIED IDEOGRAPH
	{0xAD6E,	0x8981},	// CJK UNIFIED IDEOGRAPH
	{0xAD6F,	0x89D4},	// CJK UNIFIED IDEOGRAPH
	{0xAD70,	0x8A08},	// CJK UNIFIED IDEOGRAPH
	{0xAD71,	0x8A02},	// CJK UNIFIED IDEOGRAPH
	{0xAD72,	0x8A03},	// CJK UNIFIED IDEOGRAPH
	{0xAD73,	0x8C9E},	// CJK UNIFIED IDEOGRAPH
	{0xAD74,	0x8CA0},	// CJK UNIFIED IDEOGRAPH
	{0xAD75,	0x8D74},	// CJK UNIFIED IDEOGRAPH
	{0xAD76,	0x8D73},	// CJK UNIFIED IDEOGRAPH
	{0xAD77,	0x8DB4},	// CJK UNIFIED IDEOGRAPH
	{0xAD78,	0x8ECD},	// CJK UNIFIED IDEOGRAPH
	{0xAD79,	0x8ECC},	// CJK UNIFIED IDEOGRAPH
	{0xAD7A,	0x8FF0},	// CJK UNIFIED IDEOGRAPH
	{0xAD7B,	0x8FE6},	// CJK UNIFIED IDEOGRAPH
	{0xAD7C,	0x8FE2},	// CJK UNIFIED IDEOGRAPH
	{0xAD7D,	0x8FEA},	// CJK UNIFIED IDEOGRAPH
	{0xAD7E,	0x8FE5},	// CJK UNIFIED IDEOGRAPH
	{0xADA1,	0x8FED},	// CJK UNIFIED IDEOGRAPH
	{0xADA2,	0x8FEB},	// CJK UNIFIED IDEOGRAPH
	{0xADA3,	0x8FE4},	// CJK UNIFIED IDEOGRAPH
	{0xADA4,	0x8FE8},	// CJK UNIFIED IDEOGRAPH
	{0xADA5,	0x90CA},	// CJK UNIFIED IDEOGRAPH
	{0xADA6,	0x90CE},	// CJK UNIFIED IDEOGRAPH
	{0xADA7,	0x90C1},	// CJK UNIFIED IDEOGRAPH
	{0xADA8,	0x90C3},	// CJK UNIFIED IDEOGRAPH
	{0xADA9,	0x914B},	// CJK UNIFIED IDEOGRAPH
	{0xADAA,	0x914A},	// CJK UNIFIED IDEOGRAPH
	{0xADAB,	0x91CD},	// CJK UNIFIED IDEOGRAPH
	{0xADAC,	0x9582},	// CJK UNIFIED IDEOGRAPH
	{0xADAD,	0x9650},	// CJK UNIFIED IDEOGRAPH
	{0xADAE,	0x964B},	// CJK UNIFIED IDEOGRAPH
	{0xADAF,	0x964C},	// CJK UNIFIED IDEOGRAPH
	{0xADB0,	0x964D},	// CJK UNIFIED IDEOGRAPH
	{0xADB1,	0x9762},	// CJK UNIFIED IDEOGRAPH
	{0xADB2,	0x9769},	// CJK UNIFIED IDEOGRAPH
	{0xADB3,	0x97CB},	// CJK UNIFIED IDEOGRAPH
	{0xADB4,	0x97ED},	// CJK UNIFIED IDEOGRAPH
	{0xADB5,	0x97F3},	// CJK UNIFIED IDEOGRAPH
	{0xADB6,	0x9801},	// CJK UNIFIED IDEOGRAPH
	{0xADB7,	0x98A8},	// CJK UNIFIED IDEOGRAPH
	{0xADB8,	0x98DB},	// CJK UNIFIED IDEOGRAPH
	{0xADB9,	0x98DF},	// CJK UNIFIED IDEOGRAPH
	{0xADBA,	0x9996},	// CJK UNIFIED IDEOGRAPH
	{0xADBB,	0x9999},	// CJK UNIFIED IDEOGRAPH
	{0xADBC,	0x4E58},	// CJK UNIFIED IDEOGRAPH
	{0xADBD,	0x4EB3},	// CJK UNIFIED IDEOGRAPH
	{0xADBE,	0x500C},	// CJK UNIFIED IDEOGRAPH
	{0xADBF,	0x500D},	// CJK UNIFIED IDEOGRAPH
	{0xADC0,	0x5023},	// CJK UNIFIED IDEOGRAPH
	{0xADC1,	0x4FEF},	// CJK UNIFIED IDEOGRAPH
	{0xADC2,	0x5026},	// CJK UNIFIED IDEOGRAPH
	{0xADC3,	0x5025},	// CJK UNIFIED IDEOGRAPH
	{0xADC4,	0x4FF8},	// CJK UNIFIED IDEOGRAPH
	{0xADC5,	0x5029},	// CJK UNIFIED IDEOGRAPH
	{0xADC6,	0x5016},	// CJK UNIFIED IDEOGRAPH
	{0xADC7,	0x5006},	// CJK UNIFIED IDEOGRAPH
	{0xADC8,	0x503C},	// CJK UNIFIED IDEOGRAPH
	{0xADC9,	0x501F},	// CJK UNIFIED IDEOGRAPH
	{0xADCA,	0x501A},	// CJK UNIFIED IDEOGRAPH
	{0xADCB,	0x5012},	// CJK UNIFIED IDEOGRAPH
	{0xADCC,	0x5011},	// CJK UNIFIED IDEOGRAPH
	{0xADCD,	0x4FFA},	// CJK UNIFIED IDEOGRAPH
	{0xADCE,	0x5000},	// CJK UNIFIED IDEOGRAPH
	{0xADCF,	0x5014},	// CJK UNIFIED IDEOGRAPH
	{0xADD0,	0x5028},	// CJK UNIFIED IDEOGRAPH
	{0xADD1,	0x4FF1},	// CJK UNIFIED IDEOGRAPH
	{0xADD2,	0x5021},	// CJK UNIFIED IDEOGRAPH
	{0xADD3,	0x500B},	// CJK UNIFIED IDEOGRAPH
	{0xADD4,	0x5019},	// CJK UNIFIED IDEOGRAPH
	{0xADD5,	0x5018},	// CJK UNIFIED IDEOGRAPH
	{0xADD6,	0x4FF3},	// CJK UNIFIED IDEOGRAPH
	{0xADD7,	0x4FEE},	// CJK UNIFIED IDEOGRAPH
	{0xADD8,	0x502D},	// CJK UNIFIED IDEOGRAPH
	{0xADD9,	0x502A},	// CJK UNIFIED IDEOGRAPH
	{0xADDA,	0x4FFE},	// CJK UNIFIED IDEOGRAPH
	{0xADDB,	0x502B},	// CJK UNIFIED IDEOGRAPH
	{0xADDC,	0x5009},	// CJK UNIFIED IDEOGRAPH
	{0xADDD,	0x517C},	// CJK UNIFIED IDEOGRAPH
	{0xADDE,	0x51A4},	// CJK UNIFIED IDEOGRAPH
	{0xADDF,	0x51A5},	// CJK UNIFIED IDEOGRAPH
	{0xADE0,	0x51A2},	// CJK UNIFIED IDEOGRAPH
	{0xADE1,	0x51CD},	// CJK UNIFIED IDEOGRAPH
	{0xADE2,	0x51CC},	// CJK UNIFIED IDEOGRAPH
	{0xADE3,	0x51C6},	// CJK UNIFIED IDEOGRAPH
	{0xADE4,	0x51CB},	// CJK UNIFIED IDEOGRAPH
	{0xADE5,	0x5256},	// CJK UNIFIED IDEOGRAPH
	{0xADE6,	0x525C},	// CJK UNIFIED IDEOGRAPH
	{0xADE7,	0x5254},	// CJK UNIFIED IDEOGRAPH
	{0xADE8,	0x525B},	// CJK UNIFIED IDEOGRAPH
	{0xADE9,	0x525D},	// CJK UNIFIED IDEOGRAPH
	{0xADEA,	0x532A},	// CJK UNIFIED IDEOGRAPH
	{0xADEB,	0x537F},	// CJK UNIFIED IDEOGRAPH
	{0xADEC,	0x539F},	// CJK UNIFIED IDEOGRAPH
	{0xADED,	0x539D},	// CJK UNIFIED IDEOGRAPH
	{0xADEE,	0x53DF},	// CJK UNIFIED IDEOGRAPH
	{0xADEF,	0x54E8},	// CJK UNIFIED IDEOGRAPH
	{0xADF0,	0x5510},	// CJK UNIFIED IDEOGRAPH
	{0xADF1,	0x5501},	// CJK UNIFIED IDEOGRAPH
	{0xADF2,	0x5537},	// CJK UNIFIED IDEOGRAPH
	{0xADF3,	0x54FC},	// CJK UNIFIED IDEOGRAPH
	{0xADF4,	0x54E5},	// CJK UNIFIED IDEOGRAPH
	{0xADF5,	0x54F2},	// CJK UNIFIED IDEOGRAPH
	{0xADF6,	0x5506},	// CJK UNIFIED IDEOGRAPH
	{0xADF7,	0x54FA},	// CJK UNIFIED IDEOGRAPH
	{0xADF8,	0x5514},	// CJK UNIFIED IDEOGRAPH
	{0xADF9,	0x54E9},	// CJK UNIFIED IDEOGRAPH
	{0xADFA,	0x54ED},	// CJK UNIFIED IDEOGRAPH
	{0xADFB,	0x54E1},	// CJK UNIFIED IDEOGRAPH
	{0xADFC,	0x5509},	// CJK UNIFIED IDEOGRAPH
	{0xADFD,	0x54EE},	// CJK UNIFIED IDEOGRAPH
	{0xADFE,	0x54EA},	// CJK UNIFIED IDEOGRAPH
	{0xAE40,	0x54E6},	// CJK UNIFIED IDEOGRAPH
	{0xAE41,	0x5527},	// CJK UNIFIED IDEOGRAPH
	{0xAE42,	0x5507},	// CJK UNIFIED IDEOGRAPH
	{0xAE43,	0x54FD},	// CJK UNIFIED IDEOGRAPH
	{0xAE44,	0x550F},	// CJK UNIFIED IDEOGRAPH
	{0xAE45,	0x5703},	// CJK UNIFIED IDEOGRAPH
	{0xAE46,	0x5704},	// CJK UNIFIED IDEOGRAPH
	{0xAE47,	0x57C2},	// CJK UNIFIED IDEOGRAPH
	{0xAE48,	0x57D4},	// CJK UNIFIED IDEOGRAPH
	{0xAE49,	0x57CB},	// CJK UNIFIED IDEOGRAPH
	{0xAE4A,	0x57C3},	// CJK UNIFIED IDEOGRAPH
	{0xAE4B,	0x5809},	// CJK UNIFIED IDEOGRAPH
	{0xAE4C,	0x590F},	// CJK UNIFIED IDEOGRAPH
	{0xAE4D,	0x5957},	// CJK UNIFIED IDEOGRAPH
	{0xAE4E,	0x5958},	// CJK UNIFIED IDEOGRAPH
	{0xAE4F,	0x595A},	// CJK UNIFIED IDEOGRAPH
	{0xAE50,	0x5A11},	// CJK UNIFIED IDEOGRAPH
	{0xAE51,	0x5A18},	// CJK UNIFIED IDEOGRAPH
	{0xAE52,	0x5A1C},	// CJK UNIFIED IDEOGRAPH
	{0xAE53,	0x5A1F},	// CJK UNIFIED IDEOGRAPH
	{0xAE54,	0x5A1B},	// CJK UNIFIED IDEOGRAPH
	{0xAE55,	0x5A13},	// CJK UNIFIED IDEOGRAPH
	{0xAE56,	0x59EC},	// CJK UNIFIED IDEOGRAPH
	{0xAE57,	0x5A20},	// CJK UNIFIED IDEOGRAPH
	{0xAE58,	0x5A23},	// CJK UNIFIED IDEOGRAPH
	{0xAE59,	0x5A29},	// CJK UNIFIED IDEOGRAPH
	{0xAE5A,	0x5A25},	// CJK UNIFIED IDEOGRAPH
	{0xAE5B,	0x5A0C},	// CJK UNIFIED IDEOGRAPH
	{0xAE5C,	0x5A09},	// CJK UNIFIED IDEOGRAPH
	{0xAE5D,	0x5B6B},	// CJK UNIFIED IDEOGRAPH
	{0xAE5E,	0x5C58},	// CJK UNIFIED IDEOGRAPH
	{0xAE5F,	0x5BB0},	// CJK UNIFIED IDEOGRAPH
	{0xAE60,	0x5BB3},	// CJK UNIFIED IDEOGRAPH
	{0xAE61,	0x5BB6},	// CJK UNIFIED IDEOGRAPH
	{0xAE62,	0x5BB4},	// CJK UNIFIED IDEOGRAPH
	{0xAE63,	0x5BAE},	// CJK UNIFIED IDEOGRAPH
	{0xAE64,	0x5BB5},	// CJK UNIFIED IDEOGRAPH
	{0xAE65,	0x5BB9},	// CJK UNIFIED IDEOGRAPH
	{0xAE66,	0x5BB8},	// CJK UNIFIED IDEOGRAPH
	{0xAE67,	0x5C04},	// CJK UNIFIED IDEOGRAPH
	{0xAE68,	0x5C51},	// CJK UNIFIED IDEOGRAPH
	{0xAE69,	0x5C55},	// CJK UNIFIED IDEOGRAPH
	{0xAE6A,	0x5C50},	// CJK UNIFIED IDEOGRAPH
	{0xAE6B,	0x5CED},	// CJK UNIFIED IDEOGRAPH
	{0xAE6C,	0x5CFD},	// CJK UNIFIED IDEOGRAPH
	{0xAE6D,	0x5CFB},	// CJK UNIFIED IDEOGRAPH
	{0xAE6E,	0x5CEA},	// CJK UNIFIED IDEOGRAPH
	{0xAE6F,	0x5CE8},	// CJK UNIFIED IDEOGRAPH
	{0xAE70,	0x5CF0},	// CJK UNIFIED IDEOGRAPH
	{0xAE71,	0x5CF6},	// CJK UNIFIED IDEOGRAPH
	{0xAE72,	0x5D01},	// CJK UNIFIED IDEOGRAPH
	{0xAE73,	0x5CF4},	// CJK UNIFIED IDEOGRAPH
	{0xAE74,	0x5DEE},	// CJK UNIFIED IDEOGRAPH
	{0xAE75,	0x5E2D},	// CJK UNIFIED IDEOGRAPH
	{0xAE76,	0x5E2B},	// CJK UNIFIED IDEOGRAPH
	{0xAE77,	0x5EAB},	// CJK UNIFIED IDEOGRAPH
	{0xAE78,	0x5EAD},	// CJK UNIFIED IDEOGRAPH
	{0xAE79,	0x5EA7},	// CJK UNIFIED IDEOGRAPH
	{0xAE7A,	0x5F31},	// CJK UNIFIED IDEOGRAPH
	{0xAE7B,	0x5F92},	// CJK UNIFIED IDEOGRAPH
	{0xAE7C,	0x5F91},	// CJK UNIFIED IDEOGRAPH
	{0xAE7D,	0x5F90},	// CJK UNIFIED IDEOGRAPH
	{0xAE7E,	0x6059},	// CJK UNIFIED IDEOGRAPH
	{0xAEA1,	0x6063},	// CJK UNIFIED IDEOGRAPH
	{0xAEA2,	0x6065},	// CJK UNIFIED IDEOGRAPH
	{0xAEA3,	0x6050},	// CJK UNIFIED IDEOGRAPH
	{0xAEA4,	0x6055},	// CJK UNIFIED IDEOGRAPH
	{0xAEA5,	0x606D},	// CJK UNIFIED IDEOGRAPH
	{0xAEA6,	0x6069},	// CJK UNIFIED IDEOGRAPH
	{0xAEA7,	0x606F},	// CJK UNIFIED IDEOGRAPH
	{0xAEA8,	0x6084},	// CJK UNIFIED IDEOGRAPH
	{0xAEA9,	0x609F},	// CJK UNIFIED IDEOGRAPH
	{0xAEAA,	0x609A},	// CJK UNIFIED IDEOGRAPH
	{0xAEAB,	0x608D},	// CJK UNIFIED IDEOGRAPH
	{0xAEAC,	0x6094},	// CJK UNIFIED IDEOGRAPH
	{0xAEAD,	0x608C},	// CJK UNIFIED IDEOGRAPH
	{0xAEAE,	0x6085},	// CJK UNIFIED IDEOGRAPH
	{0xAEAF,	0x6096},	// CJK UNIFIED IDEOGRAPH
	{0xAEB0,	0x6247},	// CJK UNIFIED IDEOGRAPH
	{0xAEB1,	0x62F3},	// CJK UNIFIED IDEOGRAPH
	{0xAEB2,	0x6308},	// CJK UNIFIED IDEOGRAPH
	{0xAEB3,	0x62FF},	// CJK UNIFIED IDEOGRAPH
	{0xAEB4,	0x634E},	// CJK UNIFIED IDEOGRAPH
	{0xAEB5,	0x633E},	// CJK UNIFIED IDEOGRAPH
	{0xAEB6,	0x632F},	// CJK UNIFIED IDEOGRAPH
	{0xAEB7,	0x6355},	// CJK UNIFIED IDEOGRAPH
	{0xAEB8,	0x6342},	// CJK UNIFIED IDEOGRAPH
	{0xAEB9,	0x6346},	// CJK UNIFIED IDEOGRAPH
	{0xAEBA,	0x634F},	// CJK UNIFIED IDEOGRAPH
	{0xAEBB,	0x6349},	// CJK UNIFIED IDEOGRAPH
	{0xAEBC,	0x633A},	// CJK UNIFIED IDEOGRAPH
	{0xAEBD,	0x6350},	// CJK UNIFIED IDEOGRAPH
	{0xAEBE,	0x633D},	// CJK UNIFIED IDEOGRAPH
	{0xAEBF,	0x632A},	// CJK UNIFIED IDEOGRAPH
	{0xAEC0,	0x632B},	// CJK UNIFIED IDEOGRAPH
	{0xAEC1,	0x6328},	// CJK UNIFIED IDEOGRAPH
	{0xAEC2,	0x634D},	// CJK UNIFIED IDEOGRAPH
	{0xAEC3,	0x634C},	// CJK UNIFIED IDEOGRAPH
	{0xAEC4,	0x6548},	// CJK UNIFIED IDEOGRAPH
	{0xAEC5,	0x6549},	// CJK UNIFIED IDEOGRAPH
	{0xAEC6,	0x6599},	// CJK UNIFIED IDEOGRAPH
	{0xAEC7,	0x65C1},	// CJK UNIFIED IDEOGRAPH
	{0xAEC8,	0x65C5},	// CJK UNIFIED IDEOGRAPH
	{0xAEC9,	0x6642},	// CJK UNIFIED IDEOGRAPH
	{0xAECA,	0x6649},	// CJK UNIFIED IDEOGRAPH
	{0xAECB,	0x664F},	// CJK UNIFIED IDEOGRAPH
	{0xAECC,	0x6643},	// CJK UNIFIED IDEOGRAPH
	{0xAECD,	0x6652},	// CJK UNIFIED IDEOGRAPH
	{0xAECE,	0x664C},	// CJK UNIFIED IDEOGRAPH
	{0xAECF,	0x6645},	// CJK UNIFIED IDEOGRAPH
	{0xAED0,	0x6641},	// CJK UNIFIED IDEOGRAPH
	{0xAED1,	0x66F8},	// CJK UNIFIED IDEOGRAPH
	{0xAED2,	0x6714},	// CJK UNIFIED IDEOGRAPH
	{0xAED3,	0x6715},	// CJK UNIFIED IDEOGRAPH
	{0xAED4,	0x6717},	// CJK UNIFIED IDEOGRAPH
	{0xAED5,	0x6821},	// CJK UNIFIED IDEOGRAPH
	{0xAED6,	0x6838},	// CJK UNIFIED IDEOGRAPH
	{0xAED7,	0x6848},	// CJK UNIFIED IDEOGRAPH
	{0xAED8,	0x6846},	// CJK UNIFIED IDEOGRAPH
	{0xAED9,	0x6853},	// CJK UNIFIED IDEOGRAPH
	{0xAEDA,	0x6839},	// CJK UNIFIED IDEOGRAPH
	{0xAEDB,	0x6842},	// CJK UNIFIED IDEOGRAPH
	{0xAEDC,	0x6854},	// CJK UNIFIED IDEOGRAPH
	{0xAEDD,	0x6829},	// CJK UNIFIED IDEOGRAPH
	{0xAEDE,	0x68B3},	// CJK UNIFIED IDEOGRAPH
	{0xAEDF,	0x6817},	// CJK UNIFIED IDEOGRAPH
	{0xAEE0,	0x684C},	// CJK UNIFIED IDEOGRAPH
	{0xAEE1,	0x6851},	// CJK UNIFIED IDEOGRAPH
	{0xAEE2,	0x683D},	// CJK UNIFIED IDEOGRAPH
	{0xAEE3,	0x67F4},	// CJK UNIFIED IDEOGRAPH
	{0xAEE4,	0x6850},	// CJK UNIFIED IDEOGRAPH
	{0xAEE5,	0x6840},	// CJK UNIFIED IDEOGRAPH
	{0xAEE6,	0x683C},	// CJK UNIFIED IDEOGRAPH
	{0xAEE7,	0x6843},	// CJK UNIFIED IDEOGRAPH
	{0xAEE8,	0x682A},	// CJK UNIFIED IDEOGRAPH
	{0xAEE9,	0x6845},	// CJK UNIFIED IDEOGRAPH
	{0xAEEA,	0x6813},	// CJK UNIFIED IDEOGRAPH
	{0xAEEB,	0x6818},	// CJK UNIFIED IDEOGRAPH
	{0xAEEC,	0x6841},	// CJK UNIFIED IDEOGRAPH
	{0xAEED,	0x6B8A},	// CJK UNIFIED IDEOGRAPH
	{0xAEEE,	0x6B89},	// CJK UNIFIED IDEOGRAPH
	{0xAEEF,	0x6BB7},	// CJK UNIFIED IDEOGRAPH
	{0xAEF0,	0x6C23},	// CJK UNIFIED IDEOGRAPH
	{0xAEF1,	0x6C27},	// CJK UNIFIED IDEOGRAPH
	{0xAEF2,	0x6C28},	// CJK UNIFIED IDEOGRAPH
	{0xAEF3,	0x6C26},	// CJK UNIFIED IDEOGRAPH
	{0xAEF4,	0x6C24},	// CJK UNIFIED IDEOGRAPH
	{0xAEF5,	0x6CF0},	// CJK UNIFIED IDEOGRAPH
	{0xAEF6,	0x6D6A},	// CJK UNIFIED IDEOGRAPH
	{0xAEF7,	0x6D95},	// CJK UNIFIED IDEOGRAPH
	{0xAEF8,	0x6D88},	// CJK UNIFIED IDEOGRAPH
	{0xAEF9,	0x6D87},	// CJK UNIFIED IDEOGRAPH
	{0xAEFA,	0x6D66},	// CJK UNIFIED IDEOGRAPH
	{0xAEFB,	0x6D78},	// CJK UNIFIED IDEOGRAPH
	{0xAEFC,	0x6D77},	// CJK UNIFIED IDEOGRAPH
	{0xAEFD,	0x6D59},	// CJK UNIFIED IDEOGRAPH
	{0xAEFE,	0x6D93},	// CJK UNIFIED IDEOGRAPH
	{0xAF40,	0x6D6C},	// CJK UNIFIED IDEOGRAPH
	{0xAF41,	0x6D89},	// CJK UNIFIED IDEOGRAPH
	{0xAF42,	0x6D6E},	// CJK UNIFIED IDEOGRAPH
	{0xAF43,	0x6D5A},	// CJK UNIFIED IDEOGRAPH
	{0xAF44,	0x6D74},	// CJK UNIFIED IDEOGRAPH
	{0xAF45,	0x6D69},	// CJK UNIFIED IDEOGRAPH
	{0xAF46,	0x6D8C},	// CJK UNIFIED IDEOGRAPH
	{0xAF47,	0x6D8A},	// CJK UNIFIED IDEOGRAPH
	{0xAF48,	0x6D79},	// CJK UNIFIED IDEOGRAPH
	{0xAF49,	0x6D85},	// CJK UNIFIED IDEOGRAPH
	{0xAF4A,	0x6D65},	// CJK UNIFIED IDEOGRAPH
	{0xAF4B,	0x6D94},	// CJK UNIFIED IDEOGRAPH
	{0xAF4C,	0x70CA},	// CJK UNIFIED IDEOGRAPH
	{0xAF4D,	0x70D8},	// CJK UNIFIED IDEOGRAPH
	{0xAF4E,	0x70E4},	// CJK UNIFIED IDEOGRAPH
	{0xAF4F,	0x70D9},	// CJK UNIFIED IDEOGRAPH
	{0xAF50,	0x70C8},	// CJK UNIFIED IDEOGRAPH
	{0xAF51,	0x70CF},	// CJK UNIFIED IDEOGRAPH
	{0xAF52,	0x7239},	// CJK UNIFIED IDEOGRAPH
	{0xAF53,	0x7279},	// CJK UNIFIED IDEOGRAPH
	{0xAF54,	0x72FC},	// CJK UNIFIED IDEOGRAPH
	{0xAF55,	0x72F9},	// CJK UNIFIED IDEOGRAPH
	{0xAF56,	0x72FD},	// CJK UNIFIED IDEOGRAPH
	{0xAF57,	0x72F8},	// CJK UNIFIED IDEOGRAPH
	{0xAF58,	0x72F7},	// CJK UNIFIED IDEOGRAPH
	{0xAF59,	0x7386},	// CJK UNIFIED IDEOGRAPH
	{0xAF5A,	0x73ED},	// CJK UNIFIED IDEOGRAPH
	{0xAF5B,	0x7409},	// CJK UNIFIED IDEOGRAPH
	{0xAF5C,	0x73EE},	// CJK UNIFIED IDEOGRAPH
	{0xAF5D,	0x73E0},	// CJK UNIFIED IDEOGRAPH
	{0xAF5E,	0x73EA},	// CJK UNIFIED IDEOGRAPH
	{0xAF5F,	0x73DE},	// CJK UNIFIED IDEOGRAPH
	{0xAF60,	0x7554},	// CJK UNIFIED IDEOGRAPH
	{0xAF61,	0x755D},	// CJK UNIFIED IDEOGRAPH
	{0xAF62,	0x755C},	// CJK UNIFIED IDEOGRAPH
	{0xAF63,	0x755A},	// CJK UNIFIED IDEOGRAPH
	{0xAF64,	0x7559},	// CJK UNIFIED IDEOGRAPH
	{0xAF65,	0x75BE},	// CJK UNIFIED IDEOGRAPH
	{0xAF66,	0x75C5},	// CJK UNIFIED IDEOGRAPH
	{0xAF67,	0x75C7},	// CJK UNIFIED IDEOGRAPH
	{0xAF68,	0x75B2},	// CJK UNIFIED IDEOGRAPH
	{0xAF69,	0x75B3},	// CJK UNIFIED IDEOGRAPH
	{0xAF6A,	0x75BD},	// CJK UNIFIED IDEOGRAPH
	{0xAF6B,	0x75BC},	// CJK UNIFIED IDEOGRAPH
	{0xAF6C,	0x75B9},	// CJK UNIFIED IDEOGRAPH
	{0xAF6D,	0x75C2},	// CJK UNIFIED IDEOGRAPH
	{0xAF6E,	0x75B8},	// CJK UNIFIED IDEOGRAPH
	{0xAF6F,	0x768B},	// CJK UNIFIED IDEOGRAPH
	{0xAF70,	0x76B0},	// CJK UNIFIED IDEOGRAPH
	{0xAF71,	0x76CA},	// CJK UNIFIED IDEOGRAPH
	{0xAF72,	0x76CD},	// CJK UNIFIED IDEOGRAPH
	{0xAF73,	0x76CE},	// CJK UNIFIED IDEOGRAPH
	{0xAF74,	0x7729},	// CJK UNIFIED IDEOGRAPH
	{0xAF75,	0x771F},	// CJK UNIFIED IDEOGRAPH
	{0xAF76,	0x7720},	// CJK UNIFIED IDEOGRAPH
	{0xAF77,	0x7728},	// CJK UNIFIED IDEOGRAPH
	{0xAF78,	0x77E9},	// CJK UNIFIED IDEOGRAPH
	{0xAF79,	0x7830},	// CJK UNIFIED IDEOGRAPH
	{0xAF7A,	0x7827},	// CJK UNIFIED IDEOGRAPH
	{0xAF7B,	0x7838},	// CJK UNIFIED IDEOGRAPH
	{0xAF7C,	0x781D},	// CJK UNIFIED IDEOGRAPH
	{0xAF7D,	0x7834},	// CJK UNIFIED IDEOGRAPH
	{0xAF7E,	0x7837},	// CJK UNIFIED IDEOGRAPH
	{0xAFA1,	0x7825},	// CJK UNIFIED IDEOGRAPH
	{0xAFA2,	0x782D},	// CJK UNIFIED IDEOGRAPH
	{0xAFA3,	0x7820},	// CJK UNIFIED IDEOGRAPH
	{0xAFA4,	0x781F},	// CJK UNIFIED IDEOGRAPH
	{0xAFA5,	0x7832},	// CJK UNIFIED IDEOGRAPH
	{0xAFA6,	0x7955},	// CJK UNIFIED IDEOGRAPH
	{0xAFA7,	0x7950},	// CJK UNIFIED IDEOGRAPH
	{0xAFA8,	0x7960},	// CJK UNIFIED IDEOGRAPH
	{0xAFA9,	0x795F},	// CJK UNIFIED IDEOGRAPH
	{0xAFAA,	0x7956},	// CJK UNIFIED IDEOGRAPH
	{0xAFAB,	0x795E},	// CJK UNIFIED IDEOGRAPH
	{0xAFAC,	0x795D},	// CJK UNIFIED IDEOGRAPH
	{0xAFAD,	0x7957},	// CJK UNIFIED IDEOGRAPH
	{0xAFAE,	0x795A},	// CJK UNIFIED IDEOGRAPH
	{0xAFAF,	0x79E4},	// CJK UNIFIED IDEOGRAPH
	{0xAFB0,	0x79E3},	// CJK UNIFIED IDEOGRAPH
	{0xAFB1,	0x79E7},	// CJK UNIFIED IDEOGRAPH
	{0xAFB2,	0x79DF},	// CJK UNIFIED IDEOGRAPH
	{0xAFB3,	0x79E6},	// CJK UNIFIED IDEOGRAPH
	{0xAFB4,	0x79E9},	// CJK UNIFIED IDEOGRAPH
	{0xAFB5,	0x79D8},	// CJK UNIFIED IDEOGRAPH
	{0xAFB6,	0x7A84},	// CJK UNIFIED IDEOGRAPH
	{0xAFB7,	0x7A88},	// CJK UNIFIED IDEOGRAPH
	{0xAFB8,	0x7AD9},	// CJK UNIFIED IDEOGRAPH
	{0xAFB9,	0x7B06},	// CJK UNIFIED IDEOGRAPH
	{0xAFBA,	0x7B11},	// CJK UNIFIED IDEOGRAPH
	{0xAFBB,	0x7C89},	// CJK UNIFIED IDEOGRAPH
	{0xAFBC,	0x7D21},	// CJK UNIFIED IDEOGRAPH
	{0xAFBD,	0x7D17},	// CJK UNIFIED IDEOGRAPH
	{0xAFBE,	0x7D0B},	// CJK UNIFIED IDEOGRAPH
	{0xAFBF,	0x7D0A},	// CJK UNIFIED IDEOGRAPH
	{0xAFC0,	0x7D20},	// CJK UNIFIED IDEOGRAPH
	{0xAFC1,	0x7D22},	// CJK UNIFIED IDEOGRAPH
	{0xAFC2,	0x7D14},	// CJK UNIFIED IDEOGRAPH
	{0xAFC3,	0x7D10},	// CJK UNIFIED IDEOGRAPH
	{0xAFC4,	0x7D15},	// CJK UNIFIED IDEOGRAPH
	{0xAFC5,	0x7D1A},	// CJK UNIFIED IDEOGRAPH
	{0xAFC6,	0x7D1C},	// CJK UNIFIED IDEOGRAPH
	{0xAFC7,	0x7D0D},	// CJK UNIFIED IDEOGRAPH
	{0xAFC8,	0x7D19},	// CJK UNIFIED IDEOGRAPH
	{0xAFC9,	0x7D1B},	// CJK UNIFIED IDEOGRAPH
	{0xAFCA,	0x7F3A},	// CJK UNIFIED IDEOGRAPH
	{0xAFCB,	0x7F5F},	// CJK UNIFIED IDEOGRAPH
	{0xAFCC,	0x7F94},	// CJK UNIFIED IDEOGRAPH
	{0xAFCD,	0x7FC5},	// CJK UNIFIED IDEOGRAPH
	{0xAFCE,	0x7FC1},	// CJK UNIFIED IDEOGRAPH
	{0xAFCF,	0x8006},	// CJK UNIFIED IDEOGRAPH
	{0xAFD0,	0x8018},	// CJK UNIFIED IDEOGRAPH
	{0xAFD1,	0x8015},	// CJK UNIFIED IDEOGRAPH
	{0xAFD2,	0x8019},	// CJK UNIFIED IDEOGRAPH
	{0xAFD3,	0x8017},	// CJK UNIFIED IDEOGRAPH
	{0xAFD4,	0x803D},	// CJK UNIFIED IDEOGRAPH
	{0xAFD5,	0x803F},	// CJK UNIFIED IDEOGRAPH
	{0xAFD6,	0x80F1},	// CJK UNIFIED IDEOGRAPH
	{0xAFD7,	0x8102},	// CJK UNIFIED IDEOGRAPH
	{0xAFD8,	0x80F0},	// CJK UNIFIED IDEOGRAPH
	{0xAFD9,	0x8105},	// CJK UNIFIED IDEOGRAPH
	{0xAFDA,	0x80ED},	// CJK UNIFIED IDEOGRAPH
	{0xAFDB,	0x80F4},	// CJK UNIFIED IDEOGRAPH
	{0xAFDC,	0x8106},	// CJK UNIFIED IDEOGRAPH
	{0xAFDD,	0x80F8},	// CJK UNIFIED IDEOGRAPH
	{0xAFDE,	0x80F3},	// CJK UNIFIED IDEOGRAPH
	{0xAFDF,	0x8108},	// CJK UNIFIED IDEOGRAPH
	{0xAFE0,	0x80FD},	// CJK UNIFIED IDEOGRAPH
	{0xAFE1,	0x810A},	// CJK UNIFIED IDEOGRAPH
	{0xAFE2,	0x80FC},	// CJK UNIFIED IDEOGRAPH
	{0xAFE3,	0x80EF},	// CJK UNIFIED IDEOGRAPH
	{0xAFE4,	0x81ED},	// CJK UNIFIED IDEOGRAPH
	{0xAFE5,	0x81EC},	// CJK UNIFIED IDEOGRAPH
	{0xAFE6,	0x8200},	// CJK UNIFIED IDEOGRAPH
	{0xAFE7,	0x8210},	// CJK UNIFIED IDEOGRAPH
	{0xAFE8,	0x822A},	// CJK UNIFIED IDEOGRAPH
	{0xAFE9,	0x822B},	// CJK UNIFIED IDEOGRAPH
	{0xAFEA,	0x8228},	// CJK UNIFIED IDEOGRAPH
	{0xAFEB,	0x822C},	// CJK UNIFIED IDEOGRAPH
	{0xAFEC,	0x82BB},	// CJK UNIFIED IDEOGRAPH
	{0xAFED,	0x832B},	// CJK UNIFIED IDEOGRAPH
	{0xAFEE,	0x8352},	// CJK UNIFIED IDEOGRAPH
	{0xAFEF,	0x8354},	// CJK UNIFIED IDEOGRAPH
	{0xAFF0,	0x834A},	// CJK UNIFIED IDEOGRAPH
	{0xAFF1,	0x8338},	// CJK UNIFIED IDEOGRAPH
	{0xAFF2,	0x8350},	// CJK UNIFIED IDEOGRAPH
	{0xAFF3,	0x8349},	// CJK UNIFIED IDEOGRAPH
	{0xAFF4,	0x8335},	// CJK UNIFIED IDEOGRAPH
	{0xAFF5,	0x8334},	// CJK UNIFIED IDEOGRAPH
	{0xAFF6,	0x834F},	// CJK UNIFIED IDEOGRAPH
	{0xAFF7,	0x8332},	// CJK UNIFIED IDEOGRAPH
	{0xAFF8,	0x8339},	// CJK UNIFIED IDEOGRAPH
	{0xAFF9,	0x8336},	// CJK UNIFIED IDEOGRAPH
	{0xAFFA,	0x8317},	// CJK UNIFIED IDEOGRAPH
	{0xAFFB,	0x8340},	// CJK UNIFIED IDEOGRAPH
	{0xAFFC,	0x8331},	// CJK UNIFIED IDEOGRAPH
	{0xAFFD,	0x8328},	// CJK UNIFIED IDEOGRAPH
	{0xAFFE,	0x8343},	// CJK UNIFIED IDEOGRAPH
	{0xB040,	0x8654},	// CJK UNIFIED IDEOGRAPH
	{0xB041,	0x868A},	// CJK UNIFIED IDEOGRAPH
	{0xB042,	0x86AA},	// CJK UNIFIED IDEOGRAPH
	{0xB043,	0x8693},	// CJK UNIFIED IDEOGRAPH
	{0xB044,	0x86A4},	// CJK UNIFIED IDEOGRAPH
	{0xB045,	0x86A9},	// CJK UNIFIED IDEOGRAPH
	{0xB046,	0x868C},	// CJK UNIFIED IDEOGRAPH
	{0xB047,	0x86A3},	// CJK UNIFIED IDEOGRAPH
	{0xB048,	0x869C},	// CJK UNIFIED IDEOGRAPH
	{0xB049,	0x8870},	// CJK UNIFIED IDEOGRAPH
	{0xB04A,	0x8877},	// CJK UNIFIED IDEOGRAPH
	{0xB04B,	0x8881},	// CJK UNIFIED IDEOGRAPH
	{0xB04C,	0x8882},	// CJK UNIFIED IDEOGRAPH
	{0xB04D,	0x887D},	// CJK UNIFIED IDEOGRAPH
	{0xB04E,	0x8879},	// CJK UNIFIED IDEOGRAPH
	{0xB04F,	0x8A18},	// CJK UNIFIED IDEOGRAPH
	{0xB050,	0x8A10},	// CJK UNIFIED IDEOGRAPH
	{0xB051,	0x8A0E},	// CJK UNIFIED IDEOGRAPH
	{0xB052,	0x8A0C},	// CJK UNIFIED IDEOGRAPH
	{0xB053,	0x8A15},	// CJK UNIFIED IDEOGRAPH
	{0xB054,	0x8A0A},	// CJK UNIFIED IDEOGRAPH
	{0xB055,	0x8A17},	// CJK UNIFIED IDEOGRAPH
	{0xB056,	0x8A13},	// CJK UNIFIED IDEOGRAPH
	{0xB057,	0x8A16},	// CJK UNIFIED IDEOGRAPH
	{0xB058,	0x8A0F},	// CJK UNIFIED IDEOGRAPH
	{0xB059,	0x8A11},	// CJK UNIFIED IDEOGRAPH
	{0xB05A,	0x8C48},	// CJK UNIFIED IDEOGRAPH
	{0xB05B,	0x8C7A},	// CJK UNIFIED IDEOGRAPH
	{0xB05C,	0x8C79},	// CJK UNIFIED IDEOGRAPH
	{0xB05D,	0x8CA1},	// CJK UNIFIED IDEOGRAPH
	{0xB05E,	0x8CA2},	// CJK UNIFIED IDEOGRAPH
	{0xB05F,	0x8D77},	// CJK UNIFIED IDEOGRAPH
	{0xB060,	0x8EAC},	// CJK UNIFIED IDEOGRAPH
	{0xB061,	0x8ED2},	// CJK UNIFIED IDEOGRAPH
	{0xB062,	0x8ED4},	// CJK UNIFIED IDEOGRAPH
	{0xB063,	0x8ECF},	// CJK UNIFIED IDEOGRAPH
	{0xB064,	0x8FB1},	// CJK UNIFIED IDEOGRAPH
	{0xB065,	0x9001},	// CJK UNIFIED IDEOGRAPH
	{0xB066,	0x9006},	// CJK UNIFIED IDEOGRAPH
	{0xB067,	0x8FF7},	// CJK UNIFIED IDEOGRAPH
	{0xB068,	0x9000},	// CJK UNIFIED IDEOGRAPH
	{0xB069,	0x8FFA},	// CJK UNIFIED IDEOGRAPH
	{0xB06A,	0x8FF4},	// CJK UNIFIED IDEOGRAPH
	{0xB06B,	0x9003},	// CJK UNIFIED IDEOGRAPH
	{0xB06C,	0x8FFD},	// CJK UNIFIED IDEOGRAPH
	{0xB06D,	0x9005},	// CJK UNIFIED IDEOGRAPH
	{0xB06E,	0x8FF8},	// CJK UNIFIED IDEOGRAPH
	{0xB06F,	0x9095},	// CJK UNIFIED IDEOGRAPH
	{0xB070,	0x90E1},	// CJK UNIFIED IDEOGRAPH
	{0xB071,	0x90DD},	// CJK UNIFIED IDEOGRAPH
	{0xB072,	0x90E2},	// CJK UNIFIED IDEOGRAPH
	{0xB073,	0x9152},	// CJK UNIFIED IDEOGRAPH
	{0xB074,	0x914D},	// CJK UNIFIED IDEOGRAPH
	{0xB075,	0x914C},	// CJK UNIFIED IDEOGRAPH
	{0xB076,	0x91D8},	// CJK UNIFIED IDEOGRAPH
	{0xB077,	0x91DD},	// CJK UNIFIED IDEOGRAPH
	{0xB078,	0x91D7},	// CJK UNIFIED IDEOGRAPH
	{0xB079,	0x91DC},	// CJK UNIFIED IDEOGRAPH
	{0xB07A,	0x91D9},	// CJK UNIFIED IDEOGRAPH
	{0xB07B,	0x9583},	// CJK UNIFIED IDEOGRAPH
	{0xB07C,	0x9662},	// CJK UNIFIED IDEOGRAPH
	{0xB07D,	0x9663},	// CJK UNIFIED IDEOGRAPH
	{0xB07E,	0x9661},	// CJK UNIFIED IDEOGRAPH
	{0xB0A1,	0x965B},	// CJK UNIFIED IDEOGRAPH
	{0xB0A2,	0x965D},	// CJK UNIFIED IDEOGRAPH
	{0xB0A3,	0x9664},	// CJK UNIFIED IDEOGRAPH
	{0xB0A4,	0x9658},	// CJK UNIFIED IDEOGRAPH
	{0xB0A5,	0x965E},	// CJK UNIFIED IDEOGRAPH
	{0xB0A6,	0x96BB},	// CJK UNIFIED IDEOGRAPH
	{0xB0A7,	0x98E2},	// CJK UNIFIED IDEOGRAPH
	{0xB0A8,	0x99AC},	// CJK UNIFIED IDEOGRAPH
	{0xB0A9,	0x9AA8},	// CJK UNIFIED IDEOGRAPH
	{0xB0AA,	0x9AD8},	// CJK UNIFIED IDEOGRAPH
	{0xB0AB,	0x9B25},	// CJK UNIFIED IDEOGRAPH
	{0xB0AC,	0x9B32},	// CJK UNIFIED IDEOGRAPH
	{0xB0AD,	0x9B3C},	// CJK UNIFIED IDEOGRAPH
	{0xB0AE,	0x4E7E},	// CJK UNIFIED IDEOGRAPH
	{0xB0AF,	0x507A},	// CJK UNIFIED IDEOGRAPH
	{0xB0B0,	0x507D},	// CJK UNIFIED IDEOGRAPH
	{0xB0B1,	0x505C},	// CJK UNIFIED IDEOGRAPH
	{0xB0B2,	0x5047},	// CJK UNIFIED IDEOGRAPH
	{0xB0B3,	0x5043},	// CJK UNIFIED IDEOGRAPH
	{0xB0B4,	0x504C},	// CJK UNIFIED IDEOGRAPH
	{0xB0B5,	0x505A},	// CJK UNIFIED IDEOGRAPH
	{0xB0B6,	0x5049},	// CJK UNIFIED IDEOGRAPH
	{0xB0B7,	0x5065},	// CJK UNIFIED IDEOGRAPH
	{0xB0B8,	0x5076},	// CJK UNIFIED IDEOGRAPH
	{0xB0B9,	0x504E},	// CJK UNIFIED IDEOGRAPH
	{0xB0BA,	0x5055},	// CJK UNIFIED IDEOGRAPH
	{0xB0BB,	0x5075},	// CJK UNIFIED IDEOGRAPH
	{0xB0BC,	0x5074},	// CJK UNIFIED IDEOGRAPH
	{0xB0BD,	0x5077},	// CJK UNIFIED IDEOGRAPH
	{0xB0BE,	0x504F},	// CJK UNIFIED IDEOGRAPH
	{0xB0BF,	0x500F},	// CJK UNIFIED IDEOGRAPH
	{0xB0C0,	0x506F},	// CJK UNIFIED IDEOGRAPH
	{0xB0C1,	0x506D},	// CJK UNIFIED IDEOGRAPH
	{0xB0C2,	0x515C},	// CJK UNIFIED IDEOGRAPH
	{0xB0C3,	0x5195},	// CJK UNIFIED IDEOGRAPH
	{0xB0C4,	0x51F0},	// CJK UNIFIED IDEOGRAPH
	{0xB0C5,	0x526A},	// CJK UNIFIED IDEOGRAPH
	{0xB0C6,	0x526F},	// CJK UNIFIED IDEOGRAPH
	{0xB0C7,	0x52D2},	// CJK UNIFIED IDEOGRAPH
	{0xB0C8,	0x52D9},	// CJK UNIFIED IDEOGRAPH
	{0xB0C9,	0x52D8},	// CJK UNIFIED IDEOGRAPH
	{0xB0CA,	0x52D5},	// CJK UNIFIED IDEOGRAPH
	{0xB0CB,	0x5310},	// CJK UNIFIED IDEOGRAPH
	{0xB0CC,	0x530F},	// CJK UNIFIED IDEOGRAPH
	{0xB0CD,	0x5319},	// CJK UNIFIED IDEOGRAPH
	{0xB0CE,	0x533F},	// CJK UNIFIED IDEOGRAPH
	{0xB0CF,	0x5340},	// CJK UNIFIED IDEOGRAPH
	{0xB0D0,	0x533E},	// CJK UNIFIED IDEOGRAPH
	{0xB0D1,	0x53C3},	// CJK UNIFIED IDEOGRAPH
	{0xB0D2,	0x66FC},	// CJK UNIFIED IDEOGRAPH
	{0xB0D3,	0x5546},	// CJK UNIFIED IDEOGRAPH
	{0xB0D4,	0x556A},	// CJK UNIFIED IDEOGRAPH
	{0xB0D5,	0x5566},	// CJK UNIFIED IDEOGRAPH
	{0xB0D6,	0x5544},	// CJK UNIFIED IDEOGRAPH
	{0xB0D7,	0x555E},	// CJK UNIFIED IDEOGRAPH
	{0xB0D8,	0x5561},	// CJK UNIFIED IDEOGRAPH
	{0xB0D9,	0x5543},	// CJK UNIFIED IDEOGRAPH
	{0xB0DA,	0x554A},	// CJK UNIFIED IDEOGRAPH
	{0xB0DB,	0x5531},	// CJK UNIFIED IDEOGRAPH
	{0xB0DC,	0x5556},	// CJK UNIFIED IDEOGRAPH
	{0xB0DD,	0x554F},	// CJK UNIFIED IDEOGRAPH
	{0xB0DE,	0x5555},	// CJK UNIFIED IDEOGRAPH
	{0xB0DF,	0x552F},	// CJK UNIFIED IDEOGRAPH
	{0xB0E0,	0x5564},	// CJK UNIFIED IDEOGRAPH
	{0xB0E1,	0x5538},	// CJK UNIFIED IDEOGRAPH
	{0xB0E2,	0x552E},	// CJK UNIFIED IDEOGRAPH
	{0xB0E3,	0x555C},	// CJK UNIFIED IDEOGRAPH
	{0xB0E4,	0x552C},	// CJK UNIFIED IDEOGRAPH
	{0xB0E5,	0x5563},	// CJK UNIFIED IDEOGRAPH
	{0xB0E6,	0x5533},	// CJK UNIFIED IDEOGRAPH
	{0xB0E7,	0x5541},	// CJK UNIFIED IDEOGRAPH
	{0xB0E8,	0x5557},	// CJK UNIFIED IDEOGRAPH
	{0xB0E9,	0x5708},	// CJK UNIFIED IDEOGRAPH
	{0xB0EA,	0x570B},	// CJK UNIFIED IDEOGRAPH
	{0xB0EB,	0x5709},	// CJK UNIFIED IDEOGRAPH
	{0xB0EC,	0x57DF},	// CJK UNIFIED IDEOGRAPH
	{0xB0ED,	0x5805},	// CJK UNIFIED IDEOGRAPH
	{0xB0EE,	0x580A},	// CJK UNIFIED IDEOGRAPH
	{0xB0EF,	0x5806},	// CJK UNIFIED IDEOGRAPH
	{0xB0F0,	0x57E0},	// CJK UNIFIED IDEOGRAPH
	{0xB0F1,	0x57E4},	// CJK UNIFIED IDEOGRAPH
	{0xB0F2,	0x57FA},	// CJK UNIFIED IDEOGRAPH
	{0xB0F3,	0x5802},	// CJK UNIFIED IDEOGRAPH
	{0xB0F4,	0x5835},	// CJK UNIFIED IDEOGRAPH
	{0xB0F5,	0x57F7},	// CJK UNIFIED IDEOGRAPH
	{0xB0F6,	0x57F9},	// CJK UNIFIED IDEOGRAPH
	{0xB0F7,	0x5920},	// CJK UNIFIED IDEOGRAPH
	{0xB0F8,	0x5962},	// CJK UNIFIED IDEOGRAPH
	{0xB0F9,	0x5A36},	// CJK UNIFIED IDEOGRAPH
	{0xB0FA,	0x5A41},	// CJK UNIFIED IDEOGRAPH
	{0xB0FB,	0x5A49},	// CJK UNIFIED IDEOGRAPH
	{0xB0FC,	0x5A66},	// CJK UNIFIED IDEOGRAPH
	{0xB0FD,	0x5A6A},	// CJK UNIFIED IDEOGRAPH
	{0xB0FE,	0x5A40},	// CJK UNIFIED IDEOGRAPH
	{0xB140,	0x5A3C},	// CJK UNIFIED IDEOGRAPH
	{0xB141,	0x5A62},	// CJK UNIFIED IDEOGRAPH
	{0xB142,	0x5A5A},	// CJK UNIFIED IDEOGRAPH
	{0xB143,	0x5A46},	// CJK UNIFIED IDEOGRAPH
	{0xB144,	0x5A4A},	// CJK UNIFIED IDEOGRAPH
	{0xB145,	0x5B70},	// CJK UNIFIED IDEOGRAPH
	{0xB146,	0x5BC7},	// CJK UNIFIED IDEOGRAPH
	{0xB147,	0x5BC5},	// CJK UNIFIED IDEOGRAPH
	{0xB148,	0x5BC4},	// CJK UNIFIED IDEOGRAPH
	{0xB149,	0x5BC2},	// CJK UNIFIED IDEOGRAPH
	{0xB14A,	0x5BBF},	// CJK UNIFIED IDEOGRAPH
	{0xB14B,	0x5BC6},	// CJK UNIFIED IDEOGRAPH
	{0xB14C,	0x5C09},	// CJK UNIFIED IDEOGRAPH
	{0xB14D,	0x5C08},	// CJK UNIFIED IDEOGRAPH
	{0xB14E,	0x5C07},	// CJK UNIFIED IDEOGRAPH
	{0xB14F,	0x5C60},	// CJK UNIFIED IDEOGRAPH
	{0xB150,	0x5C5C},	// CJK UNIFIED IDEOGRAPH
	{0xB151,	0x5C5D},	// CJK UNIFIED IDEOGRAPH
	{0xB152,	0x5D07},	// CJK UNIFIED IDEOGRAPH
	{0xB153,	0x5D06},	// CJK UNIFIED IDEOGRAPH
	{0xB154,	0x5D0E},	// CJK UNIFIED IDEOGRAPH
	{0xB155,	0x5D1B},	// CJK UNIFIED IDEOGRAPH
	{0xB156,	0x5D16},	// CJK UNIFIED IDEOGRAPH
	{0xB157,	0x5D22},	// CJK UNIFIED IDEOGRAPH
	{0xB158,	0x5D11},	// CJK UNIFIED IDEOGRAPH
	{0xB159,	0x5D29},	// CJK UNIFIED IDEOGRAPH
	{0xB15A,	0x5D14},	// CJK UNIFIED IDEOGRAPH
	{0xB15B,	0x5D19},	// CJK UNIFIED IDEOGRAPH
	{0xB15C,	0x5D24},	// CJK UNIFIED IDEOGRAPH
	{0xB15D,	0x5D27},	// CJK UNIFIED IDEOGRAPH
	{0xB15E,	0x5D17},	// CJK UNIFIED IDEOGRAPH
	{0xB15F,	0x5DE2},	// CJK UNIFIED IDEOGRAPH
	{0xB160,	0x5E38},	// CJK UNIFIED IDEOGRAPH
	{0xB161,	0x5E36},	// CJK UNIFIED IDEOGRAPH
	{0xB162,	0x5E33},	// CJK UNIFIED IDEOGRAPH
	{0xB163,	0x5E37},	// CJK UNIFIED IDEOGRAPH
	{0xB164,	0x5EB7},	// CJK UNIFIED IDEOGRAPH
	{0xB165,	0x5EB8},	// CJK UNIFIED IDEOGRAPH
	{0xB166,	0x5EB6},	// CJK UNIFIED IDEOGRAPH
	{0xB167,	0x5EB5},	// CJK UNIFIED IDEOGRAPH
	{0xB168,	0x5EBE},	// CJK UNIFIED IDEOGRAPH
	{0xB169,	0x5F35},	// CJK UNIFIED IDEOGRAPH
	{0xB16A,	0x5F37},	// CJK UNIFIED IDEOGRAPH
	{0xB16B,	0x5F57},	// CJK UNIFIED IDEOGRAPH
	{0xB16C,	0x5F6C},	// CJK UNIFIED IDEOGRAPH
	{0xB16D,	0x5F69},	// CJK UNIFIED IDEOGRAPH
	{0xB16E,	0x5F6B},	// CJK UNIFIED IDEOGRAPH
	{0xB16F,	0x5F97},	// CJK UNIFIED IDEOGRAPH
	{0xB170,	0x5F99},	// CJK UNIFIED IDEOGRAPH
	{0xB171,	0x5F9E},	// CJK UNIFIED IDEOGRAPH
	{0xB172,	0x5F98},	// CJK UNIFIED IDEOGRAPH
	{0xB173,	0x5FA1},	// CJK UNIFIED IDEOGRAPH
	{0xB174,	0x5FA0},	// CJK UNIFIED IDEOGRAPH
	{0xB175,	0x5F9C},	// CJK UNIFIED IDEOGRAPH
	{0xB176,	0x607F},	// CJK UNIFIED IDEOGRAPH
	{0xB177,	0x60A3},	// CJK UNIFIED IDEOGRAPH
	{0xB178,	0x6089},	// CJK UNIFIED IDEOGRAPH
	{0xB179,	0x60A0},	// CJK UNIFIED IDEOGRAPH
	{0xB17A,	0x60A8},	// CJK UNIFIED IDEOGRAPH
	{0xB17B,	0x60CB},	// CJK UNIFIED IDEOGRAPH
	{0xB17C,	0x60B4},	// CJK UNIFIED IDEOGRAPH
	{0xB17D,	0x60E6},	// CJK UNIFIED IDEOGRAPH
	{0xB17E,	0x60BD},	// CJK UNIFIED IDEOGRAPH
	{0xB1A1,	0x60C5},	// CJK UNIFIED IDEOGRAPH
	{0xB1A2,	0x60BB},	// CJK UNIFIED IDEOGRAPH
	{0xB1A3,	0x60B5},	// CJK UNIFIED IDEOGRAPH
	{0xB1A4,	0x60DC},	// CJK UNIFIED IDEOGRAPH
	{0xB1A5,	0x60BC},	// CJK UNIFIED IDEOGRAPH
	{0xB1A6,	0x60D8},	// CJK UNIFIED IDEOGRAPH
	{0xB1A7,	0x60D5},	// CJK UNIFIED IDEOGRAPH
	{0xB1A8,	0x60C6},	// CJK UNIFIED IDEOGRAPH
	{0xB1A9,	0x60DF},	// CJK UNIFIED IDEOGRAPH
	{0xB1AA,	0x60B8},	// CJK UNIFIED IDEOGRAPH
	{0xB1AB,	0x60DA},	// CJK UNIFIED IDEOGRAPH
	{0xB1AC,	0x60C7},	// CJK UNIFIED IDEOGRAPH
	{0xB1AD,	0x621A},	// CJK UNIFIED IDEOGRAPH
	{0xB1AE,	0x621B},	// CJK UNIFIED IDEOGRAPH
	{0xB1AF,	0x6248},	// CJK UNIFIED IDEOGRAPH
	{0xB1B0,	0x63A0},	// CJK UNIFIED IDEOGRAPH
	{0xB1B1,	0x63A7},	// CJK UNIFIED IDEOGRAPH
	{0xB1B2,	0x6372},	// CJK UNIFIED IDEOGRAPH
	{0xB1B3,	0x6396},	// CJK UNIFIED IDEOGRAPH
	{0xB1B4,	0x63A2},	// CJK UNIFIED IDEOGRAPH
	{0xB1B5,	0x63A5},	// CJK UNIFIED IDEOGRAPH
	{0xB1B6,	0x6377},	// CJK UNIFIED IDEOGRAPH
	{0xB1B7,	0x6367},	// CJK UNIFIED IDEOGRAPH
	{0xB1B8,	0x6398},	// CJK UNIFIED IDEOGRAPH
	{0xB1B9,	0x63AA},	// CJK UNIFIED IDEOGRAPH
	{0xB1BA,	0x6371},	// CJK UNIFIED IDEOGRAPH
	{0xB1BB,	0x63A9},	// CJK UNIFIED IDEOGRAPH
	{0xB1BC,	0x6389},	// CJK UNIFIED IDEOGRAPH
	{0xB1BD,	0x6383},	// CJK UNIFIED IDEOGRAPH
	{0xB1BE,	0x639B},	// CJK UNIFIED IDEOGRAPH
	{0xB1BF,	0x636B},	// CJK UNIFIED IDEOGRAPH
	{0xB1C0,	0x63A8},	// CJK UNIFIED IDEOGRAPH
	{0xB1C1,	0x6384},	// CJK UNIFIED IDEOGRAPH
	{0xB1C2,	0x6388},	// CJK UNIFIED IDEOGRAPH
	{0xB1C3,	0x6399},	// CJK UNIFIED IDEOGRAPH
	{0xB1C4,	0x63A1},	// CJK UNIFIED IDEOGRAPH
	{0xB1C5,	0x63AC},	// CJK UNIFIED IDEOGRAPH
	{0xB1C6,	0x6392},	// CJK UNIFIED IDEOGRAPH
	{0xB1C7,	0x638F},	// CJK UNIFIED IDEOGRAPH
	{0xB1C8,	0x6380},	// CJK UNIFIED IDEOGRAPH
	{0xB1C9,	0x637B},	// CJK UNIFIED IDEOGRAPH
	{0xB1CA,	0x6369},	// CJK UNIFIED IDEOGRAPH
	{0xB1CB,	0x6368},	// CJK UNIFIED IDEOGRAPH
	{0xB1CC,	0x637A},	// CJK UNIFIED IDEOGRAPH
	{0xB1CD,	0x655D},	// CJK UNIFIED IDEOGRAPH
	{0xB1CE,	0x6556},	// CJK UNIFIED IDEOGRAPH
	{0xB1CF,	0x6551},	// CJK UNIFIED IDEOGRAPH
	{0xB1D0,	0x6559},	// CJK UNIFIED IDEOGRAPH
	{0xB1D1,	0x6557},	// CJK UNIFIED IDEOGRAPH
	{0xB1D2,	0x555F},	// CJK UNIFIED IDEOGRAPH
	{0xB1D3,	0x654F},	// CJK UNIFIED IDEOGRAPH
	{0xB1D4,	0x6558},	// CJK UNIFIED IDEOGRAPH
	{0xB1D5,	0x6555},	// CJK UNIFIED IDEOGRAPH
	{0xB1D6,	0x6554},	// CJK UNIFIED IDEOGRAPH
	{0xB1D7,	0x659C},	// CJK UNIFIED IDEOGRAPH
	{0xB1D8,	0x659B},	// CJK UNIFIED IDEOGRAPH
	{0xB1D9,	0x65AC},	// CJK UNIFIED IDEOGRAPH
	{0xB1DA,	0x65CF},	// CJK UNIFIED IDEOGRAPH
	{0xB1DB,	0x65CB},	// CJK UNIFIED IDEOGRAPH
	{0xB1DC,	0x65CC},	// CJK UNIFIED IDEOGRAPH
	{0xB1DD,	0x65CE},	// CJK UNIFIED IDEOGRAPH
	{0xB1DE,	0x665D},	// CJK UNIFIED IDEOGRAPH
	{0xB1DF,	0x665A},	// CJK UNIFIED IDEOGRAPH
	{0xB1E0,	0x6664},	// CJK UNIFIED IDEOGRAPH
	{0xB1E1,	0x6668},	// CJK UNIFIED IDEOGRAPH
	{0xB1E2,	0x6666},	// CJK UNIFIED IDEOGRAPH
	{0xB1E3,	0x665E},	// CJK UNIFIED IDEOGRAPH
	{0xB1E4,	0x66F9},	// CJK UNIFIED IDEOGRAPH
	{0xB1E5,	0x52D7},	// CJK UNIFIED IDEOGRAPH
	{0xB1E6,	0x671B},	// CJK UNIFIED IDEOGRAPH
	{0xB1E7,	0x6881},	// CJK UNIFIED IDEOGRAPH
	{0xB1E8,	0x68AF},	// CJK UNIFIED IDEOGRAPH
	{0xB1E9,	0x68A2},	// CJK UNIFIED IDEOGRAPH
	{0xB1EA,	0x6893},	// CJK UNIFIED IDEOGRAPH
	{0xB1EB,	0x68B5},	// CJK UNIFIED IDEOGRAPH
	{0xB1EC,	0x687F},	// CJK UNIFIED IDEOGRAPH
	{0xB1ED,	0x6876},	// CJK UNIFIED IDEOGRAPH
	{0xB1EE,	0x68B1},	// CJK UNIFIED IDEOGRAPH
	{0xB1EF,	0x68A7},	// CJK UNIFIED IDEOGRAPH
	{0xB1F0,	0x6897},	// CJK UNIFIED IDEOGRAPH
	{0xB1F1,	0x68B0},	// CJK UNIFIED IDEOGRAPH
	{0xB1F2,	0x6883},	// CJK UNIFIED IDEOGRAPH
	{0xB1F3,	0x68C4},	// CJK UNIFIED IDEOGRAPH
	{0xB1F4,	0x68AD},	// CJK UNIFIED IDEOGRAPH
	{0xB1F5,	0x6886},	// CJK UNIFIED IDEOGRAPH
	{0xB1F6,	0x6885},	// CJK UNIFIED IDEOGRAPH
	{0xB1F7,	0x6894},	// CJK UNIFIED IDEOGRAPH
	{0xB1F8,	0x689D},	// CJK UNIFIED IDEOGRAPH
	{0xB1F9,	0x68A8},	// CJK UNIFIED IDEOGRAPH
	{0xB1FA,	0x689F},	// CJK UNIFIED IDEOGRAPH
	{0xB1FB,	0x68A1},	// CJK UNIFIED IDEOGRAPH
	{0xB1FC,	0x6882},	// CJK UNIFIED IDEOGRAPH
	{0xB1FD,	0x6B32},	// CJK UNIFIED IDEOGRAPH
	{0xB1FE,	0x6BBA},	// CJK UNIFIED IDEOGRAPH
	{0xB240,	0x6BEB},	// CJK UNIFIED IDEOGRAPH
	{0xB241,	0x6BEC},	// CJK UNIFIED IDEOGRAPH
	{0xB242,	0x6C2B},	// CJK UNIFIED IDEOGRAPH
	{0xB243,	0x6D8E},	// CJK UNIFIED IDEOGRAPH
	{0xB244,	0x6DBC},	// CJK UNIFIED IDEOGRAPH
	{0xB245,	0x6DF3},	// CJK UNIFIED IDEOGRAPH
	{0xB246,	0x6DD9},	// CJK UNIFIED IDEOGRAPH
	{0xB247,	0x6DB2},	// CJK UNIFIED IDEOGRAPH
	{0xB248,	0x6DE1},	// CJK UNIFIED IDEOGRAPH
	{0xB249,	0x6DCC},	// CJK UNIFIED IDEOGRAPH
	{0xB24A,	0x6DE4},	// CJK UNIFIED IDEOGRAPH
	{0xB24B,	0x6DFB},	// CJK UNIFIED IDEOGRAPH
	{0xB24C,	0x6DFA},	// CJK UNIFIED IDEOGRAPH
	{0xB24D,	0x6E05},	// CJK UNIFIED IDEOGRAPH
	{0xB24E,	0x6DC7},	// CJK UNIFIED IDEOGRAPH
	{0xB24F,	0x6DCB},	// CJK UNIFIED IDEOGRAPH
	{0xB250,	0x6DAF},	// CJK UNIFIED IDEOGRAPH
	{0xB251,	0x6DD1},	// CJK UNIFIED IDEOGRAPH
	{0xB252,	0x6DAE},	// CJK UNIFIED IDEOGRAPH
	{0xB253,	0x6DDE},	// CJK UNIFIED IDEOGRAPH
	{0xB254,	0x6DF9},	// CJK UNIFIED IDEOGRAPH
	{0xB255,	0x6DB8},	// CJK UNIFIED IDEOGRAPH
	{0xB256,	0x6DF7},	// CJK UNIFIED IDEOGRAPH
	{0xB257,	0x6DF5},	// CJK UNIFIED IDEOGRAPH
	{0xB258,	0x6DC5},	// CJK UNIFIED IDEOGRAPH
	{0xB259,	0x6DD2},	// CJK UNIFIED IDEOGRAPH
	{0xB25A,	0x6E1A},	// CJK UNIFIED IDEOGRAPH
	{0xB25B,	0x6DB5},	// CJK UNIFIED IDEOGRAPH
	{0xB25C,	0x6DDA},	// CJK UNIFIED IDEOGRAPH
	{0xB25D,	0x6DEB},	// CJK UNIFIED IDEOGRAPH
	{0xB25E,	0x6DD8},	// CJK UNIFIED IDEOGRAPH
	{0xB25F,	0x6DEA},	// CJK UNIFIED IDEOGRAPH
	{0xB260,	0x6DF1},	// CJK UNIFIED IDEOGRAPH
	{0xB261,	0x6DEE},	// CJK UNIFIED IDEOGRAPH
	{0xB262,	0x6DE8},	// CJK UNIFIED IDEOGRAPH
	{0xB263,	0x6DC6},	// CJK UNIFIED IDEOGRAPH
	{0xB264,	0x6DC4},	// CJK UNIFIED IDEOGRAPH
	{0xB265,	0x6DAA},	// CJK UNIFIED IDEOGRAPH
	{0xB266,	0x6DEC},	// CJK UNIFIED IDEOGRAPH
	{0xB267,	0x6DBF},	// CJK UNIFIED IDEOGRAPH
	{0xB268,	0x6DE6},	// CJK UNIFIED IDEOGRAPH
	{0xB269,	0x70F9},	// CJK UNIFIED IDEOGRAPH
	{0xB26A,	0x7109},	// CJK UNIFIED IDEOGRAPH
	{0xB26B,	0x710A},	// CJK UNIFIED IDEOGRAPH
	{0xB26C,	0x70FD},	// CJK UNIFIED IDEOGRAPH
	{0xB26D,	0x70EF},	// CJK UNIFIED IDEOGRAPH
	{0xB26E,	0x723D},	// CJK UNIFIED IDEOGRAPH
	{0xB26F,	0x727D},	// CJK UNIFIED IDEOGRAPH
	{0xB270,	0x7281},	// CJK UNIFIED IDEOGRAPH
	{0xB271,	0x731C},	// CJK UNIFIED IDEOGRAPH
	{0xB272,	0x731B},	// CJK UNIFIED IDEOGRAPH
	{0xB273,	0x7316},	// CJK UNIFIED IDEOGRAPH
	{0xB274,	0x7313},	// CJK UNIFIED IDEOGRAPH
	{0xB275,	0x7319},	// CJK UNIFIED IDEOGRAPH
	{0xB276,	0x7387},	// CJK UNIFIED IDEOGRAPH
	{0xB277,	0x7405},	// CJK UNIFIED IDEOGRAPH
	{0xB278,	0x740A},	// CJK UNIFIED IDEOGRAPH
	{0xB279,	0x7403},	// CJK UNIFIED IDEOGRAPH
	{0xB27A,	0x7406},	// CJK UNIFIED IDEOGRAPH
	{0xB27B,	0x73FE},	// CJK UNIFIED IDEOGRAPH
	{0xB27C,	0x740D},	// CJK UNIFIED IDEOGRAPH
	{0xB27D,	0x74E0},	// CJK UNIFIED IDEOGRAPH
	{0xB27E,	0x74F6},	// CJK UNIFIED IDEOGRAPH
	{0xB2A1,	0x74F7},	// CJK UNIFIED IDEOGRAPH
	{0xB2A2,	0x751C},	// CJK UNIFIED IDEOGRAPH
	{0xB2A3,	0x7522},	// CJK UNIFIED IDEOGRAPH
	{0xB2A4,	0x7565},	// CJK UNIFIED IDEOGRAPH
	{0xB2A5,	0x7566},	// CJK UNIFIED IDEOGRAPH
	{0xB2A6,	0x7562},	// CJK UNIFIED IDEOGRAPH
	{0xB2A7,	0x7570},	// CJK UNIFIED IDEOGRAPH
	{0xB2A8,	0x758F},	// CJK UNIFIED IDEOGRAPH
	{0xB2A9,	0x75D4},	// CJK UNIFIED IDEOGRAPH
	{0xB2AA,	0x75D5},	// CJK UNIFIED IDEOGRAPH
	{0xB2AB,	0x75B5},	// CJK UNIFIED IDEOGRAPH
	{0xB2AC,	0x75CA},	// CJK UNIFIED IDEOGRAPH
	{0xB2AD,	0x75CD},	// CJK UNIFIED IDEOGRAPH
	{0xB2AE,	0x768E},	// CJK UNIFIED IDEOGRAPH
	{0xB2AF,	0x76D4},	// CJK UNIFIED IDEOGRAPH
	{0xB2B0,	0x76D2},	// CJK UNIFIED IDEOGRAPH
	{0xB2B1,	0x76DB},	// CJK UNIFIED IDEOGRAPH
	{0xB2B2,	0x7737},	// CJK UNIFIED IDEOGRAPH
	{0xB2B3,	0x773E},	// CJK UNIFIED IDEOGRAPH
	{0xB2B4,	0x773C},	// CJK UNIFIED IDEOGRAPH
	{0xB2B5,	0x7736},	// CJK UNIFIED IDEOGRAPH
	{0xB2B6,	0x7738},	// CJK UNIFIED IDEOGRAPH
	{0xB2B7,	0x773A},	// CJK UNIFIED IDEOGRAPH
	{0xB2B8,	0x786B},	// CJK UNIFIED IDEOGRAPH
	{0xB2B9,	0x7843},	// CJK UNIFIED IDEOGRAPH
	{0xB2BA,	0x784E},	// CJK UNIFIED IDEOGRAPH
	{0xB2BB,	0x7965},	// CJK UNIFIED IDEOGRAPH
	{0xB2BC,	0x7968},	// CJK UNIFIED IDEOGRAPH
	{0xB2BD,	0x796D},	// CJK UNIFIED IDEOGRAPH
	{0xB2BE,	0x79FB},	// CJK UNIFIED IDEOGRAPH
	{0xB2BF,	0x7A92},	// CJK UNIFIED IDEOGRAPH
	{0xB2C0,	0x7A95},	// CJK UNIFIED IDEOGRAPH
	{0xB2C1,	0x7B20},	// CJK UNIFIED IDEOGRAPH
	{0xB2C2,	0x7B28},	// CJK UNIFIED IDEOGRAPH
	{0xB2C3,	0x7B1B},	// CJK UNIFIED IDEOGRAPH
	{0xB2C4,	0x7B2C},	// CJK UNIFIED IDEOGRAPH
	{0xB2C5,	0x7B26},	// CJK UNIFIED IDEOGRAPH
	{0xB2C6,	0x7B19},	// CJK UNIFIED IDEOGRAPH
	{0xB2C7,	0x7B1E},	// CJK UNIFIED IDEOGRAPH
	{0xB2C8,	0x7B2E},	// CJK UNIFIED IDEOGRAPH
	{0xB2C9,	0x7C92},	// CJK UNIFIED IDEOGRAPH
	{0xB2CA,	0x7C97},	// CJK UNIFIED IDEOGRAPH
	{0xB2CB,	0x7C95},	// CJK UNIFIED IDEOGRAPH
	{0xB2CC,	0x7D46},	// CJK UNIFIED IDEOGRAPH
	{0xB2CD,	0x7D43},	// CJK UNIFIED IDEOGRAPH
	{0xB2CE,	0x7D71},	// CJK UNIFIED IDEOGRAPH
	{0xB2CF,	0x7D2E},	// CJK UNIFIED IDEOGRAPH
	{0xB2D0,	0x7D39},	// CJK UNIFIED IDEOGRAPH
	{0xB2D1,	0x7D3C},	// CJK UNIFIED IDEOGRAPH
	{0xB2D2,	0x7D40},	// CJK UNIFIED IDEOGRAPH
	{0xB2D3,	0x7D30},	// CJK UNIFIED IDEOGRAPH
	{0xB2D4,	0x7D33},	// CJK UNIFIED IDEOGRAPH
	{0xB2D5,	0x7D44},	// CJK UNIFIED IDEOGRAPH
	{0xB2D6,	0x7D2F},	// CJK UNIFIED IDEOGRAPH
	{0xB2D7,	0x7D42},	// CJK UNIFIED IDEOGRAPH
	{0xB2D8,	0x7D32},	// CJK UNIFIED IDEOGRAPH
	{0xB2D9,	0x7D31},	// CJK UNIFIED IDEOGRAPH
	{0xB2DA,	0x7F3D},	// CJK UNIFIED IDEOGRAPH
	{0xB2DB,	0x7F9E},	// CJK UNIFIED IDEOGRAPH
	{0xB2DC,	0x7F9A},	// CJK UNIFIED IDEOGRAPH
	{0xB2DD,	0x7FCC},	// CJK UNIFIED IDEOGRAPH
	{0xB2DE,	0x7FCE},	// CJK UNIFIED IDEOGRAPH
	{0xB2DF,	0x7FD2},	// CJK UNIFIED IDEOGRAPH
	{0xB2E0,	0x801C},	// CJK UNIFIED IDEOGRAPH
	{0xB2E1,	0x804A},	// CJK UNIFIED IDEOGRAPH
	{0xB2E2,	0x8046},	// CJK UNIFIED IDEOGRAPH
	{0xB2E3,	0x812F},	// CJK UNIFIED IDEOGRAPH
	{0xB2E4,	0x8116},	// CJK UNIFIED IDEOGRAPH
	{0xB2E5,	0x8123},	// CJK UNIFIED IDEOGRAPH
	{0xB2E6,	0x812B},	// CJK UNIFIED IDEOGRAPH
	{0xB2E7,	0x8129},	// CJK UNIFIED IDEOGRAPH
	{0xB2E8,	0x8130},	// CJK UNIFIED IDEOGRAPH
	{0xB2E9,	0x8124},	// CJK UNIFIED IDEOGRAPH
	{0xB2EA,	0x8202},	// CJK UNIFIED IDEOGRAPH
	{0xB2EB,	0x8235},	// CJK UNIFIED IDEOGRAPH
	{0xB2EC,	0x8237},	// CJK UNIFIED IDEOGRAPH
	{0xB2ED,	0x8236},	// CJK UNIFIED IDEOGRAPH
	{0xB2EE,	0x8239},	// CJK UNIFIED IDEOGRAPH
	{0xB2EF,	0x838E},	// CJK UNIFIED IDEOGRAPH
	{0xB2F0,	0x839E},	// CJK UNIFIED IDEOGRAPH
	{0xB2F1,	0x8398},	// CJK UNIFIED IDEOGRAPH
	{0xB2F2,	0x8378},	// CJK UNIFIED IDEOGRAPH
	{0xB2F3,	0x83A2},	// CJK UNIFIED IDEOGRAPH
	{0xB2F4,	0x8396},	// CJK UNIFIED IDEOGRAPH
	{0xB2F5,	0x83BD},	// CJK UNIFIED IDEOGRAPH
	{0xB2F6,	0x83AB},	// CJK UNIFIED IDEOGRAPH
	{0xB2F7,	0x8392},	// CJK UNIFIED IDEOGRAPH
	{0xB2F8,	0x838A},	// CJK UNIFIED IDEOGRAPH
	{0xB2F9,	0x8393},	// CJK UNIFIED IDEOGRAPH
	{0xB2FA,	0x8389},	// CJK UNIFIED IDEOGRAPH
	{0xB2FB,	0x83A0},	// CJK UNIFIED IDEOGRAPH
	{0xB2FC,	0x8377},	// CJK UNIFIED IDEOGRAPH
	{0xB2FD,	0x837B},	// CJK UNIFIED IDEOGRAPH
	{0xB2FE,	0x837C},	// CJK UNIFIED IDEOGRAPH
	{0xB340,	0x8386},	// CJK UNIFIED IDEOGRAPH
	{0xB341,	0x83A7},	// CJK UNIFIED IDEOGRAPH
	{0xB342,	0x8655},	// CJK UNIFIED IDEOGRAPH
	{0xB343,	0x5F6A},	// CJK UNIFIED IDEOGRAPH
	{0xB344,	0x86C7},	// CJK UNIFIED IDEOGRAPH
	{0xB345,	0x86C0},	// CJK UNIFIED IDEOGRAPH
	{0xB346,	0x86B6},	// CJK UNIFIED IDEOGRAPH
	{0xB347,	0x86C4},	// CJK UNIFIED IDEOGRAPH
	{0xB348,	0x86B5},	// CJK UNIFIED IDEOGRAPH
	{0xB349,	0x86C6},	// CJK UNIFIED IDEOGRAPH
	{0xB34A,	0x86CB},	// CJK UNIFIED IDEOGRAPH
	{0xB34B,	0x86B1},	// CJK UNIFIED IDEOGRAPH
	{0xB34C,	0x86AF},	// CJK UNIFIED IDEOGRAPH
	{0xB34D,	0x86C9},	// CJK UNIFIED IDEOGRAPH
	{0xB34E,	0x8853},	// CJK UNIFIED IDEOGRAPH
	{0xB34F,	0x889E},	// CJK UNIFIED IDEOGRAPH
	{0xB350,	0x8888},	// CJK UNIFIED IDEOGRAPH
	{0xB351,	0x88AB},	// CJK UNIFIED IDEOGRAPH
	{0xB352,	0x8892},	// CJK UNIFIED IDEOGRAPH
	{0xB353,	0x8896},	// CJK UNIFIED IDEOGRAPH
	{0xB354,	0x888D},	// CJK UNIFIED IDEOGRAPH
	{0xB355,	0x888B},	// CJK UNIFIED IDEOGRAPH
	{0xB356,	0x8993},	// CJK UNIFIED IDEOGRAPH
	{0xB357,	0x898F},	// CJK UNIFIED IDEOGRAPH
	{0xB358,	0x8A2A},	// CJK UNIFIED IDEOGRAPH
	{0xB359,	0x8A1D},	// CJK UNIFIED IDEOGRAPH
	{0xB35A,	0x8A23},	// CJK UNIFIED IDEOGRAPH
	{0xB35B,	0x8A25},	// CJK UNIFIED IDEOGRAPH
	{0xB35C,	0x8A31},	// CJK UNIFIED IDEOGRAPH
	{0xB35D,	0x8A2D},	// CJK UNIFIED IDEOGRAPH
	{0xB35E,	0x8A1F},	// CJK UNIFIED IDEOGRAPH
	{0xB35F,	0x8A1B},	// CJK UNIFIED IDEOGRAPH
	{0xB360,	0x8A22},	// CJK UNIFIED IDEOGRAPH
	{0xB361,	0x8C49},	// CJK UNIFIED IDEOGRAPH
	{0xB362,	0x8C5A},	// CJK UNIFIED IDEOGRAPH
	{0xB363,	0x8CA9},	// CJK UNIFIED IDEOGRAPH
	{0xB364,	0x8CAC},	// CJK UNIFIED IDEOGRAPH
	{0xB365,	0x8CAB},	// CJK UNIFIED IDEOGRAPH
	{0xB366,	0x8CA8},	// CJK UNIFIED IDEOGRAPH
	{0xB367,	0x8CAA},	// CJK UNIFIED IDEOGRAPH
	{0xB368,	0x8CA7},	// CJK UNIFIED IDEOGRAPH
	{0xB369,	0x8D67},	// CJK UNIFIED IDEOGRAPH
	{0xB36A,	0x8D66},	// CJK UNIFIED IDEOGRAPH
	{0xB36B,	0x8DBE},	// CJK UNIFIED IDEOGRAPH
	{0xB36C,	0x8DBA},	// CJK UNIFIED IDEOGRAPH
	{0xB36D,	0x8EDB},	// CJK UNIFIED IDEOGRAPH
	{0xB36E,	0x8EDF},	// CJK UNIFIED IDEOGRAPH
	{0xB36F,	0x9019},	// CJK UNIFIED IDEOGRAPH
	{0xB370,	0x900D},	// CJK UNIFIED IDEOGRAPH
	{0xB371,	0x901A},	// CJK UNIFIED IDEOGRAPH
	{0xB372,	0x9017},	// CJK UNIFIED IDEOGRAPH
	{0xB373,	0x9023},	// CJK UNIFIED IDEOGRAPH
	{0xB374,	0x901F},	// CJK UNIFIED IDEOGRAPH
	{0xB375,	0x901D},	// CJK UNIFIED IDEOGRAPH
	{0xB376,	0x9010},	// CJK UNIFIED IDEOGRAPH
	{0xB377,	0x9015},	// CJK UNIFIED IDEOGRAPH
	{0xB378,	0x901E},	// CJK UNIFIED IDEOGRAPH
	{0xB379,	0x9020},	// CJK UNIFIED IDEOGRAPH
	{0xB37A,	0x900F},	// CJK UNIFIED IDEOGRAPH
	{0xB37B,	0x9022},	// CJK UNIFIED IDEOGRAPH
	{0xB37C,	0x9016},	// CJK UNIFIED IDEOGRAPH
	{0xB37D,	0x901B},	// CJK UNIFIED IDEOGRAPH
	{0xB37E,	0x9014},	// CJK UNIFIED IDEOGRAPH
	{0xB3A1,	0x90E8},	// CJK UNIFIED IDEOGRAPH
	{0xB3A2,	0x90ED},	// CJK UNIFIED IDEOGRAPH
	{0xB3A3,	0x90FD},	// CJK UNIFIED IDEOGRAPH
	{0xB3A4,	0x9157},	// CJK UNIFIED IDEOGRAPH
	{0xB3A5,	0x91CE},	// CJK UNIFIED IDEOGRAPH
	{0xB3A6,	0x91F5},	// CJK UNIFIED IDEOGRAPH
	{0xB3A7,	0x91E6},	// CJK UNIFIED IDEOGRAPH
	{0xB3A8,	0x91E3},	// CJK UNIFIED IDEOGRAPH
	{0xB3A9,	0x91E7},	// CJK UNIFIED IDEOGRAPH
	{0xB3AA,	0x91ED},	// CJK UNIFIED IDEOGRAPH
	{0xB3AB,	0x91E9},	// CJK UNIFIED IDEOGRAPH
	{0xB3AC,	0x9589},	// CJK UNIFIED IDEOGRAPH
	{0xB3AD,	0x966A},	// CJK UNIFIED IDEOGRAPH
	{0xB3AE,	0x9675},	// CJK UNIFIED IDEOGRAPH
	{0xB3AF,	0x9673},	// CJK UNIFIED IDEOGRAPH
	{0xB3B0,	0x9678},	// CJK UNIFIED IDEOGRAPH
	{0xB3B1,	0x9670},	// CJK UNIFIED IDEOGRAPH
	{0xB3B2,	0x9674},	// CJK UNIFIED IDEOGRAPH
	{0xB3B3,	0x9676},	// CJK UNIFIED IDEOGRAPH
	{0xB3B4,	0x9677},	// CJK UNIFIED IDEOGRAPH
	{0xB3B5,	0x966C},	// CJK UNIFIED IDEOGRAPH
	{0xB3B6,	0x96C0},	// CJK UNIFIED IDEOGRAPH
	{0xB3B7,	0x96EA},	// CJK UNIFIED IDEOGRAPH
	{0xB3B8,	0x96E9},	// CJK UNIFIED IDEOGRAPH
	{0xB3B9,	0x7AE0},	// CJK UNIFIED IDEOGRAPH
	{0xB3BA,	0x7ADF},	// CJK UNIFIED IDEOGRAPH
	{0xB3BB,	0x9802},	// CJK UNIFIED IDEOGRAPH
	{0xB3BC,	0x9803},	// CJK UNIFIED IDEOGRAPH
	{0xB3BD,	0x9B5A},	// CJK UNIFIED IDEOGRAPH
	{0xB3BE,	0x9CE5},	// CJK UNIFIED IDEOGRAPH
	{0xB3BF,	0x9E75},	// CJK UNIFIED IDEOGRAPH
	{0xB3C0,	0x9E7F},	// CJK UNIFIED IDEOGRAPH
	{0xB3C1,	0x9EA5},	// CJK UNIFIED IDEOGRAPH
	{0xB3C2,	0x9EBB},	// CJK UNIFIED IDEOGRAPH
	{0xB3C3,	0x50A2},	// CJK UNIFIED IDEOGRAPH
	{0xB3C4,	0x508D},	// CJK UNIFIED IDEOGRAPH
	{0xB3C5,	0x5085},	// CJK UNIFIED IDEOGRAPH
	{0xB3C6,	0x5099},	// CJK UNIFIED IDEOGRAPH
	{0xB3C7,	0x5091},	// CJK UNIFIED IDEOGRAPH
	{0xB3C8,	0x5080},	// CJK UNIFIED IDEOGRAPH
	{0xB3C9,	0x5096},	// CJK UNIFIED IDEOGRAPH
	{0xB3CA,	0x5098},	// CJK UNIFIED IDEOGRAPH
	{0xB3CB,	0x509A},	// CJK UNIFIED IDEOGRAPH
	{0xB3CC,	0x6700},	// CJK UNIFIED IDEOGRAPH
	{0xB3CD,	0x51F1},	// CJK UNIFIED IDEOGRAPH
	{0xB3CE,	0x5272},	// CJK UNIFIED IDEOGRAPH
	{0xB3CF,	0x5274},	// CJK UNIFIED IDEOGRAPH
	{0xB3D0,	0x5275},	// CJK UNIFIED IDEOGRAPH
	{0xB3D1,	0x5269},	// CJK UNIFIED IDEOGRAPH
	{0xB3D2,	0x52DE},	// CJK UNIFIED IDEOGRAPH
	{0xB3D3,	0x52DD},	// CJK UNIFIED IDEOGRAPH
	{0xB3D4,	0x52DB},	// CJK UNIFIED IDEOGRAPH
	{0xB3D5,	0x535A},	// CJK UNIFIED IDEOGRAPH
	{0xB3D6,	0x53A5},	// CJK UNIFIED IDEOGRAPH
	{0xB3D7,	0x557B},	// CJK UNIFIED IDEOGRAPH
	{0xB3D8,	0x5580},	// CJK UNIFIED IDEOGRAPH
	{0xB3D9,	0x55A7},	// CJK UNIFIED IDEOGRAPH
	{0xB3DA,	0x557C},	// CJK UNIFIED IDEOGRAPH
	{0xB3DB,	0x558A},	// CJK UNIFIED IDEOGRAPH
	{0xB3DC,	0x559D},	// CJK UNIFIED IDEOGRAPH
	{0xB3DD,	0x5598},	// CJK UNIFIED IDEOGRAPH
	{0xB3DE,	0x5582},	// CJK UNIFIED IDEOGRAPH
	{0xB3DF,	0x559C},	// CJK UNIFIED IDEOGRAPH
	{0xB3E0,	0x55AA},	// CJK UNIFIED IDEOGRAPH
	{0xB3E1,	0x5594},	// CJK UNIFIED IDEOGRAPH
	{0xB3E2,	0x5587},	// CJK UNIFIED IDEOGRAPH
	{0xB3E3,	0x558B},	// CJK UNIFIED IDEOGRAPH
	{0xB3E4,	0x5583},	// CJK UNIFIED IDEOGRAPH
	{0xB3E5,	0x55B3},	// CJK UNIFIED IDEOGRAPH
	{0xB3E6,	0x55AE},	// CJK UNIFIED IDEOGRAPH
	{0xB3E7,	0x559F},	// CJK UNIFIED IDEOGRAPH
	{0xB3E8,	0x553E},	// CJK UNIFIED IDEOGRAPH
	{0xB3E9,	0x55B2},	// CJK UNIFIED IDEOGRAPH
	{0xB3EA,	0x559A},	// CJK UNIFIED IDEOGRAPH
	{0xB3EB,	0x55BB},	// CJK UNIFIED IDEOGRAPH
	{0xB3EC,	0x55AC},	// CJK UNIFIED IDEOGRAPH
	{0xB3ED,	0x55B1},	// CJK UNIFIED IDEOGRAPH
	{0xB3EE,	0x557E},	// CJK UNIFIED IDEOGRAPH
	{0xB3EF,	0x5589},	// CJK UNIFIED IDEOGRAPH
	{0xB3F0,	0x55AB},	// CJK UNIFIED IDEOGRAPH
	{0xB3F1,	0x5599},	// CJK UNIFIED IDEOGRAPH
	{0xB3F2,	0x570D},	// CJK UNIFIED IDEOGRAPH
	{0xB3F3,	0x582F},	// CJK UNIFIED IDEOGRAPH
	{0xB3F4,	0x582A},	// CJK UNIFIED IDEOGRAPH
	{0xB3F5,	0x5834},	// CJK UNIFIED IDEOGRAPH
	{0xB3F6,	0x5824},	// CJK UNIFIED IDEOGRAPH
	{0xB3F7,	0x5830},	// CJK UNIFIED IDEOGRAPH
	{0xB3F8,	0x5831},	// CJK UNIFIED IDEOGRAPH
	{0xB3F9,	0x5821},	// CJK UNIFIED IDEOGRAPH
	{0xB3FA,	0x581D},	// CJK UNIFIED IDEOGRAPH
	{0xB3FB,	0x5820},	// CJK UNIFIED IDEOGRAPH
	{0xB3FC,	0x58F9},	// CJK UNIFIED IDEOGRAPH
	{0xB3FD,	0x58FA},	// CJK UNIFIED IDEOGRAPH
	{0xB3FE,	0x5960},	// CJK UNIFIED IDEOGRAPH
	{0xB440,	0x5A77},	// CJK UNIFIED IDEOGRAPH
	{0xB441,	0x5A9A},	// CJK UNIFIED IDEOGRAPH
	{0xB442,	0x5A7F},	// CJK UNIFIED IDEOGRAPH
	{0xB443,	0x5A92},	// CJK UNIFIED IDEOGRAPH
	{0xB444,	0x5A9B},	// CJK UNIFIED IDEOGRAPH
	{0xB445,	0x5AA7},	// CJK UNIFIED IDEOGRAPH
	{0xB446,	0x5B73},	// CJK UNIFIED IDEOGRAPH
	{0xB447,	0x5B71},	// CJK UNIFIED IDEOGRAPH
	{0xB448,	0x5BD2},	// CJK UNIFIED IDEOGRAPH
	{0xB449,	0x5BCC},	// CJK UNIFIED IDEOGRAPH
	{0xB44A,	0x5BD3},	// CJK UNIFIED IDEOGRAPH
	{0xB44B,	0x5BD0},	// CJK UNIFIED IDEOGRAPH
	{0xB44C,	0x5C0A},	// CJK UNIFIED IDEOGRAPH
	{0xB44D,	0x5C0B},	// CJK UNIFIED IDEOGRAPH
	{0xB44E,	0x5C31},	// CJK UNIFIED IDEOGRAPH
	{0xB44F,	0x5D4C},	// CJK UNIFIED IDEOGRAPH
	{0xB450,	0x5D50},	// CJK UNIFIED IDEOGRAPH
	{0xB451,	0x5D34},	// CJK UNIFIED IDEOGRAPH
	{0xB452,	0x5D47},	// CJK UNIFIED IDEOGRAPH
	{0xB453,	0x5DFD},	// CJK UNIFIED IDEOGRAPH
	{0xB454,	0x5E45},	// CJK UNIFIED IDEOGRAPH
	{0xB455,	0x5E3D},	// CJK UNIFIED IDEOGRAPH
	{0xB456,	0x5E40},	// CJK UNIFIED IDEOGRAPH
	{0xB457,	0x5E43},	// CJK UNIFIED IDEOGRAPH
	{0xB458,	0x5E7E},	// CJK UNIFIED IDEOGRAPH
	{0xB459,	0x5ECA},	// CJK UNIFIED IDEOGRAPH
	{0xB45A,	0x5EC1},	// CJK UNIFIED IDEOGRAPH
	{0xB45B,	0x5EC2},	// CJK UNIFIED IDEOGRAPH
	{0xB45C,	0x5EC4},	// CJK UNIFIED IDEOGRAPH
	{0xB45D,	0x5F3C},	// CJK UNIFIED IDEOGRAPH
	{0xB45E,	0x5F6D},	// CJK UNIFIED IDEOGRAPH
	{0xB45F,	0x5FA9},	// CJK UNIFIED IDEOGRAPH
	{0xB460,	0x5FAA},	// CJK UNIFIED IDEOGRAPH
	{0xB461,	0x5FA8},	// CJK UNIFIED IDEOGRAPH
	{0xB462,	0x60D1},	// CJK UNIFIED IDEOGRAPH
	{0xB463,	0x60E1},	// CJK UNIFIED IDEOGRAPH
	{0xB464,	0x60B2},	// CJK UNIFIED IDEOGRAPH
	{0xB465,	0x60B6},	// CJK UNIFIED IDEOGRAPH
	{0xB466,	0x60E0},	// CJK UNIFIED IDEOGRAPH
	{0xB467,	0x611C},	// CJK UNIFIED IDEOGRAPH
	{0xB468,	0x6123},	// CJK UNIFIED IDEOGRAPH
	{0xB469,	0x60FA},	// CJK UNIFIED IDEOGRAPH
	{0xB46A,	0x6115},	// CJK UNIFIED IDEOGRAPH
	{0xB46B,	0x60F0},	// CJK UNIFIED IDEOGRAPH
	{0xB46C,	0x60FB},	// CJK UNIFIED IDEOGRAPH
	{0xB46D,	0x60F4},	// CJK UNIFIED IDEOGRAPH
	{0xB46E,	0x6168},	// CJK UNIFIED IDEOGRAPH
	{0xB46F,	0x60F1},	// CJK UNIFIED IDEOGRAPH
	{0xB470,	0x610E},	// CJK UNIFIED IDEOGRAPH
	{0xB471,	0x60F6},	// CJK UNIFIED IDEOGRAPH
	{0xB472,	0x6109},	// CJK UNIFIED IDEOGRAPH
	{0xB473,	0x6100},	// CJK UNIFIED IDEOGRAPH
	{0xB474,	0x6112},	// CJK UNIFIED IDEOGRAPH
	{0xB475,	0x621F},	// CJK UNIFIED IDEOGRAPH
	{0xB476,	0x6249},	// CJK UNIFIED IDEOGRAPH
	{0xB477,	0x63A3},	// CJK UNIFIED IDEOGRAPH
	{0xB478,	0x638C},	// CJK UNIFIED IDEOGRAPH
	{0xB479,	0x63CF},	// CJK UNIFIED IDEOGRAPH
	{0xB47A,	0x63C0},	// CJK UNIFIED IDEOGRAPH
	{0xB47B,	0x63E9},	// CJK UNIFIED IDEOGRAPH
	{0xB47C,	0x63C9},	// CJK UNIFIED IDEOGRAPH
	{0xB47D,	0x63C6},	// CJK UNIFIED IDEOGRAPH
	{0xB47E,	0x63CD},	// CJK UNIFIED IDEOGRAPH
	{0xB4A1,	0x63D2},	// CJK UNIFIED IDEOGRAPH
	{0xB4A2,	0x63E3},	// CJK UNIFIED IDEOGRAPH
	{0xB4A3,	0x63D0},	// CJK UNIFIED IDEOGRAPH
	{0xB4A4,	0x63E1},	// CJK UNIFIED IDEOGRAPH
	{0xB4A5,	0x63D6},	// CJK UNIFIED IDEOGRAPH
	{0xB4A6,	0x63ED},	// CJK UNIFIED IDEOGRAPH
	{0xB4A7,	0x63EE},	// CJK UNIFIED IDEOGRAPH
	{0xB4A8,	0x6376},	// CJK UNIFIED IDEOGRAPH
	{0xB4A9,	0x63F4},	// CJK UNIFIED IDEOGRAPH
	{0xB4AA,	0x63EA},	// CJK UNIFIED IDEOGRAPH
	{0xB4AB,	0x63DB},	// CJK UNIFIED IDEOGRAPH
	{0xB4AC,	0x6452},	// CJK UNIFIED IDEOGRAPH
	{0xB4AD,	0x63DA},	// CJK UNIFIED IDEOGRAPH
	{0xB4AE,	0x63F9},	// CJK UNIFIED IDEOGRAPH
	{0xB4AF,	0x655E},	// CJK UNIFIED IDEOGRAPH
	{0xB4B0,	0x6566},	// CJK UNIFIED IDEOGRAPH
	{0xB4B1,	0x6562},	// CJK UNIFIED IDEOGRAPH
	{0xB4B2,	0x6563},	// CJK UNIFIED IDEOGRAPH
	{0xB4B3,	0x6591},	// CJK UNIFIED IDEOGRAPH
	{0xB4B4,	0x6590},	// CJK UNIFIED IDEOGRAPH
	{0xB4B5,	0x65AF},	// CJK UNIFIED IDEOGRAPH
	{0xB4B6,	0x666E},	// CJK UNIFIED IDEOGRAPH
	{0xB4B7,	0x6670},	// CJK UNIFIED IDEOGRAPH
	{0xB4B8,	0x6674},	// CJK UNIFIED IDEOGRAPH
	{0xB4B9,	0x6676},	// CJK UNIFIED IDEOGRAPH
	{0xB4BA,	0x666F},	// CJK UNIFIED IDEOGRAPH
	{0xB4BB,	0x6691},	// CJK UNIFIED IDEOGRAPH
	{0xB4BC,	0x667A},	// CJK UNIFIED IDEOGRAPH
	{0xB4BD,	0x667E},	// CJK UNIFIED IDEOGRAPH
	{0xB4BE,	0x6677},	// CJK UNIFIED IDEOGRAPH
	{0xB4BF,	0x66FE},	// CJK UNIFIED IDEOGRAPH
	{0xB4C0,	0x66FF},	// CJK UNIFIED IDEOGRAPH
	{0xB4C1,	0x671F},	// CJK UNIFIED IDEOGRAPH
	{0xB4C2,	0x671D},	// CJK UNIFIED IDEOGRAPH
	{0xB4C3,	0x68FA},	// CJK UNIFIED IDEOGRAPH
	{0xB4C4,	0x68D5},	// CJK UNIFIED IDEOGRAPH
	{0xB4C5,	0x68E0},	// CJK UNIFIED IDEOGRAPH
	{0xB4C6,	0x68D8},	// CJK UNIFIED IDEOGRAPH
	{0xB4C7,	0x68D7},	// CJK UNIFIED IDEOGRAPH
	{0xB4C8,	0x6905},	// CJK UNIFIED IDEOGRAPH
	{0xB4C9,	0x68DF},	// CJK UNIFIED IDEOGRAPH
	{0xB4CA,	0x68F5},	// CJK UNIFIED IDEOGRAPH
	{0xB4CB,	0x68EE},	// CJK UNIFIED IDEOGRAPH
	{0xB4CC,	0x68E7},	// CJK UNIFIED IDEOGRAPH
	{0xB4CD,	0x68F9},	// CJK UNIFIED IDEOGRAPH
	{0xB4CE,	0x68D2},	// CJK UNIFIED IDEOGRAPH
	{0xB4CF,	0x68F2},	// CJK UNIFIED IDEOGRAPH
	{0xB4D0,	0x68E3},	// CJK UNIFIED IDEOGRAPH
	{0xB4D1,	0x68CB},	// CJK UNIFIED IDEOGRAPH
	{0xB4D2,	0x68CD},	// CJK UNIFIED IDEOGRAPH
	{0xB4D3,	0x690D},	// CJK UNIFIED IDEOGRAPH
	{0xB4D4,	0x6912},	// CJK UNIFIED IDEOGRAPH
	{0xB4D5,	0x690E},	// CJK UNIFIED IDEOGRAPH
	{0xB4D6,	0x68C9},	// CJK UNIFIED IDEOGRAPH
	{0xB4D7,	0x68DA},	// CJK UNIFIED IDEOGRAPH
	{0xB4D8,	0x696E},	// CJK UNIFIED IDEOGRAPH
	{0xB4D9,	0x68FB},	// CJK UNIFIED IDEOGRAPH
	{0xB4DA,	0x6B3E},	// CJK UNIFIED IDEOGRAPH
	{0xB4DB,	0x6B3A},	// CJK UNIFIED IDEOGRAPH
	{0xB4DC,	0x6B3D},	// CJK UNIFIED IDEOGRAPH
	{0xB4DD,	0x6B98},	// CJK UNIFIED IDEOGRAPH
	{0xB4DE,	0x6B96},	// CJK UNIFIED IDEOGRAPH
	{0xB4DF,	0x6BBC},	// CJK UNIFIED IDEOGRAPH
	{0xB4E0,	0x6BEF},	// CJK UNIFIED IDEOGRAPH
	{0xB4E1,	0x6C2E},	// CJK UNIFIED IDEOGRAPH
	{0xB4E2,	0x6C2F},	// CJK UNIFIED IDEOGRAPH
	{0xB4E3,	0x6C2C},	// CJK UNIFIED IDEOGRAPH
	{0xB4E4,	0x6E2F},	// CJK UNIFIED IDEOGRAPH
	{0xB4E5,	0x6E38},	// CJK UNIFIED IDEOGRAPH
	{0xB4E6,	0x6E54},	// CJK UNIFIED IDEOGRAPH
	{0xB4E7,	0x6E21},	// CJK UNIFIED IDEOGRAPH
	{0xB4E8,	0x6E32},	// CJK UNIFIED IDEOGRAPH
	{0xB4E9,	0x6E67},	// CJK UNIFIED IDEOGRAPH
	{0xB4EA,	0x6E4A},	// CJK UNIFIED IDEOGRAPH
	{0xB4EB,	0x6E20},	// CJK UNIFIED IDEOGRAPH
	{0xB4EC,	0x6E25},	// CJK UNIFIED IDEOGRAPH
	{0xB4ED,	0x6E23},	// CJK UNIFIED IDEOGRAPH
	{0xB4EE,	0x6E1B},	// CJK UNIFIED IDEOGRAPH
	{0xB4EF,	0x6E5B},	// CJK UNIFIED IDEOGRAPH
	{0xB4F0,	0x6E58},	// CJK UNIFIED IDEOGRAPH
	{0xB4F1,	0x6E24},	// CJK UNIFIED IDEOGRAPH
	{0xB4F2,	0x6E56},	// CJK UNIFIED IDEOGRAPH
	{0xB4F3,	0x6E6E},	// CJK UNIFIED IDEOGRAPH
	{0xB4F4,	0x6E2D},	// CJK UNIFIED IDEOGRAPH
	{0xB4F5,	0x6E26},	// CJK UNIFIED IDEOGRAPH
	{0xB4F6,	0x6E6F},	// CJK UNIFIED IDEOGRAPH
	{0xB4F7,	0x6E34},	// CJK UNIFIED IDEOGRAPH
	{0xB4F8,	0x6E4D},	// CJK UNIFIED IDEOGRAPH
	{0xB4F9,	0x6E3A},	// CJK UNIFIED IDEOGRAPH
	{0xB4FA,	0x6E2C},	// CJK UNIFIED IDEOGRAPH
	{0xB4FB,	0x6E43},	// CJK UNIFIED IDEOGRAPH
	{0xB4FC,	0x6E1D},	// CJK UNIFIED IDEOGRAPH
	{0xB4FD,	0x6E3E},	// CJK UNIFIED IDEOGRAPH
	{0xB4FE,	0x6ECB},	// CJK UNIFIED IDEOGRAPH
	{0xB540,	0x6E89},	// CJK UNIFIED IDEOGRAPH
	{0xB541,	0x6E19},	// CJK UNIFIED IDEOGRAPH
	{0xB542,	0x6E4E},	// CJK UNIFIED IDEOGRAPH
	{0xB543,	0x6E63},	// CJK UNIFIED IDEOGRAPH
	{0xB544,	0x6E44},	// CJK UNIFIED IDEOGRAPH
	{0xB545,	0x6E72},	// CJK UNIFIED IDEOGRAPH
	{0xB546,	0x6E69},	// CJK UNIFIED IDEOGRAPH
	{0xB547,	0x6E5F},	// CJK UNIFIED IDEOGRAPH
	{0xB548,	0x7119},	// CJK UNIFIED IDEOGRAPH
	{0xB549,	0x711A},	// CJK UNIFIED IDEOGRAPH
	{0xB54A,	0x7126},	// CJK UNIFIED IDEOGRAPH
	{0xB54B,	0x7130},	// CJK UNIFIED IDEOGRAPH
	{0xB54C,	0x7121},	// CJK UNIFIED IDEOGRAPH
	{0xB54D,	0x7136},	// CJK UNIFIED IDEOGRAPH
	{0xB54E,	0x716E},	// CJK UNIFIED IDEOGRAPH
	{0xB54F,	0x711C},	// CJK UNIFIED IDEOGRAPH
	{0xB550,	0x724C},	// CJK UNIFIED IDEOGRAPH
	{0xB551,	0x7284},	// CJK UNIFIED IDEOGRAPH
	{0xB552,	0x7280},	// CJK UNIFIED IDEOGRAPH
	{0xB553,	0x7336},	// CJK UNIFIED IDEOGRAPH
	{0xB554,	0x7325},	// CJK UNIFIED IDEOGRAPH
	{0xB555,	0x7334},	// CJK UNIFIED IDEOGRAPH
	{0xB556,	0x7329},	// CJK UNIFIED IDEOGRAPH
	{0xB557,	0x743A},	// CJK UNIFIED IDEOGRAPH
	{0xB558,	0x742A},	// CJK UNIFIED IDEOGRAPH
	{0xB559,	0x7433},	// CJK UNIFIED IDEOGRAPH
	{0xB55A,	0x7422},	// CJK UNIFIED IDEOGRAPH
	{0xB55B,	0x7425},	// CJK UNIFIED IDEOGRAPH
	{0xB55C,	0x7435},	// CJK UNIFIED IDEOGRAPH
	{0xB55D,	0x7436},	// CJK UNIFIED IDEOGRAPH
	{0xB55E,	0x7434},	// CJK UNIFIED IDEOGRAPH
	{0xB55F,	0x742F},	// CJK UNIFIED IDEOGRAPH
	{0xB560,	0x741B},	// CJK UNIFIED IDEOGRAPH
	{0xB561,	0x7426},	// CJK UNIFIED IDEOGRAPH
	{0xB562,	0x7428},	// CJK UNIFIED IDEOGRAPH
	{0xB563,	0x7525},	// CJK UNIFIED IDEOGRAPH
	{0xB564,	0x7526},	// CJK UNIFIED IDEOGRAPH
	{0xB565,	0x756B},	// CJK UNIFIED IDEOGRAPH
	{0xB566,	0x756A},	// CJK UNIFIED IDEOGRAPH
	{0xB567,	0x75E2},	// CJK UNIFIED IDEOGRAPH
	{0xB568,	0x75DB},	// CJK UNIFIED IDEOGRAPH
	{0xB569,	0x75E3},	// CJK UNIFIED IDEOGRAPH
	{0xB56A,	0x75D9},	// CJK UNIFIED IDEOGRAPH
	{0xB56B,	0x75D8},	// CJK UNIFIED IDEOGRAPH
	{0xB56C,	0x75DE},	// CJK UNIFIED IDEOGRAPH
	{0xB56D,	0x75E0},	// CJK UNIFIED IDEOGRAPH
	{0xB56E,	0x767B},	// CJK UNIFIED IDEOGRAPH
	{0xB56F,	0x767C},	// CJK UNIFIED IDEOGRAPH
	{0xB570,	0x7696},	// CJK UNIFIED IDEOGRAPH
	{0xB571,	0x7693},	// CJK UNIFIED IDEOGRAPH
	{0xB572,	0x76B4},	// CJK UNIFIED IDEOGRAPH
	{0xB573,	0x76DC},	// CJK UNIFIED IDEOGRAPH
	{0xB574,	0x774F},	// CJK UNIFIED IDEOGRAPH
	{0xB575,	0x77ED},	// CJK UNIFIED IDEOGRAPH
	{0xB576,	0x785D},	// CJK UNIFIED IDEOGRAPH
	{0xB577,	0x786C},	// CJK UNIFIED IDEOGRAPH
	{0xB578,	0x786F},	// CJK UNIFIED IDEOGRAPH
	{0xB579,	0x7A0D},	// CJK UNIFIED IDEOGRAPH
	{0xB57A,	0x7A08},	// CJK UNIFIED IDEOGRAPH
	{0xB57B,	0x7A0B},	// CJK UNIFIED IDEOGRAPH
	{0xB57C,	0x7A05},	// CJK UNIFIED IDEOGRAPH
	{0xB57D,	0x7A00},	// CJK UNIFIED IDEOGRAPH
	{0xB57E,	0x7A98},	// CJK UNIFIED IDEOGRAPH
	{0xB5A1,	0x7A97},	// CJK UNIFIED IDEOGRAPH
	{0xB5A2,	0x7A96},	// CJK UNIFIED IDEOGRAPH
	{0xB5A3,	0x7AE5},	// CJK UNIFIED IDEOGRAPH
	{0xB5A4,	0x7AE3},	// CJK UNIFIED IDEOGRAPH
	{0xB5A5,	0x7B49},	// CJK UNIFIED IDEOGRAPH
	{0xB5A6,	0x7B56},	// CJK UNIFIED IDEOGRAPH
	{0xB5A7,	0x7B46},	// CJK UNIFIED IDEOGRAPH
	{0xB5A8,	0x7B50},	// CJK UNIFIED IDEOGRAPH
	{0xB5A9,	0x7B52},	// CJK UNIFIED IDEOGRAPH
	{0xB5AA,	0x7B54},	// CJK UNIFIED IDEOGRAPH
	{0xB5AB,	0x7B4D},	// CJK UNIFIED IDEOGRAPH
	{0xB5AC,	0x7B4B},	// CJK UNIFIED IDEOGRAPH
	{0xB5AD,	0x7B4F},	// CJK UNIFIED IDEOGRAPH
	{0xB5AE,	0x7B51},	// CJK UNIFIED IDEOGRAPH
	{0xB5AF,	0x7C9F},	// CJK UNIFIED IDEOGRAPH
	{0xB5B0,	0x7CA5},	// CJK UNIFIED IDEOGRAPH
	{0xB5B1,	0x7D5E},	// CJK UNIFIED IDEOGRAPH
	{0xB5B2,	0x7D50},	// CJK UNIFIED IDEOGRAPH
	{0xB5B3,	0x7D68},	// CJK UNIFIED IDEOGRAPH
	{0xB5B4,	0x7D55},	// CJK UNIFIED IDEOGRAPH
	{0xB5B5,	0x7D2B},	// CJK UNIFIED IDEOGRAPH
	{0xB5B6,	0x7D6E},	// CJK UNIFIED IDEOGRAPH
	{0xB5B7,	0x7D72},	// CJK UNIFIED IDEOGRAPH
	{0xB5B8,	0x7D61},	// CJK UNIFIED IDEOGRAPH
	{0xB5B9,	0x7D66},	// CJK UNIFIED IDEOGRAPH
	{0xB5BA,	0x7D62},	// CJK UNIFIED IDEOGRAPH
	{0xB5BB,	0x7D70},	// CJK UNIFIED IDEOGRAPH
	{0xB5BC,	0x7D73},	// CJK UNIFIED IDEOGRAPH
	{0xB5BD,	0x5584},	// CJK UNIFIED IDEOGRAPH
	{0xB5BE,	0x7FD4},	// CJK UNIFIED IDEOGRAPH
	{0xB5BF,	0x7FD5},	// CJK UNIFIED IDEOGRAPH
	{0xB5C0,	0x800B},	// CJK UNIFIED IDEOGRAPH
	{0xB5C1,	0x8052},	// CJK UNIFIED IDEOGRAPH
	{0xB5C2,	0x8085},	// CJK UNIFIED IDEOGRAPH
	{0xB5C3,	0x8155},	// CJK UNIFIED IDEOGRAPH
	{0xB5C4,	0x8154},	// CJK UNIFIED IDEOGRAPH
	{0xB5C5,	0x814B},	// CJK UNIFIED IDEOGRAPH
	{0xB5C6,	0x8151},	// CJK UNIFIED IDEOGRAPH
	{0xB5C7,	0x814E},	// CJK UNIFIED IDEOGRAPH
	{0xB5C8,	0x8139},	// CJK UNIFIED IDEOGRAPH
	{0xB5C9,	0x8146},	// CJK UNIFIED IDEOGRAPH
	{0xB5CA,	0x813E},	// CJK UNIFIED IDEOGRAPH
	{0xB5CB,	0x814C},	// CJK UNIFIED IDEOGRAPH
	{0xB5CC,	0x8153},	// CJK UNIFIED IDEOGRAPH
	{0xB5CD,	0x8174},	// CJK UNIFIED IDEOGRAPH
	{0xB5CE,	0x8212},	// CJK UNIFIED IDEOGRAPH
	{0xB5CF,	0x821C},	// CJK UNIFIED IDEOGRAPH
	{0xB5D0,	0x83E9},	// CJK UNIFIED IDEOGRAPH
	{0xB5D1,	0x8403},	// CJK UNIFIED IDEOGRAPH
	{0xB5D2,	0x83F8},	// CJK UNIFIED IDEOGRAPH
	{0xB5D3,	0x840D},	// CJK UNIFIED IDEOGRAPH
	{0xB5D4,	0x83E0},	// CJK UNIFIED IDEOGRAPH
	{0xB5D5,	0x83C5},	// CJK UNIFIED IDEOGRAPH
	{0xB5D6,	0x840B},	// CJK UNIFIED IDEOGRAPH
	{0xB5D7,	0x83C1},	// CJK UNIFIED IDEOGRAPH
	{0xB5D8,	0x83EF},	// CJK UNIFIED IDEOGRAPH
	{0xB5D9,	0x83F1},	// CJK UNIFIED IDEOGRAPH
	{0xB5DA,	0x83F4},	// CJK UNIFIED IDEOGRAPH
	{0xB5DB,	0x8457},	// CJK UNIFIED IDEOGRAPH
	{0xB5DC,	0x840A},	// CJK UNIFIED IDEOGRAPH
	{0xB5DD,	0x83F0},	// CJK UNIFIED IDEOGRAPH
	{0xB5DE,	0x840C},	// CJK UNIFIED IDEOGRAPH
	{0xB5DF,	0x83CC},	// CJK UNIFIED IDEOGRAPH
	{0xB5E0,	0x83FD},	// CJK UNIFIED IDEOGRAPH
	{0xB5E1,	0x83F2},	// CJK UNIFIED IDEOGRAPH
	{0xB5E2,	0x83CA},	// CJK UNIFIED IDEOGRAPH
	{0xB5E3,	0x8438},	// CJK UNIFIED IDEOGRAPH
	{0xB5E4,	0x840E},	// CJK UNIFIED IDEOGRAPH
	{0xB5E5,	0x8404},	// CJK UNIFIED IDEOGRAPH
	{0xB5E6,	0x83DC},	// CJK UNIFIED IDEOGRAPH
	{0xB5E7,	0x8407},	// CJK UNIFIED IDEOGRAPH
	{0xB5E8,	0x83D4},	// CJK UNIFIED IDEOGRAPH
	{0xB5E9,	0x83DF},	// CJK UNIFIED IDEOGRAPH
	{0xB5EA,	0x865B},	// CJK UNIFIED IDEOGRAPH
	{0xB5EB,	0x86DF},	// CJK UNIFIED IDEOGRAPH
	{0xB5EC,	0x86D9},	// CJK UNIFIED IDEOGRAPH
	{0xB5ED,	0x86ED},	// CJK UNIFIED IDEOGRAPH
	{0xB5EE,	0x86D4},	// CJK UNIFIED IDEOGRAPH
	{0xB5EF,	0x86DB},	// CJK UNIFIED IDEOGRAPH
	{0xB5F0,	0x86E4},	// CJK UNIFIED IDEOGRAPH
	{0xB5F1,	0x86D0},	// CJK UNIFIED IDEOGRAPH
	{0xB5F2,	0x86DE},	// CJK UNIFIED IDEOGRAPH
	{0xB5F3,	0x8857},	// CJK UNIFIED IDEOGRAPH
	{0xB5F4,	0x88C1},	// CJK UNIFIED IDEOGRAPH
	{0xB5F5,	0x88C2},	// CJK UNIFIED IDEOGRAPH
	{0xB5F6,	0x88B1},	// CJK UNIFIED IDEOGRAPH
	{0xB5F7,	0x8983},	// CJK UNIFIED IDEOGRAPH
	{0xB5F8,	0x8996},	// CJK UNIFIED IDEOGRAPH
	{0xB5F9,	0x8A3B},	// CJK UNIFIED IDEOGRAPH
	{0xB5FA,	0x8A60},	// CJK UNIFIED IDEOGRAPH
	{0xB5FB,	0x8A55},	// CJK UNIFIED IDEOGRAPH
	{0xB5FC,	0x8A5E},	// CJK UNIFIED IDEOGRAPH
	{0xB5FD,	0x8A3C},	// CJK UNIFIED IDEOGRAPH
	{0xB5FE,	0x8A41},	// CJK UNIFIED IDEOGRAPH
	{0xB640,	0x8A54},	// CJK UNIFIED IDEOGRAPH
	{0xB641,	0x8A5B},	// CJK UNIFIED IDEOGRAPH
	{0xB642,	0x8A50},	// CJK UNIFIED IDEOGRAPH
	{0xB643,	0x8A46},	// CJK UNIFIED IDEOGRAPH
	{0xB644,	0x8A34},	// CJK UNIFIED IDEOGRAPH
	{0xB645,	0x8A3A},	// CJK UNIFIED IDEOGRAPH
	{0xB646,	0x8A36},	// CJK UNIFIED IDEOGRAPH
	{0xB647,	0x8A56},	// CJK UNIFIED IDEOGRAPH
	{0xB648,	0x8C61},	// CJK UNIFIED IDEOGRAPH
	{0xB649,	0x8C82},	// CJK UNIFIED IDEOGRAPH
	{0xB64A,	0x8CAF},	// CJK UNIFIED IDEOGRAPH
	{0xB64B,	0x8CBC},	// CJK UNIFIED IDEOGRAPH
	{0xB64C,	0x8CB3},	// CJK UNIFIED IDEOGRAPH
	{0xB64D,	0x8CBD},	// CJK UNIFIED IDEOGRAPH
	{0xB64E,	0x8CC1},	// CJK UNIFIED IDEOGRAPH
	{0xB64F,	0x8CBB},	// CJK UNIFIED IDEOGRAPH
	{0xB650,	0x8CC0},	// CJK UNIFIED IDEOGRAPH
	{0xB651,	0x8CB4},	// CJK UNIFIED IDEOGRAPH
	{0xB652,	0x8CB7},	// CJK UNIFIED IDEOGRAPH
	{0xB653,	0x8CB6},	// CJK UNIFIED IDEOGRAPH
	{0xB654,	0x8CBF},	// CJK UNIFIED IDEOGRAPH
	{0xB655,	0x8CB8},	// CJK UNIFIED IDEOGRAPH
	{0xB656,	0x8D8A},	// CJK UNIFIED IDEOGRAPH
	{0xB657,	0x8D85},	// CJK UNIFIED IDEOGRAPH
	{0xB658,	0x8D81},	// CJK UNIFIED IDEOGRAPH
	{0xB659,	0x8DCE},	// CJK UNIFIED IDEOGRAPH
	{0xB65A,	0x8DDD},	// CJK UNIFIED IDEOGRAPH
	{0xB65B,	0x8DCB},	// CJK UNIFIED IDEOGRAPH
	{0xB65C,	0x8DDA},	// CJK UNIFIED IDEOGRAPH
	{0xB65D,	0x8DD1},	// CJK UNIFIED IDEOGRAPH
	{0xB65E,	0x8DCC},	// CJK UNIFIED IDEOGRAPH
	{0xB65F,	0x8DDB},	// CJK UNIFIED IDEOGRAPH
	{0xB660,	0x8DC6},	// CJK UNIFIED IDEOGRAPH
	{0xB661,	0x8EFB},	// CJK UNIFIED IDEOGRAPH
	{0xB662,	0x8EF8},	// CJK UNIFIED IDEOGRAPH
	{0xB663,	0x8EFC},	// CJK UNIFIED IDEOGRAPH
	{0xB664,	0x8F9C},	// CJK UNIFIED IDEOGRAPH
	{0xB665,	0x902E},	// CJK UNIFIED IDEOGRAPH
	{0xB666,	0x9035},	// CJK UNIFIED IDEOGRAPH
	{0xB667,	0x9031},	// CJK UNIFIED IDEOGRAPH
	{0xB668,	0x9038},	// CJK UNIFIED IDEOGRAPH
	{0xB669,	0x9032},	// CJK UNIFIED IDEOGRAPH
	{0xB66A,	0x9036},	// CJK UNIFIED IDEOGRAPH
	{0xB66B,	0x9102},	// CJK UNIFIED IDEOGRAPH
	{0xB66C,	0x90F5},	// CJK UNIFIED IDEOGRAPH
	{0xB66D,	0x9109},	// CJK UNIFIED IDEOGRAPH
	{0xB66E,	0x90FE},	// CJK UNIFIED IDEOGRAPH
	{0xB66F,	0x9163},	// CJK UNIFIED IDEOGRAPH
	{0xB670,	0x9165},	// CJK UNIFIED IDEOGRAPH
	{0xB671,	0x91CF},	// CJK UNIFIED IDEOGRAPH
	{0xB672,	0x9214},	// CJK UNIFIED IDEOGRAPH
	{0xB673,	0x9215},	// CJK UNIFIED IDEOGRAPH
	{0xB674,	0x9223},	// CJK UNIFIED IDEOGRAPH
	{0xB675,	0x9209},	// CJK UNIFIED IDEOGRAPH
	{0xB676,	0x921E},	// CJK UNIFIED IDEOGRAPH
	{0xB677,	0x920D},	// CJK UNIFIED IDEOGRAPH
	{0xB678,	0x9210},	// CJK UNIFIED IDEOGRAPH
	{0xB679,	0x9207},	// CJK UNIFIED IDEOGRAPH
	{0xB67A,	0x9211},	// CJK UNIFIED IDEOGRAPH
	{0xB67B,	0x9594},	// CJK UNIFIED IDEOGRAPH
	{0xB67C,	0x958F},	// CJK UNIFIED IDEOGRAPH
	{0xB67D,	0x958B},	// CJK UNIFIED IDEOGRAPH
	{0xB67E,	0x9591},	// CJK UNIFIED IDEOGRAPH
	{0xB6A1,	0x9593},	// CJK UNIFIED IDEOGRAPH
	{0xB6A2,	0x9592},	// CJK UNIFIED IDEOGRAPH
	{0xB6A3,	0x958E},	// CJK UNIFIED IDEOGRAPH
	{0xB6A4,	0x968A},	// CJK UNIFIED IDEOGRAPH
	{0xB6A5,	0x968E},	// CJK UNIFIED IDEOGRAPH
	{0xB6A6,	0x968B},	// CJK UNIFIED IDEOGRAPH
	{0xB6A7,	0x967D},	// CJK UNIFIED IDEOGRAPH
	{0xB6A8,	0x9685},	// CJK UNIFIED IDEOGRAPH
	{0xB6A9,	0x9686},	// CJK UNIFIED IDEOGRAPH
	{0xB6AA,	0x968D},	// CJK UNIFIED IDEOGRAPH
	{0xB6AB,	0x9672},	// CJK UNIFIED IDEOGRAPH
	{0xB6AC,	0x9684},	// CJK UNIFIED IDEOGRAPH
	{0xB6AD,	0x96C1},	// CJK UNIFIED IDEOGRAPH
	{0xB6AE,	0x96C5},	// CJK UNIFIED IDEOGRAPH
	{0xB6AF,	0x96C4},	// CJK UNIFIED IDEOGRAPH
	{0xB6B0,	0x96C6},	// CJK UNIFIED IDEOGRAPH
	{0xB6B1,	0x96C7},	// CJK UNIFIED IDEOGRAPH
	{0xB6B2,	0x96EF},	// CJK UNIFIED IDEOGRAPH
	{0xB6B3,	0x96F2},	// CJK UNIFIED IDEOGRAPH
	{0xB6B4,	0x97CC},	// CJK UNIFIED IDEOGRAPH
	{0xB6B5,	0x9805},	// CJK UNIFIED IDEOGRAPH
	{0xB6B6,	0x9806},	// CJK UNIFIED IDEOGRAPH
	{0xB6B7,	0x9808},	// CJK UNIFIED IDEOGRAPH
	{0xB6B8,	0x98E7},	// CJK UNIFIED IDEOGRAPH
	{0xB6B9,	0x98EA},	// CJK UNIFIED IDEOGRAPH
	{0xB6BA,	0x98EF},	// CJK UNIFIED IDEOGRAPH
	{0xB6BB,	0x98E9},	// CJK UNIFIED IDEOGRAPH
	{0xB6BC,	0x98F2},	// CJK UNIFIED IDEOGRAPH
	{0xB6BD,	0x98ED},	// CJK UNIFIED IDEOGRAPH
	{0xB6BE,	0x99AE},	// CJK UNIFIED IDEOGRAPH
	{0xB6BF,	0x99AD},	// CJK UNIFIED IDEOGRAPH
	{0xB6C0,	0x9EC3},	// CJK UNIFIED IDEOGRAPH
	{0xB6C1,	0x9ECD},	// CJK UNIFIED IDEOGRAPH
	{0xB6C2,	0x9ED1},	// CJK UNIFIED IDEOGRAPH
	{0xB6C3,	0x4E82},	// CJK UNIFIED IDEOGRAPH
	{0xB6C4,	0x50AD},	// CJK UNIFIED IDEOGRAPH
	{0xB6C5,	0x50B5},	// CJK UNIFIED IDEOGRAPH
	{0xB6C6,	0x50B2},	// CJK UNIFIED IDEOGRAPH
	{0xB6C7,	0x50B3},	// CJK UNIFIED IDEOGRAPH
	{0xB6C8,	0x50C5},	// CJK UNIFIED IDEOGRAPH
	{0xB6C9,	0x50BE},	// CJK UNIFIED IDEOGRAPH
	{0xB6CA,	0x50AC},	// CJK UNIFIED IDEOGRAPH
	{0xB6CB,	0x50B7},	// CJK UNIFIED IDEOGRAPH
	{0xB6CC,	0x50BB},	// CJK UNIFIED IDEOGRAPH
	{0xB6CD,	0x50AF},	// CJK UNIFIED IDEOGRAPH
	{0xB6CE,	0x50C7},	// CJK UNIFIED IDEOGRAPH
	{0xB6CF,	0x527F},	// CJK UNIFIED IDEOGRAPH
	{0xB6D0,	0x5277},	// CJK UNIFIED IDEOGRAPH
	{0xB6D1,	0x527D},	// CJK UNIFIED IDEOGRAPH
	{0xB6D2,	0x52DF},	// CJK UNIFIED IDEOGRAPH
	{0xB6D3,	0x52E6},	// CJK UNIFIED IDEOGRAPH
	{0xB6D4,	0x52E4},	// CJK UNIFIED IDEOGRAPH
	{0xB6D5,	0x52E2},	// CJK UNIFIED IDEOGRAPH
	{0xB6D6,	0x52E3},	// CJK UNIFIED IDEOGRAPH
	{0xB6D7,	0x532F},	// CJK UNIFIED IDEOGRAPH
	{0xB6D8,	0x55DF},	// CJK UNIFIED IDEOGRAPH
	{0xB6D9,	0x55E8},	// CJK UNIFIED IDEOGRAPH
	{0xB6DA,	0x55D3},	// CJK UNIFIED IDEOGRAPH
	{0xB6DB,	0x55E6},	// CJK UNIFIED IDEOGRAPH
	{0xB6DC,	0x55CE},	// CJK UNIFIED IDEOGRAPH
	{0xB6DD,	0x55DC},	// CJK UNIFIED IDEOGRAPH
	{0xB6DE,	0x55C7},	// CJK UNIFIED IDEOGRAPH
	{0xB6DF,	0x55D1},	// CJK UNIFIED IDEOGRAPH
	{0xB6E0,	0x55E3},	// CJK UNIFIED IDEOGRAPH
	{0xB6E1,	0x55E4},	// CJK UNIFIED IDEOGRAPH
	{0xB6E2,	0x55EF},	// CJK UNIFIED IDEOGRAPH
	{0xB6E3,	0x55DA},	// CJK UNIFIED IDEOGRAPH
	{0xB6E4,	0x55E1},	// CJK UNIFIED IDEOGRAPH
	{0xB6E5,	0x55C5},	// CJK UNIFIED IDEOGRAPH
	{0xB6E6,	0x55C6},	// CJK UNIFIED IDEOGRAPH
	{0xB6E7,	0x55E5},	// CJK UNIFIED IDEOGRAPH
	{0xB6E8,	0x55C9},	// CJK UNIFIED IDEOGRAPH
	{0xB6E9,	0x5712},	// CJK UNIFIED IDEOGRAPH
	{0xB6EA,	0x5713},	// CJK UNIFIED IDEOGRAPH
	{0xB6EB,	0x585E},	// CJK UNIFIED IDEOGRAPH
	{0xB6EC,	0x5851},	// CJK UNIFIED IDEOGRAPH
	{0xB6ED,	0x5858},	// CJK UNIFIED IDEOGRAPH
	{0xB6EE,	0x5857},	// CJK UNIFIED IDEOGRAPH
	{0xB6EF,	0x585A},	// CJK UNIFIED IDEOGRAPH
	{0xB6F0,	0x5854},	// CJK UNIFIED IDEOGRAPH
	{0xB6F1,	0x586B},	// CJK UNIFIED IDEOGRAPH
	{0xB6F2,	0x584C},	// CJK UNIFIED IDEOGRAPH
	{0xB6F3,	0x586D},	// CJK UNIFIED IDEOGRAPH
	{0xB6F4,	0x584A},	// CJK UNIFIED IDEOGRAPH
	{0xB6F5,	0x5862},	// CJK UNIFIED IDEOGRAPH
	{0xB6F6,	0x5852},	// CJK UNIFIED IDEOGRAPH
	{0xB6F7,	0x584B},	// CJK UNIFIED IDEOGRAPH
	{0xB6F8,	0x5967},	// CJK UNIFIED IDEOGRAPH
	{0xB6F9,	0x5AC1},	// CJK UNIFIED IDEOGRAPH
	{0xB6FA,	0x5AC9},	// CJK UNIFIED IDEOGRAPH
	{0xB6FB,	0x5ACC},	// CJK UNIFIED IDEOGRAPH
	{0xB6FC,	0x5ABE},	// CJK UNIFIED IDEOGRAPH
	{0xB6FD,	0x5ABD},	// CJK UNIFIED IDEOGRAPH
	{0xB6FE,	0x5ABC},	// CJK UNIFIED IDEOGRAPH
	{0xB740,	0x5AB3},	// CJK UNIFIED IDEOGRAPH
	{0xB741,	0x5AC2},	// CJK UNIFIED IDEOGRAPH
	{0xB742,	0x5AB2},	// CJK UNIFIED IDEOGRAPH
	{0xB743,	0x5D69},	// CJK UNIFIED IDEOGRAPH
	{0xB744,	0x5D6F},	// CJK UNIFIED IDEOGRAPH
	{0xB745,	0x5E4C},	// CJK UNIFIED IDEOGRAPH
	{0xB746,	0x5E79},	// CJK UNIFIED IDEOGRAPH
	{0xB747,	0x5EC9},	// CJK UNIFIED IDEOGRAPH
	{0xB748,	0x5EC8},	// CJK UNIFIED IDEOGRAPH
	{0xB749,	0x5F12},	// CJK UNIFIED IDEOGRAPH
	{0xB74A,	0x5F59},	// CJK UNIFIED IDEOGRAPH
	{0xB74B,	0x5FAC},	// CJK UNIFIED IDEOGRAPH
	{0xB74C,	0x5FAE},	// CJK UNIFIED IDEOGRAPH
	{0xB74D,	0x611A},	// CJK UNIFIED IDEOGRAPH
	{0xB74E,	0x610F},	// CJK UNIFIED IDEOGRAPH
	{0xB74F,	0x6148},	// CJK UNIFIED IDEOGRAPH
	{0xB750,	0x611F},	// CJK UNIFIED IDEOGRAPH
	{0xB751,	0x60F3},	// CJK UNIFIED IDEOGRAPH
	{0xB752,	0x611B},	// CJK UNIFIED IDEOGRAPH
	{0xB753,	0x60F9},	// CJK UNIFIED IDEOGRAPH
	{0xB754,	0x6101},	// CJK UNIFIED IDEOGRAPH
	{0xB755,	0x6108},	// CJK UNIFIED IDEOGRAPH
	{0xB756,	0x614E},	// CJK UNIFIED IDEOGRAPH
	{0xB757,	0x614C},	// CJK UNIFIED IDEOGRAPH
	{0xB758,	0x6144},	// CJK UNIFIED IDEOGRAPH
	{0xB759,	0x614D},	// CJK UNIFIED IDEOGRAPH
	{0xB75A,	0x613E},	// CJK UNIFIED IDEOGRAPH
	{0xB75B,	0x6134},	// CJK UNIFIED IDEOGRAPH
	{0xB75C,	0x6127},	// CJK UNIFIED IDEOGRAPH
	{0xB75D,	0x610D},	// CJK UNIFIED IDEOGRAPH
	{0xB75E,	0x6106},	// CJK UNIFIED IDEOGRAPH
	{0xB75F,	0x6137},	// CJK UNIFIED IDEOGRAPH
	{0xB760,	0x6221},	// CJK UNIFIED IDEOGRAPH
	{0xB761,	0x6222},	// CJK UNIFIED IDEOGRAPH
	{0xB762,	0x6413},	// CJK UNIFIED IDEOGRAPH
	{0xB763,	0x643E},	// CJK UNIFIED IDEOGRAPH
	{0xB764,	0x641E},	// CJK UNIFIED IDEOGRAPH
	{0xB765,	0x642A},	// CJK UNIFIED IDEOGRAPH
	{0xB766,	0x642D},	// CJK UNIFIED IDEOGRAPH
	{0xB767,	0x643D},	// CJK UNIFIED IDEOGRAPH
	{0xB768,	0x642C},	// CJK UNIFIED IDEOGRAPH
	{0xB769,	0x640F},	// CJK UNIFIED IDEOGRAPH
	{0xB76A,	0x641C},	// CJK UNIFIED IDEOGRAPH
	{0xB76B,	0x6414},	// CJK UNIFIED IDEOGRAPH
	{0xB76C,	0x640D},	// CJK UNIFIED IDEOGRAPH
	{0xB76D,	0x6436},	// CJK UNIFIED IDEOGRAPH
	{0xB76E,	0x6416},	// CJK UNIFIED IDEOGRAPH
	{0xB76F,	0x6417},	// CJK UNIFIED IDEOGRAPH
	{0xB770,	0x6406},	// CJK UNIFIED IDEOGRAPH
	{0xB771,	0x656C},	// CJK UNIFIED IDEOGRAPH
	{0xB772,	0x659F},	// CJK UNIFIED IDEOGRAPH
	{0xB773,	0x65B0},	// CJK UNIFIED IDEOGRAPH
	{0xB774,	0x6697},	// CJK UNIFIED IDEOGRAPH
	{0xB775,	0x6689},	// CJK UNIFIED IDEOGRAPH
	{0xB776,	0x6687},	// CJK UNIFIED IDEOGRAPH
	{0xB777,	0x6688},	// CJK UNIFIED IDEOGRAPH
	{0xB778,	0x6696},	// CJK UNIFIED IDEOGRAPH
	{0xB779,	0x6684},	// CJK UNIFIED IDEOGRAPH
	{0xB77A,	0x6698},	// CJK UNIFIED IDEOGRAPH
	{0xB77B,	0x668D},	// CJK UNIFIED IDEOGRAPH
	{0xB77C,	0x6703},	// CJK UNIFIED IDEOGRAPH
	{0xB77D,	0x6994},	// CJK UNIFIED IDEOGRAPH
	{0xB77E,	0x696D},	// CJK UNIFIED IDEOGRAPH
	{0xB7A1,	0x695A},	// CJK UNIFIED IDEOGRAPH
	{0xB7A2,	0x6977},	// CJK UNIFIED IDEOGRAPH
	{0xB7A3,	0x6960},	// CJK UNIFIED IDEOGRAPH
	{0xB7A4,	0x6954},	// CJK UNIFIED IDEOGRAPH
	{0xB7A5,	0x6975},	// CJK UNIFIED IDEOGRAPH
	{0xB7A6,	0x6930},	// CJK UNIFIED IDEOGRAPH
	{0xB7A7,	0x6982},	// CJK UNIFIED IDEOGRAPH
	{0xB7A8,	0x694A},	// CJK UNIFIED IDEOGRAPH
	{0xB7A9,	0x6968},	// CJK UNIFIED IDEOGRAPH
	{0xB7AA,	0x696B},	// CJK UNIFIED IDEOGRAPH
	{0xB7AB,	0x695E},	// CJK UNIFIED IDEOGRAPH
	{0xB7AC,	0x6953},	// CJK UNIFIED IDEOGRAPH
	{0xB7AD,	0x6979},	// CJK UNIFIED IDEOGRAPH
	{0xB7AE,	0x6986},	// CJK UNIFIED IDEOGRAPH
	{0xB7AF,	0x695D},	// CJK UNIFIED IDEOGRAPH
	{0xB7B0,	0x6963},	// CJK UNIFIED IDEOGRAPH
	{0xB7B1,	0x695B},	// CJK UNIFIED IDEOGRAPH
	{0xB7B2,	0x6B47},	// CJK UNIFIED IDEOGRAPH
	{0xB7B3,	0x6B72},	// CJK UNIFIED IDEOGRAPH
	{0xB7B4,	0x6BC0},	// CJK UNIFIED IDEOGRAPH
	{0xB7B5,	0x6BBF},	// CJK UNIFIED IDEOGRAPH
	{0xB7B6,	0x6BD3},	// CJK UNIFIED IDEOGRAPH
	{0xB7B7,	0x6BFD},	// CJK UNIFIED IDEOGRAPH
	{0xB7B8,	0x6EA2},	// CJK UNIFIED IDEOGRAPH
	{0xB7B9,	0x6EAF},	// CJK UNIFIED IDEOGRAPH
	{0xB7BA,	0x6ED3},	// CJK UNIFIED IDEOGRAPH
	{0xB7BB,	0x6EB6},	// CJK UNIFIED IDEOGRAPH
	{0xB7BC,	0x6EC2},	// CJK UNIFIED IDEOGRAPH
	{0xB7BD,	0x6E90},	// CJK UNIFIED IDEOGRAPH
	{0xB7BE,	0x6E9D},	// CJK UNIFIED IDEOGRAPH
	{0xB7BF,	0x6EC7},	// CJK UNIFIED IDEOGRAPH
	{0xB7C0,	0x6EC5},	// CJK UNIFIED IDEOGRAPH
	{0xB7C1,	0x6EA5},	// CJK UNIFIED IDEOGRAPH
	{0xB7C2,	0x6E98},	// CJK UNIFIED IDEOGRAPH
	{0xB7C3,	0x6EBC},	// CJK UNIFIED IDEOGRAPH
	{0xB7C4,	0x6EBA},	// CJK UNIFIED IDEOGRAPH
	{0xB7C5,	0x6EAB},	// CJK UNIFIED IDEOGRAPH
	{0xB7C6,	0x6ED1},	// CJK UNIFIED IDEOGRAPH
	{0xB7C7,	0x6E96},	// CJK UNIFIED IDEOGRAPH
	{0xB7C8,	0x6E9C},	// CJK UNIFIED IDEOGRAPH
	{0xB7C9,	0x6EC4},	// CJK UNIFIED IDEOGRAPH
	{0xB7CA,	0x6ED4},	// CJK UNIFIED IDEOGRAPH
	{0xB7CB,	0x6EAA},	// CJK UNIFIED IDEOGRAPH
	{0xB7CC,	0x6EA7},	// CJK UNIFIED IDEOGRAPH
	{0xB7CD,	0x6EB4},	// CJK UNIFIED IDEOGRAPH
	{0xB7CE,	0x714E},	// CJK UNIFIED IDEOGRAPH
	{0xB7CF,	0x7159},	// CJK UNIFIED IDEOGRAPH
	{0xB7D0,	0x7169},	// CJK UNIFIED IDEOGRAPH
	{0xB7D1,	0x7164},	// CJK UNIFIED IDEOGRAPH
	{0xB7D2,	0x7149},	// CJK UNIFIED IDEOGRAPH
	{0xB7D3,	0x7167},	// CJK UNIFIED IDEOGRAPH
	{0xB7D4,	0x715C},	// CJK UNIFIED IDEOGRAPH
	{0xB7D5,	0x716C},	// CJK UNIFIED IDEOGRAPH
	{0xB7D6,	0x7166},	// CJK UNIFIED IDEOGRAPH
	{0xB7D7,	0x714C},	// CJK UNIFIED IDEOGRAPH
	{0xB7D8,	0x7165},	// CJK UNIFIED IDEOGRAPH
	{0xB7D9,	0x715E},	// CJK UNIFIED IDEOGRAPH
	{0xB7DA,	0x7146},	// CJK UNIFIED IDEOGRAPH
	{0xB7DB,	0x7168},	// CJK UNIFIED IDEOGRAPH
	{0xB7DC,	0x7156},	// CJK UNIFIED IDEOGRAPH
	{0xB7DD,	0x723A},	// CJK UNIFIED IDEOGRAPH
	{0xB7DE,	0x7252},	// CJK UNIFIED IDEOGRAPH
	{0xB7DF,	0x7337},	// CJK UNIFIED IDEOGRAPH
	{0xB7E0,	0x7345},	// CJK UNIFIED IDEOGRAPH
	{0xB7E1,	0x733F},	// CJK UNIFIED IDEOGRAPH
	{0xB7E2,	0x733E},	// CJK UNIFIED IDEOGRAPH
	{0xB7E3,	0x746F},	// CJK UNIFIED IDEOGRAPH
	{0xB7E4,	0x745A},	// CJK UNIFIED IDEOGRAPH
	{0xB7E5,	0x7455},	// CJK UNIFIED IDEOGRAPH
	{0xB7E6,	0x745F},	// CJK UNIFIED IDEOGRAPH
	{0xB7E7,	0x745E},	// CJK UNIFIED IDEOGRAPH
	{0xB7E8,	0x7441},	// CJK UNIFIED IDEOGRAPH
	{0xB7E9,	0x743F},	// CJK UNIFIED IDEOGRAPH
	{0xB7EA,	0x7459},	// CJK UNIFIED IDEOGRAPH
	{0xB7EB,	0x745B},	// CJK UNIFIED IDEOGRAPH
	{0xB7EC,	0x745C},	// CJK UNIFIED IDEOGRAPH
	{0xB7ED,	0x7576},	// CJK UNIFIED IDEOGRAPH
	{0xB7EE,	0x7578},	// CJK UNIFIED IDEOGRAPH
	{0xB7EF,	0x7600},	// CJK UNIFIED IDEOGRAPH
	{0xB7F0,	0x75F0},	// CJK UNIFIED IDEOGRAPH
	{0xB7F1,	0x7601},	// CJK UNIFIED IDEOGRAPH
	{0xB7F2,	0x75F2},	// CJK UNIFIED IDEOGRAPH
	{0xB7F3,	0x75F1},	// CJK UNIFIED IDEOGRAPH
	{0xB7F4,	0x75FA},	// CJK UNIFIED IDEOGRAPH
	{0xB7F5,	0x75FF},	// CJK UNIFIED IDEOGRAPH
	{0xB7F6,	0x75F4},	// CJK UNIFIED IDEOGRAPH
	{0xB7F7,	0x75F3},	// CJK UNIFIED IDEOGRAPH
	{0xB7F8,	0x76DE},	// CJK UNIFIED IDEOGRAPH
	{0xB7F9,	0x76DF},	// CJK UNIFIED IDEOGRAPH
	{0xB7FA,	0x775B},	// CJK UNIFIED IDEOGRAPH
	{0xB7FB,	0x776B},	// CJK UNIFIED IDEOGRAPH
	{0xB7FC,	0x7766},	// CJK UNIFIED IDEOGRAPH
	{0xB7FD,	0x775E},	// CJK UNIFIED IDEOGRAPH
	{0xB7FE,	0x7763},	// CJK UNIFIED IDEOGRAPH
	{0xB840,	0x7779},	// CJK UNIFIED IDEOGRAPH
	{0xB841,	0x776A},	// CJK UNIFIED IDEOGRAPH
	{0xB842,	0x776C},	// CJK UNIFIED IDEOGRAPH
	{0xB843,	0x775C},	// CJK UNIFIED IDEOGRAPH
	{0xB844,	0x7765},	// CJK UNIFIED IDEOGRAPH
	{0xB845,	0x7768},	// CJK UNIFIED IDEOGRAPH
	{0xB846,	0x7762},	// CJK UNIFIED IDEOGRAPH
	{0xB847,	0x77EE},	// CJK UNIFIED IDEOGRAPH
	{0xB848,	0x788E},	// CJK UNIFIED IDEOGRAPH
	{0xB849,	0x78B0},	// CJK UNIFIED IDEOGRAPH
	{0xB84A,	0x7897},	// CJK UNIFIED IDEOGRAPH
	{0xB84B,	0x7898},	// CJK UNIFIED IDEOGRAPH
	{0xB84C,	0x788C},	// CJK UNIFIED IDEOGRAPH
	{0xB84D,	0x7889},	// CJK UNIFIED IDEOGRAPH
	{0xB84E,	0x787C},	// CJK UNIFIED IDEOGRAPH
	{0xB84F,	0x7891},	// CJK UNIFIED IDEOGRAPH
	{0xB850,	0x7893},	// CJK UNIFIED IDEOGRAPH
	{0xB851,	0x787F},	// CJK UNIFIED IDEOGRAPH
	{0xB852,	0x797A},	// CJK UNIFIED IDEOGRAPH
	{0xB853,	0x797F},	// CJK UNIFIED IDEOGRAPH
	{0xB854,	0x7981},	// CJK UNIFIED IDEOGRAPH
	{0xB855,	0x842C},	// CJK UNIFIED IDEOGRAPH
	{0xB856,	0x79BD},	// CJK UNIFIED IDEOGRAPH
	{0xB857,	0x7A1C},	// CJK UNIFIED IDEOGRAPH
	{0xB858,	0x7A1A},	// CJK UNIFIED IDEOGRAPH
	{0xB859,	0x7A20},	// CJK UNIFIED IDEOGRAPH
	{0xB85A,	0x7A14},	// CJK UNIFIED IDEOGRAPH
	{0xB85B,	0x7A1F},	// CJK UNIFIED IDEOGRAPH
	{0xB85C,	0x7A1E},	// CJK UNIFIED IDEOGRAPH
	{0xB85D,	0x7A9F},	// CJK UNIFIED IDEOGRAPH
	{0xB85E,	0x7AA0},	// CJK UNIFIED IDEOGRAPH
	{0xB85F,	0x7B77},	// CJK UNIFIED IDEOGRAPH
	{0xB860,	0x7BC0},	// CJK UNIFIED IDEOGRAPH
	{0xB861,	0x7B60},	// CJK UNIFIED IDEOGRAPH
	{0xB862,	0x7B6E},	// CJK UNIFIED IDEOGRAPH
	{0xB863,	0x7B67},	// CJK UNIFIED IDEOGRAPH
	{0xB864,	0x7CB1},	// CJK UNIFIED IDEOGRAPH
	{0xB865,	0x7CB3},	// CJK UNIFIED IDEOGRAPH
	{0xB866,	0x7CB5},	// CJK UNIFIED IDEOGRAPH
	{0xB867,	0x7D93},	// CJK UNIFIED IDEOGRAPH
	{0xB868,	0x7D79},	// CJK UNIFIED IDEOGRAPH
	{0xB869,	0x7D91},	// CJK UNIFIED IDEOGRAPH
	{0xB86A,	0x7D81},	// CJK UNIFIED IDEOGRAPH
	{0xB86B,	0x7D8F},	// CJK UNIFIED IDEOGRAPH
	{0xB86C,	0x7D5B},	// CJK UNIFIED IDEOGRAPH
	{0xB86D,	0x7F6E},	// CJK UNIFIED IDEOGRAPH
	{0xB86E,	0x7F69},	// CJK UNIFIED IDEOGRAPH
	{0xB86F,	0x7F6A},	// CJK UNIFIED IDEOGRAPH
	{0xB870,	0x7F72},	// CJK UNIFIED IDEOGRAPH
	{0xB871,	0x7FA9},	// CJK UNIFIED IDEOGRAPH
	{0xB872,	0x7FA8},	// CJK UNIFIED IDEOGRAPH
	{0xB873,	0x7FA4},	// CJK UNIFIED IDEOGRAPH
	{0xB874,	0x8056},	// CJK UNIFIED IDEOGRAPH
	{0xB875,	0x8058},	// CJK UNIFIED IDEOGRAPH
	{0xB876,	0x8086},	// CJK UNIFIED IDEOGRAPH
	{0xB877,	0x8084},	// CJK UNIFIED IDEOGRAPH
	{0xB878,	0x8171},	// CJK UNIFIED IDEOGRAPH
	{0xB879,	0x8170},	// CJK UNIFIED IDEOGRAPH
	{0xB87A,	0x8178},	// CJK UNIFIED IDEOGRAPH
	{0xB87B,	0x8165},	// CJK UNIFIED IDEOGRAPH
	{0xB87C,	0x816E},	// CJK UNIFIED IDEOGRAPH
	{0xB87D,	0x8173},	// CJK UNIFIED IDEOGRAPH
	{0xB87E,	0x816B},	// CJK UNIFIED IDEOGRAPH
	{0xB8A1,	0x8179},	// CJK UNIFIED IDEOGRAPH
	{0xB8A2,	0x817A},	// CJK UNIFIED IDEOGRAPH
	{0xB8A3,	0x8166},	// CJK UNIFIED IDEOGRAPH
	{0xB8A4,	0x8205},	// CJK UNIFIED IDEOGRAPH
	{0xB8A5,	0x8247},	// CJK UNIFIED IDEOGRAPH
	{0xB8A6,	0x8482},	// CJK UNIFIED IDEOGRAPH
	{0xB8A7,	0x8477},	// CJK UNIFIED IDEOGRAPH
	{0xB8A8,	0x843D},	// CJK UNIFIED IDEOGRAPH
	{0xB8A9,	0x8431},	// CJK UNIFIED IDEOGRAPH
	{0xB8AA,	0x8475},	// CJK UNIFIED IDEOGRAPH
	{0xB8AB,	0x8466},	// CJK UNIFIED IDEOGRAPH
	{0xB8AC,	0x846B},	// CJK UNIFIED IDEOGRAPH
	{0xB8AD,	0x8449},	// CJK UNIFIED IDEOGRAPH
	{0xB8AE,	0x846C},	// CJK UNIFIED IDEOGRAPH
	{0xB8AF,	0x845B},	// CJK UNIFIED IDEOGRAPH
	{0xB8B0,	0x843C},	// CJK UNIFIED IDEOGRAPH
	{0xB8B1,	0x8435},	// CJK UNIFIED IDEOGRAPH
	{0xB8B2,	0x8461},	// CJK UNIFIED IDEOGRAPH
	{0xB8B3,	0x8463},	// CJK UNIFIED IDEOGRAPH
	{0xB8B4,	0x8469},	// CJK UNIFIED IDEOGRAPH
	{0xB8B5,	0x846D},	// CJK UNIFIED IDEOGRAPH
	{0xB8B6,	0x8446},	// CJK UNIFIED IDEOGRAPH
	{0xB8B7,	0x865E},	// CJK UNIFIED IDEOGRAPH
	{0xB8B8,	0x865C},	// CJK UNIFIED IDEOGRAPH
	{0xB8B9,	0x865F},	// CJK UNIFIED IDEOGRAPH
	{0xB8BA,	0x86F9},	// CJK UNIFIED IDEOGRAPH
	{0xB8BB,	0x8713},	// CJK UNIFIED IDEOGRAPH
	{0xB8BC,	0x8708},	// CJK UNIFIED IDEOGRAPH
	{0xB8BD,	0x8707},	// CJK UNIFIED IDEOGRAPH
	{0xB8BE,	0x8700},	// CJK UNIFIED IDEOGRAPH
	{0xB8BF,	0x86FE},	// CJK UNIFIED IDEOGRAPH
	{0xB8C0,	0x86FB},	// CJK UNIFIED IDEOGRAPH
	{0xB8C1,	0x8702},	// CJK UNIFIED IDEOGRAPH
	{0xB8C2,	0x8703},	// CJK UNIFIED IDEOGRAPH
	{0xB8C3,	0x8706},	// CJK UNIFIED IDEOGRAPH
	{0xB8C4,	0x870A},	// CJK UNIFIED IDEOGRAPH
	{0xB8C5,	0x8859},	// CJK UNIFIED IDEOGRAPH
	{0xB8C6,	0x88DF},	// CJK UNIFIED IDEOGRAPH
	{0xB8C7,	0x88D4},	// CJK UNIFIED IDEOGRAPH
	{0xB8C8,	0x88D9},	// CJK UNIFIED IDEOGRAPH
	{0xB8C9,	0x88DC},	// CJK UNIFIED IDEOGRAPH
	{0xB8CA,	0x88D8},	// CJK UNIFIED IDEOGRAPH
	{0xB8CB,	0x88DD},	// CJK UNIFIED IDEOGRAPH
	{0xB8CC,	0x88E1},	// CJK UNIFIED IDEOGRAPH
	{0xB8CD,	0x88CA},	// CJK UNIFIED IDEOGRAPH
	{0xB8CE,	0x88D5},	// CJK UNIFIED IDEOGRAPH
	{0xB8CF,	0x88D2},	// CJK UNIFIED IDEOGRAPH
	{0xB8D0,	0x899C},	// CJK UNIFIED IDEOGRAPH
	{0xB8D1,	0x89E3},	// CJK UNIFIED IDEOGRAPH
	{0xB8D2,	0x8A6B},	// CJK UNIFIED IDEOGRAPH
	{0xB8D3,	0x8A72},	// CJK UNIFIED IDEOGRAPH
	{0xB8D4,	0x8A73},	// CJK UNIFIED IDEOGRAPH
	{0xB8D5,	0x8A66},	// CJK UNIFIED IDEOGRAPH
	{0xB8D6,	0x8A69},	// CJK UNIFIED IDEOGRAPH
	{0xB8D7,	0x8A70},	// CJK UNIFIED IDEOGRAPH
	{0xB8D8,	0x8A87},	// CJK UNIFIED IDEOGRAPH
	{0xB8D9,	0x8A7C},	// CJK UNIFIED IDEOGRAPH
	{0xB8DA,	0x8A63},	// CJK UNIFIED IDEOGRAPH
	{0xB8DB,	0x8AA0},	// CJK UNIFIED IDEOGRAPH
	{0xB8DC,	0x8A71},	// CJK UNIFIED IDEOGRAPH
	{0xB8DD,	0x8A85},	// CJK UNIFIED IDEOGRAPH
	{0xB8DE,	0x8A6D},	// CJK UNIFIED IDEOGRAPH
	{0xB8DF,	0x8A62},	// CJK UNIFIED IDEOGRAPH
	{0xB8E0,	0x8A6E},	// CJK UNIFIED IDEOGRAPH
	{0xB8E1,	0x8A6C},	// CJK UNIFIED IDEOGRAPH
	{0xB8E2,	0x8A79},	// CJK UNIFIED IDEOGRAPH
	{0xB8E3,	0x8A7B},	// CJK UNIFIED IDEOGRAPH
	{0xB8E4,	0x8A3E},	// CJK UNIFIED IDEOGRAPH
	{0xB8E5,	0x8A68},	// CJK UNIFIED IDEOGRAPH
	{0xB8E6,	0x8C62},	// CJK UNIFIED IDEOGRAPH
	{0xB8E7,	0x8C8A},	// CJK UNIFIED IDEOGRAPH
	{0xB8E8,	0x8C89},	// CJK UNIFIED IDEOGRAPH
	{0xB8E9,	0x8CCA},	// CJK UNIFIED IDEOGRAPH
	{0xB8EA,	0x8CC7},	// CJK UNIFIED IDEOGRAPH
	{0xB8EB,	0x8CC8},	// CJK UNIFIED IDEOGRAPH
	{0xB8EC,	0x8CC4},	// CJK UNIFIED IDEOGRAPH
	{0xB8ED,	0x8CB2},	// CJK UNIFIED IDEOGRAPH
	{0xB8EE,	0x8CC3},	// CJK UNIFIED IDEOGRAPH
	{0xB8EF,	0x8CC2},	// CJK UNIFIED IDEOGRAPH
	{0xB8F0,	0x8CC5},	// CJK UNIFIED IDEOGRAPH
	{0xB8F1,	0x8DE1},	// CJK UNIFIED IDEOGRAPH
	{0xB8F2,	0x8DDF},	// CJK UNIFIED IDEOGRAPH
	{0xB8F3,	0x8DE8},	// CJK UNIFIED IDEOGRAPH
	{0xB8F4,	0x8DEF},	// CJK UNIFIED IDEOGRAPH
	{0xB8F5,	0x8DF3},	// CJK UNIFIED IDEOGRAPH
	{0xB8F6,	0x8DFA},	// CJK UNIFIED IDEOGRAPH
	{0xB8F7,	0x8DEA},	// CJK UNIFIED IDEOGRAPH
	{0xB8F8,	0x8DE4},	// CJK UNIFIED IDEOGRAPH
	{0xB8F9,	0x8DE6},	// CJK UNIFIED IDEOGRAPH
	{0xB8FA,	0x8EB2},	// CJK UNIFIED IDEOGRAPH
	{0xB8FB,	0x8F03},	// CJK UNIFIED IDEOGRAPH
	{0xB8FC,	0x8F09},	// CJK UNIFIED IDEOGRAPH
	{0xB8FD,	0x8EFE},	// CJK UNIFIED IDEOGRAPH
	{0xB8FE,	0x8F0A},	// CJK UNIFIED IDEOGRAPH
	{0xB940,	0x8F9F},	// CJK UNIFIED IDEOGRAPH
	{0xB941,	0x8FB2},	// CJK UNIFIED IDEOGRAPH
	{0xB942,	0x904B},	// CJK UNIFIED IDEOGRAPH
	{0xB943,	0x904A},	// CJK UNIFIED IDEOGRAPH
	{0xB944,	0x9053},	// CJK UNIFIED IDEOGRAPH
	{0xB945,	0x9042},	// CJK UNIFIED IDEOGRAPH
	{0xB946,	0x9054},	// CJK UNIFIED IDEOGRAPH
	{0xB947,	0x903C},	// CJK UNIFIED IDEOGRAPH
	{0xB948,	0x9055},	// CJK UNIFIED IDEOGRAPH
	{0xB949,	0x9050},	// CJK UNIFIED IDEOGRAPH
	{0xB94A,	0x9047},	// CJK UNIFIED IDEOGRAPH
	{0xB94B,	0x904F},	// CJK UNIFIED IDEOGRAPH
	{0xB94C,	0x904E},	// CJK UNIFIED IDEOGRAPH
	{0xB94D,	0x904D},	// CJK UNIFIED IDEOGRAPH
	{0xB94E,	0x9051},	// CJK UNIFIED IDEOGRAPH
	{0xB94F,	0x903E},	// CJK UNIFIED IDEOGRAPH
	{0xB950,	0x9041},	// CJK UNIFIED IDEOGRAPH
	{0xB951,	0x9112},	// CJK UNIFIED IDEOGRAPH
	{0xB952,	0x9117},	// CJK UNIFIED IDEOGRAPH
	{0xB953,	0x916C},	// CJK UNIFIED IDEOGRAPH
	{0xB954,	0x916A},	// CJK UNIFIED IDEOGRAPH
	{0xB955,	0x9169},	// CJK UNIFIED IDEOGRAPH
	{0xB956,	0x91C9},	// CJK UNIFIED IDEOGRAPH
	{0xB957,	0x9237},	// CJK UNIFIED IDEOGRAPH
	{0xB958,	0x9257},	// CJK UNIFIED IDEOGRAPH
	{0xB959,	0x9238},	// CJK UNIFIED IDEOGRAPH
	{0xB95A,	0x923D},	// CJK UNIFIED IDEOGRAPH
	{0xB95B,	0x9240},	// CJK UNIFIED IDEOGRAPH
	{0xB95C,	0x923E},	// CJK UNIFIED IDEOGRAPH
	{0xB95D,	0x925B},	// CJK UNIFIED IDEOGRAPH
	{0xB95E,	0x924B},	// CJK UNIFIED IDEOGRAPH
	{0xB95F,	0x9264},	// CJK UNIFIED IDEOGRAPH
	{0xB960,	0x9251},	// CJK UNIFIED IDEOGRAPH
	{0xB961,	0x9234},	// CJK UNIFIED IDEOGRAPH
	{0xB962,	0x9249},	// CJK UNIFIED IDEOGRAPH
	{0xB963,	0x924D},	// CJK UNIFIED IDEOGRAPH
	{0xB964,	0x9245},	// CJK UNIFIED IDEOGRAPH
	{0xB965,	0x9239},	// CJK UNIFIED IDEOGRAPH
	{0xB966,	0x923F},	// CJK UNIFIED IDEOGRAPH
	{0xB967,	0x925A},	// CJK UNIFIED IDEOGRAPH
	{0xB968,	0x9598},	// CJK UNIFIED IDEOGRAPH
	{0xB969,	0x9698},	// CJK UNIFIED IDEOGRAPH
	{0xB96A,	0x9694},	// CJK UNIFIED IDEOGRAPH
	{0xB96B,	0x9695},	// CJK UNIFIED IDEOGRAPH
	{0xB96C,	0x96CD},	// CJK UNIFIED IDEOGRAPH
	{0xB96D,	0x96CB},	// CJK UNIFIED IDEOGRAPH
	{0xB96E,	0x96C9},	// CJK UNIFIED IDEOGRAPH
	{0xB96F,	0x96CA},	// CJK UNIFIED IDEOGRAPH
	{0xB970,	0x96F7},	// CJK UNIFIED IDEOGRAPH
	{0xB971,	0x96FB},	// CJK UNIFIED IDEOGRAPH
	{0xB972,	0x96F9},	// CJK UNIFIED IDEOGRAPH
	{0xB973,	0x96F6},	// CJK UNIFIED IDEOGRAPH
	{0xB974,	0x9756},	// CJK UNIFIED IDEOGRAPH
	{0xB975,	0x9774},	// CJK UNIFIED IDEOGRAPH
	{0xB976,	0x9776},	// CJK UNIFIED IDEOGRAPH
	{0xB977,	0x9810},	// CJK UNIFIED IDEOGRAPH
	{0xB978,	0x9811},	// CJK UNIFIED IDEOGRAPH
	{0xB979,	0x9813},	// CJK UNIFIED IDEOGRAPH
	{0xB97A,	0x980A},	// CJK UNIFIED IDEOGRAPH
	{0xB97B,	0x9812},	// CJK UNIFIED IDEOGRAPH
	{0xB97C,	0x980C},	// CJK UNIFIED IDEOGRAPH
	{0xB97D,	0x98FC},	// CJK UNIFIED IDEOGRAPH
	{0xB97E,	0x98F4},	// CJK UNIFIED IDEOGRAPH
	{0xB9A1,	0x98FD},	// CJK UNIFIED IDEOGRAPH
	{0xB9A2,	0x98FE},	// CJK UNIFIED IDEOGRAPH
	{0xB9A3,	0x99B3},	// CJK UNIFIED IDEOGRAPH
	{0xB9A4,	0x99B1},	// CJK UNIFIED IDEOGRAPH
	{0xB9A5,	0x99B4},	// CJK UNIFIED IDEOGRAPH
	{0xB9A6,	0x9AE1},	// CJK UNIFIED IDEOGRAPH
	{0xB9A7,	0x9CE9},	// CJK UNIFIED IDEOGRAPH
	{0xB9A8,	0x9E82},	// CJK UNIFIED IDEOGRAPH
	{0xB9A9,	0x9F0E},	// CJK UNIFIED IDEOGRAPH
	{0xB9AA,	0x9F13},	// CJK UNIFIED IDEOGRAPH
	{0xB9AB,	0x9F20},	// CJK UNIFIED IDEOGRAPH
	{0xB9AC,	0x50E7},	// CJK UNIFIED IDEOGRAPH
	{0xB9AD,	0x50EE},	// CJK UNIFIED IDEOGRAPH
	{0xB9AE,	0x50E5},	// CJK UNIFIED IDEOGRAPH
	{0xB9AF,	0x50D6},	// CJK UNIFIED IDEOGRAPH
	{0xB9B0,	0x50ED},	// CJK UNIFIED IDEOGRAPH
	{0xB9B1,	0x50DA},	// CJK UNIFIED IDEOGRAPH
	{0xB9B2,	0x50D5},	// CJK UNIFIED IDEOGRAPH
	{0xB9B3,	0x50CF},	// CJK UNIFIED IDEOGRAPH
	{0xB9B4,	0x50D1},	// CJK UNIFIED IDEOGRAPH
	{0xB9B5,	0x50F1},	// CJK UNIFIED IDEOGRAPH
	{0xB9B6,	0x50CE},	// CJK UNIFIED IDEOGRAPH
	{0xB9B7,	0x50E9},	// CJK UNIFIED IDEOGRAPH
	{0xB9B8,	0x5162},	// CJK UNIFIED IDEOGRAPH
	{0xB9B9,	0x51F3},	// CJK UNIFIED IDEOGRAPH
	{0xB9BA,	0x5283},	// CJK UNIFIED IDEOGRAPH
	{0xB9BB,	0x5282},	// CJK UNIFIED IDEOGRAPH
	{0xB9BC,	0x5331},	// CJK UNIFIED IDEOGRAPH
	{0xB9BD,	0x53AD},	// CJK UNIFIED IDEOGRAPH
	{0xB9BE,	0x55FE},	// CJK UNIFIED IDEOGRAPH
	{0xB9BF,	0x5600},	// CJK UNIFIED IDEOGRAPH
	{0xB9C0,	0x561B},	// CJK UNIFIED IDEOGRAPH
	{0xB9C1,	0x5617},	// CJK UNIFIED IDEOGRAPH
	{0xB9C2,	0x55FD},	// CJK UNIFIED IDEOGRAPH
	{0xB9C3,	0x5614},	// CJK UNIFIED IDEOGRAPH
	{0xB9C4,	0x5606},	// CJK UNIFIED IDEOGRAPH
	{0xB9C5,	0x5609},	// CJK UNIFIED IDEOGRAPH
	{0xB9C6,	0x560D},	// CJK UNIFIED IDEOGRAPH
	{0xB9C7,	0x560E},	// CJK UNIFIED IDEOGRAPH
	{0xB9C8,	0x55F7},	// CJK UNIFIED IDEOGRAPH
	{0xB9C9,	0x5616},	// CJK UNIFIED IDEOGRAPH
	{0xB9CA,	0x561F},	// CJK UNIFIED IDEOGRAPH
	{0xB9CB,	0x5608},	// CJK UNIFIED IDEOGRAPH
	{0xB9CC,	0x5610},	// CJK UNIFIED IDEOGRAPH
	{0xB9CD,	0x55F6},	// CJK UNIFIED IDEOGRAPH
	{0xB9CE,	0x5718},	// CJK UNIFIED IDEOGRAPH
	{0xB9CF,	0x5716},	// CJK UNIFIED IDEOGRAPH
	{0xB9D0,	0x5875},	// CJK UNIFIED IDEOGRAPH
	{0xB9D1,	0x587E},	// CJK UNIFIED IDEOGRAPH
	{0xB9D2,	0x5883},	// CJK UNIFIED IDEOGRAPH
	{0xB9D3,	0x5893},	// CJK UNIFIED IDEOGRAPH
	{0xB9D4,	0x588A},	// CJK UNIFIED IDEOGRAPH
	{0xB9D5,	0x5879},	// CJK UNIFIED IDEOGRAPH
	{0xB9D6,	0x5885},	// CJK UNIFIED IDEOGRAPH
	{0xB9D7,	0x587D},	// CJK UNIFIED IDEOGRAPH
	{0xB9D8,	0x58FD},	// CJK UNIFIED IDEOGRAPH
	{0xB9D9,	0x5925},	// CJK UNIFIED IDEOGRAPH
	{0xB9DA,	0x5922},	// CJK UNIFIED IDEOGRAPH
	{0xB9DB,	0x5924},	// CJK UNIFIED IDEOGRAPH
	{0xB9DC,	0x596A},	// CJK UNIFIED IDEOGRAPH
	{0xB9DD,	0x5969},	// CJK UNIFIED IDEOGRAPH
	{0xB9DE,	0x5AE1},	// CJK UNIFIED IDEOGRAPH
	{0xB9DF,	0x5AE6},	// CJK UNIFIED IDEOGRAPH
	{0xB9E0,	0x5AE9},	// CJK UNIFIED IDEOGRAPH
	{0xB9E1,	0x5AD7},	// CJK UNIFIED IDEOGRAPH
	{0xB9E2,	0x5AD6},	// CJK UNIFIED IDEOGRAPH
	{0xB9E3,	0x5AD8},	// CJK UNIFIED IDEOGRAPH
	{0xB9E4,	0x5AE3},	// CJK UNIFIED IDEOGRAPH
	{0xB9E5,	0x5B75},	// CJK UNIFIED IDEOGRAPH
	{0xB9E6,	0x5BDE},	// CJK UNIFIED IDEOGRAPH
	{0xB9E7,	0x5BE7},	// CJK UNIFIED IDEOGRAPH
	{0xB9E8,	0x5BE1},	// CJK UNIFIED IDEOGRAPH
	{0xB9E9,	0x5BE5},	// CJK UNIFIED IDEOGRAPH
	{0xB9EA,	0x5BE6},	// CJK UNIFIED IDEOGRAPH
	{0xB9EB,	0x5BE8},	// CJK UNIFIED IDEOGRAPH
	{0xB9EC,	0x5BE2},	// CJK UNIFIED IDEOGRAPH
	{0xB9ED,	0x5BE4},	// CJK UNIFIED IDEOGRAPH
	{0xB9EE,	0x5BDF},	// CJK UNIFIED IDEOGRAPH
	{0xB9EF,	0x5C0D},	// CJK UNIFIED IDEOGRAPH
	{0xB9F0,	0x5C62},	// CJK UNIFIED IDEOGRAPH
	{0xB9F1,	0x5D84},	// CJK UNIFIED IDEOGRAPH
	{0xB9F2,	0x5D87},	// CJK UNIFIED IDEOGRAPH
	{0xB9F3,	0x5E5B},	// CJK UNIFIED IDEOGRAPH
	{0xB9F4,	0x5E63},	// CJK UNIFIED IDEOGRAPH
	{0xB9F5,	0x5E55},	// CJK UNIFIED IDEOGRAPH
	{0xB9F6,	0x5E57},	// CJK UNIFIED IDEOGRAPH
	{0xB9F7,	0x5E54},	// CJK UNIFIED IDEOGRAPH
	{0xB9F8,	0x5ED3},	// CJK UNIFIED IDEOGRAPH
	{0xB9F9,	0x5ED6},	// CJK UNIFIED IDEOGRAPH
	{0xB9FA,	0x5F0A},	// CJK UNIFIED IDEOGRAPH
	{0xB9FB,	0x5F46},	// CJK UNIFIED IDEOGRAPH
	{0xB9FC,	0x5F70},	// CJK UNIFIED IDEOGRAPH
	{0xB9FD,	0x5FB9},	// CJK UNIFIED IDEOGRAPH
	{0xB9FE,	0x6147},	// CJK UNIFIED IDEOGRAPH
	{0xBA40,	0x613F},	// CJK UNIFIED IDEOGRAPH
	{0xBA41,	0x614B},	// CJK UNIFIED IDEOGRAPH
	{0xBA42,	0x6177},	// CJK UNIFIED IDEOGRAPH
	{0xBA43,	0x6162},	// CJK UNIFIED IDEOGRAPH
	{0xBA44,	0x6163},	// CJK UNIFIED IDEOGRAPH
	{0xBA45,	0x615F},	// CJK UNIFIED IDEOGRAPH
	{0xBA46,	0x615A},	// CJK UNIFIED IDEOGRAPH
	{0xBA47,	0x6158},	// CJK UNIFIED IDEOGRAPH
	{0xBA48,	0x6175},	// CJK UNIFIED IDEOGRAPH
	{0xBA49,	0x622A},	// CJK UNIFIED IDEOGRAPH
	{0xBA4A,	0x6487},	// CJK UNIFIED IDEOGRAPH
	{0xBA4B,	0x6458},	// CJK UNIFIED IDEOGRAPH
	{0xBA4C,	0x6454},	// CJK UNIFIED IDEOGRAPH
	{0xBA4D,	0x64A4},	// CJK UNIFIED IDEOGRAPH
	{0xBA4E,	0x6478},	// CJK UNIFIED IDEOGRAPH
	{0xBA4F,	0x645F},	// CJK UNIFIED IDEOGRAPH
	{0xBA50,	0x647A},	// CJK UNIFIED IDEOGRAPH
	{0xBA51,	0x6451},	// CJK UNIFIED IDEOGRAPH
	{0xBA52,	0x6467},	// CJK UNIFIED IDEOGRAPH
	{0xBA53,	0x6434},	// CJK UNIFIED IDEOGRAPH
	{0xBA54,	0x646D},	// CJK UNIFIED IDEOGRAPH
	{0xBA55,	0x647B},	// CJK UNIFIED IDEOGRAPH
	{0xBA56,	0x6572},	// CJK UNIFIED IDEOGRAPH
	{0xBA57,	0x65A1},	// CJK UNIFIED IDEOGRAPH
	{0xBA58,	0x65D7},	// CJK UNIFIED IDEOGRAPH
	{0xBA59,	0x65D6},	// CJK UNIFIED IDEOGRAPH
	{0xBA5A,	0x66A2},	// CJK UNIFIED IDEOGRAPH
	{0xBA5B,	0x66A8},	// CJK UNIFIED IDEOGRAPH
	{0xBA5C,	0x669D},	// CJK UNIFIED IDEOGRAPH
	{0xBA5D,	0x699C},	// CJK UNIFIED IDEOGRAPH
	{0xBA5E,	0x69A8},	// CJK UNIFIED IDEOGRAPH
	{0xBA5F,	0x6995},	// CJK UNIFIED IDEOGRAPH
	{0xBA60,	0x69C1},	// CJK UNIFIED IDEOGRAPH
	{0xBA61,	0x69AE},	// CJK UNIFIED IDEOGRAPH
	{0xBA62,	0x69D3},	// CJK UNIFIED IDEOGRAPH
	{0xBA63,	0x69CB},	// CJK UNIFIED IDEOGRAPH
	{0xBA64,	0x699B},	// CJK UNIFIED IDEOGRAPH
	{0xBA65,	0x69B7},	// CJK UNIFIED IDEOGRAPH
	{0xBA66,	0x69BB},	// CJK UNIFIED IDEOGRAPH
	{0xBA67,	0x69AB},	// CJK UNIFIED IDEOGRAPH
	{0xBA68,	0x69B4},	// CJK UNIFIED IDEOGRAPH
	{0xBA69,	0x69D0},	// CJK UNIFIED IDEOGRAPH
	{0xBA6A,	0x69CD},	// CJK UNIFIED IDEOGRAPH
	{0xBA6B,	0x69AD},	// CJK UNIFIED IDEOGRAPH
	{0xBA6C,	0x69CC},	// CJK UNIFIED IDEOGRAPH
	{0xBA6D,	0x69A6},	// CJK UNIFIED IDEOGRAPH
	{0xBA6E,	0x69C3},	// CJK UNIFIED IDEOGRAPH
	{0xBA6F,	0x69A3},	// CJK UNIFIED IDEOGRAPH
	{0xBA70,	0x6B49},	// CJK UNIFIED IDEOGRAPH
	{0xBA71,	0x6B4C},	// CJK UNIFIED IDEOGRAPH
	{0xBA72,	0x6C33},	// CJK UNIFIED IDEOGRAPH
	{0xBA73,	0x6F33},	// CJK UNIFIED IDEOGRAPH
	{0xBA74,	0x6F14},	// CJK UNIFIED IDEOGRAPH
	{0xBA75,	0x6EFE},	// CJK UNIFIED IDEOGRAPH
	{0xBA76,	0x6F13},	// CJK UNIFIED IDEOGRAPH
	{0xBA77,	0x6EF4},	// CJK UNIFIED IDEOGRAPH
	{0xBA78,	0x6F29},	// CJK UNIFIED IDEOGRAPH
	{0xBA79,	0x6F3E},	// CJK UNIFIED IDEOGRAPH
	{0xBA7A,	0x6F20},	// CJK UNIFIED IDEOGRAPH
	{0xBA7B,	0x6F2C},	// CJK UNIFIED IDEOGRAPH
	{0xBA7C,	0x6F0F},	// CJK UNIFIED IDEOGRAPH
	{0xBA7D,	0x6F02},	// CJK UNIFIED IDEOGRAPH
	{0xBA7E,	0x6F22},	// CJK UNIFIED IDEOGRAPH
	{0xBAA1,	0x6EFF},	// CJK UNIFIED IDEOGRAPH
	{0xBAA2,	0x6EEF},	// CJK UNIFIED IDEOGRAPH
	{0xBAA3,	0x6F06},	// CJK UNIFIED IDEOGRAPH
	{0xBAA4,	0x6F31},	// CJK UNIFIED IDEOGRAPH
	{0xBAA5,	0x6F38},	// CJK UNIFIED IDEOGRAPH
	{0xBAA6,	0x6F32},	// CJK UNIFIED IDEOGRAPH
	{0xBAA7,	0x6F23},	// CJK UNIFIED IDEOGRAPH
	{0xBAA8,	0x6F15},	// CJK UNIFIED IDEOGRAPH
	{0xBAA9,	0x6F2B},	// CJK UNIFIED IDEOGRAPH
	{0xBAAA,	0x6F2F},	// CJK UNIFIED IDEOGRAPH
	{0xBAAB,	0x6F88},	// CJK UNIFIED IDEOGRAPH
	{0xBAAC,	0x6F2A},	// CJK UNIFIED IDEOGRAPH
	{0xBAAD,	0x6EEC},	// CJK UNIFIED IDEOGRAPH
	{0xBAAE,	0x6F01},	// CJK UNIFIED IDEOGRAPH
	{0xBAAF,	0x6EF2},	// CJK UNIFIED IDEOGRAPH
	{0xBAB0,	0x6ECC},	// CJK UNIFIED IDEOGRAPH
	{0xBAB1,	0x6EF7},	// CJK UNIFIED IDEOGRAPH
	{0xBAB2,	0x7194},	// CJK UNIFIED IDEOGRAPH
	{0xBAB3,	0x7199},	// CJK UNIFIED IDEOGRAPH
	{0xBAB4,	0x717D},	// CJK UNIFIED IDEOGRAPH
	{0xBAB5,	0x718A},	// CJK UNIFIED IDEOGRAPH
	{0xBAB6,	0x7184},	// CJK UNIFIED IDEOGRAPH
	{0xBAB7,	0x7192},	// CJK UNIFIED IDEOGRAPH
	{0xBAB8,	0x723E},	// CJK UNIFIED IDEOGRAPH
	{0xBAB9,	0x7292},	// CJK UNIFIED IDEOGRAPH
	{0xBABA,	0x7296},	// CJK UNIFIED IDEOGRAPH
	{0xBABB,	0x7344},	// CJK UNIFIED IDEOGRAPH
	{0xBABC,	0x7350},	// CJK UNIFIED IDEOGRAPH
	{0xBABD,	0x7464},	// CJK UNIFIED IDEOGRAPH
	{0xBABE,	0x7463},	// CJK UNIFIED IDEOGRAPH
	{0xBABF,	0x746A},	// CJK UNIFIED IDEOGRAPH
	{0xBAC0,	0x7470},	// CJK UNIFIED IDEOGRAPH
	{0xBAC1,	0x746D},	// CJK UNIFIED IDEOGRAPH
	{0xBAC2,	0x7504},	// CJK UNIFIED IDEOGRAPH
	{0xBAC3,	0x7591},	// CJK UNIFIED IDEOGRAPH
	{0xBAC4,	0x7627},	// CJK UNIFIED IDEOGRAPH
	{0xBAC5,	0x760D},	// CJK UNIFIED IDEOGRAPH
	{0xBAC6,	0x760B},	// CJK UNIFIED IDEOGRAPH
	{0xBAC7,	0x7609},	// CJK UNIFIED IDEOGRAPH
	{0xBAC8,	0x7613},	// CJK UNIFIED IDEOGRAPH
	{0xBAC9,	0x76E1},	// CJK UNIFIED IDEOGRAPH
	{0xBACA,	0x76E3},	// CJK UNIFIED IDEOGRAPH
	{0xBACB,	0x7784},	// CJK UNIFIED IDEOGRAPH
	{0xBACC,	0x777D},	// CJK UNIFIED IDEOGRAPH
	{0xBACD,	0x777F},	// CJK UNIFIED IDEOGRAPH
	{0xBACE,	0x7761},	// CJK UNIFIED IDEOGRAPH
	{0xBACF,	0x78C1},	// CJK UNIFIED IDEOGRAPH
	{0xBAD0,	0x789F},	// CJK UNIFIED IDEOGRAPH
	{0xBAD1,	0x78A7},	// CJK UNIFIED IDEOGRAPH
	{0xBAD2,	0x78B3},	// CJK UNIFIED IDEOGRAPH
	{0xBAD3,	0x78A9},	// CJK UNIFIED IDEOGRAPH
	{0xBAD4,	0x78A3},	// CJK UNIFIED IDEOGRAPH
	{0xBAD5,	0x798E},	// CJK UNIFIED IDEOGRAPH
	{0xBAD6,	0x798F},	// CJK UNIFIED IDEOGRAPH
	{0xBAD7,	0x798D},	// CJK UNIFIED IDEOGRAPH
	{0xBAD8,	0x7A2E},	// CJK UNIFIED IDEOGRAPH
	{0xBAD9,	0x7A31},	// CJK UNIFIED IDEOGRAPH
	{0xBADA,	0x7AAA},	// CJK UNIFIED IDEOGRAPH
	{0xBADB,	0x7AA9},	// CJK UNIFIED IDEOGRAPH
	{0xBADC,	0x7AED},	// CJK UNIFIED IDEOGRAPH
	{0xBADD,	0x7AEF},	// CJK UNIFIED IDEOGRAPH
	{0xBADE,	0x7BA1},	// CJK UNIFIED IDEOGRAPH
	{0xBADF,	0x7B95},	// CJK UNIFIED IDEOGRAPH
	{0xBAE0,	0x7B8B},	// CJK UNIFIED IDEOGRAPH
	{0xBAE1,	0x7B75},	// CJK UNIFIED IDEOGRAPH
	{0xBAE2,	0x7B97},	// CJK UNIFIED IDEOGRAPH
	{0xBAE3,	0x7B9D},	// CJK UNIFIED IDEOGRAPH
	{0xBAE4,	0x7B94},	// CJK UNIFIED IDEOGRAPH
	{0xBAE5,	0x7B8F},	// CJK UNIFIED IDEOGRAPH
	{0xBAE6,	0x7BB8},	// CJK UNIFIED IDEOGRAPH
	{0xBAE7,	0x7B87},	// CJK UNIFIED IDEOGRAPH
	{0xBAE8,	0x7B84},	// CJK UNIFIED IDEOGRAPH
	{0xBAE9,	0x7CB9},	// CJK UNIFIED IDEOGRAPH
	{0xBAEA,	0x7CBD},	// CJK UNIFIED IDEOGRAPH
	{0xBAEB,	0x7CBE},	// CJK UNIFIED IDEOGRAPH
	{0xBAEC,	0x7DBB},	// CJK UNIFIED IDEOGRAPH
	{0xBAED,	0x7DB0},	// CJK UNIFIED IDEOGRAPH
	{0xBAEE,	0x7D9C},	// CJK UNIFIED IDEOGRAPH
	{0xBAEF,	0x7DBD},	// CJK UNIFIED IDEOGRAPH
	{0xBAF0,	0x7DBE},	// CJK UNIFIED IDEOGRAPH
	{0xBAF1,	0x7DA0},	// CJK UNIFIED IDEOGRAPH
	{0xBAF2,	0x7DCA},	// CJK UNIFIED IDEOGRAPH
	{0xBAF3,	0x7DB4},	// CJK UNIFIED IDEOGRAPH
	{0xBAF4,	0x7DB2},	// CJK UNIFIED IDEOGRAPH
	{0xBAF5,	0x7DB1},	// CJK UNIFIED IDEOGRAPH
	{0xBAF6,	0x7DBA},	// CJK UNIFIED IDEOGRAPH
	{0xBAF7,	0x7DA2},	// CJK UNIFIED IDEOGRAPH
	{0xBAF8,	0x7DBF},	// CJK UNIFIED IDEOGRAPH
	{0xBAF9,	0x7DB5},	// CJK UNIFIED IDEOGRAPH
	{0xBAFA,	0x7DB8},	// CJK UNIFIED IDEOGRAPH
	{0xBAFB,	0x7DAD},	// CJK UNIFIED IDEOGRAPH
	{0xBAFC,	0x7DD2},	// CJK UNIFIED IDEOGRAPH
	{0xBAFD,	0x7DC7},	// CJK UNIFIED IDEOGRAPH
	{0xBAFE,	0x7DAC},	// CJK UNIFIED IDEOGRAPH
	{0xBB40,	0x7F70},	// CJK UNIFIED IDEOGRAPH
	{0xBB41,	0x7FE0},	// CJK UNIFIED IDEOGRAPH
	{0xBB42,	0x7FE1},	// CJK UNIFIED IDEOGRAPH
	{0xBB43,	0x7FDF},	// CJK UNIFIED IDEOGRAPH
	{0xBB44,	0x805E},	// CJK UNIFIED IDEOGRAPH
	{0xBB45,	0x805A},	// CJK UNIFIED IDEOGRAPH
	{0xBB46,	0x8087},	// CJK UNIFIED IDEOGRAPH
	{0xBB47,	0x8150},	// CJK UNIFIED IDEOGRAPH
	{0xBB48,	0x8180},	// CJK UNIFIED IDEOGRAPH
	{0xBB49,	0x818F},	// CJK UNIFIED IDEOGRAPH
	{0xBB4A,	0x8188},	// CJK UNIFIED IDEOGRAPH
	{0xBB4B,	0x818A},	// CJK UNIFIED IDEOGRAPH
	{0xBB4C,	0x817F},	// CJK UNIFIED IDEOGRAPH
	{0xBB4D,	0x8182},	// CJK UNIFIED IDEOGRAPH
	{0xBB4E,	0x81E7},	// CJK UNIFIED IDEOGRAPH
	{0xBB4F,	0x81FA},	// CJK UNIFIED IDEOGRAPH
	{0xBB50,	0x8207},	// CJK UNIFIED IDEOGRAPH
	{0xBB51,	0x8214},	// CJK UNIFIED IDEOGRAPH
	{0xBB52,	0x821E},	// CJK UNIFIED IDEOGRAPH
	{0xBB53,	0x824B},	// CJK UNIFIED IDEOGRAPH
	{0xBB54,	0x84C9},	// CJK UNIFIED IDEOGRAPH
	{0xBB55,	0x84BF},	// CJK UNIFIED IDEOGRAPH
	{0xBB56,	0x84C6},	// CJK UNIFIED IDEOGRAPH
	{0xBB57,	0x84C4},	// CJK UNIFIED IDEOGRAPH
	{0xBB58,	0x8499},	// CJK UNIFIED IDEOGRAPH
	{0xBB59,	0x849E},	// CJK UNIFIED IDEOGRAPH
	{0xBB5A,	0x84B2},	// CJK UNIFIED IDEOGRAPH
	{0xBB5B,	0x849C},	// CJK UNIFIED IDEOGRAPH
	{0xBB5C,	0x84CB},	// CJK UNIFIED IDEOGRAPH
	{0xBB5D,	0x84B8},	// CJK UNIFIED IDEOGRAPH
	{0xBB5E,	0x84C0},	// CJK UNIFIED IDEOGRAPH
	{0xBB5F,	0x84D3},	// CJK UNIFIED IDEOGRAPH
	{0xBB60,	0x8490},	// CJK UNIFIED IDEOGRAPH
	{0xBB61,	0x84BC},	// CJK UNIFIED IDEOGRAPH
	{0xBB62,	0x84D1},	// CJK UNIFIED IDEOGRAPH
	{0xBB63,	0x84CA},	// CJK UNIFIED IDEOGRAPH
	{0xBB64,	0x873F},	// CJK UNIFIED IDEOGRAPH
	{0xBB65,	0x871C},	// CJK UNIFIED IDEOGRAPH
	{0xBB66,	0x873B},	// CJK UNIFIED IDEOGRAPH
	{0xBB67,	0x8722},	// CJK UNIFIED IDEOGRAPH
	{0xBB68,	0x8725},	// CJK UNIFIED IDEOGRAPH
	{0xBB69,	0x8734},	// CJK UNIFIED IDEOGRAPH
	{0xBB6A,	0x8718},	// CJK UNIFIED IDEOGRAPH
	{0xBB6B,	0x8755},	// CJK UNIFIED IDEOGRAPH
	{0xBB6C,	0x8737},	// CJK UNIFIED IDEOGRAPH
	{0xBB6D,	0x8729},	// CJK UNIFIED IDEOGRAPH
	{0xBB6E,	0x88F3},	// CJK UNIFIED IDEOGRAPH
	{0xBB6F,	0x8902},	// CJK UNIFIED IDEOGRAPH
	{0xBB70,	0x88F4},	// CJK UNIFIED IDEOGRAPH
	{0xBB71,	0x88F9},	// CJK UNIFIED IDEOGRAPH
	{0xBB72,	0x88F8},	// CJK UNIFIED IDEOGRAPH
	{0xBB73,	0x88FD},	// CJK UNIFIED IDEOGRAPH
	{0xBB74,	0x88E8},	// CJK UNIFIED IDEOGRAPH
	{0xBB75,	0x891A},	// CJK UNIFIED IDEOGRAPH
	{0xBB76,	0x88EF},	// CJK UNIFIED IDEOGRAPH
	{0xBB77,	0x8AA6},	// CJK UNIFIED IDEOGRAPH
	{0xBB78,	0x8A8C},	// CJK UNIFIED IDEOGRAPH
	{0xBB79,	0x8A9E},	// CJK UNIFIED IDEOGRAPH
	{0xBB7A,	0x8AA3},	// CJK UNIFIED IDEOGRAPH
	{0xBB7B,	0x8A8D},	// CJK UNIFIED IDEOGRAPH
	{0xBB7C,	0x8AA1},	// CJK UNIFIED IDEOGRAPH
	{0xBB7D,	0x8A93},	// CJK UNIFIED IDEOGRAPH
	{0xBB7E,	0x8AA4},	// CJK UNIFIED IDEOGRAPH
	{0xBBA1,	0x8AAA},	// CJK UNIFIED IDEOGRAPH
	{0xBBA2,	0x8AA5},	// CJK UNIFIED IDEOGRAPH
	{0xBBA3,	0x8AA8},	// CJK UNIFIED IDEOGRAPH
	{0xBBA4,	0x8A98},	// CJK UNIFIED IDEOGRAPH
	{0xBBA5,	0x8A91},	// CJK UNIFIED IDEOGRAPH
	{0xBBA6,	0x8A9A},	// CJK UNIFIED IDEOGRAPH
	{0xBBA7,	0x8AA7},	// CJK UNIFIED IDEOGRAPH
	{0xBBA8,	0x8C6A},	// CJK UNIFIED IDEOGRAPH
	{0xBBA9,	0x8C8D},	// CJK UNIFIED IDEOGRAPH
	{0xBBAA,	0x8C8C},	// CJK UNIFIED IDEOGRAPH
	{0xBBAB,	0x8CD3},	// CJK UNIFIED IDEOGRAPH
	{0xBBAC,	0x8CD1},	// CJK UNIFIED IDEOGRAPH
	{0xBBAD,	0x8CD2},	// CJK UNIFIED IDEOGRAPH
	{0xBBAE,	0x8D6B},	// CJK UNIFIED IDEOGRAPH
	{0xBBAF,	0x8D99},	// CJK UNIFIED IDEOGRAPH
	{0xBBB0,	0x8D95},	// CJK UNIFIED IDEOGRAPH
	{0xBBB1,	0x8DFC},	// CJK UNIFIED IDEOGRAPH
	{0xBBB2,	0x8F14},	// CJK UNIFIED IDEOGRAPH
	{0xBBB3,	0x8F12},	// CJK UNIFIED IDEOGRAPH
	{0xBBB4,	0x8F15},	// CJK UNIFIED IDEOGRAPH
	{0xBBB5,	0x8F13},	// CJK UNIFIED IDEOGRAPH
	{0xBBB6,	0x8FA3},	// CJK UNIFIED IDEOGRAPH
	{0xBBB7,	0x9060},	// CJK UNIFIED IDEOGRAPH
	{0xBBB8,	0x9058},	// CJK UNIFIED IDEOGRAPH
	{0xBBB9,	0x905C},	// CJK UNIFIED IDEOGRAPH
	{0xBBBA,	0x9063},	// CJK UNIFIED IDEOGRAPH
	{0xBBBB,	0x9059},	// CJK UNIFIED IDEOGRAPH
	{0xBBBC,	0x905E},	// CJK UNIFIED IDEOGRAPH
	{0xBBBD,	0x9062},	// CJK UNIFIED IDEOGRAPH
	{0xBBBE,	0x905D},	// CJK UNIFIED IDEOGRAPH
	{0xBBBF,	0x905B},	// CJK UNIFIED IDEOGRAPH
	{0xBBC0,	0x9119},	// CJK UNIFIED IDEOGRAPH
	{0xBBC1,	0x9118},	// CJK UNIFIED IDEOGRAPH
	{0xBBC2,	0x911E},	// CJK UNIFIED IDEOGRAPH
	{0xBBC3,	0x9175},	// CJK UNIFIED IDEOGRAPH
	{0xBBC4,	0x9178},	// CJK UNIFIED IDEOGRAPH
	{0xBBC5,	0x9177},	// CJK UNIFIED IDEOGRAPH
	{0xBBC6,	0x9174},	// CJK UNIFIED IDEOGRAPH
	{0xBBC7,	0x9278},	// CJK UNIFIED IDEOGRAPH
	{0xBBC8,	0x9280},	// CJK UNIFIED IDEOGRAPH
	{0xBBC9,	0x9285},	// CJK UNIFIED IDEOGRAPH
	{0xBBCA,	0x9298},	// CJK UNIFIED IDEOGRAPH
	{0xBBCB,	0x9296},	// CJK UNIFIED IDEOGRAPH
	{0xBBCC,	0x927B},	// CJK UNIFIED IDEOGRAPH
	{0xBBCD,	0x9293},	// CJK UNIFIED IDEOGRAPH
	{0xBBCE,	0x929C},	// CJK UNIFIED IDEOGRAPH
	{0xBBCF,	0x92A8},	// CJK UNIFIED IDEOGRAPH
	{0xBBD0,	0x927C},	// CJK UNIFIED IDEOGRAPH
	{0xBBD1,	0x9291},	// CJK UNIFIED IDEOGRAPH
	{0xBBD2,	0x95A1},	// CJK UNIFIED IDEOGRAPH
	{0xBBD3,	0x95A8},	// CJK UNIFIED IDEOGRAPH
	{0xBBD4,	0x95A9},	// CJK UNIFIED IDEOGRAPH
	{0xBBD5,	0x95A3},	// CJK UNIFIED IDEOGRAPH
	{0xBBD6,	0x95A5},	// CJK UNIFIED IDEOGRAPH
	{0xBBD7,	0x95A4},	// CJK UNIFIED IDEOGRAPH
	{0xBBD8,	0x9699},	// CJK UNIFIED IDEOGRAPH
	{0xBBD9,	0x969C},	// CJK UNIFIED IDEOGRAPH
	{0xBBDA,	0x969B},	// CJK UNIFIED IDEOGRAPH
	{0xBBDB,	0x96CC},	// CJK UNIFIED IDEOGRAPH
	{0xBBDC,	0x96D2},	// CJK UNIFIED IDEOGRAPH
	{0xBBDD,	0x9700},	// CJK UNIFIED IDEOGRAPH
	{0xBBDE,	0x977C},	// CJK UNIFIED IDEOGRAPH
	{0xBBDF,	0x9785},	// CJK UNIFIED IDEOGRAPH
	{0xBBE0,	0x97F6},	// CJK UNIFIED IDEOGRAPH
	{0xBBE1,	0x9817},	// CJK UNIFIED IDEOGRAPH
	{0xBBE2,	0x9818},	// CJK UNIFIED IDEOGRAPH
	{0xBBE3,	0x98AF},	// CJK UNIFIED IDEOGRAPH
	{0xBBE4,	0x98B1},	// CJK UNIFIED IDEOGRAPH
	{0xBBE5,	0x9903},	// CJK UNIFIED IDEOGRAPH
	{0xBBE6,	0x9905},	// CJK UNIFIED IDEOGRAPH
	{0xBBE7,	0x990C},	// CJK UNIFIED IDEOGRAPH
	{0xBBE8,	0x9909},	// CJK UNIFIED IDEOGRAPH
	{0xBBE9,	0x99C1},	// CJK UNIFIED IDEOGRAPH
	{0xBBEA,	0x9AAF},	// CJK UNIFIED IDEOGRAPH
	{0xBBEB,	0x9AB0},	// CJK UNIFIED IDEOGRAPH
	{0xBBEC,	0x9AE6},	// CJK UNIFIED IDEOGRAPH
	{0xBBED,	0x9B41},	// CJK UNIFIED IDEOGRAPH
	{0xBBEE,	0x9B42},	// CJK UNIFIED IDEOGRAPH
	{0xBBEF,	0x9CF4},	// CJK UNIFIED IDEOGRAPH
	{0xBBF0,	0x9CF6},	// CJK UNIFIED IDEOGRAPH
	{0xBBF1,	0x9CF3},	// CJK UNIFIED IDEOGRAPH
	{0xBBF2,	0x9EBC},	// CJK UNIFIED IDEOGRAPH
	{0xBBF3,	0x9F3B},	// CJK UNIFIED IDEOGRAPH
	{0xBBF4,	0x9F4A},	// CJK UNIFIED IDEOGRAPH
	{0xBBF5,	0x5104},	// CJK UNIFIED IDEOGRAPH
	{0xBBF6,	0x5100},	// CJK UNIFIED IDEOGRAPH
	{0xBBF7,	0x50FB},	// CJK UNIFIED IDEOGRAPH
	{0xBBF8,	0x50F5},	// CJK UNIFIED IDEOGRAPH
	{0xBBF9,	0x50F9},	// CJK UNIFIED IDEOGRAPH
	{0xBBFA,	0x5102},	// CJK UNIFIED IDEOGRAPH
	{0xBBFB,	0x5108},	// CJK UNIFIED IDEOGRAPH
	{0xBBFC,	0x5109},	// CJK UNIFIED IDEOGRAPH
	{0xBBFD,	0x5105},	// CJK UNIFIED IDEOGRAPH
	{0xBBFE,	0x51DC},	// CJK UNIFIED IDEOGRAPH
	{0xBC40,	0x5287},	// CJK UNIFIED IDEOGRAPH
	{0xBC41,	0x5288},	// CJK UNIFIED IDEOGRAPH
	{0xBC42,	0x5289},	// CJK UNIFIED IDEOGRAPH
	{0xBC43,	0x528D},	// CJK UNIFIED IDEOGRAPH
	{0xBC44,	0x528A},	// CJK UNIFIED IDEOGRAPH
	{0xBC45,	0x52F0},	// CJK UNIFIED IDEOGRAPH
	{0xBC46,	0x53B2},	// CJK UNIFIED IDEOGRAPH
	{0xBC47,	0x562E},	// CJK UNIFIED IDEOGRAPH
	{0xBC48,	0x563B},	// CJK UNIFIED IDEOGRAPH
	{0xBC49,	0x5639},	// CJK UNIFIED IDEOGRAPH
	{0xBC4A,	0x5632},	// CJK UNIFIED IDEOGRAPH
	{0xBC4B,	0x563F},	// CJK UNIFIED IDEOGRAPH
	{0xBC4C,	0x5634},	// CJK UNIFIED IDEOGRAPH
	{0xBC4D,	0x5629},	// CJK UNIFIED IDEOGRAPH
	{0xBC4E,	0x5653},	// CJK UNIFIED IDEOGRAPH
	{0xBC4F,	0x564E},	// CJK UNIFIED IDEOGRAPH
	{0xBC50,	0x5657},	// CJK UNIFIED IDEOGRAPH
	{0xBC51,	0x5674},	// CJK UNIFIED IDEOGRAPH
	{0xBC52,	0x5636},	// CJK UNIFIED IDEOGRAPH
	{0xBC53,	0x562F},	// CJK UNIFIED IDEOGRAPH
	{0xBC54,	0x5630},	// CJK UNIFIED IDEOGRAPH
	{0xBC55,	0x5880},	// CJK UNIFIED IDEOGRAPH
	{0xBC56,	0x589F},	// CJK UNIFIED IDEOGRAPH
	{0xBC57,	0x589E},	// CJK UNIFIED IDEOGRAPH
	{0xBC58,	0x58B3},	// CJK UNIFIED IDEOGRAPH
	{0xBC59,	0x589C},	// CJK UNIFIED IDEOGRAPH
	{0xBC5A,	0x58AE},	// CJK UNIFIED IDEOGRAPH
	{0xBC5B,	0x58A9},	// CJK UNIFIED IDEOGRAPH
	{0xBC5C,	0x58A6},	// CJK UNIFIED IDEOGRAPH
	{0xBC5D,	0x596D},	// CJK UNIFIED IDEOGRAPH
	{0xBC5E,	0x5B09},	// CJK UNIFIED IDEOGRAPH
	{0xBC5F,	0x5AFB},	// CJK UNIFIED IDEOGRAPH
	{0xBC60,	0x5B0B},	// CJK UNIFIED IDEOGRAPH
	{0xBC61,	0x5AF5},	// CJK UNIFIED IDEOGRAPH
	{0xBC62,	0x5B0C},	// CJK UNIFIED IDEOGRAPH
	{0xBC63,	0x5B08},	// CJK UNIFIED IDEOGRAPH
	{0xBC64,	0x5BEE},	// CJK UNIFIED IDEOGRAPH
	{0xBC65,	0x5BEC},	// CJK UNIFIED IDEOGRAPH
	{0xBC66,	0x5BE9},	// CJK UNIFIED IDEOGRAPH
	{0xBC67,	0x5BEB},	// CJK UNIFIED IDEOGRAPH
	{0xBC68,	0x5C64},	// CJK UNIFIED IDEOGRAPH
	{0xBC69,	0x5C65},	// CJK UNIFIED IDEOGRAPH
	{0xBC6A,	0x5D9D},	// CJK UNIFIED IDEOGRAPH
	{0xBC6B,	0x5D94},	// CJK UNIFIED IDEOGRAPH
	{0xBC6C,	0x5E62},	// CJK UNIFIED IDEOGRAPH
	{0xBC6D,	0x5E5F},	// CJK UNIFIED IDEOGRAPH
	{0xBC6E,	0x5E61},	// CJK UNIFIED IDEOGRAPH
	{0xBC6F,	0x5EE2},	// CJK UNIFIED IDEOGRAPH
	{0xBC70,	0x5EDA},	// CJK UNIFIED IDEOGRAPH
	{0xBC71,	0x5EDF},	// CJK UNIFIED IDEOGRAPH
	{0xBC72,	0x5EDD},	// CJK UNIFIED IDEOGRAPH
	{0xBC73,	0x5EE3},	// CJK UNIFIED IDEOGRAPH
	{0xBC74,	0x5EE0},	// CJK UNIFIED IDEOGRAPH
	{0xBC75,	0x5F48},	// CJK UNIFIED IDEOGRAPH
	{0xBC76,	0x5F71},	// CJK UNIFIED IDEOGRAPH
	{0xBC77,	0x5FB7},	// CJK UNIFIED IDEOGRAPH
	{0xBC78,	0x5FB5},	// CJK UNIFIED IDEOGRAPH
	{0xBC79,	0x6176},	// CJK UNIFIED IDEOGRAPH
	{0xBC7A,	0x6167},	// CJK UNIFIED IDEOGRAPH
	{0xBC7B,	0x616E},	// CJK UNIFIED IDEOGRAPH
	{0xBC7C,	0x615D},	// CJK UNIFIED IDEOGRAPH
	{0xBC7D,	0x6155},	// CJK UNIFIED IDEOGRAPH
	{0xBC7E,	0x6182},	// CJK UNIFIED IDEOGRAPH
	{0xBCA1,	0x617C},	// CJK UNIFIED IDEOGRAPH
	{0xBCA2,	0x6170},	// CJK UNIFIED IDEOGRAPH
	{0xBCA3,	0x616B},	// CJK UNIFIED IDEOGRAPH
	{0xBCA4,	0x617E},	// CJK UNIFIED IDEOGRAPH
	{0xBCA5,	0x61A7},	// CJK UNIFIED IDEOGRAPH
	{0xBCA6,	0x6190},	// CJK UNIFIED IDEOGRAPH
	{0xBCA7,	0x61AB},	// CJK UNIFIED IDEOGRAPH
	{0xBCA8,	0x618E},	// CJK UNIFIED IDEOGRAPH
	{0xBCA9,	0x61AC},	// CJK UNIFIED IDEOGRAPH
	{0xBCAA,	0x619A},	// CJK UNIFIED IDEOGRAPH
	{0xBCAB,	0x61A4},	// CJK UNIFIED IDEOGRAPH
	{0xBCAC,	0x6194},	// CJK UNIFIED IDEOGRAPH
	{0xBCAD,	0x61AE},	// CJK UNIFIED IDEOGRAPH
	{0xBCAE,	0x622E},	// CJK UNIFIED IDEOGRAPH
	{0xBCAF,	0x6469},	// CJK UNIFIED IDEOGRAPH
	{0xBCB0,	0x646F},	// CJK UNIFIED IDEOGRAPH
	{0xBCB1,	0x6479},	// CJK UNIFIED IDEOGRAPH
	{0xBCB2,	0x649E},	// CJK UNIFIED IDEOGRAPH
	{0xBCB3,	0x64B2},	// CJK UNIFIED IDEOGRAPH
	{0xBCB4,	0x6488},	// CJK UNIFIED IDEOGRAPH
	{0xBCB5,	0x6490},	// CJK UNIFIED IDEOGRAPH
	{0xBCB6,	0x64B0},	// CJK UNIFIED IDEOGRAPH
	{0xBCB7,	0x64A5},	// CJK UNIFIED IDEOGRAPH
	{0xBCB8,	0x6493},	// CJK UNIFIED IDEOGRAPH
	{0xBCB9,	0x6495},	// CJK UNIFIED IDEOGRAPH
	{0xBCBA,	0x64A9},	// CJK UNIFIED IDEOGRAPH
	{0xBCBB,	0x6492},	// CJK UNIFIED IDEOGRAPH
	{0xBCBC,	0x64AE},	// CJK UNIFIED IDEOGRAPH
	{0xBCBD,	0x64AD},	// CJK UNIFIED IDEOGRAPH
	{0xBCBE,	0x64AB},	// CJK UNIFIED IDEOGRAPH
	{0xBCBF,	0x649A},	// CJK UNIFIED IDEOGRAPH
	{0xBCC0,	0x64AC},	// CJK UNIFIED IDEOGRAPH
	{0xBCC1,	0x6499},	// CJK UNIFIED IDEOGRAPH
	{0xBCC2,	0x64A2},	// CJK UNIFIED IDEOGRAPH
	{0xBCC3,	0x64B3},	// CJK UNIFIED IDEOGRAPH
	{0xBCC4,	0x6575},	// CJK UNIFIED IDEOGRAPH
	{0xBCC5,	0x6577},	// CJK UNIFIED IDEOGRAPH
	{0xBCC6,	0x6578},	// CJK UNIFIED IDEOGRAPH
	{0xBCC7,	0x66AE},	// CJK UNIFIED IDEOGRAPH
	{0xBCC8,	0x66AB},	// CJK UNIFIED IDEOGRAPH
	{0xBCC9,	0x66B4},	// CJK UNIFIED IDEOGRAPH
	{0xBCCA,	0x66B1},	// CJK UNIFIED IDEOGRAPH
	{0xBCCB,	0x6A23},	// CJK UNIFIED IDEOGRAPH
	{0xBCCC,	0x6A1F},	// CJK UNIFIED IDEOGRAPH
	{0xBCCD,	0x69E8},	// CJK UNIFIED IDEOGRAPH
	{0xBCCE,	0x6A01},	// CJK UNIFIED IDEOGRAPH
	{0xBCCF,	0x6A1E},	// CJK UNIFIED IDEOGRAPH
	{0xBCD0,	0x6A19},	// CJK UNIFIED IDEOGRAPH
	{0xBCD1,	0x69FD},	// CJK UNIFIED IDEOGRAPH
	{0xBCD2,	0x6A21},	// CJK UNIFIED IDEOGRAPH
	{0xBCD3,	0x6A13},	// CJK UNIFIED IDEOGRAPH
	{0xBCD4,	0x6A0A},	// CJK UNIFIED IDEOGRAPH
	{0xBCD5,	0x69F3},	// CJK UNIFIED IDEOGRAPH
	{0xBCD6,	0x6A02},	// CJK UNIFIED IDEOGRAPH
	{0xBCD7,	0x6A05},	// CJK UNIFIED IDEOGRAPH
	{0xBCD8,	0x69ED},	// CJK UNIFIED IDEOGRAPH
	{0xBCD9,	0x6A11},	// CJK UNIFIED IDEOGRAPH
	{0xBCDA,	0x6B50},	// CJK UNIFIED IDEOGRAPH
	{0xBCDB,	0x6B4E},	// CJK UNIFIED IDEOGRAPH
	{0xBCDC,	0x6BA4},	// CJK UNIFIED IDEOGRAPH
	{0xBCDD,	0x6BC5},	// CJK UNIFIED IDEOGRAPH
	{0xBCDE,	0x6BC6},	// CJK UNIFIED IDEOGRAPH
	{0xBCDF,	0x6F3F},	// CJK UNIFIED IDEOGRAPH
	{0xBCE0,	0x6F7C},	// CJK UNIFIED IDEOGRAPH
	{0xBCE1,	0x6F84},	// CJK UNIFIED IDEOGRAPH
	{0xBCE2,	0x6F51},	// CJK UNIFIED IDEOGRAPH
	{0xBCE3,	0x6F66},	// CJK UNIFIED IDEOGRAPH
	{0xBCE4,	0x6F54},	// CJK UNIFIED IDEOGRAPH
	{0xBCE5,	0x6F86},	// CJK UNIFIED IDEOGRAPH
	{0xBCE6,	0x6F6D},	// CJK UNIFIED IDEOGRAPH
	{0xBCE7,	0x6F5B},	// CJK UNIFIED IDEOGRAPH
	{0xBCE8,	0x6F78},	// CJK UNIFIED IDEOGRAPH
	{0xBCE9,	0x6F6E},	// CJK UNIFIED IDEOGRAPH
	{0xBCEA,	0x6F8E},	// CJK UNIFIED IDEOGRAPH
	{0xBCEB,	0x6F7A},	// CJK UNIFIED IDEOGRAPH
	{0xBCEC,	0x6F70},	// CJK UNIFIED IDEOGRAPH
	{0xBCED,	0x6F64},	// CJK UNIFIED IDEOGRAPH
	{0xBCEE,	0x6F97},	// CJK UNIFIED IDEOGRAPH
	{0xBCEF,	0x6F58},	// CJK UNIFIED IDEOGRAPH
	{0xBCF0,	0x6ED5},	// CJK UNIFIED IDEOGRAPH
	{0xBCF1,	0x6F6F},	// CJK UNIFIED IDEOGRAPH
	{0xBCF2,	0x6F60},	// CJK UNIFIED IDEOGRAPH
	{0xBCF3,	0x6F5F},	// CJK UNIFIED IDEOGRAPH
	{0xBCF4,	0x719F},	// CJK UNIFIED IDEOGRAPH
	{0xBCF5,	0x71AC},	// CJK UNIFIED IDEOGRAPH
	{0xBCF6,	0x71B1},	// CJK UNIFIED IDEOGRAPH
	{0xBCF7,	0x71A8},	// CJK UNIFIED IDEOGRAPH
	{0xBCF8,	0x7256},	// CJK UNIFIED IDEOGRAPH
	{0xBCF9,	0x729B},	// CJK UNIFIED IDEOGRAPH
	{0xBCFA,	0x734E},	// CJK UNIFIED IDEOGRAPH
	{0xBCFB,	0x7357},	// CJK UNIFIED IDEOGRAPH
	{0xBCFC,	0x7469},	// CJK UNIFIED IDEOGRAPH
	{0xBCFD,	0x748B},	// CJK UNIFIED IDEOGRAPH
	{0xBCFE,	0x7483},	// CJK UNIFIED IDEOGRAPH
	{0xBD40,	0x747E},	// CJK UNIFIED IDEOGRAPH
	{0xBD41,	0x7480},	// CJK UNIFIED IDEOGRAPH
	{0xBD42,	0x757F},	// CJK UNIFIED IDEOGRAPH
	{0xBD43,	0x7620},	// CJK UNIFIED IDEOGRAPH
	{0xBD44,	0x7629},	// CJK UNIFIED IDEOGRAPH
	{0xBD45,	0x761F},	// CJK UNIFIED IDEOGRAPH
	{0xBD46,	0x7624},	// CJK UNIFIED IDEOGRAPH
	{0xBD47,	0x7626},	// CJK UNIFIED IDEOGRAPH
	{0xBD48,	0x7621},	// CJK UNIFIED IDEOGRAPH
	{0xBD49,	0x7622},	// CJK UNIFIED IDEOGRAPH
	{0xBD4A,	0x769A},	// CJK UNIFIED IDEOGRAPH
	{0xBD4B,	0x76BA},	// CJK UNIFIED IDEOGRAPH
	{0xBD4C,	0x76E4},	// CJK UNIFIED IDEOGRAPH
	{0xBD4D,	0x778E},	// CJK UNIFIED IDEOGRAPH
	{0xBD4E,	0x7787},	// CJK UNIFIED IDEOGRAPH
	{0xBD4F,	0x778C},	// CJK UNIFIED IDEOGRAPH
	{0xBD50,	0x7791},	// CJK UNIFIED IDEOGRAPH
	{0xBD51,	0x778B},	// CJK UNIFIED IDEOGRAPH
	{0xBD52,	0x78CB},	// CJK UNIFIED IDEOGRAPH
	{0xBD53,	0x78C5},	// CJK UNIFIED IDEOGRAPH
	{0xBD54,	0x78BA},	// CJK UNIFIED IDEOGRAPH
	{0xBD55,	0x78CA},	// CJK UNIFIED IDEOGRAPH
	{0xBD56,	0x78BE},	// CJK UNIFIED IDEOGRAPH
	{0xBD57,	0x78D5},	// CJK UNIFIED IDEOGRAPH
	{0xBD58,	0x78BC},	// CJK UNIFIED IDEOGRAPH
	{0xBD59,	0x78D0},	// CJK UNIFIED IDEOGRAPH
	{0xBD5A,	0x7A3F},	// CJK UNIFIED IDEOGRAPH
	{0xBD5B,	0x7A3C},	// CJK UNIFIED IDEOGRAPH
	{0xBD5C,	0x7A40},	// CJK UNIFIED IDEOGRAPH
	{0xBD5D,	0x7A3D},	// CJK UNIFIED IDEOGRAPH
	{0xBD5E,	0x7A37},	// CJK UNIFIED IDEOGRAPH
	{0xBD5F,	0x7A3B},	// CJK UNIFIED IDEOGRAPH
	{0xBD60,	0x7AAF},	// CJK UNIFIED IDEOGRAPH
	{0xBD61,	0x7AAE},	// CJK UNIFIED IDEOGRAPH
	{0xBD62,	0x7BAD},	// CJK UNIFIED IDEOGRAPH
	{0xBD63,	0x7BB1},	// CJK UNIFIED IDEOGRAPH
	{0xBD64,	0x7BC4},	// CJK UNIFIED IDEOGRAPH
	{0xBD65,	0x7BB4},	// CJK UNIFIED IDEOGRAPH
	{0xBD66,	0x7BC6},	// CJK UNIFIED IDEOGRAPH
	{0xBD67,	0x7BC7},	// CJK UNIFIED IDEOGRAPH
	{0xBD68,	0x7BC1},	// CJK UNIFIED IDEOGRAPH
	{0xBD69,	0x7BA0},	// CJK UNIFIED IDEOGRAPH
	{0xBD6A,	0x7BCC},	// CJK UNIFIED IDEOGRAPH
	{0xBD6B,	0x7CCA},	// CJK UNIFIED IDEOGRAPH
	{0xBD6C,	0x7DE0},	// CJK UNIFIED IDEOGRAPH
	{0xBD6D,	0x7DF4},	// CJK UNIFIED IDEOGRAPH
	{0xBD6E,	0x7DEF},	// CJK UNIFIED IDEOGRAPH
	{0xBD6F,	0x7DFB},	// CJK UNIFIED IDEOGRAPH
	{0xBD70,	0x7DD8},	// CJK UNIFIED IDEOGRAPH
	{0xBD71,	0x7DEC},	// CJK UNIFIED IDEOGRAPH
	{0xBD72,	0x7DDD},	// CJK UNIFIED IDEOGRAPH
	{0xBD73,	0x7DE8},	// CJK UNIFIED IDEOGRAPH
	{0xBD74,	0x7DE3},	// CJK UNIFIED IDEOGRAPH
	{0xBD75,	0x7DDA},	// CJK UNIFIED IDEOGRAPH
	{0xBD76,	0x7DDE},	// CJK UNIFIED IDEOGRAPH
	{0xBD77,	0x7DE9},	// CJK UNIFIED IDEOGRAPH
	{0xBD78,	0x7D9E},	// CJK UNIFIED IDEOGRAPH
	{0xBD79,	0x7DD9},	// CJK UNIFIED IDEOGRAPH
	{0xBD7A,	0x7DF2},	// CJK UNIFIED IDEOGRAPH
	{0xBD7B,	0x7DF9},	// CJK UNIFIED IDEOGRAPH
	{0xBD7C,	0x7F75},	// CJK UNIFIED IDEOGRAPH
	{0xBD7D,	0x7F77},	// CJK UNIFIED IDEOGRAPH
	{0xBD7E,	0x7FAF},	// CJK UNIFIED IDEOGRAPH
	{0xBDA1,	0x7FE9},	// CJK UNIFIED IDEOGRAPH
	{0xBDA2,	0x8026},	// CJK UNIFIED IDEOGRAPH
	{0xBDA3,	0x819B},	// CJK UNIFIED IDEOGRAPH
	{0xBDA4,	0x819C},	// CJK UNIFIED IDEOGRAPH
	{0xBDA5,	0x819D},	// CJK UNIFIED IDEOGRAPH
	{0xBDA6,	0x81A0},	// CJK UNIFIED IDEOGRAPH
	{0xBDA7,	0x819A},	// CJK UNIFIED IDEOGRAPH
	{0xBDA8,	0x8198},	// CJK UNIFIED IDEOGRAPH
	{0xBDA9,	0x8517},	// CJK UNIFIED IDEOGRAPH
	{0xBDAA,	0x853D},	// CJK UNIFIED IDEOGRAPH
	{0xBDAB,	0x851A},	// CJK UNIFIED IDEOGRAPH
	{0xBDAC,	0x84EE},	// CJK UNIFIED IDEOGRAPH
	{0xBDAD,	0x852C},	// CJK UNIFIED IDEOGRAPH
	{0xBDAE,	0x852D},	// CJK UNIFIED IDEOGRAPH
	{0xBDAF,	0x8513},	// CJK UNIFIED IDEOGRAPH
	{0xBDB0,	0x8511},	// CJK UNIFIED IDEOGRAPH
	{0xBDB1,	0x8523},	// CJK UNIFIED IDEOGRAPH
	{0xBDB2,	0x8521},	// CJK UNIFIED IDEOGRAPH
	{0xBDB3,	0x8514},	// CJK UNIFIED IDEOGRAPH
	{0xBDB4,	0x84EC},	// CJK UNIFIED IDEOGRAPH
	{0xBDB5,	0x8525},	// CJK UNIFIED IDEOGRAPH
	{0xBDB6,	0x84FF},	// CJK UNIFIED IDEOGRAPH
	{0xBDB7,	0x8506},	// CJK UNIFIED IDEOGRAPH
	{0xBDB8,	0x8782},	// CJK UNIFIED IDEOGRAPH
	{0xBDB9,	0x8774},	// CJK UNIFIED IDEOGRAPH
	{0xBDBA,	0x8776},	// CJK UNIFIED IDEOGRAPH
	{0xBDBB,	0x8760},	// CJK UNIFIED IDEOGRAPH
	{0xBDBC,	0x8766},	// CJK UNIFIED IDEOGRAPH
	{0xBDBD,	0x8778},	// CJK UNIFIED IDEOGRAPH
	{0xBDBE,	0x8768},	// CJK UNIFIED IDEOGRAPH
	{0xBDBF,	0x8759},	// CJK UNIFIED IDEOGRAPH
	{0xBDC0,	0x8757},	// CJK UNIFIED IDEOGRAPH
	{0xBDC1,	0x874C},	// CJK UNIFIED IDEOGRAPH
	{0xBDC2,	0x8753},	// CJK UNIFIED IDEOGRAPH
	{0xBDC3,	0x885B},	// CJK UNIFIED IDEOGRAPH
	{0xBDC4,	0x885D},	// CJK UNIFIED IDEOGRAPH
	{0xBDC5,	0x8910},	// CJK UNIFIED IDEOGRAPH
	{0xBDC6,	0x8907},	// CJK UNIFIED IDEOGRAPH
	{0xBDC7,	0x8912},	// CJK UNIFIED IDEOGRAPH
	{0xBDC8,	0x8913},	// CJK UNIFIED IDEOGRAPH
	{0xBDC9,	0x8915},	// CJK UNIFIED IDEOGRAPH
	{0xBDCA,	0x890A},	// CJK UNIFIED IDEOGRAPH
	{0xBDCB,	0x8ABC},	// CJK UNIFIED IDEOGRAPH
	{0xBDCC,	0x8AD2},	// CJK UNIFIED IDEOGRAPH
	{0xBDCD,	0x8AC7},	// CJK UNIFIED IDEOGRAPH
	{0xBDCE,	0x8AC4},	// CJK UNIFIED IDEOGRAPH
	{0xBDCF,	0x8A95},	// CJK UNIFIED IDEOGRAPH
	{0xBDD0,	0x8ACB},	// CJK UNIFIED IDEOGRAPH
	{0xBDD1,	0x8AF8},	// CJK UNIFIED IDEOGRAPH
	{0xBDD2,	0x8AB2},	// CJK UNIFIED IDEOGRAPH
	{0xBDD3,	0x8AC9},	// CJK UNIFIED IDEOGRAPH
	{0xBDD4,	0x8AC2},	// CJK UNIFIED IDEOGRAPH
	{0xBDD5,	0x8ABF},	// CJK UNIFIED IDEOGRAPH
	{0xBDD6,	0x8AB0},	// CJK UNIFIED IDEOGRAPH
	{0xBDD7,	0x8AD6},	// CJK UNIFIED IDEOGRAPH
	{0xBDD8,	0x8ACD},	// CJK UNIFIED IDEOGRAPH
	{0xBDD9,	0x8AB6},	// CJK UNIFIED IDEOGRAPH
	{0xBDDA,	0x8AB9},	// CJK UNIFIED IDEOGRAPH
	{0xBDDB,	0x8ADB},	// CJK UNIFIED IDEOGRAPH
	{0xBDDC,	0x8C4C},	// CJK UNIFIED IDEOGRAPH
	{0xBDDD,	0x8C4E},	// CJK UNIFIED IDEOGRAPH
	{0xBDDE,	0x8C6C},	// CJK UNIFIED IDEOGRAPH
	{0xBDDF,	0x8CE0},	// CJK UNIFIED IDEOGRAPH
	{0xBDE0,	0x8CDE},	// CJK UNIFIED IDEOGRAPH
	{0xBDE1,	0x8CE6},	// CJK UNIFIED IDEOGRAPH
	{0xBDE2,	0x8CE4},	// CJK UNIFIED IDEOGRAPH
	{0xBDE3,	0x8CEC},	// CJK UNIFIED IDEOGRAPH
	{0xBDE4,	0x8CED},	// CJK UNIFIED IDEOGRAPH
	{0xBDE5,	0x8CE2},	// CJK UNIFIED IDEOGRAPH
	{0xBDE6,	0x8CE3},	// CJK UNIFIED IDEOGRAPH
	{0xBDE7,	0x8CDC},	// CJK UNIFIED IDEOGRAPH
	{0xBDE8,	0x8CEA},	// CJK UNIFIED IDEOGRAPH
	{0xBDE9,	0x8CE1},	// CJK UNIFIED IDEOGRAPH
	{0xBDEA,	0x8D6D},	// CJK UNIFIED IDEOGRAPH
	{0xBDEB,	0x8D9F},	// CJK UNIFIED IDEOGRAPH
	{0xBDEC,	0x8DA3},	// CJK UNIFIED IDEOGRAPH
	{0xBDED,	0x8E2B},	// CJK UNIFIED IDEOGRAPH
	{0xBDEE,	0x8E10},	// CJK UNIFIED IDEOGRAPH
	{0xBDEF,	0x8E1D},	// CJK UNIFIED IDEOGRAPH
	{0xBDF0,	0x8E22},	// CJK UNIFIED IDEOGRAPH
	{0xBDF1,	0x8E0F},	// CJK UNIFIED IDEOGRAPH
	{0xBDF2,	0x8E29},	// CJK UNIFIED IDEOGRAPH
	{0xBDF3,	0x8E1F},	// CJK UNIFIED IDEOGRAPH
	{0xBDF4,	0x8E21},	// CJK UNIFIED IDEOGRAPH
	{0xBDF5,	0x8E1E},	// CJK UNIFIED IDEOGRAPH
	{0xBDF6,	0x8EBA},	// CJK UNIFIED IDEOGRAPH
	{0xBDF7,	0x8F1D},	// CJK UNIFIED IDEOGRAPH
	{0xBDF8,	0x8F1B},	// CJK UNIFIED IDEOGRAPH
	{0xBDF9,	0x8F1F},	// CJK UNIFIED IDEOGRAPH
	{0xBDFA,	0x8F29},	// CJK UNIFIED IDEOGRAPH
	{0xBDFB,	0x8F26},	// CJK UNIFIED IDEOGRAPH
	{0xBDFC,	0x8F2A},	// CJK UNIFIED IDEOGRAPH
	{0xBDFD,	0x8F1C},	// CJK UNIFIED IDEOGRAPH
	{0xBDFE,	0x8F1E},	// CJK UNIFIED IDEOGRAPH
	{0xBE40,	0x8F25},	// CJK UNIFIED IDEOGRAPH
	{0xBE41,	0x9069},	// CJK UNIFIED IDEOGRAPH
	{0xBE42,	0x906E},	// CJK UNIFIED IDEOGRAPH
	{0xBE43,	0x9068},	// CJK UNIFIED IDEOGRAPH
	{0xBE44,	0x906D},	// CJK UNIFIED IDEOGRAPH
	{0xBE45,	0x9077},	// CJK UNIFIED IDEOGRAPH
	{0xBE46,	0x9130},	// CJK UNIFIED IDEOGRAPH
	{0xBE47,	0x912D},	// CJK UNIFIED IDEOGRAPH
	{0xBE48,	0x9127},	// CJK UNIFIED IDEOGRAPH
	{0xBE49,	0x9131},	// CJK UNIFIED IDEOGRAPH
	{0xBE4A,	0x9187},	// CJK UNIFIED IDEOGRAPH
	{0xBE4B,	0x9189},	// CJK UNIFIED IDEOGRAPH
	{0xBE4C,	0x918B},	// CJK UNIFIED IDEOGRAPH
	{0xBE4D,	0x9183},	// CJK UNIFIED IDEOGRAPH
	{0xBE4E,	0x92C5},	// CJK UNIFIED IDEOGRAPH
	{0xBE4F,	0x92BB},	// CJK UNIFIED IDEOGRAPH
	{0xBE50,	0x92B7},	// CJK UNIFIED IDEOGRAPH
	{0xBE51,	0x92EA},	// CJK UNIFIED IDEOGRAPH
	{0xBE52,	0x92AC},	// CJK UNIFIED IDEOGRAPH
	{0xBE53,	0x92E4},	// CJK UNIFIED IDEOGRAPH
	{0xBE54,	0x92C1},	// CJK UNIFIED IDEOGRAPH
	{0xBE55,	0x92B3},	// CJK UNIFIED IDEOGRAPH
	{0xBE56,	0x92BC},	// CJK UNIFIED IDEOGRAPH
	{0xBE57,	0x92D2},	// CJK UNIFIED IDEOGRAPH
	{0xBE58,	0x92C7},	// CJK UNIFIED IDEOGRAPH
	{0xBE59,	0x92F0},	// CJK UNIFIED IDEOGRAPH
	{0xBE5A,	0x92B2},	// CJK UNIFIED IDEOGRAPH
	{0xBE5B,	0x95AD},	// CJK UNIFIED IDEOGRAPH
	{0xBE5C,	0x95B1},	// CJK UNIFIED IDEOGRAPH
	{0xBE5D,	0x9704},	// CJK UNIFIED IDEOGRAPH
	{0xBE5E,	0x9706},	// CJK UNIFIED IDEOGRAPH
	{0xBE5F,	0x9707},	// CJK UNIFIED IDEOGRAPH
	{0xBE60,	0x9709},	// CJK UNIFIED IDEOGRAPH
	{0xBE61,	0x9760},	// CJK UNIFIED IDEOGRAPH
	{0xBE62,	0x978D},	// CJK UNIFIED IDEOGRAPH
	{0xBE63,	0x978B},	// CJK UNIFIED IDEOGRAPH
	{0xBE64,	0x978F},	// CJK UNIFIED IDEOGRAPH
	{0xBE65,	0x9821},	// CJK UNIFIED IDEOGRAPH
	{0xBE66,	0x982B},	// CJK UNIFIED IDEOGRAPH
	{0xBE67,	0x981C},	// CJK UNIFIED IDEOGRAPH
	{0xBE68,	0x98B3},	// CJK UNIFIED IDEOGRAPH
	{0xBE69,	0x990A},	// CJK UNIFIED IDEOGRAPH
	{0xBE6A,	0x9913},	// CJK UNIFIED IDEOGRAPH
	{0xBE6B,	0x9912},	// CJK UNIFIED IDEOGRAPH
	{0xBE6C,	0x9918},	// CJK UNIFIED IDEOGRAPH
	{0xBE6D,	0x99DD},	// CJK UNIFIED IDEOGRAPH
	{0xBE6E,	0x99D0},	// CJK UNIFIED IDEOGRAPH
	{0xBE6F,	0x99DF},	// CJK UNIFIED IDEOGRAPH
	{0xBE70,	0x99DB},	// CJK UNIFIED IDEOGRAPH
	{0xBE71,	0x99D1},	// CJK UNIFIED IDEOGRAPH
	{0xBE72,	0x99D5},	// CJK UNIFIED IDEOGRAPH
	{0xBE73,	0x99D2},	// CJK UNIFIED IDEOGRAPH
	{0xBE74,	0x99D9},	// CJK UNIFIED IDEOGRAPH
	{0xBE75,	0x9AB7},	// CJK UNIFIED IDEOGRAPH
	{0xBE76,	0x9AEE},	// CJK UNIFIED IDEOGRAPH
	{0xBE77,	0x9AEF},	// CJK UNIFIED IDEOGRAPH
	{0xBE78,	0x9B27},	// CJK UNIFIED IDEOGRAPH
	{0xBE79,	0x9B45},	// CJK UNIFIED IDEOGRAPH
	{0xBE7A,	0x9B44},	// CJK UNIFIED IDEOGRAPH
	{0xBE7B,	0x9B77},	// CJK UNIFIED IDEOGRAPH
	{0xBE7C,	0x9B6F},	// CJK UNIFIED IDEOGRAPH
	{0xBE7D,	0x9D06},	// CJK UNIFIED IDEOGRAPH
	{0xBE7E,	0x9D09},	// CJK UNIFIED IDEOGRAPH
	{0xBEA1,	0x9D03},	// CJK UNIFIED IDEOGRAPH
	{0xBEA2,	0x9EA9},	// CJK UNIFIED IDEOGRAPH
	{0xBEA3,	0x9EBE},	// CJK UNIFIED IDEOGRAPH
	{0xBEA4,	0x9ECE},	// CJK UNIFIED IDEOGRAPH
	{0xBEA5,	0x58A8},	// CJK UNIFIED IDEOGRAPH
	{0xBEA6,	0x9F52},	// CJK UNIFIED IDEOGRAPH
	{0xBEA7,	0x5112},	// CJK UNIFIED IDEOGRAPH
	{0xBEA8,	0x5118},	// CJK UNIFIED IDEOGRAPH
	{0xBEA9,	0x5114},	// CJK UNIFIED IDEOGRAPH
	{0xBEAA,	0x5110},	// CJK UNIFIED IDEOGRAPH
	{0xBEAB,	0x5115},	// CJK UNIFIED IDEOGRAPH
	{0xBEAC,	0x5180},	// CJK UNIFIED IDEOGRAPH
	{0xBEAD,	0x51AA},	// CJK UNIFIED IDEOGRAPH
	{0xBEAE,	0x51DD},	// CJK UNIFIED IDEOGRAPH
	{0xBEAF,	0x5291},	// CJK UNIFIED IDEOGRAPH
	{0xBEB0,	0x5293},	// CJK UNIFIED IDEOGRAPH
	{0xBEB1,	0x52F3},	// CJK UNIFIED IDEOGRAPH
	{0xBEB2,	0x5659},	// CJK UNIFIED IDEOGRAPH
	{0xBEB3,	0x566B},	// CJK UNIFIED IDEOGRAPH
	{0xBEB4,	0x5679},	// CJK UNIFIED IDEOGRAPH
	{0xBEB5,	0x5669},	// CJK UNIFIED IDEOGRAPH
	{0xBEB6,	0x5664},	// CJK UNIFIED IDEOGRAPH
	{0xBEB7,	0x5678},	// CJK UNIFIED IDEOGRAPH
	{0xBEB8,	0x566A},	// CJK UNIFIED IDEOGRAPH
	{0xBEB9,	0x5668},	// CJK UNIFIED IDEOGRAPH
	{0xBEBA,	0x5665},	// CJK UNIFIED IDEOGRAPH
	{0xBEBB,	0x5671},	// CJK UNIFIED IDEOGRAPH
	{0xBEBC,	0x566F},	// CJK UNIFIED IDEOGRAPH
	{0xBEBD,	0x566C},	// CJK UNIFIED IDEOGRAPH
	{0xBEBE,	0x5662},	// CJK UNIFIED IDEOGRAPH
	{0xBEBF,	0x5676},	// CJK UNIFIED IDEOGRAPH
	{0xBEC0,	0x58C1},	// CJK UNIFIED IDEOGRAPH
	{0xBEC1,	0x58BE},	// CJK UNIFIED IDEOGRAPH
	{0xBEC2,	0x58C7},	// CJK UNIFIED IDEOGRAPH
	{0xBEC3,	0x58C5},	// CJK UNIFIED IDEOGRAPH
	{0xBEC4,	0x596E},	// CJK UNIFIED IDEOGRAPH
	{0xBEC5,	0x5B1D},	// CJK UNIFIED IDEOGRAPH
	{0xBEC6,	0x5B34},	// CJK UNIFIED IDEOGRAPH
	{0xBEC7,	0x5B78},	// CJK UNIFIED IDEOGRAPH
	{0xBEC8,	0x5BF0},	// CJK UNIFIED IDEOGRAPH
	{0xBEC9,	0x5C0E},	// CJK UNIFIED IDEOGRAPH
	{0xBECA,	0x5F4A},	// CJK UNIFIED IDEOGRAPH
	{0xBECB,	0x61B2},	// CJK UNIFIED IDEOGRAPH
	{0xBECC,	0x6191},	// CJK UNIFIED IDEOGRAPH
	{0xBECD,	0x61A9},	// CJK UNIFIED IDEOGRAPH
	{0xBECE,	0x618A},	// CJK UNIFIED IDEOGRAPH
	{0xBECF,	0x61CD},	// CJK UNIFIED IDEOGRAPH
	{0xBED0,	0x61B6},	// CJK UNIFIED IDEOGRAPH
	{0xBED1,	0x61BE},	// CJK UNIFIED IDEOGRAPH
	{0xBED2,	0x61CA},	// CJK UNIFIED IDEOGRAPH
	{0xBED3,	0x61C8},	// CJK UNIFIED IDEOGRAPH
	{0xBED4,	0x6230},	// CJK UNIFIED IDEOGRAPH
	{0xBED5,	0x64C5},	// CJK UNIFIED IDEOGRAPH
	{0xBED6,	0x64C1},	// CJK UNIFIED IDEOGRAPH
	{0xBED7,	0x64CB},	// CJK UNIFIED IDEOGRAPH
	{0xBED8,	0x64BB},	// CJK UNIFIED IDEOGRAPH
	{0xBED9,	0x64BC},	// CJK UNIFIED IDEOGRAPH
	{0xBEDA,	0x64DA},	// CJK UNIFIED IDEOGRAPH
	{0xBEDB,	0x64C4},	// CJK UNIFIED IDEOGRAPH
	{0xBEDC,	0x64C7},	// CJK UNIFIED IDEOGRAPH
	{0xBEDD,	0x64C2},	// CJK UNIFIED IDEOGRAPH
	{0xBEDE,	0x64CD},	// CJK UNIFIED IDEOGRAPH
	{0xBEDF,	0x64BF},	// CJK UNIFIED IDEOGRAPH
	{0xBEE0,	0x64D2},	// CJK UNIFIED IDEOGRAPH
	{0xBEE1,	0x64D4},	// CJK UNIFIED IDEOGRAPH
	{0xBEE2,	0x64BE},	// CJK UNIFIED IDEOGRAPH
	{0xBEE3,	0x6574},	// CJK UNIFIED IDEOGRAPH
	{0xBEE4,	0x66C6},	// CJK UNIFIED IDEOGRAPH
	{0xBEE5,	0x66C9},	// CJK UNIFIED IDEOGRAPH
	{0xBEE6,	0x66B9},	// CJK UNIFIED IDEOGRAPH
	{0xBEE7,	0x66C4},	// CJK UNIFIED IDEOGRAPH
	{0xBEE8,	0x66C7},	// CJK UNIFIED IDEOGRAPH
	{0xBEE9,	0x66B8},	// CJK UNIFIED IDEOGRAPH
	{0xBEEA,	0x6A3D},	// CJK UNIFIED IDEOGRAPH
	{0xBEEB,	0x6A38},	// CJK UNIFIED IDEOGRAPH
	{0xBEEC,	0x6A3A},	// CJK UNIFIED IDEOGRAPH
	{0xBEED,	0x6A59},	// CJK UNIFIED IDEOGRAPH
	{0xBEEE,	0x6A6B},	// CJK UNIFIED IDEOGRAPH
	{0xBEEF,	0x6A58},	// CJK UNIFIED IDEOGRAPH
	{0xBEF0,	0x6A39},	// CJK UNIFIED IDEOGRAPH
	{0xBEF1,	0x6A44},	// CJK UNIFIED IDEOGRAPH
	{0xBEF2,	0x6A62},	// CJK UNIFIED IDEOGRAPH
	{0xBEF3,	0x6A61},	// CJK UNIFIED IDEOGRAPH
	{0xBEF4,	0x6A4B},	// CJK UNIFIED IDEOGRAPH
	{0xBEF5,	0x6A47},	// CJK UNIFIED IDEOGRAPH
	{0xBEF6,	0x6A35},	// CJK UNIFIED IDEOGRAPH
	{0xBEF7,	0x6A5F},	// CJK UNIFIED IDEOGRAPH
	{0xBEF8,	0x6A48},	// CJK UNIFIED IDEOGRAPH
	{0xBEF9,	0x6B59},	// CJK UNIFIED IDEOGRAPH
	{0xBEFA,	0x6B77},	// CJK UNIFIED IDEOGRAPH
	{0xBEFB,	0x6C05},	// CJK UNIFIED IDEOGRAPH
	{0xBEFC,	0x6FC2},	// CJK UNIFIED IDEOGRAPH
	{0xBEFD,	0x6FB1},	// CJK UNIFIED IDEOGRAPH
	{0xBEFE,	0x6FA1},	// CJK UNIFIED IDEOGRAPH
	{0xBF40,	0x6FC3},	// CJK UNIFIED IDEOGRAPH
	{0xBF41,	0x6FA4},	// CJK UNIFIED IDEOGRAPH
	{0xBF42,	0x6FC1},	// CJK UNIFIED IDEOGRAPH
	{0xBF43,	0x6FA7},	// CJK UNIFIED IDEOGRAPH
	{0xBF44,	0x6FB3},	// CJK UNIFIED IDEOGRAPH
	{0xBF45,	0x6FC0},	// CJK UNIFIED IDEOGRAPH
	{0xBF46,	0x6FB9},	// CJK UNIFIED IDEOGRAPH
	{0xBF47,	0x6FB6},	// CJK UNIFIED IDEOGRAPH
	{0xBF48,	0x6FA6},	// CJK UNIFIED IDEOGRAPH
	{0xBF49,	0x6FA0},	// CJK UNIFIED IDEOGRAPH
	{0xBF4A,	0x6FB4},	// CJK UNIFIED IDEOGRAPH
	{0xBF4B,	0x71BE},	// CJK UNIFIED IDEOGRAPH
	{0xBF4C,	0x71C9},	// CJK UNIFIED IDEOGRAPH
	{0xBF4D,	0x71D0},	// CJK UNIFIED IDEOGRAPH
	{0xBF4E,	0x71D2},	// CJK UNIFIED IDEOGRAPH
	{0xBF4F,	0x71C8},	// CJK UNIFIED IDEOGRAPH
	{0xBF50,	0x71D5},	// CJK UNIFIED IDEOGRAPH
	{0xBF51,	0x71B9},	// CJK UNIFIED IDEOGRAPH
	{0xBF52,	0x71CE},	// CJK UNIFIED IDEOGRAPH
	{0xBF53,	0x71D9},	// CJK UNIFIED IDEOGRAPH
	{0xBF54,	0x71DC},	// CJK UNIFIED IDEOGRAPH
	{0xBF55,	0x71C3},	// CJK UNIFIED IDEOGRAPH
	{0xBF56,	0x71C4},	// CJK UNIFIED IDEOGRAPH
	{0xBF57,	0x7368},	// CJK UNIFIED IDEOGRAPH
	{0xBF58,	0x749C},	// CJK UNIFIED IDEOGRAPH
	{0xBF59,	0x74A3},	// CJK UNIFIED IDEOGRAPH
	{0xBF5A,	0x7498},	// CJK UNIFIED IDEOGRAPH
	{0xBF5B,	0x749F},	// CJK UNIFIED IDEOGRAPH
	{0xBF5C,	0x749E},	// CJK UNIFIED IDEOGRAPH
	{0xBF5D,	0x74E2},	// CJK UNIFIED IDEOGRAPH
	{0xBF5E,	0x750C},	// CJK UNIFIED IDEOGRAPH
	{0xBF5F,	0x750D},	// CJK UNIFIED IDEOGRAPH
	{0xBF60,	0x7634},	// CJK UNIFIED IDEOGRAPH
	{0xBF61,	0x7638},	// CJK UNIFIED IDEOGRAPH
	{0xBF62,	0x763A},	// CJK UNIFIED IDEOGRAPH
	{0xBF63,	0x76E7},	// CJK UNIFIED IDEOGRAPH
	{0xBF64,	0x76E5},	// CJK UNIFIED IDEOGRAPH
	{0xBF65,	0x77A0},	// CJK UNIFIED IDEOGRAPH
	{0xBF66,	0x779E},	// CJK UNIFIED IDEOGRAPH
	{0xBF67,	0x779F},	// CJK UNIFIED IDEOGRAPH
	{0xBF68,	0x77A5},	// CJK UNIFIED IDEOGRAPH
	{0xBF69,	0x78E8},	// CJK UNIFIED IDEOGRAPH
	{0xBF6A,	0x78DA},	// CJK UNIFIED IDEOGRAPH
	{0xBF6B,	0x78EC},	// CJK UNIFIED IDEOGRAPH
	{0xBF6C,	0x78E7},	// CJK UNIFIED IDEOGRAPH
	{0xBF6D,	0x79A6},	// CJK UNIFIED IDEOGRAPH
	{0xBF6E,	0x7A4D},	// CJK UNIFIED IDEOGRAPH
	{0xBF6F,	0x7A4E},	// CJK UNIFIED IDEOGRAPH
	{0xBF70,	0x7A46},	// CJK UNIFIED IDEOGRAPH
	{0xBF71,	0x7A4C},	// CJK UNIFIED IDEOGRAPH
	{0xBF72,	0x7A4B},	// CJK UNIFIED IDEOGRAPH
	{0xBF73,	0x7ABA},	// CJK UNIFIED IDEOGRAPH
	{0xBF74,	0x7BD9},	// CJK UNIFIED IDEOGRAPH
	{0xBF75,	0x7C11},	// CJK UNIFIED IDEOGRAPH
	{0xBF76,	0x7BC9},	// CJK UNIFIED IDEOGRAPH
	{0xBF77,	0x7BE4},	// CJK UNIFIED IDEOGRAPH
	{0xBF78,	0x7BDB},	// CJK UNIFIED IDEOGRAPH
	{0xBF79,	0x7BE1},	// CJK UNIFIED IDEOGRAPH
	{0xBF7A,	0x7BE9},	// CJK UNIFIED IDEOGRAPH
	{0xBF7B,	0x7BE6},	// CJK UNIFIED IDEOGRAPH
	{0xBF7C,	0x7CD5},	// CJK UNIFIED IDEOGRAPH
	{0xBF7D,	0x7CD6},	// CJK UNIFIED IDEOGRAPH
	{0xBF7E,	0x7E0A},	// CJK UNIFIED IDEOGRAPH
	{0xBFA1,	0x7E11},	// CJK UNIFIED IDEOGRAPH
	{0xBFA2,	0x7E08},	// CJK UNIFIED IDEOGRAPH
	{0xBFA3,	0x7E1B},	// CJK UNIFIED IDEOGRAPH
	{0xBFA4,	0x7E23},	// CJK UNIFIED IDEOGRAPH
	{0xBFA5,	0x7E1E},	// CJK UNIFIED IDEOGRAPH
	{0xBFA6,	0x7E1D},	// CJK UNIFIED IDEOGRAPH
	{0xBFA7,	0x7E09},	// CJK UNIFIED IDEOGRAPH
	{0xBFA8,	0x7E10},	// CJK UNIFIED IDEOGRAPH
	{0xBFA9,	0x7F79},	// CJK UNIFIED IDEOGRAPH
	{0xBFAA,	0x7FB2},	// CJK UNIFIED IDEOGRAPH
	{0xBFAB,	0x7FF0},	// CJK UNIFIED IDEOGRAPH
	{0xBFAC,	0x7FF1},	// CJK UNIFIED IDEOGRAPH
	{0xBFAD,	0x7FEE},	// CJK UNIFIED IDEOGRAPH
	{0xBFAE,	0x8028},	// CJK UNIFIED IDEOGRAPH
	{0xBFAF,	0x81B3},	// CJK UNIFIED IDEOGRAPH
	{0xBFB0,	0x81A9},	// CJK UNIFIED IDEOGRAPH
	{0xBFB1,	0x81A8},	// CJK UNIFIED IDEOGRAPH
	{0xBFB2,	0x81FB},	// CJK UNIFIED IDEOGRAPH
	{0xBFB3,	0x8208},	// CJK UNIFIED IDEOGRAPH
	{0xBFB4,	0x8258},	// CJK UNIFIED IDEOGRAPH
	{0xBFB5,	0x8259},	// CJK UNIFIED IDEOGRAPH
	{0xBFB6,	0x854A},	// CJK UNIFIED IDEOGRAPH
	{0xBFB7,	0x8559},	// CJK UNIFIED IDEOGRAPH
	{0xBFB8,	0x8548},	// CJK UNIFIED IDEOGRAPH
	{0xBFB9,	0x8568},	// CJK UNIFIED IDEOGRAPH
	{0xBFBA,	0x8569},	// CJK UNIFIED IDEOGRAPH
	{0xBFBB,	0x8543},	// CJK UNIFIED IDEOGRAPH
	{0xBFBC,	0x8549},	// CJK UNIFIED IDEOGRAPH
	{0xBFBD,	0x856D},	// CJK UNIFIED IDEOGRAPH
	{0xBFBE,	0x856A},	// CJK UNIFIED IDEOGRAPH
	{0xBFBF,	0x855E},	// CJK UNIFIED IDEOGRAPH
	{0xBFC0,	0x8783},	// CJK UNIFIED IDEOGRAPH
	{0xBFC1,	0x879F},	// CJK UNIFIED IDEOGRAPH
	{0xBFC2,	0x879E},	// CJK UNIFIED IDEOGRAPH
	{0xBFC3,	0x87A2},	// CJK UNIFIED IDEOGRAPH
	{0xBFC4,	0x878D},	// CJK UNIFIED IDEOGRAPH
	{0xBFC5,	0x8861},	// CJK UNIFIED IDEOGRAPH
	{0xBFC6,	0x892A},	// CJK UNIFIED IDEOGRAPH
	{0xBFC7,	0x8932},	// CJK UNIFIED IDEOGRAPH
	{0xBFC8,	0x8925},	// CJK UNIFIED IDEOGRAPH
	{0xBFC9,	0x892B},	// CJK UNIFIED IDEOGRAPH
	{0xBFCA,	0x8921},	// CJK UNIFIED IDEOGRAPH
	{0xBFCB,	0x89AA},	// CJK UNIFIED IDEOGRAPH
	{0xBFCC,	0x89A6},	// CJK UNIFIED IDEOGRAPH
	{0xBFCD,	0x8AE6},	// CJK UNIFIED IDEOGRAPH
	{0xBFCE,	0x8AFA},	// CJK UNIFIED IDEOGRAPH
	{0xBFCF,	0x8AEB},	// CJK UNIFIED IDEOGRAPH
	{0xBFD0,	0x8AF1},	// CJK UNIFIED IDEOGRAPH
	{0xBFD1,	0x8B00},	// CJK UNIFIED IDEOGRAPH
	{0xBFD2,	0x8ADC},	// CJK UNIFIED IDEOGRAPH
	{0xBFD3,	0x8AE7},	// CJK UNIFIED IDEOGRAPH
	{0xBFD4,	0x8AEE},	// CJK UNIFIED IDEOGRAPH
	{0xBFD5,	0x8AFE},	// CJK UNIFIED IDEOGRAPH
	{0xBFD6,	0x8B01},	// CJK UNIFIED IDEOGRAPH
	{0xBFD7,	0x8B02},	// CJK UNIFIED IDEOGRAPH
	{0xBFD8,	0x8AF7},	// CJK UNIFIED IDEOGRAPH
	{0xBFD9,	0x8AED},	// CJK UNIFIED IDEOGRAPH
	{0xBFDA,	0x8AF3},	// CJK UNIFIED IDEOGRAPH
	{0xBFDB,	0x8AF6},	// CJK UNIFIED IDEOGRAPH
	{0xBFDC,	0x8AFC},	// CJK UNIFIED IDEOGRAPH
	{0xBFDD,	0x8C6B},	// CJK UNIFIED IDEOGRAPH
	{0xBFDE,	0x8C6D},	// CJK UNIFIED IDEOGRAPH
	{0xBFDF,	0x8C93},	// CJK UNIFIED IDEOGRAPH
	{0xBFE0,	0x8CF4},	// CJK UNIFIED IDEOGRAPH
	{0xBFE1,	0x8E44},	// CJK UNIFIED IDEOGRAPH
	{0xBFE2,	0x8E31},	// CJK UNIFIED IDEOGRAPH
	{0xBFE3,	0x8E34},	// CJK UNIFIED IDEOGRAPH
	{0xBFE4,	0x8E42},	// CJK UNIFIED IDEOGRAPH
	{0xBFE5,	0x8E39},	// CJK UNIFIED IDEOGRAPH
	{0xBFE6,	0x8E35},	// CJK UNIFIED IDEOGRAPH
	{0xBFE7,	0x8F3B},	// CJK UNIFIED IDEOGRAPH
	{0xBFE8,	0x8F2F},	// CJK UNIFIED IDEOGRAPH
	{0xBFE9,	0x8F38},	// CJK UNIFIED IDEOGRAPH
	{0xBFEA,	0x8F33},	// CJK UNIFIED IDEOGRAPH
	{0xBFEB,	0x8FA8},	// CJK UNIFIED IDEOGRAPH
	{0xBFEC,	0x8FA6},	// CJK UNIFIED IDEOGRAPH
	{0xBFED,	0x9075},	// CJK UNIFIED IDEOGRAPH
	{0xBFEE,	0x9074},	// CJK UNIFIED IDEOGRAPH
	{0xBFEF,	0x9078},	// CJK UNIFIED IDEOGRAPH
	{0xBFF0,	0x9072},	// CJK UNIFIED IDEOGRAPH
	{0xBFF1,	0x907C},	// CJK UNIFIED IDEOGRAPH
	{0xBFF2,	0x907A},	// CJK UNIFIED IDEOGRAPH
	{0xBFF3,	0x9134},	// CJK UNIFIED IDEOGRAPH
	{0xBFF4,	0x9192},	// CJK UNIFIED IDEOGRAPH
	{0xBFF5,	0x9320},	// CJK UNIFIED IDEOGRAPH
	{0xBFF6,	0x9336},	// CJK UNIFIED IDEOGRAPH
	{0xBFF7,	0x92F8},	// CJK UNIFIED IDEOGRAPH
	{0xBFF8,	0x9333},	// CJK UNIFIED IDEOGRAPH
	{0xBFF9,	0x932F},	// CJK UNIFIED IDEOGRAPH
	{0xBFFA,	0x9322},	// CJK UNIFIED IDEOGRAPH
	{0xBFFB,	0x92FC},	// CJK UNIFIED IDEOGRAPH
	{0xBFFC,	0x932B},	// CJK UNIFIED IDEOGRAPH
	{0xBFFD,	0x9304},	// CJK UNIFIED IDEOGRAPH
	{0xBFFE,	0x931A},	// CJK UNIFIED IDEOGRAPH
	{0xC040,	0x9310},	// CJK UNIFIED IDEOGRAPH
	{0xC041,	0x9326},	// CJK UNIFIED IDEOGRAPH
	{0xC042,	0x9321},	// CJK UNIFIED IDEOGRAPH
	{0xC043,	0x9315},	// CJK UNIFIED IDEOGRAPH
	{0xC044,	0x932E},	// CJK UNIFIED IDEOGRAPH
	{0xC045,	0x9319},	// CJK UNIFIED IDEOGRAPH
	{0xC046,	0x95BB},	// CJK UNIFIED IDEOGRAPH
	{0xC047,	0x96A7},	// CJK UNIFIED IDEOGRAPH
	{0xC048,	0x96A8},	// CJK UNIFIED IDEOGRAPH
	{0xC049,	0x96AA},	// CJK UNIFIED IDEOGRAPH
	{0xC04A,	0x96D5},	// CJK UNIFIED IDEOGRAPH
	{0xC04B,	0x970E},	// CJK UNIFIED IDEOGRAPH
	{0xC04C,	0x9711},	// CJK UNIFIED IDEOGRAPH
	{0xC04D,	0x9716},	// CJK UNIFIED IDEOGRAPH
	{0xC04E,	0x970D},	// CJK UNIFIED IDEOGRAPH
	{0xC04F,	0x9713},	// CJK UNIFIED IDEOGRAPH
	{0xC050,	0x970F},	// CJK UNIFIED IDEOGRAPH
	{0xC051,	0x975B},	// CJK UNIFIED IDEOGRAPH
	{0xC052,	0x975C},	// CJK UNIFIED IDEOGRAPH
	{0xC053,	0x9766},	// CJK UNIFIED IDEOGRAPH
	{0xC054,	0x9798},	// CJK UNIFIED IDEOGRAPH
	{0xC055,	0x9830},	// CJK UNIFIED IDEOGRAPH
	{0xC056,	0x9838},	// CJK UNIFIED IDEOGRAPH
	{0xC057,	0x983B},	// CJK UNIFIED IDEOGRAPH
	{0xC058,	0x9837},	// CJK UNIFIED IDEOGRAPH
	{0xC059,	0x982D},	// CJK UNIFIED IDEOGRAPH
	{0xC05A,	0x9839},	// CJK UNIFIED IDEOGRAPH
	{0xC05B,	0x9824},	// CJK UNIFIED IDEOGRAPH
	{0xC05C,	0x9910},	// CJK UNIFIED IDEOGRAPH
	{0xC05D,	0x9928},	// CJK UNIFIED IDEOGRAPH
	{0xC05E,	0x991E},	// CJK UNIFIED IDEOGRAPH
	{0xC05F,	0x991B},	// CJK UNIFIED IDEOGRAPH
	{0xC060,	0x9921},	// CJK UNIFIED IDEOGRAPH
	{0xC061,	0x991A},	// CJK UNIFIED IDEOGRAPH
	{0xC062,	0x99ED},	// CJK UNIFIED IDEOGRAPH
	{0xC063,	0x99E2},	// CJK UNIFIED IDEOGRAPH
	{0xC064,	0x99F1},	// CJK UNIFIED IDEOGRAPH
	{0xC065,	0x9AB8},	// CJK UNIFIED IDEOGRAPH
	{0xC066,	0x9ABC},	// CJK UNIFIED IDEOGRAPH
	{0xC067,	0x9AFB},	// CJK UNIFIED IDEOGRAPH
	{0xC068,	0x9AED},	// CJK UNIFIED IDEOGRAPH
	{0xC069,	0x9B28},	// CJK UNIFIED IDEOGRAPH
	{0xC06A,	0x9B91},	// CJK UNIFIED IDEOGRAPH
	{0xC06B,	0x9D15},	// CJK UNIFIED IDEOGRAPH
	{0xC06C,	0x9D23},	// CJK UNIFIED IDEOGRAPH
	{0xC06D,	0x9D26},	// CJK UNIFIED IDEOGRAPH
	{0xC06E,	0x9D28},	// CJK UNIFIED IDEOGRAPH
	{0xC06F,	0x9D12},	// CJK UNIFIED IDEOGRAPH
	{0xC070,	0x9D1B},	// CJK UNIFIED IDEOGRAPH
	{0xC071,	0x9ED8},	// CJK UNIFIED IDEOGRAPH
	{0xC072,	0x9ED4},	// CJK UNIFIED IDEOGRAPH
	{0xC073,	0x9F8D},	// CJK UNIFIED IDEOGRAPH
	{0xC074,	0x9F9C},	// CJK UNIFIED IDEOGRAPH
	{0xC075,	0x512A},	// CJK UNIFIED IDEOGRAPH
	{0xC076,	0x511F},	// CJK UNIFIED IDEOGRAPH
	{0xC077,	0x5121},	// CJK UNIFIED IDEOGRAPH
	{0xC078,	0x5132},	// CJK UNIFIED IDEOGRAPH
	{0xC079,	0x52F5},	// CJK UNIFIED IDEOGRAPH
	{0xC07A,	0x568E},	// CJK UNIFIED IDEOGRAPH
	{0xC07B,	0x5680},	// CJK UNIFIED IDEOGRAPH
	{0xC07C,	0x5690},	// CJK UNIFIED IDEOGRAPH
	{0xC07D,	0x5685},	// CJK UNIFIED IDEOGRAPH
	{0xC07E,	0x5687},	// CJK UNIFIED IDEOGRAPH
	{0xC0A1,	0x568F},	// CJK UNIFIED IDEOGRAPH
	{0xC0A2,	0x58D5},	// CJK UNIFIED IDEOGRAPH
	{0xC0A3,	0x58D3},	// CJK UNIFIED IDEOGRAPH
	{0xC0A4,	0x58D1},	// CJK UNIFIED IDEOGRAPH
	{0xC0A5,	0x58CE},	// CJK UNIFIED IDEOGRAPH
	{0xC0A6,	0x5B30},	// CJK UNIFIED IDEOGRAPH
	{0xC0A7,	0x5B2A},	// CJK UNIFIED IDEOGRAPH
	{0xC0A8,	0x5B24},	// CJK UNIFIED IDEOGRAPH
	{0xC0A9,	0x5B7A},	// CJK UNIFIED IDEOGRAPH
	{0xC0AA,	0x5C37},	// CJK UNIFIED IDEOGRAPH
	{0xC0AB,	0x5C68},	// CJK UNIFIED IDEOGRAPH
	{0xC0AC,	0x5DBC},	// CJK UNIFIED IDEOGRAPH
	{0xC0AD,	0x5DBA},	// CJK UNIFIED IDEOGRAPH
	{0xC0AE,	0x5DBD},	// CJK UNIFIED IDEOGRAPH
	{0xC0AF,	0x5DB8},	// CJK UNIFIED IDEOGRAPH
	{0xC0B0,	0x5E6B},	// CJK UNIFIED IDEOGRAPH
	{0xC0B1,	0x5F4C},	// CJK UNIFIED IDEOGRAPH
	{0xC0B2,	0x5FBD},	// CJK UNIFIED IDEOGRAPH
	{0xC0B3,	0x61C9},	// CJK UNIFIED IDEOGRAPH
	{0xC0B4,	0x61C2},	// CJK UNIFIED IDEOGRAPH
	{0xC0B5,	0x61C7},	// CJK UNIFIED IDEOGRAPH
	{0xC0B6,	0x61E6},	// CJK UNIFIED IDEOGRAPH
	{0xC0B7,	0x61CB},	// CJK UNIFIED IDEOGRAPH
	{0xC0B8,	0x6232},	// CJK UNIFIED IDEOGRAPH
	{0xC0B9,	0x6234},	// CJK UNIFIED IDEOGRAPH
	{0xC0BA,	0x64CE},	// CJK UNIFIED IDEOGRAPH
	{0xC0BB,	0x64CA},	// CJK UNIFIED IDEOGRAPH
	{0xC0BC,	0x64D8},	// CJK UNIFIED IDEOGRAPH
	{0xC0BD,	0x64E0},	// CJK UNIFIED IDEOGRAPH
	{0xC0BE,	0x64F0},	// CJK UNIFIED IDEOGRAPH
	{0xC0BF,	0x64E6},	// CJK UNIFIED IDEOGRAPH
	{0xC0C0,	0x64EC},	// CJK UNIFIED IDEOGRAPH
	{0xC0C1,	0x64F1},	// CJK UNIFIED IDEOGRAPH
	{0xC0C2,	0x64E2},	// CJK UNIFIED IDEOGRAPH
	{0xC0C3,	0x64ED},	// CJK UNIFIED IDEOGRAPH
	{0xC0C4,	0x6582},	// CJK UNIFIED IDEOGRAPH
	{0xC0C5,	0x6583},	// CJK UNIFIED IDEOGRAPH
	{0xC0C6,	0x66D9},	// CJK UNIFIED IDEOGRAPH
	{0xC0C7,	0x66D6},	// CJK UNIFIED IDEOGRAPH
	{0xC0C8,	0x6A80},	// CJK UNIFIED IDEOGRAPH
	{0xC0C9,	0x6A94},	// CJK UNIFIED IDEOGRAPH
	{0xC0CA,	0x6A84},	// CJK UNIFIED IDEOGRAPH
	{0xC0CB,	0x6AA2},	// CJK UNIFIED IDEOGRAPH
	{0xC0CC,	0x6A9C},	// CJK UNIFIED IDEOGRAPH
	{0xC0CD,	0x6ADB},	// CJK UNIFIED IDEOGRAPH
	{0xC0CE,	0x6AA3},	// CJK UNIFIED IDEOGRAPH
	{0xC0CF,	0x6A7E},	// CJK UNIFIED IDEOGRAPH
	{0xC0D0,	0x6A97},	// CJK UNIFIED IDEOGRAPH
	{0xC0D1,	0x6A90},	// CJK UNIFIED IDEOGRAPH
	{0xC0D2,	0x6AA0},	// CJK UNIFIED IDEOGRAPH
	{0xC0D3,	0x6B5C},	// CJK UNIFIED IDEOGRAPH
	{0xC0D4,	0x6BAE},	// CJK UNIFIED IDEOGRAPH
	{0xC0D5,	0x6BDA},	// CJK UNIFIED IDEOGRAPH
	{0xC0D6,	0x6C08},	// CJK UNIFIED IDEOGRAPH
	{0xC0D7,	0x6FD8},	// CJK UNIFIED IDEOGRAPH
	{0xC0D8,	0x6FF1},	// CJK UNIFIED IDEOGRAPH
	{0xC0D9,	0x6FDF},	// CJK UNIFIED IDEOGRAPH
	{0xC0DA,	0x6FE0},	// CJK UNIFIED IDEOGRAPH
	{0xC0DB,	0x6FDB},	// CJK UNIFIED IDEOGRAPH
	{0xC0DC,	0x6FE4},	// CJK UNIFIED IDEOGRAPH
	{0xC0DD,	0x6FEB},	// CJK UNIFIED IDEOGRAPH
	{0xC0DE,	0x6FEF},	// CJK UNIFIED IDEOGRAPH
	{0xC0DF,	0x6F80},	// CJK UNIFIED IDEOGRAPH
	{0xC0E0,	0x6FEC},	// CJK UNIFIED IDEOGRAPH
	{0xC0E1,	0x6FE1},	// CJK UNIFIED IDEOGRAPH
	{0xC0E2,	0x6FE9},	// CJK UNIFIED IDEOGRAPH
	{0xC0E3,	0x6FD5},	// CJK UNIFIED IDEOGRAPH
	{0xC0E4,	0x6FEE},	// CJK UNIFIED IDEOGRAPH
	{0xC0E5,	0x6FF0},	// CJK UNIFIED IDEOGRAPH
	{0xC0E6,	0x71E7},	// CJK UNIFIED IDEOGRAPH
	{0xC0E7,	0x71DF},	// CJK UNIFIED IDEOGRAPH
	{0xC0E8,	0x71EE},	// CJK UNIFIED IDEOGRAPH
	{0xC0E9,	0x71E6},	// CJK UNIFIED IDEOGRAPH
	{0xC0EA,	0x71E5},	// CJK UNIFIED IDEOGRAPH
	{0xC0EB,	0x71ED},	// CJK UNIFIED IDEOGRAPH
	{0xC0EC,	0x71EC},	// CJK UNIFIED IDEOGRAPH
	{0xC0ED,	0x71F4},	// CJK UNIFIED IDEOGRAPH
	{0xC0EE,	0x71E0},	// CJK UNIFIED IDEOGRAPH
	{0xC0EF,	0x7235},	// CJK UNIFIED IDEOGRAPH
	{0xC0F0,	0x7246},	// CJK UNIFIED IDEOGRAPH
	{0xC0F1,	0x7370},	// CJK UNIFIED IDEOGRAPH
	{0xC0F2,	0x7372},	// CJK UNIFIED IDEOGRAPH
	{0xC0F3,	0x74A9},	// CJK UNIFIED IDEOGRAPH
	{0xC0F4,	0x74B0},	// CJK UNIFIED IDEOGRAPH
	{0xC0F5,	0x74A6},	// CJK UNIFIED IDEOGRAPH
	{0xC0F6,	0x74A8},	// CJK UNIFIED IDEOGRAPH
	{0xC0F7,	0x7646},	// CJK UNIFIED IDEOGRAPH
	{0xC0F8,	0x7642},	// CJK UNIFIED IDEOGRAPH
	{0xC0F9,	0x764C},	// CJK UNIFIED IDEOGRAPH
	{0xC0FA,	0x76EA},	// CJK UNIFIED IDEOGRAPH
	{0xC0FB,	0x77B3},	// CJK UNIFIED IDEOGRAPH
	{0xC0FC,	0x77AA},	// CJK UNIFIED IDEOGRAPH
	{0xC0FD,	0x77B0},	// CJK UNIFIED IDEOGRAPH
	{0xC0FE,	0x77AC},	// CJK UNIFIED IDEOGRAPH
	{0xC140,	0x77A7},	// CJK UNIFIED IDEOGRAPH
	{0xC141,	0x77AD},	// CJK UNIFIED IDEOGRAPH
	{0xC142,	0x77EF},	// CJK UNIFIED IDEOGRAPH
	{0xC143,	0x78F7},	// CJK UNIFIED IDEOGRAPH
	{0xC144,	0x78FA},	// CJK UNIFIED IDEOGRAPH
	{0xC145,	0x78F4},	// CJK UNIFIED IDEOGRAPH
	{0xC146,	0x78EF},	// CJK UNIFIED IDEOGRAPH
	{0xC147,	0x7901},	// CJK UNIFIED IDEOGRAPH
	{0xC148,	0x79A7},	// CJK UNIFIED IDEOGRAPH
	{0xC149,	0x79AA},	// CJK UNIFIED IDEOGRAPH
	{0xC14A,	0x7A57},	// CJK UNIFIED IDEOGRAPH
	{0xC14B,	0x7ABF},	// CJK UNIFIED IDEOGRAPH
	{0xC14C,	0x7C07},	// CJK UNIFIED IDEOGRAPH
	{0xC14D,	0x7C0D},	// CJK UNIFIED IDEOGRAPH
	{0xC14E,	0x7BFE},	// CJK UNIFIED IDEOGRAPH
	{0xC14F,	0x7BF7},	// CJK UNIFIED IDEOGRAPH
	{0xC150,	0x7C0C},	// CJK UNIFIED IDEOGRAPH
	{0xC151,	0x7BE0},	// CJK UNIFIED IDEOGRAPH
	{0xC152,	0x7CE0},	// CJK UNIFIED IDEOGRAPH
	{0xC153,	0x7CDC},	// CJK UNIFIED IDEOGRAPH
	{0xC154,	0x7CDE},	// CJK UNIFIED IDEOGRAPH
	{0xC155,	0x7CE2},	// CJK UNIFIED IDEOGRAPH
	{0xC156,	0x7CDF},	// CJK UNIFIED IDEOGRAPH
	{0xC157,	0x7CD9},	// CJK UNIFIED IDEOGRAPH
	{0xC158,	0x7CDD},	// CJK UNIFIED IDEOGRAPH
	{0xC159,	0x7E2E},	// CJK UNIFIED IDEOGRAPH
	{0xC15A,	0x7E3E},	// CJK UNIFIED IDEOGRAPH
	{0xC15B,	0x7E46},	// CJK UNIFIED IDEOGRAPH
	{0xC15C,	0x7E37},	// CJK UNIFIED IDEOGRAPH
	{0xC15D,	0x7E32},	// CJK UNIFIED IDEOGRAPH
	{0xC15E,	0x7E43},	// CJK UNIFIED IDEOGRAPH
	{0xC15F,	0x7E2B},	// CJK UNIFIED IDEOGRAPH
	{0xC160,	0x7E3D},	// CJK UNIFIED IDEOGRAPH
	{0xC161,	0x7E31},	// CJK UNIFIED IDEOGRAPH
	{0xC162,	0x7E45},	// CJK UNIFIED IDEOGRAPH
	{0xC163,	0x7E41},	// CJK UNIFIED IDEOGRAPH
	{0xC164,	0x7E34},	// CJK UNIFIED IDEOGRAPH
	{0xC165,	0x7E39},	// CJK UNIFIED IDEOGRAPH
	{0xC166,	0x7E48},	// CJK UNIFIED IDEOGRAPH
	{0xC167,	0x7E35},	// CJK UNIFIED IDEOGRAPH
	{0xC168,	0x7E3F},	// CJK UNIFIED IDEOGRAPH
	{0xC169,	0x7E2F},	// CJK UNIFIED IDEOGRAPH
	{0xC16A,	0x7F44},	// CJK UNIFIED IDEOGRAPH
	{0xC16B,	0x7FF3},	// CJK UNIFIED IDEOGRAPH
	{0xC16C,	0x7FFC},	// CJK UNIFIED IDEOGRAPH
	{0xC16D,	0x8071},	// CJK UNIFIED IDEOGRAPH
	{0xC16E,	0x8072},	// CJK UNIFIED IDEOGRAPH
	{0xC16F,	0x8070},	// CJK UNIFIED IDEOGRAPH
	{0xC170,	0x806F},	// CJK UNIFIED IDEOGRAPH
	{0xC171,	0x8073},	// CJK UNIFIED IDEOGRAPH
	{0xC172,	0x81C6},	// CJK UNIFIED IDEOGRAPH
	{0xC173,	0x81C3},	// CJK UNIFIED IDEOGRAPH
	{0xC174,	0x81BA},	// CJK UNIFIED IDEOGRAPH
	{0xC175,	0x81C2},	// CJK UNIFIED IDEOGRAPH
	{0xC176,	0x81C0},	// CJK UNIFIED IDEOGRAPH
	{0xC177,	0x81BF},	// CJK UNIFIED IDEOGRAPH
	{0xC178,	0x81BD},	// CJK UNIFIED IDEOGRAPH
	{0xC179,	0x81C9},	// CJK UNIFIED IDEOGRAPH
	{0xC17A,	0x81BE},	// CJK UNIFIED IDEOGRAPH
	{0xC17B,	0x81E8},	// CJK UNIFIED IDEOGRAPH
	{0xC17C,	0x8209},	// CJK UNIFIED IDEOGRAPH
	{0xC17D,	0x8271},	// CJK UNIFIED IDEOGRAPH
	{0xC17E,	0x85AA},	// CJK UNIFIED IDEOGRAPH
	{0xC1A1,	0x8584},	// CJK UNIFIED IDEOGRAPH
	{0xC1A2,	0x857E},	// CJK UNIFIED IDEOGRAPH
	{0xC1A3,	0x859C},	// CJK UNIFIED IDEOGRAPH
	{0xC1A4,	0x8591},	// CJK UNIFIED IDEOGRAPH
	{0xC1A5,	0x8594},	// CJK UNIFIED IDEOGRAPH
	{0xC1A6,	0x85AF},	// CJK UNIFIED IDEOGRAPH
	{0xC1A7,	0x859B},	// CJK UNIFIED IDEOGRAPH
	{0xC1A8,	0x8587},	// CJK UNIFIED IDEOGRAPH
	{0xC1A9,	0x85A8},	// CJK UNIFIED IDEOGRAPH
	{0xC1AA,	0x858A},	// CJK UNIFIED IDEOGRAPH
	{0xC1AB,	0x8667},	// CJK UNIFIED IDEOGRAPH
	{0xC1AC,	0x87C0},	// CJK UNIFIED IDEOGRAPH
	{0xC1AD,	0x87D1},	// CJK UNIFIED IDEOGRAPH
	{0xC1AE,	0x87B3},	// CJK UNIFIED IDEOGRAPH
	{0xC1AF,	0x87D2},	// CJK UNIFIED IDEOGRAPH
	{0xC1B0,	0x87C6},	// CJK UNIFIED IDEOGRAPH
	{0xC1B1,	0x87AB},	// CJK UNIFIED IDEOGRAPH
	{0xC1B2,	0x87BB},	// CJK UNIFIED IDEOGRAPH
	{0xC1B3,	0x87BA},	// CJK UNIFIED IDEOGRAPH
	{0xC1B4,	0x87C8},	// CJK UNIFIED IDEOGRAPH
	{0xC1B5,	0x87CB},	// CJK UNIFIED IDEOGRAPH
	{0xC1B6,	0x893B},	// CJK UNIFIED IDEOGRAPH
	{0xC1B7,	0x8936},	// CJK UNIFIED IDEOGRAPH
	{0xC1B8,	0x8944},	// CJK UNIFIED IDEOGRAPH
	{0xC1B9,	0x8938},	// CJK UNIFIED IDEOGRAPH
	{0xC1BA,	0x893D},	// CJK UNIFIED IDEOGRAPH
	{0xC1BB,	0x89AC},	// CJK UNIFIED IDEOGRAPH
	{0xC1BC,	0x8B0E},	// CJK UNIFIED IDEOGRAPH
	{0xC1BD,	0x8B17},	// CJK UNIFIED IDEOGRAPH
	{0xC1BE,	0x8B19},	// CJK UNIFIED IDEOGRAPH
	{0xC1BF,	0x8B1B},	// CJK UNIFIED IDEOGRAPH
	{0xC1C0,	0x8B0A},	// CJK UNIFIED IDEOGRAPH
	{0xC1C1,	0x8B20},	// CJK UNIFIED IDEOGRAPH
	{0xC1C2,	0x8B1D},	// CJK UNIFIED IDEOGRAPH
	{0xC1C3,	0x8B04},	// CJK UNIFIED IDEOGRAPH
	{0xC1C4,	0x8B10},	// CJK UNIFIED IDEOGRAPH
	{0xC1C5,	0x8C41},	// CJK UNIFIED IDEOGRAPH
	{0xC1C6,	0x8C3F},	// CJK UNIFIED IDEOGRAPH
	{0xC1C7,	0x8C73},	// CJK UNIFIED IDEOGRAPH
	{0xC1C8,	0x8CFA},	// CJK UNIFIED IDEOGRAPH
	{0xC1C9,	0x8CFD},	// CJK UNIFIED IDEOGRAPH
	{0xC1CA,	0x8CFC},	// CJK UNIFIED IDEOGRAPH
	{0xC1CB,	0x8CF8},	// CJK UNIFIED IDEOGRAPH
	{0xC1CC,	0x8CFB},	// CJK UNIFIED IDEOGRAPH
	{0xC1CD,	0x8DA8},	// CJK UNIFIED IDEOGRAPH
	{0xC1CE,	0x8E49},	// CJK UNIFIED IDEOGRAPH
	{0xC1CF,	0x8E4B},	// CJK UNIFIED IDEOGRAPH
	{0xC1D0,	0x8E48},	// CJK UNIFIED IDEOGRAPH
	{0xC1D1,	0x8E4A},	// CJK UNIFIED IDEOGRAPH
	{0xC1D2,	0x8F44},	// CJK UNIFIED IDEOGRAPH
	{0xC1D3,	0x8F3E},	// CJK UNIFIED IDEOGRAPH
	{0xC1D4,	0x8F42},	// CJK UNIFIED IDEOGRAPH
	{0xC1D5,	0x8F45},	// CJK UNIFIED IDEOGRAPH
	{0xC1D6,	0x8F3F},	// CJK UNIFIED IDEOGRAPH
	{0xC1D7,	0x907F},	// CJK UNIFIED IDEOGRAPH
	{0xC1D8,	0x907D},	// CJK UNIFIED IDEOGRAPH
	{0xC1D9,	0x9084},	// CJK UNIFIED IDEOGRAPH
	{0xC1DA,	0x9081},	// CJK UNIFIED IDEOGRAPH
	{0xC1DB,	0x9082},	// CJK UNIFIED IDEOGRAPH
	{0xC1DC,	0x9080},	// CJK UNIFIED IDEOGRAPH
	{0xC1DD,	0x9139},	// CJK UNIFIED IDEOGRAPH
	{0xC1DE,	0x91A3},	// CJK UNIFIED IDEOGRAPH
	{0xC1DF,	0x919E},	// CJK UNIFIED IDEOGRAPH
	{0xC1E0,	0x919C},	// CJK UNIFIED IDEOGRAPH
	{0xC1E1,	0x934D},	// CJK UNIFIED IDEOGRAPH
	{0xC1E2,	0x9382},	// CJK UNIFIED IDEOGRAPH
	{0xC1E3,	0x9328},	// CJK UNIFIED IDEOGRAPH
	{0xC1E4,	0x9375},	// CJK UNIFIED IDEOGRAPH
	{0xC1E5,	0x934A},	// CJK UNIFIED IDEOGRAPH
	{0xC1E6,	0x9365},	// CJK UNIFIED IDEOGRAPH
	{0xC1E7,	0x934B},	// CJK UNIFIED IDEOGRAPH
	{0xC1E8,	0x9318},	// CJK UNIFIED IDEOGRAPH
	{0xC1E9,	0x937E},	// CJK UNIFIED IDEOGRAPH
	{0xC1EA,	0x936C},	// CJK UNIFIED IDEOGRAPH
	{0xC1EB,	0x935B},	// CJK UNIFIED IDEOGRAPH
	{0xC1EC,	0x9370},	// CJK UNIFIED IDEOGRAPH
	{0xC1ED,	0x935A},	// CJK UNIFIED IDEOGRAPH
	{0xC1EE,	0x9354},	// CJK UNIFIED IDEOGRAPH
	{0xC1EF,	0x95CA},	// CJK UNIFIED IDEOGRAPH
	{0xC1F0,	0x95CB},	// CJK UNIFIED IDEOGRAPH
	{0xC1F1,	0x95CC},	// CJK UNIFIED IDEOGRAPH
	{0xC1F2,	0x95C8},	// CJK UNIFIED IDEOGRAPH
	{0xC1F3,	0x95C6},	// CJK UNIFIED IDEOGRAPH
	{0xC1F4,	0x96B1},	// CJK UNIFIED IDEOGRAPH
	{0xC1F5,	0x96B8},	// CJK UNIFIED IDEOGRAPH
	{0xC1F6,	0x96D6},	// CJK UNIFIED IDEOGRAPH
	{0xC1F7,	0x971C},	// CJK UNIFIED IDEOGRAPH
	{0xC1F8,	0x971E},	// CJK UNIFIED IDEOGRAPH
	{0xC1F9,	0x97A0},	// CJK UNIFIED IDEOGRAPH
	{0xC1FA,	0x97D3},	// CJK UNIFIED IDEOGRAPH
	{0xC1FB,	0x9846},	// CJK UNIFIED IDEOGRAPH
	{0xC1FC,	0x98B6},	// CJK UNIFIED IDEOGRAPH
	{0xC1FD,	0x9935},	// CJK UNIFIED IDEOGRAPH
	{0xC1FE,	0x9A01},	// CJK UNIFIED IDEOGRAPH
	{0xC240,	0x99FF},	// CJK UNIFIED IDEOGRAPH
	{0xC241,	0x9BAE},	// CJK UNIFIED IDEOGRAPH
	{0xC242,	0x9BAB},	// CJK UNIFIED IDEOGRAPH
	{0xC243,	0x9BAA},	// CJK UNIFIED IDEOGRAPH
	{0xC244,	0x9BAD},	// CJK UNIFIED IDEOGRAPH
	{0xC245,	0x9D3B},	// CJK UNIFIED IDEOGRAPH
	{0xC246,	0x9D3F},	// CJK UNIFIED IDEOGRAPH
	{0xC247,	0x9E8B},	// CJK UNIFIED IDEOGRAPH
	{0xC248,	0x9ECF},	// CJK UNIFIED IDEOGRAPH
	{0xC249,	0x9EDE},	// CJK UNIFIED IDEOGRAPH
	{0xC24A,	0x9EDC},	// CJK UNIFIED IDEOGRAPH
	{0xC24B,	0x9EDD},	// CJK UNIFIED IDEOGRAPH
	{0xC24C,	0x9EDB},	// CJK UNIFIED IDEOGRAPH
	{0xC24D,	0x9F3E},	// CJK UNIFIED IDEOGRAPH
	{0xC24E,	0x9F4B},	// CJK UNIFIED IDEOGRAPH
	{0xC24F,	0x53E2},	// CJK UNIFIED IDEOGRAPH
	{0xC250,	0x5695},	// CJK UNIFIED IDEOGRAPH
	{0xC251,	0x56AE},	// CJK UNIFIED IDEOGRAPH
	{0xC252,	0x58D9},	// CJK UNIFIED IDEOGRAPH
	{0xC253,	0x58D8},	// CJK UNIFIED IDEOGRAPH
	{0xC254,	0x5B38},	// CJK UNIFIED IDEOGRAPH
	{0xC255,	0x5F5D},	// CJK UNIFIED IDEOGRAPH
	{0xC256,	0x61E3},	// CJK UNIFIED IDEOGRAPH
	{0xC257,	0x6233},	// CJK UNIFIED IDEOGRAPH
	{0xC258,	0x64F4},	// CJK UNIFIED IDEOGRAPH
	{0xC259,	0x64F2},	// CJK UNIFIED IDEOGRAPH
	{0xC25A,	0x64FE},	// CJK UNIFIED IDEOGRAPH
	{0xC25B,	0x6506},	// CJK UNIFIED IDEOGRAPH
	{0xC25C,	0x64FA},	// CJK UNIFIED IDEOGRAPH
	{0xC25D,	0x64FB},	// CJK UNIFIED IDEOGRAPH
	{0xC25E,	0x64F7},	// CJK UNIFIED IDEOGRAPH
	{0xC25F,	0x65B7},	// CJK UNIFIED IDEOGRAPH
	{0xC260,	0x66DC},	// CJK UNIFIED IDEOGRAPH
	{0xC261,	0x6726},	// CJK UNIFIED IDEOGRAPH
	{0xC262,	0x6AB3},	// CJK UNIFIED IDEOGRAPH
	{0xC263,	0x6AAC},	// CJK UNIFIED IDEOGRAPH
	{0xC264,	0x6AC3},	// CJK UNIFIED IDEOGRAPH
	{0xC265,	0x6ABB},	// CJK UNIFIED IDEOGRAPH
	{0xC266,	0x6AB8},	// CJK UNIFIED IDEOGRAPH
	{0xC267,	0x6AC2},	// CJK UNIFIED IDEOGRAPH
	{0xC268,	0x6AAE},	// CJK UNIFIED IDEOGRAPH
	{0xC269,	0x6AAF},	// CJK UNIFIED IDEOGRAPH
	{0xC26A,	0x6B5F},	// CJK UNIFIED IDEOGRAPH
	{0xC26B,	0x6B78},	// CJK UNIFIED IDEOGRAPH
	{0xC26C,	0x6BAF},	// CJK UNIFIED IDEOGRAPH
	{0xC26D,	0x7009},	// CJK UNIFIED IDEOGRAPH
	{0xC26E,	0x700B},	// CJK UNIFIED IDEOGRAPH
	{0xC26F,	0x6FFE},	// CJK UNIFIED IDEOGRAPH
	{0xC270,	0x7006},	// CJK UNIFIED IDEOGRAPH
	{0xC271,	0x6FFA},	// CJK UNIFIED IDEOGRAPH
	{0xC272,	0x7011},	// CJK UNIFIED IDEOGRAPH
	{0xC273,	0x700F},	// CJK UNIFIED IDEOGRAPH
	{0xC274,	0x71FB},	// CJK UNIFIED IDEOGRAPH
	{0xC275,	0x71FC},	// CJK UNIFIED IDEOGRAPH
	{0xC276,	0x71FE},	// CJK UNIFIED IDEOGRAPH
	{0xC277,	0x71F8},	// CJK UNIFIED IDEOGRAPH
	{0xC278,	0x7377},	// CJK UNIFIED IDEOGRAPH
	{0xC279,	0x7375},	// CJK UNIFIED IDEOGRAPH
	{0xC27A,	0x74A7},	// CJK UNIFIED IDEOGRAPH
	{0xC27B,	0x74BF},	// CJK UNIFIED IDEOGRAPH
	{0xC27C,	0x7515},	// CJK UNIFIED IDEOGRAPH
	{0xC27D,	0x7656},	// CJK UNIFIED IDEOGRAPH
	{0xC27E,	0x7658},	// CJK UNIFIED IDEOGRAPH
	{0xC2A1,	0x7652},	// CJK UNIFIED IDEOGRAPH
	{0xC2A2,	0x77BD},	// CJK UNIFIED IDEOGRAPH
	{0xC2A3,	0x77BF},	// CJK UNIFIED IDEOGRAPH
	{0xC2A4,	0x77BB},	// CJK UNIFIED IDEOGRAPH
	{0xC2A5,	0x77BC},	// CJK UNIFIED IDEOGRAPH
	{0xC2A6,	0x790E},	// CJK UNIFIED IDEOGRAPH
	{0xC2A7,	0x79AE},	// CJK UNIFIED IDEOGRAPH
	{0xC2A8,	0x7A61},	// CJK UNIFIED IDEOGRAPH
	{0xC2A9,	0x7A62},	// CJK UNIFIED IDEOGRAPH
	{0xC2AA,	0x7A60},	// CJK UNIFIED IDEOGRAPH
	{0xC2AB,	0x7AC4},	// CJK UNIFIED IDEOGRAPH
	{0xC2AC,	0x7AC5},	// CJK UNIFIED IDEOGRAPH
	{0xC2AD,	0x7C2B},	// CJK UNIFIED IDEOGRAPH
	{0xC2AE,	0x7C27},	// CJK UNIFIED IDEOGRAPH
	{0xC2AF,	0x7C2A},	// CJK UNIFIED IDEOGRAPH
	{0xC2B0,	0x7C1E},	// CJK UNIFIED IDEOGRAPH
	{0xC2B1,	0x7C23},	// CJK UNIFIED IDEOGRAPH
	{0xC2B2,	0x7C21},	// CJK UNIFIED IDEOGRAPH
	{0xC2B3,	0x7CE7},	// CJK UNIFIED IDEOGRAPH
	{0xC2B4,	0x7E54},	// CJK UNIFIED IDEOGRAPH
	{0xC2B5,	0x7E55},	// CJK UNIFIED IDEOGRAPH
	{0xC2B6,	0x7E5E},	// CJK UNIFIED IDEOGRAPH
	{0xC2B7,	0x7E5A},	// CJK UNIFIED IDEOGRAPH
	{0xC2B8,	0x7E61},	// CJK UNIFIED IDEOGRAPH
	{0xC2B9,	0x7E52},	// CJK UNIFIED IDEOGRAPH
	{0xC2BA,	0x7E59},	// CJK UNIFIED IDEOGRAPH
	{0xC2BB,	0x7F48},	// CJK UNIFIED IDEOGRAPH
	{0xC2BC,	0x7FF9},	// CJK UNIFIED IDEOGRAPH
	{0xC2BD,	0x7FFB},	// CJK UNIFIED IDEOGRAPH
	{0xC2BE,	0x8077},	// CJK UNIFIED IDEOGRAPH
	{0xC2BF,	0x8076},	// CJK UNIFIED IDEOGRAPH
	{0xC2C0,	0x81CD},	// CJK UNIFIED IDEOGRAPH
	{0xC2C1,	0x81CF},	// CJK UNIFIED IDEOGRAPH
	{0xC2C2,	0x820A},	// CJK UNIFIED IDEOGRAPH
	{0xC2C3,	0x85CF},	// CJK UNIFIED IDEOGRAPH
	{0xC2C4,	0x85A9},	// CJK UNIFIED IDEOGRAPH
	{0xC2C5,	0x85CD},	// CJK UNIFIED IDEOGRAPH
	{0xC2C6,	0x85D0},	// CJK UNIFIED IDEOGRAPH
	{0xC2C7,	0x85C9},	// CJK UNIFIED IDEOGRAPH
	{0xC2C8,	0x85B0},	// CJK UNIFIED IDEOGRAPH
	{0xC2C9,	0x85BA},	// CJK UNIFIED IDEOGRAPH
	{0xC2CA,	0x85B9},	// CJK UNIFIED IDEOGRAPH
	{0xC2CB,	0x85A6},	// CJK UNIFIED IDEOGRAPH
	{0xC2CC,	0x87EF},	// CJK UNIFIED IDEOGRAPH
	{0xC2CD,	0x87EC},	// CJK UNIFIED IDEOGRAPH
	{0xC2CE,	0x87F2},	// CJK UNIFIED IDEOGRAPH
	{0xC2CF,	0x87E0},	// CJK UNIFIED IDEOGRAPH
	{0xC2D0,	0x8986},	// CJK UNIFIED IDEOGRAPH
	{0xC2D1,	0x89B2},	// CJK UNIFIED IDEOGRAPH
	{0xC2D2,	0x89F4},	// CJK UNIFIED IDEOGRAPH
	{0xC2D3,	0x8B28},	// CJK UNIFIED IDEOGRAPH
	{0xC2D4,	0x8B39},	// CJK UNIFIED IDEOGRAPH
	{0xC2D5,	0x8B2C},	// CJK UNIFIED IDEOGRAPH
	{0xC2D6,	0x8B2B},	// CJK UNIFIED IDEOGRAPH
	{0xC2D7,	0x8C50},	// CJK UNIFIED IDEOGRAPH
	{0xC2D8,	0x8D05},	// CJK UNIFIED IDEOGRAPH
	{0xC2D9,	0x8E59},	// CJK UNIFIED IDEOGRAPH
	{0xC2DA,	0x8E63},	// CJK UNIFIED IDEOGRAPH
	{0xC2DB,	0x8E66},	// CJK UNIFIED IDEOGRAPH
	{0xC2DC,	0x8E64},	// CJK UNIFIED IDEOGRAPH
	{0xC2DD,	0x8E5F},	// CJK UNIFIED IDEOGRAPH
	{0xC2DE,	0x8E55},	// CJK UNIFIED IDEOGRAPH
	{0xC2DF,	0x8EC0},	// CJK UNIFIED IDEOGRAPH
	{0xC2E0,	0x8F49},	// CJK UNIFIED IDEOGRAPH
	{0xC2E1,	0x8F4D},	// CJK UNIFIED IDEOGRAPH
	{0xC2E2,	0x9087},	// CJK UNIFIED IDEOGRAPH
	{0xC2E3,	0x9083},	// CJK UNIFIED IDEOGRAPH
	{0xC2E4,	0x9088},	// CJK UNIFIED IDEOGRAPH
	{0xC2E5,	0x91AB},	// CJK UNIFIED IDEOGRAPH
	{0xC2E6,	0x91AC},	// CJK UNIFIED IDEOGRAPH
	{0xC2E7,	0x91D0},	// CJK UNIFIED IDEOGRAPH
	{0xC2E8,	0x9394},	// CJK UNIFIED IDEOGRAPH
	{0xC2E9,	0x938A},	// CJK UNIFIED IDEOGRAPH
	{0xC2EA,	0x9396},	// CJK UNIFIED IDEOGRAPH
	{0xC2EB,	0x93A2},	// CJK UNIFIED IDEOGRAPH
	{0xC2EC,	0x93B3},	// CJK UNIFIED IDEOGRAPH
	{0xC2ED,	0x93AE},	// CJK UNIFIED IDEOGRAPH
	{0xC2EE,	0x93AC},	// CJK UNIFIED IDEOGRAPH
	{0xC2EF,	0x93B0},	// CJK UNIFIED IDEOGRAPH
	{0xC2F0,	0x9398},	// CJK UNIFIED IDEOGRAPH
	{0xC2F1,	0x939A},	// CJK UNIFIED IDEOGRAPH
	{0xC2F2,	0x9397},	// CJK UNIFIED IDEOGRAPH
	{0xC2F3,	0x95D4},	// CJK UNIFIED IDEOGRAPH
	{0xC2F4,	0x95D6},	// CJK UNIFIED IDEOGRAPH
	{0xC2F5,	0x95D0},	// CJK UNIFIED IDEOGRAPH
	{0xC2F6,	0x95D5},	// CJK UNIFIED IDEOGRAPH
	{0xC2F7,	0x96E2},	// CJK UNIFIED IDEOGRAPH
	{0xC2F8,	0x96DC},	// CJK UNIFIED IDEOGRAPH
	{0xC2F9,	0x96D9},	// CJK UNIFIED IDEOGRAPH
	{0xC2FA,	0x96DB},	// CJK UNIFIED IDEOGRAPH
	{0xC2FB,	0x96DE},	// CJK UNIFIED IDEOGRAPH
	{0xC2FC,	0x9724},	// CJK UNIFIED IDEOGRAPH
	{0xC2FD,	0x97A3},	// CJK UNIFIED IDEOGRAPH
	{0xC2FE,	0x97A6},	// CJK UNIFIED IDEOGRAPH
	{0xC340,	0x97AD},	// CJK UNIFIED IDEOGRAPH
	{0xC341,	0x97F9},	// CJK UNIFIED IDEOGRAPH
	{0xC342,	0x984D},	// CJK UNIFIED IDEOGRAPH
	{0xC343,	0x984F},	// CJK UNIFIED IDEOGRAPH
	{0xC344,	0x984C},	// CJK UNIFIED IDEOGRAPH
	{0xC345,	0x984E},	// CJK UNIFIED IDEOGRAPH
	{0xC346,	0x9853},	// CJK UNIFIED IDEOGRAPH
	{0xC347,	0x98BA},	// CJK UNIFIED IDEOGRAPH
	{0xC348,	0x993E},	// CJK UNIFIED IDEOGRAPH
	{0xC349,	0x993F},	// CJK UNIFIED IDEOGRAPH
	{0xC34A,	0x993D},	// CJK UNIFIED IDEOGRAPH
	{0xC34B,	0x992E},	// CJK UNIFIED IDEOGRAPH
	{0xC34C,	0x99A5},	// CJK UNIFIED IDEOGRAPH
	{0xC34D,	0x9A0E},	// CJK UNIFIED IDEOGRAPH
	{0xC34E,	0x9AC1},	// CJK UNIFIED IDEOGRAPH
	{0xC34F,	0x9B03},	// CJK UNIFIED IDEOGRAPH
	{0xC350,	0x9B06},	// CJK UNIFIED IDEOGRAPH
	{0xC351,	0x9B4F},	// CJK UNIFIED IDEOGRAPH
	{0xC352,	0x9B4E},	// CJK UNIFIED IDEOGRAPH
	{0xC353,	0x9B4D},	// CJK UNIFIED IDEOGRAPH
	{0xC354,	0x9BCA},	// CJK UNIFIED IDEOGRAPH
	{0xC355,	0x9BC9},	// CJK UNIFIED IDEOGRAPH
	{0xC356,	0x9BFD},	// CJK UNIFIED IDEOGRAPH
	{0xC357,	0x9BC8},	// CJK UNIFIED IDEOGRAPH
	{0xC358,	0x9BC0},	// CJK UNIFIED IDEOGRAPH
	{0xC359,	0x9D51},	// CJK UNIFIED IDEOGRAPH
	{0xC35A,	0x9D5D},	// CJK UNIFIED IDEOGRAPH
	{0xC35B,	0x9D60},	// CJK UNIFIED IDEOGRAPH
	{0xC35C,	0x9EE0},	// CJK UNIFIED IDEOGRAPH
	{0xC35D,	0x9F15},	// CJK UNIFIED IDEOGRAPH
	{0xC35E,	0x9F2C},	// CJK UNIFIED IDEOGRAPH
	{0xC35F,	0x5133},	// CJK UNIFIED IDEOGRAPH
	{0xC360,	0x56A5},	// CJK UNIFIED IDEOGRAPH
	{0xC361,	0x58DE},	// CJK UNIFIED IDEOGRAPH
	{0xC362,	0x58DF},	// CJK UNIFIED IDEOGRAPH
	{0xC363,	0x58E2},	// CJK UNIFIED IDEOGRAPH
	{0xC364,	0x5BF5},	// CJK UNIFIED IDEOGRAPH
	{0xC365,	0x9F90},	// CJK UNIFIED IDEOGRAPH
	{0xC366,	0x5EEC},	// CJK UNIFIED IDEOGRAPH
	{0xC367,	0x61F2},	// CJK UNIFIED IDEOGRAPH
	{0xC368,	0x61F7},	// CJK UNIFIED IDEOGRAPH
	{0xC369,	0x61F6},	// CJK UNIFIED IDEOGRAPH
	{0xC36A,	0x61F5},	// CJK UNIFIED IDEOGRAPH
	{0xC36B,	0x6500},	// CJK UNIFIED IDEOGRAPH
	{0xC36C,	0x650F},	// CJK UNIFIED IDEOGRAPH
	{0xC36D,	0x66E0},	// CJK UNIFIED IDEOGRAPH
	{0xC36E,	0x66DD},	// CJK UNIFIED IDEOGRAPH
	{0xC36F,	0x6AE5},	// CJK UNIFIED IDEOGRAPH
	{0xC370,	0x6ADD},	// CJK UNIFIED IDEOGRAPH
	{0xC371,	0x6ADA},	// CJK UNIFIED IDEOGRAPH
	{0xC372,	0x6AD3},	// CJK UNIFIED IDEOGRAPH
	{0xC373,	0x701B},	// CJK UNIFIED IDEOGRAPH
	{0xC374,	0x701F},	// CJK UNIFIED IDEOGRAPH
	{0xC375,	0x7028},	// CJK UNIFIED IDEOGRAPH
	{0xC376,	0x701A},	// CJK UNIFIED IDEOGRAPH
	{0xC377,	0x701D},	// CJK UNIFIED IDEOGRAPH
	{0xC378,	0x7015},	// CJK UNIFIED IDEOGRAPH
	{0xC379,	0x7018},	// CJK UNIFIED IDEOGRAPH
	{0xC37A,	0x7206},	// CJK UNIFIED IDEOGRAPH
	{0xC37B,	0x720D},	// CJK UNIFIED IDEOGRAPH
	{0xC37C,	0x7258},	// CJK UNIFIED IDEOGRAPH
	{0xC37D,	0x72A2},	// CJK UNIFIED IDEOGRAPH
	{0xC37E,	0x7378},	// CJK UNIFIED IDEOGRAPH
	{0xC3A1,	0x737A},	// CJK UNIFIED IDEOGRAPH
	{0xC3A2,	0x74BD},	// CJK UNIFIED IDEOGRAPH
	{0xC3A3,	0x74CA},	// CJK UNIFIED IDEOGRAPH
	{0xC3A4,	0x74E3},	// CJK UNIFIED IDEOGRAPH
	{0xC3A5,	0x7587},	// CJK UNIFIED IDEOGRAPH
	{0xC3A6,	0x7586},	// CJK UNIFIED IDEOGRAPH
	{0xC3A7,	0x765F},	// CJK UNIFIED IDEOGRAPH
	{0xC3A8,	0x7661},	// CJK UNIFIED IDEOGRAPH
	{0xC3A9,	0x77C7},	// CJK UNIFIED IDEOGRAPH
	{0xC3AA,	0x7919},	// CJK UNIFIED IDEOGRAPH
	{0xC3AB,	0x79B1},	// CJK UNIFIED IDEOGRAPH
	{0xC3AC,	0x7A6B},	// CJK UNIFIED IDEOGRAPH
	{0xC3AD,	0x7A69},	// CJK UNIFIED IDEOGRAPH
	{0xC3AE,	0x7C3E},	// CJK UNIFIED IDEOGRAPH
	{0xC3AF,	0x7C3F},	// CJK UNIFIED IDEOGRAPH
	{0xC3B0,	0x7C38},	// CJK UNIFIED IDEOGRAPH
	{0xC3B1,	0x7C3D},	// CJK UNIFIED IDEOGRAPH
	{0xC3B2,	0x7C37},	// CJK UNIFIED IDEOGRAPH
	{0xC3B3,	0x7C40},	// CJK UNIFIED IDEOGRAPH
	{0xC3B4,	0x7E6B},	// CJK UNIFIED IDEOGRAPH
	{0xC3B5,	0x7E6D},	// CJK UNIFIED IDEOGRAPH
	{0xC3B6,	0x7E79},	// CJK UNIFIED IDEOGRAPH
	{0xC3B7,	0x7E69},	// CJK UNIFIED IDEOGRAPH
	{0xC3B8,	0x7E6A},	// CJK UNIFIED IDEOGRAPH
	{0xC3B9,	0x7F85},	// CJK UNIFIED IDEOGRAPH
	{0xC3BA,	0x7E73},	// CJK UNIFIED IDEOGRAPH
	{0xC3BB,	0x7FB6},	// CJK UNIFIED IDEOGRAPH
	{0xC3BC,	0x7FB9},	// CJK UNIFIED IDEOGRAPH
	{0xC3BD,	0x7FB8},	// CJK UNIFIED IDEOGRAPH
	{0xC3BE,	0x81D8},	// CJK UNIFIED IDEOGRAPH
	{0xC3BF,	0x85E9},	// CJK UNIFIED IDEOGRAPH
	{0xC3C0,	0x85DD},	// CJK UNIFIED IDEOGRAPH
	{0xC3C1,	0x85EA},	// CJK UNIFIED IDEOGRAPH
	{0xC3C2,	0x85D5},	// CJK UNIFIED IDEOGRAPH
	{0xC3C3,	0x85E4},	// CJK UNIFIED IDEOGRAPH
	{0xC3C4,	0x85E5},	// CJK UNIFIED IDEOGRAPH
	{0xC3C5,	0x85F7},	// CJK UNIFIED IDEOGRAPH
	{0xC3C6,	0x87FB},	// CJK UNIFIED IDEOGRAPH
	{0xC3C7,	0x8805},	// CJK UNIFIED IDEOGRAPH
	{0xC3C8,	0x880D},	// CJK UNIFIED IDEOGRAPH
	{0xC3C9,	0x87F9},	// CJK UNIFIED IDEOGRAPH
	{0xC3CA,	0x87FE},	// CJK UNIFIED IDEOGRAPH
	{0xC3CB,	0x8960},	// CJK UNIFIED IDEOGRAPH
	{0xC3CC,	0x895F},	// CJK UNIFIED IDEOGRAPH
	{0xC3CD,	0x8956},	// CJK UNIFIED IDEOGRAPH
	{0xC3CE,	0x895E},	// CJK UNIFIED IDEOGRAPH
	{0xC3CF,	0x8B41},	// CJK UNIFIED IDEOGRAPH
	{0xC3D0,	0x8B5C},	// CJK UNIFIED IDEOGRAPH
	{0xC3D1,	0x8B58},	// CJK UNIFIED IDEOGRAPH
	{0xC3D2,	0x8B49},	// CJK UNIFIED IDEOGRAPH
	{0xC3D3,	0x8B5A},	// CJK UNIFIED IDEOGRAPH
	{0xC3D4,	0x8B4E},	// CJK UNIFIED IDEOGRAPH
	{0xC3D5,	0x8B4F},	// CJK UNIFIED IDEOGRAPH
	{0xC3D6,	0x8B46},	// CJK UNIFIED IDEOGRAPH
	{0xC3D7,	0x8B59},	// CJK UNIFIED IDEOGRAPH
	{0xC3D8,	0x8D08},	// CJK UNIFIED IDEOGRAPH
	{0xC3D9,	0x8D0A},	// CJK UNIFIED IDEOGRAPH
	{0xC3DA,	0x8E7C},	// CJK UNIFIED IDEOGRAPH
	{0xC3DB,	0x8E72},	// CJK UNIFIED IDEOGRAPH
	{0xC3DC,	0x8E87},	// CJK UNIFIED IDEOGRAPH
	{0xC3DD,	0x8E76},	// CJK UNIFIED IDEOGRAPH
	{0xC3DE,	0x8E6C},	// CJK UNIFIED IDEOGRAPH
	{0xC3DF,	0x8E7A},	// CJK UNIFIED IDEOGRAPH
	{0xC3E0,	0x8E74},	// CJK UNIFIED IDEOGRAPH
	{0xC3E1,	0x8F54},	// CJK UNIFIED IDEOGRAPH
	{0xC3E2,	0x8F4E},	// CJK UNIFIED IDEOGRAPH
	{0xC3E3,	0x8FAD},	// CJK UNIFIED IDEOGRAPH
	{0xC3E4,	0x908A},	// CJK UNIFIED IDEOGRAPH
	{0xC3E5,	0x908B},	// CJK UNIFIED IDEOGRAPH
	{0xC3E6,	0x91B1},	// CJK UNIFIED IDEOGRAPH
	{0xC3E7,	0x91AE},	// CJK UNIFIED IDEOGRAPH
	{0xC3E8,	0x93E1},	// CJK UNIFIED IDEOGRAPH
	{0xC3E9,	0x93D1},	// CJK UNIFIED IDEOGRAPH
	{0xC3EA,	0x93DF},	// CJK UNIFIED IDEOGRAPH
	{0xC3EB,	0x93C3},	// CJK UNIFIED IDEOGRAPH
	{0xC3EC,	0x93C8},	// CJK UNIFIED IDEOGRAPH
	{0xC3ED,	0x93DC},	// CJK UNIFIED IDEOGRAPH
	{0xC3EE,	0x93DD},	// CJK UNIFIED IDEOGRAPH
	{0xC3EF,	0x93D6},	// CJK UNIFIED IDEOGRAPH
	{0xC3F0,	0x93E2},	// CJK UNIFIED IDEOGRAPH
	{0xC3F1,	0x93CD},	// CJK UNIFIED IDEOGRAPH
	{0xC3F2,	0x93D8},	// CJK UNIFIED IDEOGRAPH
	{0xC3F3,	0x93E4},	// CJK UNIFIED IDEOGRAPH
	{0xC3F4,	0x93D7},	// CJK UNIFIED IDEOGRAPH
	{0xC3F5,	0x93E8},	// CJK UNIFIED IDEOGRAPH
	{0xC3F6,	0x95DC},	// CJK UNIFIED IDEOGRAPH
	{0xC3F7,	0x96B4},	// CJK UNIFIED IDEOGRAPH
	{0xC3F8,	0x96E3},	// CJK UNIFIED IDEOGRAPH
	{0xC3F9,	0x972A},	// CJK UNIFIED IDEOGRAPH
	{0xC3FA,	0x9727},	// CJK UNIFIED IDEOGRAPH
	{0xC3FB,	0x9761},	// CJK UNIFIED IDEOGRAPH
	{0xC3FC,	0x97DC},	// CJK UNIFIED IDEOGRAPH
	{0xC3FD,	0x97FB},	// CJK UNIFIED IDEOGRAPH
	{0xC3FE,	0x985E},	// CJK UNIFIED IDEOGRAPH
	{0xC440,	0x9858},	// CJK UNIFIED IDEOGRAPH
	{0xC441,	0x985B},	// CJK UNIFIED IDEOGRAPH
	{0xC442,	0x98BC},	// CJK UNIFIED IDEOGRAPH
	{0xC443,	0x9945},	// CJK UNIFIED IDEOGRAPH
	{0xC444,	0x9949},	// CJK UNIFIED IDEOGRAPH
	{0xC445,	0x9A16},	// CJK UNIFIED IDEOGRAPH
	{0xC446,	0x9A19},	// CJK UNIFIED IDEOGRAPH
	{0xC447,	0x9B0D},	// CJK UNIFIED IDEOGRAPH
	{0xC448,	0x9BE8},	// CJK UNIFIED IDEOGRAPH
	{0xC449,	0x9BE7},	// CJK UNIFIED IDEOGRAPH
	{0xC44A,	0x9BD6},	// CJK UNIFIED IDEOGRAPH
	{0xC44B,	0x9BDB},	// CJK UNIFIED IDEOGRAPH
	{0xC44C,	0x9D89},	// CJK UNIFIED IDEOGRAPH
	{0xC44D,	0x9D61},	// CJK UNIFIED IDEOGRAPH
	{0xC44E,	0x9D72},	// CJK UNIFIED IDEOGRAPH
	{0xC44F,	0x9D6A},	// CJK UNIFIED IDEOGRAPH
	{0xC450,	0x9D6C},	// CJK UNIFIED IDEOGRAPH
	{0xC451,	0x9E92},	// CJK UNIFIED IDEOGRAPH
	{0xC452,	0x9E97},	// CJK UNIFIED IDEOGRAPH
	{0xC453,	0x9E93},	// CJK UNIFIED IDEOGRAPH
	{0xC454,	0x9EB4},	// CJK UNIFIED IDEOGRAPH
	{0xC455,	0x52F8},	// CJK UNIFIED IDEOGRAPH
	{0xC456,	0x56A8},	// CJK UNIFIED IDEOGRAPH
	{0xC457,	0x56B7},	// CJK UNIFIED IDEOGRAPH
	{0xC458,	0x56B6},	// CJK UNIFIED IDEOGRAPH
	{0xC459,	0x56B4},	// CJK UNIFIED IDEOGRAPH
	{0xC45A,	0x56BC},	// CJK UNIFIED IDEOGRAPH
	{0xC45B,	0x58E4},	// CJK UNIFIED IDEOGRAPH
	{0xC45C,	0x5B40},	// CJK UNIFIED IDEOGRAPH
	{0xC45D,	0x5B43},	// CJK UNIFIED IDEOGRAPH
	{0xC45E,	0x5B7D},	// CJK UNIFIED IDEOGRAPH
	{0xC45F,	0x5BF6},	// CJK UNIFIED IDEOGRAPH
	{0xC460,	0x5DC9},	// CJK UNIFIED IDEOGRAPH
	{0xC461,	0x61F8},	// CJK UNIFIED IDEOGRAPH
	{0xC462,	0x61FA},	// CJK UNIFIED IDEOGRAPH
	{0xC463,	0x6518},	// CJK UNIFIED IDEOGRAPH
	{0xC464,	0x6514},	// CJK UNIFIED IDEOGRAPH
	{0xC465,	0x6519},	// CJK UNIFIED IDEOGRAPH
	{0xC466,	0x66E6},	// CJK UNIFIED IDEOGRAPH
	{0xC467,	0x6727},	// CJK UNIFIED IDEOGRAPH
	{0xC468,	0x6AEC},	// CJK UNIFIED IDEOGRAPH
	{0xC469,	0x703E},	// CJK UNIFIED IDEOGRAPH
	{0xC46A,	0x7030},	// CJK UNIFIED IDEOGRAPH
	{0xC46B,	0x7032},	// CJK UNIFIED IDEOGRAPH
	{0xC46C,	0x7210},	// CJK UNIFIED IDEOGRAPH
	{0xC46D,	0x737B},	// CJK UNIFIED IDEOGRAPH
	{0xC46E,	0x74CF},	// CJK UNIFIED IDEOGRAPH
	{0xC46F,	0x7662},	// CJK UNIFIED IDEOGRAPH
	{0xC470,	0x7665},	// CJK UNIFIED IDEOGRAPH
	{0xC471,	0x7926},	// CJK UNIFIED IDEOGRAPH
	{0xC472,	0x792A},	// CJK UNIFIED IDEOGRAPH
	{0xC473,	0x792C},	// CJK UNIFIED IDEOGRAPH
	{0xC474,	0x792B},	// CJK UNIFIED IDEOGRAPH
	{0xC475,	0x7AC7},	// CJK UNIFIED IDEOGRAPH
	{0xC476,	0x7AF6},	// CJK UNIFIED IDEOGRAPH
	{0xC477,	0x7C4C},	// CJK UNIFIED IDEOGRAPH
	{0xC478,	0x7C43},	// CJK UNIFIED IDEOGRAPH
	{0xC479,	0x7C4D},	// CJK UNIFIED IDEOGRAPH
	{0xC47A,	0x7CEF},	// CJK UNIFIED IDEOGRAPH
	{0xC47B,	0x7CF0},	// CJK UNIFIED IDEOGRAPH
	{0xC47C,	0x8FAE},	// CJK UNIFIED IDEOGRAPH
	{0xC47D,	0x7E7D},	// CJK UNIFIED IDEOGRAPH
	{0xC47E,	0x7E7C},	// CJK UNIFIED IDEOGRAPH
	{0xC4A1,	0x7E82},	// CJK UNIFIED IDEOGRAPH
	{0xC4A2,	0x7F4C},	// CJK UNIFIED IDEOGRAPH
	{0xC4A3,	0x8000},	// CJK UNIFIED IDEOGRAPH
	{0xC4A4,	0x81DA},	// CJK UNIFIED IDEOGRAPH
	{0xC4A5,	0x8266},	// CJK UNIFIED IDEOGRAPH
	{0xC4A6,	0x85FB},	// CJK UNIFIED IDEOGRAPH
	{0xC4A7,	0x85F9},	// CJK UNIFIED IDEOGRAPH
	{0xC4A8,	0x8611},	// CJK UNIFIED IDEOGRAPH
	{0xC4A9,	0x85FA},	// CJK UNIFIED IDEOGRAPH
	{0xC4AA,	0x8606},	// CJK UNIFIED IDEOGRAPH
	{0xC4AB,	0x860B},	// CJK UNIFIED IDEOGRAPH
	{0xC4AC,	0x8607},	// CJK UNIFIED IDEOGRAPH
	{0xC4AD,	0x860A},	// CJK UNIFIED IDEOGRAPH
	{0xC4AE,	0x8814},	// CJK UNIFIED IDEOGRAPH
	{0xC4AF,	0x8815},	// CJK UNIFIED IDEOGRAPH
	{0xC4B0,	0x8964},	// CJK UNIFIED IDEOGRAPH
	{0xC4B1,	0x89BA},	// CJK UNIFIED IDEOGRAPH
	{0xC4B2,	0x89F8},	// CJK UNIFIED IDEOGRAPH
	{0xC4B3,	0x8B70},	// CJK UNIFIED IDEOGRAPH
	{0xC4B4,	0x8B6C},	// CJK UNIFIED IDEOGRAPH
	{0xC4B5,	0x8B66},	// CJK UNIFIED IDEOGRAPH
	{0xC4B6,	0x8B6F},	// CJK UNIFIED IDEOGRAPH
	{0xC4B7,	0x8B5F},	// CJK UNIFIED IDEOGRAPH
	{0xC4B8,	0x8B6B},	// CJK UNIFIED IDEOGRAPH
	{0xC4B9,	0x8D0F},	// CJK UNIFIED IDEOGRAPH
	{0xC4BA,	0x8D0D},	// CJK UNIFIED IDEOGRAPH
	{0xC4BB,	0x8E89},	// CJK UNIFIED IDEOGRAPH
	{0xC4BC,	0x8E81},	// CJK UNIFIED IDEOGRAPH
	{0xC4BD,	0x8E85},	// CJK UNIFIED IDEOGRAPH
	{0xC4BE,	0x8E82},	// CJK UNIFIED IDEOGRAPH
	{0xC4BF,	0x91B4},	// CJK UNIFIED IDEOGRAPH
	{0xC4C0,	0x91CB},	// CJK UNIFIED IDEOGRAPH
	{0xC4C1,	0x9418},	// CJK UNIFIED IDEOGRAPH
	{0xC4C2,	0x9403},	// CJK UNIFIED IDEOGRAPH
	{0xC4C3,	0x93FD},	// CJK UNIFIED IDEOGRAPH
	{0xC4C4,	0x95E1},	// CJK UNIFIED IDEOGRAPH
	{0xC4C5,	0x9730},	// CJK UNIFIED IDEOGRAPH
	{0xC4C6,	0x98C4},	// CJK UNIFIED IDEOGRAPH
	{0xC4C7,	0x9952},	// CJK UNIFIED IDEOGRAPH
	{0xC4C8,	0x9951},	// CJK UNIFIED IDEOGRAPH
	{0xC4C9,	0x99A8},	// CJK UNIFIED IDEOGRAPH
	{0xC4CA,	0x9A2B},	// CJK UNIFIED IDEOGRAPH
	{0xC4CB,	0x9A30},	// CJK UNIFIED IDEOGRAPH
	{0xC4CC,	0x9A37},	// CJK UNIFIED IDEOGRAPH
	{0xC4CD,	0x9A35},	// CJK UNIFIED IDEOGRAPH
	{0xC4CE,	0x9C13},	// CJK UNIFIED IDEOGRAPH
	{0xC4CF,	0x9C0D},	// CJK UNIFIED IDEOGRAPH
	{0xC4D0,	0x9E79},	// CJK UNIFIED IDEOGRAPH
	{0xC4D1,	0x9EB5},	// CJK UNIFIED IDEOGRAPH
	{0xC4D2,	0x9EE8},	// CJK UNIFIED IDEOGRAPH
	{0xC4D3,	0x9F2F},	// CJK UNIFIED IDEOGRAPH
	{0xC4D4,	0x9F5F},	// CJK UNIFIED IDEOGRAPH
	{0xC4D5,	0x9F63},	// CJK UNIFIED IDEOGRAPH
	{0xC4D6,	0x9F61},	// CJK UNIFIED IDEOGRAPH
	{0xC4D7,	0x5137},	// CJK UNIFIED IDEOGRAPH
	{0xC4D8,	0x5138},	// CJK UNIFIED IDEOGRAPH
	{0xC4D9,	0x56C1},	// CJK UNIFIED IDEOGRAPH
	{0xC4DA,	0x56C0},	// CJK UNIFIED IDEOGRAPH
	{0xC4DB,	0x56C2},	// CJK UNIFIED IDEOGRAPH
	{0xC4DC,	0x5914},	// CJK UNIFIED IDEOGRAPH
	{0xC4DD,	0x5C6C},	// CJK UNIFIED IDEOGRAPH
	{0xC4DE,	0x5DCD},	// CJK UNIFIED IDEOGRAPH
	{0xC4DF,	0x61FC},	// CJK UNIFIED IDEOGRAPH
	{0xC4E0,	0x61FE},	// CJK UNIFIED IDEOGRAPH
	{0xC4E1,	0x651D},	// CJK UNIFIED IDEOGRAPH
	{0xC4E2,	0x651C},	// CJK UNIFIED IDEOGRAPH
	{0xC4E3,	0x6595},	// CJK UNIFIED IDEOGRAPH
	{0xC4E4,	0x66E9},	// CJK UNIFIED IDEOGRAPH
	{0xC4E5,	0x6AFB},	// CJK UNIFIED IDEOGRAPH
	{0xC4E6,	0x6B04},	// CJK UNIFIED IDEOGRAPH
	{0xC4E7,	0x6AFA},	// CJK UNIFIED IDEOGRAPH
	{0xC4E8,	0x6BB2},	// CJK UNIFIED IDEOGRAPH
	{0xC4E9,	0x704C},	// CJK UNIFIED IDEOGRAPH
	{0xC4EA,	0x721B},	// CJK UNIFIED IDEOGRAPH
	{0xC4EB,	0x72A7},	// CJK UNIFIED IDEOGRAPH
	{0xC4EC,	0x74D6},	// CJK UNIFIED IDEOGRAPH
	{0xC4ED,	0x74D4},	// CJK UNIFIED IDEOGRAPH
	{0xC4EE,	0x7669},	// CJK UNIFIED IDEOGRAPH
	{0xC4EF,	0x77D3},	// CJK UNIFIED IDEOGRAPH
	{0xC4F0,	0x7C50},	// CJK UNIFIED IDEOGRAPH
	{0xC4F1,	0x7E8F},	// CJK UNIFIED IDEOGRAPH
	{0xC4F2,	0x7E8C},	// CJK UNIFIED IDEOGRAPH
	{0xC4F3,	0x7FBC},	// CJK UNIFIED IDEOGRAPH
	{0xC4F4,	0x8617},	// CJK UNIFIED IDEOGRAPH
	{0xC4F5,	0x862D},	// CJK UNIFIED IDEOGRAPH
	{0xC4F6,	0x861A},	// CJK UNIFIED IDEOGRAPH
	{0xC4F7,	0x8823},	// CJK UNIFIED IDEOGRAPH
	{0xC4F8,	0x8822},	// CJK UNIFIED IDEOGRAPH
	{0xC4F9,	0x8821},	// CJK UNIFIED IDEOGRAPH
	{0xC4FA,	0x881F},	// CJK UNIFIED IDEOGRAPH
	{0xC4FB,	0x896A},	// CJK UNIFIED IDEOGRAPH
	{0xC4FC,	0x896C},	// CJK UNIFIED IDEOGRAPH
	{0xC4FD,	0x89BD},	// CJK UNIFIED IDEOGRAPH
	{0xC4FE,	0x8B74},	// CJK UNIFIED IDEOGRAPH
	{0xC540,	0x8B77},	// CJK UNIFIED IDEOGRAPH
	{0xC541,	0x8B7D},	// CJK UNIFIED IDEOGRAPH
	{0xC542,	0x8D13},	// CJK UNIFIED IDEOGRAPH
	{0xC543,	0x8E8A},	// CJK UNIFIED IDEOGRAPH
	{0xC544,	0x8E8D},	// CJK UNIFIED IDEOGRAPH
	{0xC545,	0x8E8B},	// CJK UNIFIED IDEOGRAPH
	{0xC546,	0x8F5F},	// CJK UNIFIED IDEOGRAPH
	{0xC547,	0x8FAF},	// CJK UNIFIED IDEOGRAPH
	{0xC548,	0x91BA},	// CJK UNIFIED IDEOGRAPH
	{0xC549,	0x942E},	// CJK UNIFIED IDEOGRAPH
	{0xC54A,	0x9433},	// CJK UNIFIED IDEOGRAPH
	{0xC54B,	0x9435},	// CJK UNIFIED IDEOGRAPH
	{0xC54C,	0x943A},	// CJK UNIFIED IDEOGRAPH
	{0xC54D,	0x9438},	// CJK UNIFIED IDEOGRAPH
	{0xC54E,	0x9432},	// CJK UNIFIED IDEOGRAPH
	{0xC54F,	0x942B},	// CJK UNIFIED IDEOGRAPH
	{0xC550,	0x95E2},	// CJK UNIFIED IDEOGRAPH
	{0xC551,	0x9738},	// CJK UNIFIED IDEOGRAPH
	{0xC552,	0x9739},	// CJK UNIFIED IDEOGRAPH
	{0xC553,	0x9732},	// CJK UNIFIED IDEOGRAPH
	{0xC554,	0x97FF},	// CJK UNIFIED IDEOGRAPH
	{0xC555,	0x9867},	// CJK UNIFIED IDEOGRAPH
	{0xC556,	0x9865},	// CJK UNIFIED IDEOGRAPH
	{0xC557,	0x9957},	// CJK UNIFIED IDEOGRAPH
	{0xC558,	0x9A45},	// CJK UNIFIED IDEOGRAPH
	{0xC559,	0x9A43},	// CJK UNIFIED IDEOGRAPH
	{0xC55A,	0x9A40},	// CJK UNIFIED IDEOGRAPH
	{0xC55B,	0x9A3E},	// CJK UNIFIED IDEOGRAPH
	{0xC55C,	0x9ACF},	// CJK UNIFIED IDEOGRAPH
	{0xC55D,	0x9B54},	// CJK UNIFIED IDEOGRAPH
	{0xC55E,	0x9B51},	// CJK UNIFIED IDEOGRAPH
	{0xC55F,	0x9C2D},	// CJK UNIFIED IDEOGRAPH
	{0xC560,	0x9C25},	// CJK UNIFIED IDEOGRAPH
	{0xC561,	0x9DAF},	// CJK UNIFIED IDEOGRAPH
	{0xC562,	0x9DB4},	// CJK UNIFIED IDEOGRAPH
	{0xC563,	0x9DC2},	// CJK UNIFIED IDEOGRAPH
	{0xC564,	0x9DB8},	// CJK UNIFIED IDEOGRAPH
	{0xC565,	0x9E9D},	// CJK UNIFIED IDEOGRAPH
	{0xC566,	0x9EEF},	// CJK UNIFIED IDEOGRAPH
	{0xC567,	0x9F19},	// CJK UNIFIED IDEOGRAPH
	{0xC568,	0x9F5C},	// CJK UNIFIED IDEOGRAPH
	{0xC569,	0x9F66},	// CJK UNIFIED IDEOGRAPH
	{0xC56A,	0x9F67},	// CJK UNIFIED IDEOGRAPH
	{0xC56B,	0x513C},	// CJK UNIFIED IDEOGRAPH
	{0xC56C,	0x513B},	// CJK UNIFIED IDEOGRAPH
	{0xC56D,	0x56C8},	// CJK UNIFIED IDEOGRAPH
	{0xC56E,	0x56CA},	// CJK UNIFIED IDEOGRAPH
	{0xC56F,	0x56C9},	// CJK UNIFIED IDEOGRAPH
	{0xC570,	0x5B7F},	// CJK UNIFIED IDEOGRAPH
	{0xC571,	0x5DD4},	// CJK UNIFIED IDEOGRAPH
	{0xC572,	0x5DD2},	// CJK UNIFIED IDEOGRAPH
	{0xC573,	0x5F4E},	// CJK UNIFIED IDEOGRAPH
	{0xC574,	0x61FF},	// CJK UNIFIED IDEOGRAPH
	{0xC575,	0x6524},	// CJK UNIFIED IDEOGRAPH
	{0xC576,	0x6B0A},	// CJK UNIFIED IDEOGRAPH
	{0xC577,	0x6B61},	// CJK UNIFIED IDEOGRAPH
	{0xC578,	0x7051},	// CJK UNIFIED IDEOGRAPH
	{0xC579,	0x7058},	// CJK UNIFIED IDEOGRAPH
	{0xC57A,	0x7380},	// CJK UNIFIED IDEOGRAPH
	{0xC57B,	0x74E4},	// CJK UNIFIED IDEOGRAPH
	{0xC57C,	0x758A},	// CJK UNIFIED IDEOGRAPH
	{0xC57D,	0x766E},	// CJK UNIFIED IDEOGRAPH
	{0xC57E,	0x766C},	// CJK UNIFIED IDEOGRAPH
	{0xC5A1,	0x79B3},	// CJK UNIFIED IDEOGRAPH
	{0xC5A2,	0x7C60},	// CJK UNIFIED IDEOGRAPH
	{0xC5A3,	0x7C5F},	// CJK UNIFIED IDEOGRAPH
	{0xC5A4,	0x807E},	// CJK UNIFIED IDEOGRAPH
	{0xC5A5,	0x807D},	// CJK UNIFIED IDEOGRAPH
	{0xC5A6,	0x81DF},	// CJK UNIFIED IDEOGRAPH
	{0xC5A7,	0x8972},	// CJK UNIFIED IDEOGRAPH
	{0xC5A8,	0x896F},	// CJK UNIFIED IDEOGRAPH
	{0xC5A9,	0x89FC},	// CJK UNIFIED IDEOGRAPH
	{0xC5AA,	0x8B80},	// CJK UNIFIED IDEOGRAPH
	{0xC5AB,	0x8D16},	// CJK UNIFIED IDEOGRAPH
	{0xC5AC,	0x8D17},	// CJK UNIFIED IDEOGRAPH
	{0xC5AD,	0x8E91},	// CJK UNIFIED IDEOGRAPH
	{0xC5AE,	0x8E93},	// CJK UNIFIED IDEOGRAPH
	{0xC5AF,	0x8F61},	// CJK UNIFIED IDEOGRAPH
	{0xC5B0,	0x9148},	// CJK UNIFIED IDEOGRAPH
	{0xC5B1,	0x9444},	// CJK UNIFIED IDEOGRAPH
	{0xC5B2,	0x9451},	// CJK UNIFIED IDEOGRAPH
	{0xC5B3,	0x9452},	// CJK UNIFIED IDEOGRAPH
	{0xC5B4,	0x973D},	// CJK UNIFIED IDEOGRAPH
	{0xC5B5,	0x973E},	// CJK UNIFIED IDEOGRAPH
	{0xC5B6,	0x97C3},	// CJK UNIFIED IDEOGRAPH
	{0xC5B7,	0x97C1},	// CJK UNIFIED IDEOGRAPH
	{0xC5B8,	0x986B},	// CJK UNIFIED IDEOGRAPH
	{0xC5B9,	0x9955},	// CJK UNIFIED IDEOGRAPH
	{0xC5BA,	0x9A55},	// CJK UNIFIED IDEOGRAPH
	{0xC5BB,	0x9A4D},	// CJK UNIFIED IDEOGRAPH
	{0xC5BC,	0x9AD2},	// CJK UNIFIED IDEOGRAPH
	{0xC5BD,	0x9B1A},	// CJK UNIFIED IDEOGRAPH
	{0xC5BE,	0x9C49},	// CJK UNIFIED IDEOGRAPH
	{0xC5BF,	0x9C31},	// CJK UNIFIED IDEOGRAPH
	{0xC5C0,	0x9C3E},	// CJK UNIFIED IDEOGRAPH
	{0xC5C1,	0x9C3B},	// CJK UNIFIED IDEOGRAPH
	{0xC5C2,	0x9DD3},	// CJK UNIFIED IDEOGRAPH
	{0xC5C3,	0x9DD7},	// CJK UNIFIED IDEOGRAPH
	{0xC5C4,	0x9F34},	// CJK UNIFIED IDEOGRAPH
	{0xC5C5,	0x9F6C},	// CJK UNIFIED IDEOGRAPH
	{0xC5C6,	0x9F6A},	// CJK UNIFIED IDEOGRAPH
	{0xC5C7,	0x9F94},	// CJK UNIFIED IDEOGRAPH
	{0xC5C8,	0x56CC},	// CJK UNIFIED IDEOGRAPH
	{0xC5C9,	0x5DD6},	// CJK UNIFIED IDEOGRAPH
	{0xC5CA,	0x6200},	// CJK UNIFIED IDEOGRAPH
	{0xC5CB,	0x6523},	// CJK UNIFIED IDEOGRAPH
	{0xC5CC,	0x652B},	// CJK UNIFIED IDEOGRAPH
	{0xC5CD,	0x652A},	// CJK UNIFIED IDEOGRAPH
	{0xC5CE,	0x66EC},	// CJK UNIFIED IDEOGRAPH
	{0xC5CF,	0x6B10},	// CJK UNIFIED IDEOGRAPH
	{0xC5D0,	0x74DA},	// CJK UNIFIED IDEOGRAPH
	{0xC5D1,	0x7ACA},	// CJK UNIFIED IDEOGRAPH
	{0xC5D2,	0x7C64},	// CJK UNIFIED IDEOGRAPH
	{0xC5D3,	0x7C63},	// CJK UNIFIED IDEOGRAPH
	{0xC5D4,	0x7C65},	// CJK UNIFIED IDEOGRAPH
	{0xC5D5,	0x7E93},	// CJK UNIFIED IDEOGRAPH
	{0xC5D6,	0x7E96},	// CJK UNIFIED IDEOGRAPH
	{0xC5D7,	0x7E94},	// CJK UNIFIED IDEOGRAPH
	{0xC5D8,	0x81E2},	// CJK UNIFIED IDEOGRAPH
	{0xC5D9,	0x8638},	// CJK UNIFIED IDEOGRAPH
	{0xC5DA,	0x863F},	// CJK UNIFIED IDEOGRAPH
	{0xC5DB,	0x8831},	// CJK UNIFIED IDEOGRAPH
	{0xC5DC,	0x8B8A},	// CJK UNIFIED IDEOGRAPH
	{0xC5DD,	0x9090},	// CJK UNIFIED IDEOGRAPH
	{0xC5DE,	0x908F},	// CJK UNIFIED IDEOGRAPH
	{0xC5DF,	0x9463},	// CJK UNIFIED IDEOGRAPH
	{0xC5E0,	0x9460},	// CJK UNIFIED IDEOGRAPH
	{0xC5E1,	0x9464},	// CJK UNIFIED IDEOGRAPH
	{0xC5E2,	0x9768},	// CJK UNIFIED IDEOGRAPH
	{0xC5E3,	0x986F},	// CJK UNIFIED IDEOGRAPH
	{0xC5E4,	0x995C},	// CJK UNIFIED IDEOGRAPH
	{0xC5E5,	0x9A5A},	// CJK UNIFIED IDEOGRAPH
	{0xC5E6,	0x9A5B},	// CJK UNIFIED IDEOGRAPH
	{0xC5E7,	0x9A57},	// CJK UNIFIED IDEOGRAPH
	{0xC5E8,	0x9AD3},	// CJK UNIFIED IDEOGRAPH
	{0xC5E9,	0x9AD4},	// CJK UNIFIED IDEOGRAPH
	{0xC5EA,	0x9AD1},	// CJK UNIFIED IDEOGRAPH
	{0xC5EB,	0x9C54},	// CJK UNIFIED IDEOGRAPH
	{0xC5EC,	0x9C57},	// CJK UNIFIED IDEOGRAPH
	{0xC5ED,	0x9C56},	// CJK UNIFIED IDEOGRAPH
	{0xC5EE,	0x9DE5},	// CJK UNIFIED IDEOGRAPH
	{0xC5EF,	0x9E9F},	// CJK UNIFIED IDEOGRAPH
	{0xC5F0,	0x9EF4},	// CJK UNIFIED IDEOGRAPH
	{0xC5F1,	0x56D1},	// CJK UNIFIED IDEOGRAPH
	{0xC5F2,	0x58E9},	// CJK UNIFIED IDEOGRAPH
	{0xC5F3,	0x652C},	// CJK UNIFIED IDEOGRAPH
	{0xC5F4,	0x705E},	// CJK UNIFIED IDEOGRAPH
	{0xC5F5,	0x7671},	// CJK UNIFIED IDEOGRAPH
	{0xC5F6,	0x7672},	// CJK UNIFIED IDEOGRAPH
	{0xC5F7,	0x77D7},	// CJK UNIFIED IDEOGRAPH
	{0xC5F8,	0x7F50},	// CJK UNIFIED IDEOGRAPH
	{0xC5F9,	0x7F88},	// CJK UNIFIED IDEOGRAPH
	{0xC5FA,	0x8836},	// CJK UNIFIED IDEOGRAPH
	{0xC5FB,	0x8839},	// CJK UNIFIED IDEOGRAPH
	{0xC5FC,	0x8862},	// CJK UNIFIED IDEOGRAPH
	{0xC5FD,	0x8B93},	// CJK UNIFIED IDEOGRAPH
	{0xC5FE,	0x8B92},	// CJK UNIFIED IDEOGRAPH
	{0xC640,	0x8B96},	// CJK UNIFIED IDEOGRAPH
	{0xC641,	0x8277},	// CJK UNIFIED IDEOGRAPH
	{0xC642,	0x8D1B},	// CJK UNIFIED IDEOGRAPH
	{0xC643,	0x91C0},	// CJK UNIFIED IDEOGRAPH
	{0xC644,	0x946A},	// CJK UNIFIED IDEOGRAPH
	{0xC645,	0x9742},	// CJK UNIFIED IDEOGRAPH
	{0xC646,	0x9748},	// CJK UNIFIED IDEOGRAPH
	{0xC647,	0x9744},	// CJK UNIFIED IDEOGRAPH
	{0xC648,	0x97C6},	// CJK UNIFIED IDEOGRAPH
	{0xC649,	0x9870},	// CJK UNIFIED IDEOGRAPH
	{0xC64A,	0x9A5F},	// CJK UNIFIED IDEOGRAPH
	{0xC64B,	0x9B22},	// CJK UNIFIED IDEOGRAPH
	{0xC64C,	0x9B58},	// CJK UNIFIED IDEOGRAPH
	{0xC64D,	0x9C5F},	// CJK UNIFIED IDEOGRAPH
	{0xC64E,	0x9DF9},	// CJK UNIFIED IDEOGRAPH
	{0xC64F,	0x9DFA},	// CJK UNIFIED IDEOGRAPH
	{0xC650,	0x9E7C},	// CJK UNIFIED IDEOGRAPH
	{0xC651,	0x9E7D},	// CJK UNIFIED IDEOGRAPH
	{0xC652,	0x9F07},	// CJK UNIFIED IDEOGRAPH
	{0xC653,	0x9F77},	// CJK UNIFIED IDEOGRAPH
	{0xC654,	0x9F72},	// CJK UNIFIED IDEOGRAPH
	{0xC655,	0x5EF3},	// CJK UNIFIED IDEOGRAPH
	{0xC656,	0x6B16},	// CJK UNIFIED IDEOGRAPH
	{0xC657,	0x7063},	// CJK UNIFIED IDEOGRAPH
	{0xC658,	0x7C6C},	// CJK UNIFIED IDEOGRAPH
	{0xC659,	0x7C6E},	// CJK UNIFIED IDEOGRAPH
	{0xC65A,	0x883B},	// CJK UNIFIED IDEOGRAPH
	{0xC65B,	0x89C0},	// CJK UNIFIED IDEOGRAPH
	{0xC65C,	0x8EA1},	// CJK UNIFIED IDEOGRAPH
	{0xC65D,	0x91C1},	// CJK UNIFIED IDEOGRAPH
	{0xC65E,	0x9472},	// CJK UNIFIED IDEOGRAPH
	{0xC65F,	0x9470},	// CJK UNIFIED IDEOGRAPH
	{0xC660,	0x9871},	// CJK UNIFIED IDEOGRAPH
	{0xC661,	0x995E},	// CJK UNIFIED IDEOGRAPH
	{0xC662,	0x9AD6},	// CJK UNIFIED IDEOGRAPH
	{0xC663,	0x9B23},	// CJK UNIFIED IDEOGRAPH
	{0xC664,	0x9ECC},	// CJK UNIFIED IDEOGRAPH
	{0xC665,	0x7064},	// CJK UNIFIED IDEOGRAPH
	{0xC666,	0x77DA},	// CJK UNIFIED IDEOGRAPH
	{0xC667,	0x8B9A},	// CJK UNIFIED IDEOGRAPH
	{0xC668,	0x9477},	// CJK UNIFIED IDEOGRAPH
	{0xC669,	0x97C9},	// CJK UNIFIED IDEOGRAPH
	{0xC66A,	0x9A62},	// CJK UNIFIED IDEOGRAPH
	{0xC66B,	0x9A65},	// CJK UNIFIED IDEOGRAPH
	{0xC66C,	0x7E9C},	// CJK UNIFIED IDEOGRAPH
	{0xC66D,	0x8B9C},	// CJK UNIFIED IDEOGRAPH
	{0xC66E,	0x8EAA},	// CJK UNIFIED IDEOGRAPH
	{0xC66F,	0x91C5},	// CJK UNIFIED IDEOGRAPH
	{0xC670,	0x947D},	// CJK UNIFIED IDEOGRAPH
	{0xC671,	0x947E},	// CJK UNIFIED IDEOGRAPH
	{0xC672,	0x947C},	// CJK UNIFIED IDEOGRAPH
	{0xC673,	0x9C77},	// CJK UNIFIED IDEOGRAPH
	{0xC674,	0x9C78},	// CJK UNIFIED IDEOGRAPH
	{0xC675,	0x9EF7},	// CJK UNIFIED IDEOGRAPH
	{0xC676,	0x8C54},	// CJK UNIFIED IDEOGRAPH
	{0xC677,	0x947F},	// CJK UNIFIED IDEOGRAPH
	{0xC678,	0x9E1A},	// CJK UNIFIED IDEOGRAPH
	{0xC679,	0x7228},	// CJK UNIFIED IDEOGRAPH
	{0xC67A,	0x9A6A},	// CJK UNIFIED IDEOGRAPH
	{0xC67B,	0x9B31},	// CJK UNIFIED IDEOGRAPH
	{0xC67C,	0x9E1B},	// CJK UNIFIED IDEOGRAPH
	{0xC67D,	0x9E1E},	// CJK UNIFIED IDEOGRAPH
	{0xC67E,	0x7C72},	// CJK UNIFIED IDEOGRAPH
	{0xC940,	0x4E42},	// CJK UNIFIED IDEOGRAPH
	{0xC941,	0x4E5C},	// CJK UNIFIED IDEOGRAPH
	{0xC942,	0x51F5},	// CJK UNIFIED IDEOGRAPH
	{0xC943,	0x531A},	// CJK UNIFIED IDEOGRAPH
	{0xC944,	0x5382},	// CJK UNIFIED IDEOGRAPH
	{0xC945,	0x4E07},	// CJK UNIFIED IDEOGRAPH
	{0xC946,	0x4E0C},	// CJK UNIFIED IDEOGRAPH
	{0xC947,	0x4E47},	// CJK UNIFIED IDEOGRAPH
	{0xC948,	0x4E8D},	// CJK UNIFIED IDEOGRAPH
	{0xC949,	0x56D7},	// CJK UNIFIED IDEOGRAPH
	{0xC94A,	0xFA0C},	// CJK COMPATIBILITY IDEOGRAPH
	{0xC94B,	0x5C6E},	// CJK UNIFIED IDEOGRAPH
	{0xC94C,	0x5F73},	// CJK UNIFIED IDEOGRAPH
	{0xC94D,	0x4E0F},	// CJK UNIFIED IDEOGRAPH
	{0xC94E,	0x5187},	// CJK UNIFIED IDEOGRAPH
	{0xC94F,	0x4E0E},	// CJK UNIFIED IDEOGRAPH
	{0xC950,	0x4E2E},	// CJK UNIFIED IDEOGRAPH
	{0xC951,	0x4E93},	// CJK UNIFIED IDEOGRAPH
	{0xC952,	0x4EC2},	// CJK UNIFIED IDEOGRAPH
	{0xC953,	0x4EC9},	// CJK UNIFIED IDEOGRAPH
	{0xC954,	0x4EC8},	// CJK UNIFIED IDEOGRAPH
	{0xC955,	0x5198},	// CJK UNIFIED IDEOGRAPH
	{0xC956,	0x52FC},	// CJK UNIFIED IDEOGRAPH
	{0xC957,	0x536C},	// CJK UNIFIED IDEOGRAPH
	{0xC958,	0x53B9},	// CJK UNIFIED IDEOGRAPH
	{0xC959,	0x5720},	// CJK UNIFIED IDEOGRAPH
	{0xC95A,	0x5903},	// CJK UNIFIED IDEOGRAPH
	{0xC95B,	0x592C},	// CJK UNIFIED IDEOGRAPH
	{0xC95C,	0x5C10},	// CJK UNIFIED IDEOGRAPH
	{0xC95D,	0x5DFF},	// CJK UNIFIED IDEOGRAPH
	{0xC95E,	0x65E1},	// CJK UNIFIED IDEOGRAPH
	{0xC95F,	0x6BB3},	// CJK UNIFIED IDEOGRAPH
	{0xC960,	0x6BCC},	// CJK UNIFIED IDEOGRAPH
	{0xC961,	0x6C14},	// CJK UNIFIED IDEOGRAPH
	{0xC962,	0x723F},	// CJK UNIFIED IDEOGRAPH
	{0xC963,	0x4E31},	// CJK UNIFIED IDEOGRAPH
	{0xC964,	0x4E3C},	// CJK UNIFIED IDEOGRAPH
	{0xC965,	0x4EE8},	// CJK UNIFIED IDEOGRAPH
	{0xC966,	0x4EDC},	// CJK UNIFIED IDEOGRAPH
	{0xC967,	0x4EE9},	// CJK UNIFIED IDEOGRAPH
	{0xC968,	0x4EE1},	// CJK UNIFIED IDEOGRAPH
	{0xC969,	0x4EDD},	// CJK UNIFIED IDEOGRAPH
	{0xC96A,	0x4EDA},	// CJK UNIFIED IDEOGRAPH
	{0xC96B,	0x520C},	// CJK UNIFIED IDEOGRAPH
	{0xC96C,	0x531C},	// CJK UNIFIED IDEOGRAPH
	{0xC96D,	0x534C},	// CJK UNIFIED IDEOGRAPH
	{0xC96E,	0x5722},	// CJK UNIFIED IDEOGRAPH
	{0xC96F,	0x5723},	// CJK UNIFIED IDEOGRAPH
	{0xC970,	0x5917},	// CJK UNIFIED IDEOGRAPH
	{0xC971,	0x592F},	// CJK UNIFIED IDEOGRAPH
	{0xC972,	0x5B81},	// CJK UNIFIED IDEOGRAPH
	{0xC973,	0x5B84},	// CJK UNIFIED IDEOGRAPH
	{0xC974,	0x5C12},	// CJK UNIFIED IDEOGRAPH
	{0xC975,	0x5C3B},	// CJK UNIFIED IDEOGRAPH
	{0xC976,	0x5C74},	// CJK UNIFIED IDEOGRAPH
	{0xC977,	0x5C73},	// CJK UNIFIED IDEOGRAPH
	{0xC978,	0x5E04},	// CJK UNIFIED IDEOGRAPH
	{0xC979,	0x5E80},	// CJK UNIFIED IDEOGRAPH
	{0xC97A,	0x5E82},	// CJK UNIFIED IDEOGRAPH
	{0xC97B,	0x5FC9},	// CJK UNIFIED IDEOGRAPH
	{0xC97C,	0x6209},	// CJK UNIFIED IDEOGRAPH
	{0xC97D,	0x6250},	// CJK UNIFIED IDEOGRAPH
	{0xC97E,	0x6C15},	// CJK UNIFIED IDEOGRAPH
	{0xC9A1,	0x6C36},	// CJK UNIFIED IDEOGRAPH
	{0xC9A2,	0x6C43},	// CJK UNIFIED IDEOGRAPH
	{0xC9A3,	0x6C3F},	// CJK UNIFIED IDEOGRAPH
	{0xC9A4,	0x6C3B},	// CJK UNIFIED IDEOGRAPH
	{0xC9A5,	0x72AE},	// CJK UNIFIED IDEOGRAPH
	{0xC9A6,	0x72B0},	// CJK UNIFIED IDEOGRAPH
	{0xC9A7,	0x738A},	// CJK UNIFIED IDEOGRAPH
	{0xC9A8,	0x79B8},	// CJK UNIFIED IDEOGRAPH
	{0xC9A9,	0x808A},	// CJK UNIFIED IDEOGRAPH
	{0xC9AA,	0x961E},	// CJK UNIFIED IDEOGRAPH
	{0xC9AB,	0x4F0E},	// CJK UNIFIED IDEOGRAPH
	{0xC9AC,	0x4F18},	// CJK UNIFIED IDEOGRAPH
	{0xC9AD,	0x4F2C},	// CJK UNIFIED IDEOGRAPH
	{0xC9AE,	0x4EF5},	// CJK UNIFIED IDEOGRAPH
	{0xC9AF,	0x4F14},	// CJK UNIFIED IDEOGRAPH
	{0xC9B0,	0x4EF1},	// CJK UNIFIED IDEOGRAPH
	{0xC9B1,	0x4F00},	// CJK UNIFIED IDEOGRAPH
	{0xC9B2,	0x4EF7},	// CJK UNIFIED IDEOGRAPH
	{0xC9B3,	0x4F08},	// CJK UNIFIED IDEOGRAPH
	{0xC9B4,	0x4F1D},	// CJK UNIFIED IDEOGRAPH
	{0xC9B5,	0x4F02},	// CJK UNIFIED IDEOGRAPH
	{0xC9B6,	0x4F05},	// CJK UNIFIED IDEOGRAPH
	{0xC9B7,	0x4F22},	// CJK UNIFIED IDEOGRAPH
	{0xC9B8,	0x4F13},	// CJK UNIFIED IDEOGRAPH
	{0xC9B9,	0x4F04},	// CJK UNIFIED IDEOGRAPH
	{0xC9BA,	0x4EF4},	// CJK UNIFIED IDEOGRAPH
	{0xC9BB,	0x4F12},	// CJK UNIFIED IDEOGRAPH
	{0xC9BC,	0x51B1},	// CJK UNIFIED IDEOGRAPH
	{0xC9BD,	0x5213},	// CJK UNIFIED IDEOGRAPH
	{0xC9BE,	0x5209},	// CJK UNIFIED IDEOGRAPH
	{0xC9BF,	0x5210},	// CJK UNIFIED IDEOGRAPH
	{0xC9C0,	0x52A6},	// CJK UNIFIED IDEOGRAPH
	{0xC9C1,	0x5322},	// CJK UNIFIED IDEOGRAPH
	{0xC9C2,	0x531F},	// CJK UNIFIED IDEOGRAPH
	{0xC9C3,	0x534D},	// CJK UNIFIED IDEOGRAPH
	{0xC9C4,	0x538A},	// CJK UNIFIED IDEOGRAPH
	{0xC9C5,	0x5407},	// CJK UNIFIED IDEOGRAPH
	{0xC9C6,	0x56E1},	// CJK UNIFIED IDEOGRAPH
	{0xC9C7,	0x56DF},	// CJK UNIFIED IDEOGRAPH
	{0xC9C8,	0x572E},	// CJK UNIFIED IDEOGRAPH
	{0xC9C9,	0x572A},	// CJK UNIFIED IDEOGRAPH
	{0xC9CA,	0x5734},	// CJK UNIFIED IDEOGRAPH
	{0xC9CB,	0x593C},	// CJK UNIFIED IDEOGRAPH
	{0xC9CC,	0x5980},	// CJK UNIFIED IDEOGRAPH
	{0xC9CD,	0x597C},	// CJK UNIFIED IDEOGRAPH
	{0xC9CE,	0x5985},	// CJK UNIFIED IDEOGRAPH
	{0xC9CF,	0x597B},	// CJK UNIFIED IDEOGRAPH
	{0xC9D0,	0x597E},	// CJK UNIFIED IDEOGRAPH
	{0xC9D1,	0x5977},	// CJK UNIFIED IDEOGRAPH
	{0xC9D2,	0x597F},	// CJK UNIFIED IDEOGRAPH
	{0xC9D3,	0x5B56},	// CJK UNIFIED IDEOGRAPH
	{0xC9D4,	0x5C15},	// CJK UNIFIED IDEOGRAPH
	{0xC9D5,	0x5C25},	// CJK UNIFIED IDEOGRAPH
	{0xC9D6,	0x5C7C},	// CJK UNIFIED IDEOGRAPH
	{0xC9D7,	0x5C7A},	// CJK UNIFIED IDEOGRAPH
	{0xC9D8,	0x5C7B},	// CJK UNIFIED IDEOGRAPH
	{0xC9D9,	0x5C7E},	// CJK UNIFIED IDEOGRAPH
	{0xC9DA,	0x5DDF},	// CJK UNIFIED IDEOGRAPH
	{0xC9DB,	0x5E75},	// CJK UNIFIED IDEOGRAPH
	{0xC9DC,	0x5E84},	// CJK UNIFIED IDEOGRAPH
	{0xC9DD,	0x5F02},	// CJK UNIFIED IDEOGRAPH
	{0xC9DE,	0x5F1A},	// CJK UNIFIED IDEOGRAPH
	{0xC9DF,	0x5F74},	// CJK UNIFIED IDEOGRAPH
	{0xC9E0,	0x5FD5},	// CJK UNIFIED IDEOGRAPH
	{0xC9E1,	0x5FD4},	// CJK UNIFIED IDEOGRAPH
	{0xC9E2,	0x5FCF},	// CJK UNIFIED IDEOGRAPH
	{0xC9E3,	0x625C},	// CJK UNIFIED IDEOGRAPH
	{0xC9E4,	0x625E},	// CJK UNIFIED IDEOGRAPH
	{0xC9E5,	0x6264},	// CJK UNIFIED IDEOGRAPH
	{0xC9E6,	0x6261},	// CJK UNIFIED IDEOGRAPH
	{0xC9E7,	0x6266},	// CJK UNIFIED IDEOGRAPH
	{0xC9E8,	0x6262},	// CJK UNIFIED IDEOGRAPH
	{0xC9E9,	0x6259},	// CJK UNIFIED IDEOGRAPH
	{0xC9EA,	0x6260},	// CJK UNIFIED IDEOGRAPH
	{0xC9EB,	0x625A},	// CJK UNIFIED IDEOGRAPH
	{0xC9EC,	0x6265},	// CJK UNIFIED IDEOGRAPH
	{0xC9ED,	0x65EF},	// CJK UNIFIED IDEOGRAPH
	{0xC9EE,	0x65EE},	// CJK UNIFIED IDEOGRAPH
	{0xC9EF,	0x673E},	// CJK UNIFIED IDEOGRAPH
	{0xC9F0,	0x6739},	// CJK UNIFIED IDEOGRAPH
	{0xC9F1,	0x6738},	// CJK UNIFIED IDEOGRAPH
	{0xC9F2,	0x673B},	// CJK UNIFIED IDEOGRAPH
	{0xC9F3,	0x673A},	// CJK UNIFIED IDEOGRAPH
	{0xC9F4,	0x673F},	// CJK UNIFIED IDEOGRAPH
	{0xC9F5,	0x673C},	// CJK UNIFIED IDEOGRAPH
	{0xC9F6,	0x6733},	// CJK UNIFIED IDEOGRAPH
	{0xC9F7,	0x6C18},	// CJK UNIFIED IDEOGRAPH
	{0xC9F8,	0x6C46},	// CJK UNIFIED IDEOGRAPH
	{0xC9F9,	0x6C52},	// CJK UNIFIED IDEOGRAPH
	{0xC9FA,	0x6C5C},	// CJK UNIFIED IDEOGRAPH
	{0xC9FB,	0x6C4F},	// CJK UNIFIED IDEOGRAPH
	{0xC9FC,	0x6C4A},	// CJK UNIFIED IDEOGRAPH
	{0xC9FD,	0x6C54},	// CJK UNIFIED IDEOGRAPH
	{0xC9FE,	0x6C4B},	// CJK UNIFIED IDEOGRAPH
	{0xCA40,	0x6C4C},	// CJK UNIFIED IDEOGRAPH
	{0xCA41,	0x7071},	// CJK UNIFIED IDEOGRAPH
	{0xCA42,	0x725E},	// CJK UNIFIED IDEOGRAPH
	{0xCA43,	0x72B4},	// CJK UNIFIED IDEOGRAPH
	{0xCA44,	0x72B5},	// CJK UNIFIED IDEOGRAPH
	{0xCA45,	0x738E},	// CJK UNIFIED IDEOGRAPH
	{0xCA46,	0x752A},	// CJK UNIFIED IDEOGRAPH
	{0xCA47,	0x767F},	// CJK UNIFIED IDEOGRAPH
	{0xCA48,	0x7A75},	// CJK UNIFIED IDEOGRAPH
	{0xCA49,	0x7F51},	// CJK UNIFIED IDEOGRAPH
	{0xCA4A,	0x8278},	// CJK UNIFIED IDEOGRAPH
	{0xCA4B,	0x827C},	// CJK UNIFIED IDEOGRAPH
	{0xCA4C,	0x8280},	// CJK UNIFIED IDEOGRAPH
	{0xCA4D,	0x827D},	// CJK UNIFIED IDEOGRAPH
	{0xCA4E,	0x827F},	// CJK UNIFIED IDEOGRAPH
	{0xCA4F,	0x864D},	// CJK UNIFIED IDEOGRAPH
	{0xCA50,	0x897E},	// CJK UNIFIED IDEOGRAPH
	{0xCA51,	0x9099},	// CJK UNIFIED IDEOGRAPH
	{0xCA52,	0x9097},	// CJK UNIFIED IDEOGRAPH
	{0xCA53,	0x9098},	// CJK UNIFIED IDEOGRAPH
	{0xCA54,	0x909B},	// CJK UNIFIED IDEOGRAPH
	{0xCA55,	0x9094},	// CJK UNIFIED IDEOGRAPH
	{0xCA56,	0x9622},	// CJK UNIFIED IDEOGRAPH
	{0xCA57,	0x9624},	// CJK UNIFIED IDEOGRAPH
	{0xCA58,	0x9620},	// CJK UNIFIED IDEOGRAPH
	{0xCA59,	0x9623},	// CJK UNIFIED IDEOGRAPH
	{0xCA5A,	0x4F56},	// CJK UNIFIED IDEOGRAPH
	{0xCA5B,	0x4F3B},	// CJK UNIFIED IDEOGRAPH
	{0xCA5C,	0x4F62},	// CJK UNIFIED IDEOGRAPH
	{0xCA5D,	0x4F49},	// CJK UNIFIED IDEOGRAPH
	{0xCA5E,	0x4F53},	// CJK UNIFIED IDEOGRAPH
	{0xCA5F,	0x4F64},	// CJK UNIFIED IDEOGRAPH
	{0xCA60,	0x4F3E},	// CJK UNIFIED IDEOGRAPH
	{0xCA61,	0x4F67},	// CJK UNIFIED IDEOGRAPH
	{0xCA62,	0x4F52},	// CJK UNIFIED IDEOGRAPH
	{0xCA63,	0x4F5F},	// CJK UNIFIED IDEOGRAPH
	{0xCA64,	0x4F41},	// CJK UNIFIED IDEOGRAPH
	{0xCA65,	0x4F58},	// CJK UNIFIED IDEOGRAPH
	{0xCA66,	0x4F2D},	// CJK UNIFIED IDEOGRAPH
	{0xCA67,	0x4F33},	// CJK UNIFIED IDEOGRAPH
	{0xCA68,	0x4F3F},	// CJK UNIFIED IDEOGRAPH
	{0xCA69,	0x4F61},	// CJK UNIFIED IDEOGRAPH
	{0xCA6A,	0x518F},	// CJK UNIFIED IDEOGRAPH
	{0xCA6B,	0x51B9},	// CJK UNIFIED IDEOGRAPH
	{0xCA6C,	0x521C},	// CJK UNIFIED IDEOGRAPH
	{0xCA6D,	0x521E},	// CJK UNIFIED IDEOGRAPH
	{0xCA6E,	0x5221},	// CJK UNIFIED IDEOGRAPH
	{0xCA6F,	0x52AD},	// CJK UNIFIED IDEOGRAPH
	{0xCA70,	0x52AE},	// CJK UNIFIED IDEOGRAPH
	{0xCA71,	0x5309},	// CJK UNIFIED IDEOGRAPH
	{0xCA72,	0x5363},	// CJK UNIFIED IDEOGRAPH
	{0xCA73,	0x5372},	// CJK UNIFIED IDEOGRAPH
	{0xCA74,	0x538E},	// CJK UNIFIED IDEOGRAPH
	{0xCA75,	0x538F},	// CJK UNIFIED IDEOGRAPH
	{0xCA76,	0x5430},	// CJK UNIFIED IDEOGRAPH
	{0xCA77,	0x5437},	// CJK UNIFIED IDEOGRAPH
	{0xCA78,	0x542A},	// CJK UNIFIED IDEOGRAPH
	{0xCA79,	0x5454},	// CJK UNIFIED IDEOGRAPH
	{0xCA7A,	0x5445},	// CJK UNIFIED IDEOGRAPH
	{0xCA7B,	0x5419},	// CJK UNIFIED IDEOGRAPH
	{0xCA7C,	0x541C},	// CJK UNIFIED IDEOGRAPH
	{0xCA7D,	0x5425},	// CJK UNIFIED IDEOGRAPH
	{0xCA7E,	0x5418},	// CJK UNIFIED IDEOGRAPH
	{0xCAA1,	0x543D},	// CJK UNIFIED IDEOGRAPH
	{0xCAA2,	0x544F},	// CJK UNIFIED IDEOGRAPH
	{0xCAA3,	0x5441},	// CJK UNIFIED IDEOGRAPH
	{0xCAA4,	0x5428},	// CJK UNIFIED IDEOGRAPH
	{0xCAA5,	0x5424},	// CJK UNIFIED IDEOGRAPH
	{0xCAA6,	0x5447},	// CJK UNIFIED IDEOGRAPH
	{0xCAA7,	0x56EE},	// CJK UNIFIED IDEOGRAPH
	{0xCAA8,	0x56E7},	// CJK UNIFIED IDEOGRAPH
	{0xCAA9,	0x56E5},	// CJK UNIFIED IDEOGRAPH
	{0xCAAA,	0x5741},	// CJK UNIFIED IDEOGRAPH
	{0xCAAB,	0x5745},	// CJK UNIFIED IDEOGRAPH
	{0xCAAC,	0x574C},	// CJK UNIFIED IDEOGRAPH
	{0xCAAD,	0x5749},	// CJK UNIFIED IDEOGRAPH
	{0xCAAE,	0x574B},	// CJK UNIFIED IDEOGRAPH
	{0xCAAF,	0x5752},	// CJK UNIFIED IDEOGRAPH
	{0xCAB0,	0x5906},	// CJK UNIFIED IDEOGRAPH
	{0xCAB1,	0x5940},	// CJK UNIFIED IDEOGRAPH
	{0xCAB2,	0x59A6},	// CJK UNIFIED IDEOGRAPH
	{0xCAB3,	0x5998},	// CJK UNIFIED IDEOGRAPH
	{0xCAB4,	0x59A0},	// CJK UNIFIED IDEOGRAPH
	{0xCAB5,	0x5997},	// CJK UNIFIED IDEOGRAPH
	{0xCAB6,	0x598E},	// CJK UNIFIED IDEOGRAPH
	{0xCAB7,	0x59A2},	// CJK UNIFIED IDEOGRAPH
	{0xCAB8,	0x5990},	// CJK UNIFIED IDEOGRAPH
	{0xCAB9,	0x598F},	// CJK UNIFIED IDEOGRAPH
	{0xCABA,	0x59A7},	// CJK UNIFIED IDEOGRAPH
	{0xCABB,	0x59A1},	// CJK UNIFIED IDEOGRAPH
	{0xCABC,	0x5B8E},	// CJK UNIFIED IDEOGRAPH
	{0xCABD,	0x5B92},	// CJK UNIFIED IDEOGRAPH
	{0xCABE,	0x5C28},	// CJK UNIFIED IDEOGRAPH
	{0xCABF,	0x5C2A},	// CJK UNIFIED IDEOGRAPH
	{0xCAC0,	0x5C8D},	// CJK UNIFIED IDEOGRAPH
	{0xCAC1,	0x5C8F},	// CJK UNIFIED IDEOGRAPH
	{0xCAC2,	0x5C88},	// CJK UNIFIED IDEOGRAPH
	{0xCAC3,	0x5C8B},	// CJK UNIFIED IDEOGRAPH
	{0xCAC4,	0x5C89},	// CJK UNIFIED IDEOGRAPH
	{0xCAC5,	0x5C92},	// CJK UNIFIED IDEOGRAPH
	{0xCAC6,	0x5C8A},	// CJK UNIFIED IDEOGRAPH
	{0xCAC7,	0x5C86},	// CJK UNIFIED IDEOGRAPH
	{0xCAC8,	0x5C93},	// CJK UNIFIED IDEOGRAPH
	{0xCAC9,	0x5C95},	// CJK UNIFIED IDEOGRAPH
	{0xCACA,	0x5DE0},	// CJK UNIFIED IDEOGRAPH
	{0xCACB,	0x5E0A},	// CJK UNIFIED IDEOGRAPH
	{0xCACC,	0x5E0E},	// CJK UNIFIED IDEOGRAPH
	{0xCACD,	0x5E8B},	// CJK UNIFIED IDEOGRAPH
	{0xCACE,	0x5E89},	// CJK UNIFIED IDEOGRAPH
	{0xCACF,	0x5E8C},	// CJK UNIFIED IDEOGRAPH
	{0xCAD0,	0x5E88},	// CJK UNIFIED IDEOGRAPH
	{0xCAD1,	0x5E8D},	// CJK UNIFIED IDEOGRAPH
	{0xCAD2,	0x5F05},	// CJK UNIFIED IDEOGRAPH
	{0xCAD3,	0x5F1D},	// CJK UNIFIED IDEOGRAPH
	{0xCAD4,	0x5F78},	// CJK UNIFIED IDEOGRAPH
	{0xCAD5,	0x5F76},	// CJK UNIFIED IDEOGRAPH
	{0xCAD6,	0x5FD2},	// CJK UNIFIED IDEOGRAPH
	{0xCAD7,	0x5FD1},	// CJK UNIFIED IDEOGRAPH
	{0xCAD8,	0x5FD0},	// CJK UNIFIED IDEOGRAPH
	{0xCAD9,	0x5FED},	// CJK UNIFIED IDEOGRAPH
	{0xCADA,	0x5FE8},	// CJK UNIFIED IDEOGRAPH
	{0xCADB,	0x5FEE},	// CJK UNIFIED IDEOGRAPH
	{0xCADC,	0x5FF3},	// CJK UNIFIED IDEOGRAPH
	{0xCADD,	0x5FE1},	// CJK UNIFIED IDEOGRAPH
	{0xCADE,	0x5FE4},	// CJK UNIFIED IDEOGRAPH
	{0xCADF,	0x5FE3},	// CJK UNIFIED IDEOGRAPH
	{0xCAE0,	0x5FFA},	// CJK UNIFIED IDEOGRAPH
	{0xCAE1,	0x5FEF},	// CJK UNIFIED IDEOGRAPH
	{0xCAE2,	0x5FF7},	// CJK UNIFIED IDEOGRAPH
	{0xCAE3,	0x5FFB},	// CJK UNIFIED IDEOGRAPH
	{0xCAE4,	0x6000},	// CJK UNIFIED IDEOGRAPH
	{0xCAE5,	0x5FF4},	// CJK UNIFIED IDEOGRAPH
	{0xCAE6,	0x623A},	// CJK UNIFIED IDEOGRAPH
	{0xCAE7,	0x6283},	// CJK UNIFIED IDEOGRAPH
	{0xCAE8,	0x628C},	// CJK UNIFIED IDEOGRAPH
	{0xCAE9,	0x628E},	// CJK UNIFIED IDEOGRAPH
	{0xCAEA,	0x628F},	// CJK UNIFIED IDEOGRAPH
	{0xCAEB,	0x6294},	// CJK UNIFIED IDEOGRAPH
	{0xCAEC,	0x6287},	// CJK UNIFIED IDEOGRAPH
	{0xCAED,	0x6271},	// CJK UNIFIED IDEOGRAPH
	{0xCAEE,	0x627B},	// CJK UNIFIED IDEOGRAPH
	{0xCAEF,	0x627A},	// CJK UNIFIED IDEOGRAPH
	{0xCAF0,	0x6270},	// CJK UNIFIED IDEOGRAPH
	{0xCAF1,	0x6281},	// CJK UNIFIED IDEOGRAPH
	{0xCAF2,	0x6288},	// CJK UNIFIED IDEOGRAPH
	{0xCAF3,	0x6277},	// CJK UNIFIED IDEOGRAPH
	{0xCAF4,	0x627D},	// CJK UNIFIED IDEOGRAPH
	{0xCAF5,	0x6272},	// CJK UNIFIED IDEOGRAPH
	{0xCAF6,	0x6274},	// CJK UNIFIED IDEOGRAPH
	{0xCAF7,	0x6537},	// CJK UNIFIED IDEOGRAPH
	{0xCAF8,	0x65F0},	// CJK UNIFIED IDEOGRAPH
	{0xCAF9,	0x65F4},	// CJK UNIFIED IDEOGRAPH
	{0xCAFA,	0x65F3},	// CJK UNIFIED IDEOGRAPH
	{0xCAFB,	0x65F2},	// CJK UNIFIED IDEOGRAPH
	{0xCAFC,	0x65F5},	// CJK UNIFIED IDEOGRAPH
	{0xCAFD,	0x6745},	// CJK UNIFIED IDEOGRAPH
	{0xCAFE,	0x6747},	// CJK UNIFIED IDEOGRAPH
	{0xCB40,	0x6759},	// CJK UNIFIED IDEOGRAPH
	{0xCB41,	0x6755},	// CJK UNIFIED IDEOGRAPH
	{0xCB42,	0x674C},	// CJK UNIFIED IDEOGRAPH
	{0xCB43,	0x6748},	// CJK UNIFIED IDEOGRAPH
	{0xCB44,	0x675D},	// CJK UNIFIED IDEOGRAPH
	{0xCB45,	0x674D},	// CJK UNIFIED IDEOGRAPH
	{0xCB46,	0x675A},	// CJK UNIFIED IDEOGRAPH
	{0xCB47,	0x674B},	// CJK UNIFIED IDEOGRAPH
	{0xCB48,	0x6BD0},	// CJK UNIFIED IDEOGRAPH
	{0xCB49,	0x6C19},	// CJK UNIFIED IDEOGRAPH
	{0xCB4A,	0x6C1A},	// CJK UNIFIED IDEOGRAPH
	{0xCB4B,	0x6C78},	// CJK UNIFIED IDEOGRAPH
	{0xCB4C,	0x6C67},	// CJK UNIFIED IDEOGRAPH
	{0xCB4D,	0x6C6B},	// CJK UNIFIED IDEOGRAPH
	{0xCB4E,	0x6C84},	// CJK UNIFIED IDEOGRAPH
	{0xCB4F,	0x6C8B},	// CJK UNIFIED IDEOGRAPH
	{0xCB50,	0x6C8F},	// CJK UNIFIED IDEOGRAPH
	{0xCB51,	0x6C71},	// CJK UNIFIED IDEOGRAPH
	{0xCB52,	0x6C6F},	// CJK UNIFIED IDEOGRAPH
	{0xCB53,	0x6C69},	// CJK UNIFIED IDEOGRAPH
	{0xCB54,	0x6C9A},	// CJK UNIFIED IDEOGRAPH
	{0xCB55,	0x6C6D},	// CJK UNIFIED IDEOGRAPH
	{0xCB56,	0x6C87},	// CJK UNIFIED IDEOGRAPH
	{0xCB57,	0x6C95},	// CJK UNIFIED IDEOGRAPH
	{0xCB58,	0x6C9C},	// CJK UNIFIED IDEOGRAPH
	{0xCB59,	0x6C66},	// CJK UNIFIED IDEOGRAPH
	{0xCB5A,	0x6C73},	// CJK UNIFIED IDEOGRAPH
	{0xCB5B,	0x6C65},	// CJK UNIFIED IDEOGRAPH
	{0xCB5C,	0x6C7B},	// CJK UNIFIED IDEOGRAPH
	{0xCB5D,	0x6C8E},	// CJK UNIFIED IDEOGRAPH
	{0xCB5E,	0x7074},	// CJK UNIFIED IDEOGRAPH
	{0xCB5F,	0x707A},	// CJK UNIFIED IDEOGRAPH
	{0xCB60,	0x7263},	// CJK UNIFIED IDEOGRAPH
	{0xCB61,	0x72BF},	// CJK UNIFIED IDEOGRAPH
	{0xCB62,	0x72BD},	// CJK UNIFIED IDEOGRAPH
	{0xCB63,	0x72C3},	// CJK UNIFIED IDEOGRAPH
	{0xCB64,	0x72C6},	// CJK UNIFIED IDEOGRAPH
	{0xCB65,	0x72C1},	// CJK UNIFIED IDEOGRAPH
	{0xCB66,	0x72BA},	// CJK UNIFIED IDEOGRAPH
	{0xCB67,	0x72C5},	// CJK UNIFIED IDEOGRAPH
	{0xCB68,	0x7395},	// CJK UNIFIED IDEOGRAPH
	{0xCB69,	0x7397},	// CJK UNIFIED IDEOGRAPH
	{0xCB6A,	0x7393},	// CJK UNIFIED IDEOGRAPH
	{0xCB6B,	0x7394},	// CJK UNIFIED IDEOGRAPH
	{0xCB6C,	0x7392},	// CJK UNIFIED IDEOGRAPH
	{0xCB6D,	0x753A},	// CJK UNIFIED IDEOGRAPH
	{0xCB6E,	0x7539},	// CJK UNIFIED IDEOGRAPH
	{0xCB6F,	0x7594},	// CJK UNIFIED IDEOGRAPH
	{0xCB70,	0x7595},	// CJK UNIFIED IDEOGRAPH
	{0xCB71,	0x7681},	// CJK UNIFIED IDEOGRAPH
	{0xCB72,	0x793D},	// CJK UNIFIED IDEOGRAPH
	{0xCB73,	0x8034},	// CJK UNIFIED IDEOGRAPH
	{0xCB74,	0x8095},	// CJK UNIFIED IDEOGRAPH
	{0xCB75,	0x8099},	// CJK UNIFIED IDEOGRAPH
	{0xCB76,	0x8090},	// CJK UNIFIED IDEOGRAPH
	{0xCB77,	0x8092},	// CJK UNIFIED IDEOGRAPH
	{0xCB78,	0x809C},	// CJK UNIFIED IDEOGRAPH
	{0xCB79,	0x8290},	// CJK UNIFIED IDEOGRAPH
	{0xCB7A,	0x828F},	// CJK UNIFIED IDEOGRAPH
	{0xCB7B,	0x8285},	// CJK UNIFIED IDEOGRAPH
	{0xCB7C,	0x828E},	// CJK UNIFIED IDEOGRAPH
	{0xCB7D,	0x8291},	// CJK UNIFIED IDEOGRAPH
	{0xCB7E,	0x8293},	// CJK UNIFIED IDEOGRAPH
	{0xCBA1,	0x828A},	// CJK UNIFIED IDEOGRAPH
	{0xCBA2,	0x8283},	// CJK UNIFIED IDEOGRAPH
	{0xCBA3,	0x8284},	// CJK UNIFIED IDEOGRAPH
	{0xCBA4,	0x8C78},	// CJK UNIFIED IDEOGRAPH
	{0xCBA5,	0x8FC9},	// CJK UNIFIED IDEOGRAPH
	{0xCBA6,	0x8FBF},	// CJK UNIFIED IDEOGRAPH
	{0xCBA7,	0x909F},	// CJK UNIFIED IDEOGRAPH
	{0xCBA8,	0x90A1},	// CJK UNIFIED IDEOGRAPH
	{0xCBA9,	0x90A5},	// CJK UNIFIED IDEOGRAPH
	{0xCBAA,	0x909E},	// CJK UNIFIED IDEOGRAPH
	{0xCBAB,	0x90A7},	// CJK UNIFIED IDEOGRAPH
	{0xCBAC,	0x90A0},	// CJK UNIFIED IDEOGRAPH
	{0xCBAD,	0x9630},	// CJK UNIFIED IDEOGRAPH
	{0xCBAE,	0x9628},	// CJK UNIFIED IDEOGRAPH
	{0xCBAF,	0x962F},	// CJK UNIFIED IDEOGRAPH
	{0xCBB0,	0x962D},	// CJK UNIFIED IDEOGRAPH
	{0xCBB1,	0x4E33},	// CJK UNIFIED IDEOGRAPH
	{0xCBB2,	0x4F98},	// CJK UNIFIED IDEOGRAPH
	{0xCBB3,	0x4F7C},	// CJK UNIFIED IDEOGRAPH
	{0xCBB4,	0x4F85},	// CJK UNIFIED IDEOGRAPH
	{0xCBB5,	0x4F7D},	// CJK UNIFIED IDEOGRAPH
	{0xCBB6,	0x4F80},	// CJK UNIFIED IDEOGRAPH
	{0xCBB7,	0x4F87},	// CJK UNIFIED IDEOGRAPH
	{0xCBB8,	0x4F76},	// CJK UNIFIED IDEOGRAPH
	{0xCBB9,	0x4F74},	// CJK UNIFIED IDEOGRAPH
	{0xCBBA,	0x4F89},	// CJK UNIFIED IDEOGRAPH
	{0xCBBB,	0x4F84},	// CJK UNIFIED IDEOGRAPH
	{0xCBBC,	0x4F77},	// CJK UNIFIED IDEOGRAPH
	{0xCBBD,	0x4F4C},	// CJK UNIFIED IDEOGRAPH
	{0xCBBE,	0x4F97},	// CJK UNIFIED IDEOGRAPH
	{0xCBBF,	0x4F6A},	// CJK UNIFIED IDEOGRAPH
	{0xCBC0,	0x4F9A},	// CJK UNIFIED IDEOGRAPH
	{0xCBC1,	0x4F79},	// CJK UNIFIED IDEOGRAPH
	{0xCBC2,	0x4F81},	// CJK UNIFIED IDEOGRAPH
	{0xCBC3,	0x4F78},	// CJK UNIFIED IDEOGRAPH
	{0xCBC4,	0x4F90},	// CJK UNIFIED IDEOGRAPH
	{0xCBC5,	0x4F9C},	// CJK UNIFIED IDEOGRAPH
	{0xCBC6,	0x4F94},	// CJK UNIFIED IDEOGRAPH
	{0xCBC7,	0x4F9E},	// CJK UNIFIED IDEOGRAPH
	{0xCBC8,	0x4F92},	// CJK UNIFIED IDEOGRAPH
	{0xCBC9,	0x4F82},	// CJK UNIFIED IDEOGRAPH
	{0xCBCA,	0x4F95},	// CJK UNIFIED IDEOGRAPH
	{0xCBCB,	0x4F6B},	// CJK UNIFIED IDEOGRAPH
	{0xCBCC,	0x4F6E},	// CJK UNIFIED IDEOGRAPH
	{0xCBCD,	0x519E},	// CJK UNIFIED IDEOGRAPH
	{0xCBCE,	0x51BC},	// CJK UNIFIED IDEOGRAPH
	{0xCBCF,	0x51BE},	// CJK UNIFIED IDEOGRAPH
	{0xCBD0,	0x5235},	// CJK UNIFIED IDEOGRAPH
	{0xCBD1,	0x5232},	// CJK UNIFIED IDEOGRAPH
	{0xCBD2,	0x5233},	// CJK UNIFIED IDEOGRAPH
	{0xCBD3,	0x5246},	// CJK UNIFIED IDEOGRAPH
	{0xCBD4,	0x5231},	// CJK UNIFIED IDEOGRAPH
	{0xCBD5,	0x52BC},	// CJK UNIFIED IDEOGRAPH
	{0xCBD6,	0x530A},	// CJK UNIFIED IDEOGRAPH
	{0xCBD7,	0x530B},	// CJK UNIFIED IDEOGRAPH
	{0xCBD8,	0x533C},	// CJK UNIFIED IDEOGRAPH
	{0xCBD9,	0x5392},	// CJK UNIFIED IDEOGRAPH
	{0xCBDA,	0x5394},	// CJK UNIFIED IDEOGRAPH
	{0xCBDB,	0x5487},	// CJK UNIFIED IDEOGRAPH
	{0xCBDC,	0x547F},	// CJK UNIFIED IDEOGRAPH
	{0xCBDD,	0x5481},	// CJK UNIFIED IDEOGRAPH
	{0xCBDE,	0x5491},	// CJK UNIFIED IDEOGRAPH
	{0xCBDF,	0x5482},	// CJK UNIFIED IDEOGRAPH
	{0xCBE0,	0x5488},	// CJK UNIFIED IDEOGRAPH
	{0xCBE1,	0x546B},	// CJK UNIFIED IDEOGRAPH
	{0xCBE2,	0x547A},	// CJK UNIFIED IDEOGRAPH
	{0xCBE3,	0x547E},	// CJK UNIFIED IDEOGRAPH
	{0xCBE4,	0x5465},	// CJK UNIFIED IDEOGRAPH
	{0xCBE5,	0x546C},	// CJK UNIFIED IDEOGRAPH
	{0xCBE6,	0x5474},	// CJK UNIFIED IDEOGRAPH
	{0xCBE7,	0x5466},	// CJK UNIFIED IDEOGRAPH
	{0xCBE8,	0x548D},	// CJK UNIFIED IDEOGRAPH
	{0xCBE9,	0x546F},	// CJK UNIFIED IDEOGRAPH
	{0xCBEA,	0x5461},	// CJK UNIFIED IDEOGRAPH
	{0xCBEB,	0x5460},	// CJK UNIFIED IDEOGRAPH
	{0xCBEC,	0x5498},	// CJK UNIFIED IDEOGRAPH
	{0xCBED,	0x5463},	// CJK UNIFIED IDEOGRAPH
	{0xCBEE,	0x5467},	// CJK UNIFIED IDEOGRAPH
	{0xCBEF,	0x5464},	// CJK UNIFIED IDEOGRAPH
	{0xCBF0,	0x56F7},	// CJK UNIFIED IDEOGRAPH
	{0xCBF1,	0x56F9},	// CJK UNIFIED IDEOGRAPH
	{0xCBF2,	0x576F},	// CJK UNIFIED IDEOGRAPH
	{0xCBF3,	0x5772},	// CJK UNIFIED IDEOGRAPH
	{0xCBF4,	0x576D},	// CJK UNIFIED IDEOGRAPH
	{0xCBF5,	0x576B},	// CJK UNIFIED IDEOGRAPH
	{0xCBF6,	0x5771},	// CJK UNIFIED IDEOGRAPH
	{0xCBF7,	0x5770},	// CJK UNIFIED IDEOGRAPH
	{0xCBF8,	0x5776},	// CJK UNIFIED IDEOGRAPH
	{0xCBF9,	0x5780},	// CJK UNIFIED IDEOGRAPH
	{0xCBFA,	0x5775},	// CJK UNIFIED IDEOGRAPH
	{0xCBFB,	0x577B},	// CJK UNIFIED IDEOGRAPH
	{0xCBFC,	0x5773},	// CJK UNIFIED IDEOGRAPH
	{0xCBFD,	0x5774},	// CJK UNIFIED IDEOGRAPH
	{0xCBFE,	0x5762},	// CJK UNIFIED IDEOGRAPH
	{0xCC40,	0x5768},	// CJK UNIFIED IDEOGRAPH
	{0xCC41,	0x577D},	// CJK UNIFIED IDEOGRAPH
	{0xCC42,	0x590C},	// CJK UNIFIED IDEOGRAPH
	{0xCC43,	0x5945},	// CJK UNIFIED IDEOGRAPH
	{0xCC44,	0x59B5},	// CJK UNIFIED IDEOGRAPH
	{0xCC45,	0x59BA},	// CJK UNIFIED IDEOGRAPH
	{0xCC46,	0x59CF},	// CJK UNIFIED IDEOGRAPH
	{0xCC47,	0x59CE},	// CJK UNIFIED IDEOGRAPH
	{0xCC48,	0x59B2},	// CJK UNIFIED IDEOGRAPH
	{0xCC49,	0x59CC},	// CJK UNIFIED IDEOGRAPH
	{0xCC4A,	0x59C1},	// CJK UNIFIED IDEOGRAPH
	{0xCC4B,	0x59B6},	// CJK UNIFIED IDEOGRAPH
	{0xCC4C,	0x59BC},	// CJK UNIFIED IDEOGRAPH
	{0xCC4D,	0x59C3},	// CJK UNIFIED IDEOGRAPH
	{0xCC4E,	0x59D6},	// CJK UNIFIED IDEOGRAPH
	{0xCC4F,	0x59B1},	// CJK UNIFIED IDEOGRAPH
	{0xCC50,	0x59BD},	// CJK UNIFIED IDEOGRAPH
	{0xCC51,	0x59C0},	// CJK UNIFIED IDEOGRAPH
	{0xCC52,	0x59C8},	// CJK UNIFIED IDEOGRAPH
	{0xCC53,	0x59B4},	// CJK UNIFIED IDEOGRAPH
	{0xCC54,	0x59C7},	// CJK UNIFIED IDEOGRAPH
	{0xCC55,	0x5B62},	// CJK UNIFIED IDEOGRAPH
	{0xCC56,	0x5B65},	// CJK UNIFIED IDEOGRAPH
	{0xCC57,	0x5B93},	// CJK UNIFIED IDEOGRAPH
	{0xCC58,	0x5B95},	// CJK UNIFIED IDEOGRAPH
	{0xCC59,	0x5C44},	// CJK UNIFIED IDEOGRAPH
	{0xCC5A,	0x5C47},	// CJK UNIFIED IDEOGRAPH
	{0xCC5B,	0x5CAE},	// CJK UNIFIED IDEOGRAPH
	{0xCC5C,	0x5CA4},	// CJK UNIFIED IDEOGRAPH
	{0xCC5D,	0x5CA0},	// CJK UNIFIED IDEOGRAPH
	{0xCC5E,	0x5CB5},	// CJK UNIFIED IDEOGRAPH
	{0xCC5F,	0x5CAF},	// CJK UNIFIED IDEOGRAPH
	{0xCC60,	0x5CA8},	// CJK UNIFIED IDEOGRAPH
	{0xCC61,	0x5CAC},	// CJK UNIFIED IDEOGRAPH
	{0xCC62,	0x5C9F},	// CJK UNIFIED IDEOGRAPH
	{0xCC63,	0x5CA3},	// CJK UNIFIED IDEOGRAPH
	{0xCC64,	0x5CAD},	// CJK UNIFIED IDEOGRAPH
	{0xCC65,	0x5CA2},	// CJK UNIFIED IDEOGRAPH
	{0xCC66,	0x5CAA},	// CJK UNIFIED IDEOGRAPH
	{0xCC67,	0x5CA7},	// CJK UNIFIED IDEOGRAPH
	{0xCC68,	0x5C9D},	// CJK UNIFIED IDEOGRAPH
	{0xCC69,	0x5CA5},	// CJK UNIFIED IDEOGRAPH
	{0xCC6A,	0x5CB6},	// CJK UNIFIED IDEOGRAPH
	{0xCC6B,	0x5CB0},	// CJK UNIFIED IDEOGRAPH
	{0xCC6C,	0x5CA6},	// CJK UNIFIED IDEOGRAPH
	{0xCC6D,	0x5E17},	// CJK UNIFIED IDEOGRAPH
	{0xCC6E,	0x5E14},	// CJK UNIFIED IDEOGRAPH
	{0xCC6F,	0x5E19},	// CJK UNIFIED IDEOGRAPH
	{0xCC70,	0x5F28},	// CJK UNIFIED IDEOGRAPH
	{0xCC71,	0x5F22},	// CJK UNIFIED IDEOGRAPH
	{0xCC72,	0x5F23},	// CJK UNIFIED IDEOGRAPH
	{0xCC73,	0x5F24},	// CJK UNIFIED IDEOGRAPH
	{0xCC74,	0x5F54},	// CJK UNIFIED IDEOGRAPH
	{0xCC75,	0x5F82},	// CJK UNIFIED IDEOGRAPH
	{0xCC76,	0x5F7E},	// CJK UNIFIED IDEOGRAPH
	{0xCC77,	0x5F7D},	// CJK UNIFIED IDEOGRAPH
	{0xCC78,	0x5FDE},	// CJK UNIFIED IDEOGRAPH
	{0xCC79,	0x5FE5},	// CJK UNIFIED IDEOGRAPH
	{0xCC7A,	0x602D},	// CJK UNIFIED IDEOGRAPH
	{0xCC7B,	0x6026},	// CJK UNIFIED IDEOGRAPH
	{0xCC7C,	0x6019},	// CJK UNIFIED IDEOGRAPH
	{0xCC7D,	0x6032},	// CJK UNIFIED IDEOGRAPH
	{0xCC7E,	0x600B},	// CJK UNIFIED IDEOGRAPH
	{0xCCA1,	0x6034},	// CJK UNIFIED IDEOGRAPH
	{0xCCA2,	0x600A},	// CJK UNIFIED IDEOGRAPH
	{0xCCA3,	0x6017},	// CJK UNIFIED IDEOGRAPH
	{0xCCA4,	0x6033},	// CJK UNIFIED IDEOGRAPH
	{0xCCA5,	0x601A},	// CJK UNIFIED IDEOGRAPH
	{0xCCA6,	0x601E},	// CJK UNIFIED IDEOGRAPH
	{0xCCA7,	0x602C},	// CJK UNIFIED IDEOGRAPH
	{0xCCA8,	0x6022},	// CJK UNIFIED IDEOGRAPH
	{0xCCA9,	0x600D},	// CJK UNIFIED IDEOGRAPH
	{0xCCAA,	0x6010},	// CJK UNIFIED IDEOGRAPH
	{0xCCAB,	0x602E},	// CJK UNIFIED IDEOGRAPH
	{0xCCAC,	0x6013},	// CJK UNIFIED IDEOGRAPH
	{0xCCAD,	0x6011},	// CJK UNIFIED IDEOGRAPH
	{0xCCAE,	0x600C},	// CJK UNIFIED IDEOGRAPH
	{0xCCAF,	0x6009},	// CJK UNIFIED IDEOGRAPH
	{0xCCB0,	0x601C},	// CJK UNIFIED IDEOGRAPH
	{0xCCB1,	0x6214},	// CJK UNIFIED IDEOGRAPH
	{0xCCB2,	0x623D},	// CJK UNIFIED IDEOGRAPH
	{0xCCB3,	0x62AD},	// CJK UNIFIED IDEOGRAPH
	{0xCCB4,	0x62B4},	// CJK UNIFIED IDEOGRAPH
	{0xCCB5,	0x62D1},	// CJK UNIFIED IDEOGRAPH
	{0xCCB6,	0x62BE},	// CJK UNIFIED IDEOGRAPH
	{0xCCB7,	0x62AA},	// CJK UNIFIED IDEOGRAPH
	{0xCCB8,	0x62B6},	// CJK UNIFIED IDEOGRAPH
	{0xCCB9,	0x62CA},	// CJK UNIFIED IDEOGRAPH
	{0xCCBA,	0x62AE},	// CJK UNIFIED IDEOGRAPH
	{0xCCBB,	0x62B3},	// CJK UNIFIED IDEOGRAPH
	{0xCCBC,	0x62AF},	// CJK UNIFIED IDEOGRAPH
	{0xCCBD,	0x62BB},	// CJK UNIFIED IDEOGRAPH
	{0xCCBE,	0x62A9},	// CJK UNIFIED IDEOGRAPH
	{0xCCBF,	0x62B0},	// CJK UNIFIED IDEOGRAPH
	{0xCCC0,	0x62B8},	// CJK UNIFIED IDEOGRAPH
	{0xCCC1,	0x653D},	// CJK UNIFIED IDEOGRAPH
	{0xCCC2,	0x65A8},	// CJK UNIFIED IDEOGRAPH
	{0xCCC3,	0x65BB},	// CJK UNIFIED IDEOGRAPH
	{0xCCC4,	0x6609},	// CJK UNIFIED IDEOGRAPH
	{0xCCC5,	0x65FC},	// CJK UNIFIED IDEOGRAPH
	{0xCCC6,	0x6604},	// CJK UNIFIED IDEOGRAPH
	{0xCCC7,	0x6612},	// CJK UNIFIED IDEOGRAPH
	{0xCCC8,	0x6608},	// CJK UNIFIED IDEOGRAPH
	{0xCCC9,	0x65FB},	// CJK UNIFIED IDEOGRAPH
	{0xCCCA,	0x6603},	// CJK UNIFIED IDEOGRAPH
	{0xCCCB,	0x660B},	// CJK UNIFIED IDEOGRAPH
	{0xCCCC,	0x660D},	// CJK UNIFIED IDEOGRAPH
	{0xCCCD,	0x6605},	// CJK UNIFIED IDEOGRAPH
	{0xCCCE,	0x65FD},	// CJK UNIFIED IDEOGRAPH
	{0xCCCF,	0x6611},	// CJK UNIFIED IDEOGRAPH
	{0xCCD0,	0x6610},	// CJK UNIFIED IDEOGRAPH
	{0xCCD1,	0x66F6},	// CJK UNIFIED IDEOGRAPH
	{0xCCD2,	0x670A},	// CJK UNIFIED IDEOGRAPH
	{0xCCD3,	0x6785},	// CJK UNIFIED IDEOGRAPH
	{0xCCD4,	0x676C},	// CJK UNIFIED IDEOGRAPH
	{0xCCD5,	0x678E},	// CJK UNIFIED IDEOGRAPH
	{0xCCD6,	0x6792},	// CJK UNIFIED IDEOGRAPH
	{0xCCD7,	0x6776},	// CJK UNIFIED IDEOGRAPH
	{0xCCD8,	0x677B},	// CJK UNIFIED IDEOGRAPH
	{0xCCD9,	0x6798},	// CJK UNIFIED IDEOGRAPH
	{0xCCDA,	0x6786},	// CJK UNIFIED IDEOGRAPH
	{0xCCDB,	0x6784},	// CJK UNIFIED IDEOGRAPH
	{0xCCDC,	0x6774},	// CJK UNIFIED IDEOGRAPH
	{0xCCDD,	0x678D},	// CJK UNIFIED IDEOGRAPH
	{0xCCDE,	0x678C},	// CJK UNIFIED IDEOGRAPH
	{0xCCDF,	0x677A},	// CJK UNIFIED IDEOGRAPH
	{0xCCE0,	0x679F},	// CJK UNIFIED IDEOGRAPH
	{0xCCE1,	0x6791},	// CJK UNIFIED IDEOGRAPH
	{0xCCE2,	0x6799},	// CJK UNIFIED IDEOGRAPH
	{0xCCE3,	0x6783},	// CJK UNIFIED IDEOGRAPH
	{0xCCE4,	0x677D},	// CJK UNIFIED IDEOGRAPH
	{0xCCE5,	0x6781},	// CJK UNIFIED IDEOGRAPH
	{0xCCE6,	0x6778},	// CJK UNIFIED IDEOGRAPH
	{0xCCE7,	0x6779},	// CJK UNIFIED IDEOGRAPH
	{0xCCE8,	0x6794},	// CJK UNIFIED IDEOGRAPH
	{0xCCE9,	0x6B25},	// CJK UNIFIED IDEOGRAPH
	{0xCCEA,	0x6B80},	// CJK UNIFIED IDEOGRAPH
	{0xCCEB,	0x6B7E},	// CJK UNIFIED IDEOGRAPH
	{0xCCEC,	0x6BDE},	// CJK UNIFIED IDEOGRAPH
	{0xCCED,	0x6C1D},	// CJK UNIFIED IDEOGRAPH
	{0xCCEE,	0x6C93},	// CJK UNIFIED IDEOGRAPH
	{0xCCEF,	0x6CEC},	// CJK UNIFIED IDEOGRAPH
	{0xCCF0,	0x6CEB},	// CJK UNIFIED IDEOGRAPH
	{0xCCF1,	0x6CEE},	// CJK UNIFIED IDEOGRAPH
	{0xCCF2,	0x6CD9},	// CJK UNIFIED IDEOGRAPH
	{0xCCF3,	0x6CB6},	// CJK UNIFIED IDEOGRAPH
	{0xCCF4,	0x6CD4},	// CJK UNIFIED IDEOGRAPH
	{0xCCF5,	0x6CAD},	// CJK UNIFIED IDEOGRAPH
	{0xCCF6,	0x6CE7},	// CJK UNIFIED IDEOGRAPH
	{0xCCF7,	0x6CB7},	// CJK UNIFIED IDEOGRAPH
	{0xCCF8,	0x6CD0},	// CJK UNIFIED IDEOGRAPH
	{0xCCF9,	0x6CC2},	// CJK UNIFIED IDEOGRAPH
	{0xCCFA,	0x6CBA},	// CJK UNIFIED IDEOGRAPH
	{0xCCFB,	0x6CC3},	// CJK UNIFIED IDEOGRAPH
	{0xCCFC,	0x6CC6},	// CJK UNIFIED IDEOGRAPH
	{0xCCFD,	0x6CED},	// CJK UNIFIED IDEOGRAPH
	{0xCCFE,	0x6CF2},	// CJK UNIFIED IDEOGRAPH
	{0xCD40,	0x6CD2},	// CJK UNIFIED IDEOGRAPH
	{0xCD41,	0x6CDD},	// CJK UNIFIED IDEOGRAPH
	{0xCD42,	0x6CB4},	// CJK UNIFIED IDEOGRAPH
	{0xCD43,	0x6C8A},	// CJK UNIFIED IDEOGRAPH
	{0xCD44,	0x6C9D},	// CJK UNIFIED IDEOGRAPH
	{0xCD45,	0x6C80},	// CJK UNIFIED IDEOGRAPH
	{0xCD46,	0x6CDE},	// CJK UNIFIED IDEOGRAPH
	{0xCD47,	0x6CC0},	// CJK UNIFIED IDEOGRAPH
	{0xCD48,	0x6D30},	// CJK UNIFIED IDEOGRAPH
	{0xCD49,	0x6CCD},	// CJK UNIFIED IDEOGRAPH
	{0xCD4A,	0x6CC7},	// CJK UNIFIED IDEOGRAPH
	{0xCD4B,	0x6CB0},	// CJK UNIFIED IDEOGRAPH
	{0xCD4C,	0x6CF9},	// CJK UNIFIED IDEOGRAPH
	{0xCD4D,	0x6CCF},	// CJK UNIFIED IDEOGRAPH
	{0xCD4E,	0x6CE9},	// CJK UNIFIED IDEOGRAPH
	{0xCD4F,	0x6CD1},	// CJK UNIFIED IDEOGRAPH
	{0xCD50,	0x7094},	// CJK UNIFIED IDEOGRAPH
	{0xCD51,	0x7098},	// CJK UNIFIED IDEOGRAPH
	{0xCD52,	0x7085},	// CJK UNIFIED IDEOGRAPH
	{0xCD53,	0x7093},	// CJK UNIFIED IDEOGRAPH
	{0xCD54,	0x7086},	// CJK UNIFIED IDEOGRAPH
	{0xCD55,	0x7084},	// CJK UNIFIED IDEOGRAPH
	{0xCD56,	0x7091},	// CJK UNIFIED IDEOGRAPH
	{0xCD57,	0x7096},	// CJK UNIFIED IDEOGRAPH
	{0xCD58,	0x7082},	// CJK UNIFIED IDEOGRAPH
	{0xCD59,	0x709A},	// CJK UNIFIED IDEOGRAPH
	{0xCD5A,	0x7083},	// CJK UNIFIED IDEOGRAPH
	{0xCD5B,	0x726A},	// CJK UNIFIED IDEOGRAPH
	{0xCD5C,	0x72D6},	// CJK UNIFIED IDEOGRAPH
	{0xCD5D,	0x72CB},	// CJK UNIFIED IDEOGRAPH
	{0xCD5E,	0x72D8},	// CJK UNIFIED IDEOGRAPH
	{0xCD5F,	0x72C9},	// CJK UNIFIED IDEOGRAPH
	{0xCD60,	0x72DC},	// CJK UNIFIED IDEOGRAPH
	{0xCD61,	0x72D2},	// CJK UNIFIED IDEOGRAPH
	{0xCD62,	0x72D4},	// CJK UNIFIED IDEOGRAPH
	{0xCD63,	0x72DA},	// CJK UNIFIED IDEOGRAPH
	{0xCD64,	0x72CC},	// CJK UNIFIED IDEOGRAPH
	{0xCD65,	0x72D1},	// CJK UNIFIED IDEOGRAPH
	{0xCD66,	0x73A4},	// CJK UNIFIED IDEOGRAPH
	{0xCD67,	0x73A1},	// CJK UNIFIED IDEOGRAPH
	{0xCD68,	0x73AD},	// CJK UNIFIED IDEOGRAPH
	{0xCD69,	0x73A6},	// CJK UNIFIED IDEOGRAPH
	{0xCD6A,	0x73A2},	// CJK UNIFIED IDEOGRAPH
	{0xCD6B,	0x73A0},	// CJK UNIFIED IDEOGRAPH
	{0xCD6C,	0x73AC},	// CJK UNIFIED IDEOGRAPH
	{0xCD6D,	0x739D},	// CJK UNIFIED IDEOGRAPH
	{0xCD6E,	0x74DD},	// CJK UNIFIED IDEOGRAPH
	{0xCD6F,	0x74E8},	// CJK UNIFIED IDEOGRAPH
	{0xCD70,	0x753F},	// CJK UNIFIED IDEOGRAPH
	{0xCD71,	0x7540},	// CJK UNIFIED IDEOGRAPH
	{0xCD72,	0x753E},	// CJK UNIFIED IDEOGRAPH
	{0xCD73,	0x758C},	// CJK UNIFIED IDEOGRAPH
	{0xCD74,	0x7598},	// CJK UNIFIED IDEOGRAPH
	{0xCD75,	0x76AF},	// CJK UNIFIED IDEOGRAPH
	{0xCD76,	0x76F3},	// CJK UNIFIED IDEOGRAPH
	{0xCD77,	0x76F1},	// CJK UNIFIED IDEOGRAPH
	{0xCD78,	0x76F0},	// CJK UNIFIED IDEOGRAPH
	{0xCD79,	0x76F5},	// CJK UNIFIED IDEOGRAPH
	{0xCD7A,	0x77F8},	// CJK UNIFIED IDEOGRAPH
	{0xCD7B,	0x77FC},	// CJK UNIFIED IDEOGRAPH
	{0xCD7C,	0x77F9},	// CJK UNIFIED IDEOGRAPH
	{0xCD7D,	0x77FB},	// CJK UNIFIED IDEOGRAPH
	{0xCD7E,	0x77FA},	// CJK UNIFIED IDEOGRAPH
	{0xCDA1,	0x77F7},	// CJK UNIFIED IDEOGRAPH
	{0xCDA2,	0x7942},	// CJK UNIFIED IDEOGRAPH
	{0xCDA3,	0x793F},	// CJK UNIFIED IDEOGRAPH
	{0xCDA4,	0x79C5},	// CJK UNIFIED IDEOGRAPH
	{0xCDA5,	0x7A78},	// CJK UNIFIED IDEOGRAPH
	{0xCDA6,	0x7A7B},	// CJK UNIFIED IDEOGRAPH
	{0xCDA7,	0x7AFB},	// CJK UNIFIED IDEOGRAPH
	{0xCDA8,	0x7C75},	// CJK UNIFIED IDEOGRAPH
	{0xCDA9,	0x7CFD},	// CJK UNIFIED IDEOGRAPH
	{0xCDAA,	0x8035},	// CJK UNIFIED IDEOGRAPH
	{0xCDAB,	0x808F},	// CJK UNIFIED IDEOGRAPH
	{0xCDAC,	0x80AE},	// CJK UNIFIED IDEOGRAPH
	{0xCDAD,	0x80A3},	// CJK UNIFIED IDEOGRAPH
	{0xCDAE,	0x80B8},	// CJK UNIFIED IDEOGRAPH
	{0xCDAF,	0x80B5},	// CJK UNIFIED IDEOGRAPH
	{0xCDB0,	0x80AD},	// CJK UNIFIED IDEOGRAPH
	{0xCDB1,	0x8220},	// CJK UNIFIED IDEOGRAPH
	{0xCDB2,	0x82A0},	// CJK UNIFIED IDEOGRAPH
	{0xCDB3,	0x82C0},	// CJK UNIFIED IDEOGRAPH
	{0xCDB4,	0x82AB},	// CJK UNIFIED IDEOGRAPH
	{0xCDB5,	0x829A},	// CJK UNIFIED IDEOGRAPH
	{0xCDB6,	0x8298},	// CJK UNIFIED IDEOGRAPH
	{0xCDB7,	0x829B},	// CJK UNIFIED IDEOGRAPH
	{0xCDB8,	0x82B5},	// CJK UNIFIED IDEOGRAPH
	{0xCDB9,	0x82A7},	// CJK UNIFIED IDEOGRAPH
	{0xCDBA,	0x82AE},	// CJK UNIFIED IDEOGRAPH
	{0xCDBB,	0x82BC},	// CJK UNIFIED IDEOGRAPH
	{0xCDBC,	0x829E},	// CJK UNIFIED IDEOGRAPH
	{0xCDBD,	0x82BA},	// CJK UNIFIED IDEOGRAPH
	{0xCDBE,	0x82B4},	// CJK UNIFIED IDEOGRAPH
	{0xCDBF,	0x82A8},	// CJK UNIFIED IDEOGRAPH
	{0xCDC0,	0x82A1},	// CJK UNIFIED IDEOGRAPH
	{0xCDC1,	0x82A9},	// CJK UNIFIED IDEOGRAPH
	{0xCDC2,	0x82C2},	// CJK UNIFIED IDEOGRAPH
	{0xCDC3,	0x82A4},	// CJK UNIFIED IDEOGRAPH
	{0xCDC4,	0x82C3},	// CJK UNIFIED IDEOGRAPH
	{0xCDC5,	0x82B6},	// CJK UNIFIED IDEOGRAPH
	{0xCDC6,	0x82A2},	// CJK UNIFIED IDEOGRAPH
	{0xCDC7,	0x8670},	// CJK UNIFIED IDEOGRAPH
	{0xCDC8,	0x866F},	// CJK UNIFIED IDEOGRAPH
	{0xCDC9,	0x866D},	// CJK UNIFIED IDEOGRAPH
	{0xCDCA,	0x866E},	// CJK UNIFIED IDEOGRAPH
	{0xCDCB,	0x8C56},	// CJK UNIFIED IDEOGRAPH
	{0xCDCC,	0x8FD2},	// CJK UNIFIED IDEOGRAPH
	{0xCDCD,	0x8FCB},	// CJK UNIFIED IDEOGRAPH
	{0xCDCE,	0x8FD3},	// CJK UNIFIED IDEOGRAPH
	{0xCDCF,	0x8FCD},	// CJK UNIFIED IDEOGRAPH
	{0xCDD0,	0x8FD6},	// CJK UNIFIED IDEOGRAPH
	{0xCDD1,	0x8FD5},	// CJK UNIFIED IDEOGRAPH
	{0xCDD2,	0x8FD7},	// CJK UNIFIED IDEOGRAPH
	{0xCDD3,	0x90B2},	// CJK UNIFIED IDEOGRAPH
	{0xCDD4,	0x90B4},	// CJK UNIFIED IDEOGRAPH
	{0xCDD5,	0x90AF},	// CJK UNIFIED IDEOGRAPH
	{0xCDD6,	0x90B3},	// CJK UNIFIED IDEOGRAPH
	{0xCDD7,	0x90B0},	// CJK UNIFIED IDEOGRAPH
	{0xCDD8,	0x9639},	// CJK UNIFIED IDEOGRAPH
	{0xCDD9,	0x963D},	// CJK UNIFIED IDEOGRAPH
	{0xCDDA,	0x963C},	// CJK UNIFIED IDEOGRAPH
	{0xCDDB,	0x963A},	// CJK UNIFIED IDEOGRAPH
	{0xCDDC,	0x9643},	// CJK UNIFIED IDEOGRAPH
	{0xCDDD,	0x4FCD},	// CJK UNIFIED IDEOGRAPH
	{0xCDDE,	0x4FC5},	// CJK UNIFIED IDEOGRAPH
	{0xCDDF,	0x4FD3},	// CJK UNIFIED IDEOGRAPH
	{0xCDE0,	0x4FB2},	// CJK UNIFIED IDEOGRAPH
	{0xCDE1,	0x4FC9},	// CJK UNIFIED IDEOGRAPH
	{0xCDE2,	0x4FCB},	// CJK UNIFIED IDEOGRAPH
	{0xCDE3,	0x4FC1},	// CJK UNIFIED IDEOGRAPH
	{0xCDE4,	0x4FD4},	// CJK UNIFIED IDEOGRAPH
	{0xCDE5,	0x4FDC},	// CJK UNIFIED IDEOGRAPH
	{0xCDE6,	0x4FD9},	// CJK UNIFIED IDEOGRAPH
	{0xCDE7,	0x4FBB},	// CJK UNIFIED IDEOGRAPH
	{0xCDE8,	0x4FB3},	// CJK UNIFIED IDEOGRAPH
	{0xCDE9,	0x4FDB},	// CJK UNIFIED IDEOGRAPH
	{0xCDEA,	0x4FC7},	// CJK UNIFIED IDEOGRAPH
	{0xCDEB,	0x4FD6},	// CJK UNIFIED IDEOGRAPH
	{0xCDEC,	0x4FBA},	// CJK UNIFIED IDEOGRAPH
	{0xCDED,	0x4FC0},	// CJK UNIFIED IDEOGRAPH
	{0xCDEE,	0x4FB9},	// CJK UNIFIED IDEOGRAPH
	{0xCDEF,	0x4FEC},	// CJK UNIFIED IDEOGRAPH
	{0xCDF0,	0x5244},	// CJK UNIFIED IDEOGRAPH
	{0xCDF1,	0x5249},	// CJK UNIFIED IDEOGRAPH
	{0xCDF2,	0x52C0},	// CJK UNIFIED IDEOGRAPH
	{0xCDF3,	0x52C2},	// CJK UNIFIED IDEOGRAPH
	{0xCDF4,	0x533D},	// CJK UNIFIED IDEOGRAPH
	{0xCDF5,	0x537C},	// CJK UNIFIED IDEOGRAPH
	{0xCDF6,	0x5397},	// CJK UNIFIED IDEOGRAPH
	{0xCDF7,	0x5396},	// CJK UNIFIED IDEOGRAPH
	{0xCDF8,	0x5399},	// CJK UNIFIED IDEOGRAPH
	{0xCDF9,	0x5398},	// CJK UNIFIED IDEOGRAPH
	{0xCDFA,	0x54BA},	// CJK UNIFIED IDEOGRAPH
	{0xCDFB,	0x54A1},	// CJK UNIFIED IDEOGRAPH
	{0xCDFC,	0x54AD},	// CJK UNIFIED IDEOGRAPH
	{0xCDFD,	0x54A5},	// CJK UNIFIED IDEOGRAPH
	{0xCDFE,	0x54CF},	// CJK UNIFIED IDEOGRAPH
	{0xCE40,	0x54C3},	// CJK UNIFIED IDEOGRAPH
	{0xCE41,	0x830D},	// CJK UNIFIED IDEOGRAPH
	{0xCE42,	0x54B7},	// CJK UNIFIED IDEOGRAPH
	{0xCE43,	0x54AE},	// CJK UNIFIED IDEOGRAPH
	{0xCE44,	0x54D6},	// CJK UNIFIED IDEOGRAPH
	{0xCE45,	0x54B6},	// CJK UNIFIED IDEOGRAPH
	{0xCE46,	0x54C5},	// CJK UNIFIED IDEOGRAPH
	{0xCE47,	0x54C6},	// CJK UNIFIED IDEOGRAPH
	{0xCE48,	0x54A0},	// CJK UNIFIED IDEOGRAPH
	{0xCE49,	0x5470},	// CJK UNIFIED IDEOGRAPH
	{0xCE4A,	0x54BC},	// CJK UNIFIED IDEOGRAPH
	{0xCE4B,	0x54A2},	// CJK UNIFIED IDEOGRAPH
	{0xCE4C,	0x54BE},	// CJK UNIFIED IDEOGRAPH
	{0xCE4D,	0x5472},	// CJK UNIFIED IDEOGRAPH
	{0xCE4E,	0x54DE},	// CJK UNIFIED IDEOGRAPH
	{0xCE4F,	0x54B0},	// CJK UNIFIED IDEOGRAPH
	{0xCE50,	0x57B5},	// CJK UNIFIED IDEOGRAPH
	{0xCE51,	0x579E},	// CJK UNIFIED IDEOGRAPH
	{0xCE52,	0x579F},	// CJK UNIFIED IDEOGRAPH
	{0xCE53,	0x57A4},	// CJK UNIFIED IDEOGRAPH
	{0xCE54,	0x578C},	// CJK UNIFIED IDEOGRAPH
	{0xCE55,	0x5797},	// CJK UNIFIED IDEOGRAPH
	{0xCE56,	0x579D},	// CJK UNIFIED IDEOGRAPH
	{0xCE57,	0x579B},	// CJK UNIFIED IDEOGRAPH
	{0xCE58,	0x5794},	// CJK UNIFIED IDEOGRAPH
	{0xCE59,	0x5798},	// CJK UNIFIED IDEOGRAPH
	{0xCE5A,	0x578F},	// CJK UNIFIED IDEOGRAPH
	{0xCE5B,	0x5799},	// CJK UNIFIED IDEOGRAPH
	{0xCE5C,	0x57A5},	// CJK UNIFIED IDEOGRAPH
	{0xCE5D,	0x579A},	// CJK UNIFIED IDEOGRAPH
	{0xCE5E,	0x5795},	// CJK UNIFIED IDEOGRAPH
	{0xCE5F,	0x58F4},	// CJK UNIFIED IDEOGRAPH
	{0xCE60,	0x590D},	// CJK UNIFIED IDEOGRAPH
	{0xCE61,	0x5953},	// CJK UNIFIED IDEOGRAPH
	{0xCE62,	0x59E1},	// CJK UNIFIED IDEOGRAPH
	{0xCE63,	0x59DE},	// CJK UNIFIED IDEOGRAPH
	{0xCE64,	0x59EE},	// CJK UNIFIED IDEOGRAPH
	{0xCE65,	0x5A00},	// CJK UNIFIED IDEOGRAPH
	{0xCE66,	0x59F1},	// CJK UNIFIED IDEOGRAPH
	{0xCE67,	0x59DD},	// CJK UNIFIED IDEOGRAPH
	{0xCE68,	0x59FA},	// CJK UNIFIED IDEOGRAPH
	{0xCE69,	0x59FD},	// CJK UNIFIED IDEOGRAPH
	{0xCE6A,	0x59FC},	// CJK UNIFIED IDEOGRAPH
	{0xCE6B,	0x59F6},	// CJK UNIFIED IDEOGRAPH
	{0xCE6C,	0x59E4},	// CJK UNIFIED IDEOGRAPH
	{0xCE6D,	0x59F2},	// CJK UNIFIED IDEOGRAPH
	{0xCE6E,	0x59F7},	// CJK UNIFIED IDEOGRAPH
	{0xCE6F,	0x59DB},	// CJK UNIFIED IDEOGRAPH
	{0xCE70,	0x59E9},	// CJK UNIFIED IDEOGRAPH
	{0xCE71,	0x59F3},	// CJK UNIFIED IDEOGRAPH
	{0xCE72,	0x59F5},	// CJK UNIFIED IDEOGRAPH
	{0xCE73,	0x59E0},	// CJK UNIFIED IDEOGRAPH
	{0xCE74,	0x59FE},	// CJK UNIFIED IDEOGRAPH
	{0xCE75,	0x59F4},	// CJK UNIFIED IDEOGRAPH
	{0xCE76,	0x59ED},	// CJK UNIFIED IDEOGRAPH
	{0xCE77,	0x5BA8},	// CJK UNIFIED IDEOGRAPH
	{0xCE78,	0x5C4C},	// CJK UNIFIED IDEOGRAPH
	{0xCE79,	0x5CD0},	// CJK UNIFIED IDEOGRAPH
	{0xCE7A,	0x5CD8},	// CJK UNIFIED IDEOGRAPH
	{0xCE7B,	0x5CCC},	// CJK UNIFIED IDEOGRAPH
	{0xCE7C,	0x5CD7},	// CJK UNIFIED IDEOGRAPH
	{0xCE7D,	0x5CCB},	// CJK UNIFIED IDEOGRAPH
	{0xCE7E,	0x5CDB},	// CJK UNIFIED IDEOGRAPH
	{0xCEA1,	0x5CDE},	// CJK UNIFIED IDEOGRAPH
	{0xCEA2,	0x5CDA},	// CJK UNIFIED IDEOGRAPH
	{0xCEA3,	0x5CC9},	// CJK UNIFIED IDEOGRAPH
	{0xCEA4,	0x5CC7},	// CJK UNIFIED IDEOGRAPH
	{0xCEA5,	0x5CCA},	// CJK UNIFIED IDEOGRAPH
	{0xCEA6,	0x5CD6},	// CJK UNIFIED IDEOGRAPH
	{0xCEA7,	0x5CD3},	// CJK UNIFIED IDEOGRAPH
	{0xCEA8,	0x5CD4},	// CJK UNIFIED IDEOGRAPH
	{0xCEA9,	0x5CCF},	// CJK UNIFIED IDEOGRAPH
	{0xCEAA,	0x5CC8},	// CJK UNIFIED IDEOGRAPH
	{0xCEAB,	0x5CC6},	// CJK UNIFIED IDEOGRAPH
	{0xCEAC,	0x5CCE},	// CJK UNIFIED IDEOGRAPH
	{0xCEAD,	0x5CDF},	// CJK UNIFIED IDEOGRAPH
	{0xCEAE,	0x5CF8},	// CJK UNIFIED IDEOGRAPH
	{0xCEAF,	0x5DF9},	// CJK UNIFIED IDEOGRAPH
	{0xCEB0,	0x5E21},	// CJK UNIFIED IDEOGRAPH
	{0xCEB1,	0x5E22},	// CJK UNIFIED IDEOGRAPH
	{0xCEB2,	0x5E23},	// CJK UNIFIED IDEOGRAPH
	{0xCEB3,	0x5E20},	// CJK UNIFIED IDEOGRAPH
	{0xCEB4,	0x5E24},	// CJK UNIFIED IDEOGRAPH
	{0xCEB5,	0x5EB0},	// CJK UNIFIED IDEOGRAPH
	{0xCEB6,	0x5EA4},	// CJK UNIFIED IDEOGRAPH
	{0xCEB7,	0x5EA2},	// CJK UNIFIED IDEOGRAPH
	{0xCEB8,	0x5E9B},	// CJK UNIFIED IDEOGRAPH
	{0xCEB9,	0x5EA3},	// CJK UNIFIED IDEOGRAPH
	{0xCEBA,	0x5EA5},	// CJK UNIFIED IDEOGRAPH
	{0xCEBB,	0x5F07},	// CJK UNIFIED IDEOGRAPH
	{0xCEBC,	0x5F2E},	// CJK UNIFIED IDEOGRAPH
	{0xCEBD,	0x5F56},	// CJK UNIFIED IDEOGRAPH
	{0xCEBE,	0x5F86},	// CJK UNIFIED IDEOGRAPH
	{0xCEBF,	0x6037},	// CJK UNIFIED IDEOGRAPH
	{0xCEC0,	0x6039},	// CJK UNIFIED IDEOGRAPH
	{0xCEC1,	0x6054},	// CJK UNIFIED IDEOGRAPH
	{0xCEC2,	0x6072},	// CJK UNIFIED IDEOGRAPH
	{0xCEC3,	0x605E},	// CJK UNIFIED IDEOGRAPH
	{0xCEC4,	0x6045},	// CJK UNIFIED IDEOGRAPH
	{0xCEC5,	0x6053},	// CJK UNIFIED IDEOGRAPH
	{0xCEC6,	0x6047},	// CJK UNIFIED IDEOGRAPH
	{0xCEC7,	0x6049},	// CJK UNIFIED IDEOGRAPH
	{0xCEC8,	0x605B},	// CJK UNIFIED IDEOGRAPH
	{0xCEC9,	0x604C},	// CJK UNIFIED IDEOGRAPH
	{0xCECA,	0x6040},	// CJK UNIFIED IDEOGRAPH
	{0xCECB,	0x6042},	// CJK UNIFIED IDEOGRAPH
	{0xCECC,	0x605F},	// CJK UNIFIED IDEOGRAPH
	{0xCECD,	0x6024},	// CJK UNIFIED IDEOGRAPH
	{0xCECE,	0x6044},	// CJK UNIFIED IDEOGRAPH
	{0xCECF,	0x6058},	// CJK UNIFIED IDEOGRAPH
	{0xCED0,	0x6066},	// CJK UNIFIED IDEOGRAPH
	{0xCED1,	0x606E},	// CJK UNIFIED IDEOGRAPH
	{0xCED2,	0x6242},	// CJK UNIFIED IDEOGRAPH
	{0xCED3,	0x6243},	// CJK UNIFIED IDEOGRAPH
	{0xCED4,	0x62CF},	// CJK UNIFIED IDEOGRAPH
	{0xCED5,	0x630D},	// CJK UNIFIED IDEOGRAPH
	{0xCED6,	0x630B},	// CJK UNIFIED IDEOGRAPH
	{0xCED7,	0x62F5},	// CJK UNIFIED IDEOGRAPH
	{0xCED8,	0x630E},	// CJK UNIFIED IDEOGRAPH
	{0xCED9,	0x6303},	// CJK UNIFIED IDEOGRAPH
	{0xCEDA,	0x62EB},	// CJK UNIFIED IDEOGRAPH
	{0xCEDB,	0x62F9},	// CJK UNIFIED IDEOGRAPH
	{0xCEDC,	0x630F},	// CJK UNIFIED IDEOGRAPH
	{0xCEDD,	0x630C},	// CJK UNIFIED IDEOGRAPH
	{0xCEDE,	0x62F8},	// CJK UNIFIED IDEOGRAPH
	{0xCEDF,	0x62F6},	// CJK UNIFIED IDEOGRAPH
	{0xCEE0,	0x6300},	// CJK UNIFIED IDEOGRAPH
	{0xCEE1,	0x6313},	// CJK UNIFIED IDEOGRAPH
	{0xCEE2,	0x6314},	// CJK UNIFIED IDEOGRAPH
	{0xCEE3,	0x62FA},	// CJK UNIFIED IDEOGRAPH
	{0xCEE4,	0x6315},	// CJK UNIFIED IDEOGRAPH
	{0xCEE5,	0x62FB},	// CJK UNIFIED IDEOGRAPH
	{0xCEE6,	0x62F0},	// CJK UNIFIED IDEOGRAPH
	{0xCEE7,	0x6541},	// CJK UNIFIED IDEOGRAPH
	{0xCEE8,	0x6543},	// CJK UNIFIED IDEOGRAPH
	{0xCEE9,	0x65AA},	// CJK UNIFIED IDEOGRAPH
	{0xCEEA,	0x65BF},	// CJK UNIFIED IDEOGRAPH
	{0xCEEB,	0x6636},	// CJK UNIFIED IDEOGRAPH
	{0xCEEC,	0x6621},	// CJK UNIFIED IDEOGRAPH
	{0xCEED,	0x6632},	// CJK UNIFIED IDEOGRAPH
	{0xCEEE,	0x6635},	// CJK UNIFIED IDEOGRAPH
	{0xCEEF,	0x661C},	// CJK UNIFIED IDEOGRAPH
	{0xCEF0,	0x6626},	// CJK UNIFIED IDEOGRAPH
	{0xCEF1,	0x6622},	// CJK UNIFIED IDEOGRAPH
	{0xCEF2,	0x6633},	// CJK UNIFIED IDEOGRAPH
	{0xCEF3,	0x662B},	// CJK UNIFIED IDEOGRAPH
	{0xCEF4,	0x663A},	// CJK UNIFIED IDEOGRAPH
	{0xCEF5,	0x661D},	// CJK UNIFIED IDEOGRAPH
	{0xCEF6,	0x6634},	// CJK UNIFIED IDEOGRAPH
	{0xCEF7,	0x6639},	// CJK UNIFIED IDEOGRAPH
	{0xCEF8,	0x662E},	// CJK UNIFIED IDEOGRAPH
	{0xCEF9,	0x670F},	// CJK UNIFIED IDEOGRAPH
	{0xCEFA,	0x6710},	// CJK UNIFIED IDEOGRAPH
	{0xCEFB,	0x67C1},	// CJK UNIFIED IDEOGRAPH
	{0xCEFC,	0x67F2},	// CJK UNIFIED IDEOGRAPH
	{0xCEFD,	0x67C8},	// CJK UNIFIED IDEOGRAPH
	{0xCEFE,	0x67BA},	// CJK UNIFIED IDEOGRAPH
	{0xCF40,	0x67DC},	// CJK UNIFIED IDEOGRAPH
	{0xCF41,	0x67BB},	// CJK UNIFIED IDEOGRAPH
	{0xCF42,	0x67F8},	// CJK UNIFIED IDEOGRAPH
	{0xCF43,	0x67D8},	// CJK UNIFIED IDEOGRAPH
	{0xCF44,	0x67C0},	// CJK UNIFIED IDEOGRAPH
	{0xCF45,	0x67B7},	// CJK UNIFIED IDEOGRAPH
	{0xCF46,	0x67C5},	// CJK UNIFIED IDEOGRAPH
	{0xCF47,	0x67EB},	// CJK UNIFIED IDEOGRAPH
	{0xCF48,	0x67E4},	// CJK UNIFIED IDEOGRAPH
	{0xCF49,	0x67DF},	// CJK UNIFIED IDEOGRAPH
	{0xCF4A,	0x67B5},	// CJK UNIFIED IDEOGRAPH
	{0xCF4B,	0x67CD},	// CJK UNIFIED IDEOGRAPH
	{0xCF4C,	0x67B3},	// CJK UNIFIED IDEOGRAPH
	{0xCF4D,	0x67F7},	// CJK UNIFIED IDEOGRAPH
	{0xCF4E,	0x67F6},	// CJK UNIFIED IDEOGRAPH
	{0xCF4F,	0x67EE},	// CJK UNIFIED IDEOGRAPH
	{0xCF50,	0x67E3},	// CJK UNIFIED IDEOGRAPH
	{0xCF51,	0x67C2},	// CJK UNIFIED IDEOGRAPH
	{0xCF52,	0x67B9},	// CJK UNIFIED IDEOGRAPH
	{0xCF53,	0x67CE},	// CJK UNIFIED IDEOGRAPH
	{0xCF54,	0x67E7},	// CJK UNIFIED IDEOGRAPH
	{0xCF55,	0x67F0},	// CJK UNIFIED IDEOGRAPH
	{0xCF56,	0x67B2},	// CJK UNIFIED IDEOGRAPH
	{0xCF57,	0x67FC},	// CJK UNIFIED IDEOGRAPH
	{0xCF58,	0x67C6},	// CJK UNIFIED IDEOGRAPH
	{0xCF59,	0x67ED},	// CJK UNIFIED IDEOGRAPH
	{0xCF5A,	0x67CC},	// CJK UNIFIED IDEOGRAPH
	{0xCF5B,	0x67AE},	// CJK UNIFIED IDEOGRAPH
	{0xCF5C,	0x67E6},	// CJK UNIFIED IDEOGRAPH
	{0xCF5D,	0x67DB},	// CJK UNIFIED IDEOGRAPH
	{0xCF5E,	0x67FA},	// CJK UNIFIED IDEOGRAPH
	{0xCF5F,	0x67C9},	// CJK UNIFIED IDEOGRAPH
	{0xCF60,	0x67CA},	// CJK UNIFIED IDEOGRAPH
	{0xCF61,	0x67C3},	// CJK UNIFIED IDEOGRAPH
	{0xCF62,	0x67EA},	// CJK UNIFIED IDEOGRAPH
	{0xCF63,	0x67CB},	// CJK UNIFIED IDEOGRAPH
	{0xCF64,	0x6B28},	// CJK UNIFIED IDEOGRAPH
	{0xCF65,	0x6B82},	// CJK UNIFIED IDEOGRAPH
	{0xCF66,	0x6B84},	// CJK UNIFIED IDEOGRAPH
	{0xCF67,	0x6BB6},	// CJK UNIFIED IDEOGRAPH
	{0xCF68,	0x6BD6},	// CJK UNIFIED IDEOGRAPH
	{0xCF69,	0x6BD8},	// CJK UNIFIED IDEOGRAPH
	{0xCF6A,	0x6BE0},	// CJK UNIFIED IDEOGRAPH
	{0xCF6B,	0x6C20},	// CJK UNIFIED IDEOGRAPH
	{0xCF6C,	0x6C21},	// CJK UNIFIED IDEOGRAPH
	{0xCF6D,	0x6D28},	// CJK UNIFIED IDEOGRAPH
	{0xCF6E,	0x6D34},	// CJK UNIFIED IDEOGRAPH
	{0xCF6F,	0x6D2D},	// CJK UNIFIED IDEOGRAPH
	{0xCF70,	0x6D1F},	// CJK UNIFIED IDEOGRAPH
	{0xCF71,	0x6D3C},	// CJK UNIFIED IDEOGRAPH
	{0xCF72,	0x6D3F},	// CJK UNIFIED IDEOGRAPH
	{0xCF73,	0x6D12},	// CJK UNIFIED IDEOGRAPH
	{0xCF74,	0x6D0A},	// CJK UNIFIED IDEOGRAPH
	{0xCF75,	0x6CDA},	// CJK UNIFIED IDEOGRAPH
	{0xCF76,	0x6D33},	// CJK UNIFIED IDEOGRAPH
	{0xCF77,	0x6D04},	// CJK UNIFIED IDEOGRAPH
	{0xCF78,	0x6D19},	// CJK UNIFIED IDEOGRAPH
	{0xCF79,	0x6D3A},	// CJK UNIFIED IDEOGRAPH
	{0xCF7A,	0x6D1A},	// CJK UNIFIED IDEOGRAPH
	{0xCF7B,	0x6D11},	// CJK UNIFIED IDEOGRAPH
	{0xCF7C,	0x6D00},	// CJK UNIFIED IDEOGRAPH
	{0xCF7D,	0x6D1D},	// CJK UNIFIED IDEOGRAPH
	{0xCF7E,	0x6D42},	// CJK UNIFIED IDEOGRAPH
	{0xCFA1,	0x6D01},	// CJK UNIFIED IDEOGRAPH
	{0xCFA2,	0x6D18},	// CJK UNIFIED IDEOGRAPH
	{0xCFA3,	0x6D37},	// CJK UNIFIED IDEOGRAPH
	{0xCFA4,	0x6D03},	// CJK UNIFIED IDEOGRAPH
	{0xCFA5,	0x6D0F},	// CJK UNIFIED IDEOGRAPH
	{0xCFA6,	0x6D40},	// CJK UNIFIED IDEOGRAPH
	{0xCFA7,	0x6D07},	// CJK UNIFIED IDEOGRAPH
	{0xCFA8,	0x6D20},	// CJK UNIFIED IDEOGRAPH
	{0xCFA9,	0x6D2C},	// CJK UNIFIED IDEOGRAPH
	{0xCFAA,	0x6D08},	// CJK UNIFIED IDEOGRAPH
	{0xCFAB,	0x6D22},	// CJK UNIFIED IDEOGRAPH
	{0xCFAC,	0x6D09},	// CJK UNIFIED IDEOGRAPH
	{0xCFAD,	0x6D10},	// CJK UNIFIED IDEOGRAPH
	{0xCFAE,	0x70B7},	// CJK UNIFIED IDEOGRAPH
	{0xCFAF,	0x709F},	// CJK UNIFIED IDEOGRAPH
	{0xCFB0,	0x70BE},	// CJK UNIFIED IDEOGRAPH
	{0xCFB1,	0x70B1},	// CJK UNIFIED IDEOGRAPH
	{0xCFB2,	0x70B0},	// CJK UNIFIED IDEOGRAPH
	{0xCFB3,	0x70A1},	// CJK UNIFIED IDEOGRAPH
	{0xCFB4,	0x70B4},	// CJK UNIFIED IDEOGRAPH
	{0xCFB5,	0x70B5},	// CJK UNIFIED IDEOGRAPH
	{0xCFB6,	0x70A9},	// CJK UNIFIED IDEOGRAPH
	{0xCFB7,	0x7241},	// CJK UNIFIED IDEOGRAPH
	{0xCFB8,	0x7249},	// CJK UNIFIED IDEOGRAPH
	{0xCFB9,	0x724A},	// CJK UNIFIED IDEOGRAPH
	{0xCFBA,	0x726C},	// CJK UNIFIED IDEOGRAPH
	{0xCFBB,	0x7270},	// CJK UNIFIED IDEOGRAPH
	{0xCFBC,	0x7273},	// CJK UNIFIED IDEOGRAPH
	{0xCFBD,	0x726E},	// CJK UNIFIED IDEOGRAPH
	{0xCFBE,	0x72CA},	// CJK UNIFIED IDEOGRAPH
	{0xCFBF,	0x72E4},	// CJK UNIFIED IDEOGRAPH
	{0xCFC0,	0x72E8},	// CJK UNIFIED IDEOGRAPH
	{0xCFC1,	0x72EB},	// CJK UNIFIED IDEOGRAPH
	{0xCFC2,	0x72DF},	// CJK UNIFIED IDEOGRAPH
	{0xCFC3,	0x72EA},	// CJK UNIFIED IDEOGRAPH
	{0xCFC4,	0x72E6},	// CJK UNIFIED IDEOGRAPH
	{0xCFC5,	0x72E3},	// CJK UNIFIED IDEOGRAPH
	{0xCFC6,	0x7385},	// CJK UNIFIED IDEOGRAPH
	{0xCFC7,	0x73CC},	// CJK UNIFIED IDEOGRAPH
	{0xCFC8,	0x73C2},	// CJK UNIFIED IDEOGRAPH
	{0xCFC9,	0x73C8},	// CJK UNIFIED IDEOGRAPH
	{0xCFCA,	0x73C5},	// CJK UNIFIED IDEOGRAPH
	{0xCFCB,	0x73B9},	// CJK UNIFIED IDEOGRAPH
	{0xCFCC,	0x73B6},	// CJK UNIFIED IDEOGRAPH
	{0xCFCD,	0x73B5},	// CJK UNIFIED IDEOGRAPH
	{0xCFCE,	0x73B4},	// CJK UNIFIED IDEOGRAPH
	{0xCFCF,	0x73EB},	// CJK UNIFIED IDEOGRAPH
	{0xCFD0,	0x73BF},	// CJK UNIFIED IDEOGRAPH
	{0xCFD1,	0x73C7},	// CJK UNIFIED IDEOGRAPH
	{0xCFD2,	0x73BE},	// CJK UNIFIED IDEOGRAPH
	{0xCFD3,	0x73C3},	// CJK UNIFIED IDEOGRAPH
	{0xCFD4,	0x73C6},	// CJK UNIFIED IDEOGRAPH
	{0xCFD5,	0x73B8},	// CJK UNIFIED IDEOGRAPH
	{0xCFD6,	0x73CB},	// CJK UNIFIED IDEOGRAPH
	{0xCFD7,	0x74EC},	// CJK UNIFIED IDEOGRAPH
	{0xCFD8,	0x74EE},	// CJK UNIFIED IDEOGRAPH
	{0xCFD9,	0x752E},	// CJK UNIFIED IDEOGRAPH
	{0xCFDA,	0x7547},	// CJK UNIFIED IDEOGRAPH
	{0xCFDB,	0x7548},	// CJK UNIFIED IDEOGRAPH
	{0xCFDC,	0x75A7},	// CJK UNIFIED IDEOGRAPH
	{0xCFDD,	0x75AA},	// CJK UNIFIED IDEOGRAPH
	{0xCFDE,	0x7679},	// CJK UNIFIED IDEOGRAPH
	{0xCFDF,	0x76C4},	// CJK UNIFIED IDEOGRAPH
	{0xCFE0,	0x7708},	// CJK UNIFIED IDEOGRAPH
	{0xCFE1,	0x7703},	// CJK UNIFIED IDEOGRAPH
	{0xCFE2,	0x7704},	// CJK UNIFIED IDEOGRAPH
	{0xCFE3,	0x7705},	// CJK UNIFIED IDEOGRAPH
	{0xCFE4,	0x770A},	// CJK UNIFIED IDEOGRAPH
	{0xCFE5,	0x76F7},	// CJK UNIFIED IDEOGRAPH
	{0xCFE6,	0x76FB},	// CJK UNIFIED IDEOGRAPH
	{0xCFE7,	0x76FA},	// CJK UNIFIED IDEOGRAPH
	{0xCFE8,	0x77E7},	// CJK UNIFIED IDEOGRAPH
	{0xCFE9,	0x77E8},	// CJK UNIFIED IDEOGRAPH
	{0xCFEA,	0x7806},	// CJK UNIFIED IDEOGRAPH
	{0xCFEB,	0x7811},	// CJK UNIFIED IDEOGRAPH
	{0xCFEC,	0x7812},	// CJK UNIFIED IDEOGRAPH
	{0xCFED,	0x7805},	// CJK UNIFIED IDEOGRAPH
	{0xCFEE,	0x7810},	// CJK UNIFIED IDEOGRAPH
	{0xCFEF,	0x780F},	// CJK UNIFIED IDEOGRAPH
	{0xCFF0,	0x780E},	// CJK UNIFIED IDEOGRAPH
	{0xCFF1,	0x7809},	// CJK UNIFIED IDEOGRAPH
	{0xCFF2,	0x7803},	// CJK UNIFIED IDEOGRAPH
	{0xCFF3,	0x7813},	// CJK UNIFIED IDEOGRAPH
	{0xCFF4,	0x794A},	// CJK UNIFIED IDEOGRAPH
	{0xCFF5,	0x794C},	// CJK UNIFIED IDEOGRAPH
	{0xCFF6,	0x794B},	// CJK UNIFIED IDEOGRAPH
	{0xCFF7,	0x7945},	// CJK UNIFIED IDEOGRAPH
	{0xCFF8,	0x7944},	// CJK UNIFIED IDEOGRAPH
	{0xCFF9,	0x79D5},	// CJK UNIFIED IDEOGRAPH
	{0xCFFA,	0x79CD},	// CJK UNIFIED IDEOGRAPH
	{0xCFFB,	0x79CF},	// CJK UNIFIED IDEOGRAPH
	{0xCFFC,	0x79D6},	// CJK UNIFIED IDEOGRAPH
	{0xCFFD,	0x79CE},	// CJK UNIFIED IDEOGRAPH
	{0xCFFE,	0x7A80},	// CJK UNIFIED IDEOGRAPH
	{0xD040,	0x7A7E},	// CJK UNIFIED IDEOGRAPH
	{0xD041,	0x7AD1},	// CJK UNIFIED IDEOGRAPH
	{0xD042,	0x7B00},	// CJK UNIFIED IDEOGRAPH
	{0xD043,	0x7B01},	// CJK UNIFIED IDEOGRAPH
	{0xD044,	0x7C7A},	// CJK UNIFIED IDEOGRAPH
	{0xD045,	0x7C78},	// CJK UNIFIED IDEOGRAPH
	{0xD046,	0x7C79},	// CJK UNIFIED IDEOGRAPH
	{0xD047,	0x7C7F},	// CJK UNIFIED IDEOGRAPH
	{0xD048,	0x7C80},	// CJK UNIFIED IDEOGRAPH
	{0xD049,	0x7C81},	// CJK UNIFIED IDEOGRAPH
	{0xD04A,	0x7D03},	// CJK UNIFIED IDEOGRAPH
	{0xD04B,	0x7D08},	// CJK UNIFIED IDEOGRAPH
	{0xD04C,	0x7D01},	// CJK UNIFIED IDEOGRAPH
	{0xD04D,	0x7F58},	// CJK UNIFIED IDEOGRAPH
	{0xD04E,	0x7F91},	// CJK UNIFIED IDEOGRAPH
	{0xD04F,	0x7F8D},	// CJK UNIFIED IDEOGRAPH
	{0xD050,	0x7FBE},	// CJK UNIFIED IDEOGRAPH
	{0xD051,	0x8007},	// CJK UNIFIED IDEOGRAPH
	{0xD052,	0x800E},	// CJK UNIFIED IDEOGRAPH
	{0xD053,	0x800F},	// CJK UNIFIED IDEOGRAPH
	{0xD054,	0x8014},	// CJK UNIFIED IDEOGRAPH
	{0xD055,	0x8037},	// CJK UNIFIED IDEOGRAPH
	{0xD056,	0x80D8},	// CJK UNIFIED IDEOGRAPH
	{0xD057,	0x80C7},	// CJK UNIFIED IDEOGRAPH
	{0xD058,	0x80E0},	// CJK UNIFIED IDEOGRAPH
	{0xD059,	0x80D1},	// CJK UNIFIED IDEOGRAPH
	{0xD05A,	0x80C8},	// CJK UNIFIED IDEOGRAPH
	{0xD05B,	0x80C2},	// CJK UNIFIED IDEOGRAPH
	{0xD05C,	0x80D0},	// CJK UNIFIED IDEOGRAPH
	{0xD05D,	0x80C5},	// CJK UNIFIED IDEOGRAPH
	{0xD05E,	0x80E3},	// CJK UNIFIED IDEOGRAPH
	{0xD05F,	0x80D9},	// CJK UNIFIED IDEOGRAPH
	{0xD060,	0x80DC},	// CJK UNIFIED IDEOGRAPH
	{0xD061,	0x80CA},	// CJK UNIFIED IDEOGRAPH
	{0xD062,	0x80D5},	// CJK UNIFIED IDEOGRAPH
	{0xD063,	0x80C9},	// CJK UNIFIED IDEOGRAPH
	{0xD064,	0x80CF},	// CJK UNIFIED IDEOGRAPH
	{0xD065,	0x80D7},	// CJK UNIFIED IDEOGRAPH
	{0xD066,	0x80E6},	// CJK UNIFIED IDEOGRAPH
	{0xD067,	0x80CD},	// CJK UNIFIED IDEOGRAPH
	{0xD068,	0x81FF},	// CJK UNIFIED IDEOGRAPH
	{0xD069,	0x8221},	// CJK UNIFIED IDEOGRAPH
	{0xD06A,	0x8294},	// CJK UNIFIED IDEOGRAPH
	{0xD06B,	0x82D9},	// CJK UNIFIED IDEOGRAPH
	{0xD06C,	0x82FE},	// CJK UNIFIED IDEOGRAPH
	{0xD06D,	0x82F9},	// CJK UNIFIED IDEOGRAPH
	{0xD06E,	0x8307},	// CJK UNIFIED IDEOGRAPH
	{0xD06F,	0x82E8},	// CJK UNIFIED IDEOGRAPH
	{0xD070,	0x8300},	// CJK UNIFIED IDEOGRAPH
	{0xD071,	0x82D5},	// CJK UNIFIED IDEOGRAPH
	{0xD072,	0x833A},	// CJK UNIFIED IDEOGRAPH
	{0xD073,	0x82EB},	// CJK UNIFIED IDEOGRAPH
	{0xD074,	0x82D6},	// CJK UNIFIED IDEOGRAPH
	{0xD075,	0x82F4},	// CJK UNIFIED IDEOGRAPH
	{0xD076,	0x82EC},	// CJK UNIFIED IDEOGRAPH
	{0xD077,	0x82E1},	// CJK UNIFIED IDEOGRAPH
	{0xD078,	0x82F2},	// CJK UNIFIED IDEOGRAPH
	{0xD079,	0x82F5},	// CJK UNIFIED IDEOGRAPH
	{0xD07A,	0x830C},	// CJK UNIFIED IDEOGRAPH
	{0xD07B,	0x82FB},	// CJK UNIFIED IDEOGRAPH
	{0xD07C,	0x82F6},	// CJK UNIFIED IDEOGRAPH
	{0xD07D,	0x82F0},	// CJK UNIFIED IDEOGRAPH
	{0xD07E,	0x82EA},	// CJK UNIFIED IDEOGRAPH
	{0xD0A1,	0x82E4},	// CJK UNIFIED IDEOGRAPH
	{0xD0A2,	0x82E0},	// CJK UNIFIED IDEOGRAPH
	{0xD0A3,	0x82FA},	// CJK UNIFIED IDEOGRAPH
	{0xD0A4,	0x82F3},	// CJK UNIFIED IDEOGRAPH
	{0xD0A5,	0x82ED},	// CJK UNIFIED IDEOGRAPH
	{0xD0A6,	0x8677},	// CJK UNIFIED IDEOGRAPH
	{0xD0A7,	0x8674},	// CJK UNIFIED IDEOGRAPH
	{0xD0A8,	0x867C},	// CJK UNIFIED IDEOGRAPH
	{0xD0A9,	0x8673},	// CJK UNIFIED IDEOGRAPH
	{0xD0AA,	0x8841},	// CJK UNIFIED IDEOGRAPH
	{0xD0AB,	0x884E},	// CJK UNIFIED IDEOGRAPH
	{0xD0AC,	0x8867},	// CJK UNIFIED IDEOGRAPH
	{0xD0AD,	0x886A},	// CJK UNIFIED IDEOGRAPH
	{0xD0AE,	0x8869},	// CJK UNIFIED IDEOGRAPH
	{0xD0AF,	0x89D3},	// CJK UNIFIED IDEOGRAPH
	{0xD0B0,	0x8A04},	// CJK UNIFIED IDEOGRAPH
	{0xD0B1,	0x8A07},	// CJK UNIFIED IDEOGRAPH
	{0xD0B2,	0x8D72},	// CJK UNIFIED IDEOGRAPH
	{0xD0B3,	0x8FE3},	// CJK UNIFIED IDEOGRAPH
	{0xD0B4,	0x8FE1},	// CJK UNIFIED IDEOGRAPH
	{0xD0B5,	0x8FEE},	// CJK UNIFIED IDEOGRAPH
	{0xD0B6,	0x8FE0},	// CJK UNIFIED IDEOGRAPH
	{0xD0B7,	0x90F1},	// CJK UNIFIED IDEOGRAPH
	{0xD0B8,	0x90BD},	// CJK UNIFIED IDEOGRAPH
	{0xD0B9,	0x90BF},	// CJK UNIFIED IDEOGRAPH
	{0xD0BA,	0x90D5},	// CJK UNIFIED IDEOGRAPH
	{0xD0BB,	0x90C5},	// CJK UNIFIED IDEOGRAPH
	{0xD0BC,	0x90BE},	// CJK UNIFIED IDEOGRAPH
	{0xD0BD,	0x90C7},	// CJK UNIFIED IDEOGRAPH
	{0xD0BE,	0x90CB},	// CJK UNIFIED IDEOGRAPH
	{0xD0BF,	0x90C8},	// CJK UNIFIED IDEOGRAPH
	{0xD0C0,	0x91D4},	// CJK UNIFIED IDEOGRAPH
	{0xD0C1,	0x91D3},	// CJK UNIFIED IDEOGRAPH
	{0xD0C2,	0x9654},	// CJK UNIFIED IDEOGRAPH
	{0xD0C3,	0x964F},	// CJK UNIFIED IDEOGRAPH
	{0xD0C4,	0x9651},	// CJK UNIFIED IDEOGRAPH
	{0xD0C5,	0x9653},	// CJK UNIFIED IDEOGRAPH
	{0xD0C6,	0x964A},	// CJK UNIFIED IDEOGRAPH
	{0xD0C7,	0x964E},	// CJK UNIFIED IDEOGRAPH
	{0xD0C8,	0x501E},	// CJK UNIFIED IDEOGRAPH
	{0xD0C9,	0x5005},	// CJK UNIFIED IDEOGRAPH
	{0xD0CA,	0x5007},	// CJK UNIFIED IDEOGRAPH
	{0xD0CB,	0x5013},	// CJK UNIFIED IDEOGRAPH
	{0xD0CC,	0x5022},	// CJK UNIFIED IDEOGRAPH
	{0xD0CD,	0x5030},	// CJK UNIFIED IDEOGRAPH
	{0xD0CE,	0x501B},	// CJK UNIFIED IDEOGRAPH
	{0xD0CF,	0x4FF5},	// CJK UNIFIED IDEOGRAPH
	{0xD0D0,	0x4FF4},	// CJK UNIFIED IDEOGRAPH
	{0xD0D1,	0x5033},	// CJK UNIFIED IDEOGRAPH
	{0xD0D2,	0x5037},	// CJK UNIFIED IDEOGRAPH
	{0xD0D3,	0x502C},	// CJK UNIFIED IDEOGRAPH
	{0xD0D4,	0x4FF6},	// CJK UNIFIED IDEOGRAPH
	{0xD0D5,	0x4FF7},	// CJK UNIFIED IDEOGRAPH
	{0xD0D6,	0x5017},	// CJK UNIFIED IDEOGRAPH
	{0xD0D7,	0x501C},	// CJK UNIFIED IDEOGRAPH
	{0xD0D8,	0x5020},	// CJK UNIFIED IDEOGRAPH
	{0xD0D9,	0x5027},	// CJK UNIFIED IDEOGRAPH
	{0xD0DA,	0x5035},	// CJK UNIFIED IDEOGRAPH
	{0xD0DB,	0x502F},	// CJK UNIFIED IDEOGRAPH
	{0xD0DC,	0x5031},	// CJK UNIFIED IDEOGRAPH
	{0xD0DD,	0x500E},	// CJK UNIFIED IDEOGRAPH
	{0xD0DE,	0x515A},	// CJK UNIFIED IDEOGRAPH
	{0xD0DF,	0x5194},	// CJK UNIFIED IDEOGRAPH
	{0xD0E0,	0x5193},	// CJK UNIFIED IDEOGRAPH
	{0xD0E1,	0x51CA},	// CJK UNIFIED IDEOGRAPH
	{0xD0E2,	0x51C4},	// CJK UNIFIED IDEOGRAPH
	{0xD0E3,	0x51C5},	// CJK UNIFIED IDEOGRAPH
	{0xD0E4,	0x51C8},	// CJK UNIFIED IDEOGRAPH
	{0xD0E5,	0x51CE},	// CJK UNIFIED IDEOGRAPH
	{0xD0E6,	0x5261},	// CJK UNIFIED IDEOGRAPH
	{0xD0E7,	0x525A},	// CJK UNIFIED IDEOGRAPH
	{0xD0E8,	0x5252},	// CJK UNIFIED IDEOGRAPH
	{0xD0E9,	0x525E},	// CJK UNIFIED IDEOGRAPH
	{0xD0EA,	0x525F},	// CJK UNIFIED IDEOGRAPH
	{0xD0EB,	0x5255},	// CJK UNIFIED IDEOGRAPH
	{0xD0EC,	0x5262},	// CJK UNIFIED IDEOGRAPH
	{0xD0ED,	0x52CD},	// CJK UNIFIED IDEOGRAPH
	{0xD0EE,	0x530E},	// CJK UNIFIED IDEOGRAPH
	{0xD0EF,	0x539E},	// CJK UNIFIED IDEOGRAPH
	{0xD0F0,	0x5526},	// CJK UNIFIED IDEOGRAPH
	{0xD0F1,	0x54E2},	// CJK UNIFIED IDEOGRAPH
	{0xD0F2,	0x5517},	// CJK UNIFIED IDEOGRAPH
	{0xD0F3,	0x5512},	// CJK UNIFIED IDEOGRAPH
	{0xD0F4,	0x54E7},	// CJK UNIFIED IDEOGRAPH
	{0xD0F5,	0x54F3},	// CJK UNIFIED IDEOGRAPH
	{0xD0F6,	0x54E4},	// CJK UNIFIED IDEOGRAPH
	{0xD0F7,	0x551A},	// CJK UNIFIED IDEOGRAPH
	{0xD0F8,	0x54FF},	// CJK UNIFIED IDEOGRAPH
	{0xD0F9,	0x5504},	// CJK UNIFIED IDEOGRAPH
	{0xD0FA,	0x5508},	// CJK UNIFIED IDEOGRAPH
	{0xD0FB,	0x54EB},	// CJK UNIFIED IDEOGRAPH
	{0xD0FC,	0x5511},	// CJK UNIFIED IDEOGRAPH
	{0xD0FD,	0x5505},	// CJK UNIFIED IDEOGRAPH
	{0xD0FE,	0x54F1},	// CJK UNIFIED IDEOGRAPH
	{0xD140,	0x550A},	// CJK UNIFIED IDEOGRAPH
	{0xD141,	0x54FB},	// CJK UNIFIED IDEOGRAPH
	{0xD142,	0x54F7},	// CJK UNIFIED IDEOGRAPH
	{0xD143,	0x54F8},	// CJK UNIFIED IDEOGRAPH
	{0xD144,	0x54E0},	// CJK UNIFIED IDEOGRAPH
	{0xD145,	0x550E},	// CJK UNIFIED IDEOGRAPH
	{0xD146,	0x5503},	// CJK UNIFIED IDEOGRAPH
	{0xD147,	0x550B},	// CJK UNIFIED IDEOGRAPH
	{0xD148,	0x5701},	// CJK UNIFIED IDEOGRAPH
	{0xD149,	0x5702},	// CJK UNIFIED IDEOGRAPH
	{0xD14A,	0x57CC},	// CJK UNIFIED IDEOGRAPH
	{0xD14B,	0x5832},	// CJK UNIFIED IDEOGRAPH
	{0xD14C,	0x57D5},	// CJK UNIFIED IDEOGRAPH
	{0xD14D,	0x57D2},	// CJK UNIFIED IDEOGRAPH
	{0xD14E,	0x57BA},	// CJK UNIFIED IDEOGRAPH
	{0xD14F,	0x57C6},	// CJK UNIFIED IDEOGRAPH
	{0xD150,	0x57BD},	// CJK UNIFIED IDEOGRAPH
	{0xD151,	0x57BC},	// CJK UNIFIED IDEOGRAPH
	{0xD152,	0x57B8},	// CJK UNIFIED IDEOGRAPH
	{0xD153,	0x57B6},	// CJK UNIFIED IDEOGRAPH
	{0xD154,	0x57BF},	// CJK UNIFIED IDEOGRAPH
	{0xD155,	0x57C7},	// CJK UNIFIED IDEOGRAPH
	{0xD156,	0x57D0},	// CJK UNIFIED IDEOGRAPH
	{0xD157,	0x57B9},	// CJK UNIFIED IDEOGRAPH
	{0xD158,	0x57C1},	// CJK UNIFIED IDEOGRAPH
	{0xD159,	0x590E},	// CJK UNIFIED IDEOGRAPH
	{0xD15A,	0x594A},	// CJK UNIFIED IDEOGRAPH
	{0xD15B,	0x5A19},	// CJK UNIFIED IDEOGRAPH
	{0xD15C,	0x5A16},	// CJK UNIFIED IDEOGRAPH
	{0xD15D,	0x5A2D},	// CJK UNIFIED IDEOGRAPH
	{0xD15E,	0x5A2E},	// CJK UNIFIED IDEOGRAPH
	{0xD15F,	0x5A15},	// CJK UNIFIED IDEOGRAPH
	{0xD160,	0x5A0F},	// CJK UNIFIED IDEOGRAPH
	{0xD161,	0x5A17},	// CJK UNIFIED IDEOGRAPH
	{0xD162,	0x5A0A},	// CJK UNIFIED IDEOGRAPH
	{0xD163,	0x5A1E},	// CJK UNIFIED IDEOGRAPH
	{0xD164,	0x5A33},	// CJK UNIFIED IDEOGRAPH
	{0xD165,	0x5B6C},	// CJK UNIFIED IDEOGRAPH
	{0xD166,	0x5BA7},	// CJK UNIFIED IDEOGRAPH
	{0xD167,	0x5BAD},	// CJK UNIFIED IDEOGRAPH
	{0xD168,	0x5BAC},	// CJK UNIFIED IDEOGRAPH
	{0xD169,	0x5C03},	// CJK UNIFIED IDEOGRAPH
	{0xD16A,	0x5C56},	// CJK UNIFIED IDEOGRAPH
	{0xD16B,	0x5C54},	// CJK UNIFIED IDEOGRAPH
	{0xD16C,	0x5CEC},	// CJK UNIFIED IDEOGRAPH
	{0xD16D,	0x5CFF},	// CJK UNIFIED IDEOGRAPH
	{0xD16E,	0x5CEE},	// CJK UNIFIED IDEOGRAPH
	{0xD16F,	0x5CF1},	// CJK UNIFIED IDEOGRAPH
	{0xD170,	0x5CF7},	// CJK UNIFIED IDEOGRAPH
	{0xD171,	0x5D00},	// CJK UNIFIED IDEOGRAPH
	{0xD172,	0x5CF9},	// CJK UNIFIED IDEOGRAPH
	{0xD173,	0x5E29},	// CJK UNIFIED IDEOGRAPH
	{0xD174,	0x5E28},	// CJK UNIFIED IDEOGRAPH
	{0xD175,	0x5EA8},	// CJK UNIFIED IDEOGRAPH
	{0xD176,	0x5EAE},	// CJK UNIFIED IDEOGRAPH
	{0xD177,	0x5EAA},	// CJK UNIFIED IDEOGRAPH
	{0xD178,	0x5EAC},	// CJK UNIFIED IDEOGRAPH
	{0xD179,	0x5F33},	// CJK UNIFIED IDEOGRAPH
	{0xD17A,	0x5F30},	// CJK UNIFIED IDEOGRAPH
	{0xD17B,	0x5F67},	// CJK UNIFIED IDEOGRAPH
	{0xD17C,	0x605D},	// CJK UNIFIED IDEOGRAPH
	{0xD17D,	0x605A},	// CJK UNIFIED IDEOGRAPH
	{0xD17E,	0x6067},	// CJK UNIFIED IDEOGRAPH
	{0xD1A1,	0x6041},	// CJK UNIFIED IDEOGRAPH
	{0xD1A2,	0x60A2},	// CJK UNIFIED IDEOGRAPH
	{0xD1A3,	0x6088},	// CJK UNIFIED IDEOGRAPH
	{0xD1A4,	0x6080},	// CJK UNIFIED IDEOGRAPH
	{0xD1A5,	0x6092},	// CJK UNIFIED IDEOGRAPH
	{0xD1A6,	0x6081},	// CJK UNIFIED IDEOGRAPH
	{0xD1A7,	0x609D},	// CJK UNIFIED IDEOGRAPH
	{0xD1A8,	0x6083},	// CJK UNIFIED IDEOGRAPH
	{0xD1A9,	0x6095},	// CJK UNIFIED IDEOGRAPH
	{0xD1AA,	0x609B},	// CJK UNIFIED IDEOGRAPH
	{0xD1AB,	0x6097},	// CJK UNIFIED IDEOGRAPH
	{0xD1AC,	0x6087},	// CJK UNIFIED IDEOGRAPH
	{0xD1AD,	0x609C},	// CJK UNIFIED IDEOGRAPH
	{0xD1AE,	0x608E},	// CJK UNIFIED IDEOGRAPH
	{0xD1AF,	0x6219},	// CJK UNIFIED IDEOGRAPH
	{0xD1B0,	0x6246},	// CJK UNIFIED IDEOGRAPH
	{0xD1B1,	0x62F2},	// CJK UNIFIED IDEOGRAPH
	{0xD1B2,	0x6310},	// CJK UNIFIED IDEOGRAPH
	{0xD1B3,	0x6356},	// CJK UNIFIED IDEOGRAPH
	{0xD1B4,	0x632C},	// CJK UNIFIED IDEOGRAPH
	{0xD1B5,	0x6344},	// CJK UNIFIED IDEOGRAPH
	{0xD1B6,	0x6345},	// CJK UNIFIED IDEOGRAPH
	{0xD1B7,	0x6336},	// CJK UNIFIED IDEOGRAPH
	{0xD1B8,	0x6343},	// CJK UNIFIED IDEOGRAPH
	{0xD1B9,	0x63E4},	// CJK UNIFIED IDEOGRAPH
	{0xD1BA,	0x6339},	// CJK UNIFIED IDEOGRAPH
	{0xD1BB,	0x634B},	// CJK UNIFIED IDEOGRAPH
	{0xD1BC,	0x634A},	// CJK UNIFIED IDEOGRAPH
	{0xD1BD,	0x633C},	// CJK UNIFIED IDEOGRAPH
	{0xD1BE,	0x6329},	// CJK UNIFIED IDEOGRAPH
	{0xD1BF,	0x6341},	// CJK UNIFIED IDEOGRAPH
	{0xD1C0,	0x6334},	// CJK UNIFIED IDEOGRAPH
	{0xD1C1,	0x6358},	// CJK UNIFIED IDEOGRAPH
	{0xD1C2,	0x6354},	// CJK UNIFIED IDEOGRAPH
	{0xD1C3,	0x6359},	// CJK UNIFIED IDEOGRAPH
	{0xD1C4,	0x632D},	// CJK UNIFIED IDEOGRAPH
	{0xD1C5,	0x6347},	// CJK UNIFIED IDEOGRAPH
	{0xD1C6,	0x6333},	// CJK UNIFIED IDEOGRAPH
	{0xD1C7,	0x635A},	// CJK UNIFIED IDEOGRAPH
	{0xD1C8,	0x6351},	// CJK UNIFIED IDEOGRAPH
	{0xD1C9,	0x6338},	// CJK UNIFIED IDEOGRAPH
	{0xD1CA,	0x6357},	// CJK UNIFIED IDEOGRAPH
	{0xD1CB,	0x6340},	// CJK UNIFIED IDEOGRAPH
	{0xD1CC,	0x6348},	// CJK UNIFIED IDEOGRAPH
	{0xD1CD,	0x654A},	// CJK UNIFIED IDEOGRAPH
	{0xD1CE,	0x6546},	// CJK UNIFIED IDEOGRAPH
	{0xD1CF,	0x65C6},	// CJK UNIFIED IDEOGRAPH
	{0xD1D0,	0x65C3},	// CJK UNIFIED IDEOGRAPH
	{0xD1D1,	0x65C4},	// CJK UNIFIED IDEOGRAPH
	{0xD1D2,	0x65C2},	// CJK UNIFIED IDEOGRAPH
	{0xD1D3,	0x664A},	// CJK UNIFIED IDEOGRAPH
	{0xD1D4,	0x665F},	// CJK UNIFIED IDEOGRAPH
	{0xD1D5,	0x6647},	// CJK UNIFIED IDEOGRAPH
	{0xD1D6,	0x6651},	// CJK UNIFIED IDEOGRAPH
	{0xD1D7,	0x6712},	// CJK UNIFIED IDEOGRAPH
	{0xD1D8,	0x6713},	// CJK UNIFIED IDEOGRAPH
	{0xD1D9,	0x681F},	// CJK UNIFIED IDEOGRAPH
	{0xD1DA,	0x681A},	// CJK UNIFIED IDEOGRAPH
	{0xD1DB,	0x6849},	// CJK UNIFIED IDEOGRAPH
	{0xD1DC,	0x6832},	// CJK UNIFIED IDEOGRAPH
	{0xD1DD,	0x6833},	// CJK UNIFIED IDEOGRAPH
	{0xD1DE,	0x683B},	// CJK UNIFIED IDEOGRAPH
	{0xD1DF,	0x684B},	// CJK UNIFIED IDEOGRAPH
	{0xD1E0,	0x684F},	// CJK UNIFIED IDEOGRAPH
	{0xD1E1,	0x6816},	// CJK UNIFIED IDEOGRAPH
	{0xD1E2,	0x6831},	// CJK UNIFIED IDEOGRAPH
	{0xD1E3,	0x681C},	// CJK UNIFIED IDEOGRAPH
	{0xD1E4,	0x6835},	// CJK UNIFIED IDEOGRAPH
	{0xD1E5,	0x682B},	// CJK UNIFIED IDEOGRAPH
	{0xD1E6,	0x682D},	// CJK UNIFIED IDEOGRAPH
	{0xD1E7,	0x682F},	// CJK UNIFIED IDEOGRAPH
	{0xD1E8,	0x684E},	// CJK UNIFIED IDEOGRAPH
	{0xD1E9,	0x6844},	// CJK UNIFIED IDEOGRAPH
	{0xD1EA,	0x6834},	// CJK UNIFIED IDEOGRAPH
	{0xD1EB,	0x681D},	// CJK UNIFIED IDEOGRAPH
	{0xD1EC,	0x6812},	// CJK UNIFIED IDEOGRAPH
	{0xD1ED,	0x6814},	// CJK UNIFIED IDEOGRAPH
	{0xD1EE,	0x6826},	// CJK UNIFIED IDEOGRAPH
	{0xD1EF,	0x6828},	// CJK UNIFIED IDEOGRAPH
	{0xD1F0,	0x682E},	// CJK UNIFIED IDEOGRAPH
	{0xD1F1,	0x684D},	// CJK UNIFIED IDEOGRAPH
	{0xD1F2,	0x683A},	// CJK UNIFIED IDEOGRAPH
	{0xD1F3,	0x6825},	// CJK UNIFIED IDEOGRAPH
	{0xD1F4,	0x6820},	// CJK UNIFIED IDEOGRAPH
	{0xD1F5,	0x6B2C},	// CJK UNIFIED IDEOGRAPH
	{0xD1F6,	0x6B2F},	// CJK UNIFIED IDEOGRAPH
	{0xD1F7,	0x6B2D},	// CJK UNIFIED IDEOGRAPH
	{0xD1F8,	0x6B31},	// CJK UNIFIED IDEOGRAPH
	{0xD1F9,	0x6B34},	// CJK UNIFIED IDEOGRAPH
	{0xD1FA,	0x6B6D},	// CJK UNIFIED IDEOGRAPH
	{0xD1FB,	0x8082},	// CJK UNIFIED IDEOGRAPH
	{0xD1FC,	0x6B88},	// CJK UNIFIED IDEOGRAPH
	{0xD1FD,	0x6BE6},	// CJK UNIFIED IDEOGRAPH
	{0xD1FE,	0x6BE4},	// CJK UNIFIED IDEOGRAPH
	{0xD240,	0x6BE8},	// CJK UNIFIED IDEOGRAPH
	{0xD241,	0x6BE3},	// CJK UNIFIED IDEOGRAPH
	{0xD242,	0x6BE2},	// CJK UNIFIED IDEOGRAPH
	{0xD243,	0x6BE7},	// CJK UNIFIED IDEOGRAPH
	{0xD244,	0x6C25},	// CJK UNIFIED IDEOGRAPH
	{0xD245,	0x6D7A},	// CJK UNIFIED IDEOGRAPH
	{0xD246,	0x6D63},	// CJK UNIFIED IDEOGRAPH
	{0xD247,	0x6D64},	// CJK UNIFIED IDEOGRAPH
	{0xD248,	0x6D76},	// CJK UNIFIED IDEOGRAPH
	{0xD249,	0x6D0D},	// CJK UNIFIED IDEOGRAPH
	{0xD24A,	0x6D61},	// CJK UNIFIED IDEOGRAPH
	{0xD24B,	0x6D92},	// CJK UNIFIED IDEOGRAPH
	{0xD24C,	0x6D58},	// CJK UNIFIED IDEOGRAPH
	{0xD24D,	0x6D62},	// CJK UNIFIED IDEOGRAPH
	{0xD24E,	0x6D6D},	// CJK UNIFIED IDEOGRAPH
	{0xD24F,	0x6D6F},	// CJK UNIFIED IDEOGRAPH
	{0xD250,	0x6D91},	// CJK UNIFIED IDEOGRAPH
	{0xD251,	0x6D8D},	// CJK UNIFIED IDEOGRAPH
	{0xD252,	0x6DEF},	// CJK UNIFIED IDEOGRAPH
	{0xD253,	0x6D7F},	// CJK UNIFIED IDEOGRAPH
	{0xD254,	0x6D86},	// CJK UNIFIED IDEOGRAPH
	{0xD255,	0x6D5E},	// CJK UNIFIED IDEOGRAPH
	{0xD256,	0x6D67},	// CJK UNIFIED IDEOGRAPH
	{0xD257,	0x6D60},	// CJK UNIFIED IDEOGRAPH
	{0xD258,	0x6D97},	// CJK UNIFIED IDEOGRAPH
	{0xD259,	0x6D70},	// CJK UNIFIED IDEOGRAPH
	{0xD25A,	0x6D7C},	// CJK UNIFIED IDEOGRAPH
	{0xD25B,	0x6D5F},	// CJK UNIFIED IDEOGRAPH
	{0xD25C,	0x6D82},	// CJK UNIFIED IDEOGRAPH
	{0xD25D,	0x6D98},	// CJK UNIFIED IDEOGRAPH
	{0xD25E,	0x6D2F},	// CJK UNIFIED IDEOGRAPH
	{0xD25F,	0x6D68},	// CJK UNIFIED IDEOGRAPH
	{0xD260,	0x6D8B},	// CJK UNIFIED IDEOGRAPH
	{0xD261,	0x6D7E},	// CJK UNIFIED IDEOGRAPH
	{0xD262,	0x6D80},	// CJK UNIFIED IDEOGRAPH
	{0xD263,	0x6D84},	// CJK UNIFIED IDEOGRAPH
	{0xD264,	0x6D16},	// CJK UNIFIED IDEOGRAPH
	{0xD265,	0x6D83},	// CJK UNIFIED IDEOGRAPH
	{0xD266,	0x6D7B},	// CJK UNIFIED IDEOGRAPH
	{0xD267,	0x6D7D},	// CJK UNIFIED IDEOGRAPH
	{0xD268,	0x6D75},	// CJK UNIFIED IDEOGRAPH
	{0xD269,	0x6D90},	// CJK UNIFIED IDEOGRAPH
	{0xD26A,	0x70DC},	// CJK UNIFIED IDEOGRAPH
	{0xD26B,	0x70D3},	// CJK UNIFIED IDEOGRAPH
	{0xD26C,	0x70D1},	// CJK UNIFIED IDEOGRAPH
	{0xD26D,	0x70DD},	// CJK UNIFIED IDEOGRAPH
	{0xD26E,	0x70CB},	// CJK UNIFIED IDEOGRAPH
	{0xD26F,	0x7F39},	// CJK UNIFIED IDEOGRAPH
	{0xD270,	0x70E2},	// CJK UNIFIED IDEOGRAPH
	{0xD271,	0x70D7},	// CJK UNIFIED IDEOGRAPH
	{0xD272,	0x70D2},	// CJK UNIFIED IDEOGRAPH
	{0xD273,	0x70DE},	// CJK UNIFIED IDEOGRAPH
	{0xD274,	0x70E0},	// CJK UNIFIED IDEOGRAPH
	{0xD275,	0x70D4},	// CJK UNIFIED IDEOGRAPH
	{0xD276,	0x70CD},	// CJK UNIFIED IDEOGRAPH
	{0xD277,	0x70C5},	// CJK UNIFIED IDEOGRAPH
	{0xD278,	0x70C6},	// CJK UNIFIED IDEOGRAPH
	{0xD279,	0x70C7},	// CJK UNIFIED IDEOGRAPH
	{0xD27A,	0x70DA},	// CJK UNIFIED IDEOGRAPH
	{0xD27B,	0x70CE},	// CJK UNIFIED IDEOGRAPH
	{0xD27C,	0x70E1},	// CJK UNIFIED IDEOGRAPH
	{0xD27D,	0x7242},	// CJK UNIFIED IDEOGRAPH
	{0xD27E,	0x7278},	// CJK UNIFIED IDEOGRAPH
	{0xD2A1,	0x7277},	// CJK UNIFIED IDEOGRAPH
	{0xD2A2,	0x7276},	// CJK UNIFIED IDEOGRAPH
	{0xD2A3,	0x7300},	// CJK UNIFIED IDEOGRAPH
	{0xD2A4,	0x72FA},	// CJK UNIFIED IDEOGRAPH
	{0xD2A5,	0x72F4},	// CJK UNIFIED IDEOGRAPH
	{0xD2A6,	0x72FE},	// CJK UNIFIED IDEOGRAPH
	{0xD2A7,	0x72F6},	// CJK UNIFIED IDEOGRAPH
	{0xD2A8,	0x72F3},	// CJK UNIFIED IDEOGRAPH
	{0xD2A9,	0x72FB},	// CJK UNIFIED IDEOGRAPH
	{0xD2AA,	0x7301},	// CJK UNIFIED IDEOGRAPH
	{0xD2AB,	0x73D3},	// CJK UNIFIED IDEOGRAPH
	{0xD2AC,	0x73D9},	// CJK UNIFIED IDEOGRAPH
	{0xD2AD,	0x73E5},	// CJK UNIFIED IDEOGRAPH
	{0xD2AE,	0x73D6},	// CJK UNIFIED IDEOGRAPH
	{0xD2AF,	0x73BC},	// CJK UNIFIED IDEOGRAPH
	{0xD2B0,	0x73E7},	// CJK UNIFIED IDEOGRAPH
	{0xD2B1,	0x73E3},	// CJK UNIFIED IDEOGRAPH
	{0xD2B2,	0x73E9},	// CJK UNIFIED IDEOGRAPH
	{0xD2B3,	0x73DC},	// CJK UNIFIED IDEOGRAPH
	{0xD2B4,	0x73D2},	// CJK UNIFIED IDEOGRAPH
	{0xD2B5,	0x73DB},	// CJK UNIFIED IDEOGRAPH
	{0xD2B6,	0x73D4},	// CJK UNIFIED IDEOGRAPH
	{0xD2B7,	0x73DD},	// CJK UNIFIED IDEOGRAPH
	{0xD2B8,	0x73DA},	// CJK UNIFIED IDEOGRAPH
	{0xD2B9,	0x73D7},	// CJK UNIFIED IDEOGRAPH
	{0xD2BA,	0x73D8},	// CJK UNIFIED IDEOGRAPH
	{0xD2BB,	0x73E8},	// CJK UNIFIED IDEOGRAPH
	{0xD2BC,	0x74DE},	// CJK UNIFIED IDEOGRAPH
	{0xD2BD,	0x74DF},	// CJK UNIFIED IDEOGRAPH
	{0xD2BE,	0x74F4},	// CJK UNIFIED IDEOGRAPH
	{0xD2BF,	0x74F5},	// CJK UNIFIED IDEOGRAPH
	{0xD2C0,	0x7521},	// CJK UNIFIED IDEOGRAPH
	{0xD2C1,	0x755B},	// CJK UNIFIED IDEOGRAPH
	{0xD2C2,	0x755F},	// CJK UNIFIED IDEOGRAPH
	{0xD2C3,	0x75B0},	// CJK UNIFIED IDEOGRAPH
	{0xD2C4,	0x75C1},	// CJK UNIFIED IDEOGRAPH
	{0xD2C5,	0x75BB},	// CJK UNIFIED IDEOGRAPH
	{0xD2C6,	0x75C4},	// CJK UNIFIED IDEOGRAPH
	{0xD2C7,	0x75C0},	// CJK UNIFIED IDEOGRAPH
	{0xD2C8,	0x75BF},	// CJK UNIFIED IDEOGRAPH
	{0xD2C9,	0x75B6},	// CJK UNIFIED IDEOGRAPH
	{0xD2CA,	0x75BA},	// CJK UNIFIED IDEOGRAPH
	{0xD2CB,	0x768A},	// CJK UNIFIED IDEOGRAPH
	{0xD2CC,	0x76C9},	// CJK UNIFIED IDEOGRAPH
	{0xD2CD,	0x771D},	// CJK UNIFIED IDEOGRAPH
	{0xD2CE,	0x771B},	// CJK UNIFIED IDEOGRAPH
	{0xD2CF,	0x7710},	// CJK UNIFIED IDEOGRAPH
	{0xD2D0,	0x7713},	// CJK UNIFIED IDEOGRAPH
	{0xD2D1,	0x7712},	// CJK UNIFIED IDEOGRAPH
	{0xD2D2,	0x7723},	// CJK UNIFIED IDEOGRAPH
	{0xD2D3,	0x7711},	// CJK UNIFIED IDEOGRAPH
	{0xD2D4,	0x7715},	// CJK UNIFIED IDEOGRAPH
	{0xD2D5,	0x7719},	// CJK UNIFIED IDEOGRAPH
	{0xD2D6,	0x771A},	// CJK UNIFIED IDEOGRAPH
	{0xD2D7,	0x7722},	// CJK UNIFIED IDEOGRAPH
	{0xD2D8,	0x7727},	// CJK UNIFIED IDEOGRAPH
	{0xD2D9,	0x7823},	// CJK UNIFIED IDEOGRAPH
	{0xD2DA,	0x782C},	// CJK UNIFIED IDEOGRAPH
	{0xD2DB,	0x7822},	// CJK UNIFIED IDEOGRAPH
	{0xD2DC,	0x7835},	// CJK UNIFIED IDEOGRAPH
	{0xD2DD,	0x782F},	// CJK UNIFIED IDEOGRAPH
	{0xD2DE,	0x7828},	// CJK UNIFIED IDEOGRAPH
	{0xD2DF,	0x782E},	// CJK UNIFIED IDEOGRAPH
	{0xD2E0,	0x782B},	// CJK UNIFIED IDEOGRAPH
	{0xD2E1,	0x7821},	// CJK UNIFIED IDEOGRAPH
	{0xD2E2,	0x7829},	// CJK UNIFIED IDEOGRAPH
	{0xD2E3,	0x7833},	// CJK UNIFIED IDEOGRAPH
	{0xD2E4,	0x782A},	// CJK UNIFIED IDEOGRAPH
	{0xD2E5,	0x7831},	// CJK UNIFIED IDEOGRAPH
	{0xD2E6,	0x7954},	// CJK UNIFIED IDEOGRAPH
	{0xD2E7,	0x795B},	// CJK UNIFIED IDEOGRAPH
	{0xD2E8,	0x794F},	// CJK UNIFIED IDEOGRAPH
	{0xD2E9,	0x795C},	// CJK UNIFIED IDEOGRAPH
	{0xD2EA,	0x7953},	// CJK UNIFIED IDEOGRAPH
	{0xD2EB,	0x7952},	// CJK UNIFIED IDEOGRAPH
	{0xD2EC,	0x7951},	// CJK UNIFIED IDEOGRAPH
	{0xD2ED,	0x79EB},	// CJK UNIFIED IDEOGRAPH
	{0xD2EE,	0x79EC},	// CJK UNIFIED IDEOGRAPH
	{0xD2EF,	0x79E0},	// CJK UNIFIED IDEOGRAPH
	{0xD2F0,	0x79EE},	// CJK UNIFIED IDEOGRAPH
	{0xD2F1,	0x79ED},	// CJK UNIFIED IDEOGRAPH
	{0xD2F2,	0x79EA},	// CJK UNIFIED IDEOGRAPH
	{0xD2F3,	0x79DC},	// CJK UNIFIED IDEOGRAPH
	{0xD2F4,	0x79DE},	// CJK UNIFIED IDEOGRAPH
	{0xD2F5,	0x79DD},	// CJK UNIFIED IDEOGRAPH
	{0xD2F6,	0x7A86},	// CJK UNIFIED IDEOGRAPH
	{0xD2F7,	0x7A89},	// CJK UNIFIED IDEOGRAPH
	{0xD2F8,	0x7A85},	// CJK UNIFIED IDEOGRAPH
	{0xD2F9,	0x7A8B},	// CJK UNIFIED IDEOGRAPH
	{0xD2FA,	0x7A8C},	// CJK UNIFIED IDEOGRAPH
	{0xD2FB,	0x7A8A},	// CJK UNIFIED IDEOGRAPH
	{0xD2FC,	0x7A87},	// CJK UNIFIED IDEOGRAPH
	{0xD2FD,	0x7AD8},	// CJK UNIFIED IDEOGRAPH
	{0xD2FE,	0x7B10},	// CJK UNIFIED IDEOGRAPH
	{0xD340,	0x7B04},	// CJK UNIFIED IDEOGRAPH
	{0xD341,	0x7B13},	// CJK UNIFIED IDEOGRAPH
	{0xD342,	0x7B05},	// CJK UNIFIED IDEOGRAPH
	{0xD343,	0x7B0F},	// CJK UNIFIED IDEOGRAPH
	{0xD344,	0x7B08},	// CJK UNIFIED IDEOGRAPH
	{0xD345,	0x7B0A},	// CJK UNIFIED IDEOGRAPH
	{0xD346,	0x7B0E},	// CJK UNIFIED IDEOGRAPH
	{0xD347,	0x7B09},	// CJK UNIFIED IDEOGRAPH
	{0xD348,	0x7B12},	// CJK UNIFIED IDEOGRAPH
	{0xD349,	0x7C84},	// CJK UNIFIED IDEOGRAPH
	{0xD34A,	0x7C91},	// CJK UNIFIED IDEOGRAPH
	{0xD34B,	0x7C8A},	// CJK UNIFIED IDEOGRAPH
	{0xD34C,	0x7C8C},	// CJK UNIFIED IDEOGRAPH
	{0xD34D,	0x7C88},	// CJK UNIFIED IDEOGRAPH
	{0xD34E,	0x7C8D},	// CJK UNIFIED IDEOGRAPH
	{0xD34F,	0x7C85},	// CJK UNIFIED IDEOGRAPH
	{0xD350,	0x7D1E},	// CJK UNIFIED IDEOGRAPH
	{0xD351,	0x7D1D},	// CJK UNIFIED IDEOGRAPH
	{0xD352,	0x7D11},	// CJK UNIFIED IDEOGRAPH
	{0xD353,	0x7D0E},	// CJK UNIFIED IDEOGRAPH
	{0xD354,	0x7D18},	// CJK UNIFIED IDEOGRAPH
	{0xD355,	0x7D16},	// CJK UNIFIED IDEOGRAPH
	{0xD356,	0x7D13},	// CJK UNIFIED IDEOGRAPH
	{0xD357,	0x7D1F},	// CJK UNIFIED IDEOGRAPH
	{0xD358,	0x7D12},	// CJK UNIFIED IDEOGRAPH
	{0xD359,	0x7D0F},	// CJK UNIFIED IDEOGRAPH
	{0xD35A,	0x7D0C},	// CJK UNIFIED IDEOGRAPH
	{0xD35B,	0x7F5C},	// CJK UNIFIED IDEOGRAPH
	{0xD35C,	0x7F61},	// CJK UNIFIED IDEOGRAPH
	{0xD35D,	0x7F5E},	// CJK UNIFIED IDEOGRAPH
	{0xD35E,	0x7F60},	// CJK UNIFIED IDEOGRAPH
	{0xD35F,	0x7F5D},	// CJK UNIFIED IDEOGRAPH
	{0xD360,	0x7F5B},	// CJK UNIFIED IDEOGRAPH
	{0xD361,	0x7F96},	// CJK UNIFIED IDEOGRAPH
	{0xD362,	0x7F92},	// CJK UNIFIED IDEOGRAPH
	{0xD363,	0x7FC3},	// CJK UNIFIED IDEOGRAPH
	{0xD364,	0x7FC2},	// CJK UNIFIED IDEOGRAPH
	{0xD365,	0x7FC0},	// CJK UNIFIED IDEOGRAPH
	{0xD366,	0x8016},	// CJK UNIFIED IDEOGRAPH
	{0xD367,	0x803E},	// CJK UNIFIED IDEOGRAPH
	{0xD368,	0x8039},	// CJK UNIFIED IDEOGRAPH
	{0xD369,	0x80FA},	// CJK UNIFIED IDEOGRAPH
	{0xD36A,	0x80F2},	// CJK UNIFIED IDEOGRAPH
	{0xD36B,	0x80F9},	// CJK UNIFIED IDEOGRAPH
	{0xD36C,	0x80F5},	// CJK UNIFIED IDEOGRAPH
	{0xD36D,	0x8101},	// CJK UNIFIED IDEOGRAPH
	{0xD36E,	0x80FB},	// CJK UNIFIED IDEOGRAPH
	{0xD36F,	0x8100},	// CJK UNIFIED IDEOGRAPH
	{0xD370,	0x8201},	// CJK UNIFIED IDEOGRAPH
	{0xD371,	0x822F},	// CJK UNIFIED IDEOGRAPH
	{0xD372,	0x8225},	// CJK UNIFIED IDEOGRAPH
	{0xD373,	0x8333},	// CJK UNIFIED IDEOGRAPH
	{0xD374,	0x832D},	// CJK UNIFIED IDEOGRAPH
	{0xD375,	0x8344},	// CJK UNIFIED IDEOGRAPH
	{0xD376,	0x8319},	// CJK UNIFIED IDEOGRAPH
	{0xD377,	0x8351},	// CJK UNIFIED IDEOGRAPH
	{0xD378,	0x8325},	// CJK UNIFIED IDEOGRAPH
	{0xD379,	0x8356},	// CJK UNIFIED IDEOGRAPH
	{0xD37A,	0x833F},	// CJK UNIFIED IDEOGRAPH
	{0xD37B,	0x8341},	// CJK UNIFIED IDEOGRAPH
	{0xD37C,	0x8326},	// CJK UNIFIED IDEOGRAPH
	{0xD37D,	0x831C},	// CJK UNIFIED IDEOGRAPH
	{0xD37E,	0x8322},	// CJK UNIFIED IDEOGRAPH
	{0xD3A1,	0x8342},	// CJK UNIFIED IDEOGRAPH
	{0xD3A2,	0x834E},	// CJK UNIFIED IDEOGRAPH
	{0xD3A3,	0x831B},	// CJK UNIFIED IDEOGRAPH
	{0xD3A4,	0x832A},	// CJK UNIFIED IDEOGRAPH
	{0xD3A5,	0x8308},	// CJK UNIFIED IDEOGRAPH
	{0xD3A6,	0x833C},	// CJK UNIFIED IDEOGRAPH
	{0xD3A7,	0x834D},	// CJK UNIFIED IDEOGRAPH
	{0xD3A8,	0x8316},	// CJK UNIFIED IDEOGRAPH
	{0xD3A9,	0x8324},	// CJK UNIFIED IDEOGRAPH
	{0xD3AA,	0x8320},	// CJK UNIFIED IDEOGRAPH
	{0xD3AB,	0x8337},	// CJK UNIFIED IDEOGRAPH
	{0xD3AC,	0x832F},	// CJK UNIFIED IDEOGRAPH
	{0xD3AD,	0x8329},	// CJK UNIFIED IDEOGRAPH
	{0xD3AE,	0x8347},	// CJK UNIFIED IDEOGRAPH
	{0xD3AF,	0x8345},	// CJK UNIFIED IDEOGRAPH
	{0xD3B0,	0x834C},	// CJK UNIFIED IDEOGRAPH
	{0xD3B1,	0x8353},	// CJK UNIFIED IDEOGRAPH
	{0xD3B2,	0x831E},	// CJK UNIFIED IDEOGRAPH
	{0xD3B3,	0x832C},	// CJK UNIFIED IDEOGRAPH
	{0xD3B4,	0x834B},	// CJK UNIFIED IDEOGRAPH
	{0xD3B5,	0x8327},	// CJK UNIFIED IDEOGRAPH
	{0xD3B6,	0x8348},	// CJK UNIFIED IDEOGRAPH
	{0xD3B7,	0x8653},	// CJK UNIFIED IDEOGRAPH
	{0xD3B8,	0x8652},	// CJK UNIFIED IDEOGRAPH
	{0xD3B9,	0x86A2},	// CJK UNIFIED IDEOGRAPH
	{0xD3BA,	0x86A8},	// CJK UNIFIED IDEOGRAPH
	{0xD3BB,	0x8696},	// CJK UNIFIED IDEOGRAPH
	{0xD3BC,	0x868D},	// CJK UNIFIED IDEOGRAPH
	{0xD3BD,	0x8691},	// CJK UNIFIED IDEOGRAPH
	{0xD3BE,	0x869E},	// CJK UNIFIED IDEOGRAPH
	{0xD3BF,	0x8687},	// CJK UNIFIED IDEOGRAPH
	{0xD3C0,	0x8697},	// CJK UNIFIED IDEOGRAPH
	{0xD3C1,	0x8686},	// CJK UNIFIED IDEOGRAPH
	{0xD3C2,	0x868B},	// CJK UNIFIED IDEOGRAPH
	{0xD3C3,	0x869A},	// CJK UNIFIED IDEOGRAPH
	{0xD3C4,	0x8685},	// CJK UNIFIED IDEOGRAPH
	{0xD3C5,	0x86A5},	// CJK UNIFIED IDEOGRAPH
	{0xD3C6,	0x8699},	// CJK UNIFIED IDEOGRAPH
	{0xD3C7,	0x86A1},	// CJK UNIFIED IDEOGRAPH
	{0xD3C8,	0x86A7},	// CJK UNIFIED IDEOGRAPH
	{0xD3C9,	0x8695},	// CJK UNIFIED IDEOGRAPH
	{0xD3CA,	0x8698},	// CJK UNIFIED IDEOGRAPH
	{0xD3CB,	0x868E},	// CJK UNIFIED IDEOGRAPH
	{0xD3CC,	0x869D},	// CJK UNIFIED IDEOGRAPH
	{0xD3CD,	0x8690},	// CJK UNIFIED IDEOGRAPH
	{0xD3CE,	0x8694},	// CJK UNIFIED IDEOGRAPH
	{0xD3CF,	0x8843},	// CJK UNIFIED IDEOGRAPH
	{0xD3D0,	0x8844},	// CJK UNIFIED IDEOGRAPH
	{0xD3D1,	0x886D},	// CJK UNIFIED IDEOGRAPH
	{0xD3D2,	0x8875},	// CJK UNIFIED IDEOGRAPH
	{0xD3D3,	0x8876},	// CJK UNIFIED IDEOGRAPH
	{0xD3D4,	0x8872},	// CJK UNIFIED IDEOGRAPH
	{0xD3D5,	0x8880},	// CJK UNIFIED IDEOGRAPH
	{0xD3D6,	0x8871},	// CJK UNIFIED IDEOGRAPH
	{0xD3D7,	0x887F},	// CJK UNIFIED IDEOGRAPH
	{0xD3D8,	0x886F},	// CJK UNIFIED IDEOGRAPH
	{0xD3D9,	0x8883},	// CJK UNIFIED IDEOGRAPH
	{0xD3DA,	0x887E},	// CJK UNIFIED IDEOGRAPH
	{0xD3DB,	0x8874},	// CJK UNIFIED IDEOGRAPH
	{0xD3DC,	0x887C},	// CJK UNIFIED IDEOGRAPH
	{0xD3DD,	0x8A12},	// CJK UNIFIED IDEOGRAPH
	{0xD3DE,	0x8C47},	// CJK UNIFIED IDEOGRAPH
	{0xD3DF,	0x8C57},	// CJK UNIFIED IDEOGRAPH
	{0xD3E0,	0x8C7B},	// CJK UNIFIED IDEOGRAPH
	{0xD3E1,	0x8CA4},	// CJK UNIFIED IDEOGRAPH
	{0xD3E2,	0x8CA3},	// CJK UNIFIED IDEOGRAPH
	{0xD3E3,	0x8D76},	// CJK UNIFIED IDEOGRAPH
	{0xD3E4,	0x8D78},	// CJK UNIFIED IDEOGRAPH
	{0xD3E5,	0x8DB5},	// CJK UNIFIED IDEOGRAPH
	{0xD3E6,	0x8DB7},	// CJK UNIFIED IDEOGRAPH
	{0xD3E7,	0x8DB6},	// CJK UNIFIED IDEOGRAPH
	{0xD3E8,	0x8ED1},	// CJK UNIFIED IDEOGRAPH
	{0xD3E9,	0x8ED3},	// CJK UNIFIED IDEOGRAPH
	{0xD3EA,	0x8FFE},	// CJK UNIFIED IDEOGRAPH
	{0xD3EB,	0x8FF5},	// CJK UNIFIED IDEOGRAPH
	{0xD3EC,	0x9002},	// CJK UNIFIED IDEOGRAPH
	{0xD3ED,	0x8FFF},	// CJK UNIFIED IDEOGRAPH
	{0xD3EE,	0x8FFB},	// CJK UNIFIED IDEOGRAPH
	{0xD3EF,	0x9004},	// CJK UNIFIED IDEOGRAPH
	{0xD3F0,	0x8FFC},	// CJK UNIFIED IDEOGRAPH
	{0xD3F1,	0x8FF6},	// CJK UNIFIED IDEOGRAPH
	{0xD3F2,	0x90D6},	// CJK UNIFIED IDEOGRAPH
	{0xD3F3,	0x90E0},	// CJK UNIFIED IDEOGRAPH
	{0xD3F4,	0x90D9},	// CJK UNIFIED IDEOGRAPH
	{0xD3F5,	0x90DA},	// CJK UNIFIED IDEOGRAPH
	{0xD3F6,	0x90E3},	// CJK UNIFIED IDEOGRAPH
	{0xD3F7,	0x90DF},	// CJK UNIFIED IDEOGRAPH
	{0xD3F8,	0x90E5},	// CJK UNIFIED IDEOGRAPH
	{0xD3F9,	0x90D8},	// CJK UNIFIED IDEOGRAPH
	{0xD3FA,	0x90DB},	// CJK UNIFIED IDEOGRAPH
	{0xD3FB,	0x90D7},	// CJK UNIFIED IDEOGRAPH
	{0xD3FC,	0x90DC},	// CJK UNIFIED IDEOGRAPH
	{0xD3FD,	0x90E4},	// CJK UNIFIED IDEOGRAPH
	{0xD3FE,	0x9150},	// CJK UNIFIED IDEOGRAPH
	{0xD440,	0x914E},	// CJK UNIFIED IDEOGRAPH
	{0xD441,	0x914F},	// CJK UNIFIED IDEOGRAPH
	{0xD442,	0x91D5},	// CJK UNIFIED IDEOGRAPH
	{0xD443,	0x91E2},	// CJK UNIFIED IDEOGRAPH
	{0xD444,	0x91DA},	// CJK UNIFIED IDEOGRAPH
	{0xD445,	0x965C},	// CJK UNIFIED IDEOGRAPH
	{0xD446,	0x965F},	// CJK UNIFIED IDEOGRAPH
	{0xD447,	0x96BC},	// CJK UNIFIED IDEOGRAPH
	{0xD448,	0x98E3},	// CJK UNIFIED IDEOGRAPH
	{0xD449,	0x9ADF},	// CJK UNIFIED IDEOGRAPH
	{0xD44A,	0x9B2F},	// CJK UNIFIED IDEOGRAPH
	{0xD44B,	0x4E7F},	// CJK UNIFIED IDEOGRAPH
	{0xD44C,	0x5070},	// CJK UNIFIED IDEOGRAPH
	{0xD44D,	0x506A},	// CJK UNIFIED IDEOGRAPH
	{0xD44E,	0x5061},	// CJK UNIFIED IDEOGRAPH
	{0xD44F,	0x505E},	// CJK UNIFIED IDEOGRAPH
	{0xD450,	0x5060},	// CJK UNIFIED IDEOGRAPH
	{0xD451,	0x5053},	// CJK UNIFIED IDEOGRAPH
	{0xD452,	0x504B},	// CJK UNIFIED IDEOGRAPH
	{0xD453,	0x505D},	// CJK UNIFIED IDEOGRAPH
	{0xD454,	0x5072},	// CJK UNIFIED IDEOGRAPH
	{0xD455,	0x5048},	// CJK UNIFIED IDEOGRAPH
	{0xD456,	0x504D},	// CJK UNIFIED IDEOGRAPH
	{0xD457,	0x5041},	// CJK UNIFIED IDEOGRAPH
	{0xD458,	0x505B},	// CJK UNIFIED IDEOGRAPH
	{0xD459,	0x504A},	// CJK UNIFIED IDEOGRAPH
	{0xD45A,	0x5062},	// CJK UNIFIED IDEOGRAPH
	{0xD45B,	0x5015},	// CJK UNIFIED IDEOGRAPH
	{0xD45C,	0x5045},	// CJK UNIFIED IDEOGRAPH
	{0xD45D,	0x505F},	// CJK UNIFIED IDEOGRAPH
	{0xD45E,	0x5069},	// CJK UNIFIED IDEOGRAPH
	{0xD45F,	0x506B},	// CJK UNIFIED IDEOGRAPH
	{0xD460,	0x5063},	// CJK UNIFIED IDEOGRAPH
	{0xD461,	0x5064},	// CJK UNIFIED IDEOGRAPH
	{0xD462,	0x5046},	// CJK UNIFIED IDEOGRAPH
	{0xD463,	0x5040},	// CJK UNIFIED IDEOGRAPH
	{0xD464,	0x506E},	// CJK UNIFIED IDEOGRAPH
	{0xD465,	0x5073},	// CJK UNIFIED IDEOGRAPH
	{0xD466,	0x5057},	// CJK UNIFIED IDEOGRAPH
	{0xD467,	0x5051},	// CJK UNIFIED IDEOGRAPH
	{0xD468,	0x51D0},	// CJK UNIFIED IDEOGRAPH
	{0xD469,	0x526B},	// CJK UNIFIED IDEOGRAPH
	{0xD46A,	0x526D},	// CJK UNIFIED IDEOGRAPH
	{0xD46B,	0x526C},	// CJK UNIFIED IDEOGRAPH
	{0xD46C,	0x526E},	// CJK UNIFIED IDEOGRAPH
	{0xD46D,	0x52D6},	// CJK UNIFIED IDEOGRAPH
	{0xD46E,	0x52D3},	// CJK UNIFIED IDEOGRAPH
	{0xD46F,	0x532D},	// CJK UNIFIED IDEOGRAPH
	{0xD470,	0x539C},	// CJK UNIFIED IDEOGRAPH
	{0xD471,	0x5575},	// CJK UNIFIED IDEOGRAPH
	{0xD472,	0x5576},	// CJK UNIFIED IDEOGRAPH
	{0xD473,	0x553C},	// CJK UNIFIED IDEOGRAPH
	{0xD474,	0x554D},	// CJK UNIFIED IDEOGRAPH
	{0xD475,	0x5550},	// CJK UNIFIED IDEOGRAPH
	{0xD476,	0x5534},	// CJK UNIFIED IDEOGRAPH
	{0xD477,	0x552A},	// CJK UNIFIED IDEOGRAPH
	{0xD478,	0x5551},	// CJK UNIFIED IDEOGRAPH
	{0xD479,	0x5562},	// CJK UNIFIED IDEOGRAPH
	{0xD47A,	0x5536},	// CJK UNIFIED IDEOGRAPH
	{0xD47B,	0x5535},	// CJK UNIFIED IDEOGRAPH
	{0xD47C,	0x5530},	// CJK UNIFIED IDEOGRAPH
	{0xD47D,	0x5552},	// CJK UNIFIED IDEOGRAPH
	{0xD47E,	0x5545},	// CJK UNIFIED IDEOGRAPH
	{0xD4A1,	0x550C},	// CJK UNIFIED IDEOGRAPH
	{0xD4A2,	0x5532},	// CJK UNIFIED IDEOGRAPH
	{0xD4A3,	0x5565},	// CJK UNIFIED IDEOGRAPH
	{0xD4A4,	0x554E},	// CJK UNIFIED IDEOGRAPH
	{0xD4A5,	0x5539},	// CJK UNIFIED IDEOGRAPH
	{0xD4A6,	0x5548},	// CJK UNIFIED IDEOGRAPH
	{0xD4A7,	0x552D},	// CJK UNIFIED IDEOGRAPH
	{0xD4A8,	0x553B},	// CJK UNIFIED IDEOGRAPH
	{0xD4A9,	0x5540},	// CJK UNIFIED IDEOGRAPH
	{0xD4AA,	0x554B},	// CJK UNIFIED IDEOGRAPH
	{0xD4AB,	0x570A},	// CJK UNIFIED IDEOGRAPH
	{0xD4AC,	0x5707},	// CJK UNIFIED IDEOGRAPH
	{0xD4AD,	0x57FB},	// CJK UNIFIED IDEOGRAPH
	{0xD4AE,	0x5814},	// CJK UNIFIED IDEOGRAPH
	{0xD4AF,	0x57E2},	// CJK UNIFIED IDEOGRAPH
	{0xD4B0,	0x57F6},	// CJK UNIFIED IDEOGRAPH
	{0xD4B1,	0x57DC},	// CJK UNIFIED IDEOGRAPH
	{0xD4B2,	0x57F4},	// CJK UNIFIED IDEOGRAPH
	{0xD4B3,	0x5800},	// CJK UNIFIED IDEOGRAPH
	{0xD4B4,	0x57ED},	// CJK UNIFIED IDEOGRAPH
	{0xD4B5,	0x57FD},	// CJK UNIFIED IDEOGRAPH
	{0xD4B6,	0x5808},	// CJK UNIFIED IDEOGRAPH
	{0xD4B7,	0x57F8},	// CJK UNIFIED IDEOGRAPH
	{0xD4B8,	0x580B},	// CJK UNIFIED IDEOGRAPH
	{0xD4B9,	0x57F3},	// CJK UNIFIED IDEOGRAPH
	{0xD4BA,	0x57CF},	// CJK UNIFIED IDEOGRAPH
	{0xD4BB,	0x5807},	// CJK UNIFIED IDEOGRAPH
	{0xD4BC,	0x57EE},	// CJK UNIFIED IDEOGRAPH
	{0xD4BD,	0x57E3},	// CJK UNIFIED IDEOGRAPH
	{0xD4BE,	0x57F2},	// CJK UNIFIED IDEOGRAPH
	{0xD4BF,	0x57E5},	// CJK UNIFIED IDEOGRAPH
	{0xD4C0,	0x57EC},	// CJK UNIFIED IDEOGRAPH
	{0xD4C1,	0x57E1},	// CJK UNIFIED IDEOGRAPH
	{0xD4C2,	0x580E},	// CJK UNIFIED IDEOGRAPH
	{0xD4C3,	0x57FC},	// CJK UNIFIED IDEOGRAPH
	{0xD4C4,	0x5810},	// CJK UNIFIED IDEOGRAPH
	{0xD4C5,	0x57E7},	// CJK UNIFIED IDEOGRAPH
	{0xD4C6,	0x5801},	// CJK UNIFIED IDEOGRAPH
	{0xD4C7,	0x580C},	// CJK UNIFIED IDEOGRAPH
	{0xD4C8,	0x57F1},	// CJK UNIFIED IDEOGRAPH
	{0xD4C9,	0x57E9},	// CJK UNIFIED IDEOGRAPH
	{0xD4CA,	0x57F0},	// CJK UNIFIED IDEOGRAPH
	{0xD4CB,	0x580D},	// CJK UNIFIED IDEOGRAPH
	{0xD4CC,	0x5804},	// CJK UNIFIED IDEOGRAPH
	{0xD4CD,	0x595C},	// CJK UNIFIED IDEOGRAPH
	{0xD4CE,	0x5A60},	// CJK UNIFIED IDEOGRAPH
	{0xD4CF,	0x5A58},	// CJK UNIFIED IDEOGRAPH
	{0xD4D0,	0x5A55},	// CJK UNIFIED IDEOGRAPH
	{0xD4D1,	0x5A67},	// CJK UNIFIED IDEOGRAPH
	{0xD4D2,	0x5A5E},	// CJK UNIFIED IDEOGRAPH
	{0xD4D3,	0x5A38},	// CJK UNIFIED IDEOGRAPH
	{0xD4D4,	0x5A35},	// CJK UNIFIED IDEOGRAPH
	{0xD4D5,	0x5A6D},	// CJK UNIFIED IDEOGRAPH
	{0xD4D6,	0x5A50},	// CJK UNIFIED IDEOGRAPH
	{0xD4D7,	0x5A5F},	// CJK UNIFIED IDEOGRAPH
	{0xD4D8,	0x5A65},	// CJK UNIFIED IDEOGRAPH
	{0xD4D9,	0x5A6C},	// CJK UNIFIED IDEOGRAPH
	{0xD4DA,	0x5A53},	// CJK UNIFIED IDEOGRAPH
	{0xD4DB,	0x5A64},	// CJK UNIFIED IDEOGRAPH
	{0xD4DC,	0x5A57},	// CJK UNIFIED IDEOGRAPH
	{0xD4DD,	0x5A43},	// CJK UNIFIED IDEOGRAPH
	{0xD4DE,	0x5A5D},	// CJK UNIFIED IDEOGRAPH
	{0xD4DF,	0x5A52},	// CJK UNIFIED IDEOGRAPH
	{0xD4E0,	0x5A44},	// CJK UNIFIED IDEOGRAPH
	{0xD4E1,	0x5A5B},	// CJK UNIFIED IDEOGRAPH
	{0xD4E2,	0x5A48},	// CJK UNIFIED IDEOGRAPH
	{0xD4E3,	0x5A8E},	// CJK UNIFIED IDEOGRAPH
	{0xD4E4,	0x5A3E},	// CJK UNIFIED IDEOGRAPH
	{0xD4E5,	0x5A4D},	// CJK UNIFIED IDEOGRAPH
	{0xD4E6,	0x5A39},	// CJK UNIFIED IDEOGRAPH
	{0xD4E7,	0x5A4C},	// CJK UNIFIED IDEOGRAPH
	{0xD4E8,	0x5A70},	// CJK UNIFIED IDEOGRAPH
	{0xD4E9,	0x5A69},	// CJK UNIFIED IDEOGRAPH
	{0xD4EA,	0x5A47},	// CJK UNIFIED IDEOGRAPH
	{0xD4EB,	0x5A51},	// CJK UNIFIED IDEOGRAPH
	{0xD4EC,	0x5A56},	// CJK UNIFIED IDEOGRAPH
	{0xD4ED,	0x5A42},	// CJK UNIFIED IDEOGRAPH
	{0xD4EE,	0x5A5C},	// CJK UNIFIED IDEOGRAPH
	{0xD4EF,	0x5B72},	// CJK UNIFIED IDEOGRAPH
	{0xD4F0,	0x5B6E},	// CJK UNIFIED IDEOGRAPH
	{0xD4F1,	0x5BC1},	// CJK UNIFIED IDEOGRAPH
	{0xD4F2,	0x5BC0},	// CJK UNIFIED IDEOGRAPH
	{0xD4F3,	0x5C59},	// CJK UNIFIED IDEOGRAPH
	{0xD4F4,	0x5D1E},	// CJK UNIFIED IDEOGRAPH
	{0xD4F5,	0x5D0B},	// CJK UNIFIED IDEOGRAPH
	{0xD4F6,	0x5D1D},	// CJK UNIFIED IDEOGRAPH
	{0xD4F7,	0x5D1A},	// CJK UNIFIED IDEOGRAPH
	{0xD4F8,	0x5D20},	// CJK UNIFIED IDEOGRAPH
	{0xD4F9,	0x5D0C},	// CJK UNIFIED IDEOGRAPH
	{0xD4FA,	0x5D28},	// CJK UNIFIED IDEOGRAPH
	{0xD4FB,	0x5D0D},	// CJK UNIFIED IDEOGRAPH
	{0xD4FC,	0x5D26},	// CJK UNIFIED IDEOGRAPH
	{0xD4FD,	0x5D25},	// CJK UNIFIED IDEOGRAPH
	{0xD4FE,	0x5D0F},	// CJK UNIFIED IDEOGRAPH
	{0xD540,	0x5D30},	// CJK UNIFIED IDEOGRAPH
	{0xD541,	0x5D12},	// CJK UNIFIED IDEOGRAPH
	{0xD542,	0x5D23},	// CJK UNIFIED IDEOGRAPH
	{0xD543,	0x5D1F},	// CJK UNIFIED IDEOGRAPH
	{0xD544,	0x5D2E},	// CJK UNIFIED IDEOGRAPH
	{0xD545,	0x5E3E},	// CJK UNIFIED IDEOGRAPH
	{0xD546,	0x5E34},	// CJK UNIFIED IDEOGRAPH
	{0xD547,	0x5EB1},	// CJK UNIFIED IDEOGRAPH
	{0xD548,	0x5EB4},	// CJK UNIFIED IDEOGRAPH
	{0xD549,	0x5EB9},	// CJK UNIFIED IDEOGRAPH
	{0xD54A,	0x5EB2},	// CJK UNIFIED IDEOGRAPH
	{0xD54B,	0x5EB3},	// CJK UNIFIED IDEOGRAPH
	{0xD54C,	0x5F36},	// CJK UNIFIED IDEOGRAPH
	{0xD54D,	0x5F38},	// CJK UNIFIED IDEOGRAPH
	{0xD54E,	0x5F9B},	// CJK UNIFIED IDEOGRAPH
	{0xD54F,	0x5F96},	// CJK UNIFIED IDEOGRAPH
	{0xD550,	0x5F9F},	// CJK UNIFIED IDEOGRAPH
	{0xD551,	0x608A},	// CJK UNIFIED IDEOGRAPH
	{0xD552,	0x6090},	// CJK UNIFIED IDEOGRAPH
	{0xD553,	0x6086},	// CJK UNIFIED IDEOGRAPH
	{0xD554,	0x60BE},	// CJK UNIFIED IDEOGRAPH
	{0xD555,	0x60B0},	// CJK UNIFIED IDEOGRAPH
	{0xD556,	0x60BA},	// CJK UNIFIED IDEOGRAPH
	{0xD557,	0x60D3},	// CJK UNIFIED IDEOGRAPH
	{0xD558,	0x60D4},	// CJK UNIFIED IDEOGRAPH
	{0xD559,	0x60CF},	// CJK UNIFIED IDEOGRAPH
	{0xD55A,	0x60E4},	// CJK UNIFIED IDEOGRAPH
	{0xD55B,	0x60D9},	// CJK UNIFIED IDEOGRAPH
	{0xD55C,	0x60DD},	// CJK UNIFIED IDEOGRAPH
	{0xD55D,	0x60C8},	// CJK UNIFIED IDEOGRAPH
	{0xD55E,	0x60B1},	// CJK UNIFIED IDEOGRAPH
	{0xD55F,	0x60DB},	// CJK UNIFIED IDEOGRAPH
	{0xD560,	0x60B7},	// CJK UNIFIED IDEOGRAPH
	{0xD561,	0x60CA},	// CJK UNIFIED IDEOGRAPH
	{0xD562,	0x60BF},	// CJK UNIFIED IDEOGRAPH
	{0xD563,	0x60C3},	// CJK UNIFIED IDEOGRAPH
	{0xD564,	0x60CD},	// CJK UNIFIED IDEOGRAPH
	{0xD565,	0x60C0},	// CJK UNIFIED IDEOGRAPH
	{0xD566,	0x6332},	// CJK UNIFIED IDEOGRAPH
	{0xD567,	0x6365},	// CJK UNIFIED IDEOGRAPH
	{0xD568,	0x638A},	// CJK UNIFIED IDEOGRAPH
	{0xD569,	0x6382},	// CJK UNIFIED IDEOGRAPH
	{0xD56A,	0x637D},	// CJK UNIFIED IDEOGRAPH
	{0xD56B,	0x63BD},	// CJK UNIFIED IDEOGRAPH
	{0xD56C,	0x639E},	// CJK UNIFIED IDEOGRAPH
	{0xD56D,	0x63AD},	// CJK UNIFIED IDEOGRAPH
	{0xD56E,	0x639D},	// CJK UNIFIED IDEOGRAPH
	{0xD56F,	0x6397},	// CJK UNIFIED IDEOGRAPH
	{0xD570,	0x63AB},	// CJK UNIFIED IDEOGRAPH
	{0xD571,	0x638E},	// CJK UNIFIED IDEOGRAPH
	{0xD572,	0x636F},	// CJK UNIFIED IDEOGRAPH
	{0xD573,	0x6387},	// CJK UNIFIED IDEOGRAPH
	{0xD574,	0x6390},	// CJK UNIFIED IDEOGRAPH
	{0xD575,	0x636E},	// CJK UNIFIED IDEOGRAPH
	{0xD576,	0x63AF},	// CJK UNIFIED IDEOGRAPH
	{0xD577,	0x6375},	// CJK UNIFIED IDEOGRAPH
	{0xD578,	0x639C},	// CJK UNIFIED IDEOGRAPH
	{0xD579,	0x636D},	// CJK UNIFIED IDEOGRAPH
	{0xD57A,	0x63AE},	// CJK UNIFIED IDEOGRAPH
	{0xD57B,	0x637C},	// CJK UNIFIED IDEOGRAPH
	{0xD57C,	0x63A4},	// CJK UNIFIED IDEOGRAPH
	{0xD57D,	0x633B},	// CJK UNIFIED IDEOGRAPH
	{0xD57E,	0x639F},	// CJK UNIFIED IDEOGRAPH
	{0xD5A1,	0x6378},	// CJK UNIFIED IDEOGRAPH
	{0xD5A2,	0x6385},	// CJK UNIFIED IDEOGRAPH
	{0xD5A3,	0x6381},	// CJK UNIFIED IDEOGRAPH
	{0xD5A4,	0x6391},	// CJK UNIFIED IDEOGRAPH
	{0xD5A5,	0x638D},	// CJK UNIFIED IDEOGRAPH
	{0xD5A6,	0x6370},	// CJK UNIFIED IDEOGRAPH
	{0xD5A7,	0x6553},	// CJK UNIFIED IDEOGRAPH
	{0xD5A8,	0x65CD},	// CJK UNIFIED IDEOGRAPH
	{0xD5A9,	0x6665},	// CJK UNIFIED IDEOGRAPH
	{0xD5AA,	0x6661},	// CJK UNIFIED IDEOGRAPH
	{0xD5AB,	0x665B},	// CJK UNIFIED IDEOGRAPH
	{0xD5AC,	0x6659},	// CJK UNIFIED IDEOGRAPH
	{0xD5AD,	0x665C},	// CJK UNIFIED IDEOGRAPH
	{0xD5AE,	0x6662},	// CJK UNIFIED IDEOGRAPH
	{0xD5AF,	0x6718},	// CJK UNIFIED IDEOGRAPH
	{0xD5B0,	0x6879},	// CJK UNIFIED IDEOGRAPH
	{0xD5B1,	0x6887},	// CJK UNIFIED IDEOGRAPH
	{0xD5B2,	0x6890},	// CJK UNIFIED IDEOGRAPH
	{0xD5B3,	0x689C},	// CJK UNIFIED IDEOGRAPH
	{0xD5B4,	0x686D},	// CJK UNIFIED IDEOGRAPH
	{0xD5B5,	0x686E},	// CJK UNIFIED IDEOGRAPH
	{0xD5B6,	0x68AE},	// CJK UNIFIED IDEOGRAPH
	{0xD5B7,	0x68AB},	// CJK UNIFIED IDEOGRAPH
	{0xD5B8,	0x6956},	// CJK UNIFIED IDEOGRAPH
	{0xD5B9,	0x686F},	// CJK UNIFIED IDEOGRAPH
	{0xD5BA,	0x68A3},	// CJK UNIFIED IDEOGRAPH
	{0xD5BB,	0x68AC},	// CJK UNIFIED IDEOGRAPH
	{0xD5BC,	0x68A9},	// CJK UNIFIED IDEOGRAPH
	{0xD5BD,	0x6875},	// CJK UNIFIED IDEOGRAPH
	{0xD5BE,	0x6874},	// CJK UNIFIED IDEOGRAPH
	{0xD5BF,	0x68B2},	// CJK UNIFIED IDEOGRAPH
	{0xD5C0,	0x688F},	// CJK UNIFIED IDEOGRAPH
	{0xD5C1,	0x6877},	// CJK UNIFIED IDEOGRAPH
	{0xD5C2,	0x6892},	// CJK UNIFIED IDEOGRAPH
	{0xD5C3,	0x687C},	// CJK UNIFIED IDEOGRAPH
	{0xD5C4,	0x686B},	// CJK UNIFIED IDEOGRAPH
	{0xD5C5,	0x6872},	// CJK UNIFIED IDEOGRAPH
	{0xD5C6,	0x68AA},	// CJK UNIFIED IDEOGRAPH
	{0xD5C7,	0x6880},	// CJK UNIFIED IDEOGRAPH
	{0xD5C8,	0x6871},	// CJK UNIFIED IDEOGRAPH
	{0xD5C9,	0x687E},	// CJK UNIFIED IDEOGRAPH
	{0xD5CA,	0x689B},	// CJK UNIFIED IDEOGRAPH
	{0xD5CB,	0x6896},	// CJK UNIFIED IDEOGRAPH
	{0xD5CC,	0x688B},	// CJK UNIFIED IDEOGRAPH
	{0xD5CD,	0x68A0},	// CJK UNIFIED IDEOGRAPH
	{0xD5CE,	0x6889},	// CJK UNIFIED IDEOGRAPH
	{0xD5CF,	0x68A4},	// CJK UNIFIED IDEOGRAPH
	{0xD5D0,	0x6878},	// CJK UNIFIED IDEOGRAPH
	{0xD5D1,	0x687B},	// CJK UNIFIED IDEOGRAPH
	{0xD5D2,	0x6891},	// CJK UNIFIED IDEOGRAPH
	{0xD5D3,	0x688C},	// CJK UNIFIED IDEOGRAPH
	{0xD5D4,	0x688A},	// CJK UNIFIED IDEOGRAPH
	{0xD5D5,	0x687D},	// CJK UNIFIED IDEOGRAPH
	{0xD5D6,	0x6B36},	// CJK UNIFIED IDEOGRAPH
	{0xD5D7,	0x6B33},	// CJK UNIFIED IDEOGRAPH
	{0xD5D8,	0x6B37},	// CJK UNIFIED IDEOGRAPH
	{0xD5D9,	0x6B38},	// CJK UNIFIED IDEOGRAPH
	{0xD5DA,	0x6B91},	// CJK UNIFIED IDEOGRAPH
	{0xD5DB,	0x6B8F},	// CJK UNIFIED IDEOGRAPH
	{0xD5DC,	0x6B8D},	// CJK UNIFIED IDEOGRAPH
	{0xD5DD,	0x6B8E},	// CJK UNIFIED IDEOGRAPH
	{0xD5DE,	0x6B8C},	// CJK UNIFIED IDEOGRAPH
	{0xD5DF,	0x6C2A},	// CJK UNIFIED IDEOGRAPH
	{0xD5E0,	0x6DC0},	// CJK UNIFIED IDEOGRAPH
	{0xD5E1,	0x6DAB},	// CJK UNIFIED IDEOGRAPH
	{0xD5E2,	0x6DB4},	// CJK UNIFIED IDEOGRAPH
	{0xD5E3,	0x6DB3},	// CJK UNIFIED IDEOGRAPH
	{0xD5E4,	0x6E74},	// CJK UNIFIED IDEOGRAPH
	{0xD5E5,	0x6DAC},	// CJK UNIFIED IDEOGRAPH
	{0xD5E6,	0x6DE9},	// CJK UNIFIED IDEOGRAPH
	{0xD5E7,	0x6DE2},	// CJK UNIFIED IDEOGRAPH
	{0xD5E8,	0x6DB7},	// CJK UNIFIED IDEOGRAPH
	{0xD5E9,	0x6DF6},	// CJK UNIFIED IDEOGRAPH
	{0xD5EA,	0x6DD4},	// CJK UNIFIED IDEOGRAPH
	{0xD5EB,	0x6E00},	// CJK UNIFIED IDEOGRAPH
	{0xD5EC,	0x6DC8},	// CJK UNIFIED IDEOGRAPH
	{0xD5ED,	0x6DE0},	// CJK UNIFIED IDEOGRAPH
	{0xD5EE,	0x6DDF},	// CJK UNIFIED IDEOGRAPH
	{0xD5EF,	0x6DD6},	// CJK UNIFIED IDEOGRAPH
	{0xD5F0,	0x6DBE},	// CJK UNIFIED IDEOGRAPH
	{0xD5F1,	0x6DE5},	// CJK UNIFIED IDEOGRAPH
	{0xD5F2,	0x6DDC},	// CJK UNIFIED IDEOGRAPH
	{0xD5F3,	0x6DDD},	// CJK UNIFIED IDEOGRAPH
	{0xD5F4,	0x6DDB},	// CJK UNIFIED IDEOGRAPH
	{0xD5F5,	0x6DF4},	// CJK UNIFIED IDEOGRAPH
	{0xD5F6,	0x6DCA},	// CJK UNIFIED IDEOGRAPH
	{0xD5F7,	0x6DBD},	// CJK UNIFIED IDEOGRAPH
	{0xD5F8,	0x6DED},	// CJK UNIFIED IDEOGRAPH
	{0xD5F9,	0x6DF0},	// CJK UNIFIED IDEOGRAPH
	{0xD5FA,	0x6DBA},	// CJK UNIFIED IDEOGRAPH
	{0xD5FB,	0x6DD5},	// CJK UNIFIED IDEOGRAPH
	{0xD5FC,	0x6DC2},	// CJK UNIFIED IDEOGRAPH
	{0xD5FD,	0x6DCF},	// CJK UNIFIED IDEOGRAPH
	{0xD5FE,	0x6DC9},	// CJK UNIFIED IDEOGRAPH
	{0xD640,	0x6DD0},	// CJK UNIFIED IDEOGRAPH
	{0xD641,	0x6DF2},	// CJK UNIFIED IDEOGRAPH
	{0xD642,	0x6DD3},	// CJK UNIFIED IDEOGRAPH
	{0xD643,	0x6DFD},	// CJK UNIFIED IDEOGRAPH
	{0xD644,	0x6DD7},	// CJK UNIFIED IDEOGRAPH
	{0xD645,	0x6DCD},	// CJK UNIFIED IDEOGRAPH
	{0xD646,	0x6DE3},	// CJK UNIFIED IDEOGRAPH
	{0xD647,	0x6DBB},	// CJK UNIFIED IDEOGRAPH
	{0xD648,	0x70FA},	// CJK UNIFIED IDEOGRAPH
	{0xD649,	0x710D},	// CJK UNIFIED IDEOGRAPH
	{0xD64A,	0x70F7},	// CJK UNIFIED IDEOGRAPH
	{0xD64B,	0x7117},	// CJK UNIFIED IDEOGRAPH
	{0xD64C,	0x70F4},	// CJK UNIFIED IDEOGRAPH
	{0xD64D,	0x710C},	// CJK UNIFIED IDEOGRAPH
	{0xD64E,	0x70F0},	// CJK UNIFIED IDEOGRAPH
	{0xD64F,	0x7104},	// CJK UNIFIED IDEOGRAPH
	{0xD650,	0x70F3},	// CJK UNIFIED IDEOGRAPH
	{0xD651,	0x7110},	// CJK UNIFIED IDEOGRAPH
	{0xD652,	0x70FC},	// CJK UNIFIED IDEOGRAPH
	{0xD653,	0x70FF},	// CJK UNIFIED IDEOGRAPH
	{0xD654,	0x7106},	// CJK UNIFIED IDEOGRAPH
	{0xD655,	0x7113},	// CJK UNIFIED IDEOGRAPH
	{0xD656,	0x7100},	// CJK UNIFIED IDEOGRAPH
	{0xD657,	0x70F8},	// CJK UNIFIED IDEOGRAPH
	{0xD658,	0x70F6},	// CJK UNIFIED IDEOGRAPH
	{0xD659,	0x710B},	// CJK UNIFIED IDEOGRAPH
	{0xD65A,	0x7102},	// CJK UNIFIED IDEOGRAPH
	{0xD65B,	0x710E},	// CJK UNIFIED IDEOGRAPH
	{0xD65C,	0x727E},	// CJK UNIFIED IDEOGRAPH
	{0xD65D,	0x727B},	// CJK UNIFIED IDEOGRAPH
	{0xD65E,	0x727C},	// CJK UNIFIED IDEOGRAPH
	{0xD65F,	0x727F},	// CJK UNIFIED IDEOGRAPH
	{0xD660,	0x731D},	// CJK UNIFIED IDEOGRAPH
	{0xD661,	0x7317},	// CJK UNIFIED IDEOGRAPH
	{0xD662,	0x7307},	// CJK UNIFIED IDEOGRAPH
	{0xD663,	0x7311},	// CJK UNIFIED IDEOGRAPH
	{0xD664,	0x7318},	// CJK UNIFIED IDEOGRAPH
	{0xD665,	0x730A},	// CJK UNIFIED IDEOGRAPH
	{0xD666,	0x7308},	// CJK UNIFIED IDEOGRAPH
	{0xD667,	0x72FF},	// CJK UNIFIED IDEOGRAPH
	{0xD668,	0x730F},	// CJK UNIFIED IDEOGRAPH
	{0xD669,	0x731E},	// CJK UNIFIED IDEOGRAPH
	{0xD66A,	0x7388},	// CJK UNIFIED IDEOGRAPH
	{0xD66B,	0x73F6},	// CJK UNIFIED IDEOGRAPH
	{0xD66C,	0x73F8},	// CJK UNIFIED IDEOGRAPH
	{0xD66D,	0x73F5},	// CJK UNIFIED IDEOGRAPH
	{0xD66E,	0x7404},	// CJK UNIFIED IDEOGRAPH
	{0xD66F,	0x7401},	// CJK UNIFIED IDEOGRAPH
	{0xD670,	0x73FD},	// CJK UNIFIED IDEOGRAPH
	{0xD671,	0x7407},	// CJK UNIFIED IDEOGRAPH
	{0xD672,	0x7400},	// CJK UNIFIED IDEOGRAPH
	{0xD673,	0x73FA},	// CJK UNIFIED IDEOGRAPH
	{0xD674,	0x73FC},	// CJK UNIFIED IDEOGRAPH
	{0xD675,	0x73FF},	// CJK UNIFIED IDEOGRAPH
	{0xD676,	0x740C},	// CJK UNIFIED IDEOGRAPH
	{0xD677,	0x740B},	// CJK UNIFIED IDEOGRAPH
	{0xD678,	0x73F4},	// CJK UNIFIED IDEOGRAPH
	{0xD679,	0x7408},	// CJK UNIFIED IDEOGRAPH
	{0xD67A,	0x7564},	// CJK UNIFIED IDEOGRAPH
	{0xD67B,	0x7563},	// CJK UNIFIED IDEOGRAPH
	{0xD67C,	0x75CE},	// CJK UNIFIED IDEOGRAPH
	{0xD67D,	0x75D2},	// CJK UNIFIED IDEOGRAPH
	{0xD67E,	0x75CF},	// CJK UNIFIED IDEOGRAPH
	{0xD6A1,	0x75CB},	// CJK UNIFIED IDEOGRAPH
	{0xD6A2,	0x75CC},	// CJK UNIFIED IDEOGRAPH
	{0xD6A3,	0x75D1},	// CJK UNIFIED IDEOGRAPH
	{0xD6A4,	0x75D0},	// CJK UNIFIED IDEOGRAPH
	{0xD6A5,	0x768F},	// CJK UNIFIED IDEOGRAPH
	{0xD6A6,	0x7689},	// CJK UNIFIED IDEOGRAPH
	{0xD6A7,	0x76D3},	// CJK UNIFIED IDEOGRAPH
	{0xD6A8,	0x7739},	// CJK UNIFIED IDEOGRAPH
	{0xD6A9,	0x772F},	// CJK UNIFIED IDEOGRAPH
	{0xD6AA,	0x772D},	// CJK UNIFIED IDEOGRAPH
	{0xD6AB,	0x7731},	// CJK UNIFIED IDEOGRAPH
	{0xD6AC,	0x7732},	// CJK UNIFIED IDEOGRAPH
	{0xD6AD,	0x7734},	// CJK UNIFIED IDEOGRAPH
	{0xD6AE,	0x7733},	// CJK UNIFIED IDEOGRAPH
	{0xD6AF,	0x773D},	// CJK UNIFIED IDEOGRAPH
	{0xD6B0,	0x7725},	// CJK UNIFIED IDEOGRAPH
	{0xD6B1,	0x773B},	// CJK UNIFIED IDEOGRAPH
	{0xD6B2,	0x7735},	// CJK UNIFIED IDEOGRAPH
	{0xD6B3,	0x7848},	// CJK UNIFIED IDEOGRAPH
	{0xD6B4,	0x7852},	// CJK UNIFIED IDEOGRAPH
	{0xD6B5,	0x7849},	// CJK UNIFIED IDEOGRAPH
	{0xD6B6,	0x784D},	// CJK UNIFIED IDEOGRAPH
	{0xD6B7,	0x784A},	// CJK UNIFIED IDEOGRAPH
	{0xD6B8,	0x784C},	// CJK UNIFIED IDEOGRAPH
	{0xD6B9,	0x7826},	// CJK UNIFIED IDEOGRAPH
	{0xD6BA,	0x7845},	// CJK UNIFIED IDEOGRAPH
	{0xD6BB,	0x7850},	// CJK UNIFIED IDEOGRAPH
	{0xD6BC,	0x7964},	// CJK UNIFIED IDEOGRAPH
	{0xD6BD,	0x7967},	// CJK UNIFIED IDEOGRAPH
	{0xD6BE,	0x7969},	// CJK UNIFIED IDEOGRAPH
	{0xD6BF,	0x796A},	// CJK UNIFIED IDEOGRAPH
	{0xD6C0,	0x7963},	// CJK UNIFIED IDEOGRAPH
	{0xD6C1,	0x796B},	// CJK UNIFIED IDEOGRAPH
	{0xD6C2,	0x7961},	// CJK UNIFIED IDEOGRAPH
	{0xD6C3,	0x79BB},	// CJK UNIFIED IDEOGRAPH
	{0xD6C4,	0x79FA},	// CJK UNIFIED IDEOGRAPH
	{0xD6C5,	0x79F8},	// CJK UNIFIED IDEOGRAPH
	{0xD6C6,	0x79F6},	// CJK UNIFIED IDEOGRAPH
	{0xD6C7,	0x79F7},	// CJK UNIFIED IDEOGRAPH
	{0xD6C8,	0x7A8F},	// CJK UNIFIED IDEOGRAPH
	{0xD6C9,	0x7A94},	// CJK UNIFIED IDEOGRAPH
	{0xD6CA,	0x7A90},	// CJK UNIFIED IDEOGRAPH
	{0xD6CB,	0x7B35},	// CJK UNIFIED IDEOGRAPH
	{0xD6CC,	0x7B47},	// CJK UNIFIED IDEOGRAPH
	{0xD6CD,	0x7B34},	// CJK UNIFIED IDEOGRAPH
	{0xD6CE,	0x7B25},	// CJK UNIFIED IDEOGRAPH
	{0xD6CF,	0x7B30},	// CJK UNIFIED IDEOGRAPH
	{0xD6D0,	0x7B22},	// CJK UNIFIED IDEOGRAPH
	{0xD6D1,	0x7B24},	// CJK UNIFIED IDEOGRAPH
	{0xD6D2,	0x7B33},	// CJK UNIFIED IDEOGRAPH
	{0xD6D3,	0x7B18},	// CJK UNIFIED IDEOGRAPH
	{0xD6D4,	0x7B2A},	// CJK UNIFIED IDEOGRAPH
	{0xD6D5,	0x7B1D},	// CJK UNIFIED IDEOGRAPH
	{0xD6D6,	0x7B31},	// CJK UNIFIED IDEOGRAPH
	{0xD6D7,	0x7B2B},	// CJK UNIFIED IDEOGRAPH
	{0xD6D8,	0x7B2D},	// CJK UNIFIED IDEOGRAPH
	{0xD6D9,	0x7B2F},	// CJK UNIFIED IDEOGRAPH
	{0xD6DA,	0x7B32},	// CJK UNIFIED IDEOGRAPH
	{0xD6DB,	0x7B38},	// CJK UNIFIED IDEOGRAPH
	{0xD6DC,	0x7B1A},	// CJK UNIFIED IDEOGRAPH
	{0xD6DD,	0x7B23},	// CJK UNIFIED IDEOGRAPH
	{0xD6DE,	0x7C94},	// CJK UNIFIED IDEOGRAPH
	{0xD6DF,	0x7C98},	// CJK UNIFIED IDEOGRAPH
	{0xD6E0,	0x7C96},	// CJK UNIFIED IDEOGRAPH
	{0xD6E1,	0x7CA3},	// CJK UNIFIED IDEOGRAPH
	{0xD6E2,	0x7D35},	// CJK UNIFIED IDEOGRAPH
	{0xD6E3,	0x7D3D},	// CJK UNIFIED IDEOGRAPH
	{0xD6E4,	0x7D38},	// CJK UNIFIED IDEOGRAPH
	{0xD6E5,	0x7D36},	// CJK UNIFIED IDEOGRAPH
	{0xD6E6,	0x7D3A},	// CJK UNIFIED IDEOGRAPH
	{0xD6E7,	0x7D45},	// CJK UNIFIED IDEOGRAPH
	{0xD6E8,	0x7D2C},	// CJK UNIFIED IDEOGRAPH
	{0xD6E9,	0x7D29},	// CJK UNIFIED IDEOGRAPH
	{0xD6EA,	0x7D41},	// CJK UNIFIED IDEOGRAPH
	{0xD6EB,	0x7D47},	// CJK UNIFIED IDEOGRAPH
	{0xD6EC,	0x7D3E},	// CJK UNIFIED IDEOGRAPH
	{0xD6ED,	0x7D3F},	// CJK UNIFIED IDEOGRAPH
	{0xD6EE,	0x7D4A},	// CJK UNIFIED IDEOGRAPH
	{0xD6EF,	0x7D3B},	// CJK UNIFIED IDEOGRAPH
	{0xD6F0,	0x7D28},	// CJK UNIFIED IDEOGRAPH
	{0xD6F1,	0x7F63},	// CJK UNIFIED IDEOGRAPH
	{0xD6F2,	0x7F95},	// CJK UNIFIED IDEOGRAPH
	{0xD6F3,	0x7F9C},	// CJK UNIFIED IDEOGRAPH
	{0xD6F4,	0x7F9D},	// CJK UNIFIED IDEOGRAPH
	{0xD6F5,	0x7F9B},	// CJK UNIFIED IDEOGRAPH
	{0xD6F6,	0x7FCA},	// CJK UNIFIED IDEOGRAPH
	{0xD6F7,	0x7FCB},	// CJK UNIFIED IDEOGRAPH
	{0xD6F8,	0x7FCD},	// CJK UNIFIED IDEOGRAPH
	{0xD6F9,	0x7FD0},	// CJK UNIFIED IDEOGRAPH
	{0xD6FA,	0x7FD1},	// CJK UNIFIED IDEOGRAPH
	{0xD6FB,	0x7FC7},	// CJK UNIFIED IDEOGRAPH
	{0xD6FC,	0x7FCF},	// CJK UNIFIED IDEOGRAPH
	{0xD6FD,	0x7FC9},	// CJK UNIFIED IDEOGRAPH
	{0xD6FE,	0x801F},	// CJK UNIFIED IDEOGRAPH
	{0xD740,	0x801E},	// CJK UNIFIED IDEOGRAPH
	{0xD741,	0x801B},	// CJK UNIFIED IDEOGRAPH
	{0xD742,	0x8047},	// CJK UNIFIED IDEOGRAPH
	{0xD743,	0x8043},	// CJK UNIFIED IDEOGRAPH
	{0xD744,	0x8048},	// CJK UNIFIED IDEOGRAPH
	{0xD745,	0x8118},	// CJK UNIFIED IDEOGRAPH
	{0xD746,	0x8125},	// CJK UNIFIED IDEOGRAPH
	{0xD747,	0x8119},	// CJK UNIFIED IDEOGRAPH
	{0xD748,	0x811B},	// CJK UNIFIED IDEOGRAPH
	{0xD749,	0x812D},	// CJK UNIFIED IDEOGRAPH
	{0xD74A,	0x811F},	// CJK UNIFIED IDEOGRAPH
	{0xD74B,	0x812C},	// CJK UNIFIED IDEOGRAPH
	{0xD74C,	0x811E},	// CJK UNIFIED IDEOGRAPH
	{0xD74D,	0x8121},	// CJK UNIFIED IDEOGRAPH
	{0xD74E,	0x8115},	// CJK UNIFIED IDEOGRAPH
	{0xD74F,	0x8127},	// CJK UNIFIED IDEOGRAPH
	{0xD750,	0x811D},	// CJK UNIFIED IDEOGRAPH
	{0xD751,	0x8122},	// CJK UNIFIED IDEOGRAPH
	{0xD752,	0x8211},	// CJK UNIFIED IDEOGRAPH
	{0xD753,	0x8238},	// CJK UNIFIED IDEOGRAPH
	{0xD754,	0x8233},	// CJK UNIFIED IDEOGRAPH
	{0xD755,	0x823A},	// CJK UNIFIED IDEOGRAPH
	{0xD756,	0x8234},	// CJK UNIFIED IDEOGRAPH
	{0xD757,	0x8232},	// CJK UNIFIED IDEOGRAPH
	{0xD758,	0x8274},	// CJK UNIFIED IDEOGRAPH
	{0xD759,	0x8390},	// CJK UNIFIED IDEOGRAPH
	{0xD75A,	0x83A3},	// CJK UNIFIED IDEOGRAPH
	{0xD75B,	0x83A8},	// CJK UNIFIED IDEOGRAPH
	{0xD75C,	0x838D},	// CJK UNIFIED IDEOGRAPH
	{0xD75D,	0x837A},	// CJK UNIFIED IDEOGRAPH
	{0xD75E,	0x8373},	// CJK UNIFIED IDEOGRAPH
	{0xD75F,	0x83A4},	// CJK UNIFIED IDEOGRAPH
	{0xD760,	0x8374},	// CJK UNIFIED IDEOGRAPH
	{0xD761,	0x838F},	// CJK UNIFIED IDEOGRAPH
	{0xD762,	0x8381},	// CJK UNIFIED IDEOGRAPH
	{0xD763,	0x8395},	// CJK UNIFIED IDEOGRAPH
	{0xD764,	0x8399},	// CJK UNIFIED IDEOGRAPH
	{0xD765,	0x8375},	// CJK UNIFIED IDEOGRAPH
	{0xD766,	0x8394},	// CJK UNIFIED IDEOGRAPH
	{0xD767,	0x83A9},	// CJK UNIFIED IDEOGRAPH
	{0xD768,	0x837D},	// CJK UNIFIED IDEOGRAPH
	{0xD769,	0x8383},	// CJK UNIFIED IDEOGRAPH
	{0xD76A,	0x838C},	// CJK UNIFIED IDEOGRAPH
	{0xD76B,	0x839D},	// CJK UNIFIED IDEOGRAPH
	{0xD76C,	0x839B},	// CJK UNIFIED IDEOGRAPH
	{0xD76D,	0x83AA},	// CJK UNIFIED IDEOGRAPH
	{0xD76E,	0x838B},	// CJK UNIFIED IDEOGRAPH
	{0xD76F,	0x837E},	// CJK UNIFIED IDEOGRAPH
	{0xD770,	0x83A5},	// CJK UNIFIED IDEOGRAPH
	{0xD771,	0x83AF},	// CJK UNIFIED IDEOGRAPH
	{0xD772,	0x8388},	// CJK UNIFIED IDEOGRAPH
	{0xD773,	0x8397},	// CJK UNIFIED IDEOGRAPH
	{0xD774,	0x83B0},	// CJK UNIFIED IDEOGRAPH
	{0xD775,	0x837F},	// CJK UNIFIED IDEOGRAPH
	{0xD776,	0x83A6},	// CJK UNIFIED IDEOGRAPH
	{0xD777,	0x8387},	// CJK UNIFIED IDEOGRAPH
	{0xD778,	0x83AE},	// CJK UNIFIED IDEOGRAPH
	{0xD779,	0x8376},	// CJK UNIFIED IDEOGRAPH
	{0xD77A,	0x839A},	// CJK UNIFIED IDEOGRAPH
	{0xD77B,	0x8659},	// CJK UNIFIED IDEOGRAPH
	{0xD77C,	0x8656},	// CJK UNIFIED IDEOGRAPH
	{0xD77D,	0x86BF},	// CJK UNIFIED IDEOGRAPH
	{0xD77E,	0x86B7},	// CJK UNIFIED IDEOGRAPH
	{0xD7A1,	0x86C2},	// CJK UNIFIED IDEOGRAPH
	{0xD7A2,	0x86C1},	// CJK UNIFIED IDEOGRAPH
	{0xD7A3,	0x86C5},	// CJK UNIFIED IDEOGRAPH
	{0xD7A4,	0x86BA},	// CJK UNIFIED IDEOGRAPH
	{0xD7A5,	0x86B0},	// CJK UNIFIED IDEOGRAPH
	{0xD7A6,	0x86C8},	// CJK UNIFIED IDEOGRAPH
	{0xD7A7,	0x86B9},	// CJK UNIFIED IDEOGRAPH
	{0xD7A8,	0x86B3},	// CJK UNIFIED IDEOGRAPH
	{0xD7A9,	0x86B8},	// CJK UNIFIED IDEOGRAPH
	{0xD7AA,	0x86CC},	// CJK UNIFIED IDEOGRAPH
	{0xD7AB,	0x86B4},	// CJK UNIFIED IDEOGRAPH
	{0xD7AC,	0x86BB},	// CJK UNIFIED IDEOGRAPH
	{0xD7AD,	0x86BC},	// CJK UNIFIED IDEOGRAPH
	{0xD7AE,	0x86C3},	// CJK UNIFIED IDEOGRAPH
	{0xD7AF,	0x86BD},	// CJK UNIFIED IDEOGRAPH
	{0xD7B0,	0x86BE},	// CJK UNIFIED IDEOGRAPH
	{0xD7B1,	0x8852},	// CJK UNIFIED IDEOGRAPH
	{0xD7B2,	0x8889},	// CJK UNIFIED IDEOGRAPH
	{0xD7B3,	0x8895},	// CJK UNIFIED IDEOGRAPH
	{0xD7B4,	0x88A8},	// CJK UNIFIED IDEOGRAPH
	{0xD7B5,	0x88A2},	// CJK UNIFIED IDEOGRAPH
	{0xD7B6,	0x88AA},	// CJK UNIFIED IDEOGRAPH
	{0xD7B7,	0x889A},	// CJK UNIFIED IDEOGRAPH
	{0xD7B8,	0x8891},	// CJK UNIFIED IDEOGRAPH
	{0xD7B9,	0x88A1},	// CJK UNIFIED IDEOGRAPH
	{0xD7BA,	0x889F},	// CJK UNIFIED IDEOGRAPH
	{0xD7BB,	0x8898},	// CJK UNIFIED IDEOGRAPH
	{0xD7BC,	0x88A7},	// CJK UNIFIED IDEOGRAPH
	{0xD7BD,	0x8899},	// CJK UNIFIED IDEOGRAPH
	{0xD7BE,	0x889B},	// CJK UNIFIED IDEOGRAPH
	{0xD7BF,	0x8897},	// CJK UNIFIED IDEOGRAPH
	{0xD7C0,	0x88A4},	// CJK UNIFIED IDEOGRAPH
	{0xD7C1,	0x88AC},	// CJK UNIFIED IDEOGRAPH
	{0xD7C2,	0x888C},	// CJK UNIFIED IDEOGRAPH
	{0xD7C3,	0x8893},	// CJK UNIFIED IDEOGRAPH
	{0xD7C4,	0x888E},	// CJK UNIFIED IDEOGRAPH
	{0xD7C5,	0x8982},	// CJK UNIFIED IDEOGRAPH
	{0xD7C6,	0x89D6},	// CJK UNIFIED IDEOGRAPH
	{0xD7C7,	0x89D9},	// CJK UNIFIED IDEOGRAPH
	{0xD7C8,	0x89D5},	// CJK UNIFIED IDEOGRAPH
	{0xD7C9,	0x8A30},	// CJK UNIFIED IDEOGRAPH
	{0xD7CA,	0x8A27},	// CJK UNIFIED IDEOGRAPH
	{0xD7CB,	0x8A2C},	// CJK UNIFIED IDEOGRAPH
	{0xD7CC,	0x8A1E},	// CJK UNIFIED IDEOGRAPH
	{0xD7CD,	0x8C39},	// CJK UNIFIED IDEOGRAPH
	{0xD7CE,	0x8C3B},	// CJK UNIFIED IDEOGRAPH
	{0xD7CF,	0x8C5C},	// CJK UNIFIED IDEOGRAPH
	{0xD7D0,	0x8C5D},	// CJK UNIFIED IDEOGRAPH
	{0xD7D1,	0x8C7D},	// CJK UNIFIED IDEOGRAPH
	{0xD7D2,	0x8CA5},	// CJK UNIFIED IDEOGRAPH
	{0xD7D3,	0x8D7D},	// CJK UNIFIED IDEOGRAPH
	{0xD7D4,	0x8D7B},	// CJK UNIFIED IDEOGRAPH
	{0xD7D5,	0x8D79},	// CJK UNIFIED IDEOGRAPH
	{0xD7D6,	0x8DBC},	// CJK UNIFIED IDEOGRAPH
	{0xD7D7,	0x8DC2},	// CJK UNIFIED IDEOGRAPH
	{0xD7D8,	0x8DB9},	// CJK UNIFIED IDEOGRAPH
	{0xD7D9,	0x8DBF},	// CJK UNIFIED IDEOGRAPH
	{0xD7DA,	0x8DC1},	// CJK UNIFIED IDEOGRAPH
	{0xD7DB,	0x8ED8},	// CJK UNIFIED IDEOGRAPH
	{0xD7DC,	0x8EDE},	// CJK UNIFIED IDEOGRAPH
	{0xD7DD,	0x8EDD},	// CJK UNIFIED IDEOGRAPH
	{0xD7DE,	0x8EDC},	// CJK UNIFIED IDEOGRAPH
	{0xD7DF,	0x8ED7},	// CJK UNIFIED IDEOGRAPH
	{0xD7E0,	0x8EE0},	// CJK UNIFIED IDEOGRAPH
	{0xD7E1,	0x8EE1},	// CJK UNIFIED IDEOGRAPH
	{0xD7E2,	0x9024},	// CJK UNIFIED IDEOGRAPH
	{0xD7E3,	0x900B},	// CJK UNIFIED IDEOGRAPH
	{0xD7E4,	0x9011},	// CJK UNIFIED IDEOGRAPH
	{0xD7E5,	0x901C},	// CJK UNIFIED IDEOGRAPH
	{0xD7E6,	0x900C},	// CJK UNIFIED IDEOGRAPH
	{0xD7E7,	0x9021},	// CJK UNIFIED IDEOGRAPH
	{0xD7E8,	0x90EF},	// CJK UNIFIED IDEOGRAPH
	{0xD7E9,	0x90EA},	// CJK UNIFIED IDEOGRAPH
	{0xD7EA,	0x90F0},	// CJK UNIFIED IDEOGRAPH
	{0xD7EB,	0x90F4},	// CJK UNIFIED IDEOGRAPH
	{0xD7EC,	0x90F2},	// CJK UNIFIED IDEOGRAPH
	{0xD7ED,	0x90F3},	// CJK UNIFIED IDEOGRAPH
	{0xD7EE,	0x90D4},	// CJK UNIFIED IDEOGRAPH
	{0xD7EF,	0x90EB},	// CJK UNIFIED IDEOGRAPH
	{0xD7F0,	0x90EC},	// CJK UNIFIED IDEOGRAPH
	{0xD7F1,	0x90E9},	// CJK UNIFIED IDEOGRAPH
	{0xD7F2,	0x9156},	// CJK UNIFIED IDEOGRAPH
	{0xD7F3,	0x9158},	// CJK UNIFIED IDEOGRAPH
	{0xD7F4,	0x915A},	// CJK UNIFIED IDEOGRAPH
	{0xD7F5,	0x9153},	// CJK UNIFIED IDEOGRAPH
	{0xD7F6,	0x9155},	// CJK UNIFIED IDEOGRAPH
	{0xD7F7,	0x91EC},	// CJK UNIFIED IDEOGRAPH
	{0xD7F8,	0x91F4},	// CJK UNIFIED IDEOGRAPH
	{0xD7F9,	0x91F1},	// CJK UNIFIED IDEOGRAPH
	{0xD7FA,	0x91F3},	// CJK UNIFIED IDEOGRAPH
	{0xD7FB,	0x91F8},	// CJK UNIFIED IDEOGRAPH
	{0xD7FC,	0x91E4},	// CJK UNIFIED IDEOGRAPH
	{0xD7FD,	0x91F9},	// CJK UNIFIED IDEOGRAPH
	{0xD7FE,	0x91EA},	// CJK UNIFIED IDEOGRAPH
	{0xD840,	0x91EB},	// CJK UNIFIED IDEOGRAPH
	{0xD841,	0x91F7},	// CJK UNIFIED IDEOGRAPH
	{0xD842,	0x91E8},	// CJK UNIFIED IDEOGRAPH
	{0xD843,	0x91EE},	// CJK UNIFIED IDEOGRAPH
	{0xD844,	0x957A},	// CJK UNIFIED IDEOGRAPH
	{0xD845,	0x9586},	// CJK UNIFIED IDEOGRAPH
	{0xD846,	0x9588},	// CJK UNIFIED IDEOGRAPH
	{0xD847,	0x967C},	// CJK UNIFIED IDEOGRAPH
	{0xD848,	0x966D},	// CJK UNIFIED IDEOGRAPH
	{0xD849,	0x966B},	// CJK UNIFIED IDEOGRAPH
	{0xD84A,	0x9671},	// CJK UNIFIED IDEOGRAPH
	{0xD84B,	0x966F},	// CJK UNIFIED IDEOGRAPH
	{0xD84C,	0x96BF},	// CJK UNIFIED IDEOGRAPH
	{0xD84D,	0x976A},	// CJK UNIFIED IDEOGRAPH
	{0xD84E,	0x9804},	// CJK UNIFIED IDEOGRAPH
	{0xD84F,	0x98E5},	// CJK UNIFIED IDEOGRAPH
	{0xD850,	0x9997},	// CJK UNIFIED IDEOGRAPH
	{0xD851,	0x509B},	// CJK UNIFIED IDEOGRAPH
	{0xD852,	0x5095},	// CJK UNIFIED IDEOGRAPH
	{0xD853,	0x5094},	// CJK UNIFIED IDEOGRAPH
	{0xD854,	0x509E},	// CJK UNIFIED IDEOGRAPH
	{0xD855,	0x508B},	// CJK UNIFIED IDEOGRAPH
	{0xD856,	0x50A3},	// CJK UNIFIED IDEOGRAPH
	{0xD857,	0x5083},	// CJK UNIFIED IDEOGRAPH
	{0xD858,	0x508C},	// CJK UNIFIED IDEOGRAPH
	{0xD859,	0x508E},	// CJK UNIFIED IDEOGRAPH
	{0xD85A,	0x509D},	// CJK UNIFIED IDEOGRAPH
	{0xD85B,	0x5068},	// CJK UNIFIED IDEOGRAPH
	{0xD85C,	0x509C},	// CJK UNIFIED IDEOGRAPH
	{0xD85D,	0x5092},	// CJK UNIFIED IDEOGRAPH
	{0xD85E,	0x5082},	// CJK UNIFIED IDEOGRAPH
	{0xD85F,	0x5087},	// CJK UNIFIED IDEOGRAPH
	{0xD860,	0x515F},	// CJK UNIFIED IDEOGRAPH
	{0xD861,	0x51D4},	// CJK UNIFIED IDEOGRAPH
	{0xD862,	0x5312},	// CJK UNIFIED IDEOGRAPH
	{0xD863,	0x5311},	// CJK UNIFIED IDEOGRAPH
	{0xD864,	0x53A4},	// CJK UNIFIED IDEOGRAPH
	{0xD865,	0x53A7},	// CJK UNIFIED IDEOGRAPH
	{0xD866,	0x5591},	// CJK UNIFIED IDEOGRAPH
	{0xD867,	0x55A8},	// CJK UNIFIED IDEOGRAPH
	{0xD868,	0x55A5},	// CJK UNIFIED IDEOGRAPH
	{0xD869,	0x55AD},	// CJK UNIFIED IDEOGRAPH
	{0xD86A,	0x5577},	// CJK UNIFIED IDEOGRAPH
	{0xD86B,	0x5645},	// CJK UNIFIED IDEOGRAPH
	{0xD86C,	0x55A2},	// CJK UNIFIED IDEOGRAPH
	{0xD86D,	0x5593},	// CJK UNIFIED IDEOGRAPH
	{0xD86E,	0x5588},	// CJK UNIFIED IDEOGRAPH
	{0xD86F,	0x558F},	// CJK UNIFIED IDEOGRAPH
	{0xD870,	0x55B5},	// CJK UNIFIED IDEOGRAPH
	{0xD871,	0x5581},	// CJK UNIFIED IDEOGRAPH
	{0xD872,	0x55A3},	// CJK UNIFIED IDEOGRAPH
	{0xD873,	0x5592},	// CJK UNIFIED IDEOGRAPH
	{0xD874,	0x55A4},	// CJK UNIFIED IDEOGRAPH
	{0xD875,	0x557D},	// CJK UNIFIED IDEOGRAPH
	{0xD876,	0x558C},	// CJK UNIFIED IDEOGRAPH
	{0xD877,	0x55A6},	// CJK UNIFIED IDEOGRAPH
	{0xD878,	0x557F},	// CJK UNIFIED IDEOGRAPH
	{0xD879,	0x5595},	// CJK UNIFIED IDEOGRAPH
	{0xD87A,	0x55A1},	// CJK UNIFIED IDEOGRAPH
	{0xD87B,	0x558E},	// CJK UNIFIED IDEOGRAPH
	{0xD87C,	0x570C},	// CJK UNIFIED IDEOGRAPH
	{0xD87D,	0x5829},	// CJK UNIFIED IDEOGRAPH
	{0xD87E,	0x5837},	// CJK UNIFIED IDEOGRAPH
	{0xD8A1,	0x5819},	// CJK UNIFIED IDEOGRAPH
	{0xD8A2,	0x581E},	// CJK UNIFIED IDEOGRAPH
	{0xD8A3,	0x5827},	// CJK UNIFIED IDEOGRAPH
	{0xD8A4,	0x5823},	// CJK UNIFIED IDEOGRAPH
	{0xD8A5,	0x5828},	// CJK UNIFIED IDEOGRAPH
	{0xD8A6,	0x57F5},	// CJK UNIFIED IDEOGRAPH
	{0xD8A7,	0x5848},	// CJK UNIFIED IDEOGRAPH
	{0xD8A8,	0x5825},	// CJK UNIFIED IDEOGRAPH
	{0xD8A9,	0x581C},	// CJK UNIFIED IDEOGRAPH
	{0xD8AA,	0x581B},	// CJK UNIFIED IDEOGRAPH
	{0xD8AB,	0x5833},	// CJK UNIFIED IDEOGRAPH
	{0xD8AC,	0x583F},	// CJK UNIFIED IDEOGRAPH
	{0xD8AD,	0x5836},	// CJK UNIFIED IDEOGRAPH
	{0xD8AE,	0x582E},	// CJK UNIFIED IDEOGRAPH
	{0xD8AF,	0x5839},	// CJK UNIFIED IDEOGRAPH
	{0xD8B0,	0x5838},	// CJK UNIFIED IDEOGRAPH
	{0xD8B1,	0x582D},	// CJK UNIFIED IDEOGRAPH
	{0xD8B2,	0x582C},	// CJK UNIFIED IDEOGRAPH
	{0xD8B3,	0x583B},	// CJK UNIFIED IDEOGRAPH
	{0xD8B4,	0x5961},	// CJK UNIFIED IDEOGRAPH
	{0xD8B5,	0x5AAF},	// CJK UNIFIED IDEOGRAPH
	{0xD8B6,	0x5A94},	// CJK UNIFIED IDEOGRAPH
	{0xD8B7,	0x5A9F},	// CJK UNIFIED IDEOGRAPH
	{0xD8B8,	0x5A7A},	// CJK UNIFIED IDEOGRAPH
	{0xD8B9,	0x5AA2},	// CJK UNIFIED IDEOGRAPH
	{0xD8BA,	0x5A9E},	// CJK UNIFIED IDEOGRAPH
	{0xD8BB,	0x5A78},	// CJK UNIFIED IDEOGRAPH
	{0xD8BC,	0x5AA6},	// CJK UNIFIED IDEOGRAPH
	{0xD8BD,	0x5A7C},	// CJK UNIFIED IDEOGRAPH
	{0xD8BE,	0x5AA5},	// CJK UNIFIED IDEOGRAPH
	{0xD8BF,	0x5AAC},	// CJK UNIFIED IDEOGRAPH
	{0xD8C0,	0x5A95},	// CJK UNIFIED IDEOGRAPH
	{0xD8C1,	0x5AAE},	// CJK UNIFIED IDEOGRAPH
	{0xD8C2,	0x5A37},	// CJK UNIFIED IDEOGRAPH
	{0xD8C3,	0x5A84},	// CJK UNIFIED IDEOGRAPH
	{0xD8C4,	0x5A8A},	// CJK UNIFIED IDEOGRAPH
	{0xD8C5,	0x5A97},	// CJK UNIFIED IDEOGRAPH
	{0xD8C6,	0x5A83},	// CJK UNIFIED IDEOGRAPH
	{0xD8C7,	0x5A8B},	// CJK UNIFIED IDEOGRAPH
	{0xD8C8,	0x5AA9},	// CJK UNIFIED IDEOGRAPH
	{0xD8C9,	0x5A7B},	// CJK UNIFIED IDEOGRAPH
	{0xD8CA,	0x5A7D},	// CJK UNIFIED IDEOGRAPH
	{0xD8CB,	0x5A8C},	// CJK UNIFIED IDEOGRAPH
	{0xD8CC,	0x5A9C},	// CJK UNIFIED IDEOGRAPH
	{0xD8CD,	0x5A8F},	// CJK UNIFIED IDEOGRAPH
	{0xD8CE,	0x5A93},	// CJK UNIFIED IDEOGRAPH
	{0xD8CF,	0x5A9D},	// CJK UNIFIED IDEOGRAPH
	{0xD8D0,	0x5BEA},	// CJK UNIFIED IDEOGRAPH
	{0xD8D1,	0x5BCD},	// CJK UNIFIED IDEOGRAPH
	{0xD8D2,	0x5BCB},	// CJK UNIFIED IDEOGRAPH
	{0xD8D3,	0x5BD4},	// CJK UNIFIED IDEOGRAPH
	{0xD8D4,	0x5BD1},	// CJK UNIFIED IDEOGRAPH
	{0xD8D5,	0x5BCA},	// CJK UNIFIED IDEOGRAPH
	{0xD8D6,	0x5BCE},	// CJK UNIFIED IDEOGRAPH
	{0xD8D7,	0x5C0C},	// CJK UNIFIED IDEOGRAPH
	{0xD8D8,	0x5C30},	// CJK UNIFIED IDEOGRAPH
	{0xD8D9,	0x5D37},	// CJK UNIFIED IDEOGRAPH
	{0xD8DA,	0x5D43},	// CJK UNIFIED IDEOGRAPH
	{0xD8DB,	0x5D6B},	// CJK UNIFIED IDEOGRAPH
	{0xD8DC,	0x5D41},	// CJK UNIFIED IDEOGRAPH
	{0xD8DD,	0x5D4B},	// CJK UNIFIED IDEOGRAPH
	{0xD8DE,	0x5D3F},	// CJK UNIFIED IDEOGRAPH
	{0xD8DF,	0x5D35},	// CJK UNIFIED IDEOGRAPH
	{0xD8E0,	0x5D51},	// CJK UNIFIED IDEOGRAPH
	{0xD8E1,	0x5D4E},	// CJK UNIFIED IDEOGRAPH
	{0xD8E2,	0x5D55},	// CJK UNIFIED IDEOGRAPH
	{0xD8E3,	0x5D33},	// CJK UNIFIED IDEOGRAPH
	{0xD8E4,	0x5D3A},	// CJK UNIFIED IDEOGRAPH
	{0xD8E5,	0x5D52},	// CJK UNIFIED IDEOGRAPH
	{0xD8E6,	0x5D3D},	// CJK UNIFIED IDEOGRAPH
	{0xD8E7,	0x5D31},	// CJK UNIFIED IDEOGRAPH
	{0xD8E8,	0x5D59},	// CJK UNIFIED IDEOGRAPH
	{0xD8E9,	0x5D42},	// CJK UNIFIED IDEOGRAPH
	{0xD8EA,	0x5D39},	// CJK UNIFIED IDEOGRAPH
	{0xD8EB,	0x5D49},	// CJK UNIFIED IDEOGRAPH
	{0xD8EC,	0x5D38},	// CJK UNIFIED IDEOGRAPH
	{0xD8ED,	0x5D3C},	// CJK UNIFIED IDEOGRAPH
	{0xD8EE,	0x5D32},	// CJK UNIFIED IDEOGRAPH
	{0xD8EF,	0x5D36},	// CJK UNIFIED IDEOGRAPH
	{0xD8F0,	0x5D40},	// CJK UNIFIED IDEOGRAPH
	{0xD8F1,	0x5D45},	// CJK UNIFIED IDEOGRAPH
	{0xD8F2,	0x5E44},	// CJK UNIFIED IDEOGRAPH
	{0xD8F3,	0x5E41},	// CJK UNIFIED IDEOGRAPH
	{0xD8F4,	0x5F58},	// CJK UNIFIED IDEOGRAPH
	{0xD8F5,	0x5FA6},	// CJK UNIFIED IDEOGRAPH
	{0xD8F6,	0x5FA5},	// CJK UNIFIED IDEOGRAPH
	{0xD8F7,	0x5FAB},	// CJK UNIFIED IDEOGRAPH
	{0xD8F8,	0x60C9},	// CJK UNIFIED IDEOGRAPH
	{0xD8F9,	0x60B9},	// CJK UNIFIED IDEOGRAPH
	{0xD8FA,	0x60CC},	// CJK UNIFIED IDEOGRAPH
	{0xD8FB,	0x60E2},	// CJK UNIFIED IDEOGRAPH
	{0xD8FC,	0x60CE},	// CJK UNIFIED IDEOGRAPH
	{0xD8FD,	0x60C4},	// CJK UNIFIED IDEOGRAPH
	{0xD8FE,	0x6114},	// CJK UNIFIED IDEOGRAPH
	{0xD940,	0x60F2},	// CJK UNIFIED IDEOGRAPH
	{0xD941,	0x610A},	// CJK UNIFIED IDEOGRAPH
	{0xD942,	0x6116},	// CJK UNIFIED IDEOGRAPH
	{0xD943,	0x6105},	// CJK UNIFIED IDEOGRAPH
	{0xD944,	0x60F5},	// CJK UNIFIED IDEOGRAPH
	{0xD945,	0x6113},	// CJK UNIFIED IDEOGRAPH
	{0xD946,	0x60F8},	// CJK UNIFIED IDEOGRAPH
	{0xD947,	0x60FC},	// CJK UNIFIED IDEOGRAPH
	{0xD948,	0x60FE},	// CJK UNIFIED IDEOGRAPH
	{0xD949,	0x60C1},	// CJK UNIFIED IDEOGRAPH
	{0xD94A,	0x6103},	// CJK UNIFIED IDEOGRAPH
	{0xD94B,	0x6118},	// CJK UNIFIED IDEOGRAPH
	{0xD94C,	0x611D},	// CJK UNIFIED IDEOGRAPH
	{0xD94D,	0x6110},	// CJK UNIFIED IDEOGRAPH
	{0xD94E,	0x60FF},	// CJK UNIFIED IDEOGRAPH
	{0xD94F,	0x6104},	// CJK UNIFIED IDEOGRAPH
	{0xD950,	0x610B},	// CJK UNIFIED IDEOGRAPH
	{0xD951,	0x624A},	// CJK UNIFIED IDEOGRAPH
	{0xD952,	0x6394},	// CJK UNIFIED IDEOGRAPH
	{0xD953,	0x63B1},	// CJK UNIFIED IDEOGRAPH
	{0xD954,	0x63B0},	// CJK UNIFIED IDEOGRAPH
	{0xD955,	0x63CE},	// CJK UNIFIED IDEOGRAPH
	{0xD956,	0x63E5},	// CJK UNIFIED IDEOGRAPH
	{0xD957,	0x63E8},	// CJK UNIFIED IDEOGRAPH
	{0xD958,	0x63EF},	// CJK UNIFIED IDEOGRAPH
	{0xD959,	0x63C3},	// CJK UNIFIED IDEOGRAPH
	{0xD95A,	0x649D},	// CJK UNIFIED IDEOGRAPH
	{0xD95B,	0x63F3},	// CJK UNIFIED IDEOGRAPH
	{0xD95C,	0x63CA},	// CJK UNIFIED IDEOGRAPH
	{0xD95D,	0x63E0},	// CJK UNIFIED IDEOGRAPH
	{0xD95E,	0x63F6},	// CJK UNIFIED IDEOGRAPH
	{0xD95F,	0x63D5},	// CJK UNIFIED IDEOGRAPH
	{0xD960,	0x63F2},	// CJK UNIFIED IDEOGRAPH
	{0xD961,	0x63F5},	// CJK UNIFIED IDEOGRAPH
	{0xD962,	0x6461},	// CJK UNIFIED IDEOGRAPH
	{0xD963,	0x63DF},	// CJK UNIFIED IDEOGRAPH
	{0xD964,	0x63BE},	// CJK UNIFIED IDEOGRAPH
	{0xD965,	0x63DD},	// CJK UNIFIED IDEOGRAPH
	{0xD966,	0x63DC},	// CJK UNIFIED IDEOGRAPH
	{0xD967,	0x63C4},	// CJK UNIFIED IDEOGRAPH
	{0xD968,	0x63D8},	// CJK UNIFIED IDEOGRAPH
	{0xD969,	0x63D3},	// CJK UNIFIED IDEOGRAPH
	{0xD96A,	0x63C2},	// CJK UNIFIED IDEOGRAPH
	{0xD96B,	0x63C7},	// CJK UNIFIED IDEOGRAPH
	{0xD96C,	0x63CC},	// CJK UNIFIED IDEOGRAPH
	{0xD96D,	0x63CB},	// CJK UNIFIED IDEOGRAPH
	{0xD96E,	0x63C8},	// CJK UNIFIED IDEOGRAPH
	{0xD96F,	0x63F0},	// CJK UNIFIED IDEOGRAPH
	{0xD970,	0x63D7},	// CJK UNIFIED IDEOGRAPH
	{0xD971,	0x63D9},	// CJK UNIFIED IDEOGRAPH
	{0xD972,	0x6532},	// CJK UNIFIED IDEOGRAPH
	{0xD973,	0x6567},	// CJK UNIFIED IDEOGRAPH
	{0xD974,	0x656A},	// CJK UNIFIED IDEOGRAPH
	{0xD975,	0x6564},	// CJK UNIFIED IDEOGRAPH
	{0xD976,	0x655C},	// CJK UNIFIED IDEOGRAPH
	{0xD977,	0x6568},	// CJK UNIFIED IDEOGRAPH
	{0xD978,	0x6565},	// CJK UNIFIED IDEOGRAPH
	{0xD979,	0x658C},	// CJK UNIFIED IDEOGRAPH
	{0xD97A,	0x659D},	// CJK UNIFIED IDEOGRAPH
	{0xD97B,	0x659E},	// CJK UNIFIED IDEOGRAPH
	{0xD97C,	0x65AE},	// CJK UNIFIED IDEOGRAPH
	{0xD97D,	0x65D0},	// CJK UNIFIED IDEOGRAPH
	{0xD97E,	0x65D2},	// CJK UNIFIED IDEOGRAPH
	{0xD9A1,	0x667C},	// CJK UNIFIED IDEOGRAPH
	{0xD9A2,	0x666C},	// CJK UNIFIED IDEOGRAPH
	{0xD9A3,	0x667B},	// CJK UNIFIED IDEOGRAPH
	{0xD9A4,	0x6680},	// CJK UNIFIED IDEOGRAPH
	{0xD9A5,	0x6671},	// CJK UNIFIED IDEOGRAPH
	{0xD9A6,	0x6679},	// CJK UNIFIED IDEOGRAPH
	{0xD9A7,	0x666A},	// CJK UNIFIED IDEOGRAPH
	{0xD9A8,	0x6672},	// CJK UNIFIED IDEOGRAPH
	{0xD9A9,	0x6701},	// CJK UNIFIED IDEOGRAPH
	{0xD9AA,	0x690C},	// CJK UNIFIED IDEOGRAPH
	{0xD9AB,	0x68D3},	// CJK UNIFIED IDEOGRAPH
	{0xD9AC,	0x6904},	// CJK UNIFIED IDEOGRAPH
	{0xD9AD,	0x68DC},	// CJK UNIFIED IDEOGRAPH
	{0xD9AE,	0x692A},	// CJK UNIFIED IDEOGRAPH
	{0xD9AF,	0x68EC},	// CJK UNIFIED IDEOGRAPH
	{0xD9B0,	0x68EA},	// CJK UNIFIED IDEOGRAPH
	{0xD9B1,	0x68F1},	// CJK UNIFIED IDEOGRAPH
	{0xD9B2,	0x690F},	// CJK UNIFIED IDEOGRAPH
	{0xD9B3,	0x68D6},	// CJK UNIFIED IDEOGRAPH
	{0xD9B4,	0x68F7},	// CJK UNIFIED IDEOGRAPH
	{0xD9B5,	0x68EB},	// CJK UNIFIED IDEOGRAPH
	{0xD9B6,	0x68E4},	// CJK UNIFIED IDEOGRAPH
	{0xD9B7,	0x68F6},	// CJK UNIFIED IDEOGRAPH
	{0xD9B8,	0x6913},	// CJK UNIFIED IDEOGRAPH
	{0xD9B9,	0x6910},	// CJK UNIFIED IDEOGRAPH
	{0xD9BA,	0x68F3},	// CJK UNIFIED IDEOGRAPH
	{0xD9BB,	0x68E1},	// CJK UNIFIED IDEOGRAPH
	{0xD9BC,	0x6907},	// CJK UNIFIED IDEOGRAPH
	{0xD9BD,	0x68CC},	// CJK UNIFIED IDEOGRAPH
	{0xD9BE,	0x6908},	// CJK UNIFIED IDEOGRAPH
	{0xD9BF,	0x6970},	// CJK UNIFIED IDEOGRAPH
	{0xD9C0,	0x68B4},	// CJK UNIFIED IDEOGRAPH
	{0xD9C1,	0x6911},	// CJK UNIFIED IDEOGRAPH
	{0xD9C2,	0x68EF},	// CJK UNIFIED IDEOGRAPH
	{0xD9C3,	0x68C6},	// CJK UNIFIED IDEOGRAPH
	{0xD9C4,	0x6914},	// CJK UNIFIED IDEOGRAPH
	{0xD9C5,	0x68F8},	// CJK UNIFIED IDEOGRAPH
	{0xD9C6,	0x68D0},	// CJK UNIFIED IDEOGRAPH
	{0xD9C7,	0x68FD},	// CJK UNIFIED IDEOGRAPH
	{0xD9C8,	0x68FC},	// CJK UNIFIED IDEOGRAPH
	{0xD9C9,	0x68E8},	// CJK UNIFIED IDEOGRAPH
	{0xD9CA,	0x690B},	// CJK UNIFIED IDEOGRAPH
	{0xD9CB,	0x690A},	// CJK UNIFIED IDEOGRAPH
	{0xD9CC,	0x6917},	// CJK UNIFIED IDEOGRAPH
	{0xD9CD,	0x68CE},	// CJK UNIFIED IDEOGRAPH
	{0xD9CE,	0x68C8},	// CJK UNIFIED IDEOGRAPH
	{0xD9CF,	0x68DD},	// CJK UNIFIED IDEOGRAPH
	{0xD9D0,	0x68DE},	// CJK UNIFIED IDEOGRAPH
	{0xD9D1,	0x68E6},	// CJK UNIFIED IDEOGRAPH
	{0xD9D2,	0x68F4},	// CJK UNIFIED IDEOGRAPH
	{0xD9D3,	0x68D1},	// CJK UNIFIED IDEOGRAPH
	{0xD9D4,	0x6906},	// CJK UNIFIED IDEOGRAPH
	{0xD9D5,	0x68D4},	// CJK UNIFIED IDEOGRAPH
	{0xD9D6,	0x68E9},	// CJK UNIFIED IDEOGRAPH
	{0xD9D7,	0x6915},	// CJK UNIFIED IDEOGRAPH
	{0xD9D8,	0x6925},	// CJK UNIFIED IDEOGRAPH
	{0xD9D9,	0x68C7},	// CJK UNIFIED IDEOGRAPH
	{0xD9DA,	0x6B39},	// CJK UNIFIED IDEOGRAPH
	{0xD9DB,	0x6B3B},	// CJK UNIFIED IDEOGRAPH
	{0xD9DC,	0x6B3F},	// CJK UNIFIED IDEOGRAPH
	{0xD9DD,	0x6B3C},	// CJK UNIFIED IDEOGRAPH
	{0xD9DE,	0x6B94},	// CJK UNIFIED IDEOGRAPH
	{0xD9DF,	0x6B97},	// CJK UNIFIED IDEOGRAPH
	{0xD9E0,	0x6B99},	// CJK UNIFIED IDEOGRAPH
	{0xD9E1,	0x6B95},	// CJK UNIFIED IDEOGRAPH
	{0xD9E2,	0x6BBD},	// CJK UNIFIED IDEOGRAPH
	{0xD9E3,	0x6BF0},	// CJK UNIFIED IDEOGRAPH
	{0xD9E4,	0x6BF2},	// CJK UNIFIED IDEOGRAPH
	{0xD9E5,	0x6BF3},	// CJK UNIFIED IDEOGRAPH
	{0xD9E6,	0x6C30},	// CJK UNIFIED IDEOGRAPH
	{0xD9E7,	0x6DFC},	// CJK UNIFIED IDEOGRAPH
	{0xD9E8,	0x6E46},	// CJK UNIFIED IDEOGRAPH
	{0xD9E9,	0x6E47},	// CJK UNIFIED IDEOGRAPH
	{0xD9EA,	0x6E1F},	// CJK UNIFIED IDEOGRAPH
	{0xD9EB,	0x6E49},	// CJK UNIFIED IDEOGRAPH
	{0xD9EC,	0x6E88},	// CJK UNIFIED IDEOGRAPH
	{0xD9ED,	0x6E3C},	// CJK UNIFIED IDEOGRAPH
	{0xD9EE,	0x6E3D},	// CJK UNIFIED IDEOGRAPH
	{0xD9EF,	0x6E45},	// CJK UNIFIED IDEOGRAPH
	{0xD9F0,	0x6E62},	// CJK UNIFIED IDEOGRAPH
	{0xD9F1,	0x6E2B},	// CJK UNIFIED IDEOGRAPH
	{0xD9F2,	0x6E3F},	// CJK UNIFIED IDEOGRAPH
	{0xD9F3,	0x6E41},	// CJK UNIFIED IDEOGRAPH
	{0xD9F4,	0x6E5D},	// CJK UNIFIED IDEOGRAPH
	{0xD9F5,	0x6E73},	// CJK UNIFIED IDEOGRAPH
	{0xD9F6,	0x6E1C},	// CJK UNIFIED IDEOGRAPH
	{0xD9F7,	0x6E33},	// CJK UNIFIED IDEOGRAPH
	{0xD9F8,	0x6E4B},	// CJK UNIFIED IDEOGRAPH
	{0xD9F9,	0x6E40},	// CJK UNIFIED IDEOGRAPH
	{0xD9FA,	0x6E51},	// CJK UNIFIED IDEOGRAPH
	{0xD9FB,	0x6E3B},	// CJK UNIFIED IDEOGRAPH
	{0xD9FC,	0x6E03},	// CJK UNIFIED IDEOGRAPH
	{0xD9FD,	0x6E2E},	// CJK UNIFIED IDEOGRAPH
	{0xD9FE,	0x6E5E},	// CJK UNIFIED IDEOGRAPH
	{0xDA40,	0x6E68},	// CJK UNIFIED IDEOGRAPH
	{0xDA41,	0x6E5C},	// CJK UNIFIED IDEOGRAPH
	{0xDA42,	0x6E61},	// CJK UNIFIED IDEOGRAPH
	{0xDA43,	0x6E31},	// CJK UNIFIED IDEOGRAPH
	{0xDA44,	0x6E28},	// CJK UNIFIED IDEOGRAPH
	{0xDA45,	0x6E60},	// CJK UNIFIED IDEOGRAPH
	{0xDA46,	0x6E71},	// CJK UNIFIED IDEOGRAPH
	{0xDA47,	0x6E6B},	// CJK UNIFIED IDEOGRAPH
	{0xDA48,	0x6E39},	// CJK UNIFIED IDEOGRAPH
	{0xDA49,	0x6E22},	// CJK UNIFIED IDEOGRAPH
	{0xDA4A,	0x6E30},	// CJK UNIFIED IDEOGRAPH
	{0xDA4B,	0x6E53},	// CJK UNIFIED IDEOGRAPH
	{0xDA4C,	0x6E65},	// CJK UNIFIED IDEOGRAPH
	{0xDA4D,	0x6E27},	// CJK UNIFIED IDEOGRAPH
	{0xDA4E,	0x6E78},	// CJK UNIFIED IDEOGRAPH
	{0xDA4F,	0x6E64},	// CJK UNIFIED IDEOGRAPH
	{0xDA50,	0x6E77},	// CJK UNIFIED IDEOGRAPH
	{0xDA51,	0x6E55},	// CJK UNIFIED IDEOGRAPH
	{0xDA52,	0x6E79},	// CJK UNIFIED IDEOGRAPH
	{0xDA53,	0x6E52},	// CJK UNIFIED IDEOGRAPH
	{0xDA54,	0x6E66},	// CJK UNIFIED IDEOGRAPH
	{0xDA55,	0x6E35},	// CJK UNIFIED IDEOGRAPH
	{0xDA56,	0x6E36},	// CJK UNIFIED IDEOGRAPH
	{0xDA57,	0x6E5A},	// CJK UNIFIED IDEOGRAPH
	{0xDA58,	0x7120},	// CJK UNIFIED IDEOGRAPH
	{0xDA59,	0x711E},	// CJK UNIFIED IDEOGRAPH
	{0xDA5A,	0x712F},	// CJK UNIFIED IDEOGRAPH
	{0xDA5B,	0x70FB},	// CJK UNIFIED IDEOGRAPH
	{0xDA5C,	0x712E},	// CJK UNIFIED IDEOGRAPH
	{0xDA5D,	0x7131},	// CJK UNIFIED IDEOGRAPH
	{0xDA5E,	0x7123},	// CJK UNIFIED IDEOGRAPH
	{0xDA5F,	0x7125},	// CJK UNIFIED IDEOGRAPH
	{0xDA60,	0x7122},	// CJK UNIFIED IDEOGRAPH
	{0xDA61,	0x7132},	// CJK UNIFIED IDEOGRAPH
	{0xDA62,	0x711F},	// CJK UNIFIED IDEOGRAPH
	{0xDA63,	0x7128},	// CJK UNIFIED IDEOGRAPH
	{0xDA64,	0x713A},	// CJK UNIFIED IDEOGRAPH
	{0xDA65,	0x711B},	// CJK UNIFIED IDEOGRAPH
	{0xDA66,	0x724B},	// CJK UNIFIED IDEOGRAPH
	{0xDA67,	0x725A},	// CJK UNIFIED IDEOGRAPH
	{0xDA68,	0x7288},	// CJK UNIFIED IDEOGRAPH
	{0xDA69,	0x7289},	// CJK UNIFIED IDEOGRAPH
	{0xDA6A,	0x7286},	// CJK UNIFIED IDEOGRAPH
	{0xDA6B,	0x7285},	// CJK UNIFIED IDEOGRAPH
	{0xDA6C,	0x728B},	// CJK UNIFIED IDEOGRAPH
	{0xDA6D,	0x7312},	// CJK UNIFIED IDEOGRAPH
	{0xDA6E,	0x730B},	// CJK UNIFIED IDEOGRAPH
	{0xDA6F,	0x7330},	// CJK UNIFIED IDEOGRAPH
	{0xDA70,	0x7322},	// CJK UNIFIED IDEOGRAPH
	{0xDA71,	0x7331},	// CJK UNIFIED IDEOGRAPH
	{0xDA72,	0x7333},	// CJK UNIFIED IDEOGRAPH
	{0xDA73,	0x7327},	// CJK UNIFIED IDEOGRAPH
	{0xDA74,	0x7332},	// CJK UNIFIED IDEOGRAPH
	{0xDA75,	0x732D},	// CJK UNIFIED IDEOGRAPH
	{0xDA76,	0x7326},	// CJK UNIFIED IDEOGRAPH
	{0xDA77,	0x7323},	// CJK UNIFIED IDEOGRAPH
	{0xDA78,	0x7335},	// CJK UNIFIED IDEOGRAPH
	{0xDA79,	0x730C},	// CJK UNIFIED IDEOGRAPH
	{0xDA7A,	0x742E},	// CJK UNIFIED IDEOGRAPH
	{0xDA7B,	0x742C},	// CJK UNIFIED IDEOGRAPH
	{0xDA7C,	0x7430},	// CJK UNIFIED IDEOGRAPH
	{0xDA7D,	0x742B},	// CJK UNIFIED IDEOGRAPH
	{0xDA7E,	0x7416},	// CJK UNIFIED IDEOGRAPH
	{0xDAA1,	0x741A},	// CJK UNIFIED IDEOGRAPH
	{0xDAA2,	0x7421},	// CJK UNIFIED IDEOGRAPH
	{0xDAA3,	0x742D},	// CJK UNIFIED IDEOGRAPH
	{0xDAA4,	0x7431},	// CJK UNIFIED IDEOGRAPH
	{0xDAA5,	0x7424},	// CJK UNIFIED IDEOGRAPH
	{0xDAA6,	0x7423},	// CJK UNIFIED IDEOGRAPH
	{0xDAA7,	0x741D},	// CJK UNIFIED IDEOGRAPH
	{0xDAA8,	0x7429},	// CJK UNIFIED IDEOGRAPH
	{0xDAA9,	0x7420},	// CJK UNIFIED IDEOGRAPH
	{0xDAAA,	0x7432},	// CJK UNIFIED IDEOGRAPH
	{0xDAAB,	0x74FB},	// CJK UNIFIED IDEOGRAPH
	{0xDAAC,	0x752F},	// CJK UNIFIED IDEOGRAPH
	{0xDAAD,	0x756F},	// CJK UNIFIED IDEOGRAPH
	{0xDAAE,	0x756C},	// CJK UNIFIED IDEOGRAPH
	{0xDAAF,	0x75E7},	// CJK UNIFIED IDEOGRAPH
	{0xDAB0,	0x75DA},	// CJK UNIFIED IDEOGRAPH
	{0xDAB1,	0x75E1},	// CJK UNIFIED IDEOGRAPH
	{0xDAB2,	0x75E6},	// CJK UNIFIED IDEOGRAPH
	{0xDAB3,	0x75DD},	// CJK UNIFIED IDEOGRAPH
	{0xDAB4,	0x75DF},	// CJK UNIFIED IDEOGRAPH
	{0xDAB5,	0x75E4},	// CJK UNIFIED IDEOGRAPH
	{0xDAB6,	0x75D7},	// CJK UNIFIED IDEOGRAPH
	{0xDAB7,	0x7695},	// CJK UNIFIED IDEOGRAPH
	{0xDAB8,	0x7692},	// CJK UNIFIED IDEOGRAPH
	{0xDAB9,	0x76DA},	// CJK UNIFIED IDEOGRAPH
	{0xDABA,	0x7746},	// CJK UNIFIED IDEOGRAPH
	{0xDABB,	0x7747},	// CJK UNIFIED IDEOGRAPH
	{0xDABC,	0x7744},	// CJK UNIFIED IDEOGRAPH
	{0xDABD,	0x774D},	// CJK UNIFIED IDEOGRAPH
	{0xDABE,	0x7745},	// CJK UNIFIED IDEOGRAPH
	{0xDABF,	0x774A},	// CJK UNIFIED IDEOGRAPH
	{0xDAC0,	0x774E},	// CJK UNIFIED IDEOGRAPH
	{0xDAC1,	0x774B},	// CJK UNIFIED IDEOGRAPH
	{0xDAC2,	0x774C},	// CJK UNIFIED IDEOGRAPH
	{0xDAC3,	0x77DE},	// CJK UNIFIED IDEOGRAPH
	{0xDAC4,	0x77EC},	// CJK UNIFIED IDEOGRAPH
	{0xDAC5,	0x7860},	// CJK UNIFIED IDEOGRAPH
	{0xDAC6,	0x7864},	// CJK UNIFIED IDEOGRAPH
	{0xDAC7,	0x7865},	// CJK UNIFIED IDEOGRAPH
	{0xDAC8,	0x785C},	// CJK UNIFIED IDEOGRAPH
	{0xDAC9,	0x786D},	// CJK UNIFIED IDEOGRAPH
	{0xDACA,	0x7871},	// CJK UNIFIED IDEOGRAPH
	{0xDACB,	0x786A},	// CJK UNIFIED IDEOGRAPH
	{0xDACC,	0x786E},	// CJK UNIFIED IDEOGRAPH
	{0xDACD,	0x7870},	// CJK UNIFIED IDEOGRAPH
	{0xDACE,	0x7869},	// CJK UNIFIED IDEOGRAPH
	{0xDACF,	0x7868},	// CJK UNIFIED IDEOGRAPH
	{0xDAD0,	0x785E},	// CJK UNIFIED IDEOGRAPH
	{0xDAD1,	0x7862},	// CJK UNIFIED IDEOGRAPH
	{0xDAD2,	0x7974},	// CJK UNIFIED IDEOGRAPH
	{0xDAD3,	0x7973},	// CJK UNIFIED IDEOGRAPH
	{0xDAD4,	0x7972},	// CJK UNIFIED IDEOGRAPH
	{0xDAD5,	0x7970},	// CJK UNIFIED IDEOGRAPH
	{0xDAD6,	0x7A02},	// CJK UNIFIED IDEOGRAPH
	{0xDAD7,	0x7A0A},	// CJK UNIFIED IDEOGRAPH
	{0xDAD8,	0x7A03},	// CJK UNIFIED IDEOGRAPH
	{0xDAD9,	0x7A0C},	// CJK UNIFIED IDEOGRAPH
	{0xDADA,	0x7A04},	// CJK UNIFIED IDEOGRAPH
	{0xDADB,	0x7A99},	// CJK UNIFIED IDEOGRAPH
	{0xDADC,	0x7AE6},	// CJK UNIFIED IDEOGRAPH
	{0xDADD,	0x7AE4},	// CJK UNIFIED IDEOGRAPH
	{0xDADE,	0x7B4A},	// CJK UNIFIED IDEOGRAPH
	{0xDADF,	0x7B3B},	// CJK UNIFIED IDEOGRAPH
	{0xDAE0,	0x7B44},	// CJK UNIFIED IDEOGRAPH
	{0xDAE1,	0x7B48},	// CJK UNIFIED IDEOGRAPH
	{0xDAE2,	0x7B4C},	// CJK UNIFIED IDEOGRAPH
	{0xDAE3,	0x7B4E},	// CJK UNIFIED IDEOGRAPH
	{0xDAE4,	0x7B40},	// CJK UNIFIED IDEOGRAPH
	{0xDAE5,	0x7B58},	// CJK UNIFIED IDEOGRAPH
	{0xDAE6,	0x7B45},	// CJK UNIFIED IDEOGRAPH
	{0xDAE7,	0x7CA2},	// CJK UNIFIED IDEOGRAPH
	{0xDAE8,	0x7C9E},	// CJK UNIFIED IDEOGRAPH
	{0xDAE9,	0x7CA8},	// CJK UNIFIED IDEOGRAPH
	{0xDAEA,	0x7CA1},	// CJK UNIFIED IDEOGRAPH
	{0xDAEB,	0x7D58},	// CJK UNIFIED IDEOGRAPH
	{0xDAEC,	0x7D6F},	// CJK UNIFIED IDEOGRAPH
	{0xDAED,	0x7D63},	// CJK UNIFIED IDEOGRAPH
	{0xDAEE,	0x7D53},	// CJK UNIFIED IDEOGRAPH
	{0xDAEF,	0x7D56},	// CJK UNIFIED IDEOGRAPH
	{0xDAF0,	0x7D67},	// CJK UNIFIED IDEOGRAPH
	{0xDAF1,	0x7D6A},	// CJK UNIFIED IDEOGRAPH
	{0xDAF2,	0x7D4F},	// CJK UNIFIED IDEOGRAPH
	{0xDAF3,	0x7D6D},	// CJK UNIFIED IDEOGRAPH
	{0xDAF4,	0x7D5C},	// CJK UNIFIED IDEOGRAPH
	{0xDAF5,	0x7D6B},	// CJK UNIFIED IDEOGRAPH
	{0xDAF6,	0x7D52},	// CJK UNIFIED IDEOGRAPH
	{0xDAF7,	0x7D54},	// CJK UNIFIED IDEOGRAPH
	{0xDAF8,	0x7D69},	// CJK UNIFIED IDEOGRAPH
	{0xDAF9,	0x7D51},	// CJK UNIFIED IDEOGRAPH
	{0xDAFA,	0x7D5F},	// CJK UNIFIED IDEOGRAPH
	{0xDAFB,	0x7D4E},	// CJK UNIFIED IDEOGRAPH
	{0xDAFC,	0x7F3E},	// CJK UNIFIED IDEOGRAPH
	{0xDAFD,	0x7F3F},	// CJK UNIFIED IDEOGRAPH
	{0xDAFE,	0x7F65},	// CJK UNIFIED IDEOGRAPH
	{0xDB40,	0x7F66},	// CJK UNIFIED IDEOGRAPH
	{0xDB41,	0x7FA2},	// CJK UNIFIED IDEOGRAPH
	{0xDB42,	0x7FA0},	// CJK UNIFIED IDEOGRAPH
	{0xDB43,	0x7FA1},	// CJK UNIFIED IDEOGRAPH
	{0xDB44,	0x7FD7},	// CJK UNIFIED IDEOGRAPH
	{0xDB45,	0x8051},	// CJK UNIFIED IDEOGRAPH
	{0xDB46,	0x804F},	// CJK UNIFIED IDEOGRAPH
	{0xDB47,	0x8050},	// CJK UNIFIED IDEOGRAPH
	{0xDB48,	0x80FE},	// CJK UNIFIED IDEOGRAPH
	{0xDB49,	0x80D4},	// CJK UNIFIED IDEOGRAPH
	{0xDB4A,	0x8143},	// CJK UNIFIED IDEOGRAPH
	{0xDB4B,	0x814A},	// CJK UNIFIED IDEOGRAPH
	{0xDB4C,	0x8152},	// CJK UNIFIED IDEOGRAPH
	{0xDB4D,	0x814F},	// CJK UNIFIED IDEOGRAPH
	{0xDB4E,	0x8147},	// CJK UNIFIED IDEOGRAPH
	{0xDB4F,	0x813D},	// CJK UNIFIED IDEOGRAPH
	{0xDB50,	0x814D},	// CJK UNIFIED IDEOGRAPH
	{0xDB51,	0x813A},	// CJK UNIFIED IDEOGRAPH
	{0xDB52,	0x81E6},	// CJK UNIFIED IDEOGRAPH
	{0xDB53,	0x81EE},	// CJK UNIFIED IDEOGRAPH
	{0xDB54,	0x81F7},	// CJK UNIFIED IDEOGRAPH
	{0xDB55,	0x81F8},	// CJK UNIFIED IDEOGRAPH
	{0xDB56,	0x81F9},	// CJK UNIFIED IDEOGRAPH
	{0xDB57,	0x8204},	// CJK UNIFIED IDEOGRAPH
	{0xDB58,	0x823C},	// CJK UNIFIED IDEOGRAPH
	{0xDB59,	0x823D},	// CJK UNIFIED IDEOGRAPH
	{0xDB5A,	0x823F},	// CJK UNIFIED IDEOGRAPH
	{0xDB5B,	0x8275},	// CJK UNIFIED IDEOGRAPH
	{0xDB5C,	0x833B},	// CJK UNIFIED IDEOGRAPH
	{0xDB5D,	0x83CF},	// CJK UNIFIED IDEOGRAPH
	{0xDB5E,	0x83F9},	// CJK UNIFIED IDEOGRAPH
	{0xDB5F,	0x8423},	// CJK UNIFIED IDEOGRAPH
	{0xDB60,	0x83C0},	// CJK UNIFIED IDEOGRAPH
	{0xDB61,	0x83E8},	// CJK UNIFIED IDEOGRAPH
	{0xDB62,	0x8412},	// CJK UNIFIED IDEOGRAPH
	{0xDB63,	0x83E7},	// CJK UNIFIED IDEOGRAPH
	{0xDB64,	0x83E4},	// CJK UNIFIED IDEOGRAPH
	{0xDB65,	0x83FC},	// CJK UNIFIED IDEOGRAPH
	{0xDB66,	0x83F6},	// CJK UNIFIED IDEOGRAPH
	{0xDB67,	0x8410},	// CJK UNIFIED IDEOGRAPH
	{0xDB68,	0x83C6},	// CJK UNIFIED IDEOGRAPH
	{0xDB69,	0x83C8},	// CJK UNIFIED IDEOGRAPH
	{0xDB6A,	0x83EB},	// CJK UNIFIED IDEOGRAPH
	{0xDB6B,	0x83E3},	// CJK UNIFIED IDEOGRAPH
	{0xDB6C,	0x83BF},	// CJK UNIFIED IDEOGRAPH
	{0xDB6D,	0x8401},	// CJK UNIFIED IDEOGRAPH
	{0xDB6E,	0x83DD},	// CJK UNIFIED IDEOGRAPH
	{0xDB6F,	0x83E5},	// CJK UNIFIED IDEOGRAPH
	{0xDB70,	0x83D8},	// CJK UNIFIED IDEOGRAPH
	{0xDB71,	0x83FF},	// CJK UNIFIED IDEOGRAPH
	{0xDB72,	0x83E1},	// CJK UNIFIED IDEOGRAPH
	{0xDB73,	0x83CB},	// CJK UNIFIED IDEOGRAPH
	{0xDB74,	0x83CE},	// CJK UNIFIED IDEOGRAPH
	{0xDB75,	0x83D6},	// CJK UNIFIED IDEOGRAPH
	{0xDB76,	0x83F5},	// CJK UNIFIED IDEOGRAPH
	{0xDB77,	0x83C9},	// CJK UNIFIED IDEOGRAPH
	{0xDB78,	0x8409},	// CJK UNIFIED IDEOGRAPH
	{0xDB79,	0x840F},	// CJK UNIFIED IDEOGRAPH
	{0xDB7A,	0x83DE},	// CJK UNIFIED IDEOGRAPH
	{0xDB7B,	0x8411},	// CJK UNIFIED IDEOGRAPH
	{0xDB7C,	0x8406},	// CJK UNIFIED IDEOGRAPH
	{0xDB7D,	0x83C2},	// CJK UNIFIED IDEOGRAPH
	{0xDB7E,	0x83F3},	// CJK UNIFIED IDEOGRAPH
	{0xDBA1,	0x83D5},	// CJK UNIFIED IDEOGRAPH
	{0xDBA2,	0x83FA},	// CJK UNIFIED IDEOGRAPH
	{0xDBA3,	0x83C7},	// CJK UNIFIED IDEOGRAPH
	{0xDBA4,	0x83D1},	// CJK UNIFIED IDEOGRAPH
	{0xDBA5,	0x83EA},	// CJK UNIFIED IDEOGRAPH
	{0xDBA6,	0x8413},	// CJK UNIFIED IDEOGRAPH
	{0xDBA7,	0x83C3},	// CJK UNIFIED IDEOGRAPH
	{0xDBA8,	0x83EC},	// CJK UNIFIED IDEOGRAPH
	{0xDBA9,	0x83EE},	// CJK UNIFIED IDEOGRAPH
	{0xDBAA,	0x83C4},	// CJK UNIFIED IDEOGRAPH
	{0xDBAB,	0x83FB},	// CJK UNIFIED IDEOGRAPH
	{0xDBAC,	0x83D7},	// CJK UNIFIED IDEOGRAPH
	{0xDBAD,	0x83E2},	// CJK UNIFIED IDEOGRAPH
	{0xDBAE,	0x841B},	// CJK UNIFIED IDEOGRAPH
	{0xDBAF,	0x83DB},	// CJK UNIFIED IDEOGRAPH
	{0xDBB0,	0x83FE},	// CJK UNIFIED IDEOGRAPH
	{0xDBB1,	0x86D8},	// CJK UNIFIED IDEOGRAPH
	{0xDBB2,	0x86E2},	// CJK UNIFIED IDEOGRAPH
	{0xDBB3,	0x86E6},	// CJK UNIFIED IDEOGRAPH
	{0xDBB4,	0x86D3},	// CJK UNIFIED IDEOGRAPH
	{0xDBB5,	0x86E3},	// CJK UNIFIED IDEOGRAPH
	{0xDBB6,	0x86DA},	// CJK UNIFIED IDEOGRAPH
	{0xDBB7,	0x86EA},	// CJK UNIFIED IDEOGRAPH
	{0xDBB8,	0x86DD},	// CJK UNIFIED IDEOGRAPH
	{0xDBB9,	0x86EB},	// CJK UNIFIED IDEOGRAPH
	{0xDBBA,	0x86DC},	// CJK UNIFIED IDEOGRAPH
	{0xDBBB,	0x86EC},	// CJK UNIFIED IDEOGRAPH
	{0xDBBC,	0x86E9},	// CJK UNIFIED IDEOGRAPH
	{0xDBBD,	0x86D7},	// CJK UNIFIED IDEOGRAPH
	{0xDBBE,	0x86E8},	// CJK UNIFIED IDEOGRAPH
	{0xDBBF,	0x86D1},	// CJK UNIFIED IDEOGRAPH
	{0xDBC0,	0x8848},	// CJK UNIFIED IDEOGRAPH
	{0xDBC1,	0x8856},	// CJK UNIFIED IDEOGRAPH
	{0xDBC2,	0x8855},	// CJK UNIFIED IDEOGRAPH
	{0xDBC3,	0x88BA},	// CJK UNIFIED IDEOGRAPH
	{0xDBC4,	0x88D7},	// CJK UNIFIED IDEOGRAPH
	{0xDBC5,	0x88B9},	// CJK UNIFIED IDEOGRAPH
	{0xDBC6,	0x88B8},	// CJK UNIFIED IDEOGRAPH
	{0xDBC7,	0x88C0},	// CJK UNIFIED IDEOGRAPH
	{0xDBC8,	0x88BE},	// CJK UNIFIED IDEOGRAPH
	{0xDBC9,	0x88B6},	// CJK UNIFIED IDEOGRAPH
	{0xDBCA,	0x88BC},	// CJK UNIFIED IDEOGRAPH
	{0xDBCB,	0x88B7},	// CJK UNIFIED IDEOGRAPH
	{0xDBCC,	0x88BD},	// CJK UNIFIED IDEOGRAPH
	{0xDBCD,	0x88B2},	// CJK UNIFIED IDEOGRAPH
	{0xDBCE,	0x8901},	// CJK UNIFIED IDEOGRAPH
	{0xDBCF,	0x88C9},	// CJK UNIFIED IDEOGRAPH
	{0xDBD0,	0x8995},	// CJK UNIFIED IDEOGRAPH
	{0xDBD1,	0x8998},	// CJK UNIFIED IDEOGRAPH
	{0xDBD2,	0x8997},	// CJK UNIFIED IDEOGRAPH
	{0xDBD3,	0x89DD},	// CJK UNIFIED IDEOGRAPH
	{0xDBD4,	0x89DA},	// CJK UNIFIED IDEOGRAPH
	{0xDBD5,	0x89DB},	// CJK UNIFIED IDEOGRAPH
	{0xDBD6,	0x8A4E},	// CJK UNIFIED IDEOGRAPH
	{0xDBD7,	0x8A4D},	// CJK UNIFIED IDEOGRAPH
	{0xDBD8,	0x8A39},	// CJK UNIFIED IDEOGRAPH
	{0xDBD9,	0x8A59},	// CJK UNIFIED IDEOGRAPH
	{0xDBDA,	0x8A40},	// CJK UNIFIED IDEOGRAPH
	{0xDBDB,	0x8A57},	// CJK UNIFIED IDEOGRAPH
	{0xDBDC,	0x8A58},	// CJK UNIFIED IDEOGRAPH
	{0xDBDD,	0x8A44},	// CJK UNIFIED IDEOGRAPH
	{0xDBDE,	0x8A45},	// CJK UNIFIED IDEOGRAPH
	{0xDBDF,	0x8A52},	// CJK UNIFIED IDEOGRAPH
	{0xDBE0,	0x8A48},	// CJK UNIFIED IDEOGRAPH
	{0xDBE1,	0x8A51},	// CJK UNIFIED IDEOGRAPH
	{0xDBE2,	0x8A4A},	// CJK UNIFIED IDEOGRAPH
	{0xDBE3,	0x8A4C},	// CJK UNIFIED IDEOGRAPH
	{0xDBE4,	0x8A4F},	// CJK UNIFIED IDEOGRAPH
	{0xDBE5,	0x8C5F},	// CJK UNIFIED IDEOGRAPH
	{0xDBE6,	0x8C81},	// CJK UNIFIED IDEOGRAPH
	{0xDBE7,	0x8C80},	// CJK UNIFIED IDEOGRAPH
	{0xDBE8,	0x8CBA},	// CJK UNIFIED IDEOGRAPH
	{0xDBE9,	0x8CBE},	// CJK UNIFIED IDEOGRAPH
	{0xDBEA,	0x8CB0},	// CJK UNIFIED IDEOGRAPH
	{0xDBEB,	0x8CB9},	// CJK UNIFIED IDEOGRAPH
	{0xDBEC,	0x8CB5},	// CJK UNIFIED IDEOGRAPH
	{0xDBED,	0x8D84},	// CJK UNIFIED IDEOGRAPH
	{0xDBEE,	0x8D80},	// CJK UNIFIED IDEOGRAPH
	{0xDBEF,	0x8D89},	// CJK UNIFIED IDEOGRAPH
	{0xDBF0,	0x8DD8},	// CJK UNIFIED IDEOGRAPH
	{0xDBF1,	0x8DD3},	// CJK UNIFIED IDEOGRAPH
	{0xDBF2,	0x8DCD},	// CJK UNIFIED IDEOGRAPH
	{0xDBF3,	0x8DC7},	// CJK UNIFIED IDEOGRAPH
	{0xDBF4,	0x8DD6},	// CJK UNIFIED IDEOGRAPH
	{0xDBF5,	0x8DDC},	// CJK UNIFIED IDEOGRAPH
	{0xDBF6,	0x8DCF},	// CJK UNIFIED IDEOGRAPH
	{0xDBF7,	0x8DD5},	// CJK UNIFIED IDEOGRAPH
	{0xDBF8,	0x8DD9},	// CJK UNIFIED IDEOGRAPH
	{0xDBF9,	0x8DC8},	// CJK UNIFIED IDEOGRAPH
	{0xDBFA,	0x8DD7},	// CJK UNIFIED IDEOGRAPH
	{0xDBFB,	0x8DC5},	// CJK UNIFIED IDEOGRAPH
	{0xDBFC,	0x8EEF},	// CJK UNIFIED IDEOGRAPH
	{0xDBFD,	0x8EF7},	// CJK UNIFIED IDEOGRAPH
	{0xDBFE,	0x8EFA},	// CJK UNIFIED IDEOGRAPH
	{0xDC40,	0x8EF9},	// CJK UNIFIED IDEOGRAPH
	{0xDC41,	0x8EE6},	// CJK UNIFIED IDEOGRAPH
	{0xDC42,	0x8EEE},	// CJK UNIFIED IDEOGRAPH
	{0xDC43,	0x8EE5},	// CJK UNIFIED IDEOGRAPH
	{0xDC44,	0x8EF5},	// CJK UNIFIED IDEOGRAPH
	{0xDC45,	0x8EE7},	// CJK UNIFIED IDEOGRAPH
	{0xDC46,	0x8EE8},	// CJK UNIFIED IDEOGRAPH
	{0xDC47,	0x8EF6},	// CJK UNIFIED IDEOGRAPH
	{0xDC48,	0x8EEB},	// CJK UNIFIED IDEOGRAPH
	{0xDC49,	0x8EF1},	// CJK UNIFIED IDEOGRAPH
	{0xDC4A,	0x8EEC},	// CJK UNIFIED IDEOGRAPH
	{0xDC4B,	0x8EF4},	// CJK UNIFIED IDEOGRAPH
	{0xDC4C,	0x8EE9},	// CJK UNIFIED IDEOGRAPH
	{0xDC4D,	0x902D},	// CJK UNIFIED IDEOGRAPH
	{0xDC4E,	0x9034},	// CJK UNIFIED IDEOGRAPH
	{0xDC4F,	0x902F},	// CJK UNIFIED IDEOGRAPH
	{0xDC50,	0x9106},	// CJK UNIFIED IDEOGRAPH
	{0xDC51,	0x912C},	// CJK UNIFIED IDEOGRAPH
	{0xDC52,	0x9104},	// CJK UNIFIED IDEOGRAPH
	{0xDC53,	0x90FF},	// CJK UNIFIED IDEOGRAPH
	{0xDC54,	0x90FC},	// CJK UNIFIED IDEOGRAPH
	{0xDC55,	0x9108},	// CJK UNIFIED IDEOGRAPH
	{0xDC56,	0x90F9},	// CJK UNIFIED IDEOGRAPH
	{0xDC57,	0x90FB},	// CJK UNIFIED IDEOGRAPH
	{0xDC58,	0x9101},	// CJK UNIFIED IDEOGRAPH
	{0xDC59,	0x9100},	// CJK UNIFIED IDEOGRAPH
	{0xDC5A,	0x9107},	// CJK UNIFIED IDEOGRAPH
	{0xDC5B,	0x9105},	// CJK UNIFIED IDEOGRAPH
	{0xDC5C,	0x9103},	// CJK UNIFIED IDEOGRAPH
	{0xDC5D,	0x9161},	// CJK UNIFIED IDEOGRAPH
	{0xDC5E,	0x9164},	// CJK UNIFIED IDEOGRAPH
	{0xDC5F,	0x915F},	// CJK UNIFIED IDEOGRAPH
	{0xDC60,	0x9162},	// CJK UNIFIED IDEOGRAPH
	{0xDC61,	0x9160},	// CJK UNIFIED IDEOGRAPH
	{0xDC62,	0x9201},	// CJK UNIFIED IDEOGRAPH
	{0xDC63,	0x920A},	// CJK UNIFIED IDEOGRAPH
	{0xDC64,	0x9225},	// CJK UNIFIED IDEOGRAPH
	{0xDC65,	0x9203},	// CJK UNIFIED IDEOGRAPH
	{0xDC66,	0x921A},	// CJK UNIFIED IDEOGRAPH
	{0xDC67,	0x9226},	// CJK UNIFIED IDEOGRAPH
	{0xDC68,	0x920F},	// CJK UNIFIED IDEOGRAPH
	{0xDC69,	0x920C},	// CJK UNIFIED IDEOGRAPH
	{0xDC6A,	0x9200},	// CJK UNIFIED IDEOGRAPH
	{0xDC6B,	0x9212},	// CJK UNIFIED IDEOGRAPH
	{0xDC6C,	0x91FF},	// CJK UNIFIED IDEOGRAPH
	{0xDC6D,	0x91FD},	// CJK UNIFIED IDEOGRAPH
	{0xDC6E,	0x9206},	// CJK UNIFIED IDEOGRAPH
	{0xDC6F,	0x9204},	// CJK UNIFIED IDEOGRAPH
	{0xDC70,	0x9227},	// CJK UNIFIED IDEOGRAPH
	{0xDC71,	0x9202},	// CJK UNIFIED IDEOGRAPH
	{0xDC72,	0x921C},	// CJK UNIFIED IDEOGRAPH
	{0xDC73,	0x9224},	// CJK UNIFIED IDEOGRAPH
	{0xDC74,	0x9219},	// CJK UNIFIED IDEOGRAPH
	{0xDC75,	0x9217},	// CJK UNIFIED IDEOGRAPH
	{0xDC76,	0x9205},	// CJK UNIFIED IDEOGRAPH
	{0xDC77,	0x9216},	// CJK UNIFIED IDEOGRAPH
	{0xDC78,	0x957B},	// CJK UNIFIED IDEOGRAPH
	{0xDC79,	0x958D},	// CJK UNIFIED IDEOGRAPH
	{0xDC7A,	0x958C},	// CJK UNIFIED IDEOGRAPH
	{0xDC7B,	0x9590},	// CJK UNIFIED IDEOGRAPH
	{0xDC7C,	0x9687},	// CJK UNIFIED IDEOGRAPH
	{0xDC7D,	0x967E},	// CJK UNIFIED IDEOGRAPH
	{0xDC7E,	0x9688},	// CJK UNIFIED IDEOGRAPH
	{0xDCA1,	0x9689},	// CJK UNIFIED IDEOGRAPH
	{0xDCA2,	0x9683},	// CJK UNIFIED IDEOGRAPH
	{0xDCA3,	0x9680},	// CJK UNIFIED IDEOGRAPH
	{0xDCA4,	0x96C2},	// CJK UNIFIED IDEOGRAPH
	{0xDCA5,	0x96C8},	// CJK UNIFIED IDEOGRAPH
	{0xDCA6,	0x96C3},	// CJK UNIFIED IDEOGRAPH
	{0xDCA7,	0x96F1},	// CJK UNIFIED IDEOGRAPH
	{0xDCA8,	0x96F0},	// CJK UNIFIED IDEOGRAPH
	{0xDCA9,	0x976C},	// CJK UNIFIED IDEOGRAPH
	{0xDCAA,	0x9770},	// CJK UNIFIED IDEOGRAPH
	{0xDCAB,	0x976E},	// CJK UNIFIED IDEOGRAPH
	{0xDCAC,	0x9807},	// CJK UNIFIED IDEOGRAPH
	{0xDCAD,	0x98A9},	// CJK UNIFIED IDEOGRAPH
	{0xDCAE,	0x98EB},	// CJK UNIFIED IDEOGRAPH
	{0xDCAF,	0x9CE6},	// CJK UNIFIED IDEOGRAPH
	{0xDCB0,	0x9EF9},	// CJK UNIFIED IDEOGRAPH
	{0xDCB1,	0x4E83},	// CJK UNIFIED IDEOGRAPH
	{0xDCB2,	0x4E84},	// CJK UNIFIED IDEOGRAPH
	{0xDCB3,	0x4EB6},	// CJK UNIFIED IDEOGRAPH
	{0xDCB4,	0x50BD},	// CJK UNIFIED IDEOGRAPH
	{0xDCB5,	0x50BF},	// CJK UNIFIED IDEOGRAPH
	{0xDCB6,	0x50C6},	// CJK UNIFIED IDEOGRAPH
	{0xDCB7,	0x50AE},	// CJK UNIFIED IDEOGRAPH
	{0xDCB8,	0x50C4},	// CJK UNIFIED IDEOGRAPH
	{0xDCB9,	0x50CA},	// CJK UNIFIED IDEOGRAPH
	{0xDCBA,	0x50B4},	// CJK UNIFIED IDEOGRAPH
	{0xDCBB,	0x50C8},	// CJK UNIFIED IDEOGRAPH
	{0xDCBC,	0x50C2},	// CJK UNIFIED IDEOGRAPH
	{0xDCBD,	0x50B0},	// CJK UNIFIED IDEOGRAPH
	{0xDCBE,	0x50C1},	// CJK UNIFIED IDEOGRAPH
	{0xDCBF,	0x50BA},	// CJK UNIFIED IDEOGRAPH
	{0xDCC0,	0x50B1},	// CJK UNIFIED IDEOGRAPH
	{0xDCC1,	0x50CB},	// CJK UNIFIED IDEOGRAPH
	{0xDCC2,	0x50C9},	// CJK UNIFIED IDEOGRAPH
	{0xDCC3,	0x50B6},	// CJK UNIFIED IDEOGRAPH
	{0xDCC4,	0x50B8},	// CJK UNIFIED IDEOGRAPH
	{0xDCC5,	0x51D7},	// CJK UNIFIED IDEOGRAPH
	{0xDCC6,	0x527A},	// CJK UNIFIED IDEOGRAPH
	{0xDCC7,	0x5278},	// CJK UNIFIED IDEOGRAPH
	{0xDCC8,	0x527B},	// CJK UNIFIED IDEOGRAPH
	{0xDCC9,	0x527C},	// CJK UNIFIED IDEOGRAPH
	{0xDCCA,	0x55C3},	// CJK UNIFIED IDEOGRAPH
	{0xDCCB,	0x55DB},	// CJK UNIFIED IDEOGRAPH
	{0xDCCC,	0x55CC},	// CJK UNIFIED IDEOGRAPH
	{0xDCCD,	0x55D0},	// CJK UNIFIED IDEOGRAPH
	{0xDCCE,	0x55CB},	// CJK UNIFIED IDEOGRAPH
	{0xDCCF,	0x55CA},	// CJK UNIFIED IDEOGRAPH
	{0xDCD0,	0x55DD},	// CJK UNIFIED IDEOGRAPH
	{0xDCD1,	0x55C0},	// CJK UNIFIED IDEOGRAPH
	{0xDCD2,	0x55D4},	// CJK UNIFIED IDEOGRAPH
	{0xDCD3,	0x55C4},	// CJK UNIFIED IDEOGRAPH
	{0xDCD4,	0x55E9},	// CJK UNIFIED IDEOGRAPH
	{0xDCD5,	0x55BF},	// CJK UNIFIED IDEOGRAPH
	{0xDCD6,	0x55D2},	// CJK UNIFIED IDEOGRAPH
	{0xDCD7,	0x558D},	// CJK UNIFIED IDEOGRAPH
	{0xDCD8,	0x55CF},	// CJK UNIFIED IDEOGRAPH
	{0xDCD9,	0x55D5},	// CJK UNIFIED IDEOGRAPH
	{0xDCDA,	0x55E2},	// CJK UNIFIED IDEOGRAPH
	{0xDCDB,	0x55D6},	// CJK UNIFIED IDEOGRAPH
	{0xDCDC,	0x55C8},	// CJK UNIFIED IDEOGRAPH
	{0xDCDD,	0x55F2},	// CJK UNIFIED IDEOGRAPH
	{0xDCDE,	0x55CD},	// CJK UNIFIED IDEOGRAPH
	{0xDCDF,	0x55D9},	// CJK UNIFIED IDEOGRAPH
	{0xDCE0,	0x55C2},	// CJK UNIFIED IDEOGRAPH
	{0xDCE1,	0x5714},	// CJK UNIFIED IDEOGRAPH
	{0xDCE2,	0x5853},	// CJK UNIFIED IDEOGRAPH
	{0xDCE3,	0x5868},	// CJK UNIFIED IDEOGRAPH
	{0xDCE4,	0x5864},	// CJK UNIFIED IDEOGRAPH
	{0xDCE5,	0x584F},	// CJK UNIFIED IDEOGRAPH
	{0xDCE6,	0x584D},	// CJK UNIFIED IDEOGRAPH
	{0xDCE7,	0x5849},	// CJK UNIFIED IDEOGRAPH
	{0xDCE8,	0x586F},	// CJK UNIFIED IDEOGRAPH
	{0xDCE9,	0x5855},	// CJK UNIFIED IDEOGRAPH
	{0xDCEA,	0x584E},	// CJK UNIFIED IDEOGRAPH
	{0xDCEB,	0x585D},	// CJK UNIFIED IDEOGRAPH
	{0xDCEC,	0x5859},	// CJK UNIFIED IDEOGRAPH
	{0xDCED,	0x5865},	// CJK UNIFIED IDEOGRAPH
	{0xDCEE,	0x585B},	// CJK UNIFIED IDEOGRAPH
	{0xDCEF,	0x583D},	// CJK UNIFIED IDEOGRAPH
	{0xDCF0,	0x5863},	// CJK UNIFIED IDEOGRAPH
	{0xDCF1,	0x5871},	// CJK UNIFIED IDEOGRAPH
	{0xDCF2,	0x58FC},	// CJK UNIFIED IDEOGRAPH
	{0xDCF3,	0x5AC7},	// CJK UNIFIED IDEOGRAPH
	{0xDCF4,	0x5AC4},	// CJK UNIFIED IDEOGRAPH
	{0xDCF5,	0x5ACB},	// CJK UNIFIED IDEOGRAPH
	{0xDCF6,	0x5ABA},	// CJK UNIFIED IDEOGRAPH
	{0xDCF7,	0x5AB8},	// CJK UNIFIED IDEOGRAPH
	{0xDCF8,	0x5AB1},	// CJK UNIFIED IDEOGRAPH
	{0xDCF9,	0x5AB5},	// CJK UNIFIED IDEOGRAPH
	{0xDCFA,	0x5AB0},	// CJK UNIFIED IDEOGRAPH
	{0xDCFB,	0x5ABF},	// CJK UNIFIED IDEOGRAPH
	{0xDCFC,	0x5AC8},	// CJK UNIFIED IDEOGRAPH
	{0xDCFD,	0x5ABB},	// CJK UNIFIED IDEOGRAPH
	{0xDCFE,	0x5AC6},	// CJK UNIFIED IDEOGRAPH
	{0xDD40,	0x5AB7},	// CJK UNIFIED IDEOGRAPH
	{0xDD41,	0x5AC0},	// CJK UNIFIED IDEOGRAPH
	{0xDD42,	0x5ACA},	// CJK UNIFIED IDEOGRAPH
	{0xDD43,	0x5AB4},	// CJK UNIFIED IDEOGRAPH
	{0xDD44,	0x5AB6},	// CJK UNIFIED IDEOGRAPH
	{0xDD45,	0x5ACD},	// CJK UNIFIED IDEOGRAPH
	{0xDD46,	0x5AB9},	// CJK UNIFIED IDEOGRAPH
	{0xDD47,	0x5A90},	// CJK UNIFIED IDEOGRAPH
	{0xDD48,	0x5BD6},	// CJK UNIFIED IDEOGRAPH
	{0xDD49,	0x5BD8},	// CJK UNIFIED IDEOGRAPH
	{0xDD4A,	0x5BD9},	// CJK UNIFIED IDEOGRAPH
	{0xDD4B,	0x5C1F},	// CJK UNIFIED IDEOGRAPH
	{0xDD4C,	0x5C33},	// CJK UNIFIED IDEOGRAPH
	{0xDD4D,	0x5D71},	// CJK UNIFIED IDEOGRAPH
	{0xDD4E,	0x5D63},	// CJK UNIFIED IDEOGRAPH
	{0xDD4F,	0x5D4A},	// CJK UNIFIED IDEOGRAPH
	{0xDD50,	0x5D65},	// CJK UNIFIED IDEOGRAPH
	{0xDD51,	0x5D72},	// CJK UNIFIED IDEOGRAPH
	{0xDD52,	0x5D6C},	// CJK UNIFIED IDEOGRAPH
	{0xDD53,	0x5D5E},	// CJK UNIFIED IDEOGRAPH
	{0xDD54,	0x5D68},	// CJK UNIFIED IDEOGRAPH
	{0xDD55,	0x5D67},	// CJK UNIFIED IDEOGRAPH
	{0xDD56,	0x5D62},	// CJK UNIFIED IDEOGRAPH
	{0xDD57,	0x5DF0},	// CJK UNIFIED IDEOGRAPH
	{0xDD58,	0x5E4F},	// CJK UNIFIED IDEOGRAPH
	{0xDD59,	0x5E4E},	// CJK UNIFIED IDEOGRAPH
	{0xDD5A,	0x5E4A},	// CJK UNIFIED IDEOGRAPH
	{0xDD5B,	0x5E4D},	// CJK UNIFIED IDEOGRAPH
	{0xDD5C,	0x5E4B},	// CJK UNIFIED IDEOGRAPH
	{0xDD5D,	0x5EC5},	// CJK UNIFIED IDEOGRAPH
	{0xDD5E,	0x5ECC},	// CJK UNIFIED IDEOGRAPH
	{0xDD5F,	0x5EC6},	// CJK UNIFIED IDEOGRAPH
	{0xDD60,	0x5ECB},	// CJK UNIFIED IDEOGRAPH
	{0xDD61,	0x5EC7},	// CJK UNIFIED IDEOGRAPH
	{0xDD62,	0x5F40},	// CJK UNIFIED IDEOGRAPH
	{0xDD63,	0x5FAF},	// CJK UNIFIED IDEOGRAPH
	{0xDD64,	0x5FAD},	// CJK UNIFIED IDEOGRAPH
	{0xDD65,	0x60F7},	// CJK UNIFIED IDEOGRAPH
	{0xDD66,	0x6149},	// CJK UNIFIED IDEOGRAPH
	{0xDD67,	0x614A},	// CJK UNIFIED IDEOGRAPH
	{0xDD68,	0x612B},	// CJK UNIFIED IDEOGRAPH
	{0xDD69,	0x6145},	// CJK UNIFIED IDEOGRAPH
	{0xDD6A,	0x6136},	// CJK UNIFIED IDEOGRAPH
	{0xDD6B,	0x6132},	// CJK UNIFIED IDEOGRAPH
	{0xDD6C,	0x612E},	// CJK UNIFIED IDEOGRAPH
	{0xDD6D,	0x6146},	// CJK UNIFIED IDEOGRAPH
	{0xDD6E,	0x612F},	// CJK UNIFIED IDEOGRAPH
	{0xDD6F,	0x614F},	// CJK UNIFIED IDEOGRAPH
	{0xDD70,	0x6129},	// CJK UNIFIED IDEOGRAPH
	{0xDD71,	0x6140},	// CJK UNIFIED IDEOGRAPH
	{0xDD72,	0x6220},	// CJK UNIFIED IDEOGRAPH
	{0xDD73,	0x9168},	// CJK UNIFIED IDEOGRAPH
	{0xDD74,	0x6223},	// CJK UNIFIED IDEOGRAPH
	{0xDD75,	0x6225},	// CJK UNIFIED IDEOGRAPH
	{0xDD76,	0x6224},	// CJK UNIFIED IDEOGRAPH
	{0xDD77,	0x63C5},	// CJK UNIFIED IDEOGRAPH
	{0xDD78,	0x63F1},	// CJK UNIFIED IDEOGRAPH
	{0xDD79,	0x63EB},	// CJK UNIFIED IDEOGRAPH
	{0xDD7A,	0x6410},	// CJK UNIFIED IDEOGRAPH
	{0xDD7B,	0x6412},	// CJK UNIFIED IDEOGRAPH
	{0xDD7C,	0x6409},	// CJK UNIFIED IDEOGRAPH
	{0xDD7D,	0x6420},	// CJK UNIFIED IDEOGRAPH
	{0xDD7E,	0x6424},	// CJK UNIFIED IDEOGRAPH
	{0xDDA1,	0x6433},	// CJK UNIFIED IDEOGRAPH
	{0xDDA2,	0x6443},	// CJK UNIFIED IDEOGRAPH
	{0xDDA3,	0x641F},	// CJK UNIFIED IDEOGRAPH
	{0xDDA4,	0x6415},	// CJK UNIFIED IDEOGRAPH
	{0xDDA5,	0x6418},	// CJK UNIFIED IDEOGRAPH
	{0xDDA6,	0x6439},	// CJK UNIFIED IDEOGRAPH
	{0xDDA7,	0x6437},	// CJK UNIFIED IDEOGRAPH
	{0xDDA8,	0x6422},	// CJK UNIFIED IDEOGRAPH
	{0xDDA9,	0x6423},	// CJK UNIFIED IDEOGRAPH
	{0xDDAA,	0x640C},	// CJK UNIFIED IDEOGRAPH
	{0xDDAB,	0x6426},	// CJK UNIFIED IDEOGRAPH
	{0xDDAC,	0x6430},	// CJK UNIFIED IDEOGRAPH
	{0xDDAD,	0x6428},	// CJK UNIFIED IDEOGRAPH
	{0xDDAE,	0x6441},	// CJK UNIFIED IDEOGRAPH
	{0xDDAF,	0x6435},	// CJK UNIFIED IDEOGRAPH
	{0xDDB0,	0x642F},	// CJK UNIFIED IDEOGRAPH
	{0xDDB1,	0x640A},	// CJK UNIFIED IDEOGRAPH
	{0xDDB2,	0x641A},	// CJK UNIFIED IDEOGRAPH
	{0xDDB3,	0x6440},	// CJK UNIFIED IDEOGRAPH
	{0xDDB4,	0x6425},	// CJK UNIFIED IDEOGRAPH
	{0xDDB5,	0x6427},	// CJK UNIFIED IDEOGRAPH
	{0xDDB6,	0x640B},	// CJK UNIFIED IDEOGRAPH
	{0xDDB7,	0x63E7},	// CJK UNIFIED IDEOGRAPH
	{0xDDB8,	0x641B},	// CJK UNIFIED IDEOGRAPH
	{0xDDB9,	0x642E},	// CJK UNIFIED IDEOGRAPH
	{0xDDBA,	0x6421},	// CJK UNIFIED IDEOGRAPH
	{0xDDBB,	0x640E},	// CJK UNIFIED IDEOGRAPH
	{0xDDBC,	0x656F},	// CJK UNIFIED IDEOGRAPH
	{0xDDBD,	0x6592},	// CJK UNIFIED IDEOGRAPH
	{0xDDBE,	0x65D3},	// CJK UNIFIED IDEOGRAPH
	{0xDDBF,	0x6686},	// CJK UNIFIED IDEOGRAPH
	{0xDDC0,	0x668C},	// CJK UNIFIED IDEOGRAPH
	{0xDDC1,	0x6695},	// CJK UNIFIED IDEOGRAPH
	{0xDDC2,	0x6690},	// CJK UNIFIED IDEOGRAPH
	{0xDDC3,	0x668B},	// CJK UNIFIED IDEOGRAPH
	{0xDDC4,	0x668A},	// CJK UNIFIED IDEOGRAPH
	{0xDDC5,	0x6699},	// CJK UNIFIED IDEOGRAPH
	{0xDDC6,	0x6694},	// CJK UNIFIED IDEOGRAPH
	{0xDDC7,	0x6678},	// CJK UNIFIED IDEOGRAPH
	{0xDDC8,	0x6720},	// CJK UNIFIED IDEOGRAPH
	{0xDDC9,	0x6966},	// CJK UNIFIED IDEOGRAPH
	{0xDDCA,	0x695F},	// CJK UNIFIED IDEOGRAPH
	{0xDDCB,	0x6938},	// CJK UNIFIED IDEOGRAPH
	{0xDDCC,	0x694E},	// CJK UNIFIED IDEOGRAPH
	{0xDDCD,	0x6962},	// CJK UNIFIED IDEOGRAPH
	{0xDDCE,	0x6971},	// CJK UNIFIED IDEOGRAPH
	{0xDDCF,	0x693F},	// CJK UNIFIED IDEOGRAPH
	{0xDDD0,	0x6945},	// CJK UNIFIED IDEOGRAPH
	{0xDDD1,	0x696A},	// CJK UNIFIED IDEOGRAPH
	{0xDDD2,	0x6939},	// CJK UNIFIED IDEOGRAPH
	{0xDDD3,	0x6942},	// CJK UNIFIED IDEOGRAPH
	{0xDDD4,	0x6957},	// CJK UNIFIED IDEOGRAPH
	{0xDDD5,	0x6959},	// CJK UNIFIED IDEOGRAPH
	{0xDDD6,	0x697A},	// CJK UNIFIED IDEOGRAPH
	{0xDDD7,	0x6948},	// CJK UNIFIED IDEOGRAPH
	{0xDDD8,	0x6949},	// CJK UNIFIED IDEOGRAPH
	{0xDDD9,	0x6935},	// CJK UNIFIED IDEOGRAPH
	{0xDDDA,	0x696C},	// CJK UNIFIED IDEOGRAPH
	{0xDDDB,	0x6933},	// CJK UNIFIED IDEOGRAPH
	{0xDDDC,	0x693D},	// CJK UNIFIED IDEOGRAPH
	{0xDDDD,	0x6965},	// CJK UNIFIED IDEOGRAPH
	{0xDDDE,	0x68F0},	// CJK UNIFIED IDEOGRAPH
	{0xDDDF,	0x6978},	// CJK UNIFIED IDEOGRAPH
	{0xDDE0,	0x6934},	// CJK UNIFIED IDEOGRAPH
	{0xDDE1,	0x6969},	// CJK UNIFIED IDEOGRAPH
	{0xDDE2,	0x6940},	// CJK UNIFIED IDEOGRAPH
	{0xDDE3,	0x696F},	// CJK UNIFIED IDEOGRAPH
	{0xDDE4,	0x6944},	// CJK UNIFIED IDEOGRAPH
	{0xDDE5,	0x6976},	// CJK UNIFIED IDEOGRAPH
	{0xDDE6,	0x6958},	// CJK UNIFIED IDEOGRAPH
	{0xDDE7,	0x6941},	// CJK UNIFIED IDEOGRAPH
	{0xDDE8,	0x6974},	// CJK UNIFIED IDEOGRAPH
	{0xDDE9,	0x694C},	// CJK UNIFIED IDEOGRAPH
	{0xDDEA,	0x693B},	// CJK UNIFIED IDEOGRAPH
	{0xDDEB,	0x694B},	// CJK UNIFIED IDEOGRAPH
	{0xDDEC,	0x6937},	// CJK UNIFIED IDEOGRAPH
	{0xDDED,	0x695C},	// CJK UNIFIED IDEOGRAPH
	{0xDDEE,	0x694F},	// CJK UNIFIED IDEOGRAPH
	{0xDDEF,	0x6951},	// CJK UNIFIED IDEOGRAPH
	{0xDDF0,	0x6932},	// CJK UNIFIED IDEOGRAPH
	{0xDDF1,	0x6952},	// CJK UNIFIED IDEOGRAPH
	{0xDDF2,	0x692F},	// CJK UNIFIED IDEOGRAPH
	{0xDDF3,	0x697B},	// CJK UNIFIED IDEOGRAPH
	{0xDDF4,	0x693C},	// CJK UNIFIED IDEOGRAPH
	{0xDDF5,	0x6B46},	// CJK UNIFIED IDEOGRAPH
	{0xDDF6,	0x6B45},	// CJK UNIFIED IDEOGRAPH
	{0xDDF7,	0x6B43},	// CJK UNIFIED IDEOGRAPH
	{0xDDF8,	0x6B42},	// CJK UNIFIED IDEOGRAPH
	{0xDDF9,	0x6B48},	// CJK UNIFIED IDEOGRAPH
	{0xDDFA,	0x6B41},	// CJK UNIFIED IDEOGRAPH
	{0xDDFB,	0x6B9B},	// CJK UNIFIED IDEOGRAPH
	{0xDDFC,	0xFA0D},	// CJK COMPATIBILITY IDEOGRAPH
	{0xDDFD,	0x6BFB},	// CJK UNIFIED IDEOGRAPH
	{0xDDFE,	0x6BFC},	// CJK UNIFIED IDEOGRAPH
	{0xDE40,	0x6BF9},	// CJK UNIFIED IDEOGRAPH
	{0xDE41,	0x6BF7},	// CJK UNIFIED IDEOGRAPH
	{0xDE42,	0x6BF8},	// CJK UNIFIED IDEOGRAPH
	{0xDE43,	0x6E9B},	// CJK UNIFIED IDEOGRAPH
	{0xDE44,	0x6ED6},	// CJK UNIFIED IDEOGRAPH
	{0xDE45,	0x6EC8},	// CJK UNIFIED IDEOGRAPH
	{0xDE46,	0x6E8F},	// CJK UNIFIED IDEOGRAPH
	{0xDE47,	0x6EC0},	// CJK UNIFIED IDEOGRAPH
	{0xDE48,	0x6E9F},	// CJK UNIFIED IDEOGRAPH
	{0xDE49,	0x6E93},	// CJK UNIFIED IDEOGRAPH
	{0xDE4A,	0x6E94},	// CJK UNIFIED IDEOGRAPH
	{0xDE4B,	0x6EA0},	// CJK UNIFIED IDEOGRAPH
	{0xDE4C,	0x6EB1},	// CJK UNIFIED IDEOGRAPH
	{0xDE4D,	0x6EB9},	// CJK UNIFIED IDEOGRAPH
	{0xDE4E,	0x6EC6},	// CJK UNIFIED IDEOGRAPH
	{0xDE4F,	0x6ED2},	// CJK UNIFIED IDEOGRAPH
	{0xDE50,	0x6EBD},	// CJK UNIFIED IDEOGRAPH
	{0xDE51,	0x6EC1},	// CJK UNIFIED IDEOGRAPH
	{0xDE52,	0x6E9E},	// CJK UNIFIED IDEOGRAPH
	{0xDE53,	0x6EC9},	// CJK UNIFIED IDEOGRAPH
	{0xDE54,	0x6EB7},	// CJK UNIFIED IDEOGRAPH
	{0xDE55,	0x6EB0},	// CJK UNIFIED IDEOGRAPH
	{0xDE56,	0x6ECD},	// CJK UNIFIED IDEOGRAPH
	{0xDE57,	0x6EA6},	// CJK UNIFIED IDEOGRAPH
	{0xDE58,	0x6ECF},	// CJK UNIFIED IDEOGRAPH
	{0xDE59,	0x6EB2},	// CJK UNIFIED IDEOGRAPH
	{0xDE5A,	0x6EBE},	// CJK UNIFIED IDEOGRAPH
	{0xDE5B,	0x6EC3},	// CJK UNIFIED IDEOGRAPH
	{0xDE5C,	0x6EDC},	// CJK UNIFIED IDEOGRAPH
	{0xDE5D,	0x6ED8},	// CJK UNIFIED IDEOGRAPH
	{0xDE5E,	0x6E99},	// CJK UNIFIED IDEOGRAPH
	{0xDE5F,	0x6E92},	// CJK UNIFIED IDEOGRAPH
	{0xDE60,	0x6E8E},	// CJK UNIFIED IDEOGRAPH
	{0xDE61,	0x6E8D},	// CJK UNIFIED IDEOGRAPH
	{0xDE62,	0x6EA4},	// CJK UNIFIED IDEOGRAPH
	{0xDE63,	0x6EA1},	// CJK UNIFIED IDEOGRAPH
	{0xDE64,	0x6EBF},	// CJK UNIFIED IDEOGRAPH
	{0xDE65,	0x6EB3},	// CJK UNIFIED IDEOGRAPH
	{0xDE66,	0x6ED0},	// CJK UNIFIED IDEOGRAPH
	{0xDE67,	0x6ECA},	// CJK UNIFIED IDEOGRAPH
	{0xDE68,	0x6E97},	// CJK UNIFIED IDEOGRAPH
	{0xDE69,	0x6EAE},	// CJK UNIFIED IDEOGRAPH
	{0xDE6A,	0x6EA3},	// CJK UNIFIED IDEOGRAPH
	{0xDE6B,	0x7147},	// CJK UNIFIED IDEOGRAPH
	{0xDE6C,	0x7154},	// CJK UNIFIED IDEOGRAPH
	{0xDE6D,	0x7152},	// CJK UNIFIED IDEOGRAPH
	{0xDE6E,	0x7163},	// CJK UNIFIED IDEOGRAPH
	{0xDE6F,	0x7160},	// CJK UNIFIED IDEOGRAPH
	{0xDE70,	0x7141},	// CJK UNIFIED IDEOGRAPH
	{0xDE71,	0x715D},	// CJK UNIFIED IDEOGRAPH
	{0xDE72,	0x7162},	// CJK UNIFIED IDEOGRAPH
	{0xDE73,	0x7172},	// CJK UNIFIED IDEOGRAPH
	{0xDE74,	0x7178},	// CJK UNIFIED IDEOGRAPH
	{0xDE75,	0x716A},	// CJK UNIFIED IDEOGRAPH
	{0xDE76,	0x7161},	// CJK UNIFIED IDEOGRAPH
	{0xDE77,	0x7142},	// CJK UNIFIED IDEOGRAPH
	{0xDE78,	0x7158},	// CJK UNIFIED IDEOGRAPH
	{0xDE79,	0x7143},	// CJK UNIFIED IDEOGRAPH
	{0xDE7A,	0x714B},	// CJK UNIFIED IDEOGRAPH
	{0xDE7B,	0x7170},	// CJK UNIFIED IDEOGRAPH
	{0xDE7C,	0x715F},	// CJK UNIFIED IDEOGRAPH
	{0xDE7D,	0x7150},	// CJK UNIFIED IDEOGRAPH
	{0xDE7E,	0x7153},	// CJK UNIFIED IDEOGRAPH
	{0xDEA1,	0x7144},	// CJK UNIFIED IDEOGRAPH
	{0xDEA2,	0x714D},	// CJK UNIFIED IDEOGRAPH
	{0xDEA3,	0x715A},	// CJK UNIFIED IDEOGRAPH
	{0xDEA4,	0x724F},	// CJK UNIFIED IDEOGRAPH
	{0xDEA5,	0x728D},	// CJK UNIFIED IDEOGRAPH
	{0xDEA6,	0x728C},	// CJK UNIFIED IDEOGRAPH
	{0xDEA7,	0x7291},	// CJK UNIFIED IDEOGRAPH
	{0xDEA8,	0x7290},	// CJK UNIFIED IDEOGRAPH
	{0xDEA9,	0x728E},	// CJK UNIFIED IDEOGRAPH
	{0xDEAA,	0x733C},	// CJK UNIFIED IDEOGRAPH
	{0xDEAB,	0x7342},	// CJK UNIFIED IDEOGRAPH
	{0xDEAC,	0x733B},	// CJK UNIFIED IDEOGRAPH
	{0xDEAD,	0x733A},	// CJK UNIFIED IDEOGRAPH
	{0xDEAE,	0x7340},	// CJK UNIFIED IDEOGRAPH
	{0xDEAF,	0x734A},	// CJK UNIFIED IDEOGRAPH
	{0xDEB0,	0x7349},	// CJK UNIFIED IDEOGRAPH
	{0xDEB1,	0x7444},	// CJK UNIFIED IDEOGRAPH
	{0xDEB2,	0x744A},	// CJK UNIFIED IDEOGRAPH
	{0xDEB3,	0x744B},	// CJK UNIFIED IDEOGRAPH
	{0xDEB4,	0x7452},	// CJK UNIFIED IDEOGRAPH
	{0xDEB5,	0x7451},	// CJK UNIFIED IDEOGRAPH
	{0xDEB6,	0x7457},	// CJK UNIFIED IDEOGRAPH
	{0xDEB7,	0x7440},	// CJK UNIFIED IDEOGRAPH
	{0xDEB8,	0x744F},	// CJK UNIFIED IDEOGRAPH
	{0xDEB9,	0x7450},	// CJK UNIFIED IDEOGRAPH
	{0xDEBA,	0x744E},	// CJK UNIFIED IDEOGRAPH
	{0xDEBB,	0x7442},	// CJK UNIFIED IDEOGRAPH
	{0xDEBC,	0x7446},	// CJK UNIFIED IDEOGRAPH
	{0xDEBD,	0x744D},	// CJK UNIFIED IDEOGRAPH
	{0xDEBE,	0x7454},	// CJK UNIFIED IDEOGRAPH
	{0xDEBF,	0x74E1},	// CJK UNIFIED IDEOGRAPH
	{0xDEC0,	0x74FF},	// CJK UNIFIED IDEOGRAPH
	{0xDEC1,	0x74FE},	// CJK UNIFIED IDEOGRAPH
	{0xDEC2,	0x74FD},	// CJK UNIFIED IDEOGRAPH
	{0xDEC3,	0x751D},	// CJK UNIFIED IDEOGRAPH
	{0xDEC4,	0x7579},	// CJK UNIFIED IDEOGRAPH
	{0xDEC5,	0x7577},	// CJK UNIFIED IDEOGRAPH
	{0xDEC6,	0x6983},	// CJK UNIFIED IDEOGRAPH
	{0xDEC7,	0x75EF},	// CJK UNIFIED IDEOGRAPH
	{0xDEC8,	0x760F},	// CJK UNIFIED IDEOGRAPH
	{0xDEC9,	0x7603},	// CJK UNIFIED IDEOGRAPH
	{0xDECA,	0x75F7},	// CJK UNIFIED IDEOGRAPH
	{0xDECB,	0x75FE},	// CJK UNIFIED IDEOGRAPH
	{0xDECC,	0x75FC},	// CJK UNIFIED IDEOGRAPH
	{0xDECD,	0x75F9},	// CJK UNIFIED IDEOGRAPH
	{0xDECE,	0x75F8},	// CJK UNIFIED IDEOGRAPH
	{0xDECF,	0x7610},	// CJK UNIFIED IDEOGRAPH
	{0xDED0,	0x75FB},	// CJK UNIFIED IDEOGRAPH
	{0xDED1,	0x75F6},	// CJK UNIFIED IDEOGRAPH
	{0xDED2,	0x75ED},	// CJK UNIFIED IDEOGRAPH
	{0xDED3,	0x75F5},	// CJK UNIFIED IDEOGRAPH
	{0xDED4,	0x75FD},	// CJK UNIFIED IDEOGRAPH
	{0xDED5,	0x7699},	// CJK UNIFIED IDEOGRAPH
	{0xDED6,	0x76B5},	// CJK UNIFIED IDEOGRAPH
	{0xDED7,	0x76DD},	// CJK UNIFIED IDEOGRAPH
	{0xDED8,	0x7755},	// CJK UNIFIED IDEOGRAPH
	{0xDED9,	0x775F},	// CJK UNIFIED IDEOGRAPH
	{0xDEDA,	0x7760},	// CJK UNIFIED IDEOGRAPH
	{0xDEDB,	0x7752},	// CJK UNIFIED IDEOGRAPH
	{0xDEDC,	0x7756},	// CJK UNIFIED IDEOGRAPH
	{0xDEDD,	0x775A},	// CJK UNIFIED IDEOGRAPH
	{0xDEDE,	0x7769},	// CJK UNIFIED IDEOGRAPH
	{0xDEDF,	0x7767},	// CJK UNIFIED IDEOGRAPH
	{0xDEE0,	0x7754},	// CJK UNIFIED IDEOGRAPH
	{0xDEE1,	0x7759},	// CJK UNIFIED IDEOGRAPH
	{0xDEE2,	0x776D},	// CJK UNIFIED IDEOGRAPH
	{0xDEE3,	0x77E0},	// CJK UNIFIED IDEOGRAPH
	{0xDEE4,	0x7887},	// CJK UNIFIED IDEOGRAPH
	{0xDEE5,	0x789A},	// CJK UNIFIED IDEOGRAPH
	{0xDEE6,	0x7894},	// CJK UNIFIED IDEOGRAPH
	{0xDEE7,	0x788F},	// CJK UNIFIED IDEOGRAPH
	{0xDEE8,	0x7884},	// CJK UNIFIED IDEOGRAPH
	{0xDEE9,	0x7895},	// CJK UNIFIED IDEOGRAPH
	{0xDEEA,	0x7885},	// CJK UNIFIED IDEOGRAPH
	{0xDEEB,	0x7886},	// CJK UNIFIED IDEOGRAPH
	{0xDEEC,	0x78A1},	// CJK UNIFIED IDEOGRAPH
	{0xDEED,	0x7883},	// CJK UNIFIED IDEOGRAPH
	{0xDEEE,	0x7879},	// CJK UNIFIED IDEOGRAPH
	{0xDEEF,	0x7899},	// CJK UNIFIED IDEOGRAPH
	{0xDEF0,	0x7880},	// CJK UNIFIED IDEOGRAPH
	{0xDEF1,	0x7896},	// CJK UNIFIED IDEOGRAPH
	{0xDEF2,	0x787B},	// CJK UNIFIED IDEOGRAPH
	{0xDEF3,	0x797C},	// CJK UNIFIED IDEOGRAPH
	{0xDEF4,	0x7982},	// CJK UNIFIED IDEOGRAPH
	{0xDEF5,	0x797D},	// CJK UNIFIED IDEOGRAPH
	{0xDEF6,	0x7979},	// CJK UNIFIED IDEOGRAPH
	{0xDEF7,	0x7A11},	// CJK UNIFIED IDEOGRAPH
	{0xDEF8,	0x7A18},	// CJK UNIFIED IDEOGRAPH
	{0xDEF9,	0x7A19},	// CJK UNIFIED IDEOGRAPH
	{0xDEFA,	0x7A12},	// CJK UNIFIED IDEOGRAPH
	{0xDEFB,	0x7A17},	// CJK UNIFIED IDEOGRAPH
	{0xDEFC,	0x7A15},	// CJK UNIFIED IDEOGRAPH
	{0xDEFD,	0x7A22},	// CJK UNIFIED IDEOGRAPH
	{0xDEFE,	0x7A13},	// CJK UNIFIED IDEOGRAPH
	{0xDF40,	0x7A1B},	// CJK UNIFIED IDEOGRAPH
	{0xDF41,	0x7A10},	// CJK UNIFIED IDEOGRAPH
	{0xDF42,	0x7AA3},	// CJK UNIFIED IDEOGRAPH
	{0xDF43,	0x7AA2},	// CJK UNIFIED IDEOGRAPH
	{0xDF44,	0x7A9E},	// CJK UNIFIED IDEOGRAPH
	{0xDF45,	0x7AEB},	// CJK UNIFIED IDEOGRAPH
	{0xDF46,	0x7B66},	// CJK UNIFIED IDEOGRAPH
	{0xDF47,	0x7B64},	// CJK UNIFIED IDEOGRAPH
	{0xDF48,	0x7B6D},	// CJK UNIFIED IDEOGRAPH
	{0xDF49,	0x7B74},	// CJK UNIFIED IDEOGRAPH
	{0xDF4A,	0x7B69},	// CJK UNIFIED IDEOGRAPH
	{0xDF4B,	0x7B72},	// CJK UNIFIED IDEOGRAPH
	{0xDF4C,	0x7B65},	// CJK UNIFIED IDEOGRAPH
	{0xDF4D,	0x7B73},	// CJK UNIFIED IDEOGRAPH
	{0xDF4E,	0x7B71},	// CJK UNIFIED IDEOGRAPH
	{0xDF4F,	0x7B70},	// CJK UNIFIED IDEOGRAPH
	{0xDF50,	0x7B61},	// CJK UNIFIED IDEOGRAPH
	{0xDF51,	0x7B78},	// CJK UNIFIED IDEOGRAPH
	{0xDF52,	0x7B76},	// CJK UNIFIED IDEOGRAPH
	{0xDF53,	0x7B63},	// CJK UNIFIED IDEOGRAPH
	{0xDF54,	0x7CB2},	// CJK UNIFIED IDEOGRAPH
	{0xDF55,	0x7CB4},	// CJK UNIFIED IDEOGRAPH
	{0xDF56,	0x7CAF},	// CJK UNIFIED IDEOGRAPH
	{0xDF57,	0x7D88},	// CJK UNIFIED IDEOGRAPH
	{0xDF58,	0x7D86},	// CJK UNIFIED IDEOGRAPH
	{0xDF59,	0x7D80},	// CJK UNIFIED IDEOGRAPH
	{0xDF5A,	0x7D8D},	// CJK UNIFIED IDEOGRAPH
	{0xDF5B,	0x7D7F},	// CJK UNIFIED IDEOGRAPH
	{0xDF5C,	0x7D85},	// CJK UNIFIED IDEOGRAPH
	{0xDF5D,	0x7D7A},	// CJK UNIFIED IDEOGRAPH
	{0xDF5E,	0x7D8E},	// CJK UNIFIED IDEOGRAPH
	{0xDF5F,	0x7D7B},	// CJK UNIFIED IDEOGRAPH
	{0xDF60,	0x7D83},	// CJK UNIFIED IDEOGRAPH
	{0xDF61,	0x7D7C},	// CJK UNIFIED IDEOGRAPH
	{0xDF62,	0x7D8C},	// CJK UNIFIED IDEOGRAPH
	{0xDF63,	0x7D94},	// CJK UNIFIED IDEOGRAPH
	{0xDF64,	0x7D84},	// CJK UNIFIED IDEOGRAPH
	{0xDF65,	0x7D7D},	// CJK UNIFIED IDEOGRAPH
	{0xDF66,	0x7D92},	// CJK UNIFIED IDEOGRAPH
	{0xDF67,	0x7F6D},	// CJK UNIFIED IDEOGRAPH
	{0xDF68,	0x7F6B},	// CJK UNIFIED IDEOGRAPH
	{0xDF69,	0x7F67},	// CJK UNIFIED IDEOGRAPH
	{0xDF6A,	0x7F68},	// CJK UNIFIED IDEOGRAPH
	{0xDF6B,	0x7F6C},	// CJK UNIFIED IDEOGRAPH
	{0xDF6C,	0x7FA6},	// CJK UNIFIED IDEOGRAPH
	{0xDF6D,	0x7FA5},	// CJK UNIFIED IDEOGRAPH
	{0xDF6E,	0x7FA7},	// CJK UNIFIED IDEOGRAPH
	{0xDF6F,	0x7FDB},	// CJK UNIFIED IDEOGRAPH
	{0xDF70,	0x7FDC},	// CJK UNIFIED IDEOGRAPH
	{0xDF71,	0x8021},	// CJK UNIFIED IDEOGRAPH
	{0xDF72,	0x8164},	// CJK UNIFIED IDEOGRAPH
	{0xDF73,	0x8160},	// CJK UNIFIED IDEOGRAPH
	{0xDF74,	0x8177},	// CJK UNIFIED IDEOGRAPH
	{0xDF75,	0x815C},	// CJK UNIFIED IDEOGRAPH
	{0xDF76,	0x8169},	// CJK UNIFIED IDEOGRAPH
	{0xDF77,	0x815B},	// CJK UNIFIED IDEOGRAPH
	{0xDF78,	0x8162},	// CJK UNIFIED IDEOGRAPH
	{0xDF79,	0x8172},	// CJK UNIFIED IDEOGRAPH
	{0xDF7A,	0x6721},	// CJK UNIFIED IDEOGRAPH
	{0xDF7B,	0x815E},	// CJK UNIFIED IDEOGRAPH
	{0xDF7C,	0x8176},	// CJK UNIFIED IDEOGRAPH
	{0xDF7D,	0x8167},	// CJK UNIFIED IDEOGRAPH
	{0xDF7E,	0x816F},	// CJK UNIFIED IDEOGRAPH
	{0xDFA1,	0x8144},	// CJK UNIFIED IDEOGRAPH
	{0xDFA2,	0x8161},	// CJK UNIFIED IDEOGRAPH
	{0xDFA3,	0x821D},	// CJK UNIFIED IDEOGRAPH
	{0xDFA4,	0x8249},	// CJK UNIFIED IDEOGRAPH
	{0xDFA5,	0x8244},	// CJK UNIFIED IDEOGRAPH
	{0xDFA6,	0x8240},	// CJK UNIFIED IDEOGRAPH
	{0xDFA7,	0x8242},	// CJK UNIFIED IDEOGRAPH
	{0xDFA8,	0x8245},	// CJK UNIFIED IDEOGRAPH
	{0xDFA9,	0x84F1},	// CJK UNIFIED IDEOGRAPH
	{0xDFAA,	0x843F},	// CJK UNIFIED IDEOGRAPH
	{0xDFAB,	0x8456},	// CJK UNIFIED IDEOGRAPH
	{0xDFAC,	0x8476},	// CJK UNIFIED IDEOGRAPH
	{0xDFAD,	0x8479},	// CJK UNIFIED IDEOGRAPH
	{0xDFAE,	0x848F},	// CJK UNIFIED IDEOGRAPH
	{0xDFAF,	0x848D},	// CJK UNIFIED IDEOGRAPH
	{0xDFB0,	0x8465},	// CJK UNIFIED IDEOGRAPH
	{0xDFB1,	0x8451},	// CJK UNIFIED IDEOGRAPH
	{0xDFB2,	0x8440},	// CJK UNIFIED IDEOGRAPH
	{0xDFB3,	0x8486},	// CJK UNIFIED IDEOGRAPH
	{0xDFB4,	0x8467},	// CJK UNIFIED IDEOGRAPH
	{0xDFB5,	0x8430},	// CJK UNIFIED IDEOGRAPH
	{0xDFB6,	0x844D},	// CJK UNIFIED IDEOGRAPH
	{0xDFB7,	0x847D},	// CJK UNIFIED IDEOGRAPH
	{0xDFB8,	0x845A},	// CJK UNIFIED IDEOGRAPH
	{0xDFB9,	0x8459},	// CJK UNIFIED IDEOGRAPH
	{0xDFBA,	0x8474},	// CJK UNIFIED IDEOGRAPH
	{0xDFBB,	0x8473},	// CJK UNIFIED IDEOGRAPH
	{0xDFBC,	0x845D},	// CJK UNIFIED IDEOGRAPH
	{0xDFBD,	0x8507},	// CJK UNIFIED IDEOGRAPH
	{0xDFBE,	0x845E},	// CJK UNIFIED IDEOGRAPH
	{0xDFBF,	0x8437},	// CJK UNIFIED IDEOGRAPH
	{0xDFC0,	0x843A},	// CJK UNIFIED IDEOGRAPH
	{0xDFC1,	0x8434},	// CJK UNIFIED IDEOGRAPH
	{0xDFC2,	0x847A},	// CJK UNIFIED IDEOGRAPH
	{0xDFC3,	0x8443},	// CJK UNIFIED IDEOGRAPH
	{0xDFC4,	0x8478},	// CJK UNIFIED IDEOGRAPH
	{0xDFC5,	0x8432},	// CJK UNIFIED IDEOGRAPH
	{0xDFC6,	0x8445},	// CJK UNIFIED IDEOGRAPH
	{0xDFC7,	0x8429},	// CJK UNIFIED IDEOGRAPH
	{0xDFC8,	0x83D9},	// CJK UNIFIED IDEOGRAPH
	{0xDFC9,	0x844B},	// CJK UNIFIED IDEOGRAPH
	{0xDFCA,	0x842F},	// CJK UNIFIED IDEOGRAPH
	{0xDFCB,	0x8442},	// CJK UNIFIED IDEOGRAPH
	{0xDFCC,	0x842D},	// CJK UNIFIED IDEOGRAPH
	{0xDFCD,	0x845F},	// CJK UNIFIED IDEOGRAPH
	{0xDFCE,	0x8470},	// CJK UNIFIED IDEOGRAPH
	{0xDFCF,	0x8439},	// CJK UNIFIED IDEOGRAPH
	{0xDFD0,	0x844E},	// CJK UNIFIED IDEOGRAPH
	{0xDFD1,	0x844C},	// CJK UNIFIED IDEOGRAPH
	{0xDFD2,	0x8452},	// CJK UNIFIED IDEOGRAPH
	{0xDFD3,	0x846F},	// CJK UNIFIED IDEOGRAPH
	{0xDFD4,	0x84C5},	// CJK UNIFIED IDEOGRAPH
	{0xDFD5,	0x848E},	// CJK UNIFIED IDEOGRAPH
	{0xDFD6,	0x843B},	// CJK UNIFIED IDEOGRAPH
	{0xDFD7,	0x8447},	// CJK UNIFIED IDEOGRAPH
	{0xDFD8,	0x8436},	// CJK UNIFIED IDEOGRAPH
	{0xDFD9,	0x8433},	// CJK UNIFIED IDEOGRAPH
	{0xDFDA,	0x8468},	// CJK UNIFIED IDEOGRAPH
	{0xDFDB,	0x847E},	// CJK UNIFIED IDEOGRAPH
	{0xDFDC,	0x8444},	// CJK UNIFIED IDEOGRAPH
	{0xDFDD,	0x842B},	// CJK UNIFIED IDEOGRAPH
	{0xDFDE,	0x8460},	// CJK UNIFIED IDEOGRAPH
	{0xDFDF,	0x8454},	// CJK UNIFIED IDEOGRAPH
	{0xDFE0,	0x846E},	// CJK UNIFIED IDEOGRAPH
	{0xDFE1,	0x8450},	// CJK UNIFIED IDEOGRAPH
	{0xDFE2,	0x870B},	// CJK UNIFIED IDEOGRAPH
	{0xDFE3,	0x8704},	// CJK UNIFIED IDEOGRAPH
	{0xDFE4,	0x86F7},	// CJK UNIFIED IDEOGRAPH
	{0xDFE5,	0x870C},	// CJK UNIFIED IDEOGRAPH
	{0xDFE6,	0x86FA},	// CJK UNIFIED IDEOGRAPH
	{0xDFE7,	0x86D6},	// CJK UNIFIED IDEOGRAPH
	{0xDFE8,	0x86F5},	// CJK UNIFIED IDEOGRAPH
	{0xDFE9,	0x874D},	// CJK UNIFIED IDEOGRAPH
	{0xDFEA,	0x86F8},	// CJK UNIFIED IDEOGRAPH
	{0xDFEB,	0x870E},	// CJK UNIFIED IDEOGRAPH
	{0xDFEC,	0x8709},	// CJK UNIFIED IDEOGRAPH
	{0xDFED,	0x8701},	// CJK UNIFIED IDEOGRAPH
	{0xDFEE,	0x86F6},	// CJK UNIFIED IDEOGRAPH
	{0xDFEF,	0x870D},	// CJK UNIFIED IDEOGRAPH
	{0xDFF0,	0x8705},	// CJK UNIFIED IDEOGRAPH
	{0xDFF1,	0x88D6},	// CJK UNIFIED IDEOGRAPH
	{0xDFF2,	0x88CB},	// CJK UNIFIED IDEOGRAPH
	{0xDFF3,	0x88CD},	// CJK UNIFIED IDEOGRAPH
	{0xDFF4,	0x88CE},	// CJK UNIFIED IDEOGRAPH
	{0xDFF5,	0x88DE},	// CJK UNIFIED IDEOGRAPH
	{0xDFF6,	0x88DB},	// CJK UNIFIED IDEOGRAPH
	{0xDFF7,	0x88DA},	// CJK UNIFIED IDEOGRAPH
	{0xDFF8,	0x88CC},	// CJK UNIFIED IDEOGRAPH
	{0xDFF9,	0x88D0},	// CJK UNIFIED IDEOGRAPH
	{0xDFFA,	0x8985},	// CJK UNIFIED IDEOGRAPH
	{0xDFFB,	0x899B},	// CJK UNIFIED IDEOGRAPH
	{0xDFFC,	0x89DF},	// CJK UNIFIED IDEOGRAPH
	{0xDFFD,	0x89E5},	// CJK UNIFIED IDEOGRAPH
	{0xDFFE,	0x89E4},	// CJK UNIFIED IDEOGRAPH
	{0xE040,	0x89E1},	// CJK UNIFIED IDEOGRAPH
	{0xE041,	0x89E0},	// CJK UNIFIED IDEOGRAPH
	{0xE042,	0x89E2},	// CJK UNIFIED IDEOGRAPH
	{0xE043,	0x89DC},	// CJK UNIFIED IDEOGRAPH
	{0xE044,	0x89E6},	// CJK UNIFIED IDEOGRAPH
	{0xE045,	0x8A76},	// CJK UNIFIED IDEOGRAPH
	{0xE046,	0x8A86},	// CJK UNIFIED IDEOGRAPH
	{0xE047,	0x8A7F},	// CJK UNIFIED IDEOGRAPH
	{0xE048,	0x8A61},	// CJK UNIFIED IDEOGRAPH
	{0xE049,	0x8A3F},	// CJK UNIFIED IDEOGRAPH
	{0xE04A,	0x8A77},	// CJK UNIFIED IDEOGRAPH
	{0xE04B,	0x8A82},	// CJK UNIFIED IDEOGRAPH
	{0xE04C,	0x8A84},	// CJK UNIFIED IDEOGRAPH
	{0xE04D,	0x8A75},	// CJK UNIFIED IDEOGRAPH
	{0xE04E,	0x8A83},	// CJK UNIFIED IDEOGRAPH
	{0xE04F,	0x8A81},	// CJK UNIFIED IDEOGRAPH
	{0xE050,	0x8A74},	// CJK UNIFIED IDEOGRAPH
	{0xE051,	0x8A7A},	// CJK UNIFIED IDEOGRAPH
	{0xE052,	0x8C3C},	// CJK UNIFIED IDEOGRAPH
	{0xE053,	0x8C4B},	// CJK UNIFIED IDEOGRAPH
	{0xE054,	0x8C4A},	// CJK UNIFIED IDEOGRAPH
	{0xE055,	0x8C65},	// CJK UNIFIED IDEOGRAPH
	{0xE056,	0x8C64},	// CJK UNIFIED IDEOGRAPH
	{0xE057,	0x8C66},	// CJK UNIFIED IDEOGRAPH
	{0xE058,	0x8C86},	// CJK UNIFIED IDEOGRAPH
	{0xE059,	0x8C84},	// CJK UNIFIED IDEOGRAPH
	{0xE05A,	0x8C85},	// CJK UNIFIED IDEOGRAPH
	{0xE05B,	0x8CCC},	// CJK UNIFIED IDEOGRAPH
	{0xE05C,	0x8D68},	// CJK UNIFIED IDEOGRAPH
	{0xE05D,	0x8D69},	// CJK UNIFIED IDEOGRAPH
	{0xE05E,	0x8D91},	// CJK UNIFIED IDEOGRAPH
	{0xE05F,	0x8D8C},	// CJK UNIFIED IDEOGRAPH
	{0xE060,	0x8D8E},	// CJK UNIFIED IDEOGRAPH
	{0xE061,	0x8D8F},	// CJK UNIFIED IDEOGRAPH
	{0xE062,	0x8D8D},	// CJK UNIFIED IDEOGRAPH
	{0xE063,	0x8D93},	// CJK UNIFIED IDEOGRAPH
	{0xE064,	0x8D94},	// CJK UNIFIED IDEOGRAPH
	{0xE065,	0x8D90},	// CJK UNIFIED IDEOGRAPH
	{0xE066,	0x8D92},	// CJK UNIFIED IDEOGRAPH
	{0xE067,	0x8DF0},	// CJK UNIFIED IDEOGRAPH
	{0xE068,	0x8DE0},	// CJK UNIFIED IDEOGRAPH
	{0xE069,	0x8DEC},	// CJK UNIFIED IDEOGRAPH
	{0xE06A,	0x8DF1},	// CJK UNIFIED IDEOGRAPH
	{0xE06B,	0x8DEE},	// CJK UNIFIED IDEOGRAPH
	{0xE06C,	0x8DD0},	// CJK UNIFIED IDEOGRAPH
	{0xE06D,	0x8DE9},	// CJK UNIFIED IDEOGRAPH
	{0xE06E,	0x8DE3},	// CJK UNIFIED IDEOGRAPH
	{0xE06F,	0x8DE2},	// CJK UNIFIED IDEOGRAPH
	{0xE070,	0x8DE7},	// CJK UNIFIED IDEOGRAPH
	{0xE071,	0x8DF2},	// CJK UNIFIED IDEOGRAPH
	{0xE072,	0x8DEB},	// CJK UNIFIED IDEOGRAPH
	{0xE073,	0x8DF4},	// CJK UNIFIED IDEOGRAPH
	{0xE074,	0x8F06},	// CJK UNIFIED IDEOGRAPH
	{0xE075,	0x8EFF},	// CJK UNIFIED IDEOGRAPH
	{0xE076,	0x8F01},	// CJK UNIFIED IDEOGRAPH
	{0xE077,	0x8F00},	// CJK UNIFIED IDEOGRAPH
	{0xE078,	0x8F05},	// CJK UNIFIED IDEOGRAPH
	{0xE079,	0x8F07},	// CJK UNIFIED IDEOGRAPH
	{0xE07A,	0x8F08},	// CJK UNIFIED IDEOGRAPH
	{0xE07B,	0x8F02},	// CJK UNIFIED IDEOGRAPH
	{0xE07C,	0x8F0B},	// CJK UNIFIED IDEOGRAPH
	{0xE07D,	0x9052},	// CJK UNIFIED IDEOGRAPH
	{0xE07E,	0x903F},	// CJK UNIFIED IDEOGRAPH
	{0xE0A1,	0x9044},	// CJK UNIFIED IDEOGRAPH
	{0xE0A2,	0x9049},	// CJK UNIFIED IDEOGRAPH
	{0xE0A3,	0x903D},	// CJK UNIFIED IDEOGRAPH
	{0xE0A4,	0x9110},	// CJK UNIFIED IDEOGRAPH
	{0xE0A5,	0x910D},	// CJK UNIFIED IDEOGRAPH
	{0xE0A6,	0x910F},	// CJK UNIFIED IDEOGRAPH
	{0xE0A7,	0x9111},	// CJK UNIFIED IDEOGRAPH
	{0xE0A8,	0x9116},	// CJK UNIFIED IDEOGRAPH
	{0xE0A9,	0x9114},	// CJK UNIFIED IDEOGRAPH
	{0xE0AA,	0x910B},	// CJK UNIFIED IDEOGRAPH
	{0xE0AB,	0x910E},	// CJK UNIFIED IDEOGRAPH
	{0xE0AC,	0x916E},	// CJK UNIFIED IDEOGRAPH
	{0xE0AD,	0x916F},	// CJK UNIFIED IDEOGRAPH
	{0xE0AE,	0x9248},	// CJK UNIFIED IDEOGRAPH
	{0xE0AF,	0x9252},	// CJK UNIFIED IDEOGRAPH
	{0xE0B0,	0x9230},	// CJK UNIFIED IDEOGRAPH
	{0xE0B1,	0x923A},	// CJK UNIFIED IDEOGRAPH
	{0xE0B2,	0x9266},	// CJK UNIFIED IDEOGRAPH
	{0xE0B3,	0x9233},	// CJK UNIFIED IDEOGRAPH
	{0xE0B4,	0x9265},	// CJK UNIFIED IDEOGRAPH
	{0xE0B5,	0x925E},	// CJK UNIFIED IDEOGRAPH
	{0xE0B6,	0x9283},	// CJK UNIFIED IDEOGRAPH
	{0xE0B7,	0x922E},	// CJK UNIFIED IDEOGRAPH
	{0xE0B8,	0x924A},	// CJK UNIFIED IDEOGRAPH
	{0xE0B9,	0x9246},	// CJK UNIFIED IDEOGRAPH
	{0xE0BA,	0x926D},	// CJK UNIFIED IDEOGRAPH
	{0xE0BB,	0x926C},	// CJK UNIFIED IDEOGRAPH
	{0xE0BC,	0x924F},	// CJK UNIFIED IDEOGRAPH
	{0xE0BD,	0x9260},	// CJK UNIFIED IDEOGRAPH
	{0xE0BE,	0x9267},	// CJK UNIFIED IDEOGRAPH
	{0xE0BF,	0x926F},	// CJK UNIFIED IDEOGRAPH
	{0xE0C0,	0x9236},	// CJK UNIFIED IDEOGRAPH
	{0xE0C1,	0x9261},	// CJK UNIFIED IDEOGRAPH
	{0xE0C2,	0x9270},	// CJK UNIFIED IDEOGRAPH
	{0xE0C3,	0x9231},	// CJK UNIFIED IDEOGRAPH
	{0xE0C4,	0x9254},	// CJK UNIFIED IDEOGRAPH
	{0xE0C5,	0x9263},	// CJK UNIFIED IDEOGRAPH
	{0xE0C6,	0x9250},	// CJK UNIFIED IDEOGRAPH
	{0xE0C7,	0x9272},	// CJK UNIFIED IDEOGRAPH
	{0xE0C8,	0x924E},	// CJK UNIFIED IDEOGRAPH
	{0xE0C9,	0x9253},	// CJK UNIFIED IDEOGRAPH
	{0xE0CA,	0x924C},	// CJK UNIFIED IDEOGRAPH
	{0xE0CB,	0x9256},	// CJK UNIFIED IDEOGRAPH
	{0xE0CC,	0x9232},	// CJK UNIFIED IDEOGRAPH
	{0xE0CD,	0x959F},	// CJK UNIFIED IDEOGRAPH
	{0xE0CE,	0x959C},	// CJK UNIFIED IDEOGRAPH
	{0xE0CF,	0x959E},	// CJK UNIFIED IDEOGRAPH
	{0xE0D0,	0x959B},	// CJK UNIFIED IDEOGRAPH
	{0xE0D1,	0x9692},	// CJK UNIFIED IDEOGRAPH
	{0xE0D2,	0x9693},	// CJK UNIFIED IDEOGRAPH
	{0xE0D3,	0x9691},	// CJK UNIFIED IDEOGRAPH
	{0xE0D4,	0x9697},	// CJK UNIFIED IDEOGRAPH
	{0xE0D5,	0x96CE},	// CJK UNIFIED IDEOGRAPH
	{0xE0D6,	0x96FA},	// CJK UNIFIED IDEOGRAPH
	{0xE0D7,	0x96FD},	// CJK UNIFIED IDEOGRAPH
	{0xE0D8,	0x96F8},	// CJK UNIFIED IDEOGRAPH
	{0xE0D9,	0x96F5},	// CJK UNIFIED IDEOGRAPH
	{0xE0DA,	0x9773},	// CJK UNIFIED IDEOGRAPH
	{0xE0DB,	0x9777},	// CJK UNIFIED IDEOGRAPH
	{0xE0DC,	0x9778},	// CJK UNIFIED IDEOGRAPH
	{0xE0DD,	0x9772},	// CJK UNIFIED IDEOGRAPH
	{0xE0DE,	0x980F},	// CJK UNIFIED IDEOGRAPH
	{0xE0DF,	0x980D},	// CJK UNIFIED IDEOGRAPH
	{0xE0E0,	0x980E},	// CJK UNIFIED IDEOGRAPH
	{0xE0E1,	0x98AC},	// CJK UNIFIED IDEOGRAPH
	{0xE0E2,	0x98F6},	// CJK UNIFIED IDEOGRAPH
	{0xE0E3,	0x98F9},	// CJK UNIFIED IDEOGRAPH
	{0xE0E4,	0x99AF},	// CJK UNIFIED IDEOGRAPH
	{0xE0E5,	0x99B2},	// CJK UNIFIED IDEOGRAPH
	{0xE0E6,	0x99B0},	// CJK UNIFIED IDEOGRAPH
	{0xE0E7,	0x99B5},	// CJK UNIFIED IDEOGRAPH
	{0xE0E8,	0x9AAD},	// CJK UNIFIED IDEOGRAPH
	{0xE0E9,	0x9AAB},	// CJK UNIFIED IDEOGRAPH
	{0xE0EA,	0x9B5B},	// CJK UNIFIED IDEOGRAPH
	{0xE0EB,	0x9CEA},	// CJK UNIFIED IDEOGRAPH
	{0xE0EC,	0x9CED},	// CJK UNIFIED IDEOGRAPH
	{0xE0ED,	0x9CE7},	// CJK UNIFIED IDEOGRAPH
	{0xE0EE,	0x9E80},	// CJK UNIFIED IDEOGRAPH
	{0xE0EF,	0x9EFD},	// CJK UNIFIED IDEOGRAPH
	{0xE0F0,	0x50E6},	// CJK UNIFIED IDEOGRAPH
	{0xE0F1,	0x50D4},	// CJK UNIFIED IDEOGRAPH
	{0xE0F2,	0x50D7},	// CJK UNIFIED IDEOGRAPH
	{0xE0F3,	0x50E8},	// CJK UNIFIED IDEOGRAPH
	{0xE0F4,	0x50F3},	// CJK UNIFIED IDEOGRAPH
	{0xE0F5,	0x50DB},	// CJK UNIFIED IDEOGRAPH
	{0xE0F6,	0x50EA},	// CJK UNIFIED IDEOGRAPH
	{0xE0F7,	0x50DD},	// CJK UNIFIED IDEOGRAPH
	{0xE0F8,	0x50E4},	// CJK UNIFIED IDEOGRAPH
	{0xE0F9,	0x50D3},	// CJK UNIFIED IDEOGRAPH
	{0xE0FA,	0x50EC},	// CJK UNIFIED IDEOGRAPH
	{0xE0FB,	0x50F0},	// CJK UNIFIED IDEOGRAPH
	{0xE0FC,	0x50EF},	// CJK UNIFIED IDEOGRAPH
	{0xE0FD,	0x50E3},	// CJK UNIFIED IDEOGRAPH
	{0xE0FE,	0x50E0},	// CJK UNIFIED IDEOGRAPH
	{0xE140,	0x51D8},	// CJK UNIFIED IDEOGRAPH
	{0xE141,	0x5280},	// CJK UNIFIED IDEOGRAPH
	{0xE142,	0x5281},	// CJK UNIFIED IDEOGRAPH
	{0xE143,	0x52E9},	// CJK UNIFIED IDEOGRAPH
	{0xE144,	0x52EB},	// CJK UNIFIED IDEOGRAPH
	{0xE145,	0x5330},	// CJK UNIFIED IDEOGRAPH
	{0xE146,	0x53AC},	// CJK UNIFIED IDEOGRAPH
	{0xE147,	0x5627},	// CJK UNIFIED IDEOGRAPH
	{0xE148,	0x5615},	// CJK UNIFIED IDEOGRAPH
	{0xE149,	0x560C},	// CJK UNIFIED IDEOGRAPH
	{0xE14A,	0x5612},	// CJK UNIFIED IDEOGRAPH
	{0xE14B,	0x55FC},	// CJK UNIFIED IDEOGRAPH
	{0xE14C,	0x560F},	// CJK UNIFIED IDEOGRAPH
	{0xE14D,	0x561C},	// CJK UNIFIED IDEOGRAPH
	{0xE14E,	0x5601},	// CJK UNIFIED IDEOGRAPH
	{0xE14F,	0x5613},	// CJK UNIFIED IDEOGRAPH
	{0xE150,	0x5602},	// CJK UNIFIED IDEOGRAPH
	{0xE151,	0x55FA},	// CJK UNIFIED IDEOGRAPH
	{0xE152,	0x561D},	// CJK UNIFIED IDEOGRAPH
	{0xE153,	0x5604},	// CJK UNIFIED IDEOGRAPH
	{0xE154,	0x55FF},	// CJK UNIFIED IDEOGRAPH
	{0xE155,	0x55F9},	// CJK UNIFIED IDEOGRAPH
	{0xE156,	0x5889},	// CJK UNIFIED IDEOGRAPH
	{0xE157,	0x587C},	// CJK UNIFIED IDEOGRAPH
	{0xE158,	0x5890},	// CJK UNIFIED IDEOGRAPH
	{0xE159,	0x5898},	// CJK UNIFIED IDEOGRAPH
	{0xE15A,	0x5886},	// CJK UNIFIED IDEOGRAPH
	{0xE15B,	0x5881},	// CJK UNIFIED IDEOGRAPH
	{0xE15C,	0x587F},	// CJK UNIFIED IDEOGRAPH
	{0xE15D,	0x5874},	// CJK UNIFIED IDEOGRAPH
	{0xE15E,	0x588B},	// CJK UNIFIED IDEOGRAPH
	{0xE15F,	0x587A},	// CJK UNIFIED IDEOGRAPH
	{0xE160,	0x5887},	// CJK UNIFIED IDEOGRAPH
	{0xE161,	0x5891},	// CJK UNIFIED IDEOGRAPH
	{0xE162,	0x588E},	// CJK UNIFIED IDEOGRAPH
	{0xE163,	0x5876},	// CJK UNIFIED IDEOGRAPH
	{0xE164,	0x5882},	// CJK UNIFIED IDEOGRAPH
	{0xE165,	0x5888},	// CJK UNIFIED IDEOGRAPH
	{0xE166,	0x587B},	// CJK UNIFIED IDEOGRAPH
	{0xE167,	0x5894},	// CJK UNIFIED IDEOGRAPH
	{0xE168,	0x588F},	// CJK UNIFIED IDEOGRAPH
	{0xE169,	0x58FE},	// CJK UNIFIED IDEOGRAPH
	{0xE16A,	0x596B},	// CJK UNIFIED IDEOGRAPH
	{0xE16B,	0x5ADC},	// CJK UNIFIED IDEOGRAPH
	{0xE16C,	0x5AEE},	// CJK UNIFIED IDEOGRAPH
	{0xE16D,	0x5AE5},	// CJK UNIFIED IDEOGRAPH
	{0xE16E,	0x5AD5},	// CJK UNIFIED IDEOGRAPH
	{0xE16F,	0x5AEA},	// CJK UNIFIED IDEOGRAPH
	{0xE170,	0x5ADA},	// CJK UNIFIED IDEOGRAPH
	{0xE171,	0x5AED},	// CJK UNIFIED IDEOGRAPH
	{0xE172,	0x5AEB},	// CJK UNIFIED IDEOGRAPH
	{0xE173,	0x5AF3},	// CJK UNIFIED IDEOGRAPH
	{0xE174,	0x5AE2},	// CJK UNIFIED IDEOGRAPH
	{0xE175,	0x5AE0},	// CJK UNIFIED IDEOGRAPH
	{0xE176,	0x5ADB},	// CJK UNIFIED IDEOGRAPH
	{0xE177,	0x5AEC},	// CJK UNIFIED IDEOGRAPH
	{0xE178,	0x5ADE},	// CJK UNIFIED IDEOGRAPH
	{0xE179,	0x5ADD},	// CJK UNIFIED IDEOGRAPH
	{0xE17A,	0x5AD9},	// CJK UNIFIED IDEOGRAPH
	{0xE17B,	0x5AE8},	// CJK UNIFIED IDEOGRAPH
	{0xE17C,	0x5ADF},	// CJK UNIFIED IDEOGRAPH
	{0xE17D,	0x5B77},	// CJK UNIFIED IDEOGRAPH
	{0xE17E,	0x5BE0},	// CJK UNIFIED IDEOGRAPH
	{0xE1A1,	0x5BE3},	// CJK UNIFIED IDEOGRAPH
	{0xE1A2,	0x5C63},	// CJK UNIFIED IDEOGRAPH
	{0xE1A3,	0x5D82},	// CJK UNIFIED IDEOGRAPH
	{0xE1A4,	0x5D80},	// CJK UNIFIED IDEOGRAPH
	{0xE1A5,	0x5D7D},	// CJK UNIFIED IDEOGRAPH
	{0xE1A6,	0x5D86},	// CJK UNIFIED IDEOGRAPH
	{0xE1A7,	0x5D7A},	// CJK UNIFIED IDEOGRAPH
	{0xE1A8,	0x5D81},	// CJK UNIFIED IDEOGRAPH
	{0xE1A9,	0x5D77},	// CJK UNIFIED IDEOGRAPH
	{0xE1AA,	0x5D8A},	// CJK UNIFIED IDEOGRAPH
	{0xE1AB,	0x5D89},	// CJK UNIFIED IDEOGRAPH
	{0xE1AC,	0x5D88},	// CJK UNIFIED IDEOGRAPH
	{0xE1AD,	0x5D7E},	// CJK UNIFIED IDEOGRAPH
	{0xE1AE,	0x5D7C},	// CJK UNIFIED IDEOGRAPH
	{0xE1AF,	0x5D8D},	// CJK UNIFIED IDEOGRAPH
	{0xE1B0,	0x5D79},	// CJK UNIFIED IDEOGRAPH
	{0xE1B1,	0x5D7F},	// CJK UNIFIED IDEOGRAPH
	{0xE1B2,	0x5E58},	// CJK UNIFIED IDEOGRAPH
	{0xE1B3,	0x5E59},	// CJK UNIFIED IDEOGRAPH
	{0xE1B4,	0x5E53},	// CJK UNIFIED IDEOGRAPH
	{0xE1B5,	0x5ED8},	// CJK UNIFIED IDEOGRAPH
	{0xE1B6,	0x5ED1},	// CJK UNIFIED IDEOGRAPH
	{0xE1B7,	0x5ED7},	// CJK UNIFIED IDEOGRAPH
	{0xE1B8,	0x5ECE},	// CJK UNIFIED IDEOGRAPH
	{0xE1B9,	0x5EDC},	// CJK UNIFIED IDEOGRAPH
	{0xE1BA,	0x5ED5},	// CJK UNIFIED IDEOGRAPH
	{0xE1BB,	0x5ED9},	// CJK UNIFIED IDEOGRAPH
	{0xE1BC,	0x5ED2},	// CJK UNIFIED IDEOGRAPH
	{0xE1BD,	0x5ED4},	// CJK UNIFIED IDEOGRAPH
	{0xE1BE,	0x5F44},	// CJK UNIFIED IDEOGRAPH
	{0xE1BF,	0x5F43},	// CJK UNIFIED IDEOGRAPH
	{0xE1C0,	0x5F6F},	// CJK UNIFIED IDEOGRAPH
	{0xE1C1,	0x5FB6},	// CJK UNIFIED IDEOGRAPH
	{0xE1C2,	0x612C},	// CJK UNIFIED IDEOGRAPH
	{0xE1C3,	0x6128},	// CJK UNIFIED IDEOGRAPH
	{0xE1C4,	0x6141},	// CJK UNIFIED IDEOGRAPH
	{0xE1C5,	0x615E},	// CJK UNIFIED IDEOGRAPH
	{0xE1C6,	0x6171},	// CJK UNIFIED IDEOGRAPH
	{0xE1C7,	0x6173},	// CJK UNIFIED IDEOGRAPH
	{0xE1C8,	0x6152},	// CJK UNIFIED IDEOGRAPH
	{0xE1C9,	0x6153},	// CJK UNIFIED IDEOGRAPH
	{0xE1CA,	0x6172},	// CJK UNIFIED IDEOGRAPH
	{0xE1CB,	0x616C},	// CJK UNIFIED IDEOGRAPH
	{0xE1CC,	0x6180},	// CJK UNIFIED IDEOGRAPH
	{0xE1CD,	0x6174},	// CJK UNIFIED IDEOGRAPH
	{0xE1CE,	0x6154},	// CJK UNIFIED IDEOGRAPH
	{0xE1CF,	0x617A},	// CJK UNIFIED IDEOGRAPH
	{0xE1D0,	0x615B},	// CJK UNIFIED IDEOGRAPH
	{0xE1D1,	0x6165},	// CJK UNIFIED IDEOGRAPH
	{0xE1D2,	0x613B},	// CJK UNIFIED IDEOGRAPH
	{0xE1D3,	0x616A},	// CJK UNIFIED IDEOGRAPH
	{0xE1D4,	0x6161},	// CJK UNIFIED IDEOGRAPH
	{0xE1D5,	0x6156},	// CJK UNIFIED IDEOGRAPH
	{0xE1D6,	0x6229},	// CJK UNIFIED IDEOGRAPH
	{0xE1D7,	0x6227},	// CJK UNIFIED IDEOGRAPH
	{0xE1D8,	0x622B},	// CJK UNIFIED IDEOGRAPH
	{0xE1D9,	0x642B},	// CJK UNIFIED IDEOGRAPH
	{0xE1DA,	0x644D},	// CJK UNIFIED IDEOGRAPH
	{0xE1DB,	0x645B},	// CJK UNIFIED IDEOGRAPH
	{0xE1DC,	0x645D},	// CJK UNIFIED IDEOGRAPH
	{0xE1DD,	0x6474},	// CJK UNIFIED IDEOGRAPH
	{0xE1DE,	0x6476},	// CJK UNIFIED IDEOGRAPH
	{0xE1DF,	0x6472},	// CJK UNIFIED IDEOGRAPH
	{0xE1E0,	0x6473},	// CJK UNIFIED IDEOGRAPH
	{0xE1E1,	0x647D},	// CJK UNIFIED IDEOGRAPH
	{0xE1E2,	0x6475},	// CJK UNIFIED IDEOGRAPH
	{0xE1E3,	0x6466},	// CJK UNIFIED IDEOGRAPH
	{0xE1E4,	0x64A6},	// CJK UNIFIED IDEOGRAPH
	{0xE1E5,	0x644E},	// CJK UNIFIED IDEOGRAPH
	{0xE1E6,	0x6482},	// CJK UNIFIED IDEOGRAPH
	{0xE1E7,	0x645E},	// CJK UNIFIED IDEOGRAPH
	{0xE1E8,	0x645C},	// CJK UNIFIED IDEOGRAPH
	{0xE1E9,	0x644B},	// CJK UNIFIED IDEOGRAPH
	{0xE1EA,	0x6453},	// CJK UNIFIED IDEOGRAPH
	{0xE1EB,	0x6460},	// CJK UNIFIED IDEOGRAPH
	{0xE1EC,	0x6450},	// CJK UNIFIED IDEOGRAPH
	{0xE1ED,	0x647F},	// CJK UNIFIED IDEOGRAPH
	{0xE1EE,	0x643F},	// CJK UNIFIED IDEOGRAPH
	{0xE1EF,	0x646C},	// CJK UNIFIED IDEOGRAPH
	{0xE1F0,	0x646B},	// CJK UNIFIED IDEOGRAPH
	{0xE1F1,	0x6459},	// CJK UNIFIED IDEOGRAPH
	{0xE1F2,	0x6465},	// CJK UNIFIED IDEOGRAPH
	{0xE1F3,	0x6477},	// CJK UNIFIED IDEOGRAPH
	{0xE1F4,	0x6573},	// CJK UNIFIED IDEOGRAPH
	{0xE1F5,	0x65A0},	// CJK UNIFIED IDEOGRAPH
	{0xE1F6,	0x66A1},	// CJK UNIFIED IDEOGRAPH
	{0xE1F7,	0x66A0},	// CJK UNIFIED IDEOGRAPH
	{0xE1F8,	0x669F},	// CJK UNIFIED IDEOGRAPH
	{0xE1F9,	0x6705},	// CJK UNIFIED IDEOGRAPH
	{0xE1FA,	0x6704},	// CJK UNIFIED IDEOGRAPH
	{0xE1FB,	0x6722},	// CJK UNIFIED IDEOGRAPH
	{0xE1FC,	0x69B1},	// CJK UNIFIED IDEOGRAPH
	{0xE1FD,	0x69B6},	// CJK UNIFIED IDEOGRAPH
	{0xE1FE,	0x69C9},	// CJK UNIFIED IDEOGRAPH
	{0xE240,	0x69A0},	// CJK UNIFIED IDEOGRAPH
	{0xE241,	0x69CE},	// CJK UNIFIED IDEOGRAPH
	{0xE242,	0x6996},	// CJK UNIFIED IDEOGRAPH
	{0xE243,	0x69B0},	// CJK UNIFIED IDEOGRAPH
	{0xE244,	0x69AC},	// CJK UNIFIED IDEOGRAPH
	{0xE245,	0x69BC},	// CJK UNIFIED IDEOGRAPH
	{0xE246,	0x6991},	// CJK UNIFIED IDEOGRAPH
	{0xE247,	0x6999},	// CJK UNIFIED IDEOGRAPH
	{0xE248,	0x698E},	// CJK UNIFIED IDEOGRAPH
	{0xE249,	0x69A7},	// CJK UNIFIED IDEOGRAPH
	{0xE24A,	0x698D},	// CJK UNIFIED IDEOGRAPH
	{0xE24B,	0x69A9},	// CJK UNIFIED IDEOGRAPH
	{0xE24C,	0x69BE},	// CJK UNIFIED IDEOGRAPH
	{0xE24D,	0x69AF},	// CJK UNIFIED IDEOGRAPH
	{0xE24E,	0x69BF},	// CJK UNIFIED IDEOGRAPH
	{0xE24F,	0x69C4},	// CJK UNIFIED IDEOGRAPH
	{0xE250,	0x69BD},	// CJK UNIFIED IDEOGRAPH
	{0xE251,	0x69A4},	// CJK UNIFIED IDEOGRAPH
	{0xE252,	0x69D4},	// CJK UNIFIED IDEOGRAPH
	{0xE253,	0x69B9},	// CJK UNIFIED IDEOGRAPH
	{0xE254,	0x69CA},	// CJK UNIFIED IDEOGRAPH
	{0xE255,	0x699A},	// CJK UNIFIED IDEOGRAPH
	{0xE256,	0x69CF},	// CJK UNIFIED IDEOGRAPH
	{0xE257,	0x69B3},	// CJK UNIFIED IDEOGRAPH
	{0xE258,	0x6993},	// CJK UNIFIED IDEOGRAPH
	{0xE259,	0x69AA},	// CJK UNIFIED IDEOGRAPH
	{0xE25A,	0x69A1},	// CJK UNIFIED IDEOGRAPH
	{0xE25B,	0x699E},	// CJK UNIFIED IDEOGRAPH
	{0xE25C,	0x69D9},	// CJK UNIFIED IDEOGRAPH
	{0xE25D,	0x6997},	// CJK UNIFIED IDEOGRAPH
	{0xE25E,	0x6990},	// CJK UNIFIED IDEOGRAPH
	{0xE25F,	0x69C2},	// CJK UNIFIED IDEOGRAPH
	{0xE260,	0x69B5},	// CJK UNIFIED IDEOGRAPH
	{0xE261,	0x69A5},	// CJK UNIFIED IDEOGRAPH
	{0xE262,	0x69C6},	// CJK UNIFIED IDEOGRAPH
	{0xE263,	0x6B4A},	// CJK UNIFIED IDEOGRAPH
	{0xE264,	0x6B4D},	// CJK UNIFIED IDEOGRAPH
	{0xE265,	0x6B4B},	// CJK UNIFIED IDEOGRAPH
	{0xE266,	0x6B9E},	// CJK UNIFIED IDEOGRAPH
	{0xE267,	0x6B9F},	// CJK UNIFIED IDEOGRAPH
	{0xE268,	0x6BA0},	// CJK UNIFIED IDEOGRAPH
	{0xE269,	0x6BC3},	// CJK UNIFIED IDEOGRAPH
	{0xE26A,	0x6BC4},	// CJK UNIFIED IDEOGRAPH
	{0xE26B,	0x6BFE},	// CJK UNIFIED IDEOGRAPH
	{0xE26C,	0x6ECE},	// CJK UNIFIED IDEOGRAPH
	{0xE26D,	0x6EF5},	// CJK UNIFIED IDEOGRAPH
	{0xE26E,	0x6EF1},	// CJK UNIFIED IDEOGRAPH
	{0xE26F,	0x6F03},	// CJK UNIFIED IDEOGRAPH
	{0xE270,	0x6F25},	// CJK UNIFIED IDEOGRAPH
	{0xE271,	0x6EF8},	// CJK UNIFIED IDEOGRAPH
	{0xE272,	0x6F37},	// CJK UNIFIED IDEOGRAPH
	{0xE273,	0x6EFB},	// CJK UNIFIED IDEOGRAPH
	{0xE274,	0x6F2E},	// CJK UNIFIED IDEOGRAPH
	{0xE275,	0x6F09},	// CJK UNIFIED IDEOGRAPH
	{0xE276,	0x6F4E},	// CJK UNIFIED IDEOGRAPH
	{0xE277,	0x6F19},	// CJK UNIFIED IDEOGRAPH
	{0xE278,	0x6F1A},	// CJK UNIFIED IDEOGRAPH
	{0xE279,	0x6F27},	// CJK UNIFIED IDEOGRAPH
	{0xE27A,	0x6F18},	// CJK UNIFIED IDEOGRAPH
	{0xE27B,	0x6F3B},	// CJK UNIFIED IDEOGRAPH
	{0xE27C,	0x6F12},	// CJK UNIFIED IDEOGRAPH
	{0xE27D,	0x6EED},	// CJK UNIFIED IDEOGRAPH
	{0xE27E,	0x6F0A},	// CJK UNIFIED IDEOGRAPH
	{0xE2A1,	0x6F36},	// CJK UNIFIED IDEOGRAPH
	{0xE2A2,	0x6F73},	// CJK UNIFIED IDEOGRAPH
	{0xE2A3,	0x6EF9},	// CJK UNIFIED IDEOGRAPH
	{0xE2A4,	0x6EEE},	// CJK UNIFIED IDEOGRAPH
	{0xE2A5,	0x6F2D},	// CJK UNIFIED IDEOGRAPH
	{0xE2A6,	0x6F40},	// CJK UNIFIED IDEOGRAPH
	{0xE2A7,	0x6F30},	// CJK UNIFIED IDEOGRAPH
	{0xE2A8,	0x6F3C},	// CJK UNIFIED IDEOGRAPH
	{0xE2A9,	0x6F35},	// CJK UNIFIED IDEOGRAPH
	{0xE2AA,	0x6EEB},	// CJK UNIFIED IDEOGRAPH
	{0xE2AB,	0x6F07},	// CJK UNIFIED IDEOGRAPH
	{0xE2AC,	0x6F0E},	// CJK UNIFIED IDEOGRAPH
	{0xE2AD,	0x6F43},	// CJK UNIFIED IDEOGRAPH
	{0xE2AE,	0x6F05},	// CJK UNIFIED IDEOGRAPH
	{0xE2AF,	0x6EFD},	// CJK UNIFIED IDEOGRAPH
	{0xE2B0,	0x6EF6},	// CJK UNIFIED IDEOGRAPH
	{0xE2B1,	0x6F39},	// CJK UNIFIED IDEOGRAPH
	{0xE2B2,	0x6F1C},	// CJK UNIFIED IDEOGRAPH
	{0xE2B3,	0x6EFC},	// CJK UNIFIED IDEOGRAPH
	{0xE2B4,	0x6F3A},	// CJK UNIFIED IDEOGRAPH
	{0xE2B5,	0x6F1F},	// CJK UNIFIED IDEOGRAPH
	{0xE2B6,	0x6F0D},	// CJK UNIFIED IDEOGRAPH
	{0xE2B7,	0x6F1E},	// CJK UNIFIED IDEOGRAPH
	{0xE2B8,	0x6F08},	// CJK UNIFIED IDEOGRAPH
	{0xE2B9,	0x6F21},	// CJK UNIFIED IDEOGRAPH
	{0xE2BA,	0x7187},	// CJK UNIFIED IDEOGRAPH
	{0xE2BB,	0x7190},	// CJK UNIFIED IDEOGRAPH
	{0xE2BC,	0x7189},	// CJK UNIFIED IDEOGRAPH
	{0xE2BD,	0x7180},	// CJK UNIFIED IDEOGRAPH
	{0xE2BE,	0x7185},	// CJK UNIFIED IDEOGRAPH
	{0xE2BF,	0x7182},	// CJK UNIFIED IDEOGRAPH
	{0xE2C0,	0x718F},	// CJK UNIFIED IDEOGRAPH
	{0xE2C1,	0x717B},	// CJK UNIFIED IDEOGRAPH
	{0xE2C2,	0x7186},	// CJK UNIFIED IDEOGRAPH
	{0xE2C3,	0x7181},	// CJK UNIFIED IDEOGRAPH
	{0xE2C4,	0x7197},	// CJK UNIFIED IDEOGRAPH
	{0xE2C5,	0x7244},	// CJK UNIFIED IDEOGRAPH
	{0xE2C6,	0x7253},	// CJK UNIFIED IDEOGRAPH
	{0xE2C7,	0x7297},	// CJK UNIFIED IDEOGRAPH
	{0xE2C8,	0x7295},	// CJK UNIFIED IDEOGRAPH
	{0xE2C9,	0x7293},	// CJK UNIFIED IDEOGRAPH
	{0xE2CA,	0x7343},	// CJK UNIFIED IDEOGRAPH
	{0xE2CB,	0x734D},	// CJK UNIFIED IDEOGRAPH
	{0xE2CC,	0x7351},	// CJK UNIFIED IDEOGRAPH
	{0xE2CD,	0x734C},	// CJK UNIFIED IDEOGRAPH
	{0xE2CE,	0x7462},	// CJK UNIFIED IDEOGRAPH
	{0xE2CF,	0x7473},	// CJK UNIFIED IDEOGRAPH
	{0xE2D0,	0x7471},	// CJK UNIFIED IDEOGRAPH
	{0xE2D1,	0x7475},	// CJK UNIFIED IDEOGRAPH
	{0xE2D2,	0x7472},	// CJK UNIFIED IDEOGRAPH
	{0xE2D3,	0x7467},	// CJK UNIFIED IDEOGRAPH
	{0xE2D4,	0x746E},	// CJK UNIFIED IDEOGRAPH
	{0xE2D5,	0x7500},	// CJK UNIFIED IDEOGRAPH
	{0xE2D6,	0x7502},	// CJK UNIFIED IDEOGRAPH
	{0xE2D7,	0x7503},	// CJK UNIFIED IDEOGRAPH
	{0xE2D8,	0x757D},	// CJK UNIFIED IDEOGRAPH
	{0xE2D9,	0x7590},	// CJK UNIFIED IDEOGRAPH
	{0xE2DA,	0x7616},	// CJK UNIFIED IDEOGRAPH
	{0xE2DB,	0x7608},	// CJK UNIFIED IDEOGRAPH
	{0xE2DC,	0x760C},	// CJK UNIFIED IDEOGRAPH
	{0xE2DD,	0x7615},	// CJK UNIFIED IDEOGRAPH
	{0xE2DE,	0x7611},	// CJK UNIFIED IDEOGRAPH
	{0xE2DF,	0x760A},	// CJK UNIFIED IDEOGRAPH
	{0xE2E0,	0x7614},	// CJK UNIFIED IDEOGRAPH
	{0xE2E1,	0x76B8},	// CJK UNIFIED IDEOGRAPH
	{0xE2E2,	0x7781},	// CJK UNIFIED IDEOGRAPH
	{0xE2E3,	0x777C},	// CJK UNIFIED IDEOGRAPH
	{0xE2E4,	0x7785},	// CJK UNIFIED IDEOGRAPH
	{0xE2E5,	0x7782},	// CJK UNIFIED IDEOGRAPH
	{0xE2E6,	0x776E},	// CJK UNIFIED IDEOGRAPH
	{0xE2E7,	0x7780},	// CJK UNIFIED IDEOGRAPH
	{0xE2E8,	0x776F},	// CJK UNIFIED IDEOGRAPH
	{0xE2E9,	0x777E},	// CJK UNIFIED IDEOGRAPH
	{0xE2EA,	0x7783},	// CJK UNIFIED IDEOGRAPH
	{0xE2EB,	0x78B2},	// CJK UNIFIED IDEOGRAPH
	{0xE2EC,	0x78AA},	// CJK UNIFIED IDEOGRAPH
	{0xE2ED,	0x78B4},	// CJK UNIFIED IDEOGRAPH
	{0xE2EE,	0x78AD},	// CJK UNIFIED IDEOGRAPH
	{0xE2EF,	0x78A8},	// CJK UNIFIED IDEOGRAPH
	{0xE2F0,	0x787E},	// CJK UNIFIED IDEOGRAPH
	{0xE2F1,	0x78AB},	// CJK UNIFIED IDEOGRAPH
	{0xE2F2,	0x789E},	// CJK UNIFIED IDEOGRAPH
	{0xE2F3,	0x78A5},	// CJK UNIFIED IDEOGRAPH
	{0xE2F4,	0x78A0},	// CJK UNIFIED IDEOGRAPH
	{0xE2F5,	0x78AC},	// CJK UNIFIED IDEOGRAPH
	{0xE2F6,	0x78A2},	// CJK UNIFIED IDEOGRAPH
	{0xE2F7,	0x78A4},	// CJK UNIFIED IDEOGRAPH
	{0xE2F8,	0x7998},	// CJK UNIFIED IDEOGRAPH
	{0xE2F9,	0x798A},	// CJK UNIFIED IDEOGRAPH
	{0xE2FA,	0x798B},	// CJK UNIFIED IDEOGRAPH
	{0xE2FB,	0x7996},	// CJK UNIFIED IDEOGRAPH
	{0xE2FC,	0x7995},	// CJK UNIFIED IDEOGRAPH
	{0xE2FD,	0x7994},	// CJK UNIFIED IDEOGRAPH
	{0xE2FE,	0x7993},	// CJK UNIFIED IDEOGRAPH
	{0xE340,	0x7997},	// CJK UNIFIED IDEOGRAPH
	{0xE341,	0x7988},	// CJK UNIFIED IDEOGRAPH
	{0xE342,	0x7992},	// CJK UNIFIED IDEOGRAPH
	{0xE343,	0x7990},	// CJK UNIFIED IDEOGRAPH
	{0xE344,	0x7A2B},	// CJK UNIFIED IDEOGRAPH
	{0xE345,	0x7A4A},	// CJK UNIFIED IDEOGRAPH
	{0xE346,	0x7A30},	// CJK UNIFIED IDEOGRAPH
	{0xE347,	0x7A2F},	// CJK UNIFIED IDEOGRAPH
	{0xE348,	0x7A28},	// CJK UNIFIED IDEOGRAPH
	{0xE349,	0x7A26},	// CJK UNIFIED IDEOGRAPH
	{0xE34A,	0x7AA8},	// CJK UNIFIED IDEOGRAPH
	{0xE34B,	0x7AAB},	// CJK UNIFIED IDEOGRAPH
	{0xE34C,	0x7AAC},	// CJK UNIFIED IDEOGRAPH
	{0xE34D,	0x7AEE},	// CJK UNIFIED IDEOGRAPH
	{0xE34E,	0x7B88},	// CJK UNIFIED IDEOGRAPH
	{0xE34F,	0x7B9C},	// CJK UNIFIED IDEOGRAPH
	{0xE350,	0x7B8A},	// CJK UNIFIED IDEOGRAPH
	{0xE351,	0x7B91},	// CJK UNIFIED IDEOGRAPH
	{0xE352,	0x7B90},	// CJK UNIFIED IDEOGRAPH
	{0xE353,	0x7B96},	// CJK UNIFIED IDEOGRAPH
	{0xE354,	0x7B8D},	// CJK UNIFIED IDEOGRAPH
	{0xE355,	0x7B8C},	// CJK UNIFIED IDEOGRAPH
	{0xE356,	0x7B9B},	// CJK UNIFIED IDEOGRAPH
	{0xE357,	0x7B8E},	// CJK UNIFIED IDEOGRAPH
	{0xE358,	0x7B85},	// CJK UNIFIED IDEOGRAPH
	{0xE359,	0x7B98},	// CJK UNIFIED IDEOGRAPH
	{0xE35A,	0x5284},	// CJK UNIFIED IDEOGRAPH
	{0xE35B,	0x7B99},	// CJK UNIFIED IDEOGRAPH
	{0xE35C,	0x7BA4},	// CJK UNIFIED IDEOGRAPH
	{0xE35D,	0x7B82},	// CJK UNIFIED IDEOGRAPH
	{0xE35E,	0x7CBB},	// CJK UNIFIED IDEOGRAPH
	{0xE35F,	0x7CBF},	// CJK UNIFIED IDEOGRAPH
	{0xE360,	0x7CBC},	// CJK UNIFIED IDEOGRAPH
	{0xE361,	0x7CBA},	// CJK UNIFIED IDEOGRAPH
	{0xE362,	0x7DA7},	// CJK UNIFIED IDEOGRAPH
	{0xE363,	0x7DB7},	// CJK UNIFIED IDEOGRAPH
	{0xE364,	0x7DC2},	// CJK UNIFIED IDEOGRAPH
	{0xE365,	0x7DA3},	// CJK UNIFIED IDEOGRAPH
	{0xE366,	0x7DAA},	// CJK UNIFIED IDEOGRAPH
	{0xE367,	0x7DC1},	// CJK UNIFIED IDEOGRAPH
	{0xE368,	0x7DC0},	// CJK UNIFIED IDEOGRAPH
	{0xE369,	0x7DC5},	// CJK UNIFIED IDEOGRAPH
	{0xE36A,	0x7D9D},	// CJK UNIFIED IDEOGRAPH
	{0xE36B,	0x7DCE},	// CJK UNIFIED IDEOGRAPH
	{0xE36C,	0x7DC4},	// CJK UNIFIED IDEOGRAPH
	{0xE36D,	0x7DC6},	// CJK UNIFIED IDEOGRAPH
	{0xE36E,	0x7DCB},	// CJK UNIFIED IDEOGRAPH
	{0xE36F,	0x7DCC},	// CJK UNIFIED IDEOGRAPH
	{0xE370,	0x7DAF},	// CJK UNIFIED IDEOGRAPH
	{0xE371,	0x7DB9},	// CJK UNIFIED IDEOGRAPH
	{0xE372,	0x7D96},	// CJK UNIFIED IDEOGRAPH
	{0xE373,	0x7DBC},	// CJK UNIFIED IDEOGRAPH
	{0xE374,	0x7D9F},	// CJK UNIFIED IDEOGRAPH
	{0xE375,	0x7DA6},	// CJK UNIFIED IDEOGRAPH
	{0xE376,	0x7DAE},	// CJK UNIFIED IDEOGRAPH
	{0xE377,	0x7DA9},	// CJK UNIFIED IDEOGRAPH
	{0xE378,	0x7DA1},	// CJK UNIFIED IDEOGRAPH
	{0xE379,	0x7DC9},	// CJK UNIFIED IDEOGRAPH
	{0xE37A,	0x7F73},	// CJK UNIFIED IDEOGRAPH
	{0xE37B,	0x7FE2},	// CJK UNIFIED IDEOGRAPH
	{0xE37C,	0x7FE3},	// CJK UNIFIED IDEOGRAPH
	{0xE37D,	0x7FE5},	// CJK UNIFIED IDEOGRAPH
	{0xE37E,	0x7FDE},	// CJK UNIFIED IDEOGRAPH
	{0xE3A1,	0x8024},	// CJK UNIFIED IDEOGRAPH
	{0xE3A2,	0x805D},	// CJK UNIFIED IDEOGRAPH
	{0xE3A3,	0x805C},	// CJK UNIFIED IDEOGRAPH
	{0xE3A4,	0x8189},	// CJK UNIFIED IDEOGRAPH
	{0xE3A5,	0x8186},	// CJK UNIFIED IDEOGRAPH
	{0xE3A6,	0x8183},	// CJK UNIFIED IDEOGRAPH
	{0xE3A7,	0x8187},	// CJK UNIFIED IDEOGRAPH
	{0xE3A8,	0x818D},	// CJK UNIFIED IDEOGRAPH
	{0xE3A9,	0x818C},	// CJK UNIFIED IDEOGRAPH
	{0xE3AA,	0x818B},	// CJK UNIFIED IDEOGRAPH
	{0xE3AB,	0x8215},	// CJK UNIFIED IDEOGRAPH
	{0xE3AC,	0x8497},	// CJK UNIFIED IDEOGRAPH
	{0xE3AD,	0x84A4},	// CJK UNIFIED IDEOGRAPH
	{0xE3AE,	0x84A1},	// CJK UNIFIED IDEOGRAPH
	{0xE3AF,	0x849F},	// CJK UNIFIED IDEOGRAPH
	{0xE3B0,	0x84BA},	// CJK UNIFIED IDEOGRAPH
	{0xE3B1,	0x84CE},	// CJK UNIFIED IDEOGRAPH
	{0xE3B2,	0x84C2},	// CJK UNIFIED IDEOGRAPH
	{0xE3B3,	0x84AC},	// CJK UNIFIED IDEOGRAPH
	{0xE3B4,	0x84AE},	// CJK UNIFIED IDEOGRAPH
	{0xE3B5,	0x84AB},	// CJK UNIFIED IDEOGRAPH
	{0xE3B6,	0x84B9},	// CJK UNIFIED IDEOGRAPH
	{0xE3B7,	0x84B4},	// CJK UNIFIED IDEOGRAPH
	{0xE3B8,	0x84C1},	// CJK UNIFIED IDEOGRAPH
	{0xE3B9,	0x84CD},	// CJK UNIFIED IDEOGRAPH
	{0xE3BA,	0x84AA},	// CJK UNIFIED IDEOGRAPH
	{0xE3BB,	0x849A},	// CJK UNIFIED IDEOGRAPH
	{0xE3BC,	0x84B1},	// CJK UNIFIED IDEOGRAPH
	{0xE3BD,	0x84D0},	// CJK UNIFIED IDEOGRAPH
	{0xE3BE,	0x849D},	// CJK UNIFIED IDEOGRAPH
	{0xE3BF,	0x84A7},	// CJK UNIFIED IDEOGRAPH
	{0xE3C0,	0x84BB},	// CJK UNIFIED IDEOGRAPH
	{0xE3C1,	0x84A2},	// CJK UNIFIED IDEOGRAPH
	{0xE3C2,	0x8494},	// CJK UNIFIED IDEOGRAPH
	{0xE3C3,	0x84C7},	// CJK UNIFIED IDEOGRAPH
	{0xE3C4,	0x84CC},	// CJK UNIFIED IDEOGRAPH
	{0xE3C5,	0x849B},	// CJK UNIFIED IDEOGRAPH
	{0xE3C6,	0x84A9},	// CJK UNIFIED IDEOGRAPH
	{0xE3C7,	0x84AF},	// CJK UNIFIED IDEOGRAPH
	{0xE3C8,	0x84A8},	// CJK UNIFIED IDEOGRAPH
	{0xE3C9,	0x84D6},	// CJK UNIFIED IDEOGRAPH
	{0xE3CA,	0x8498},	// CJK UNIFIED IDEOGRAPH
	{0xE3CB,	0x84B6},	// CJK UNIFIED IDEOGRAPH
	{0xE3CC,	0x84CF},	// CJK UNIFIED IDEOGRAPH
	{0xE3CD,	0x84A0},	// CJK UNIFIED IDEOGRAPH
	{0xE3CE,	0x84D7},	// CJK UNIFIED IDEOGRAPH
	{0xE3CF,	0x84D4},	// CJK UNIFIED IDEOGRAPH
	{0xE3D0,	0x84D2},	// CJK UNIFIED IDEOGRAPH
	{0xE3D1,	0x84DB},	// CJK UNIFIED IDEOGRAPH
	{0xE3D2,	0x84B0},	// CJK UNIFIED IDEOGRAPH
	{0xE3D3,	0x8491},	// CJK UNIFIED IDEOGRAPH
	{0xE3D4,	0x8661},	// CJK UNIFIED IDEOGRAPH
	{0xE3D5,	0x8733},	// CJK UNIFIED IDEOGRAPH
	{0xE3D6,	0x8723},	// CJK UNIFIED IDEOGRAPH
	{0xE3D7,	0x8728},	// CJK UNIFIED IDEOGRAPH
	{0xE3D8,	0x876B},	// CJK UNIFIED IDEOGRAPH
	{0xE3D9,	0x8740},	// CJK UNIFIED IDEOGRAPH
	{0xE3DA,	0x872E},	// CJK UNIFIED IDEOGRAPH
	{0xE3DB,	0x871E},	// CJK UNIFIED IDEOGRAPH
	{0xE3DC,	0x8721},	// CJK UNIFIED IDEOGRAPH
	{0xE3DD,	0x8719},	// CJK UNIFIED IDEOGRAPH
	{0xE3DE,	0x871B},	// CJK UNIFIED IDEOGRAPH
	{0xE3DF,	0x8743},	// CJK UNIFIED IDEOGRAPH
	{0xE3E0,	0x872C},	// CJK UNIFIED IDEOGRAPH
	{0xE3E1,	0x8741},	// CJK UNIFIED IDEOGRAPH
	{0xE3E2,	0x873E},	// CJK UNIFIED IDEOGRAPH
	{0xE3E3,	0x8746},	// CJK UNIFIED IDEOGRAPH
	{0xE3E4,	0x8720},	// CJK UNIFIED IDEOGRAPH
	{0xE3E5,	0x8732},	// CJK UNIFIED IDEOGRAPH
	{0xE3E6,	0x872A},	// CJK UNIFIED IDEOGRAPH
	{0xE3E7,	0x872D},	// CJK UNIFIED IDEOGRAPH
	{0xE3E8,	0x873C},	// CJK UNIFIED IDEOGRAPH
	{0xE3E9,	0x8712},	// CJK UNIFIED IDEOGRAPH
	{0xE3EA,	0x873A},	// CJK UNIFIED IDEOGRAPH
	{0xE3EB,	0x8731},	// CJK UNIFIED IDEOGRAPH
	{0xE3EC,	0x8735},	// CJK UNIFIED IDEOGRAPH
	{0xE3ED,	0x8742},	// CJK UNIFIED IDEOGRAPH
	{0xE3EE,	0x8726},	// CJK UNIFIED IDEOGRAPH
	{0xE3EF,	0x8727},	// CJK UNIFIED IDEOGRAPH
	{0xE3F0,	0x8738},	// CJK UNIFIED IDEOGRAPH
	{0xE3F1,	0x8724},	// CJK UNIFIED IDEOGRAPH
	{0xE3F2,	0x871A},	// CJK UNIFIED IDEOGRAPH
	{0xE3F3,	0x8730},	// CJK UNIFIED IDEOGRAPH
	{0xE3F4,	0x8711},	// CJK UNIFIED IDEOGRAPH
	{0xE3F5,	0x88F7},	// CJK UNIFIED IDEOGRAPH
	{0xE3F6,	0x88E7},	// CJK UNIFIED IDEOGRAPH
	{0xE3F7,	0x88F1},	// CJK UNIFIED IDEOGRAPH
	{0xE3F8,	0x88F2},	// CJK UNIFIED IDEOGRAPH
	{0xE3F9,	0x88FA},	// CJK UNIFIED IDEOGRAPH
	{0xE3FA,	0x88FE},	// CJK UNIFIED IDEOGRAPH
	{0xE3FB,	0x88EE},	// CJK UNIFIED IDEOGRAPH
	{0xE3FC,	0x88FC},	// CJK UNIFIED IDEOGRAPH
	{0xE3FD,	0x88F6},	// CJK UNIFIED IDEOGRAPH
	{0xE3FE,	0x88FB},	// CJK UNIFIED IDEOGRAPH
	{0xE440,	0x88F0},	// CJK UNIFIED IDEOGRAPH
	{0xE441,	0x88EC},	// CJK UNIFIED IDEOGRAPH
	{0xE442,	0x88EB},	// CJK UNIFIED IDEOGRAPH
	{0xE443,	0x899D},	// CJK UNIFIED IDEOGRAPH
	{0xE444,	0x89A1},	// CJK UNIFIED IDEOGRAPH
	{0xE445,	0x899F},	// CJK UNIFIED IDEOGRAPH
	{0xE446,	0x899E},	// CJK UNIFIED IDEOGRAPH
	{0xE447,	0x89E9},	// CJK UNIFIED IDEOGRAPH
	{0xE448,	0x89EB},	// CJK UNIFIED IDEOGRAPH
	{0xE449,	0x89E8},	// CJK UNIFIED IDEOGRAPH
	{0xE44A,	0x8AAB},	// CJK UNIFIED IDEOGRAPH
	{0xE44B,	0x8A99},	// CJK UNIFIED IDEOGRAPH
	{0xE44C,	0x8A8B},	// CJK UNIFIED IDEOGRAPH
	{0xE44D,	0x8A92},	// CJK UNIFIED IDEOGRAPH
	{0xE44E,	0x8A8F},	// CJK UNIFIED IDEOGRAPH
	{0xE44F,	0x8A96},	// CJK UNIFIED IDEOGRAPH
	{0xE450,	0x8C3D},	// CJK UNIFIED IDEOGRAPH
	{0xE451,	0x8C68},	// CJK UNIFIED IDEOGRAPH
	{0xE452,	0x8C69},	// CJK UNIFIED IDEOGRAPH
	{0xE453,	0x8CD5},	// CJK UNIFIED IDEOGRAPH
	{0xE454,	0x8CCF},	// CJK UNIFIED IDEOGRAPH
	{0xE455,	0x8CD7},	// CJK UNIFIED IDEOGRAPH
	{0xE456,	0x8D96},	// CJK UNIFIED IDEOGRAPH
	{0xE457,	0x8E09},	// CJK UNIFIED IDEOGRAPH
	{0xE458,	0x8E02},	// CJK UNIFIED IDEOGRAPH
	{0xE459,	0x8DFF},	// CJK UNIFIED IDEOGRAPH
	{0xE45A,	0x8E0D},	// CJK UNIFIED IDEOGRAPH
	{0xE45B,	0x8DFD},	// CJK UNIFIED IDEOGRAPH
	{0xE45C,	0x8E0A},	// CJK UNIFIED IDEOGRAPH
	{0xE45D,	0x8E03},	// CJK UNIFIED IDEOGRAPH
	{0xE45E,	0x8E07},	// CJK UNIFIED IDEOGRAPH
	{0xE45F,	0x8E06},	// CJK UNIFIED IDEOGRAPH
	{0xE460,	0x8E05},	// CJK UNIFIED IDEOGRAPH
	{0xE461,	0x8DFE},	// CJK UNIFIED IDEOGRAPH
	{0xE462,	0x8E00},	// CJK UNIFIED IDEOGRAPH
	{0xE463,	0x8E04},	// CJK UNIFIED IDEOGRAPH
	{0xE464,	0x8F10},	// CJK UNIFIED IDEOGRAPH
	{0xE465,	0x8F11},	// CJK UNIFIED IDEOGRAPH
	{0xE466,	0x8F0E},	// CJK UNIFIED IDEOGRAPH
	{0xE467,	0x8F0D},	// CJK UNIFIED IDEOGRAPH
	{0xE468,	0x9123},	// CJK UNIFIED IDEOGRAPH
	{0xE469,	0x911C},	// CJK UNIFIED IDEOGRAPH
	{0xE46A,	0x9120},	// CJK UNIFIED IDEOGRAPH
	{0xE46B,	0x9122},	// CJK UNIFIED IDEOGRAPH
	{0xE46C,	0x911F},	// CJK UNIFIED IDEOGRAPH
	{0xE46D,	0x911D},	// CJK UNIFIED IDEOGRAPH
	{0xE46E,	0x911A},	// CJK UNIFIED IDEOGRAPH
	{0xE46F,	0x9124},	// CJK UNIFIED IDEOGRAPH
	{0xE470,	0x9121},	// CJK UNIFIED IDEOGRAPH
	{0xE471,	0x911B},	// CJK UNIFIED IDEOGRAPH
	{0xE472,	0x917A},	// CJK UNIFIED IDEOGRAPH
	{0xE473,	0x9172},	// CJK UNIFIED IDEOGRAPH
	{0xE474,	0x9179},	// CJK UNIFIED IDEOGRAPH
	{0xE475,	0x9173},	// CJK UNIFIED IDEOGRAPH
	{0xE476,	0x92A5},	// CJK UNIFIED IDEOGRAPH
	{0xE477,	0x92A4},	// CJK UNIFIED IDEOGRAPH
	{0xE478,	0x9276},	// CJK UNIFIED IDEOGRAPH
	{0xE479,	0x929B},	// CJK UNIFIED IDEOGRAPH
	{0xE47A,	0x927A},	// CJK UNIFIED IDEOGRAPH
	{0xE47B,	0x92A0},	// CJK UNIFIED IDEOGRAPH
	{0xE47C,	0x9294},	// CJK UNIFIED IDEOGRAPH
	{0xE47D,	0x92AA},	// CJK UNIFIED IDEOGRAPH
	{0xE47E,	0x928D},	// CJK UNIFIED IDEOGRAPH
	{0xE4A1,	0x92A6},	// CJK UNIFIED IDEOGRAPH
	{0xE4A2,	0x929A},	// CJK UNIFIED IDEOGRAPH
	{0xE4A3,	0x92AB},	// CJK UNIFIED IDEOGRAPH
	{0xE4A4,	0x9279},	// CJK UNIFIED IDEOGRAPH
	{0xE4A5,	0x9297},	// CJK UNIFIED IDEOGRAPH
	{0xE4A6,	0x927F},	// CJK UNIFIED IDEOGRAPH
	{0xE4A7,	0x92A3},	// CJK UNIFIED IDEOGRAPH
	{0xE4A8,	0x92EE},	// CJK UNIFIED IDEOGRAPH
	{0xE4A9,	0x928E},	// CJK UNIFIED IDEOGRAPH
	{0xE4AA,	0x9282},	// CJK UNIFIED IDEOGRAPH
	{0xE4AB,	0x9295},	// CJK UNIFIED IDEOGRAPH
	{0xE4AC,	0x92A2},	// CJK UNIFIED IDEOGRAPH
	{0xE4AD,	0x927D},	// CJK UNIFIED IDEOGRAPH
	{0xE4AE,	0x9288},	// CJK UNIFIED IDEOGRAPH
	{0xE4AF,	0x92A1},	// CJK UNIFIED IDEOGRAPH
	{0xE4B0,	0x928A},	// CJK UNIFIED IDEOGRAPH
	{0xE4B1,	0x9286},	// CJK UNIFIED IDEOGRAPH
	{0xE4B2,	0x928C},	// CJK UNIFIED IDEOGRAPH
	{0xE4B3,	0x9299},	// CJK UNIFIED IDEOGRAPH
	{0xE4B4,	0x92A7},	// CJK UNIFIED IDEOGRAPH
	{0xE4B5,	0x927E},	// CJK UNIFIED IDEOGRAPH
	{0xE4B6,	0x9287},	// CJK UNIFIED IDEOGRAPH
	{0xE4B7,	0x92A9},	// CJK UNIFIED IDEOGRAPH
	{0xE4B8,	0x929D},	// CJK UNIFIED IDEOGRAPH
	{0xE4B9,	0x928B},	// CJK UNIFIED IDEOGRAPH
	{0xE4BA,	0x922D},	// CJK UNIFIED IDEOGRAPH
	{0xE4BB,	0x969E},	// CJK UNIFIED IDEOGRAPH
	{0xE4BC,	0x96A1},	// CJK UNIFIED IDEOGRAPH
	{0xE4BD,	0x96FF},	// CJK UNIFIED IDEOGRAPH
	{0xE4BE,	0x9758},	// CJK UNIFIED IDEOGRAPH
	{0xE4BF,	0x977D},	// CJK UNIFIED IDEOGRAPH
	{0xE4C0,	0x977A},	// CJK UNIFIED IDEOGRAPH
	{0xE4C1,	0x977E},	// CJK UNIFIED IDEOGRAPH
	{0xE4C2,	0x9783},	// CJK UNIFIED IDEOGRAPH
	{0xE4C3,	0x9780},	// CJK UNIFIED IDEOGRAPH
	{0xE4C4,	0x9782},	// CJK UNIFIED IDEOGRAPH
	{0xE4C5,	0x977B},	// CJK UNIFIED IDEOGRAPH
	{0xE4C6,	0x9784},	// CJK UNIFIED IDEOGRAPH
	{0xE4C7,	0x9781},	// CJK UNIFIED IDEOGRAPH
	{0xE4C8,	0x977F},	// CJK UNIFIED IDEOGRAPH
	{0xE4C9,	0x97CE},	// CJK UNIFIED IDEOGRAPH
	{0xE4CA,	0x97CD},	// CJK UNIFIED IDEOGRAPH
	{0xE4CB,	0x9816},	// CJK UNIFIED IDEOGRAPH
	{0xE4CC,	0x98AD},	// CJK UNIFIED IDEOGRAPH
	{0xE4CD,	0x98AE},	// CJK UNIFIED IDEOGRAPH
	{0xE4CE,	0x9902},	// CJK UNIFIED IDEOGRAPH
	{0xE4CF,	0x9900},	// CJK UNIFIED IDEOGRAPH
	{0xE4D0,	0x9907},	// CJK UNIFIED IDEOGRAPH
	{0xE4D1,	0x999D},	// CJK UNIFIED IDEOGRAPH
	{0xE4D2,	0x999C},	// CJK UNIFIED IDEOGRAPH
	{0xE4D3,	0x99C3},	// CJK UNIFIED IDEOGRAPH
	{0xE4D4,	0x99B9},	// CJK UNIFIED IDEOGRAPH
	{0xE4D5,	0x99BB},	// CJK UNIFIED IDEOGRAPH
	{0xE4D6,	0x99BA},	// CJK UNIFIED IDEOGRAPH
	{0xE4D7,	0x99C2},	// CJK UNIFIED IDEOGRAPH
	{0xE4D8,	0x99BD},	// CJK UNIFIED IDEOGRAPH
	{0xE4D9,	0x99C7},	// CJK UNIFIED IDEOGRAPH
	{0xE4DA,	0x9AB1},	// CJK UNIFIED IDEOGRAPH
	{0xE4DB,	0x9AE3},	// CJK UNIFIED IDEOGRAPH
	{0xE4DC,	0x9AE7},	// CJK UNIFIED IDEOGRAPH
	{0xE4DD,	0x9B3E},	// CJK UNIFIED IDEOGRAPH
	{0xE4DE,	0x9B3F},	// CJK UNIFIED IDEOGRAPH
	{0xE4DF,	0x9B60},	// CJK UNIFIED IDEOGRAPH
	{0xE4E0,	0x9B61},	// CJK UNIFIED IDEOGRAPH
	{0xE4E1,	0x9B5F},	// CJK UNIFIED IDEOGRAPH
	{0xE4E2,	0x9CF1},	// CJK UNIFIED IDEOGRAPH
	{0xE4E3,	0x9CF2},	// CJK UNIFIED IDEOGRAPH
	{0xE4E4,	0x9CF5},	// CJK UNIFIED IDEOGRAPH
	{0xE4E5,	0x9EA7},	// CJK UNIFIED IDEOGRAPH
	{0xE4E6,	0x50FF},	// CJK UNIFIED IDEOGRAPH
	{0xE4E7,	0x5103},	// CJK UNIFIED IDEOGRAPH
	{0xE4E8,	0x5130},	// CJK UNIFIED IDEOGRAPH
	{0xE4E9,	0x50F8},	// CJK UNIFIED IDEOGRAPH
	{0xE4EA,	0x5106},	// CJK UNIFIED IDEOGRAPH
	{0xE4EB,	0x5107},	// CJK UNIFIED IDEOGRAPH
	{0xE4EC,	0x50F6},	// CJK UNIFIED IDEOGRAPH
	{0xE4ED,	0x50FE},	// CJK UNIFIED IDEOGRAPH
	{0xE4EE,	0x510B},	// CJK UNIFIED IDEOGRAPH
	{0xE4EF,	0x510C},	// CJK UNIFIED IDEOGRAPH
	{0xE4F0,	0x50FD},	// CJK UNIFIED IDEOGRAPH
	{0xE4F1,	0x510A},	// CJK UNIFIED IDEOGRAPH
	{0xE4F2,	0x528B},	// CJK UNIFIED IDEOGRAPH
	{0xE4F3,	0x528C},	// CJK UNIFIED IDEOGRAPH
	{0xE4F4,	0x52F1},	// CJK UNIFIED IDEOGRAPH
	{0xE4F5,	0x52EF},	// CJK UNIFIED IDEOGRAPH
	{0xE4F6,	0x5648},	// CJK UNIFIED IDEOGRAPH
	{0xE4F7,	0x5642},	// CJK UNIFIED IDEOGRAPH
	{0xE4F8,	0x564C},	// CJK UNIFIED IDEOGRAPH
	{0xE4F9,	0x5635},	// CJK UNIFIED IDEOGRAPH
	{0xE4FA,	0x5641},	// CJK UNIFIED IDEOGRAPH
	{0xE4FB,	0x564A},	// CJK UNIFIED IDEOGRAPH
	{0xE4FC,	0x5649},	// CJK UNIFIED IDEOGRAPH
	{0xE4FD,	0x5646},	// CJK UNIFIED IDEOGRAPH
	{0xE4FE,	0x5658},	// CJK UNIFIED IDEOGRAPH
	{0xE540,	0x565A},	// CJK UNIFIED IDEOGRAPH
	{0xE541,	0x5640},	// CJK UNIFIED IDEOGRAPH
	{0xE542,	0x5633},	// CJK UNIFIED IDEOGRAPH
	{0xE543,	0x563D},	// CJK UNIFIED IDEOGRAPH
	{0xE544,	0x562C},	// CJK UNIFIED IDEOGRAPH
	{0xE545,	0x563E},	// CJK UNIFIED IDEOGRAPH
	{0xE546,	0x5638},	// CJK UNIFIED IDEOGRAPH
	{0xE547,	0x562A},	// CJK UNIFIED IDEOGRAPH
	{0xE548,	0x563A},	// CJK UNIFIED IDEOGRAPH
	{0xE549,	0x571A},	// CJK UNIFIED IDEOGRAPH
	{0xE54A,	0x58AB},	// CJK UNIFIED IDEOGRAPH
	{0xE54B,	0x589D},	// CJK UNIFIED IDEOGRAPH
	{0xE54C,	0x58B1},	// CJK UNIFIED IDEOGRAPH
	{0xE54D,	0x58A0},	// CJK UNIFIED IDEOGRAPH
	{0xE54E,	0x58A3},	// CJK UNIFIED IDEOGRAPH
	{0xE54F,	0x58AF},	// CJK UNIFIED IDEOGRAPH
	{0xE550,	0x58AC},	// CJK UNIFIED IDEOGRAPH
	{0xE551,	0x58A5},	// CJK UNIFIED IDEOGRAPH
	{0xE552,	0x58A1},	// CJK UNIFIED IDEOGRAPH
	{0xE553,	0x58FF},	// CJK UNIFIED IDEOGRAPH
	{0xE554,	0x5AFF},	// CJK UNIFIED IDEOGRAPH
	{0xE555,	0x5AF4},	// CJK UNIFIED IDEOGRAPH
	{0xE556,	0x5AFD},	// CJK UNIFIED IDEOGRAPH
	{0xE557,	0x5AF7},	// CJK UNIFIED IDEOGRAPH
	{0xE558,	0x5AF6},	// CJK UNIFIED IDEOGRAPH
	{0xE559,	0x5B03},	// CJK UNIFIED IDEOGRAPH
	{0xE55A,	0x5AF8},	// CJK UNIFIED IDEOGRAPH
	{0xE55B,	0x5B02},	// CJK UNIFIED IDEOGRAPH
	{0xE55C,	0x5AF9},	// CJK UNIFIED IDEOGRAPH
	{0xE55D,	0x5B01},	// CJK UNIFIED IDEOGRAPH
	{0xE55E,	0x5B07},	// CJK UNIFIED IDEOGRAPH
	{0xE55F,	0x5B05},	// CJK UNIFIED IDEOGRAPH
	{0xE560,	0x5B0F},	// CJK UNIFIED IDEOGRAPH
	{0xE561,	0x5C67},	// CJK UNIFIED IDEOGRAPH
	{0xE562,	0x5D99},	// CJK UNIFIED IDEOGRAPH
	{0xE563,	0x5D97},	// CJK UNIFIED IDEOGRAPH
	{0xE564,	0x5D9F},	// CJK UNIFIED IDEOGRAPH
	{0xE565,	0x5D92},	// CJK UNIFIED IDEOGRAPH
	{0xE566,	0x5DA2},	// CJK UNIFIED IDEOGRAPH
	{0xE567,	0x5D93},	// CJK UNIFIED IDEOGRAPH
	{0xE568,	0x5D95},	// CJK UNIFIED IDEOGRAPH
	{0xE569,	0x5DA0},	// CJK UNIFIED IDEOGRAPH
	{0xE56A,	0x5D9C},	// CJK UNIFIED IDEOGRAPH
	{0xE56B,	0x5DA1},	// CJK UNIFIED IDEOGRAPH
	{0xE56C,	0x5D9A},	// CJK UNIFIED IDEOGRAPH
	{0xE56D,	0x5D9E},	// CJK UNIFIED IDEOGRAPH
	{0xE56E,	0x5E69},	// CJK UNIFIED IDEOGRAPH
	{0xE56F,	0x5E5D},	// CJK UNIFIED IDEOGRAPH
	{0xE570,	0x5E60},	// CJK UNIFIED IDEOGRAPH
	{0xE571,	0x5E5C},	// CJK UNIFIED IDEOGRAPH
	{0xE572,	0x7DF3},	// CJK UNIFIED IDEOGRAPH
	{0xE573,	0x5EDB},	// CJK UNIFIED IDEOGRAPH
	{0xE574,	0x5EDE},	// CJK UNIFIED IDEOGRAPH
	{0xE575,	0x5EE1},	// CJK UNIFIED IDEOGRAPH
	{0xE576,	0x5F49},	// CJK UNIFIED IDEOGRAPH
	{0xE577,	0x5FB2},	// CJK UNIFIED IDEOGRAPH
	{0xE578,	0x618B},	// CJK UNIFIED IDEOGRAPH
	{0xE579,	0x6183},	// CJK UNIFIED IDEOGRAPH
	{0xE57A,	0x6179},	// CJK UNIFIED IDEOGRAPH
	{0xE57B,	0x61B1},	// CJK UNIFIED IDEOGRAPH
	{0xE57C,	0x61B0},	// CJK UNIFIED IDEOGRAPH
	{0xE57D,	0x61A2},	// CJK UNIFIED IDEOGRAPH
	{0xE57E,	0x6189},	// CJK UNIFIED IDEOGRAPH
	{0xE5A1,	0x619B},	// CJK UNIFIED IDEOGRAPH
	{0xE5A2,	0x6193},	// CJK UNIFIED IDEOGRAPH
	{0xE5A3,	0x61AF},	// CJK UNIFIED IDEOGRAPH
	{0xE5A4,	0x61AD},	// CJK UNIFIED IDEOGRAPH
	{0xE5A5,	0x619F},	// CJK UNIFIED IDEOGRAPH
	{0xE5A6,	0x6192},	// CJK UNIFIED IDEOGRAPH
	{0xE5A7,	0x61AA},	// CJK UNIFIED IDEOGRAPH
	{0xE5A8,	0x61A1},	// CJK UNIFIED IDEOGRAPH
	{0xE5A9,	0x618D},	// CJK UNIFIED IDEOGRAPH
	{0xE5AA,	0x6166},	// CJK UNIFIED IDEOGRAPH
	{0xE5AB,	0x61B3},	// CJK UNIFIED IDEOGRAPH
	{0xE5AC,	0x622D},	// CJK UNIFIED IDEOGRAPH
	{0xE5AD,	0x646E},	// CJK UNIFIED IDEOGRAPH
	{0xE5AE,	0x6470},	// CJK UNIFIED IDEOGRAPH
	{0xE5AF,	0x6496},	// CJK UNIFIED IDEOGRAPH
	{0xE5B0,	0x64A0},	// CJK UNIFIED IDEOGRAPH
	{0xE5B1,	0x6485},	// CJK UNIFIED IDEOGRAPH
	{0xE5B2,	0x6497},	// CJK UNIFIED IDEOGRAPH
	{0xE5B3,	0x649C},	// CJK UNIFIED IDEOGRAPH
	{0xE5B4,	0x648F},	// CJK UNIFIED IDEOGRAPH
	{0xE5B5,	0x648B},	// CJK UNIFIED IDEOGRAPH
	{0xE5B6,	0x648A},	// CJK UNIFIED IDEOGRAPH
	{0xE5B7,	0x648C},	// CJK UNIFIED IDEOGRAPH
	{0xE5B8,	0x64A3},	// CJK UNIFIED IDEOGRAPH
	{0xE5B9,	0x649F},	// CJK UNIFIED IDEOGRAPH
	{0xE5BA,	0x6468},	// CJK UNIFIED IDEOGRAPH
	{0xE5BB,	0x64B1},	// CJK UNIFIED IDEOGRAPH
	{0xE5BC,	0x6498},	// CJK UNIFIED IDEOGRAPH
	{0xE5BD,	0x6576},	// CJK UNIFIED IDEOGRAPH
	{0xE5BE,	0x657A},	// CJK UNIFIED IDEOGRAPH
	{0xE5BF,	0x6579},	// CJK UNIFIED IDEOGRAPH
	{0xE5C0,	0x657B},	// CJK UNIFIED IDEOGRAPH
	{0xE5C1,	0x65B2},	// CJK UNIFIED IDEOGRAPH
	{0xE5C2,	0x65B3},	// CJK UNIFIED IDEOGRAPH
	{0xE5C3,	0x66B5},	// CJK UNIFIED IDEOGRAPH
	{0xE5C4,	0x66B0},	// CJK UNIFIED IDEOGRAPH
	{0xE5C5,	0x66A9},	// CJK UNIFIED IDEOGRAPH
	{0xE5C6,	0x66B2},	// CJK UNIFIED IDEOGRAPH
	{0xE5C7,	0x66B7},	// CJK UNIFIED IDEOGRAPH
	{0xE5C8,	0x66AA},	// CJK UNIFIED IDEOGRAPH
	{0xE5C9,	0x66AF},	// CJK UNIFIED IDEOGRAPH
	{0xE5CA,	0x6A00},	// CJK UNIFIED IDEOGRAPH
	{0xE5CB,	0x6A06},	// CJK UNIFIED IDEOGRAPH
	{0xE5CC,	0x6A17},	// CJK UNIFIED IDEOGRAPH
	{0xE5CD,	0x69E5},	// CJK UNIFIED IDEOGRAPH
	{0xE5CE,	0x69F8},	// CJK UNIFIED IDEOGRAPH
	{0xE5CF,	0x6A15},	// CJK UNIFIED IDEOGRAPH
	{0xE5D0,	0x69F1},	// CJK UNIFIED IDEOGRAPH
	{0xE5D1,	0x69E4},	// CJK UNIFIED IDEOGRAPH
	{0xE5D2,	0x6A20},	// CJK UNIFIED IDEOGRAPH
	{0xE5D3,	0x69FF},	// CJK UNIFIED IDEOGRAPH
	{0xE5D4,	0x69EC},	// CJK UNIFIED IDEOGRAPH
	{0xE5D5,	0x69E2},	// CJK UNIFIED IDEOGRAPH
	{0xE5D6,	0x6A1B},	// CJK UNIFIED IDEOGRAPH
	{0xE5D7,	0x6A1D},	// CJK UNIFIED IDEOGRAPH
	{0xE5D8,	0x69FE},	// CJK UNIFIED IDEOGRAPH
	{0xE5D9,	0x6A27},	// CJK UNIFIED IDEOGRAPH
	{0xE5DA,	0x69F2},	// CJK UNIFIED IDEOGRAPH
	{0xE5DB,	0x69EE},	// CJK UNIFIED IDEOGRAPH
	{0xE5DC,	0x6A14},	// CJK UNIFIED IDEOGRAPH
	{0xE5DD,	0x69F7},	// CJK UNIFIED IDEOGRAPH
	{0xE5DE,	0x69E7},	// CJK UNIFIED IDEOGRAPH
	{0xE5DF,	0x6A40},	// CJK UNIFIED IDEOGRAPH
	{0xE5E0,	0x6A08},	// CJK UNIFIED IDEOGRAPH
	{0xE5E1,	0x69E6},	// CJK UNIFIED IDEOGRAPH
	{0xE5E2,	0x69FB},	// CJK UNIFIED IDEOGRAPH
	{0xE5E3,	0x6A0D},	// CJK UNIFIED IDEOGRAPH
	{0xE5E4,	0x69FC},	// CJK UNIFIED IDEOGRAPH
	{0xE5E5,	0x69EB},	// CJK UNIFIED IDEOGRAPH
	{0xE5E6,	0x6A09},	// CJK UNIFIED IDEOGRAPH
	{0xE5E7,	0x6A04},	// CJK UNIFIED IDEOGRAPH
	{0xE5E8,	0x6A18},	// CJK UNIFIED IDEOGRAPH
	{0xE5E9,	0x6A25},	// CJK UNIFIED IDEOGRAPH
	{0xE5EA,	0x6A0F},	// CJK UNIFIED IDEOGRAPH
	{0xE5EB,	0x69F6},	// CJK UNIFIED IDEOGRAPH
	{0xE5EC,	0x6A26},	// CJK UNIFIED IDEOGRAPH
	{0xE5ED,	0x6A07},	// CJK UNIFIED IDEOGRAPH
	{0xE5EE,	0x69F4},	// CJK UNIFIED IDEOGRAPH
	{0xE5EF,	0x6A16},	// CJK UNIFIED IDEOGRAPH
	{0xE5F0,	0x6B51},	// CJK UNIFIED IDEOGRAPH
	{0xE5F1,	0x6BA5},	// CJK UNIFIED IDEOGRAPH
	{0xE5F2,	0x6BA3},	// CJK UNIFIED IDEOGRAPH
	{0xE5F3,	0x6BA2},	// CJK UNIFIED IDEOGRAPH
	{0xE5F4,	0x6BA6},	// CJK UNIFIED IDEOGRAPH
	{0xE5F5,	0x6C01},	// CJK UNIFIED IDEOGRAPH
	{0xE5F6,	0x6C00},	// CJK UNIFIED IDEOGRAPH
	{0xE5F7,	0x6BFF},	// CJK UNIFIED IDEOGRAPH
	{0xE5F8,	0x6C02},	// CJK UNIFIED IDEOGRAPH
	{0xE5F9,	0x6F41},	// CJK UNIFIED IDEOGRAPH
	{0xE5FA,	0x6F26},	// CJK UNIFIED IDEOGRAPH
	{0xE5FB,	0x6F7E},	// CJK UNIFIED IDEOGRAPH
	{0xE5FC,	0x6F87},	// CJK UNIFIED IDEOGRAPH
	{0xE5FD,	0x6FC6},	// CJK UNIFIED IDEOGRAPH
	{0xE5FE,	0x6F92},	// CJK UNIFIED IDEOGRAPH
	{0xE640,	0x6F8D},	// CJK UNIFIED IDEOGRAPH
	{0xE641,	0x6F89},	// CJK UNIFIED IDEOGRAPH
	{0xE642,	0x6F8C},	// CJK UNIFIED IDEOGRAPH
	{0xE643,	0x6F62},	// CJK UNIFIED IDEOGRAPH
	{0xE644,	0x6F4F},	// CJK UNIFIED IDEOGRAPH
	{0xE645,	0x6F85},	// CJK UNIFIED IDEOGRAPH
	{0xE646,	0x6F5A},	// CJK UNIFIED IDEOGRAPH
	{0xE647,	0x6F96},	// CJK UNIFIED IDEOGRAPH
	{0xE648,	0x6F76},	// CJK UNIFIED IDEOGRAPH
	{0xE649,	0x6F6C},	// CJK UNIFIED IDEOGRAPH
	{0xE64A,	0x6F82},	// CJK UNIFIED IDEOGRAPH
	{0xE64B,	0x6F55},	// CJK UNIFIED IDEOGRAPH
	{0xE64C,	0x6F72},	// CJK UNIFIED IDEOGRAPH
	{0xE64D,	0x6F52},	// CJK UNIFIED IDEOGRAPH
	{0xE64E,	0x6F50},	// CJK UNIFIED IDEOGRAPH
	{0xE64F,	0x6F57},	// CJK UNIFIED IDEOGRAPH
	{0xE650,	0x6F94},	// CJK UNIFIED IDEOGRAPH
	{0xE651,	0x6F93},	// CJK UNIFIED IDEOGRAPH
	{0xE652,	0x6F5D},	// CJK UNIFIED IDEOGRAPH
	{0xE653,	0x6F00},	// CJK UNIFIED IDEOGRAPH
	{0xE654,	0x6F61},	// CJK UNIFIED IDEOGRAPH
	{0xE655,	0x6F6B},	// CJK UNIFIED IDEOGRAPH
	{0xE656,	0x6F7D},	// CJK UNIFIED IDEOGRAPH
	{0xE657,	0x6F67},	// CJK UNIFIED IDEOGRAPH
	{0xE658,	0x6F90},	// CJK UNIFIED IDEOGRAPH
	{0xE659,	0x6F53},	// CJK UNIFIED IDEOGRAPH
	{0xE65A,	0x6F8B},	// CJK UNIFIED IDEOGRAPH
	{0xE65B,	0x6F69},	// CJK UNIFIED IDEOGRAPH
	{0xE65C,	0x6F7F},	// CJK UNIFIED IDEOGRAPH
	{0xE65D,	0x6F95},	// CJK UNIFIED IDEOGRAPH
	{0xE65E,	0x6F63},	// CJK UNIFIED IDEOGRAPH
	{0xE65F,	0x6F77},	// CJK UNIFIED IDEOGRAPH
	{0xE660,	0x6F6A},	// CJK UNIFIED IDEOGRAPH
	{0xE661,	0x6F7B},	// CJK UNIFIED IDEOGRAPH
	{0xE662,	0x71B2},	// CJK UNIFIED IDEOGRAPH
	{0xE663,	0x71AF},	// CJK UNIFIED IDEOGRAPH
	{0xE664,	0x719B},	// CJK UNIFIED IDEOGRAPH
	{0xE665,	0x71B0},	// CJK UNIFIED IDEOGRAPH
	{0xE666,	0x71A0},	// CJK UNIFIED IDEOGRAPH
	{0xE667,	0x719A},	// CJK UNIFIED IDEOGRAPH
	{0xE668,	0x71A9},	// CJK UNIFIED IDEOGRAPH
	{0xE669,	0x71B5},	// CJK UNIFIED IDEOGRAPH
	{0xE66A,	0x719D},	// CJK UNIFIED IDEOGRAPH
	{0xE66B,	0x71A5},	// CJK UNIFIED IDEOGRAPH
	{0xE66C,	0x719E},	// CJK UNIFIED IDEOGRAPH
	{0xE66D,	0x71A4},	// CJK UNIFIED IDEOGRAPH
	{0xE66E,	0x71A1},	// CJK UNIFIED IDEOGRAPH
	{0xE66F,	0x71AA},	// CJK UNIFIED IDEOGRAPH
	{0xE670,	0x719C},	// CJK UNIFIED IDEOGRAPH
	{0xE671,	0x71A7},	// CJK UNIFIED IDEOGRAPH
	{0xE672,	0x71B3},	// CJK UNIFIED IDEOGRAPH
	{0xE673,	0x7298},	// CJK UNIFIED IDEOGRAPH
	{0xE674,	0x729A},	// CJK UNIFIED IDEOGRAPH
	{0xE675,	0x7358},	// CJK UNIFIED IDEOGRAPH
	{0xE676,	0x7352},	// CJK UNIFIED IDEOGRAPH
	{0xE677,	0x735E},	// CJK UNIFIED IDEOGRAPH
	{0xE678,	0x735F},	// CJK UNIFIED IDEOGRAPH
	{0xE679,	0x7360},	// CJK UNIFIED IDEOGRAPH
	{0xE67A,	0x735D},	// CJK UNIFIED IDEOGRAPH
	{0xE67B,	0x735B},	// CJK UNIFIED IDEOGRAPH
	{0xE67C,	0x7361},	// CJK UNIFIED IDEOGRAPH
	{0xE67D,	0x735A},	// CJK UNIFIED IDEOGRAPH
	{0xE67E,	0x7359},	// CJK UNIFIED IDEOGRAPH
	{0xE6A1,	0x7362},	// CJK UNIFIED IDEOGRAPH
	{0xE6A2,	0x7487},	// CJK UNIFIED IDEOGRAPH
	{0xE6A3,	0x7489},	// CJK UNIFIED IDEOGRAPH
	{0xE6A4,	0x748A},	// CJK UNIFIED IDEOGRAPH
	{0xE6A5,	0x7486},	// CJK UNIFIED IDEOGRAPH
	{0xE6A6,	0x7481},	// CJK UNIFIED IDEOGRAPH
	{0xE6A7,	0x747D},	// CJK UNIFIED IDEOGRAPH
	{0xE6A8,	0x7485},	// CJK UNIFIED IDEOGRAPH
	{0xE6A9,	0x7488},	// CJK UNIFIED IDEOGRAPH
	{0xE6AA,	0x747C},	// CJK UNIFIED IDEOGRAPH
	{0xE6AB,	0x7479},	// CJK UNIFIED IDEOGRAPH
	{0xE6AC,	0x7508},	// CJK UNIFIED IDEOGRAPH
	{0xE6AD,	0x7507},	// CJK UNIFIED IDEOGRAPH
	{0xE6AE,	0x757E},	// CJK UNIFIED IDEOGRAPH
	{0xE6AF,	0x7625},	// CJK UNIFIED IDEOGRAPH
	{0xE6B0,	0x761E},	// CJK UNIFIED IDEOGRAPH
	{0xE6B1,	0x7619},	// CJK UNIFIED IDEOGRAPH
	{0xE6B2,	0x761D},	// CJK UNIFIED IDEOGRAPH
	{0xE6B3,	0x761C},	// CJK UNIFIED IDEOGRAPH
	{0xE6B4,	0x7623},	// CJK UNIFIED IDEOGRAPH
	{0xE6B5,	0x761A},	// CJK UNIFIED IDEOGRAPH
	{0xE6B6,	0x7628},	// CJK UNIFIED IDEOGRAPH
	{0xE6B7,	0x761B},	// CJK UNIFIED IDEOGRAPH
	{0xE6B8,	0x769C},	// CJK UNIFIED IDEOGRAPH
	{0xE6B9,	0x769D},	// CJK UNIFIED IDEOGRAPH
	{0xE6BA,	0x769E},	// CJK UNIFIED IDEOGRAPH
	{0xE6BB,	0x769B},	// CJK UNIFIED IDEOGRAPH
	{0xE6BC,	0x778D},	// CJK UNIFIED IDEOGRAPH
	{0xE6BD,	0x778F},	// CJK UNIFIED IDEOGRAPH
	{0xE6BE,	0x7789},	// CJK UNIFIED IDEOGRAPH
	{0xE6BF,	0x7788},	// CJK UNIFIED IDEOGRAPH
	{0xE6C0,	0x78CD},	// CJK UNIFIED IDEOGRAPH
	{0xE6C1,	0x78BB},	// CJK UNIFIED IDEOGRAPH
	{0xE6C2,	0x78CF},	// CJK UNIFIED IDEOGRAPH
	{0xE6C3,	0x78CC},	// CJK UNIFIED IDEOGRAPH
	{0xE6C4,	0x78D1},	// CJK UNIFIED IDEOGRAPH
	{0xE6C5,	0x78CE},	// CJK UNIFIED IDEOGRAPH
	{0xE6C6,	0x78D4},	// CJK UNIFIED IDEOGRAPH
	{0xE6C7,	0x78C8},	// CJK UNIFIED IDEOGRAPH
	{0xE6C8,	0x78C3},	// CJK UNIFIED IDEOGRAPH
	{0xE6C9,	0x78C4},	// CJK UNIFIED IDEOGRAPH
	{0xE6CA,	0x78C9},	// CJK UNIFIED IDEOGRAPH
	{0xE6CB,	0x799A},	// CJK UNIFIED IDEOGRAPH
	{0xE6CC,	0x79A1},	// CJK UNIFIED IDEOGRAPH
	{0xE6CD,	0x79A0},	// CJK UNIFIED IDEOGRAPH
	{0xE6CE,	0x799C},	// CJK UNIFIED IDEOGRAPH
	{0xE6CF,	0x79A2},	// CJK UNIFIED IDEOGRAPH
	{0xE6D0,	0x799B},	// CJK UNIFIED IDEOGRAPH
	{0xE6D1,	0x6B76},	// CJK UNIFIED IDEOGRAPH
	{0xE6D2,	0x7A39},	// CJK UNIFIED IDEOGRAPH
	{0xE6D3,	0x7AB2},	// CJK UNIFIED IDEOGRAPH
	{0xE6D4,	0x7AB4},	// CJK UNIFIED IDEOGRAPH
	{0xE6D5,	0x7AB3},	// CJK UNIFIED IDEOGRAPH
	{0xE6D6,	0x7BB7},	// CJK UNIFIED IDEOGRAPH
	{0xE6D7,	0x7BCB},	// CJK UNIFIED IDEOGRAPH
	{0xE6D8,	0x7BBE},	// CJK UNIFIED IDEOGRAPH
	{0xE6D9,	0x7BAC},	// CJK UNIFIED IDEOGRAPH
	{0xE6DA,	0x7BCE},	// CJK UNIFIED IDEOGRAPH
	{0xE6DB,	0x7BAF},	// CJK UNIFIED IDEOGRAPH
	{0xE6DC,	0x7BB9},	// CJK UNIFIED IDEOGRAPH
	{0xE6DD,	0x7BCA},	// CJK UNIFIED IDEOGRAPH
	{0xE6DE,	0x7BB5},	// CJK UNIFIED IDEOGRAPH
	{0xE6DF,	0x7CC5},	// CJK UNIFIED IDEOGRAPH
	{0xE6E0,	0x7CC8},	// CJK UNIFIED IDEOGRAPH
	{0xE6E1,	0x7CCC},	// CJK UNIFIED IDEOGRAPH
	{0xE6E2,	0x7CCB},	// CJK UNIFIED IDEOGRAPH
	{0xE6E3,	0x7DF7},	// CJK UNIFIED IDEOGRAPH
	{0xE6E4,	0x7DDB},	// CJK UNIFIED IDEOGRAPH
	{0xE6E5,	0x7DEA},	// CJK UNIFIED IDEOGRAPH
	{0xE6E6,	0x7DE7},	// CJK UNIFIED IDEOGRAPH
	{0xE6E7,	0x7DD7},	// CJK UNIFIED IDEOGRAPH
	{0xE6E8,	0x7DE1},	// CJK UNIFIED IDEOGRAPH
	{0xE6E9,	0x7E03},	// CJK UNIFIED IDEOGRAPH
	{0xE6EA,	0x7DFA},	// CJK UNIFIED IDEOGRAPH
	{0xE6EB,	0x7DE6},	// CJK UNIFIED IDEOGRAPH
	{0xE6EC,	0x7DF6},	// CJK UNIFIED IDEOGRAPH
	{0xE6ED,	0x7DF1},	// CJK UNIFIED IDEOGRAPH
	{0xE6EE,	0x7DF0},	// CJK UNIFIED IDEOGRAPH
	{0xE6EF,	0x7DEE},	// CJK UNIFIED IDEOGRAPH
	{0xE6F0,	0x7DDF},	// CJK UNIFIED IDEOGRAPH
	{0xE6F1,	0x7F76},	// CJK UNIFIED IDEOGRAPH
	{0xE6F2,	0x7FAC},	// CJK UNIFIED IDEOGRAPH
	{0xE6F3,	0x7FB0},	// CJK UNIFIED IDEOGRAPH
	{0xE6F4,	0x7FAD},	// CJK UNIFIED IDEOGRAPH
	{0xE6F5,	0x7FED},	// CJK UNIFIED IDEOGRAPH
	{0xE6F6,	0x7FEB},	// CJK UNIFIED IDEOGRAPH
	{0xE6F7,	0x7FEA},	// CJK UNIFIED IDEOGRAPH
	{0xE6F8,	0x7FEC},	// CJK UNIFIED IDEOGRAPH
	{0xE6F9,	0x7FE6},	// CJK UNIFIED IDEOGRAPH
	{0xE6FA,	0x7FE8},	// CJK UNIFIED IDEOGRAPH
	{0xE6FB,	0x8064},	// CJK UNIFIED IDEOGRAPH
	{0xE6FC,	0x8067},	// CJK UNIFIED IDEOGRAPH
	{0xE6FD,	0x81A3},	// CJK UNIFIED IDEOGRAPH
	{0xE6FE,	0x819F},	// CJK UNIFIED IDEOGRAPH
	{0xE740,	0x819E},	// CJK UNIFIED IDEOGRAPH
	{0xE741,	0x8195},	// CJK UNIFIED IDEOGRAPH
	{0xE742,	0x81A2},	// CJK UNIFIED IDEOGRAPH
	{0xE743,	0x8199},	// CJK UNIFIED IDEOGRAPH
	{0xE744,	0x8197},	// CJK UNIFIED IDEOGRAPH
	{0xE745,	0x8216},	// CJK UNIFIED IDEOGRAPH
	{0xE746,	0x824F},	// CJK UNIFIED IDEOGRAPH
	{0xE747,	0x8253},	// CJK UNIFIED IDEOGRAPH
	{0xE748,	0x8252},	// CJK UNIFIED IDEOGRAPH
	{0xE749,	0x8250},	// CJK UNIFIED IDEOGRAPH
	{0xE74A,	0x824E},	// CJK UNIFIED IDEOGRAPH
	{0xE74B,	0x8251},	// CJK UNIFIED IDEOGRAPH
	{0xE74C,	0x8524},	// CJK UNIFIED IDEOGRAPH
	{0xE74D,	0x853B},	// CJK UNIFIED IDEOGRAPH
	{0xE74E,	0x850F},	// CJK UNIFIED IDEOGRAPH
	{0xE74F,	0x8500},	// CJK UNIFIED IDEOGRAPH
	{0xE750,	0x8529},	// CJK UNIFIED IDEOGRAPH
	{0xE751,	0x850E},	// CJK UNIFIED IDEOGRAPH
	{0xE752,	0x8509},	// CJK UNIFIED IDEOGRAPH
	{0xE753,	0x850D},	// CJK UNIFIED IDEOGRAPH
	{0xE754,	0x851F},	// CJK UNIFIED IDEOGRAPH
	{0xE755,	0x850A},	// CJK UNIFIED IDEOGRAPH
	{0xE756,	0x8527},	// CJK UNIFIED IDEOGRAPH
	{0xE757,	0x851C},	// CJK UNIFIED IDEOGRAPH
	{0xE758,	0x84FB},	// CJK UNIFIED IDEOGRAPH
	{0xE759,	0x852B},	// CJK UNIFIED IDEOGRAPH
	{0xE75A,	0x84FA},	// CJK UNIFIED IDEOGRAPH
	{0xE75B,	0x8508},	// CJK UNIFIED IDEOGRAPH
	{0xE75C,	0x850C},	// CJK UNIFIED IDEOGRAPH
	{0xE75D,	0x84F4},	// CJK UNIFIED IDEOGRAPH
	{0xE75E,	0x852A},	// CJK UNIFIED IDEOGRAPH
	{0xE75F,	0x84F2},	// CJK UNIFIED IDEOGRAPH
	{0xE760,	0x8515},	// CJK UNIFIED IDEOGRAPH
	{0xE761,	0x84F7},	// CJK UNIFIED IDEOGRAPH
	{0xE762,	0x84EB},	// CJK UNIFIED IDEOGRAPH
	{0xE763,	0x84F3},	// CJK UNIFIED IDEOGRAPH
	{0xE764,	0x84FC},	// CJK UNIFIED IDEOGRAPH
	{0xE765,	0x8512},	// CJK UNIFIED IDEOGRAPH
	{0xE766,	0x84EA},	// CJK UNIFIED IDEOGRAPH
	{0xE767,	0x84E9},	// CJK UNIFIED IDEOGRAPH
	{0xE768,	0x8516},	// CJK UNIFIED IDEOGRAPH
	{0xE769,	0x84FE},	// CJK UNIFIED IDEOGRAPH
	{0xE76A,	0x8528},	// CJK UNIFIED IDEOGRAPH
	{0xE76B,	0x851D},	// CJK UNIFIED IDEOGRAPH
	{0xE76C,	0x852E},	// CJK UNIFIED IDEOGRAPH
	{0xE76D,	0x8502},	// CJK UNIFIED IDEOGRAPH
	{0xE76E,	0x84FD},	// CJK UNIFIED IDEOGRAPH
	{0xE76F,	0x851E},	// CJK UNIFIED IDEOGRAPH
	{0xE770,	0x84F6},	// CJK UNIFIED IDEOGRAPH
	{0xE771,	0x8531},	// CJK UNIFIED IDEOGRAPH
	{0xE772,	0x8526},	// CJK UNIFIED IDEOGRAPH
	{0xE773,	0x84E7},	// CJK UNIFIED IDEOGRAPH
	{0xE774,	0x84E8},	// CJK UNIFIED IDEOGRAPH
	{0xE775,	0x84F0},	// CJK UNIFIED IDEOGRAPH
	{0xE776,	0x84EF},	// CJK UNIFIED IDEOGRAPH
	{0xE777,	0x84F9},	// CJK UNIFIED IDEOGRAPH
	{0xE778,	0x8518},	// CJK UNIFIED IDEOGRAPH
	{0xE779,	0x8520},	// CJK UNIFIED IDEOGRAPH
	{0xE77A,	0x8530},	// CJK UNIFIED IDEOGRAPH
	{0xE77B,	0x850B},	// CJK UNIFIED IDEOGRAPH
	{0xE77C,	0x8519},	// CJK UNIFIED IDEOGRAPH
	{0xE77D,	0x852F},	// CJK UNIFIED IDEOGRAPH
	{0xE77E,	0x8662},	// CJK UNIFIED IDEOGRAPH
	{0xE7A1,	0x8756},	// CJK UNIFIED IDEOGRAPH
	{0xE7A2,	0x8763},	// CJK UNIFIED IDEOGRAPH
	{0xE7A3,	0x8764},	// CJK UNIFIED IDEOGRAPH
	{0xE7A4,	0x8777},	// CJK UNIFIED IDEOGRAPH
	{0xE7A5,	0x87E1},	// CJK UNIFIED IDEOGRAPH
	{0xE7A6,	0x8773},	// CJK UNIFIED IDEOGRAPH
	{0xE7A7,	0x8758},	// CJK UNIFIED IDEOGRAPH
	{0xE7A8,	0x8754},	// CJK UNIFIED IDEOGRAPH
	{0xE7A9,	0x875B},	// CJK UNIFIED IDEOGRAPH
	{0xE7AA,	0x8752},	// CJK UNIFIED IDEOGRAPH
	{0xE7AB,	0x8761},	// CJK UNIFIED IDEOGRAPH
	{0xE7AC,	0x875A},	// CJK UNIFIED IDEOGRAPH
	{0xE7AD,	0x8751},	// CJK UNIFIED IDEOGRAPH
	{0xE7AE,	0x875E},	// CJK UNIFIED IDEOGRAPH
	{0xE7AF,	0x876D},	// CJK UNIFIED IDEOGRAPH
	{0xE7B0,	0x876A},	// CJK UNIFIED IDEOGRAPH
	{0xE7B1,	0x8750},	// CJK UNIFIED IDEOGRAPH
	{0xE7B2,	0x874E},	// CJK UNIFIED IDEOGRAPH
	{0xE7B3,	0x875F},	// CJK UNIFIED IDEOGRAPH
	{0xE7B4,	0x875D},	// CJK UNIFIED IDEOGRAPH
	{0xE7B5,	0x876F},	// CJK UNIFIED IDEOGRAPH
	{0xE7B6,	0x876C},	// CJK UNIFIED IDEOGRAPH
	{0xE7B7,	0x877A},	// CJK UNIFIED IDEOGRAPH
	{0xE7B8,	0x876E},	// CJK UNIFIED IDEOGRAPH
	{0xE7B9,	0x875C},	// CJK UNIFIED IDEOGRAPH
	{0xE7BA,	0x8765},	// CJK UNIFIED IDEOGRAPH
	{0xE7BB,	0x874F},	// CJK UNIFIED IDEOGRAPH
	{0xE7BC,	0x877B},	// CJK UNIFIED IDEOGRAPH
	{0xE7BD,	0x8775},	// CJK UNIFIED IDEOGRAPH
	{0xE7BE,	0x8762},	// CJK UNIFIED IDEOGRAPH
	{0xE7BF,	0x8767},	// CJK UNIFIED IDEOGRAPH
	{0xE7C0,	0x8769},	// CJK UNIFIED IDEOGRAPH
	{0xE7C1,	0x885A},	// CJK UNIFIED IDEOGRAPH
	{0xE7C2,	0x8905},	// CJK UNIFIED IDEOGRAPH
	{0xE7C3,	0x890C},	// CJK UNIFIED IDEOGRAPH
	{0xE7C4,	0x8914},	// CJK UNIFIED IDEOGRAPH
	{0xE7C5,	0x890B},	// CJK UNIFIED IDEOGRAPH
	{0xE7C6,	0x8917},	// CJK UNIFIED IDEOGRAPH
	{0xE7C7,	0x8918},	// CJK UNIFIED IDEOGRAPH
	{0xE7C8,	0x8919},	// CJK UNIFIED IDEOGRAPH
	{0xE7C9,	0x8906},	// CJK UNIFIED IDEOGRAPH
	{0xE7CA,	0x8916},	// CJK UNIFIED IDEOGRAPH
	{0xE7CB,	0x8911},	// CJK UNIFIED IDEOGRAPH
	{0xE7CC,	0x890E},	// CJK UNIFIED IDEOGRAPH
	{0xE7CD,	0x8909},	// CJK UNIFIED IDEOGRAPH
	{0xE7CE,	0x89A2},	// CJK UNIFIED IDEOGRAPH
	{0xE7CF,	0x89A4},	// CJK UNIFIED IDEOGRAPH
	{0xE7D0,	0x89A3},	// CJK UNIFIED IDEOGRAPH
	{0xE7D1,	0x89ED},	// CJK UNIFIED IDEOGRAPH
	{0xE7D2,	0x89F0},	// CJK UNIFIED IDEOGRAPH
	{0xE7D3,	0x89EC},	// CJK UNIFIED IDEOGRAPH
	{0xE7D4,	0x8ACF},	// CJK UNIFIED IDEOGRAPH
	{0xE7D5,	0x8AC6},	// CJK UNIFIED IDEOGRAPH
	{0xE7D6,	0x8AB8},	// CJK UNIFIED IDEOGRAPH
	{0xE7D7,	0x8AD3},	// CJK UNIFIED IDEOGRAPH
	{0xE7D8,	0x8AD1},	// CJK UNIFIED IDEOGRAPH
	{0xE7D9,	0x8AD4},	// CJK UNIFIED IDEOGRAPH
	{0xE7DA,	0x8AD5},	// CJK UNIFIED IDEOGRAPH
	{0xE7DB,	0x8ABB},	// CJK UNIFIED IDEOGRAPH
	{0xE7DC,	0x8AD7},	// CJK UNIFIED IDEOGRAPH
	{0xE7DD,	0x8ABE},	// CJK UNIFIED IDEOGRAPH
	{0xE7DE,	0x8AC0},	// CJK UNIFIED IDEOGRAPH
	{0xE7DF,	0x8AC5},	// CJK UNIFIED IDEOGRAPH
	{0xE7E0,	0x8AD8},	// CJK UNIFIED IDEOGRAPH
	{0xE7E1,	0x8AC3},	// CJK UNIFIED IDEOGRAPH
	{0xE7E2,	0x8ABA},	// CJK UNIFIED IDEOGRAPH
	{0xE7E3,	0x8ABD},	// CJK UNIFIED IDEOGRAPH
	{0xE7E4,	0x8AD9},	// CJK UNIFIED IDEOGRAPH
	{0xE7E5,	0x8C3E},	// CJK UNIFIED IDEOGRAPH
	{0xE7E6,	0x8C4D},	// CJK UNIFIED IDEOGRAPH
	{0xE7E7,	0x8C8F},	// CJK UNIFIED IDEOGRAPH
	{0xE7E8,	0x8CE5},	// CJK UNIFIED IDEOGRAPH
	{0xE7E9,	0x8CDF},	// CJK UNIFIED IDEOGRAPH
	{0xE7EA,	0x8CD9},	// CJK UNIFIED IDEOGRAPH
	{0xE7EB,	0x8CE8},	// CJK UNIFIED IDEOGRAPH
	{0xE7EC,	0x8CDA},	// CJK UNIFIED IDEOGRAPH
	{0xE7ED,	0x8CDD},	// CJK UNIFIED IDEOGRAPH
	{0xE7EE,	0x8CE7},	// CJK UNIFIED IDEOGRAPH
	{0xE7EF,	0x8DA0},	// CJK UNIFIED IDEOGRAPH
	{0xE7F0,	0x8D9C},	// CJK UNIFIED IDEOGRAPH
	{0xE7F1,	0x8DA1},	// CJK UNIFIED IDEOGRAPH
	{0xE7F2,	0x8D9B},	// CJK UNIFIED IDEOGRAPH
	{0xE7F3,	0x8E20},	// CJK UNIFIED IDEOGRAPH
	{0xE7F4,	0x8E23},	// CJK UNIFIED IDEOGRAPH
	{0xE7F5,	0x8E25},	// CJK UNIFIED IDEOGRAPH
	{0xE7F6,	0x8E24},	// CJK UNIFIED IDEOGRAPH
	{0xE7F7,	0x8E2E},	// CJK UNIFIED IDEOGRAPH
	{0xE7F8,	0x8E15},	// CJK UNIFIED IDEOGRAPH
	{0xE7F9,	0x8E1B},	// CJK UNIFIED IDEOGRAPH
	{0xE7FA,	0x8E16},	// CJK UNIFIED IDEOGRAPH
	{0xE7FB,	0x8E11},	// CJK UNIFIED IDEOGRAPH
	{0xE7FC,	0x8E19},	// CJK UNIFIED IDEOGRAPH
	{0xE7FD,	0x8E26},	// CJK UNIFIED IDEOGRAPH
	{0xE7FE,	0x8E27},	// CJK UNIFIED IDEOGRAPH
	{0xE840,	0x8E14},	// CJK UNIFIED IDEOGRAPH
	{0xE841,	0x8E12},	// CJK UNIFIED IDEOGRAPH
	{0xE842,	0x8E18},	// CJK UNIFIED IDEOGRAPH
	{0xE843,	0x8E13},	// CJK UNIFIED IDEOGRAPH
	{0xE844,	0x8E1C},	// CJK UNIFIED IDEOGRAPH
	{0xE845,	0x8E17},	// CJK UNIFIED IDEOGRAPH
	{0xE846,	0x8E1A},	// CJK UNIFIED IDEOGRAPH
	{0xE847,	0x8F2C},	// CJK UNIFIED IDEOGRAPH
	{0xE848,	0x8F24},	// CJK UNIFIED IDEOGRAPH
	{0xE849,	0x8F18},	// CJK UNIFIED IDEOGRAPH
	{0xE84A,	0x8F1A},	// CJK UNIFIED IDEOGRAPH
	{0xE84B,	0x8F20},	// CJK UNIFIED IDEOGRAPH
	{0xE84C,	0x8F23},	// CJK UNIFIED IDEOGRAPH
	{0xE84D,	0x8F16},	// CJK UNIFIED IDEOGRAPH
	{0xE84E,	0x8F17},	// CJK UNIFIED IDEOGRAPH
	{0xE84F,	0x9073},	// CJK UNIFIED IDEOGRAPH
	{0xE850,	0x9070},	// CJK UNIFIED IDEOGRAPH
	{0xE851,	0x906F},	// CJK UNIFIED IDEOGRAPH
	{0xE852,	0x9067},	// CJK UNIFIED IDEOGRAPH
	{0xE853,	0x906B},	// CJK UNIFIED IDEOGRAPH
	{0xE854,	0x912F},	// CJK UNIFIED IDEOGRAPH
	{0xE855,	0x912B},	// CJK UNIFIED IDEOGRAPH
	{0xE856,	0x9129},	// CJK UNIFIED IDEOGRAPH
	{0xE857,	0x912A},	// CJK UNIFIED IDEOGRAPH
	{0xE858,	0x9132},	// CJK UNIFIED IDEOGRAPH
	{0xE859,	0x9126},	// CJK UNIFIED IDEOGRAPH
	{0xE85A,	0x912E},	// CJK UNIFIED IDEOGRAPH
	{0xE85B,	0x9185},	// CJK UNIFIED IDEOGRAPH
	{0xE85C,	0x9186},	// CJK UNIFIED IDEOGRAPH
	{0xE85D,	0x918A},	// CJK UNIFIED IDEOGRAPH
	{0xE85E,	0x9181},	// CJK UNIFIED IDEOGRAPH
	{0xE85F,	0x9182},	// CJK UNIFIED IDEOGRAPH
	{0xE860,	0x9184},	// CJK UNIFIED IDEOGRAPH
	{0xE861,	0x9180},	// CJK UNIFIED IDEOGRAPH
	{0xE862,	0x92D0},	// CJK UNIFIED IDEOGRAPH
	{0xE863,	0x92C3},	// CJK UNIFIED IDEOGRAPH
	{0xE864,	0x92C4},	// CJK UNIFIED IDEOGRAPH
	{0xE865,	0x92C0},	// CJK UNIFIED IDEOGRAPH
	{0xE866,	0x92D9},	// CJK UNIFIED IDEOGRAPH
	{0xE867,	0x92B6},	// CJK UNIFIED IDEOGRAPH
	{0xE868,	0x92CF},	// CJK UNIFIED IDEOGRAPH
	{0xE869,	0x92F1},	// CJK UNIFIED IDEOGRAPH
	{0xE86A,	0x92DF},	// CJK UNIFIED IDEOGRAPH
	{0xE86B,	0x92D8},	// CJK UNIFIED IDEOGRAPH
	{0xE86C,	0x92E9},	// CJK UNIFIED IDEOGRAPH
	{0xE86D,	0x92D7},	// CJK UNIFIED IDEOGRAPH
	{0xE86E,	0x92DD},	// CJK UNIFIED IDEOGRAPH
	{0xE86F,	0x92CC},	// CJK UNIFIED IDEOGRAPH
	{0xE870,	0x92EF},	// CJK UNIFIED IDEOGRAPH
	{0xE871,	0x92C2},	// CJK UNIFIED IDEOGRAPH
	{0xE872,	0x92E8},	// CJK UNIFIED IDEOGRAPH
	{0xE873,	0x92CA},	// CJK UNIFIED IDEOGRAPH
	{0xE874,	0x92C8},	// CJK UNIFIED IDEOGRAPH
	{0xE875,	0x92CE},	// CJK UNIFIED IDEOGRAPH
	{0xE876,	0x92E6},	// CJK UNIFIED IDEOGRAPH
	{0xE877,	0x92CD},	// CJK UNIFIED IDEOGRAPH
	{0xE878,	0x92D5},	// CJK UNIFIED IDEOGRAPH
	{0xE879,	0x92C9},	// CJK UNIFIED IDEOGRAPH
	{0xE87A,	0x92E0},	// CJK UNIFIED IDEOGRAPH
	{0xE87B,	0x92DE},	// CJK UNIFIED IDEOGRAPH
	{0xE87C,	0x92E7},	// CJK UNIFIED IDEOGRAPH
	{0xE87D,	0x92D1},	// CJK UNIFIED IDEOGRAPH
	{0xE87E,	0x92D3},	// CJK UNIFIED IDEOGRAPH
	{0xE8A1,	0x92B5},	// CJK UNIFIED IDEOGRAPH
	{0xE8A2,	0x92E1},	// CJK UNIFIED IDEOGRAPH
	{0xE8A3,	0x92C6},	// CJK UNIFIED IDEOGRAPH
	{0xE8A4,	0x92B4},	// CJK UNIFIED IDEOGRAPH
	{0xE8A5,	0x957C},	// CJK UNIFIED IDEOGRAPH
	{0xE8A6,	0x95AC},	// CJK UNIFIED IDEOGRAPH
	{0xE8A7,	0x95AB},	// CJK UNIFIED IDEOGRAPH
	{0xE8A8,	0x95AE},	// CJK UNIFIED IDEOGRAPH
	{0xE8A9,	0x95B0},	// CJK UNIFIED IDEOGRAPH
	{0xE8AA,	0x96A4},	// CJK UNIFIED IDEOGRAPH
	{0xE8AB,	0x96A2},	// CJK UNIFIED IDEOGRAPH
	{0xE8AC,	0x96D3},	// CJK UNIFIED IDEOGRAPH
	{0xE8AD,	0x9705},	// CJK UNIFIED IDEOGRAPH
	{0xE8AE,	0x9708},	// CJK UNIFIED IDEOGRAPH
	{0xE8AF,	0x9702},	// CJK UNIFIED IDEOGRAPH
	{0xE8B0,	0x975A},	// CJK UNIFIED IDEOGRAPH
	{0xE8B1,	0x978A},	// CJK UNIFIED IDEOGRAPH
	{0xE8B2,	0x978E},	// CJK UNIFIED IDEOGRAPH
	{0xE8B3,	0x9788},	// CJK UNIFIED IDEOGRAPH
	{0xE8B4,	0x97D0},	// CJK UNIFIED IDEOGRAPH
	{0xE8B5,	0x97CF},	// CJK UNIFIED IDEOGRAPH
	{0xE8B6,	0x981E},	// CJK UNIFIED IDEOGRAPH
	{0xE8B7,	0x981D},	// CJK UNIFIED IDEOGRAPH
	{0xE8B8,	0x9826},	// CJK UNIFIED IDEOGRAPH
	{0xE8B9,	0x9829},	// CJK UNIFIED IDEOGRAPH
	{0xE8BA,	0x9828},	// CJK UNIFIED IDEOGRAPH
	{0xE8BB,	0x9820},	// CJK UNIFIED IDEOGRAPH
	{0xE8BC,	0x981B},	// CJK UNIFIED IDEOGRAPH
	{0xE8BD,	0x9827},	// CJK UNIFIED IDEOGRAPH
	{0xE8BE,	0x98B2},	// CJK UNIFIED IDEOGRAPH
	{0xE8BF,	0x9908},	// CJK UNIFIED IDEOGRAPH
	{0xE8C0,	0x98FA},	// CJK UNIFIED IDEOGRAPH
	{0xE8C1,	0x9911},	// CJK UNIFIED IDEOGRAPH
	{0xE8C2,	0x9914},	// CJK UNIFIED IDEOGRAPH
	{0xE8C3,	0x9916},	// CJK UNIFIED IDEOGRAPH
	{0xE8C4,	0x9917},	// CJK UNIFIED IDEOGRAPH
	{0xE8C5,	0x9915},	// CJK UNIFIED IDEOGRAPH
	{0xE8C6,	0x99DC},	// CJK UNIFIED IDEOGRAPH
	{0xE8C7,	0x99CD},	// CJK UNIFIED IDEOGRAPH
	{0xE8C8,	0x99CF},	// CJK UNIFIED IDEOGRAPH
	{0xE8C9,	0x99D3},	// CJK UNIFIED IDEOGRAPH
	{0xE8CA,	0x99D4},	// CJK UNIFIED IDEOGRAPH
	{0xE8CB,	0x99CE},	// CJK UNIFIED IDEOGRAPH
	{0xE8CC,	0x99C9},	// CJK UNIFIED IDEOGRAPH
	{0xE8CD,	0x99D6},	// CJK UNIFIED IDEOGRAPH
	{0xE8CE,	0x99D8},	// CJK UNIFIED IDEOGRAPH
	{0xE8CF,	0x99CB},	// CJK UNIFIED IDEOGRAPH
	{0xE8D0,	0x99D7},	// CJK UNIFIED IDEOGRAPH
	{0xE8D1,	0x99CC},	// CJK UNIFIED IDEOGRAPH
	{0xE8D2,	0x9AB3},	// CJK UNIFIED IDEOGRAPH
	{0xE8D3,	0x9AEC},	// CJK UNIFIED IDEOGRAPH
	{0xE8D4,	0x9AEB},	// CJK UNIFIED IDEOGRAPH
	{0xE8D5,	0x9AF3},	// CJK UNIFIED IDEOGRAPH
	{0xE8D6,	0x9AF2},	// CJK UNIFIED IDEOGRAPH
	{0xE8D7,	0x9AF1},	// CJK UNIFIED IDEOGRAPH
	{0xE8D8,	0x9B46},	// CJK UNIFIED IDEOGRAPH
	{0xE8D9,	0x9B43},	// CJK UNIFIED IDEOGRAPH
	{0xE8DA,	0x9B67},	// CJK UNIFIED IDEOGRAPH
	{0xE8DB,	0x9B74},	// CJK UNIFIED IDEOGRAPH
	{0xE8DC,	0x9B71},	// CJK UNIFIED IDEOGRAPH
	{0xE8DD,	0x9B66},	// CJK UNIFIED IDEOGRAPH
	{0xE8DE,	0x9B76},	// CJK UNIFIED IDEOGRAPH
	{0xE8DF,	0x9B75},	// CJK UNIFIED IDEOGRAPH
	{0xE8E0,	0x9B70},	// CJK UNIFIED IDEOGRAPH
	{0xE8E1,	0x9B68},	// CJK UNIFIED IDEOGRAPH
	{0xE8E2,	0x9B64},	// CJK UNIFIED IDEOGRAPH
	{0xE8E3,	0x9B6C},	// CJK UNIFIED IDEOGRAPH
	{0xE8E4,	0x9CFC},	// CJK UNIFIED IDEOGRAPH
	{0xE8E5,	0x9CFA},	// CJK UNIFIED IDEOGRAPH
	{0xE8E6,	0x9CFD},	// CJK UNIFIED IDEOGRAPH
	{0xE8E7,	0x9CFF},	// CJK UNIFIED IDEOGRAPH
	{0xE8E8,	0x9CF7},	// CJK UNIFIED IDEOGRAPH
	{0xE8E9,	0x9D07},	// CJK UNIFIED IDEOGRAPH
	{0xE8EA,	0x9D00},	// CJK UNIFIED IDEOGRAPH
	{0xE8EB,	0x9CF9},	// CJK UNIFIED IDEOGRAPH
	{0xE8EC,	0x9CFB},	// CJK UNIFIED IDEOGRAPH
	{0xE8ED,	0x9D08},	// CJK UNIFIED IDEOGRAPH
	{0xE8EE,	0x9D05},	// CJK UNIFIED IDEOGRAPH
	{0xE8EF,	0x9D04},	// CJK UNIFIED IDEOGRAPH
	{0xE8F0,	0x9E83},	// CJK UNIFIED IDEOGRAPH
	{0xE8F1,	0x9ED3},	// CJK UNIFIED IDEOGRAPH
	{0xE8F2,	0x9F0F},	// CJK UNIFIED IDEOGRAPH
	{0xE8F3,	0x9F10},	// CJK UNIFIED IDEOGRAPH
	{0xE8F4,	0x511C},	// CJK UNIFIED IDEOGRAPH
	{0xE8F5,	0x5113},	// CJK UNIFIED IDEOGRAPH
	{0xE8F6,	0x5117},	// CJK UNIFIED IDEOGRAPH
	{0xE8F7,	0x511A},	// CJK UNIFIED IDEOGRAPH
	{0xE8F8,	0x5111},	// CJK UNIFIED IDEOGRAPH
	{0xE8F9,	0x51DE},	// CJK UNIFIED IDEOGRAPH
	{0xE8FA,	0x5334},	// CJK UNIFIED IDEOGRAPH
	{0xE8FB,	0x53E1},	// CJK UNIFIED IDEOGRAPH
	{0xE8FC,	0x5670},	// CJK UNIFIED IDEOGRAPH
	{0xE8FD,	0x5660},	// CJK UNIFIED IDEOGRAPH
	{0xE8FE,	0x566E},	// CJK UNIFIED IDEOGRAPH
	{0xE940,	0x5673},	// CJK UNIFIED IDEOGRAPH
	{0xE941,	0x5666},	// CJK UNIFIED IDEOGRAPH
	{0xE942,	0x5663},	// CJK UNIFIED IDEOGRAPH
	{0xE943,	0x566D},	// CJK UNIFIED IDEOGRAPH
	{0xE944,	0x5672},	// CJK UNIFIED IDEOGRAPH
	{0xE945,	0x565E},	// CJK UNIFIED IDEOGRAPH
	{0xE946,	0x5677},	// CJK UNIFIED IDEOGRAPH
	{0xE947,	0x571C},	// CJK UNIFIED IDEOGRAPH
	{0xE948,	0x571B},	// CJK UNIFIED IDEOGRAPH
	{0xE949,	0x58C8},	// CJK UNIFIED IDEOGRAPH
	{0xE94A,	0x58BD},	// CJK UNIFIED IDEOGRAPH
	{0xE94B,	0x58C9},	// CJK UNIFIED IDEOGRAPH
	{0xE94C,	0x58BF},	// CJK UNIFIED IDEOGRAPH
	{0xE94D,	0x58BA},	// CJK UNIFIED IDEOGRAPH
	{0xE94E,	0x58C2},	// CJK UNIFIED IDEOGRAPH
	{0xE94F,	0x58BC},	// CJK UNIFIED IDEOGRAPH
	{0xE950,	0x58C6},	// CJK UNIFIED IDEOGRAPH
	{0xE951,	0x5B17},	// CJK UNIFIED IDEOGRAPH
	{0xE952,	0x5B19},	// CJK UNIFIED IDEOGRAPH
	{0xE953,	0x5B1B},	// CJK UNIFIED IDEOGRAPH
	{0xE954,	0x5B21},	// CJK UNIFIED IDEOGRAPH
	{0xE955,	0x5B14},	// CJK UNIFIED IDEOGRAPH
	{0xE956,	0x5B13},	// CJK UNIFIED IDEOGRAPH
	{0xE957,	0x5B10},	// CJK UNIFIED IDEOGRAPH
	{0xE958,	0x5B16},	// CJK UNIFIED IDEOGRAPH
	{0xE959,	0x5B28},	// CJK UNIFIED IDEOGRAPH
	{0xE95A,	0x5B1A},	// CJK UNIFIED IDEOGRAPH
	{0xE95B,	0x5B20},	// CJK UNIFIED IDEOGRAPH
	{0xE95C,	0x5B1E},	// CJK UNIFIED IDEOGRAPH
	{0xE95D,	0x5BEF},	// CJK UNIFIED IDEOGRAPH
	{0xE95E,	0x5DAC},	// CJK UNIFIED IDEOGRAPH
	{0xE95F,	0x5DB1},	// CJK UNIFIED IDEOGRAPH
	{0xE960,	0x5DA9},	// CJK UNIFIED IDEOGRAPH
	{0xE961,	0x5DA7},	// CJK UNIFIED IDEOGRAPH
	{0xE962,	0x5DB5},	// CJK UNIFIED IDEOGRAPH
	{0xE963,	0x5DB0},	// CJK UNIFIED IDEOGRAPH
	{0xE964,	0x5DAE},	// CJK UNIFIED IDEOGRAPH
	{0xE965,	0x5DAA},	// CJK UNIFIED IDEOGRAPH
	{0xE966,	0x5DA8},	// CJK UNIFIED IDEOGRAPH
	{0xE967,	0x5DB2},	// CJK UNIFIED IDEOGRAPH
	{0xE968,	0x5DAD},	// CJK UNIFIED IDEOGRAPH
	{0xE969,	0x5DAF},	// CJK UNIFIED IDEOGRAPH
	{0xE96A,	0x5DB4},	// CJK UNIFIED IDEOGRAPH
	{0xE96B,	0x5E67},	// CJK UNIFIED IDEOGRAPH
	{0xE96C,	0x5E68},	// CJK UNIFIED IDEOGRAPH
	{0xE96D,	0x5E66},	// CJK UNIFIED IDEOGRAPH
	{0xE96E,	0x5E6F},	// CJK UNIFIED IDEOGRAPH
	{0xE96F,	0x5EE9},	// CJK UNIFIED IDEOGRAPH
	{0xE970,	0x5EE7},	// CJK UNIFIED IDEOGRAPH
	{0xE971,	0x5EE6},	// CJK UNIFIED IDEOGRAPH
	{0xE972,	0x5EE8},	// CJK UNIFIED IDEOGRAPH
	{0xE973,	0x5EE5},	// CJK UNIFIED IDEOGRAPH
	{0xE974,	0x5F4B},	// CJK UNIFIED IDEOGRAPH
	{0xE975,	0x5FBC},	// CJK UNIFIED IDEOGRAPH
	{0xE976,	0x619D},	// CJK UNIFIED IDEOGRAPH
	{0xE977,	0x61A8},	// CJK UNIFIED IDEOGRAPH
	{0xE978,	0x6196},	// CJK UNIFIED IDEOGRAPH
	{0xE979,	0x61C5},	// CJK UNIFIED IDEOGRAPH
	{0xE97A,	0x61B4},	// CJK UNIFIED IDEOGRAPH
	{0xE97B,	0x61C6},	// CJK UNIFIED IDEOGRAPH
	{0xE97C,	0x61C1},	// CJK UNIFIED IDEOGRAPH
	{0xE97D,	0x61CC},	// CJK UNIFIED IDEOGRAPH
	{0xE97E,	0x61BA},	// CJK UNIFIED IDEOGRAPH
	{0xE9A1,	0x61BF},	// CJK UNIFIED IDEOGRAPH
	{0xE9A2,	0x61B8},	// CJK UNIFIED IDEOGRAPH
	{0xE9A3,	0x618C},	// CJK UNIFIED IDEOGRAPH
	{0xE9A4,	0x64D7},	// CJK UNIFIED IDEOGRAPH
	{0xE9A5,	0x64D6},	// CJK UNIFIED IDEOGRAPH
	{0xE9A6,	0x64D0},	// CJK UNIFIED IDEOGRAPH
	{0xE9A7,	0x64CF},	// CJK UNIFIED IDEOGRAPH
	{0xE9A8,	0x64C9},	// CJK UNIFIED IDEOGRAPH
	{0xE9A9,	0x64BD},	// CJK UNIFIED IDEOGRAPH
	{0xE9AA,	0x6489},	// CJK UNIFIED IDEOGRAPH
	{0xE9AB,	0x64C3},	// CJK UNIFIED IDEOGRAPH
	{0xE9AC,	0x64DB},	// CJK UNIFIED IDEOGRAPH
	{0xE9AD,	0x64F3},	// CJK UNIFIED IDEOGRAPH
	{0xE9AE,	0x64D9},	// CJK UNIFIED IDEOGRAPH
	{0xE9AF,	0x6533},	// CJK UNIFIED IDEOGRAPH
	{0xE9B0,	0x657F},	// CJK UNIFIED IDEOGRAPH
	{0xE9B1,	0x657C},	// CJK UNIFIED IDEOGRAPH
	{0xE9B2,	0x65A2},	// CJK UNIFIED IDEOGRAPH
	{0xE9B3,	0x66C8},	// CJK UNIFIED IDEOGRAPH
	{0xE9B4,	0x66BE},	// CJK UNIFIED IDEOGRAPH
	{0xE9B5,	0x66C0},	// CJK UNIFIED IDEOGRAPH
	{0xE9B6,	0x66CA},	// CJK UNIFIED IDEOGRAPH
	{0xE9B7,	0x66CB},	// CJK UNIFIED IDEOGRAPH
	{0xE9B8,	0x66CF},	// CJK UNIFIED IDEOGRAPH
	{0xE9B9,	0x66BD},	// CJK UNIFIED IDEOGRAPH
	{0xE9BA,	0x66BB},	// CJK UNIFIED IDEOGRAPH
	{0xE9BB,	0x66BA},	// CJK UNIFIED IDEOGRAPH
	{0xE9BC,	0x66CC},	// CJK UNIFIED IDEOGRAPH
	{0xE9BD,	0x6723},	// CJK UNIFIED IDEOGRAPH
	{0xE9BE,	0x6A34},	// CJK UNIFIED IDEOGRAPH
	{0xE9BF,	0x6A66},	// CJK UNIFIED IDEOGRAPH
	{0xE9C0,	0x6A49},	// CJK UNIFIED IDEOGRAPH
	{0xE9C1,	0x6A67},	// CJK UNIFIED IDEOGRAPH
	{0xE9C2,	0x6A32},	// CJK UNIFIED IDEOGRAPH
	{0xE9C3,	0x6A68},	// CJK UNIFIED IDEOGRAPH
	{0xE9C4,	0x6A3E},	// CJK UNIFIED IDEOGRAPH
	{0xE9C5,	0x6A5D},	// CJK UNIFIED IDEOGRAPH
	{0xE9C6,	0x6A6D},	// CJK UNIFIED IDEOGRAPH
	{0xE9C7,	0x6A76},	// CJK UNIFIED IDEOGRAPH
	{0xE9C8,	0x6A5B},	// CJK UNIFIED IDEOGRAPH
	{0xE9C9,	0x6A51},	// CJK UNIFIED IDEOGRAPH
	{0xE9CA,	0x6A28},	// CJK UNIFIED IDEOGRAPH
	{0xE9CB,	0x6A5A},	// CJK UNIFIED IDEOGRAPH
	{0xE9CC,	0x6A3B},	// CJK UNIFIED IDEOGRAPH
	{0xE9CD,	0x6A3F},	// CJK UNIFIED IDEOGRAPH
	{0xE9CE,	0x6A41},	// CJK UNIFIED IDEOGRAPH
	{0xE9CF,	0x6A6A},	// CJK UNIFIED IDEOGRAPH
	{0xE9D0,	0x6A64},	// CJK UNIFIED IDEOGRAPH
	{0xE9D1,	0x6A50},	// CJK UNIFIED IDEOGRAPH
	{0xE9D2,	0x6A4F},	// CJK UNIFIED IDEOGRAPH
	{0xE9D3,	0x6A54},	// CJK UNIFIED IDEOGRAPH
	{0xE9D4,	0x6A6F},	// CJK UNIFIED IDEOGRAPH
	{0xE9D5,	0x6A69},	// CJK UNIFIED IDEOGRAPH
	{0xE9D6,	0x6A60},	// CJK UNIFIED IDEOGRAPH
	{0xE9D7,	0x6A3C},	// CJK UNIFIED IDEOGRAPH
	{0xE9D8,	0x6A5E},	// CJK UNIFIED IDEOGRAPH
	{0xE9D9,	0x6A56},	// CJK UNIFIED IDEOGRAPH
	{0xE9DA,	0x6A55},	// CJK UNIFIED IDEOGRAPH
	{0xE9DB,	0x6A4D},	// CJK UNIFIED IDEOGRAPH
	{0xE9DC,	0x6A4E},	// CJK UNIFIED IDEOGRAPH
	{0xE9DD,	0x6A46},	// CJK UNIFIED IDEOGRAPH
	{0xE9DE,	0x6B55},	// CJK UNIFIED IDEOGRAPH
	{0xE9DF,	0x6B54},	// CJK UNIFIED IDEOGRAPH
	{0xE9E0,	0x6B56},	// CJK UNIFIED IDEOGRAPH
	{0xE9E1,	0x6BA7},	// CJK UNIFIED IDEOGRAPH
	{0xE9E2,	0x6BAA},	// CJK UNIFIED IDEOGRAPH
	{0xE9E3,	0x6BAB},	// CJK UNIFIED IDEOGRAPH
	{0xE9E4,	0x6BC8},	// CJK UNIFIED IDEOGRAPH
	{0xE9E5,	0x6BC7},	// CJK UNIFIED IDEOGRAPH
	{0xE9E6,	0x6C04},	// CJK UNIFIED IDEOGRAPH
	{0xE9E7,	0x6C03},	// CJK UNIFIED IDEOGRAPH
	{0xE9E8,	0x6C06},	// CJK UNIFIED IDEOGRAPH
	{0xE9E9,	0x6FAD},	// CJK UNIFIED IDEOGRAPH
	{0xE9EA,	0x6FCB},	// CJK UNIFIED IDEOGRAPH
	{0xE9EB,	0x6FA3},	// CJK UNIFIED IDEOGRAPH
	{0xE9EC,	0x6FC7},	// CJK UNIFIED IDEOGRAPH
	{0xE9ED,	0x6FBC},	// CJK UNIFIED IDEOGRAPH
	{0xE9EE,	0x6FCE},	// CJK UNIFIED IDEOGRAPH
	{0xE9EF,	0x6FC8},	// CJK UNIFIED IDEOGRAPH
	{0xE9F0,	0x6F5E},	// CJK UNIFIED IDEOGRAPH
	{0xE9F1,	0x6FC4},	// CJK UNIFIED IDEOGRAPH
	{0xE9F2,	0x6FBD},	// CJK UNIFIED IDEOGRAPH
	{0xE9F3,	0x6F9E},	// CJK UNIFIED IDEOGRAPH
	{0xE9F4,	0x6FCA},	// CJK UNIFIED IDEOGRAPH
	{0xE9F5,	0x6FA8},	// CJK UNIFIED IDEOGRAPH
	{0xE9F6,	0x7004},	// CJK UNIFIED IDEOGRAPH
	{0xE9F7,	0x6FA5},	// CJK UNIFIED IDEOGRAPH
	{0xE9F8,	0x6FAE},	// CJK UNIFIED IDEOGRAPH
	{0xE9F9,	0x6FBA},	// CJK UNIFIED IDEOGRAPH
	{0xE9FA,	0x6FAC},	// CJK UNIFIED IDEOGRAPH
	{0xE9FB,	0x6FAA},	// CJK UNIFIED IDEOGRAPH
	{0xE9FC,	0x6FCF},	// CJK UNIFIED IDEOGRAPH
	{0xE9FD,	0x6FBF},	// CJK UNIFIED IDEOGRAPH
	{0xE9FE,	0x6FB8},	// CJK UNIFIED IDEOGRAPH
	{0xEA40,	0x6FA2},	// CJK UNIFIED IDEOGRAPH
	{0xEA41,	0x6FC9},	// CJK UNIFIED IDEOGRAPH
	{0xEA42,	0x6FAB},	// CJK UNIFIED IDEOGRAPH
	{0xEA43,	0x6FCD},	// CJK UNIFIED IDEOGRAPH
	{0xEA44,	0x6FAF},	// CJK UNIFIED IDEOGRAPH
	{0xEA45,	0x6FB2},	// CJK UNIFIED IDEOGRAPH
	{0xEA46,	0x6FB0},	// CJK UNIFIED IDEOGRAPH
	{0xEA47,	0x71C5},	// CJK UNIFIED IDEOGRAPH
	{0xEA48,	0x71C2},	// CJK UNIFIED IDEOGRAPH
	{0xEA49,	0x71BF},	// CJK UNIFIED IDEOGRAPH
	{0xEA4A,	0x71B8},	// CJK UNIFIED IDEOGRAPH
	{0xEA4B,	0x71D6},	// CJK UNIFIED IDEOGRAPH
	{0xEA4C,	0x71C0},	// CJK UNIFIED IDEOGRAPH
	{0xEA4D,	0x71C1},	// CJK UNIFIED IDEOGRAPH
	{0xEA4E,	0x71CB},	// CJK UNIFIED IDEOGRAPH
	{0xEA4F,	0x71D4},	// CJK UNIFIED IDEOGRAPH
	{0xEA50,	0x71CA},	// CJK UNIFIED IDEOGRAPH
	{0xEA51,	0x71C7},	// CJK UNIFIED IDEOGRAPH
	{0xEA52,	0x71CF},	// CJK UNIFIED IDEOGRAPH
	{0xEA53,	0x71BD},	// CJK UNIFIED IDEOGRAPH
	{0xEA54,	0x71D8},	// CJK UNIFIED IDEOGRAPH
	{0xEA55,	0x71BC},	// CJK UNIFIED IDEOGRAPH
	{0xEA56,	0x71C6},	// CJK UNIFIED IDEOGRAPH
	{0xEA57,	0x71DA},	// CJK UNIFIED IDEOGRAPH
	{0xEA58,	0x71DB},	// CJK UNIFIED IDEOGRAPH
	{0xEA59,	0x729D},	// CJK UNIFIED IDEOGRAPH
	{0xEA5A,	0x729E},	// CJK UNIFIED IDEOGRAPH
	{0xEA5B,	0x7369},	// CJK UNIFIED IDEOGRAPH
	{0xEA5C,	0x7366},	// CJK UNIFIED IDEOGRAPH
	{0xEA5D,	0x7367},	// CJK UNIFIED IDEOGRAPH
	{0xEA5E,	0x736C},	// CJK UNIFIED IDEOGRAPH
	{0xEA5F,	0x7365},	// CJK UNIFIED IDEOGRAPH
	{0xEA60,	0x736B},	// CJK UNIFIED IDEOGRAPH
	{0xEA61,	0x736A},	// CJK UNIFIED IDEOGRAPH
	{0xEA62,	0x747F},	// CJK UNIFIED IDEOGRAPH
	{0xEA63,	0x749A},	// CJK UNIFIED IDEOGRAPH
	{0xEA64,	0x74A0},	// CJK UNIFIED IDEOGRAPH
	{0xEA65,	0x7494},	// CJK UNIFIED IDEOGRAPH
	{0xEA66,	0x7492},	// CJK UNIFIED IDEOGRAPH
	{0xEA67,	0x7495},	// CJK UNIFIED IDEOGRAPH
	{0xEA68,	0x74A1},	// CJK UNIFIED IDEOGRAPH
	{0xEA69,	0x750B},	// CJK UNIFIED IDEOGRAPH
	{0xEA6A,	0x7580},	// CJK UNIFIED IDEOGRAPH
	{0xEA6B,	0x762F},	// CJK UNIFIED IDEOGRAPH
	{0xEA6C,	0x762D},	// CJK UNIFIED IDEOGRAPH
	{0xEA6D,	0x7631},	// CJK UNIFIED IDEOGRAPH
	{0xEA6E,	0x763D},	// CJK UNIFIED IDEOGRAPH
	{0xEA6F,	0x7633},	// CJK UNIFIED IDEOGRAPH
	{0xEA70,	0x763C},	// CJK UNIFIED IDEOGRAPH
	{0xEA71,	0x7635},	// CJK UNIFIED IDEOGRAPH
	{0xEA72,	0x7632},	// CJK UNIFIED IDEOGRAPH
	{0xEA73,	0x7630},	// CJK UNIFIED IDEOGRAPH
	{0xEA74,	0x76BB},	// CJK UNIFIED IDEOGRAPH
	{0xEA75,	0x76E6},	// CJK UNIFIED IDEOGRAPH
	{0xEA76,	0x779A},	// CJK UNIFIED IDEOGRAPH
	{0xEA77,	0x779D},	// CJK UNIFIED IDEOGRAPH
	{0xEA78,	0x77A1},	// CJK UNIFIED IDEOGRAPH
	{0xEA79,	0x779C},	// CJK UNIFIED IDEOGRAPH
	{0xEA7A,	0x779B},	// CJK UNIFIED IDEOGRAPH
	{0xEA7B,	0x77A2},	// CJK UNIFIED IDEOGRAPH
	{0xEA7C,	0x77A3},	// CJK UNIFIED IDEOGRAPH
	{0xEA7D,	0x7795},	// CJK UNIFIED IDEOGRAPH
	{0xEA7E,	0x7799},	// CJK UNIFIED IDEOGRAPH
	{0xEAA1,	0x7797},	// CJK UNIFIED IDEOGRAPH
	{0xEAA2,	0x78DD},	// CJK UNIFIED IDEOGRAPH
	{0xEAA3,	0x78E9},	// CJK UNIFIED IDEOGRAPH
	{0xEAA4,	0x78E5},	// CJK UNIFIED IDEOGRAPH
	{0xEAA5,	0x78EA},	// CJK UNIFIED IDEOGRAPH
	{0xEAA6,	0x78DE},	// CJK UNIFIED IDEOGRAPH
	{0xEAA7,	0x78E3},	// CJK UNIFIED IDEOGRAPH
	{0xEAA8,	0x78DB},	// CJK UNIFIED IDEOGRAPH
	{0xEAA9,	0x78E1},	// CJK UNIFIED IDEOGRAPH
	{0xEAAA,	0x78E2},	// CJK UNIFIED IDEOGRAPH
	{0xEAAB,	0x78ED},	// CJK UNIFIED IDEOGRAPH
	{0xEAAC,	0x78DF},	// CJK UNIFIED IDEOGRAPH
	{0xEAAD,	0x78E0},	// CJK UNIFIED IDEOGRAPH
	{0xEAAE,	0x79A4},	// CJK UNIFIED IDEOGRAPH
	{0xEAAF,	0x7A44},	// CJK UNIFIED IDEOGRAPH
	{0xEAB0,	0x7A48},	// CJK UNIFIED IDEOGRAPH
	{0xEAB1,	0x7A47},	// CJK UNIFIED IDEOGRAPH
	{0xEAB2,	0x7AB6},	// CJK UNIFIED IDEOGRAPH
	{0xEAB3,	0x7AB8},	// CJK UNIFIED IDEOGRAPH
	{0xEAB4,	0x7AB5},	// CJK UNIFIED IDEOGRAPH
	{0xEAB5,	0x7AB1},	// CJK UNIFIED IDEOGRAPH
	{0xEAB6,	0x7AB7},	// CJK UNIFIED IDEOGRAPH
	{0xEAB7,	0x7BDE},	// CJK UNIFIED IDEOGRAPH
	{0xEAB8,	0x7BE3},	// CJK UNIFIED IDEOGRAPH
	{0xEAB9,	0x7BE7},	// CJK UNIFIED IDEOGRAPH
	{0xEABA,	0x7BDD},	// CJK UNIFIED IDEOGRAPH
	{0xEABB,	0x7BD5},	// CJK UNIFIED IDEOGRAPH
	{0xEABC,	0x7BE5},	// CJK UNIFIED IDEOGRAPH
	{0xEABD,	0x7BDA},	// CJK UNIFIED IDEOGRAPH
	{0xEABE,	0x7BE8},	// CJK UNIFIED IDEOGRAPH
	{0xEABF,	0x7BF9},	// CJK UNIFIED IDEOGRAPH
	{0xEAC0,	0x7BD4},	// CJK UNIFIED IDEOGRAPH
	{0xEAC1,	0x7BEA},	// CJK UNIFIED IDEOGRAPH
	{0xEAC2,	0x7BE2},	// CJK UNIFIED IDEOGRAPH
	{0xEAC3,	0x7BDC},	// CJK UNIFIED IDEOGRAPH
	{0xEAC4,	0x7BEB},	// CJK UNIFIED IDEOGRAPH
	{0xEAC5,	0x7BD8},	// CJK UNIFIED IDEOGRAPH
	{0xEAC6,	0x7BDF},	// CJK UNIFIED IDEOGRAPH
	{0xEAC7,	0x7CD2},	// CJK UNIFIED IDEOGRAPH
	{0xEAC8,	0x7CD4},	// CJK UNIFIED IDEOGRAPH
	{0xEAC9,	0x7CD7},	// CJK UNIFIED IDEOGRAPH
	{0xEACA,	0x7CD0},	// CJK UNIFIED IDEOGRAPH
	{0xEACB,	0x7CD1},	// CJK UNIFIED IDEOGRAPH
	{0xEACC,	0x7E12},	// CJK UNIFIED IDEOGRAPH
	{0xEACD,	0x7E21},	// CJK UNIFIED IDEOGRAPH
	{0xEACE,	0x7E17},	// CJK UNIFIED IDEOGRAPH
	{0xEACF,	0x7E0C},	// CJK UNIFIED IDEOGRAPH
	{0xEAD0,	0x7E1F},	// CJK UNIFIED IDEOGRAPH
	{0xEAD1,	0x7E20},	// CJK UNIFIED IDEOGRAPH
	{0xEAD2,	0x7E13},	// CJK UNIFIED IDEOGRAPH
	{0xEAD3,	0x7E0E},	// CJK UNIFIED IDEOGRAPH
	{0xEAD4,	0x7E1C},	// CJK UNIFIED IDEOGRAPH
	{0xEAD5,	0x7E15},	// CJK UNIFIED IDEOGRAPH
	{0xEAD6,	0x7E1A},	// CJK UNIFIED IDEOGRAPH
	{0xEAD7,	0x7E22},	// CJK UNIFIED IDEOGRAPH
	{0xEAD8,	0x7E0B},	// CJK UNIFIED IDEOGRAPH
	{0xEAD9,	0x7E0F},	// CJK UNIFIED IDEOGRAPH
	{0xEADA,	0x7E16},	// CJK UNIFIED IDEOGRAPH
	{0xEADB,	0x7E0D},	// CJK UNIFIED IDEOGRAPH
	{0xEADC,	0x7E14},	// CJK UNIFIED IDEOGRAPH
	{0xEADD,	0x7E25},	// CJK UNIFIED IDEOGRAPH
	{0xEADE,	0x7E24},	// CJK UNIFIED IDEOGRAPH
	{0xEADF,	0x7F43},	// CJK UNIFIED IDEOGRAPH
	{0xEAE0,	0x7F7B},	// CJK UNIFIED IDEOGRAPH
	{0xEAE1,	0x7F7C},	// CJK UNIFIED IDEOGRAPH
	{0xEAE2,	0x7F7A},	// CJK UNIFIED IDEOGRAPH
	{0xEAE3,	0x7FB1},	// CJK UNIFIED IDEOGRAPH
	{0xEAE4,	0x7FEF},	// CJK UNIFIED IDEOGRAPH
	{0xEAE5,	0x802A},	// CJK UNIFIED IDEOGRAPH
	{0xEAE6,	0x8029},	// CJK UNIFIED IDEOGRAPH
	{0xEAE7,	0x806C},	// CJK UNIFIED IDEOGRAPH
	{0xEAE8,	0x81B1},	// CJK UNIFIED IDEOGRAPH
	{0xEAE9,	0x81A6},	// CJK UNIFIED IDEOGRAPH
	{0xEAEA,	0x81AE},	// CJK UNIFIED IDEOGRAPH
	{0xEAEB,	0x81B9},	// CJK UNIFIED IDEOGRAPH
	{0xEAEC,	0x81B5},	// CJK UNIFIED IDEOGRAPH
	{0xEAED,	0x81AB},	// CJK UNIFIED IDEOGRAPH
	{0xEAEE,	0x81B0},	// CJK UNIFIED IDEOGRAPH
	{0xEAEF,	0x81AC},	// CJK UNIFIED IDEOGRAPH
	{0xEAF0,	0x81B4},	// CJK UNIFIED IDEOGRAPH
	{0xEAF1,	0x81B2},	// CJK UNIFIED IDEOGRAPH
	{0xEAF2,	0x81B7},	// CJK UNIFIED IDEOGRAPH
	{0xEAF3,	0x81A7},	// CJK UNIFIED IDEOGRAPH
	{0xEAF4,	0x81F2},	// CJK UNIFIED IDEOGRAPH
	{0xEAF5,	0x8255},	// CJK UNIFIED IDEOGRAPH
	{0xEAF6,	0x8256},	// CJK UNIFIED IDEOGRAPH
	{0xEAF7,	0x8257},	// CJK UNIFIED IDEOGRAPH
	{0xEAF8,	0x8556},	// CJK UNIFIED IDEOGRAPH
	{0xEAF9,	0x8545},	// CJK UNIFIED IDEOGRAPH
	{0xEAFA,	0x856B},	// CJK UNIFIED IDEOGRAPH
	{0xEAFB,	0x854D},	// CJK UNIFIED IDEOGRAPH
	{0xEAFC,	0x8553},	// CJK UNIFIED IDEOGRAPH
	{0xEAFD,	0x8561},	// CJK UNIFIED IDEOGRAPH
	{0xEAFE,	0x8558},	// CJK UNIFIED IDEOGRAPH
	{0xEB40,	0x8540},	// CJK UNIFIED IDEOGRAPH
	{0xEB41,	0x8546},	// CJK UNIFIED IDEOGRAPH
	{0xEB42,	0x8564},	// CJK UNIFIED IDEOGRAPH
	{0xEB43,	0x8541},	// CJK UNIFIED IDEOGRAPH
	{0xEB44,	0x8562},	// CJK UNIFIED IDEOGRAPH
	{0xEB45,	0x8544},	// CJK UNIFIED IDEOGRAPH
	{0xEB46,	0x8551},	// CJK UNIFIED IDEOGRAPH
	{0xEB47,	0x8547},	// CJK UNIFIED IDEOGRAPH
	{0xEB48,	0x8563},	// CJK UNIFIED IDEOGRAPH
	{0xEB49,	0x853E},	// CJK UNIFIED IDEOGRAPH
	{0xEB4A,	0x855B},	// CJK UNIFIED IDEOGRAPH
	{0xEB4B,	0x8571},	// CJK UNIFIED IDEOGRAPH
	{0xEB4C,	0x854E},	// CJK UNIFIED IDEOGRAPH
	{0xEB4D,	0x856E},	// CJK UNIFIED IDEOGRAPH
	{0xEB4E,	0x8575},	// CJK UNIFIED IDEOGRAPH
	{0xEB4F,	0x8555},	// CJK UNIFIED IDEOGRAPH
	{0xEB50,	0x8567},	// CJK UNIFIED IDEOGRAPH
	{0xEB51,	0x8560},	// CJK UNIFIED IDEOGRAPH
	{0xEB52,	0x858C},	// CJK UNIFIED IDEOGRAPH
	{0xEB53,	0x8566},	// CJK UNIFIED IDEOGRAPH
	{0xEB54,	0x855D},	// CJK UNIFIED IDEOGRAPH
	{0xEB55,	0x8554},	// CJK UNIFIED IDEOGRAPH
	{0xEB56,	0x8565},	// CJK UNIFIED IDEOGRAPH
	{0xEB57,	0x856C},	// CJK UNIFIED IDEOGRAPH
	{0xEB58,	0x8663},	// CJK UNIFIED IDEOGRAPH
	{0xEB59,	0x8665},	// CJK UNIFIED IDEOGRAPH
	{0xEB5A,	0x8664},	// CJK UNIFIED IDEOGRAPH
	{0xEB5B,	0x879B},	// CJK UNIFIED IDEOGRAPH
	{0xEB5C,	0x878F},	// CJK UNIFIED IDEOGRAPH
	{0xEB5D,	0x8797},	// CJK UNIFIED IDEOGRAPH
	{0xEB5E,	0x8793},	// CJK UNIFIED IDEOGRAPH
	{0xEB5F,	0x8792},	// CJK UNIFIED IDEOGRAPH
	{0xEB60,	0x8788},	// CJK UNIFIED IDEOGRAPH
	{0xEB61,	0x8781},	// CJK UNIFIED IDEOGRAPH
	{0xEB62,	0x8796},	// CJK UNIFIED IDEOGRAPH
	{0xEB63,	0x8798},	// CJK UNIFIED IDEOGRAPH
	{0xEB64,	0x8779},	// CJK UNIFIED IDEOGRAPH
	{0xEB65,	0x8787},	// CJK UNIFIED IDEOGRAPH
	{0xEB66,	0x87A3},	// CJK UNIFIED IDEOGRAPH
	{0xEB67,	0x8785},	// CJK UNIFIED IDEOGRAPH
	{0xEB68,	0x8790},	// CJK UNIFIED IDEOGRAPH
	{0xEB69,	0x8791},	// CJK UNIFIED IDEOGRAPH
	{0xEB6A,	0x879D},	// CJK UNIFIED IDEOGRAPH
	{0xEB6B,	0x8784},	// CJK UNIFIED IDEOGRAPH
	{0xEB6C,	0x8794},	// CJK UNIFIED IDEOGRAPH
	{0xEB6D,	0x879C},	// CJK UNIFIED IDEOGRAPH
	{0xEB6E,	0x879A},	// CJK UNIFIED IDEOGRAPH
	{0xEB6F,	0x8789},	// CJK UNIFIED IDEOGRAPH
	{0xEB70,	0x891E},	// CJK UNIFIED IDEOGRAPH
	{0xEB71,	0x8926},	// CJK UNIFIED IDEOGRAPH
	{0xEB72,	0x8930},	// CJK UNIFIED IDEOGRAPH
	{0xEB73,	0x892D},	// CJK UNIFIED IDEOGRAPH
	{0xEB74,	0x892E},	// CJK UNIFIED IDEOGRAPH
	{0xEB75,	0x8927},	// CJK UNIFIED IDEOGRAPH
	{0xEB76,	0x8931},	// CJK UNIFIED IDEOGRAPH
	{0xEB77,	0x8922},	// CJK UNIFIED IDEOGRAPH
	{0xEB78,	0x8929},	// CJK UNIFIED IDEOGRAPH
	{0xEB79,	0x8923},	// CJK UNIFIED IDEOGRAPH
	{0xEB7A,	0x892F},	// CJK UNIFIED IDEOGRAPH
	{0xEB7B,	0x892C},	// CJK UNIFIED IDEOGRAPH
	{0xEB7C,	0x891F},	// CJK UNIFIED IDEOGRAPH
	{0xEB7D,	0x89F1},	// CJK UNIFIED IDEOGRAPH
	{0xEB7E,	0x8AE0},	// CJK UNIFIED IDEOGRAPH
	{0xEBA1,	0x8AE2},	// CJK UNIFIED IDEOGRAPH
	{0xEBA2,	0x8AF2},	// CJK UNIFIED IDEOGRAPH
	{0xEBA3,	0x8AF4},	// CJK UNIFIED IDEOGRAPH
	{0xEBA4,	0x8AF5},	// CJK UNIFIED IDEOGRAPH
	{0xEBA5,	0x8ADD},	// CJK UNIFIED IDEOGRAPH
	{0xEBA6,	0x8B14},	// CJK UNIFIED IDEOGRAPH
	{0xEBA7,	0x8AE4},	// CJK UNIFIED IDEOGRAPH
	{0xEBA8,	0x8ADF},	// CJK UNIFIED IDEOGRAPH
	{0xEBA9,	0x8AF0},	// CJK UNIFIED IDEOGRAPH
	{0xEBAA,	0x8AC8},	// CJK UNIFIED IDEOGRAPH
	{0xEBAB,	0x8ADE},	// CJK UNIFIED IDEOGRAPH
	{0xEBAC,	0x8AE1},	// CJK UNIFIED IDEOGRAPH
	{0xEBAD,	0x8AE8},	// CJK UNIFIED IDEOGRAPH
	{0xEBAE,	0x8AFF},	// CJK UNIFIED IDEOGRAPH
	{0xEBAF,	0x8AEF},	// CJK UNIFIED IDEOGRAPH
	{0xEBB0,	0x8AFB},	// CJK UNIFIED IDEOGRAPH
	{0xEBB1,	0x8C91},	// CJK UNIFIED IDEOGRAPH
	{0xEBB2,	0x8C92},	// CJK UNIFIED IDEOGRAPH
	{0xEBB3,	0x8C90},	// CJK UNIFIED IDEOGRAPH
	{0xEBB4,	0x8CF5},	// CJK UNIFIED IDEOGRAPH
	{0xEBB5,	0x8CEE},	// CJK UNIFIED IDEOGRAPH
	{0xEBB6,	0x8CF1},	// CJK UNIFIED IDEOGRAPH
	{0xEBB7,	0x8CF0},	// CJK UNIFIED IDEOGRAPH
	{0xEBB8,	0x8CF3},	// CJK UNIFIED IDEOGRAPH
	{0xEBB9,	0x8D6C},	// CJK UNIFIED IDEOGRAPH
	{0xEBBA,	0x8D6E},	// CJK UNIFIED IDEOGRAPH
	{0xEBBB,	0x8DA5},	// CJK UNIFIED IDEOGRAPH
	{0xEBBC,	0x8DA7},	// CJK UNIFIED IDEOGRAPH
	{0xEBBD,	0x8E33},	// CJK UNIFIED IDEOGRAPH
	{0xEBBE,	0x8E3E},	// CJK UNIFIED IDEOGRAPH
	{0xEBBF,	0x8E38},	// CJK UNIFIED IDEOGRAPH
	{0xEBC0,	0x8E40},	// CJK UNIFIED IDEOGRAPH
	{0xEBC1,	0x8E45},	// CJK UNIFIED IDEOGRAPH
	{0xEBC2,	0x8E36},	// CJK UNIFIED IDEOGRAPH
	{0xEBC3,	0x8E3C},	// CJK UNIFIED IDEOGRAPH
	{0xEBC4,	0x8E3D},	// CJK UNIFIED IDEOGRAPH
	{0xEBC5,	0x8E41},	// CJK UNIFIED IDEOGRAPH
	{0xEBC6,	0x8E30},	// CJK UNIFIED IDEOGRAPH
	{0xEBC7,	0x8E3F},	// CJK UNIFIED IDEOGRAPH
	{0xEBC8,	0x8EBD},	// CJK UNIFIED IDEOGRAPH
	{0xEBC9,	0x8F36},	// CJK UNIFIED IDEOGRAPH
	{0xEBCA,	0x8F2E},	// CJK UNIFIED IDEOGRAPH
	{0xEBCB,	0x8F35},	// CJK UNIFIED IDEOGRAPH
	{0xEBCC,	0x8F32},	// CJK UNIFIED IDEOGRAPH
	{0xEBCD,	0x8F39},	// CJK UNIFIED IDEOGRAPH
	{0xEBCE,	0x8F37},	// CJK UNIFIED IDEOGRAPH
	{0xEBCF,	0x8F34},	// CJK UNIFIED IDEOGRAPH
	{0xEBD0,	0x9076},	// CJK UNIFIED IDEOGRAPH
	{0xEBD1,	0x9079},	// CJK UNIFIED IDEOGRAPH
	{0xEBD2,	0x907B},	// CJK UNIFIED IDEOGRAPH
	{0xEBD3,	0x9086},	// CJK UNIFIED IDEOGRAPH
	{0xEBD4,	0x90FA},	// CJK UNIFIED IDEOGRAPH
	{0xEBD5,	0x9133},	// CJK UNIFIED IDEOGRAPH
	{0xEBD6,	0x9135},	// CJK UNIFIED IDEOGRAPH
	{0xEBD7,	0x9136},	// CJK UNIFIED IDEOGRAPH
	{0xEBD8,	0x9193},	// CJK UNIFIED IDEOGRAPH
	{0xEBD9,	0x9190},	// CJK UNIFIED IDEOGRAPH
	{0xEBDA,	0x9191},	// CJK UNIFIED IDEOGRAPH
	{0xEBDB,	0x918D},	// CJK UNIFIED IDEOGRAPH
	{0xEBDC,	0x918F},	// CJK UNIFIED IDEOGRAPH
	{0xEBDD,	0x9327},	// CJK UNIFIED IDEOGRAPH
	{0xEBDE,	0x931E},	// CJK UNIFIED IDEOGRAPH
	{0xEBDF,	0x9308},	// CJK UNIFIED IDEOGRAPH
	{0xEBE0,	0x931F},	// CJK UNIFIED IDEOGRAPH
	{0xEBE1,	0x9306},	// CJK UNIFIED IDEOGRAPH
	{0xEBE2,	0x930F},	// CJK UNIFIED IDEOGRAPH
	{0xEBE3,	0x937A},	// CJK UNIFIED IDEOGRAPH
	{0xEBE4,	0x9338},	// CJK UNIFIED IDEOGRAPH
	{0xEBE5,	0x933C},	// CJK UNIFIED IDEOGRAPH
	{0xEBE6,	0x931B},	// CJK UNIFIED IDEOGRAPH
	{0xEBE7,	0x9323},	// CJK UNIFIED IDEOGRAPH
	{0xEBE8,	0x9312},	// CJK UNIFIED IDEOGRAPH
	{0xEBE9,	0x9301},	// CJK UNIFIED IDEOGRAPH
	{0xEBEA,	0x9346},	// CJK UNIFIED IDEOGRAPH
	{0xEBEB,	0x932D},	// CJK UNIFIED IDEOGRAPH
	{0xEBEC,	0x930E},	// CJK UNIFIED IDEOGRAPH
	{0xEBED,	0x930D},	// CJK UNIFIED IDEOGRAPH
	{0xEBEE,	0x92CB},	// CJK UNIFIED IDEOGRAPH
	{0xEBEF,	0x931D},	// CJK UNIFIED IDEOGRAPH
	{0xEBF0,	0x92FA},	// CJK UNIFIED IDEOGRAPH
	{0xEBF1,	0x9325},	// CJK UNIFIED IDEOGRAPH
	{0xEBF2,	0x9313},	// CJK UNIFIED IDEOGRAPH
	{0xEBF3,	0x92F9},	// CJK UNIFIED IDEOGRAPH
	{0xEBF4,	0x92F7},	// CJK UNIFIED IDEOGRAPH
	{0xEBF5,	0x9334},	// CJK UNIFIED IDEOGRAPH
	{0xEBF6,	0x9302},	// CJK UNIFIED IDEOGRAPH
	{0xEBF7,	0x9324},	// CJK UNIFIED IDEOGRAPH
	{0xEBF8,	0x92FF},	// CJK UNIFIED IDEOGRAPH
	{0xEBF9,	0x9329},	// CJK UNIFIED IDEOGRAPH
	{0xEBFA,	0x9339},	// CJK UNIFIED IDEOGRAPH
	{0xEBFB,	0x9335},	// CJK UNIFIED IDEOGRAPH
	{0xEBFC,	0x932A},	// CJK UNIFIED IDEOGRAPH
	{0xEBFD,	0x9314},	// CJK UNIFIED IDEOGRAPH
	{0xEBFE,	0x930C},	// CJK UNIFIED IDEOGRAPH
	{0xEC40,	0x930B},	// CJK UNIFIED IDEOGRAPH
	{0xEC41,	0x92FE},	// CJK UNIFIED IDEOGRAPH
	{0xEC42,	0x9309},	// CJK UNIFIED IDEOGRAPH
	{0xEC43,	0x9300},	// CJK UNIFIED IDEOGRAPH
	{0xEC44,	0x92FB},	// CJK UNIFIED IDEOGRAPH
	{0xEC45,	0x9316},	// CJK UNIFIED IDEOGRAPH
	{0xEC46,	0x95BC},	// CJK UNIFIED IDEOGRAPH
	{0xEC47,	0x95CD},	// CJK UNIFIED IDEOGRAPH
	{0xEC48,	0x95BE},	// CJK UNIFIED IDEOGRAPH
	{0xEC49,	0x95B9},	// CJK UNIFIED IDEOGRAPH
	{0xEC4A,	0x95BA},	// CJK UNIFIED IDEOGRAPH
	{0xEC4B,	0x95B6},	// CJK UNIFIED IDEOGRAPH
	{0xEC4C,	0x95BF},	// CJK UNIFIED IDEOGRAPH
	{0xEC4D,	0x95B5},	// CJK UNIFIED IDEOGRAPH
	{0xEC4E,	0x95BD},	// CJK UNIFIED IDEOGRAPH
	{0xEC4F,	0x96A9},	// CJK UNIFIED IDEOGRAPH
	{0xEC50,	0x96D4},	// CJK UNIFIED IDEOGRAPH
	{0xEC51,	0x970B},	// CJK UNIFIED IDEOGRAPH
	{0xEC52,	0x9712},	// CJK UNIFIED IDEOGRAPH
	{0xEC53,	0x9710},	// CJK UNIFIED IDEOGRAPH
	{0xEC54,	0x9799},	// CJK UNIFIED IDEOGRAPH
	{0xEC55,	0x9797},	// CJK UNIFIED IDEOGRAPH
	{0xEC56,	0x9794},	// CJK UNIFIED IDEOGRAPH
	{0xEC57,	0x97F0},	// CJK UNIFIED IDEOGRAPH
	{0xEC58,	0x97F8},	// CJK UNIFIED IDEOGRAPH
	{0xEC59,	0x9835},	// CJK UNIFIED IDEOGRAPH
	{0xEC5A,	0x982F},	// CJK UNIFIED IDEOGRAPH
	{0xEC5B,	0x9832},	// CJK UNIFIED IDEOGRAPH
	{0xEC5C,	0x9924},	// CJK UNIFIED IDEOGRAPH
	{0xEC5D,	0x991F},	// CJK UNIFIED IDEOGRAPH
	{0xEC5E,	0x9927},	// CJK UNIFIED IDEOGRAPH
	{0xEC5F,	0x9929},	// CJK UNIFIED IDEOGRAPH
	{0xEC60,	0x999E},	// CJK UNIFIED IDEOGRAPH
	{0xEC61,	0x99EE},	// CJK UNIFIED IDEOGRAPH
	{0xEC62,	0x99EC},	// CJK UNIFIED IDEOGRAPH
	{0xEC63,	0x99E5},	// CJK UNIFIED IDEOGRAPH
	{0xEC64,	0x99E4},	// CJK UNIFIED IDEOGRAPH
	{0xEC65,	0x99F0},	// CJK UNIFIED IDEOGRAPH
	{0xEC66,	0x99E3},	// CJK UNIFIED IDEOGRAPH
	{0xEC67,	0x99EA},	// CJK UNIFIED IDEOGRAPH
	{0xEC68,	0x99E9},	// CJK UNIFIED IDEOGRAPH
	{0xEC69,	0x99E7},	// CJK UNIFIED IDEOGRAPH
	{0xEC6A,	0x9AB9},	// CJK UNIFIED IDEOGRAPH
	{0xEC6B,	0x9ABF},	// CJK UNIFIED IDEOGRAPH
	{0xEC6C,	0x9AB4},	// CJK UNIFIED IDEOGRAPH
	{0xEC6D,	0x9ABB},	// CJK UNIFIED IDEOGRAPH
	{0xEC6E,	0x9AF6},	// CJK UNIFIED IDEOGRAPH
	{0xEC6F,	0x9AFA},	// CJK UNIFIED IDEOGRAPH
	{0xEC70,	0x9AF9},	// CJK UNIFIED IDEOGRAPH
	{0xEC71,	0x9AF7},	// CJK UNIFIED IDEOGRAPH
	{0xEC72,	0x9B33},	// CJK UNIFIED IDEOGRAPH
	{0xEC73,	0x9B80},	// CJK UNIFIED IDEOGRAPH
	{0xEC74,	0x9B85},	// CJK UNIFIED IDEOGRAPH
	{0xEC75,	0x9B87},	// CJK UNIFIED IDEOGRAPH
	{0xEC76,	0x9B7C},	// CJK UNIFIED IDEOGRAPH
	{0xEC77,	0x9B7E},	// CJK UNIFIED IDEOGRAPH
	{0xEC78,	0x9B7B},	// CJK UNIFIED IDEOGRAPH
	{0xEC79,	0x9B82},	// CJK UNIFIED IDEOGRAPH
	{0xEC7A,	0x9B93},	// CJK UNIFIED IDEOGRAPH
	{0xEC7B,	0x9B92},	// CJK UNIFIED IDEOGRAPH
	{0xEC7C,	0x9B90},	// CJK UNIFIED IDEOGRAPH
	{0xEC7D,	0x9B7A},	// CJK UNIFIED IDEOGRAPH
	{0xEC7E,	0x9B95},	// CJK UNIFIED IDEOGRAPH
	{0xECA1,	0x9B7D},	// CJK UNIFIED IDEOGRAPH
	{0xECA2,	0x9B88},	// CJK UNIFIED IDEOGRAPH
	{0xECA3,	0x9D25},	// CJK UNIFIED IDEOGRAPH
	{0xECA4,	0x9D17},	// CJK UNIFIED IDEOGRAPH
	{0xECA5,	0x9D20},	// CJK UNIFIED IDEOGRAPH
	{0xECA6,	0x9D1E},	// CJK UNIFIED IDEOGRAPH
	{0xECA7,	0x9D14},	// CJK UNIFIED IDEOGRAPH
	{0xECA8,	0x9D29},	// CJK UNIFIED IDEOGRAPH
	{0xECA9,	0x9D1D},	// CJK UNIFIED IDEOGRAPH
	{0xECAA,	0x9D18},	// CJK UNIFIED IDEOGRAPH
	{0xECAB,	0x9D22},	// CJK UNIFIED IDEOGRAPH
	{0xECAC,	0x9D10},	// CJK UNIFIED IDEOGRAPH
	{0xECAD,	0x9D19},	// CJK UNIFIED IDEOGRAPH
	{0xECAE,	0x9D1F},	// CJK UNIFIED IDEOGRAPH
	{0xECAF,	0x9E88},	// CJK UNIFIED IDEOGRAPH
	{0xECB0,	0x9E86},	// CJK UNIFIED IDEOGRAPH
	{0xECB1,	0x9E87},	// CJK UNIFIED IDEOGRAPH
	{0xECB2,	0x9EAE},	// CJK UNIFIED IDEOGRAPH
	{0xECB3,	0x9EAD},	// CJK UNIFIED IDEOGRAPH
	{0xECB4,	0x9ED5},	// CJK UNIFIED IDEOGRAPH
	{0xECB5,	0x9ED6},	// CJK UNIFIED IDEOGRAPH
	{0xECB6,	0x9EFA},	// CJK UNIFIED IDEOGRAPH
	{0xECB7,	0x9F12},	// CJK UNIFIED IDEOGRAPH
	{0xECB8,	0x9F3D},	// CJK UNIFIED IDEOGRAPH
	{0xECB9,	0x5126},	// CJK UNIFIED IDEOGRAPH
	{0xECBA,	0x5125},	// CJK UNIFIED IDEOGRAPH
	{0xECBB,	0x5122},	// CJK UNIFIED IDEOGRAPH
	{0xECBC,	0x5124},	// CJK UNIFIED IDEOGRAPH
	{0xECBD,	0x5120},	// CJK UNIFIED IDEOGRAPH
	{0xECBE,	0x5129},	// CJK UNIFIED IDEOGRAPH
	{0xECBF,	0x52F4},	// CJK UNIFIED IDEOGRAPH
	{0xECC0,	0x5693},	// CJK UNIFIED IDEOGRAPH
	{0xECC1,	0x568C},	// CJK UNIFIED IDEOGRAPH
	{0xECC2,	0x568D},	// CJK UNIFIED IDEOGRAPH
	{0xECC3,	0x5686},	// CJK UNIFIED IDEOGRAPH
	{0xECC4,	0x5684},	// CJK UNIFIED IDEOGRAPH
	{0xECC5,	0x5683},	// CJK UNIFIED IDEOGRAPH
	{0xECC6,	0x567E},	// CJK UNIFIED IDEOGRAPH
	{0xECC7,	0x5682},	// CJK UNIFIED IDEOGRAPH
	{0xECC8,	0x567F},	// CJK UNIFIED IDEOGRAPH
	{0xECC9,	0x5681},	// CJK UNIFIED IDEOGRAPH
	{0xECCA,	0x58D6},	// CJK UNIFIED IDEOGRAPH
	{0xECCB,	0x58D4},	// CJK UNIFIED IDEOGRAPH
	{0xECCC,	0x58CF},	// CJK UNIFIED IDEOGRAPH
	{0xECCD,	0x58D2},	// CJK UNIFIED IDEOGRAPH
	{0xECCE,	0x5B2D},	// CJK UNIFIED IDEOGRAPH
	{0xECCF,	0x5B25},	// CJK UNIFIED IDEOGRAPH
	{0xECD0,	0x5B32},	// CJK UNIFIED IDEOGRAPH
	{0xECD1,	0x5B23},	// CJK UNIFIED IDEOGRAPH
	{0xECD2,	0x5B2C},	// CJK UNIFIED IDEOGRAPH
	{0xECD3,	0x5B27},	// CJK UNIFIED IDEOGRAPH
	{0xECD4,	0x5B26},	// CJK UNIFIED IDEOGRAPH
	{0xECD5,	0x5B2F},	// CJK UNIFIED IDEOGRAPH
	{0xECD6,	0x5B2E},	// CJK UNIFIED IDEOGRAPH
	{0xECD7,	0x5B7B},	// CJK UNIFIED IDEOGRAPH
	{0xECD8,	0x5BF1},	// CJK UNIFIED IDEOGRAPH
	{0xECD9,	0x5BF2},	// CJK UNIFIED IDEOGRAPH
	{0xECDA,	0x5DB7},	// CJK UNIFIED IDEOGRAPH
	{0xECDB,	0x5E6C},	// CJK UNIFIED IDEOGRAPH
	{0xECDC,	0x5E6A},	// CJK UNIFIED IDEOGRAPH
	{0xECDD,	0x5FBE},	// CJK UNIFIED IDEOGRAPH
	{0xECDE,	0x5FBB},	// CJK UNIFIED IDEOGRAPH
	{0xECDF,	0x61C3},	// CJK UNIFIED IDEOGRAPH
	{0xECE0,	0x61B5},	// CJK UNIFIED IDEOGRAPH
	{0xECE1,	0x61BC},	// CJK UNIFIED IDEOGRAPH
	{0xECE2,	0x61E7},	// CJK UNIFIED IDEOGRAPH
	{0xECE3,	0x61E0},	// CJK UNIFIED IDEOGRAPH
	{0xECE4,	0x61E5},	// CJK UNIFIED IDEOGRAPH
	{0xECE5,	0x61E4},	// CJK UNIFIED IDEOGRAPH
	{0xECE6,	0x61E8},	// CJK UNIFIED IDEOGRAPH
	{0xECE7,	0x61DE},	// CJK UNIFIED IDEOGRAPH
	{0xECE8,	0x64EF},	// CJK UNIFIED IDEOGRAPH
	{0xECE9,	0x64E9},	// CJK UNIFIED IDEOGRAPH
	{0xECEA,	0x64E3},	// CJK UNIFIED IDEOGRAPH
	{0xECEB,	0x64EB},	// CJK UNIFIED IDEOGRAPH
	{0xECEC,	0x64E4},	// CJK UNIFIED IDEOGRAPH
	{0xECED,	0x64E8},	// CJK UNIFIED IDEOGRAPH
	{0xECEE,	0x6581},	// CJK UNIFIED IDEOGRAPH
	{0xECEF,	0x6580},	// CJK UNIFIED IDEOGRAPH
	{0xECF0,	0x65B6},	// CJK UNIFIED IDEOGRAPH
	{0xECF1,	0x65DA},	// CJK UNIFIED IDEOGRAPH
	{0xECF2,	0x66D2},	// CJK UNIFIED IDEOGRAPH
	{0xECF3,	0x6A8D},	// CJK UNIFIED IDEOGRAPH
	{0xECF4,	0x6A96},	// CJK UNIFIED IDEOGRAPH
	{0xECF5,	0x6A81},	// CJK UNIFIED IDEOGRAPH
	{0xECF6,	0x6AA5},	// CJK UNIFIED IDEOGRAPH
	{0xECF7,	0x6A89},	// CJK UNIFIED IDEOGRAPH
	{0xECF8,	0x6A9F},	// CJK UNIFIED IDEOGRAPH
	{0xECF9,	0x6A9B},	// CJK UNIFIED IDEOGRAPH
	{0xECFA,	0x6AA1},	// CJK UNIFIED IDEOGRAPH
	{0xECFB,	0x6A9E},	// CJK UNIFIED IDEOGRAPH
	{0xECFC,	0x6A87},	// CJK UNIFIED IDEOGRAPH
	{0xECFD,	0x6A93},	// CJK UNIFIED IDEOGRAPH
	{0xECFE,	0x6A8E},	// CJK UNIFIED IDEOGRAPH
	{0xED40,	0x6A95},	// CJK UNIFIED IDEOGRAPH
	{0xED41,	0x6A83},	// CJK UNIFIED IDEOGRAPH
	{0xED42,	0x6AA8},	// CJK UNIFIED IDEOGRAPH
	{0xED43,	0x6AA4},	// CJK UNIFIED IDEOGRAPH
	{0xED44,	0x6A91},	// CJK UNIFIED IDEOGRAPH
	{0xED45,	0x6A7F},	// CJK UNIFIED IDEOGRAPH
	{0xED46,	0x6AA6},	// CJK UNIFIED IDEOGRAPH
	{0xED47,	0x6A9A},	// CJK UNIFIED IDEOGRAPH
	{0xED48,	0x6A85},	// CJK UNIFIED IDEOGRAPH
	{0xED49,	0x6A8C},	// CJK UNIFIED IDEOGRAPH
	{0xED4A,	0x6A92},	// CJK UNIFIED IDEOGRAPH
	{0xED4B,	0x6B5B},	// CJK UNIFIED IDEOGRAPH
	{0xED4C,	0x6BAD},	// CJK UNIFIED IDEOGRAPH
	{0xED4D,	0x6C09},	// CJK UNIFIED IDEOGRAPH
	{0xED4E,	0x6FCC},	// CJK UNIFIED IDEOGRAPH
	{0xED4F,	0x6FA9},	// CJK UNIFIED IDEOGRAPH
	{0xED50,	0x6FF4},	// CJK UNIFIED IDEOGRAPH
	{0xED51,	0x6FD4},	// CJK UNIFIED IDEOGRAPH
	{0xED52,	0x6FE3},	// CJK UNIFIED IDEOGRAPH
	{0xED53,	0x6FDC},	// CJK UNIFIED IDEOGRAPH
	{0xED54,	0x6FED},	// CJK UNIFIED IDEOGRAPH
	{0xED55,	0x6FE7},	// CJK UNIFIED IDEOGRAPH
	{0xED56,	0x6FE6},	// CJK UNIFIED IDEOGRAPH
	{0xED57,	0x6FDE},	// CJK UNIFIED IDEOGRAPH
	{0xED58,	0x6FF2},	// CJK UNIFIED IDEOGRAPH
	{0xED59,	0x6FDD},	// CJK UNIFIED IDEOGRAPH
	{0xED5A,	0x6FE2},	// CJK UNIFIED IDEOGRAPH
	{0xED5B,	0x6FE8},	// CJK UNIFIED IDEOGRAPH
	{0xED5C,	0x71E1},	// CJK UNIFIED IDEOGRAPH
	{0xED5D,	0x71F1},	// CJK UNIFIED IDEOGRAPH
	{0xED5E,	0x71E8},	// CJK UNIFIED IDEOGRAPH
	{0xED5F,	0x71F2},	// CJK UNIFIED IDEOGRAPH
	{0xED60,	0x71E4},	// CJK UNIFIED IDEOGRAPH
	{0xED61,	0x71F0},	// CJK UNIFIED IDEOGRAPH
	{0xED62,	0x71E2},	// CJK UNIFIED IDEOGRAPH
	{0xED63,	0x7373},	// CJK UNIFIED IDEOGRAPH
	{0xED64,	0x736E},	// CJK UNIFIED IDEOGRAPH
	{0xED65,	0x736F},	// CJK UNIFIED IDEOGRAPH
	{0xED66,	0x7497},	// CJK UNIFIED IDEOGRAPH
	{0xED67,	0x74B2},	// CJK UNIFIED IDEOGRAPH
	{0xED68,	0x74AB},	// CJK UNIFIED IDEOGRAPH
	{0xED69,	0x7490},	// CJK UNIFIED IDEOGRAPH
	{0xED6A,	0x74AA},	// CJK UNIFIED IDEOGRAPH
	{0xED6B,	0x74AD},	// CJK UNIFIED IDEOGRAPH
	{0xED6C,	0x74B1},	// CJK UNIFIED IDEOGRAPH
	{0xED6D,	0x74A5},	// CJK UNIFIED IDEOGRAPH
	{0xED6E,	0x74AF},	// CJK UNIFIED IDEOGRAPH
	{0xED6F,	0x7510},	// CJK UNIFIED IDEOGRAPH
	{0xED70,	0x7511},	// CJK UNIFIED IDEOGRAPH
	{0xED71,	0x7512},	// CJK UNIFIED IDEOGRAPH
	{0xED72,	0x750F},	// CJK UNIFIED IDEOGRAPH
	{0xED73,	0x7584},	// CJK UNIFIED IDEOGRAPH
	{0xED74,	0x7643},	// CJK UNIFIED IDEOGRAPH
	{0xED75,	0x7648},	// CJK UNIFIED IDEOGRAPH
	{0xED76,	0x7649},	// CJK UNIFIED IDEOGRAPH
	{0xED77,	0x7647},	// CJK UNIFIED IDEOGRAPH
	{0xED78,	0x76A4},	// CJK UNIFIED IDEOGRAPH
	{0xED79,	0x76E9},	// CJK UNIFIED IDEOGRAPH
	{0xED7A,	0x77B5},	// CJK UNIFIED IDEOGRAPH
	{0xED7B,	0x77AB},	// CJK UNIFIED IDEOGRAPH
	{0xED7C,	0x77B2},	// CJK UNIFIED IDEOGRAPH
	{0xED7D,	0x77B7},	// CJK UNIFIED IDEOGRAPH
	{0xED7E,	0x77B6},	// CJK UNIFIED IDEOGRAPH
	{0xEDA1,	0x77B4},	// CJK UNIFIED IDEOGRAPH
	{0xEDA2,	0x77B1},	// CJK UNIFIED IDEOGRAPH
	{0xEDA3,	0x77A8},	// CJK UNIFIED IDEOGRAPH
	{0xEDA4,	0x77F0},	// CJK UNIFIED IDEOGRAPH
	{0xEDA5,	0x78F3},	// CJK UNIFIED IDEOGRAPH
	{0xEDA6,	0x78FD},	// CJK UNIFIED IDEOGRAPH
	{0xEDA7,	0x7902},	// CJK UNIFIED IDEOGRAPH
	{0xEDA8,	0x78FB},	// CJK UNIFIED IDEOGRAPH
	{0xEDA9,	0x78FC},	// CJK UNIFIED IDEOGRAPH
	{0xEDAA,	0x78F2},	// CJK UNIFIED IDEOGRAPH
	{0xEDAB,	0x7905},	// CJK UNIFIED IDEOGRAPH
	{0xEDAC,	0x78F9},	// CJK UNIFIED IDEOGRAPH
	{0xEDAD,	0x78FE},	// CJK UNIFIED IDEOGRAPH
	{0xEDAE,	0x7904},	// CJK UNIFIED IDEOGRAPH
	{0xEDAF,	0x79AB},	// CJK UNIFIED IDEOGRAPH
	{0xEDB0,	0x79A8},	// CJK UNIFIED IDEOGRAPH
	{0xEDB1,	0x7A5C},	// CJK UNIFIED IDEOGRAPH
	{0xEDB2,	0x7A5B},	// CJK UNIFIED IDEOGRAPH
	{0xEDB3,	0x7A56},	// CJK UNIFIED IDEOGRAPH
	{0xEDB4,	0x7A58},	// CJK UNIFIED IDEOGRAPH
	{0xEDB5,	0x7A54},	// CJK UNIFIED IDEOGRAPH
	{0xEDB6,	0x7A5A},	// CJK UNIFIED IDEOGRAPH
	{0xEDB7,	0x7ABE},	// CJK UNIFIED IDEOGRAPH
	{0xEDB8,	0x7AC0},	// CJK UNIFIED IDEOGRAPH
	{0xEDB9,	0x7AC1},	// CJK UNIFIED IDEOGRAPH
	{0xEDBA,	0x7C05},	// CJK UNIFIED IDEOGRAPH
	{0xEDBB,	0x7C0F},	// CJK UNIFIED IDEOGRAPH
	{0xEDBC,	0x7BF2},	// CJK UNIFIED IDEOGRAPH
	{0xEDBD,	0x7C00},	// CJK UNIFIED IDEOGRAPH
	{0xEDBE,	0x7BFF},	// CJK UNIFIED IDEOGRAPH
	{0xEDBF,	0x7BFB},	// CJK UNIFIED IDEOGRAPH
	{0xEDC0,	0x7C0E},	// CJK UNIFIED IDEOGRAPH
	{0xEDC1,	0x7BF4},	// CJK UNIFIED IDEOGRAPH
	{0xEDC2,	0x7C0B},	// CJK UNIFIED IDEOGRAPH
	{0xEDC3,	0x7BF3},	// CJK UNIFIED IDEOGRAPH
	{0xEDC4,	0x7C02},	// CJK UNIFIED IDEOGRAPH
	{0xEDC5,	0x7C09},	// CJK UNIFIED IDEOGRAPH
	{0xEDC6,	0x7C03},	// CJK UNIFIED IDEOGRAPH
	{0xEDC7,	0x7C01},	// CJK UNIFIED IDEOGRAPH
	{0xEDC8,	0x7BF8},	// CJK UNIFIED IDEOGRAPH
	{0xEDC9,	0x7BFD},	// CJK UNIFIED IDEOGRAPH
	{0xEDCA,	0x7C06},	// CJK UNIFIED IDEOGRAPH
	{0xEDCB,	0x7BF0},	// CJK UNIFIED IDEOGRAPH
	{0xEDCC,	0x7BF1},	// CJK UNIFIED IDEOGRAPH
	{0xEDCD,	0x7C10},	// CJK UNIFIED IDEOGRAPH
	{0xEDCE,	0x7C0A},	// CJK UNIFIED IDEOGRAPH
	{0xEDCF,	0x7CE8},	// CJK UNIFIED IDEOGRAPH
	{0xEDD0,	0x7E2D},	// CJK UNIFIED IDEOGRAPH
	{0xEDD1,	0x7E3C},	// CJK UNIFIED IDEOGRAPH
	{0xEDD2,	0x7E42},	// CJK UNIFIED IDEOGRAPH
	{0xEDD3,	0x7E33},	// CJK UNIFIED IDEOGRAPH
	{0xEDD4,	0x9848},	// CJK UNIFIED IDEOGRAPH
	{0xEDD5,	0x7E38},	// CJK UNIFIED IDEOGRAPH
	{0xEDD6,	0x7E2A},	// CJK UNIFIED IDEOGRAPH
	{0xEDD7,	0x7E49},	// CJK UNIFIED IDEOGRAPH
	{0xEDD8,	0x7E40},	// CJK UNIFIED IDEOGRAPH
	{0xEDD9,	0x7E47},	// CJK UNIFIED IDEOGRAPH
	{0xEDDA,	0x7E29},	// CJK UNIFIED IDEOGRAPH
	{0xEDDB,	0x7E4C},	// CJK UNIFIED IDEOGRAPH
	{0xEDDC,	0x7E30},	// CJK UNIFIED IDEOGRAPH
	{0xEDDD,	0x7E3B},	// CJK UNIFIED IDEOGRAPH
	{0xEDDE,	0x7E36},	// CJK UNIFIED IDEOGRAPH
	{0xEDDF,	0x7E44},	// CJK UNIFIED IDEOGRAPH
	{0xEDE0,	0x7E3A},	// CJK UNIFIED IDEOGRAPH
	{0xEDE1,	0x7F45},	// CJK UNIFIED IDEOGRAPH
	{0xEDE2,	0x7F7F},	// CJK UNIFIED IDEOGRAPH
	{0xEDE3,	0x7F7E},	// CJK UNIFIED IDEOGRAPH
	{0xEDE4,	0x7F7D},	// CJK UNIFIED IDEOGRAPH
	{0xEDE5,	0x7FF4},	// CJK UNIFIED IDEOGRAPH
	{0xEDE6,	0x7FF2},	// CJK UNIFIED IDEOGRAPH
	{0xEDE7,	0x802C},	// CJK UNIFIED IDEOGRAPH
	{0xEDE8,	0x81BB},	// CJK UNIFIED IDEOGRAPH
	{0xEDE9,	0x81C4},	// CJK UNIFIED IDEOGRAPH
	{0xEDEA,	0x81CC},	// CJK UNIFIED IDEOGRAPH
	{0xEDEB,	0x81CA},	// CJK UNIFIED IDEOGRAPH
	{0xEDEC,	0x81C5},	// CJK UNIFIED IDEOGRAPH
	{0xEDED,	0x81C7},	// CJK UNIFIED IDEOGRAPH
	{0xEDEE,	0x81BC},	// CJK UNIFIED IDEOGRAPH
	{0xEDEF,	0x81E9},	// CJK UNIFIED IDEOGRAPH
	{0xEDF0,	0x825B},	// CJK UNIFIED IDEOGRAPH
	{0xEDF1,	0x825A},	// CJK UNIFIED IDEOGRAPH
	{0xEDF2,	0x825C},	// CJK UNIFIED IDEOGRAPH
	{0xEDF3,	0x8583},	// CJK UNIFIED IDEOGRAPH
	{0xEDF4,	0x8580},	// CJK UNIFIED IDEOGRAPH
	{0xEDF5,	0x858F},	// CJK UNIFIED IDEOGRAPH
	{0xEDF6,	0x85A7},	// CJK UNIFIED IDEOGRAPH
	{0xEDF7,	0x8595},	// CJK UNIFIED IDEOGRAPH
	{0xEDF8,	0x85A0},	// CJK UNIFIED IDEOGRAPH
	{0xEDF9,	0x858B},	// CJK UNIFIED IDEOGRAPH
	{0xEDFA,	0x85A3},	// CJK UNIFIED IDEOGRAPH
	{0xEDFB,	0x857B},	// CJK UNIFIED IDEOGRAPH
	{0xEDFC,	0x85A4},	// CJK UNIFIED IDEOGRAPH
	{0xEDFD,	0x859A},	// CJK UNIFIED IDEOGRAPH
	{0xEDFE,	0x859E},	// CJK UNIFIED IDEOGRAPH
	{0xEE40,	0x8577},	// CJK UNIFIED IDEOGRAPH
	{0xEE41,	0x857C},	// CJK UNIFIED IDEOGRAPH
	{0xEE42,	0x8589},	// CJK UNIFIED IDEOGRAPH
	{0xEE43,	0x85A1},	// CJK UNIFIED IDEOGRAPH
	{0xEE44,	0x857A},	// CJK UNIFIED IDEOGRAPH
	{0xEE45,	0x8578},	// CJK UNIFIED IDEOGRAPH
	{0xEE46,	0x8557},	// CJK UNIFIED IDEOGRAPH
	{0xEE47,	0x858E},	// CJK UNIFIED IDEOGRAPH
	{0xEE48,	0x8596},	// CJK UNIFIED IDEOGRAPH
	{0xEE49,	0x8586},	// CJK UNIFIED IDEOGRAPH
	{0xEE4A,	0x858D},	// CJK UNIFIED IDEOGRAPH
	{0xEE4B,	0x8599},	// CJK UNIFIED IDEOGRAPH
	{0xEE4C,	0x859D},	// CJK UNIFIED IDEOGRAPH
	{0xEE4D,	0x8581},	// CJK UNIFIED IDEOGRAPH
	{0xEE4E,	0x85A2},	// CJK UNIFIED IDEOGRAPH
	{0xEE4F,	0x8582},	// CJK UNIFIED IDEOGRAPH
	{0xEE50,	0x8588},	// CJK UNIFIED IDEOGRAPH
	{0xEE51,	0x8585},	// CJK UNIFIED IDEOGRAPH
	{0xEE52,	0x8579},	// CJK UNIFIED IDEOGRAPH
	{0xEE53,	0x8576},	// CJK UNIFIED IDEOGRAPH
	{0xEE54,	0x8598},	// CJK UNIFIED IDEOGRAPH
	{0xEE55,	0x8590},	// CJK UNIFIED IDEOGRAPH
	{0xEE56,	0x859F},	// CJK UNIFIED IDEOGRAPH
	{0xEE57,	0x8668},	// CJK UNIFIED IDEOGRAPH
	{0xEE58,	0x87BE},	// CJK UNIFIED IDEOGRAPH
	{0xEE59,	0x87AA},	// CJK UNIFIED IDEOGRAPH
	{0xEE5A,	0x87AD},	// CJK UNIFIED IDEOGRAPH
	{0xEE5B,	0x87C5},	// CJK UNIFIED IDEOGRAPH
	{0xEE5C,	0x87B0},	// CJK UNIFIED IDEOGRAPH
	{0xEE5D,	0x87AC},	// CJK UNIFIED IDEOGRAPH
	{0xEE5E,	0x87B9},	// CJK UNIFIED IDEOGRAPH
	{0xEE5F,	0x87B5},	// CJK UNIFIED IDEOGRAPH
	{0xEE60,	0x87BC},	// CJK UNIFIED IDEOGRAPH
	{0xEE61,	0x87AE},	// CJK UNIFIED IDEOGRAPH
	{0xEE62,	0x87C9},	// CJK UNIFIED IDEOGRAPH
	{0xEE63,	0x87C3},	// CJK UNIFIED IDEOGRAPH
	{0xEE64,	0x87C2},	// CJK UNIFIED IDEOGRAPH
	{0xEE65,	0x87CC},	// CJK UNIFIED IDEOGRAPH
	{0xEE66,	0x87B7},	// CJK UNIFIED IDEOGRAPH
	{0xEE67,	0x87AF},	// CJK UNIFIED IDEOGRAPH
	{0xEE68,	0x87C4},	// CJK UNIFIED IDEOGRAPH
	{0xEE69,	0x87CA},	// CJK UNIFIED IDEOGRAPH
	{0xEE6A,	0x87B4},	// CJK UNIFIED IDEOGRAPH
	{0xEE6B,	0x87B6},	// CJK UNIFIED IDEOGRAPH
	{0xEE6C,	0x87BF},	// CJK UNIFIED IDEOGRAPH
	{0xEE6D,	0x87B8},	// CJK UNIFIED IDEOGRAPH
	{0xEE6E,	0x87BD},	// CJK UNIFIED IDEOGRAPH
	{0xEE6F,	0x87DE},	// CJK UNIFIED IDEOGRAPH
	{0xEE70,	0x87B2},	// CJK UNIFIED IDEOGRAPH
	{0xEE71,	0x8935},	// CJK UNIFIED IDEOGRAPH
	{0xEE72,	0x8933},	// CJK UNIFIED IDEOGRAPH
	{0xEE73,	0x893C},	// CJK UNIFIED IDEOGRAPH
	{0xEE74,	0x893E},	// CJK UNIFIED IDEOGRAPH
	{0xEE75,	0x8941},	// CJK UNIFIED IDEOGRAPH
	{0xEE76,	0x8952},	// CJK UNIFIED IDEOGRAPH
	{0xEE77,	0x8937},	// CJK UNIFIED IDEOGRAPH
	{0xEE78,	0x8942},	// CJK UNIFIED IDEOGRAPH
	{0xEE79,	0x89AD},	// CJK UNIFIED IDEOGRAPH
	{0xEE7A,	0x89AF},	// CJK UNIFIED IDEOGRAPH
	{0xEE7B,	0x89AE},	// CJK UNIFIED IDEOGRAPH
	{0xEE7C,	0x89F2},	// CJK UNIFIED IDEOGRAPH
	{0xEE7D,	0x89F3},	// CJK UNIFIED IDEOGRAPH
	{0xEE7E,	0x8B1E},	// CJK UNIFIED IDEOGRAPH
	{0xEEA1,	0x8B18},	// CJK UNIFIED IDEOGRAPH
	{0xEEA2,	0x8B16},	// CJK UNIFIED IDEOGRAPH
	{0xEEA3,	0x8B11},	// CJK UNIFIED IDEOGRAPH
	{0xEEA4,	0x8B05},	// CJK UNIFIED IDEOGRAPH
	{0xEEA5,	0x8B0B},	// CJK UNIFIED IDEOGRAPH
	{0xEEA6,	0x8B22},	// CJK UNIFIED IDEOGRAPH
	{0xEEA7,	0x8B0F},	// CJK UNIFIED IDEOGRAPH
	{0xEEA8,	0x8B12},	// CJK UNIFIED IDEOGRAPH
	{0xEEA9,	0x8B15},	// CJK UNIFIED IDEOGRAPH
	{0xEEAA,	0x8B07},	// CJK UNIFIED IDEOGRAPH
	{0xEEAB,	0x8B0D},	// CJK UNIFIED IDEOGRAPH
	{0xEEAC,	0x8B08},	// CJK UNIFIED IDEOGRAPH
	{0xEEAD,	0x8B06},	// CJK UNIFIED IDEOGRAPH
	{0xEEAE,	0x8B1C},	// CJK UNIFIED IDEOGRAPH
	{0xEEAF,	0x8B13},	// CJK UNIFIED IDEOGRAPH
	{0xEEB0,	0x8B1A},	// CJK UNIFIED IDEOGRAPH
	{0xEEB1,	0x8C4F},	// CJK UNIFIED IDEOGRAPH
	{0xEEB2,	0x8C70},	// CJK UNIFIED IDEOGRAPH
	{0xEEB3,	0x8C72},	// CJK UNIFIED IDEOGRAPH
	{0xEEB4,	0x8C71},	// CJK UNIFIED IDEOGRAPH
	{0xEEB5,	0x8C6F},	// CJK UNIFIED IDEOGRAPH
	{0xEEB6,	0x8C95},	// CJK UNIFIED IDEOGRAPH
	{0xEEB7,	0x8C94},	// CJK UNIFIED IDEOGRAPH
	{0xEEB8,	0x8CF9},	// CJK UNIFIED IDEOGRAPH
	{0xEEB9,	0x8D6F},	// CJK UNIFIED IDEOGRAPH
	{0xEEBA,	0x8E4E},	// CJK UNIFIED IDEOGRAPH
	{0xEEBB,	0x8E4D},	// CJK UNIFIED IDEOGRAPH
	{0xEEBC,	0x8E53},	// CJK UNIFIED IDEOGRAPH
	{0xEEBD,	0x8E50},	// CJK UNIFIED IDEOGRAPH
	{0xEEBE,	0x8E4C},	// CJK UNIFIED IDEOGRAPH
	{0xEEBF,	0x8E47},	// CJK UNIFIED IDEOGRAPH
	{0xEEC0,	0x8F43},	// CJK UNIFIED IDEOGRAPH
	{0xEEC1,	0x8F40},	// CJK UNIFIED IDEOGRAPH
	{0xEEC2,	0x9085},	// CJK UNIFIED IDEOGRAPH
	{0xEEC3,	0x907E},	// CJK UNIFIED IDEOGRAPH
	{0xEEC4,	0x9138},	// CJK UNIFIED IDEOGRAPH
	{0xEEC5,	0x919A},	// CJK UNIFIED IDEOGRAPH
	{0xEEC6,	0x91A2},	// CJK UNIFIED IDEOGRAPH
	{0xEEC7,	0x919B},	// CJK UNIFIED IDEOGRAPH
	{0xEEC8,	0x9199},	// CJK UNIFIED IDEOGRAPH
	{0xEEC9,	0x919F},	// CJK UNIFIED IDEOGRAPH
	{0xEECA,	0x91A1},	// CJK UNIFIED IDEOGRAPH
	{0xEECB,	0x919D},	// CJK UNIFIED IDEOGRAPH
	{0xEECC,	0x91A0},	// CJK UNIFIED IDEOGRAPH
	{0xEECD,	0x93A1},	// CJK UNIFIED IDEOGRAPH
	{0xEECE,	0x9383},	// CJK UNIFIED IDEOGRAPH
	{0xEECF,	0x93AF},	// CJK UNIFIED IDEOGRAPH
	{0xEED0,	0x9364},	// CJK UNIFIED IDEOGRAPH
	{0xEED1,	0x9356},	// CJK UNIFIED IDEOGRAPH
	{0xEED2,	0x9347},	// CJK UNIFIED IDEOGRAPH
	{0xEED3,	0x937C},	// CJK UNIFIED IDEOGRAPH
	{0xEED4,	0x9358},	// CJK UNIFIED IDEOGRAPH
	{0xEED5,	0x935C},	// CJK UNIFIED IDEOGRAPH
	{0xEED6,	0x9376},	// CJK UNIFIED IDEOGRAPH
	{0xEED7,	0x9349},	// CJK UNIFIED IDEOGRAPH
	{0xEED8,	0x9350},	// CJK UNIFIED IDEOGRAPH
	{0xEED9,	0x9351},	// CJK UNIFIED IDEOGRAPH
	{0xEEDA,	0x9360},	// CJK UNIFIED IDEOGRAPH
	{0xEEDB,	0x936D},	// CJK UNIFIED IDEOGRAPH
	{0xEEDC,	0x938F},	// CJK UNIFIED IDEOGRAPH
	{0xEEDD,	0x934C},	// CJK UNIFIED IDEOGRAPH
	{0xEEDE,	0x936A},	// CJK UNIFIED IDEOGRAPH
	{0xEEDF,	0x9379},	// CJK UNIFIED IDEOGRAPH
	{0xEEE0,	0x9357},	// CJK UNIFIED IDEOGRAPH
	{0xEEE1,	0x9355},	// CJK UNIFIED IDEOGRAPH
	{0xEEE2,	0x9352},	// CJK UNIFIED IDEOGRAPH
	{0xEEE3,	0x934F},	// CJK UNIFIED IDEOGRAPH
	{0xEEE4,	0x9371},	// CJK UNIFIED IDEOGRAPH
	{0xEEE5,	0x9377},	// CJK UNIFIED IDEOGRAPH
	{0xEEE6,	0x937B},	// CJK UNIFIED IDEOGRAPH
	{0xEEE7,	0x9361},	// CJK UNIFIED IDEOGRAPH
	{0xEEE8,	0x935E},	// CJK UNIFIED IDEOGRAPH
	{0xEEE9,	0x9363},	// CJK UNIFIED IDEOGRAPH
	{0xEEEA,	0x9367},	// CJK UNIFIED IDEOGRAPH
	{0xEEEB,	0x9380},	// CJK UNIFIED IDEOGRAPH
	{0xEEEC,	0x934E},	// CJK UNIFIED IDEOGRAPH
	{0xEEED,	0x9359},	// CJK UNIFIED IDEOGRAPH
	{0xEEEE,	0x95C7},	// CJK UNIFIED IDEOGRAPH
	{0xEEEF,	0x95C0},	// CJK UNIFIED IDEOGRAPH
	{0xEEF0,	0x95C9},	// CJK UNIFIED IDEOGRAPH
	{0xEEF1,	0x95C3},	// CJK UNIFIED IDEOGRAPH
	{0xEEF2,	0x95C5},	// CJK UNIFIED IDEOGRAPH
	{0xEEF3,	0x95B7},	// CJK UNIFIED IDEOGRAPH
	{0xEEF4,	0x96AE},	// CJK UNIFIED IDEOGRAPH
	{0xEEF5,	0x96B0},	// CJK UNIFIED IDEOGRAPH
	{0xEEF6,	0x96AC},	// CJK UNIFIED IDEOGRAPH
	{0xEEF7,	0x9720},	// CJK UNIFIED IDEOGRAPH
	{0xEEF8,	0x971F},	// CJK UNIFIED IDEOGRAPH
	{0xEEF9,	0x9718},	// CJK UNIFIED IDEOGRAPH
	{0xEEFA,	0x971D},	// CJK UNIFIED IDEOGRAPH
	{0xEEFB,	0x9719},	// CJK UNIFIED IDEOGRAPH
	{0xEEFC,	0x979A},	// CJK UNIFIED IDEOGRAPH
	{0xEEFD,	0x97A1},	// CJK UNIFIED IDEOGRAPH
	{0xEEFE,	0x979C},	// CJK UNIFIED IDEOGRAPH
	{0xEF40,	0x979E},	// CJK UNIFIED IDEOGRAPH
	{0xEF41,	0x979D},	// CJK UNIFIED IDEOGRAPH
	{0xEF42,	0x97D5},	// CJK UNIFIED IDEOGRAPH
	{0xEF43,	0x97D4},	// CJK UNIFIED IDEOGRAPH
	{0xEF44,	0x97F1},	// CJK UNIFIED IDEOGRAPH
	{0xEF45,	0x9841},	// CJK UNIFIED IDEOGRAPH
	{0xEF46,	0x9844},	// CJK UNIFIED IDEOGRAPH
	{0xEF47,	0x984A},	// CJK UNIFIED IDEOGRAPH
	{0xEF48,	0x9849},	// CJK UNIFIED IDEOGRAPH
	{0xEF49,	0x9845},	// CJK UNIFIED IDEOGRAPH
	{0xEF4A,	0x9843},	// CJK UNIFIED IDEOGRAPH
	{0xEF4B,	0x9925},	// CJK UNIFIED IDEOGRAPH
	{0xEF4C,	0x992B},	// CJK UNIFIED IDEOGRAPH
	{0xEF4D,	0x992C},	// CJK UNIFIED IDEOGRAPH
	{0xEF4E,	0x992A},	// CJK UNIFIED IDEOGRAPH
	{0xEF4F,	0x9933},	// CJK UNIFIED IDEOGRAPH
	{0xEF50,	0x9932},	// CJK UNIFIED IDEOGRAPH
	{0xEF51,	0x992F},	// CJK UNIFIED IDEOGRAPH
	{0xEF52,	0x992D},	// CJK UNIFIED IDEOGRAPH
	{0xEF53,	0x9931},	// CJK UNIFIED IDEOGRAPH
	{0xEF54,	0x9930},	// CJK UNIFIED IDEOGRAPH
	{0xEF55,	0x9998},	// CJK UNIFIED IDEOGRAPH
	{0xEF56,	0x99A3},	// CJK UNIFIED IDEOGRAPH
	{0xEF57,	0x99A1},	// CJK UNIFIED IDEOGRAPH
	{0xEF58,	0x9A02},	// CJK UNIFIED IDEOGRAPH
	{0xEF59,	0x99FA},	// CJK UNIFIED IDEOGRAPH
	{0xEF5A,	0x99F4},	// CJK UNIFIED IDEOGRAPH
	{0xEF5B,	0x99F7},	// CJK UNIFIED IDEOGRAPH
	{0xEF5C,	0x99F9},	// CJK UNIFIED IDEOGRAPH
	{0xEF5D,	0x99F8},	// CJK UNIFIED IDEOGRAPH
	{0xEF5E,	0x99F6},	// CJK UNIFIED IDEOGRAPH
	{0xEF5F,	0x99FB},	// CJK UNIFIED IDEOGRAPH
	{0xEF60,	0x99FD},	// CJK UNIFIED IDEOGRAPH
	{0xEF61,	0x99FE},	// CJK UNIFIED IDEOGRAPH
	{0xEF62,	0x99FC},	// CJK UNIFIED IDEOGRAPH
	{0xEF63,	0x9A03},	// CJK UNIFIED IDEOGRAPH
	{0xEF64,	0x9ABE},	// CJK UNIFIED IDEOGRAPH
	{0xEF65,	0x9AFE},	// CJK UNIFIED IDEOGRAPH
	{0xEF66,	0x9AFD},	// CJK UNIFIED IDEOGRAPH
	{0xEF67,	0x9B01},	// CJK UNIFIED IDEOGRAPH
	{0xEF68,	0x9AFC},	// CJK UNIFIED IDEOGRAPH
	{0xEF69,	0x9B48},	// CJK UNIFIED IDEOGRAPH
	{0xEF6A,	0x9B9A},	// CJK UNIFIED IDEOGRAPH
	{0xEF6B,	0x9BA8},	// CJK UNIFIED IDEOGRAPH
	{0xEF6C,	0x9B9E},	// CJK UNIFIED IDEOGRAPH
	{0xEF6D,	0x9B9B},	// CJK UNIFIED IDEOGRAPH
	{0xEF6E,	0x9BA6},	// CJK UNIFIED IDEOGRAPH
	{0xEF6F,	0x9BA1},	// CJK UNIFIED IDEOGRAPH
	{0xEF70,	0x9BA5},	// CJK UNIFIED IDEOGRAPH
	{0xEF71,	0x9BA4},	// CJK UNIFIED IDEOGRAPH
	{0xEF72,	0x9B86},	// CJK UNIFIED IDEOGRAPH
	{0xEF73,	0x9BA2},	// CJK UNIFIED IDEOGRAPH
	{0xEF74,	0x9BA0},	// CJK UNIFIED IDEOGRAPH
	{0xEF75,	0x9BAF},	// CJK UNIFIED IDEOGRAPH
	{0xEF76,	0x9D33},	// CJK UNIFIED IDEOGRAPH
	{0xEF77,	0x9D41},	// CJK UNIFIED IDEOGRAPH
	{0xEF78,	0x9D67},	// CJK UNIFIED IDEOGRAPH
	{0xEF79,	0x9D36},	// CJK UNIFIED IDEOGRAPH
	{0xEF7A,	0x9D2E},	// CJK UNIFIED IDEOGRAPH
	{0xEF7B,	0x9D2F},	// CJK UNIFIED IDEOGRAPH
	{0xEF7C,	0x9D31},	// CJK UNIFIED IDEOGRAPH
	{0xEF7D,	0x9D38},	// CJK UNIFIED IDEOGRAPH
	{0xEF7E,	0x9D30},	// CJK UNIFIED IDEOGRAPH
	{0xEFA1,	0x9D45},	// CJK UNIFIED IDEOGRAPH
	{0xEFA2,	0x9D42},	// CJK UNIFIED IDEOGRAPH
	{0xEFA3,	0x9D43},	// CJK UNIFIED IDEOGRAPH
	{0xEFA4,	0x9D3E},	// CJK UNIFIED IDEOGRAPH
	{0xEFA5,	0x9D37},	// CJK UNIFIED IDEOGRAPH
	{0xEFA6,	0x9D40},	// CJK UNIFIED IDEOGRAPH
	{0xEFA7,	0x9D3D},	// CJK UNIFIED IDEOGRAPH
	{0xEFA8,	0x7FF5},	// CJK UNIFIED IDEOGRAPH
	{0xEFA9,	0x9D2D},	// CJK UNIFIED IDEOGRAPH
	{0xEFAA,	0x9E8A},	// CJK UNIFIED IDEOGRAPH
	{0xEFAB,	0x9E89},	// CJK UNIFIED IDEOGRAPH
	{0xEFAC,	0x9E8D},	// CJK UNIFIED IDEOGRAPH
	{0xEFAD,	0x9EB0},	// CJK UNIFIED IDEOGRAPH
	{0xEFAE,	0x9EC8},	// CJK UNIFIED IDEOGRAPH
	{0xEFAF,	0x9EDA},	// CJK UNIFIED IDEOGRAPH
	{0xEFB0,	0x9EFB},	// CJK UNIFIED IDEOGRAPH
	{0xEFB1,	0x9EFF},	// CJK UNIFIED IDEOGRAPH
	{0xEFB2,	0x9F24},	// CJK UNIFIED IDEOGRAPH
	{0xEFB3,	0x9F23},	// CJK UNIFIED IDEOGRAPH
	{0xEFB4,	0x9F22},	// CJK UNIFIED IDEOGRAPH
	{0xEFB5,	0x9F54},	// CJK UNIFIED IDEOGRAPH
	{0xEFB6,	0x9FA0},	// CJK UNIFIED IDEOGRAPH
	{0xEFB7,	0x5131},	// CJK UNIFIED IDEOGRAPH
	{0xEFB8,	0x512D},	// CJK UNIFIED IDEOGRAPH
	{0xEFB9,	0x512E},	// CJK UNIFIED IDEOGRAPH
	{0xEFBA,	0x5698},	// CJK UNIFIED IDEOGRAPH
	{0xEFBB,	0x569C},	// CJK UNIFIED IDEOGRAPH
	{0xEFBC,	0x5697},	// CJK UNIFIED IDEOGRAPH
	{0xEFBD,	0x569A},	// CJK UNIFIED IDEOGRAPH
	{0xEFBE,	0x569D},	// CJK UNIFIED IDEOGRAPH
	{0xEFBF,	0x5699},	// CJK UNIFIED IDEOGRAPH
	{0xEFC0,	0x5970},	// CJK UNIFIED IDEOGRAPH
	{0xEFC1,	0x5B3C},	// CJK UNIFIED IDEOGRAPH
	{0xEFC2,	0x5C69},	// CJK UNIFIED IDEOGRAPH
	{0xEFC3,	0x5C6A},	// CJK UNIFIED IDEOGRAPH
	{0xEFC4,	0x5DC0},	// CJK UNIFIED IDEOGRAPH
	{0xEFC5,	0x5E6D},	// CJK UNIFIED IDEOGRAPH
	{0xEFC6,	0x5E6E},	// CJK UNIFIED IDEOGRAPH
	{0xEFC7,	0x61D8},	// CJK UNIFIED IDEOGRAPH
	{0xEFC8,	0x61DF},	// CJK UNIFIED IDEOGRAPH
	{0xEFC9,	0x61ED},	// CJK UNIFIED IDEOGRAPH
	{0xEFCA,	0x61EE},	// CJK UNIFIED IDEOGRAPH
	{0xEFCB,	0x61F1},	// CJK UNIFIED IDEOGRAPH
	{0xEFCC,	0x61EA},	// CJK UNIFIED IDEOGRAPH
	{0xEFCD,	0x61F0},	// CJK UNIFIED IDEOGRAPH
	{0xEFCE,	0x61EB},	// CJK UNIFIED IDEOGRAPH
	{0xEFCF,	0x61D6},	// CJK UNIFIED IDEOGRAPH
	{0xEFD0,	0x61E9},	// CJK UNIFIED IDEOGRAPH
	{0xEFD1,	0x64FF},	// CJK UNIFIED IDEOGRAPH
	{0xEFD2,	0x6504},	// CJK UNIFIED IDEOGRAPH
	{0xEFD3,	0x64FD},	// CJK UNIFIED IDEOGRAPH
	{0xEFD4,	0x64F8},	// CJK UNIFIED IDEOGRAPH
	{0xEFD5,	0x6501},	// CJK UNIFIED IDEOGRAPH
	{0xEFD6,	0x6503},	// CJK UNIFIED IDEOGRAPH
	{0xEFD7,	0x64FC},	// CJK UNIFIED IDEOGRAPH
	{0xEFD8,	0x6594},	// CJK UNIFIED IDEOGRAPH
	{0xEFD9,	0x65DB},	// CJK UNIFIED IDEOGRAPH
	{0xEFDA,	0x66DA},	// CJK UNIFIED IDEOGRAPH
	{0xEFDB,	0x66DB},	// CJK UNIFIED IDEOGRAPH
	{0xEFDC,	0x66D8},	// CJK UNIFIED IDEOGRAPH
	{0xEFDD,	0x6AC5},	// CJK UNIFIED IDEOGRAPH
	{0xEFDE,	0x6AB9},	// CJK UNIFIED IDEOGRAPH
	{0xEFDF,	0x6ABD},	// CJK UNIFIED IDEOGRAPH
	{0xEFE0,	0x6AE1},	// CJK UNIFIED IDEOGRAPH
	{0xEFE1,	0x6AC6},	// CJK UNIFIED IDEOGRAPH
	{0xEFE2,	0x6ABA},	// CJK UNIFIED IDEOGRAPH
	{0xEFE3,	0x6AB6},	// CJK UNIFIED IDEOGRAPH
	{0xEFE4,	0x6AB7},	// CJK UNIFIED IDEOGRAPH
	{0xEFE5,	0x6AC7},	// CJK UNIFIED IDEOGRAPH
	{0xEFE6,	0x6AB4},	// CJK UNIFIED IDEOGRAPH
	{0xEFE7,	0x6AAD},	// CJK UNIFIED IDEOGRAPH
	{0xEFE8,	0x6B5E},	// CJK UNIFIED IDEOGRAPH
	{0xEFE9,	0x6BC9},	// CJK UNIFIED IDEOGRAPH
	{0xEFEA,	0x6C0B},	// CJK UNIFIED IDEOGRAPH
	{0xEFEB,	0x7007},	// CJK UNIFIED IDEOGRAPH
	{0xEFEC,	0x700C},	// CJK UNIFIED IDEOGRAPH
	{0xEFED,	0x700D},	// CJK UNIFIED IDEOGRAPH
	{0xEFEE,	0x7001},	// CJK UNIFIED IDEOGRAPH
	{0xEFEF,	0x7005},	// CJK UNIFIED IDEOGRAPH
	{0xEFF0,	0x7014},	// CJK UNIFIED IDEOGRAPH
	{0xEFF1,	0x700E},	// CJK UNIFIED IDEOGRAPH
	{0xEFF2,	0x6FFF},	// CJK UNIFIED IDEOGRAPH
	{0xEFF3,	0x7000},	// CJK UNIFIED IDEOGRAPH
	{0xEFF4,	0x6FFB},	// CJK UNIFIED IDEOGRAPH
	{0xEFF5,	0x7026},	// CJK UNIFIED IDEOGRAPH
	{0xEFF6,	0x6FFC},	// CJK UNIFIED IDEOGRAPH
	{0xEFF7,	0x6FF7},	// CJK UNIFIED IDEOGRAPH
	{0xEFF8,	0x700A},	// CJK UNIFIED IDEOGRAPH
	{0xEFF9,	0x7201},	// CJK UNIFIED IDEOGRAPH
	{0xEFFA,	0x71FF},	// CJK UNIFIED IDEOGRAPH
	{0xEFFB,	0x71F9},	// CJK UNIFIED IDEOGRAPH
	{0xEFFC,	0x7203},	// CJK UNIFIED IDEOGRAPH
	{0xEFFD,	0x71FD},	// CJK UNIFIED IDEOGRAPH
	{0xEFFE,	0x7376},	// CJK UNIFIED IDEOGRAPH
	{0xF040,	0x74B8},	// CJK UNIFIED IDEOGRAPH
	{0xF041,	0x74C0},	// CJK UNIFIED IDEOGRAPH
	{0xF042,	0x74B5},	// CJK UNIFIED IDEOGRAPH
	{0xF043,	0x74C1},	// CJK UNIFIED IDEOGRAPH
	{0xF044,	0x74BE},	// CJK UNIFIED IDEOGRAPH
	{0xF045,	0x74B6},	// CJK UNIFIED IDEOGRAPH
	{0xF046,	0x74BB},	// CJK UNIFIED IDEOGRAPH
	{0xF047,	0x74C2},	// CJK UNIFIED IDEOGRAPH
	{0xF048,	0x7514},	// CJK UNIFIED IDEOGRAPH
	{0xF049,	0x7513},	// CJK UNIFIED IDEOGRAPH
	{0xF04A,	0x765C},	// CJK UNIFIED IDEOGRAPH
	{0xF04B,	0x7664},	// CJK UNIFIED IDEOGRAPH
	{0xF04C,	0x7659},	// CJK UNIFIED IDEOGRAPH
	{0xF04D,	0x7650},	// CJK UNIFIED IDEOGRAPH
	{0xF04E,	0x7653},	// CJK UNIFIED IDEOGRAPH
	{0xF04F,	0x7657},	// CJK UNIFIED IDEOGRAPH
	{0xF050,	0x765A},	// CJK UNIFIED IDEOGRAPH
	{0xF051,	0x76A6},	// CJK UNIFIED IDEOGRAPH
	{0xF052,	0x76BD},	// CJK UNIFIED IDEOGRAPH
	{0xF053,	0x76EC},	// CJK UNIFIED IDEOGRAPH
	{0xF054,	0x77C2},	// CJK UNIFIED IDEOGRAPH
	{0xF055,	0x77BA},	// CJK UNIFIED IDEOGRAPH
	{0xF056,	0x78FF},	// CJK UNIFIED IDEOGRAPH
	{0xF057,	0x790C},	// CJK UNIFIED IDEOGRAPH
	{0xF058,	0x7913},	// CJK UNIFIED IDEOGRAPH
	{0xF059,	0x7914},	// CJK UNIFIED IDEOGRAPH
	{0xF05A,	0x7909},	// CJK UNIFIED IDEOGRAPH
	{0xF05B,	0x7910},	// CJK UNIFIED IDEOGRAPH
	{0xF05C,	0x7912},	// CJK UNIFIED IDEOGRAPH
	{0xF05D,	0x7911},	// CJK UNIFIED IDEOGRAPH
	{0xF05E,	0x79AD},	// CJK UNIFIED IDEOGRAPH
	{0xF05F,	0x79AC},	// CJK UNIFIED IDEOGRAPH
	{0xF060,	0x7A5F},	// CJK UNIFIED IDEOGRAPH
	{0xF061,	0x7C1C},	// CJK UNIFIED IDEOGRAPH
	{0xF062,	0x7C29},	// CJK UNIFIED IDEOGRAPH
	{0xF063,	0x7C19},	// CJK UNIFIED IDEOGRAPH
	{0xF064,	0x7C20},	// CJK UNIFIED IDEOGRAPH
	{0xF065,	0x7C1F},	// CJK UNIFIED IDEOGRAPH
	{0xF066,	0x7C2D},	// CJK UNIFIED IDEOGRAPH
	{0xF067,	0x7C1D},	// CJK UNIFIED IDEOGRAPH
	{0xF068,	0x7C26},	// CJK UNIFIED IDEOGRAPH
	{0xF069,	0x7C28},	// CJK UNIFIED IDEOGRAPH
	{0xF06A,	0x7C22},	// CJK UNIFIED IDEOGRAPH
	{0xF06B,	0x7C25},	// CJK UNIFIED IDEOGRAPH
	{0xF06C,	0x7C30},	// CJK UNIFIED IDEOGRAPH
	{0xF06D,	0x7E5C},	// CJK UNIFIED IDEOGRAPH
	{0xF06E,	0x7E50},	// CJK UNIFIED IDEOGRAPH
	{0xF06F,	0x7E56},	// CJK UNIFIED IDEOGRAPH
	{0xF070,	0x7E63},	// CJK UNIFIED IDEOGRAPH
	{0xF071,	0x7E58},	// CJK UNIFIED IDEOGRAPH
	{0xF072,	0x7E62},	// CJK UNIFIED IDEOGRAPH
	{0xF073,	0x7E5F},	// CJK UNIFIED IDEOGRAPH
	{0xF074,	0x7E51},	// CJK UNIFIED IDEOGRAPH
	{0xF075,	0x7E60},	// CJK UNIFIED IDEOGRAPH
	{0xF076,	0x7E57},	// CJK UNIFIED IDEOGRAPH
	{0xF077,	0x7E53},	// CJK UNIFIED IDEOGRAPH
	{0xF078,	0x7FB5},	// CJK UNIFIED IDEOGRAPH
	{0xF079,	0x7FB3},	// CJK UNIFIED IDEOGRAPH
	{0xF07A,	0x7FF7},	// CJK UNIFIED IDEOGRAPH
	{0xF07B,	0x7FF8},	// CJK UNIFIED IDEOGRAPH
	{0xF07C,	0x8075},	// CJK UNIFIED IDEOGRAPH
	{0xF07D,	0x81D1},	// CJK UNIFIED IDEOGRAPH
	{0xF07E,	0x81D2},	// CJK UNIFIED IDEOGRAPH
	{0xF0A1,	0x81D0},	// CJK UNIFIED IDEOGRAPH
	{0xF0A2,	0x825F},	// CJK UNIFIED IDEOGRAPH
	{0xF0A3,	0x825E},	// CJK UNIFIED IDEOGRAPH
	{0xF0A4,	0x85B4},	// CJK UNIFIED IDEOGRAPH
	{0xF0A5,	0x85C6},	// CJK UNIFIED IDEOGRAPH
	{0xF0A6,	0x85C0},	// CJK UNIFIED IDEOGRAPH
	{0xF0A7,	0x85C3},	// CJK UNIFIED IDEOGRAPH
	{0xF0A8,	0x85C2},	// CJK UNIFIED IDEOGRAPH
	{0xF0A9,	0x85B3},	// CJK UNIFIED IDEOGRAPH
	{0xF0AA,	0x85B5},	// CJK UNIFIED IDEOGRAPH
	{0xF0AB,	0x85BD},	// CJK UNIFIED IDEOGRAPH
	{0xF0AC,	0x85C7},	// CJK UNIFIED IDEOGRAPH
	{0xF0AD,	0x85C4},	// CJK UNIFIED IDEOGRAPH
	{0xF0AE,	0x85BF},	// CJK UNIFIED IDEOGRAPH
	{0xF0AF,	0x85CB},	// CJK UNIFIED IDEOGRAPH
	{0xF0B0,	0x85CE},	// CJK UNIFIED IDEOGRAPH
	{0xF0B1,	0x85C8},	// CJK UNIFIED IDEOGRAPH
	{0xF0B2,	0x85C5},	// CJK UNIFIED IDEOGRAPH
	{0xF0B3,	0x85B1},	// CJK UNIFIED IDEOGRAPH
	{0xF0B4,	0x85B6},	// CJK UNIFIED IDEOGRAPH
	{0xF0B5,	0x85D2},	// CJK UNIFIED IDEOGRAPH
	{0xF0B6,	0x8624},	// CJK UNIFIED IDEOGRAPH
	{0xF0B7,	0x85B8},	// CJK UNIFIED IDEOGRAPH
	{0xF0B8,	0x85B7},	// CJK UNIFIED IDEOGRAPH
	{0xF0B9,	0x85BE},	// CJK UNIFIED IDEOGRAPH
	{0xF0BA,	0x8669},	// CJK UNIFIED IDEOGRAPH
	{0xF0BB,	0x87E7},	// CJK UNIFIED IDEOGRAPH
	{0xF0BC,	0x87E6},	// CJK UNIFIED IDEOGRAPH
	{0xF0BD,	0x87E2},	// CJK UNIFIED IDEOGRAPH
	{0xF0BE,	0x87DB},	// CJK UNIFIED IDEOGRAPH
	{0xF0BF,	0x87EB},	// CJK UNIFIED IDEOGRAPH
	{0xF0C0,	0x87EA},	// CJK UNIFIED IDEOGRAPH
	{0xF0C1,	0x87E5},	// CJK UNIFIED IDEOGRAPH
	{0xF0C2,	0x87DF},	// CJK UNIFIED IDEOGRAPH
	{0xF0C3,	0x87F3},	// CJK UNIFIED IDEOGRAPH
	{0xF0C4,	0x87E4},	// CJK UNIFIED IDEOGRAPH
	{0xF0C5,	0x87D4},	// CJK UNIFIED IDEOGRAPH
	{0xF0C6,	0x87DC},	// CJK UNIFIED IDEOGRAPH
	{0xF0C7,	0x87D3},	// CJK UNIFIED IDEOGRAPH
	{0xF0C8,	0x87ED},	// CJK UNIFIED IDEOGRAPH
	{0xF0C9,	0x87D8},	// CJK UNIFIED IDEOGRAPH
	{0xF0CA,	0x87E3},	// CJK UNIFIED IDEOGRAPH
	{0xF0CB,	0x87A4},	// CJK UNIFIED IDEOGRAPH
	{0xF0CC,	0x87D7},	// CJK UNIFIED IDEOGRAPH
	{0xF0CD,	0x87D9},	// CJK UNIFIED IDEOGRAPH
	{0xF0CE,	0x8801},	// CJK UNIFIED IDEOGRAPH
	{0xF0CF,	0x87F4},	// CJK UNIFIED IDEOGRAPH
	{0xF0D0,	0x87E8},	// CJK UNIFIED IDEOGRAPH
	{0xF0D1,	0x87DD},	// CJK UNIFIED IDEOGRAPH
	{0xF0D2,	0x8953},	// CJK UNIFIED IDEOGRAPH
	{0xF0D3,	0x894B},	// CJK UNIFIED IDEOGRAPH
	{0xF0D4,	0x894F},	// CJK UNIFIED IDEOGRAPH
	{0xF0D5,	0x894C},	// CJK UNIFIED IDEOGRAPH
	{0xF0D6,	0x8946},	// CJK UNIFIED IDEOGRAPH
	{0xF0D7,	0x8950},	// CJK UNIFIED IDEOGRAPH
	{0xF0D8,	0x8951},	// CJK UNIFIED IDEOGRAPH
	{0xF0D9,	0x8949},	// CJK UNIFIED IDEOGRAPH
	{0xF0DA,	0x8B2A},	// CJK UNIFIED IDEOGRAPH
	{0xF0DB,	0x8B27},	// CJK UNIFIED IDEOGRAPH
	{0xF0DC,	0x8B23},	// CJK UNIFIED IDEOGRAPH
	{0xF0DD,	0x8B33},	// CJK UNIFIED IDEOGRAPH
	{0xF0DE,	0x8B30},	// CJK UNIFIED IDEOGRAPH
	{0xF0DF,	0x8B35},	// CJK UNIFIED IDEOGRAPH
	{0xF0E0,	0x8B47},	// CJK UNIFIED IDEOGRAPH
	{0xF0E1,	0x8B2F},	// CJK UNIFIED IDEOGRAPH
	{0xF0E2,	0x8B3C},	// CJK UNIFIED IDEOGRAPH
	{0xF0E3,	0x8B3E},	// CJK UNIFIED IDEOGRAPH
	{0xF0E4,	0x8B31},	// CJK UNIFIED IDEOGRAPH
	{0xF0E5,	0x8B25},	// CJK UNIFIED IDEOGRAPH
	{0xF0E6,	0x8B37},	// CJK UNIFIED IDEOGRAPH
	{0xF0E7,	0x8B26},	// CJK UNIFIED IDEOGRAPH
	{0xF0E8,	0x8B36},	// CJK UNIFIED IDEOGRAPH
	{0xF0E9,	0x8B2E},	// CJK UNIFIED IDEOGRAPH
	{0xF0EA,	0x8B24},	// CJK UNIFIED IDEOGRAPH
	{0xF0EB,	0x8B3B},	// CJK UNIFIED IDEOGRAPH
	{0xF0EC,	0x8B3D},	// CJK UNIFIED IDEOGRAPH
	{0xF0ED,	0x8B3A},	// CJK UNIFIED IDEOGRAPH
	{0xF0EE,	0x8C42},	// CJK UNIFIED IDEOGRAPH
	{0xF0EF,	0x8C75},	// CJK UNIFIED IDEOGRAPH
	{0xF0F0,	0x8C99},	// CJK UNIFIED IDEOGRAPH
	{0xF0F1,	0x8C98},	// CJK UNIFIED IDEOGRAPH
	{0xF0F2,	0x8C97},	// CJK UNIFIED IDEOGRAPH
	{0xF0F3,	0x8CFE},	// CJK UNIFIED IDEOGRAPH
	{0xF0F4,	0x8D04},	// CJK UNIFIED IDEOGRAPH
	{0xF0F5,	0x8D02},	// CJK UNIFIED IDEOGRAPH
	{0xF0F6,	0x8D00},	// CJK UNIFIED IDEOGRAPH
	{0xF0F7,	0x8E5C},	// CJK UNIFIED IDEOGRAPH
	{0xF0F8,	0x8E62},	// CJK UNIFIED IDEOGRAPH
	{0xF0F9,	0x8E60},	// CJK UNIFIED IDEOGRAPH
	{0xF0FA,	0x8E57},	// CJK UNIFIED IDEOGRAPH
	{0xF0FB,	0x8E56},	// CJK UNIFIED IDEOGRAPH
	{0xF0FC,	0x8E5E},	// CJK UNIFIED IDEOGRAPH
	{0xF0FD,	0x8E65},	// CJK UNIFIED IDEOGRAPH
	{0xF0FE,	0x8E67},	// CJK UNIFIED IDEOGRAPH
	{0xF140,	0x8E5B},	// CJK UNIFIED IDEOGRAPH
	{0xF141,	0x8E5A},	// CJK UNIFIED IDEOGRAPH
	{0xF142,	0x8E61},	// CJK UNIFIED IDEOGRAPH
	{0xF143,	0x8E5D},	// CJK UNIFIED IDEOGRAPH
	{0xF144,	0x8E69},	// CJK UNIFIED IDEOGRAPH
	{0xF145,	0x8E54},	// CJK UNIFIED IDEOGRAPH
	{0xF146,	0x8F46},	// CJK UNIFIED IDEOGRAPH
	{0xF147,	0x8F47},	// CJK UNIFIED IDEOGRAPH
	{0xF148,	0x8F48},	// CJK UNIFIED IDEOGRAPH
	{0xF149,	0x8F4B},	// CJK UNIFIED IDEOGRAPH
	{0xF14A,	0x9128},	// CJK UNIFIED IDEOGRAPH
	{0xF14B,	0x913A},	// CJK UNIFIED IDEOGRAPH
	{0xF14C,	0x913B},	// CJK UNIFIED IDEOGRAPH
	{0xF14D,	0x913E},	// CJK UNIFIED IDEOGRAPH
	{0xF14E,	0x91A8},	// CJK UNIFIED IDEOGRAPH
	{0xF14F,	0x91A5},	// CJK UNIFIED IDEOGRAPH
	{0xF150,	0x91A7},	// CJK UNIFIED IDEOGRAPH
	{0xF151,	0x91AF},	// CJK UNIFIED IDEOGRAPH
	{0xF152,	0x91AA},	// CJK UNIFIED IDEOGRAPH
	{0xF153,	0x93B5},	// CJK UNIFIED IDEOGRAPH
	{0xF154,	0x938C},	// CJK UNIFIED IDEOGRAPH
	{0xF155,	0x9392},	// CJK UNIFIED IDEOGRAPH
	{0xF156,	0x93B7},	// CJK UNIFIED IDEOGRAPH
	{0xF157,	0x939B},	// CJK UNIFIED IDEOGRAPH
	{0xF158,	0x939D},	// CJK UNIFIED IDEOGRAPH
	{0xF159,	0x9389},	// CJK UNIFIED IDEOGRAPH
	{0xF15A,	0x93A7},	// CJK UNIFIED IDEOGRAPH
	{0xF15B,	0x938E},	// CJK UNIFIED IDEOGRAPH
	{0xF15C,	0x93AA},	// CJK UNIFIED IDEOGRAPH
	{0xF15D,	0x939E},	// CJK UNIFIED IDEOGRAPH
	{0xF15E,	0x93A6},	// CJK UNIFIED IDEOGRAPH
	{0xF15F,	0x9395},	// CJK UNIFIED IDEOGRAPH
	{0xF160,	0x9388},	// CJK UNIFIED IDEOGRAPH
	{0xF161,	0x9399},	// CJK UNIFIED IDEOGRAPH
	{0xF162,	0x939F},	// CJK UNIFIED IDEOGRAPH
	{0xF163,	0x938D},	// CJK UNIFIED IDEOGRAPH
	{0xF164,	0x93B1},	// CJK UNIFIED IDEOGRAPH
	{0xF165,	0x9391},	// CJK UNIFIED IDEOGRAPH
	{0xF166,	0x93B2},	// CJK UNIFIED IDEOGRAPH
	{0xF167,	0x93A4},	// CJK UNIFIED IDEOGRAPH
	{0xF168,	0x93A8},	// CJK UNIFIED IDEOGRAPH
	{0xF169,	0x93B4},	// CJK UNIFIED IDEOGRAPH
	{0xF16A,	0x93A3},	// CJK UNIFIED IDEOGRAPH
	{0xF16B,	0x93A5},	// CJK UNIFIED IDEOGRAPH
	{0xF16C,	0x95D2},	// CJK UNIFIED IDEOGRAPH
	{0xF16D,	0x95D3},	// CJK UNIFIED IDEOGRAPH
	{0xF16E,	0x95D1},	// CJK UNIFIED IDEOGRAPH
	{0xF16F,	0x96B3},	// CJK UNIFIED IDEOGRAPH
	{0xF170,	0x96D7},	// CJK UNIFIED IDEOGRAPH
	{0xF171,	0x96DA},	// CJK UNIFIED IDEOGRAPH
	{0xF172,	0x5DC2},	// CJK UNIFIED IDEOGRAPH
	{0xF173,	0x96DF},	// CJK UNIFIED IDEOGRAPH
	{0xF174,	0x96D8},	// CJK UNIFIED IDEOGRAPH
	{0xF175,	0x96DD},	// CJK UNIFIED IDEOGRAPH
	{0xF176,	0x9723},	// CJK UNIFIED IDEOGRAPH
	{0xF177,	0x9722},	// CJK UNIFIED IDEOGRAPH
	{0xF178,	0x9725},	// CJK UNIFIED IDEOGRAPH
	{0xF179,	0x97AC},	// CJK UNIFIED IDEOGRAPH
	{0xF17A,	0x97AE},	// CJK UNIFIED IDEOGRAPH
	{0xF17B,	0x97A8},	// CJK UNIFIED IDEOGRAPH
	{0xF17C,	0x97AB},	// CJK UNIFIED IDEOGRAPH
	{0xF17D,	0x97A4},	// CJK UNIFIED IDEOGRAPH
	{0xF17E,	0x97AA},	// CJK UNIFIED IDEOGRAPH
	{0xF1A1,	0x97A2},	// CJK UNIFIED IDEOGRAPH
	{0xF1A2,	0x97A5},	// CJK UNIFIED IDEOGRAPH
	{0xF1A3,	0x97D7},	// CJK UNIFIED IDEOGRAPH
	{0xF1A4,	0x97D9},	// CJK UNIFIED IDEOGRAPH
	{0xF1A5,	0x97D6},	// CJK UNIFIED IDEOGRAPH
	{0xF1A6,	0x97D8},	// CJK UNIFIED IDEOGRAPH
	{0xF1A7,	0x97FA},	// CJK UNIFIED IDEOGRAPH
	{0xF1A8,	0x9850},	// CJK UNIFIED IDEOGRAPH
	{0xF1A9,	0x9851},	// CJK UNIFIED IDEOGRAPH
	{0xF1AA,	0x9852},	// CJK UNIFIED IDEOGRAPH
	{0xF1AB,	0x98B8},	// CJK UNIFIED IDEOGRAPH
	{0xF1AC,	0x9941},	// CJK UNIFIED IDEOGRAPH
	{0xF1AD,	0x993C},	// CJK UNIFIED IDEOGRAPH
	{0xF1AE,	0x993A},	// CJK UNIFIED IDEOGRAPH
	{0xF1AF,	0x9A0F},	// CJK UNIFIED IDEOGRAPH
	{0xF1B0,	0x9A0B},	// CJK UNIFIED IDEOGRAPH
	{0xF1B1,	0x9A09},	// CJK UNIFIED IDEOGRAPH
	{0xF1B2,	0x9A0D},	// CJK UNIFIED IDEOGRAPH
	{0xF1B3,	0x9A04},	// CJK UNIFIED IDEOGRAPH
	{0xF1B4,	0x9A11},	// CJK UNIFIED IDEOGRAPH
	{0xF1B5,	0x9A0A},	// CJK UNIFIED IDEOGRAPH
	{0xF1B6,	0x9A05},	// CJK UNIFIED IDEOGRAPH
	{0xF1B7,	0x9A07},	// CJK UNIFIED IDEOGRAPH
	{0xF1B8,	0x9A06},	// CJK UNIFIED IDEOGRAPH
	{0xF1B9,	0x9AC0},	// CJK UNIFIED IDEOGRAPH
	{0xF1BA,	0x9ADC},	// CJK UNIFIED IDEOGRAPH
	{0xF1BB,	0x9B08},	// CJK UNIFIED IDEOGRAPH
	{0xF1BC,	0x9B04},	// CJK UNIFIED IDEOGRAPH
	{0xF1BD,	0x9B05},	// CJK UNIFIED IDEOGRAPH
	{0xF1BE,	0x9B29},	// CJK UNIFIED IDEOGRAPH
	{0xF1BF,	0x9B35},	// CJK UNIFIED IDEOGRAPH
	{0xF1C0,	0x9B4A},	// CJK UNIFIED IDEOGRAPH
	{0xF1C1,	0x9B4C},	// CJK UNIFIED IDEOGRAPH
	{0xF1C2,	0x9B4B},	// CJK UNIFIED IDEOGRAPH
	{0xF1C3,	0x9BC7},	// CJK UNIFIED IDEOGRAPH
	{0xF1C4,	0x9BC6},	// CJK UNIFIED IDEOGRAPH
	{0xF1C5,	0x9BC3},	// CJK UNIFIED IDEOGRAPH
	{0xF1C6,	0x9BBF},	// CJK UNIFIED IDEOGRAPH
	{0xF1C7,	0x9BC1},	// CJK UNIFIED IDEOGRAPH
	{0xF1C8,	0x9BB5},	// CJK UNIFIED IDEOGRAPH
	{0xF1C9,	0x9BB8},	// CJK UNIFIED IDEOGRAPH
	{0xF1CA,	0x9BD3},	// CJK UNIFIED IDEOGRAPH
	{0xF1CB,	0x9BB6},	// CJK UNIFIED IDEOGRAPH
	{0xF1CC,	0x9BC4},	// CJK UNIFIED IDEOGRAPH
	{0xF1CD,	0x9BB9},	// CJK UNIFIED IDEOGRAPH
	{0xF1CE,	0x9BBD},	// CJK UNIFIED IDEOGRAPH
	{0xF1CF,	0x9D5C},	// CJK UNIFIED IDEOGRAPH
	{0xF1D0,	0x9D53},	// CJK UNIFIED IDEOGRAPH
	{0xF1D1,	0x9D4F},	// CJK UNIFIED IDEOGRAPH
	{0xF1D2,	0x9D4A},	// CJK UNIFIED IDEOGRAPH
	{0xF1D3,	0x9D5B},	// CJK UNIFIED IDEOGRAPH
	{0xF1D4,	0x9D4B},	// CJK UNIFIED IDEOGRAPH
	{0xF1D5,	0x9D59},	// CJK UNIFIED IDEOGRAPH
	{0xF1D6,	0x9D56},	// CJK UNIFIED IDEOGRAPH
	{0xF1D7,	0x9D4C},	// CJK UNIFIED IDEOGRAPH
	{0xF1D8,	0x9D57},	// CJK UNIFIED IDEOGRAPH
	{0xF1D9,	0x9D52},	// CJK UNIFIED IDEOGRAPH
	{0xF1DA,	0x9D54},	// CJK UNIFIED IDEOGRAPH
	{0xF1DB,	0x9D5F},	// CJK UNIFIED IDEOGRAPH
	{0xF1DC,	0x9D58},	// CJK UNIFIED IDEOGRAPH
	{0xF1DD,	0x9D5A},	// CJK UNIFIED IDEOGRAPH
	{0xF1DE,	0x9E8E},	// CJK UNIFIED IDEOGRAPH
	{0xF1DF,	0x9E8C},	// CJK UNIFIED IDEOGRAPH
	{0xF1E0,	0x9EDF},	// CJK UNIFIED IDEOGRAPH
	{0xF1E1,	0x9F01},	// CJK UNIFIED IDEOGRAPH
	{0xF1E2,	0x9F00},	// CJK UNIFIED IDEOGRAPH
	{0xF1E3,	0x9F16},	// CJK UNIFIED IDEOGRAPH
	{0xF1E4,	0x9F25},	// CJK UNIFIED IDEOGRAPH
	{0xF1E5,	0x9F2B},	// CJK UNIFIED IDEOGRAPH
	{0xF1E6,	0x9F2A},	// CJK UNIFIED IDEOGRAPH
	{0xF1E7,	0x9F29},	// CJK UNIFIED IDEOGRAPH
	{0xF1E8,	0x9F28},	// CJK UNIFIED IDEOGRAPH
	{0xF1E9,	0x9F4C},	// CJK UNIFIED IDEOGRAPH
	{0xF1EA,	0x9F55},	// CJK UNIFIED IDEOGRAPH
	{0xF1EB,	0x5134},	// CJK UNIFIED IDEOGRAPH
	{0xF1EC,	0x5135},	// CJK UNIFIED IDEOGRAPH
	{0xF1ED,	0x5296},	// CJK UNIFIED IDEOGRAPH
	{0xF1EE,	0x52F7},	// CJK UNIFIED IDEOGRAPH
	{0xF1EF,	0x53B4},	// CJK UNIFIED IDEOGRAPH
	{0xF1F0,	0x56AB},	// CJK UNIFIED IDEOGRAPH
	{0xF1F1,	0x56AD},	// CJK UNIFIED IDEOGRAPH
	{0xF1F2,	0x56A6},	// CJK UNIFIED IDEOGRAPH
	{0xF1F3,	0x56A7},	// CJK UNIFIED IDEOGRAPH
	{0xF1F4,	0x56AA},	// CJK UNIFIED IDEOGRAPH
	{0xF1F5,	0x56AC},	// CJK UNIFIED IDEOGRAPH
	{0xF1F6,	0x58DA},	// CJK UNIFIED IDEOGRAPH
	{0xF1F7,	0x58DD},	// CJK UNIFIED IDEOGRAPH
	{0xF1F8,	0x58DB},	// CJK UNIFIED IDEOGRAPH
	{0xF1F9,	0x5912},	// CJK UNIFIED IDEOGRAPH
	{0xF1FA,	0x5B3D},	// CJK UNIFIED IDEOGRAPH
	{0xF1FB,	0x5B3E},	// CJK UNIFIED IDEOGRAPH
	{0xF1FC,	0x5B3F},	// CJK UNIFIED IDEOGRAPH
	{0xF1FD,	0x5DC3},	// CJK UNIFIED IDEOGRAPH
	{0xF1FE,	0x5E70},	// CJK UNIFIED IDEOGRAPH
	{0xF240,	0x5FBF},	// CJK UNIFIED IDEOGRAPH
	{0xF241,	0x61FB},	// CJK UNIFIED IDEOGRAPH
	{0xF242,	0x6507},	// CJK UNIFIED IDEOGRAPH
	{0xF243,	0x6510},	// CJK UNIFIED IDEOGRAPH
	{0xF244,	0x650D},	// CJK UNIFIED IDEOGRAPH
	{0xF245,	0x6509},	// CJK UNIFIED IDEOGRAPH
	{0xF246,	0x650C},	// CJK UNIFIED IDEOGRAPH
	{0xF247,	0x650E},	// CJK UNIFIED IDEOGRAPH
	{0xF248,	0x6584},	// CJK UNIFIED IDEOGRAPH
	{0xF249,	0x65DE},	// CJK UNIFIED IDEOGRAPH
	{0xF24A,	0x65DD},	// CJK UNIFIED IDEOGRAPH
	{0xF24B,	0x66DE},	// CJK UNIFIED IDEOGRAPH
	{0xF24C,	0x6AE7},	// CJK UNIFIED IDEOGRAPH
	{0xF24D,	0x6AE0},	// CJK UNIFIED IDEOGRAPH
	{0xF24E,	0x6ACC},	// CJK UNIFIED IDEOGRAPH
	{0xF24F,	0x6AD1},	// CJK UNIFIED IDEOGRAPH
	{0xF250,	0x6AD9},	// CJK UNIFIED IDEOGRAPH
	{0xF251,	0x6ACB},	// CJK UNIFIED IDEOGRAPH
	{0xF252,	0x6ADF},	// CJK UNIFIED IDEOGRAPH
	{0xF253,	0x6ADC},	// CJK UNIFIED IDEOGRAPH
	{0xF254,	0x6AD0},	// CJK UNIFIED IDEOGRAPH
	{0xF255,	0x6AEB},	// CJK UNIFIED IDEOGRAPH
	{0xF256,	0x6ACF},	// CJK UNIFIED IDEOGRAPH
	{0xF257,	0x6ACD},	// CJK UNIFIED IDEOGRAPH
	{0xF258,	0x6ADE},	// CJK UNIFIED IDEOGRAPH
	{0xF259,	0x6B60},	// CJK UNIFIED IDEOGRAPH
	{0xF25A,	0x6BB0},	// CJK UNIFIED IDEOGRAPH
	{0xF25B,	0x6C0C},	// CJK UNIFIED IDEOGRAPH
	{0xF25C,	0x7019},	// CJK UNIFIED IDEOGRAPH
	{0xF25D,	0x7027},	// CJK UNIFIED IDEOGRAPH
	{0xF25E,	0x7020},	// CJK UNIFIED IDEOGRAPH
	{0xF25F,	0x7016},	// CJK UNIFIED IDEOGRAPH
	{0xF260,	0x702B},	// CJK UNIFIED IDEOGRAPH
	{0xF261,	0x7021},	// CJK UNIFIED IDEOGRAPH
	{0xF262,	0x7022},	// CJK UNIFIED IDEOGRAPH
	{0xF263,	0x7023},	// CJK UNIFIED IDEOGRAPH
	{0xF264,	0x7029},	// CJK UNIFIED IDEOGRAPH
	{0xF265,	0x7017},	// CJK UNIFIED IDEOGRAPH
	{0xF266,	0x7024},	// CJK UNIFIED IDEOGRAPH
	{0xF267,	0x701C},	// CJK UNIFIED IDEOGRAPH
	{0xF268,	0x702A},	// CJK UNIFIED IDEOGRAPH
	{0xF269,	0x720C},	// CJK UNIFIED IDEOGRAPH
	{0xF26A,	0x720A},	// CJK UNIFIED IDEOGRAPH
	{0xF26B,	0x7207},	// CJK UNIFIED IDEOGRAPH
	{0xF26C,	0x7202},	// CJK UNIFIED IDEOGRAPH
	{0xF26D,	0x7205},	// CJK UNIFIED IDEOGRAPH
	{0xF26E,	0x72A5},	// CJK UNIFIED IDEOGRAPH
	{0xF26F,	0x72A6},	// CJK UNIFIED IDEOGRAPH
	{0xF270,	0x72A4},	// CJK UNIFIED IDEOGRAPH
	{0xF271,	0x72A3},	// CJK UNIFIED IDEOGRAPH
	{0xF272,	0x72A1},	// CJK UNIFIED IDEOGRAPH
	{0xF273,	0x74CB},	// CJK UNIFIED IDEOGRAPH
	{0xF274,	0x74C5},	// CJK UNIFIED IDEOGRAPH
	{0xF275,	0x74B7},	// CJK UNIFIED IDEOGRAPH
	{0xF276,	0x74C3},	// CJK UNIFIED IDEOGRAPH
	{0xF277,	0x7516},	// CJK UNIFIED IDEOGRAPH
	{0xF278,	0x7660},	// CJK UNIFIED IDEOGRAPH
	{0xF279,	0x77C9},	// CJK UNIFIED IDEOGRAPH
	{0xF27A,	0x77CA},	// CJK UNIFIED IDEOGRAPH
	{0xF27B,	0x77C4},	// CJK UNIFIED IDEOGRAPH
	{0xF27C,	0x77F1},	// CJK UNIFIED IDEOGRAPH
	{0xF27D,	0x791D},	// CJK UNIFIED IDEOGRAPH
	{0xF27E,	0x791B},	// CJK UNIFIED IDEOGRAPH
	{0xF2A1,	0x7921},	// CJK UNIFIED IDEOGRAPH
	{0xF2A2,	0x791C},	// CJK UNIFIED IDEOGRAPH
	{0xF2A3,	0x7917},	// CJK UNIFIED IDEOGRAPH
	{0xF2A4,	0x791E},	// CJK UNIFIED IDEOGRAPH
	{0xF2A5,	0x79B0},	// CJK UNIFIED IDEOGRAPH
	{0xF2A6,	0x7A67},	// CJK UNIFIED IDEOGRAPH
	{0xF2A7,	0x7A68},	// CJK UNIFIED IDEOGRAPH
	{0xF2A8,	0x7C33},	// CJK UNIFIED IDEOGRAPH
	{0xF2A9,	0x7C3C},	// CJK UNIFIED IDEOGRAPH
	{0xF2AA,	0x7C39},	// CJK UNIFIED IDEOGRAPH
	{0xF2AB,	0x7C2C},	// CJK UNIFIED IDEOGRAPH
	{0xF2AC,	0x7C3B},	// CJK UNIFIED IDEOGRAPH
	{0xF2AD,	0x7CEC},	// CJK UNIFIED IDEOGRAPH
	{0xF2AE,	0x7CEA},	// CJK UNIFIED IDEOGRAPH
	{0xF2AF,	0x7E76},	// CJK UNIFIED IDEOGRAPH
	{0xF2B0,	0x7E75},	// CJK UNIFIED IDEOGRAPH
	{0xF2B1,	0x7E78},	// CJK UNIFIED IDEOGRAPH
	{0xF2B2,	0x7E70},	// CJK UNIFIED IDEOGRAPH
	{0xF2B3,	0x7E77},	// CJK UNIFIED IDEOGRAPH
	{0xF2B4,	0x7E6F},	// CJK UNIFIED IDEOGRAPH
	{0xF2B5,	0x7E7A},	// CJK UNIFIED IDEOGRAPH
	{0xF2B6,	0x7E72},	// CJK UNIFIED IDEOGRAPH
	{0xF2B7,	0x7E74},	// CJK UNIFIED IDEOGRAPH
	{0xF2B8,	0x7E68},	// CJK UNIFIED IDEOGRAPH
	{0xF2B9,	0x7F4B},	// CJK UNIFIED IDEOGRAPH
	{0xF2BA,	0x7F4A},	// CJK UNIFIED IDEOGRAPH
	{0xF2BB,	0x7F83},	// CJK UNIFIED IDEOGRAPH
	{0xF2BC,	0x7F86},	// CJK UNIFIED IDEOGRAPH
	{0xF2BD,	0x7FB7},	// CJK UNIFIED IDEOGRAPH
	{0xF2BE,	0x7FFD},	// CJK UNIFIED IDEOGRAPH
	{0xF2BF,	0x7FFE},	// CJK UNIFIED IDEOGRAPH
	{0xF2C0,	0x8078},	// CJK UNIFIED IDEOGRAPH
	{0xF2C1,	0x81D7},	// CJK UNIFIED IDEOGRAPH
	{0xF2C2,	0x81D5},	// CJK UNIFIED IDEOGRAPH
	{0xF2C3,	0x8264},	// CJK UNIFIED IDEOGRAPH
	{0xF2C4,	0x8261},	// CJK UNIFIED IDEOGRAPH
	{0xF2C5,	0x8263},	// CJK UNIFIED IDEOGRAPH
	{0xF2C6,	0x85EB},	// CJK UNIFIED IDEOGRAPH
	{0xF2C7,	0x85F1},	// CJK UNIFIED IDEOGRAPH
	{0xF2C8,	0x85ED},	// CJK UNIFIED IDEOGRAPH
	{0xF2C9,	0x85D9},	// CJK UNIFIED IDEOGRAPH
	{0xF2CA,	0x85E1},	// CJK UNIFIED IDEOGRAPH
	{0xF2CB,	0x85E8},	// CJK UNIFIED IDEOGRAPH
	{0xF2CC,	0x85DA},	// CJK UNIFIED IDEOGRAPH
	{0xF2CD,	0x85D7},	// CJK UNIFIED IDEOGRAPH
	{0xF2CE,	0x85EC},	// CJK UNIFIED IDEOGRAPH
	{0xF2CF,	0x85F2},	// CJK UNIFIED IDEOGRAPH
	{0xF2D0,	0x85F8},	// CJK UNIFIED IDEOGRAPH
	{0xF2D1,	0x85D8},	// CJK UNIFIED IDEOGRAPH
	{0xF2D2,	0x85DF},	// CJK UNIFIED IDEOGRAPH
	{0xF2D3,	0x85E3},	// CJK UNIFIED IDEOGRAPH
	{0xF2D4,	0x85DC},	// CJK UNIFIED IDEOGRAPH
	{0xF2D5,	0x85D1},	// CJK UNIFIED IDEOGRAPH
	{0xF2D6,	0x85F0},	// CJK UNIFIED IDEOGRAPH
	{0xF2D7,	0x85E6},	// CJK UNIFIED IDEOGRAPH
	{0xF2D8,	0x85EF},	// CJK UNIFIED IDEOGRAPH
	{0xF2D9,	0x85DE},	// CJK UNIFIED IDEOGRAPH
	{0xF2DA,	0x85E2},	// CJK UNIFIED IDEOGRAPH
	{0xF2DB,	0x8800},	// CJK UNIFIED IDEOGRAPH
	{0xF2DC,	0x87FA},	// CJK UNIFIED IDEOGRAPH
	{0xF2DD,	0x8803},	// CJK UNIFIED IDEOGRAPH
	{0xF2DE,	0x87F6},	// CJK UNIFIED IDEOGRAPH
	{0xF2DF,	0x87F7},	// CJK UNIFIED IDEOGRAPH
	{0xF2E0,	0x8809},	// CJK UNIFIED IDEOGRAPH
	{0xF2E1,	0x880C},	// CJK UNIFIED IDEOGRAPH
	{0xF2E2,	0x880B},	// CJK UNIFIED IDEOGRAPH
	{0xF2E3,	0x8806},	// CJK UNIFIED IDEOGRAPH
	{0xF2E4,	0x87FC},	// CJK UNIFIED IDEOGRAPH
	{0xF2E5,	0x8808},	// CJK UNIFIED IDEOGRAPH
	{0xF2E6,	0x87FF},	// CJK UNIFIED IDEOGRAPH
	{0xF2E7,	0x880A},	// CJK UNIFIED IDEOGRAPH
	{0xF2E8,	0x8802},	// CJK UNIFIED IDEOGRAPH
	{0xF2E9,	0x8962},	// CJK UNIFIED IDEOGRAPH
	{0xF2EA,	0x895A},	// CJK UNIFIED IDEOGRAPH
	{0xF2EB,	0x895B},	// CJK UNIFIED IDEOGRAPH
	{0xF2EC,	0x8957},	// CJK UNIFIED IDEOGRAPH
	{0xF2ED,	0x8961},	// CJK UNIFIED IDEOGRAPH
	{0xF2EE,	0x895C},	// CJK UNIFIED IDEOGRAPH
	{0xF2EF,	0x8958},	// CJK UNIFIED IDEOGRAPH
	{0xF2F0,	0x895D},	// CJK UNIFIED IDEOGRAPH
	{0xF2F1,	0x8959},	// CJK UNIFIED IDEOGRAPH
	{0xF2F2,	0x8988},	// CJK UNIFIED IDEOGRAPH
	{0xF2F3,	0x89B7},	// CJK UNIFIED IDEOGRAPH
	{0xF2F4,	0x89B6},	// CJK UNIFIED IDEOGRAPH
	{0xF2F5,	0x89F6},	// CJK UNIFIED IDEOGRAPH
	{0xF2F6,	0x8B50},	// CJK UNIFIED IDEOGRAPH
	{0xF2F7,	0x8B48},	// CJK UNIFIED IDEOGRAPH
	{0xF2F8,	0x8B4A},	// CJK UNIFIED IDEOGRAPH
	{0xF2F9,	0x8B40},	// CJK UNIFIED IDEOGRAPH
	{0xF2FA,	0x8B53},	// CJK UNIFIED IDEOGRAPH
	{0xF2FB,	0x8B56},	// CJK UNIFIED IDEOGRAPH
	{0xF2FC,	0x8B54},	// CJK UNIFIED IDEOGRAPH
	{0xF2FD,	0x8B4B},	// CJK UNIFIED IDEOGRAPH
	{0xF2FE,	0x8B55},	// CJK UNIFIED IDEOGRAPH
	{0xF340,	0x8B51},	// CJK UNIFIED IDEOGRAPH
	{0xF341,	0x8B42},	// CJK UNIFIED IDEOGRAPH
	{0xF342,	0x8B52},	// CJK UNIFIED IDEOGRAPH
	{0xF343,	0x8B57},	// CJK UNIFIED IDEOGRAPH
	{0xF344,	0x8C43},	// CJK UNIFIED IDEOGRAPH
	{0xF345,	0x8C77},	// CJK UNIFIED IDEOGRAPH
	{0xF346,	0x8C76},	// CJK UNIFIED IDEOGRAPH
	{0xF347,	0x8C9A},	// CJK UNIFIED IDEOGRAPH
	{0xF348,	0x8D06},	// CJK UNIFIED IDEOGRAPH
	{0xF349,	0x8D07},	// CJK UNIFIED IDEOGRAPH
	{0xF34A,	0x8D09},	// CJK UNIFIED IDEOGRAPH
	{0xF34B,	0x8DAC},	// CJK UNIFIED IDEOGRAPH
	{0xF34C,	0x8DAA},	// CJK UNIFIED IDEOGRAPH
	{0xF34D,	0x8DAD},	// CJK UNIFIED IDEOGRAPH
	{0xF34E,	0x8DAB},	// CJK UNIFIED IDEOGRAPH
	{0xF34F,	0x8E6D},	// CJK UNIFIED IDEOGRAPH
	{0xF350,	0x8E78},	// CJK UNIFIED IDEOGRAPH
	{0xF351,	0x8E73},	// CJK UNIFIED IDEOGRAPH
	{0xF352,	0x8E6A},	// CJK UNIFIED IDEOGRAPH
	{0xF353,	0x8E6F},	// CJK UNIFIED IDEOGRAPH
	{0xF354,	0x8E7B},	// CJK UNIFIED IDEOGRAPH
	{0xF355,	0x8EC2},	// CJK UNIFIED IDEOGRAPH
	{0xF356,	0x8F52},	// CJK UNIFIED IDEOGRAPH
	{0xF357,	0x8F51},	// CJK UNIFIED IDEOGRAPH
	{0xF358,	0x8F4F},	// CJK UNIFIED IDEOGRAPH
	{0xF359,	0x8F50},	// CJK UNIFIED IDEOGRAPH
	{0xF35A,	0x8F53},	// CJK UNIFIED IDEOGRAPH
	{0xF35B,	0x8FB4},	// CJK UNIFIED IDEOGRAPH
	{0xF35C,	0x9140},	// CJK UNIFIED IDEOGRAPH
	{0xF35D,	0x913F},	// CJK UNIFIED IDEOGRAPH
	{0xF35E,	0x91B0},	// CJK UNIFIED IDEOGRAPH
	{0xF35F,	0x91AD},	// CJK UNIFIED IDEOGRAPH
	{0xF360,	0x93DE},	// CJK UNIFIED IDEOGRAPH
	{0xF361,	0x93C7},	// CJK UNIFIED IDEOGRAPH
	{0xF362,	0x93CF},	// CJK UNIFIED IDEOGRAPH
	{0xF363,	0x93C2},	// CJK UNIFIED IDEOGRAPH
	{0xF364,	0x93DA},	// CJK UNIFIED IDEOGRAPH
	{0xF365,	0x93D0},	// CJK UNIFIED IDEOGRAPH
	{0xF366,	0x93F9},	// CJK UNIFIED IDEOGRAPH
	{0xF367,	0x93EC},	// CJK UNIFIED IDEOGRAPH
	{0xF368,	0x93CC},	// CJK UNIFIED IDEOGRAPH
	{0xF369,	0x93D9},	// CJK UNIFIED IDEOGRAPH
	{0xF36A,	0x93A9},	// CJK UNIFIED IDEOGRAPH
	{0xF36B,	0x93E6},	// CJK UNIFIED IDEOGRAPH
	{0xF36C,	0x93CA},	// CJK UNIFIED IDEOGRAPH
	{0xF36D,	0x93D4},	// CJK UNIFIED IDEOGRAPH
	{0xF36E,	0x93EE},	// CJK UNIFIED IDEOGRAPH
	{0xF36F,	0x93E3},	// CJK UNIFIED IDEOGRAPH
	{0xF370,	0x93D5},	// CJK UNIFIED IDEOGRAPH
	{0xF371,	0x93C4},	// CJK UNIFIED IDEOGRAPH
	{0xF372,	0x93CE},	// CJK UNIFIED IDEOGRAPH
	{0xF373,	0x93C0},	// CJK UNIFIED IDEOGRAPH
	{0xF374,	0x93D2},	// CJK UNIFIED IDEOGRAPH
	{0xF375,	0x93E7},	// CJK UNIFIED IDEOGRAPH
	{0xF376,	0x957D},	// CJK UNIFIED IDEOGRAPH
	{0xF377,	0x95DA},	// CJK UNIFIED IDEOGRAPH
	{0xF378,	0x95DB},	// CJK UNIFIED IDEOGRAPH
	{0xF379,	0x96E1},	// CJK UNIFIED IDEOGRAPH
	{0xF37A,	0x9729},	// CJK UNIFIED IDEOGRAPH
	{0xF37B,	0x972B},	// CJK UNIFIED IDEOGRAPH
	{0xF37C,	0x972C},	// CJK UNIFIED IDEOGRAPH
	{0xF37D,	0x9728},	// CJK UNIFIED IDEOGRAPH
	{0xF37E,	0x9726},	// CJK UNIFIED IDEOGRAPH
	{0xF3A1,	0x97B3},	// CJK UNIFIED IDEOGRAPH
	{0xF3A2,	0x97B7},	// CJK UNIFIED IDEOGRAPH
	{0xF3A3,	0x97B6},	// CJK UNIFIED IDEOGRAPH
	{0xF3A4,	0x97DD},	// CJK UNIFIED IDEOGRAPH
	{0xF3A5,	0x97DE},	// CJK UNIFIED IDEOGRAPH
	{0xF3A6,	0x97DF},	// CJK UNIFIED IDEOGRAPH
	{0xF3A7,	0x985C},	// CJK UNIFIED IDEOGRAPH
	{0xF3A8,	0x9859},	// CJK UNIFIED IDEOGRAPH
	{0xF3A9,	0x985D},	// CJK UNIFIED IDEOGRAPH
	{0xF3AA,	0x9857},	// CJK UNIFIED IDEOGRAPH
	{0xF3AB,	0x98BF},	// CJK UNIFIED IDEOGRAPH
	{0xF3AC,	0x98BD},	// CJK UNIFIED IDEOGRAPH
	{0xF3AD,	0x98BB},	// CJK UNIFIED IDEOGRAPH
	{0xF3AE,	0x98BE},	// CJK UNIFIED IDEOGRAPH
	{0xF3AF,	0x9948},	// CJK UNIFIED IDEOGRAPH
	{0xF3B0,	0x9947},	// CJK UNIFIED IDEOGRAPH
	{0xF3B1,	0x9943},	// CJK UNIFIED IDEOGRAPH
	{0xF3B2,	0x99A6},	// CJK UNIFIED IDEOGRAPH
	{0xF3B3,	0x99A7},	// CJK UNIFIED IDEOGRAPH
	{0xF3B4,	0x9A1A},	// CJK UNIFIED IDEOGRAPH
	{0xF3B5,	0x9A15},	// CJK UNIFIED IDEOGRAPH
	{0xF3B6,	0x9A25},	// CJK UNIFIED IDEOGRAPH
	{0xF3B7,	0x9A1D},	// CJK UNIFIED IDEOGRAPH
	{0xF3B8,	0x9A24},	// CJK UNIFIED IDEOGRAPH
	{0xF3B9,	0x9A1B},	// CJK UNIFIED IDEOGRAPH
	{0xF3BA,	0x9A22},	// CJK UNIFIED IDEOGRAPH
	{0xF3BB,	0x9A20},	// CJK UNIFIED IDEOGRAPH
	{0xF3BC,	0x9A27},	// CJK UNIFIED IDEOGRAPH
	{0xF3BD,	0x9A23},	// CJK UNIFIED IDEOGRAPH
	{0xF3BE,	0x9A1E},	// CJK UNIFIED IDEOGRAPH
	{0xF3BF,	0x9A1C},	// CJK UNIFIED IDEOGRAPH
	{0xF3C0,	0x9A14},	// CJK UNIFIED IDEOGRAPH
	{0xF3C1,	0x9AC2},	// CJK UNIFIED IDEOGRAPH
	{0xF3C2,	0x9B0B},	// CJK UNIFIED IDEOGRAPH
	{0xF3C3,	0x9B0A},	// CJK UNIFIED IDEOGRAPH
	{0xF3C4,	0x9B0E},	// CJK UNIFIED IDEOGRAPH
	{0xF3C5,	0x9B0C},	// CJK UNIFIED IDEOGRAPH
	{0xF3C6,	0x9B37},	// CJK UNIFIED IDEOGRAPH
	{0xF3C7,	0x9BEA},	// CJK UNIFIED IDEOGRAPH
	{0xF3C8,	0x9BEB},	// CJK UNIFIED IDEOGRAPH
	{0xF3C9,	0x9BE0},	// CJK UNIFIED IDEOGRAPH
	{0xF3CA,	0x9BDE},	// CJK UNIFIED IDEOGRAPH
	{0xF3CB,	0x9BE4},	// CJK UNIFIED IDEOGRAPH
	{0xF3CC,	0x9BE6},	// CJK UNIFIED IDEOGRAPH
	{0xF3CD,	0x9BE2},	// CJK UNIFIED IDEOGRAPH
	{0xF3CE,	0x9BF0},	// CJK UNIFIED IDEOGRAPH
	{0xF3CF,	0x9BD4},	// CJK UNIFIED IDEOGRAPH
	{0xF3D0,	0x9BD7},	// CJK UNIFIED IDEOGRAPH
	{0xF3D1,	0x9BEC},	// CJK UNIFIED IDEOGRAPH
	{0xF3D2,	0x9BDC},	// CJK UNIFIED IDEOGRAPH
	{0xF3D3,	0x9BD9},	// CJK UNIFIED IDEOGRAPH
	{0xF3D4,	0x9BE5},	// CJK UNIFIED IDEOGRAPH
	{0xF3D5,	0x9BD5},	// CJK UNIFIED IDEOGRAPH
	{0xF3D6,	0x9BE1},	// CJK UNIFIED IDEOGRAPH
	{0xF3D7,	0x9BDA},	// CJK UNIFIED IDEOGRAPH
	{0xF3D8,	0x9D77},	// CJK UNIFIED IDEOGRAPH
	{0xF3D9,	0x9D81},	// CJK UNIFIED IDEOGRAPH
	{0xF3DA,	0x9D8A},	// CJK UNIFIED IDEOGRAPH
	{0xF3DB,	0x9D84},	// CJK UNIFIED IDEOGRAPH
	{0xF3DC,	0x9D88},	// CJK UNIFIED IDEOGRAPH
	{0xF3DD,	0x9D71},	// CJK UNIFIED IDEOGRAPH
	{0xF3DE,	0x9D80},	// CJK UNIFIED IDEOGRAPH
	{0xF3DF,	0x9D78},	// CJK UNIFIED IDEOGRAPH
	{0xF3E0,	0x9D86},	// CJK UNIFIED IDEOGRAPH
	{0xF3E1,	0x9D8B},	// CJK UNIFIED IDEOGRAPH
	{0xF3E2,	0x9D8C},	// CJK UNIFIED IDEOGRAPH
	{0xF3E3,	0x9D7D},	// CJK UNIFIED IDEOGRAPH
	{0xF3E4,	0x9D6B},	// CJK UNIFIED IDEOGRAPH
	{0xF3E5,	0x9D74},	// CJK UNIFIED IDEOGRAPH
	{0xF3E6,	0x9D75},	// CJK UNIFIED IDEOGRAPH
	{0xF3E7,	0x9D70},	// CJK UNIFIED IDEOGRAPH
	{0xF3E8,	0x9D69},	// CJK UNIFIED IDEOGRAPH
	{0xF3E9,	0x9D85},	// CJK UNIFIED IDEOGRAPH
	{0xF3EA,	0x9D73},	// CJK UNIFIED IDEOGRAPH
	{0xF3EB,	0x9D7B},	// CJK UNIFIED IDEOGRAPH
	{0xF3EC,	0x9D82},	// CJK UNIFIED IDEOGRAPH
	{0xF3ED,	0x9D6F},	// CJK UNIFIED IDEOGRAPH
	{0xF3EE,	0x9D79},	// CJK UNIFIED IDEOGRAPH
	{0xF3EF,	0x9D7F},	// CJK UNIFIED IDEOGRAPH
	{0xF3F0,	0x9D87},	// CJK UNIFIED IDEOGRAPH
	{0xF3F1,	0x9D68},	// CJK UNIFIED IDEOGRAPH
	{0xF3F2,	0x9E94},	// CJK UNIFIED IDEOGRAPH
	{0xF3F3,	0x9E91},	// CJK UNIFIED IDEOGRAPH
	{0xF3F4,	0x9EC0},	// CJK UNIFIED IDEOGRAPH
	{0xF3F5,	0x9EFC},	// CJK UNIFIED IDEOGRAPH
	{0xF3F6,	0x9F2D},	// CJK UNIFIED IDEOGRAPH
	{0xF3F7,	0x9F40},	// CJK UNIFIED IDEOGRAPH
	{0xF3F8,	0x9F41},	// CJK UNIFIED IDEOGRAPH
	{0xF3F9,	0x9F4D},	// CJK UNIFIED IDEOGRAPH
	{0xF3FA,	0x9F56},	// CJK UNIFIED IDEOGRAPH
	{0xF3FB,	0x9F57},	// CJK UNIFIED IDEOGRAPH
	{0xF3FC,	0x9F58},	// CJK UNIFIED IDEOGRAPH
	{0xF3FD,	0x5337},	// CJK UNIFIED IDEOGRAPH
	{0xF3FE,	0x56B2},	// CJK UNIFIED IDEOGRAPH
	{0xF440,	0x56B5},	// CJK UNIFIED IDEOGRAPH
	{0xF441,	0x56B3},	// CJK UNIFIED IDEOGRAPH
	{0xF442,	0x58E3},	// CJK UNIFIED IDEOGRAPH
	{0xF443,	0x5B45},	// CJK UNIFIED IDEOGRAPH
	{0xF444,	0x5DC6},	// CJK UNIFIED IDEOGRAPH
	{0xF445,	0x5DC7},	// CJK UNIFIED IDEOGRAPH
	{0xF446,	0x5EEE},	// CJK UNIFIED IDEOGRAPH
	{0xF447,	0x5EEF},	// CJK UNIFIED IDEOGRAPH
	{0xF448,	0x5FC0},	// CJK UNIFIED IDEOGRAPH
	{0xF449,	0x5FC1},	// CJK UNIFIED IDEOGRAPH
	{0xF44A,	0x61F9},	// CJK UNIFIED IDEOGRAPH
	{0xF44B,	0x6517},	// CJK UNIFIED IDEOGRAPH
	{0xF44C,	0x6516},	// CJK UNIFIED IDEOGRAPH
	{0xF44D,	0x6515},	// CJK UNIFIED IDEOGRAPH
	{0xF44E,	0x6513},	// CJK UNIFIED IDEOGRAPH
	{0xF44F,	0x65DF},	// CJK UNIFIED IDEOGRAPH
	{0xF450,	0x66E8},	// CJK UNIFIED IDEOGRAPH
	{0xF451,	0x66E3},	// CJK UNIFIED IDEOGRAPH
	{0xF452,	0x66E4},	// CJK UNIFIED IDEOGRAPH
	{0xF453,	0x6AF3},	// CJK UNIFIED IDEOGRAPH
	{0xF454,	0x6AF0},	// CJK UNIFIED IDEOGRAPH
	{0xF455,	0x6AEA},	// CJK UNIFIED IDEOGRAPH
	{0xF456,	0x6AE8},	// CJK UNIFIED IDEOGRAPH
	{0xF457,	0x6AF9},	// CJK UNIFIED IDEOGRAPH
	{0xF458,	0x6AF1},	// CJK UNIFIED IDEOGRAPH
	{0xF459,	0x6AEE},	// CJK UNIFIED IDEOGRAPH
	{0xF45A,	0x6AEF},	// CJK UNIFIED IDEOGRAPH
	{0xF45B,	0x703C},	// CJK UNIFIED IDEOGRAPH
	{0xF45C,	0x7035},	// CJK UNIFIED IDEOGRAPH
	{0xF45D,	0x702F},	// CJK UNIFIED IDEOGRAPH
	{0xF45E,	0x7037},	// CJK UNIFIED IDEOGRAPH
	{0xF45F,	0x7034},	// CJK UNIFIED IDEOGRAPH
	{0xF460,	0x7031},	// CJK UNIFIED IDEOGRAPH
	{0xF461,	0x7042},	// CJK UNIFIED IDEOGRAPH
	{0xF462,	0x7038},	// CJK UNIFIED IDEOGRAPH
	{0xF463,	0x703F},	// CJK UNIFIED IDEOGRAPH
	{0xF464,	0x703A},	// CJK UNIFIED IDEOGRAPH
	{0xF465,	0x7039},	// CJK UNIFIED IDEOGRAPH
	{0xF466,	0x7040},	// CJK UNIFIED IDEOGRAPH
	{0xF467,	0x703B},	// CJK UNIFIED IDEOGRAPH
	{0xF468,	0x7033},	// CJK UNIFIED IDEOGRAPH
	{0xF469,	0x7041},	// CJK UNIFIED IDEOGRAPH
	{0xF46A,	0x7213},	// CJK UNIFIED IDEOGRAPH
	{0xF46B,	0x7214},	// CJK UNIFIED IDEOGRAPH
	{0xF46C,	0x72A8},	// CJK UNIFIED IDEOGRAPH
	{0xF46D,	0x737D},	// CJK UNIFIED IDEOGRAPH
	{0xF46E,	0x737C},	// CJK UNIFIED IDEOGRAPH
	{0xF46F,	0x74BA},	// CJK UNIFIED IDEOGRAPH
	{0xF470,	0x76AB},	// CJK UNIFIED IDEOGRAPH
	{0xF471,	0x76AA},	// CJK UNIFIED IDEOGRAPH
	{0xF472,	0x76BE},	// CJK UNIFIED IDEOGRAPH
	{0xF473,	0x76ED},	// CJK UNIFIED IDEOGRAPH
	{0xF474,	0x77CC},	// CJK UNIFIED IDEOGRAPH
	{0xF475,	0x77CE},	// CJK UNIFIED IDEOGRAPH
	{0xF476,	0x77CF},	// CJK UNIFIED IDEOGRAPH
	{0xF477,	0x77CD},	// CJK UNIFIED IDEOGRAPH
	{0xF478,	0x77F2},	// CJK UNIFIED IDEOGRAPH
	{0xF479,	0x7925},	// CJK UNIFIED IDEOGRAPH
	{0xF47A,	0x7923},	// CJK UNIFIED IDEOGRAPH
	{0xF47B,	0x7927},	// CJK UNIFIED IDEOGRAPH
	{0xF47C,	0x7928},	// CJK UNIFIED IDEOGRAPH
	{0xF47D,	0x7924},	// CJK UNIFIED IDEOGRAPH
	{0xF47E,	0x7929},	// CJK UNIFIED IDEOGRAPH
	{0xF4A1,	0x79B2},	// CJK UNIFIED IDEOGRAPH
	{0xF4A2,	0x7A6E},	// CJK UNIFIED IDEOGRAPH
	{0xF4A3,	0x7A6C},	// CJK UNIFIED IDEOGRAPH
	{0xF4A4,	0x7A6D},	// CJK UNIFIED IDEOGRAPH
	{0xF4A5,	0x7AF7},	// CJK UNIFIED IDEOGRAPH
	{0xF4A6,	0x7C49},	// CJK UNIFIED IDEOGRAPH
	{0xF4A7,	0x7C48},	// CJK UNIFIED IDEOGRAPH
	{0xF4A8,	0x7C4A},	// CJK UNIFIED IDEOGRAPH
	{0xF4A9,	0x7C47},	// CJK UNIFIED IDEOGRAPH
	{0xF4AA,	0x7C45},	// CJK UNIFIED IDEOGRAPH
	{0xF4AB,	0x7CEE},	// CJK UNIFIED IDEOGRAPH
	{0xF4AC,	0x7E7B},	// CJK UNIFIED IDEOGRAPH
	{0xF4AD,	0x7E7E},	// CJK UNIFIED IDEOGRAPH
	{0xF4AE,	0x7E81},	// CJK UNIFIED IDEOGRAPH
	{0xF4AF,	0x7E80},	// CJK UNIFIED IDEOGRAPH
	{0xF4B0,	0x7FBA},	// CJK UNIFIED IDEOGRAPH
	{0xF4B1,	0x7FFF},	// CJK UNIFIED IDEOGRAPH
	{0xF4B2,	0x8079},	// CJK UNIFIED IDEOGRAPH
	{0xF4B3,	0x81DB},	// CJK UNIFIED IDEOGRAPH
	{0xF4B4,	0x81D9},	// CJK UNIFIED IDEOGRAPH
	{0xF4B5,	0x820B},	// CJK UNIFIED IDEOGRAPH
	{0xF4B6,	0x8268},	// CJK UNIFIED IDEOGRAPH
	{0xF4B7,	0x8269},	// CJK UNIFIED IDEOGRAPH
	{0xF4B8,	0x8622},	// CJK UNIFIED IDEOGRAPH
	{0xF4B9,	0x85FF},	// CJK UNIFIED IDEOGRAPH
	{0xF4BA,	0x8601},	// CJK UNIFIED IDEOGRAPH
	{0xF4BB,	0x85FE},	// CJK UNIFIED IDEOGRAPH
	{0xF4BC,	0x861B},	// CJK UNIFIED IDEOGRAPH
	{0xF4BD,	0x8600},	// CJK UNIFIED IDEOGRAPH
	{0xF4BE,	0x85F6},	// CJK UNIFIED IDEOGRAPH
	{0xF4BF,	0x8604},	// CJK UNIFIED IDEOGRAPH
	{0xF4C0,	0x8609},	// CJK UNIFIED IDEOGRAPH
	{0xF4C1,	0x8605},	// CJK UNIFIED IDEOGRAPH
	{0xF4C2,	0x860C},	// CJK UNIFIED IDEOGRAPH
	{0xF4C3,	0x85FD},	// CJK UNIFIED IDEOGRAPH
	{0xF4C4,	0x8819},	// CJK UNIFIED IDEOGRAPH
	{0xF4C5,	0x8810},	// CJK UNIFIED IDEOGRAPH
	{0xF4C6,	0x8811},	// CJK UNIFIED IDEOGRAPH
	{0xF4C7,	0x8817},	// CJK UNIFIED IDEOGRAPH
	{0xF4C8,	0x8813},	// CJK UNIFIED IDEOGRAPH
	{0xF4C9,	0x8816},	// CJK UNIFIED IDEOGRAPH
	{0xF4CA,	0x8963},	// CJK UNIFIED IDEOGRAPH
	{0xF4CB,	0x8966},	// CJK UNIFIED IDEOGRAPH
	{0xF4CC,	0x89B9},	// CJK UNIFIED IDEOGRAPH
	{0xF4CD,	0x89F7},	// CJK UNIFIED IDEOGRAPH
	{0xF4CE,	0x8B60},	// CJK UNIFIED IDEOGRAPH
	{0xF4CF,	0x8B6A},	// CJK UNIFIED IDEOGRAPH
	{0xF4D0,	0x8B5D},	// CJK UNIFIED IDEOGRAPH
	{0xF4D1,	0x8B68},	// CJK UNIFIED IDEOGRAPH
	{0xF4D2,	0x8B63},	// CJK UNIFIED IDEOGRAPH
	{0xF4D3,	0x8B65},	// CJK UNIFIED IDEOGRAPH
	{0xF4D4,	0x8B67},	// CJK UNIFIED IDEOGRAPH
	{0xF4D5,	0x8B6D},	// CJK UNIFIED IDEOGRAPH
	{0xF4D6,	0x8DAE},	// CJK UNIFIED IDEOGRAPH
	{0xF4D7,	0x8E86},	// CJK UNIFIED IDEOGRAPH
	{0xF4D8,	0x8E88},	// CJK UNIFIED IDEOGRAPH
	{0xF4D9,	0x8E84},	// CJK UNIFIED IDEOGRAPH
	{0xF4DA,	0x8F59},	// CJK UNIFIED IDEOGRAPH
	{0xF4DB,	0x8F56},	// CJK UNIFIED IDEOGRAPH
	{0xF4DC,	0x8F57},	// CJK UNIFIED IDEOGRAPH
	{0xF4DD,	0x8F55},	// CJK UNIFIED IDEOGRAPH
	{0xF4DE,	0x8F58},	// CJK UNIFIED IDEOGRAPH
	{0xF4DF,	0x8F5A},	// CJK UNIFIED IDEOGRAPH
	{0xF4E0,	0x908D},	// CJK UNIFIED IDEOGRAPH
	{0xF4E1,	0x9143},	// CJK UNIFIED IDEOGRAPH
	{0xF4E2,	0x9141},	// CJK UNIFIED IDEOGRAPH
	{0xF4E3,	0x91B7},	// CJK UNIFIED IDEOGRAPH
	{0xF4E4,	0x91B5},	// CJK UNIFIED IDEOGRAPH
	{0xF4E5,	0x91B2},	// CJK UNIFIED IDEOGRAPH
	{0xF4E6,	0x91B3},	// CJK UNIFIED IDEOGRAPH
	{0xF4E7,	0x940B},	// CJK UNIFIED IDEOGRAPH
	{0xF4E8,	0x9413},	// CJK UNIFIED IDEOGRAPH
	{0xF4E9,	0x93FB},	// CJK UNIFIED IDEOGRAPH
	{0xF4EA,	0x9420},	// CJK UNIFIED IDEOGRAPH
	{0xF4EB,	0x940F},	// CJK UNIFIED IDEOGRAPH
	{0xF4EC,	0x9414},	// CJK UNIFIED IDEOGRAPH
	{0xF4ED,	0x93FE},	// CJK UNIFIED IDEOGRAPH
	{0xF4EE,	0x9415},	// CJK UNIFIED IDEOGRAPH
	{0xF4EF,	0x9410},	// CJK UNIFIED IDEOGRAPH
	{0xF4F0,	0x9428},	// CJK UNIFIED IDEOGRAPH
	{0xF4F1,	0x9419},	// CJK UNIFIED IDEOGRAPH
	{0xF4F2,	0x940D},	// CJK UNIFIED IDEOGRAPH
	{0xF4F3,	0x93F5},	// CJK UNIFIED IDEOGRAPH
	{0xF4F4,	0x9400},	// CJK UNIFIED IDEOGRAPH
	{0xF4F5,	0x93F7},	// CJK UNIFIED IDEOGRAPH
	{0xF4F6,	0x9407},	// CJK UNIFIED IDEOGRAPH
	{0xF4F7,	0x940E},	// CJK UNIFIED IDEOGRAPH
	{0xF4F8,	0x9416},	// CJK UNIFIED IDEOGRAPH
	{0xF4F9,	0x9412},	// CJK UNIFIED IDEOGRAPH
	{0xF4FA,	0x93FA},	// CJK UNIFIED IDEOGRAPH
	{0xF4FB,	0x9409},	// CJK UNIFIED IDEOGRAPH
	{0xF4FC,	0x93F8},	// CJK UNIFIED IDEOGRAPH
	{0xF4FD,	0x940A},	// CJK UNIFIED IDEOGRAPH
	{0xF4FE,	0x93FF},	// CJK UNIFIED IDEOGRAPH
	{0xF540,	0x93FC},	// CJK UNIFIED IDEOGRAPH
	{0xF541,	0x940C},	// CJK UNIFIED IDEOGRAPH
	{0xF542,	0x93F6},	// CJK UNIFIED IDEOGRAPH
	{0xF543,	0x9411},	// CJK UNIFIED IDEOGRAPH
	{0xF544,	0x9406},	// CJK UNIFIED IDEOGRAPH
	{0xF545,	0x95DE},	// CJK UNIFIED IDEOGRAPH
	{0xF546,	0x95E0},	// CJK UNIFIED IDEOGRAPH
	{0xF547,	0x95DF},	// CJK UNIFIED IDEOGRAPH
	{0xF548,	0x972E},	// CJK UNIFIED IDEOGRAPH
	{0xF549,	0x972F},	// CJK UNIFIED IDEOGRAPH
	{0xF54A,	0x97B9},	// CJK UNIFIED IDEOGRAPH
	{0xF54B,	0x97BB},	// CJK UNIFIED IDEOGRAPH
	{0xF54C,	0x97FD},	// CJK UNIFIED IDEOGRAPH
	{0xF54D,	0x97FE},	// CJK UNIFIED IDEOGRAPH
	{0xF54E,	0x9860},	// CJK UNIFIED IDEOGRAPH
	{0xF54F,	0x9862},	// CJK UNIFIED IDEOGRAPH
	{0xF550,	0x9863},	// CJK UNIFIED IDEOGRAPH
	{0xF551,	0x985F},	// CJK UNIFIED IDEOGRAPH
	{0xF552,	0x98C1},	// CJK UNIFIED IDEOGRAPH
	{0xF553,	0x98C2},	// CJK UNIFIED IDEOGRAPH
	{0xF554,	0x9950},	// CJK UNIFIED IDEOGRAPH
	{0xF555,	0x994E},	// CJK UNIFIED IDEOGRAPH
	{0xF556,	0x9959},	// CJK UNIFIED IDEOGRAPH
	{0xF557,	0x994C},	// CJK UNIFIED IDEOGRAPH
	{0xF558,	0x994B},	// CJK UNIFIED IDEOGRAPH
	{0xF559,	0x9953},	// CJK UNIFIED IDEOGRAPH
	{0xF55A,	0x9A32},	// CJK UNIFIED IDEOGRAPH
	{0xF55B,	0x9A34},	// CJK UNIFIED IDEOGRAPH
	{0xF55C,	0x9A31},	// CJK UNIFIED IDEOGRAPH
	{0xF55D,	0x9A2C},	// CJK UNIFIED IDEOGRAPH
	{0xF55E,	0x9A2A},	// CJK UNIFIED IDEOGRAPH
	{0xF55F,	0x9A36},	// CJK UNIFIED IDEOGRAPH
	{0xF560,	0x9A29},	// CJK UNIFIED IDEOGRAPH
	{0xF561,	0x9A2E},	// CJK UNIFIED IDEOGRAPH
	{0xF562,	0x9A38},	// CJK UNIFIED IDEOGRAPH
	{0xF563,	0x9A2D},	// CJK UNIFIED IDEOGRAPH
	{0xF564,	0x9AC7},	// CJK UNIFIED IDEOGRAPH
	{0xF565,	0x9ACA},	// CJK UNIFIED IDEOGRAPH
	{0xF566,	0x9AC6},	// CJK UNIFIED IDEOGRAPH
	{0xF567,	0x9B10},	// CJK UNIFIED IDEOGRAPH
	{0xF568,	0x9B12},	// CJK UNIFIED IDEOGRAPH
	{0xF569,	0x9B11},	// CJK UNIFIED IDEOGRAPH
	{0xF56A,	0x9C0B},	// CJK UNIFIED IDEOGRAPH
	{0xF56B,	0x9C08},	// CJK UNIFIED IDEOGRAPH
	{0xF56C,	0x9BF7},	// CJK UNIFIED IDEOGRAPH
	{0xF56D,	0x9C05},	// CJK UNIFIED IDEOGRAPH
	{0xF56E,	0x9C12},	// CJK UNIFIED IDEOGRAPH
	{0xF56F,	0x9BF8},	// CJK UNIFIED IDEOGRAPH
	{0xF570,	0x9C40},	// CJK UNIFIED IDEOGRAPH
	{0xF571,	0x9C07},	// CJK UNIFIED IDEOGRAPH
	{0xF572,	0x9C0E},	// CJK UNIFIED IDEOGRAPH
	{0xF573,	0x9C06},	// CJK UNIFIED IDEOGRAPH
	{0xF574,	0x9C17},	// CJK UNIFIED IDEOGRAPH
	{0xF575,	0x9C14},	// CJK UNIFIED IDEOGRAPH
	{0xF576,	0x9C09},	// CJK UNIFIED IDEOGRAPH
	{0xF577,	0x9D9F},	// CJK UNIFIED IDEOGRAPH
	{0xF578,	0x9D99},	// CJK UNIFIED IDEOGRAPH
	{0xF579,	0x9DA4},	// CJK UNIFIED IDEOGRAPH
	{0xF57A,	0x9D9D},	// CJK UNIFIED IDEOGRAPH
	{0xF57B,	0x9D92},	// CJK UNIFIED IDEOGRAPH
	{0xF57C,	0x9D98},	// CJK UNIFIED IDEOGRAPH
	{0xF57D,	0x9D90},	// CJK UNIFIED IDEOGRAPH
	{0xF57E,	0x9D9B},	// CJK UNIFIED IDEOGRAPH
	{0xF5A1,	0x9DA0},	// CJK UNIFIED IDEOGRAPH
	{0xF5A2,	0x9D94},	// CJK UNIFIED IDEOGRAPH
	{0xF5A3,	0x9D9C},	// CJK UNIFIED IDEOGRAPH
	{0xF5A4,	0x9DAA},	// CJK UNIFIED IDEOGRAPH
	{0xF5A5,	0x9D97},	// CJK UNIFIED IDEOGRAPH
	{0xF5A6,	0x9DA1},	// CJK UNIFIED IDEOGRAPH
	{0xF5A7,	0x9D9A},	// CJK UNIFIED IDEOGRAPH
	{0xF5A8,	0x9DA2},	// CJK UNIFIED IDEOGRAPH
	{0xF5A9,	0x9DA8},	// CJK UNIFIED IDEOGRAPH
	{0xF5AA,	0x9D9E},	// CJK UNIFIED IDEOGRAPH
	{0xF5AB,	0x9DA3},	// CJK UNIFIED IDEOGRAPH
	{0xF5AC,	0x9DBF},	// CJK UNIFIED IDEOGRAPH
	{0xF5AD,	0x9DA9},	// CJK UNIFIED IDEOGRAPH
	{0xF5AE,	0x9D96},	// CJK UNIFIED IDEOGRAPH
	{0xF5AF,	0x9DA6},	// CJK UNIFIED IDEOGRAPH
	{0xF5B0,	0x9DA7},	// CJK UNIFIED IDEOGRAPH
	{0xF5B1,	0x9E99},	// CJK UNIFIED IDEOGRAPH
	{0xF5B2,	0x9E9B},	// CJK UNIFIED IDEOGRAPH
	{0xF5B3,	0x9E9A},	// CJK UNIFIED IDEOGRAPH
	{0xF5B4,	0x9EE5},	// CJK UNIFIED IDEOGRAPH
	{0xF5B5,	0x9EE4},	// CJK UNIFIED IDEOGRAPH
	{0xF5B6,	0x9EE7},	// CJK UNIFIED IDEOGRAPH
	{0xF5B7,	0x9EE6},	// CJK UNIFIED IDEOGRAPH
	{0xF5B8,	0x9F30},	// CJK UNIFIED IDEOGRAPH
	{0xF5B9,	0x9F2E},	// CJK UNIFIED IDEOGRAPH
	{0xF5BA,	0x9F5B},	// CJK UNIFIED IDEOGRAPH
	{0xF5BB,	0x9F60},	// CJK UNIFIED IDEOGRAPH
	{0xF5BC,	0x9F5E},	// CJK UNIFIED IDEOGRAPH
	{0xF5BD,	0x9F5D},	// CJK UNIFIED IDEOGRAPH
	{0xF5BE,	0x9F59},	// CJK UNIFIED IDEOGRAPH
	{0xF5BF,	0x9F91},	// CJK UNIFIED IDEOGRAPH
	{0xF5C0,	0x513A},	// CJK UNIFIED IDEOGRAPH
	{0xF5C1,	0x5139},	// CJK UNIFIED IDEOGRAPH
	{0xF5C2,	0x5298},	// CJK UNIFIED IDEOGRAPH
	{0xF5C3,	0x5297},	// CJK UNIFIED IDEOGRAPH
	{0xF5C4,	0x56C3},	// CJK UNIFIED IDEOGRAPH
	{0xF5C5,	0x56BD},	// CJK UNIFIED IDEOGRAPH
	{0xF5C6,	0x56BE},	// CJK UNIFIED IDEOGRAPH
	{0xF5C7,	0x5B48},	// CJK UNIFIED IDEOGRAPH
	{0xF5C8,	0x5B47},	// CJK UNIFIED IDEOGRAPH
	{0xF5C9,	0x5DCB},	// CJK UNIFIED IDEOGRAPH
	{0xF5CA,	0x5DCF},	// CJK UNIFIED IDEOGRAPH
	{0xF5CB,	0x5EF1},	// CJK UNIFIED IDEOGRAPH
	{0xF5CC,	0x61FD},	// CJK UNIFIED IDEOGRAPH
	{0xF5CD,	0x651B},	// CJK UNIFIED IDEOGRAPH
	{0xF5CE,	0x6B02},	// CJK UNIFIED IDEOGRAPH
	{0xF5CF,	0x6AFC},	// CJK UNIFIED IDEOGRAPH
	{0xF5D0,	0x6B03},	// CJK UNIFIED IDEOGRAPH
	{0xF5D1,	0x6AF8},	// CJK UNIFIED IDEOGRAPH
	{0xF5D2,	0x6B00},	// CJK UNIFIED IDEOGRAPH
	{0xF5D3,	0x7043},	// CJK UNIFIED IDEOGRAPH
	{0xF5D4,	0x7044},	// CJK UNIFIED IDEOGRAPH
	{0xF5D5,	0x704A},	// CJK UNIFIED IDEOGRAPH
	{0xF5D6,	0x7048},	// CJK UNIFIED IDEOGRAPH
	{0xF5D7,	0x7049},	// CJK UNIFIED IDEOGRAPH
	{0xF5D8,	0x7045},	// CJK UNIFIED IDEOGRAPH
	{0xF5D9,	0x7046},	// CJK UNIFIED IDEOGRAPH
	{0xF5DA,	0x721D},	// CJK UNIFIED IDEOGRAPH
	{0xF5DB,	0x721A},	// CJK UNIFIED IDEOGRAPH
	{0xF5DC,	0x7219},	// CJK UNIFIED IDEOGRAPH
	{0xF5DD,	0x737E},	// CJK UNIFIED IDEOGRAPH
	{0xF5DE,	0x7517},	// CJK UNIFIED IDEOGRAPH
	{0xF5DF,	0x766A},	// CJK UNIFIED IDEOGRAPH
	{0xF5E0,	0x77D0},	// CJK UNIFIED IDEOGRAPH
	{0xF5E1,	0x792D},	// CJK UNIFIED IDEOGRAPH
	{0xF5E2,	0x7931},	// CJK UNIFIED IDEOGRAPH
	{0xF5E3,	0x792F},	// CJK UNIFIED IDEOGRAPH
	{0xF5E4,	0x7C54},	// CJK UNIFIED IDEOGRAPH
	{0xF5E5,	0x7C53},	// CJK UNIFIED IDEOGRAPH
	{0xF5E6,	0x7CF2},	// CJK UNIFIED IDEOGRAPH
	{0xF5E7,	0x7E8A},	// CJK UNIFIED IDEOGRAPH
	{0xF5E8,	0x7E87},	// CJK UNIFIED IDEOGRAPH
	{0xF5E9,	0x7E88},	// CJK UNIFIED IDEOGRAPH
	{0xF5EA,	0x7E8B},	// CJK UNIFIED IDEOGRAPH
	{0xF5EB,	0x7E86},	// CJK UNIFIED IDEOGRAPH
	{0xF5EC,	0x7E8D},	// CJK UNIFIED IDEOGRAPH
	{0xF5ED,	0x7F4D},	// CJK UNIFIED IDEOGRAPH
	{0xF5EE,	0x7FBB},	// CJK UNIFIED IDEOGRAPH
	{0xF5EF,	0x8030},	// CJK UNIFIED IDEOGRAPH
	{0xF5F0,	0x81DD},	// CJK UNIFIED IDEOGRAPH
	{0xF5F1,	0x8618},	// CJK UNIFIED IDEOGRAPH
	{0xF5F2,	0x862A},	// CJK UNIFIED IDEOGRAPH
	{0xF5F3,	0x8626},	// CJK UNIFIED IDEOGRAPH
	{0xF5F4,	0x861F},	// CJK UNIFIED IDEOGRAPH
	{0xF5F5,	0x8623},	// CJK UNIFIED IDEOGRAPH
	{0xF5F6,	0x861C},	// CJK UNIFIED IDEOGRAPH
	{0xF5F7,	0x8619},	// CJK UNIFIED IDEOGRAPH
	{0xF5F8,	0x8627},	// CJK UNIFIED IDEOGRAPH
	{0xF5F9,	0x862E},	// CJK UNIFIED IDEOGRAPH
	{0xF5FA,	0x8621},	// CJK UNIFIED IDEOGRAPH
	{0xF5FB,	0x8620},	// CJK UNIFIED IDEOGRAPH
	{0xF5FC,	0x8629},	// CJK UNIFIED IDEOGRAPH
	{0xF5FD,	0x861E},	// CJK UNIFIED IDEOGRAPH
	{0xF5FE,	0x8625},	// CJK UNIFIED IDEOGRAPH
	{0xF640,	0x8829},	// CJK UNIFIED IDEOGRAPH
	{0xF641,	0x881D},	// CJK UNIFIED IDEOGRAPH
	{0xF642,	0x881B},	// CJK UNIFIED IDEOGRAPH
	{0xF643,	0x8820},	// CJK UNIFIED IDEOGRAPH
	{0xF644,	0x8824},	// CJK UNIFIED IDEOGRAPH
	{0xF645,	0x881C},	// CJK UNIFIED IDEOGRAPH
	{0xF646,	0x882B},	// CJK UNIFIED IDEOGRAPH
	{0xF647,	0x884A},	// CJK UNIFIED IDEOGRAPH
	{0xF648,	0x896D},	// CJK UNIFIED IDEOGRAPH
	{0xF649,	0x8969},	// CJK UNIFIED IDEOGRAPH
	{0xF64A,	0x896E},	// CJK UNIFIED IDEOGRAPH
	{0xF64B,	0x896B},	// CJK UNIFIED IDEOGRAPH
	{0xF64C,	0x89FA},	// CJK UNIFIED IDEOGRAPH
	{0xF64D,	0x8B79},	// CJK UNIFIED IDEOGRAPH
	{0xF64E,	0x8B78},	// CJK UNIFIED IDEOGRAPH
	{0xF64F,	0x8B45},	// CJK UNIFIED IDEOGRAPH
	{0xF650,	0x8B7A},	// CJK UNIFIED IDEOGRAPH
	{0xF651,	0x8B7B},	// CJK UNIFIED IDEOGRAPH
	{0xF652,	0x8D10},	// CJK UNIFIED IDEOGRAPH
	{0xF653,	0x8D14},	// CJK UNIFIED IDEOGRAPH
	{0xF654,	0x8DAF},	// CJK UNIFIED IDEOGRAPH
	{0xF655,	0x8E8E},	// CJK UNIFIED IDEOGRAPH
	{0xF656,	0x8E8C},	// CJK UNIFIED IDEOGRAPH
	{0xF657,	0x8F5E},	// CJK UNIFIED IDEOGRAPH
	{0xF658,	0x8F5B},	// CJK UNIFIED IDEOGRAPH
	{0xF659,	0x8F5D},	// CJK UNIFIED IDEOGRAPH
	{0xF65A,	0x9146},	// CJK UNIFIED IDEOGRAPH
	{0xF65B,	0x9144},	// CJK UNIFIED IDEOGRAPH
	{0xF65C,	0x9145},	// CJK UNIFIED IDEOGRAPH
	{0xF65D,	0x91B9},	// CJK UNIFIED IDEOGRAPH
	{0xF65E,	0x943F},	// CJK UNIFIED IDEOGRAPH
	{0xF65F,	0x943B},	// CJK UNIFIED IDEOGRAPH
	{0xF660,	0x9436},	// CJK UNIFIED IDEOGRAPH
	{0xF661,	0x9429},	// CJK UNIFIED IDEOGRAPH
	{0xF662,	0x943D},	// CJK UNIFIED IDEOGRAPH
	{0xF663,	0x943C},	// CJK UNIFIED IDEOGRAPH
	{0xF664,	0x9430},	// CJK UNIFIED IDEOGRAPH
	{0xF665,	0x9439},	// CJK UNIFIED IDEOGRAPH
	{0xF666,	0x942A},	// CJK UNIFIED IDEOGRAPH
	{0xF667,	0x9437},	// CJK UNIFIED IDEOGRAPH
	{0xF668,	0x942C},	// CJK UNIFIED IDEOGRAPH
	{0xF669,	0x9440},	// CJK UNIFIED IDEOGRAPH
	{0xF66A,	0x9431},	// CJK UNIFIED IDEOGRAPH
	{0xF66B,	0x95E5},	// CJK UNIFIED IDEOGRAPH
	{0xF66C,	0x95E4},	// CJK UNIFIED IDEOGRAPH
	{0xF66D,	0x95E3},	// CJK UNIFIED IDEOGRAPH
	{0xF66E,	0x9735},	// CJK UNIFIED IDEOGRAPH
	{0xF66F,	0x973A},	// CJK UNIFIED IDEOGRAPH
	{0xF670,	0x97BF},	// CJK UNIFIED IDEOGRAPH
	{0xF671,	0x97E1},	// CJK UNIFIED IDEOGRAPH
	{0xF672,	0x9864},	// CJK UNIFIED IDEOGRAPH
	{0xF673,	0x98C9},	// CJK UNIFIED IDEOGRAPH
	{0xF674,	0x98C6},	// CJK UNIFIED IDEOGRAPH
	{0xF675,	0x98C0},	// CJK UNIFIED IDEOGRAPH
	{0xF676,	0x9958},	// CJK UNIFIED IDEOGRAPH
	{0xF677,	0x9956},	// CJK UNIFIED IDEOGRAPH
	{0xF678,	0x9A39},	// CJK UNIFIED IDEOGRAPH
	{0xF679,	0x9A3D},	// CJK UNIFIED IDEOGRAPH
	{0xF67A,	0x9A46},	// CJK UNIFIED IDEOGRAPH
	{0xF67B,	0x9A44},	// CJK UNIFIED IDEOGRAPH
	{0xF67C,	0x9A42},	// CJK UNIFIED IDEOGRAPH
	{0xF67D,	0x9A41},	// CJK UNIFIED IDEOGRAPH
	{0xF67E,	0x9A3A},	// CJK UNIFIED IDEOGRAPH
	{0xF6A1,	0x9A3F},	// CJK UNIFIED IDEOGRAPH
	{0xF6A2,	0x9ACD},	// CJK UNIFIED IDEOGRAPH
	{0xF6A3,	0x9B15},	// CJK UNIFIED IDEOGRAPH
	{0xF6A4,	0x9B17},	// CJK UNIFIED IDEOGRAPH
	{0xF6A5,	0x9B18},	// CJK UNIFIED IDEOGRAPH
	{0xF6A6,	0x9B16},	// CJK UNIFIED IDEOGRAPH
	{0xF6A7,	0x9B3A},	// CJK UNIFIED IDEOGRAPH
	{0xF6A8,	0x9B52},	// CJK UNIFIED IDEOGRAPH
	{0xF6A9,	0x9C2B},	// CJK UNIFIED IDEOGRAPH
	{0xF6AA,	0x9C1D},	// CJK UNIFIED IDEOGRAPH
	{0xF6AB,	0x9C1C},	// CJK UNIFIED IDEOGRAPH
	{0xF6AC,	0x9C2C},	// CJK UNIFIED IDEOGRAPH
	{0xF6AD,	0x9C23},	// CJK UNIFIED IDEOGRAPH
	{0xF6AE,	0x9C28},	// CJK UNIFIED IDEOGRAPH
	{0xF6AF,	0x9C29},	// CJK UNIFIED IDEOGRAPH
	{0xF6B0,	0x9C24},	// CJK UNIFIED IDEOGRAPH
	{0xF6B1,	0x9C21},	// CJK UNIFIED IDEOGRAPH
	{0xF6B2,	0x9DB7},	// CJK UNIFIED IDEOGRAPH
	{0xF6B3,	0x9DB6},	// CJK UNIFIED IDEOGRAPH
	{0xF6B4,	0x9DBC},	// CJK UNIFIED IDEOGRAPH
	{0xF6B5,	0x9DC1},	// CJK UNIFIED IDEOGRAPH
	{0xF6B6,	0x9DC7},	// CJK UNIFIED IDEOGRAPH
	{0xF6B7,	0x9DCA},	// CJK UNIFIED IDEOGRAPH
	{0xF6B8,	0x9DCF},	// CJK UNIFIED IDEOGRAPH
	{0xF6B9,	0x9DBE},	// CJK UNIFIED IDEOGRAPH
	{0xF6BA,	0x9DC5},	// CJK UNIFIED IDEOGRAPH
	{0xF6BB,	0x9DC3},	// CJK UNIFIED IDEOGRAPH
	{0xF6BC,	0x9DBB},	// CJK UNIFIED IDEOGRAPH
	{0xF6BD,	0x9DB5},	// CJK UNIFIED IDEOGRAPH
	{0xF6BE,	0x9DCE},	// CJK UNIFIED IDEOGRAPH
	{0xF6BF,	0x9DB9},	// CJK UNIFIED IDEOGRAPH
	{0xF6C0,	0x9DBA},	// CJK UNIFIED IDEOGRAPH
	{0xF6C1,	0x9DAC},	// CJK UNIFIED IDEOGRAPH
	{0xF6C2,	0x9DC8},	// CJK UNIFIED IDEOGRAPH
	{0xF6C3,	0x9DB1},	// CJK UNIFIED IDEOGRAPH
	{0xF6C4,	0x9DAD},	// CJK UNIFIED IDEOGRAPH
	{0xF6C5,	0x9DCC},	// CJK UNIFIED IDEOGRAPH
	{0xF6C6,	0x9DB3},	// CJK UNIFIED IDEOGRAPH
	{0xF6C7,	0x9DCD},	// CJK UNIFIED IDEOGRAPH
	{0xF6C8,	0x9DB2},	// CJK UNIFIED IDEOGRAPH
	{0xF6C9,	0x9E7A},	// CJK UNIFIED IDEOGRAPH
	{0xF6CA,	0x9E9C},	// CJK UNIFIED IDEOGRAPH
	{0xF6CB,	0x9EEB},	// CJK UNIFIED IDEOGRAPH
	{0xF6CC,	0x9EEE},	// CJK UNIFIED IDEOGRAPH
	{0xF6CD,	0x9EED},	// CJK UNIFIED IDEOGRAPH
	{0xF6CE,	0x9F1B},	// CJK UNIFIED IDEOGRAPH
	{0xF6CF,	0x9F18},	// CJK UNIFIED IDEOGRAPH
	{0xF6D0,	0x9F1A},	// CJK UNIFIED IDEOGRAPH
	{0xF6D1,	0x9F31},	// CJK UNIFIED IDEOGRAPH
	{0xF6D2,	0x9F4E},	// CJK UNIFIED IDEOGRAPH
	{0xF6D3,	0x9F65},	// CJK UNIFIED IDEOGRAPH
	{0xF6D4,	0x9F64},	// CJK UNIFIED IDEOGRAPH
	{0xF6D5,	0x9F92},	// CJK UNIFIED IDEOGRAPH
	{0xF6D6,	0x4EB9},	// CJK UNIFIED IDEOGRAPH
	{0xF6D7,	0x56C6},	// CJK UNIFIED IDEOGRAPH
	{0xF6D8,	0x56C5},	// CJK UNIFIED IDEOGRAPH
	{0xF6D9,	0x56CB},	// CJK UNIFIED IDEOGRAPH
	{0xF6DA,	0x5971},	// CJK UNIFIED IDEOGRAPH
	{0xF6DB,	0x5B4B},	// CJK UNIFIED IDEOGRAPH
	{0xF6DC,	0x5B4C},	// CJK UNIFIED IDEOGRAPH
	{0xF6DD,	0x5DD5},	// CJK UNIFIED IDEOGRAPH
	{0xF6DE,	0x5DD1},	// CJK UNIFIED IDEOGRAPH
	{0xF6DF,	0x5EF2},	// CJK UNIFIED IDEOGRAPH
	{0xF6E0,	0x6521},	// CJK UNIFIED IDEOGRAPH
	{0xF6E1,	0x6520},	// CJK UNIFIED IDEOGRAPH
	{0xF6E2,	0x6526},	// CJK UNIFIED IDEOGRAPH
	{0xF6E3,	0x6522},	// CJK UNIFIED IDEOGRAPH
	{0xF6E4,	0x6B0B},	// CJK UNIFIED IDEOGRAPH
	{0xF6E5,	0x6B08},	// CJK UNIFIED IDEOGRAPH
	{0xF6E6,	0x6B09},	// CJK UNIFIED IDEOGRAPH
	{0xF6E7,	0x6C0D},	// CJK UNIFIED IDEOGRAPH
	{0xF6E8,	0x7055},	// CJK UNIFIED IDEOGRAPH
	{0xF6E9,	0x7056},	// CJK UNIFIED IDEOGRAPH
	{0xF6EA,	0x7057},	// CJK UNIFIED IDEOGRAPH
	{0xF6EB,	0x7052},	// CJK UNIFIED IDEOGRAPH
	{0xF6EC,	0x721E},	// CJK UNIFIED IDEOGRAPH
	{0xF6ED,	0x721F},	// CJK UNIFIED IDEOGRAPH
	{0xF6EE,	0x72A9},	// CJK UNIFIED IDEOGRAPH
	{0xF6EF,	0x737F},	// CJK UNIFIED IDEOGRAPH
	{0xF6F0,	0x74D8},	// CJK UNIFIED IDEOGRAPH
	{0xF6F1,	0x74D5},	// CJK UNIFIED IDEOGRAPH
	{0xF6F2,	0x74D9},	// CJK UNIFIED IDEOGRAPH
	{0xF6F3,	0x74D7},	// CJK UNIFIED IDEOGRAPH
	{0xF6F4,	0x766D},	// CJK UNIFIED IDEOGRAPH
	{0xF6F5,	0x76AD},	// CJK UNIFIED IDEOGRAPH
	{0xF6F6,	0x7935},	// CJK UNIFIED IDEOGRAPH
	{0xF6F7,	0x79B4},	// CJK UNIFIED IDEOGRAPH
	{0xF6F8,	0x7A70},	// CJK UNIFIED IDEOGRAPH
	{0xF6F9,	0x7A71},	// CJK UNIFIED IDEOGRAPH
	{0xF6FA,	0x7C57},	// CJK UNIFIED IDEOGRAPH
	{0xF6FB,	0x7C5C},	// CJK UNIFIED IDEOGRAPH
	{0xF6FC,	0x7C59},	// CJK UNIFIED IDEOGRAPH
	{0xF6FD,	0x7C5B},	// CJK UNIFIED IDEOGRAPH
	{0xF6FE,	0x7C5A},	// CJK UNIFIED IDEOGRAPH
	{0xF740,	0x7CF4},	// CJK UNIFIED IDEOGRAPH
	{0xF741,	0x7CF1},	// CJK UNIFIED IDEOGRAPH
	{0xF742,	0x7E91},	// CJK UNIFIED IDEOGRAPH
	{0xF743,	0x7F4F},	// CJK UNIFIED IDEOGRAPH
	{0xF744,	0x7F87},	// CJK UNIFIED IDEOGRAPH
	{0xF745,	0x81DE},	// CJK UNIFIED IDEOGRAPH
	{0xF746,	0x826B},	// CJK UNIFIED IDEOGRAPH
	{0xF747,	0x8634},	// CJK UNIFIED IDEOGRAPH
	{0xF748,	0x8635},	// CJK UNIFIED IDEOGRAPH
	{0xF749,	0x8633},	// CJK UNIFIED IDEOGRAPH
	{0xF74A,	0x862C},	// CJK UNIFIED IDEOGRAPH
	{0xF74B,	0x8632},	// CJK UNIFIED IDEOGRAPH
	{0xF74C,	0x8636},	// CJK UNIFIED IDEOGRAPH
	{0xF74D,	0x882C},	// CJK UNIFIED IDEOGRAPH
	{0xF74E,	0x8828},	// CJK UNIFIED IDEOGRAPH
	{0xF74F,	0x8826},	// CJK UNIFIED IDEOGRAPH
	{0xF750,	0x882A},	// CJK UNIFIED IDEOGRAPH
	{0xF751,	0x8825},	// CJK UNIFIED IDEOGRAPH
	{0xF752,	0x8971},	// CJK UNIFIED IDEOGRAPH
	{0xF753,	0x89BF},	// CJK UNIFIED IDEOGRAPH
	{0xF754,	0x89BE},	// CJK UNIFIED IDEOGRAPH
	{0xF755,	0x89FB},	// CJK UNIFIED IDEOGRAPH
	{0xF756,	0x8B7E},	// CJK UNIFIED IDEOGRAPH
	{0xF757,	0x8B84},	// CJK UNIFIED IDEOGRAPH
	{0xF758,	0x8B82},	// CJK UNIFIED IDEOGRAPH
	{0xF759,	0x8B86},	// CJK UNIFIED IDEOGRAPH
	{0xF75A,	0x8B85},	// CJK UNIFIED IDEOGRAPH
	{0xF75B,	0x8B7F},	// CJK UNIFIED IDEOGRAPH
	{0xF75C,	0x8D15},	// CJK UNIFIED IDEOGRAPH
	{0xF75D,	0x8E95},	// CJK UNIFIED IDEOGRAPH
	{0xF75E,	0x8E94},	// CJK UNIFIED IDEOGRAPH
	{0xF75F,	0x8E9A},	// CJK UNIFIED IDEOGRAPH
	{0xF760,	0x8E92},	// CJK UNIFIED IDEOGRAPH
	{0xF761,	0x8E90},	// CJK UNIFIED IDEOGRAPH
	{0xF762,	0x8E96},	// CJK UNIFIED IDEOGRAPH
	{0xF763,	0x8E97},	// CJK UNIFIED IDEOGRAPH
	{0xF764,	0x8F60},	// CJK UNIFIED IDEOGRAPH
	{0xF765,	0x8F62},	// CJK UNIFIED IDEOGRAPH
	{0xF766,	0x9147},	// CJK UNIFIED IDEOGRAPH
	{0xF767,	0x944C},	// CJK UNIFIED IDEOGRAPH
	{0xF768,	0x9450},	// CJK UNIFIED IDEOGRAPH
	{0xF769,	0x944A},	// CJK UNIFIED IDEOGRAPH
	{0xF76A,	0x944B},	// CJK UNIFIED IDEOGRAPH
	{0xF76B,	0x944F},	// CJK UNIFIED IDEOGRAPH
	{0xF76C,	0x9447},	// CJK UNIFIED IDEOGRAPH
	{0xF76D,	0x9445},	// CJK UNIFIED IDEOGRAPH
	{0xF76E,	0x9448},	// CJK UNIFIED IDEOGRAPH
	{0xF76F,	0x9449},	// CJK UNIFIED IDEOGRAPH
	{0xF770,	0x9446},	// CJK UNIFIED IDEOGRAPH
	{0xF771,	0x973F},	// CJK UNIFIED IDEOGRAPH
	{0xF772,	0x97E3},	// CJK UNIFIED IDEOGRAPH
	{0xF773,	0x986A},	// CJK UNIFIED IDEOGRAPH
	{0xF774,	0x9869},	// CJK UNIFIED IDEOGRAPH
	{0xF775,	0x98CB},	// CJK UNIFIED IDEOGRAPH
	{0xF776,	0x9954},	// CJK UNIFIED IDEOGRAPH
	{0xF777,	0x995B},	// CJK UNIFIED IDEOGRAPH
	{0xF778,	0x9A4E},	// CJK UNIFIED IDEOGRAPH
	{0xF779,	0x9A53},	// CJK UNIFIED IDEOGRAPH
	{0xF77A,	0x9A54},	// CJK UNIFIED IDEOGRAPH
	{0xF77B,	0x9A4C},	// CJK UNIFIED IDEOGRAPH
	{0xF77C,	0x9A4F},	// CJK UNIFIED IDEOGRAPH
	{0xF77D,	0x9A48},	// CJK UNIFIED IDEOGRAPH
	{0xF77E,	0x9A4A},	// CJK UNIFIED IDEOGRAPH
	{0xF7A1,	0x9A49},	// CJK UNIFIED IDEOGRAPH
	{0xF7A2,	0x9A52},	// CJK UNIFIED IDEOGRAPH
	{0xF7A3,	0x9A50},	// CJK UNIFIED IDEOGRAPH
	{0xF7A4,	0x9AD0},	// CJK UNIFIED IDEOGRAPH
	{0xF7A5,	0x9B19},	// CJK UNIFIED IDEOGRAPH
	{0xF7A6,	0x9B2B},	// CJK UNIFIED IDEOGRAPH
	{0xF7A7,	0x9B3B},	// CJK UNIFIED IDEOGRAPH
	{0xF7A8,	0x9B56},	// CJK UNIFIED IDEOGRAPH
	{0xF7A9,	0x9B55},	// CJK UNIFIED IDEOGRAPH
	{0xF7AA,	0x9C46},	// CJK UNIFIED IDEOGRAPH
	{0xF7AB,	0x9C48},	// CJK UNIFIED IDEOGRAPH
	{0xF7AC,	0x9C3F},	// CJK UNIFIED IDEOGRAPH
	{0xF7AD,	0x9C44},	// CJK UNIFIED IDEOGRAPH
	{0xF7AE,	0x9C39},	// CJK UNIFIED IDEOGRAPH
	{0xF7AF,	0x9C33},	// CJK UNIFIED IDEOGRAPH
	{0xF7B0,	0x9C41},	// CJK UNIFIED IDEOGRAPH
	{0xF7B1,	0x9C3C},	// CJK UNIFIED IDEOGRAPH
	{0xF7B2,	0x9C37},	// CJK UNIFIED IDEOGRAPH
	{0xF7B3,	0x9C34},	// CJK UNIFIED IDEOGRAPH
	{0xF7B4,	0x9C32},	// CJK UNIFIED IDEOGRAPH
	{0xF7B5,	0x9C3D},	// CJK UNIFIED IDEOGRAPH
	{0xF7B6,	0x9C36},	// CJK UNIFIED IDEOGRAPH
	{0xF7B7,	0x9DDB},	// CJK UNIFIED IDEOGRAPH
	{0xF7B8,	0x9DD2},	// CJK UNIFIED IDEOGRAPH
	{0xF7B9,	0x9DDE},	// CJK UNIFIED IDEOGRAPH
	{0xF7BA,	0x9DDA},	// CJK UNIFIED IDEOGRAPH
	{0xF7BB,	0x9DCB},	// CJK UNIFIED IDEOGRAPH
	{0xF7BC,	0x9DD0},	// CJK UNIFIED IDEOGRAPH
	{0xF7BD,	0x9DDC},	// CJK UNIFIED IDEOGRAPH
	{0xF7BE,	0x9DD1},	// CJK UNIFIED IDEOGRAPH
	{0xF7BF,	0x9DDF},	// CJK UNIFIED IDEOGRAPH
	{0xF7C0,	0x9DE9},	// CJK UNIFIED IDEOGRAPH
	{0xF7C1,	0x9DD9},	// CJK UNIFIED IDEOGRAPH
	{0xF7C2,	0x9DD8},	// CJK UNIFIED IDEOGRAPH
	{0xF7C3,	0x9DD6},	// CJK UNIFIED IDEOGRAPH
	{0xF7C4,	0x9DF5},	// CJK UNIFIED IDEOGRAPH
	{0xF7C5,	0x9DD5},	// CJK UNIFIED IDEOGRAPH
	{0xF7C6,	0x9DDD},	// CJK UNIFIED IDEOGRAPH
	{0xF7C7,	0x9EB6},	// CJK UNIFIED IDEOGRAPH
	{0xF7C8,	0x9EF0},	// CJK UNIFIED IDEOGRAPH
	{0xF7C9,	0x9F35},	// CJK UNIFIED IDEOGRAPH
	{0xF7CA,	0x9F33},	// CJK UNIFIED IDEOGRAPH
	{0xF7CB,	0x9F32},	// CJK UNIFIED IDEOGRAPH
	{0xF7CC,	0x9F42},	// CJK UNIFIED IDEOGRAPH
	{0xF7CD,	0x9F6B},	// CJK UNIFIED IDEOGRAPH
	{0xF7CE,	0x9F95},	// CJK UNIFIED IDEOGRAPH
	{0xF7CF,	0x9FA2},	// CJK UNIFIED IDEOGRAPH
	{0xF7D0,	0x513D},	// CJK UNIFIED IDEOGRAPH
	{0xF7D1,	0x5299},	// CJK UNIFIED IDEOGRAPH
	{0xF7D2,	0x58E8},	// CJK UNIFIED IDEOGRAPH
	{0xF7D3,	0x58E7},	// CJK UNIFIED IDEOGRAPH
	{0xF7D4,	0x5972},	// CJK UNIFIED IDEOGRAPH
	{0xF7D5,	0x5B4D},	// CJK UNIFIED IDEOGRAPH
	{0xF7D6,	0x5DD8},	// CJK UNIFIED IDEOGRAPH
	{0xF7D7,	0x882F},	// CJK UNIFIED IDEOGRAPH
	{0xF7D8,	0x5F4F},	// CJK UNIFIED IDEOGRAPH
	{0xF7D9,	0x6201},	// CJK UNIFIED IDEOGRAPH
	{0xF7DA,	0x6203},	// CJK UNIFIED IDEOGRAPH
	{0xF7DB,	0x6204},	// CJK UNIFIED IDEOGRAPH
	{0xF7DC,	0x6529},	// CJK UNIFIED IDEOGRAPH
	{0xF7DD,	0x6525},	// CJK UNIFIED IDEOGRAPH
	{0xF7DE,	0x6596},	// CJK UNIFIED IDEOGRAPH
	{0xF7DF,	0x66EB},	// CJK UNIFIED IDEOGRAPH
	{0xF7E0,	0x6B11},	// CJK UNIFIED IDEOGRAPH
	{0xF7E1,	0x6B12},	// CJK UNIFIED IDEOGRAPH
	{0xF7E2,	0x6B0F},	// CJK UNIFIED IDEOGRAPH
	{0xF7E3,	0x6BCA},	// CJK UNIFIED IDEOGRAPH
	{0xF7E4,	0x705B},	// CJK UNIFIED IDEOGRAPH
	{0xF7E5,	0x705A},	// CJK UNIFIED IDEOGRAPH
	{0xF7E6,	0x7222},	// CJK UNIFIED IDEOGRAPH
	{0xF7E7,	0x7382},	// CJK UNIFIED IDEOGRAPH
	{0xF7E8,	0x7381},	// CJK UNIFIED IDEOGRAPH
	{0xF7E9,	0x7383},	// CJK UNIFIED IDEOGRAPH
	{0xF7EA,	0x7670},	// CJK UNIFIED IDEOGRAPH
	{0xF7EB,	0x77D4},	// CJK UNIFIED IDEOGRAPH
	{0xF7EC,	0x7C67},	// CJK UNIFIED IDEOGRAPH
	{0xF7ED,	0x7C66},	// CJK UNIFIED IDEOGRAPH
	{0xF7EE,	0x7E95},	// CJK UNIFIED IDEOGRAPH
	{0xF7EF,	0x826C},	// CJK UNIFIED IDEOGRAPH
	{0xF7F0,	0x863A},	// CJK UNIFIED IDEOGRAPH
	{0xF7F1,	0x8640},	// CJK UNIFIED IDEOGRAPH
	{0xF7F2,	0x8639},	// CJK UNIFIED IDEOGRAPH
	{0xF7F3,	0x863C},	// CJK UNIFIED IDEOGRAPH
	{0xF7F4,	0x8631},	// CJK UNIFIED IDEOGRAPH
	{0xF7F5,	0x863B},	// CJK UNIFIED IDEOGRAPH
	{0xF7F6,	0x863E},	// CJK UNIFIED IDEOGRAPH
	{0xF7F7,	0x8830},	// CJK UNIFIED IDEOGRAPH
	{0xF7F8,	0x8832},	// CJK UNIFIED IDEOGRAPH
	{0xF7F9,	0x882E},	// CJK UNIFIED IDEOGRAPH
	{0xF7FA,	0x8833},	// CJK UNIFIED IDEOGRAPH
	{0xF7FB,	0x8976},	// CJK UNIFIED IDEOGRAPH
	{0xF7FC,	0x8974},	// CJK UNIFIED IDEOGRAPH
	{0xF7FD,	0x8973},	// CJK UNIFIED IDEOGRAPH
	{0xF7FE,	0x89FE},	// CJK UNIFIED IDEOGRAPH
	{0xF840,	0x8B8C},	// CJK UNIFIED IDEOGRAPH
	{0xF841,	0x8B8E},	// CJK UNIFIED IDEOGRAPH
	{0xF842,	0x8B8B},	// CJK UNIFIED IDEOGRAPH
	{0xF843,	0x8B88},	// CJK UNIFIED IDEOGRAPH
	{0xF844,	0x8C45},	// CJK UNIFIED IDEOGRAPH
	{0xF845,	0x8D19},	// CJK UNIFIED IDEOGRAPH
	{0xF846,	0x8E98},	// CJK UNIFIED IDEOGRAPH
	{0xF847,	0x8F64},	// CJK UNIFIED IDEOGRAPH
	{0xF848,	0x8F63},	// CJK UNIFIED IDEOGRAPH
	{0xF849,	0x91BC},	// CJK UNIFIED IDEOGRAPH
	{0xF84A,	0x9462},	// CJK UNIFIED IDEOGRAPH
	{0xF84B,	0x9455},	// CJK UNIFIED IDEOGRAPH
	{0xF84C,	0x945D},	// CJK UNIFIED IDEOGRAPH
	{0xF84D,	0x9457},	// CJK UNIFIED IDEOGRAPH
	{0xF84E,	0x945E},	// CJK UNIFIED IDEOGRAPH
	{0xF84F,	0x97C4},	// CJK UNIFIED IDEOGRAPH
	{0xF850,	0x97C5},	// CJK UNIFIED IDEOGRAPH
	{0xF851,	0x9800},	// CJK UNIFIED IDEOGRAPH
	{0xF852,	0x9A56},	// CJK UNIFIED IDEOGRAPH
	{0xF853,	0x9A59},	// CJK UNIFIED IDEOGRAPH
	{0xF854,	0x9B1E},	// CJK UNIFIED IDEOGRAPH
	{0xF855,	0x9B1F},	// CJK UNIFIED IDEOGRAPH
	{0xF856,	0x9B20},	// CJK UNIFIED IDEOGRAPH
	{0xF857,	0x9C52},	// CJK UNIFIED IDEOGRAPH
	{0xF858,	0x9C58},	// CJK UNIFIED IDEOGRAPH
	{0xF859,	0x9C50},	// CJK UNIFIED IDEOGRAPH
	{0xF85A,	0x9C4A},	// CJK UNIFIED IDEOGRAPH
	{0xF85B,	0x9C4D},	// CJK UNIFIED IDEOGRAPH
	{0xF85C,	0x9C4B},	// CJK UNIFIED IDEOGRAPH
	{0xF85D,	0x9C55},	// CJK UNIFIED IDEOGRAPH
	{0xF85E,	0x9C59},	// CJK UNIFIED IDEOGRAPH
	{0xF85F,	0x9C4C},	// CJK UNIFIED IDEOGRAPH
	{0xF860,	0x9C4E},	// CJK UNIFIED IDEOGRAPH
	{0xF861,	0x9DFB},	// CJK UNIFIED IDEOGRAPH
	{0xF862,	0x9DF7},	// CJK UNIFIED IDEOGRAPH
	{0xF863,	0x9DEF},	// CJK UNIFIED IDEOGRAPH
	{0xF864,	0x9DE3},	// CJK UNIFIED IDEOGRAPH
	{0xF865,	0x9DEB},	// CJK UNIFIED IDEOGRAPH
	{0xF866,	0x9DF8},	// CJK UNIFIED IDEOGRAPH
	{0xF867,	0x9DE4},	// CJK UNIFIED IDEOGRAPH
	{0xF868,	0x9DF6},	// CJK UNIFIED IDEOGRAPH
	{0xF869,	0x9DE1},	// CJK UNIFIED IDEOGRAPH
	{0xF86A,	0x9DEE},	// CJK UNIFIED IDEOGRAPH
	{0xF86B,	0x9DE6},	// CJK UNIFIED IDEOGRAPH
	{0xF86C,	0x9DF2},	// CJK UNIFIED IDEOGRAPH
	{0xF86D,	0x9DF0},	// CJK UNIFIED IDEOGRAPH
	{0xF86E,	0x9DE2},	// CJK UNIFIED IDEOGRAPH
	{0xF86F,	0x9DEC},	// CJK UNIFIED IDEOGRAPH
	{0xF870,	0x9DF4},	// CJK UNIFIED IDEOGRAPH
	{0xF871,	0x9DF3},	// CJK UNIFIED IDEOGRAPH
	{0xF872,	0x9DE8},	// CJK UNIFIED IDEOGRAPH
	{0xF873,	0x9DED},	// CJK UNIFIED IDEOGRAPH
	{0xF874,	0x9EC2},	// CJK UNIFIED IDEOGRAPH
	{0xF875,	0x9ED0},	// CJK UNIFIED IDEOGRAPH
	{0xF876,	0x9EF2},	// CJK UNIFIED IDEOGRAPH
	{0xF877,	0x9EF3},	// CJK UNIFIED IDEOGRAPH
	{0xF878,	0x9F06},	// CJK UNIFIED IDEOGRAPH
	{0xF879,	0x9F1C},	// CJK UNIFIED IDEOGRAPH
	{0xF87A,	0x9F38},	// CJK UNIFIED IDEOGRAPH
	{0xF87B,	0x9F37},	// CJK UNIFIED IDEOGRAPH
	{0xF87C,	0x9F36},	// CJK UNIFIED IDEOGRAPH
	{0xF87D,	0x9F43},	// CJK UNIFIED IDEOGRAPH
	{0xF87E,	0x9F4F},	// CJK UNIFIED IDEOGRAPH
	{0xF8A1,	0x9F71},	// CJK UNIFIED IDEOGRAPH
	{0xF8A2,	0x9F70},	// CJK UNIFIED IDEOGRAPH
	{0xF8A3,	0x9F6E},	// CJK UNIFIED IDEOGRAPH
	{0xF8A4,	0x9F6F},	// CJK UNIFIED IDEOGRAPH
	{0xF8A5,	0x56D3},	// CJK UNIFIED IDEOGRAPH
	{0xF8A6,	0x56CD},	// CJK UNIFIED IDEOGRAPH
	{0xF8A7,	0x5B4E},	// CJK UNIFIED IDEOGRAPH
	{0xF8A8,	0x5C6D},	// CJK UNIFIED IDEOGRAPH
	{0xF8A9,	0x652D},	// CJK UNIFIED IDEOGRAPH
	{0xF8AA,	0x66ED},	// CJK UNIFIED IDEOGRAPH
	{0xF8AB,	0x66EE},	// CJK UNIFIED IDEOGRAPH
	{0xF8AC,	0x6B13},	// CJK UNIFIED IDEOGRAPH
	{0xF8AD,	0x705F},	// CJK UNIFIED IDEOGRAPH
	{0xF8AE,	0x7061},	// CJK UNIFIED IDEOGRAPH
	{0xF8AF,	0x705D},	// CJK UNIFIED IDEOGRAPH
	{0xF8B0,	0x7060},	// CJK UNIFIED IDEOGRAPH
	{0xF8B1,	0x7223},	// CJK UNIFIED IDEOGRAPH
	{0xF8B2,	0x74DB},	// CJK UNIFIED IDEOGRAPH
	{0xF8B3,	0x74E5},	// CJK UNIFIED IDEOGRAPH
	{0xF8B4,	0x77D5},	// CJK UNIFIED IDEOGRAPH
	{0xF8B5,	0x7938},	// CJK UNIFIED IDEOGRAPH
	{0xF8B6,	0x79B7},	// CJK UNIFIED IDEOGRAPH
	{0xF8B7,	0x79B6},	// CJK UNIFIED IDEOGRAPH
	{0xF8B8,	0x7C6A},	// CJK UNIFIED IDEOGRAPH
	{0xF8B9,	0x7E97},	// CJK UNIFIED IDEOGRAPH
	{0xF8BA,	0x7F89},	// CJK UNIFIED IDEOGRAPH
	{0xF8BB,	0x826D},	// CJK UNIFIED IDEOGRAPH
	{0xF8BC,	0x8643},	// CJK UNIFIED IDEOGRAPH
	{0xF8BD,	0x8838},	// CJK UNIFIED IDEOGRAPH
	{0xF8BE,	0x8837},	// CJK UNIFIED IDEOGRAPH
	{0xF8BF,	0x8835},	// CJK UNIFIED IDEOGRAPH
	{0xF8C0,	0x884B},	// CJK UNIFIED IDEOGRAPH
	{0xF8C1,	0x8B94},	// CJK UNIFIED IDEOGRAPH
	{0xF8C2,	0x8B95},	// CJK UNIFIED IDEOGRAPH
	{0xF8C3,	0x8E9E},	// CJK UNIFIED IDEOGRAPH
	{0xF8C4,	0x8E9F},	// CJK UNIFIED IDEOGRAPH
	{0xF8C5,	0x8EA0},	// CJK UNIFIED IDEOGRAPH
	{0xF8C6,	0x8E9D},	// CJK UNIFIED IDEOGRAPH
	{0xF8C7,	0x91BE},	// CJK UNIFIED IDEOGRAPH
	{0xF8C8,	0x91BD},	// CJK UNIFIED IDEOGRAPH
	{0xF8C9,	0x91C2},	// CJK UNIFIED IDEOGRAPH
	{0xF8CA,	0x946B},	// CJK UNIFIED IDEOGRAPH
	{0xF8CB,	0x9468},	// CJK UNIFIED IDEOGRAPH
	{0xF8CC,	0x9469},	// CJK UNIFIED IDEOGRAPH
	{0xF8CD,	0x96E5},	// CJK UNIFIED IDEOGRAPH
	{0xF8CE,	0x9746},	// CJK UNIFIED IDEOGRAPH
	{0xF8CF,	0x9743},	// CJK UNIFIED IDEOGRAPH
	{0xF8D0,	0x9747},	// CJK UNIFIED IDEOGRAPH
	{0xF8D1,	0x97C7},	// CJK UNIFIED IDEOGRAPH
	{0xF8D2,	0x97E5},	// CJK UNIFIED IDEOGRAPH
	{0xF8D3,	0x9A5E},	// CJK UNIFIED IDEOGRAPH
	{0xF8D4,	0x9AD5},	// CJK UNIFIED IDEOGRAPH
	{0xF8D5,	0x9B59},	// CJK UNIFIED IDEOGRAPH
	{0xF8D6,	0x9C63},	// CJK UNIFIED IDEOGRAPH
	{0xF8D7,	0x9C67},	// CJK UNIFIED IDEOGRAPH
	{0xF8D8,	0x9C66},	// CJK UNIFIED IDEOGRAPH
	{0xF8D9,	0x9C62},	// CJK UNIFIED IDEOGRAPH
	{0xF8DA,	0x9C5E},	// CJK UNIFIED IDEOGRAPH
	{0xF8DB,	0x9C60},	// CJK UNIFIED IDEOGRAPH
	{0xF8DC,	0x9E02},	// CJK UNIFIED IDEOGRAPH
	{0xF8DD,	0x9DFE},	// CJK UNIFIED IDEOGRAPH
	{0xF8DE,	0x9E07},	// CJK UNIFIED IDEOGRAPH
	{0xF8DF,	0x9E03},	// CJK UNIFIED IDEOGRAPH
	{0xF8E0,	0x9E06},	// CJK UNIFIED IDEOGRAPH
	{0xF8E1,	0x9E05},	// CJK UNIFIED IDEOGRAPH
	{0xF8E2,	0x9E00},	// CJK UNIFIED IDEOGRAPH
	{0xF8E3,	0x9E01},	// CJK UNIFIED IDEOGRAPH
	{0xF8E4,	0x9E09},	// CJK UNIFIED IDEOGRAPH
	{0xF8E5,	0x9DFF},	// CJK UNIFIED IDEOGRAPH
	{0xF8E6,	0x9DFD},	// CJK UNIFIED IDEOGRAPH
	{0xF8E7,	0x9E04},	// CJK UNIFIED IDEOGRAPH
	{0xF8E8,	0x9EA0},	// CJK UNIFIED IDEOGRAPH
	{0xF8E9,	0x9F1E},	// CJK UNIFIED IDEOGRAPH
	{0xF8EA,	0x9F46},	// CJK UNIFIED IDEOGRAPH
	{0xF8EB,	0x9F74},	// CJK UNIFIED IDEOGRAPH
	{0xF8EC,	0x9F75},	// CJK UNIFIED IDEOGRAPH
	{0xF8ED,	0x9F76},	// CJK UNIFIED IDEOGRAPH
	{0xF8EE,	0x56D4},	// CJK UNIFIED IDEOGRAPH
	{0xF8EF,	0x652E},	// CJK UNIFIED IDEOGRAPH
	{0xF8F0,	0x65B8},	// CJK UNIFIED IDEOGRAPH
	{0xF8F1,	0x6B18},	// CJK UNIFIED IDEOGRAPH
	{0xF8F2,	0x6B19},	// CJK UNIFIED IDEOGRAPH
	{0xF8F3,	0x6B17},	// CJK UNIFIED IDEOGRAPH
	{0xF8F4,	0x6B1A},	// CJK UNIFIED IDEOGRAPH
	{0xF8F5,	0x7062},	// CJK UNIFIED IDEOGRAPH
	{0xF8F6,	0x7226},	// CJK UNIFIED IDEOGRAPH
	{0xF8F7,	0x72AA},	// CJK UNIFIED IDEOGRAPH
	{0xF8F8,	0x77D8},	// CJK UNIFIED IDEOGRAPH
	{0xF8F9,	0x77D9},	// CJK UNIFIED IDEOGRAPH
	{0xF8FA,	0x7939},	// CJK UNIFIED IDEOGRAPH
	{0xF8FB,	0x7C69},	// CJK UNIFIED IDEOGRAPH
	{0xF8FC,	0x7C6B},	// CJK UNIFIED IDEOGRAPH
	{0xF8FD,	0x7CF6},	// CJK UNIFIED IDEOGRAPH
	{0xF8FE,	0x7E9A},	// CJK UNIFIED IDEOGRAPH
	{0xF940,	0x7E98},	// CJK UNIFIED IDEOGRAPH
	{0xF941,	0x7E9B},	// CJK UNIFIED IDEOGRAPH
	{0xF942,	0x7E99},	// CJK UNIFIED IDEOGRAPH
	{0xF943,	0x81E0},	// CJK UNIFIED IDEOGRAPH
	{0xF944,	0x81E1},	// CJK UNIFIED IDEOGRAPH
	{0xF945,	0x8646},	// CJK UNIFIED IDEOGRAPH
	{0xF946,	0x8647},	// CJK UNIFIED IDEOGRAPH
	{0xF947,	0x8648},	// CJK UNIFIED IDEOGRAPH
	{0xF948,	0x8979},	// CJK UNIFIED IDEOGRAPH
	{0xF949,	0x897A},	// CJK UNIFIED IDEOGRAPH
	{0xF94A,	0x897C},	// CJK UNIFIED IDEOGRAPH
	{0xF94B,	0x897B},	// CJK UNIFIED IDEOGRAPH
	{0xF94C,	0x89FF},	// CJK UNIFIED IDEOGRAPH
	{0xF94D,	0x8B98},	// CJK UNIFIED IDEOGRAPH
	{0xF94E,	0x8B99},	// CJK UNIFIED IDEOGRAPH
	{0xF94F,	0x8EA5},	// CJK UNIFIED IDEOGRAPH
	{0xF950,	0x8EA4},	// CJK UNIFIED IDEOGRAPH
	{0xF951,	0x8EA3},	// CJK UNIFIED IDEOGRAPH
	{0xF952,	0x946E},	// CJK UNIFIED IDEOGRAPH
	{0xF953,	0x946D},	// CJK UNIFIED IDEOGRAPH
	{0xF954,	0x946F},	// CJK UNIFIED IDEOGRAPH
	{0xF955,	0x9471},	// CJK UNIFIED IDEOGRAPH
	{0xF956,	0x9473},	// CJK UNIFIED IDEOGRAPH
	{0xF957,	0x9749},	// CJK UNIFIED IDEOGRAPH
	{0xF958,	0x9872},	// CJK UNIFIED IDEOGRAPH
	{0xF959,	0x995F},	// CJK UNIFIED IDEOGRAPH
	{0xF95A,	0x9C68},	// CJK UNIFIED IDEOGRAPH
	{0xF95B,	0x9C6E},	// CJK UNIFIED IDEOGRAPH
	{0xF95C,	0x9C6D},	// CJK UNIFIED IDEOGRAPH
	{0xF95D,	0x9E0B},	// CJK UNIFIED IDEOGRAPH
	{0xF95E,	0x9E0D},	// CJK UNIFIED IDEOGRAPH
	{0xF95F,	0x9E10},	// CJK UNIFIED IDEOGRAPH
	{0xF960,	0x9E0F},	// CJK UNIFIED IDEOGRAPH
	{0xF961,	0x9E12},	// CJK UNIFIED IDEOGRAPH
	{0xF962,	0x9E11},	// CJK UNIFIED IDEOGRAPH
	{0xF963,	0x9EA1},	// CJK UNIFIED IDEOGRAPH
	{0xF964,	0x9EF5},	// CJK UNIFIED IDEOGRAPH
	{0xF965,	0x9F09},	// CJK UNIFIED IDEOGRAPH
	{0xF966,	0x9F47},	// CJK UNIFIED IDEOGRAPH
	{0xF967,	0x9F78},	// CJK UNIFIED IDEOGRAPH
	{0xF968,	0x9F7B},	// CJK UNIFIED IDEOGRAPH
	{0xF969,	0x9F7A},	// CJK UNIFIED IDEOGRAPH
	{0xF96A,	0x9F79},	// CJK UNIFIED IDEOGRAPH
	{0xF96B,	0x571E},	// CJK UNIFIED IDEOGRAPH
	{0xF96C,	0x7066},	// CJK UNIFIED IDEOGRAPH
	{0xF96D,	0x7C6F},	// CJK UNIFIED IDEOGRAPH
	{0xF96E,	0x883C},	// CJK UNIFIED IDEOGRAPH
	{0xF96F,	0x8DB2},	// CJK UNIFIED IDEOGRAPH
	{0xF970,	0x8EA6},	// CJK UNIFIED IDEOGRAPH
	{0xF971,	0x91C3},	// CJK UNIFIED IDEOGRAPH
	{0xF972,	0x9474},	// CJK UNIFIED IDEOGRAPH
	{0xF973,	0x9478},	// CJK UNIFIED IDEOGRAPH
	{0xF974,	0x9476},	// CJK UNIFIED IDEOGRAPH
	{0xF975,	0x9475},	// CJK UNIFIED IDEOGRAPH
	{0xF976,	0x9A60},	// CJK UNIFIED IDEOGRAPH
	{0xF977,	0x9C74},	// CJK UNIFIED IDEOGRAPH
	{0xF978,	0x9C73},	// CJK UNIFIED IDEOGRAPH
	{0xF979,	0x9C71},	// CJK UNIFIED IDEOGRAPH
	{0xF97A,	0x9C75},	// CJK UNIFIED IDEOGRAPH
	{0xF97B,	0x9E14},	// CJK UNIFIED IDEOGRAPH
	{0xF97C,	0x9E13},	// CJK UNIFIED IDEOGRAPH
	{0xF97D,	0x9EF6},	// CJK UNIFIED IDEOGRAPH
	{0xF97E,	0x9F0A},	// CJK UNIFIED IDEOGRAPH
	{0xF9A1,	0x9FA4},	// CJK UNIFIED IDEOGRAPH
	{0xF9A2,	0x7068},	// CJK UNIFIED IDEOGRAPH
	{0xF9A3,	0x7065},	// CJK UNIFIED IDEOGRAPH
	{0xF9A4,	0x7CF7},	// CJK UNIFIED IDEOGRAPH
	{0xF9A5,	0x866A},	// CJK UNIFIED IDEOGRAPH
	{0xF9A6,	0x883E},	// CJK UNIFIED IDEOGRAPH
	{0xF9A7,	0x883D},	// CJK UNIFIED IDEOGRAPH
	{0xF9A8,	0x883F},	// CJK UNIFIED IDEOGRAPH
	{0xF9A9,	0x8B9E},	// CJK UNIFIED IDEOGRAPH
	{0xF9AA,	0x8C9C},	// CJK UNIFIED IDEOGRAPH
	{0xF9AB,	0x8EA9},	// CJK UNIFIED IDEOGRAPH
	{0xF9AC,	0x8EC9},	// CJK UNIFIED IDEOGRAPH
	{0xF9AD,	0x974B},	// CJK UNIFIED IDEOGRAPH
	{0xF9AE,	0x9873},	// CJK UNIFIED IDEOGRAPH
	{0xF9AF,	0x9874},	// CJK UNIFIED IDEOGRAPH
	{0xF9B0,	0x98CC},	// CJK UNIFIED IDEOGRAPH
	{0xF9B1,	0x9961},	// CJK UNIFIED IDEOGRAPH
	{0xF9B2,	0x99AB},	// CJK UNIFIED IDEOGRAPH
	{0xF9B3,	0x9A64},	// CJK UNIFIED IDEOGRAPH
	{0xF9B4,	0x9A66},	// CJK UNIFIED IDEOGRAPH
	{0xF9B5,	0x9A67},	// CJK UNIFIED IDEOGRAPH
	{0xF9B6,	0x9B24},	// CJK UNIFIED IDEOGRAPH
	{0xF9B7,	0x9E15},	// CJK UNIFIED IDEOGRAPH
	{0xF9B8,	0x9E17},	// CJK UNIFIED IDEOGRAPH
	{0xF9B9,	0x9F48},	// CJK UNIFIED IDEOGRAPH
	{0xF9BA,	0x6207},	// CJK UNIFIED IDEOGRAPH
	{0xF9BB,	0x6B1E},	// CJK UNIFIED IDEOGRAPH
	{0xF9BC,	0x7227},	// CJK UNIFIED IDEOGRAPH
	{0xF9BD,	0x864C},	// CJK UNIFIED IDEOGRAPH
	{0xF9BE,	0x8EA8},	// CJK UNIFIED IDEOGRAPH
	{0xF9BF,	0x9482},	// CJK UNIFIED IDEOGRAPH
	{0xF9C0,	0x9480},	// CJK UNIFIED IDEOGRAPH
	{0xF9C1,	0x9481},	// CJK UNIFIED IDEOGRAPH
	{0xF9C2,	0x9A69},	// CJK UNIFIED IDEOGRAPH
	{0xF9C3,	0x9A68},	// CJK UNIFIED IDEOGRAPH
	{0xF9C4,	0x9B2E},	// CJK UNIFIED IDEOGRAPH
	{0xF9C5,	0x9E19},	// CJK UNIFIED IDEOGRAPH
	{0xF9C6,	0x7229},	// CJK UNIFIED IDEOGRAPH
	{0xF9C7,	0x864B},	// CJK UNIFIED IDEOGRAPH
	{0xF9C8,	0x8B9F},	// CJK UNIFIED IDEOGRAPH
	{0xF9C9,	0x9483},	// CJK UNIFIED IDEOGRAPH
	{0xF9CA,	0x9C79},	// CJK UNIFIED IDEOGRAPH
	{0xF9CB,	0x9EB7},	// CJK UNIFIED IDEOGRAPH
	{0xF9CC,	0x7675},	// CJK UNIFIED IDEOGRAPH
	{0xF9CD,	0x9A6B},	// CJK UNIFIED IDEOGRAPH
	{0xF9CE,	0x9C7A},	// CJK UNIFIED IDEOGRAPH
	{0xF9CF,	0x9E1D},	// CJK UNIFIED IDEOGRAPH
	{0xF9D0,	0x7069},	// CJK UNIFIED IDEOGRAPH
	{0xF9D1,	0x706A},	// CJK UNIFIED IDEOGRAPH
	{0xF9D2,	0x9EA4},	// CJK UNIFIED IDEOGRAPH
	{0xF9D3,	0x9F7E},	// CJK UNIFIED IDEOGRAPH
	{0xF9D4,	0x9F49},	// CJK UNIFIED IDEOGRAPH
	{0xF9D5,	0x9F98},	// CJK UNIFIED IDEOGRAPH
	{0xF9D6,	0x7881},	// CJK UNIFIED IDEOGRAPH
	{0xF9D7,	0x92B9},	// CJK UNIFIED IDEOGRAPH
	{0xF9D8,	0x88CF},	// CJK UNIFIED IDEOGRAPH
	{0xF9D9,	0x58BB},	// CJK UNIFIED IDEOGRAPH
	{0xF9DA,	0x6052},	// CJK UNIFIED IDEOGRAPH
	{0xF9DB,	0x7CA7},	// CJK UNIFIED IDEOGRAPH
	{0xF9DC,	0x5AFA},	// CJK UNIFIED IDEOGRAPH
	{0xF9DD,	0x2554},	// BOX DRAWINGS DOUBLE DOWN AND RIGHT
	{0xF9DE,	0x2566},	// BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL
	{0xF9DF,	0x2557},	// BOX DRAWINGS DOUBLE DOWN AND LEFT
	{0xF9E0,	0x2560},	// BOX DRAWINGS DOUBLE VERTICAL AND RIGHT
	{0xF9E1,	0x256C},	// BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL
	{0xF9E2,	0x2563},	// BOX DRAWINGS DOUBLE VERTICAL AND LEFT
	{0xF9E3,	0x255A},	// BOX DRAWINGS DOUBLE UP AND RIGHT
	{0xF9E4,	0x2569},	// BOX DRAWINGS DOUBLE UP AND HORIZONTAL
	{0xF9E5,	0x255D},	// BOX DRAWINGS DOUBLE UP AND LEFT
	{0xF9E6,	0x2552},	// BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE
	{0xF9E7,	0x2564},	// BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE
	{0xF9E8,	0x2555},	// BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE
	{0xF9E9,	0x255E},	// BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE
	{0xF9EA,	0x256A},	// BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE
	{0xF9EB,	0x2561},	// BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE
	{0xF9EC,	0x2558},	// BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE
	{0xF9ED,	0x2567},	// BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE
	{0xF9EE,	0x255B},	// BOX DRAWINGS UP SINGLE AND LEFT DOUBLE
	{0xF9EF,	0x2553},	// BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE
	{0xF9F0,	0x2565},	// BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE
	{0xF9F1,	0x2556},	// BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE
	{0xF9F2,	0x255F},	// BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE
	{0xF9F3,	0x256B},	// BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE
	{0xF9F4,	0x2562},	// BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE
	{0xF9F5,	0x2559},	// BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE
	{0xF9F6,	0x2568},	// BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE
	{0xF9F7,	0x255C},	// BOX DRAWINGS UP DOUBLE AND LEFT SINGLE
	{0xF9F8,	0x2551},	// BOX DRAWINGS DOUBLE VERTICAL
	{0xF9F9,	0x2550},	// BOX DRAWINGS DOUBLE HORIZONTAL
	{0xF9FA,	0x256D},	// BOX DRAWINGS LIGHT ARC DOWN AND RIGHT
	{0xF9FB,	0x256E},	// BOX DRAWINGS LIGHT ARC DOWN AND LEFT
	{0xF9FC,	0x2570},	// BOX DRAWINGS LIGHT ARC UP AND RIGHT
	{0xF9FD,	0x256F},	// BOX DRAWINGS LIGHT ARC UP AND LEFT
	{0xF9FE,	0x2593}	// DARK SHADE
};

CharSetCvt::MapEnt
CharSetCvtUTF8toCp950::UCS2toCp950[] = {
	{0x00A7,	0xA1B1},	// SECTION SIGN
	{0x00AF,	0xA1C2},	// MACRON
	{0x00B0,	0xA258},	// DEGREE SIGN
	{0x00B1,	0xA1D3},	// PLUS-MINUS SIGN
	{0x00B7,	0xA150},	// MIDDLE DOT
	{0x00D7,	0xA1D1},	// MULTIPLICATION SIGN
	{0x00F7,	0xA1D2},	// DIVISION SIGN
	{0x02C7,	0xA3BE},	// CARON
	{0x02C9,	0xA3BC},	// MODIFIER LETTER MACRON
	{0x02CA,	0xA3BD},	// MODIFIER LETTER ACUTE ACCENT
	{0x02CB,	0xA3BF},	// MODIFIER LETTER GRAVE ACCENT
	{0x02CD,	0xA1C5},	// MODIFIER LETTER LOW MACRON
	{0x02D9,	0xA3BB},	// DOT ABOVE
	{0x0391,	0xA344},	// GREEK CAPITAL LETTER ALPHA
	{0x0392,	0xA345},	// GREEK CAPITAL LETTER BETA
	{0x0393,	0xA346},	// GREEK CAPITAL LETTER GAMMA
	{0x0394,	0xA347},	// GREEK CAPITAL LETTER DELTA
	{0x0395,	0xA348},	// GREEK CAPITAL LETTER EPSILON
	{0x0396,	0xA349},	// GREEK CAPITAL LETTER ZETA
	{0x0397,	0xA34A},	// GREEK CAPITAL LETTER ETA
	{0x0398,	0xA34B},	// GREEK CAPITAL LETTER THETA
	{0x0399,	0xA34C},	// GREEK CAPITAL LETTER IOTA
	{0x039A,	0xA34D},	// GREEK CAPITAL LETTER KAPPA
	{0x039B,	0xA34E},	// GREEK CAPITAL LETTER LAMDA
	{0x039C,	0xA34F},	// GREEK CAPITAL LETTER MU
	{0x039D,	0xA350},	// GREEK CAPITAL LETTER NU
	{0x039E,	0xA351},	// GREEK CAPITAL LETTER XI
	{0x039F,	0xA352},	// GREEK CAPITAL LETTER OMICRON
	{0x03A0,	0xA353},	// GREEK CAPITAL LETTER PI
	{0x03A1,	0xA354},	// GREEK CAPITAL LETTER RHO
	{0x03A3,	0xA355},	// GREEK CAPITAL LETTER SIGMA
	{0x03A4,	0xA356},	// GREEK CAPITAL LETTER TAU
	{0x03A5,	0xA357},	// GREEK CAPITAL LETTER UPSILON
	{0x03A6,	0xA358},	// GREEK CAPITAL LETTER PHI
	{0x03A7,	0xA359},	// GREEK CAPITAL LETTER CHI
	{0x03A8,	0xA35A},	// GREEK CAPITAL LETTER PSI
	{0x03A9,	0xA35B},	// GREEK CAPITAL LETTER OMEGA
	{0x03B1,	0xA35C},	// GREEK SMALL LETTER ALPHA
	{0x03B2,	0xA35D},	// GREEK SMALL LETTER BETA
	{0x03B3,	0xA35E},	// GREEK SMALL LETTER GAMMA
	{0x03B4,	0xA35F},	// GREEK SMALL LETTER DELTA
	{0x03B5,	0xA360},	// GREEK SMALL LETTER EPSILON
	{0x03B6,	0xA361},	// GREEK SMALL LETTER ZETA
	{0x03B7,	0xA362},	// GREEK SMALL LETTER ETA
	{0x03B8,	0xA363},	// GREEK SMALL LETTER THETA
	{0x03B9,	0xA364},	// GREEK SMALL LETTER IOTA
	{0x03BA,	0xA365},	// GREEK SMALL LETTER KAPPA
	{0x03BB,	0xA366},	// GREEK SMALL LETTER LAMDA
	{0x03BC,	0xA367},	// GREEK SMALL LETTER MU
	{0x03BD,	0xA368},	// GREEK SMALL LETTER NU
	{0x03BE,	0xA369},	// GREEK SMALL LETTER XI
	{0x03BF,	0xA36A},	// GREEK SMALL LETTER OMICRON
	{0x03C0,	0xA36B},	// GREEK SMALL LETTER PI
	{0x03C1,	0xA36C},	// GREEK SMALL LETTER RHO
	{0x03C3,	0xA36D},	// GREEK SMALL LETTER SIGMA
	{0x03C4,	0xA36E},	// GREEK SMALL LETTER TAU
	{0x03C5,	0xA36F},	// GREEK SMALL LETTER UPSILON
	{0x03C6,	0xA370},	// GREEK SMALL LETTER PHI
	{0x03C7,	0xA371},	// GREEK SMALL LETTER CHI
	{0x03C8,	0xA372},	// GREEK SMALL LETTER PSI
	{0x03C9,	0xA373},	// GREEK SMALL LETTER OMEGA
	{0x2013,	0xA156},	// EN DASH
	{0x2014,	0xA158},	// EM DASH
	{0x2018,	0xA1A5},	// LEFT SINGLE QUOTATION MARK
	{0x2019,	0xA1A6},	// RIGHT SINGLE QUOTATION MARK
	{0x201C,	0xA1A7},	// LEFT DOUBLE QUOTATION MARK
	{0x201D,	0xA1A8},	// RIGHT DOUBLE QUOTATION MARK
	{0x2025,	0xA14C},	// TWO DOT LEADER
	{0x2026,	0xA14B},	// HORIZONTAL ELLIPSIS
	{0x2027,	0xA145},	// HYPHENATION POINT
	{0x2032,	0xA1AC},	// PRIME
	{0x2035,	0xA1AB},	// REVERSED PRIME
	{0x203B,	0xA1B0},	// REFERENCE MARK
	{0x20AC,	0xA3E1},	// EURO SIGN
	{0x2103,	0xA24A},	// DEGREE CELSIUS
	{0x2105,	0xA1C1},	// CARE OF
	{0x2109,	0xA24B},	// DEGREE FAHRENHEIT
	{0x2160,	0xA2B9},	// ROMAN NUMERAL ONE
	{0x2161,	0xA2BA},	// ROMAN NUMERAL TWO
	{0x2162,	0xA2BB},	// ROMAN NUMERAL THREE
	{0x2163,	0xA2BC},	// ROMAN NUMERAL FOUR
	{0x2164,	0xA2BD},	// ROMAN NUMERAL FIVE
	{0x2165,	0xA2BE},	// ROMAN NUMERAL SIX
	{0x2166,	0xA2BF},	// ROMAN NUMERAL SEVEN
	{0x2167,	0xA2C0},	// ROMAN NUMERAL EIGHT
	{0x2168,	0xA2C1},	// ROMAN NUMERAL NINE
	{0x2169,	0xA2C2},	// ROMAN NUMERAL TEN
	{0x2190,	0xA1F6},	// LEFTWARDS ARROW
	{0x2191,	0xA1F4},	// UPWARDS ARROW
	{0x2192,	0xA1F7},	// RIGHTWARDS ARROW
	{0x2193,	0xA1F5},	// DOWNWARDS ARROW
	{0x2196,	0xA1F8},	// NORTH WEST ARROW
	{0x2197,	0xA1F9},	// NORTH EAST ARROW
	{0x2198,	0xA1FB},	// SOUTH EAST ARROW
	{0x2199,	0xA1FA},	// SOUTH WEST ARROW
	{0x2215,	0xA241},	// DIVISION SLASH
	{0x221A,	0xA1D4},	// SQUARE ROOT
	{0x221E,	0xA1DB},	// INFINITY
	{0x221F,	0xA1E8},	// RIGHT ANGLE
	{0x2220,	0xA1E7},	// ANGLE
	{0x2223,	0xA1FD},	// DIVIDES
	{0x2225,	0xA1FC},	// PARALLEL TO
	{0x2229,	0xA1E4},	// INTERSECTION
	{0x222A,	0xA1E5},	// UNION
	{0x222B,	0xA1EC},	// INTEGRAL
	{0x222E,	0xA1ED},	// CONTOUR INTEGRAL
	{0x2234,	0xA1EF},	// THEREFORE
	{0x2235,	0xA1EE},	// BECAUSE
	{0x2252,	0xA1DC},	// APPROXIMATELY EQUAL TO OR THE IMAGE OF
	{0x2260,	0xA1DA},	// NOT EQUAL TO
	{0x2261,	0xA1DD},	// IDENTICAL TO
	{0x2266,	0xA1D8},	// LESS-THAN OVER EQUAL TO
	{0x2267,	0xA1D9},	// GREATER-THAN OVER EQUAL TO
	{0x2295,	0xA1F2},	// CIRCLED PLUS
	{0x2299,	0xA1F3},	// CIRCLED DOT OPERATOR
	{0x22A5,	0xA1E6},	// UP TACK
	{0x22BF,	0xA1E9},	// RIGHT TRIANGLE
	{0x2500,	0xA277},	// BOX DRAWINGS LIGHT HORIZONTAL
	{0x2502,	0xA278},	// BOX DRAWINGS LIGHT VERTICAL
	{0x250C,	0xA27A},	// BOX DRAWINGS LIGHT DOWN AND RIGHT
	{0x2510,	0xA27B},	// BOX DRAWINGS LIGHT DOWN AND LEFT
	{0x2514,	0xA27C},	// BOX DRAWINGS LIGHT UP AND RIGHT
	{0x2518,	0xA27D},	// BOX DRAWINGS LIGHT UP AND LEFT
	{0x251C,	0xA275},	// BOX DRAWINGS LIGHT VERTICAL AND RIGHT
	{0x2524,	0xA274},	// BOX DRAWINGS LIGHT VERTICAL AND LEFT
	{0x252C,	0xA273},	// BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
	{0x2534,	0xA272},	// BOX DRAWINGS LIGHT UP AND HORIZONTAL
	{0x253C,	0xA271},	// BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
	{0x2550,	0xF9F9},	// BOX DRAWINGS DOUBLE HORIZONTAL
	{0x2551,	0xF9F8},	// BOX DRAWINGS DOUBLE VERTICAL
	{0x2552,	0xF9E6},	// BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE
	{0x2553,	0xF9EF},	// BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE
	{0x2554,	0xF9DD},	// BOX DRAWINGS DOUBLE DOWN AND RIGHT
	{0x2555,	0xF9E8},	// BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE
	{0x2556,	0xF9F1},	// BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE
	{0x2557,	0xF9DF},	// BOX DRAWINGS DOUBLE DOWN AND LEFT
	{0x2558,	0xF9EC},	// BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE
	{0x2559,	0xF9F5},	// BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE
	{0x255A,	0xF9E3},	// BOX DRAWINGS DOUBLE UP AND RIGHT
	{0x255B,	0xF9EE},	// BOX DRAWINGS UP SINGLE AND LEFT DOUBLE
	{0x255C,	0xF9F7},	// BOX DRAWINGS UP DOUBLE AND LEFT SINGLE
	{0x255D,	0xF9E5},	// BOX DRAWINGS DOUBLE UP AND LEFT
	{0x255E,	0xF9E9},	// BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE
	{0x255F,	0xF9F2},	// BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE
	{0x2560,	0xF9E0},	// BOX DRAWINGS DOUBLE VERTICAL AND RIGHT
	{0x2561,	0xF9EB},	// BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE
	{0x2562,	0xF9F4},	// BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE
	{0x2563,	0xF9E2},	// BOX DRAWINGS DOUBLE VERTICAL AND LEFT
	{0x2564,	0xF9E7},	// BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE
	{0x2565,	0xF9F0},	// BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE
	{0x2566,	0xF9DE},	// BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL
	{0x2567,	0xF9ED},	// BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE
	{0x2568,	0xF9F6},	// BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE
	{0x2569,	0xF9E4},	// BOX DRAWINGS DOUBLE UP AND HORIZONTAL
	{0x256A,	0xF9EA},	// BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE
	{0x256B,	0xF9F3},	// BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE
	{0x256C,	0xF9E1},	// BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL
	{0x256D,	0xF9FA},	// BOX DRAWINGS LIGHT ARC DOWN AND RIGHT
	{0x256E,	0xF9FB},	// BOX DRAWINGS LIGHT ARC DOWN AND LEFT
	{0x256F,	0xF9FD},	// BOX DRAWINGS LIGHT ARC UP AND LEFT
	{0x2570,	0xF9FC},	// BOX DRAWINGS LIGHT ARC UP AND RIGHT
	{0x2571,	0xA2AC},	// BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT
	{0x2572,	0xA2AD},	// BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT
	{0x2573,	0xA2AE},	// BOX DRAWINGS LIGHT DIAGONAL CROSS
	{0x2574,	0xA15A},	// BOX DRAWINGS LIGHT LEFT
	{0x2581,	0xA262},	// LOWER ONE EIGHTH BLOCK
	{0x2582,	0xA263},	// LOWER ONE QUARTER BLOCK
	{0x2583,	0xA264},	// LOWER THREE EIGHTHS BLOCK
	{0x2584,	0xA265},	// LOWER HALF BLOCK
	{0x2585,	0xA266},	// LOWER FIVE EIGHTHS BLOCK
	{0x2586,	0xA267},	// LOWER THREE QUARTERS BLOCK
	{0x2587,	0xA268},	// LOWER SEVEN EIGHTHS BLOCK
	{0x2588,	0xA269},	// FULL BLOCK
	{0x2589,	0xA270},	// LEFT SEVEN EIGHTHS BLOCK
	{0x258A,	0xA26F},	// LEFT THREE QUARTERS BLOCK
	{0x258B,	0xA26E},	// LEFT FIVE EIGHTHS BLOCK
	{0x258C,	0xA26D},	// LEFT HALF BLOCK
	{0x258D,	0xA26C},	// LEFT THREE EIGHTHS BLOCK
	{0x258E,	0xA26B},	// LEFT ONE QUARTER BLOCK
	{0x258F,	0xA26A},	// LEFT ONE EIGHTH BLOCK
	{0x2593,	0xF9FE},	// DARK SHADE
	{0x2594,	0xA276},	// UPPER ONE EIGHTH BLOCK
	{0x2595,	0xA279},	// RIGHT ONE EIGHTH BLOCK
	{0x25A0,	0xA1BD},	// BLACK SQUARE
	{0x25A1,	0xA1BC},	// WHITE SQUARE
	{0x25B2,	0xA1B6},	// BLACK UP-POINTING TRIANGLE
	{0x25B3,	0xA1B5},	// WHITE UP-POINTING TRIANGLE
	{0x25BC,	0xA1BF},	// BLACK DOWN-POINTING TRIANGLE
	{0x25BD,	0xA1BE},	// WHITE DOWN-POINTING TRIANGLE
	{0x25C6,	0xA1BB},	// BLACK DIAMOND
	{0x25C7,	0xA1BA},	// WHITE DIAMOND
	{0x25CB,	0xA1B3},	// WHITE CIRCLE
	{0x25CE,	0xA1B7},	// BULLSEYE
	{0x25CF,	0xA1B4},	// BLACK CIRCLE
	{0x25E2,	0xA2A8},	// BLACK LOWER RIGHT TRIANGLE
	{0x25E3,	0xA2A9},	// BLACK LOWER LEFT TRIANGLE
	{0x25E4,	0xA2AB},	// BLACK UPPER LEFT TRIANGLE
	{0x25E5,	0xA2AA},	// BLACK UPPER RIGHT TRIANGLE
	{0x2605,	0xA1B9},	// BLACK STAR
	{0x2606,	0xA1B8},	// WHITE STAR
	{0x2640,	0xA1F0},	// FEMALE SIGN
	{0x2642,	0xA1F1},	// MALE SIGN
	{0x3000,	0xA140},	// IDEOGRAPHIC SPACE
	{0x3001,	0xA142},	// IDEOGRAPHIC COMMA
	{0x3002,	0xA143},	// IDEOGRAPHIC FULL STOP
	{0x3003,	0xA1B2},	// DITTO MARK
	{0x3008,	0xA171},	// LEFT ANGLE BRACKET
	{0x3009,	0xA172},	// RIGHT ANGLE BRACKET
	{0x300A,	0xA16D},	// LEFT DOUBLE ANGLE BRACKET
	{0x300B,	0xA16E},	// RIGHT DOUBLE ANGLE BRACKET
	{0x300C,	0xA175},	// LEFT CORNER BRACKET
	{0x300D,	0xA176},	// RIGHT CORNER BRACKET
	{0x300E,	0xA179},	// LEFT WHITE CORNER BRACKET
	{0x300F,	0xA17A},	// RIGHT WHITE CORNER BRACKET
	{0x3010,	0xA169},	// LEFT BLACK LENTICULAR BRACKET
	{0x3011,	0xA16A},	// RIGHT BLACK LENTICULAR BRACKET
	{0x3012,	0xA245},	// POSTAL MARK
	{0x3014,	0xA165},	// LEFT TORTOISE SHELL BRACKET
	{0x3015,	0xA166},	// RIGHT TORTOISE SHELL BRACKET
	{0x301D,	0xA1A9},	// REVERSED DOUBLE PRIME QUOTATION MARK
	{0x301E,	0xA1AA},	// DOUBLE PRIME QUOTATION MARK
	{0x3021,	0xA2C3},	// HANGZHOU NUMERAL ONE
	{0x3022,	0xA2C4},	// HANGZHOU NUMERAL TWO
	{0x3023,	0xA2C5},	// HANGZHOU NUMERAL THREE
	{0x3024,	0xA2C6},	// HANGZHOU NUMERAL FOUR
	{0x3025,	0xA2C7},	// HANGZHOU NUMERAL FIVE
	{0x3026,	0xA2C8},	// HANGZHOU NUMERAL SIX
	{0x3027,	0xA2C9},	// HANGZHOU NUMERAL SEVEN
	{0x3028,	0xA2CA},	// HANGZHOU NUMERAL EIGHT
	{0x3029,	0xA2CB},	// HANGZHOU NUMERAL NINE
	{0x3105,	0xA374},	// BOPOMOFO LETTER B
	{0x3106,	0xA375},	// BOPOMOFO LETTER P
	{0x3107,	0xA376},	// BOPOMOFO LETTER M
	{0x3108,	0xA377},	// BOPOMOFO LETTER F
	{0x3109,	0xA378},	// BOPOMOFO LETTER D
	{0x310A,	0xA379},	// BOPOMOFO LETTER T
	{0x310B,	0xA37A},	// BOPOMOFO LETTER N
	{0x310C,	0xA37B},	// BOPOMOFO LETTER L
	{0x310D,	0xA37C},	// BOPOMOFO LETTER G
	{0x310E,	0xA37D},	// BOPOMOFO LETTER K
	{0x310F,	0xA37E},	// BOPOMOFO LETTER H
	{0x3110,	0xA3A1},	// BOPOMOFO LETTER J
	{0x3111,	0xA3A2},	// BOPOMOFO LETTER Q
	{0x3112,	0xA3A3},	// BOPOMOFO LETTER X
	{0x3113,	0xA3A4},	// BOPOMOFO LETTER ZH
	{0x3114,	0xA3A5},	// BOPOMOFO LETTER CH
	{0x3115,	0xA3A6},	// BOPOMOFO LETTER SH
	{0x3116,	0xA3A7},	// BOPOMOFO LETTER R
	{0x3117,	0xA3A8},	// BOPOMOFO LETTER Z
	{0x3118,	0xA3A9},	// BOPOMOFO LETTER C
	{0x3119,	0xA3AA},	// BOPOMOFO LETTER S
	{0x311A,	0xA3AB},	// BOPOMOFO LETTER A
	{0x311B,	0xA3AC},	// BOPOMOFO LETTER O
	{0x311C,	0xA3AD},	// BOPOMOFO LETTER E
	{0x311D,	0xA3AE},	// BOPOMOFO LETTER EH
	{0x311E,	0xA3AF},	// BOPOMOFO LETTER AI
	{0x311F,	0xA3B0},	// BOPOMOFO LETTER EI
	{0x3120,	0xA3B1},	// BOPOMOFO LETTER AU
	{0x3121,	0xA3B2},	// BOPOMOFO LETTER OU
	{0x3122,	0xA3B3},	// BOPOMOFO LETTER AN
	{0x3123,	0xA3B4},	// BOPOMOFO LETTER EN
	{0x3124,	0xA3B5},	// BOPOMOFO LETTER ANG
	{0x3125,	0xA3B6},	// BOPOMOFO LETTER ENG
	{0x3126,	0xA3B7},	// BOPOMOFO LETTER ER
	{0x3127,	0xA3B8},	// BOPOMOFO LETTER I
	{0x3128,	0xA3B9},	// BOPOMOFO LETTER U
	{0x3129,	0xA3BA},	// BOPOMOFO LETTER IU
	{0x32A3,	0xA1C0},	// CIRCLED IDEOGRAPH CORRECT
	{0x338E,	0xA255},	// SQUARE MG
	{0x338F,	0xA256},	// SQUARE KG
	{0x339C,	0xA250},	// SQUARE MM
	{0x339D,	0xA251},	// SQUARE CM
	{0x339E,	0xA252},	// SQUARE KM
	{0x33A1,	0xA254},	// SQUARE M SQUARED
	{0x33C4,	0xA257},	// SQUARE CC
	{0x33CE,	0xA253},	// SQUARE KM CAPITAL
	{0x33D1,	0xA1EB},	// SQUARE LN
	{0x33D2,	0xA1EA},	// SQUARE LOG
	{0x33D5,	0xA24F},	// SQUARE MIL
	{0x4E00,	0xA440},	// CJK UNIFIED IDEOGRAPH
	{0x4E01,	0xA442},	// CJK UNIFIED IDEOGRAPH
	{0x4E03,	0xA443},	// CJK UNIFIED IDEOGRAPH
	{0x4E07,	0xC945},	// CJK UNIFIED IDEOGRAPH
	{0x4E08,	0xA456},	// CJK UNIFIED IDEOGRAPH
	{0x4E09,	0xA454},	// CJK UNIFIED IDEOGRAPH
	{0x4E0A,	0xA457},	// CJK UNIFIED IDEOGRAPH
	{0x4E0B,	0xA455},	// CJK UNIFIED IDEOGRAPH
	{0x4E0C,	0xC946},	// CJK UNIFIED IDEOGRAPH
	{0x4E0D,	0xA4A3},	// CJK UNIFIED IDEOGRAPH
	{0x4E0E,	0xC94F},	// CJK UNIFIED IDEOGRAPH
	{0x4E0F,	0xC94D},	// CJK UNIFIED IDEOGRAPH
	{0x4E10,	0xA4A2},	// CJK UNIFIED IDEOGRAPH
	{0x4E11,	0xA4A1},	// CJK UNIFIED IDEOGRAPH
	{0x4E14,	0xA542},	// CJK UNIFIED IDEOGRAPH
	{0x4E15,	0xA541},	// CJK UNIFIED IDEOGRAPH
	{0x4E16,	0xA540},	// CJK UNIFIED IDEOGRAPH
	{0x4E18,	0xA543},	// CJK UNIFIED IDEOGRAPH
	{0x4E19,	0xA4FE},	// CJK UNIFIED IDEOGRAPH
	{0x4E1E,	0xA5E0},	// CJK UNIFIED IDEOGRAPH
	{0x4E1F,	0xA5E1},	// CJK UNIFIED IDEOGRAPH
	{0x4E26,	0xA8C3},	// CJK UNIFIED IDEOGRAPH
	{0x4E2B,	0xA458},	// CJK UNIFIED IDEOGRAPH
	{0x4E2D,	0xA4A4},	// CJK UNIFIED IDEOGRAPH
	{0x4E2E,	0xC950},	// CJK UNIFIED IDEOGRAPH
	{0x4E30,	0xA4A5},	// CJK UNIFIED IDEOGRAPH
	{0x4E31,	0xC963},	// CJK UNIFIED IDEOGRAPH
	{0x4E32,	0xA6EA},	// CJK UNIFIED IDEOGRAPH
	{0x4E33,	0xCBB1},	// CJK UNIFIED IDEOGRAPH
	{0x4E38,	0xA459},	// CJK UNIFIED IDEOGRAPH
	{0x4E39,	0xA4A6},	// CJK UNIFIED IDEOGRAPH
	{0x4E3B,	0xA544},	// CJK UNIFIED IDEOGRAPH
	{0x4E3C,	0xC964},	// CJK UNIFIED IDEOGRAPH
	{0x4E42,	0xC940},	// CJK UNIFIED IDEOGRAPH
	{0x4E43,	0xA444},	// CJK UNIFIED IDEOGRAPH
	{0x4E45,	0xA45B},	// CJK UNIFIED IDEOGRAPH
	{0x4E47,	0xC947},	// CJK UNIFIED IDEOGRAPH
	{0x4E48,	0xA45C},	// CJK UNIFIED IDEOGRAPH
	{0x4E4B,	0xA4A7},	// CJK UNIFIED IDEOGRAPH
	{0x4E4D,	0xA545},	// CJK UNIFIED IDEOGRAPH
	{0x4E4E,	0xA547},	// CJK UNIFIED IDEOGRAPH
	{0x4E4F,	0xA546},	// CJK UNIFIED IDEOGRAPH
	{0x4E52,	0xA5E2},	// CJK UNIFIED IDEOGRAPH
	{0x4E53,	0xA5E3},	// CJK UNIFIED IDEOGRAPH
	{0x4E56,	0xA8C4},	// CJK UNIFIED IDEOGRAPH
	{0x4E58,	0xADBC},	// CJK UNIFIED IDEOGRAPH
	{0x4E59,	0xA441},	// CJK UNIFIED IDEOGRAPH
	{0x4E5C,	0xC941},	// CJK UNIFIED IDEOGRAPH
	{0x4E5D,	0xA445},	// CJK UNIFIED IDEOGRAPH
	{0x4E5E,	0xA45E},	// CJK UNIFIED IDEOGRAPH
	{0x4E5F,	0xA45D},	// CJK UNIFIED IDEOGRAPH
	{0x4E69,	0xA5E4},	// CJK UNIFIED IDEOGRAPH
	{0x4E73,	0xA8C5},	// CJK UNIFIED IDEOGRAPH
	{0x4E7E,	0xB0AE},	// CJK UNIFIED IDEOGRAPH
	{0x4E7F,	0xD44B},	// CJK UNIFIED IDEOGRAPH
	{0x4E82,	0xB6C3},	// CJK UNIFIED IDEOGRAPH
	{0x4E83,	0xDCB1},	// CJK UNIFIED IDEOGRAPH
	{0x4E84,	0xDCB2},	// CJK UNIFIED IDEOGRAPH
	{0x4E86,	0xA446},	// CJK UNIFIED IDEOGRAPH
	{0x4E88,	0xA4A9},	// CJK UNIFIED IDEOGRAPH
	{0x4E8B,	0xA8C6},	// CJK UNIFIED IDEOGRAPH
	{0x4E8C,	0xA447},	// CJK UNIFIED IDEOGRAPH
	{0x4E8D,	0xC948},	// CJK UNIFIED IDEOGRAPH
	{0x4E8E,	0xA45F},	// CJK UNIFIED IDEOGRAPH
	{0x4E91,	0xA4AA},	// CJK UNIFIED IDEOGRAPH
	{0x4E92,	0xA4AC},	// CJK UNIFIED IDEOGRAPH
	{0x4E93,	0xC951},	// CJK UNIFIED IDEOGRAPH
	{0x4E94,	0xA4AD},	// CJK UNIFIED IDEOGRAPH
	{0x4E95,	0xA4AB},	// CJK UNIFIED IDEOGRAPH
	{0x4E99,	0xA5E5},	// CJK UNIFIED IDEOGRAPH
	{0x4E9B,	0xA8C7},	// CJK UNIFIED IDEOGRAPH
	{0x4E9E,	0xA8C8},	// CJK UNIFIED IDEOGRAPH
	{0x4E9F,	0xAB45},	// CJK UNIFIED IDEOGRAPH
	{0x4EA1,	0xA460},	// CJK UNIFIED IDEOGRAPH
	{0x4EA2,	0xA4AE},	// CJK UNIFIED IDEOGRAPH
	{0x4EA4,	0xA5E6},	// CJK UNIFIED IDEOGRAPH
	{0x4EA5,	0xA5E8},	// CJK UNIFIED IDEOGRAPH
	{0x4EA6,	0xA5E7},	// CJK UNIFIED IDEOGRAPH
	{0x4EA8,	0xA6EB},	// CJK UNIFIED IDEOGRAPH
	{0x4EAB,	0xA8C9},	// CJK UNIFIED IDEOGRAPH
	{0x4EAC,	0xA8CA},	// CJK UNIFIED IDEOGRAPH
	{0x4EAD,	0xAB46},	// CJK UNIFIED IDEOGRAPH
	{0x4EAE,	0xAB47},	// CJK UNIFIED IDEOGRAPH
	{0x4EB3,	0xADBD},	// CJK UNIFIED IDEOGRAPH
	{0x4EB6,	0xDCB3},	// CJK UNIFIED IDEOGRAPH
	{0x4EB9,	0xF6D6},	// CJK UNIFIED IDEOGRAPH
	{0x4EBA,	0xA448},	// CJK UNIFIED IDEOGRAPH
	{0x4EC0,	0xA4B0},	// CJK UNIFIED IDEOGRAPH
	{0x4EC1,	0xA4AF},	// CJK UNIFIED IDEOGRAPH
	{0x4EC2,	0xC952},	// CJK UNIFIED IDEOGRAPH
	{0x4EC3,	0xA4B1},	// CJK UNIFIED IDEOGRAPH
	{0x4EC4,	0xA4B7},	// CJK UNIFIED IDEOGRAPH
	{0x4EC6,	0xA4B2},	// CJK UNIFIED IDEOGRAPH
	{0x4EC7,	0xA4B3},	// CJK UNIFIED IDEOGRAPH
	{0x4EC8,	0xC954},	// CJK UNIFIED IDEOGRAPH
	{0x4EC9,	0xC953},	// CJK UNIFIED IDEOGRAPH
	{0x4ECA,	0xA4B5},	// CJK UNIFIED IDEOGRAPH
	{0x4ECB,	0xA4B6},	// CJK UNIFIED IDEOGRAPH
	{0x4ECD,	0xA4B4},	// CJK UNIFIED IDEOGRAPH
	{0x4ED4,	0xA54A},	// CJK UNIFIED IDEOGRAPH
	{0x4ED5,	0xA54B},	// CJK UNIFIED IDEOGRAPH
	{0x4ED6,	0xA54C},	// CJK UNIFIED IDEOGRAPH
	{0x4ED7,	0xA54D},	// CJK UNIFIED IDEOGRAPH
	{0x4ED8,	0xA549},	// CJK UNIFIED IDEOGRAPH
	{0x4ED9,	0xA550},	// CJK UNIFIED IDEOGRAPH
	{0x4EDA,	0xC96A},	// CJK UNIFIED IDEOGRAPH
	{0x4EDC,	0xC966},	// CJK UNIFIED IDEOGRAPH
	{0x4EDD,	0xC969},	// CJK UNIFIED IDEOGRAPH
	{0x4EDE,	0xA551},	// CJK UNIFIED IDEOGRAPH
	{0x4EDF,	0xA561},	// CJK UNIFIED IDEOGRAPH
	{0x4EE1,	0xC968},	// CJK UNIFIED IDEOGRAPH
	{0x4EE3,	0xA54E},	// CJK UNIFIED IDEOGRAPH
	{0x4EE4,	0xA54F},	// CJK UNIFIED IDEOGRAPH
	{0x4EE5,	0xA548},	// CJK UNIFIED IDEOGRAPH
	{0x4EE8,	0xC965},	// CJK UNIFIED IDEOGRAPH
	{0x4EE9,	0xC967},	// CJK UNIFIED IDEOGRAPH
	{0x4EF0,	0xA5F5},	// CJK UNIFIED IDEOGRAPH
	{0x4EF1,	0xC9B0},	// CJK UNIFIED IDEOGRAPH
	{0x4EF2,	0xA5F2},	// CJK UNIFIED IDEOGRAPH
	{0x4EF3,	0xA5F6},	// CJK UNIFIED IDEOGRAPH
	{0x4EF4,	0xC9BA},	// CJK UNIFIED IDEOGRAPH
	{0x4EF5,	0xC9AE},	// CJK UNIFIED IDEOGRAPH
	{0x4EF6,	0xA5F3},	// CJK UNIFIED IDEOGRAPH
	{0x4EF7,	0xC9B2},	// CJK UNIFIED IDEOGRAPH
	{0x4EFB,	0xA5F4},	// CJK UNIFIED IDEOGRAPH
	{0x4EFD,	0xA5F7},	// CJK UNIFIED IDEOGRAPH
	{0x4EFF,	0xA5E9},	// CJK UNIFIED IDEOGRAPH
	{0x4F00,	0xC9B1},	// CJK UNIFIED IDEOGRAPH
	{0x4F01,	0xA5F8},	// CJK UNIFIED IDEOGRAPH
	{0x4F02,	0xC9B5},	// CJK UNIFIED IDEOGRAPH
	{0x4F04,	0xC9B9},	// CJK UNIFIED IDEOGRAPH
	{0x4F05,	0xC9B6},	// CJK UNIFIED IDEOGRAPH
	{0x4F08,	0xC9B3},	// CJK UNIFIED IDEOGRAPH
	{0x4F09,	0xA5EA},	// CJK UNIFIED IDEOGRAPH
	{0x4F0A,	0xA5EC},	// CJK UNIFIED IDEOGRAPH
	{0x4F0B,	0xA5F9},	// CJK UNIFIED IDEOGRAPH
	{0x4F0D,	0xA5EE},	// CJK UNIFIED IDEOGRAPH
	{0x4F0E,	0xC9AB},	// CJK UNIFIED IDEOGRAPH
	{0x4F0F,	0xA5F1},	// CJK UNIFIED IDEOGRAPH
	{0x4F10,	0xA5EF},	// CJK UNIFIED IDEOGRAPH
	{0x4F11,	0xA5F0},	// CJK UNIFIED IDEOGRAPH
	{0x4F12,	0xC9BB},	// CJK UNIFIED IDEOGRAPH
	{0x4F13,	0xC9B8},	// CJK UNIFIED IDEOGRAPH
	{0x4F14,	0xC9AF},	// CJK UNIFIED IDEOGRAPH
	{0x4F15,	0xA5ED},	// CJK UNIFIED IDEOGRAPH
	{0x4F18,	0xC9AC},	// CJK UNIFIED IDEOGRAPH
	{0x4F19,	0xA5EB},	// CJK UNIFIED IDEOGRAPH
	{0x4F1D,	0xC9B4},	// CJK UNIFIED IDEOGRAPH
	{0x4F22,	0xC9B7},	// CJK UNIFIED IDEOGRAPH
	{0x4F2C,	0xC9AD},	// CJK UNIFIED IDEOGRAPH
	{0x4F2D,	0xCA66},	// CJK UNIFIED IDEOGRAPH
	{0x4F2F,	0xA742},	// CJK UNIFIED IDEOGRAPH
	{0x4F30,	0xA6F4},	// CJK UNIFIED IDEOGRAPH
	{0x4F33,	0xCA67},	// CJK UNIFIED IDEOGRAPH
	{0x4F34,	0xA6F1},	// CJK UNIFIED IDEOGRAPH
	{0x4F36,	0xA744},	// CJK UNIFIED IDEOGRAPH
	{0x4F38,	0xA6F9},	// CJK UNIFIED IDEOGRAPH
	{0x4F3A,	0xA6F8},	// CJK UNIFIED IDEOGRAPH
	{0x4F3B,	0xCA5B},	// CJK UNIFIED IDEOGRAPH
	{0x4F3C,	0xA6FC},	// CJK UNIFIED IDEOGRAPH
	{0x4F3D,	0xA6F7},	// CJK UNIFIED IDEOGRAPH
	{0x4F3E,	0xCA60},	// CJK UNIFIED IDEOGRAPH
	{0x4F3F,	0xCA68},	// CJK UNIFIED IDEOGRAPH
	{0x4F41,	0xCA64},	// CJK UNIFIED IDEOGRAPH
	{0x4F43,	0xA6FA},	// CJK UNIFIED IDEOGRAPH
	{0x4F46,	0xA6FD},	// CJK UNIFIED IDEOGRAPH
	{0x4F47,	0xA6EE},	// CJK UNIFIED IDEOGRAPH
	{0x4F48,	0xA747},	// CJK UNIFIED IDEOGRAPH
	{0x4F49,	0xCA5D},	// CJK UNIFIED IDEOGRAPH
	{0x4F4C,	0xCBBD},	// CJK UNIFIED IDEOGRAPH
	{0x4F4D,	0xA6EC},	// CJK UNIFIED IDEOGRAPH
	{0x4F4E,	0xA743},	// CJK UNIFIED IDEOGRAPH
	{0x4F4F,	0xA6ED},	// CJK UNIFIED IDEOGRAPH
	{0x4F50,	0xA6F5},	// CJK UNIFIED IDEOGRAPH
	{0x4F51,	0xA6F6},	// CJK UNIFIED IDEOGRAPH
	{0x4F52,	0xCA62},	// CJK UNIFIED IDEOGRAPH
	{0x4F53,	0xCA5E},	// CJK UNIFIED IDEOGRAPH
	{0x4F54,	0xA6FB},	// CJK UNIFIED IDEOGRAPH
	{0x4F55,	0xA6F3},	// CJK UNIFIED IDEOGRAPH
	{0x4F56,	0xCA5A},	// CJK UNIFIED IDEOGRAPH
	{0x4F57,	0xA6EF},	// CJK UNIFIED IDEOGRAPH
	{0x4F58,	0xCA65},	// CJK UNIFIED IDEOGRAPH
	{0x4F59,	0xA745},	// CJK UNIFIED IDEOGRAPH
	{0x4F5A,	0xA748},	// CJK UNIFIED IDEOGRAPH
	{0x4F5B,	0xA6F2},	// CJK UNIFIED IDEOGRAPH
	{0x4F5C,	0xA740},	// CJK UNIFIED IDEOGRAPH
	{0x4F5D,	0xA746},	// CJK UNIFIED IDEOGRAPH
	{0x4F5E,	0xA6F0},	// CJK UNIFIED IDEOGRAPH
	{0x4F5F,	0xCA63},	// CJK UNIFIED IDEOGRAPH
	{0x4F60,	0xA741},	// CJK UNIFIED IDEOGRAPH
	{0x4F61,	0xCA69},	// CJK UNIFIED IDEOGRAPH
	{0x4F62,	0xCA5C},	// CJK UNIFIED IDEOGRAPH
	{0x4F63,	0xA6FE},	// CJK UNIFIED IDEOGRAPH
	{0x4F64,	0xCA5F},	// CJK UNIFIED IDEOGRAPH
	{0x4F67,	0xCA61},	// CJK UNIFIED IDEOGRAPH
	{0x4F69,	0xA8D8},	// CJK UNIFIED IDEOGRAPH
	{0x4F6A,	0xCBBF},	// CJK UNIFIED IDEOGRAPH
	{0x4F6B,	0xCBCB},	// CJK UNIFIED IDEOGRAPH
	{0x4F6C,	0xA8D0},	// CJK UNIFIED IDEOGRAPH
	{0x4F6E,	0xCBCC},	// CJK UNIFIED IDEOGRAPH
	{0x4F6F,	0xA8CB},	// CJK UNIFIED IDEOGRAPH
	{0x4F70,	0xA8D5},	// CJK UNIFIED IDEOGRAPH
	{0x4F73,	0xA8CE},	// CJK UNIFIED IDEOGRAPH
	{0x4F74,	0xCBB9},	// CJK UNIFIED IDEOGRAPH
	{0x4F75,	0xA8D6},	// CJK UNIFIED IDEOGRAPH
	{0x4F76,	0xCBB8},	// CJK UNIFIED IDEOGRAPH
	{0x4F77,	0xCBBC},	// CJK UNIFIED IDEOGRAPH
	{0x4F78,	0xCBC3},	// CJK UNIFIED IDEOGRAPH
	{0x4F79,	0xCBC1},	// CJK UNIFIED IDEOGRAPH
	{0x4F7A,	0xA8DE},	// CJK UNIFIED IDEOGRAPH
	{0x4F7B,	0xA8D9},	// CJK UNIFIED IDEOGRAPH
	{0x4F7C,	0xCBB3},	// CJK UNIFIED IDEOGRAPH
	{0x4F7D,	0xCBB5},	// CJK UNIFIED IDEOGRAPH
	{0x4F7E,	0xA8DB},	// CJK UNIFIED IDEOGRAPH
	{0x4F7F,	0xA8CF},	// CJK UNIFIED IDEOGRAPH
	{0x4F80,	0xCBB6},	// CJK UNIFIED IDEOGRAPH
	{0x4F81,	0xCBC2},	// CJK UNIFIED IDEOGRAPH
	{0x4F82,	0xCBC9},	// CJK UNIFIED IDEOGRAPH
	{0x4F83,	0xA8D4},	// CJK UNIFIED IDEOGRAPH
	{0x4F84,	0xCBBB},	// CJK UNIFIED IDEOGRAPH
	{0x4F85,	0xCBB4},	// CJK UNIFIED IDEOGRAPH
	{0x4F86,	0xA8D3},	// CJK UNIFIED IDEOGRAPH
	{0x4F87,	0xCBB7},	// CJK UNIFIED IDEOGRAPH
	{0x4F88,	0xA8D7},	// CJK UNIFIED IDEOGRAPH
	{0x4F89,	0xCBBA},	// CJK UNIFIED IDEOGRAPH
	{0x4F8B,	0xA8D2},	// CJK UNIFIED IDEOGRAPH
	{0x4F8D,	0xA8CD},	// CJK UNIFIED IDEOGRAPH
	{0x4F8F,	0xA8DC},	// CJK UNIFIED IDEOGRAPH
	{0x4F90,	0xCBC4},	// CJK UNIFIED IDEOGRAPH
	{0x4F91,	0xA8DD},	// CJK UNIFIED IDEOGRAPH
	{0x4F92,	0xCBC8},	// CJK UNIFIED IDEOGRAPH
	{0x4F94,	0xCBC6},	// CJK UNIFIED IDEOGRAPH
	{0x4F95,	0xCBCA},	// CJK UNIFIED IDEOGRAPH
	{0x4F96,	0xA8DA},	// CJK UNIFIED IDEOGRAPH
	{0x4F97,	0xCBBE},	// CJK UNIFIED IDEOGRAPH
	{0x4F98,	0xCBB2},	// CJK UNIFIED IDEOGRAPH
	{0x4F9A,	0xCBC0},	// CJK UNIFIED IDEOGRAPH
	{0x4F9B,	0xA8D1},	// CJK UNIFIED IDEOGRAPH
	{0x4F9C,	0xCBC5},	// CJK UNIFIED IDEOGRAPH
	{0x4F9D,	0xA8CC},	// CJK UNIFIED IDEOGRAPH
	{0x4F9E,	0xCBC7},	// CJK UNIFIED IDEOGRAPH
	{0x4FAE,	0xAB56},	// CJK UNIFIED IDEOGRAPH
	{0x4FAF,	0xAB4A},	// CJK UNIFIED IDEOGRAPH
	{0x4FB2,	0xCDE0},	// CJK UNIFIED IDEOGRAPH
	{0x4FB3,	0xCDE8},	// CJK UNIFIED IDEOGRAPH
	{0x4FB5,	0xAB49},	// CJK UNIFIED IDEOGRAPH
	{0x4FB6,	0xAB51},	// CJK UNIFIED IDEOGRAPH
	{0x4FB7,	0xAB5D},	// CJK UNIFIED IDEOGRAPH
	{0x4FB9,	0xCDEE},	// CJK UNIFIED IDEOGRAPH
	{0x4FBA,	0xCDEC},	// CJK UNIFIED IDEOGRAPH
	{0x4FBB,	0xCDE7},	// CJK UNIFIED IDEOGRAPH
	{0x4FBF,	0xAB4B},	// CJK UNIFIED IDEOGRAPH
	{0x4FC0,	0xCDED},	// CJK UNIFIED IDEOGRAPH
	{0x4FC1,	0xCDE3},	// CJK UNIFIED IDEOGRAPH
	{0x4FC2,	0xAB59},	// CJK UNIFIED IDEOGRAPH
	{0x4FC3,	0xAB50},	// CJK UNIFIED IDEOGRAPH
	{0x4FC4,	0xAB58},	// CJK UNIFIED IDEOGRAPH
	{0x4FC5,	0xCDDE},	// CJK UNIFIED IDEOGRAPH
	{0x4FC7,	0xCDEA},	// CJK UNIFIED IDEOGRAPH
	{0x4FC9,	0xCDE1},	// CJK UNIFIED IDEOGRAPH
	{0x4FCA,	0xAB54},	// CJK UNIFIED IDEOGRAPH
	{0x4FCB,	0xCDE2},	// CJK UNIFIED IDEOGRAPH
	{0x4FCD,	0xCDDD},	// CJK UNIFIED IDEOGRAPH
	{0x4FCE,	0xAB5B},	// CJK UNIFIED IDEOGRAPH
	{0x4FCF,	0xAB4E},	// CJK UNIFIED IDEOGRAPH
	{0x4FD0,	0xAB57},	// CJK UNIFIED IDEOGRAPH
	{0x4FD1,	0xAB4D},	// CJK UNIFIED IDEOGRAPH
	{0x4FD3,	0xCDDF},	// CJK UNIFIED IDEOGRAPH
	{0x4FD4,	0xCDE4},	// CJK UNIFIED IDEOGRAPH
	{0x4FD6,	0xCDEB},	// CJK UNIFIED IDEOGRAPH
	{0x4FD7,	0xAB55},	// CJK UNIFIED IDEOGRAPH
	{0x4FD8,	0xAB52},	// CJK UNIFIED IDEOGRAPH
	{0x4FD9,	0xCDE6},	// CJK UNIFIED IDEOGRAPH
	{0x4FDA,	0xAB5A},	// CJK UNIFIED IDEOGRAPH
	{0x4FDB,	0xCDE9},	// CJK UNIFIED IDEOGRAPH
	{0x4FDC,	0xCDE5},	// CJK UNIFIED IDEOGRAPH
	{0x4FDD,	0xAB4F},	// CJK UNIFIED IDEOGRAPH
	{0x4FDE,	0xAB5C},	// CJK UNIFIED IDEOGRAPH
	{0x4FDF,	0xAB53},	// CJK UNIFIED IDEOGRAPH
	{0x4FE0,	0xAB4C},	// CJK UNIFIED IDEOGRAPH
	{0x4FE1,	0xAB48},	// CJK UNIFIED IDEOGRAPH
	{0x4FEC,	0xCDEF},	// CJK UNIFIED IDEOGRAPH
	{0x4FEE,	0xADD7},	// CJK UNIFIED IDEOGRAPH
	{0x4FEF,	0xADC1},	// CJK UNIFIED IDEOGRAPH
	{0x4FF1,	0xADD1},	// CJK UNIFIED IDEOGRAPH
	{0x4FF3,	0xADD6},	// CJK UNIFIED IDEOGRAPH
	{0x4FF4,	0xD0D0},	// CJK UNIFIED IDEOGRAPH
	{0x4FF5,	0xD0CF},	// CJK UNIFIED IDEOGRAPH
	{0x4FF6,	0xD0D4},	// CJK UNIFIED IDEOGRAPH
	{0x4FF7,	0xD0D5},	// CJK UNIFIED IDEOGRAPH
	{0x4FF8,	0xADC4},	// CJK UNIFIED IDEOGRAPH
	{0x4FFA,	0xADCD},	// CJK UNIFIED IDEOGRAPH
	{0x4FFE,	0xADDA},	// CJK UNIFIED IDEOGRAPH
	{0x5000,	0xADCE},	// CJK UNIFIED IDEOGRAPH
	{0x5005,	0xD0C9},	// CJK UNIFIED IDEOGRAPH
	{0x5006,	0xADC7},	// CJK UNIFIED IDEOGRAPH
	{0x5007,	0xD0CA},	// CJK UNIFIED IDEOGRAPH
	{0x5009,	0xADDC},	// CJK UNIFIED IDEOGRAPH
	{0x500B,	0xADD3},	// CJK UNIFIED IDEOGRAPH
	{0x500C,	0xADBE},	// CJK UNIFIED IDEOGRAPH
	{0x500D,	0xADBF},	// CJK UNIFIED IDEOGRAPH
	{0x500E,	0xD0DD},	// CJK UNIFIED IDEOGRAPH
	{0x500F,	0xB0BF},	// CJK UNIFIED IDEOGRAPH
	{0x5011,	0xADCC},	// CJK UNIFIED IDEOGRAPH
	{0x5012,	0xADCB},	// CJK UNIFIED IDEOGRAPH
	{0x5013,	0xD0CB},	// CJK UNIFIED IDEOGRAPH
	{0x5014,	0xADCF},	// CJK UNIFIED IDEOGRAPH
	{0x5015,	0xD45B},	// CJK UNIFIED IDEOGRAPH
	{0x5016,	0xADC6},	// CJK UNIFIED IDEOGRAPH
	{0x5017,	0xD0D6},	// CJK UNIFIED IDEOGRAPH
	{0x5018,	0xADD5},	// CJK UNIFIED IDEOGRAPH
	{0x5019,	0xADD4},	// CJK UNIFIED IDEOGRAPH
	{0x501A,	0xADCA},	// CJK UNIFIED IDEOGRAPH
	{0x501B,	0xD0CE},	// CJK UNIFIED IDEOGRAPH
	{0x501C,	0xD0D7},	// CJK UNIFIED IDEOGRAPH
	{0x501E,	0xD0C8},	// CJK UNIFIED IDEOGRAPH
	{0x501F,	0xADC9},	// CJK UNIFIED IDEOGRAPH
	{0x5020,	0xD0D8},	// CJK UNIFIED IDEOGRAPH
	{0x5021,	0xADD2},	// CJK UNIFIED IDEOGRAPH
	{0x5022,	0xD0CC},	// CJK UNIFIED IDEOGRAPH
	{0x5023,	0xADC0},	// CJK UNIFIED IDEOGRAPH
	{0x5025,	0xADC3},	// CJK UNIFIED IDEOGRAPH
	{0x5026,	0xADC2},	// CJK UNIFIED IDEOGRAPH
	{0x5027,	0xD0D9},	// CJK UNIFIED IDEOGRAPH
	{0x5028,	0xADD0},	// CJK UNIFIED IDEOGRAPH
	{0x5029,	0xADC5},	// CJK UNIFIED IDEOGRAPH
	{0x502A,	0xADD9},	// CJK UNIFIED IDEOGRAPH
	{0x502B,	0xADDB},	// CJK UNIFIED IDEOGRAPH
	{0x502C,	0xD0D3},	// CJK UNIFIED IDEOGRAPH
	{0x502D,	0xADD8},	// CJK UNIFIED IDEOGRAPH
	{0x502F,	0xD0DB},	// CJK UNIFIED IDEOGRAPH
	{0x5030,	0xD0CD},	// CJK UNIFIED IDEOGRAPH
	{0x5031,	0xD0DC},	// CJK UNIFIED IDEOGRAPH
	{0x5033,	0xD0D1},	// CJK UNIFIED IDEOGRAPH
	{0x5035,	0xD0DA},	// CJK UNIFIED IDEOGRAPH
	{0x5037,	0xD0D2},	// CJK UNIFIED IDEOGRAPH
	{0x503C,	0xADC8},	// CJK UNIFIED IDEOGRAPH
	{0x5040,	0xD463},	// CJK UNIFIED IDEOGRAPH
	{0x5041,	0xD457},	// CJK UNIFIED IDEOGRAPH
	{0x5043,	0xB0B3},	// CJK UNIFIED IDEOGRAPH
	{0x5045,	0xD45C},	// CJK UNIFIED IDEOGRAPH
	{0x5046,	0xD462},	// CJK UNIFIED IDEOGRAPH
	{0x5047,	0xB0B2},	// CJK UNIFIED IDEOGRAPH
	{0x5048,	0xD455},	// CJK UNIFIED IDEOGRAPH
	{0x5049,	0xB0B6},	// CJK UNIFIED IDEOGRAPH
	{0x504A,	0xD459},	// CJK UNIFIED IDEOGRAPH
	{0x504B,	0xD452},	// CJK UNIFIED IDEOGRAPH
	{0x504C,	0xB0B4},	// CJK UNIFIED IDEOGRAPH
	{0x504D,	0xD456},	// CJK UNIFIED IDEOGRAPH
	{0x504E,	0xB0B9},	// CJK UNIFIED IDEOGRAPH
	{0x504F,	0xB0BE},	// CJK UNIFIED IDEOGRAPH
	{0x5051,	0xD467},	// CJK UNIFIED IDEOGRAPH
	{0x5053,	0xD451},	// CJK UNIFIED IDEOGRAPH
	{0x5055,	0xB0BA},	// CJK UNIFIED IDEOGRAPH
	{0x5057,	0xD466},	// CJK UNIFIED IDEOGRAPH
	{0x505A,	0xB0B5},	// CJK UNIFIED IDEOGRAPH
	{0x505B,	0xD458},	// CJK UNIFIED IDEOGRAPH
	{0x505C,	0xB0B1},	// CJK UNIFIED IDEOGRAPH
	{0x505D,	0xD453},	// CJK UNIFIED IDEOGRAPH
	{0x505E,	0xD44F},	// CJK UNIFIED IDEOGRAPH
	{0x505F,	0xD45D},	// CJK UNIFIED IDEOGRAPH
	{0x5060,	0xD450},	// CJK UNIFIED IDEOGRAPH
	{0x5061,	0xD44E},	// CJK UNIFIED IDEOGRAPH
	{0x5062,	0xD45A},	// CJK UNIFIED IDEOGRAPH
	{0x5063,	0xD460},	// CJK UNIFIED IDEOGRAPH
	{0x5064,	0xD461},	// CJK UNIFIED IDEOGRAPH
	{0x5065,	0xB0B7},	// CJK UNIFIED IDEOGRAPH
	{0x5068,	0xD85B},	// CJK UNIFIED IDEOGRAPH
	{0x5069,	0xD45E},	// CJK UNIFIED IDEOGRAPH
	{0x506A,	0xD44D},	// CJK UNIFIED IDEOGRAPH
	{0x506B,	0xD45F},	// CJK UNIFIED IDEOGRAPH
	{0x506D,	0xB0C1},	// CJK UNIFIED IDEOGRAPH
	{0x506E,	0xD464},	// CJK UNIFIED IDEOGRAPH
	{0x506F,	0xB0C0},	// CJK UNIFIED IDEOGRAPH
	{0x5070,	0xD44C},	// CJK UNIFIED IDEOGRAPH
	{0x5072,	0xD454},	// CJK UNIFIED IDEOGRAPH
	{0x5073,	0xD465},	// CJK UNIFIED IDEOGRAPH
	{0x5074,	0xB0BC},	// CJK UNIFIED IDEOGRAPH
	{0x5075,	0xB0BB},	// CJK UNIFIED IDEOGRAPH
	{0x5076,	0xB0B8},	// CJK UNIFIED IDEOGRAPH
	{0x5077,	0xB0BD},	// CJK UNIFIED IDEOGRAPH
	{0x507A,	0xB0AF},	// CJK UNIFIED IDEOGRAPH
	{0x507D,	0xB0B0},	// CJK UNIFIED IDEOGRAPH
	{0x5080,	0xB3C8},	// CJK UNIFIED IDEOGRAPH
	{0x5082,	0xD85E},	// CJK UNIFIED IDEOGRAPH
	{0x5083,	0xD857},	// CJK UNIFIED IDEOGRAPH
	{0x5085,	0xB3C5},	// CJK UNIFIED IDEOGRAPH
	{0x5087,	0xD85F},	// CJK UNIFIED IDEOGRAPH
	{0x508B,	0xD855},	// CJK UNIFIED IDEOGRAPH
	{0x508C,	0xD858},	// CJK UNIFIED IDEOGRAPH
	{0x508D,	0xB3C4},	// CJK UNIFIED IDEOGRAPH
	{0x508E,	0xD859},	// CJK UNIFIED IDEOGRAPH
	{0x5091,	0xB3C7},	// CJK UNIFIED IDEOGRAPH
	{0x5092,	0xD85D},	// CJK UNIFIED IDEOGRAPH
	{0x5094,	0xD853},	// CJK UNIFIED IDEOGRAPH
	{0x5095,	0xD852},	// CJK UNIFIED IDEOGRAPH
	{0x5096,	0xB3C9},	// CJK UNIFIED IDEOGRAPH
	{0x5098,	0xB3CA},	// CJK UNIFIED IDEOGRAPH
	{0x5099,	0xB3C6},	// CJK UNIFIED IDEOGRAPH
	{0x509A,	0xB3CB},	// CJK UNIFIED IDEOGRAPH
	{0x509B,	0xD851},	// CJK UNIFIED IDEOGRAPH
	{0x509C,	0xD85C},	// CJK UNIFIED IDEOGRAPH
	{0x509D,	0xD85A},	// CJK UNIFIED IDEOGRAPH
	{0x509E,	0xD854},	// CJK UNIFIED IDEOGRAPH
	{0x50A2,	0xB3C3},	// CJK UNIFIED IDEOGRAPH
	{0x50A3,	0xD856},	// CJK UNIFIED IDEOGRAPH
	{0x50AC,	0xB6CA},	// CJK UNIFIED IDEOGRAPH
	{0x50AD,	0xB6C4},	// CJK UNIFIED IDEOGRAPH
	{0x50AE,	0xDCB7},	// CJK UNIFIED IDEOGRAPH
	{0x50AF,	0xB6CD},	// CJK UNIFIED IDEOGRAPH
	{0x50B0,	0xDCBD},	// CJK UNIFIED IDEOGRAPH
	{0x50B1,	0xDCC0},	// CJK UNIFIED IDEOGRAPH
	{0x50B2,	0xB6C6},	// CJK UNIFIED IDEOGRAPH
	{0x50B3,	0xB6C7},	// CJK UNIFIED IDEOGRAPH
	{0x50B4,	0xDCBA},	// CJK UNIFIED IDEOGRAPH
	{0x50B5,	0xB6C5},	// CJK UNIFIED IDEOGRAPH
	{0x50B6,	0xDCC3},	// CJK UNIFIED IDEOGRAPH
	{0x50B7,	0xB6CB},	// CJK UNIFIED IDEOGRAPH
	{0x50B8,	0xDCC4},	// CJK UNIFIED IDEOGRAPH
	{0x50BA,	0xDCBF},	// CJK UNIFIED IDEOGRAPH
	{0x50BB,	0xB6CC},	// CJK UNIFIED IDEOGRAPH
	{0x50BD,	0xDCB4},	// CJK UNIFIED IDEOGRAPH
	{0x50BE,	0xB6C9},	// CJK UNIFIED IDEOGRAPH
	{0x50BF,	0xDCB5},	// CJK UNIFIED IDEOGRAPH
	{0x50C1,	0xDCBE},	// CJK UNIFIED IDEOGRAPH
	{0x50C2,	0xDCBC},	// CJK UNIFIED IDEOGRAPH
	{0x50C4,	0xDCB8},	// CJK UNIFIED IDEOGRAPH
	{0x50C5,	0xB6C8},	// CJK UNIFIED IDEOGRAPH
	{0x50C6,	0xDCB6},	// CJK UNIFIED IDEOGRAPH
	{0x50C7,	0xB6CE},	// CJK UNIFIED IDEOGRAPH
	{0x50C8,	0xDCBB},	// CJK UNIFIED IDEOGRAPH
	{0x50C9,	0xDCC2},	// CJK UNIFIED IDEOGRAPH
	{0x50CA,	0xDCB9},	// CJK UNIFIED IDEOGRAPH
	{0x50CB,	0xDCC1},	// CJK UNIFIED IDEOGRAPH
	{0x50CE,	0xB9B6},	// CJK UNIFIED IDEOGRAPH
	{0x50CF,	0xB9B3},	// CJK UNIFIED IDEOGRAPH
	{0x50D1,	0xB9B4},	// CJK UNIFIED IDEOGRAPH
	{0x50D3,	0xE0F9},	// CJK UNIFIED IDEOGRAPH
	{0x50D4,	0xE0F1},	// CJK UNIFIED IDEOGRAPH
	{0x50D5,	0xB9B2},	// CJK UNIFIED IDEOGRAPH
	{0x50D6,	0xB9AF},	// CJK UNIFIED IDEOGRAPH
	{0x50D7,	0xE0F2},	// CJK UNIFIED IDEOGRAPH
	{0x50DA,	0xB9B1},	// CJK UNIFIED IDEOGRAPH
	{0x50DB,	0xE0F5},	// CJK UNIFIED IDEOGRAPH
	{0x50DD,	0xE0F7},	// CJK UNIFIED IDEOGRAPH
	{0x50E0,	0xE0FE},	// CJK UNIFIED IDEOGRAPH
	{0x50E3,	0xE0FD},	// CJK UNIFIED IDEOGRAPH
	{0x50E4,	0xE0F8},	// CJK UNIFIED IDEOGRAPH
	{0x50E5,	0xB9AE},	// CJK UNIFIED IDEOGRAPH
	{0x50E6,	0xE0F0},	// CJK UNIFIED IDEOGRAPH
	{0x50E7,	0xB9AC},	// CJK UNIFIED IDEOGRAPH
	{0x50E8,	0xE0F3},	// CJK UNIFIED IDEOGRAPH
	{0x50E9,	0xB9B7},	// CJK UNIFIED IDEOGRAPH
	{0x50EA,	0xE0F6},	// CJK UNIFIED IDEOGRAPH
	{0x50EC,	0xE0FA},	// CJK UNIFIED IDEOGRAPH
	{0x50ED,	0xB9B0},	// CJK UNIFIED IDEOGRAPH
	{0x50EE,	0xB9AD},	// CJK UNIFIED IDEOGRAPH
	{0x50EF,	0xE0FC},	// CJK UNIFIED IDEOGRAPH
	{0x50F0,	0xE0FB},	// CJK UNIFIED IDEOGRAPH
	{0x50F1,	0xB9B5},	// CJK UNIFIED IDEOGRAPH
	{0x50F3,	0xE0F4},	// CJK UNIFIED IDEOGRAPH
	{0x50F5,	0xBBF8},	// CJK UNIFIED IDEOGRAPH
	{0x50F6,	0xE4EC},	// CJK UNIFIED IDEOGRAPH
	{0x50F8,	0xE4E9},	// CJK UNIFIED IDEOGRAPH
	{0x50F9,	0xBBF9},	// CJK UNIFIED IDEOGRAPH
	{0x50FB,	0xBBF7},	// CJK UNIFIED IDEOGRAPH
	{0x50FD,	0xE4F0},	// CJK UNIFIED IDEOGRAPH
	{0x50FE,	0xE4ED},	// CJK UNIFIED IDEOGRAPH
	{0x50FF,	0xE4E6},	// CJK UNIFIED IDEOGRAPH
	{0x5100,	0xBBF6},	// CJK UNIFIED IDEOGRAPH
	{0x5102,	0xBBFA},	// CJK UNIFIED IDEOGRAPH
	{0x5103,	0xE4E7},	// CJK UNIFIED IDEOGRAPH
	{0x5104,	0xBBF5},	// CJK UNIFIED IDEOGRAPH
	{0x5105,	0xBBFD},	// CJK UNIFIED IDEOGRAPH
	{0x5106,	0xE4EA},	// CJK UNIFIED IDEOGRAPH
	{0x5107,	0xE4EB},	// CJK UNIFIED IDEOGRAPH
	{0x5108,	0xBBFB},	// CJK UNIFIED IDEOGRAPH
	{0x5109,	0xBBFC},	// CJK UNIFIED IDEOGRAPH
	{0x510A,	0xE4F1},	// CJK UNIFIED IDEOGRAPH
	{0x510B,	0xE4EE},	// CJK UNIFIED IDEOGRAPH
	{0x510C,	0xE4EF},	// CJK UNIFIED IDEOGRAPH
	{0x5110,	0xBEAA},	// CJK UNIFIED IDEOGRAPH
	{0x5111,	0xE8F8},	// CJK UNIFIED IDEOGRAPH
	{0x5112,	0xBEA7},	// CJK UNIFIED IDEOGRAPH
	{0x5113,	0xE8F5},	// CJK UNIFIED IDEOGRAPH
	{0x5114,	0xBEA9},	// CJK UNIFIED IDEOGRAPH
	{0x5115,	0xBEAB},	// CJK UNIFIED IDEOGRAPH
	{0x5117,	0xE8F6},	// CJK UNIFIED IDEOGRAPH
	{0x5118,	0xBEA8},	// CJK UNIFIED IDEOGRAPH
	{0x511A,	0xE8F7},	// CJK UNIFIED IDEOGRAPH
	{0x511C,	0xE8F4},	// CJK UNIFIED IDEOGRAPH
	{0x511F,	0xC076},	// CJK UNIFIED IDEOGRAPH
	{0x5120,	0xECBD},	// CJK UNIFIED IDEOGRAPH
	{0x5121,	0xC077},	// CJK UNIFIED IDEOGRAPH
	{0x5122,	0xECBB},	// CJK UNIFIED IDEOGRAPH
	{0x5124,	0xECBC},	// CJK UNIFIED IDEOGRAPH
	{0x5125,	0xECBA},	// CJK UNIFIED IDEOGRAPH
	{0x5126,	0xECB9},	// CJK UNIFIED IDEOGRAPH
	{0x5129,	0xECBE},	// CJK UNIFIED IDEOGRAPH
	{0x512A,	0xC075},	// CJK UNIFIED IDEOGRAPH
	{0x512D,	0xEFB8},	// CJK UNIFIED IDEOGRAPH
	{0x512E,	0xEFB9},	// CJK UNIFIED IDEOGRAPH
	{0x5130,	0xE4E8},	// CJK UNIFIED IDEOGRAPH
	{0x5131,	0xEFB7},	// CJK UNIFIED IDEOGRAPH
	{0x5132,	0xC078},	// CJK UNIFIED IDEOGRAPH
	{0x5133,	0xC35F},	// CJK UNIFIED IDEOGRAPH
	{0x5134,	0xF1EB},	// CJK UNIFIED IDEOGRAPH
	{0x5135,	0xF1EC},	// CJK UNIFIED IDEOGRAPH
	{0x5137,	0xC4D7},	// CJK UNIFIED IDEOGRAPH
	{0x5138,	0xC4D8},	// CJK UNIFIED IDEOGRAPH
	{0x5139,	0xF5C1},	// CJK UNIFIED IDEOGRAPH
	{0x513A,	0xF5C0},	// CJK UNIFIED IDEOGRAPH
	{0x513B,	0xC56C},	// CJK UNIFIED IDEOGRAPH
	{0x513C,	0xC56B},	// CJK UNIFIED IDEOGRAPH
	{0x513D,	0xF7D0},	// CJK UNIFIED IDEOGRAPH
	{0x513F,	0xA449},	// CJK UNIFIED IDEOGRAPH
	{0x5140,	0xA461},	// CJK UNIFIED IDEOGRAPH
	{0x5141,	0xA4B9},	// CJK UNIFIED IDEOGRAPH
	{0x5143,	0xA4B8},	// CJK UNIFIED IDEOGRAPH
	{0x5144,	0xA553},	// CJK UNIFIED IDEOGRAPH
	{0x5145,	0xA552},	// CJK UNIFIED IDEOGRAPH
	{0x5146,	0xA5FC},	// CJK UNIFIED IDEOGRAPH
	{0x5147,	0xA5FB},	// CJK UNIFIED IDEOGRAPH
	{0x5148,	0xA5FD},	// CJK UNIFIED IDEOGRAPH
	{0x5149,	0xA5FA},	// CJK UNIFIED IDEOGRAPH
	{0x514B,	0xA74A},	// CJK UNIFIED IDEOGRAPH
	{0x514C,	0xA749},	// CJK UNIFIED IDEOGRAPH
	{0x514D,	0xA74B},	// CJK UNIFIED IDEOGRAPH
	{0x5152,	0xA8E0},	// CJK UNIFIED IDEOGRAPH
	{0x5154,	0xA8DF},	// CJK UNIFIED IDEOGRAPH
	{0x5155,	0xA8E1},	// CJK UNIFIED IDEOGRAPH
	{0x5157,	0xAB5E},	// CJK UNIFIED IDEOGRAPH
	{0x5159,	0xA259},	// CJK UNIFIED IDEOGRAPH
	{0x515A,	0xD0DE},	// CJK UNIFIED IDEOGRAPH
	{0x515B,	0xA25A},	// CJK UNIFIED IDEOGRAPH
	{0x515C,	0xB0C2},	// CJK UNIFIED IDEOGRAPH
	{0x515D,	0xA25C},	// CJK UNIFIED IDEOGRAPH
	{0x515E,	0xA25B},	// CJK UNIFIED IDEOGRAPH
	{0x515F,	0xD860},	// CJK UNIFIED IDEOGRAPH
	{0x5161,	0xA25D},	// CJK UNIFIED IDEOGRAPH
	{0x5162,	0xB9B8},	// CJK UNIFIED IDEOGRAPH
	{0x5163,	0xA25E},	// CJK UNIFIED IDEOGRAPH
	{0x5165,	0xA44A},	// CJK UNIFIED IDEOGRAPH
	{0x5167,	0xA4BA},	// CJK UNIFIED IDEOGRAPH
	{0x5168,	0xA5FE},	// CJK UNIFIED IDEOGRAPH
	{0x5169,	0xA8E2},	// CJK UNIFIED IDEOGRAPH
	{0x516B,	0xA44B},	// CJK UNIFIED IDEOGRAPH
	{0x516C,	0xA4BD},	// CJK UNIFIED IDEOGRAPH
	{0x516D,	0xA4BB},	// CJK UNIFIED IDEOGRAPH
	{0x516E,	0xA4BC},	// CJK UNIFIED IDEOGRAPH
	{0x5171,	0xA640},	// CJK UNIFIED IDEOGRAPH
	{0x5175,	0xA74C},	// CJK UNIFIED IDEOGRAPH
	{0x5176,	0xA8E4},	// CJK UNIFIED IDEOGRAPH
	{0x5177,	0xA8E3},	// CJK UNIFIED IDEOGRAPH
	{0x5178,	0xA8E5},	// CJK UNIFIED IDEOGRAPH
	{0x517C,	0xADDD},	// CJK UNIFIED IDEOGRAPH
	{0x5180,	0xBEAC},	// CJK UNIFIED IDEOGRAPH
	{0x5187,	0xC94E},	// CJK UNIFIED IDEOGRAPH
	{0x5189,	0xA554},	// CJK UNIFIED IDEOGRAPH
	{0x518A,	0xA555},	// CJK UNIFIED IDEOGRAPH
	{0x518D,	0xA641},	// CJK UNIFIED IDEOGRAPH
	{0x518F,	0xCA6A},	// CJK UNIFIED IDEOGRAPH
	{0x5191,	0xAB60},	// CJK UNIFIED IDEOGRAPH
	{0x5192,	0xAB5F},	// CJK UNIFIED IDEOGRAPH
	{0x5193,	0xD0E0},	// CJK UNIFIED IDEOGRAPH
	{0x5194,	0xD0DF},	// CJK UNIFIED IDEOGRAPH
	{0x5195,	0xB0C3},	// CJK UNIFIED IDEOGRAPH
	{0x5197,	0xA4BE},	// CJK UNIFIED IDEOGRAPH
	{0x5198,	0xC955},	// CJK UNIFIED IDEOGRAPH
	{0x519E,	0xCBCD},	// CJK UNIFIED IDEOGRAPH
	{0x51A0,	0xAB61},	// CJK UNIFIED IDEOGRAPH
	{0x51A2,	0xADE0},	// CJK UNIFIED IDEOGRAPH
	{0x51A4,	0xADDE},	// CJK UNIFIED IDEOGRAPH
	{0x51A5,	0xADDF},	// CJK UNIFIED IDEOGRAPH
	{0x51AA,	0xBEAD},	// CJK UNIFIED IDEOGRAPH
	{0x51AC,	0xA556},	// CJK UNIFIED IDEOGRAPH
	{0x51B0,	0xA642},	// CJK UNIFIED IDEOGRAPH
	{0x51B1,	0xC9BC},	// CJK UNIFIED IDEOGRAPH
	{0x51B6,	0xA74D},	// CJK UNIFIED IDEOGRAPH
	{0x51B7,	0xA74E},	// CJK UNIFIED IDEOGRAPH
	{0x51B9,	0xCA6B},	// CJK UNIFIED IDEOGRAPH
	{0x51BC,	0xCBCE},	// CJK UNIFIED IDEOGRAPH
	{0x51BD,	0xA8E6},	// CJK UNIFIED IDEOGRAPH
	{0x51BE,	0xCBCF},	// CJK UNIFIED IDEOGRAPH
	{0x51C4,	0xD0E2},	// CJK UNIFIED IDEOGRAPH
	{0x51C5,	0xD0E3},	// CJK UNIFIED IDEOGRAPH
	{0x51C6,	0xADE3},	// CJK UNIFIED IDEOGRAPH
	{0x51C8,	0xD0E4},	// CJK UNIFIED IDEOGRAPH
	{0x51CA,	0xD0E1},	// CJK UNIFIED IDEOGRAPH
	{0x51CB,	0xADE4},	// CJK UNIFIED IDEOGRAPH
	{0x51CC,	0xADE2},	// CJK UNIFIED IDEOGRAPH
	{0x51CD,	0xADE1},	// CJK UNIFIED IDEOGRAPH
	{0x51CE,	0xD0E5},	// CJK UNIFIED IDEOGRAPH
	{0x51D0,	0xD468},	// CJK UNIFIED IDEOGRAPH
	{0x51D4,	0xD861},	// CJK UNIFIED IDEOGRAPH
	{0x51D7,	0xDCC5},	// CJK UNIFIED IDEOGRAPH
	{0x51D8,	0xE140},	// CJK UNIFIED IDEOGRAPH
	{0x51DC,	0xBBFE},	// CJK UNIFIED IDEOGRAPH
	{0x51DD,	0xBEAE},	// CJK UNIFIED IDEOGRAPH
	{0x51DE,	0xE8F9},	// CJK UNIFIED IDEOGRAPH
	{0x51E0,	0xA44C},	// CJK UNIFIED IDEOGRAPH
	{0x51E1,	0xA45A},	// CJK UNIFIED IDEOGRAPH
	{0x51F0,	0xB0C4},	// CJK UNIFIED IDEOGRAPH
	{0x51F1,	0xB3CD},	// CJK UNIFIED IDEOGRAPH
	{0x51F3,	0xB9B9},	// CJK UNIFIED IDEOGRAPH
	{0x51F5,	0xC942},	// CJK UNIFIED IDEOGRAPH
	{0x51F6,	0xA4BF},	// CJK UNIFIED IDEOGRAPH
	{0x51F8,	0xA559},	// CJK UNIFIED IDEOGRAPH
	{0x51F9,	0xA557},	// CJK UNIFIED IDEOGRAPH
	{0x51FA,	0xA558},	// CJK UNIFIED IDEOGRAPH
	{0x51FD,	0xA8E7},	// CJK UNIFIED IDEOGRAPH
	{0x5200,	0xA44D},	// CJK UNIFIED IDEOGRAPH
	{0x5201,	0xA44E},	// CJK UNIFIED IDEOGRAPH
	{0x5203,	0xA462},	// CJK UNIFIED IDEOGRAPH
	{0x5206,	0xA4C0},	// CJK UNIFIED IDEOGRAPH
	{0x5207,	0xA4C1},	// CJK UNIFIED IDEOGRAPH
	{0x5208,	0xA4C2},	// CJK UNIFIED IDEOGRAPH
	{0x5209,	0xC9BE},	// CJK UNIFIED IDEOGRAPH
	{0x520A,	0xA55A},	// CJK UNIFIED IDEOGRAPH
	{0x520C,	0xC96B},	// CJK UNIFIED IDEOGRAPH
	{0x520E,	0xA646},	// CJK UNIFIED IDEOGRAPH
	{0x5210,	0xC9BF},	// CJK UNIFIED IDEOGRAPH
	{0x5211,	0xA644},	// CJK UNIFIED IDEOGRAPH
	{0x5212,	0xA645},	// CJK UNIFIED IDEOGRAPH
	{0x5213,	0xC9BD},	// CJK UNIFIED IDEOGRAPH
	{0x5216,	0xA647},	// CJK UNIFIED IDEOGRAPH
	{0x5217,	0xA643},	// CJK UNIFIED IDEOGRAPH
	{0x521C,	0xCA6C},	// CJK UNIFIED IDEOGRAPH
	{0x521D,	0xAAEC},	// CJK UNIFIED IDEOGRAPH
	{0x521E,	0xCA6D},	// CJK UNIFIED IDEOGRAPH
	{0x5221,	0xCA6E},	// CJK UNIFIED IDEOGRAPH
	{0x5224,	0xA750},	// CJK UNIFIED IDEOGRAPH
	{0x5225,	0xA74F},	// CJK UNIFIED IDEOGRAPH
	{0x5228,	0xA753},	// CJK UNIFIED IDEOGRAPH
	{0x5229,	0xA751},	// CJK UNIFIED IDEOGRAPH
	{0x522A,	0xA752},	// CJK UNIFIED IDEOGRAPH
	{0x522E,	0xA8ED},	// CJK UNIFIED IDEOGRAPH
	{0x5230,	0xA8EC},	// CJK UNIFIED IDEOGRAPH
	{0x5231,	0xCBD4},	// CJK UNIFIED IDEOGRAPH
	{0x5232,	0xCBD1},	// CJK UNIFIED IDEOGRAPH
	{0x5233,	0xCBD2},	// CJK UNIFIED IDEOGRAPH
	{0x5235,	0xCBD0},	// CJK UNIFIED IDEOGRAPH
	{0x5236,	0xA8EE},	// CJK UNIFIED IDEOGRAPH
	{0x5237,	0xA8EA},	// CJK UNIFIED IDEOGRAPH
	{0x5238,	0xA8E9},	// CJK UNIFIED IDEOGRAPH
	{0x523A,	0xA8EB},	// CJK UNIFIED IDEOGRAPH
	{0x523B,	0xA8E8},	// CJK UNIFIED IDEOGRAPH
	{0x5241,	0xA8EF},	// CJK UNIFIED IDEOGRAPH
	{0x5243,	0xAB63},	// CJK UNIFIED IDEOGRAPH
	{0x5244,	0xCDF0},	// CJK UNIFIED IDEOGRAPH
	{0x5246,	0xCBD3},	// CJK UNIFIED IDEOGRAPH
	{0x5247,	0xAB68},	// CJK UNIFIED IDEOGRAPH
	{0x5249,	0xCDF1},	// CJK UNIFIED IDEOGRAPH
	{0x524A,	0xAB64},	// CJK UNIFIED IDEOGRAPH
	{0x524B,	0xAB67},	// CJK UNIFIED IDEOGRAPH
	{0x524C,	0xAB66},	// CJK UNIFIED IDEOGRAPH
	{0x524D,	0xAB65},	// CJK UNIFIED IDEOGRAPH
	{0x524E,	0xAB62},	// CJK UNIFIED IDEOGRAPH
	{0x5252,	0xD0E8},	// CJK UNIFIED IDEOGRAPH
	{0x5254,	0xADE7},	// CJK UNIFIED IDEOGRAPH
	{0x5255,	0xD0EB},	// CJK UNIFIED IDEOGRAPH
	{0x5256,	0xADE5},	// CJK UNIFIED IDEOGRAPH
	{0x525A,	0xD0E7},	// CJK UNIFIED IDEOGRAPH
	{0x525B,	0xADE8},	// CJK UNIFIED IDEOGRAPH
	{0x525C,	0xADE6},	// CJK UNIFIED IDEOGRAPH
	{0x525D,	0xADE9},	// CJK UNIFIED IDEOGRAPH
	{0x525E,	0xD0E9},	// CJK UNIFIED IDEOGRAPH
	{0x525F,	0xD0EA},	// CJK UNIFIED IDEOGRAPH
	{0x5261,	0xD0E6},	// CJK UNIFIED IDEOGRAPH
	{0x5262,	0xD0EC},	// CJK UNIFIED IDEOGRAPH
	{0x5269,	0xB3D1},	// CJK UNIFIED IDEOGRAPH
	{0x526A,	0xB0C5},	// CJK UNIFIED IDEOGRAPH
	{0x526B,	0xD469},	// CJK UNIFIED IDEOGRAPH
	{0x526C,	0xD46B},	// CJK UNIFIED IDEOGRAPH
	{0x526D,	0xD46A},	// CJK UNIFIED IDEOGRAPH
	{0x526E,	0xD46C},	// CJK UNIFIED IDEOGRAPH
	{0x526F,	0xB0C6},	// CJK UNIFIED IDEOGRAPH
	{0x5272,	0xB3CE},	// CJK UNIFIED IDEOGRAPH
	{0x5274,	0xB3CF},	// CJK UNIFIED IDEOGRAPH
	{0x5275,	0xB3D0},	// CJK UNIFIED IDEOGRAPH
	{0x5277,	0xB6D0},	// CJK UNIFIED IDEOGRAPH
	{0x5278,	0xDCC7},	// CJK UNIFIED IDEOGRAPH
	{0x527A,	0xDCC6},	// CJK UNIFIED IDEOGRAPH
	{0x527B,	0xDCC8},	// CJK UNIFIED IDEOGRAPH
	{0x527C,	0xDCC9},	// CJK UNIFIED IDEOGRAPH
	{0x527D,	0xB6D1},	// CJK UNIFIED IDEOGRAPH
	{0x527F,	0xB6CF},	// CJK UNIFIED IDEOGRAPH
	{0x5280,	0xE141},	// CJK UNIFIED IDEOGRAPH
	{0x5281,	0xE142},	// CJK UNIFIED IDEOGRAPH
	{0x5282,	0xB9BB},	// CJK UNIFIED IDEOGRAPH
	{0x5283,	0xB9BA},	// CJK UNIFIED IDEOGRAPH
	{0x5284,	0xE35A},	// CJK UNIFIED IDEOGRAPH
	{0x5287,	0xBC40},	// CJK UNIFIED IDEOGRAPH
	{0x5288,	0xBC41},	// CJK UNIFIED IDEOGRAPH
	{0x5289,	0xBC42},	// CJK UNIFIED IDEOGRAPH
	{0x528A,	0xBC44},	// CJK UNIFIED IDEOGRAPH
	{0x528B,	0xE4F2},	// CJK UNIFIED IDEOGRAPH
	{0x528C,	0xE4F3},	// CJK UNIFIED IDEOGRAPH
	{0x528D,	0xBC43},	// CJK UNIFIED IDEOGRAPH
	{0x5291,	0xBEAF},	// CJK UNIFIED IDEOGRAPH
	{0x5293,	0xBEB0},	// CJK UNIFIED IDEOGRAPH
	{0x5296,	0xF1ED},	// CJK UNIFIED IDEOGRAPH
	{0x5297,	0xF5C3},	// CJK UNIFIED IDEOGRAPH
	{0x5298,	0xF5C2},	// CJK UNIFIED IDEOGRAPH
	{0x5299,	0xF7D1},	// CJK UNIFIED IDEOGRAPH
	{0x529B,	0xA44F},	// CJK UNIFIED IDEOGRAPH
	{0x529F,	0xA55C},	// CJK UNIFIED IDEOGRAPH
	{0x52A0,	0xA55B},	// CJK UNIFIED IDEOGRAPH
	{0x52A3,	0xA648},	// CJK UNIFIED IDEOGRAPH
	{0x52A6,	0xC9C0},	// CJK UNIFIED IDEOGRAPH
	{0x52A9,	0xA755},	// CJK UNIFIED IDEOGRAPH
	{0x52AA,	0xA756},	// CJK UNIFIED IDEOGRAPH
	{0x52AB,	0xA754},	// CJK UNIFIED IDEOGRAPH
	{0x52AC,	0xA757},	// CJK UNIFIED IDEOGRAPH
	{0x52AD,	0xCA6F},	// CJK UNIFIED IDEOGRAPH
	{0x52AE,	0xCA70},	// CJK UNIFIED IDEOGRAPH
	{0x52BB,	0xA8F1},	// CJK UNIFIED IDEOGRAPH
	{0x52BC,	0xCBD5},	// CJK UNIFIED IDEOGRAPH
	{0x52BE,	0xA8F0},	// CJK UNIFIED IDEOGRAPH
	{0x52C0,	0xCDF2},	// CJK UNIFIED IDEOGRAPH
	{0x52C1,	0xAB6C},	// CJK UNIFIED IDEOGRAPH
	{0x52C2,	0xCDF3},	// CJK UNIFIED IDEOGRAPH
	{0x52C3,	0xAB6B},	// CJK UNIFIED IDEOGRAPH
	{0x52C7,	0xAB69},	// CJK UNIFIED IDEOGRAPH
	{0x52C9,	0xAB6A},	// CJK UNIFIED IDEOGRAPH
	{0x52CD,	0xD0ED},	// CJK UNIFIED IDEOGRAPH
	{0x52D2,	0xB0C7},	// CJK UNIFIED IDEOGRAPH
	{0x52D3,	0xD46E},	// CJK UNIFIED IDEOGRAPH
	{0x52D5,	0xB0CA},	// CJK UNIFIED IDEOGRAPH
	{0x52D6,	0xD46D},	// CJK UNIFIED IDEOGRAPH
	{0x52D7,	0xB1E5},	// CJK UNIFIED IDEOGRAPH
	{0x52D8,	0xB0C9},	// CJK UNIFIED IDEOGRAPH
	{0x52D9,	0xB0C8},	// CJK UNIFIED IDEOGRAPH
	{0x52DB,	0xB3D4},	// CJK UNIFIED IDEOGRAPH
	{0x52DD,	0xB3D3},	// CJK UNIFIED IDEOGRAPH
	{0x52DE,	0xB3D2},	// CJK UNIFIED IDEOGRAPH
	{0x52DF,	0xB6D2},	// CJK UNIFIED IDEOGRAPH
	{0x52E2,	0xB6D5},	// CJK UNIFIED IDEOGRAPH
	{0x52E3,	0xB6D6},	// CJK UNIFIED IDEOGRAPH
	{0x52E4,	0xB6D4},	// CJK UNIFIED IDEOGRAPH
	{0x52E6,	0xB6D3},	// CJK UNIFIED IDEOGRAPH
	{0x52E9,	0xE143},	// CJK UNIFIED IDEOGRAPH
	{0x52EB,	0xE144},	// CJK UNIFIED IDEOGRAPH
	{0x52EF,	0xE4F5},	// CJK UNIFIED IDEOGRAPH
	{0x52F0,	0xBC45},	// CJK UNIFIED IDEOGRAPH
	{0x52F1,	0xE4F4},	// CJK UNIFIED IDEOGRAPH
	{0x52F3,	0xBEB1},	// CJK UNIFIED IDEOGRAPH
	{0x52F4,	0xECBF},	// CJK UNIFIED IDEOGRAPH
	{0x52F5,	0xC079},	// CJK UNIFIED IDEOGRAPH
	{0x52F7,	0xF1EE},	// CJK UNIFIED IDEOGRAPH
	{0x52F8,	0xC455},	// CJK UNIFIED IDEOGRAPH
	{0x52FA,	0xA463},	// CJK UNIFIED IDEOGRAPH
	{0x52FB,	0xA4C3},	// CJK UNIFIED IDEOGRAPH
	{0x52FC,	0xC956},	// CJK UNIFIED IDEOGRAPH
	{0x52FE,	0xA4C4},	// CJK UNIFIED IDEOGRAPH
	{0x52FF,	0xA4C5},	// CJK UNIFIED IDEOGRAPH
	{0x5305,	0xA55D},	// CJK UNIFIED IDEOGRAPH
	{0x5306,	0xA55E},	// CJK UNIFIED IDEOGRAPH
	{0x5308,	0xA649},	// CJK UNIFIED IDEOGRAPH
	{0x5309,	0xCA71},	// CJK UNIFIED IDEOGRAPH
	{0x530A,	0xCBD6},	// CJK UNIFIED IDEOGRAPH
	{0x530B,	0xCBD7},	// CJK UNIFIED IDEOGRAPH
	{0x530D,	0xAB6D},	// CJK UNIFIED IDEOGRAPH
	{0x530E,	0xD0EE},	// CJK UNIFIED IDEOGRAPH
	{0x530F,	0xB0CC},	// CJK UNIFIED IDEOGRAPH
	{0x5310,	0xB0CB},	// CJK UNIFIED IDEOGRAPH
	{0x5311,	0xD863},	// CJK UNIFIED IDEOGRAPH
	{0x5312,	0xD862},	// CJK UNIFIED IDEOGRAPH
	{0x5315,	0xA450},	// CJK UNIFIED IDEOGRAPH
	{0x5316,	0xA4C6},	// CJK UNIFIED IDEOGRAPH
	{0x5317,	0xA55F},	// CJK UNIFIED IDEOGRAPH
	{0x5319,	0xB0CD},	// CJK UNIFIED IDEOGRAPH
	{0x531A,	0xC943},	// CJK UNIFIED IDEOGRAPH
	{0x531C,	0xC96C},	// CJK UNIFIED IDEOGRAPH
	{0x531D,	0xA560},	// CJK UNIFIED IDEOGRAPH
	{0x531F,	0xC9C2},	// CJK UNIFIED IDEOGRAPH
	{0x5320,	0xA64B},	// CJK UNIFIED IDEOGRAPH
	{0x5321,	0xA64A},	// CJK UNIFIED IDEOGRAPH
	{0x5322,	0xC9C1},	// CJK UNIFIED IDEOGRAPH
	{0x5323,	0xA758},	// CJK UNIFIED IDEOGRAPH
	{0x532A,	0xADEA},	// CJK UNIFIED IDEOGRAPH
	{0x532D,	0xD46F},	// CJK UNIFIED IDEOGRAPH
	{0x532F,	0xB6D7},	// CJK UNIFIED IDEOGRAPH
	{0x5330,	0xE145},	// CJK UNIFIED IDEOGRAPH
	{0x5331,	0xB9BC},	// CJK UNIFIED IDEOGRAPH
	{0x5334,	0xE8FA},	// CJK UNIFIED IDEOGRAPH
	{0x5337,	0xF3FD},	// CJK UNIFIED IDEOGRAPH
	{0x5339,	0xA4C7},	// CJK UNIFIED IDEOGRAPH
	{0x533C,	0xCBD8},	// CJK UNIFIED IDEOGRAPH
	{0x533D,	0xCDF4},	// CJK UNIFIED IDEOGRAPH
	{0x533E,	0xB0D0},	// CJK UNIFIED IDEOGRAPH
	{0x533F,	0xB0CE},	// CJK UNIFIED IDEOGRAPH
	{0x5340,	0xB0CF},	// CJK UNIFIED IDEOGRAPH
	{0x5341,	0xA451},	// CJK UNIFIED IDEOGRAPH
	{0x5343,	0xA464},	// CJK UNIFIED IDEOGRAPH
	{0x5344,	0xA2CD},	// CJK UNIFIED IDEOGRAPH
	{0x5345,	0xA4CA},	// CJK UNIFIED IDEOGRAPH
	{0x5347,	0xA4C9},	// CJK UNIFIED IDEOGRAPH
	{0x5348,	0xA4C8},	// CJK UNIFIED IDEOGRAPH
	{0x5349,	0xA563},	// CJK UNIFIED IDEOGRAPH
	{0x534A,	0xA562},	// CJK UNIFIED IDEOGRAPH
	{0x534C,	0xC96D},	// CJK UNIFIED IDEOGRAPH
	{0x534D,	0xC9C3},	// CJK UNIFIED IDEOGRAPH
	{0x5351,	0xA8F5},	// CJK UNIFIED IDEOGRAPH
	{0x5352,	0xA8F2},	// CJK UNIFIED IDEOGRAPH
	{0x5353,	0xA8F4},	// CJK UNIFIED IDEOGRAPH
	{0x5354,	0xA8F3},	// CJK UNIFIED IDEOGRAPH
	{0x5357,	0xAB6E},	// CJK UNIFIED IDEOGRAPH
	{0x535A,	0xB3D5},	// CJK UNIFIED IDEOGRAPH
	{0x535C,	0xA452},	// CJK UNIFIED IDEOGRAPH
	{0x535E,	0xA4CB},	// CJK UNIFIED IDEOGRAPH
	{0x5360,	0xA565},	// CJK UNIFIED IDEOGRAPH
	{0x5361,	0xA564},	// CJK UNIFIED IDEOGRAPH
	{0x5363,	0xCA72},	// CJK UNIFIED IDEOGRAPH
	{0x5366,	0xA8F6},	// CJK UNIFIED IDEOGRAPH
	{0x536C,	0xC957},	// CJK UNIFIED IDEOGRAPH
	{0x536E,	0xA567},	// CJK UNIFIED IDEOGRAPH
	{0x536F,	0xA566},	// CJK UNIFIED IDEOGRAPH
	{0x5370,	0xA64C},	// CJK UNIFIED IDEOGRAPH
	{0x5371,	0xA64D},	// CJK UNIFIED IDEOGRAPH
	{0x5372,	0xCA73},	// CJK UNIFIED IDEOGRAPH
	{0x5373,	0xA759},	// CJK UNIFIED IDEOGRAPH
	{0x5375,	0xA75A},	// CJK UNIFIED IDEOGRAPH
	{0x5377,	0xA8F7},	// CJK UNIFIED IDEOGRAPH
	{0x5378,	0xA8F8},	// CJK UNIFIED IDEOGRAPH
	{0x5379,	0xA8F9},	// CJK UNIFIED IDEOGRAPH
	{0x537B,	0xAB6F},	// CJK UNIFIED IDEOGRAPH
	{0x537C,	0xCDF5},	// CJK UNIFIED IDEOGRAPH
	{0x537F,	0xADEB},	// CJK UNIFIED IDEOGRAPH
	{0x5382,	0xC944},	// CJK UNIFIED IDEOGRAPH
	{0x5384,	0xA4CC},	// CJK UNIFIED IDEOGRAPH
	{0x538A,	0xC9C4},	// CJK UNIFIED IDEOGRAPH
	{0x538E,	0xCA74},	// CJK UNIFIED IDEOGRAPH
	{0x538F,	0xCA75},	// CJK UNIFIED IDEOGRAPH
	{0x5392,	0xCBD9},	// CJK UNIFIED IDEOGRAPH
	{0x5394,	0xCBDA},	// CJK UNIFIED IDEOGRAPH
	{0x5396,	0xCDF7},	// CJK UNIFIED IDEOGRAPH
	{0x5397,	0xCDF6},	// CJK UNIFIED IDEOGRAPH
	{0x5398,	0xCDF9},	// CJK UNIFIED IDEOGRAPH
	{0x5399,	0xCDF8},	// CJK UNIFIED IDEOGRAPH
	{0x539A,	0xAB70},	// CJK UNIFIED IDEOGRAPH
	{0x539C,	0xD470},	// CJK UNIFIED IDEOGRAPH
	{0x539D,	0xADED},	// CJK UNIFIED IDEOGRAPH
	{0x539E,	0xD0EF},	// CJK UNIFIED IDEOGRAPH
	{0x539F,	0xADEC},	// CJK UNIFIED IDEOGRAPH
	{0x53A4,	0xD864},	// CJK UNIFIED IDEOGRAPH
	{0x53A5,	0xB3D6},	// CJK UNIFIED IDEOGRAPH
	{0x53A7,	0xD865},	// CJK UNIFIED IDEOGRAPH
	{0x53AC,	0xE146},	// CJK UNIFIED IDEOGRAPH
	{0x53AD,	0xB9BD},	// CJK UNIFIED IDEOGRAPH
	{0x53B2,	0xBC46},	// CJK UNIFIED IDEOGRAPH
	{0x53B4,	0xF1EF},	// CJK UNIFIED IDEOGRAPH
	{0x53B9,	0xC958},	// CJK UNIFIED IDEOGRAPH
	{0x53BB,	0xA568},	// CJK UNIFIED IDEOGRAPH
	{0x53C3,	0xB0D1},	// CJK UNIFIED IDEOGRAPH
	{0x53C8,	0xA453},	// CJK UNIFIED IDEOGRAPH
	{0x53C9,	0xA465},	// CJK UNIFIED IDEOGRAPH
	{0x53CA,	0xA4CE},	// CJK UNIFIED IDEOGRAPH
	{0x53CB,	0xA4CD},	// CJK UNIFIED IDEOGRAPH
	{0x53CD,	0xA4CF},	// CJK UNIFIED IDEOGRAPH
	{0x53D4,	0xA8FB},	// CJK UNIFIED IDEOGRAPH
	{0x53D6,	0xA8FA},	// CJK UNIFIED IDEOGRAPH
	{0x53D7,	0xA8FC},	// CJK UNIFIED IDEOGRAPH
	{0x53DB,	0xAB71},	// CJK UNIFIED IDEOGRAPH
	{0x53DF,	0xADEE},	// CJK UNIFIED IDEOGRAPH
	{0x53E1,	0xE8FB},	// CJK UNIFIED IDEOGRAPH
	{0x53E2,	0xC24F},	// CJK UNIFIED IDEOGRAPH
	{0x53E3,	0xA466},	// CJK UNIFIED IDEOGRAPH
	{0x53E4,	0xA56A},	// CJK UNIFIED IDEOGRAPH
	{0x53E5,	0xA579},	// CJK UNIFIED IDEOGRAPH
	{0x53E6,	0xA574},	// CJK UNIFIED IDEOGRAPH
	{0x53E8,	0xA56F},	// CJK UNIFIED IDEOGRAPH
	{0x53E9,	0xA56E},	// CJK UNIFIED IDEOGRAPH
	{0x53EA,	0xA575},	// CJK UNIFIED IDEOGRAPH
	{0x53EB,	0xA573},	// CJK UNIFIED IDEOGRAPH
	{0x53EC,	0xA56C},	// CJK UNIFIED IDEOGRAPH
	{0x53ED,	0xA57A},	// CJK UNIFIED IDEOGRAPH
	{0x53EE,	0xA56D},	// CJK UNIFIED IDEOGRAPH
	{0x53EF,	0xA569},	// CJK UNIFIED IDEOGRAPH
	{0x53F0,	0xA578},	// CJK UNIFIED IDEOGRAPH
	{0x53F1,	0xA577},	// CJK UNIFIED IDEOGRAPH
	{0x53F2,	0xA576},	// CJK UNIFIED IDEOGRAPH
	{0x53F3,	0xA56B},	// CJK UNIFIED IDEOGRAPH
	{0x53F5,	0xA572},	// CJK UNIFIED IDEOGRAPH
	{0x53F8,	0xA571},	// CJK UNIFIED IDEOGRAPH
	{0x53FB,	0xA57B},	// CJK UNIFIED IDEOGRAPH
	{0x53FC,	0xA570},	// CJK UNIFIED IDEOGRAPH
	{0x5401,	0xA653},	// CJK UNIFIED IDEOGRAPH
	{0x5403,	0xA659},	// CJK UNIFIED IDEOGRAPH
	{0x5404,	0xA655},	// CJK UNIFIED IDEOGRAPH
	{0x5406,	0xA65B},	// CJK UNIFIED IDEOGRAPH
	{0x5407,	0xC9C5},	// CJK UNIFIED IDEOGRAPH
	{0x5408,	0xA658},	// CJK UNIFIED IDEOGRAPH
	{0x5409,	0xA64E},	// CJK UNIFIED IDEOGRAPH
	{0x540A,	0xA651},	// CJK UNIFIED IDEOGRAPH
	{0x540B,	0xA654},	// CJK UNIFIED IDEOGRAPH
	{0x540C,	0xA650},	// CJK UNIFIED IDEOGRAPH
	{0x540D,	0xA657},	// CJK UNIFIED IDEOGRAPH
	{0x540E,	0xA65A},	// CJK UNIFIED IDEOGRAPH
	{0x540F,	0xA64F},	// CJK UNIFIED IDEOGRAPH
	{0x5410,	0xA652},	// CJK UNIFIED IDEOGRAPH
	{0x5411,	0xA656},	// CJK UNIFIED IDEOGRAPH
	{0x5412,	0xA65C},	// CJK UNIFIED IDEOGRAPH
	{0x5418,	0xCA7E},	// CJK UNIFIED IDEOGRAPH
	{0x5419,	0xCA7B},	// CJK UNIFIED IDEOGRAPH
	{0x541B,	0xA767},	// CJK UNIFIED IDEOGRAPH
	{0x541C,	0xCA7C},	// CJK UNIFIED IDEOGRAPH
	{0x541D,	0xA75B},	// CJK UNIFIED IDEOGRAPH
	{0x541E,	0xA75D},	// CJK UNIFIED IDEOGRAPH
	{0x541F,	0xA775},	// CJK UNIFIED IDEOGRAPH
	{0x5420,	0xA770},	// CJK UNIFIED IDEOGRAPH
	{0x5424,	0xCAA5},	// CJK UNIFIED IDEOGRAPH
	{0x5425,	0xCA7D},	// CJK UNIFIED IDEOGRAPH
	{0x5426,	0xA75F},	// CJK UNIFIED IDEOGRAPH
	{0x5427,	0xA761},	// CJK UNIFIED IDEOGRAPH
	{0x5428,	0xCAA4},	// CJK UNIFIED IDEOGRAPH
	{0x5429,	0xA768},	// CJK UNIFIED IDEOGRAPH
	{0x542A,	0xCA78},	// CJK UNIFIED IDEOGRAPH
	{0x542B,	0xA774},	// CJK UNIFIED IDEOGRAPH
	{0x542C,	0xA776},	// CJK UNIFIED IDEOGRAPH
	{0x542D,	0xA75C},	// CJK UNIFIED IDEOGRAPH
	{0x542E,	0xA76D},	// CJK UNIFIED IDEOGRAPH
	{0x5430,	0xCA76},	// CJK UNIFIED IDEOGRAPH
	{0x5431,	0xA773},	// CJK UNIFIED IDEOGRAPH
	{0x5433,	0xA764},	// CJK UNIFIED IDEOGRAPH
	{0x5435,	0xA76E},	// CJK UNIFIED IDEOGRAPH
	{0x5436,	0xA76F},	// CJK UNIFIED IDEOGRAPH
	{0x5437,	0xCA77},	// CJK UNIFIED IDEOGRAPH
	{0x5438,	0xA76C},	// CJK UNIFIED IDEOGRAPH
	{0x5439,	0xA76A},	// CJK UNIFIED IDEOGRAPH
	{0x543B,	0xA76B},	// CJK UNIFIED IDEOGRAPH
	{0x543C,	0xA771},	// CJK UNIFIED IDEOGRAPH
	{0x543D,	0xCAA1},	// CJK UNIFIED IDEOGRAPH
	{0x543E,	0xA75E},	// CJK UNIFIED IDEOGRAPH
	{0x5440,	0xA772},	// CJK UNIFIED IDEOGRAPH
	{0x5441,	0xCAA3},	// CJK UNIFIED IDEOGRAPH
	{0x5442,	0xA766},	// CJK UNIFIED IDEOGRAPH
	{0x5443,	0xA763},	// CJK UNIFIED IDEOGRAPH
	{0x5445,	0xCA7A},	// CJK UNIFIED IDEOGRAPH
	{0x5446,	0xA762},	// CJK UNIFIED IDEOGRAPH
	{0x5447,	0xCAA6},	// CJK UNIFIED IDEOGRAPH
	{0x5448,	0xA765},	// CJK UNIFIED IDEOGRAPH
	{0x544A,	0xA769},	// CJK UNIFIED IDEOGRAPH
	{0x544E,	0xA760},	// CJK UNIFIED IDEOGRAPH
	{0x544F,	0xCAA2},	// CJK UNIFIED IDEOGRAPH
	{0x5454,	0xCA79},	// CJK UNIFIED IDEOGRAPH
	{0x5460,	0xCBEB},	// CJK UNIFIED IDEOGRAPH
	{0x5461,	0xCBEA},	// CJK UNIFIED IDEOGRAPH
	{0x5462,	0xA94F},	// CJK UNIFIED IDEOGRAPH
	{0x5463,	0xCBED},	// CJK UNIFIED IDEOGRAPH
	{0x5464,	0xCBEF},	// CJK UNIFIED IDEOGRAPH
	{0x5465,	0xCBE4},	// CJK UNIFIED IDEOGRAPH
	{0x5466,	0xCBE7},	// CJK UNIFIED IDEOGRAPH
	{0x5467,	0xCBEE},	// CJK UNIFIED IDEOGRAPH
	{0x5468,	0xA950},	// CJK UNIFIED IDEOGRAPH
	{0x546B,	0xCBE1},	// CJK UNIFIED IDEOGRAPH
	{0x546C,	0xCBE5},	// CJK UNIFIED IDEOGRAPH
	{0x546F,	0xCBE9},	// CJK UNIFIED IDEOGRAPH
	{0x5470,	0xCE49},	// CJK UNIFIED IDEOGRAPH
	{0x5471,	0xA94B},	// CJK UNIFIED IDEOGRAPH
	{0x5472,	0xCE4D},	// CJK UNIFIED IDEOGRAPH
	{0x5473,	0xA8FD},	// CJK UNIFIED IDEOGRAPH
	{0x5474,	0xCBE6},	// CJK UNIFIED IDEOGRAPH
	{0x5475,	0xA8FE},	// CJK UNIFIED IDEOGRAPH
	{0x5476,	0xA94C},	// CJK UNIFIED IDEOGRAPH
	{0x5477,	0xA945},	// CJK UNIFIED IDEOGRAPH
	{0x5478,	0xA941},	// CJK UNIFIED IDEOGRAPH
	{0x547A,	0xCBE2},	// CJK UNIFIED IDEOGRAPH
	{0x547B,	0xA944},	// CJK UNIFIED IDEOGRAPH
	{0x547C,	0xA949},	// CJK UNIFIED IDEOGRAPH
	{0x547D,	0xA952},	// CJK UNIFIED IDEOGRAPH
	{0x547E,	0xCBE3},	// CJK UNIFIED IDEOGRAPH
	{0x547F,	0xCBDC},	// CJK UNIFIED IDEOGRAPH
	{0x5480,	0xA943},	// CJK UNIFIED IDEOGRAPH
	{0x5481,	0xCBDD},	// CJK UNIFIED IDEOGRAPH
	{0x5482,	0xCBDF},	// CJK UNIFIED IDEOGRAPH
	{0x5484,	0xA946},	// CJK UNIFIED IDEOGRAPH
	{0x5486,	0xA948},	// CJK UNIFIED IDEOGRAPH
	{0x5487,	0xCBDB},	// CJK UNIFIED IDEOGRAPH
	{0x5488,	0xCBE0},	// CJK UNIFIED IDEOGRAPH
	{0x548B,	0xA951},	// CJK UNIFIED IDEOGRAPH
	{0x548C,	0xA94D},	// CJK UNIFIED IDEOGRAPH
	{0x548D,	0xCBE8},	// CJK UNIFIED IDEOGRAPH
	{0x548E,	0xA953},	// CJK UNIFIED IDEOGRAPH
	{0x5490,	0xA94A},	// CJK UNIFIED IDEOGRAPH
	{0x5491,	0xCBDE},	// CJK UNIFIED IDEOGRAPH
	{0x5492,	0xA947},	// CJK UNIFIED IDEOGRAPH
	{0x5495,	0xA942},	// CJK UNIFIED IDEOGRAPH
	{0x5496,	0xA940},	// CJK UNIFIED IDEOGRAPH
	{0x5498,	0xCBEC},	// CJK UNIFIED IDEOGRAPH
	{0x549A,	0xA94E},	// CJK UNIFIED IDEOGRAPH
	{0x54A0,	0xCE48},	// CJK UNIFIED IDEOGRAPH
	{0x54A1,	0xCDFB},	// CJK UNIFIED IDEOGRAPH
	{0x54A2,	0xCE4B},	// CJK UNIFIED IDEOGRAPH
	{0x54A5,	0xCDFD},	// CJK UNIFIED IDEOGRAPH
	{0x54A6,	0xAB78},	// CJK UNIFIED IDEOGRAPH
	{0x54A7,	0xABA8},	// CJK UNIFIED IDEOGRAPH
	{0x54A8,	0xAB74},	// CJK UNIFIED IDEOGRAPH
	{0x54A9,	0xABA7},	// CJK UNIFIED IDEOGRAPH
	{0x54AA,	0xAB7D},	// CJK UNIFIED IDEOGRAPH
	{0x54AB,	0xABA4},	// CJK UNIFIED IDEOGRAPH
	{0x54AC,	0xAB72},	// CJK UNIFIED IDEOGRAPH
	{0x54AD,	0xCDFC},	// CJK UNIFIED IDEOGRAPH
	{0x54AE,	0xCE43},	// CJK UNIFIED IDEOGRAPH
	{0x54AF,	0xABA3},	// CJK UNIFIED IDEOGRAPH
	{0x54B0,	0xCE4F},	// CJK UNIFIED IDEOGRAPH
	{0x54B1,	0xABA5},	// CJK UNIFIED IDEOGRAPH
	{0x54B3,	0xAB79},	// CJK UNIFIED IDEOGRAPH
	{0x54B6,	0xCE45},	// CJK UNIFIED IDEOGRAPH
	{0x54B7,	0xCE42},	// CJK UNIFIED IDEOGRAPH
	{0x54B8,	0xAB77},	// CJK UNIFIED IDEOGRAPH
	{0x54BA,	0xCDFA},	// CJK UNIFIED IDEOGRAPH
	{0x54BB,	0xABA6},	// CJK UNIFIED IDEOGRAPH
	{0x54BC,	0xCE4A},	// CJK UNIFIED IDEOGRAPH
	{0x54BD,	0xAB7C},	// CJK UNIFIED IDEOGRAPH
	{0x54BE,	0xCE4C},	// CJK UNIFIED IDEOGRAPH
	{0x54BF,	0xABA9},	// CJK UNIFIED IDEOGRAPH
	{0x54C0,	0xAB73},	// CJK UNIFIED IDEOGRAPH
	{0x54C1,	0xAB7E},	// CJK UNIFIED IDEOGRAPH
	{0x54C2,	0xAB7B},	// CJK UNIFIED IDEOGRAPH
	{0x54C3,	0xCE40},	// CJK UNIFIED IDEOGRAPH
	{0x54C4,	0xABA1},	// CJK UNIFIED IDEOGRAPH
	{0x54C5,	0xCE46},	// CJK UNIFIED IDEOGRAPH
	{0x54C6,	0xCE47},	// CJK UNIFIED IDEOGRAPH
	{0x54C7,	0xAB7A},	// CJK UNIFIED IDEOGRAPH
	{0x54C8,	0xABA2},	// CJK UNIFIED IDEOGRAPH
	{0x54C9,	0xAB76},	// CJK UNIFIED IDEOGRAPH
	{0x54CE,	0xAB75},	// CJK UNIFIED IDEOGRAPH
	{0x54CF,	0xCDFE},	// CJK UNIFIED IDEOGRAPH
	{0x54D6,	0xCE44},	// CJK UNIFIED IDEOGRAPH
	{0x54DE,	0xCE4E},	// CJK UNIFIED IDEOGRAPH
	{0x54E0,	0xD144},	// CJK UNIFIED IDEOGRAPH
	{0x54E1,	0xADFB},	// CJK UNIFIED IDEOGRAPH
	{0x54E2,	0xD0F1},	// CJK UNIFIED IDEOGRAPH
	{0x54E4,	0xD0F6},	// CJK UNIFIED IDEOGRAPH
	{0x54E5,	0xADF4},	// CJK UNIFIED IDEOGRAPH
	{0x54E6,	0xAE40},	// CJK UNIFIED IDEOGRAPH
	{0x54E7,	0xD0F4},	// CJK UNIFIED IDEOGRAPH
	{0x54E8,	0xADEF},	// CJK UNIFIED IDEOGRAPH
	{0x54E9,	0xADF9},	// CJK UNIFIED IDEOGRAPH
	{0x54EA,	0xADFE},	// CJK UNIFIED IDEOGRAPH
	{0x54EB,	0xD0FB},	// CJK UNIFIED IDEOGRAPH
	{0x54ED,	0xADFA},	// CJK UNIFIED IDEOGRAPH
	{0x54EE,	0xADFD},	// CJK UNIFIED IDEOGRAPH
	{0x54F1,	0xD0FE},	// CJK UNIFIED IDEOGRAPH
	{0x54F2,	0xADF5},	// CJK UNIFIED IDEOGRAPH
	{0x54F3,	0xD0F5},	// CJK UNIFIED IDEOGRAPH
	{0x54F7,	0xD142},	// CJK UNIFIED IDEOGRAPH
	{0x54F8,	0xD143},	// CJK UNIFIED IDEOGRAPH
	{0x54FA,	0xADF7},	// CJK UNIFIED IDEOGRAPH
	{0x54FB,	0xD141},	// CJK UNIFIED IDEOGRAPH
	{0x54FC,	0xADF3},	// CJK UNIFIED IDEOGRAPH
	{0x54FD,	0xAE43},	// CJK UNIFIED IDEOGRAPH
	{0x54FF,	0xD0F8},	// CJK UNIFIED IDEOGRAPH
	{0x5501,	0xADF1},	// CJK UNIFIED IDEOGRAPH
	{0x5503,	0xD146},	// CJK UNIFIED IDEOGRAPH
	{0x5504,	0xD0F9},	// CJK UNIFIED IDEOGRAPH
	{0x5505,	0xD0FD},	// CJK UNIFIED IDEOGRAPH
	{0x5506,	0xADF6},	// CJK UNIFIED IDEOGRAPH
	{0x5507,	0xAE42},	// CJK UNIFIED IDEOGRAPH
	{0x5508,	0xD0FA},	// CJK UNIFIED IDEOGRAPH
	{0x5509,	0xADFC},	// CJK UNIFIED IDEOGRAPH
	{0x550A,	0xD140},	// CJK UNIFIED IDEOGRAPH
	{0x550B,	0xD147},	// CJK UNIFIED IDEOGRAPH
	{0x550C,	0xD4A1},	// CJK UNIFIED IDEOGRAPH
	{0x550E,	0xD145},	// CJK UNIFIED IDEOGRAPH
	{0x550F,	0xAE44},	// CJK UNIFIED IDEOGRAPH
	{0x5510,	0xADF0},	// CJK UNIFIED IDEOGRAPH
	{0x5511,	0xD0FC},	// CJK UNIFIED IDEOGRAPH
	{0x5512,	0xD0F3},	// CJK UNIFIED IDEOGRAPH
	{0x5514,	0xADF8},	// CJK UNIFIED IDEOGRAPH
	{0x5517,	0xD0F2},	// CJK UNIFIED IDEOGRAPH
	{0x551A,	0xD0F7},	// CJK UNIFIED IDEOGRAPH
	{0x5526,	0xD0F0},	// CJK UNIFIED IDEOGRAPH
	{0x5527,	0xAE41},	// CJK UNIFIED IDEOGRAPH
	{0x552A,	0xD477},	// CJK UNIFIED IDEOGRAPH
	{0x552C,	0xB0E4},	// CJK UNIFIED IDEOGRAPH
	{0x552D,	0xD4A7},	// CJK UNIFIED IDEOGRAPH
	{0x552E,	0xB0E2},	// CJK UNIFIED IDEOGRAPH
	{0x552F,	0xB0DF},	// CJK UNIFIED IDEOGRAPH
	{0x5530,	0xD47C},	// CJK UNIFIED IDEOGRAPH
	{0x5531,	0xB0DB},	// CJK UNIFIED IDEOGRAPH
	{0x5532,	0xD4A2},	// CJK UNIFIED IDEOGRAPH
	{0x5533,	0xB0E6},	// CJK UNIFIED IDEOGRAPH
	{0x5534,	0xD476},	// CJK UNIFIED IDEOGRAPH
	{0x5535,	0xD47B},	// CJK UNIFIED IDEOGRAPH
	{0x5536,	0xD47A},	// CJK UNIFIED IDEOGRAPH
	{0x5537,	0xADF2},	// CJK UNIFIED IDEOGRAPH
	{0x5538,	0xB0E1},	// CJK UNIFIED IDEOGRAPH
	{0x5539,	0xD4A5},	// CJK UNIFIED IDEOGRAPH
	{0x553B,	0xD4A8},	// CJK UNIFIED IDEOGRAPH
	{0x553C,	0xD473},	// CJK UNIFIED IDEOGRAPH
	{0x553E,	0xB3E8},	// CJK UNIFIED IDEOGRAPH
	{0x5540,	0xD4A9},	// CJK UNIFIED IDEOGRAPH
	{0x5541,	0xB0E7},	// CJK UNIFIED IDEOGRAPH
	{0x5543,	0xB0D9},	// CJK UNIFIED IDEOGRAPH
	{0x5544,	0xB0D6},	// CJK UNIFIED IDEOGRAPH
	{0x5545,	0xD47E},	// CJK UNIFIED IDEOGRAPH
	{0x5546,	0xB0D3},	// CJK UNIFIED IDEOGRAPH
	{0x5548,	0xD4A6},	// CJK UNIFIED IDEOGRAPH
	{0x554A,	0xB0DA},	// CJK UNIFIED IDEOGRAPH
	{0x554B,	0xD4AA},	// CJK UNIFIED IDEOGRAPH
	{0x554D,	0xD474},	// CJK UNIFIED IDEOGRAPH
	{0x554E,	0xD4A4},	// CJK UNIFIED IDEOGRAPH
	{0x554F,	0xB0DD},	// CJK UNIFIED IDEOGRAPH
	{0x5550,	0xD475},	// CJK UNIFIED IDEOGRAPH
	{0x5551,	0xD478},	// CJK UNIFIED IDEOGRAPH
	{0x5552,	0xD47D},	// CJK UNIFIED IDEOGRAPH
	{0x5555,	0xB0DE},	// CJK UNIFIED IDEOGRAPH
	{0x5556,	0xB0DC},	// CJK UNIFIED IDEOGRAPH
	{0x5557,	0xB0E8},	// CJK UNIFIED IDEOGRAPH
	{0x555C,	0xB0E3},	// CJK UNIFIED IDEOGRAPH
	{0x555E,	0xB0D7},	// CJK UNIFIED IDEOGRAPH
	{0x555F,	0xB1D2},	// CJK UNIFIED IDEOGRAPH
	{0x5561,	0xB0D8},	// CJK UNIFIED IDEOGRAPH
	{0x5562,	0xD479},	// CJK UNIFIED IDEOGRAPH
	{0x5563,	0xB0E5},	// CJK UNIFIED IDEOGRAPH
	{0x5564,	0xB0E0},	// CJK UNIFIED IDEOGRAPH
	{0x5565,	0xD4A3},	// CJK UNIFIED IDEOGRAPH
	{0x5566,	0xB0D5},	// CJK UNIFIED IDEOGRAPH
	{0x556A,	0xB0D4},	// CJK UNIFIED IDEOGRAPH
	{0x5575,	0xD471},	// CJK UNIFIED IDEOGRAPH
	{0x5576,	0xD472},	// CJK UNIFIED IDEOGRAPH
	{0x5577,	0xD86A},	// CJK UNIFIED IDEOGRAPH
	{0x557B,	0xB3D7},	// CJK UNIFIED IDEOGRAPH
	{0x557C,	0xB3DA},	// CJK UNIFIED IDEOGRAPH
	{0x557D,	0xD875},	// CJK UNIFIED IDEOGRAPH
	{0x557E,	0xB3EE},	// CJK UNIFIED IDEOGRAPH
	{0x557F,	0xD878},	// CJK UNIFIED IDEOGRAPH
	{0x5580,	0xB3D8},	// CJK UNIFIED IDEOGRAPH
	{0x5581,	0xD871},	// CJK UNIFIED IDEOGRAPH
	{0x5582,	0xB3DE},	// CJK UNIFIED IDEOGRAPH
	{0x5583,	0xB3E4},	// CJK UNIFIED IDEOGRAPH
	{0x5584,	0xB5BD},	// CJK UNIFIED IDEOGRAPH
	{0x5587,	0xB3E2},	// CJK UNIFIED IDEOGRAPH
	{0x5588,	0xD86E},	// CJK UNIFIED IDEOGRAPH
	{0x5589,	0xB3EF},	// CJK UNIFIED IDEOGRAPH
	{0x558A,	0xB3DB},	// CJK UNIFIED IDEOGRAPH
	{0x558B,	0xB3E3},	// CJK UNIFIED IDEOGRAPH
	{0x558C,	0xD876},	// CJK UNIFIED IDEOGRAPH
	{0x558D,	0xDCD7},	// CJK UNIFIED IDEOGRAPH
	{0x558E,	0xD87B},	// CJK UNIFIED IDEOGRAPH
	{0x558F,	0xD86F},	// CJK UNIFIED IDEOGRAPH
	{0x5591,	0xD866},	// CJK UNIFIED IDEOGRAPH
	{0x5592,	0xD873},	// CJK UNIFIED IDEOGRAPH
	{0x5593,	0xD86D},	// CJK UNIFIED IDEOGRAPH
	{0x5594,	0xB3E1},	// CJK UNIFIED IDEOGRAPH
	{0x5595,	0xD879},	// CJK UNIFIED IDEOGRAPH
	{0x5598,	0xB3DD},	// CJK UNIFIED IDEOGRAPH
	{0x5599,	0xB3F1},	// CJK UNIFIED IDEOGRAPH
	{0x559A,	0xB3EA},	// CJK UNIFIED IDEOGRAPH
	{0x559C,	0xB3DF},	// CJK UNIFIED IDEOGRAPH
	{0x559D,	0xB3DC},	// CJK UNIFIED IDEOGRAPH
	{0x559F,	0xB3E7},	// CJK UNIFIED IDEOGRAPH
	{0x55A1,	0xD87A},	// CJK UNIFIED IDEOGRAPH
	{0x55A2,	0xD86C},	// CJK UNIFIED IDEOGRAPH
	{0x55A3,	0xD872},	// CJK UNIFIED IDEOGRAPH
	{0x55A4,	0xD874},	// CJK UNIFIED IDEOGRAPH
	{0x55A5,	0xD868},	// CJK UNIFIED IDEOGRAPH
	{0x55A6,	0xD877},	// CJK UNIFIED IDEOGRAPH
	{0x55A7,	0xB3D9},	// CJK UNIFIED IDEOGRAPH
	{0x55A8,	0xD867},	// CJK UNIFIED IDEOGRAPH
	{0x55AA,	0xB3E0},	// CJK UNIFIED IDEOGRAPH
	{0x55AB,	0xB3F0},	// CJK UNIFIED IDEOGRAPH
	{0x55AC,	0xB3EC},	// CJK UNIFIED IDEOGRAPH
	{0x55AD,	0xD869},	// CJK UNIFIED IDEOGRAPH
	{0x55AE,	0xB3E6},	// CJK UNIFIED IDEOGRAPH
	{0x55B1,	0xB3ED},	// CJK UNIFIED IDEOGRAPH
	{0x55B2,	0xB3E9},	// CJK UNIFIED IDEOGRAPH
	{0x55B3,	0xB3E5},	// CJK UNIFIED IDEOGRAPH
	{0x55B5,	0xD870},	// CJK UNIFIED IDEOGRAPH
	{0x55BB,	0xB3EB},	// CJK UNIFIED IDEOGRAPH
	{0x55BF,	0xDCD5},	// CJK UNIFIED IDEOGRAPH
	{0x55C0,	0xDCD1},	// CJK UNIFIED IDEOGRAPH
	{0x55C2,	0xDCE0},	// CJK UNIFIED IDEOGRAPH
	{0x55C3,	0xDCCA},	// CJK UNIFIED IDEOGRAPH
	{0x55C4,	0xDCD3},	// CJK UNIFIED IDEOGRAPH
	{0x55C5,	0xB6E5},	// CJK UNIFIED IDEOGRAPH
	{0x55C6,	0xB6E6},	// CJK UNIFIED IDEOGRAPH
	{0x55C7,	0xB6DE},	// CJK UNIFIED IDEOGRAPH
	{0x55C8,	0xDCDC},	// CJK UNIFIED IDEOGRAPH
	{0x55C9,	0xB6E8},	// CJK UNIFIED IDEOGRAPH
	{0x55CA,	0xDCCF},	// CJK UNIFIED IDEOGRAPH
	{0x55CB,	0xDCCE},	// CJK UNIFIED IDEOGRAPH
	{0x55CC,	0xDCCC},	// CJK UNIFIED IDEOGRAPH
	{0x55CD,	0xDCDE},	// CJK UNIFIED IDEOGRAPH
	{0x55CE,	0xB6DC},	// CJK UNIFIED IDEOGRAPH
	{0x55CF,	0xDCD8},	// CJK UNIFIED IDEOGRAPH
	{0x55D0,	0xDCCD},	// CJK UNIFIED IDEOGRAPH
	{0x55D1,	0xB6DF},	// CJK UNIFIED IDEOGRAPH
	{0x55D2,	0xDCD6},	// CJK UNIFIED IDEOGRAPH
	{0x55D3,	0xB6DA},	// CJK UNIFIED IDEOGRAPH
	{0x55D4,	0xDCD2},	// CJK UNIFIED IDEOGRAPH
	{0x55D5,	0xDCD9},	// CJK UNIFIED IDEOGRAPH
	{0x55D6,	0xDCDB},	// CJK UNIFIED IDEOGRAPH
	{0x55D9,	0xDCDF},	// CJK UNIFIED IDEOGRAPH
	{0x55DA,	0xB6E3},	// CJK UNIFIED IDEOGRAPH
	{0x55DB,	0xDCCB},	// CJK UNIFIED IDEOGRAPH
	{0x55DC,	0xB6DD},	// CJK UNIFIED IDEOGRAPH
	{0x55DD,	0xDCD0},	// CJK UNIFIED IDEOGRAPH
	{0x55DF,	0xB6D8},	// CJK UNIFIED IDEOGRAPH
	{0x55E1,	0xB6E4},	// CJK UNIFIED IDEOGRAPH
	{0x55E2,	0xDCDA},	// CJK UNIFIED IDEOGRAPH
	{0x55E3,	0xB6E0},	// CJK UNIFIED IDEOGRAPH
	{0x55E4,	0xB6E1},	// CJK UNIFIED IDEOGRAPH
	{0x55E5,	0xB6E7},	// CJK UNIFIED IDEOGRAPH
	{0x55E6,	0xB6DB},	// CJK UNIFIED IDEOGRAPH
	{0x55E7,	0xA25F},	// CJK UNIFIED IDEOGRAPH
	{0x55E8,	0xB6D9},	// CJK UNIFIED IDEOGRAPH
	{0x55E9,	0xDCD4},	// CJK UNIFIED IDEOGRAPH
	{0x55EF,	0xB6E2},	// CJK UNIFIED IDEOGRAPH
	{0x55F2,	0xDCDD},	// CJK UNIFIED IDEOGRAPH
	{0x55F6,	0xB9CD},	// CJK UNIFIED IDEOGRAPH
	{0x55F7,	0xB9C8},	// CJK UNIFIED IDEOGRAPH
	{0x55F9,	0xE155},	// CJK UNIFIED IDEOGRAPH
	{0x55FA,	0xE151},	// CJK UNIFIED IDEOGRAPH
	{0x55FC,	0xE14B},	// CJK UNIFIED IDEOGRAPH
	{0x55FD,	0xB9C2},	// CJK UNIFIED IDEOGRAPH
	{0x55FE,	0xB9BE},	// CJK UNIFIED IDEOGRAPH
	{0x55FF,	0xE154},	// CJK UNIFIED IDEOGRAPH
	{0x5600,	0xB9BF},	// CJK UNIFIED IDEOGRAPH
	{0x5601,	0xE14E},	// CJK UNIFIED IDEOGRAPH
	{0x5602,	0xE150},	// CJK UNIFIED IDEOGRAPH
	{0x5604,	0xE153},	// CJK UNIFIED IDEOGRAPH
	{0x5606,	0xB9C4},	// CJK UNIFIED IDEOGRAPH
	{0x5608,	0xB9CB},	// CJK UNIFIED IDEOGRAPH
	{0x5609,	0xB9C5},	// CJK UNIFIED IDEOGRAPH
	{0x560C,	0xE149},	// CJK UNIFIED IDEOGRAPH
	{0x560D,	0xB9C6},	// CJK UNIFIED IDEOGRAPH
	{0x560E,	0xB9C7},	// CJK UNIFIED IDEOGRAPH
	{0x560F,	0xE14C},	// CJK UNIFIED IDEOGRAPH
	{0x5610,	0xB9CC},	// CJK UNIFIED IDEOGRAPH
	{0x5612,	0xE14A},	// CJK UNIFIED IDEOGRAPH
	{0x5613,	0xE14F},	// CJK UNIFIED IDEOGRAPH
	{0x5614,	0xB9C3},	// CJK UNIFIED IDEOGRAPH
	{0x5615,	0xE148},	// CJK UNIFIED IDEOGRAPH
	{0x5616,	0xB9C9},	// CJK UNIFIED IDEOGRAPH
	{0x5617,	0xB9C1},	// CJK UNIFIED IDEOGRAPH
	{0x561B,	0xB9C0},	// CJK UNIFIED IDEOGRAPH
	{0x561C,	0xE14D},	// CJK UNIFIED IDEOGRAPH
	{0x561D,	0xE152},	// CJK UNIFIED IDEOGRAPH
	{0x561F,	0xB9CA},	// CJK UNIFIED IDEOGRAPH
	{0x5627,	0xE147},	// CJK UNIFIED IDEOGRAPH
	{0x5629,	0xBC4D},	// CJK UNIFIED IDEOGRAPH
	{0x562A,	0xE547},	// CJK UNIFIED IDEOGRAPH
	{0x562C,	0xE544},	// CJK UNIFIED IDEOGRAPH
	{0x562E,	0xBC47},	// CJK UNIFIED IDEOGRAPH
	{0x562F,	0xBC53},	// CJK UNIFIED IDEOGRAPH
	{0x5630,	0xBC54},	// CJK UNIFIED IDEOGRAPH
	{0x5632,	0xBC4A},	// CJK UNIFIED IDEOGRAPH
	{0x5633,	0xE542},	// CJK UNIFIED IDEOGRAPH
	{0x5634,	0xBC4C},	// CJK UNIFIED IDEOGRAPH
	{0x5635,	0xE4F9},	// CJK UNIFIED IDEOGRAPH
	{0x5636,	0xBC52},	// CJK UNIFIED IDEOGRAPH
	{0x5638,	0xE546},	// CJK UNIFIED IDEOGRAPH
	{0x5639,	0xBC49},	// CJK UNIFIED IDEOGRAPH
	{0x563A,	0xE548},	// CJK UNIFIED IDEOGRAPH
	{0x563B,	0xBC48},	// CJK UNIFIED IDEOGRAPH
	{0x563D,	0xE543},	// CJK UNIFIED IDEOGRAPH
	{0x563E,	0xE545},	// CJK UNIFIED IDEOGRAPH
	{0x563F,	0xBC4B},	// CJK UNIFIED IDEOGRAPH
	{0x5640,	0xE541},	// CJK UNIFIED IDEOGRAPH
	{0x5641,	0xE4FA},	// CJK UNIFIED IDEOGRAPH
	{0x5642,	0xE4F7},	// CJK UNIFIED IDEOGRAPH
	{0x5645,	0xD86B},	// CJK UNIFIED IDEOGRAPH
	{0x5646,	0xE4FD},	// CJK UNIFIED IDEOGRAPH
	{0x5648,	0xE4F6},	// CJK UNIFIED IDEOGRAPH
	{0x5649,	0xE4FC},	// CJK UNIFIED IDEOGRAPH
	{0x564A,	0xE4FB},	// CJK UNIFIED IDEOGRAPH
	{0x564C,	0xE4F8},	// CJK UNIFIED IDEOGRAPH
	{0x564E,	0xBC4F},	// CJK UNIFIED IDEOGRAPH
	{0x5653,	0xBC4E},	// CJK UNIFIED IDEOGRAPH
	{0x5657,	0xBC50},	// CJK UNIFIED IDEOGRAPH
	{0x5658,	0xE4FE},	// CJK UNIFIED IDEOGRAPH
	{0x5659,	0xBEB2},	// CJK UNIFIED IDEOGRAPH
	{0x565A,	0xE540},	// CJK UNIFIED IDEOGRAPH
	{0x565E,	0xE945},	// CJK UNIFIED IDEOGRAPH
	{0x5660,	0xE8FD},	// CJK UNIFIED IDEOGRAPH
	{0x5662,	0xBEBE},	// CJK UNIFIED IDEOGRAPH
	{0x5663,	0xE942},	// CJK UNIFIED IDEOGRAPH
	{0x5664,	0xBEB6},	// CJK UNIFIED IDEOGRAPH
	{0x5665,	0xBEBA},	// CJK UNIFIED IDEOGRAPH
	{0x5666,	0xE941},	// CJK UNIFIED IDEOGRAPH
	{0x5668,	0xBEB9},	// CJK UNIFIED IDEOGRAPH
	{0x5669,	0xBEB5},	// CJK UNIFIED IDEOGRAPH
	{0x566A,	0xBEB8},	// CJK UNIFIED IDEOGRAPH
	{0x566B,	0xBEB3},	// CJK UNIFIED IDEOGRAPH
	{0x566C,	0xBEBD},	// CJK UNIFIED IDEOGRAPH
	{0x566D,	0xE943},	// CJK UNIFIED IDEOGRAPH
	{0x566E,	0xE8FE},	// CJK UNIFIED IDEOGRAPH
	{0x566F,	0xBEBC},	// CJK UNIFIED IDEOGRAPH
	{0x5670,	0xE8FC},	// CJK UNIFIED IDEOGRAPH
	{0x5671,	0xBEBB},	// CJK UNIFIED IDEOGRAPH
	{0x5672,	0xE944},	// CJK UNIFIED IDEOGRAPH
	{0x5673,	0xE940},	// CJK UNIFIED IDEOGRAPH
	{0x5674,	0xBC51},	// CJK UNIFIED IDEOGRAPH
	{0x5676,	0xBEBF},	// CJK UNIFIED IDEOGRAPH
	{0x5677,	0xE946},	// CJK UNIFIED IDEOGRAPH
	{0x5678,	0xBEB7},	// CJK UNIFIED IDEOGRAPH
	{0x5679,	0xBEB4},	// CJK UNIFIED IDEOGRAPH
	{0x567E,	0xECC6},	// CJK UNIFIED IDEOGRAPH
	{0x567F,	0xECC8},	// CJK UNIFIED IDEOGRAPH
	{0x5680,	0xC07B},	// CJK UNIFIED IDEOGRAPH
	{0x5681,	0xECC9},	// CJK UNIFIED IDEOGRAPH
	{0x5682,	0xECC7},	// CJK UNIFIED IDEOGRAPH
	{0x5683,	0xECC5},	// CJK UNIFIED IDEOGRAPH
	{0x5684,	0xECC4},	// CJK UNIFIED IDEOGRAPH
	{0x5685,	0xC07D},	// CJK UNIFIED IDEOGRAPH
	{0x5686,	0xECC3},	// CJK UNIFIED IDEOGRAPH
	{0x5687,	0xC07E},	// CJK UNIFIED IDEOGRAPH
	{0x568C,	0xECC1},	// CJK UNIFIED IDEOGRAPH
	{0x568D,	0xECC2},	// CJK UNIFIED IDEOGRAPH
	{0x568E,	0xC07A},	// CJK UNIFIED IDEOGRAPH
	{0x568F,	0xC0A1},	// CJK UNIFIED IDEOGRAPH
	{0x5690,	0xC07C},	// CJK UNIFIED IDEOGRAPH
	{0x5693,	0xECC0},	// CJK UNIFIED IDEOGRAPH
	{0x5695,	0xC250},	// CJK UNIFIED IDEOGRAPH
	{0x5697,	0xEFBC},	// CJK UNIFIED IDEOGRAPH
	{0x5698,	0xEFBA},	// CJK UNIFIED IDEOGRAPH
	{0x5699,	0xEFBF},	// CJK UNIFIED IDEOGRAPH
	{0x569A,	0xEFBD},	// CJK UNIFIED IDEOGRAPH
	{0x569C,	0xEFBB},	// CJK UNIFIED IDEOGRAPH
	{0x569D,	0xEFBE},	// CJK UNIFIED IDEOGRAPH
	{0x56A5,	0xC360},	// CJK UNIFIED IDEOGRAPH
	{0x56A6,	0xF1F2},	// CJK UNIFIED IDEOGRAPH
	{0x56A7,	0xF1F3},	// CJK UNIFIED IDEOGRAPH
	{0x56A8,	0xC456},	// CJK UNIFIED IDEOGRAPH
	{0x56AA,	0xF1F4},	// CJK UNIFIED IDEOGRAPH
	{0x56AB,	0xF1F0},	// CJK UNIFIED IDEOGRAPH
	{0x56AC,	0xF1F5},	// CJK UNIFIED IDEOGRAPH
	{0x56AD,	0xF1F1},	// CJK UNIFIED IDEOGRAPH
	{0x56AE,	0xC251},	// CJK UNIFIED IDEOGRAPH
	{0x56B2,	0xF3FE},	// CJK UNIFIED IDEOGRAPH
	{0x56B3,	0xF441},	// CJK UNIFIED IDEOGRAPH
	{0x56B4,	0xC459},	// CJK UNIFIED IDEOGRAPH
	{0x56B5,	0xF440},	// CJK UNIFIED IDEOGRAPH
	{0x56B6,	0xC458},	// CJK UNIFIED IDEOGRAPH
	{0x56B7,	0xC457},	// CJK UNIFIED IDEOGRAPH
	{0x56BC,	0xC45A},	// CJK UNIFIED IDEOGRAPH
	{0x56BD,	0xF5C5},	// CJK UNIFIED IDEOGRAPH
	{0x56BE,	0xF5C6},	// CJK UNIFIED IDEOGRAPH
	{0x56C0,	0xC4DA},	// CJK UNIFIED IDEOGRAPH
	{0x56C1,	0xC4D9},	// CJK UNIFIED IDEOGRAPH
	{0x56C2,	0xC4DB},	// CJK UNIFIED IDEOGRAPH
	{0x56C3,	0xF5C4},	// CJK UNIFIED IDEOGRAPH
	{0x56C5,	0xF6D8},	// CJK UNIFIED IDEOGRAPH
	{0x56C6,	0xF6D7},	// CJK UNIFIED IDEOGRAPH
	{0x56C8,	0xC56D},	// CJK UNIFIED IDEOGRAPH
	{0x56C9,	0xC56F},	// CJK UNIFIED IDEOGRAPH
	{0x56CA,	0xC56E},	// CJK UNIFIED IDEOGRAPH
	{0x56CB,	0xF6D9},	// CJK UNIFIED IDEOGRAPH
	{0x56CC,	0xC5C8},	// CJK UNIFIED IDEOGRAPH
	{0x56CD,	0xF8A6},	// CJK UNIFIED IDEOGRAPH
	{0x56D1,	0xC5F1},	// CJK UNIFIED IDEOGRAPH
	{0x56D3,	0xF8A5},	// CJK UNIFIED IDEOGRAPH
	{0x56D4,	0xF8EE},	// CJK UNIFIED IDEOGRAPH
	{0x56D7,	0xC949},	// CJK UNIFIED IDEOGRAPH
	{0x56DA,	0xA57D},	// CJK UNIFIED IDEOGRAPH
	{0x56DB,	0xA57C},	// CJK UNIFIED IDEOGRAPH
	{0x56DD,	0xA65F},	// CJK UNIFIED IDEOGRAPH
	{0x56DE,	0xA65E},	// CJK UNIFIED IDEOGRAPH
	{0x56DF,	0xC9C7},	// CJK UNIFIED IDEOGRAPH
	{0x56E0,	0xA65D},	// CJK UNIFIED IDEOGRAPH
	{0x56E1,	0xC9C6},	// CJK UNIFIED IDEOGRAPH
	{0x56E4,	0xA779},	// CJK UNIFIED IDEOGRAPH
	{0x56E5,	0xCAA9},	// CJK UNIFIED IDEOGRAPH
	{0x56E7,	0xCAA8},	// CJK UNIFIED IDEOGRAPH
	{0x56EA,	0xA777},	// CJK UNIFIED IDEOGRAPH
	{0x56EB,	0xA77A},	// CJK UNIFIED IDEOGRAPH
	{0x56EE,	0xCAA7},	// CJK UNIFIED IDEOGRAPH
	{0x56F0,	0xA778},	// CJK UNIFIED IDEOGRAPH
	{0x56F7,	0xCBF0},	// CJK UNIFIED IDEOGRAPH
	{0x56F9,	0xCBF1},	// CJK UNIFIED IDEOGRAPH
	{0x56FA,	0xA954},	// CJK UNIFIED IDEOGRAPH
	{0x56FF,	0xABAA},	// CJK UNIFIED IDEOGRAPH
	{0x5701,	0xD148},	// CJK UNIFIED IDEOGRAPH
	{0x5702,	0xD149},	// CJK UNIFIED IDEOGRAPH
	{0x5703,	0xAE45},	// CJK UNIFIED IDEOGRAPH
	{0x5704,	0xAE46},	// CJK UNIFIED IDEOGRAPH
	{0x5707,	0xD4AC},	// CJK UNIFIED IDEOGRAPH
	{0x5708,	0xB0E9},	// CJK UNIFIED IDEOGRAPH
	{0x5709,	0xB0EB},	// CJK UNIFIED IDEOGRAPH
	{0x570A,	0xD4AB},	// CJK UNIFIED IDEOGRAPH
	{0x570B,	0xB0EA},	// CJK UNIFIED IDEOGRAPH
	{0x570C,	0xD87C},	// CJK UNIFIED IDEOGRAPH
	{0x570D,	0xB3F2},	// CJK UNIFIED IDEOGRAPH
	{0x5712,	0xB6E9},	// CJK UNIFIED IDEOGRAPH
	{0x5713,	0xB6EA},	// CJK UNIFIED IDEOGRAPH
	{0x5714,	0xDCE1},	// CJK UNIFIED IDEOGRAPH
	{0x5716,	0xB9CF},	// CJK UNIFIED IDEOGRAPH
	{0x5718,	0xB9CE},	// CJK UNIFIED IDEOGRAPH
	{0x571A,	0xE549},	// CJK UNIFIED IDEOGRAPH
	{0x571B,	0xE948},	// CJK UNIFIED IDEOGRAPH
	{0x571C,	0xE947},	// CJK UNIFIED IDEOGRAPH
	{0x571E,	0xF96B},	// CJK UNIFIED IDEOGRAPH
	{0x571F,	0xA467},	// CJK UNIFIED IDEOGRAPH
	{0x5720,	0xC959},	// CJK UNIFIED IDEOGRAPH
	{0x5722,	0xC96E},	// CJK UNIFIED IDEOGRAPH
	{0x5723,	0xC96F},	// CJK UNIFIED IDEOGRAPH
	{0x5728,	0xA662},	// CJK UNIFIED IDEOGRAPH
	{0x5729,	0xA666},	// CJK UNIFIED IDEOGRAPH
	{0x572A,	0xC9C9},	// CJK UNIFIED IDEOGRAPH
	{0x572C,	0xA664},	// CJK UNIFIED IDEOGRAPH
	{0x572D,	0xA663},	// CJK UNIFIED IDEOGRAPH
	{0x572E,	0xC9C8},	// CJK UNIFIED IDEOGRAPH
	{0x572F,	0xA665},	// CJK UNIFIED IDEOGRAPH
	{0x5730,	0xA661},	// CJK UNIFIED IDEOGRAPH
	{0x5733,	0xA660},	// CJK UNIFIED IDEOGRAPH
	{0x5734,	0xC9CA},	// CJK UNIFIED IDEOGRAPH
	{0x573B,	0xA7A6},	// CJK UNIFIED IDEOGRAPH
	{0x573E,	0xA7A3},	// CJK UNIFIED IDEOGRAPH
	{0x5740,	0xA77D},	// CJK UNIFIED IDEOGRAPH
	{0x5741,	0xCAAA},	// CJK UNIFIED IDEOGRAPH
	{0x5745,	0xCAAB},	// CJK UNIFIED IDEOGRAPH
	{0x5747,	0xA7A1},	// CJK UNIFIED IDEOGRAPH
	{0x5749,	0xCAAD},	// CJK UNIFIED IDEOGRAPH
	{0x574A,	0xA77B},	// CJK UNIFIED IDEOGRAPH
	{0x574B,	0xCAAE},	// CJK UNIFIED IDEOGRAPH
	{0x574C,	0xCAAC},	// CJK UNIFIED IDEOGRAPH
	{0x574D,	0xA77E},	// CJK UNIFIED IDEOGRAPH
	{0x574E,	0xA7A2},	// CJK UNIFIED IDEOGRAPH
	{0x574F,	0xA7A5},	// CJK UNIFIED IDEOGRAPH
	{0x5750,	0xA7A4},	// CJK UNIFIED IDEOGRAPH
	{0x5751,	0xA77C},	// CJK UNIFIED IDEOGRAPH
	{0x5752,	0xCAAF},	// CJK UNIFIED IDEOGRAPH
	{0x5761,	0xA959},	// CJK UNIFIED IDEOGRAPH
	{0x5762,	0xCBFE},	// CJK UNIFIED IDEOGRAPH
	{0x5764,	0xA95B},	// CJK UNIFIED IDEOGRAPH
	{0x5766,	0xA95A},	// CJK UNIFIED IDEOGRAPH
	{0x5768,	0xCC40},	// CJK UNIFIED IDEOGRAPH
	{0x5769,	0xA958},	// CJK UNIFIED IDEOGRAPH
	{0x576A,	0xA957},	// CJK UNIFIED IDEOGRAPH
	{0x576B,	0xCBF5},	// CJK UNIFIED IDEOGRAPH
	{0x576D,	0xCBF4},	// CJK UNIFIED IDEOGRAPH
	{0x576F,	0xCBF2},	// CJK UNIFIED IDEOGRAPH
	{0x5770,	0xCBF7},	// CJK UNIFIED IDEOGRAPH
	{0x5771,	0xCBF6},	// CJK UNIFIED IDEOGRAPH
	{0x5772,	0xCBF3},	// CJK UNIFIED IDEOGRAPH
	{0x5773,	0xCBFC},	// CJK UNIFIED IDEOGRAPH
	{0x5774,	0xCBFD},	// CJK UNIFIED IDEOGRAPH
	{0x5775,	0xCBFA},	// CJK UNIFIED IDEOGRAPH
	{0x5776,	0xCBF8},	// CJK UNIFIED IDEOGRAPH
	{0x5777,	0xA956},	// CJK UNIFIED IDEOGRAPH
	{0x577B,	0xCBFB},	// CJK UNIFIED IDEOGRAPH
	{0x577C,	0xA95C},	// CJK UNIFIED IDEOGRAPH
	{0x577D,	0xCC41},	// CJK UNIFIED IDEOGRAPH
	{0x5780,	0xCBF9},	// CJK UNIFIED IDEOGRAPH
	{0x5782,	0xABAB},	// CJK UNIFIED IDEOGRAPH
	{0x5783,	0xA955},	// CJK UNIFIED IDEOGRAPH
	{0x578B,	0xABAC},	// CJK UNIFIED IDEOGRAPH
	{0x578C,	0xCE54},	// CJK UNIFIED IDEOGRAPH
	{0x578F,	0xCE5A},	// CJK UNIFIED IDEOGRAPH
	{0x5793,	0xABB2},	// CJK UNIFIED IDEOGRAPH
	{0x5794,	0xCE58},	// CJK UNIFIED IDEOGRAPH
	{0x5795,	0xCE5E},	// CJK UNIFIED IDEOGRAPH
	{0x5797,	0xCE55},	// CJK UNIFIED IDEOGRAPH
	{0x5798,	0xCE59},	// CJK UNIFIED IDEOGRAPH
	{0x5799,	0xCE5B},	// CJK UNIFIED IDEOGRAPH
	{0x579A,	0xCE5D},	// CJK UNIFIED IDEOGRAPH
	{0x579B,	0xCE57},	// CJK UNIFIED IDEOGRAPH
	{0x579D,	0xCE56},	// CJK UNIFIED IDEOGRAPH
	{0x579E,	0xCE51},	// CJK UNIFIED IDEOGRAPH
	{0x579F,	0xCE52},	// CJK UNIFIED IDEOGRAPH
	{0x57A0,	0xABAD},	// CJK UNIFIED IDEOGRAPH
	{0x57A2,	0xABAF},	// CJK UNIFIED IDEOGRAPH
	{0x57A3,	0xABAE},	// CJK UNIFIED IDEOGRAPH
	{0x57A4,	0xCE53},	// CJK UNIFIED IDEOGRAPH
	{0x57A5,	0xCE5C},	// CJK UNIFIED IDEOGRAPH
	{0x57AE,	0xABB1},	// CJK UNIFIED IDEOGRAPH
	{0x57B5,	0xCE50},	// CJK UNIFIED IDEOGRAPH
	{0x57B6,	0xD153},	// CJK UNIFIED IDEOGRAPH
	{0x57B8,	0xD152},	// CJK UNIFIED IDEOGRAPH
	{0x57B9,	0xD157},	// CJK UNIFIED IDEOGRAPH
	{0x57BA,	0xD14E},	// CJK UNIFIED IDEOGRAPH
	{0x57BC,	0xD151},	// CJK UNIFIED IDEOGRAPH
	{0x57BD,	0xD150},	// CJK UNIFIED IDEOGRAPH
	{0x57BF,	0xD154},	// CJK UNIFIED IDEOGRAPH
	{0x57C1,	0xD158},	// CJK UNIFIED IDEOGRAPH
	{0x57C2,	0xAE47},	// CJK UNIFIED IDEOGRAPH
	{0x57C3,	0xAE4A},	// CJK UNIFIED IDEOGRAPH
	{0x57C6,	0xD14F},	// CJK UNIFIED IDEOGRAPH
	{0x57C7,	0xD155},	// CJK UNIFIED IDEOGRAPH
	{0x57CB,	0xAE49},	// CJK UNIFIED IDEOGRAPH
	{0x57CC,	0xD14A},	// CJK UNIFIED IDEOGRAPH
	{0x57CE,	0xABB0},	// CJK UNIFIED IDEOGRAPH
	{0x57CF,	0xD4BA},	// CJK UNIFIED IDEOGRAPH
	{0x57D0,	0xD156},	// CJK UNIFIED IDEOGRAPH
	{0x57D2,	0xD14D},	// CJK UNIFIED IDEOGRAPH
	{0x57D4,	0xAE48},	// CJK UNIFIED IDEOGRAPH
	{0x57D5,	0xD14C},	// CJK UNIFIED IDEOGRAPH
	{0x57DC,	0xD4B1},	// CJK UNIFIED IDEOGRAPH
	{0x57DF,	0xB0EC},	// CJK UNIFIED IDEOGRAPH
	{0x57E0,	0xB0F0},	// CJK UNIFIED IDEOGRAPH
	{0x57E1,	0xD4C1},	// CJK UNIFIED IDEOGRAPH
	{0x57E2,	0xD4AF},	// CJK UNIFIED IDEOGRAPH
	{0x57E3,	0xD4BD},	// CJK UNIFIED IDEOGRAPH
	{0x57E4,	0xB0F1},	// CJK UNIFIED IDEOGRAPH
	{0x57E5,	0xD4BF},	// CJK UNIFIED IDEOGRAPH
	{0x57E7,	0xD4C5},	// CJK UNIFIED IDEOGRAPH
	{0x57E9,	0xD4C9},	// CJK UNIFIED IDEOGRAPH
	{0x57EC,	0xD4C0},	// CJK UNIFIED IDEOGRAPH
	{0x57ED,	0xD4B4},	// CJK UNIFIED IDEOGRAPH
	{0x57EE,	0xD4BC},	// CJK UNIFIED IDEOGRAPH
	{0x57F0,	0xD4CA},	// CJK UNIFIED IDEOGRAPH
	{0x57F1,	0xD4C8},	// CJK UNIFIED IDEOGRAPH
	{0x57F2,	0xD4BE},	// CJK UNIFIED IDEOGRAPH
	{0x57F3,	0xD4B9},	// CJK UNIFIED IDEOGRAPH
	{0x57F4,	0xD4B2},	// CJK UNIFIED IDEOGRAPH
	{0x57F5,	0xD8A6},	// CJK UNIFIED IDEOGRAPH
	{0x57F6,	0xD4B0},	// CJK UNIFIED IDEOGRAPH
	{0x57F7,	0xB0F5},	// CJK UNIFIED IDEOGRAPH
	{0x57F8,	0xD4B7},	// CJK UNIFIED IDEOGRAPH
	{0x57F9,	0xB0F6},	// CJK UNIFIED IDEOGRAPH
	{0x57FA,	0xB0F2},	// CJK UNIFIED IDEOGRAPH
	{0x57FB,	0xD4AD},	// CJK UNIFIED IDEOGRAPH
	{0x57FC,	0xD4C3},	// CJK UNIFIED IDEOGRAPH
	{0x57FD,	0xD4B5},	// CJK UNIFIED IDEOGRAPH
	{0x5800,	0xD4B3},	// CJK UNIFIED IDEOGRAPH
	{0x5801,	0xD4C6},	// CJK UNIFIED IDEOGRAPH
	{0x5802,	0xB0F3},	// CJK UNIFIED IDEOGRAPH
	{0x5804,	0xD4CC},	// CJK UNIFIED IDEOGRAPH
	{0x5805,	0xB0ED},	// CJK UNIFIED IDEOGRAPH
	{0x5806,	0xB0EF},	// CJK UNIFIED IDEOGRAPH
	{0x5807,	0xD4BB},	// CJK UNIFIED IDEOGRAPH
	{0x5808,	0xD4B6},	// CJK UNIFIED IDEOGRAPH
	{0x5809,	0xAE4B},	// CJK UNIFIED IDEOGRAPH
	{0x580A,	0xB0EE},	// CJK UNIFIED IDEOGRAPH
	{0x580B,	0xD4B8},	// CJK UNIFIED IDEOGRAPH
	{0x580C,	0xD4C7},	// CJK UNIFIED IDEOGRAPH
	{0x580D,	0xD4CB},	// CJK UNIFIED IDEOGRAPH
	{0x580E,	0xD4C2},	// CJK UNIFIED IDEOGRAPH
	{0x5810,	0xD4C4},	// CJK UNIFIED IDEOGRAPH
	{0x5814,	0xD4AE},	// CJK UNIFIED IDEOGRAPH
	{0x5819,	0xD8A1},	// CJK UNIFIED IDEOGRAPH
	{0x581B,	0xD8AA},	// CJK UNIFIED IDEOGRAPH
	{0x581C,	0xD8A9},	// CJK UNIFIED IDEOGRAPH
	{0x581D,	0xB3FA},	// CJK UNIFIED IDEOGRAPH
	{0x581E,	0xD8A2},	// CJK UNIFIED IDEOGRAPH
	{0x5820,	0xB3FB},	// CJK UNIFIED IDEOGRAPH
	{0x5821,	0xB3F9},	// CJK UNIFIED IDEOGRAPH
	{0x5823,	0xD8A4},	// CJK UNIFIED IDEOGRAPH
	{0x5824,	0xB3F6},	// CJK UNIFIED IDEOGRAPH
	{0x5825,	0xD8A8},	// CJK UNIFIED IDEOGRAPH
	{0x5827,	0xD8A3},	// CJK UNIFIED IDEOGRAPH
	{0x5828,	0xD8A5},	// CJK UNIFIED IDEOGRAPH
	{0x5829,	0xD87D},	// CJK UNIFIED IDEOGRAPH
	{0x582A,	0xB3F4},	// CJK UNIFIED IDEOGRAPH
	{0x582C,	0xD8B2},	// CJK UNIFIED IDEOGRAPH
	{0x582D,	0xD8B1},	// CJK UNIFIED IDEOGRAPH
	{0x582E,	0xD8AE},	// CJK UNIFIED IDEOGRAPH
	{0x582F,	0xB3F3},	// CJK UNIFIED IDEOGRAPH
	{0x5830,	0xB3F7},	// CJK UNIFIED IDEOGRAPH
	{0x5831,	0xB3F8},	// CJK UNIFIED IDEOGRAPH
	{0x5832,	0xD14B},	// CJK UNIFIED IDEOGRAPH
	{0x5833,	0xD8AB},	// CJK UNIFIED IDEOGRAPH
	{0x5834,	0xB3F5},	// CJK UNIFIED IDEOGRAPH
	{0x5835,	0xB0F4},	// CJK UNIFIED IDEOGRAPH
	{0x5836,	0xD8AD},	// CJK UNIFIED IDEOGRAPH
	{0x5837,	0xD87E},	// CJK UNIFIED IDEOGRAPH
	{0x5838,	0xD8B0},	// CJK UNIFIED IDEOGRAPH
	{0x5839,	0xD8AF},	// CJK UNIFIED IDEOGRAPH
	{0x583B,	0xD8B3},	// CJK UNIFIED IDEOGRAPH
	{0x583D,	0xDCEF},	// CJK UNIFIED IDEOGRAPH
	{0x583F,	0xD8AC},	// CJK UNIFIED IDEOGRAPH
	{0x5848,	0xD8A7},	// CJK UNIFIED IDEOGRAPH
	{0x5849,	0xDCE7},	// CJK UNIFIED IDEOGRAPH
	{0x584A,	0xB6F4},	// CJK UNIFIED IDEOGRAPH
	{0x584B,	0xB6F7},	// CJK UNIFIED IDEOGRAPH
	{0x584C,	0xB6F2},	// CJK UNIFIED IDEOGRAPH
	{0x584D,	0xDCE6},	// CJK UNIFIED IDEOGRAPH
	{0x584E,	0xDCEA},	// CJK UNIFIED IDEOGRAPH
	{0x584F,	0xDCE5},	// CJK UNIFIED IDEOGRAPH
	{0x5851,	0xB6EC},	// CJK UNIFIED IDEOGRAPH
	{0x5852,	0xB6F6},	// CJK UNIFIED IDEOGRAPH
	{0x5853,	0xDCE2},	// CJK UNIFIED IDEOGRAPH
	{0x5854,	0xB6F0},	// CJK UNIFIED IDEOGRAPH
	{0x5855,	0xDCE9},	// CJK UNIFIED IDEOGRAPH
	{0x5857,	0xB6EE},	// CJK UNIFIED IDEOGRAPH
	{0x5858,	0xB6ED},	// CJK UNIFIED IDEOGRAPH
	{0x5859,	0xDCEC},	// CJK UNIFIED IDEOGRAPH
	{0x585A,	0xB6EF},	// CJK UNIFIED IDEOGRAPH
	{0x585B,	0xDCEE},	// CJK UNIFIED IDEOGRAPH
	{0x585D,	0xDCEB},	// CJK UNIFIED IDEOGRAPH
	{0x585E,	0xB6EB},	// CJK UNIFIED IDEOGRAPH
	{0x5862,	0xB6F5},	// CJK UNIFIED IDEOGRAPH
	{0x5863,	0xDCF0},	// CJK UNIFIED IDEOGRAPH
	{0x5864,	0xDCE4},	// CJK UNIFIED IDEOGRAPH
	{0x5865,	0xDCED},	// CJK UNIFIED IDEOGRAPH
	{0x5868,	0xDCE3},	// CJK UNIFIED IDEOGRAPH
	{0x586B,	0xB6F1},	// CJK UNIFIED IDEOGRAPH
	{0x586D,	0xB6F3},	// CJK UNIFIED IDEOGRAPH
	{0x586F,	0xDCE8},	// CJK UNIFIED IDEOGRAPH
	{0x5871,	0xDCF1},	// CJK UNIFIED IDEOGRAPH
	{0x5874,	0xE15D},	// CJK UNIFIED IDEOGRAPH
	{0x5875,	0xB9D0},	// CJK UNIFIED IDEOGRAPH
	{0x5876,	0xE163},	// CJK UNIFIED IDEOGRAPH
	{0x5879,	0xB9D5},	// CJK UNIFIED IDEOGRAPH
	{0x587A,	0xE15F},	// CJK UNIFIED IDEOGRAPH
	{0x587B,	0xE166},	// CJK UNIFIED IDEOGRAPH
	{0x587C,	0xE157},	// CJK UNIFIED IDEOGRAPH
	{0x587D,	0xB9D7},	// CJK UNIFIED IDEOGRAPH
	{0x587E,	0xB9D1},	// CJK UNIFIED IDEOGRAPH
	{0x587F,	0xE15C},	// CJK UNIFIED IDEOGRAPH
	{0x5880,	0xBC55},	// CJK UNIFIED IDEOGRAPH
	{0x5881,	0xE15B},	// CJK UNIFIED IDEOGRAPH
	{0x5882,	0xE164},	// CJK UNIFIED IDEOGRAPH
	{0x5883,	0xB9D2},	// CJK UNIFIED IDEOGRAPH
	{0x5885,	0xB9D6},	// CJK UNIFIED IDEOGRAPH
	{0x5886,	0xE15A},	// CJK UNIFIED IDEOGRAPH
	{0x5887,	0xE160},	// CJK UNIFIED IDEOGRAPH
	{0x5888,	0xE165},	// CJK UNIFIED IDEOGRAPH
	{0x5889,	0xE156},	// CJK UNIFIED IDEOGRAPH
	{0x588A,	0xB9D4},	// CJK UNIFIED IDEOGRAPH
	{0x588B,	0xE15E},	// CJK UNIFIED IDEOGRAPH
	{0x588E,	0xE162},	// CJK UNIFIED IDEOGRAPH
	{0x588F,	0xE168},	// CJK UNIFIED IDEOGRAPH
	{0x5890,	0xE158},	// CJK UNIFIED IDEOGRAPH
	{0x5891,	0xE161},	// CJK UNIFIED IDEOGRAPH
	{0x5893,	0xB9D3},	// CJK UNIFIED IDEOGRAPH
	{0x5894,	0xE167},	// CJK UNIFIED IDEOGRAPH
	{0x5898,	0xE159},	// CJK UNIFIED IDEOGRAPH
	{0x589C,	0xBC59},	// CJK UNIFIED IDEOGRAPH
	{0x589D,	0xE54B},	// CJK UNIFIED IDEOGRAPH
	{0x589E,	0xBC57},	// CJK UNIFIED IDEOGRAPH
	{0x589F,	0xBC56},	// CJK UNIFIED IDEOGRAPH
	{0x58A0,	0xE54D},	// CJK UNIFIED IDEOGRAPH
	{0x58A1,	0xE552},	// CJK UNIFIED IDEOGRAPH
	{0x58A3,	0xE54E},	// CJK UNIFIED IDEOGRAPH
	{0x58A5,	0xE551},	// CJK UNIFIED IDEOGRAPH
	{0x58A6,	0xBC5C},	// CJK UNIFIED IDEOGRAPH
	{0x58A8,	0xBEA5},	// CJK UNIFIED IDEOGRAPH
	{0x58A9,	0xBC5B},	// CJK UNIFIED IDEOGRAPH
	{0x58AB,	0xE54A},	// CJK UNIFIED IDEOGRAPH
	{0x58AC,	0xE550},	// CJK UNIFIED IDEOGRAPH
	{0x58AE,	0xBC5A},	// CJK UNIFIED IDEOGRAPH
	{0x58AF,	0xE54F},	// CJK UNIFIED IDEOGRAPH
	{0x58B1,	0xE54C},	// CJK UNIFIED IDEOGRAPH
	{0x58B3,	0xBC58},	// CJK UNIFIED IDEOGRAPH
	{0x58BA,	0xE94D},	// CJK UNIFIED IDEOGRAPH
	{0x58BB,	0xF9D9},	// CJK UNIFIED IDEOGRAPH
	{0x58BC,	0xE94F},	// CJK UNIFIED IDEOGRAPH
	{0x58BD,	0xE94A},	// CJK UNIFIED IDEOGRAPH
	{0x58BE,	0xBEC1},	// CJK UNIFIED IDEOGRAPH
	{0x58BF,	0xE94C},	// CJK UNIFIED IDEOGRAPH
	{0x58C1,	0xBEC0},	// CJK UNIFIED IDEOGRAPH
	{0x58C2,	0xE94E},	// CJK UNIFIED IDEOGRAPH
	{0x58C5,	0xBEC3},	// CJK UNIFIED IDEOGRAPH
	{0x58C6,	0xE950},	// CJK UNIFIED IDEOGRAPH
	{0x58C7,	0xBEC2},	// CJK UNIFIED IDEOGRAPH
	{0x58C8,	0xE949},	// CJK UNIFIED IDEOGRAPH
	{0x58C9,	0xE94B},	// CJK UNIFIED IDEOGRAPH
	{0x58CE,	0xC0A5},	// CJK UNIFIED IDEOGRAPH
	{0x58CF,	0xECCC},	// CJK UNIFIED IDEOGRAPH
	{0x58D1,	0xC0A4},	// CJK UNIFIED IDEOGRAPH
	{0x58D2,	0xECCD},	// CJK UNIFIED IDEOGRAPH
	{0x58D3,	0xC0A3},	// CJK UNIFIED IDEOGRAPH
	{0x58D4,	0xECCB},	// CJK UNIFIED IDEOGRAPH
	{0x58D5,	0xC0A2},	// CJK UNIFIED IDEOGRAPH
	{0x58D6,	0xECCA},	// CJK UNIFIED IDEOGRAPH
	{0x58D8,	0xC253},	// CJK UNIFIED IDEOGRAPH
	{0x58D9,	0xC252},	// CJK UNIFIED IDEOGRAPH
	{0x58DA,	0xF1F6},	// CJK UNIFIED IDEOGRAPH
	{0x58DB,	0xF1F8},	// CJK UNIFIED IDEOGRAPH
	{0x58DD,	0xF1F7},	// CJK UNIFIED IDEOGRAPH
	{0x58DE,	0xC361},	// CJK UNIFIED IDEOGRAPH
	{0x58DF,	0xC362},	// CJK UNIFIED IDEOGRAPH
	{0x58E2,	0xC363},	// CJK UNIFIED IDEOGRAPH
	{0x58E3,	0xF442},	// CJK UNIFIED IDEOGRAPH
	{0x58E4,	0xC45B},	// CJK UNIFIED IDEOGRAPH
	{0x58E7,	0xF7D3},	// CJK UNIFIED IDEOGRAPH
	{0x58E8,	0xF7D2},	// CJK UNIFIED IDEOGRAPH
	{0x58E9,	0xC5F2},	// CJK UNIFIED IDEOGRAPH
	{0x58EB,	0xA468},	// CJK UNIFIED IDEOGRAPH
	{0x58EC,	0xA4D0},	// CJK UNIFIED IDEOGRAPH
	{0x58EF,	0xA7A7},	// CJK UNIFIED IDEOGRAPH
	{0x58F4,	0xCE5F},	// CJK UNIFIED IDEOGRAPH
	{0x58F9,	0xB3FC},	// CJK UNIFIED IDEOGRAPH
	{0x58FA,	0xB3FD},	// CJK UNIFIED IDEOGRAPH
	{0x58FC,	0xDCF2},	// CJK UNIFIED IDEOGRAPH
	{0x58FD,	0xB9D8},	// CJK UNIFIED IDEOGRAPH
	{0x58FE,	0xE169},	// CJK UNIFIED IDEOGRAPH
	{0x58FF,	0xE553},	// CJK UNIFIED IDEOGRAPH
	{0x5903,	0xC95A},	// CJK UNIFIED IDEOGRAPH
	{0x5906,	0xCAB0},	// CJK UNIFIED IDEOGRAPH
	{0x590C,	0xCC42},	// CJK UNIFIED IDEOGRAPH
	{0x590D,	0xCE60},	// CJK UNIFIED IDEOGRAPH
	{0x590E,	0xD159},	// CJK UNIFIED IDEOGRAPH
	{0x590F,	0xAE4C},	// CJK UNIFIED IDEOGRAPH
	{0x5912,	0xF1F9},	// CJK UNIFIED IDEOGRAPH
	{0x5914,	0xC4DC},	// CJK UNIFIED IDEOGRAPH
	{0x5915,	0xA469},	// CJK UNIFIED IDEOGRAPH
	{0x5916,	0xA57E},	// CJK UNIFIED IDEOGRAPH
	{0x5917,	0xC970},	// CJK UNIFIED IDEOGRAPH
	{0x5919,	0xA667},	// CJK UNIFIED IDEOGRAPH
	{0x591A,	0xA668},	// CJK UNIFIED IDEOGRAPH
	{0x591C,	0xA95D},	// CJK UNIFIED IDEOGRAPH
	{0x5920,	0xB0F7},	// CJK UNIFIED IDEOGRAPH
	{0x5922,	0xB9DA},	// CJK UNIFIED IDEOGRAPH
	{0x5924,	0xB9DB},	// CJK UNIFIED IDEOGRAPH
	{0x5925,	0xB9D9},	// CJK UNIFIED IDEOGRAPH
	{0x5927,	0xA46A},	// CJK UNIFIED IDEOGRAPH
	{0x5929,	0xA4D1},	// CJK UNIFIED IDEOGRAPH
	{0x592A,	0xA4D3},	// CJK UNIFIED IDEOGRAPH
	{0x592B,	0xA4D2},	// CJK UNIFIED IDEOGRAPH
	{0x592C,	0xC95B},	// CJK UNIFIED IDEOGRAPH
	{0x592D,	0xA4D4},	// CJK UNIFIED IDEOGRAPH
	{0x592E,	0xA5A1},	// CJK UNIFIED IDEOGRAPH
	{0x592F,	0xC971},	// CJK UNIFIED IDEOGRAPH
	{0x5931,	0xA5A2},	// CJK UNIFIED IDEOGRAPH
	{0x5937,	0xA669},	// CJK UNIFIED IDEOGRAPH
	{0x5938,	0xA66A},	// CJK UNIFIED IDEOGRAPH
	{0x593C,	0xC9CB},	// CJK UNIFIED IDEOGRAPH
	{0x593E,	0xA7A8},	// CJK UNIFIED IDEOGRAPH
	{0x5940,	0xCAB1},	// CJK UNIFIED IDEOGRAPH
	{0x5944,	0xA961},	// CJK UNIFIED IDEOGRAPH
	{0x5945,	0xCC43},	// CJK UNIFIED IDEOGRAPH
	{0x5947,	0xA95F},	// CJK UNIFIED IDEOGRAPH
	{0x5948,	0xA960},	// CJK UNIFIED IDEOGRAPH
	{0x5949,	0xA95E},	// CJK UNIFIED IDEOGRAPH
	{0x594A,	0xD15A},	// CJK UNIFIED IDEOGRAPH
	{0x594E,	0xABB6},	// CJK UNIFIED IDEOGRAPH
	{0x594F,	0xABB5},	// CJK UNIFIED IDEOGRAPH
	{0x5950,	0xABB7},	// CJK UNIFIED IDEOGRAPH
	{0x5951,	0xABB4},	// CJK UNIFIED IDEOGRAPH
	{0x5953,	0xCE61},	// CJK UNIFIED IDEOGRAPH
	{0x5954,	0xA962},	// CJK UNIFIED IDEOGRAPH
	{0x5955,	0xABB3},	// CJK UNIFIED IDEOGRAPH
	{0x5957,	0xAE4D},	// CJK UNIFIED IDEOGRAPH
	{0x5958,	0xAE4E},	// CJK UNIFIED IDEOGRAPH
	{0x595A,	0xAE4F},	// CJK UNIFIED IDEOGRAPH
	{0x595C,	0xD4CD},	// CJK UNIFIED IDEOGRAPH
	{0x5960,	0xB3FE},	// CJK UNIFIED IDEOGRAPH
	{0x5961,	0xD8B4},	// CJK UNIFIED IDEOGRAPH
	{0x5962,	0xB0F8},	// CJK UNIFIED IDEOGRAPH
	{0x5967,	0xB6F8},	// CJK UNIFIED IDEOGRAPH
	{0x5969,	0xB9DD},	// CJK UNIFIED IDEOGRAPH
	{0x596A,	0xB9DC},	// CJK UNIFIED IDEOGRAPH
	{0x596B,	0xE16A},	// CJK UNIFIED IDEOGRAPH
	{0x596D,	0xBC5D},	// CJK UNIFIED IDEOGRAPH
	{0x596E,	0xBEC4},	// CJK UNIFIED IDEOGRAPH
	{0x5970,	0xEFC0},	// CJK UNIFIED IDEOGRAPH
	{0x5971,	0xF6DA},	// CJK UNIFIED IDEOGRAPH
	{0x5972,	0xF7D4},	// CJK UNIFIED IDEOGRAPH
	{0x5973,	0xA46B},	// CJK UNIFIED IDEOGRAPH
	{0x5974,	0xA5A3},	// CJK UNIFIED IDEOGRAPH
	{0x5976,	0xA5A4},	// CJK UNIFIED IDEOGRAPH
	{0x5977,	0xC9D1},	// CJK UNIFIED IDEOGRAPH
	{0x5978,	0xA66C},	// CJK UNIFIED IDEOGRAPH
	{0x5979,	0xA66F},	// CJK UNIFIED IDEOGRAPH
	{0x597B,	0xC9CF},	// CJK UNIFIED IDEOGRAPH
	{0x597C,	0xC9CD},	// CJK UNIFIED IDEOGRAPH
	{0x597D,	0xA66E},	// CJK UNIFIED IDEOGRAPH
	{0x597E,	0xC9D0},	// CJK UNIFIED IDEOGRAPH
	{0x597F,	0xC9D2},	// CJK UNIFIED IDEOGRAPH
	{0x5980,	0xC9CC},	// CJK UNIFIED IDEOGRAPH
	{0x5981,	0xA671},	// CJK UNIFIED IDEOGRAPH
	{0x5982,	0xA670},	// CJK UNIFIED IDEOGRAPH
	{0x5983,	0xA66D},	// CJK UNIFIED IDEOGRAPH
	{0x5984,	0xA66B},	// CJK UNIFIED IDEOGRAPH
	{0x5985,	0xC9CE},	// CJK UNIFIED IDEOGRAPH
	{0x598A,	0xA7B3},	// CJK UNIFIED IDEOGRAPH
	{0x598D,	0xA7B0},	// CJK UNIFIED IDEOGRAPH
	{0x598E,	0xCAB6},	// CJK UNIFIED IDEOGRAPH
	{0x598F,	0xCAB9},	// CJK UNIFIED IDEOGRAPH
	{0x5990,	0xCAB8},	// CJK UNIFIED IDEOGRAPH
	{0x5992,	0xA7AA},	// CJK UNIFIED IDEOGRAPH
	{0x5993,	0xA7B2},	// CJK UNIFIED IDEOGRAPH
	{0x5996,	0xA7AF},	// CJK UNIFIED IDEOGRAPH
	{0x5997,	0xCAB5},	// CJK UNIFIED IDEOGRAPH
	{0x5998,	0xCAB3},	// CJK UNIFIED IDEOGRAPH
	{0x5999,	0xA7AE},	// CJK UNIFIED IDEOGRAPH
	{0x599D,	0xA7A9},	// CJK UNIFIED IDEOGRAPH
	{0x599E,	0xA7AC},	// CJK UNIFIED IDEOGRAPH
	{0x59A0,	0xCAB4},	// CJK UNIFIED IDEOGRAPH
	{0x59A1,	0xCABB},	// CJK UNIFIED IDEOGRAPH
	{0x59A2,	0xCAB7},	// CJK UNIFIED IDEOGRAPH
	{0x59A3,	0xA7AD},	// CJK UNIFIED IDEOGRAPH
	{0x59A4,	0xA7B1},	// CJK UNIFIED IDEOGRAPH
	{0x59A5,	0xA7B4},	// CJK UNIFIED IDEOGRAPH
	{0x59A6,	0xCAB2},	// CJK UNIFIED IDEOGRAPH
	{0x59A7,	0xCABA},	// CJK UNIFIED IDEOGRAPH
	{0x59A8,	0xA7AB},	// CJK UNIFIED IDEOGRAPH
	{0x59AE,	0xA967},	// CJK UNIFIED IDEOGRAPH
	{0x59AF,	0xA96F},	// CJK UNIFIED IDEOGRAPH
	{0x59B1,	0xCC4F},	// CJK UNIFIED IDEOGRAPH
	{0x59B2,	0xCC48},	// CJK UNIFIED IDEOGRAPH
	{0x59B3,	0xA970},	// CJK UNIFIED IDEOGRAPH
	{0x59B4,	0xCC53},	// CJK UNIFIED IDEOGRAPH
	{0x59B5,	0xCC44},	// CJK UNIFIED IDEOGRAPH
	{0x59B6,	0xCC4B},	// CJK UNIFIED IDEOGRAPH
	{0x59B9,	0xA966},	// CJK UNIFIED IDEOGRAPH
	{0x59BA,	0xCC45},	// CJK UNIFIED IDEOGRAPH
	{0x59BB,	0xA964},	// CJK UNIFIED IDEOGRAPH
	{0x59BC,	0xCC4C},	// CJK UNIFIED IDEOGRAPH
	{0x59BD,	0xCC50},	// CJK UNIFIED IDEOGRAPH
	{0x59BE,	0xA963},	// CJK UNIFIED IDEOGRAPH
	{0x59C0,	0xCC51},	// CJK UNIFIED IDEOGRAPH
	{0x59C1,	0xCC4A},	// CJK UNIFIED IDEOGRAPH
	{0x59C3,	0xCC4D},	// CJK UNIFIED IDEOGRAPH
	{0x59C5,	0xA972},	// CJK UNIFIED IDEOGRAPH
	{0x59C6,	0xA969},	// CJK UNIFIED IDEOGRAPH
	{0x59C7,	0xCC54},	// CJK UNIFIED IDEOGRAPH
	{0x59C8,	0xCC52},	// CJK UNIFIED IDEOGRAPH
	{0x59CA,	0xA96E},	// CJK UNIFIED IDEOGRAPH
	{0x59CB,	0xA96C},	// CJK UNIFIED IDEOGRAPH
	{0x59CC,	0xCC49},	// CJK UNIFIED IDEOGRAPH
	{0x59CD,	0xA96B},	// CJK UNIFIED IDEOGRAPH
	{0x59CE,	0xCC47},	// CJK UNIFIED IDEOGRAPH
	{0x59CF,	0xCC46},	// CJK UNIFIED IDEOGRAPH
	{0x59D0,	0xA96A},	// CJK UNIFIED IDEOGRAPH
	{0x59D1,	0xA968},	// CJK UNIFIED IDEOGRAPH
	{0x59D2,	0xA971},	// CJK UNIFIED IDEOGRAPH
	{0x59D3,	0xA96D},	// CJK UNIFIED IDEOGRAPH
	{0x59D4,	0xA965},	// CJK UNIFIED IDEOGRAPH
	{0x59D6,	0xCC4E},	// CJK UNIFIED IDEOGRAPH
	{0x59D8,	0xABB9},	// CJK UNIFIED IDEOGRAPH
	{0x59DA,	0xABC0},	// CJK UNIFIED IDEOGRAPH
	{0x59DB,	0xCE6F},	// CJK UNIFIED IDEOGRAPH
	{0x59DC,	0xABB8},	// CJK UNIFIED IDEOGRAPH
	{0x59DD,	0xCE67},	// CJK UNIFIED IDEOGRAPH
	{0x59DE,	0xCE63},	// CJK UNIFIED IDEOGRAPH
	{0x59E0,	0xCE73},	// CJK UNIFIED IDEOGRAPH
	{0x59E1,	0xCE62},	// CJK UNIFIED IDEOGRAPH
	{0x59E3,	0xABBB},	// CJK UNIFIED IDEOGRAPH
	{0x59E4,	0xCE6C},	// CJK UNIFIED IDEOGRAPH
	{0x59E5,	0xABBE},	// CJK UNIFIED IDEOGRAPH
	{0x59E6,	0xABC1},	// CJK UNIFIED IDEOGRAPH
	{0x59E8,	0xABBC},	// CJK UNIFIED IDEOGRAPH
	{0x59E9,	0xCE70},	// CJK UNIFIED IDEOGRAPH
	{0x59EA,	0xABBF},	// CJK UNIFIED IDEOGRAPH
	{0x59EC,	0xAE56},	// CJK UNIFIED IDEOGRAPH
	{0x59ED,	0xCE76},	// CJK UNIFIED IDEOGRAPH
	{0x59EE,	0xCE64},	// CJK UNIFIED IDEOGRAPH
	{0x59F1,	0xCE66},	// CJK UNIFIED IDEOGRAPH
	{0x59F2,	0xCE6D},	// CJK UNIFIED IDEOGRAPH
	{0x59F3,	0xCE71},	// CJK UNIFIED IDEOGRAPH
	{0x59F4,	0xCE75},	// CJK UNIFIED IDEOGRAPH
	{0x59F5,	0xCE72},	// CJK UNIFIED IDEOGRAPH
	{0x59F6,	0xCE6B},	// CJK UNIFIED IDEOGRAPH
	{0x59F7,	0xCE6E},	// CJK UNIFIED IDEOGRAPH
	{0x59FA,	0xCE68},	// CJK UNIFIED IDEOGRAPH
	{0x59FB,	0xABC3},	// CJK UNIFIED IDEOGRAPH
	{0x59FC,	0xCE6A},	// CJK UNIFIED IDEOGRAPH
	{0x59FD,	0xCE69},	// CJK UNIFIED IDEOGRAPH
	{0x59FE,	0xCE74},	// CJK UNIFIED IDEOGRAPH
	{0x59FF,	0xABBA},	// CJK UNIFIED IDEOGRAPH
	{0x5A00,	0xCE65},	// CJK UNIFIED IDEOGRAPH
	{0x5A01,	0xABC2},	// CJK UNIFIED IDEOGRAPH
	{0x5A03,	0xABBD},	// CJK UNIFIED IDEOGRAPH
	{0x5A09,	0xAE5C},	// CJK UNIFIED IDEOGRAPH
	{0x5A0A,	0xD162},	// CJK UNIFIED IDEOGRAPH
	{0x5A0C,	0xAE5B},	// CJK UNIFIED IDEOGRAPH
	{0x5A0F,	0xD160},	// CJK UNIFIED IDEOGRAPH
	{0x5A11,	0xAE50},	// CJK UNIFIED IDEOGRAPH
	{0x5A13,	0xAE55},	// CJK UNIFIED IDEOGRAPH
	{0x5A15,	0xD15F},	// CJK UNIFIED IDEOGRAPH
	{0x5A16,	0xD15C},	// CJK UNIFIED IDEOGRAPH
	{0x5A17,	0xD161},	// CJK UNIFIED IDEOGRAPH
	{0x5A18,	0xAE51},	// CJK UNIFIED IDEOGRAPH
	{0x5A19,	0xD15B},	// CJK UNIFIED IDEOGRAPH
	{0x5A1B,	0xAE54},	// CJK UNIFIED IDEOGRAPH
	{0x5A1C,	0xAE52},	// CJK UNIFIED IDEOGRAPH
	{0x5A1E,	0xD163},	// CJK UNIFIED IDEOGRAPH
	{0x5A1F,	0xAE53},	// CJK UNIFIED IDEOGRAPH
	{0x5A20,	0xAE57},	// CJK UNIFIED IDEOGRAPH
	{0x5A23,	0xAE58},	// CJK UNIFIED IDEOGRAPH
	{0x5A25,	0xAE5A},	// CJK UNIFIED IDEOGRAPH
	{0x5A29,	0xAE59},	// CJK UNIFIED IDEOGRAPH
	{0x5A2D,	0xD15D},	// CJK UNIFIED IDEOGRAPH
	{0x5A2E,	0xD15E},	// CJK UNIFIED IDEOGRAPH
	{0x5A33,	0xD164},	// CJK UNIFIED IDEOGRAPH
	{0x5A35,	0xD4D4},	// CJK UNIFIED IDEOGRAPH
	{0x5A36,	0xB0F9},	// CJK UNIFIED IDEOGRAPH
	{0x5A37,	0xD8C2},	// CJK UNIFIED IDEOGRAPH
	{0x5A38,	0xD4D3},	// CJK UNIFIED IDEOGRAPH
	{0x5A39,	0xD4E6},	// CJK UNIFIED IDEOGRAPH
	{0x5A3C,	0xB140},	// CJK UNIFIED IDEOGRAPH
	{0x5A3E,	0xD4E4},	// CJK UNIFIED IDEOGRAPH
	{0x5A40,	0xB0FE},	// CJK UNIFIED IDEOGRAPH
	{0x5A41,	0xB0FA},	// CJK UNIFIED IDEOGRAPH
	{0x5A42,	0xD4ED},	// CJK UNIFIED IDEOGRAPH
	{0x5A43,	0xD4DD},	// CJK UNIFIED IDEOGRAPH
	{0x5A44,	0xD4E0},	// CJK UNIFIED IDEOGRAPH
	{0x5A46,	0xB143},	// CJK UNIFIED IDEOGRAPH
	{0x5A47,	0xD4EA},	// CJK UNIFIED IDEOGRAPH
	{0x5A48,	0xD4E2},	// CJK UNIFIED IDEOGRAPH
	{0x5A49,	0xB0FB},	// CJK UNIFIED IDEOGRAPH
	{0x5A4A,	0xB144},	// CJK UNIFIED IDEOGRAPH
	{0x5A4C,	0xD4E7},	// CJK UNIFIED IDEOGRAPH
	{0x5A4D,	0xD4E5},	// CJK UNIFIED IDEOGRAPH
	{0x5A50,	0xD4D6},	// CJK UNIFIED IDEOGRAPH
	{0x5A51,	0xD4EB},	// CJK UNIFIED IDEOGRAPH
	{0x5A52,	0xD4DF},	// CJK UNIFIED IDEOGRAPH
	{0x5A53,	0xD4DA},	// CJK UNIFIED IDEOGRAPH
	{0x5A55,	0xD4D0},	// CJK UNIFIED IDEOGRAPH
	{0x5A56,	0xD4EC},	// CJK UNIFIED IDEOGRAPH
	{0x5A57,	0xD4DC},	// CJK UNIFIED IDEOGRAPH
	{0x5A58,	0xD4CF},	// CJK UNIFIED IDEOGRAPH
	{0x5A5A,	0xB142},	// CJK UNIFIED IDEOGRAPH
	{0x5A5B,	0xD4E1},	// CJK UNIFIED IDEOGRAPH
	{0x5A5C,	0xD4EE},	// CJK UNIFIED IDEOGRAPH
	{0x5A5D,	0xD4DE},	// CJK UNIFIED IDEOGRAPH
	{0x5A5E,	0xD4D2},	// CJK UNIFIED IDEOGRAPH
	{0x5A5F,	0xD4D7},	// CJK UNIFIED IDEOGRAPH
	{0x5A60,	0xD4CE},	// CJK UNIFIED IDEOGRAPH
	{0x5A62,	0xB141},	// CJK UNIFIED IDEOGRAPH
	{0x5A64,	0xD4DB},	// CJK UNIFIED IDEOGRAPH
	{0x5A65,	0xD4D8},	// CJK UNIFIED IDEOGRAPH
	{0x5A66,	0xB0FC},	// CJK UNIFIED IDEOGRAPH
	{0x5A67,	0xD4D1},	// CJK UNIFIED IDEOGRAPH
	{0x5A69,	0xD4E9},	// CJK UNIFIED IDEOGRAPH
	{0x5A6A,	0xB0FD},	// CJK UNIFIED IDEOGRAPH
	{0x5A6C,	0xD4D9},	// CJK UNIFIED IDEOGRAPH
	{0x5A6D,	0xD4D5},	// CJK UNIFIED IDEOGRAPH
	{0x5A70,	0xD4E8},	// CJK UNIFIED IDEOGRAPH
	{0x5A77,	0xB440},	// CJK UNIFIED IDEOGRAPH
	{0x5A78,	0xD8BB},	// CJK UNIFIED IDEOGRAPH
	{0x5A7A,	0xD8B8},	// CJK UNIFIED IDEOGRAPH
	{0x5A7B,	0xD8C9},	// CJK UNIFIED IDEOGRAPH
	{0x5A7C,	0xD8BD},	// CJK UNIFIED IDEOGRAPH
	{0x5A7D,	0xD8CA},	// CJK UNIFIED IDEOGRAPH
	{0x5A7F,	0xB442},	// CJK UNIFIED IDEOGRAPH
	{0x5A83,	0xD8C6},	// CJK UNIFIED IDEOGRAPH
	{0x5A84,	0xD8C3},	// CJK UNIFIED IDEOGRAPH
	{0x5A8A,	0xD8C4},	// CJK UNIFIED IDEOGRAPH
	{0x5A8B,	0xD8C7},	// CJK UNIFIED IDEOGRAPH
	{0x5A8C,	0xD8CB},	// CJK UNIFIED IDEOGRAPH
	{0x5A8E,	0xD4E3},	// CJK UNIFIED IDEOGRAPH
	{0x5A8F,	0xD8CD},	// CJK UNIFIED IDEOGRAPH
	{0x5A90,	0xDD47},	// CJK UNIFIED IDEOGRAPH
	{0x5A92,	0xB443},	// CJK UNIFIED IDEOGRAPH
	{0x5A93,	0xD8CE},	// CJK UNIFIED IDEOGRAPH
	{0x5A94,	0xD8B6},	// CJK UNIFIED IDEOGRAPH
	{0x5A95,	0xD8C0},	// CJK UNIFIED IDEOGRAPH
	{0x5A97,	0xD8C5},	// CJK UNIFIED IDEOGRAPH
	{0x5A9A,	0xB441},	// CJK UNIFIED IDEOGRAPH
	{0x5A9B,	0xB444},	// CJK UNIFIED IDEOGRAPH
	{0x5A9C,	0xD8CC},	// CJK UNIFIED IDEOGRAPH
	{0x5A9D,	0xD8CF},	// CJK UNIFIED IDEOGRAPH
	{0x5A9E,	0xD8BA},	// CJK UNIFIED IDEOGRAPH
	{0x5A9F,	0xD8B7},	// CJK UNIFIED IDEOGRAPH
	{0x5AA2,	0xD8B9},	// CJK UNIFIED IDEOGRAPH
	{0x5AA5,	0xD8BE},	// CJK UNIFIED IDEOGRAPH
	{0x5AA6,	0xD8BC},	// CJK UNIFIED IDEOGRAPH
	{0x5AA7,	0xB445},	// CJK UNIFIED IDEOGRAPH
	{0x5AA9,	0xD8C8},	// CJK UNIFIED IDEOGRAPH
	{0x5AAC,	0xD8BF},	// CJK UNIFIED IDEOGRAPH
	{0x5AAE,	0xD8C1},	// CJK UNIFIED IDEOGRAPH
	{0x5AAF,	0xD8B5},	// CJK UNIFIED IDEOGRAPH
	{0x5AB0,	0xDCFA},	// CJK UNIFIED IDEOGRAPH
	{0x5AB1,	0xDCF8},	// CJK UNIFIED IDEOGRAPH
	{0x5AB2,	0xB742},	// CJK UNIFIED IDEOGRAPH
	{0x5AB3,	0xB740},	// CJK UNIFIED IDEOGRAPH
	{0x5AB4,	0xDD43},	// CJK UNIFIED IDEOGRAPH
	{0x5AB5,	0xDCF9},	// CJK UNIFIED IDEOGRAPH
	{0x5AB6,	0xDD44},	// CJK UNIFIED IDEOGRAPH
	{0x5AB7,	0xDD40},	// CJK UNIFIED IDEOGRAPH
	{0x5AB8,	0xDCF7},	// CJK UNIFIED IDEOGRAPH
	{0x5AB9,	0xDD46},	// CJK UNIFIED IDEOGRAPH
	{0x5ABA,	0xDCF6},	// CJK UNIFIED IDEOGRAPH
	{0x5ABB,	0xDCFD},	// CJK UNIFIED IDEOGRAPH
	{0x5ABC,	0xB6FE},	// CJK UNIFIED IDEOGRAPH
	{0x5ABD,	0xB6FD},	// CJK UNIFIED IDEOGRAPH
	{0x5ABE,	0xB6FC},	// CJK UNIFIED IDEOGRAPH
	{0x5ABF,	0xDCFB},	// CJK UNIFIED IDEOGRAPH
	{0x5AC0,	0xDD41},	// CJK UNIFIED IDEOGRAPH
	{0x5AC1,	0xB6F9},	// CJK UNIFIED IDEOGRAPH
	{0x5AC2,	0xB741},	// CJK UNIFIED IDEOGRAPH
	{0x5AC4,	0xDCF4},	// CJK UNIFIED IDEOGRAPH
	{0x5AC6,	0xDCFE},	// CJK UNIFIED IDEOGRAPH
	{0x5AC7,	0xDCF3},	// CJK UNIFIED IDEOGRAPH
	{0x5AC8,	0xDCFC},	// CJK UNIFIED IDEOGRAPH
	{0x5AC9,	0xB6FA},	// CJK UNIFIED IDEOGRAPH
	{0x5ACA,	0xDD42},	// CJK UNIFIED IDEOGRAPH
	{0x5ACB,	0xDCF5},	// CJK UNIFIED IDEOGRAPH
	{0x5ACC,	0xB6FB},	// CJK UNIFIED IDEOGRAPH
	{0x5ACD,	0xDD45},	// CJK UNIFIED IDEOGRAPH
	{0x5AD5,	0xE16E},	// CJK UNIFIED IDEOGRAPH
	{0x5AD6,	0xB9E2},	// CJK UNIFIED IDEOGRAPH
	{0x5AD7,	0xB9E1},	// CJK UNIFIED IDEOGRAPH
	{0x5AD8,	0xB9E3},	// CJK UNIFIED IDEOGRAPH
	{0x5AD9,	0xE17A},	// CJK UNIFIED IDEOGRAPH
	{0x5ADA,	0xE170},	// CJK UNIFIED IDEOGRAPH
	{0x5ADB,	0xE176},	// CJK UNIFIED IDEOGRAPH
	{0x5ADC,	0xE16B},	// CJK UNIFIED IDEOGRAPH
	{0x5ADD,	0xE179},	// CJK UNIFIED IDEOGRAPH
	{0x5ADE,	0xE178},	// CJK UNIFIED IDEOGRAPH
	{0x5ADF,	0xE17C},	// CJK UNIFIED IDEOGRAPH
	{0x5AE0,	0xE175},	// CJK UNIFIED IDEOGRAPH
	{0x5AE1,	0xB9DE},	// CJK UNIFIED IDEOGRAPH
	{0x5AE2,	0xE174},	// CJK UNIFIED IDEOGRAPH
	{0x5AE3,	0xB9E4},	// CJK UNIFIED IDEOGRAPH
	{0x5AE5,	0xE16D},	// CJK UNIFIED IDEOGRAPH
	{0x5AE6,	0xB9DF},	// CJK UNIFIED IDEOGRAPH
	{0x5AE8,	0xE17B},	// CJK UNIFIED IDEOGRAPH
	{0x5AE9,	0xB9E0},	// CJK UNIFIED IDEOGRAPH
	{0x5AEA,	0xE16F},	// CJK UNIFIED IDEOGRAPH
	{0x5AEB,	0xE172},	// CJK UNIFIED IDEOGRAPH
	{0x5AEC,	0xE177},	// CJK UNIFIED IDEOGRAPH
	{0x5AED,	0xE171},	// CJK UNIFIED IDEOGRAPH
	{0x5AEE,	0xE16C},	// CJK UNIFIED IDEOGRAPH
	{0x5AF3,	0xE173},	// CJK UNIFIED IDEOGRAPH
	{0x5AF4,	0xE555},	// CJK UNIFIED IDEOGRAPH
	{0x5AF5,	0xBC61},	// CJK UNIFIED IDEOGRAPH
	{0x5AF6,	0xE558},	// CJK UNIFIED IDEOGRAPH
	{0x5AF7,	0xE557},	// CJK UNIFIED IDEOGRAPH
	{0x5AF8,	0xE55A},	// CJK UNIFIED IDEOGRAPH
	{0x5AF9,	0xE55C},	// CJK UNIFIED IDEOGRAPH
	{0x5AFA,	0xF9DC},	// CJK UNIFIED IDEOGRAPH
	{0x5AFB,	0xBC5F},	// CJK UNIFIED IDEOGRAPH
	{0x5AFD,	0xE556},	// CJK UNIFIED IDEOGRAPH
	{0x5AFF,	0xE554},	// CJK UNIFIED IDEOGRAPH
	{0x5B01,	0xE55D},	// CJK UNIFIED IDEOGRAPH
	{0x5B02,	0xE55B},	// CJK UNIFIED IDEOGRAPH
	{0x5B03,	0xE559},	// CJK UNIFIED IDEOGRAPH
	{0x5B05,	0xE55F},	// CJK UNIFIED IDEOGRAPH
	{0x5B07,	0xE55E},	// CJK UNIFIED IDEOGRAPH
	{0x5B08,	0xBC63},	// CJK UNIFIED IDEOGRAPH
	{0x5B09,	0xBC5E},	// CJK UNIFIED IDEOGRAPH
	{0x5B0B,	0xBC60},	// CJK UNIFIED IDEOGRAPH
	{0x5B0C,	0xBC62},	// CJK UNIFIED IDEOGRAPH
	{0x5B0F,	0xE560},	// CJK UNIFIED IDEOGRAPH
	{0x5B10,	0xE957},	// CJK UNIFIED IDEOGRAPH
	{0x5B13,	0xE956},	// CJK UNIFIED IDEOGRAPH
	{0x5B14,	0xE955},	// CJK UNIFIED IDEOGRAPH
	{0x5B16,	0xE958},	// CJK UNIFIED IDEOGRAPH
	{0x5B17,	0xE951},	// CJK UNIFIED IDEOGRAPH
	{0x5B19,	0xE952},	// CJK UNIFIED IDEOGRAPH
	{0x5B1A,	0xE95A},	// CJK UNIFIED IDEOGRAPH
	{0x5B1B,	0xE953},	// CJK UNIFIED IDEOGRAPH
	{0x5B1D,	0xBEC5},	// CJK UNIFIED IDEOGRAPH
	{0x5B1E,	0xE95C},	// CJK UNIFIED IDEOGRAPH
	{0x5B20,	0xE95B},	// CJK UNIFIED IDEOGRAPH
	{0x5B21,	0xE954},	// CJK UNIFIED IDEOGRAPH
	{0x5B23,	0xECD1},	// CJK UNIFIED IDEOGRAPH
	{0x5B24,	0xC0A8},	// CJK UNIFIED IDEOGRAPH
	{0x5B25,	0xECCF},	// CJK UNIFIED IDEOGRAPH
	{0x5B26,	0xECD4},	// CJK UNIFIED IDEOGRAPH
	{0x5B27,	0xECD3},	// CJK UNIFIED IDEOGRAPH
	{0x5B28,	0xE959},	// CJK UNIFIED IDEOGRAPH
	{0x5B2A,	0xC0A7},	// CJK UNIFIED IDEOGRAPH
	{0x5B2C,	0xECD2},	// CJK UNIFIED IDEOGRAPH
	{0x5B2D,	0xECCE},	// CJK UNIFIED IDEOGRAPH
	{0x5B2E,	0xECD6},	// CJK UNIFIED IDEOGRAPH
	{0x5B2F,	0xECD5},	// CJK UNIFIED IDEOGRAPH
	{0x5B30,	0xC0A6},	// CJK UNIFIED IDEOGRAPH
	{0x5B32,	0xECD0},	// CJK UNIFIED IDEOGRAPH
	{0x5B34,	0xBEC6},	// CJK UNIFIED IDEOGRAPH
	{0x5B38,	0xC254},	// CJK UNIFIED IDEOGRAPH
	{0x5B3C,	0xEFC1},	// CJK UNIFIED IDEOGRAPH
	{0x5B3D,	0xF1FA},	// CJK UNIFIED IDEOGRAPH
	{0x5B3E,	0xF1FB},	// CJK UNIFIED IDEOGRAPH
	{0x5B3F,	0xF1FC},	// CJK UNIFIED IDEOGRAPH
	{0x5B40,	0xC45C},	// CJK UNIFIED IDEOGRAPH
	{0x5B43,	0xC45D},	// CJK UNIFIED IDEOGRAPH
	{0x5B45,	0xF443},	// CJK UNIFIED IDEOGRAPH
	{0x5B47,	0xF5C8},	// CJK UNIFIED IDEOGRAPH
	{0x5B48,	0xF5C7},	// CJK UNIFIED IDEOGRAPH
	{0x5B4B,	0xF6DB},	// CJK UNIFIED IDEOGRAPH
	{0x5B4C,	0xF6DC},	// CJK UNIFIED IDEOGRAPH
	{0x5B4D,	0xF7D5},	// CJK UNIFIED IDEOGRAPH
	{0x5B4E,	0xF8A7},	// CJK UNIFIED IDEOGRAPH
	{0x5B50,	0xA46C},	// CJK UNIFIED IDEOGRAPH
	{0x5B51,	0xA46D},	// CJK UNIFIED IDEOGRAPH
	{0x5B53,	0xA46E},	// CJK UNIFIED IDEOGRAPH
	{0x5B54,	0xA4D5},	// CJK UNIFIED IDEOGRAPH
	{0x5B55,	0xA5A5},	// CJK UNIFIED IDEOGRAPH
	{0x5B56,	0xC9D3},	// CJK UNIFIED IDEOGRAPH
	{0x5B57,	0xA672},	// CJK UNIFIED IDEOGRAPH
	{0x5B58,	0xA673},	// CJK UNIFIED IDEOGRAPH
	{0x5B5A,	0xA7B7},	// CJK UNIFIED IDEOGRAPH
	{0x5B5B,	0xA7B8},	// CJK UNIFIED IDEOGRAPH
	{0x5B5C,	0xA7B6},	// CJK UNIFIED IDEOGRAPH
	{0x5B5D,	0xA7B5},	// CJK UNIFIED IDEOGRAPH
	{0x5B5F,	0xA973},	// CJK UNIFIED IDEOGRAPH
	{0x5B62,	0xCC55},	// CJK UNIFIED IDEOGRAPH
	{0x5B63,	0xA975},	// CJK UNIFIED IDEOGRAPH
	{0x5B64,	0xA974},	// CJK UNIFIED IDEOGRAPH
	{0x5B65,	0xCC56},	// CJK UNIFIED IDEOGRAPH
	{0x5B69,	0xABC4},	// CJK UNIFIED IDEOGRAPH
	{0x5B6B,	0xAE5D},	// CJK UNIFIED IDEOGRAPH
	{0x5B6C,	0xD165},	// CJK UNIFIED IDEOGRAPH
	{0x5B6E,	0xD4F0},	// CJK UNIFIED IDEOGRAPH
	{0x5B70,	0xB145},	// CJK UNIFIED IDEOGRAPH
	{0x5B71,	0xB447},	// CJK UNIFIED IDEOGRAPH
	{0x5B72,	0xD4EF},	// CJK UNIFIED IDEOGRAPH
	{0x5B73,	0xB446},	// CJK UNIFIED IDEOGRAPH
	{0x5B75,	0xB9E5},	// CJK UNIFIED IDEOGRAPH
	{0x5B77,	0xE17D},	// CJK UNIFIED IDEOGRAPH
	{0x5B78,	0xBEC7},	// CJK UNIFIED IDEOGRAPH
	{0x5B7A,	0xC0A9},	// CJK UNIFIED IDEOGRAPH
	{0x5B7B,	0xECD7},	// CJK UNIFIED IDEOGRAPH
	{0x5B7D,	0xC45E},	// CJK UNIFIED IDEOGRAPH
	{0x5B7F,	0xC570},	// CJK UNIFIED IDEOGRAPH
	{0x5B81,	0xC972},	// CJK UNIFIED IDEOGRAPH
	{0x5B83,	0xA5A6},	// CJK UNIFIED IDEOGRAPH
	{0x5B84,	0xC973},	// CJK UNIFIED IDEOGRAPH
	{0x5B85,	0xA676},	// CJK UNIFIED IDEOGRAPH
	{0x5B87,	0xA674},	// CJK UNIFIED IDEOGRAPH
	{0x5B88,	0xA675},	// CJK UNIFIED IDEOGRAPH
	{0x5B89,	0xA677},	// CJK UNIFIED IDEOGRAPH
	{0x5B8B,	0xA7BA},	// CJK UNIFIED IDEOGRAPH
	{0x5B8C,	0xA7B9},	// CJK UNIFIED IDEOGRAPH
	{0x5B8E,	0xCABC},	// CJK UNIFIED IDEOGRAPH
	{0x5B8F,	0xA7BB},	// CJK UNIFIED IDEOGRAPH
	{0x5B92,	0xCABD},	// CJK UNIFIED IDEOGRAPH
	{0x5B93,	0xCC57},	// CJK UNIFIED IDEOGRAPH
	{0x5B95,	0xCC58},	// CJK UNIFIED IDEOGRAPH
	{0x5B97,	0xA976},	// CJK UNIFIED IDEOGRAPH
	{0x5B98,	0xA978},	// CJK UNIFIED IDEOGRAPH
	{0x5B99,	0xA97A},	// CJK UNIFIED IDEOGRAPH
	{0x5B9A,	0xA977},	// CJK UNIFIED IDEOGRAPH
	{0x5B9B,	0xA97B},	// CJK UNIFIED IDEOGRAPH
	{0x5B9C,	0xA979},	// CJK UNIFIED IDEOGRAPH
	{0x5BA2,	0xABC8},	// CJK UNIFIED IDEOGRAPH
	{0x5BA3,	0xABC5},	// CJK UNIFIED IDEOGRAPH
	{0x5BA4,	0xABC7},	// CJK UNIFIED IDEOGRAPH
	{0x5BA5,	0xABC9},	// CJK UNIFIED IDEOGRAPH
	{0x5BA6,	0xABC6},	// CJK UNIFIED IDEOGRAPH
	{0x5BA7,	0xD166},	// CJK UNIFIED IDEOGRAPH
	{0x5BA8,	0xCE77},	// CJK UNIFIED IDEOGRAPH
	{0x5BAC,	0xD168},	// CJK UNIFIED IDEOGRAPH
	{0x5BAD,	0xD167},	// CJK UNIFIED IDEOGRAPH
	{0x5BAE,	0xAE63},	// CJK UNIFIED IDEOGRAPH
	{0x5BB0,	0xAE5F},	// CJK UNIFIED IDEOGRAPH
	{0x5BB3,	0xAE60},	// CJK UNIFIED IDEOGRAPH
	{0x5BB4,	0xAE62},	// CJK UNIFIED IDEOGRAPH
	{0x5BB5,	0xAE64},	// CJK UNIFIED IDEOGRAPH
	{0x5BB6,	0xAE61},	// CJK UNIFIED IDEOGRAPH
	{0x5BB8,	0xAE66},	// CJK UNIFIED IDEOGRAPH
	{0x5BB9,	0xAE65},	// CJK UNIFIED IDEOGRAPH
	{0x5BBF,	0xB14A},	// CJK UNIFIED IDEOGRAPH
	{0x5BC0,	0xD4F2},	// CJK UNIFIED IDEOGRAPH
	{0x5BC1,	0xD4F1},	// CJK UNIFIED IDEOGRAPH
	{0x5BC2,	0xB149},	// CJK UNIFIED IDEOGRAPH
	{0x5BC4,	0xB148},	// CJK UNIFIED IDEOGRAPH
	{0x5BC5,	0xB147},	// CJK UNIFIED IDEOGRAPH
	{0x5BC6,	0xB14B},	// CJK UNIFIED IDEOGRAPH
	{0x5BC7,	0xB146},	// CJK UNIFIED IDEOGRAPH
	{0x5BCA,	0xD8D5},	// CJK UNIFIED IDEOGRAPH
	{0x5BCB,	0xD8D2},	// CJK UNIFIED IDEOGRAPH
	{0x5BCC,	0xB449},	// CJK UNIFIED IDEOGRAPH
	{0x5BCD,	0xD8D1},	// CJK UNIFIED IDEOGRAPH
	{0x5BCE,	0xD8D6},	// CJK UNIFIED IDEOGRAPH
	{0x5BD0,	0xB44B},	// CJK UNIFIED IDEOGRAPH
	{0x5BD1,	0xD8D4},	// CJK UNIFIED IDEOGRAPH
	{0x5BD2,	0xB448},	// CJK UNIFIED IDEOGRAPH
	{0x5BD3,	0xB44A},	// CJK UNIFIED IDEOGRAPH
	{0x5BD4,	0xD8D3},	// CJK UNIFIED IDEOGRAPH
	{0x5BD6,	0xDD48},	// CJK UNIFIED IDEOGRAPH
	{0x5BD8,	0xDD49},	// CJK UNIFIED IDEOGRAPH
	{0x5BD9,	0xDD4A},	// CJK UNIFIED IDEOGRAPH
	{0x5BDE,	0xB9E6},	// CJK UNIFIED IDEOGRAPH
	{0x5BDF,	0xB9EE},	// CJK UNIFIED IDEOGRAPH
	{0x5BE0,	0xE17E},	// CJK UNIFIED IDEOGRAPH
	{0x5BE1,	0xB9E8},	// CJK UNIFIED IDEOGRAPH
	{0x5BE2,	0xB9EC},	// CJK UNIFIED IDEOGRAPH
	{0x5BE3,	0xE1A1},	// CJK UNIFIED IDEOGRAPH
	{0x5BE4,	0xB9ED},	// CJK UNIFIED IDEOGRAPH
	{0x5BE5,	0xB9E9},	// CJK UNIFIED IDEOGRAPH
	{0x5BE6,	0xB9EA},	// CJK UNIFIED IDEOGRAPH
	{0x5BE7,	0xB9E7},	// CJK UNIFIED IDEOGRAPH
	{0x5BE8,	0xB9EB},	// CJK UNIFIED IDEOGRAPH
	{0x5BE9,	0xBC66},	// CJK UNIFIED IDEOGRAPH
	{0x5BEA,	0xD8D0},	// CJK UNIFIED IDEOGRAPH
	{0x5BEB,	0xBC67},	// CJK UNIFIED IDEOGRAPH
	{0x5BEC,	0xBC65},	// CJK UNIFIED IDEOGRAPH
	{0x5BEE,	0xBC64},	// CJK UNIFIED IDEOGRAPH
	{0x5BEF,	0xE95D},	// CJK UNIFIED IDEOGRAPH
	{0x5BF0,	0xBEC8},	// CJK UNIFIED IDEOGRAPH
	{0x5BF1,	0xECD8},	// CJK UNIFIED IDEOGRAPH
	{0x5BF2,	0xECD9},	// CJK UNIFIED IDEOGRAPH
	{0x5BF5,	0xC364},	// CJK UNIFIED IDEOGRAPH
	{0x5BF6,	0xC45F},	// CJK UNIFIED IDEOGRAPH
	{0x5BF8,	0xA46F},	// CJK UNIFIED IDEOGRAPH
	{0x5BFA,	0xA678},	// CJK UNIFIED IDEOGRAPH
	{0x5C01,	0xABCA},	// CJK UNIFIED IDEOGRAPH
	{0x5C03,	0xD169},	// CJK UNIFIED IDEOGRAPH
	{0x5C04,	0xAE67},	// CJK UNIFIED IDEOGRAPH
	{0x5C07,	0xB14E},	// CJK UNIFIED IDEOGRAPH
	{0x5C08,	0xB14D},	// CJK UNIFIED IDEOGRAPH
	{0x5C09,	0xB14C},	// CJK UNIFIED IDEOGRAPH
	{0x5C0A,	0xB44C},	// CJK UNIFIED IDEOGRAPH
	{0x5C0B,	0xB44D},	// CJK UNIFIED IDEOGRAPH
	{0x5C0C,	0xD8D7},	// CJK UNIFIED IDEOGRAPH
	{0x5C0D,	0xB9EF},	// CJK UNIFIED IDEOGRAPH
	{0x5C0E,	0xBEC9},	// CJK UNIFIED IDEOGRAPH
	{0x5C0F,	0xA470},	// CJK UNIFIED IDEOGRAPH
	{0x5C10,	0xC95C},	// CJK UNIFIED IDEOGRAPH
	{0x5C11,	0xA4D6},	// CJK UNIFIED IDEOGRAPH
	{0x5C12,	0xC974},	// CJK UNIFIED IDEOGRAPH
	{0x5C15,	0xC9D4},	// CJK UNIFIED IDEOGRAPH
	{0x5C16,	0xA679},	// CJK UNIFIED IDEOGRAPH
	{0x5C1A,	0xA97C},	// CJK UNIFIED IDEOGRAPH
	{0x5C1F,	0xDD4B},	// CJK UNIFIED IDEOGRAPH
	{0x5C22,	0xA471},	// CJK UNIFIED IDEOGRAPH
	{0x5C24,	0xA4D7},	// CJK UNIFIED IDEOGRAPH
	{0x5C25,	0xC9D5},	// CJK UNIFIED IDEOGRAPH
	{0x5C28,	0xCABE},	// CJK UNIFIED IDEOGRAPH
	{0x5C2A,	0xCABF},	// CJK UNIFIED IDEOGRAPH
	{0x5C2C,	0xA7BC},	// CJK UNIFIED IDEOGRAPH
	{0x5C30,	0xD8D8},	// CJK UNIFIED IDEOGRAPH
	{0x5C31,	0xB44E},	// CJK UNIFIED IDEOGRAPH
	{0x5C33,	0xDD4C},	// CJK UNIFIED IDEOGRAPH
	{0x5C37,	0xC0AA},	// CJK UNIFIED IDEOGRAPH
	{0x5C38,	0xA472},	// CJK UNIFIED IDEOGRAPH
	{0x5C39,	0xA4A8},	// CJK UNIFIED IDEOGRAPH
	{0x5C3A,	0xA4D8},	// CJK UNIFIED IDEOGRAPH
	{0x5C3B,	0xC975},	// CJK UNIFIED IDEOGRAPH
	{0x5C3C,	0xA5A7},	// CJK UNIFIED IDEOGRAPH
	{0x5C3E,	0xA7C0},	// CJK UNIFIED IDEOGRAPH
	{0x5C3F,	0xA7BF},	// CJK UNIFIED IDEOGRAPH
	{0x5C40,	0xA7BD},	// CJK UNIFIED IDEOGRAPH
	{0x5C41,	0xA7BE},	// CJK UNIFIED IDEOGRAPH
	{0x5C44,	0xCC59},	// CJK UNIFIED IDEOGRAPH
	{0x5C45,	0xA97E},	// CJK UNIFIED IDEOGRAPH
	{0x5C46,	0xA9A1},	// CJK UNIFIED IDEOGRAPH
	{0x5C47,	0xCC5A},	// CJK UNIFIED IDEOGRAPH
	{0x5C48,	0xA97D},	// CJK UNIFIED IDEOGRAPH
	{0x5C4B,	0xABCE},	// CJK UNIFIED IDEOGRAPH
	{0x5C4C,	0xCE78},	// CJK UNIFIED IDEOGRAPH
	{0x5C4D,	0xABCD},	// CJK UNIFIED IDEOGRAPH
	{0x5C4E,	0xABCB},	// CJK UNIFIED IDEOGRAPH
	{0x5C4F,	0xABCC},	// CJK UNIFIED IDEOGRAPH
	{0x5C50,	0xAE6A},	// CJK UNIFIED IDEOGRAPH
	{0x5C51,	0xAE68},	// CJK UNIFIED IDEOGRAPH
	{0x5C54,	0xD16B},	// CJK UNIFIED IDEOGRAPH
	{0x5C55,	0xAE69},	// CJK UNIFIED IDEOGRAPH
	{0x5C56,	0xD16A},	// CJK UNIFIED IDEOGRAPH
	{0x5C58,	0xAE5E},	// CJK UNIFIED IDEOGRAPH
	{0x5C59,	0xD4F3},	// CJK UNIFIED IDEOGRAPH
	{0x5C5C,	0xB150},	// CJK UNIFIED IDEOGRAPH
	{0x5C5D,	0xB151},	// CJK UNIFIED IDEOGRAPH
	{0x5C60,	0xB14F},	// CJK UNIFIED IDEOGRAPH
	{0x5C62,	0xB9F0},	// CJK UNIFIED IDEOGRAPH
	{0x5C63,	0xE1A2},	// CJK UNIFIED IDEOGRAPH
	{0x5C64,	0xBC68},	// CJK UNIFIED IDEOGRAPH
	{0x5C65,	0xBC69},	// CJK UNIFIED IDEOGRAPH
	{0x5C67,	0xE561},	// CJK UNIFIED IDEOGRAPH
	{0x5C68,	0xC0AB},	// CJK UNIFIED IDEOGRAPH
	{0x5C69,	0xEFC2},	// CJK UNIFIED IDEOGRAPH
	{0x5C6A,	0xEFC3},	// CJK UNIFIED IDEOGRAPH
	{0x5C6C,	0xC4DD},	// CJK UNIFIED IDEOGRAPH
	{0x5C6D,	0xF8A8},	// CJK UNIFIED IDEOGRAPH
	{0x5C6E,	0xC94B},	// CJK UNIFIED IDEOGRAPH
	{0x5C6F,	0xA4D9},	// CJK UNIFIED IDEOGRAPH
	{0x5C71,	0xA473},	// CJK UNIFIED IDEOGRAPH
	{0x5C73,	0xC977},	// CJK UNIFIED IDEOGRAPH
	{0x5C74,	0xC976},	// CJK UNIFIED IDEOGRAPH
	{0x5C79,	0xA67A},	// CJK UNIFIED IDEOGRAPH
	{0x5C7A,	0xC9D7},	// CJK UNIFIED IDEOGRAPH
	{0x5C7B,	0xC9D8},	// CJK UNIFIED IDEOGRAPH
	{0x5C7C,	0xC9D6},	// CJK UNIFIED IDEOGRAPH
	{0x5C7E,	0xC9D9},	// CJK UNIFIED IDEOGRAPH
	{0x5C86,	0xCAC7},	// CJK UNIFIED IDEOGRAPH
	{0x5C88,	0xCAC2},	// CJK UNIFIED IDEOGRAPH
	{0x5C89,	0xCAC4},	// CJK UNIFIED IDEOGRAPH
	{0x5C8A,	0xCAC6},	// CJK UNIFIED IDEOGRAPH
	{0x5C8B,	0xCAC3},	// CJK UNIFIED IDEOGRAPH
	{0x5C8C,	0xA7C4},	// CJK UNIFIED IDEOGRAPH
	{0x5C8D,	0xCAC0},	// CJK UNIFIED IDEOGRAPH
	{0x5C8F,	0xCAC1},	// CJK UNIFIED IDEOGRAPH
	{0x5C90,	0xA7C1},	// CJK UNIFIED IDEOGRAPH
	{0x5C91,	0xA7C2},	// CJK UNIFIED IDEOGRAPH
	{0x5C92,	0xCAC5},	// CJK UNIFIED IDEOGRAPH
	{0x5C93,	0xCAC8},	// CJK UNIFIED IDEOGRAPH
	{0x5C94,	0xA7C3},	// CJK UNIFIED IDEOGRAPH
	{0x5C95,	0xCAC9},	// CJK UNIFIED IDEOGRAPH
	{0x5C9D,	0xCC68},	// CJK UNIFIED IDEOGRAPH
	{0x5C9F,	0xCC62},	// CJK UNIFIED IDEOGRAPH
	{0x5CA0,	0xCC5D},	// CJK UNIFIED IDEOGRAPH
	{0x5CA1,	0xA9A3},	// CJK UNIFIED IDEOGRAPH
	{0x5CA2,	0xCC65},	// CJK UNIFIED IDEOGRAPH
	{0x5CA3,	0xCC63},	// CJK UNIFIED IDEOGRAPH
	{0x5CA4,	0xCC5C},	// CJK UNIFIED IDEOGRAPH
	{0x5CA5,	0xCC69},	// CJK UNIFIED IDEOGRAPH
	{0x5CA6,	0xCC6C},	// CJK UNIFIED IDEOGRAPH
	{0x5CA7,	0xCC67},	// CJK UNIFIED IDEOGRAPH
	{0x5CA8,	0xCC60},	// CJK UNIFIED IDEOGRAPH
	{0x5CA9,	0xA9A5},	// CJK UNIFIED IDEOGRAPH
	{0x5CAA,	0xCC66},	// CJK UNIFIED IDEOGRAPH
	{0x5CAB,	0xA9A6},	// CJK UNIFIED IDEOGRAPH
	{0x5CAC,	0xCC61},	// CJK UNIFIED IDEOGRAPH
	{0x5CAD,	0xCC64},	// CJK UNIFIED IDEOGRAPH
	{0x5CAE,	0xCC5B},	// CJK UNIFIED IDEOGRAPH
	{0x5CAF,	0xCC5F},	// CJK UNIFIED IDEOGRAPH
	{0x5CB0,	0xCC6B},	// CJK UNIFIED IDEOGRAPH
	{0x5CB1,	0xA9A7},	// CJK UNIFIED IDEOGRAPH
	{0x5CB3,	0xA9A8},	// CJK UNIFIED IDEOGRAPH
	{0x5CB5,	0xCC5E},	// CJK UNIFIED IDEOGRAPH
	{0x5CB6,	0xCC6A},	// CJK UNIFIED IDEOGRAPH
	{0x5CB7,	0xA9A2},	// CJK UNIFIED IDEOGRAPH
	{0x5CB8,	0xA9A4},	// CJK UNIFIED IDEOGRAPH
	{0x5CC6,	0xCEAB},	// CJK UNIFIED IDEOGRAPH
	{0x5CC7,	0xCEA4},	// CJK UNIFIED IDEOGRAPH
	{0x5CC8,	0xCEAA},	// CJK UNIFIED IDEOGRAPH
	{0x5CC9,	0xCEA3},	// CJK UNIFIED IDEOGRAPH
	{0x5CCA,	0xCEA5},	// CJK UNIFIED IDEOGRAPH
	{0x5CCB,	0xCE7D},	// CJK UNIFIED IDEOGRAPH
	{0x5CCC,	0xCE7B},	// CJK UNIFIED IDEOGRAPH
	{0x5CCE,	0xCEAC},	// CJK UNIFIED IDEOGRAPH
	{0x5CCF,	0xCEA9},	// CJK UNIFIED IDEOGRAPH
	{0x5CD0,	0xCE79},	// CJK UNIFIED IDEOGRAPH
	{0x5CD2,	0xABD0},	// CJK UNIFIED IDEOGRAPH
	{0x5CD3,	0xCEA7},	// CJK UNIFIED IDEOGRAPH
	{0x5CD4,	0xCEA8},	// CJK UNIFIED IDEOGRAPH
	{0x5CD6,	0xCEA6},	// CJK UNIFIED IDEOGRAPH
	{0x5CD7,	0xCE7C},	// CJK UNIFIED IDEOGRAPH
	{0x5CD8,	0xCE7A},	// CJK UNIFIED IDEOGRAPH
	{0x5CD9,	0xABCF},	// CJK UNIFIED IDEOGRAPH
	{0x5CDA,	0xCEA2},	// CJK UNIFIED IDEOGRAPH
	{0x5CDB,	0xCE7E},	// CJK UNIFIED IDEOGRAPH
	{0x5CDE,	0xCEA1},	// CJK UNIFIED IDEOGRAPH
	{0x5CDF,	0xCEAD},	// CJK UNIFIED IDEOGRAPH
	{0x5CE8,	0xAE6F},	// CJK UNIFIED IDEOGRAPH
	{0x5CEA,	0xAE6E},	// CJK UNIFIED IDEOGRAPH
	{0x5CEC,	0xD16C},	// CJK UNIFIED IDEOGRAPH
	{0x5CED,	0xAE6B},	// CJK UNIFIED IDEOGRAPH
	{0x5CEE,	0xD16E},	// CJK UNIFIED IDEOGRAPH
	{0x5CF0,	0xAE70},	// CJK UNIFIED IDEOGRAPH
	{0x5CF1,	0xD16F},	// CJK UNIFIED IDEOGRAPH
	{0x5CF4,	0xAE73},	// CJK UNIFIED IDEOGRAPH
	{0x5CF6,	0xAE71},	// CJK UNIFIED IDEOGRAPH
	{0x5CF7,	0xD170},	// CJK UNIFIED IDEOGRAPH
	{0x5CF8,	0xCEAE},	// CJK UNIFIED IDEOGRAPH
	{0x5CF9,	0xD172},	// CJK UNIFIED IDEOGRAPH
	{0x5CFB,	0xAE6D},	// CJK UNIFIED IDEOGRAPH
	{0x5CFD,	0xAE6C},	// CJK UNIFIED IDEOGRAPH
	{0x5CFF,	0xD16D},	// CJK UNIFIED IDEOGRAPH
	{0x5D00,	0xD171},	// CJK UNIFIED IDEOGRAPH
	{0x5D01,	0xAE72},	// CJK UNIFIED IDEOGRAPH
	{0x5D06,	0xB153},	// CJK UNIFIED IDEOGRAPH
	{0x5D07,	0xB152},	// CJK UNIFIED IDEOGRAPH
	{0x5D0B,	0xD4F5},	// CJK UNIFIED IDEOGRAPH
	{0x5D0C,	0xD4F9},	// CJK UNIFIED IDEOGRAPH
	{0x5D0D,	0xD4FB},	// CJK UNIFIED IDEOGRAPH
	{0x5D0E,	0xB154},	// CJK UNIFIED IDEOGRAPH
	{0x5D0F,	0xD4FE},	// CJK UNIFIED IDEOGRAPH
	{0x5D11,	0xB158},	// CJK UNIFIED IDEOGRAPH
	{0x5D12,	0xD541},	// CJK UNIFIED IDEOGRAPH
	{0x5D14,	0xB15A},	// CJK UNIFIED IDEOGRAPH
	{0x5D16,	0xB156},	// CJK UNIFIED IDEOGRAPH
	{0x5D17,	0xB15E},	// CJK UNIFIED IDEOGRAPH
	{0x5D19,	0xB15B},	// CJK UNIFIED IDEOGRAPH
	{0x5D1A,	0xD4F7},	// CJK UNIFIED IDEOGRAPH
	{0x5D1B,	0xB155},	// CJK UNIFIED IDEOGRAPH
	{0x5D1D,	0xD4F6},	// CJK UNIFIED IDEOGRAPH
	{0x5D1E,	0xD4F4},	// CJK UNIFIED IDEOGRAPH
	{0x5D1F,	0xD543},	// CJK UNIFIED IDEOGRAPH
	{0x5D20,	0xD4F8},	// CJK UNIFIED IDEOGRAPH
	{0x5D22,	0xB157},	// CJK UNIFIED IDEOGRAPH
	{0x5D23,	0xD542},	// CJK UNIFIED IDEOGRAPH
	{0x5D24,	0xB15C},	// CJK UNIFIED IDEOGRAPH
	{0x5D25,	0xD4FD},	// CJK UNIFIED IDEOGRAPH
	{0x5D26,	0xD4FC},	// CJK UNIFIED IDEOGRAPH
	{0x5D27,	0xB15D},	// CJK UNIFIED IDEOGRAPH
	{0x5D28,	0xD4FA},	// CJK UNIFIED IDEOGRAPH
	{0x5D29,	0xB159},	// CJK UNIFIED IDEOGRAPH
	{0x5D2E,	0xD544},	// CJK UNIFIED IDEOGRAPH
	{0x5D30,	0xD540},	// CJK UNIFIED IDEOGRAPH
	{0x5D31,	0xD8E7},	// CJK UNIFIED IDEOGRAPH
	{0x5D32,	0xD8EE},	// CJK UNIFIED IDEOGRAPH
	{0x5D33,	0xD8E3},	// CJK UNIFIED IDEOGRAPH
	{0x5D34,	0xB451},	// CJK UNIFIED IDEOGRAPH
	{0x5D35,	0xD8DF},	// CJK UNIFIED IDEOGRAPH
	{0x5D36,	0xD8EF},	// CJK UNIFIED IDEOGRAPH
	{0x5D37,	0xD8D9},	// CJK UNIFIED IDEOGRAPH
	{0x5D38,	0xD8EC},	// CJK UNIFIED IDEOGRAPH
	{0x5D39,	0xD8EA},	// CJK UNIFIED IDEOGRAPH
	{0x5D3A,	0xD8E4},	// CJK UNIFIED IDEOGRAPH
	{0x5D3C,	0xD8ED},	// CJK UNIFIED IDEOGRAPH
	{0x5D3D,	0xD8E6},	// CJK UNIFIED IDEOGRAPH
	{0x5D3F,	0xD8DE},	// CJK UNIFIED IDEOGRAPH
	{0x5D40,	0xD8F0},	// CJK UNIFIED IDEOGRAPH
	{0x5D41,	0xD8DC},	// CJK UNIFIED IDEOGRAPH
	{0x5D42,	0xD8E9},	// CJK UNIFIED IDEOGRAPH
	{0x5D43,	0xD8DA},	// CJK UNIFIED IDEOGRAPH
	{0x5D45,	0xD8F1},	// CJK UNIFIED IDEOGRAPH
	{0x5D47,	0xB452},	// CJK UNIFIED IDEOGRAPH
	{0x5D49,	0xD8EB},	// CJK UNIFIED IDEOGRAPH
	{0x5D4A,	0xDD4F},	// CJK UNIFIED IDEOGRAPH
	{0x5D4B,	0xD8DD},	// CJK UNIFIED IDEOGRAPH
	{0x5D4C,	0xB44F},	// CJK UNIFIED IDEOGRAPH
	{0x5D4E,	0xD8E1},	// CJK UNIFIED IDEOGRAPH
	{0x5D50,	0xB450},	// CJK UNIFIED IDEOGRAPH
	{0x5D51,	0xD8E0},	// CJK UNIFIED IDEOGRAPH
	{0x5D52,	0xD8E5},	// CJK UNIFIED IDEOGRAPH
	{0x5D55,	0xD8E2},	// CJK UNIFIED IDEOGRAPH
	{0x5D59,	0xD8E8},	// CJK UNIFIED IDEOGRAPH
	{0x5D5E,	0xDD53},	// CJK UNIFIED IDEOGRAPH
	{0x5D62,	0xDD56},	// CJK UNIFIED IDEOGRAPH
	{0x5D63,	0xDD4E},	// CJK UNIFIED IDEOGRAPH
	{0x5D65,	0xDD50},	// CJK UNIFIED IDEOGRAPH
	{0x5D67,	0xDD55},	// CJK UNIFIED IDEOGRAPH
	{0x5D68,	0xDD54},	// CJK UNIFIED IDEOGRAPH
	{0x5D69,	0xB743},	// CJK UNIFIED IDEOGRAPH
	{0x5D6B,	0xD8DB},	// CJK UNIFIED IDEOGRAPH
	{0x5D6C,	0xDD52},	// CJK UNIFIED IDEOGRAPH
	{0x5D6F,	0xB744},	// CJK UNIFIED IDEOGRAPH
	{0x5D71,	0xDD4D},	// CJK UNIFIED IDEOGRAPH
	{0x5D72,	0xDD51},	// CJK UNIFIED IDEOGRAPH
	{0x5D77,	0xE1A9},	// CJK UNIFIED IDEOGRAPH
	{0x5D79,	0xE1B0},	// CJK UNIFIED IDEOGRAPH
	{0x5D7A,	0xE1A7},	// CJK UNIFIED IDEOGRAPH
	{0x5D7C,	0xE1AE},	// CJK UNIFIED IDEOGRAPH
	{0x5D7D,	0xE1A5},	// CJK UNIFIED IDEOGRAPH
	{0x5D7E,	0xE1AD},	// CJK UNIFIED IDEOGRAPH
	{0x5D7F,	0xE1B1},	// CJK UNIFIED IDEOGRAPH
	{0x5D80,	0xE1A4},	// CJK UNIFIED IDEOGRAPH
	{0x5D81,	0xE1A8},	// CJK UNIFIED IDEOGRAPH
	{0x5D82,	0xE1A3},	// CJK UNIFIED IDEOGRAPH
	{0x5D84,	0xB9F1},	// CJK UNIFIED IDEOGRAPH
	{0x5D86,	0xE1A6},	// CJK UNIFIED IDEOGRAPH
	{0x5D87,	0xB9F2},	// CJK UNIFIED IDEOGRAPH
	{0x5D88,	0xE1AC},	// CJK UNIFIED IDEOGRAPH
	{0x5D89,	0xE1AB},	// CJK UNIFIED IDEOGRAPH
	{0x5D8A,	0xE1AA},	// CJK UNIFIED IDEOGRAPH
	{0x5D8D,	0xE1AF},	// CJK UNIFIED IDEOGRAPH
	{0x5D92,	0xE565},	// CJK UNIFIED IDEOGRAPH
	{0x5D93,	0xE567},	// CJK UNIFIED IDEOGRAPH
	{0x5D94,	0xBC6B},	// CJK UNIFIED IDEOGRAPH
	{0x5D95,	0xE568},	// CJK UNIFIED IDEOGRAPH
	{0x5D97,	0xE563},	// CJK UNIFIED IDEOGRAPH
	{0x5D99,	0xE562},	// CJK UNIFIED IDEOGRAPH
	{0x5D9A,	0xE56C},	// CJK UNIFIED IDEOGRAPH
	{0x5D9C,	0xE56A},	// CJK UNIFIED IDEOGRAPH
	{0x5D9D,	0xBC6A},	// CJK UNIFIED IDEOGRAPH
	{0x5D9E,	0xE56D},	// CJK UNIFIED IDEOGRAPH
	{0x5D9F,	0xE564},	// CJK UNIFIED IDEOGRAPH
	{0x5DA0,	0xE569},	// CJK UNIFIED IDEOGRAPH
	{0x5DA1,	0xE56B},	// CJK UNIFIED IDEOGRAPH
	{0x5DA2,	0xE566},	// CJK UNIFIED IDEOGRAPH
	{0x5DA7,	0xE961},	// CJK UNIFIED IDEOGRAPH
	{0x5DA8,	0xE966},	// CJK UNIFIED IDEOGRAPH
	{0x5DA9,	0xE960},	// CJK UNIFIED IDEOGRAPH
	{0x5DAA,	0xE965},	// CJK UNIFIED IDEOGRAPH
	{0x5DAC,	0xE95E},	// CJK UNIFIED IDEOGRAPH
	{0x5DAD,	0xE968},	// CJK UNIFIED IDEOGRAPH
	{0x5DAE,	0xE964},	// CJK UNIFIED IDEOGRAPH
	{0x5DAF,	0xE969},	// CJK UNIFIED IDEOGRAPH
	{0x5DB0,	0xE963},	// CJK UNIFIED IDEOGRAPH
	{0x5DB1,	0xE95F},	// CJK UNIFIED IDEOGRAPH
	{0x5DB2,	0xE967},	// CJK UNIFIED IDEOGRAPH
	{0x5DB4,	0xE96A},	// CJK UNIFIED IDEOGRAPH
	{0x5DB5,	0xE962},	// CJK UNIFIED IDEOGRAPH
	{0x5DB7,	0xECDA},	// CJK UNIFIED IDEOGRAPH
	{0x5DB8,	0xC0AF},	// CJK UNIFIED IDEOGRAPH
	{0x5DBA,	0xC0AD},	// CJK UNIFIED IDEOGRAPH
	{0x5DBC,	0xC0AC},	// CJK UNIFIED IDEOGRAPH
	{0x5DBD,	0xC0AE},	// CJK UNIFIED IDEOGRAPH
	{0x5DC0,	0xEFC4},	// CJK UNIFIED IDEOGRAPH
	{0x5DC2,	0xF172},	// CJK UNIFIED IDEOGRAPH
	{0x5DC3,	0xF1FD},	// CJK UNIFIED IDEOGRAPH
	{0x5DC6,	0xF444},	// CJK UNIFIED IDEOGRAPH
	{0x5DC7,	0xF445},	// CJK UNIFIED IDEOGRAPH
	{0x5DC9,	0xC460},	// CJK UNIFIED IDEOGRAPH
	{0x5DCB,	0xF5C9},	// CJK UNIFIED IDEOGRAPH
	{0x5DCD,	0xC4DE},	// CJK UNIFIED IDEOGRAPH
	{0x5DCF,	0xF5CA},	// CJK UNIFIED IDEOGRAPH
	{0x5DD1,	0xF6DE},	// CJK UNIFIED IDEOGRAPH
	{0x5DD2,	0xC572},	// CJK UNIFIED IDEOGRAPH
	{0x5DD4,	0xC571},	// CJK UNIFIED IDEOGRAPH
	{0x5DD5,	0xF6DD},	// CJK UNIFIED IDEOGRAPH
	{0x5DD6,	0xC5C9},	// CJK UNIFIED IDEOGRAPH
	{0x5DD8,	0xF7D6},	// CJK UNIFIED IDEOGRAPH
	{0x5DDD,	0xA474},	// CJK UNIFIED IDEOGRAPH
	{0x5DDE,	0xA67B},	// CJK UNIFIED IDEOGRAPH
	{0x5DDF,	0xC9DA},	// CJK UNIFIED IDEOGRAPH
	{0x5DE0,	0xCACA},	// CJK UNIFIED IDEOGRAPH
	{0x5DE1,	0xA8B5},	// CJK UNIFIED IDEOGRAPH
	{0x5DE2,	0xB15F},	// CJK UNIFIED IDEOGRAPH
	{0x5DE5,	0xA475},	// CJK UNIFIED IDEOGRAPH
	{0x5DE6,	0xA5AA},	// CJK UNIFIED IDEOGRAPH
	{0x5DE7,	0xA5A9},	// CJK UNIFIED IDEOGRAPH
	{0x5DE8,	0xA5A8},	// CJK UNIFIED IDEOGRAPH
	{0x5DEB,	0xA7C5},	// CJK UNIFIED IDEOGRAPH
	{0x5DEE,	0xAE74},	// CJK UNIFIED IDEOGRAPH
	{0x5DF0,	0xDD57},	// CJK UNIFIED IDEOGRAPH
	{0x5DF1,	0xA476},	// CJK UNIFIED IDEOGRAPH
	{0x5DF2,	0xA477},	// CJK UNIFIED IDEOGRAPH
	{0x5DF3,	0xA478},	// CJK UNIFIED IDEOGRAPH
	{0x5DF4,	0xA4DA},	// CJK UNIFIED IDEOGRAPH
	{0x5DF7,	0xABD1},	// CJK UNIFIED IDEOGRAPH
	{0x5DF9,	0xCEAF},	// CJK UNIFIED IDEOGRAPH
	{0x5DFD,	0xB453},	// CJK UNIFIED IDEOGRAPH
	{0x5DFE,	0xA479},	// CJK UNIFIED IDEOGRAPH
	{0x5DFF,	0xC95D},	// CJK UNIFIED IDEOGRAPH
	{0x5E02,	0xA5AB},	// CJK UNIFIED IDEOGRAPH
	{0x5E03,	0xA5AC},	// CJK UNIFIED IDEOGRAPH
	{0x5E04,	0xC978},	// CJK UNIFIED IDEOGRAPH
	{0x5E06,	0xA67C},	// CJK UNIFIED IDEOGRAPH
	{0x5E0A,	0xCACB},	// CJK UNIFIED IDEOGRAPH
	{0x5E0C,	0xA7C6},	// CJK UNIFIED IDEOGRAPH
	{0x5E0E,	0xCACC},	// CJK UNIFIED IDEOGRAPH
	{0x5E11,	0xA9AE},	// CJK UNIFIED IDEOGRAPH
	{0x5E14,	0xCC6E},	// CJK UNIFIED IDEOGRAPH
	{0x5E15,	0xA9AC},	// CJK UNIFIED IDEOGRAPH
	{0x5E16,	0xA9AB},	// CJK UNIFIED IDEOGRAPH
	{0x5E17,	0xCC6D},	// CJK UNIFIED IDEOGRAPH
	{0x5E18,	0xA9A9},	// CJK UNIFIED IDEOGRAPH
	{0x5E19,	0xCC6F},	// CJK UNIFIED IDEOGRAPH
	{0x5E1A,	0xA9AA},	// CJK UNIFIED IDEOGRAPH
	{0x5E1B,	0xA9AD},	// CJK UNIFIED IDEOGRAPH
	{0x5E1D,	0xABD2},	// CJK UNIFIED IDEOGRAPH
	{0x5E1F,	0xABD4},	// CJK UNIFIED IDEOGRAPH
	{0x5E20,	0xCEB3},	// CJK UNIFIED IDEOGRAPH
	{0x5E21,	0xCEB0},	// CJK UNIFIED IDEOGRAPH
	{0x5E22,	0xCEB1},	// CJK UNIFIED IDEOGRAPH
	{0x5E23,	0xCEB2},	// CJK UNIFIED IDEOGRAPH
	{0x5E24,	0xCEB4},	// CJK UNIFIED IDEOGRAPH
	{0x5E25,	0xABD3},	// CJK UNIFIED IDEOGRAPH
	{0x5E28,	0xD174},	// CJK UNIFIED IDEOGRAPH
	{0x5E29,	0xD173},	// CJK UNIFIED IDEOGRAPH
	{0x5E2B,	0xAE76},	// CJK UNIFIED IDEOGRAPH
	{0x5E2D,	0xAE75},	// CJK UNIFIED IDEOGRAPH
	{0x5E33,	0xB162},	// CJK UNIFIED IDEOGRAPH
	{0x5E34,	0xD546},	// CJK UNIFIED IDEOGRAPH
	{0x5E36,	0xB161},	// CJK UNIFIED IDEOGRAPH
	{0x5E37,	0xB163},	// CJK UNIFIED IDEOGRAPH
	{0x5E38,	0xB160},	// CJK UNIFIED IDEOGRAPH
	{0x5E3D,	0xB455},	// CJK UNIFIED IDEOGRAPH
	{0x5E3E,	0xD545},	// CJK UNIFIED IDEOGRAPH
	{0x5E40,	0xB456},	// CJK UNIFIED IDEOGRAPH
	{0x5E41,	0xD8F3},	// CJK UNIFIED IDEOGRAPH
	{0x5E43,	0xB457},	// CJK UNIFIED IDEOGRAPH
	{0x5E44,	0xD8F2},	// CJK UNIFIED IDEOGRAPH
	{0x5E45,	0xB454},	// CJK UNIFIED IDEOGRAPH
	{0x5E4A,	0xDD5A},	// CJK UNIFIED IDEOGRAPH
	{0x5E4B,	0xDD5C},	// CJK UNIFIED IDEOGRAPH
	{0x5E4C,	0xB745},	// CJK UNIFIED IDEOGRAPH
	{0x5E4D,	0xDD5B},	// CJK UNIFIED IDEOGRAPH
	{0x5E4E,	0xDD59},	// CJK UNIFIED IDEOGRAPH
	{0x5E4F,	0xDD58},	// CJK UNIFIED IDEOGRAPH
	{0x5E53,	0xE1B4},	// CJK UNIFIED IDEOGRAPH
	{0x5E54,	0xB9F7},	// CJK UNIFIED IDEOGRAPH
	{0x5E55,	0xB9F5},	// CJK UNIFIED IDEOGRAPH
	{0x5E57,	0xB9F6},	// CJK UNIFIED IDEOGRAPH
	{0x5E58,	0xE1B2},	// CJK UNIFIED IDEOGRAPH
	{0x5E59,	0xE1B3},	// CJK UNIFIED IDEOGRAPH
	{0x5E5B,	0xB9F3},	// CJK UNIFIED IDEOGRAPH
	{0x5E5C,	0xE571},	// CJK UNIFIED IDEOGRAPH
	{0x5E5D,	0xE56F},	// CJK UNIFIED IDEOGRAPH
	{0x5E5F,	0xBC6D},	// CJK UNIFIED IDEOGRAPH
	{0x5E60,	0xE570},	// CJK UNIFIED IDEOGRAPH
	{0x5E61,	0xBC6E},	// CJK UNIFIED IDEOGRAPH
	{0x5E62,	0xBC6C},	// CJK UNIFIED IDEOGRAPH
	{0x5E63,	0xB9F4},	// CJK UNIFIED IDEOGRAPH
	{0x5E66,	0xE96D},	// CJK UNIFIED IDEOGRAPH
	{0x5E67,	0xE96B},	// CJK UNIFIED IDEOGRAPH
	{0x5E68,	0xE96C},	// CJK UNIFIED IDEOGRAPH
	{0x5E69,	0xE56E},	// CJK UNIFIED IDEOGRAPH
	{0x5E6A,	0xECDC},	// CJK UNIFIED IDEOGRAPH
	{0x5E6B,	0xC0B0},	// CJK UNIFIED IDEOGRAPH
	{0x5E6C,	0xECDB},	// CJK UNIFIED IDEOGRAPH
	{0x5E6D,	0xEFC5},	// CJK UNIFIED IDEOGRAPH
	{0x5E6E,	0xEFC6},	// CJK UNIFIED IDEOGRAPH
	{0x5E6F,	0xE96E},	// CJK UNIFIED IDEOGRAPH
	{0x5E70,	0xF1FE},	// CJK UNIFIED IDEOGRAPH
	{0x5E72,	0xA47A},	// CJK UNIFIED IDEOGRAPH
	{0x5E73,	0xA5AD},	// CJK UNIFIED IDEOGRAPH
	{0x5E74,	0xA67E},	// CJK UNIFIED IDEOGRAPH
	{0x5E75,	0xC9DB},	// CJK UNIFIED IDEOGRAPH
	{0x5E76,	0xA67D},	// CJK UNIFIED IDEOGRAPH
	{0x5E78,	0xA9AF},	// CJK UNIFIED IDEOGRAPH
	{0x5E79,	0xB746},	// CJK UNIFIED IDEOGRAPH
	{0x5E7B,	0xA4DB},	// CJK UNIFIED IDEOGRAPH
	{0x5E7C,	0xA5AE},	// CJK UNIFIED IDEOGRAPH
	{0x5E7D,	0xABD5},	// CJK UNIFIED IDEOGRAPH
	{0x5E7E,	0xB458},	// CJK UNIFIED IDEOGRAPH
	{0x5E80,	0xC979},	// CJK UNIFIED IDEOGRAPH
	{0x5E82,	0xC97A},	// CJK UNIFIED IDEOGRAPH
	{0x5E84,	0xC9DC},	// CJK UNIFIED IDEOGRAPH
	{0x5E87,	0xA7C8},	// CJK UNIFIED IDEOGRAPH
	{0x5E88,	0xCAD0},	// CJK UNIFIED IDEOGRAPH
	{0x5E89,	0xCACE},	// CJK UNIFIED IDEOGRAPH
	{0x5E8A,	0xA7C9},	// CJK UNIFIED IDEOGRAPH
	{0x5E8B,	0xCACD},	// CJK UNIFIED IDEOGRAPH
	{0x5E8C,	0xCACF},	// CJK UNIFIED IDEOGRAPH
	{0x5E8D,	0xCAD1},	// CJK UNIFIED IDEOGRAPH
	{0x5E8F,	0xA7C7},	// CJK UNIFIED IDEOGRAPH
	{0x5E95,	0xA9B3},	// CJK UNIFIED IDEOGRAPH
	{0x5E96,	0xA9B4},	// CJK UNIFIED IDEOGRAPH
	{0x5E97,	0xA9B1},	// CJK UNIFIED IDEOGRAPH
	{0x5E9A,	0xA9B0},	// CJK UNIFIED IDEOGRAPH
	{0x5E9B,	0xCEB8},	// CJK UNIFIED IDEOGRAPH
	{0x5E9C,	0xA9B2},	// CJK UNIFIED IDEOGRAPH
	{0x5EA0,	0xABD6},	// CJK UNIFIED IDEOGRAPH
	{0x5EA2,	0xCEB7},	// CJK UNIFIED IDEOGRAPH
	{0x5EA3,	0xCEB9},	// CJK UNIFIED IDEOGRAPH
	{0x5EA4,	0xCEB6},	// CJK UNIFIED IDEOGRAPH
	{0x5EA5,	0xCEBA},	// CJK UNIFIED IDEOGRAPH
	{0x5EA6,	0xABD7},	// CJK UNIFIED IDEOGRAPH
	{0x5EA7,	0xAE79},	// CJK UNIFIED IDEOGRAPH
	{0x5EA8,	0xD175},	// CJK UNIFIED IDEOGRAPH
	{0x5EAA,	0xD177},	// CJK UNIFIED IDEOGRAPH
	{0x5EAB,	0xAE77},	// CJK UNIFIED IDEOGRAPH
	{0x5EAC,	0xD178},	// CJK UNIFIED IDEOGRAPH
	{0x5EAD,	0xAE78},	// CJK UNIFIED IDEOGRAPH
	{0x5EAE,	0xD176},	// CJK UNIFIED IDEOGRAPH
	{0x5EB0,	0xCEB5},	// CJK UNIFIED IDEOGRAPH
	{0x5EB1,	0xD547},	// CJK UNIFIED IDEOGRAPH
	{0x5EB2,	0xD54A},	// CJK UNIFIED IDEOGRAPH
	{0x5EB3,	0xD54B},	// CJK UNIFIED IDEOGRAPH
	{0x5EB4,	0xD548},	// CJK UNIFIED IDEOGRAPH
	{0x5EB5,	0xB167},	// CJK UNIFIED IDEOGRAPH
	{0x5EB6,	0xB166},	// CJK UNIFIED IDEOGRAPH
	{0x5EB7,	0xB164},	// CJK UNIFIED IDEOGRAPH
	{0x5EB8,	0xB165},	// CJK UNIFIED IDEOGRAPH
	{0x5EB9,	0xD549},	// CJK UNIFIED IDEOGRAPH
	{0x5EBE,	0xB168},	// CJK UNIFIED IDEOGRAPH
	{0x5EC1,	0xB45A},	// CJK UNIFIED IDEOGRAPH
	{0x5EC2,	0xB45B},	// CJK UNIFIED IDEOGRAPH
	{0x5EC4,	0xB45C},	// CJK UNIFIED IDEOGRAPH
	{0x5EC5,	0xDD5D},	// CJK UNIFIED IDEOGRAPH
	{0x5EC6,	0xDD5F},	// CJK UNIFIED IDEOGRAPH
	{0x5EC7,	0xDD61},	// CJK UNIFIED IDEOGRAPH
	{0x5EC8,	0xB748},	// CJK UNIFIED IDEOGRAPH
	{0x5EC9,	0xB747},	// CJK UNIFIED IDEOGRAPH
	{0x5ECA,	0xB459},	// CJK UNIFIED IDEOGRAPH
	{0x5ECB,	0xDD60},	// CJK UNIFIED IDEOGRAPH
	{0x5ECC,	0xDD5E},	// CJK UNIFIED IDEOGRAPH
	{0x5ECE,	0xE1B8},	// CJK UNIFIED IDEOGRAPH
	{0x5ED1,	0xE1B6},	// CJK UNIFIED IDEOGRAPH
	{0x5ED2,	0xE1BC},	// CJK UNIFIED IDEOGRAPH
	{0x5ED3,	0xB9F8},	// CJK UNIFIED IDEOGRAPH
	{0x5ED4,	0xE1BD},	// CJK UNIFIED IDEOGRAPH
	{0x5ED5,	0xE1BA},	// CJK UNIFIED IDEOGRAPH
	{0x5ED6,	0xB9F9},	// CJK UNIFIED IDEOGRAPH
	{0x5ED7,	0xE1B7},	// CJK UNIFIED IDEOGRAPH
	{0x5ED8,	0xE1B5},	// CJK UNIFIED IDEOGRAPH
	{0x5ED9,	0xE1BB},	// CJK UNIFIED IDEOGRAPH
	{0x5EDA,	0xBC70},	// CJK UNIFIED IDEOGRAPH
	{0x5EDB,	0xE573},	// CJK UNIFIED IDEOGRAPH
	{0x5EDC,	0xE1B9},	// CJK UNIFIED IDEOGRAPH
	{0x5EDD,	0xBC72},	// CJK UNIFIED IDEOGRAPH
	{0x5EDE,	0xE574},	// CJK UNIFIED IDEOGRAPH
	{0x5EDF,	0xBC71},	// CJK UNIFIED IDEOGRAPH
	{0x5EE0,	0xBC74},	// CJK UNIFIED IDEOGRAPH
	{0x5EE1,	0xE575},	// CJK UNIFIED IDEOGRAPH
	{0x5EE2,	0xBC6F},	// CJK UNIFIED IDEOGRAPH
	{0x5EE3,	0xBC73},	// CJK UNIFIED IDEOGRAPH
	{0x5EE5,	0xE973},	// CJK UNIFIED IDEOGRAPH
	{0x5EE6,	0xE971},	// CJK UNIFIED IDEOGRAPH
	{0x5EE7,	0xE970},	// CJK UNIFIED IDEOGRAPH
	{0x5EE8,	0xE972},	// CJK UNIFIED IDEOGRAPH
	{0x5EE9,	0xE96F},	// CJK UNIFIED IDEOGRAPH
	{0x5EEC,	0xC366},	// CJK UNIFIED IDEOGRAPH
	{0x5EEE,	0xF446},	// CJK UNIFIED IDEOGRAPH
	{0x5EEF,	0xF447},	// CJK UNIFIED IDEOGRAPH
	{0x5EF1,	0xF5CB},	// CJK UNIFIED IDEOGRAPH
	{0x5EF2,	0xF6DF},	// CJK UNIFIED IDEOGRAPH
	{0x5EF3,	0xC655},	// CJK UNIFIED IDEOGRAPH
	{0x5EF6,	0xA9B5},	// CJK UNIFIED IDEOGRAPH
	{0x5EF7,	0xA7CA},	// CJK UNIFIED IDEOGRAPH
	{0x5EFA,	0xABD8},	// CJK UNIFIED IDEOGRAPH
	{0x5EFE,	0xA47B},	// CJK UNIFIED IDEOGRAPH
	{0x5EFF,	0xA4DC},	// CJK UNIFIED IDEOGRAPH
	{0x5F01,	0xA5AF},	// CJK UNIFIED IDEOGRAPH
	{0x5F02,	0xC9DD},	// CJK UNIFIED IDEOGRAPH
	{0x5F04,	0xA7CB},	// CJK UNIFIED IDEOGRAPH
	{0x5F05,	0xCAD2},	// CJK UNIFIED IDEOGRAPH
	{0x5F07,	0xCEBB},	// CJK UNIFIED IDEOGRAPH
	{0x5F08,	0xABD9},	// CJK UNIFIED IDEOGRAPH
	{0x5F0A,	0xB9FA},	// CJK UNIFIED IDEOGRAPH
	{0x5F0B,	0xA47C},	// CJK UNIFIED IDEOGRAPH
	{0x5F0F,	0xA6A1},	// CJK UNIFIED IDEOGRAPH
	{0x5F12,	0xB749},	// CJK UNIFIED IDEOGRAPH
	{0x5F13,	0xA47D},	// CJK UNIFIED IDEOGRAPH
	{0x5F14,	0xA4DD},	// CJK UNIFIED IDEOGRAPH
	{0x5F15,	0xA4DE},	// CJK UNIFIED IDEOGRAPH
	{0x5F17,	0xA5B1},	// CJK UNIFIED IDEOGRAPH
	{0x5F18,	0xA5B0},	// CJK UNIFIED IDEOGRAPH
	{0x5F1A,	0xC9DE},	// CJK UNIFIED IDEOGRAPH
	{0x5F1B,	0xA6A2},	// CJK UNIFIED IDEOGRAPH
	{0x5F1D,	0xCAD3},	// CJK UNIFIED IDEOGRAPH
	{0x5F1F,	0xA7CC},	// CJK UNIFIED IDEOGRAPH
	{0x5F22,	0xCC71},	// CJK UNIFIED IDEOGRAPH
	{0x5F23,	0xCC72},	// CJK UNIFIED IDEOGRAPH
	{0x5F24,	0xCC73},	// CJK UNIFIED IDEOGRAPH
	{0x5F26,	0xA9B6},	// CJK UNIFIED IDEOGRAPH
	{0x5F27,	0xA9B7},	// CJK UNIFIED IDEOGRAPH
	{0x5F28,	0xCC70},	// CJK UNIFIED IDEOGRAPH
	{0x5F29,	0xA9B8},	// CJK UNIFIED IDEOGRAPH
	{0x5F2D,	0xABDA},	// CJK UNIFIED IDEOGRAPH
	{0x5F2E,	0xCEBC},	// CJK UNIFIED IDEOGRAPH
	{0x5F30,	0xD17A},	// CJK UNIFIED IDEOGRAPH
	{0x5F31,	0xAE7A},	// CJK UNIFIED IDEOGRAPH
	{0x5F33,	0xD179},	// CJK UNIFIED IDEOGRAPH
	{0x5F35,	0xB169},	// CJK UNIFIED IDEOGRAPH
	{0x5F36,	0xD54C},	// CJK UNIFIED IDEOGRAPH
	{0x5F37,	0xB16A},	// CJK UNIFIED IDEOGRAPH
	{0x5F38,	0xD54D},	// CJK UNIFIED IDEOGRAPH
	{0x5F3C,	0xB45D},	// CJK UNIFIED IDEOGRAPH
	{0x5F40,	0xDD62},	// CJK UNIFIED IDEOGRAPH
	{0x5F43,	0xE1BF},	// CJK UNIFIED IDEOGRAPH
	{0x5F44,	0xE1BE},	// CJK UNIFIED IDEOGRAPH
	{0x5F46,	0xB9FB},	// CJK UNIFIED IDEOGRAPH
	{0x5F48,	0xBC75},	// CJK UNIFIED IDEOGRAPH
	{0x5F49,	0xE576},	// CJK UNIFIED IDEOGRAPH
	{0x5F4A,	0xBECA},	// CJK UNIFIED IDEOGRAPH
	{0x5F4B,	0xE974},	// CJK UNIFIED IDEOGRAPH
	{0x5F4C,	0xC0B1},	// CJK UNIFIED IDEOGRAPH
	{0x5F4E,	0xC573},	// CJK UNIFIED IDEOGRAPH
	{0x5F4F,	0xF7D8},	// CJK UNIFIED IDEOGRAPH
	{0x5F54,	0xCC74},	// CJK UNIFIED IDEOGRAPH
	{0x5F56,	0xCEBD},	// CJK UNIFIED IDEOGRAPH
	{0x5F57,	0xB16B},	// CJK UNIFIED IDEOGRAPH
	{0x5F58,	0xD8F4},	// CJK UNIFIED IDEOGRAPH
	{0x5F59,	0xB74A},	// CJK UNIFIED IDEOGRAPH
	{0x5F5D,	0xC255},	// CJK UNIFIED IDEOGRAPH
	{0x5F62,	0xA7CE},	// CJK UNIFIED IDEOGRAPH
	{0x5F64,	0xA7CD},	// CJK UNIFIED IDEOGRAPH
	{0x5F65,	0xABDB},	// CJK UNIFIED IDEOGRAPH
	{0x5F67,	0xD17B},	// CJK UNIFIED IDEOGRAPH
	{0x5F69,	0xB16D},	// CJK UNIFIED IDEOGRAPH
	{0x5F6A,	0xB343},	// CJK UNIFIED IDEOGRAPH
	{0x5F6B,	0xB16E},	// CJK UNIFIED IDEOGRAPH
	{0x5F6C,	0xB16C},	// CJK UNIFIED IDEOGRAPH
	{0x5F6D,	0xB45E},	// CJK UNIFIED IDEOGRAPH
	{0x5F6F,	0xE1C0},	// CJK UNIFIED IDEOGRAPH
	{0x5F70,	0xB9FC},	// CJK UNIFIED IDEOGRAPH
	{0x5F71,	0xBC76},	// CJK UNIFIED IDEOGRAPH
	{0x5F73,	0xC94C},	// CJK UNIFIED IDEOGRAPH
	{0x5F74,	0xC9DF},	// CJK UNIFIED IDEOGRAPH
	{0x5F76,	0xCAD5},	// CJK UNIFIED IDEOGRAPH
	{0x5F77,	0xA7CF},	// CJK UNIFIED IDEOGRAPH
	{0x5F78,	0xCAD4},	// CJK UNIFIED IDEOGRAPH
	{0x5F79,	0xA7D0},	// CJK UNIFIED IDEOGRAPH
	{0x5F7C,	0xA9BC},	// CJK UNIFIED IDEOGRAPH
	{0x5F7D,	0xCC77},	// CJK UNIFIED IDEOGRAPH
	{0x5F7E,	0xCC76},	// CJK UNIFIED IDEOGRAPH
	{0x5F7F,	0xA9BB},	// CJK UNIFIED IDEOGRAPH
	{0x5F80,	0xA9B9},	// CJK UNIFIED IDEOGRAPH
	{0x5F81,	0xA9BA},	// CJK UNIFIED IDEOGRAPH
	{0x5F82,	0xCC75},	// CJK UNIFIED IDEOGRAPH
	{0x5F85,	0xABDD},	// CJK UNIFIED IDEOGRAPH
	{0x5F86,	0xCEBE},	// CJK UNIFIED IDEOGRAPH
	{0x5F87,	0xABE0},	// CJK UNIFIED IDEOGRAPH
	{0x5F88,	0xABDC},	// CJK UNIFIED IDEOGRAPH
	{0x5F89,	0xABE2},	// CJK UNIFIED IDEOGRAPH
	{0x5F8A,	0xABDE},	// CJK UNIFIED IDEOGRAPH
	{0x5F8B,	0xABDF},	// CJK UNIFIED IDEOGRAPH
	{0x5F8C,	0xABE1},	// CJK UNIFIED IDEOGRAPH
	{0x5F90,	0xAE7D},	// CJK UNIFIED IDEOGRAPH
	{0x5F91,	0xAE7C},	// CJK UNIFIED IDEOGRAPH
	{0x5F92,	0xAE7B},	// CJK UNIFIED IDEOGRAPH
	{0x5F96,	0xD54F},	// CJK UNIFIED IDEOGRAPH
	{0x5F97,	0xB16F},	// CJK UNIFIED IDEOGRAPH
	{0x5F98,	0xB172},	// CJK UNIFIED IDEOGRAPH
	{0x5F99,	0xB170},	// CJK UNIFIED IDEOGRAPH
	{0x5F9B,	0xD54E},	// CJK UNIFIED IDEOGRAPH
	{0x5F9C,	0xB175},	// CJK UNIFIED IDEOGRAPH
	{0x5F9E,	0xB171},	// CJK UNIFIED IDEOGRAPH
	{0x5F9F,	0xD550},	// CJK UNIFIED IDEOGRAPH
	{0x5FA0,	0xB174},	// CJK UNIFIED IDEOGRAPH
	{0x5FA1,	0xB173},	// CJK UNIFIED IDEOGRAPH
	{0x5FA5,	0xD8F6},	// CJK UNIFIED IDEOGRAPH
	{0x5FA6,	0xD8F5},	// CJK UNIFIED IDEOGRAPH
	{0x5FA8,	0xB461},	// CJK UNIFIED IDEOGRAPH
	{0x5FA9,	0xB45F},	// CJK UNIFIED IDEOGRAPH
	{0x5FAA,	0xB460},	// CJK UNIFIED IDEOGRAPH
	{0x5FAB,	0xD8F7},	// CJK UNIFIED IDEOGRAPH
	{0x5FAC,	0xB74B},	// CJK UNIFIED IDEOGRAPH
	{0x5FAD,	0xDD64},	// CJK UNIFIED IDEOGRAPH
	{0x5FAE,	0xB74C},	// CJK UNIFIED IDEOGRAPH
	{0x5FAF,	0xDD63},	// CJK UNIFIED IDEOGRAPH
	{0x5FB2,	0xE577},	// CJK UNIFIED IDEOGRAPH
	{0x5FB5,	0xBC78},	// CJK UNIFIED IDEOGRAPH
	{0x5FB6,	0xE1C1},	// CJK UNIFIED IDEOGRAPH
	{0x5FB7,	0xBC77},	// CJK UNIFIED IDEOGRAPH
	{0x5FB9,	0xB9FD},	// CJK UNIFIED IDEOGRAPH
	{0x5FBB,	0xECDE},	// CJK UNIFIED IDEOGRAPH
	{0x5FBC,	0xE975},	// CJK UNIFIED IDEOGRAPH
	{0x5FBD,	0xC0B2},	// CJK UNIFIED IDEOGRAPH
	{0x5FBE,	0xECDD},	// CJK UNIFIED IDEOGRAPH
	{0x5FBF,	0xF240},	// CJK UNIFIED IDEOGRAPH
	{0x5FC0,	0xF448},	// CJK UNIFIED IDEOGRAPH
	{0x5FC1,	0xF449},	// CJK UNIFIED IDEOGRAPH
	{0x5FC3,	0xA4DF},	// CJK UNIFIED IDEOGRAPH
	{0x5FC5,	0xA5B2},	// CJK UNIFIED IDEOGRAPH
	{0x5FC9,	0xC97B},	// CJK UNIFIED IDEOGRAPH
	{0x5FCC,	0xA7D2},	// CJK UNIFIED IDEOGRAPH
	{0x5FCD,	0xA7D4},	// CJK UNIFIED IDEOGRAPH
	{0x5FCF,	0xC9E2},	// CJK UNIFIED IDEOGRAPH
	{0x5FD0,	0xCAD8},	// CJK UNIFIED IDEOGRAPH
	{0x5FD1,	0xCAD7},	// CJK UNIFIED IDEOGRAPH
	{0x5FD2,	0xCAD6},	// CJK UNIFIED IDEOGRAPH
	{0x5FD4,	0xC9E1},	// CJK UNIFIED IDEOGRAPH
	{0x5FD5,	0xC9E0},	// CJK UNIFIED IDEOGRAPH
	{0x5FD6,	0xA6A4},	// CJK UNIFIED IDEOGRAPH
	{0x5FD7,	0xA7D3},	// CJK UNIFIED IDEOGRAPH
	{0x5FD8,	0xA7D1},	// CJK UNIFIED IDEOGRAPH
	{0x5FD9,	0xA6A3},	// CJK UNIFIED IDEOGRAPH
	{0x5FDD,	0xA9BD},	// CJK UNIFIED IDEOGRAPH
	{0x5FDE,	0xCC78},	// CJK UNIFIED IDEOGRAPH
	{0x5FE0,	0xA9BE},	// CJK UNIFIED IDEOGRAPH
	{0x5FE1,	0xCADD},	// CJK UNIFIED IDEOGRAPH
	{0x5FE3,	0xCADF},	// CJK UNIFIED IDEOGRAPH
	{0x5FE4,	0xCADE},	// CJK UNIFIED IDEOGRAPH
	{0x5FE5,	0xCC79},	// CJK UNIFIED IDEOGRAPH
	{0x5FE8,	0xCADA},	// CJK UNIFIED IDEOGRAPH
	{0x5FEA,	0xA7D8},	// CJK UNIFIED IDEOGRAPH
	{0x5FEB,	0xA7D6},	// CJK UNIFIED IDEOGRAPH
	{0x5FED,	0xCAD9},	// CJK UNIFIED IDEOGRAPH
	{0x5FEE,	0xCADB},	// CJK UNIFIED IDEOGRAPH
	{0x5FEF,	0xCAE1},	// CJK UNIFIED IDEOGRAPH
	{0x5FF1,	0xA7D5},	// CJK UNIFIED IDEOGRAPH
	{0x5FF3,	0xCADC},	// CJK UNIFIED IDEOGRAPH
	{0x5FF4,	0xCAE5},	// CJK UNIFIED IDEOGRAPH
	{0x5FF5,	0xA9C0},	// CJK UNIFIED IDEOGRAPH
	{0x5FF7,	0xCAE2},	// CJK UNIFIED IDEOGRAPH
	{0x5FF8,	0xA7D7},	// CJK UNIFIED IDEOGRAPH
	{0x5FFA,	0xCAE0},	// CJK UNIFIED IDEOGRAPH
	{0x5FFB,	0xCAE3},	// CJK UNIFIED IDEOGRAPH
	{0x5FFD,	0xA9BF},	// CJK UNIFIED IDEOGRAPH
	{0x5FFF,	0xA9C1},	// CJK UNIFIED IDEOGRAPH
	{0x6000,	0xCAE4},	// CJK UNIFIED IDEOGRAPH
	{0x6009,	0xCCAF},	// CJK UNIFIED IDEOGRAPH
	{0x600A,	0xCCA2},	// CJK UNIFIED IDEOGRAPH
	{0x600B,	0xCC7E},	// CJK UNIFIED IDEOGRAPH
	{0x600C,	0xCCAE},	// CJK UNIFIED IDEOGRAPH
	{0x600D,	0xCCA9},	// CJK UNIFIED IDEOGRAPH
	{0x600E,	0xABE7},	// CJK UNIFIED IDEOGRAPH
	{0x600F,	0xA9C2},	// CJK UNIFIED IDEOGRAPH
	{0x6010,	0xCCAA},	// CJK UNIFIED IDEOGRAPH
	{0x6011,	0xCCAD},	// CJK UNIFIED IDEOGRAPH
	{0x6012,	0xABE3},	// CJK UNIFIED IDEOGRAPH
	{0x6013,	0xCCAC},	// CJK UNIFIED IDEOGRAPH
	{0x6014,	0xA9C3},	// CJK UNIFIED IDEOGRAPH
	{0x6015,	0xA9C8},	// CJK UNIFIED IDEOGRAPH
	{0x6016,	0xA9C6},	// CJK UNIFIED IDEOGRAPH
	{0x6017,	0xCCA3},	// CJK UNIFIED IDEOGRAPH
	{0x6019,	0xCC7C},	// CJK UNIFIED IDEOGRAPH
	{0x601A,	0xCCA5},	// CJK UNIFIED IDEOGRAPH
	{0x601B,	0xA9CD},	// CJK UNIFIED IDEOGRAPH
	{0x601C,	0xCCB0},	// CJK UNIFIED IDEOGRAPH
	{0x601D,	0xABE4},	// CJK UNIFIED IDEOGRAPH
	{0x601E,	0xCCA6},	// CJK UNIFIED IDEOGRAPH
	{0x6020,	0xABE5},	// CJK UNIFIED IDEOGRAPH
	{0x6021,	0xA9C9},	// CJK UNIFIED IDEOGRAPH
	{0x6022,	0xCCA8},	// CJK UNIFIED IDEOGRAPH
	{0x6024,	0xCECD},	// CJK UNIFIED IDEOGRAPH
	{0x6025,	0xABE6},	// CJK UNIFIED IDEOGRAPH
	{0x6026,	0xCC7B},	// CJK UNIFIED IDEOGRAPH
	{0x6027,	0xA9CA},	// CJK UNIFIED IDEOGRAPH
	{0x6028,	0xABE8},	// CJK UNIFIED IDEOGRAPH
	{0x6029,	0xA9CB},	// CJK UNIFIED IDEOGRAPH
	{0x602A,	0xA9C7},	// CJK UNIFIED IDEOGRAPH
	{0x602B,	0xA9CC},	// CJK UNIFIED IDEOGRAPH
	{0x602C,	0xCCA7},	// CJK UNIFIED IDEOGRAPH
	{0x602D,	0xCC7A},	// CJK UNIFIED IDEOGRAPH
	{0x602E,	0xCCAB},	// CJK UNIFIED IDEOGRAPH
	{0x602F,	0xA9C4},	// CJK UNIFIED IDEOGRAPH
	{0x6032,	0xCC7D},	// CJK UNIFIED IDEOGRAPH
	{0x6033,	0xCCA4},	// CJK UNIFIED IDEOGRAPH
	{0x6034,	0xCCA1},	// CJK UNIFIED IDEOGRAPH
	{0x6035,	0xA9C5},	// CJK UNIFIED IDEOGRAPH
	{0x6037,	0xCEBF},	// CJK UNIFIED IDEOGRAPH
	{0x6039,	0xCEC0},	// CJK UNIFIED IDEOGRAPH
	{0x6040,	0xCECA},	// CJK UNIFIED IDEOGRAPH
	{0x6041,	0xD1A1},	// CJK UNIFIED IDEOGRAPH
	{0x6042,	0xCECB},	// CJK UNIFIED IDEOGRAPH
	{0x6043,	0xABEE},	// CJK UNIFIED IDEOGRAPH
	{0x6044,	0xCECE},	// CJK UNIFIED IDEOGRAPH
	{0x6045,	0xCEC4},	// CJK UNIFIED IDEOGRAPH
	{0x6046,	0xABED},	// CJK UNIFIED IDEOGRAPH
	{0x6047,	0xCEC6},	// CJK UNIFIED IDEOGRAPH
	{0x6049,	0xCEC7},	// CJK UNIFIED IDEOGRAPH
	{0x604C,	0xCEC9},	// CJK UNIFIED IDEOGRAPH
	{0x604D,	0xABE9},	// CJK UNIFIED IDEOGRAPH
	{0x6050,	0xAEA3},	// CJK UNIFIED IDEOGRAPH
	{0x6052,	0xF9DA},	// CJK UNIFIED IDEOGRAPH
	{0x6053,	0xCEC5},	// CJK UNIFIED IDEOGRAPH
	{0x6054,	0xCEC1},	// CJK UNIFIED IDEOGRAPH
	{0x6055,	0xAEA4},	// CJK UNIFIED IDEOGRAPH
	{0x6058,	0xCECF},	// CJK UNIFIED IDEOGRAPH
	{0x6059,	0xAE7E},	// CJK UNIFIED IDEOGRAPH
	{0x605A,	0xD17D},	// CJK UNIFIED IDEOGRAPH
	{0x605B,	0xCEC8},	// CJK UNIFIED IDEOGRAPH
	{0x605D,	0xD17C},	// CJK UNIFIED IDEOGRAPH
	{0x605E,	0xCEC3},	// CJK UNIFIED IDEOGRAPH
	{0x605F,	0xCECC},	// CJK UNIFIED IDEOGRAPH
	{0x6062,	0xABEC},	// CJK UNIFIED IDEOGRAPH
	{0x6063,	0xAEA1},	// CJK UNIFIED IDEOGRAPH
	{0x6064,	0xABF2},	// CJK UNIFIED IDEOGRAPH
	{0x6065,	0xAEA2},	// CJK UNIFIED IDEOGRAPH
	{0x6066,	0xCED0},	// CJK UNIFIED IDEOGRAPH
	{0x6067,	0xD17E},	// CJK UNIFIED IDEOGRAPH
	{0x6068,	0xABEB},	// CJK UNIFIED IDEOGRAPH
	{0x6069,	0xAEA6},	// CJK UNIFIED IDEOGRAPH
	{0x606A,	0xABF1},	// CJK UNIFIED IDEOGRAPH
	{0x606B,	0xABF0},	// CJK UNIFIED IDEOGRAPH
	{0x606C,	0xABEF},	// CJK UNIFIED IDEOGRAPH
	{0x606D,	0xAEA5},	// CJK UNIFIED IDEOGRAPH
	{0x606E,	0xCED1},	// CJK UNIFIED IDEOGRAPH
	{0x606F,	0xAEA7},	// CJK UNIFIED IDEOGRAPH
	{0x6070,	0xABEA},	// CJK UNIFIED IDEOGRAPH
	{0x6072,	0xCEC2},	// CJK UNIFIED IDEOGRAPH
	{0x607F,	0xB176},	// CJK UNIFIED IDEOGRAPH
	{0x6080,	0xD1A4},	// CJK UNIFIED IDEOGRAPH
	{0x6081,	0xD1A6},	// CJK UNIFIED IDEOGRAPH
	{0x6083,	0xD1A8},	// CJK UNIFIED IDEOGRAPH
	{0x6084,	0xAEA8},	// CJK UNIFIED IDEOGRAPH
	{0x6085,	0xAEAE},	// CJK UNIFIED IDEOGRAPH
	{0x6086,	0xD553},	// CJK UNIFIED IDEOGRAPH
	{0x6087,	0xD1AC},	// CJK UNIFIED IDEOGRAPH
	{0x6088,	0xD1A3},	// CJK UNIFIED IDEOGRAPH
	{0x6089,	0xB178},	// CJK UNIFIED IDEOGRAPH
	{0x608A,	0xD551},	// CJK UNIFIED IDEOGRAPH
	{0x608C,	0xAEAD},	// CJK UNIFIED IDEOGRAPH
	{0x608D,	0xAEAB},	// CJK UNIFIED IDEOGRAPH
	{0x608E,	0xD1AE},	// CJK UNIFIED IDEOGRAPH
	{0x6090,	0xD552},	// CJK UNIFIED IDEOGRAPH
	{0x6092,	0xD1A5},	// CJK UNIFIED IDEOGRAPH
	{0x6094,	0xAEAC},	// CJK UNIFIED IDEOGRAPH
	{0x6095,	0xD1A9},	// CJK UNIFIED IDEOGRAPH
	{0x6096,	0xAEAF},	// CJK UNIFIED IDEOGRAPH
	{0x6097,	0xD1AB},	// CJK UNIFIED IDEOGRAPH
	{0x609A,	0xAEAA},	// CJK UNIFIED IDEOGRAPH
	{0x609B,	0xD1AA},	// CJK UNIFIED IDEOGRAPH
	{0x609C,	0xD1AD},	// CJK UNIFIED IDEOGRAPH
	{0x609D,	0xD1A7},	// CJK UNIFIED IDEOGRAPH
	{0x609F,	0xAEA9},	// CJK UNIFIED IDEOGRAPH
	{0x60A0,	0xB179},	// CJK UNIFIED IDEOGRAPH
	{0x60A2,	0xD1A2},	// CJK UNIFIED IDEOGRAPH
	{0x60A3,	0xB177},	// CJK UNIFIED IDEOGRAPH
	{0x60A8,	0xB17A},	// CJK UNIFIED IDEOGRAPH
	{0x60B0,	0xD555},	// CJK UNIFIED IDEOGRAPH
	{0x60B1,	0xD55E},	// CJK UNIFIED IDEOGRAPH
	{0x60B2,	0xB464},	// CJK UNIFIED IDEOGRAPH
	{0x60B4,	0xB17C},	// CJK UNIFIED IDEOGRAPH
	{0x60B5,	0xB1A3},	// CJK UNIFIED IDEOGRAPH
	{0x60B6,	0xB465},	// CJK UNIFIED IDEOGRAPH
	{0x60B7,	0xD560},	// CJK UNIFIED IDEOGRAPH
	{0x60B8,	0xB1AA},	// CJK UNIFIED IDEOGRAPH
	{0x60B9,	0xD8F9},	// CJK UNIFIED IDEOGRAPH
	{0x60BA,	0xD556},	// CJK UNIFIED IDEOGRAPH
	{0x60BB,	0xB1A2},	// CJK UNIFIED IDEOGRAPH
	{0x60BC,	0xB1A5},	// CJK UNIFIED IDEOGRAPH
	{0x60BD,	0xB17E},	// CJK UNIFIED IDEOGRAPH
	{0x60BE,	0xD554},	// CJK UNIFIED IDEOGRAPH
	{0x60BF,	0xD562},	// CJK UNIFIED IDEOGRAPH
	{0x60C0,	0xD565},	// CJK UNIFIED IDEOGRAPH
	{0x60C1,	0xD949},	// CJK UNIFIED IDEOGRAPH
	{0x60C3,	0xD563},	// CJK UNIFIED IDEOGRAPH
	{0x60C4,	0xD8FD},	// CJK UNIFIED IDEOGRAPH
	{0x60C5,	0xB1A1},	// CJK UNIFIED IDEOGRAPH
	{0x60C6,	0xB1A8},	// CJK UNIFIED IDEOGRAPH
	{0x60C7,	0xB1AC},	// CJK UNIFIED IDEOGRAPH
	{0x60C8,	0xD55D},	// CJK UNIFIED IDEOGRAPH
	{0x60C9,	0xD8F8},	// CJK UNIFIED IDEOGRAPH
	{0x60CA,	0xD561},	// CJK UNIFIED IDEOGRAPH
	{0x60CB,	0xB17B},	// CJK UNIFIED IDEOGRAPH
	{0x60CC,	0xD8FA},	// CJK UNIFIED IDEOGRAPH
	{0x60CD,	0xD564},	// CJK UNIFIED IDEOGRAPH
	{0x60CE,	0xD8FC},	// CJK UNIFIED IDEOGRAPH
	{0x60CF,	0xD559},	// CJK UNIFIED IDEOGRAPH
	{0x60D1,	0xB462},	// CJK UNIFIED IDEOGRAPH
	{0x60D3,	0xD557},	// CJK UNIFIED IDEOGRAPH
	{0x60D4,	0xD558},	// CJK UNIFIED IDEOGRAPH
	{0x60D5,	0xB1A7},	// CJK UNIFIED IDEOGRAPH
	{0x60D8,	0xB1A6},	// CJK UNIFIED IDEOGRAPH
	{0x60D9,	0xD55B},	// CJK UNIFIED IDEOGRAPH
	{0x60DA,	0xB1AB},	// CJK UNIFIED IDEOGRAPH
	{0x60DB,	0xD55F},	// CJK UNIFIED IDEOGRAPH
	{0x60DC,	0xB1A4},	// CJK UNIFIED IDEOGRAPH
	{0x60DD,	0xD55C},	// CJK UNIFIED IDEOGRAPH
	{0x60DF,	0xB1A9},	// CJK UNIFIED IDEOGRAPH
	{0x60E0,	0xB466},	// CJK UNIFIED IDEOGRAPH
	{0x60E1,	0xB463},	// CJK UNIFIED IDEOGRAPH
	{0x60E2,	0xD8FB},	// CJK UNIFIED IDEOGRAPH
	{0x60E4,	0xD55A},	// CJK UNIFIED IDEOGRAPH
	{0x60E6,	0xB17D},	// CJK UNIFIED IDEOGRAPH
	{0x60F0,	0xB46B},	// CJK UNIFIED IDEOGRAPH
	{0x60F1,	0xB46F},	// CJK UNIFIED IDEOGRAPH
	{0x60F2,	0xD940},	// CJK UNIFIED IDEOGRAPH
	{0x60F3,	0xB751},	// CJK UNIFIED IDEOGRAPH
	{0x60F4,	0xB46D},	// CJK UNIFIED IDEOGRAPH
	{0x60F5,	0xD944},	// CJK UNIFIED IDEOGRAPH
	{0x60F6,	0xB471},	// CJK UNIFIED IDEOGRAPH
	{0x60F7,	0xDD65},	// CJK UNIFIED IDEOGRAPH
	{0x60F8,	0xD946},	// CJK UNIFIED IDEOGRAPH
	{0x60F9,	0xB753},	// CJK UNIFIED IDEOGRAPH
	{0x60FA,	0xB469},	// CJK UNIFIED IDEOGRAPH
	{0x60FB,	0xB46C},	// CJK UNIFIED IDEOGRAPH
	{0x60FC,	0xD947},	// CJK UNIFIED IDEOGRAPH
	{0x60FE,	0xD948},	// CJK UNIFIED IDEOGRAPH
	{0x60FF,	0xD94E},	// CJK UNIFIED IDEOGRAPH
	{0x6100,	0xB473},	// CJK UNIFIED IDEOGRAPH
	{0x6101,	0xB754},	// CJK UNIFIED IDEOGRAPH
	{0x6103,	0xD94A},	// CJK UNIFIED IDEOGRAPH
	{0x6104,	0xD94F},	// CJK UNIFIED IDEOGRAPH
	{0x6105,	0xD943},	// CJK UNIFIED IDEOGRAPH
	{0x6106,	0xB75E},	// CJK UNIFIED IDEOGRAPH
	{0x6108,	0xB755},	// CJK UNIFIED IDEOGRAPH
	{0x6109,	0xB472},	// CJK UNIFIED IDEOGRAPH
	{0x610A,	0xD941},	// CJK UNIFIED IDEOGRAPH
	{0x610B,	0xD950},	// CJK UNIFIED IDEOGRAPH
	{0x610D,	0xB75D},	// CJK UNIFIED IDEOGRAPH
	{0x610E,	0xB470},	// CJK UNIFIED IDEOGRAPH
	{0x610F,	0xB74E},	// CJK UNIFIED IDEOGRAPH
	{0x6110,	0xD94D},	// CJK UNIFIED IDEOGRAPH
	{0x6112,	0xB474},	// CJK UNIFIED IDEOGRAPH
	{0x6113,	0xD945},	// CJK UNIFIED IDEOGRAPH
	{0x6114,	0xD8FE},	// CJK UNIFIED IDEOGRAPH
	{0x6115,	0xB46A},	// CJK UNIFIED IDEOGRAPH
	{0x6116,	0xD942},	// CJK UNIFIED IDEOGRAPH
	{0x6118,	0xD94B},	// CJK UNIFIED IDEOGRAPH
	{0x611A,	0xB74D},	// CJK UNIFIED IDEOGRAPH
	{0x611B,	0xB752},	// CJK UNIFIED IDEOGRAPH
	{0x611C,	0xB467},	// CJK UNIFIED IDEOGRAPH
	{0x611D,	0xD94C},	// CJK UNIFIED IDEOGRAPH
	{0x611F,	0xB750},	// CJK UNIFIED IDEOGRAPH
	{0x6123,	0xB468},	// CJK UNIFIED IDEOGRAPH
	{0x6127,	0xB75C},	// CJK UNIFIED IDEOGRAPH
	{0x6128,	0xE1C3},	// CJK UNIFIED IDEOGRAPH
	{0x6129,	0xDD70},	// CJK UNIFIED IDEOGRAPH
	{0x612B,	0xDD68},	// CJK UNIFIED IDEOGRAPH
	{0x612C,	0xE1C2},	// CJK UNIFIED IDEOGRAPH
	{0x612E,	0xDD6C},	// CJK UNIFIED IDEOGRAPH
	{0x612F,	0xDD6E},	// CJK UNIFIED IDEOGRAPH
	{0x6132,	0xDD6B},	// CJK UNIFIED IDEOGRAPH
	{0x6134,	0xB75B},	// CJK UNIFIED IDEOGRAPH
	{0x6136,	0xDD6A},	// CJK UNIFIED IDEOGRAPH
	{0x6137,	0xB75F},	// CJK UNIFIED IDEOGRAPH
	{0x613B,	0xE1D2},	// CJK UNIFIED IDEOGRAPH
	{0x613E,	0xB75A},	// CJK UNIFIED IDEOGRAPH
	{0x613F,	0xBA40},	// CJK UNIFIED IDEOGRAPH
	{0x6140,	0xDD71},	// CJK UNIFIED IDEOGRAPH
	{0x6141,	0xE1C4},	// CJK UNIFIED IDEOGRAPH
	{0x6144,	0xB758},	// CJK UNIFIED IDEOGRAPH
	{0x6145,	0xDD69},	// CJK UNIFIED IDEOGRAPH
	{0x6146,	0xDD6D},	// CJK UNIFIED IDEOGRAPH
	{0x6147,	0xB9FE},	// CJK UNIFIED IDEOGRAPH
	{0x6148,	0xB74F},	// CJK UNIFIED IDEOGRAPH
	{0x6149,	0xDD66},	// CJK UNIFIED IDEOGRAPH
	{0x614A,	0xDD67},	// CJK UNIFIED IDEOGRAPH
	{0x614B,	0xBA41},	// CJK UNIFIED IDEOGRAPH
	{0x614C,	0xB757},	// CJK UNIFIED IDEOGRAPH
	{0x614D,	0xB759},	// CJK UNIFIED IDEOGRAPH
	{0x614E,	0xB756},	// CJK UNIFIED IDEOGRAPH
	{0x614F,	0xDD6F},	// CJK UNIFIED IDEOGRAPH
	{0x6152,	0xE1C8},	// CJK UNIFIED IDEOGRAPH
	{0x6153,	0xE1C9},	// CJK UNIFIED IDEOGRAPH
	{0x6154,	0xE1CE},	// CJK UNIFIED IDEOGRAPH
	{0x6155,	0xBC7D},	// CJK UNIFIED IDEOGRAPH
	{0x6156,	0xE1D5},	// CJK UNIFIED IDEOGRAPH
	{0x6158,	0xBA47},	// CJK UNIFIED IDEOGRAPH
	{0x615A,	0xBA46},	// CJK UNIFIED IDEOGRAPH
	{0x615B,	0xE1D0},	// CJK UNIFIED IDEOGRAPH
	{0x615D,	0xBC7C},	// CJK UNIFIED IDEOGRAPH
	{0x615E,	0xE1C5},	// CJK UNIFIED IDEOGRAPH
	{0x615F,	0xBA45},	// CJK UNIFIED IDEOGRAPH
	{0x6161,	0xE1D4},	// CJK UNIFIED IDEOGRAPH
	{0x6162,	0xBA43},	// CJK UNIFIED IDEOGRAPH
	{0x6163,	0xBA44},	// CJK UNIFIED IDEOGRAPH
	{0x6165,	0xE1D1},	// CJK UNIFIED IDEOGRAPH
	{0x6166,	0xE5AA},	// CJK UNIFIED IDEOGRAPH
	{0x6167,	0xBC7A},	// CJK UNIFIED IDEOGRAPH
	{0x6168,	0xB46E},	// CJK UNIFIED IDEOGRAPH
	{0x616A,	0xE1D3},	// CJK UNIFIED IDEOGRAPH
	{0x616B,	0xBCA3},	// CJK UNIFIED IDEOGRAPH
	{0x616C,	0xE1CB},	// CJK UNIFIED IDEOGRAPH
	{0x616E,	0xBC7B},	// CJK UNIFIED IDEOGRAPH
	{0x6170,	0xBCA2},	// CJK UNIFIED IDEOGRAPH
	{0x6171,	0xE1C6},	// CJK UNIFIED IDEOGRAPH
	{0x6172,	0xE1CA},	// CJK UNIFIED IDEOGRAPH
	{0x6173,	0xE1C7},	// CJK UNIFIED IDEOGRAPH
	{0x6174,	0xE1CD},	// CJK UNIFIED IDEOGRAPH
	{0x6175,	0xBA48},	// CJK UNIFIED IDEOGRAPH
	{0x6176,	0xBC79},	// CJK UNIFIED IDEOGRAPH
	{0x6177,	0xBA42},	// CJK UNIFIED IDEOGRAPH
	{0x6179,	0xE57A},	// CJK UNIFIED IDEOGRAPH
	{0x617A,	0xE1CF},	// CJK UNIFIED IDEOGRAPH
	{0x617C,	0xBCA1},	// CJK UNIFIED IDEOGRAPH
	{0x617E,	0xBCA4},	// CJK UNIFIED IDEOGRAPH
	{0x6180,	0xE1CC},	// CJK UNIFIED IDEOGRAPH
	{0x6182,	0xBC7E},	// CJK UNIFIED IDEOGRAPH
	{0x6183,	0xE579},	// CJK UNIFIED IDEOGRAPH
	{0x6189,	0xE57E},	// CJK UNIFIED IDEOGRAPH
	{0x618A,	0xBECE},	// CJK UNIFIED IDEOGRAPH
	{0x618B,	0xE578},	// CJK UNIFIED IDEOGRAPH
	{0x618C,	0xE9A3},	// CJK UNIFIED IDEOGRAPH
	{0x618D,	0xE5A9},	// CJK UNIFIED IDEOGRAPH
	{0x618E,	0xBCA8},	// CJK UNIFIED IDEOGRAPH
	{0x6190,	0xBCA6},	// CJK UNIFIED IDEOGRAPH
	{0x6191,	0xBECC},	// CJK UNIFIED IDEOGRAPH
	{0x6192,	0xE5A6},	// CJK UNIFIED IDEOGRAPH
	{0x6193,	0xE5A2},	// CJK UNIFIED IDEOGRAPH
	{0x6194,	0xBCAC},	// CJK UNIFIED IDEOGRAPH
	{0x6196,	0xE978},	// CJK UNIFIED IDEOGRAPH
	{0x619A,	0xBCAA},	// CJK UNIFIED IDEOGRAPH
	{0x619B,	0xE5A1},	// CJK UNIFIED IDEOGRAPH
	{0x619D,	0xE976},	// CJK UNIFIED IDEOGRAPH
	{0x619F,	0xE5A5},	// CJK UNIFIED IDEOGRAPH
	{0x61A1,	0xE5A8},	// CJK UNIFIED IDEOGRAPH
	{0x61A2,	0xE57D},	// CJK UNIFIED IDEOGRAPH
	{0x61A4,	0xBCAB},	// CJK UNIFIED IDEOGRAPH
	{0x61A7,	0xBCA5},	// CJK UNIFIED IDEOGRAPH
	{0x61A8,	0xE977},	// CJK UNIFIED IDEOGRAPH
	{0x61A9,	0xBECD},	// CJK UNIFIED IDEOGRAPH
	{0x61AA,	0xE5A7},	// CJK UNIFIED IDEOGRAPH
	{0x61AB,	0xBCA7},	// CJK UNIFIED IDEOGRAPH
	{0x61AC,	0xBCA9},	// CJK UNIFIED IDEOGRAPH
	{0x61AD,	0xE5A4},	// CJK UNIFIED IDEOGRAPH
	{0x61AE,	0xBCAD},	// CJK UNIFIED IDEOGRAPH
	{0x61AF,	0xE5A3},	// CJK UNIFIED IDEOGRAPH
	{0x61B0,	0xE57C},	// CJK UNIFIED IDEOGRAPH
	{0x61B1,	0xE57B},	// CJK UNIFIED IDEOGRAPH
	{0x61B2,	0xBECB},	// CJK UNIFIED IDEOGRAPH
	{0x61B3,	0xE5AB},	// CJK UNIFIED IDEOGRAPH
	{0x61B4,	0xE97A},	// CJK UNIFIED IDEOGRAPH
	{0x61B5,	0xECE0},	// CJK UNIFIED IDEOGRAPH
	{0x61B6,	0xBED0},	// CJK UNIFIED IDEOGRAPH
	{0x61B8,	0xE9A2},	// CJK UNIFIED IDEOGRAPH
	{0x61BA,	0xE97E},	// CJK UNIFIED IDEOGRAPH
	{0x61BC,	0xECE1},	// CJK UNIFIED IDEOGRAPH
	{0x61BE,	0xBED1},	// CJK UNIFIED IDEOGRAPH
	{0x61BF,	0xE9A1},	// CJK UNIFIED IDEOGRAPH
	{0x61C1,	0xE97C},	// CJK UNIFIED IDEOGRAPH
	{0x61C2,	0xC0B4},	// CJK UNIFIED IDEOGRAPH
	{0x61C3,	0xECDF},	// CJK UNIFIED IDEOGRAPH
	{0x61C5,	0xE979},	// CJK UNIFIED IDEOGRAPH
	{0x61C6,	0xE97B},	// CJK UNIFIED IDEOGRAPH
	{0x61C7,	0xC0B5},	// CJK UNIFIED IDEOGRAPH
	{0x61C8,	0xBED3},	// CJK UNIFIED IDEOGRAPH
	{0x61C9,	0xC0B3},	// CJK UNIFIED IDEOGRAPH
	{0x61CA,	0xBED2},	// CJK UNIFIED IDEOGRAPH
	{0x61CB,	0xC0B7},	// CJK UNIFIED IDEOGRAPH
	{0x61CC,	0xE97D},	// CJK UNIFIED IDEOGRAPH
	{0x61CD,	0xBECF},	// CJK UNIFIED IDEOGRAPH
	{0x61D6,	0xEFCF},	// CJK UNIFIED IDEOGRAPH
	{0x61D8,	0xEFC7},	// CJK UNIFIED IDEOGRAPH
	{0x61DE,	0xECE7},	// CJK UNIFIED IDEOGRAPH
	{0x61DF,	0xEFC8},	// CJK UNIFIED IDEOGRAPH
	{0x61E0,	0xECE3},	// CJK UNIFIED IDEOGRAPH
	{0x61E3,	0xC256},	// CJK UNIFIED IDEOGRAPH
	{0x61E4,	0xECE5},	// CJK UNIFIED IDEOGRAPH
	{0x61E5,	0xECE4},	// CJK UNIFIED IDEOGRAPH
	{0x61E6,	0xC0B6},	// CJK UNIFIED IDEOGRAPH
	{0x61E7,	0xECE2},	// CJK UNIFIED IDEOGRAPH
	{0x61E8,	0xECE6},	// CJK UNIFIED IDEOGRAPH
	{0x61E9,	0xEFD0},	// CJK UNIFIED IDEOGRAPH
	{0x61EA,	0xEFCC},	// CJK UNIFIED IDEOGRAPH
	{0x61EB,	0xEFCE},	// CJK UNIFIED IDEOGRAPH
	{0x61ED,	0xEFC9},	// CJK UNIFIED IDEOGRAPH
	{0x61EE,	0xEFCA},	// CJK UNIFIED IDEOGRAPH
	{0x61F0,	0xEFCD},	// CJK UNIFIED IDEOGRAPH
	{0x61F1,	0xEFCB},	// CJK UNIFIED IDEOGRAPH
	{0x61F2,	0xC367},	// CJK UNIFIED IDEOGRAPH
	{0x61F5,	0xC36A},	// CJK UNIFIED IDEOGRAPH
	{0x61F6,	0xC369},	// CJK UNIFIED IDEOGRAPH
	{0x61F7,	0xC368},	// CJK UNIFIED IDEOGRAPH
	{0x61F8,	0xC461},	// CJK UNIFIED IDEOGRAPH
	{0x61F9,	0xF44A},	// CJK UNIFIED IDEOGRAPH
	{0x61FA,	0xC462},	// CJK UNIFIED IDEOGRAPH
	{0x61FB,	0xF241},	// CJK UNIFIED IDEOGRAPH
	{0x61FC,	0xC4DF},	// CJK UNIFIED IDEOGRAPH
	{0x61FD,	0xF5CC},	// CJK UNIFIED IDEOGRAPH
	{0x61FE,	0xC4E0},	// CJK UNIFIED IDEOGRAPH
	{0x61FF,	0xC574},	// CJK UNIFIED IDEOGRAPH
	{0x6200,	0xC5CA},	// CJK UNIFIED IDEOGRAPH
	{0x6201,	0xF7D9},	// CJK UNIFIED IDEOGRAPH
	{0x6203,	0xF7DA},	// CJK UNIFIED IDEOGRAPH
	{0x6204,	0xF7DB},	// CJK UNIFIED IDEOGRAPH
	{0x6207,	0xF9BA},	// CJK UNIFIED IDEOGRAPH
	{0x6208,	0xA4E0},	// CJK UNIFIED IDEOGRAPH
	{0x6209,	0xC97C},	// CJK UNIFIED IDEOGRAPH
	{0x620A,	0xA5B3},	// CJK UNIFIED IDEOGRAPH
	{0x620C,	0xA6A6},	// CJK UNIFIED IDEOGRAPH
	{0x620D,	0xA6A7},	// CJK UNIFIED IDEOGRAPH
	{0x620E,	0xA6A5},	// CJK UNIFIED IDEOGRAPH
	{0x6210,	0xA6A8},	// CJK UNIFIED IDEOGRAPH
	{0x6211,	0xA7DA},	// CJK UNIFIED IDEOGRAPH
	{0x6212,	0xA7D9},	// CJK UNIFIED IDEOGRAPH
	{0x6214,	0xCCB1},	// CJK UNIFIED IDEOGRAPH
	{0x6215,	0xA9CF},	// CJK UNIFIED IDEOGRAPH
	{0x6216,	0xA9CE},	// CJK UNIFIED IDEOGRAPH
	{0x6219,	0xD1AF},	// CJK UNIFIED IDEOGRAPH
	{0x621A,	0xB1AD},	// CJK UNIFIED IDEOGRAPH
	{0x621B,	0xB1AE},	// CJK UNIFIED IDEOGRAPH
	{0x621F,	0xB475},	// CJK UNIFIED IDEOGRAPH
	{0x6220,	0xDD72},	// CJK UNIFIED IDEOGRAPH
	{0x6221,	0xB760},	// CJK UNIFIED IDEOGRAPH
	{0x6222,	0xB761},	// CJK UNIFIED IDEOGRAPH
	{0x6223,	0xDD74},	// CJK UNIFIED IDEOGRAPH
	{0x6224,	0xDD76},	// CJK UNIFIED IDEOGRAPH
	{0x6225,	0xDD75},	// CJK UNIFIED IDEOGRAPH
	{0x6227,	0xE1D7},	// CJK UNIFIED IDEOGRAPH
	{0x6229,	0xE1D6},	// CJK UNIFIED IDEOGRAPH
	{0x622A,	0xBA49},	// CJK UNIFIED IDEOGRAPH
	{0x622B,	0xE1D8},	// CJK UNIFIED IDEOGRAPH
	{0x622D,	0xE5AC},	// CJK UNIFIED IDEOGRAPH
	{0x622E,	0xBCAE},	// CJK UNIFIED IDEOGRAPH
	{0x6230,	0xBED4},	// CJK UNIFIED IDEOGRAPH
	{0x6232,	0xC0B8},	// CJK UNIFIED IDEOGRAPH
	{0x6233,	0xC257},	// CJK UNIFIED IDEOGRAPH
	{0x6234,	0xC0B9},	// CJK UNIFIED IDEOGRAPH
	{0x6236,	0xA4E1},	// CJK UNIFIED IDEOGRAPH
	{0x623A,	0xCAE6},	// CJK UNIFIED IDEOGRAPH
	{0x623D,	0xCCB2},	// CJK UNIFIED IDEOGRAPH
	{0x623E,	0xA9D1},	// CJK UNIFIED IDEOGRAPH
	{0x623F,	0xA9D0},	// CJK UNIFIED IDEOGRAPH
	{0x6240,	0xA9D2},	// CJK UNIFIED IDEOGRAPH
	{0x6241,	0xABF3},	// CJK UNIFIED IDEOGRAPH
	{0x6242,	0xCED2},	// CJK UNIFIED IDEOGRAPH
	{0x6243,	0xCED3},	// CJK UNIFIED IDEOGRAPH
	{0x6246,	0xD1B0},	// CJK UNIFIED IDEOGRAPH
	{0x6247,	0xAEB0},	// CJK UNIFIED IDEOGRAPH
	{0x6248,	0xB1AF},	// CJK UNIFIED IDEOGRAPH
	{0x6249,	0xB476},	// CJK UNIFIED IDEOGRAPH
	{0x624A,	0xD951},	// CJK UNIFIED IDEOGRAPH
	{0x624B,	0xA4E2},	// CJK UNIFIED IDEOGRAPH
	{0x624D,	0xA47E},	// CJK UNIFIED IDEOGRAPH
	{0x624E,	0xA4E3},	// CJK UNIFIED IDEOGRAPH
	{0x6250,	0xC97D},	// CJK UNIFIED IDEOGRAPH
	{0x6251,	0xA5B7},	// CJK UNIFIED IDEOGRAPH
	{0x6252,	0xA5B6},	// CJK UNIFIED IDEOGRAPH
	{0x6253,	0xA5B4},	// CJK UNIFIED IDEOGRAPH
	{0x6254,	0xA5B5},	// CJK UNIFIED IDEOGRAPH
	{0x6258,	0xA6AB},	// CJK UNIFIED IDEOGRAPH
	{0x6259,	0xC9E9},	// CJK UNIFIED IDEOGRAPH
	{0x625A,	0xC9EB},	// CJK UNIFIED IDEOGRAPH
	{0x625B,	0xA6AA},	// CJK UNIFIED IDEOGRAPH
	{0x625C,	0xC9E3},	// CJK UNIFIED IDEOGRAPH
	{0x625E,	0xC9E4},	// CJK UNIFIED IDEOGRAPH
	{0x6260,	0xC9EA},	// CJK UNIFIED IDEOGRAPH
	{0x6261,	0xC9E6},	// CJK UNIFIED IDEOGRAPH
	{0x6262,	0xC9E8},	// CJK UNIFIED IDEOGRAPH
	{0x6263,	0xA6A9},	// CJK UNIFIED IDEOGRAPH
	{0x6264,	0xC9E5},	// CJK UNIFIED IDEOGRAPH
	{0x6265,	0xC9EC},	// CJK UNIFIED IDEOGRAPH
	{0x6266,	0xC9E7},	// CJK UNIFIED IDEOGRAPH
	{0x626D,	0xA7E1},	// CJK UNIFIED IDEOGRAPH
	{0x626E,	0xA7EA},	// CJK UNIFIED IDEOGRAPH
	{0x626F,	0xA7E8},	// CJK UNIFIED IDEOGRAPH
	{0x6270,	0xCAF0},	// CJK UNIFIED IDEOGRAPH
	{0x6271,	0xCAED},	// CJK UNIFIED IDEOGRAPH
	{0x6272,	0xCAF5},	// CJK UNIFIED IDEOGRAPH
	{0x6273,	0xA7E6},	// CJK UNIFIED IDEOGRAPH
	{0x6274,	0xCAF6},	// CJK UNIFIED IDEOGRAPH
	{0x6276,	0xA7DF},	// CJK UNIFIED IDEOGRAPH
	{0x6277,	0xCAF3},	// CJK UNIFIED IDEOGRAPH
	{0x6279,	0xA7E5},	// CJK UNIFIED IDEOGRAPH
	{0x627A,	0xCAEF},	// CJK UNIFIED IDEOGRAPH
	{0x627B,	0xCAEE},	// CJK UNIFIED IDEOGRAPH
	{0x627C,	0xA7E3},	// CJK UNIFIED IDEOGRAPH
	{0x627D,	0xCAF4},	// CJK UNIFIED IDEOGRAPH
	{0x627E,	0xA7E4},	// CJK UNIFIED IDEOGRAPH
	{0x627F,	0xA9D3},	// CJK UNIFIED IDEOGRAPH
	{0x6280,	0xA7DE},	// CJK UNIFIED IDEOGRAPH
	{0x6281,	0xCAF1},	// CJK UNIFIED IDEOGRAPH
	{0x6283,	0xCAE7},	// CJK UNIFIED IDEOGRAPH
	{0x6284,	0xA7DB},	// CJK UNIFIED IDEOGRAPH
	{0x6286,	0xA7EE},	// CJK UNIFIED IDEOGRAPH
	{0x6287,	0xCAEC},	// CJK UNIFIED IDEOGRAPH
	{0x6288,	0xCAF2},	// CJK UNIFIED IDEOGRAPH
	{0x6289,	0xA7E0},	// CJK UNIFIED IDEOGRAPH
	{0x628A,	0xA7E2},	// CJK UNIFIED IDEOGRAPH
	{0x628C,	0xCAE8},	// CJK UNIFIED IDEOGRAPH
	{0x628E,	0xCAE9},	// CJK UNIFIED IDEOGRAPH
	{0x628F,	0xCAEA},	// CJK UNIFIED IDEOGRAPH
	{0x6291,	0xA7ED},	// CJK UNIFIED IDEOGRAPH
	{0x6292,	0xA7E7},	// CJK UNIFIED IDEOGRAPH
	{0x6293,	0xA7EC},	// CJK UNIFIED IDEOGRAPH
	{0x6294,	0xCAEB},	// CJK UNIFIED IDEOGRAPH
	{0x6295,	0xA7EB},	// CJK UNIFIED IDEOGRAPH
	{0x6296,	0xA7DD},	// CJK UNIFIED IDEOGRAPH
	{0x6297,	0xA7DC},	// CJK UNIFIED IDEOGRAPH
	{0x6298,	0xA7E9},	// CJK UNIFIED IDEOGRAPH
	{0x62A8,	0xA9E1},	// CJK UNIFIED IDEOGRAPH
	{0x62A9,	0xCCBE},	// CJK UNIFIED IDEOGRAPH
	{0x62AA,	0xCCB7},	// CJK UNIFIED IDEOGRAPH
	{0x62AB,	0xA9DC},	// CJK UNIFIED IDEOGRAPH
	{0x62AC,	0xA9EF},	// CJK UNIFIED IDEOGRAPH
	{0x62AD,	0xCCB3},	// CJK UNIFIED IDEOGRAPH
	{0x62AE,	0xCCBA},	// CJK UNIFIED IDEOGRAPH
	{0x62AF,	0xCCBC},	// CJK UNIFIED IDEOGRAPH
	{0x62B0,	0xCCBF},	// CJK UNIFIED IDEOGRAPH
	{0x62B1,	0xA9EA},	// CJK UNIFIED IDEOGRAPH
	{0x62B3,	0xCCBB},	// CJK UNIFIED IDEOGRAPH
	{0x62B4,	0xCCB4},	// CJK UNIFIED IDEOGRAPH
	{0x62B5,	0xA9E8},	// CJK UNIFIED IDEOGRAPH
	{0x62B6,	0xCCB8},	// CJK UNIFIED IDEOGRAPH
	{0x62B8,	0xCCC0},	// CJK UNIFIED IDEOGRAPH
	{0x62B9,	0xA9D9},	// CJK UNIFIED IDEOGRAPH
	{0x62BB,	0xCCBD},	// CJK UNIFIED IDEOGRAPH
	{0x62BC,	0xA9E3},	// CJK UNIFIED IDEOGRAPH
	{0x62BD,	0xA9E2},	// CJK UNIFIED IDEOGRAPH
	{0x62BE,	0xCCB6},	// CJK UNIFIED IDEOGRAPH
	{0x62BF,	0xA9D7},	// CJK UNIFIED IDEOGRAPH
	{0x62C2,	0xA9D8},	// CJK UNIFIED IDEOGRAPH
	{0x62C4,	0xA9D6},	// CJK UNIFIED IDEOGRAPH
	{0x62C6,	0xA9EE},	// CJK UNIFIED IDEOGRAPH
	{0x62C7,	0xA9E6},	// CJK UNIFIED IDEOGRAPH
	{0x62C8,	0xA9E0},	// CJK UNIFIED IDEOGRAPH
	{0x62C9,	0xA9D4},	// CJK UNIFIED IDEOGRAPH
	{0x62CA,	0xCCB9},	// CJK UNIFIED IDEOGRAPH
	{0x62CB,	0xA9DF},	// CJK UNIFIED IDEOGRAPH
	{0x62CC,	0xA9D5},	// CJK UNIFIED IDEOGRAPH
	{0x62CD,	0xA9E7},	// CJK UNIFIED IDEOGRAPH
	{0x62CE,	0xA9F0},	// CJK UNIFIED IDEOGRAPH
	{0x62CF,	0xCED4},	// CJK UNIFIED IDEOGRAPH
	{0x62D0,	0xA9E4},	// CJK UNIFIED IDEOGRAPH
	{0x62D1,	0xCCB5},	// CJK UNIFIED IDEOGRAPH
	{0x62D2,	0xA9DA},	// CJK UNIFIED IDEOGRAPH
	{0x62D3,	0xA9DD},	// CJK UNIFIED IDEOGRAPH
	{0x62D4,	0xA9DE},	// CJK UNIFIED IDEOGRAPH
	{0x62D6,	0xA9EC},	// CJK UNIFIED IDEOGRAPH
	{0x62D7,	0xA9ED},	// CJK UNIFIED IDEOGRAPH
	{0x62D8,	0xA9EB},	// CJK UNIFIED IDEOGRAPH
	{0x62D9,	0xA9E5},	// CJK UNIFIED IDEOGRAPH
	{0x62DA,	0xA9E9},	// CJK UNIFIED IDEOGRAPH
	{0x62DB,	0xA9DB},	// CJK UNIFIED IDEOGRAPH
	{0x62DC,	0xABF4},	// CJK UNIFIED IDEOGRAPH
	{0x62EB,	0xCEDA},	// CJK UNIFIED IDEOGRAPH
	{0x62EC,	0xAC41},	// CJK UNIFIED IDEOGRAPH
	{0x62ED,	0xABF8},	// CJK UNIFIED IDEOGRAPH
	{0x62EE,	0xABFA},	// CJK UNIFIED IDEOGRAPH
	{0x62EF,	0xAC40},	// CJK UNIFIED IDEOGRAPH
	{0x62F0,	0xCEE6},	// CJK UNIFIED IDEOGRAPH
	{0x62F1,	0xABFD},	// CJK UNIFIED IDEOGRAPH
	{0x62F2,	0xD1B1},	// CJK UNIFIED IDEOGRAPH
	{0x62F3,	0xAEB1},	// CJK UNIFIED IDEOGRAPH
	{0x62F4,	0xAC43},	// CJK UNIFIED IDEOGRAPH
	{0x62F5,	0xCED7},	// CJK UNIFIED IDEOGRAPH
	{0x62F6,	0xCEDF},	// CJK UNIFIED IDEOGRAPH
	{0x62F7,	0xABFE},	// CJK UNIFIED IDEOGRAPH
	{0x62F8,	0xCEDE},	// CJK UNIFIED IDEOGRAPH
	{0x62F9,	0xCEDB},	// CJK UNIFIED IDEOGRAPH
	{0x62FA,	0xCEE3},	// CJK UNIFIED IDEOGRAPH
	{0x62FB,	0xCEE5},	// CJK UNIFIED IDEOGRAPH
	{0x62FC,	0xABF7},	// CJK UNIFIED IDEOGRAPH
	{0x62FD,	0xABFB},	// CJK UNIFIED IDEOGRAPH
	{0x62FE,	0xAC42},	// CJK UNIFIED IDEOGRAPH
	{0x62FF,	0xAEB3},	// CJK UNIFIED IDEOGRAPH
	{0x6300,	0xCEE0},	// CJK UNIFIED IDEOGRAPH
	{0x6301,	0xABF9},	// CJK UNIFIED IDEOGRAPH
	{0x6302,	0xAC45},	// CJK UNIFIED IDEOGRAPH
	{0x6303,	0xCED9},	// CJK UNIFIED IDEOGRAPH
	{0x6307,	0xABFC},	// CJK UNIFIED IDEOGRAPH
	{0x6308,	0xAEB2},	// CJK UNIFIED IDEOGRAPH
	{0x6309,	0xABF6},	// CJK UNIFIED IDEOGRAPH
	{0x630B,	0xCED6},	// CJK UNIFIED IDEOGRAPH
	{0x630C,	0xCEDD},	// CJK UNIFIED IDEOGRAPH
	{0x630D,	0xCED5},	// CJK UNIFIED IDEOGRAPH
	{0x630E,	0xCED8},	// CJK UNIFIED IDEOGRAPH
	{0x630F,	0xCEDC},	// CJK UNIFIED IDEOGRAPH
	{0x6310,	0xD1B2},	// CJK UNIFIED IDEOGRAPH
	{0x6311,	0xAC44},	// CJK UNIFIED IDEOGRAPH
	{0x6313,	0xCEE1},	// CJK UNIFIED IDEOGRAPH
	{0x6314,	0xCEE2},	// CJK UNIFIED IDEOGRAPH
	{0x6315,	0xCEE4},	// CJK UNIFIED IDEOGRAPH
	{0x6316,	0xABF5},	// CJK UNIFIED IDEOGRAPH
	{0x6328,	0xAEC1},	// CJK UNIFIED IDEOGRAPH
	{0x6329,	0xD1BE},	// CJK UNIFIED IDEOGRAPH
	{0x632A,	0xAEBF},	// CJK UNIFIED IDEOGRAPH
	{0x632B,	0xAEC0},	// CJK UNIFIED IDEOGRAPH
	{0x632C,	0xD1B4},	// CJK UNIFIED IDEOGRAPH
	{0x632D,	0xD1C4},	// CJK UNIFIED IDEOGRAPH
	{0x632F,	0xAEB6},	// CJK UNIFIED IDEOGRAPH
	{0x6332,	0xD566},	// CJK UNIFIED IDEOGRAPH
	{0x6333,	0xD1C6},	// CJK UNIFIED IDEOGRAPH
	{0x6334,	0xD1C0},	// CJK UNIFIED IDEOGRAPH
	{0x6336,	0xD1B7},	// CJK UNIFIED IDEOGRAPH
	{0x6338,	0xD1C9},	// CJK UNIFIED IDEOGRAPH
	{0x6339,	0xD1BA},	// CJK UNIFIED IDEOGRAPH
	{0x633A,	0xAEBC},	// CJK UNIFIED IDEOGRAPH
	{0x633B,	0xD57D},	// CJK UNIFIED IDEOGRAPH
	{0x633C,	0xD1BD},	// CJK UNIFIED IDEOGRAPH
	{0x633D,	0xAEBE},	// CJK UNIFIED IDEOGRAPH
	{0x633E,	0xAEB5},	// CJK UNIFIED IDEOGRAPH
	{0x6340,	0xD1CB},	// CJK UNIFIED IDEOGRAPH
	{0x6341,	0xD1BF},	// CJK UNIFIED IDEOGRAPH
	{0x6342,	0xAEB8},	// CJK UNIFIED IDEOGRAPH
	{0x6343,	0xD1B8},	// CJK UNIFIED IDEOGRAPH
	{0x6344,	0xD1B5},	// CJK UNIFIED IDEOGRAPH
	{0x6345,	0xD1B6},	// CJK UNIFIED IDEOGRAPH
	{0x6346,	0xAEB9},	// CJK UNIFIED IDEOGRAPH
	{0x6347,	0xD1C5},	// CJK UNIFIED IDEOGRAPH
	{0x6348,	0xD1CC},	// CJK UNIFIED IDEOGRAPH
	{0x6349,	0xAEBB},	// CJK UNIFIED IDEOGRAPH
	{0x634A,	0xD1BC},	// CJK UNIFIED IDEOGRAPH
	{0x634B,	0xD1BB},	// CJK UNIFIED IDEOGRAPH
	{0x634C,	0xAEC3},	// CJK UNIFIED IDEOGRAPH
	{0x634D,	0xAEC2},	// CJK UNIFIED IDEOGRAPH
	{0x634E,	0xAEB4},	// CJK UNIFIED IDEOGRAPH
	{0x634F,	0xAEBA},	// CJK UNIFIED IDEOGRAPH
	{0x6350,	0xAEBD},	// CJK UNIFIED IDEOGRAPH
	{0x6351,	0xD1C8},	// CJK UNIFIED IDEOGRAPH
	{0x6354,	0xD1C2},	// CJK UNIFIED IDEOGRAPH
	{0x6355,	0xAEB7},	// CJK UNIFIED IDEOGRAPH
	{0x6356,	0xD1B3},	// CJK UNIFIED IDEOGRAPH
	{0x6357,	0xD1CA},	// CJK UNIFIED IDEOGRAPH
	{0x6358,	0xD1C1},	// CJK UNIFIED IDEOGRAPH
	{0x6359,	0xD1C3},	// CJK UNIFIED IDEOGRAPH
	{0x635A,	0xD1C7},	// CJK UNIFIED IDEOGRAPH
	{0x6365,	0xD567},	// CJK UNIFIED IDEOGRAPH
	{0x6367,	0xB1B7},	// CJK UNIFIED IDEOGRAPH
	{0x6368,	0xB1CB},	// CJK UNIFIED IDEOGRAPH
	{0x6369,	0xB1CA},	// CJK UNIFIED IDEOGRAPH
	{0x636B,	0xB1BF},	// CJK UNIFIED IDEOGRAPH
	{0x636D,	0xD579},	// CJK UNIFIED IDEOGRAPH
	{0x636E,	0xD575},	// CJK UNIFIED IDEOGRAPH
	{0x636F,	0xD572},	// CJK UNIFIED IDEOGRAPH
	{0x6370,	0xD5A6},	// CJK UNIFIED IDEOGRAPH
	{0x6371,	0xB1BA},	// CJK UNIFIED IDEOGRAPH
	{0x6372,	0xB1B2},	// CJK UNIFIED IDEOGRAPH
	{0x6375,	0xD577},	// CJK UNIFIED IDEOGRAPH
	{0x6376,	0xB4A8},	// CJK UNIFIED IDEOGRAPH
	{0x6377,	0xB1B6},	// CJK UNIFIED IDEOGRAPH
	{0x6378,	0xD5A1},	// CJK UNIFIED IDEOGRAPH
	{0x637A,	0xB1CC},	// CJK UNIFIED IDEOGRAPH
	{0x637B,	0xB1C9},	// CJK UNIFIED IDEOGRAPH
	{0x637C,	0xD57B},	// CJK UNIFIED IDEOGRAPH
	{0x637D,	0xD56A},	// CJK UNIFIED IDEOGRAPH
	{0x6380,	0xB1C8},	// CJK UNIFIED IDEOGRAPH
	{0x6381,	0xD5A3},	// CJK UNIFIED IDEOGRAPH
	{0x6382,	0xD569},	// CJK UNIFIED IDEOGRAPH
	{0x6383,	0xB1BD},	// CJK UNIFIED IDEOGRAPH
	{0x6384,	0xB1C1},	// CJK UNIFIED IDEOGRAPH
	{0x6385,	0xD5A2},	// CJK UNIFIED IDEOGRAPH
	{0x6387,	0xD573},	// CJK UNIFIED IDEOGRAPH
	{0x6388,	0xB1C2},	// CJK UNIFIED IDEOGRAPH
	{0x6389,	0xB1BC},	// CJK UNIFIED IDEOGRAPH
	{0x638A,	0xD568},	// CJK UNIFIED IDEOGRAPH
	{0x638C,	0xB478},	// CJK UNIFIED IDEOGRAPH
	{0x638D,	0xD5A5},	// CJK UNIFIED IDEOGRAPH
	{0x638E,	0xD571},	// CJK UNIFIED IDEOGRAPH
	{0x638F,	0xB1C7},	// CJK UNIFIED IDEOGRAPH
	{0x6390,	0xD574},	// CJK UNIFIED IDEOGRAPH
	{0x6391,	0xD5A4},	// CJK UNIFIED IDEOGRAPH
	{0x6392,	0xB1C6},	// CJK UNIFIED IDEOGRAPH
	{0x6394,	0xD952},	// CJK UNIFIED IDEOGRAPH
	{0x6396,	0xB1B3},	// CJK UNIFIED IDEOGRAPH
	{0x6397,	0xD56F},	// CJK UNIFIED IDEOGRAPH
	{0x6398,	0xB1B8},	// CJK UNIFIED IDEOGRAPH
	{0x6399,	0xB1C3},	// CJK UNIFIED IDEOGRAPH
	{0x639B,	0xB1BE},	// CJK UNIFIED IDEOGRAPH
	{0x639C,	0xD578},	// CJK UNIFIED IDEOGRAPH
	{0x639D,	0xD56E},	// CJK UNIFIED IDEOGRAPH
	{0x639E,	0xD56C},	// CJK UNIFIED IDEOGRAPH
	{0x639F,	0xD57E},	// CJK UNIFIED IDEOGRAPH
	{0x63A0,	0xB1B0},	// CJK UNIFIED IDEOGRAPH
	{0x63A1,	0xB1C4},	// CJK UNIFIED IDEOGRAPH
	{0x63A2,	0xB1B4},	// CJK UNIFIED IDEOGRAPH
	{0x63A3,	0xB477},	// CJK UNIFIED IDEOGRAPH
	{0x63A4,	0xD57C},	// CJK UNIFIED IDEOGRAPH
	{0x63A5,	0xB1B5},	// CJK UNIFIED IDEOGRAPH
	{0x63A7,	0xB1B1},	// CJK UNIFIED IDEOGRAPH
	{0x63A8,	0xB1C0},	// CJK UNIFIED IDEOGRAPH
	{0x63A9,	0xB1BB},	// CJK UNIFIED IDEOGRAPH
	{0x63AA,	0xB1B9},	// CJK UNIFIED IDEOGRAPH
	{0x63AB,	0xD570},	// CJK UNIFIED IDEOGRAPH
	{0x63AC,	0xB1C5},	// CJK UNIFIED IDEOGRAPH
	{0x63AD,	0xD56D},	// CJK UNIFIED IDEOGRAPH
	{0x63AE,	0xD57A},	// CJK UNIFIED IDEOGRAPH
	{0x63AF,	0xD576},	// CJK UNIFIED IDEOGRAPH
	{0x63B0,	0xD954},	// CJK UNIFIED IDEOGRAPH
	{0x63B1,	0xD953},	// CJK UNIFIED IDEOGRAPH
	{0x63BD,	0xD56B},	// CJK UNIFIED IDEOGRAPH
	{0x63BE,	0xD964},	// CJK UNIFIED IDEOGRAPH
	{0x63C0,	0xB47A},	// CJK UNIFIED IDEOGRAPH
	{0x63C2,	0xD96A},	// CJK UNIFIED IDEOGRAPH
	{0x63C3,	0xD959},	// CJK UNIFIED IDEOGRAPH
	{0x63C4,	0xD967},	// CJK UNIFIED IDEOGRAPH
	{0x63C5,	0xDD77},	// CJK UNIFIED IDEOGRAPH
	{0x63C6,	0xB47D},	// CJK UNIFIED IDEOGRAPH
	{0x63C7,	0xD96B},	// CJK UNIFIED IDEOGRAPH
	{0x63C8,	0xD96E},	// CJK UNIFIED IDEOGRAPH
	{0x63C9,	0xB47C},	// CJK UNIFIED IDEOGRAPH
	{0x63CA,	0xD95C},	// CJK UNIFIED IDEOGRAPH
	{0x63CB,	0xD96D},	// CJK UNIFIED IDEOGRAPH
	{0x63CC,	0xD96C},	// CJK UNIFIED IDEOGRAPH
	{0x63CD,	0xB47E},	// CJK UNIFIED IDEOGRAPH
	{0x63CE,	0xD955},	// CJK UNIFIED IDEOGRAPH
	{0x63CF,	0xB479},	// CJK UNIFIED IDEOGRAPH
	{0x63D0,	0xB4A3},	// CJK UNIFIED IDEOGRAPH
	{0x63D2,	0xB4A1},	// CJK UNIFIED IDEOGRAPH
	{0x63D3,	0xD969},	// CJK UNIFIED IDEOGRAPH
	{0x63D5,	0xD95F},	// CJK UNIFIED IDEOGRAPH
	{0x63D6,	0xB4A5},	// CJK UNIFIED IDEOGRAPH
	{0x63D7,	0xD970},	// CJK UNIFIED IDEOGRAPH
	{0x63D8,	0xD968},	// CJK UNIFIED IDEOGRAPH
	{0x63D9,	0xD971},	// CJK UNIFIED IDEOGRAPH
	{0x63DA,	0xB4AD},	// CJK UNIFIED IDEOGRAPH
	{0x63DB,	0xB4AB},	// CJK UNIFIED IDEOGRAPH
	{0x63DC,	0xD966},	// CJK UNIFIED IDEOGRAPH
	{0x63DD,	0xD965},	// CJK UNIFIED IDEOGRAPH
	{0x63DF,	0xD963},	// CJK UNIFIED IDEOGRAPH
	{0x63E0,	0xD95D},	// CJK UNIFIED IDEOGRAPH
	{0x63E1,	0xB4A4},	// CJK UNIFIED IDEOGRAPH
	{0x63E3,	0xB4A2},	// CJK UNIFIED IDEOGRAPH
	{0x63E4,	0xD1B9},	// CJK UNIFIED IDEOGRAPH
	{0x63E5,	0xD956},	// CJK UNIFIED IDEOGRAPH
	{0x63E7,	0xDDB7},	// CJK UNIFIED IDEOGRAPH
	{0x63E8,	0xD957},	// CJK UNIFIED IDEOGRAPH
	{0x63E9,	0xB47B},	// CJK UNIFIED IDEOGRAPH
	{0x63EA,	0xB4AA},	// CJK UNIFIED IDEOGRAPH
	{0x63EB,	0xDD79},	// CJK UNIFIED IDEOGRAPH
	{0x63ED,	0xB4A6},	// CJK UNIFIED IDEOGRAPH
	{0x63EE,	0xB4A7},	// CJK UNIFIED IDEOGRAPH
	{0x63EF,	0xD958},	// CJK UNIFIED IDEOGRAPH
	{0x63F0,	0xD96F},	// CJK UNIFIED IDEOGRAPH
	{0x63F1,	0xDD78},	// CJK UNIFIED IDEOGRAPH
	{0x63F2,	0xD960},	// CJK UNIFIED IDEOGRAPH
	{0x63F3,	0xD95B},	// CJK UNIFIED IDEOGRAPH
	{0x63F4,	0xB4A9},	// CJK UNIFIED IDEOGRAPH
	{0x63F5,	0xD961},	// CJK UNIFIED IDEOGRAPH
	{0x63F6,	0xD95E},	// CJK UNIFIED IDEOGRAPH
	{0x63F9,	0xB4AE},	// CJK UNIFIED IDEOGRAPH
	{0x6406,	0xB770},	// CJK UNIFIED IDEOGRAPH
	{0x6409,	0xDD7C},	// CJK UNIFIED IDEOGRAPH
	{0x640A,	0xDDB1},	// CJK UNIFIED IDEOGRAPH
	{0x640B,	0xDDB6},	// CJK UNIFIED IDEOGRAPH
	{0x640C,	0xDDAA},	// CJK UNIFIED IDEOGRAPH
	{0x640D,	0xB76C},	// CJK UNIFIED IDEOGRAPH
	{0x640E,	0xDDBB},	// CJK UNIFIED IDEOGRAPH
	{0x640F,	0xB769},	// CJK UNIFIED IDEOGRAPH
	{0x6410,	0xDD7A},	// CJK UNIFIED IDEOGRAPH
	{0x6412,	0xDD7B},	// CJK UNIFIED IDEOGRAPH
	{0x6413,	0xB762},	// CJK UNIFIED IDEOGRAPH
	{0x6414,	0xB76B},	// CJK UNIFIED IDEOGRAPH
	{0x6415,	0xDDA4},	// CJK UNIFIED IDEOGRAPH
	{0x6416,	0xB76E},	// CJK UNIFIED IDEOGRAPH
	{0x6417,	0xB76F},	// CJK UNIFIED IDEOGRAPH
	{0x6418,	0xDDA5},	// CJK UNIFIED IDEOGRAPH
	{0x641A,	0xDDB2},	// CJK UNIFIED IDEOGRAPH
	{0x641B,	0xDDB8},	// CJK UNIFIED IDEOGRAPH
	{0x641C,	0xB76A},	// CJK UNIFIED IDEOGRAPH
	{0x641E,	0xB764},	// CJK UNIFIED IDEOGRAPH
	{0x641F,	0xDDA3},	// CJK UNIFIED IDEOGRAPH
	{0x6420,	0xDD7D},	// CJK UNIFIED IDEOGRAPH
	{0x6421,	0xDDBA},	// CJK UNIFIED IDEOGRAPH
	{0x6422,	0xDDA8},	// CJK UNIFIED IDEOGRAPH
	{0x6423,	0xDDA9},	// CJK UNIFIED IDEOGRAPH
	{0x6424,	0xDD7E},	// CJK UNIFIED IDEOGRAPH
	{0x6425,	0xDDB4},	// CJK UNIFIED IDEOGRAPH
	{0x6426,	0xDDAB},	// CJK UNIFIED IDEOGRAPH
	{0x6427,	0xDDB5},	// CJK UNIFIED IDEOGRAPH
	{0x6428,	0xDDAD},	// CJK UNIFIED IDEOGRAPH
	{0x642A,	0xB765},	// CJK UNIFIED IDEOGRAPH
	{0x642B,	0xE1D9},	// CJK UNIFIED IDEOGRAPH
	{0x642C,	0xB768},	// CJK UNIFIED IDEOGRAPH
	{0x642D,	0xB766},	// CJK UNIFIED IDEOGRAPH
	{0x642E,	0xDDB9},	// CJK UNIFIED IDEOGRAPH
	{0x642F,	0xDDB0},	// CJK UNIFIED IDEOGRAPH
	{0x6430,	0xDDAC},	// CJK UNIFIED IDEOGRAPH
	{0x6433,	0xDDA1},	// CJK UNIFIED IDEOGRAPH
	{0x6434,	0xBA53},	// CJK UNIFIED IDEOGRAPH
	{0x6435,	0xDDAF},	// CJK UNIFIED IDEOGRAPH
	{0x6436,	0xB76D},	// CJK UNIFIED IDEOGRAPH
	{0x6437,	0xDDA7},	// CJK UNIFIED IDEOGRAPH
	{0x6439,	0xDDA6},	// CJK UNIFIED IDEOGRAPH
	{0x643D,	0xB767},	// CJK UNIFIED IDEOGRAPH
	{0x643E,	0xB763},	// CJK UNIFIED IDEOGRAPH
	{0x643F,	0xE1EE},	// CJK UNIFIED IDEOGRAPH
	{0x6440,	0xDDB3},	// CJK UNIFIED IDEOGRAPH
	{0x6441,	0xDDAE},	// CJK UNIFIED IDEOGRAPH
	{0x6443,	0xDDA2},	// CJK UNIFIED IDEOGRAPH
	{0x644B,	0xE1E9},	// CJK UNIFIED IDEOGRAPH
	{0x644D,	0xE1DA},	// CJK UNIFIED IDEOGRAPH
	{0x644E,	0xE1E5},	// CJK UNIFIED IDEOGRAPH
	{0x6450,	0xE1EC},	// CJK UNIFIED IDEOGRAPH
	{0x6451,	0xBA51},	// CJK UNIFIED IDEOGRAPH
	{0x6452,	0xB4AC},	// CJK UNIFIED IDEOGRAPH
	{0x6453,	0xE1EA},	// CJK UNIFIED IDEOGRAPH
	{0x6454,	0xBA4C},	// CJK UNIFIED IDEOGRAPH
	{0x6458,	0xBA4B},	// CJK UNIFIED IDEOGRAPH
	{0x6459,	0xE1F1},	// CJK UNIFIED IDEOGRAPH
	{0x645B,	0xE1DB},	// CJK UNIFIED IDEOGRAPH
	{0x645C,	0xE1E8},	// CJK UNIFIED IDEOGRAPH
	{0x645D,	0xE1DC},	// CJK UNIFIED IDEOGRAPH
	{0x645E,	0xE1E7},	// CJK UNIFIED IDEOGRAPH
	{0x645F,	0xBA4F},	// CJK UNIFIED IDEOGRAPH
	{0x6460,	0xE1EB},	// CJK UNIFIED IDEOGRAPH
	{0x6461,	0xD962},	// CJK UNIFIED IDEOGRAPH
	{0x6465,	0xE1F2},	// CJK UNIFIED IDEOGRAPH
	{0x6466,	0xE1E3},	// CJK UNIFIED IDEOGRAPH
	{0x6467,	0xBA52},	// CJK UNIFIED IDEOGRAPH
	{0x6468,	0xE5BA},	// CJK UNIFIED IDEOGRAPH
	{0x6469,	0xBCAF},	// CJK UNIFIED IDEOGRAPH
	{0x646B,	0xE1F0},	// CJK UNIFIED IDEOGRAPH
	{0x646C,	0xE1EF},	// CJK UNIFIED IDEOGRAPH
	{0x646D,	0xBA54},	// CJK UNIFIED IDEOGRAPH
	{0x646E,	0xE5AD},	// CJK UNIFIED IDEOGRAPH
	{0x646F,	0xBCB0},	// CJK UNIFIED IDEOGRAPH
	{0x6470,	0xE5AE},	// CJK UNIFIED IDEOGRAPH
	{0x6472,	0xE1DF},	// CJK UNIFIED IDEOGRAPH
	{0x6473,	0xE1E0},	// CJK UNIFIED IDEOGRAPH
	{0x6474,	0xE1DD},	// CJK UNIFIED IDEOGRAPH
	{0x6475,	0xE1E2},	// CJK UNIFIED IDEOGRAPH
	{0x6476,	0xE1DE},	// CJK UNIFIED IDEOGRAPH
	{0x6477,	0xE1F3},	// CJK UNIFIED IDEOGRAPH
	{0x6478,	0xBA4E},	// CJK UNIFIED IDEOGRAPH
	{0x6479,	0xBCB1},	// CJK UNIFIED IDEOGRAPH
	{0x647A,	0xBA50},	// CJK UNIFIED IDEOGRAPH
	{0x647B,	0xBA55},	// CJK UNIFIED IDEOGRAPH
	{0x647D,	0xE1E1},	// CJK UNIFIED IDEOGRAPH
	{0x647F,	0xE1ED},	// CJK UNIFIED IDEOGRAPH
	{0x6482,	0xE1E6},	// CJK UNIFIED IDEOGRAPH
	{0x6485,	0xE5B1},	// CJK UNIFIED IDEOGRAPH
	{0x6487,	0xBA4A},	// CJK UNIFIED IDEOGRAPH
	{0x6488,	0xBCB4},	// CJK UNIFIED IDEOGRAPH
	{0x6489,	0xE9AA},	// CJK UNIFIED IDEOGRAPH
	{0x648A,	0xE5B6},	// CJK UNIFIED IDEOGRAPH
	{0x648B,	0xE5B5},	// CJK UNIFIED IDEOGRAPH
	{0x648C,	0xE5B7},	// CJK UNIFIED IDEOGRAPH
	{0x648F,	0xE5B4},	// CJK UNIFIED IDEOGRAPH
	{0x6490,	0xBCB5},	// CJK UNIFIED IDEOGRAPH
	{0x6492,	0xBCBB},	// CJK UNIFIED IDEOGRAPH
	{0x6493,	0xBCB8},	// CJK UNIFIED IDEOGRAPH
	{0x6495,	0xBCB9},	// CJK UNIFIED IDEOGRAPH
	{0x6496,	0xE5AF},	// CJK UNIFIED IDEOGRAPH
	{0x6497,	0xE5B2},	// CJK UNIFIED IDEOGRAPH
	{0x6498,	0xE5BC},	// CJK UNIFIED IDEOGRAPH
	{0x6499,	0xBCC1},	// CJK UNIFIED IDEOGRAPH
	{0x649A,	0xBCBF},	// CJK UNIFIED IDEOGRAPH
	{0x649C,	0xE5B3},	// CJK UNIFIED IDEOGRAPH
	{0x649D,	0xD95A},	// CJK UNIFIED IDEOGRAPH
	{0x649E,	0xBCB2},	// CJK UNIFIED IDEOGRAPH
	{0x649F,	0xE5B9},	// CJK UNIFIED IDEOGRAPH
	{0x64A0,	0xE5B0},	// CJK UNIFIED IDEOGRAPH
	{0x64A2,	0xBCC2},	// CJK UNIFIED IDEOGRAPH
	{0x64A3,	0xE5B8},	// CJK UNIFIED IDEOGRAPH
	{0x64A4,	0xBA4D},	// CJK UNIFIED IDEOGRAPH
	{0x64A5,	0xBCB7},	// CJK UNIFIED IDEOGRAPH
	{0x64A6,	0xE1E4},	// CJK UNIFIED IDEOGRAPH
	{0x64A9,	0xBCBA},	// CJK UNIFIED IDEOGRAPH
	{0x64AB,	0xBCBE},	// CJK UNIFIED IDEOGRAPH
	{0x64AC,	0xBCC0},	// CJK UNIFIED IDEOGRAPH
	{0x64AD,	0xBCBD},	// CJK UNIFIED IDEOGRAPH
	{0x64AE,	0xBCBC},	// CJK UNIFIED IDEOGRAPH
	{0x64B0,	0xBCB6},	// CJK UNIFIED IDEOGRAPH
	{0x64B1,	0xE5BB},	// CJK UNIFIED IDEOGRAPH
	{0x64B2,	0xBCB3},	// CJK UNIFIED IDEOGRAPH
	{0x64B3,	0xBCC3},	// CJK UNIFIED IDEOGRAPH
	{0x64BB,	0xBED8},	// CJK UNIFIED IDEOGRAPH
	{0x64BC,	0xBED9},	// CJK UNIFIED IDEOGRAPH
	{0x64BD,	0xE9A9},	// CJK UNIFIED IDEOGRAPH
	{0x64BE,	0xBEE2},	// CJK UNIFIED IDEOGRAPH
	{0x64BF,	0xBEDF},	// CJK UNIFIED IDEOGRAPH
	{0x64C1,	0xBED6},	// CJK UNIFIED IDEOGRAPH
	{0x64C2,	0xBEDD},	// CJK UNIFIED IDEOGRAPH
	{0x64C3,	0xE9AB},	// CJK UNIFIED IDEOGRAPH
	{0x64C4,	0xBEDB},	// CJK UNIFIED IDEOGRAPH
	{0x64C5,	0xBED5},	// CJK UNIFIED IDEOGRAPH
	{0x64C7,	0xBEDC},	// CJK UNIFIED IDEOGRAPH
	{0x64C9,	0xE9A8},	// CJK UNIFIED IDEOGRAPH
	{0x64CA,	0xC0BB},	// CJK UNIFIED IDEOGRAPH
	{0x64CB,	0xBED7},	// CJK UNIFIED IDEOGRAPH
	{0x64CD,	0xBEDE},	// CJK UNIFIED IDEOGRAPH
	{0x64CE,	0xC0BA},	// CJK UNIFIED IDEOGRAPH
	{0x64CF,	0xE9A7},	// CJK UNIFIED IDEOGRAPH
	{0x64D0,	0xE9A6},	// CJK UNIFIED IDEOGRAPH
	{0x64D2,	0xBEE0},	// CJK UNIFIED IDEOGRAPH
	{0x64D4,	0xBEE1},	// CJK UNIFIED IDEOGRAPH
	{0x64D6,	0xE9A5},	// CJK UNIFIED IDEOGRAPH
	{0x64D7,	0xE9A4},	// CJK UNIFIED IDEOGRAPH
	{0x64D8,	0xC0BC},	// CJK UNIFIED IDEOGRAPH
	{0x64D9,	0xE9AE},	// CJK UNIFIED IDEOGRAPH
	{0x64DA,	0xBEDA},	// CJK UNIFIED IDEOGRAPH
	{0x64DB,	0xE9AC},	// CJK UNIFIED IDEOGRAPH
	{0x64E0,	0xC0BD},	// CJK UNIFIED IDEOGRAPH
	{0x64E2,	0xC0C2},	// CJK UNIFIED IDEOGRAPH
	{0x64E3,	0xECEA},	// CJK UNIFIED IDEOGRAPH
	{0x64E4,	0xECEC},	// CJK UNIFIED IDEOGRAPH
	{0x64E6,	0xC0BF},	// CJK UNIFIED IDEOGRAPH
	{0x64E8,	0xECED},	// CJK UNIFIED IDEOGRAPH
	{0x64E9,	0xECE9},	// CJK UNIFIED IDEOGRAPH
	{0x64EB,	0xECEB},	// CJK UNIFIED IDEOGRAPH
	{0x64EC,	0xC0C0},	// CJK UNIFIED IDEOGRAPH
	{0x64ED,	0xC0C3},	// CJK UNIFIED IDEOGRAPH
	{0x64EF,	0xECE8},	// CJK UNIFIED IDEOGRAPH
	{0x64F0,	0xC0BE},	// CJK UNIFIED IDEOGRAPH
	{0x64F1,	0xC0C1},	// CJK UNIFIED IDEOGRAPH
	{0x64F2,	0xC259},	// CJK UNIFIED IDEOGRAPH
	{0x64F3,	0xE9AD},	// CJK UNIFIED IDEOGRAPH
	{0x64F4,	0xC258},	// CJK UNIFIED IDEOGRAPH
	{0x64F7,	0xC25E},	// CJK UNIFIED IDEOGRAPH
	{0x64F8,	0xEFD4},	// CJK UNIFIED IDEOGRAPH
	{0x64FA,	0xC25C},	// CJK UNIFIED IDEOGRAPH
	{0x64FB,	0xC25D},	// CJK UNIFIED IDEOGRAPH
	{0x64FC,	0xEFD7},	// CJK UNIFIED IDEOGRAPH
	{0x64FD,	0xEFD3},	// CJK UNIFIED IDEOGRAPH
	{0x64FE,	0xC25A},	// CJK UNIFIED IDEOGRAPH
	{0x64FF,	0xEFD1},	// CJK UNIFIED IDEOGRAPH
	{0x6500,	0xC36B},	// CJK UNIFIED IDEOGRAPH
	{0x6501,	0xEFD5},	// CJK UNIFIED IDEOGRAPH
	{0x6503,	0xEFD6},	// CJK UNIFIED IDEOGRAPH
	{0x6504,	0xEFD2},	// CJK UNIFIED IDEOGRAPH
	{0x6506,	0xC25B},	// CJK UNIFIED IDEOGRAPH
	{0x6507,	0xF242},	// CJK UNIFIED IDEOGRAPH
	{0x6509,	0xF245},	// CJK UNIFIED IDEOGRAPH
	{0x650C,	0xF246},	// CJK UNIFIED IDEOGRAPH
	{0x650D,	0xF244},	// CJK UNIFIED IDEOGRAPH
	{0x650E,	0xF247},	// CJK UNIFIED IDEOGRAPH
	{0x650F,	0xC36C},	// CJK UNIFIED IDEOGRAPH
	{0x6510,	0xF243},	// CJK UNIFIED IDEOGRAPH
	{0x6513,	0xF44E},	// CJK UNIFIED IDEOGRAPH
	{0x6514,	0xC464},	// CJK UNIFIED IDEOGRAPH
	{0x6515,	0xF44D},	// CJK UNIFIED IDEOGRAPH
	{0x6516,	0xF44C},	// CJK UNIFIED IDEOGRAPH
	{0x6517,	0xF44B},	// CJK UNIFIED IDEOGRAPH
	{0x6518,	0xC463},	// CJK UNIFIED IDEOGRAPH
	{0x6519,	0xC465},	// CJK UNIFIED IDEOGRAPH
	{0x651B,	0xF5CD},	// CJK UNIFIED IDEOGRAPH
	{0x651C,	0xC4E2},	// CJK UNIFIED IDEOGRAPH
	{0x651D,	0xC4E1},	// CJK UNIFIED IDEOGRAPH
	{0x6520,	0xF6E1},	// CJK UNIFIED IDEOGRAPH
	{0x6521,	0xF6E0},	// CJK UNIFIED IDEOGRAPH
	{0x6522,	0xF6E3},	// CJK UNIFIED IDEOGRAPH
	{0x6523,	0xC5CB},	// CJK UNIFIED IDEOGRAPH
	{0x6524,	0xC575},	// CJK UNIFIED IDEOGRAPH
	{0x6525,	0xF7DD},	// CJK UNIFIED IDEOGRAPH
	{0x6526,	0xF6E2},	// CJK UNIFIED IDEOGRAPH
	{0x6529,	0xF7DC},	// CJK UNIFIED IDEOGRAPH
	{0x652A,	0xC5CD},	// CJK UNIFIED IDEOGRAPH
	{0x652B,	0xC5CC},	// CJK UNIFIED IDEOGRAPH
	{0x652C,	0xC5F3},	// CJK UNIFIED IDEOGRAPH
	{0x652D,	0xF8A9},	// CJK UNIFIED IDEOGRAPH
	{0x652E,	0xF8EF},	// CJK UNIFIED IDEOGRAPH
	{0x652F,	0xA4E4},	// CJK UNIFIED IDEOGRAPH
	{0x6532,	0xD972},	// CJK UNIFIED IDEOGRAPH
	{0x6533,	0xE9AF},	// CJK UNIFIED IDEOGRAPH
	{0x6536,	0xA6AC},	// CJK UNIFIED IDEOGRAPH
	{0x6537,	0xCAF7},	// CJK UNIFIED IDEOGRAPH
	{0x6538,	0xA7F1},	// CJK UNIFIED IDEOGRAPH
	{0x6539,	0xA7EF},	// CJK UNIFIED IDEOGRAPH
	{0x653B,	0xA7F0},	// CJK UNIFIED IDEOGRAPH
	{0x653D,	0xCCC1},	// CJK UNIFIED IDEOGRAPH
	{0x653E,	0xA9F1},	// CJK UNIFIED IDEOGRAPH
	{0x653F,	0xAC46},	// CJK UNIFIED IDEOGRAPH
	{0x6541,	0xCEE7},	// CJK UNIFIED IDEOGRAPH
	{0x6543,	0xCEE8},	// CJK UNIFIED IDEOGRAPH
	{0x6545,	0xAC47},	// CJK UNIFIED IDEOGRAPH
	{0x6546,	0xD1CE},	// CJK UNIFIED IDEOGRAPH
	{0x6548,	0xAEC4},	// CJK UNIFIED IDEOGRAPH
	{0x6549,	0xAEC5},	// CJK UNIFIED IDEOGRAPH
	{0x654A,	0xD1CD},	// CJK UNIFIED IDEOGRAPH
	{0x654F,	0xB1D3},	// CJK UNIFIED IDEOGRAPH
	{0x6551,	0xB1CF},	// CJK UNIFIED IDEOGRAPH
	{0x6553,	0xD5A7},	// CJK UNIFIED IDEOGRAPH
	{0x6554,	0xB1D6},	// CJK UNIFIED IDEOGRAPH
	{0x6555,	0xB1D5},	// CJK UNIFIED IDEOGRAPH
	{0x6556,	0xB1CE},	// CJK UNIFIED IDEOGRAPH
	{0x6557,	0xB1D1},	// CJK UNIFIED IDEOGRAPH
	{0x6558,	0xB1D4},	// CJK UNIFIED IDEOGRAPH
	{0x6559,	0xB1D0},	// CJK UNIFIED IDEOGRAPH
	{0x655C,	0xD976},	// CJK UNIFIED IDEOGRAPH
	{0x655D,	0xB1CD},	// CJK UNIFIED IDEOGRAPH
	{0x655E,	0xB4AF},	// CJK UNIFIED IDEOGRAPH
	{0x6562,	0xB4B1},	// CJK UNIFIED IDEOGRAPH
	{0x6563,	0xB4B2},	// CJK UNIFIED IDEOGRAPH
	{0x6564,	0xD975},	// CJK UNIFIED IDEOGRAPH
	{0x6565,	0xD978},	// CJK UNIFIED IDEOGRAPH
	{0x6566,	0xB4B0},	// CJK UNIFIED IDEOGRAPH
	{0x6567,	0xD973},	// CJK UNIFIED IDEOGRAPH
	{0x6568,	0xD977},	// CJK UNIFIED IDEOGRAPH
	{0x656A,	0xD974},	// CJK UNIFIED IDEOGRAPH
	{0x656C,	0xB771},	// CJK UNIFIED IDEOGRAPH
	{0x656F,	0xDDBC},	// CJK UNIFIED IDEOGRAPH
	{0x6572,	0xBA56},	// CJK UNIFIED IDEOGRAPH
	{0x6573,	0xE1F4},	// CJK UNIFIED IDEOGRAPH
	{0x6574,	0xBEE3},	// CJK UNIFIED IDEOGRAPH
	{0x6575,	0xBCC4},	// CJK UNIFIED IDEOGRAPH
	{0x6576,	0xE5BD},	// CJK UNIFIED IDEOGRAPH
	{0x6577,	0xBCC5},	// CJK UNIFIED IDEOGRAPH
	{0x6578,	0xBCC6},	// CJK UNIFIED IDEOGRAPH
	{0x6579,	0xE5BF},	// CJK UNIFIED IDEOGRAPH
	{0x657A,	0xE5BE},	// CJK UNIFIED IDEOGRAPH
	{0x657B,	0xE5C0},	// CJK UNIFIED IDEOGRAPH
	{0x657C,	0xE9B1},	// CJK UNIFIED IDEOGRAPH
	{0x657F,	0xE9B0},	// CJK UNIFIED IDEOGRAPH
	{0x6580,	0xECEF},	// CJK UNIFIED IDEOGRAPH
	{0x6581,	0xECEE},	// CJK UNIFIED IDEOGRAPH
	{0x6582,	0xC0C4},	// CJK UNIFIED IDEOGRAPH
	{0x6583,	0xC0C5},	// CJK UNIFIED IDEOGRAPH
	{0x6584,	0xF248},	// CJK UNIFIED IDEOGRAPH
	{0x6587,	0xA4E5},	// CJK UNIFIED IDEOGRAPH
	{0x658C,	0xD979},	// CJK UNIFIED IDEOGRAPH
	{0x6590,	0xB4B4},	// CJK UNIFIED IDEOGRAPH
	{0x6591,	0xB4B3},	// CJK UNIFIED IDEOGRAPH
	{0x6592,	0xDDBD},	// CJK UNIFIED IDEOGRAPH
	{0x6594,	0xEFD8},	// CJK UNIFIED IDEOGRAPH
	{0x6595,	0xC4E3},	// CJK UNIFIED IDEOGRAPH
	{0x6596,	0xF7DE},	// CJK UNIFIED IDEOGRAPH
	{0x6597,	0xA4E6},	// CJK UNIFIED IDEOGRAPH
	{0x6599,	0xAEC6},	// CJK UNIFIED IDEOGRAPH
	{0x659B,	0xB1D8},	// CJK UNIFIED IDEOGRAPH
	{0x659C,	0xB1D7},	// CJK UNIFIED IDEOGRAPH
	{0x659D,	0xD97A},	// CJK UNIFIED IDEOGRAPH
	{0x659E,	0xD97B},	// CJK UNIFIED IDEOGRAPH
	{0x659F,	0xB772},	// CJK UNIFIED IDEOGRAPH
	{0x65A0,	0xE1F5},	// CJK UNIFIED IDEOGRAPH
	{0x65A1,	0xBA57},	// CJK UNIFIED IDEOGRAPH
	{0x65A2,	0xE9B2},	// CJK UNIFIED IDEOGRAPH
	{0x65A4,	0xA4E7},	// CJK UNIFIED IDEOGRAPH
	{0x65A5,	0xA5B8},	// CJK UNIFIED IDEOGRAPH
	{0x65A7,	0xA9F2},	// CJK UNIFIED IDEOGRAPH
	{0x65A8,	0xCCC2},	// CJK UNIFIED IDEOGRAPH
	{0x65AA,	0xCEE9},	// CJK UNIFIED IDEOGRAPH
	{0x65AB,	0xAC48},	// CJK UNIFIED IDEOGRAPH
	{0x65AC,	0xB1D9},	// CJK UNIFIED IDEOGRAPH
	{0x65AE,	0xD97C},	// CJK UNIFIED IDEOGRAPH
	{0x65AF,	0xB4B5},	// CJK UNIFIED IDEOGRAPH
	{0x65B0,	0xB773},	// CJK UNIFIED IDEOGRAPH
	{0x65B2,	0xE5C1},	// CJK UNIFIED IDEOGRAPH
	{0x65B3,	0xE5C2},	// CJK UNIFIED IDEOGRAPH
	{0x65B6,	0xECF0},	// CJK UNIFIED IDEOGRAPH
	{0x65B7,	0xC25F},	// CJK UNIFIED IDEOGRAPH
	{0x65B8,	0xF8F0},	// CJK UNIFIED IDEOGRAPH
	{0x65B9,	0xA4E8},	// CJK UNIFIED IDEOGRAPH
	{0x65BB,	0xCCC3},	// CJK UNIFIED IDEOGRAPH
	{0x65BC,	0xA9F3},	// CJK UNIFIED IDEOGRAPH
	{0x65BD,	0xAC49},	// CJK UNIFIED IDEOGRAPH
	{0x65BF,	0xCEEA},	// CJK UNIFIED IDEOGRAPH
	{0x65C1,	0xAEC7},	// CJK UNIFIED IDEOGRAPH
	{0x65C2,	0xD1D2},	// CJK UNIFIED IDEOGRAPH
	{0x65C3,	0xD1D0},	// CJK UNIFIED IDEOGRAPH
	{0x65C4,	0xD1D1},	// CJK UNIFIED IDEOGRAPH
	{0x65C5,	0xAEC8},	// CJK UNIFIED IDEOGRAPH
	{0x65C6,	0xD1CF},	// CJK UNIFIED IDEOGRAPH
	{0x65CB,	0xB1DB},	// CJK UNIFIED IDEOGRAPH
	{0x65CC,	0xB1DC},	// CJK UNIFIED IDEOGRAPH
	{0x65CD,	0xD5A8},	// CJK UNIFIED IDEOGRAPH
	{0x65CE,	0xB1DD},	// CJK UNIFIED IDEOGRAPH
	{0x65CF,	0xB1DA},	// CJK UNIFIED IDEOGRAPH
	{0x65D0,	0xD97D},	// CJK UNIFIED IDEOGRAPH
	{0x65D2,	0xD97E},	// CJK UNIFIED IDEOGRAPH
	{0x65D3,	0xDDBE},	// CJK UNIFIED IDEOGRAPH
	{0x65D6,	0xBA59},	// CJK UNIFIED IDEOGRAPH
	{0x65D7,	0xBA58},	// CJK UNIFIED IDEOGRAPH
	{0x65DA,	0xECF1},	// CJK UNIFIED IDEOGRAPH
	{0x65DB,	0xEFD9},	// CJK UNIFIED IDEOGRAPH
	{0x65DD,	0xF24A},	// CJK UNIFIED IDEOGRAPH
	{0x65DE,	0xF249},	// CJK UNIFIED IDEOGRAPH
	{0x65DF,	0xF44F},	// CJK UNIFIED IDEOGRAPH
	{0x65E1,	0xC95E},	// CJK UNIFIED IDEOGRAPH
	{0x65E2,	0xAC4A},	// CJK UNIFIED IDEOGRAPH
	{0x65E5,	0xA4E9},	// CJK UNIFIED IDEOGRAPH
	{0x65E6,	0xA5B9},	// CJK UNIFIED IDEOGRAPH
	{0x65E8,	0xA6AE},	// CJK UNIFIED IDEOGRAPH
	{0x65E9,	0xA6AD},	// CJK UNIFIED IDEOGRAPH
	{0x65EC,	0xA6AF},	// CJK UNIFIED IDEOGRAPH
	{0x65ED,	0xA6B0},	// CJK UNIFIED IDEOGRAPH
	{0x65EE,	0xC9EE},	// CJK UNIFIED IDEOGRAPH
	{0x65EF,	0xC9ED},	// CJK UNIFIED IDEOGRAPH
	{0x65F0,	0xCAF8},	// CJK UNIFIED IDEOGRAPH
	{0x65F1,	0xA7F2},	// CJK UNIFIED IDEOGRAPH
	{0x65F2,	0xCAFB},	// CJK UNIFIED IDEOGRAPH
	{0x65F3,	0xCAFA},	// CJK UNIFIED IDEOGRAPH
	{0x65F4,	0xCAF9},	// CJK UNIFIED IDEOGRAPH
	{0x65F5,	0xCAFC},	// CJK UNIFIED IDEOGRAPH
	{0x65FA,	0xA9F4},	// CJK UNIFIED IDEOGRAPH
	{0x65FB,	0xCCC9},	// CJK UNIFIED IDEOGRAPH
	{0x65FC,	0xCCC5},	// CJK UNIFIED IDEOGRAPH
	{0x65FD,	0xCCCE},	// CJK UNIFIED IDEOGRAPH
	{0x6600,	0xA9FB},	// CJK UNIFIED IDEOGRAPH
	{0x6602,	0xA9F9},	// CJK UNIFIED IDEOGRAPH
	{0x6603,	0xCCCA},	// CJK UNIFIED IDEOGRAPH
	{0x6604,	0xCCC6},	// CJK UNIFIED IDEOGRAPH
	{0x6605,	0xCCCD},	// CJK UNIFIED IDEOGRAPH
	{0x6606,	0xA9F8},	// CJK UNIFIED IDEOGRAPH
	{0x6607,	0xAA40},	// CJK UNIFIED IDEOGRAPH
	{0x6608,	0xCCC8},	// CJK UNIFIED IDEOGRAPH
	{0x6609,	0xCCC4},	// CJK UNIFIED IDEOGRAPH
	{0x660A,	0xA9FE},	// CJK UNIFIED IDEOGRAPH
	{0x660B,	0xCCCB},	// CJK UNIFIED IDEOGRAPH
	{0x660C,	0xA9F7},	// CJK UNIFIED IDEOGRAPH
	{0x660D,	0xCCCC},	// CJK UNIFIED IDEOGRAPH
	{0x660E,	0xA9FA},	// CJK UNIFIED IDEOGRAPH
	{0x660F,	0xA9FC},	// CJK UNIFIED IDEOGRAPH
	{0x6610,	0xCCD0},	// CJK UNIFIED IDEOGRAPH
	{0x6611,	0xCCCF},	// CJK UNIFIED IDEOGRAPH
	{0x6612,	0xCCC7},	// CJK UNIFIED IDEOGRAPH
	{0x6613,	0xA9F6},	// CJK UNIFIED IDEOGRAPH
	{0x6614,	0xA9F5},	// CJK UNIFIED IDEOGRAPH
	{0x6615,	0xA9FD},	// CJK UNIFIED IDEOGRAPH
	{0x661C,	0xCEEF},	// CJK UNIFIED IDEOGRAPH
	{0x661D,	0xCEF5},	// CJK UNIFIED IDEOGRAPH
	{0x661F,	0xAC50},	// CJK UNIFIED IDEOGRAPH
	{0x6620,	0xAC4D},	// CJK UNIFIED IDEOGRAPH
	{0x6621,	0xCEEC},	// CJK UNIFIED IDEOGRAPH
	{0x6622,	0xCEF1},	// CJK UNIFIED IDEOGRAPH
	{0x6624,	0xAC53},	// CJK UNIFIED IDEOGRAPH
	{0x6625,	0xAC4B},	// CJK UNIFIED IDEOGRAPH
	{0x6626,	0xCEF0},	// CJK UNIFIED IDEOGRAPH
	{0x6627,	0xAC4E},	// CJK UNIFIED IDEOGRAPH
	{0x6628,	0xAC51},	// CJK UNIFIED IDEOGRAPH
	{0x662B,	0xCEF3},	// CJK UNIFIED IDEOGRAPH
	{0x662D,	0xAC4C},	// CJK UNIFIED IDEOGRAPH
	{0x662E,	0xCEF8},	// CJK UNIFIED IDEOGRAPH
	{0x662F,	0xAC4F},	// CJK UNIFIED IDEOGRAPH
	{0x6631,	0xAC52},	// CJK UNIFIED IDEOGRAPH
	{0x6632,	0xCEED},	// CJK UNIFIED IDEOGRAPH
	{0x6633,	0xCEF2},	// CJK UNIFIED IDEOGRAPH
	{0x6634,	0xCEF6},	// CJK UNIFIED IDEOGRAPH
	{0x6635,	0xCEEE},	// CJK UNIFIED IDEOGRAPH
	{0x6636,	0xCEEB},	// CJK UNIFIED IDEOGRAPH
	{0x6639,	0xCEF7},	// CJK UNIFIED IDEOGRAPH
	{0x663A,	0xCEF4},	// CJK UNIFIED IDEOGRAPH
	{0x6641,	0xAED0},	// CJK UNIFIED IDEOGRAPH
	{0x6642,	0xAEC9},	// CJK UNIFIED IDEOGRAPH
	{0x6643,	0xAECC},	// CJK UNIFIED IDEOGRAPH
	{0x6645,	0xAECF},	// CJK UNIFIED IDEOGRAPH
	{0x6647,	0xD1D5},	// CJK UNIFIED IDEOGRAPH
	{0x6649,	0xAECA},	// CJK UNIFIED IDEOGRAPH
	{0x664A,	0xD1D3},	// CJK UNIFIED IDEOGRAPH
	{0x664C,	0xAECE},	// CJK UNIFIED IDEOGRAPH
	{0x664F,	0xAECB},	// CJK UNIFIED IDEOGRAPH
	{0x6651,	0xD1D6},	// CJK UNIFIED IDEOGRAPH
	{0x6652,	0xAECD},	// CJK UNIFIED IDEOGRAPH
	{0x6659,	0xD5AC},	// CJK UNIFIED IDEOGRAPH
	{0x665A,	0xB1DF},	// CJK UNIFIED IDEOGRAPH
	{0x665B,	0xD5AB},	// CJK UNIFIED IDEOGRAPH
	{0x665C,	0xD5AD},	// CJK UNIFIED IDEOGRAPH
	{0x665D,	0xB1DE},	// CJK UNIFIED IDEOGRAPH
	{0x665E,	0xB1E3},	// CJK UNIFIED IDEOGRAPH
	{0x665F,	0xD1D4},	// CJK UNIFIED IDEOGRAPH
	{0x6661,	0xD5AA},	// CJK UNIFIED IDEOGRAPH
	{0x6662,	0xD5AE},	// CJK UNIFIED IDEOGRAPH
	{0x6664,	0xB1E0},	// CJK UNIFIED IDEOGRAPH
	{0x6665,	0xD5A9},	// CJK UNIFIED IDEOGRAPH
	{0x6666,	0xB1E2},	// CJK UNIFIED IDEOGRAPH
	{0x6668,	0xB1E1},	// CJK UNIFIED IDEOGRAPH
	{0x666A,	0xD9A7},	// CJK UNIFIED IDEOGRAPH
	{0x666C,	0xD9A2},	// CJK UNIFIED IDEOGRAPH
	{0x666E,	0xB4B6},	// CJK UNIFIED IDEOGRAPH
	{0x666F,	0xB4BA},	// CJK UNIFIED IDEOGRAPH
	{0x6670,	0xB4B7},	// CJK UNIFIED IDEOGRAPH
	{0x6671,	0xD9A5},	// CJK UNIFIED IDEOGRAPH
	{0x6672,	0xD9A8},	// CJK UNIFIED IDEOGRAPH
	{0x6674,	0xB4B8},	// CJK UNIFIED IDEOGRAPH
	{0x6676,	0xB4B9},	// CJK UNIFIED IDEOGRAPH
	{0x6677,	0xB4BE},	// CJK UNIFIED IDEOGRAPH
	{0x6678,	0xDDC7},	// CJK UNIFIED IDEOGRAPH
	{0x6679,	0xD9A6},	// CJK UNIFIED IDEOGRAPH
	{0x667A,	0xB4BC},	// CJK UNIFIED IDEOGRAPH
	{0x667B,	0xD9A3},	// CJK UNIFIED IDEOGRAPH
	{0x667C,	0xD9A1},	// CJK UNIFIED IDEOGRAPH
	{0x667E,	0xB4BD},	// CJK UNIFIED IDEOGRAPH
	{0x6680,	0xD9A4},	// CJK UNIFIED IDEOGRAPH
	{0x6684,	0xB779},	// CJK UNIFIED IDEOGRAPH
	{0x6686,	0xDDBF},	// CJK UNIFIED IDEOGRAPH
	{0x6687,	0xB776},	// CJK UNIFIED IDEOGRAPH
	{0x6688,	0xB777},	// CJK UNIFIED IDEOGRAPH
	{0x6689,	0xB775},	// CJK UNIFIED IDEOGRAPH
	{0x668A,	0xDDC4},	// CJK UNIFIED IDEOGRAPH
	{0x668B,	0xDDC3},	// CJK UNIFIED IDEOGRAPH
	{0x668C,	0xDDC0},	// CJK UNIFIED IDEOGRAPH
	{0x668D,	0xB77B},	// CJK UNIFIED IDEOGRAPH
	{0x6690,	0xDDC2},	// CJK UNIFIED IDEOGRAPH
	{0x6691,	0xB4BB},	// CJK UNIFIED IDEOGRAPH
	{0x6694,	0xDDC6},	// CJK UNIFIED IDEOGRAPH
	{0x6695,	0xDDC1},	// CJK UNIFIED IDEOGRAPH
	{0x6696,	0xB778},	// CJK UNIFIED IDEOGRAPH
	{0x6697,	0xB774},	// CJK UNIFIED IDEOGRAPH
	{0x6698,	0xB77A},	// CJK UNIFIED IDEOGRAPH
	{0x6699,	0xDDC5},	// CJK UNIFIED IDEOGRAPH
	{0x669D,	0xBA5C},	// CJK UNIFIED IDEOGRAPH
	{0x669F,	0xE1F8},	// CJK UNIFIED IDEOGRAPH
	{0x66A0,	0xE1F7},	// CJK UNIFIED IDEOGRAPH
	{0x66A1,	0xE1F6},	// CJK UNIFIED IDEOGRAPH
	{0x66A2,	0xBA5A},	// CJK UNIFIED IDEOGRAPH
	{0x66A8,	0xBA5B},	// CJK UNIFIED IDEOGRAPH
	{0x66A9,	0xE5C5},	// CJK UNIFIED IDEOGRAPH
	{0x66AA,	0xE5C8},	// CJK UNIFIED IDEOGRAPH
	{0x66AB,	0xBCC8},	// CJK UNIFIED IDEOGRAPH
	{0x66AE,	0xBCC7},	// CJK UNIFIED IDEOGRAPH
	{0x66AF,	0xE5C9},	// CJK UNIFIED IDEOGRAPH
	{0x66B0,	0xE5C4},	// CJK UNIFIED IDEOGRAPH
	{0x66B1,	0xBCCA},	// CJK UNIFIED IDEOGRAPH
	{0x66B2,	0xE5C6},	// CJK UNIFIED IDEOGRAPH
	{0x66B4,	0xBCC9},	// CJK UNIFIED IDEOGRAPH
	{0x66B5,	0xE5C3},	// CJK UNIFIED IDEOGRAPH
	{0x66B7,	0xE5C7},	// CJK UNIFIED IDEOGRAPH
	{0x66B8,	0xBEE9},	// CJK UNIFIED IDEOGRAPH
	{0x66B9,	0xBEE6},	// CJK UNIFIED IDEOGRAPH
	{0x66BA,	0xE9BB},	// CJK UNIFIED IDEOGRAPH
	{0x66BB,	0xE9BA},	// CJK UNIFIED IDEOGRAPH
	{0x66BD,	0xE9B9},	// CJK UNIFIED IDEOGRAPH
	{0x66BE,	0xE9B4},	// CJK UNIFIED IDEOGRAPH
	{0x66C0,	0xE9B5},	// CJK UNIFIED IDEOGRAPH
	{0x66C4,	0xBEE7},	// CJK UNIFIED IDEOGRAPH
	{0x66C6,	0xBEE4},	// CJK UNIFIED IDEOGRAPH
	{0x66C7,	0xBEE8},	// CJK UNIFIED IDEOGRAPH
	{0x66C8,	0xE9B3},	// CJK UNIFIED IDEOGRAPH
	{0x66C9,	0xBEE5},	// CJK UNIFIED IDEOGRAPH
	{0x66CA,	0xE9B6},	// CJK UNIFIED IDEOGRAPH
	{0x66CB,	0xE9B7},	// CJK UNIFIED IDEOGRAPH
	{0x66CC,	0xE9BC},	// CJK UNIFIED IDEOGRAPH
	{0x66CF,	0xE9B8},	// CJK UNIFIED IDEOGRAPH
	{0x66D2,	0xECF2},	// CJK UNIFIED IDEOGRAPH
	{0x66D6,	0xC0C7},	// CJK UNIFIED IDEOGRAPH
	{0x66D8,	0xEFDC},	// CJK UNIFIED IDEOGRAPH
	{0x66D9,	0xC0C6},	// CJK UNIFIED IDEOGRAPH
	{0x66DA,	0xEFDA},	// CJK UNIFIED IDEOGRAPH
	{0x66DB,	0xEFDB},	// CJK UNIFIED IDEOGRAPH
	{0x66DC,	0xC260},	// CJK UNIFIED IDEOGRAPH
	{0x66DD,	0xC36E},	// CJK UNIFIED IDEOGRAPH
	{0x66DE,	0xF24B},	// CJK UNIFIED IDEOGRAPH
	{0x66E0,	0xC36D},	// CJK UNIFIED IDEOGRAPH
	{0x66E3,	0xF451},	// CJK UNIFIED IDEOGRAPH
	{0x66E4,	0xF452},	// CJK UNIFIED IDEOGRAPH
	{0x66E6,	0xC466},	// CJK UNIFIED IDEOGRAPH
	{0x66E8,	0xF450},	// CJK UNIFIED IDEOGRAPH
	{0x66E9,	0xC4E4},	// CJK UNIFIED IDEOGRAPH
	{0x66EB,	0xF7DF},	// CJK UNIFIED IDEOGRAPH
	{0x66EC,	0xC5CE},	// CJK UNIFIED IDEOGRAPH
	{0x66ED,	0xF8AA},	// CJK UNIFIED IDEOGRAPH
	{0x66EE,	0xF8AB},	// CJK UNIFIED IDEOGRAPH
	{0x66F0,	0xA4EA},	// CJK UNIFIED IDEOGRAPH
	{0x66F2,	0xA6B1},	// CJK UNIFIED IDEOGRAPH
	{0x66F3,	0xA6B2},	// CJK UNIFIED IDEOGRAPH
	{0x66F4,	0xA7F3},	// CJK UNIFIED IDEOGRAPH
	{0x66F6,	0xCCD1},	// CJK UNIFIED IDEOGRAPH
	{0x66F7,	0xAC54},	// CJK UNIFIED IDEOGRAPH
	{0x66F8,	0xAED1},	// CJK UNIFIED IDEOGRAPH
	{0x66F9,	0xB1E4},	// CJK UNIFIED IDEOGRAPH
	{0x66FC,	0xB0D2},	// CJK UNIFIED IDEOGRAPH
	{0x66FE,	0xB4BF},	// CJK UNIFIED IDEOGRAPH
	{0x66FF,	0xB4C0},	// CJK UNIFIED IDEOGRAPH
	{0x6700,	0xB3CC},	// CJK UNIFIED IDEOGRAPH
	{0x6701,	0xD9A9},	// CJK UNIFIED IDEOGRAPH
	{0x6703,	0xB77C},	// CJK UNIFIED IDEOGRAPH
	{0x6704,	0xE1FA},	// CJK UNIFIED IDEOGRAPH
	{0x6705,	0xE1F9},	// CJK UNIFIED IDEOGRAPH
	{0x6708,	0xA4EB},	// CJK UNIFIED IDEOGRAPH
	{0x6709,	0xA6B3},	// CJK UNIFIED IDEOGRAPH
	{0x670A,	0xCCD2},	// CJK UNIFIED IDEOGRAPH
	{0x670B,	0xAA42},	// CJK UNIFIED IDEOGRAPH
	{0x670D,	0xAA41},	// CJK UNIFIED IDEOGRAPH
	{0x670F,	0xCEF9},	// CJK UNIFIED IDEOGRAPH
	{0x6710,	0xCEFA},	// CJK UNIFIED IDEOGRAPH
	{0x6712,	0xD1D7},	// CJK UNIFIED IDEOGRAPH
	{0x6713,	0xD1D8},	// CJK UNIFIED IDEOGRAPH
	{0x6714,	0xAED2},	// CJK UNIFIED IDEOGRAPH
	{0x6715,	0xAED3},	// CJK UNIFIED IDEOGRAPH
	{0x6717,	0xAED4},	// CJK UNIFIED IDEOGRAPH
	{0x6718,	0xD5AF},	// CJK UNIFIED IDEOGRAPH
	{0x671B,	0xB1E6},	// CJK UNIFIED IDEOGRAPH
	{0x671D,	0xB4C2},	// CJK UNIFIED IDEOGRAPH
	{0x671F,	0xB4C1},	// CJK UNIFIED IDEOGRAPH
	{0x6720,	0xDDC8},	// CJK UNIFIED IDEOGRAPH
	{0x6721,	0xDF7A},	// CJK UNIFIED IDEOGRAPH
	{0x6722,	0xE1FB},	// CJK UNIFIED IDEOGRAPH
	{0x6723,	0xE9BD},	// CJK UNIFIED IDEOGRAPH
	{0x6726,	0xC261},	// CJK UNIFIED IDEOGRAPH
	{0x6727,	0xC467},	// CJK UNIFIED IDEOGRAPH
	{0x6728,	0xA4EC},	// CJK UNIFIED IDEOGRAPH
	{0x672A,	0xA5BC},	// CJK UNIFIED IDEOGRAPH
	{0x672B,	0xA5BD},	// CJK UNIFIED IDEOGRAPH
	{0x672C,	0xA5BB},	// CJK UNIFIED IDEOGRAPH
	{0x672D,	0xA5BE},	// CJK UNIFIED IDEOGRAPH
	{0x672E,	0xA5BA},	// CJK UNIFIED IDEOGRAPH
	{0x6731,	0xA6B6},	// CJK UNIFIED IDEOGRAPH
	{0x6733,	0xC9F6},	// CJK UNIFIED IDEOGRAPH
	{0x6734,	0xA6B5},	// CJK UNIFIED IDEOGRAPH
	{0x6735,	0xA6B7},	// CJK UNIFIED IDEOGRAPH
	{0x6738,	0xC9F1},	// CJK UNIFIED IDEOGRAPH
	{0x6739,	0xC9F0},	// CJK UNIFIED IDEOGRAPH
	{0x673A,	0xC9F3},	// CJK UNIFIED IDEOGRAPH
	{0x673B,	0xC9F2},	// CJK UNIFIED IDEOGRAPH
	{0x673C,	0xC9F5},	// CJK UNIFIED IDEOGRAPH
	{0x673D,	0xA6B4},	// CJK UNIFIED IDEOGRAPH
	{0x673E,	0xC9EF},	// CJK UNIFIED IDEOGRAPH
	{0x673F,	0xC9F4},	// CJK UNIFIED IDEOGRAPH
	{0x6745,	0xCAFD},	// CJK UNIFIED IDEOGRAPH
	{0x6746,	0xA7FD},	// CJK UNIFIED IDEOGRAPH
	{0x6747,	0xCAFE},	// CJK UNIFIED IDEOGRAPH
	{0x6748,	0xCB43},	// CJK UNIFIED IDEOGRAPH
	{0x6749,	0xA7FC},	// CJK UNIFIED IDEOGRAPH
	{0x674B,	0xCB47},	// CJK UNIFIED IDEOGRAPH
	{0x674C,	0xCB42},	// CJK UNIFIED IDEOGRAPH
	{0x674D,	0xCB45},	// CJK UNIFIED IDEOGRAPH
	{0x674E,	0xA7F5},	// CJK UNIFIED IDEOGRAPH
	{0x674F,	0xA7F6},	// CJK UNIFIED IDEOGRAPH
	{0x6750,	0xA7F7},	// CJK UNIFIED IDEOGRAPH
	{0x6751,	0xA7F8},	// CJK UNIFIED IDEOGRAPH
	{0x6753,	0xA840},	// CJK UNIFIED IDEOGRAPH
	{0x6755,	0xCB41},	// CJK UNIFIED IDEOGRAPH
	{0x6756,	0xA7FA},	// CJK UNIFIED IDEOGRAPH
	{0x6757,	0xA841},	// CJK UNIFIED IDEOGRAPH
	{0x6759,	0xCB40},	// CJK UNIFIED IDEOGRAPH
	{0x675A,	0xCB46},	// CJK UNIFIED IDEOGRAPH
	{0x675C,	0xA7F9},	// CJK UNIFIED IDEOGRAPH
	{0x675D,	0xCB44},	// CJK UNIFIED IDEOGRAPH
	{0x675E,	0xA7FB},	// CJK UNIFIED IDEOGRAPH
	{0x675F,	0xA7F4},	// CJK UNIFIED IDEOGRAPH
	{0x6760,	0xA7FE},	// CJK UNIFIED IDEOGRAPH
	{0x676A,	0xAA57},	// CJK UNIFIED IDEOGRAPH
	{0x676C,	0xCCD4},	// CJK UNIFIED IDEOGRAPH
	{0x676D,	0xAA43},	// CJK UNIFIED IDEOGRAPH
	{0x676F,	0xAA4D},	// CJK UNIFIED IDEOGRAPH
	{0x6770,	0xAA4E},	// CJK UNIFIED IDEOGRAPH
	{0x6771,	0xAA46},	// CJK UNIFIED IDEOGRAPH
	{0x6772,	0xAA58},	// CJK UNIFIED IDEOGRAPH
	{0x6773,	0xAA48},	// CJK UNIFIED IDEOGRAPH
	{0x6774,	0xCCDC},	// CJK UNIFIED IDEOGRAPH
	{0x6775,	0xAA53},	// CJK UNIFIED IDEOGRAPH
	{0x6776,	0xCCD7},	// CJK UNIFIED IDEOGRAPH
	{0x6777,	0xAA49},	// CJK UNIFIED IDEOGRAPH
	{0x6778,	0xCCE6},	// CJK UNIFIED IDEOGRAPH
	{0x6779,	0xCCE7},	// CJK UNIFIED IDEOGRAPH
	{0x677A,	0xCCDF},	// CJK UNIFIED IDEOGRAPH
	{0x677B,	0xCCD8},	// CJK UNIFIED IDEOGRAPH
	{0x677C,	0xAA56},	// CJK UNIFIED IDEOGRAPH
	{0x677D,	0xCCE4},	// CJK UNIFIED IDEOGRAPH
	{0x677E,	0xAA51},	// CJK UNIFIED IDEOGRAPH
	{0x677F,	0xAA4F},	// CJK UNIFIED IDEOGRAPH
	{0x6781,	0xCCE5},	// CJK UNIFIED IDEOGRAPH
	{0x6783,	0xCCE3},	// CJK UNIFIED IDEOGRAPH
	{0x6784,	0xCCDB},	// CJK UNIFIED IDEOGRAPH
	{0x6785,	0xCCD3},	// CJK UNIFIED IDEOGRAPH
	{0x6786,	0xCCDA},	// CJK UNIFIED IDEOGRAPH
	{0x6787,	0xAA4A},	// CJK UNIFIED IDEOGRAPH
	{0x6789,	0xAA50},	// CJK UNIFIED IDEOGRAPH
	{0x678B,	0xAA44},	// CJK UNIFIED IDEOGRAPH
	{0x678C,	0xCCDE},	// CJK UNIFIED IDEOGRAPH
	{0x678D,	0xCCDD},	// CJK UNIFIED IDEOGRAPH
	{0x678E,	0xCCD5},	// CJK UNIFIED IDEOGRAPH
	{0x6790,	0xAA52},	// CJK UNIFIED IDEOGRAPH
	{0x6791,	0xCCE1},	// CJK UNIFIED IDEOGRAPH
	{0x6792,	0xCCD6},	// CJK UNIFIED IDEOGRAPH
	{0x6793,	0xAA55},	// CJK UNIFIED IDEOGRAPH
	{0x6794,	0xCCE8},	// CJK UNIFIED IDEOGRAPH
	{0x6795,	0xAA45},	// CJK UNIFIED IDEOGRAPH
	{0x6797,	0xAA4C},	// CJK UNIFIED IDEOGRAPH
	{0x6798,	0xCCD9},	// CJK UNIFIED IDEOGRAPH
	{0x6799,	0xCCE2},	// CJK UNIFIED IDEOGRAPH
	{0x679A,	0xAA54},	// CJK UNIFIED IDEOGRAPH
	{0x679C,	0xAA47},	// CJK UNIFIED IDEOGRAPH
	{0x679D,	0xAA4B},	// CJK UNIFIED IDEOGRAPH
	{0x679F,	0xCCE0},	// CJK UNIFIED IDEOGRAPH
	{0x67AE,	0xCF5B},	// CJK UNIFIED IDEOGRAPH
	{0x67AF,	0xAC5C},	// CJK UNIFIED IDEOGRAPH
	{0x67B0,	0xAC69},	// CJK UNIFIED IDEOGRAPH
	{0x67B2,	0xCF56},	// CJK UNIFIED IDEOGRAPH
	{0x67B3,	0xCF4C},	// CJK UNIFIED IDEOGRAPH
	{0x67B4,	0xAC62},	// CJK UNIFIED IDEOGRAPH
	{0x67B5,	0xCF4A},	// CJK UNIFIED IDEOGRAPH
	{0x67B6,	0xAC5B},	// CJK UNIFIED IDEOGRAPH
	{0x67B7,	0xCF45},	// CJK UNIFIED IDEOGRAPH
	{0x67B8,	0xAC65},	// CJK UNIFIED IDEOGRAPH
	{0x67B9,	0xCF52},	// CJK UNIFIED IDEOGRAPH
	{0x67BA,	0xCEFE},	// CJK UNIFIED IDEOGRAPH
	{0x67BB,	0xCF41},	// CJK UNIFIED IDEOGRAPH
	{0x67C0,	0xCF44},	// CJK UNIFIED IDEOGRAPH
	{0x67C1,	0xCEFB},	// CJK UNIFIED IDEOGRAPH
	{0x67C2,	0xCF51},	// CJK UNIFIED IDEOGRAPH
	{0x67C3,	0xCF61},	// CJK UNIFIED IDEOGRAPH
	{0x67C4,	0xAC60},	// CJK UNIFIED IDEOGRAPH
	{0x67C5,	0xCF46},	// CJK UNIFIED IDEOGRAPH
	{0x67C6,	0xCF58},	// CJK UNIFIED IDEOGRAPH
	{0x67C8,	0xCEFD},	// CJK UNIFIED IDEOGRAPH
	{0x67C9,	0xCF5F},	// CJK UNIFIED IDEOGRAPH
	{0x67CA,	0xCF60},	// CJK UNIFIED IDEOGRAPH
	{0x67CB,	0xCF63},	// CJK UNIFIED IDEOGRAPH
	{0x67CC,	0xCF5A},	// CJK UNIFIED IDEOGRAPH
	{0x67CD,	0xCF4B},	// CJK UNIFIED IDEOGRAPH
	{0x67CE,	0xCF53},	// CJK UNIFIED IDEOGRAPH
	{0x67CF,	0xAC66},	// CJK UNIFIED IDEOGRAPH
	{0x67D0,	0xAC59},	// CJK UNIFIED IDEOGRAPH
	{0x67D1,	0xAC61},	// CJK UNIFIED IDEOGRAPH
	{0x67D2,	0xAC6D},	// CJK UNIFIED IDEOGRAPH
	{0x67D3,	0xAC56},	// CJK UNIFIED IDEOGRAPH
	{0x67D4,	0xAC58},	// CJK UNIFIED IDEOGRAPH
	{0x67D8,	0xCF43},	// CJK UNIFIED IDEOGRAPH
	{0x67D9,	0xAC6A},	// CJK UNIFIED IDEOGRAPH
	{0x67DA,	0xAC63},	// CJK UNIFIED IDEOGRAPH
	{0x67DB,	0xCF5D},	// CJK UNIFIED IDEOGRAPH
	{0x67DC,	0xCF40},	// CJK UNIFIED IDEOGRAPH
	{0x67DD,	0xAC6C},	// CJK UNIFIED IDEOGRAPH
	{0x67DE,	0xAC67},	// CJK UNIFIED IDEOGRAPH
	{0x67DF,	0xCF49},	// CJK UNIFIED IDEOGRAPH
	{0x67E2,	0xAC6B},	// CJK UNIFIED IDEOGRAPH
	{0x67E3,	0xCF50},	// CJK UNIFIED IDEOGRAPH
	{0x67E4,	0xCF48},	// CJK UNIFIED IDEOGRAPH
	{0x67E5,	0xAC64},	// CJK UNIFIED IDEOGRAPH
	{0x67E6,	0xCF5C},	// CJK UNIFIED IDEOGRAPH
	{0x67E7,	0xCF54},	// CJK UNIFIED IDEOGRAPH
	{0x67E9,	0xAC5E},	// CJK UNIFIED IDEOGRAPH
	{0x67EA,	0xCF62},	// CJK UNIFIED IDEOGRAPH
	{0x67EB,	0xCF47},	// CJK UNIFIED IDEOGRAPH
	{0x67EC,	0xAC5A},	// CJK UNIFIED IDEOGRAPH
	{0x67ED,	0xCF59},	// CJK UNIFIED IDEOGRAPH
	{0x67EE,	0xCF4F},	// CJK UNIFIED IDEOGRAPH
	{0x67EF,	0xAC5F},	// CJK UNIFIED IDEOGRAPH
	{0x67F0,	0xCF55},	// CJK UNIFIED IDEOGRAPH
	{0x67F1,	0xAC57},	// CJK UNIFIED IDEOGRAPH
	{0x67F2,	0xCEFC},	// CJK UNIFIED IDEOGRAPH
	{0x67F3,	0xAC68},	// CJK UNIFIED IDEOGRAPH
	{0x67F4,	0xAEE3},	// CJK UNIFIED IDEOGRAPH
	{0x67F5,	0xAC5D},	// CJK UNIFIED IDEOGRAPH
	{0x67F6,	0xCF4E},	// CJK UNIFIED IDEOGRAPH
	{0x67F7,	0xCF4D},	// CJK UNIFIED IDEOGRAPH
	{0x67F8,	0xCF42},	// CJK UNIFIED IDEOGRAPH
	{0x67FA,	0xCF5E},	// CJK UNIFIED IDEOGRAPH
	{0x67FC,	0xCF57},	// CJK UNIFIED IDEOGRAPH
	{0x67FF,	0xAC55},	// CJK UNIFIED IDEOGRAPH
	{0x6812,	0xD1EC},	// CJK UNIFIED IDEOGRAPH
	{0x6813,	0xAEEA},	// CJK UNIFIED IDEOGRAPH
	{0x6814,	0xD1ED},	// CJK UNIFIED IDEOGRAPH
	{0x6816,	0xD1E1},	// CJK UNIFIED IDEOGRAPH
	{0x6817,	0xAEDF},	// CJK UNIFIED IDEOGRAPH
	{0x6818,	0xAEEB},	// CJK UNIFIED IDEOGRAPH
	{0x681A,	0xD1DA},	// CJK UNIFIED IDEOGRAPH
	{0x681C,	0xD1E3},	// CJK UNIFIED IDEOGRAPH
	{0x681D,	0xD1EB},	// CJK UNIFIED IDEOGRAPH
	{0x681F,	0xD1D9},	// CJK UNIFIED IDEOGRAPH
	{0x6820,	0xD1F4},	// CJK UNIFIED IDEOGRAPH
	{0x6821,	0xAED5},	// CJK UNIFIED IDEOGRAPH
	{0x6825,	0xD1F3},	// CJK UNIFIED IDEOGRAPH
	{0x6826,	0xD1EE},	// CJK UNIFIED IDEOGRAPH
	{0x6828,	0xD1EF},	// CJK UNIFIED IDEOGRAPH
	{0x6829,	0xAEDD},	// CJK UNIFIED IDEOGRAPH
	{0x682A,	0xAEE8},	// CJK UNIFIED IDEOGRAPH
	{0x682B,	0xD1E5},	// CJK UNIFIED IDEOGRAPH
	{0x682D,	0xD1E6},	// CJK UNIFIED IDEOGRAPH
	{0x682E,	0xD1F0},	// CJK UNIFIED IDEOGRAPH
	{0x682F,	0xD1E7},	// CJK UNIFIED IDEOGRAPH
	{0x6831,	0xD1E2},	// CJK UNIFIED IDEOGRAPH
	{0x6832,	0xD1DC},	// CJK UNIFIED IDEOGRAPH
	{0x6833,	0xD1DD},	// CJK UNIFIED IDEOGRAPH
	{0x6834,	0xD1EA},	// CJK UNIFIED IDEOGRAPH
	{0x6835,	0xD1E4},	// CJK UNIFIED IDEOGRAPH
	{0x6838,	0xAED6},	// CJK UNIFIED IDEOGRAPH
	{0x6839,	0xAEDA},	// CJK UNIFIED IDEOGRAPH
	{0x683A,	0xD1F2},	// CJK UNIFIED IDEOGRAPH
	{0x683B,	0xD1DE},	// CJK UNIFIED IDEOGRAPH
	{0x683C,	0xAEE6},	// CJK UNIFIED IDEOGRAPH
	{0x683D,	0xAEE2},	// CJK UNIFIED IDEOGRAPH
	{0x6840,	0xAEE5},	// CJK UNIFIED IDEOGRAPH
	{0x6841,	0xAEEC},	// CJK UNIFIED IDEOGRAPH
	{0x6842,	0xAEDB},	// CJK UNIFIED IDEOGRAPH
	{0x6843,	0xAEE7},	// CJK UNIFIED IDEOGRAPH
	{0x6844,	0xD1E9},	// CJK UNIFIED IDEOGRAPH
	{0x6845,	0xAEE9},	// CJK UNIFIED IDEOGRAPH
	{0x6846,	0xAED8},	// CJK UNIFIED IDEOGRAPH
	{0x6848,	0xAED7},	// CJK UNIFIED IDEOGRAPH
	{0x6849,	0xD1DB},	// CJK UNIFIED IDEOGRAPH
	{0x684B,	0xD1DF},	// CJK UNIFIED IDEOGRAPH
	{0x684C,	0xAEE0},	// CJK UNIFIED IDEOGRAPH
	{0x684D,	0xD1F1},	// CJK UNIFIED IDEOGRAPH
	{0x684E,	0xD1E8},	// CJK UNIFIED IDEOGRAPH
	{0x684F,	0xD1E0},	// CJK UNIFIED IDEOGRAPH
	{0x6850,	0xAEE4},	// CJK UNIFIED IDEOGRAPH
	{0x6851,	0xAEE1},	// CJK UNIFIED IDEOGRAPH
	{0x6853,	0xAED9},	// CJK UNIFIED IDEOGRAPH
	{0x6854,	0xAEDC},	// CJK UNIFIED IDEOGRAPH
	{0x686B,	0xD5C4},	// CJK UNIFIED IDEOGRAPH
	{0x686D,	0xD5B4},	// CJK UNIFIED IDEOGRAPH
	{0x686E,	0xD5B5},	// CJK UNIFIED IDEOGRAPH
	{0x686F,	0xD5B9},	// CJK UNIFIED IDEOGRAPH
	{0x6871,	0xD5C8},	// CJK UNIFIED IDEOGRAPH
	{0x6872,	0xD5C5},	// CJK UNIFIED IDEOGRAPH
	{0x6874,	0xD5BE},	// CJK UNIFIED IDEOGRAPH
	{0x6875,	0xD5BD},	// CJK UNIFIED IDEOGRAPH
	{0x6876,	0xB1ED},	// CJK UNIFIED IDEOGRAPH
	{0x6877,	0xD5C1},	// CJK UNIFIED IDEOGRAPH
	{0x6878,	0xD5D0},	// CJK UNIFIED IDEOGRAPH
	{0x6879,	0xD5B0},	// CJK UNIFIED IDEOGRAPH
	{0x687B,	0xD5D1},	// CJK UNIFIED IDEOGRAPH
	{0x687C,	0xD5C3},	// CJK UNIFIED IDEOGRAPH
	{0x687D,	0xD5D5},	// CJK UNIFIED IDEOGRAPH
	{0x687E,	0xD5C9},	// CJK UNIFIED IDEOGRAPH
	{0x687F,	0xB1EC},	// CJK UNIFIED IDEOGRAPH
	{0x6880,	0xD5C7},	// CJK UNIFIED IDEOGRAPH
	{0x6881,	0xB1E7},	// CJK UNIFIED IDEOGRAPH
	{0x6882,	0xB1FC},	// CJK UNIFIED IDEOGRAPH
	{0x6883,	0xB1F2},	// CJK UNIFIED IDEOGRAPH
	{0x6885,	0xB1F6},	// CJK UNIFIED IDEOGRAPH
	{0x6886,	0xB1F5},	// CJK UNIFIED IDEOGRAPH
	{0x6887,	0xD5B1},	// CJK UNIFIED IDEOGRAPH
	{0x6889,	0xD5CE},	// CJK UNIFIED IDEOGRAPH
	{0x688A,	0xD5D4},	// CJK UNIFIED IDEOGRAPH
	{0x688B,	0xD5CC},	// CJK UNIFIED IDEOGRAPH
	{0x688C,	0xD5D3},	// CJK UNIFIED IDEOGRAPH
	{0x688F,	0xD5C0},	// CJK UNIFIED IDEOGRAPH
	{0x6890,	0xD5B2},	// CJK UNIFIED IDEOGRAPH
	{0x6891,	0xD5D2},	// CJK UNIFIED IDEOGRAPH
	{0x6892,	0xD5C2},	// CJK UNIFIED IDEOGRAPH
	{0x6893,	0xB1EA},	// CJK UNIFIED IDEOGRAPH
	{0x6894,	0xB1F7},	// CJK UNIFIED IDEOGRAPH
	{0x6896,	0xD5CB},	// CJK UNIFIED IDEOGRAPH
	{0x6897,	0xB1F0},	// CJK UNIFIED IDEOGRAPH
	{0x689B,	0xD5CA},	// CJK UNIFIED IDEOGRAPH
	{0x689C,	0xD5B3},	// CJK UNIFIED IDEOGRAPH
	{0x689D,	0xB1F8},	// CJK UNIFIED IDEOGRAPH
	{0x689F,	0xB1FA},	// CJK UNIFIED IDEOGRAPH
	{0x68A0,	0xD5CD},	// CJK UNIFIED IDEOGRAPH
	{0x68A1,	0xB1FB},	// CJK UNIFIED IDEOGRAPH
	{0x68A2,	0xB1E9},	// CJK UNIFIED IDEOGRAPH
	{0x68A3,	0xD5BA},	// CJK UNIFIED IDEOGRAPH
	{0x68A4,	0xD5CF},	// CJK UNIFIED IDEOGRAPH
	{0x68A7,	0xB1EF},	// CJK UNIFIED IDEOGRAPH
	{0x68A8,	0xB1F9},	// CJK UNIFIED IDEOGRAPH
	{0x68A9,	0xD5BC},	// CJK UNIFIED IDEOGRAPH
	{0x68AA,	0xD5C6},	// CJK UNIFIED IDEOGRAPH
	{0x68AB,	0xD5B7},	// CJK UNIFIED IDEOGRAPH
	{0x68AC,	0xD5BB},	// CJK UNIFIED IDEOGRAPH
	{0x68AD,	0xB1F4},	// CJK UNIFIED IDEOGRAPH
	{0x68AE,	0xD5B6},	// CJK UNIFIED IDEOGRAPH
	{0x68AF,	0xB1E8},	// CJK UNIFIED IDEOGRAPH
	{0x68B0,	0xB1F1},	// CJK UNIFIED IDEOGRAPH
	{0x68B1,	0xB1EE},	// CJK UNIFIED IDEOGRAPH
	{0x68B2,	0xD5BF},	// CJK UNIFIED IDEOGRAPH
	{0x68B3,	0xAEDE},	// CJK UNIFIED IDEOGRAPH
	{0x68B4,	0xD9C0},	// CJK UNIFIED IDEOGRAPH
	{0x68B5,	0xB1EB},	// CJK UNIFIED IDEOGRAPH
	{0x68C4,	0xB1F3},	// CJK UNIFIED IDEOGRAPH
	{0x68C6,	0xD9C3},	// CJK UNIFIED IDEOGRAPH
	{0x68C7,	0xD9D9},	// CJK UNIFIED IDEOGRAPH
	{0x68C8,	0xD9CE},	// CJK UNIFIED IDEOGRAPH
	{0x68C9,	0xB4D6},	// CJK UNIFIED IDEOGRAPH
	{0x68CB,	0xB4D1},	// CJK UNIFIED IDEOGRAPH
	{0x68CC,	0xD9BD},	// CJK UNIFIED IDEOGRAPH
	{0x68CD,	0xB4D2},	// CJK UNIFIED IDEOGRAPH
	{0x68CE,	0xD9CD},	// CJK UNIFIED IDEOGRAPH
	{0x68D0,	0xD9C6},	// CJK UNIFIED IDEOGRAPH
	{0x68D1,	0xD9D3},	// CJK UNIFIED IDEOGRAPH
	{0x68D2,	0xB4CE},	// CJK UNIFIED IDEOGRAPH
	{0x68D3,	0xD9AB},	// CJK UNIFIED IDEOGRAPH
	{0x68D4,	0xD9D5},	// CJK UNIFIED IDEOGRAPH
	{0x68D5,	0xB4C4},	// CJK UNIFIED IDEOGRAPH
	{0x68D6,	0xD9B3},	// CJK UNIFIED IDEOGRAPH
	{0x68D7,	0xB4C7},	// CJK UNIFIED IDEOGRAPH
	{0x68D8,	0xB4C6},	// CJK UNIFIED IDEOGRAPH
	{0x68DA,	0xB4D7},	// CJK UNIFIED IDEOGRAPH
	{0x68DC,	0xD9AD},	// CJK UNIFIED IDEOGRAPH
	{0x68DD,	0xD9CF},	// CJK UNIFIED IDEOGRAPH
	{0x68DE,	0xD9D0},	// CJK UNIFIED IDEOGRAPH
	{0x68DF,	0xB4C9},	// CJK UNIFIED IDEOGRAPH
	{0x68E0,	0xB4C5},	// CJK UNIFIED IDEOGRAPH
	{0x68E1,	0xD9BB},	// CJK UNIFIED IDEOGRAPH
	{0x68E3,	0xB4D0},	// CJK UNIFIED IDEOGRAPH
	{0x68E4,	0xD9B6},	// CJK UNIFIED IDEOGRAPH
	{0x68E6,	0xD9D1},	// CJK UNIFIED IDEOGRAPH
	{0x68E7,	0xB4CC},	// CJK UNIFIED IDEOGRAPH
	{0x68E8,	0xD9C9},	// CJK UNIFIED IDEOGRAPH
	{0x68E9,	0xD9D6},	// CJK UNIFIED IDEOGRAPH
	{0x68EA,	0xD9B0},	// CJK UNIFIED IDEOGRAPH
	{0x68EB,	0xD9B5},	// CJK UNIFIED IDEOGRAPH
	{0x68EC,	0xD9AF},	// CJK UNIFIED IDEOGRAPH
	{0x68EE,	0xB4CB},	// CJK UNIFIED IDEOGRAPH
	{0x68EF,	0xD9C2},	// CJK UNIFIED IDEOGRAPH
	{0x68F0,	0xDDDE},	// CJK UNIFIED IDEOGRAPH
	{0x68F1,	0xD9B1},	// CJK UNIFIED IDEOGRAPH
	{0x68F2,	0xB4CF},	// CJK UNIFIED IDEOGRAPH
	{0x68F3,	0xD9BA},	// CJK UNIFIED IDEOGRAPH
	{0x68F4,	0xD9D2},	// CJK UNIFIED IDEOGRAPH
	{0x68F5,	0xB4CA},	// CJK UNIFIED IDEOGRAPH
	{0x68F6,	0xD9B7},	// CJK UNIFIED IDEOGRAPH
	{0x68F7,	0xD9B4},	// CJK UNIFIED IDEOGRAPH
	{0x68F8,	0xD9C5},	// CJK UNIFIED IDEOGRAPH
	{0x68F9,	0xB4CD},	// CJK UNIFIED IDEOGRAPH
	{0x68FA,	0xB4C3},	// CJK UNIFIED IDEOGRAPH
	{0x68FB,	0xB4D9},	// CJK UNIFIED IDEOGRAPH
	{0x68FC,	0xD9C8},	// CJK UNIFIED IDEOGRAPH
	{0x68FD,	0xD9C7},	// CJK UNIFIED IDEOGRAPH
	{0x6904,	0xD9AC},	// CJK UNIFIED IDEOGRAPH
	{0x6905,	0xB4C8},	// CJK UNIFIED IDEOGRAPH
	{0x6906,	0xD9D4},	// CJK UNIFIED IDEOGRAPH
	{0x6907,	0xD9BC},	// CJK UNIFIED IDEOGRAPH
	{0x6908,	0xD9BE},	// CJK UNIFIED IDEOGRAPH
	{0x690A,	0xD9CB},	// CJK UNIFIED IDEOGRAPH
	{0x690B,	0xD9CA},	// CJK UNIFIED IDEOGRAPH
	{0x690C,	0xD9AA},	// CJK UNIFIED IDEOGRAPH
	{0x690D,	0xB4D3},	// CJK UNIFIED IDEOGRAPH
	{0x690E,	0xB4D5},	// CJK UNIFIED IDEOGRAPH
	{0x690F,	0xD9B2},	// CJK UNIFIED IDEOGRAPH
	{0x6910,	0xD9B9},	// CJK UNIFIED IDEOGRAPH
	{0x6911,	0xD9C1},	// CJK UNIFIED IDEOGRAPH
	{0x6912,	0xB4D4},	// CJK UNIFIED IDEOGRAPH
	{0x6913,	0xD9B8},	// CJK UNIFIED IDEOGRAPH
	{0x6914,	0xD9C4},	// CJK UNIFIED IDEOGRAPH
	{0x6915,	0xD9D7},	// CJK UNIFIED IDEOGRAPH
	{0x6917,	0xD9CC},	// CJK UNIFIED IDEOGRAPH
	{0x6925,	0xD9D8},	// CJK UNIFIED IDEOGRAPH
	{0x692A,	0xD9AE},	// CJK UNIFIED IDEOGRAPH
	{0x692F,	0xDDF2},	// CJK UNIFIED IDEOGRAPH
	{0x6930,	0xB7A6},	// CJK UNIFIED IDEOGRAPH
	{0x6932,	0xDDF0},	// CJK UNIFIED IDEOGRAPH
	{0x6933,	0xDDDB},	// CJK UNIFIED IDEOGRAPH
	{0x6934,	0xDDE0},	// CJK UNIFIED IDEOGRAPH
	{0x6935,	0xDDD9},	// CJK UNIFIED IDEOGRAPH
	{0x6937,	0xDDEC},	// CJK UNIFIED IDEOGRAPH
	{0x6938,	0xDDCB},	// CJK UNIFIED IDEOGRAPH
	{0x6939,	0xDDD2},	// CJK UNIFIED IDEOGRAPH
	{0x693B,	0xDDEA},	// CJK UNIFIED IDEOGRAPH
	{0x693C,	0xDDF4},	// CJK UNIFIED IDEOGRAPH
	{0x693D,	0xDDDC},	// CJK UNIFIED IDEOGRAPH
	{0x693F,	0xDDCF},	// CJK UNIFIED IDEOGRAPH
	{0x6940,	0xDDE2},	// CJK UNIFIED IDEOGRAPH
	{0x6941,	0xDDE7},	// CJK UNIFIED IDEOGRAPH
	{0x6942,	0xDDD3},	// CJK UNIFIED IDEOGRAPH
	{0x6944,	0xDDE4},	// CJK UNIFIED IDEOGRAPH
	{0x6945,	0xDDD0},	// CJK UNIFIED IDEOGRAPH
	{0x6948,	0xDDD7},	// CJK UNIFIED IDEOGRAPH
	{0x6949,	0xDDD8},	// CJK UNIFIED IDEOGRAPH
	{0x694A,	0xB7A8},	// CJK UNIFIED IDEOGRAPH
	{0x694B,	0xDDEB},	// CJK UNIFIED IDEOGRAPH
	{0x694C,	0xDDE9},	// CJK UNIFIED IDEOGRAPH
	{0x694E,	0xDDCC},	// CJK UNIFIED IDEOGRAPH
	{0x694F,	0xDDEE},	// CJK UNIFIED IDEOGRAPH
	{0x6951,	0xDDEF},	// CJK UNIFIED IDEOGRAPH
	{0x6952,	0xDDF1},	// CJK UNIFIED IDEOGRAPH
	{0x6953,	0xB7AC},	// CJK UNIFIED IDEOGRAPH
	{0x6954,	0xB7A4},	// CJK UNIFIED IDEOGRAPH
	{0x6956,	0xD5B8},	// CJK UNIFIED IDEOGRAPH
	{0x6957,	0xDDD4},	// CJK UNIFIED IDEOGRAPH
	{0x6958,	0xDDE6},	// CJK UNIFIED IDEOGRAPH
	{0x6959,	0xDDD5},	// CJK UNIFIED IDEOGRAPH
	{0x695A,	0xB7A1},	// CJK UNIFIED IDEOGRAPH
	{0x695B,	0xB7B1},	// CJK UNIFIED IDEOGRAPH
	{0x695C,	0xDDED},	// CJK UNIFIED IDEOGRAPH
	{0x695D,	0xB7AF},	// CJK UNIFIED IDEOGRAPH
	{0x695E,	0xB7AB},	// CJK UNIFIED IDEOGRAPH
	{0x695F,	0xDDCA},	// CJK UNIFIED IDEOGRAPH
	{0x6960,	0xB7A3},	// CJK UNIFIED IDEOGRAPH
	{0x6962,	0xDDCD},	// CJK UNIFIED IDEOGRAPH
	{0x6963,	0xB7B0},	// CJK UNIFIED IDEOGRAPH
	{0x6965,	0xDDDD},	// CJK UNIFIED IDEOGRAPH
	{0x6966,	0xDDC9},	// CJK UNIFIED IDEOGRAPH
	{0x6968,	0xB7A9},	// CJK UNIFIED IDEOGRAPH
	{0x6969,	0xDDE1},	// CJK UNIFIED IDEOGRAPH
	{0x696A,	0xDDD1},	// CJK UNIFIED IDEOGRAPH
	{0x696B,	0xB7AA},	// CJK UNIFIED IDEOGRAPH
	{0x696C,	0xDDDA},	// CJK UNIFIED IDEOGRAPH
	{0x696D,	0xB77E},	// CJK UNIFIED IDEOGRAPH
	{0x696E,	0xB4D8},	// CJK UNIFIED IDEOGRAPH
	{0x696F,	0xDDE3},	// CJK UNIFIED IDEOGRAPH
	{0x6970,	0xD9BF},	// CJK UNIFIED IDEOGRAPH
	{0x6971,	0xDDCE},	// CJK UNIFIED IDEOGRAPH
	{0x6974,	0xDDE8},	// CJK UNIFIED IDEOGRAPH
	{0x6975,	0xB7A5},	// CJK UNIFIED IDEOGRAPH
	{0x6976,	0xDDE5},	// CJK UNIFIED IDEOGRAPH
	{0x6977,	0xB7A2},	// CJK UNIFIED IDEOGRAPH
	{0x6978,	0xDDDF},	// CJK UNIFIED IDEOGRAPH
	{0x6979,	0xB7AD},	// CJK UNIFIED IDEOGRAPH
	{0x697A,	0xDDD6},	// CJK UNIFIED IDEOGRAPH
	{0x697B,	0xDDF3},	// CJK UNIFIED IDEOGRAPH
	{0x6982,	0xB7A7},	// CJK UNIFIED IDEOGRAPH
	{0x6983,	0xDEC6},	// CJK UNIFIED IDEOGRAPH
	{0x6986,	0xB7AE},	// CJK UNIFIED IDEOGRAPH
	{0x698D,	0xE24A},	// CJK UNIFIED IDEOGRAPH
	{0x698E,	0xE248},	// CJK UNIFIED IDEOGRAPH
	{0x6990,	0xE25E},	// CJK UNIFIED IDEOGRAPH
	{0x6991,	0xE246},	// CJK UNIFIED IDEOGRAPH
	{0x6993,	0xE258},	// CJK UNIFIED IDEOGRAPH
	{0x6994,	0xB77D},	// CJK UNIFIED IDEOGRAPH
	{0x6995,	0xBA5F},	// CJK UNIFIED IDEOGRAPH
	{0x6996,	0xE242},	// CJK UNIFIED IDEOGRAPH
	{0x6997,	0xE25D},	// CJK UNIFIED IDEOGRAPH
	{0x6999,	0xE247},	// CJK UNIFIED IDEOGRAPH
	{0x699A,	0xE255},	// CJK UNIFIED IDEOGRAPH
	{0x699B,	0xBA64},	// CJK UNIFIED IDEOGRAPH
	{0x699C,	0xBA5D},	// CJK UNIFIED IDEOGRAPH
	{0x699E,	0xE25B},	// CJK UNIFIED IDEOGRAPH
	{0x69A0,	0xE240},	// CJK UNIFIED IDEOGRAPH
	{0x69A1,	0xE25A},	// CJK UNIFIED IDEOGRAPH
	{0x69A3,	0xBA6F},	// CJK UNIFIED IDEOGRAPH
	{0x69A4,	0xE251},	// CJK UNIFIED IDEOGRAPH
	{0x69A5,	0xE261},	// CJK UNIFIED IDEOGRAPH
	{0x69A6,	0xBA6D},	// CJK UNIFIED IDEOGRAPH
	{0x69A7,	0xE249},	// CJK UNIFIED IDEOGRAPH
	{0x69A8,	0xBA5E},	// CJK UNIFIED IDEOGRAPH
	{0x69A9,	0xE24B},	// CJK UNIFIED IDEOGRAPH
	{0x69AA,	0xE259},	// CJK UNIFIED IDEOGRAPH
	{0x69AB,	0xBA67},	// CJK UNIFIED IDEOGRAPH
	{0x69AC,	0xE244},	// CJK UNIFIED IDEOGRAPH
	{0x69AD,	0xBA6B},	// CJK UNIFIED IDEOGRAPH
	{0x69AE,	0xBA61},	// CJK UNIFIED IDEOGRAPH
	{0x69AF,	0xE24D},	// CJK UNIFIED IDEOGRAPH
	{0x69B0,	0xE243},	// CJK UNIFIED IDEOGRAPH
	{0x69B1,	0xE1FC},	// CJK UNIFIED IDEOGRAPH
	{0x69B3,	0xE257},	// CJK UNIFIED IDEOGRAPH
	{0x69B4,	0xBA68},	// CJK UNIFIED IDEOGRAPH
	{0x69B5,	0xE260},	// CJK UNIFIED IDEOGRAPH
	{0x69B6,	0xE1FD},	// CJK UNIFIED IDEOGRAPH
	{0x69B7,	0xBA65},	// CJK UNIFIED IDEOGRAPH
	{0x69B9,	0xE253},	// CJK UNIFIED IDEOGRAPH
	{0x69BB,	0xBA66},	// CJK UNIFIED IDEOGRAPH
	{0x69BC,	0xE245},	// CJK UNIFIED IDEOGRAPH
	{0x69BD,	0xE250},	// CJK UNIFIED IDEOGRAPH
	{0x69BE,	0xE24C},	// CJK UNIFIED IDEOGRAPH
	{0x69BF,	0xE24E},	// CJK UNIFIED IDEOGRAPH
	{0x69C1,	0xBA60},	// CJK UNIFIED IDEOGRAPH
	{0x69C2,	0xE25F},	// CJK UNIFIED IDEOGRAPH
	{0x69C3,	0xBA6E},	// CJK UNIFIED IDEOGRAPH
	{0x69C4,	0xE24F},	// CJK UNIFIED IDEOGRAPH
	{0x69C6,	0xE262},	// CJK UNIFIED IDEOGRAPH
	{0x69C9,	0xE1FE},	// CJK UNIFIED IDEOGRAPH
	{0x69CA,	0xE254},	// CJK UNIFIED IDEOGRAPH
	{0x69CB,	0xBA63},	// CJK UNIFIED IDEOGRAPH
	{0x69CC,	0xBA6C},	// CJK UNIFIED IDEOGRAPH
	{0x69CD,	0xBA6A},	// CJK UNIFIED IDEOGRAPH
	{0x69CE,	0xE241},	// CJK UNIFIED IDEOGRAPH
	{0x69CF,	0xE256},	// CJK UNIFIED IDEOGRAPH
	{0x69D0,	0xBA69},	// CJK UNIFIED IDEOGRAPH
	{0x69D3,	0xBA62},	// CJK UNIFIED IDEOGRAPH
	{0x69D4,	0xE252},	// CJK UNIFIED IDEOGRAPH
	{0x69D9,	0xE25C},	// CJK UNIFIED IDEOGRAPH
	{0x69E2,	0xE5D5},	// CJK UNIFIED IDEOGRAPH
	{0x69E4,	0xE5D1},	// CJK UNIFIED IDEOGRAPH
	{0x69E5,	0xE5CD},	// CJK UNIFIED IDEOGRAPH
	{0x69E6,	0xE5E1},	// CJK UNIFIED IDEOGRAPH
	{0x69E7,	0xE5DE},	// CJK UNIFIED IDEOGRAPH
	{0x69E8,	0xBCCD},	// CJK UNIFIED IDEOGRAPH
	{0x69EB,	0xE5E5},	// CJK UNIFIED IDEOGRAPH
	{0x69EC,	0xE5D4},	// CJK UNIFIED IDEOGRAPH
	{0x69ED,	0xBCD8},	// CJK UNIFIED IDEOGRAPH
	{0x69EE,	0xE5DB},	// CJK UNIFIED IDEOGRAPH
	{0x69F1,	0xE5D0},	// CJK UNIFIED IDEOGRAPH
	{0x69F2,	0xE5DA},	// CJK UNIFIED IDEOGRAPH
	{0x69F3,	0xBCD5},	// CJK UNIFIED IDEOGRAPH
	{0x69F4,	0xE5EE},	// CJK UNIFIED IDEOGRAPH
	{0x69F6,	0xE5EB},	// CJK UNIFIED IDEOGRAPH
	{0x69F7,	0xE5DD},	// CJK UNIFIED IDEOGRAPH
	{0x69F8,	0xE5CE},	// CJK UNIFIED IDEOGRAPH
	{0x69FB,	0xE5E2},	// CJK UNIFIED IDEOGRAPH
	{0x69FC,	0xE5E4},	// CJK UNIFIED IDEOGRAPH
	{0x69FD,	0xBCD1},	// CJK UNIFIED IDEOGRAPH
	{0x69FE,	0xE5D8},	// CJK UNIFIED IDEOGRAPH
	{0x69FF,	0xE5D3},	// CJK UNIFIED IDEOGRAPH
	{0x6A00,	0xE5CA},	// CJK UNIFIED IDEOGRAPH
	{0x6A01,	0xBCCE},	// CJK UNIFIED IDEOGRAPH
	{0x6A02,	0xBCD6},	// CJK UNIFIED IDEOGRAPH
	{0x6A04,	0xE5E7},	// CJK UNIFIED IDEOGRAPH
	{0x6A05,	0xBCD7},	// CJK UNIFIED IDEOGRAPH
	{0x6A06,	0xE5CB},	// CJK UNIFIED IDEOGRAPH
	{0x6A07,	0xE5ED},	// CJK UNIFIED IDEOGRAPH
	{0x6A08,	0xE5E0},	// CJK UNIFIED IDEOGRAPH
	{0x6A09,	0xE5E6},	// CJK UNIFIED IDEOGRAPH
	{0x6A0A,	0xBCD4},	// CJK UNIFIED IDEOGRAPH
	{0x6A0D,	0xE5E3},	// CJK UNIFIED IDEOGRAPH
	{0x6A0F,	0xE5EA},	// CJK UNIFIED IDEOGRAPH
	{0x6A11,	0xBCD9},	// CJK UNIFIED IDEOGRAPH
	{0x6A13,	0xBCD3},	// CJK UNIFIED IDEOGRAPH
	{0x6A14,	0xE5DC},	// CJK UNIFIED IDEOGRAPH
	{0x6A15,	0xE5CF},	// CJK UNIFIED IDEOGRAPH
	{0x6A16,	0xE5EF},	// CJK UNIFIED IDEOGRAPH
	{0x6A17,	0xE5CC},	// CJK UNIFIED IDEOGRAPH
	{0x6A18,	0xE5E8},	// CJK UNIFIED IDEOGRAPH
	{0x6A19,	0xBCD0},	// CJK UNIFIED IDEOGRAPH
	{0x6A1B,	0xE5D6},	// CJK UNIFIED IDEOGRAPH
	{0x6A1D,	0xE5D7},	// CJK UNIFIED IDEOGRAPH
	{0x6A1E,	0xBCCF},	// CJK UNIFIED IDEOGRAPH
	{0x6A1F,	0xBCCC},	// CJK UNIFIED IDEOGRAPH
	{0x6A20,	0xE5D2},	// CJK UNIFIED IDEOGRAPH
	{0x6A21,	0xBCD2},	// CJK UNIFIED IDEOGRAPH
	{0x6A23,	0xBCCB},	// CJK UNIFIED IDEOGRAPH
	{0x6A25,	0xE5E9},	// CJK UNIFIED IDEOGRAPH
	{0x6A26,	0xE5EC},	// CJK UNIFIED IDEOGRAPH
	{0x6A27,	0xE5D9},	// CJK UNIFIED IDEOGRAPH
	{0x6A28,	0xE9CA},	// CJK UNIFIED IDEOGRAPH
	{0x6A32,	0xE9C2},	// CJK UNIFIED IDEOGRAPH
	{0x6A34,	0xE9BE},	// CJK UNIFIED IDEOGRAPH
	{0x6A35,	0xBEF6},	// CJK UNIFIED IDEOGRAPH
	{0x6A38,	0xBEEB},	// CJK UNIFIED IDEOGRAPH
	{0x6A39,	0xBEF0},	// CJK UNIFIED IDEOGRAPH
	{0x6A3A,	0xBEEC},	// CJK UNIFIED IDEOGRAPH
	{0x6A3B,	0xE9CC},	// CJK UNIFIED IDEOGRAPH
	{0x6A3C,	0xE9D7},	// CJK UNIFIED IDEOGRAPH
	{0x6A3D,	0xBEEA},	// CJK UNIFIED IDEOGRAPH
	{0x6A3E,	0xE9C4},	// CJK UNIFIED IDEOGRAPH
	{0x6A3F,	0xE9CD},	// CJK UNIFIED IDEOGRAPH
	{0x6A40,	0xE5DF},	// CJK UNIFIED IDEOGRAPH
	{0x6A41,	0xE9CE},	// CJK UNIFIED IDEOGRAPH
	{0x6A44,	0xBEF1},	// CJK UNIFIED IDEOGRAPH
	{0x6A46,	0xE9DD},	// CJK UNIFIED IDEOGRAPH
	{0x6A47,	0xBEF5},	// CJK UNIFIED IDEOGRAPH
	{0x6A48,	0xBEF8},	// CJK UNIFIED IDEOGRAPH
	{0x6A49,	0xE9C0},	// CJK UNIFIED IDEOGRAPH
	{0x6A4B,	0xBEF4},	// CJK UNIFIED IDEOGRAPH
	{0x6A4D,	0xE9DB},	// CJK UNIFIED IDEOGRAPH
	{0x6A4E,	0xE9DC},	// CJK UNIFIED IDEOGRAPH
	{0x6A4F,	0xE9D2},	// CJK UNIFIED IDEOGRAPH
	{0x6A50,	0xE9D1},	// CJK UNIFIED IDEOGRAPH
	{0x6A51,	0xE9C9},	// CJK UNIFIED IDEOGRAPH
	{0x6A54,	0xE9D3},	// CJK UNIFIED IDEOGRAPH
	{0x6A55,	0xE9DA},	// CJK UNIFIED IDEOGRAPH
	{0x6A56,	0xE9D9},	// CJK UNIFIED IDEOGRAPH
	{0x6A58,	0xBEEF},	// CJK UNIFIED IDEOGRAPH
	{0x6A59,	0xBEED},	// CJK UNIFIED IDEOGRAPH
	{0x6A5A,	0xE9CB},	// CJK UNIFIED IDEOGRAPH
	{0x6A5B,	0xE9C8},	// CJK UNIFIED IDEOGRAPH
	{0x6A5D,	0xE9C5},	// CJK UNIFIED IDEOGRAPH
	{0x6A5E,	0xE9D8},	// CJK UNIFIED IDEOGRAPH
	{0x6A5F,	0xBEF7},	// CJK UNIFIED IDEOGRAPH
	{0x6A60,	0xE9D6},	// CJK UNIFIED IDEOGRAPH
	{0x6A61,	0xBEF3},	// CJK UNIFIED IDEOGRAPH
	{0x6A62,	0xBEF2},	// CJK UNIFIED IDEOGRAPH
	{0x6A64,	0xE9D0},	// CJK UNIFIED IDEOGRAPH
	{0x6A66,	0xE9BF},	// CJK UNIFIED IDEOGRAPH
	{0x6A67,	0xE9C1},	// CJK UNIFIED IDEOGRAPH
	{0x6A68,	0xE9C3},	// CJK UNIFIED IDEOGRAPH
	{0x6A69,	0xE9D5},	// CJK UNIFIED IDEOGRAPH
	{0x6A6A,	0xE9CF},	// CJK UNIFIED IDEOGRAPH
	{0x6A6B,	0xBEEE},	// CJK UNIFIED IDEOGRAPH
	{0x6A6D,	0xE9C6},	// CJK UNIFIED IDEOGRAPH
	{0x6A6F,	0xE9D4},	// CJK UNIFIED IDEOGRAPH
	{0x6A76,	0xE9C7},	// CJK UNIFIED IDEOGRAPH
	{0x6A7E,	0xC0CF},	// CJK UNIFIED IDEOGRAPH
	{0x6A7F,	0xED45},	// CJK UNIFIED IDEOGRAPH
	{0x6A80,	0xC0C8},	// CJK UNIFIED IDEOGRAPH
	{0x6A81,	0xECF5},	// CJK UNIFIED IDEOGRAPH
	{0x6A83,	0xED41},	// CJK UNIFIED IDEOGRAPH
	{0x6A84,	0xC0CA},	// CJK UNIFIED IDEOGRAPH
	{0x6A85,	0xED48},	// CJK UNIFIED IDEOGRAPH
	{0x6A87,	0xECFC},	// CJK UNIFIED IDEOGRAPH
	{0x6A89,	0xECF7},	// CJK UNIFIED IDEOGRAPH
	{0x6A8C,	0xED49},	// CJK UNIFIED IDEOGRAPH
	{0x6A8D,	0xECF3},	// CJK UNIFIED IDEOGRAPH
	{0x6A8E,	0xECFE},	// CJK UNIFIED IDEOGRAPH
	{0x6A90,	0xC0D1},	// CJK UNIFIED IDEOGRAPH
	{0x6A91,	0xED44},	// CJK UNIFIED IDEOGRAPH
	{0x6A92,	0xED4A},	// CJK UNIFIED IDEOGRAPH
	{0x6A93,	0xECFD},	// CJK UNIFIED IDEOGRAPH
	{0x6A94,	0xC0C9},	// CJK UNIFIED IDEOGRAPH
	{0x6A95,	0xED40},	// CJK UNIFIED IDEOGRAPH
	{0x6A96,	0xECF4},	// CJK UNIFIED IDEOGRAPH
	{0x6A97,	0xC0D0},	// CJK UNIFIED IDEOGRAPH
	{0x6A9A,	0xED47},	// CJK UNIFIED IDEOGRAPH
	{0x6A9B,	0xECF9},	// CJK UNIFIED IDEOGRAPH
	{0x6A9C,	0xC0CC},	// CJK UNIFIED IDEOGRAPH
	{0x6A9E,	0xECFB},	// CJK UNIFIED IDEOGRAPH
	{0x6A9F,	0xECF8},	// CJK UNIFIED IDEOGRAPH
	{0x6AA0,	0xC0D2},	// CJK UNIFIED IDEOGRAPH
	{0x6AA1,	0xECFA},	// CJK UNIFIED IDEOGRAPH
	{0x6AA2,	0xC0CB},	// CJK UNIFIED IDEOGRAPH
	{0x6AA3,	0xC0CE},	// CJK UNIFIED IDEOGRAPH
	{0x6AA4,	0xED43},	// CJK UNIFIED IDEOGRAPH
	{0x6AA5,	0xECF6},	// CJK UNIFIED IDEOGRAPH
	{0x6AA6,	0xED46},	// CJK UNIFIED IDEOGRAPH
	{0x6AA8,	0xED42},	// CJK UNIFIED IDEOGRAPH
	{0x6AAC,	0xC263},	// CJK UNIFIED IDEOGRAPH
	{0x6AAD,	0xEFE7},	// CJK UNIFIED IDEOGRAPH
	{0x6AAE,	0xC268},	// CJK UNIFIED IDEOGRAPH
	{0x6AAF,	0xC269},	// CJK UNIFIED IDEOGRAPH
	{0x6AB3,	0xC262},	// CJK UNIFIED IDEOGRAPH
	{0x6AB4,	0xEFE6},	// CJK UNIFIED IDEOGRAPH
	{0x6AB6,	0xEFE3},	// CJK UNIFIED IDEOGRAPH
	{0x6AB7,	0xEFE4},	// CJK UNIFIED IDEOGRAPH
	{0x6AB8,	0xC266},	// CJK UNIFIED IDEOGRAPH
	{0x6AB9,	0xEFDE},	// CJK UNIFIED IDEOGRAPH
	{0x6ABA,	0xEFE2},	// CJK UNIFIED IDEOGRAPH
	{0x6ABB,	0xC265},	// CJK UNIFIED IDEOGRAPH
	{0x6ABD,	0xEFDF},	// CJK UNIFIED IDEOGRAPH
	{0x6AC2,	0xC267},	// CJK UNIFIED IDEOGRAPH
	{0x6AC3,	0xC264},	// CJK UNIFIED IDEOGRAPH
	{0x6AC5,	0xEFDD},	// CJK UNIFIED IDEOGRAPH
	{0x6AC6,	0xEFE1},	// CJK UNIFIED IDEOGRAPH
	{0x6AC7,	0xEFE5},	// CJK UNIFIED IDEOGRAPH
	{0x6ACB,	0xF251},	// CJK UNIFIED IDEOGRAPH
	{0x6ACC,	0xF24E},	// CJK UNIFIED IDEOGRAPH
	{0x6ACD,	0xF257},	// CJK UNIFIED IDEOGRAPH
	{0x6ACF,	0xF256},	// CJK UNIFIED IDEOGRAPH
	{0x6AD0,	0xF254},	// CJK UNIFIED IDEOGRAPH
	{0x6AD1,	0xF24F},	// CJK UNIFIED IDEOGRAPH
	{0x6AD3,	0xC372},	// CJK UNIFIED IDEOGRAPH
	{0x6AD9,	0xF250},	// CJK UNIFIED IDEOGRAPH
	{0x6ADA,	0xC371},	// CJK UNIFIED IDEOGRAPH
	{0x6ADB,	0xC0CD},	// CJK UNIFIED IDEOGRAPH
	{0x6ADC,	0xF253},	// CJK UNIFIED IDEOGRAPH
	{0x6ADD,	0xC370},	// CJK UNIFIED IDEOGRAPH
	{0x6ADE,	0xF258},	// CJK UNIFIED IDEOGRAPH
	{0x6ADF,	0xF252},	// CJK UNIFIED IDEOGRAPH
	{0x6AE0,	0xF24D},	// CJK UNIFIED IDEOGRAPH
	{0x6AE1,	0xEFE0},	// CJK UNIFIED IDEOGRAPH
	{0x6AE5,	0xC36F},	// CJK UNIFIED IDEOGRAPH
	{0x6AE7,	0xF24C},	// CJK UNIFIED IDEOGRAPH
	{0x6AE8,	0xF456},	// CJK UNIFIED IDEOGRAPH
	{0x6AEA,	0xF455},	// CJK UNIFIED IDEOGRAPH
	{0x6AEB,	0xF255},	// CJK UNIFIED IDEOGRAPH
	{0x6AEC,	0xC468},	// CJK UNIFIED IDEOGRAPH
	{0x6AEE,	0xF459},	// CJK UNIFIED IDEOGRAPH
	{0x6AEF,	0xF45A},	// CJK UNIFIED IDEOGRAPH
	{0x6AF0,	0xF454},	// CJK UNIFIED IDEOGRAPH
	{0x6AF1,	0xF458},	// CJK UNIFIED IDEOGRAPH
	{0x6AF3,	0xF453},	// CJK UNIFIED IDEOGRAPH
	{0x6AF8,	0xF5D1},	// CJK UNIFIED IDEOGRAPH
	{0x6AF9,	0xF457},	// CJK UNIFIED IDEOGRAPH
	{0x6AFA,	0xC4E7},	// CJK UNIFIED IDEOGRAPH
	{0x6AFB,	0xC4E5},	// CJK UNIFIED IDEOGRAPH
	{0x6AFC,	0xF5CF},	// CJK UNIFIED IDEOGRAPH
	{0x6B00,	0xF5D2},	// CJK UNIFIED IDEOGRAPH
	{0x6B02,	0xF5CE},	// CJK UNIFIED IDEOGRAPH
	{0x6B03,	0xF5D0},	// CJK UNIFIED IDEOGRAPH
	{0x6B04,	0xC4E6},	// CJK UNIFIED IDEOGRAPH
	{0x6B08,	0xF6E5},	// CJK UNIFIED IDEOGRAPH
	{0x6B09,	0xF6E6},	// CJK UNIFIED IDEOGRAPH
	{0x6B0A,	0xC576},	// CJK UNIFIED IDEOGRAPH
	{0x6B0B,	0xF6E4},	// CJK UNIFIED IDEOGRAPH
	{0x6B0F,	0xF7E2},	// CJK UNIFIED IDEOGRAPH
	{0x6B10,	0xC5CF},	// CJK UNIFIED IDEOGRAPH
	{0x6B11,	0xF7E0},	// CJK UNIFIED IDEOGRAPH
	{0x6B12,	0xF7E1},	// CJK UNIFIED IDEOGRAPH
	{0x6B13,	0xF8AC},	// CJK UNIFIED IDEOGRAPH
	{0x6B16,	0xC656},	// CJK UNIFIED IDEOGRAPH
	{0x6B17,	0xF8F3},	// CJK UNIFIED IDEOGRAPH
	{0x6B18,	0xF8F1},	// CJK UNIFIED IDEOGRAPH
	{0x6B19,	0xF8F2},	// CJK UNIFIED IDEOGRAPH
	{0x6B1A,	0xF8F4},	// CJK UNIFIED IDEOGRAPH
	{0x6B1E,	0xF9BB},	// CJK UNIFIED IDEOGRAPH
	{0x6B20,	0xA4ED},	// CJK UNIFIED IDEOGRAPH
	{0x6B21,	0xA6B8},	// CJK UNIFIED IDEOGRAPH
	{0x6B23,	0xAA59},	// CJK UNIFIED IDEOGRAPH
	{0x6B25,	0xCCE9},	// CJK UNIFIED IDEOGRAPH
	{0x6B28,	0xCF64},	// CJK UNIFIED IDEOGRAPH
	{0x6B2C,	0xD1F5},	// CJK UNIFIED IDEOGRAPH
	{0x6B2D,	0xD1F7},	// CJK UNIFIED IDEOGRAPH
	{0x6B2F,	0xD1F6},	// CJK UNIFIED IDEOGRAPH
	{0x6B31,	0xD1F8},	// CJK UNIFIED IDEOGRAPH
	{0x6B32,	0xB1FD},	// CJK UNIFIED IDEOGRAPH
	{0x6B33,	0xD5D7},	// CJK UNIFIED IDEOGRAPH
	{0x6B34,	0xD1F9},	// CJK UNIFIED IDEOGRAPH
	{0x6B36,	0xD5D6},	// CJK UNIFIED IDEOGRAPH
	{0x6B37,	0xD5D8},	// CJK UNIFIED IDEOGRAPH
	{0x6B38,	0xD5D9},	// CJK UNIFIED IDEOGRAPH
	{0x6B39,	0xD9DA},	// CJK UNIFIED IDEOGRAPH
	{0x6B3A,	0xB4DB},	// CJK UNIFIED IDEOGRAPH
	{0x6B3B,	0xD9DB},	// CJK UNIFIED IDEOGRAPH
	{0x6B3C,	0xD9DD},	// CJK UNIFIED IDEOGRAPH
	{0x6B3D,	0xB4DC},	// CJK UNIFIED IDEOGRAPH
	{0x6B3E,	0xB4DA},	// CJK UNIFIED IDEOGRAPH
	{0x6B3F,	0xD9DC},	// CJK UNIFIED IDEOGRAPH
	{0x6B41,	0xDDFA},	// CJK UNIFIED IDEOGRAPH
	{0x6B42,	0xDDF8},	// CJK UNIFIED IDEOGRAPH
	{0x6B43,	0xDDF7},	// CJK UNIFIED IDEOGRAPH
	{0x6B45,	0xDDF6},	// CJK UNIFIED IDEOGRAPH
	{0x6B46,	0xDDF5},	// CJK UNIFIED IDEOGRAPH
	{0x6B47,	0xB7B2},	// CJK UNIFIED IDEOGRAPH
	{0x6B48,	0xDDF9},	// CJK UNIFIED IDEOGRAPH
	{0x6B49,	0xBA70},	// CJK UNIFIED IDEOGRAPH
	{0x6B4A,	0xE263},	// CJK UNIFIED IDEOGRAPH
	{0x6B4B,	0xE265},	// CJK UNIFIED IDEOGRAPH
	{0x6B4C,	0xBA71},	// CJK UNIFIED IDEOGRAPH
	{0x6B4D,	0xE264},	// CJK UNIFIED IDEOGRAPH
	{0x6B4E,	0xBCDB},	// CJK UNIFIED IDEOGRAPH
	{0x6B50,	0xBCDA},	// CJK UNIFIED IDEOGRAPH
	{0x6B51,	0xE5F0},	// CJK UNIFIED IDEOGRAPH
	{0x6B54,	0xE9DF},	// CJK UNIFIED IDEOGRAPH
	{0x6B55,	0xE9DE},	// CJK UNIFIED IDEOGRAPH
	{0x6B56,	0xE9E0},	// CJK UNIFIED IDEOGRAPH
	{0x6B59,	0xBEF9},	// CJK UNIFIED IDEOGRAPH
	{0x6B5B,	0xED4B},	// CJK UNIFIED IDEOGRAPH
	{0x6B5C,	0xC0D3},	// CJK UNIFIED IDEOGRAPH
	{0x6B5E,	0xEFE8},	// CJK UNIFIED IDEOGRAPH
	{0x6B5F,	0xC26A},	// CJK UNIFIED IDEOGRAPH
	{0x6B60,	0xF259},	// CJK UNIFIED IDEOGRAPH
	{0x6B61,	0xC577},	// CJK UNIFIED IDEOGRAPH
	{0x6B62,	0xA4EE},	// CJK UNIFIED IDEOGRAPH
	{0x6B63,	0xA5BF},	// CJK UNIFIED IDEOGRAPH
	{0x6B64,	0xA6B9},	// CJK UNIFIED IDEOGRAPH
	{0x6B65,	0xA842},	// CJK UNIFIED IDEOGRAPH
	{0x6B66,	0xAA5A},	// CJK UNIFIED IDEOGRAPH
	{0x6B67,	0xAA5B},	// CJK UNIFIED IDEOGRAPH
	{0x6B6A,	0xAC6E},	// CJK UNIFIED IDEOGRAPH
	{0x6B6D,	0xD1FA},	// CJK UNIFIED IDEOGRAPH
	{0x6B72,	0xB7B3},	// CJK UNIFIED IDEOGRAPH
	{0x6B76,	0xE6D1},	// CJK UNIFIED IDEOGRAPH
	{0x6B77,	0xBEFA},	// CJK UNIFIED IDEOGRAPH
	{0x6B78,	0xC26B},	// CJK UNIFIED IDEOGRAPH
	{0x6B79,	0xA4EF},	// CJK UNIFIED IDEOGRAPH
	{0x6B7B,	0xA6BA},	// CJK UNIFIED IDEOGRAPH
	{0x6B7E,	0xCCEB},	// CJK UNIFIED IDEOGRAPH
	{0x6B7F,	0xAA5C},	// CJK UNIFIED IDEOGRAPH
	{0x6B80,	0xCCEA},	// CJK UNIFIED IDEOGRAPH
	{0x6B82,	0xCF65},	// CJK UNIFIED IDEOGRAPH
	{0x6B83,	0xAC6F},	// CJK UNIFIED IDEOGRAPH
	{0x6B84,	0xCF66},	// CJK UNIFIED IDEOGRAPH
	{0x6B86,	0xAC70},	// CJK UNIFIED IDEOGRAPH
	{0x6B88,	0xD1FC},	// CJK UNIFIED IDEOGRAPH
	{0x6B89,	0xAEEE},	// CJK UNIFIED IDEOGRAPH
	{0x6B8A,	0xAEED},	// CJK UNIFIED IDEOGRAPH
	{0x6B8C,	0xD5DE},	// CJK UNIFIED IDEOGRAPH
	{0x6B8D,	0xD5DC},	// CJK UNIFIED IDEOGRAPH
	{0x6B8E,	0xD5DD},	// CJK UNIFIED IDEOGRAPH
	{0x6B8F,	0xD5DB},	// CJK UNIFIED IDEOGRAPH
	{0x6B91,	0xD5DA},	// CJK UNIFIED IDEOGRAPH
	{0x6B94,	0xD9DE},	// CJK UNIFIED IDEOGRAPH
	{0x6B95,	0xD9E1},	// CJK UNIFIED IDEOGRAPH
	{0x6B96,	0xB4DE},	// CJK UNIFIED IDEOGRAPH
	{0x6B97,	0xD9DF},	// CJK UNIFIED IDEOGRAPH
	{0x6B98,	0xB4DD},	// CJK UNIFIED IDEOGRAPH
	{0x6B99,	0xD9E0},	// CJK UNIFIED IDEOGRAPH
	{0x6B9B,	0xDDFB},	// CJK UNIFIED IDEOGRAPH
	{0x6B9E,	0xE266},	// CJK UNIFIED IDEOGRAPH
	{0x6B9F,	0xE267},	// CJK UNIFIED IDEOGRAPH
	{0x6BA0,	0xE268},	// CJK UNIFIED IDEOGRAPH
	{0x6BA2,	0xE5F3},	// CJK UNIFIED IDEOGRAPH
	{0x6BA3,	0xE5F2},	// CJK UNIFIED IDEOGRAPH
	{0x6BA4,	0xBCDC},	// CJK UNIFIED IDEOGRAPH
	{0x6BA5,	0xE5F1},	// CJK UNIFIED IDEOGRAPH
	{0x6BA6,	0xE5F4},	// CJK UNIFIED IDEOGRAPH
	{0x6BA7,	0xE9E1},	// CJK UNIFIED IDEOGRAPH
	{0x6BAA,	0xE9E2},	// CJK UNIFIED IDEOGRAPH
	{0x6BAB,	0xE9E3},	// CJK UNIFIED IDEOGRAPH
	{0x6BAD,	0xED4C},	// CJK UNIFIED IDEOGRAPH
	{0x6BAE,	0xC0D4},	// CJK UNIFIED IDEOGRAPH
	{0x6BAF,	0xC26C},	// CJK UNIFIED IDEOGRAPH
	{0x6BB0,	0xF25A},	// CJK UNIFIED IDEOGRAPH
	{0x6BB2,	0xC4E8},	// CJK UNIFIED IDEOGRAPH
	{0x6BB3,	0xC95F},	// CJK UNIFIED IDEOGRAPH
	{0x6BB5,	0xAC71},	// CJK UNIFIED IDEOGRAPH
	{0x6BB6,	0xCF67},	// CJK UNIFIED IDEOGRAPH
	{0x6BB7,	0xAEEF},	// CJK UNIFIED IDEOGRAPH
	{0x6BBA,	0xB1FE},	// CJK UNIFIED IDEOGRAPH
	{0x6BBC,	0xB4DF},	// CJK UNIFIED IDEOGRAPH
	{0x6BBD,	0xD9E2},	// CJK UNIFIED IDEOGRAPH
	{0x6BBF,	0xB7B5},	// CJK UNIFIED IDEOGRAPH
	{0x6BC0,	0xB7B4},	// CJK UNIFIED IDEOGRAPH
	{0x6BC3,	0xE269},	// CJK UNIFIED IDEOGRAPH
	{0x6BC4,	0xE26A},	// CJK UNIFIED IDEOGRAPH
	{0x6BC5,	0xBCDD},	// CJK UNIFIED IDEOGRAPH
	{0x6BC6,	0xBCDE},	// CJK UNIFIED IDEOGRAPH
	{0x6BC7,	0xE9E5},	// CJK UNIFIED IDEOGRAPH
	{0x6BC8,	0xE9E4},	// CJK UNIFIED IDEOGRAPH
	{0x6BC9,	0xEFE9},	// CJK UNIFIED IDEOGRAPH
	{0x6BCA,	0xF7E3},	// CJK UNIFIED IDEOGRAPH
	{0x6BCB,	0xA4F0},	// CJK UNIFIED IDEOGRAPH
	{0x6BCC,	0xC960},	// CJK UNIFIED IDEOGRAPH
	{0x6BCD,	0xA5C0},	// CJK UNIFIED IDEOGRAPH
	{0x6BCF,	0xA843},	// CJK UNIFIED IDEOGRAPH
	{0x6BD0,	0xCB48},	// CJK UNIFIED IDEOGRAPH
	{0x6BD2,	0xAC72},	// CJK UNIFIED IDEOGRAPH
	{0x6BD3,	0xB7B6},	// CJK UNIFIED IDEOGRAPH
	{0x6BD4,	0xA4F1},	// CJK UNIFIED IDEOGRAPH
	{0x6BD6,	0xCF68},	// CJK UNIFIED IDEOGRAPH
	{0x6BD7,	0xAC73},	// CJK UNIFIED IDEOGRAPH
	{0x6BD8,	0xCF69},	// CJK UNIFIED IDEOGRAPH
	{0x6BDA,	0xC0D5},	// CJK UNIFIED IDEOGRAPH
	{0x6BDB,	0xA4F2},	// CJK UNIFIED IDEOGRAPH
	{0x6BDE,	0xCCEC},	// CJK UNIFIED IDEOGRAPH
	{0x6BE0,	0xCF6A},	// CJK UNIFIED IDEOGRAPH
	{0x6BE2,	0xD242},	// CJK UNIFIED IDEOGRAPH
	{0x6BE3,	0xD241},	// CJK UNIFIED IDEOGRAPH
	{0x6BE4,	0xD1FE},	// CJK UNIFIED IDEOGRAPH
	{0x6BE6,	0xD1FD},	// CJK UNIFIED IDEOGRAPH
	{0x6BE7,	0xD243},	// CJK UNIFIED IDEOGRAPH
	{0x6BE8,	0xD240},	// CJK UNIFIED IDEOGRAPH
	{0x6BEB,	0xB240},	// CJK UNIFIED IDEOGRAPH
	{0x6BEC,	0xB241},	// CJK UNIFIED IDEOGRAPH
	{0x6BEF,	0xB4E0},	// CJK UNIFIED IDEOGRAPH
	{0x6BF0,	0xD9E3},	// CJK UNIFIED IDEOGRAPH
	{0x6BF2,	0xD9E4},	// CJK UNIFIED IDEOGRAPH
	{0x6BF3,	0xD9E5},	// CJK UNIFIED IDEOGRAPH
	{0x6BF7,	0xDE41},	// CJK UNIFIED IDEOGRAPH
	{0x6BF8,	0xDE42},	// CJK UNIFIED IDEOGRAPH
	{0x6BF9,	0xDE40},	// CJK UNIFIED IDEOGRAPH
	{0x6BFB,	0xDDFD},	// CJK UNIFIED IDEOGRAPH
	{0x6BFC,	0xDDFE},	// CJK UNIFIED IDEOGRAPH
	{0x6BFD,	0xB7B7},	// CJK UNIFIED IDEOGRAPH
	{0x6BFE,	0xE26B},	// CJK UNIFIED IDEOGRAPH
	{0x6BFF,	0xE5F7},	// CJK UNIFIED IDEOGRAPH
	{0x6C00,	0xE5F6},	// CJK UNIFIED IDEOGRAPH
	{0x6C01,	0xE5F5},	// CJK UNIFIED IDEOGRAPH
	{0x6C02,	0xE5F8},	// CJK UNIFIED IDEOGRAPH
	{0x6C03,	0xE9E7},	// CJK UNIFIED IDEOGRAPH
	{0x6C04,	0xE9E6},	// CJK UNIFIED IDEOGRAPH
	{0x6C05,	0xBEFB},	// CJK UNIFIED IDEOGRAPH
	{0x6C06,	0xE9E8},	// CJK UNIFIED IDEOGRAPH
	{0x6C08,	0xC0D6},	// CJK UNIFIED IDEOGRAPH
	{0x6C09,	0xED4D},	// CJK UNIFIED IDEOGRAPH
	{0x6C0B,	0xEFEA},	// CJK UNIFIED IDEOGRAPH
	{0x6C0C,	0xF25B},	// CJK UNIFIED IDEOGRAPH
	{0x6C0D,	0xF6E7},	// CJK UNIFIED IDEOGRAPH
	{0x6C0F,	0xA4F3},	// CJK UNIFIED IDEOGRAPH
	{0x6C10,	0xA5C2},	// CJK UNIFIED IDEOGRAPH
	{0x6C11,	0xA5C1},	// CJK UNIFIED IDEOGRAPH
	{0x6C13,	0xAA5D},	// CJK UNIFIED IDEOGRAPH
	{0x6C14,	0xC961},	// CJK UNIFIED IDEOGRAPH
	{0x6C15,	0xC97E},	// CJK UNIFIED IDEOGRAPH
	{0x6C16,	0xA6BB},	// CJK UNIFIED IDEOGRAPH
	{0x6C18,	0xC9F7},	// CJK UNIFIED IDEOGRAPH
	{0x6C19,	0xCB49},	// CJK UNIFIED IDEOGRAPH
	{0x6C1A,	0xCB4A},	// CJK UNIFIED IDEOGRAPH
	{0x6C1B,	0xAA5E},	// CJK UNIFIED IDEOGRAPH
	{0x6C1D,	0xCCED},	// CJK UNIFIED IDEOGRAPH
	{0x6C1F,	0xAC74},	// CJK UNIFIED IDEOGRAPH
	{0x6C20,	0xCF6B},	// CJK UNIFIED IDEOGRAPH
	{0x6C21,	0xCF6C},	// CJK UNIFIED IDEOGRAPH
	{0x6C23,	0xAEF0},	// CJK UNIFIED IDEOGRAPH
	{0x6C24,	0xAEF4},	// CJK UNIFIED IDEOGRAPH
	{0x6C25,	0xD244},	// CJK UNIFIED IDEOGRAPH
	{0x6C26,	0xAEF3},	// CJK UNIFIED IDEOGRAPH
	{0x6C27,	0xAEF1},	// CJK UNIFIED IDEOGRAPH
	{0x6C28,	0xAEF2},	// CJK UNIFIED IDEOGRAPH
	{0x6C2A,	0xD5DF},	// CJK UNIFIED IDEOGRAPH
	{0x6C2B,	0xB242},	// CJK UNIFIED IDEOGRAPH
	{0x6C2C,	0xB4E3},	// CJK UNIFIED IDEOGRAPH
	{0x6C2E,	0xB4E1},	// CJK UNIFIED IDEOGRAPH
	{0x6C2F,	0xB4E2},	// CJK UNIFIED IDEOGRAPH
	{0x6C30,	0xD9E6},	// CJK UNIFIED IDEOGRAPH
	{0x6C33,	0xBA72},	// CJK UNIFIED IDEOGRAPH
	{0x6C34,	0xA4F4},	// CJK UNIFIED IDEOGRAPH
	{0x6C36,	0xC9A1},	// CJK UNIFIED IDEOGRAPH
	{0x6C38,	0xA5C3},	// CJK UNIFIED IDEOGRAPH
	{0x6C3B,	0xC9A4},	// CJK UNIFIED IDEOGRAPH
	{0x6C3E,	0xA5C6},	// CJK UNIFIED IDEOGRAPH
	{0x6C3F,	0xC9A3},	// CJK UNIFIED IDEOGRAPH
	{0x6C40,	0xA5C5},	// CJK UNIFIED IDEOGRAPH
	{0x6C41,	0xA5C4},	// CJK UNIFIED IDEOGRAPH
	{0x6C42,	0xA844},	// CJK UNIFIED IDEOGRAPH
	{0x6C43,	0xC9A2},	// CJK UNIFIED IDEOGRAPH
	{0x6C46,	0xC9F8},	// CJK UNIFIED IDEOGRAPH
	{0x6C4A,	0xC9FC},	// CJK UNIFIED IDEOGRAPH
	{0x6C4B,	0xC9FE},	// CJK UNIFIED IDEOGRAPH
	{0x6C4C,	0xCA40},	// CJK UNIFIED IDEOGRAPH
	{0x6C4D,	0xA6C5},	// CJK UNIFIED IDEOGRAPH
	{0x6C4E,	0xA6C6},	// CJK UNIFIED IDEOGRAPH
	{0x6C4F,	0xC9FB},	// CJK UNIFIED IDEOGRAPH
	{0x6C50,	0xA6C1},	// CJK UNIFIED IDEOGRAPH
	{0x6C52,	0xC9F9},	// CJK UNIFIED IDEOGRAPH
	{0x6C54,	0xC9FD},	// CJK UNIFIED IDEOGRAPH
	{0x6C55,	0xA6C2},	// CJK UNIFIED IDEOGRAPH
	{0x6C57,	0xA6BD},	// CJK UNIFIED IDEOGRAPH
	{0x6C59,	0xA6BE},	// CJK UNIFIED IDEOGRAPH
	{0x6C5B,	0xA6C4},	// CJK UNIFIED IDEOGRAPH
	{0x6C5C,	0xC9FA},	// CJK UNIFIED IDEOGRAPH
	{0x6C5D,	0xA6BC},	// CJK UNIFIED IDEOGRAPH
	{0x6C5E,	0xA845},	// CJK UNIFIED IDEOGRAPH
	{0x6C5F,	0xA6BF},	// CJK UNIFIED IDEOGRAPH
	{0x6C60,	0xA6C0},	// CJK UNIFIED IDEOGRAPH
	{0x6C61,	0xA6C3},	// CJK UNIFIED IDEOGRAPH
	{0x6C65,	0xCB5B},	// CJK UNIFIED IDEOGRAPH
	{0x6C66,	0xCB59},	// CJK UNIFIED IDEOGRAPH
	{0x6C67,	0xCB4C},	// CJK UNIFIED IDEOGRAPH
	{0x6C68,	0xA851},	// CJK UNIFIED IDEOGRAPH
	{0x6C69,	0xCB53},	// CJK UNIFIED IDEOGRAPH
	{0x6C6A,	0xA84C},	// CJK UNIFIED IDEOGRAPH
	{0x6C6B,	0xCB4D},	// CJK UNIFIED IDEOGRAPH
	{0x6C6D,	0xCB55},	// CJK UNIFIED IDEOGRAPH
	{0x6C6F,	0xCB52},	// CJK UNIFIED IDEOGRAPH
	{0x6C70,	0xA84F},	// CJK UNIFIED IDEOGRAPH
	{0x6C71,	0xCB51},	// CJK UNIFIED IDEOGRAPH
	{0x6C72,	0xA856},	// CJK UNIFIED IDEOGRAPH
	{0x6C73,	0xCB5A},	// CJK UNIFIED IDEOGRAPH
	{0x6C74,	0xA858},	// CJK UNIFIED IDEOGRAPH
	{0x6C76,	0xA85A},	// CJK UNIFIED IDEOGRAPH
	{0x6C78,	0xCB4B},	// CJK UNIFIED IDEOGRAPH
	{0x6C7A,	0xA84D},	// CJK UNIFIED IDEOGRAPH
	{0x6C7B,	0xCB5C},	// CJK UNIFIED IDEOGRAPH
	{0x6C7D,	0xA854},	// CJK UNIFIED IDEOGRAPH
	{0x6C7E,	0xA857},	// CJK UNIFIED IDEOGRAPH
	{0x6C80,	0xCD45},	// CJK UNIFIED IDEOGRAPH
	{0x6C81,	0xA847},	// CJK UNIFIED IDEOGRAPH
	{0x6C82,	0xA85E},	// CJK UNIFIED IDEOGRAPH
	{0x6C83,	0xA855},	// CJK UNIFIED IDEOGRAPH
	{0x6C84,	0xCB4E},	// CJK UNIFIED IDEOGRAPH
	{0x6C85,	0xA84A},	// CJK UNIFIED IDEOGRAPH
	{0x6C86,	0xA859},	// CJK UNIFIED IDEOGRAPH
	{0x6C87,	0xCB56},	// CJK UNIFIED IDEOGRAPH
	{0x6C88,	0xA848},	// CJK UNIFIED IDEOGRAPH
	{0x6C89,	0xA849},	// CJK UNIFIED IDEOGRAPH
	{0x6C8A,	0xCD43},	// CJK UNIFIED IDEOGRAPH
	{0x6C8B,	0xCB4F},	// CJK UNIFIED IDEOGRAPH
	{0x6C8C,	0xA850},	// CJK UNIFIED IDEOGRAPH
	{0x6C8D,	0xA85B},	// CJK UNIFIED IDEOGRAPH
	{0x6C8E,	0xCB5D},	// CJK UNIFIED IDEOGRAPH
	{0x6C8F,	0xCB50},	// CJK UNIFIED IDEOGRAPH
	{0x6C90,	0xA84E},	// CJK UNIFIED IDEOGRAPH
	{0x6C92,	0xA853},	// CJK UNIFIED IDEOGRAPH
	{0x6C93,	0xCCEE},	// CJK UNIFIED IDEOGRAPH
	{0x6C94,	0xA85C},	// CJK UNIFIED IDEOGRAPH
	{0x6C95,	0xCB57},	// CJK UNIFIED IDEOGRAPH
	{0x6C96,	0xA852},	// CJK UNIFIED IDEOGRAPH
	{0x6C98,	0xA85D},	// CJK UNIFIED IDEOGRAPH
	{0x6C99,	0xA846},	// CJK UNIFIED IDEOGRAPH
	{0x6C9A,	0xCB54},	// CJK UNIFIED IDEOGRAPH
	{0x6C9B,	0xA84B},	// CJK UNIFIED IDEOGRAPH
	{0x6C9C,	0xCB58},	// CJK UNIFIED IDEOGRAPH
	{0x6C9D,	0xCD44},	// CJK UNIFIED IDEOGRAPH
	{0x6CAB,	0xAA6A},	// CJK UNIFIED IDEOGRAPH
	{0x6CAC,	0xAA7A},	// CJK UNIFIED IDEOGRAPH
	{0x6CAD,	0xCCF5},	// CJK UNIFIED IDEOGRAPH
	{0x6CAE,	0xAA71},	// CJK UNIFIED IDEOGRAPH
	{0x6CB0,	0xCD4B},	// CJK UNIFIED IDEOGRAPH
	{0x6CB1,	0xAA62},	// CJK UNIFIED IDEOGRAPH
	{0x6CB3,	0xAA65},	// CJK UNIFIED IDEOGRAPH
	{0x6CB4,	0xCD42},	// CJK UNIFIED IDEOGRAPH
	{0x6CB6,	0xCCF3},	// CJK UNIFIED IDEOGRAPH
	{0x6CB7,	0xCCF7},	// CJK UNIFIED IDEOGRAPH
	{0x6CB8,	0xAA6D},	// CJK UNIFIED IDEOGRAPH
	{0x6CB9,	0xAA6F},	// CJK UNIFIED IDEOGRAPH
	{0x6CBA,	0xCCFA},	// CJK UNIFIED IDEOGRAPH
	{0x6CBB,	0xAA76},	// CJK UNIFIED IDEOGRAPH
	{0x6CBC,	0xAA68},	// CJK UNIFIED IDEOGRAPH
	{0x6CBD,	0xAA66},	// CJK UNIFIED IDEOGRAPH
	{0x6CBE,	0xAA67},	// CJK UNIFIED IDEOGRAPH
	{0x6CBF,	0xAA75},	// CJK UNIFIED IDEOGRAPH
	{0x6CC0,	0xCD47},	// CJK UNIFIED IDEOGRAPH
	{0x6CC1,	0xAA70},	// CJK UNIFIED IDEOGRAPH
	{0x6CC2,	0xCCF9},	// CJK UNIFIED IDEOGRAPH
	{0x6CC3,	0xCCFB},	// CJK UNIFIED IDEOGRAPH
	{0x6CC4,	0xAA6E},	// CJK UNIFIED IDEOGRAPH
	{0x6CC5,	0xAA73},	// CJK UNIFIED IDEOGRAPH
	{0x6CC6,	0xCCFC},	// CJK UNIFIED IDEOGRAPH
	{0x6CC7,	0xCD4A},	// CJK UNIFIED IDEOGRAPH
	{0x6CC9,	0xAC75},	// CJK UNIFIED IDEOGRAPH
	{0x6CCA,	0xAA79},	// CJK UNIFIED IDEOGRAPH
	{0x6CCC,	0xAA63},	// CJK UNIFIED IDEOGRAPH
	{0x6CCD,	0xCD49},	// CJK UNIFIED IDEOGRAPH
	{0x6CCF,	0xCD4D},	// CJK UNIFIED IDEOGRAPH
	{0x6CD0,	0xCCF8},	// CJK UNIFIED IDEOGRAPH
	{0x6CD1,	0xCD4F},	// CJK UNIFIED IDEOGRAPH
	{0x6CD2,	0xCD40},	// CJK UNIFIED IDEOGRAPH
	{0x6CD3,	0xAA6C},	// CJK UNIFIED IDEOGRAPH
	{0x6CD4,	0xCCF4},	// CJK UNIFIED IDEOGRAPH
	{0x6CD5,	0xAA6B},	// CJK UNIFIED IDEOGRAPH
	{0x6CD6,	0xAA7D},	// CJK UNIFIED IDEOGRAPH
	{0x6CD7,	0xAA72},	// CJK UNIFIED IDEOGRAPH
	{0x6CD9,	0xCCF2},	// CJK UNIFIED IDEOGRAPH
	{0x6CDA,	0xCF75},	// CJK UNIFIED IDEOGRAPH
	{0x6CDB,	0xAA78},	// CJK UNIFIED IDEOGRAPH
	{0x6CDC,	0xAA7C},	// CJK UNIFIED IDEOGRAPH
	{0x6CDD,	0xCD41},	// CJK UNIFIED IDEOGRAPH
	{0x6CDE,	0xCD46},	// CJK UNIFIED IDEOGRAPH
	{0x6CE0,	0xAA7E},	// CJK UNIFIED IDEOGRAPH
	{0x6CE1,	0xAA77},	// CJK UNIFIED IDEOGRAPH
	{0x6CE2,	0xAA69},	// CJK UNIFIED IDEOGRAPH
	{0x6CE3,	0xAA5F},	// CJK UNIFIED IDEOGRAPH
	{0x6CE5,	0xAA64},	// CJK UNIFIED IDEOGRAPH
	{0x6CE7,	0xCCF6},	// CJK UNIFIED IDEOGRAPH
	{0x6CE8,	0xAA60},	// CJK UNIFIED IDEOGRAPH
	{0x6CE9,	0xCD4E},	// CJK UNIFIED IDEOGRAPH
	{0x6CEB,	0xCCF0},	// CJK UNIFIED IDEOGRAPH
	{0x6CEC,	0xCCEF},	// CJK UNIFIED IDEOGRAPH
	{0x6CED,	0xCCFD},	// CJK UNIFIED IDEOGRAPH
	{0x6CEE,	0xCCF1},	// CJK UNIFIED IDEOGRAPH
	{0x6CEF,	0xAA7B},	// CJK UNIFIED IDEOGRAPH
	{0x6CF0,	0xAEF5},	// CJK UNIFIED IDEOGRAPH
	{0x6CF1,	0xAA74},	// CJK UNIFIED IDEOGRAPH
	{0x6CF2,	0xCCFE},	// CJK UNIFIED IDEOGRAPH
	{0x6CF3,	0xAA61},	// CJK UNIFIED IDEOGRAPH
	{0x6CF5,	0xACA6},	// CJK UNIFIED IDEOGRAPH
	{0x6CF9,	0xCD4C},	// CJK UNIFIED IDEOGRAPH
	{0x6D00,	0xCF7C},	// CJK UNIFIED IDEOGRAPH
	{0x6D01,	0xCFA1},	// CJK UNIFIED IDEOGRAPH
	{0x6D03,	0xCFA4},	// CJK UNIFIED IDEOGRAPH
	{0x6D04,	0xCF77},	// CJK UNIFIED IDEOGRAPH
	{0x6D07,	0xCFA7},	// CJK UNIFIED IDEOGRAPH
	{0x6D08,	0xCFAA},	// CJK UNIFIED IDEOGRAPH
	{0x6D09,	0xCFAC},	// CJK UNIFIED IDEOGRAPH
	{0x6D0A,	0xCF74},	// CJK UNIFIED IDEOGRAPH
	{0x6D0B,	0xAC76},	// CJK UNIFIED IDEOGRAPH
	{0x6D0C,	0xAC7B},	// CJK UNIFIED IDEOGRAPH
	{0x6D0D,	0xD249},	// CJK UNIFIED IDEOGRAPH
	{0x6D0E,	0xACAD},	// CJK UNIFIED IDEOGRAPH
	{0x6D0F,	0xCFA5},	// CJK UNIFIED IDEOGRAPH
	{0x6D10,	0xCFAD},	// CJK UNIFIED IDEOGRAPH
	{0x6D11,	0xCF7B},	// CJK UNIFIED IDEOGRAPH
	{0x6D12,	0xCF73},	// CJK UNIFIED IDEOGRAPH
	{0x6D16,	0xD264},	// CJK UNIFIED IDEOGRAPH
	{0x6D17,	0xAC7E},	// CJK UNIFIED IDEOGRAPH
	{0x6D18,	0xCFA2},	// CJK UNIFIED IDEOGRAPH
	{0x6D19,	0xCF78},	// CJK UNIFIED IDEOGRAPH
	{0x6D1A,	0xCF7A},	// CJK UNIFIED IDEOGRAPH
	{0x6D1B,	0xACA5},	// CJK UNIFIED IDEOGRAPH
	{0x6D1D,	0xCF7D},	// CJK UNIFIED IDEOGRAPH
	{0x6D1E,	0xAC7D},	// CJK UNIFIED IDEOGRAPH
	{0x6D1F,	0xCF70},	// CJK UNIFIED IDEOGRAPH
	{0x6D20,	0xCFA8},	// CJK UNIFIED IDEOGRAPH
	{0x6D22,	0xCFAB},	// CJK UNIFIED IDEOGRAPH
	{0x6D25,	0xAC7A},	// CJK UNIFIED IDEOGRAPH
	{0x6D27,	0xACA8},	// CJK UNIFIED IDEOGRAPH
	{0x6D28,	0xCF6D},	// CJK UNIFIED IDEOGRAPH
	{0x6D29,	0xACAA},	// CJK UNIFIED IDEOGRAPH
	{0x6D2A,	0xAC78},	// CJK UNIFIED IDEOGRAPH
	{0x6D2B,	0xACAE},	// CJK UNIFIED IDEOGRAPH
	{0x6D2C,	0xCFA9},	// CJK UNIFIED IDEOGRAPH
	{0x6D2D,	0xCF6F},	// CJK UNIFIED IDEOGRAPH
	{0x6D2E,	0xACAB},	// CJK UNIFIED IDEOGRAPH
	{0x6D2F,	0xD25E},	// CJK UNIFIED IDEOGRAPH
	{0x6D30,	0xCD48},	// CJK UNIFIED IDEOGRAPH
	{0x6D31,	0xAC7C},	// CJK UNIFIED IDEOGRAPH
	{0x6D32,	0xAC77},	// CJK UNIFIED IDEOGRAPH
	{0x6D33,	0xCF76},	// CJK UNIFIED IDEOGRAPH
	{0x6D34,	0xCF6E},	// CJK UNIFIED IDEOGRAPH
	{0x6D35,	0xACAC},	// CJK UNIFIED IDEOGRAPH
	{0x6D36,	0xACA4},	// CJK UNIFIED IDEOGRAPH
	{0x6D37,	0xCFA3},	// CJK UNIFIED IDEOGRAPH
	{0x6D38,	0xACA9},	// CJK UNIFIED IDEOGRAPH
	{0x6D39,	0xACA7},	// CJK UNIFIED IDEOGRAPH
	{0x6D3A,	0xCF79},	// CJK UNIFIED IDEOGRAPH
	{0x6D3B,	0xACA1},	// CJK UNIFIED IDEOGRAPH
	{0x6D3C,	0xCF71},	// CJK UNIFIED IDEOGRAPH
	{0x6D3D,	0xACA2},	// CJK UNIFIED IDEOGRAPH
	{0x6D3E,	0xACA3},	// CJK UNIFIED IDEOGRAPH
	{0x6D3F,	0xCF72},	// CJK UNIFIED IDEOGRAPH
	{0x6D40,	0xCFA6},	// CJK UNIFIED IDEOGRAPH
	{0x6D41,	0xAC79},	// CJK UNIFIED IDEOGRAPH
	{0x6D42,	0xCF7E},	// CJK UNIFIED IDEOGRAPH
	{0x6D58,	0xD24C},	// CJK UNIFIED IDEOGRAPH
	{0x6D59,	0xAEFD},	// CJK UNIFIED IDEOGRAPH
	{0x6D5A,	0xAF43},	// CJK UNIFIED IDEOGRAPH
	{0x6D5E,	0xD255},	// CJK UNIFIED IDEOGRAPH
	{0x6D5F,	0xD25B},	// CJK UNIFIED IDEOGRAPH
	{0x6D60,	0xD257},	// CJK UNIFIED IDEOGRAPH
	{0x6D61,	0xD24A},	// CJK UNIFIED IDEOGRAPH
	{0x6D62,	0xD24D},	// CJK UNIFIED IDEOGRAPH
	{0x6D63,	0xD246},	// CJK UNIFIED IDEOGRAPH
	{0x6D64,	0xD247},	// CJK UNIFIED IDEOGRAPH
	{0x6D65,	0xAF4A},	// CJK UNIFIED IDEOGRAPH
	{0x6D66,	0xAEFA},	// CJK UNIFIED IDEOGRAPH
	{0x6D67,	0xD256},	// CJK UNIFIED IDEOGRAPH
	{0x6D68,	0xD25F},	// CJK UNIFIED IDEOGRAPH
	{0x6D69,	0xAF45},	// CJK UNIFIED IDEOGRAPH
	{0x6D6A,	0xAEF6},	// CJK UNIFIED IDEOGRAPH
	{0x6D6C,	0xAF40},	// CJK UNIFIED IDEOGRAPH
	{0x6D6D,	0xD24E},	// CJK UNIFIED IDEOGRAPH
	{0x6D6E,	0xAF42},	// CJK UNIFIED IDEOGRAPH
	{0x6D6F,	0xD24F},	// CJK UNIFIED IDEOGRAPH
	{0x6D70,	0xD259},	// CJK UNIFIED IDEOGRAPH
	{0x6D74,	0xAF44},	// CJK UNIFIED IDEOGRAPH
	{0x6D75,	0xD268},	// CJK UNIFIED IDEOGRAPH
	{0x6D76,	0xD248},	// CJK UNIFIED IDEOGRAPH
	{0x6D77,	0xAEFC},	// CJK UNIFIED IDEOGRAPH
	{0x6D78,	0xAEFB},	// CJK UNIFIED IDEOGRAPH
	{0x6D79,	0xAF48},	// CJK UNIFIED IDEOGRAPH
	{0x6D7A,	0xD245},	// CJK UNIFIED IDEOGRAPH
	{0x6D7B,	0xD266},	// CJK UNIFIED IDEOGRAPH
	{0x6D7C,	0xD25A},	// CJK UNIFIED IDEOGRAPH
	{0x6D7D,	0xD267},	// CJK UNIFIED IDEOGRAPH
	{0x6D7E,	0xD261},	// CJK UNIFIED IDEOGRAPH
	{0x6D7F,	0xD253},	// CJK UNIFIED IDEOGRAPH
	{0x6D80,	0xD262},	// CJK UNIFIED IDEOGRAPH
	{0x6D82,	0xD25C},	// CJK UNIFIED IDEOGRAPH
	{0x6D83,	0xD265},	// CJK UNIFIED IDEOGRAPH
	{0x6D84,	0xD263},	// CJK UNIFIED IDEOGRAPH
	{0x6D85,	0xAF49},	// CJK UNIFIED IDEOGRAPH
	{0x6D86,	0xD254},	// CJK UNIFIED IDEOGRAPH
	{0x6D87,	0xAEF9},	// CJK UNIFIED IDEOGRAPH
	{0x6D88,	0xAEF8},	// CJK UNIFIED IDEOGRAPH
	{0x6D89,	0xAF41},	// CJK UNIFIED IDEOGRAPH
	{0x6D8A,	0xAF47},	// CJK UNIFIED IDEOGRAPH
	{0x6D8B,	0xD260},	// CJK UNIFIED IDEOGRAPH
	{0x6D8C,	0xAF46},	// CJK UNIFIED IDEOGRAPH
	{0x6D8D,	0xD251},	// CJK UNIFIED IDEOGRAPH
	{0x6D8E,	0xB243},	// CJK UNIFIED IDEOGRAPH
	{0x6D90,	0xD269},	// CJK UNIFIED IDEOGRAPH
	{0x6D91,	0xD250},	// CJK UNIFIED IDEOGRAPH
	{0x6D92,	0xD24B},	// CJK UNIFIED IDEOGRAPH
	{0x6D93,	0xAEFE},	// CJK UNIFIED IDEOGRAPH
	{0x6D94,	0xAF4B},	// CJK UNIFIED IDEOGRAPH
	{0x6D95,	0xAEF7},	// CJK UNIFIED IDEOGRAPH
	{0x6D97,	0xD258},	// CJK UNIFIED IDEOGRAPH
	{0x6D98,	0xD25D},	// CJK UNIFIED IDEOGRAPH
	{0x6DAA,	0xB265},	// CJK UNIFIED IDEOGRAPH
	{0x6DAB,	0xD5E1},	// CJK UNIFIED IDEOGRAPH
	{0x6DAC,	0xD5E5},	// CJK UNIFIED IDEOGRAPH
	{0x6DAE,	0xB252},	// CJK UNIFIED IDEOGRAPH
	{0x6DAF,	0xB250},	// CJK UNIFIED IDEOGRAPH
	{0x6DB2,	0xB247},	// CJK UNIFIED IDEOGRAPH
	{0x6DB3,	0xD5E3},	// CJK UNIFIED IDEOGRAPH
	{0x6DB4,	0xD5E2},	// CJK UNIFIED IDEOGRAPH
	{0x6DB5,	0xB25B},	// CJK UNIFIED IDEOGRAPH
	{0x6DB7,	0xD5E8},	// CJK UNIFIED IDEOGRAPH
	{0x6DB8,	0xB255},	// CJK UNIFIED IDEOGRAPH
	{0x6DBA,	0xD5FA},	// CJK UNIFIED IDEOGRAPH
	{0x6DBB,	0xD647},	// CJK UNIFIED IDEOGRAPH
	{0x6DBC,	0xB244},	// CJK UNIFIED IDEOGRAPH
	{0x6DBD,	0xD5F7},	// CJK UNIFIED IDEOGRAPH
	{0x6DBE,	0xD5F0},	// CJK UNIFIED IDEOGRAPH
	{0x6DBF,	0xB267},	// CJK UNIFIED IDEOGRAPH
	{0x6DC0,	0xD5E0},	// CJK UNIFIED IDEOGRAPH
	{0x6DC2,	0xD5FC},	// CJK UNIFIED IDEOGRAPH
	{0x6DC4,	0xB264},	// CJK UNIFIED IDEOGRAPH
	{0x6DC5,	0xB258},	// CJK UNIFIED IDEOGRAPH
	{0x6DC6,	0xB263},	// CJK UNIFIED IDEOGRAPH
	{0x6DC7,	0xB24E},	// CJK UNIFIED IDEOGRAPH
	{0x6DC8,	0xD5EC},	// CJK UNIFIED IDEOGRAPH
	{0x6DC9,	0xD5FE},	// CJK UNIFIED IDEOGRAPH
	{0x6DCA,	0xD5F6},	// CJK UNIFIED IDEOGRAPH
	{0x6DCB,	0xB24F},	// CJK UNIFIED IDEOGRAPH
	{0x6DCC,	0xB249},	// CJK UNIFIED IDEOGRAPH
	{0x6DCD,	0xD645},	// CJK UNIFIED IDEOGRAPH
	{0x6DCF,	0xD5FD},	// CJK UNIFIED IDEOGRAPH
	{0x6DD0,	0xD640},	// CJK UNIFIED IDEOGRAPH
	{0x6DD1,	0xB251},	// CJK UNIFIED IDEOGRAPH
	{0x6DD2,	0xB259},	// CJK UNIFIED IDEOGRAPH
	{0x6DD3,	0xD642},	// CJK UNIFIED IDEOGRAPH
	{0x6DD4,	0xD5EA},	// CJK UNIFIED IDEOGRAPH
	{0x6DD5,	0xD5FB},	// CJK UNIFIED IDEOGRAPH
	{0x6DD6,	0xD5EF},	// CJK UNIFIED IDEOGRAPH
	{0x6DD7,	0xD644},	// CJK UNIFIED IDEOGRAPH
	{0x6DD8,	0xB25E},	// CJK UNIFIED IDEOGRAPH
	{0x6DD9,	0xB246},	// CJK UNIFIED IDEOGRAPH
	{0x6DDA,	0xB25C},	// CJK UNIFIED IDEOGRAPH
	{0x6DDB,	0xD5F4},	// CJK UNIFIED IDEOGRAPH
	{0x6DDC,	0xD5F2},	// CJK UNIFIED IDEOGRAPH
	{0x6DDD,	0xD5F3},	// CJK UNIFIED IDEOGRAPH
	{0x6DDE,	0xB253},	// CJK UNIFIED IDEOGRAPH
	{0x6DDF,	0xD5EE},	// CJK UNIFIED IDEOGRAPH
	{0x6DE0,	0xD5ED},	// CJK UNIFIED IDEOGRAPH
	{0x6DE1,	0xB248},	// CJK UNIFIED IDEOGRAPH
	{0x6DE2,	0xD5E7},	// CJK UNIFIED IDEOGRAPH
	{0x6DE3,	0xD646},	// CJK UNIFIED IDEOGRAPH
	{0x6DE4,	0xB24A},	// CJK UNIFIED IDEOGRAPH
	{0x6DE5,	0xD5F1},	// CJK UNIFIED IDEOGRAPH
	{0x6DE6,	0xB268},	// CJK UNIFIED IDEOGRAPH
	{0x6DE8,	0xB262},	// CJK UNIFIED IDEOGRAPH
	{0x6DE9,	0xD5E6},	// CJK UNIFIED IDEOGRAPH
	{0x6DEA,	0xB25F},	// CJK UNIFIED IDEOGRAPH
	{0x6DEB,	0xB25D},	// CJK UNIFIED IDEOGRAPH
	{0x6DEC,	0xB266},	// CJK UNIFIED IDEOGRAPH
	{0x6DED,	0xD5F8},	// CJK UNIFIED IDEOGRAPH
	{0x6DEE,	0xB261},	// CJK UNIFIED IDEOGRAPH
	{0x6DEF,	0xD252},	// CJK UNIFIED IDEOGRAPH
	{0x6DF0,	0xD5F9},	// CJK UNIFIED IDEOGRAPH
	{0x6DF1,	0xB260},	// CJK UNIFIED IDEOGRAPH
	{0x6DF2,	0xD641},	// CJK UNIFIED IDEOGRAPH
	{0x6DF3,	0xB245},	// CJK UNIFIED IDEOGRAPH
	{0x6DF4,	0xD5F5},	// CJK UNIFIED IDEOGRAPH
	{0x6DF5,	0xB257},	// CJK UNIFIED IDEOGRAPH
	{0x6DF6,	0xD5E9},	// CJK UNIFIED IDEOGRAPH
	{0x6DF7,	0xB256},	// CJK UNIFIED IDEOGRAPH
	{0x6DF9,	0xB254},	// CJK UNIFIED IDEOGRAPH
	{0x6DFA,	0xB24C},	// CJK UNIFIED IDEOGRAPH
	{0x6DFB,	0xB24B},	// CJK UNIFIED IDEOGRAPH
	{0x6DFC,	0xD9E7},	// CJK UNIFIED IDEOGRAPH
	{0x6DFD,	0xD643},	// CJK UNIFIED IDEOGRAPH
	{0x6E00,	0xD5EB},	// CJK UNIFIED IDEOGRAPH
	{0x6E03,	0xD9FC},	// CJK UNIFIED IDEOGRAPH
	{0x6E05,	0xB24D},	// CJK UNIFIED IDEOGRAPH
	{0x6E19,	0xB541},	// CJK UNIFIED IDEOGRAPH
	{0x6E1A,	0xB25A},	// CJK UNIFIED IDEOGRAPH
	{0x6E1B,	0xB4EE},	// CJK UNIFIED IDEOGRAPH
	{0x6E1C,	0xD9F6},	// CJK UNIFIED IDEOGRAPH
	{0x6E1D,	0xB4FC},	// CJK UNIFIED IDEOGRAPH
	{0x6E1F,	0xD9EA},	// CJK UNIFIED IDEOGRAPH
	{0x6E20,	0xB4EB},	// CJK UNIFIED IDEOGRAPH
	{0x6E21,	0xB4E7},	// CJK UNIFIED IDEOGRAPH
	{0x6E22,	0xDA49},	// CJK UNIFIED IDEOGRAPH
	{0x6E23,	0xB4ED},	// CJK UNIFIED IDEOGRAPH
	{0x6E24,	0xB4F1},	// CJK UNIFIED IDEOGRAPH
	{0x6E25,	0xB4EC},	// CJK UNIFIED IDEOGRAPH
	{0x6E26,	0xB4F5},	// CJK UNIFIED IDEOGRAPH
	{0x6E27,	0xDA4D},	// CJK UNIFIED IDEOGRAPH
	{0x6E28,	0xDA44},	// CJK UNIFIED IDEOGRAPH
	{0x6E2B,	0xD9F1},	// CJK UNIFIED IDEOGRAPH
	{0x6E2C,	0xB4FA},	// CJK UNIFIED IDEOGRAPH
	{0x6E2D,	0xB4F4},	// CJK UNIFIED IDEOGRAPH
	{0x6E2E,	0xD9FD},	// CJK UNIFIED IDEOGRAPH
	{0x6E2F,	0xB4E4},	// CJK UNIFIED IDEOGRAPH
	{0x6E30,	0xDA4A},	// CJK UNIFIED IDEOGRAPH
	{0x6E31,	0xDA43},	// CJK UNIFIED IDEOGRAPH
	{0x6E32,	0xB4E8},	// CJK UNIFIED IDEOGRAPH
	{0x6E33,	0xD9F7},	// CJK UNIFIED IDEOGRAPH
	{0x6E34,	0xB4F7},	// CJK UNIFIED IDEOGRAPH
	{0x6E35,	0xDA55},	// CJK UNIFIED IDEOGRAPH
	{0x6E36,	0xDA56},	// CJK UNIFIED IDEOGRAPH
	{0x6E38,	0xB4E5},	// CJK UNIFIED IDEOGRAPH
	{0x6E39,	0xDA48},	// CJK UNIFIED IDEOGRAPH
	{0x6E3A,	0xB4F9},	// CJK UNIFIED IDEOGRAPH
	{0x6E3B,	0xD9FB},	// CJK UNIFIED IDEOGRAPH
	{0x6E3C,	0xD9ED},	// CJK UNIFIED IDEOGRAPH
	{0x6E3D,	0xD9EE},	// CJK UNIFIED IDEOGRAPH
	{0x6E3E,	0xB4FD},	// CJK UNIFIED IDEOGRAPH
	{0x6E3F,	0xD9F2},	// CJK UNIFIED IDEOGRAPH
	{0x6E40,	0xD9F9},	// CJK UNIFIED IDEOGRAPH
	{0x6E41,	0xD9F3},	// CJK UNIFIED IDEOGRAPH
	{0x6E43,	0xB4FB},	// CJK UNIFIED IDEOGRAPH
	{0x6E44,	0xB544},	// CJK UNIFIED IDEOGRAPH
	{0x6E45,	0xD9EF},	// CJK UNIFIED IDEOGRAPH
	{0x6E46,	0xD9E8},	// CJK UNIFIED IDEOGRAPH
	{0x6E47,	0xD9E9},	// CJK UNIFIED IDEOGRAPH
	{0x6E49,	0xD9EB},	// CJK UNIFIED IDEOGRAPH
	{0x6E4A,	0xB4EA},	// CJK UNIFIED IDEOGRAPH
	{0x6E4B,	0xD9F8},	// CJK UNIFIED IDEOGRAPH
	{0x6E4D,	0xB4F8},	// CJK UNIFIED IDEOGRAPH
	{0x6E4E,	0xB542},	// CJK UNIFIED IDEOGRAPH
	{0x6E51,	0xD9FA},	// CJK UNIFIED IDEOGRAPH
	{0x6E52,	0xDA53},	// CJK UNIFIED IDEOGRAPH
	{0x6E53,	0xDA4B},	// CJK UNIFIED IDEOGRAPH
	{0x6E54,	0xB4E6},	// CJK UNIFIED IDEOGRAPH
	{0x6E55,	0xDA51},	// CJK UNIFIED IDEOGRAPH
	{0x6E56,	0xB4F2},	// CJK UNIFIED IDEOGRAPH
	{0x6E58,	0xB4F0},	// CJK UNIFIED IDEOGRAPH
	{0x6E5A,	0xDA57},	// CJK UNIFIED IDEOGRAPH
	{0x6E5B,	0xB4EF},	// CJK UNIFIED IDEOGRAPH
	{0x6E5C,	0xDA41},	// CJK UNIFIED IDEOGRAPH
	{0x6E5D,	0xD9F4},	// CJK UNIFIED IDEOGRAPH
	{0x6E5E,	0xD9FE},	// CJK UNIFIED IDEOGRAPH
	{0x6E5F,	0xB547},	// CJK UNIFIED IDEOGRAPH
	{0x6E60,	0xDA45},	// CJK UNIFIED IDEOGRAPH
	{0x6E61,	0xDA42},	// CJK UNIFIED IDEOGRAPH
	{0x6E62,	0xD9F0},	// CJK UNIFIED IDEOGRAPH
	{0x6E63,	0xB543},	// CJK UNIFIED IDEOGRAPH
	{0x6E64,	0xDA4F},	// CJK UNIFIED IDEOGRAPH
	{0x6E65,	0xDA4C},	// CJK UNIFIED IDEOGRAPH
	{0x6E66,	0xDA54},	// CJK UNIFIED IDEOGRAPH
	{0x6E67,	0xB4E9},	// CJK UNIFIED IDEOGRAPH
	{0x6E68,	0xDA40},	// CJK UNIFIED IDEOGRAPH
	{0x6E69,	0xB546},	// CJK UNIFIED IDEOGRAPH
	{0x6E6B,	0xDA47},	// CJK UNIFIED IDEOGRAPH
	{0x6E6E,	0xB4F3},	// CJK UNIFIED IDEOGRAPH
	{0x6E6F,	0xB4F6},	// CJK UNIFIED IDEOGRAPH
	{0x6E71,	0xDA46},	// CJK UNIFIED IDEOGRAPH
	{0x6E72,	0xB545},	// CJK UNIFIED IDEOGRAPH
	{0x6E73,	0xD9F5},	// CJK UNIFIED IDEOGRAPH
	{0x6E74,	0xD5E4},	// CJK UNIFIED IDEOGRAPH
	{0x6E77,	0xDA50},	// CJK UNIFIED IDEOGRAPH
	{0x6E78,	0xDA4E},	// CJK UNIFIED IDEOGRAPH
	{0x6E79,	0xDA52},	// CJK UNIFIED IDEOGRAPH
	{0x6E88,	0xD9EC},	// CJK UNIFIED IDEOGRAPH
	{0x6E89,	0xB540},	// CJK UNIFIED IDEOGRAPH
	{0x6E8D,	0xDE61},	// CJK UNIFIED IDEOGRAPH
	{0x6E8E,	0xDE60},	// CJK UNIFIED IDEOGRAPH
	{0x6E8F,	0xDE46},	// CJK UNIFIED IDEOGRAPH
	{0x6E90,	0xB7BD},	// CJK UNIFIED IDEOGRAPH
	{0x6E92,	0xDE5F},	// CJK UNIFIED IDEOGRAPH
	{0x6E93,	0xDE49},	// CJK UNIFIED IDEOGRAPH
	{0x6E94,	0xDE4A},	// CJK UNIFIED IDEOGRAPH
	{0x6E96,	0xB7C7},	// CJK UNIFIED IDEOGRAPH
	{0x6E97,	0xDE68},	// CJK UNIFIED IDEOGRAPH
	{0x6E98,	0xB7C2},	// CJK UNIFIED IDEOGRAPH
	{0x6E99,	0xDE5E},	// CJK UNIFIED IDEOGRAPH
	{0x6E9B,	0xDE43},	// CJK UNIFIED IDEOGRAPH
	{0x6E9C,	0xB7C8},	// CJK UNIFIED IDEOGRAPH
	{0x6E9D,	0xB7BE},	// CJK UNIFIED IDEOGRAPH
	{0x6E9E,	0xDE52},	// CJK UNIFIED IDEOGRAPH
	{0x6E9F,	0xDE48},	// CJK UNIFIED IDEOGRAPH
	{0x6EA0,	0xDE4B},	// CJK UNIFIED IDEOGRAPH
	{0x6EA1,	0xDE63},	// CJK UNIFIED IDEOGRAPH
	{0x6EA2,	0xB7B8},	// CJK UNIFIED IDEOGRAPH
	{0x6EA3,	0xDE6A},	// CJK UNIFIED IDEOGRAPH
	{0x6EA4,	0xDE62},	// CJK UNIFIED IDEOGRAPH
	{0x6EA5,	0xB7C1},	// CJK UNIFIED IDEOGRAPH
	{0x6EA6,	0xDE57},	// CJK UNIFIED IDEOGRAPH
	{0x6EA7,	0xB7CC},	// CJK UNIFIED IDEOGRAPH
	{0x6EAA,	0xB7CB},	// CJK UNIFIED IDEOGRAPH
	{0x6EAB,	0xB7C5},	// CJK UNIFIED IDEOGRAPH
	{0x6EAE,	0xDE69},	// CJK UNIFIED IDEOGRAPH
	{0x6EAF,	0xB7B9},	// CJK UNIFIED IDEOGRAPH
	{0x6EB0,	0xDE55},	// CJK UNIFIED IDEOGRAPH
	{0x6EB1,	0xDE4C},	// CJK UNIFIED IDEOGRAPH
	{0x6EB2,	0xDE59},	// CJK UNIFIED IDEOGRAPH
	{0x6EB3,	0xDE65},	// CJK UNIFIED IDEOGRAPH
	{0x6EB4,	0xB7CD},	// CJK UNIFIED IDEOGRAPH
	{0x6EB6,	0xB7BB},	// CJK UNIFIED IDEOGRAPH
	{0x6EB7,	0xDE54},	// CJK UNIFIED IDEOGRAPH
	{0x6EB9,	0xDE4D},	// CJK UNIFIED IDEOGRAPH
	{0x6EBA,	0xB7C4},	// CJK UNIFIED IDEOGRAPH
	{0x6EBC,	0xB7C3},	// CJK UNIFIED IDEOGRAPH
	{0x6EBD,	0xDE50},	// CJK UNIFIED IDEOGRAPH
	{0x6EBE,	0xDE5A},	// CJK UNIFIED IDEOGRAPH
	{0x6EBF,	0xDE64},	// CJK UNIFIED IDEOGRAPH
	{0x6EC0,	0xDE47},	// CJK UNIFIED IDEOGRAPH
	{0x6EC1,	0xDE51},	// CJK UNIFIED IDEOGRAPH
	{0x6EC2,	0xB7BC},	// CJK UNIFIED IDEOGRAPH
	{0x6EC3,	0xDE5B},	// CJK UNIFIED IDEOGRAPH
	{0x6EC4,	0xB7C9},	// CJK UNIFIED IDEOGRAPH
	{0x6EC5,	0xB7C0},	// CJK UNIFIED IDEOGRAPH
	{0x6EC6,	0xDE4E},	// CJK UNIFIED IDEOGRAPH
	{0x6EC7,	0xB7BF},	// CJK UNIFIED IDEOGRAPH
	{0x6EC8,	0xDE45},	// CJK UNIFIED IDEOGRAPH
	{0x6EC9,	0xDE53},	// CJK UNIFIED IDEOGRAPH
	{0x6ECA,	0xDE67},	// CJK UNIFIED IDEOGRAPH
	{0x6ECB,	0xB4FE},	// CJK UNIFIED IDEOGRAPH
	{0x6ECC,	0xBAB0},	// CJK UNIFIED IDEOGRAPH
	{0x6ECD,	0xDE56},	// CJK UNIFIED IDEOGRAPH
	{0x6ECE,	0xE26C},	// CJK UNIFIED IDEOGRAPH
	{0x6ECF,	0xDE58},	// CJK UNIFIED IDEOGRAPH
	{0x6ED0,	0xDE66},	// CJK UNIFIED IDEOGRAPH
	{0x6ED1,	0xB7C6},	// CJK UNIFIED IDEOGRAPH
	{0x6ED2,	0xDE4F},	// CJK UNIFIED IDEOGRAPH
	{0x6ED3,	0xB7BA},	// CJK UNIFIED IDEOGRAPH
	{0x6ED4,	0xB7CA},	// CJK UNIFIED IDEOGRAPH
	{0x6ED5,	0xBCF0},	// CJK UNIFIED IDEOGRAPH
	{0x6ED6,	0xDE44},	// CJK UNIFIED IDEOGRAPH
	{0x6ED8,	0xDE5D},	// CJK UNIFIED IDEOGRAPH
	{0x6EDC,	0xDE5C},	// CJK UNIFIED IDEOGRAPH
	{0x6EEB,	0xE2AA},	// CJK UNIFIED IDEOGRAPH
	{0x6EEC,	0xBAAD},	// CJK UNIFIED IDEOGRAPH
	{0x6EED,	0xE27D},	// CJK UNIFIED IDEOGRAPH
	{0x6EEE,	0xE2A4},	// CJK UNIFIED IDEOGRAPH
	{0x6EEF,	0xBAA2},	// CJK UNIFIED IDEOGRAPH
	{0x6EF1,	0xE26E},	// CJK UNIFIED IDEOGRAPH
	{0x6EF2,	0xBAAF},	// CJK UNIFIED IDEOGRAPH
	{0x6EF4,	0xBA77},	// CJK UNIFIED IDEOGRAPH
	{0x6EF5,	0xE26D},	// CJK UNIFIED IDEOGRAPH
	{0x6EF6,	0xE2B0},	// CJK UNIFIED IDEOGRAPH
	{0x6EF7,	0xBAB1},	// CJK UNIFIED IDEOGRAPH
	{0x6EF8,	0xE271},	// CJK UNIFIED IDEOGRAPH
	{0x6EF9,	0xE2A3},	// CJK UNIFIED IDEOGRAPH
	{0x6EFB,	0xE273},	// CJK UNIFIED IDEOGRAPH
	{0x6EFC,	0xE2B3},	// CJK UNIFIED IDEOGRAPH
	{0x6EFD,	0xE2AF},	// CJK UNIFIED IDEOGRAPH
	{0x6EFE,	0xBA75},	// CJK UNIFIED IDEOGRAPH
	{0x6EFF,	0xBAA1},	// CJK UNIFIED IDEOGRAPH
	{0x6F00,	0xE653},	// CJK UNIFIED IDEOGRAPH
	{0x6F01,	0xBAAE},	// CJK UNIFIED IDEOGRAPH
	{0x6F02,	0xBA7D},	// CJK UNIFIED IDEOGRAPH
	{0x6F03,	0xE26F},	// CJK UNIFIED IDEOGRAPH
	{0x6F05,	0xE2AE},	// CJK UNIFIED IDEOGRAPH
	{0x6F06,	0xBAA3},	// CJK UNIFIED IDEOGRAPH
	{0x6F07,	0xE2AB},	// CJK UNIFIED IDEOGRAPH
	{0x6F08,	0xE2B8},	// CJK UNIFIED IDEOGRAPH
	{0x6F09,	0xE275},	// CJK UNIFIED IDEOGRAPH
	{0x6F0A,	0xE27E},	// CJK UNIFIED IDEOGRAPH
	{0x6F0D,	0xE2B6},	// CJK UNIFIED IDEOGRAPH
	{0x6F0E,	0xE2AC},	// CJK UNIFIED IDEOGRAPH
	{0x6F0F,	0xBA7C},	// CJK UNIFIED IDEOGRAPH
	{0x6F12,	0xE27C},	// CJK UNIFIED IDEOGRAPH
	{0x6F13,	0xBA76},	// CJK UNIFIED IDEOGRAPH
	{0x6F14,	0xBA74},	// CJK UNIFIED IDEOGRAPH
	{0x6F15,	0xBAA8},	// CJK UNIFIED IDEOGRAPH
	{0x6F18,	0xE27A},	// CJK UNIFIED IDEOGRAPH
	{0x6F19,	0xE277},	// CJK UNIFIED IDEOGRAPH
	{0x6F1A,	0xE278},	// CJK UNIFIED IDEOGRAPH
	{0x6F1C,	0xE2B2},	// CJK UNIFIED IDEOGRAPH
	{0x6F1E,	0xE2B7},	// CJK UNIFIED IDEOGRAPH
	{0x6F1F,	0xE2B5},	// CJK UNIFIED IDEOGRAPH
	{0x6F20,	0xBA7A},	// CJK UNIFIED IDEOGRAPH
	{0x6F21,	0xE2B9},	// CJK UNIFIED IDEOGRAPH
	{0x6F22,	0xBA7E},	// CJK UNIFIED IDEOGRAPH
	{0x6F23,	0xBAA7},	// CJK UNIFIED IDEOGRAPH
	{0x6F25,	0xE270},	// CJK UNIFIED IDEOGRAPH
	{0x6F26,	0xE5FA},	// CJK UNIFIED IDEOGRAPH
	{0x6F27,	0xE279},	// CJK UNIFIED IDEOGRAPH
	{0x6F29,	0xBA78},	// CJK UNIFIED IDEOGRAPH
	{0x6F2A,	0xBAAC},	// CJK UNIFIED IDEOGRAPH
	{0x6F2B,	0xBAA9},	// CJK UNIFIED IDEOGRAPH
	{0x6F2C,	0xBA7B},	// CJK UNIFIED IDEOGRAPH
	{0x6F2D,	0xE2A5},	// CJK UNIFIED IDEOGRAPH
	{0x6F2E,	0xE274},	// CJK UNIFIED IDEOGRAPH
	{0x6F2F,	0xBAAA},	// CJK UNIFIED IDEOGRAPH
	{0x6F30,	0xE2A7},	// CJK UNIFIED IDEOGRAPH
	{0x6F31,	0xBAA4},	// CJK UNIFIED IDEOGRAPH
	{0x6F32,	0xBAA6},	// CJK UNIFIED IDEOGRAPH
	{0x6F33,	0xBA73},	// CJK UNIFIED IDEOGRAPH
	{0x6F35,	0xE2A9},	// CJK UNIFIED IDEOGRAPH
	{0x6F36,	0xE2A1},	// CJK UNIFIED IDEOGRAPH
	{0x6F37,	0xE272},	// CJK UNIFIED IDEOGRAPH
	{0x6F38,	0xBAA5},	// CJK UNIFIED IDEOGRAPH
	{0x6F39,	0xE2B1},	// CJK UNIFIED IDEOGRAPH
	{0x6F3A,	0xE2B4},	// CJK UNIFIED IDEOGRAPH
	{0x6F3B,	0xE27B},	// CJK UNIFIED IDEOGRAPH
	{0x6F3C,	0xE2A8},	// CJK UNIFIED IDEOGRAPH
	{0x6F3E,	0xBA79},	// CJK UNIFIED IDEOGRAPH
	{0x6F3F,	0xBCDF},	// CJK UNIFIED IDEOGRAPH
	{0x6F40,	0xE2A6},	// CJK UNIFIED IDEOGRAPH
	{0x6F41,	0xE5F9},	// CJK UNIFIED IDEOGRAPH
	{0x6F43,	0xE2AD},	// CJK UNIFIED IDEOGRAPH
	{0x6F4E,	0xE276},	// CJK UNIFIED IDEOGRAPH
	{0x6F4F,	0xE644},	// CJK UNIFIED IDEOGRAPH
	{0x6F50,	0xE64E},	// CJK UNIFIED IDEOGRAPH
	{0x6F51,	0xBCE2},	// CJK UNIFIED IDEOGRAPH
	{0x6F52,	0xE64D},	// CJK UNIFIED IDEOGRAPH
	{0x6F53,	0xE659},	// CJK UNIFIED IDEOGRAPH
	{0x6F54,	0xBCE4},	// CJK UNIFIED IDEOGRAPH
	{0x6F55,	0xE64B},	// CJK UNIFIED IDEOGRAPH
	{0x6F57,	0xE64F},	// CJK UNIFIED IDEOGRAPH
	{0x6F58,	0xBCEF},	// CJK UNIFIED IDEOGRAPH
	{0x6F5A,	0xE646},	// CJK UNIFIED IDEOGRAPH
	{0x6F5B,	0xBCE7},	// CJK UNIFIED IDEOGRAPH
	{0x6F5D,	0xE652},	// CJK UNIFIED IDEOGRAPH
	{0x6F5E,	0xE9F0},	// CJK UNIFIED IDEOGRAPH
	{0x6F5F,	0xBCF3},	// CJK UNIFIED IDEOGRAPH
	{0x6F60,	0xBCF2},	// CJK UNIFIED IDEOGRAPH
	{0x6F61,	0xE654},	// CJK UNIFIED IDEOGRAPH
	{0x6F62,	0xE643},	// CJK UNIFIED IDEOGRAPH
	{0x6F63,	0xE65E},	// CJK UNIFIED IDEOGRAPH
	{0x6F64,	0xBCED},	// CJK UNIFIED IDEOGRAPH
	{0x6F66,	0xBCE3},	// CJK UNIFIED IDEOGRAPH
	{0x6F67,	0xE657},	// CJK UNIFIED IDEOGRAPH
	{0x6F69,	0xE65B},	// CJK UNIFIED IDEOGRAPH
	{0x6F6A,	0xE660},	// CJK UNIFIED IDEOGRAPH
	{0x6F6B,	0xE655},	// CJK UNIFIED IDEOGRAPH
	{0x6F6C,	0xE649},	// CJK UNIFIED IDEOGRAPH
	{0x6F6D,	0xBCE6},	// CJK UNIFIED IDEOGRAPH
	{0x6F6E,	0xBCE9},	// CJK UNIFIED IDEOGRAPH
	{0x6F6F,	0xBCF1},	// CJK UNIFIED IDEOGRAPH
	{0x6F70,	0xBCEC},	// CJK UNIFIED IDEOGRAPH
	{0x6F72,	0xE64C},	// CJK UNIFIED IDEOGRAPH
	{0x6F73,	0xE2A2},	// CJK UNIFIED IDEOGRAPH
	{0x6F76,	0xE648},	// CJK UNIFIED IDEOGRAPH
	{0x6F77,	0xE65F},	// CJK UNIFIED IDEOGRAPH
	{0x6F78,	0xBCE8},	// CJK UNIFIED IDEOGRAPH
	{0x6F7A,	0xBCEB},	// CJK UNIFIED IDEOGRAPH
	{0x6F7B,	0xE661},	// CJK UNIFIED IDEOGRAPH
	{0x6F7C,	0xBCE0},	// CJK UNIFIED IDEOGRAPH
	{0x6F7D,	0xE656},	// CJK UNIFIED IDEOGRAPH
	{0x6F7E,	0xE5FB},	// CJK UNIFIED IDEOGRAPH
	{0x6F7F,	0xE65C},	// CJK UNIFIED IDEOGRAPH
	{0x6F80,	0xC0DF},	// CJK UNIFIED IDEOGRAPH
	{0x6F82,	0xE64A},	// CJK UNIFIED IDEOGRAPH
	{0x6F84,	0xBCE1},	// CJK UNIFIED IDEOGRAPH
	{0x6F85,	0xE645},	// CJK UNIFIED IDEOGRAPH
	{0x6F86,	0xBCE5},	// CJK UNIFIED IDEOGRAPH
	{0x6F87,	0xE5FC},	// CJK UNIFIED IDEOGRAPH
	{0x6F88,	0xBAAB},	// CJK UNIFIED IDEOGRAPH
	{0x6F89,	0xE641},	// CJK UNIFIED IDEOGRAPH
	{0x6F8B,	0xE65A},	// CJK UNIFIED IDEOGRAPH
	{0x6F8C,	0xE642},	// CJK UNIFIED IDEOGRAPH
	{0x6F8D,	0xE640},	// CJK UNIFIED IDEOGRAPH
	{0x6F8E,	0xBCEA},	// CJK UNIFIED IDEOGRAPH
	{0x6F90,	0xE658},	// CJK UNIFIED IDEOGRAPH
	{0x6F92,	0xE5FE},	// CJK UNIFIED IDEOGRAPH
	{0x6F93,	0xE651},	// CJK UNIFIED IDEOGRAPH
	{0x6F94,	0xE650},	// CJK UNIFIED IDEOGRAPH
	{0x6F95,	0xE65D},	// CJK UNIFIED IDEOGRAPH
	{0x6F96,	0xE647},	// CJK UNIFIED IDEOGRAPH
	{0x6F97,	0xBCEE},	// CJK UNIFIED IDEOGRAPH
	{0x6F9E,	0xE9F3},	// CJK UNIFIED IDEOGRAPH
	{0x6FA0,	0xBF49},	// CJK UNIFIED IDEOGRAPH
	{0x6FA1,	0xBEFE},	// CJK UNIFIED IDEOGRAPH
	{0x6FA2,	0xEA40},	// CJK UNIFIED IDEOGRAPH
	{0x6FA3,	0xE9EB},	// CJK UNIFIED IDEOGRAPH
	{0x6FA4,	0xBF41},	// CJK UNIFIED IDEOGRAPH
	{0x6FA5,	0xE9F7},	// CJK UNIFIED IDEOGRAPH
	{0x6FA6,	0xBF48},	// CJK UNIFIED IDEOGRAPH
	{0x6FA7,	0xBF43},	// CJK UNIFIED IDEOGRAPH
	{0x6FA8,	0xE9F5},	// CJK UNIFIED IDEOGRAPH
	{0x6FA9,	0xED4F},	// CJK UNIFIED IDEOGRAPH
	{0x6FAA,	0xE9FB},	// CJK UNIFIED IDEOGRAPH
	{0x6FAB,	0xEA42},	// CJK UNIFIED IDEOGRAPH
	{0x6FAC,	0xE9FA},	// CJK UNIFIED IDEOGRAPH
	{0x6FAD,	0xE9E9},	// CJK UNIFIED IDEOGRAPH
	{0x6FAE,	0xE9F8},	// CJK UNIFIED IDEOGRAPH
	{0x6FAF,	0xEA44},	// CJK UNIFIED IDEOGRAPH
	{0x6FB0,	0xEA46},	// CJK UNIFIED IDEOGRAPH
	{0x6FB1,	0xBEFD},	// CJK UNIFIED IDEOGRAPH
	{0x6FB2,	0xEA45},	// CJK UNIFIED IDEOGRAPH
	{0x6FB3,	0xBF44},	// CJK UNIFIED IDEOGRAPH
	{0x6FB4,	0xBF4A},	// CJK UNIFIED IDEOGRAPH
	{0x6FB6,	0xBF47},	// CJK UNIFIED IDEOGRAPH
	{0x6FB8,	0xE9FE},	// CJK UNIFIED IDEOGRAPH
	{0x6FB9,	0xBF46},	// CJK UNIFIED IDEOGRAPH
	{0x6FBA,	0xE9F9},	// CJK UNIFIED IDEOGRAPH
	{0x6FBC,	0xE9ED},	// CJK UNIFIED IDEOGRAPH
	{0x6FBD,	0xE9F2},	// CJK UNIFIED IDEOGRAPH
	{0x6FBF,	0xE9FD},	// CJK UNIFIED IDEOGRAPH
	{0x6FC0,	0xBF45},	// CJK UNIFIED IDEOGRAPH
	{0x6FC1,	0xBF42},	// CJK UNIFIED IDEOGRAPH
	{0x6FC2,	0xBEFC},	// CJK UNIFIED IDEOGRAPH
	{0x6FC3,	0xBF40},	// CJK UNIFIED IDEOGRAPH
	{0x6FC4,	0xE9F1},	// CJK UNIFIED IDEOGRAPH
	{0x6FC6,	0xE5FD},	// CJK UNIFIED IDEOGRAPH
	{0x6FC7,	0xE9EC},	// CJK UNIFIED IDEOGRAPH
	{0x6FC8,	0xE9EF},	// CJK UNIFIED IDEOGRAPH
	{0x6FC9,	0xEA41},	// CJK UNIFIED IDEOGRAPH
	{0x6FCA,	0xE9F4},	// CJK UNIFIED IDEOGRAPH
	{0x6FCB,	0xE9EA},	// CJK UNIFIED IDEOGRAPH
	{0x6FCC,	0xED4E},	// CJK UNIFIED IDEOGRAPH
	{0x6FCD,	0xEA43},	// CJK UNIFIED IDEOGRAPH
	{0x6FCE,	0xE9EE},	// CJK UNIFIED IDEOGRAPH
	{0x6FCF,	0xE9FC},	// CJK UNIFIED IDEOGRAPH
	{0x6FD4,	0xED51},	// CJK UNIFIED IDEOGRAPH
	{0x6FD5,	0xC0E3},	// CJK UNIFIED IDEOGRAPH
	{0x6FD8,	0xC0D7},	// CJK UNIFIED IDEOGRAPH
	{0x6FDB,	0xC0DB},	// CJK UNIFIED IDEOGRAPH
	{0x6FDC,	0xED53},	// CJK UNIFIED IDEOGRAPH
	{0x6FDD,	0xED59},	// CJK UNIFIED IDEOGRAPH
	{0x6FDE,	0xED57},	// CJK UNIFIED IDEOGRAPH
	{0x6FDF,	0xC0D9},	// CJK UNIFIED IDEOGRAPH
	{0x6FE0,	0xC0DA},	// CJK UNIFIED IDEOGRAPH
	{0x6FE1,	0xC0E1},	// CJK UNIFIED IDEOGRAPH
	{0x6FE2,	0xED5A},	// CJK UNIFIED IDEOGRAPH
	{0x6FE3,	0xED52},	// CJK UNIFIED IDEOGRAPH
	{0x6FE4,	0xC0DC},	// CJK UNIFIED IDEOGRAPH
	{0x6FE6,	0xED56},	// CJK UNIFIED IDEOGRAPH
	{0x6FE7,	0xED55},	// CJK UNIFIED IDEOGRAPH
	{0x6FE8,	0xED5B},	// CJK UNIFIED IDEOGRAPH
	{0x6FE9,	0xC0E2},	// CJK UNIFIED IDEOGRAPH
	{0x6FEB,	0xC0DD},	// CJK UNIFIED IDEOGRAPH
	{0x6FEC,	0xC0E0},	// CJK UNIFIED IDEOGRAPH
	{0x6FED,	0xED54},	// CJK UNIFIED IDEOGRAPH
	{0x6FEE,	0xC0E4},	// CJK UNIFIED IDEOGRAPH
	{0x6FEF,	0xC0DE},	// CJK UNIFIED IDEOGRAPH
	{0x6FF0,	0xC0E5},	// CJK UNIFIED IDEOGRAPH
	{0x6FF1,	0xC0D8},	// CJK UNIFIED IDEOGRAPH
	{0x6FF2,	0xED58},	// CJK UNIFIED IDEOGRAPH
	{0x6FF4,	0xED50},	// CJK UNIFIED IDEOGRAPH
	{0x6FF7,	0xEFF7},	// CJK UNIFIED IDEOGRAPH
	{0x6FFA,	0xC271},	// CJK UNIFIED IDEOGRAPH
	{0x6FFB,	0xEFF4},	// CJK UNIFIED IDEOGRAPH
	{0x6FFC,	0xEFF6},	// CJK UNIFIED IDEOGRAPH
	{0x6FFE,	0xC26F},	// CJK UNIFIED IDEOGRAPH
	{0x6FFF,	0xEFF2},	// CJK UNIFIED IDEOGRAPH
	{0x7000,	0xEFF3},	// CJK UNIFIED IDEOGRAPH
	{0x7001,	0xEFEE},	// CJK UNIFIED IDEOGRAPH
	{0x7004,	0xE9F6},	// CJK UNIFIED IDEOGRAPH
	{0x7005,	0xEFEF},	// CJK UNIFIED IDEOGRAPH
	{0x7006,	0xC270},	// CJK UNIFIED IDEOGRAPH
	{0x7007,	0xEFEB},	// CJK UNIFIED IDEOGRAPH
	{0x7009,	0xC26D},	// CJK UNIFIED IDEOGRAPH
	{0x700A,	0xEFF8},	// CJK UNIFIED IDEOGRAPH
	{0x700B,	0xC26E},	// CJK UNIFIED IDEOGRAPH
	{0x700C,	0xEFEC},	// CJK UNIFIED IDEOGRAPH
	{0x700D,	0xEFED},	// CJK UNIFIED IDEOGRAPH
	{0x700E,	0xEFF1},	// CJK UNIFIED IDEOGRAPH
	{0x700F,	0xC273},	// CJK UNIFIED IDEOGRAPH
	{0x7011,	0xC272},	// CJK UNIFIED IDEOGRAPH
	{0x7014,	0xEFF0},	// CJK UNIFIED IDEOGRAPH
	{0x7015,	0xC378},	// CJK UNIFIED IDEOGRAPH
	{0x7016,	0xF25F},	// CJK UNIFIED IDEOGRAPH
	{0x7017,	0xF265},	// CJK UNIFIED IDEOGRAPH
	{0x7018,	0xC379},	// CJK UNIFIED IDEOGRAPH
	{0x7019,	0xF25C},	// CJK UNIFIED IDEOGRAPH
	{0x701A,	0xC376},	// CJK UNIFIED IDEOGRAPH
	{0x701B,	0xC373},	// CJK UNIFIED IDEOGRAPH
	{0x701C,	0xF267},	// CJK UNIFIED IDEOGRAPH
	{0x701D,	0xC377},	// CJK UNIFIED IDEOGRAPH
	{0x701F,	0xC374},	// CJK UNIFIED IDEOGRAPH
	{0x7020,	0xF25E},	// CJK UNIFIED IDEOGRAPH
	{0x7021,	0xF261},	// CJK UNIFIED IDEOGRAPH
	{0x7022,	0xF262},	// CJK UNIFIED IDEOGRAPH
	{0x7023,	0xF263},	// CJK UNIFIED IDEOGRAPH
	{0x7024,	0xF266},	// CJK UNIFIED IDEOGRAPH
	{0x7026,	0xEFF5},	// CJK UNIFIED IDEOGRAPH
	{0x7027,	0xF25D},	// CJK UNIFIED IDEOGRAPH
	{0x7028,	0xC375},	// CJK UNIFIED IDEOGRAPH
	{0x7029,	0xF264},	// CJK UNIFIED IDEOGRAPH
	{0x702A,	0xF268},	// CJK UNIFIED IDEOGRAPH
	{0x702B,	0xF260},	// CJK UNIFIED IDEOGRAPH
	{0x702F,	0xF45D},	// CJK UNIFIED IDEOGRAPH
	{0x7030,	0xC46A},	// CJK UNIFIED IDEOGRAPH
	{0x7031,	0xF460},	// CJK UNIFIED IDEOGRAPH
	{0x7032,	0xC46B},	// CJK UNIFIED IDEOGRAPH
	{0x7033,	0xF468},	// CJK UNIFIED IDEOGRAPH
	{0x7034,	0xF45F},	// CJK UNIFIED IDEOGRAPH
	{0x7035,	0xF45C},	// CJK UNIFIED IDEOGRAPH
	{0x7037,	0xF45E},	// CJK UNIFIED IDEOGRAPH
	{0x7038,	0xF462},	// CJK UNIFIED IDEOGRAPH
	{0x7039,	0xF465},	// CJK UNIFIED IDEOGRAPH
	{0x703A,	0xF464},	// CJK UNIFIED IDEOGRAPH
	{0x703B,	0xF467},	// CJK UNIFIED IDEOGRAPH
	{0x703C,	0xF45B},	// CJK UNIFIED IDEOGRAPH
	{0x703E,	0xC469},	// CJK UNIFIED IDEOGRAPH
	{0x703F,	0xF463},	// CJK UNIFIED IDEOGRAPH
	{0x7040,	0xF466},	// CJK UNIFIED IDEOGRAPH
	{0x7041,	0xF469},	// CJK UNIFIED IDEOGRAPH
	{0x7042,	0xF461},	// CJK UNIFIED IDEOGRAPH
	{0x7043,	0xF5D3},	// CJK UNIFIED IDEOGRAPH
	{0x7044,	0xF5D4},	// CJK UNIFIED IDEOGRAPH
	{0x7045,	0xF5D8},	// CJK UNIFIED IDEOGRAPH
	{0x7046,	0xF5D9},	// CJK UNIFIED IDEOGRAPH
	{0x7048,	0xF5D6},	// CJK UNIFIED IDEOGRAPH
	{0x7049,	0xF5D7},	// CJK UNIFIED IDEOGRAPH
	{0x704A,	0xF5D5},	// CJK UNIFIED IDEOGRAPH
	{0x704C,	0xC4E9},	// CJK UNIFIED IDEOGRAPH
	{0x7051,	0xC578},	// CJK UNIFIED IDEOGRAPH
	{0x7052,	0xF6EB},	// CJK UNIFIED IDEOGRAPH
	{0x7055,	0xF6E8},	// CJK UNIFIED IDEOGRAPH
	{0x7056,	0xF6E9},	// CJK UNIFIED IDEOGRAPH
	{0x7057,	0xF6EA},	// CJK UNIFIED IDEOGRAPH
	{0x7058,	0xC579},	// CJK UNIFIED IDEOGRAPH
	{0x705A,	0xF7E5},	// CJK UNIFIED IDEOGRAPH
	{0x705B,	0xF7E4},	// CJK UNIFIED IDEOGRAPH
	{0x705D,	0xF8AF},	// CJK UNIFIED IDEOGRAPH
	{0x705E,	0xC5F4},	// CJK UNIFIED IDEOGRAPH
	{0x705F,	0xF8AD},	// CJK UNIFIED IDEOGRAPH
	{0x7060,	0xF8B0},	// CJK UNIFIED IDEOGRAPH
	{0x7061,	0xF8AE},	// CJK UNIFIED IDEOGRAPH
	{0x7062,	0xF8F5},	// CJK UNIFIED IDEOGRAPH
	{0x7063,	0xC657},	// CJK UNIFIED IDEOGRAPH
	{0x7064,	0xC665},	// CJK UNIFIED IDEOGRAPH
	{0x7065,	0xF9A3},	// CJK UNIFIED IDEOGRAPH
	{0x7066,	0xF96C},	// CJK UNIFIED IDEOGRAPH
	{0x7068,	0xF9A2},	// CJK UNIFIED IDEOGRAPH
	{0x7069,	0xF9D0},	// CJK UNIFIED IDEOGRAPH
	{0x706A,	0xF9D1},	// CJK UNIFIED IDEOGRAPH
	{0x706B,	0xA4F5},	// CJK UNIFIED IDEOGRAPH
	{0x7070,	0xA6C7},	// CJK UNIFIED IDEOGRAPH
	{0x7071,	0xCA41},	// CJK UNIFIED IDEOGRAPH
	{0x7074,	0xCB5E},	// CJK UNIFIED IDEOGRAPH
	{0x7076,	0xA85F},	// CJK UNIFIED IDEOGRAPH
	{0x7078,	0xA862},	// CJK UNIFIED IDEOGRAPH
	{0x707A,	0xCB5F},	// CJK UNIFIED IDEOGRAPH
	{0x707C,	0xA860},	// CJK UNIFIED IDEOGRAPH
	{0x707D,	0xA861},	// CJK UNIFIED IDEOGRAPH
	{0x7082,	0xCD58},	// CJK UNIFIED IDEOGRAPH
	{0x7083,	0xCD5A},	// CJK UNIFIED IDEOGRAPH
	{0x7084,	0xCD55},	// CJK UNIFIED IDEOGRAPH
	{0x7085,	0xCD52},	// CJK UNIFIED IDEOGRAPH
	{0x7086,	0xCD54},	// CJK UNIFIED IDEOGRAPH
	{0x708A,	0xAAA4},	// CJK UNIFIED IDEOGRAPH
	{0x708E,	0xAAA2},	// CJK UNIFIED IDEOGRAPH
	{0x7091,	0xCD56},	// CJK UNIFIED IDEOGRAPH
	{0x7092,	0xAAA3},	// CJK UNIFIED IDEOGRAPH
	{0x7093,	0xCD53},	// CJK UNIFIED IDEOGRAPH
	{0x7094,	0xCD50},	// CJK UNIFIED IDEOGRAPH
	{0x7095,	0xAAA1},	// CJK UNIFIED IDEOGRAPH
	{0x7096,	0xCD57},	// CJK UNIFIED IDEOGRAPH
	{0x7098,	0xCD51},	// CJK UNIFIED IDEOGRAPH
	{0x7099,	0xAAA5},	// CJK UNIFIED IDEOGRAPH
	{0x709A,	0xCD59},	// CJK UNIFIED IDEOGRAPH
	{0x709F,	0xCFAF},	// CJK UNIFIED IDEOGRAPH
	{0x70A1,	0xCFB3},	// CJK UNIFIED IDEOGRAPH
	{0x70A4,	0xACB7},	// CJK UNIFIED IDEOGRAPH
	{0x70A9,	0xCFB6},	// CJK UNIFIED IDEOGRAPH
	{0x70AB,	0xACAF},	// CJK UNIFIED IDEOGRAPH
	{0x70AC,	0xACB2},	// CJK UNIFIED IDEOGRAPH
	{0x70AD,	0xACB4},	// CJK UNIFIED IDEOGRAPH
	{0x70AE,	0xACB6},	// CJK UNIFIED IDEOGRAPH
	{0x70AF,	0xACB3},	// CJK UNIFIED IDEOGRAPH
	{0x70B0,	0xCFB2},	// CJK UNIFIED IDEOGRAPH
	{0x70B1,	0xCFB1},	// CJK UNIFIED IDEOGRAPH
	{0x70B3,	0xACB1},	// CJK UNIFIED IDEOGRAPH
	{0x70B4,	0xCFB4},	// CJK UNIFIED IDEOGRAPH
	{0x70B5,	0xCFB5},	// CJK UNIFIED IDEOGRAPH
	{0x70B7,	0xCFAE},	// CJK UNIFIED IDEOGRAPH
	{0x70B8,	0xACB5},	// CJK UNIFIED IDEOGRAPH
	{0x70BA,	0xACB0},	// CJK UNIFIED IDEOGRAPH
	{0x70BE,	0xCFB0},	// CJK UNIFIED IDEOGRAPH
	{0x70C5,	0xD277},	// CJK UNIFIED IDEOGRAPH
	{0x70C6,	0xD278},	// CJK UNIFIED IDEOGRAPH
	{0x70C7,	0xD279},	// CJK UNIFIED IDEOGRAPH
	{0x70C8,	0xAF50},	// CJK UNIFIED IDEOGRAPH
	{0x70CA,	0xAF4C},	// CJK UNIFIED IDEOGRAPH
	{0x70CB,	0xD26E},	// CJK UNIFIED IDEOGRAPH
	{0x70CD,	0xD276},	// CJK UNIFIED IDEOGRAPH
	{0x70CE,	0xD27B},	// CJK UNIFIED IDEOGRAPH
	{0x70CF,	0xAF51},	// CJK UNIFIED IDEOGRAPH
	{0x70D1,	0xD26C},	// CJK UNIFIED IDEOGRAPH
	{0x70D2,	0xD272},	// CJK UNIFIED IDEOGRAPH
	{0x70D3,	0xD26B},	// CJK UNIFIED IDEOGRAPH
	{0x70D4,	0xD275},	// CJK UNIFIED IDEOGRAPH
	{0x70D7,	0xD271},	// CJK UNIFIED IDEOGRAPH
	{0x70D8,	0xAF4D},	// CJK UNIFIED IDEOGRAPH
	{0x70D9,	0xAF4F},	// CJK UNIFIED IDEOGRAPH
	{0x70DA,	0xD27A},	// CJK UNIFIED IDEOGRAPH
	{0x70DC,	0xD26A},	// CJK UNIFIED IDEOGRAPH
	{0x70DD,	0xD26D},	// CJK UNIFIED IDEOGRAPH
	{0x70DE,	0xD273},	// CJK UNIFIED IDEOGRAPH
	{0x70E0,	0xD274},	// CJK UNIFIED IDEOGRAPH
	{0x70E1,	0xD27C},	// CJK UNIFIED IDEOGRAPH
	{0x70E2,	0xD270},	// CJK UNIFIED IDEOGRAPH
	{0x70E4,	0xAF4E},	// CJK UNIFIED IDEOGRAPH
	{0x70EF,	0xB26D},	// CJK UNIFIED IDEOGRAPH
	{0x70F0,	0xD64E},	// CJK UNIFIED IDEOGRAPH
	{0x70F3,	0xD650},	// CJK UNIFIED IDEOGRAPH
	{0x70F4,	0xD64C},	// CJK UNIFIED IDEOGRAPH
	{0x70F6,	0xD658},	// CJK UNIFIED IDEOGRAPH
	{0x70F7,	0xD64A},	// CJK UNIFIED IDEOGRAPH
	{0x70F8,	0xD657},	// CJK UNIFIED IDEOGRAPH
	{0x70F9,	0xB269},	// CJK UNIFIED IDEOGRAPH
	{0x70FA,	0xD648},	// CJK UNIFIED IDEOGRAPH
	{0x70FB,	0xDA5B},	// CJK UNIFIED IDEOGRAPH
	{0x70FC,	0xD652},	// CJK UNIFIED IDEOGRAPH
	{0x70FD,	0xB26C},	// CJK UNIFIED IDEOGRAPH
	{0x70FF,	0xD653},	// CJK UNIFIED IDEOGRAPH
	{0x7100,	0xD656},	// CJK UNIFIED IDEOGRAPH
	{0x7102,	0xD65A},	// CJK UNIFIED IDEOGRAPH
	{0x7104,	0xD64F},	// CJK UNIFIED IDEOGRAPH
	{0x7106,	0xD654},	// CJK UNIFIED IDEOGRAPH
	{0x7109,	0xB26A},	// CJK UNIFIED IDEOGRAPH
	{0x710A,	0xB26B},	// CJK UNIFIED IDEOGRAPH
	{0x710B,	0xD659},	// CJK UNIFIED IDEOGRAPH
	{0x710C,	0xD64D},	// CJK UNIFIED IDEOGRAPH
	{0x710D,	0xD649},	// CJK UNIFIED IDEOGRAPH
	{0x710E,	0xD65B},	// CJK UNIFIED IDEOGRAPH
	{0x7110,	0xD651},	// CJK UNIFIED IDEOGRAPH
	{0x7113,	0xD655},	// CJK UNIFIED IDEOGRAPH
	{0x7117,	0xD64B},	// CJK UNIFIED IDEOGRAPH
	{0x7119,	0xB548},	// CJK UNIFIED IDEOGRAPH
	{0x711A,	0xB549},	// CJK UNIFIED IDEOGRAPH
	{0x711B,	0xDA65},	// CJK UNIFIED IDEOGRAPH
	{0x711C,	0xB54F},	// CJK UNIFIED IDEOGRAPH
	{0x711E,	0xDA59},	// CJK UNIFIED IDEOGRAPH
	{0x711F,	0xDA62},	// CJK UNIFIED IDEOGRAPH
	{0x7120,	0xDA58},	// CJK UNIFIED IDEOGRAPH
	{0x7121,	0xB54C},	// CJK UNIFIED IDEOGRAPH
	{0x7122,	0xDA60},	// CJK UNIFIED IDEOGRAPH
	{0x7123,	0xDA5E},	// CJK UNIFIED IDEOGRAPH
	{0x7125,	0xDA5F},	// CJK UNIFIED IDEOGRAPH
	{0x7126,	0xB54A},	// CJK UNIFIED IDEOGRAPH
	{0x7128,	0xDA63},	// CJK UNIFIED IDEOGRAPH
	{0x712E,	0xDA5C},	// CJK UNIFIED IDEOGRAPH
	{0x712F,	0xDA5A},	// CJK UNIFIED IDEOGRAPH
	{0x7130,	0xB54B},	// CJK UNIFIED IDEOGRAPH
	{0x7131,	0xDA5D},	// CJK UNIFIED IDEOGRAPH
	{0x7132,	0xDA61},	// CJK UNIFIED IDEOGRAPH
	{0x7136,	0xB54D},	// CJK UNIFIED IDEOGRAPH
	{0x713A,	0xDA64},	// CJK UNIFIED IDEOGRAPH
	{0x7141,	0xDE70},	// CJK UNIFIED IDEOGRAPH
	{0x7142,	0xDE77},	// CJK UNIFIED IDEOGRAPH
	{0x7143,	0xDE79},	// CJK UNIFIED IDEOGRAPH
	{0x7144,	0xDEA1},	// CJK UNIFIED IDEOGRAPH
	{0x7146,	0xB7DA},	// CJK UNIFIED IDEOGRAPH
	{0x7147,	0xDE6B},	// CJK UNIFIED IDEOGRAPH
	{0x7149,	0xB7D2},	// CJK UNIFIED IDEOGRAPH
	{0x714B,	0xDE7A},	// CJK UNIFIED IDEOGRAPH
	{0x714C,	0xB7D7},	// CJK UNIFIED IDEOGRAPH
	{0x714D,	0xDEA2},	// CJK UNIFIED IDEOGRAPH
	{0x714E,	0xB7CE},	// CJK UNIFIED IDEOGRAPH
	{0x7150,	0xDE7D},	// CJK UNIFIED IDEOGRAPH
	{0x7152,	0xDE6D},	// CJK UNIFIED IDEOGRAPH
	{0x7153,	0xDE7E},	// CJK UNIFIED IDEOGRAPH
	{0x7154,	0xDE6C},	// CJK UNIFIED IDEOGRAPH
	{0x7156,	0xB7DC},	// CJK UNIFIED IDEOGRAPH
	{0x7158,	0xDE78},	// CJK UNIFIED IDEOGRAPH
	{0x7159,	0xB7CF},	// CJK UNIFIED IDEOGRAPH
	{0x715A,	0xDEA3},	// CJK UNIFIED IDEOGRAPH
	{0x715C,	0xB7D4},	// CJK UNIFIED IDEOGRAPH
	{0x715D,	0xDE71},	// CJK UNIFIED IDEOGRAPH
	{0x715E,	0xB7D9},	// CJK UNIFIED IDEOGRAPH
	{0x715F,	0xDE7C},	// CJK UNIFIED IDEOGRAPH
	{0x7160,	0xDE6F},	// CJK UNIFIED IDEOGRAPH
	{0x7161,	0xDE76},	// CJK UNIFIED IDEOGRAPH
	{0x7162,	0xDE72},	// CJK UNIFIED IDEOGRAPH
	{0x7163,	0xDE6E},	// CJK UNIFIED IDEOGRAPH
	{0x7164,	0xB7D1},	// CJK UNIFIED IDEOGRAPH
	{0x7165,	0xB7D8},	// CJK UNIFIED IDEOGRAPH
	{0x7166,	0xB7D6},	// CJK UNIFIED IDEOGRAPH
	{0x7167,	0xB7D3},	// CJK UNIFIED IDEOGRAPH
	{0x7168,	0xB7DB},	// CJK UNIFIED IDEOGRAPH
	{0x7169,	0xB7D0},	// CJK UNIFIED IDEOGRAPH
	{0x716A,	0xDE75},	// CJK UNIFIED IDEOGRAPH
	{0x716C,	0xB7D5},	// CJK UNIFIED IDEOGRAPH
	{0x716E,	0xB54E},	// CJK UNIFIED IDEOGRAPH
	{0x7170,	0xDE7B},	// CJK UNIFIED IDEOGRAPH
	{0x7172,	0xDE73},	// CJK UNIFIED IDEOGRAPH
	{0x7178,	0xDE74},	// CJK UNIFIED IDEOGRAPH
	{0x717B,	0xE2C1},	// CJK UNIFIED IDEOGRAPH
	{0x717D,	0xBAB4},	// CJK UNIFIED IDEOGRAPH
	{0x7180,	0xE2BD},	// CJK UNIFIED IDEOGRAPH
	{0x7181,	0xE2C3},	// CJK UNIFIED IDEOGRAPH
	{0x7182,	0xE2BF},	// CJK UNIFIED IDEOGRAPH
	{0x7184,	0xBAB6},	// CJK UNIFIED IDEOGRAPH
	{0x7185,	0xE2BE},	// CJK UNIFIED IDEOGRAPH
	{0x7186,	0xE2C2},	// CJK UNIFIED IDEOGRAPH
	{0x7187,	0xE2BA},	// CJK UNIFIED IDEOGRAPH
	{0x7189,	0xE2BC},	// CJK UNIFIED IDEOGRAPH
	{0x718A,	0xBAB5},	// CJK UNIFIED IDEOGRAPH
	{0x718F,	0xE2C0},	// CJK UNIFIED IDEOGRAPH
	{0x7190,	0xE2BB},	// CJK UNIFIED IDEOGRAPH
	{0x7192,	0xBAB7},	// CJK UNIFIED IDEOGRAPH
	{0x7194,	0xBAB2},	// CJK UNIFIED IDEOGRAPH
	{0x7197,	0xE2C4},	// CJK UNIFIED IDEOGRAPH
	{0x7199,	0xBAB3},	// CJK UNIFIED IDEOGRAPH
	{0x719A,	0xE667},	// CJK UNIFIED IDEOGRAPH
	{0x719B,	0xE664},	// CJK UNIFIED IDEOGRAPH
	{0x719C,	0xE670},	// CJK UNIFIED IDEOGRAPH
	{0x719D,	0xE66A},	// CJK UNIFIED IDEOGRAPH
	{0x719E,	0xE66C},	// CJK UNIFIED IDEOGRAPH
	{0x719F,	0xBCF4},	// CJK UNIFIED IDEOGRAPH
	{0x71A0,	0xE666},	// CJK UNIFIED IDEOGRAPH
	{0x71A1,	0xE66E},	// CJK UNIFIED IDEOGRAPH
	{0x71A4,	0xE66D},	// CJK UNIFIED IDEOGRAPH
	{0x71A5,	0xE66B},	// CJK UNIFIED IDEOGRAPH
	{0x71A7,	0xE671},	// CJK UNIFIED IDEOGRAPH
	{0x71A8,	0xBCF7},	// CJK UNIFIED IDEOGRAPH
	{0x71A9,	0xE668},	// CJK UNIFIED IDEOGRAPH
	{0x71AA,	0xE66F},	// CJK UNIFIED IDEOGRAPH
	{0x71AC,	0xBCF5},	// CJK UNIFIED IDEOGRAPH
	{0x71AF,	0xE663},	// CJK UNIFIED IDEOGRAPH
	{0x71B0,	0xE665},	// CJK UNIFIED IDEOGRAPH
	{0x71B1,	0xBCF6},	// CJK UNIFIED IDEOGRAPH
	{0x71B2,	0xE662},	// CJK UNIFIED IDEOGRAPH
	{0x71B3,	0xE672},	// CJK UNIFIED IDEOGRAPH
	{0x71B5,	0xE669},	// CJK UNIFIED IDEOGRAPH
	{0x71B8,	0xEA4A},	// CJK UNIFIED IDEOGRAPH
	{0x71B9,	0xBF51},	// CJK UNIFIED IDEOGRAPH
	{0x71BC,	0xEA55},	// CJK UNIFIED IDEOGRAPH
	{0x71BD,	0xEA53},	// CJK UNIFIED IDEOGRAPH
	{0x71BE,	0xBF4B},	// CJK UNIFIED IDEOGRAPH
	{0x71BF,	0xEA49},	// CJK UNIFIED IDEOGRAPH
	{0x71C0,	0xEA4C},	// CJK UNIFIED IDEOGRAPH
	{0x71C1,	0xEA4D},	// CJK UNIFIED IDEOGRAPH
	{0x71C2,	0xEA48},	// CJK UNIFIED IDEOGRAPH
	{0x71C3,	0xBF55},	// CJK UNIFIED IDEOGRAPH
	{0x71C4,	0xBF56},	// CJK UNIFIED IDEOGRAPH
	{0x71C5,	0xEA47},	// CJK UNIFIED IDEOGRAPH
	{0x71C6,	0xEA56},	// CJK UNIFIED IDEOGRAPH
	{0x71C7,	0xEA51},	// CJK UNIFIED IDEOGRAPH
	{0x71C8,	0xBF4F},	// CJK UNIFIED IDEOGRAPH
	{0x71C9,	0xBF4C},	// CJK UNIFIED IDEOGRAPH
	{0x71CA,	0xEA50},	// CJK UNIFIED IDEOGRAPH
	{0x71CB,	0xEA4E},	// CJK UNIFIED IDEOGRAPH
	{0x71CE,	0xBF52},	// CJK UNIFIED IDEOGRAPH
	{0x71CF,	0xEA52},	// CJK UNIFIED IDEOGRAPH
	{0x71D0,	0xBF4D},	// CJK UNIFIED IDEOGRAPH
	{0x71D2,	0xBF4E},	// CJK UNIFIED IDEOGRAPH
	{0x71D4,	0xEA4F},	// CJK UNIFIED IDEOGRAPH
	{0x71D5,	0xBF50},	// CJK UNIFIED IDEOGRAPH
	{0x71D6,	0xEA4B},	// CJK UNIFIED IDEOGRAPH
	{0x71D8,	0xEA54},	// CJK UNIFIED IDEOGRAPH
	{0x71D9,	0xBF53},	// CJK UNIFIED IDEOGRAPH
	{0x71DA,	0xEA57},	// CJK UNIFIED IDEOGRAPH
	{0x71DB,	0xEA58},	// CJK UNIFIED IDEOGRAPH
	{0x71DC,	0xBF54},	// CJK UNIFIED IDEOGRAPH
	{0x71DF,	0xC0E7},	// CJK UNIFIED IDEOGRAPH
	{0x71E0,	0xC0EE},	// CJK UNIFIED IDEOGRAPH
	{0x71E1,	0xED5C},	// CJK UNIFIED IDEOGRAPH
	{0x71E2,	0xED62},	// CJK UNIFIED IDEOGRAPH
	{0x71E4,	0xED60},	// CJK UNIFIED IDEOGRAPH
	{0x71E5,	0xC0EA},	// CJK UNIFIED IDEOGRAPH
	{0x71E6,	0xC0E9},	// CJK UNIFIED IDEOGRAPH
	{0x71E7,	0xC0E6},	// CJK UNIFIED IDEOGRAPH
	{0x71E8,	0xED5E},	// CJK UNIFIED IDEOGRAPH
	{0x71EC,	0xC0EC},	// CJK UNIFIED IDEOGRAPH
	{0x71ED,	0xC0EB},	// CJK UNIFIED IDEOGRAPH
	{0x71EE,	0xC0E8},	// CJK UNIFIED IDEOGRAPH
	{0x71F0,	0xED61},	// CJK UNIFIED IDEOGRAPH
	{0x71F1,	0xED5D},	// CJK UNIFIED IDEOGRAPH
	{0x71F2,	0xED5F},	// CJK UNIFIED IDEOGRAPH
	{0x71F4,	0xC0ED},	// CJK UNIFIED IDEOGRAPH
	{0x71F8,	0xC277},	// CJK UNIFIED IDEOGRAPH
	{0x71F9,	0xEFFB},	// CJK UNIFIED IDEOGRAPH
	{0x71FB,	0xC274},	// CJK UNIFIED IDEOGRAPH
	{0x71FC,	0xC275},	// CJK UNIFIED IDEOGRAPH
	{0x71FD,	0xEFFD},	// CJK UNIFIED IDEOGRAPH
	{0x71FE,	0xC276},	// CJK UNIFIED IDEOGRAPH
	{0x71FF,	0xEFFA},	// CJK UNIFIED IDEOGRAPH
	{0x7201,	0xEFF9},	// CJK UNIFIED IDEOGRAPH
	{0x7202,	0xF26C},	// CJK UNIFIED IDEOGRAPH
	{0x7203,	0xEFFC},	// CJK UNIFIED IDEOGRAPH
	{0x7205,	0xF26D},	// CJK UNIFIED IDEOGRAPH
	{0x7206,	0xC37A},	// CJK UNIFIED IDEOGRAPH
	{0x7207,	0xF26B},	// CJK UNIFIED IDEOGRAPH
	{0x720A,	0xF26A},	// CJK UNIFIED IDEOGRAPH
	{0x720C,	0xF269},	// CJK UNIFIED IDEOGRAPH
	{0x720D,	0xC37B},	// CJK UNIFIED IDEOGRAPH
	{0x7210,	0xC46C},	// CJK UNIFIED IDEOGRAPH
	{0x7213,	0xF46A},	// CJK UNIFIED IDEOGRAPH
	{0x7214,	0xF46B},	// CJK UNIFIED IDEOGRAPH
	{0x7219,	0xF5DC},	// CJK UNIFIED IDEOGRAPH
	{0x721A,	0xF5DB},	// CJK UNIFIED IDEOGRAPH
	{0x721B,	0xC4EA},	// CJK UNIFIED IDEOGRAPH
	{0x721D,	0xF5DA},	// CJK UNIFIED IDEOGRAPH
	{0x721E,	0xF6EC},	// CJK UNIFIED IDEOGRAPH
	{0x721F,	0xF6ED},	// CJK UNIFIED IDEOGRAPH
	{0x7222,	0xF7E6},	// CJK UNIFIED IDEOGRAPH
	{0x7223,	0xF8B1},	// CJK UNIFIED IDEOGRAPH
	{0x7226,	0xF8F6},	// CJK UNIFIED IDEOGRAPH
	{0x7227,	0xF9BC},	// CJK UNIFIED IDEOGRAPH
	{0x7228,	0xC679},	// CJK UNIFIED IDEOGRAPH
	{0x7229,	0xF9C6},	// CJK UNIFIED IDEOGRAPH
	{0x722A,	0xA4F6},	// CJK UNIFIED IDEOGRAPH
	{0x722C,	0xAAA6},	// CJK UNIFIED IDEOGRAPH
	{0x722D,	0xAAA7},	// CJK UNIFIED IDEOGRAPH
	{0x7230,	0xACB8},	// CJK UNIFIED IDEOGRAPH
	{0x7235,	0xC0EF},	// CJK UNIFIED IDEOGRAPH
	{0x7236,	0xA4F7},	// CJK UNIFIED IDEOGRAPH
	{0x7238,	0xAAA8},	// CJK UNIFIED IDEOGRAPH
	{0x7239,	0xAF52},	// CJK UNIFIED IDEOGRAPH
	{0x723A,	0xB7DD},	// CJK UNIFIED IDEOGRAPH
	{0x723B,	0xA4F8},	// CJK UNIFIED IDEOGRAPH
	{0x723D,	0xB26E},	// CJK UNIFIED IDEOGRAPH
	{0x723E,	0xBAB8},	// CJK UNIFIED IDEOGRAPH
	{0x723F,	0xC962},	// CJK UNIFIED IDEOGRAPH
	{0x7241,	0xCFB7},	// CJK UNIFIED IDEOGRAPH
	{0x7242,	0xD27D},	// CJK UNIFIED IDEOGRAPH
	{0x7244,	0xE2C5},	// CJK UNIFIED IDEOGRAPH
	{0x7246,	0xC0F0},	// CJK UNIFIED IDEOGRAPH
	{0x7247,	0xA4F9},	// CJK UNIFIED IDEOGRAPH
	{0x7248,	0xAAA9},	// CJK UNIFIED IDEOGRAPH
	{0x7249,	0xCFB8},	// CJK UNIFIED IDEOGRAPH
	{0x724A,	0xCFB9},	// CJK UNIFIED IDEOGRAPH
	{0x724B,	0xDA66},	// CJK UNIFIED IDEOGRAPH
	{0x724C,	0xB550},	// CJK UNIFIED IDEOGRAPH
	{0x724F,	0xDEA4},	// CJK UNIFIED IDEOGRAPH
	{0x7252,	0xB7DE},	// CJK UNIFIED IDEOGRAPH
	{0x7253,	0xE2C6},	// CJK UNIFIED IDEOGRAPH
	{0x7256,	0xBCF8},	// CJK UNIFIED IDEOGRAPH
	{0x7258,	0xC37C},	// CJK UNIFIED IDEOGRAPH
	{0x7259,	0xA4FA},	// CJK UNIFIED IDEOGRAPH
	{0x725A,	0xDA67},	// CJK UNIFIED IDEOGRAPH
	{0x725B,	0xA4FB},	// CJK UNIFIED IDEOGRAPH
	{0x725D,	0xA6C9},	// CJK UNIFIED IDEOGRAPH
	{0x725E,	0xCA42},	// CJK UNIFIED IDEOGRAPH
	{0x725F,	0xA6C8},	// CJK UNIFIED IDEOGRAPH
	{0x7260,	0xA865},	// CJK UNIFIED IDEOGRAPH
	{0x7261,	0xA864},	// CJK UNIFIED IDEOGRAPH
	{0x7262,	0xA863},	// CJK UNIFIED IDEOGRAPH
	{0x7263,	0xCB60},	// CJK UNIFIED IDEOGRAPH
	{0x7267,	0xAAAA},	// CJK UNIFIED IDEOGRAPH
	{0x7269,	0xAAAB},	// CJK UNIFIED IDEOGRAPH
	{0x726A,	0xCD5B},	// CJK UNIFIED IDEOGRAPH
	{0x726C,	0xCFBA},	// CJK UNIFIED IDEOGRAPH
	{0x726E,	0xCFBD},	// CJK UNIFIED IDEOGRAPH
	{0x726F,	0xACBA},	// CJK UNIFIED IDEOGRAPH
	{0x7270,	0xCFBB},	// CJK UNIFIED IDEOGRAPH
	{0x7272,	0xACB9},	// CJK UNIFIED IDEOGRAPH
	{0x7273,	0xCFBC},	// CJK UNIFIED IDEOGRAPH
	{0x7274,	0xACBB},	// CJK UNIFIED IDEOGRAPH
	{0x7276,	0xD2A2},	// CJK UNIFIED IDEOGRAPH
	{0x7277,	0xD2A1},	// CJK UNIFIED IDEOGRAPH
	{0x7278,	0xD27E},	// CJK UNIFIED IDEOGRAPH
	{0x7279,	0xAF53},	// CJK UNIFIED IDEOGRAPH
	{0x727B,	0xD65D},	// CJK UNIFIED IDEOGRAPH
	{0x727C,	0xD65E},	// CJK UNIFIED IDEOGRAPH
	{0x727D,	0xB26F},	// CJK UNIFIED IDEOGRAPH
	{0x727E,	0xD65C},	// CJK UNIFIED IDEOGRAPH
	{0x727F,	0xD65F},	// CJK UNIFIED IDEOGRAPH
	{0x7280,	0xB552},	// CJK UNIFIED IDEOGRAPH
	{0x7281,	0xB270},	// CJK UNIFIED IDEOGRAPH
	{0x7284,	0xB551},	// CJK UNIFIED IDEOGRAPH
	{0x7285,	0xDA6B},	// CJK UNIFIED IDEOGRAPH
	{0x7286,	0xDA6A},	// CJK UNIFIED IDEOGRAPH
	{0x7288,	0xDA68},	// CJK UNIFIED IDEOGRAPH
	{0x7289,	0xDA69},	// CJK UNIFIED IDEOGRAPH
	{0x728B,	0xDA6C},	// CJK UNIFIED IDEOGRAPH
	{0x728C,	0xDEA6},	// CJK UNIFIED IDEOGRAPH
	{0x728D,	0xDEA5},	// CJK UNIFIED IDEOGRAPH
	{0x728E,	0xDEA9},	// CJK UNIFIED IDEOGRAPH
	{0x7290,	0xDEA8},	// CJK UNIFIED IDEOGRAPH
	{0x7291,	0xDEA7},	// CJK UNIFIED IDEOGRAPH
	{0x7292,	0xBAB9},	// CJK UNIFIED IDEOGRAPH
	{0x7293,	0xE2C9},	// CJK UNIFIED IDEOGRAPH
	{0x7295,	0xE2C8},	// CJK UNIFIED IDEOGRAPH
	{0x7296,	0xBABA},	// CJK UNIFIED IDEOGRAPH
	{0x7297,	0xE2C7},	// CJK UNIFIED IDEOGRAPH
	{0x7298,	0xE673},	// CJK UNIFIED IDEOGRAPH
	{0x729A,	0xE674},	// CJK UNIFIED IDEOGRAPH
	{0x729B,	0xBCF9},	// CJK UNIFIED IDEOGRAPH
	{0x729D,	0xEA59},	// CJK UNIFIED IDEOGRAPH
	{0x729E,	0xEA5A},	// CJK UNIFIED IDEOGRAPH
	{0x72A1,	0xF272},	// CJK UNIFIED IDEOGRAPH
	{0x72A2,	0xC37D},	// CJK UNIFIED IDEOGRAPH
	{0x72A3,	0xF271},	// CJK UNIFIED IDEOGRAPH
	{0x72A4,	0xF270},	// CJK UNIFIED IDEOGRAPH
	{0x72A5,	0xF26E},	// CJK UNIFIED IDEOGRAPH
	{0x72A6,	0xF26F},	// CJK UNIFIED IDEOGRAPH
	{0x72A7,	0xC4EB},	// CJK UNIFIED IDEOGRAPH
	{0x72A8,	0xF46C},	// CJK UNIFIED IDEOGRAPH
	{0x72A9,	0xF6EE},	// CJK UNIFIED IDEOGRAPH
	{0x72AA,	0xF8F7},	// CJK UNIFIED IDEOGRAPH
	{0x72AC,	0xA4FC},	// CJK UNIFIED IDEOGRAPH
	{0x72AE,	0xC9A5},	// CJK UNIFIED IDEOGRAPH
	{0x72AF,	0xA5C7},	// CJK UNIFIED IDEOGRAPH
	{0x72B0,	0xC9A6},	// CJK UNIFIED IDEOGRAPH
	{0x72B4,	0xCA43},	// CJK UNIFIED IDEOGRAPH
	{0x72B5,	0xCA44},	// CJK UNIFIED IDEOGRAPH
	{0x72BA,	0xCB66},	// CJK UNIFIED IDEOGRAPH
	{0x72BD,	0xCB62},	// CJK UNIFIED IDEOGRAPH
	{0x72BF,	0xCB61},	// CJK UNIFIED IDEOGRAPH
	{0x72C0,	0xAAAC},	// CJK UNIFIED IDEOGRAPH
	{0x72C1,	0xCB65},	// CJK UNIFIED IDEOGRAPH
	{0x72C2,	0xA867},	// CJK UNIFIED IDEOGRAPH
	{0x72C3,	0xCB63},	// CJK UNIFIED IDEOGRAPH
	{0x72C4,	0xA866},	// CJK UNIFIED IDEOGRAPH
	{0x72C5,	0xCB67},	// CJK UNIFIED IDEOGRAPH
	{0x72C6,	0xCB64},	// CJK UNIFIED IDEOGRAPH
	{0x72C9,	0xCD5F},	// CJK UNIFIED IDEOGRAPH
	{0x72CA,	0xCFBE},	// CJK UNIFIED IDEOGRAPH
	{0x72CB,	0xCD5D},	// CJK UNIFIED IDEOGRAPH
	{0x72CC,	0xCD64},	// CJK UNIFIED IDEOGRAPH
	{0x72CE,	0xAAAD},	// CJK UNIFIED IDEOGRAPH
	{0x72D0,	0xAAB0},	// CJK UNIFIED IDEOGRAPH
	{0x72D1,	0xCD65},	// CJK UNIFIED IDEOGRAPH
	{0x72D2,	0xCD61},	// CJK UNIFIED IDEOGRAPH
	{0x72D4,	0xCD62},	// CJK UNIFIED IDEOGRAPH
	{0x72D6,	0xCD5C},	// CJK UNIFIED IDEOGRAPH
	{0x72D7,	0xAAAF},	// CJK UNIFIED IDEOGRAPH
	{0x72D8,	0xCD5E},	// CJK UNIFIED IDEOGRAPH
	{0x72D9,	0xAAAE},	// CJK UNIFIED IDEOGRAPH
	{0x72DA,	0xCD63},	// CJK UNIFIED IDEOGRAPH
	{0x72DC,	0xCD60},	// CJK UNIFIED IDEOGRAPH
	{0x72DF,	0xCFC2},	// CJK UNIFIED IDEOGRAPH
	{0x72E0,	0xACBD},	// CJK UNIFIED IDEOGRAPH
	{0x72E1,	0xACBE},	// CJK UNIFIED IDEOGRAPH
	{0x72E3,	0xCFC5},	// CJK UNIFIED IDEOGRAPH
	{0x72E4,	0xCFBF},	// CJK UNIFIED IDEOGRAPH
	{0x72E6,	0xCFC4},	// CJK UNIFIED IDEOGRAPH
	{0x72E8,	0xCFC0},	// CJK UNIFIED IDEOGRAPH
	{0x72E9,	0xACBC},	// CJK UNIFIED IDEOGRAPH
	{0x72EA,	0xCFC3},	// CJK UNIFIED IDEOGRAPH
	{0x72EB,	0xCFC1},	// CJK UNIFIED IDEOGRAPH
	{0x72F3,	0xD2A8},	// CJK UNIFIED IDEOGRAPH
	{0x72F4,	0xD2A5},	// CJK UNIFIED IDEOGRAPH
	{0x72F6,	0xD2A7},	// CJK UNIFIED IDEOGRAPH
	{0x72F7,	0xAF58},	// CJK UNIFIED IDEOGRAPH
	{0x72F8,	0xAF57},	// CJK UNIFIED IDEOGRAPH
	{0x72F9,	0xAF55},	// CJK UNIFIED IDEOGRAPH
	{0x72FA,	0xD2A4},	// CJK UNIFIED IDEOGRAPH
	{0x72FB,	0xD2A9},	// CJK UNIFIED IDEOGRAPH
	{0x72FC,	0xAF54},	// CJK UNIFIED IDEOGRAPH
	{0x72FD,	0xAF56},	// CJK UNIFIED IDEOGRAPH
	{0x72FE,	0xD2A6},	// CJK UNIFIED IDEOGRAPH
	{0x72FF,	0xD667},	// CJK UNIFIED IDEOGRAPH
	{0x7300,	0xD2A3},	// CJK UNIFIED IDEOGRAPH
	{0x7301,	0xD2AA},	// CJK UNIFIED IDEOGRAPH
	{0x7307,	0xD662},	// CJK UNIFIED IDEOGRAPH
	{0x7308,	0xD666},	// CJK UNIFIED IDEOGRAPH
	{0x730A,	0xD665},	// CJK UNIFIED IDEOGRAPH
	{0x730B,	0xDA6E},	// CJK UNIFIED IDEOGRAPH
	{0x730C,	0xDA79},	// CJK UNIFIED IDEOGRAPH
	{0x730F,	0xD668},	// CJK UNIFIED IDEOGRAPH
	{0x7311,	0xD663},	// CJK UNIFIED IDEOGRAPH
	{0x7312,	0xDA6D},	// CJK UNIFIED IDEOGRAPH
	{0x7313,	0xB274},	// CJK UNIFIED IDEOGRAPH
	{0x7316,	0xB273},	// CJK UNIFIED IDEOGRAPH
	{0x7317,	0xD661},	// CJK UNIFIED IDEOGRAPH
	{0x7318,	0xD664},	// CJK UNIFIED IDEOGRAPH
	{0x7319,	0xB275},	// CJK UNIFIED IDEOGRAPH
	{0x731B,	0xB272},	// CJK UNIFIED IDEOGRAPH
	{0x731C,	0xB271},	// CJK UNIFIED IDEOGRAPH
	{0x731D,	0xD660},	// CJK UNIFIED IDEOGRAPH
	{0x731E,	0xD669},	// CJK UNIFIED IDEOGRAPH
	{0x7322,	0xDA70},	// CJK UNIFIED IDEOGRAPH
	{0x7323,	0xDA77},	// CJK UNIFIED IDEOGRAPH
	{0x7325,	0xB554},	// CJK UNIFIED IDEOGRAPH
	{0x7326,	0xDA76},	// CJK UNIFIED IDEOGRAPH
	{0x7327,	0xDA73},	// CJK UNIFIED IDEOGRAPH
	{0x7329,	0xB556},	// CJK UNIFIED IDEOGRAPH
	{0x732D,	0xDA75},	// CJK UNIFIED IDEOGRAPH
	{0x7330,	0xDA6F},	// CJK UNIFIED IDEOGRAPH
	{0x7331,	0xDA71},	// CJK UNIFIED IDEOGRAPH
	{0x7332,	0xDA74},	// CJK UNIFIED IDEOGRAPH
	{0x7333,	0xDA72},	// CJK UNIFIED IDEOGRAPH
	{0x7334,	0xB555},	// CJK UNIFIED IDEOGRAPH
	{0x7335,	0xDA78},	// CJK UNIFIED IDEOGRAPH
	{0x7336,	0xB553},	// CJK UNIFIED IDEOGRAPH
	{0x7337,	0xB7DF},	// CJK UNIFIED IDEOGRAPH
	{0x733A,	0xDEAD},	// CJK UNIFIED IDEOGRAPH
	{0x733B,	0xDEAC},	// CJK UNIFIED IDEOGRAPH
	{0x733C,	0xDEAA},	// CJK UNIFIED IDEOGRAPH
	{0x733E,	0xB7E2},	// CJK UNIFIED IDEOGRAPH
	{0x733F,	0xB7E1},	// CJK UNIFIED IDEOGRAPH
	{0x7340,	0xDEAE},	// CJK UNIFIED IDEOGRAPH
	{0x7342,	0xDEAB},	// CJK UNIFIED IDEOGRAPH
	{0x7343,	0xE2CA},	// CJK UNIFIED IDEOGRAPH
	{0x7344,	0xBABB},	// CJK UNIFIED IDEOGRAPH
	{0x7345,	0xB7E0},	// CJK UNIFIED IDEOGRAPH
	{0x7349,	0xDEB0},	// CJK UNIFIED IDEOGRAPH
	{0x734A,	0xDEAF},	// CJK UNIFIED IDEOGRAPH
	{0x734C,	0xE2CD},	// CJK UNIFIED IDEOGRAPH
	{0x734D,	0xE2CB},	// CJK UNIFIED IDEOGRAPH
	{0x734E,	0xBCFA},	// CJK UNIFIED IDEOGRAPH
	{0x7350,	0xBABC},	// CJK UNIFIED IDEOGRAPH
	{0x7351,	0xE2CC},	// CJK UNIFIED IDEOGRAPH
	{0x7352,	0xE676},	// CJK UNIFIED IDEOGRAPH
	{0x7357,	0xBCFB},	// CJK UNIFIED IDEOGRAPH
	{0x7358,	0xE675},	// CJK UNIFIED IDEOGRAPH
	{0x7359,	0xE67E},	// CJK UNIFIED IDEOGRAPH
	{0x735A,	0xE67D},	// CJK UNIFIED IDEOGRAPH
	{0x735B,	0xE67B},	// CJK UNIFIED IDEOGRAPH
	{0x735D,	0xE67A},	// CJK UNIFIED IDEOGRAPH
	{0x735E,	0xE677},	// CJK UNIFIED IDEOGRAPH
	{0x735F,	0xE678},	// CJK UNIFIED IDEOGRAPH
	{0x7360,	0xE679},	// CJK UNIFIED IDEOGRAPH
	{0x7361,	0xE67C},	// CJK UNIFIED IDEOGRAPH
	{0x7362,	0xE6A1},	// CJK UNIFIED IDEOGRAPH
	{0x7365,	0xEA5F},	// CJK UNIFIED IDEOGRAPH
	{0x7366,	0xEA5C},	// CJK UNIFIED IDEOGRAPH
	{0x7367,	0xEA5D},	// CJK UNIFIED IDEOGRAPH
	{0x7368,	0xBF57},	// CJK UNIFIED IDEOGRAPH
	{0x7369,	0xEA5B},	// CJK UNIFIED IDEOGRAPH
	{0x736A,	0xEA61},	// CJK UNIFIED IDEOGRAPH
	{0x736B,	0xEA60},	// CJK UNIFIED IDEOGRAPH
	{0x736C,	0xEA5E},	// CJK UNIFIED IDEOGRAPH
	{0x736E,	0xED64},	// CJK UNIFIED IDEOGRAPH
	{0x736F,	0xED65},	// CJK UNIFIED IDEOGRAPH
	{0x7370,	0xC0F1},	// CJK UNIFIED IDEOGRAPH
	{0x7372,	0xC0F2},	// CJK UNIFIED IDEOGRAPH
	{0x7373,	0xED63},	// CJK UNIFIED IDEOGRAPH
	{0x7375,	0xC279},	// CJK UNIFIED IDEOGRAPH
	{0x7376,	0xEFFE},	// CJK UNIFIED IDEOGRAPH
	{0x7377,	0xC278},	// CJK UNIFIED IDEOGRAPH
	{0x7378,	0xC37E},	// CJK UNIFIED IDEOGRAPH
	{0x737A,	0xC3A1},	// CJK UNIFIED IDEOGRAPH
	{0x737B,	0xC46D},	// CJK UNIFIED IDEOGRAPH
	{0x737C,	0xF46E},	// CJK UNIFIED IDEOGRAPH
	{0x737D,	0xF46D},	// CJK UNIFIED IDEOGRAPH
	{0x737E,	0xF5DD},	// CJK UNIFIED IDEOGRAPH
	{0x737F,	0xF6EF},	// CJK UNIFIED IDEOGRAPH
	{0x7380,	0xC57A},	// CJK UNIFIED IDEOGRAPH
	{0x7381,	0xF7E8},	// CJK UNIFIED IDEOGRAPH
	{0x7382,	0xF7E7},	// CJK UNIFIED IDEOGRAPH
	{0x7383,	0xF7E9},	// CJK UNIFIED IDEOGRAPH
	{0x7384,	0xA5C8},	// CJK UNIFIED IDEOGRAPH
	{0x7385,	0xCFC6},	// CJK UNIFIED IDEOGRAPH
	{0x7386,	0xAF59},	// CJK UNIFIED IDEOGRAPH
	{0x7387,	0xB276},	// CJK UNIFIED IDEOGRAPH
	{0x7388,	0xD66A},	// CJK UNIFIED IDEOGRAPH
	{0x7389,	0xA5C9},	// CJK UNIFIED IDEOGRAPH
	{0x738A,	0xC9A7},	// CJK UNIFIED IDEOGRAPH
	{0x738B,	0xA4FD},	// CJK UNIFIED IDEOGRAPH
	{0x738E,	0xCA45},	// CJK UNIFIED IDEOGRAPH
	{0x7392,	0xCB6C},	// CJK UNIFIED IDEOGRAPH
	{0x7393,	0xCB6A},	// CJK UNIFIED IDEOGRAPH
	{0x7394,	0xCB6B},	// CJK UNIFIED IDEOGRAPH
	{0x7395,	0xCB68},	// CJK UNIFIED IDEOGRAPH
	{0x7396,	0xA868},	// CJK UNIFIED IDEOGRAPH
	{0x7397,	0xCB69},	// CJK UNIFIED IDEOGRAPH
	{0x739D,	0xCD6D},	// CJK UNIFIED IDEOGRAPH
	{0x739F,	0xAAB3},	// CJK UNIFIED IDEOGRAPH
	{0x73A0,	0xCD6B},	// CJK UNIFIED IDEOGRAPH
	{0x73A1,	0xCD67},	// CJK UNIFIED IDEOGRAPH
	{0x73A2,	0xCD6A},	// CJK UNIFIED IDEOGRAPH
	{0x73A4,	0xCD66},	// CJK UNIFIED IDEOGRAPH
	{0x73A5,	0xAAB5},	// CJK UNIFIED IDEOGRAPH
	{0x73A6,	0xCD69},	// CJK UNIFIED IDEOGRAPH
	{0x73A8,	0xAAB2},	// CJK UNIFIED IDEOGRAPH
	{0x73A9,	0xAAB1},	// CJK UNIFIED IDEOGRAPH
	{0x73AB,	0xAAB4},	// CJK UNIFIED IDEOGRAPH
	{0x73AC,	0xCD6C},	// CJK UNIFIED IDEOGRAPH
	{0x73AD,	0xCD68},	// CJK UNIFIED IDEOGRAPH
	{0x73B2,	0xACC2},	// CJK UNIFIED IDEOGRAPH
	{0x73B3,	0xACC5},	// CJK UNIFIED IDEOGRAPH
	{0x73B4,	0xCFCE},	// CJK UNIFIED IDEOGRAPH
	{0x73B5,	0xCFCD},	// CJK UNIFIED IDEOGRAPH
	{0x73B6,	0xCFCC},	// CJK UNIFIED IDEOGRAPH
	{0x73B7,	0xACBF},	// CJK UNIFIED IDEOGRAPH
	{0x73B8,	0xCFD5},	// CJK UNIFIED IDEOGRAPH
	{0x73B9,	0xCFCB},	// CJK UNIFIED IDEOGRAPH
	{0x73BB,	0xACC1},	// CJK UNIFIED IDEOGRAPH
	{0x73BC,	0xD2AF},	// CJK UNIFIED IDEOGRAPH
	{0x73BE,	0xCFD2},	// CJK UNIFIED IDEOGRAPH
	{0x73BF,	0xCFD0},	// CJK UNIFIED IDEOGRAPH
	{0x73C0,	0xACC4},	// CJK UNIFIED IDEOGRAPH
	{0x73C2,	0xCFC8},	// CJK UNIFIED IDEOGRAPH
	{0x73C3,	0xCFD3},	// CJK UNIFIED IDEOGRAPH
	{0x73C5,	0xCFCA},	// CJK UNIFIED IDEOGRAPH
	{0x73C6,	0xCFD4},	// CJK UNIFIED IDEOGRAPH
	{0x73C7,	0xCFD1},	// CJK UNIFIED IDEOGRAPH
	{0x73C8,	0xCFC9},	// CJK UNIFIED IDEOGRAPH
	{0x73CA,	0xACC0},	// CJK UNIFIED IDEOGRAPH
	{0x73CB,	0xCFD6},	// CJK UNIFIED IDEOGRAPH
	{0x73CC,	0xCFC7},	// CJK UNIFIED IDEOGRAPH
	{0x73CD,	0xACC3},	// CJK UNIFIED IDEOGRAPH
	{0x73D2,	0xD2B4},	// CJK UNIFIED IDEOGRAPH
	{0x73D3,	0xD2AB},	// CJK UNIFIED IDEOGRAPH
	{0x73D4,	0xD2B6},	// CJK UNIFIED IDEOGRAPH
	{0x73D6,	0xD2AE},	// CJK UNIFIED IDEOGRAPH
	{0x73D7,	0xD2B9},	// CJK UNIFIED IDEOGRAPH
	{0x73D8,	0xD2BA},	// CJK UNIFIED IDEOGRAPH
	{0x73D9,	0xD2AC},	// CJK UNIFIED IDEOGRAPH
	{0x73DA,	0xD2B8},	// CJK UNIFIED IDEOGRAPH
	{0x73DB,	0xD2B5},	// CJK UNIFIED IDEOGRAPH
	{0x73DC,	0xD2B3},	// CJK UNIFIED IDEOGRAPH
	{0x73DD,	0xD2B7},	// CJK UNIFIED IDEOGRAPH
	{0x73DE,	0xAF5F},	// CJK UNIFIED IDEOGRAPH
	{0x73E0,	0xAF5D},	// CJK UNIFIED IDEOGRAPH
	{0x73E3,	0xD2B1},	// CJK UNIFIED IDEOGRAPH
	{0x73E5,	0xD2AD},	// CJK UNIFIED IDEOGRAPH
	{0x73E7,	0xD2B0},	// CJK UNIFIED IDEOGRAPH
	{0x73E8,	0xD2BB},	// CJK UNIFIED IDEOGRAPH
	{0x73E9,	0xD2B2},	// CJK UNIFIED IDEOGRAPH
	{0x73EA,	0xAF5E},	// CJK UNIFIED IDEOGRAPH
	{0x73EB,	0xCFCF},	// CJK UNIFIED IDEOGRAPH
	{0x73ED,	0xAF5A},	// CJK UNIFIED IDEOGRAPH
	{0x73EE,	0xAF5C},	// CJK UNIFIED IDEOGRAPH
	{0x73F4,	0xD678},	// CJK UNIFIED IDEOGRAPH
	{0x73F5,	0xD66D},	// CJK UNIFIED IDEOGRAPH
	{0x73F6,	0xD66B},	// CJK UNIFIED IDEOGRAPH
	{0x73F8,	0xD66C},	// CJK UNIFIED IDEOGRAPH
	{0x73FA,	0xD673},	// CJK UNIFIED IDEOGRAPH
	{0x73FC,	0xD674},	// CJK UNIFIED IDEOGRAPH
	{0x73FD,	0xD670},	// CJK UNIFIED IDEOGRAPH
	{0x73FE,	0xB27B},	// CJK UNIFIED IDEOGRAPH
	{0x73FF,	0xD675},	// CJK UNIFIED IDEOGRAPH
	{0x7400,	0xD672},	// CJK UNIFIED IDEOGRAPH
	{0x7401,	0xD66F},	// CJK UNIFIED IDEOGRAPH
	{0x7403,	0xB279},	// CJK UNIFIED IDEOGRAPH
	{0x7404,	0xD66E},	// CJK UNIFIED IDEOGRAPH
	{0x7405,	0xB277},	// CJK UNIFIED IDEOGRAPH
	{0x7406,	0xB27A},	// CJK UNIFIED IDEOGRAPH
	{0x7407,	0xD671},	// CJK UNIFIED IDEOGRAPH
	{0x7408,	0xD679},	// CJK UNIFIED IDEOGRAPH
	{0x7409,	0xAF5B},	// CJK UNIFIED IDEOGRAPH
	{0x740A,	0xB278},	// CJK UNIFIED IDEOGRAPH
	{0x740B,	0xD677},	// CJK UNIFIED IDEOGRAPH
	{0x740C,	0xD676},	// CJK UNIFIED IDEOGRAPH
	{0x740D,	0xB27C},	// CJK UNIFIED IDEOGRAPH
	{0x7416,	0xDA7E},	// CJK UNIFIED IDEOGRAPH
	{0x741A,	0xDAA1},	// CJK UNIFIED IDEOGRAPH
	{0x741B,	0xB560},	// CJK UNIFIED IDEOGRAPH
	{0x741D,	0xDAA7},	// CJK UNIFIED IDEOGRAPH
	{0x7420,	0xDAA9},	// CJK UNIFIED IDEOGRAPH
	{0x7421,	0xDAA2},	// CJK UNIFIED IDEOGRAPH
	{0x7422,	0xB55A},	// CJK UNIFIED IDEOGRAPH
	{0x7423,	0xDAA6},	// CJK UNIFIED IDEOGRAPH
	{0x7424,	0xDAA5},	// CJK UNIFIED IDEOGRAPH
	{0x7425,	0xB55B},	// CJK UNIFIED IDEOGRAPH
	{0x7426,	0xB561},	// CJK UNIFIED IDEOGRAPH
	{0x7428,	0xB562},	// CJK UNIFIED IDEOGRAPH
	{0x7429,	0xDAA8},	// CJK UNIFIED IDEOGRAPH
	{0x742A,	0xB558},	// CJK UNIFIED IDEOGRAPH
	{0x742B,	0xDA7D},	// CJK UNIFIED IDEOGRAPH
	{0x742C,	0xDA7B},	// CJK UNIFIED IDEOGRAPH
	{0x742D,	0xDAA3},	// CJK UNIFIED IDEOGRAPH
	{0x742E,	0xDA7A},	// CJK UNIFIED IDEOGRAPH
	{0x742F,	0xB55F},	// CJK UNIFIED IDEOGRAPH
	{0x7430,	0xDA7C},	// CJK UNIFIED IDEOGRAPH
	{0x7431,	0xDAA4},	// CJK UNIFIED IDEOGRAPH
	{0x7432,	0xDAAA},	// CJK UNIFIED IDEOGRAPH
	{0x7433,	0xB559},	// CJK UNIFIED IDEOGRAPH
	{0x7434,	0xB55E},	// CJK UNIFIED IDEOGRAPH
	{0x7435,	0xB55C},	// CJK UNIFIED IDEOGRAPH
	{0x7436,	0xB55D},	// CJK UNIFIED IDEOGRAPH
	{0x743A,	0xB557},	// CJK UNIFIED IDEOGRAPH
	{0x743F,	0xB7E9},	// CJK UNIFIED IDEOGRAPH
	{0x7440,	0xDEB7},	// CJK UNIFIED IDEOGRAPH
	{0x7441,	0xB7E8},	// CJK UNIFIED IDEOGRAPH
	{0x7442,	0xDEBB},	// CJK UNIFIED IDEOGRAPH
	{0x7444,	0xDEB1},	// CJK UNIFIED IDEOGRAPH
	{0x7446,	0xDEBC},	// CJK UNIFIED IDEOGRAPH
	{0x744A,	0xDEB2},	// CJK UNIFIED IDEOGRAPH
	{0x744B,	0xDEB3},	// CJK UNIFIED IDEOGRAPH
	{0x744D,	0xDEBD},	// CJK UNIFIED IDEOGRAPH
	{0x744E,	0xDEBA},	// CJK UNIFIED IDEOGRAPH
	{0x744F,	0xDEB8},	// CJK UNIFIED IDEOGRAPH
	{0x7450,	0xDEB9},	// CJK UNIFIED IDEOGRAPH
	{0x7451,	0xDEB5},	// CJK UNIFIED IDEOGRAPH
	{0x7452,	0xDEB4},	// CJK UNIFIED IDEOGRAPH
	{0x7454,	0xDEBE},	// CJK UNIFIED IDEOGRAPH
	{0x7455,	0xB7E5},	// CJK UNIFIED IDEOGRAPH
	{0x7457,	0xDEB6},	// CJK UNIFIED IDEOGRAPH
	{0x7459,	0xB7EA},	// CJK UNIFIED IDEOGRAPH
	{0x745A,	0xB7E4},	// CJK UNIFIED IDEOGRAPH
	{0x745B,	0xB7EB},	// CJK UNIFIED IDEOGRAPH
	{0x745C,	0xB7EC},	// CJK UNIFIED IDEOGRAPH
	{0x745E,	0xB7E7},	// CJK UNIFIED IDEOGRAPH
	{0x745F,	0xB7E6},	// CJK UNIFIED IDEOGRAPH
	{0x7462,	0xE2CE},	// CJK UNIFIED IDEOGRAPH
	{0x7463,	0xBABE},	// CJK UNIFIED IDEOGRAPH
	{0x7464,	0xBABD},	// CJK UNIFIED IDEOGRAPH
	{0x7467,	0xE2D3},	// CJK UNIFIED IDEOGRAPH
	{0x7469,	0xBCFC},	// CJK UNIFIED IDEOGRAPH
	{0x746A,	0xBABF},	// CJK UNIFIED IDEOGRAPH
	{0x746D,	0xBAC1},	// CJK UNIFIED IDEOGRAPH
	{0x746E,	0xE2D4},	// CJK UNIFIED IDEOGRAPH
	{0x746F,	0xB7E3},	// CJK UNIFIED IDEOGRAPH
	{0x7470,	0xBAC0},	// CJK UNIFIED IDEOGRAPH
	{0x7471,	0xE2D0},	// CJK UNIFIED IDEOGRAPH
	{0x7472,	0xE2D2},	// CJK UNIFIED IDEOGRAPH
	{0x7473,	0xE2CF},	// CJK UNIFIED IDEOGRAPH
	{0x7475,	0xE2D1},	// CJK UNIFIED IDEOGRAPH
	{0x7479,	0xE6AB},	// CJK UNIFIED IDEOGRAPH
	{0x747C,	0xE6AA},	// CJK UNIFIED IDEOGRAPH
	{0x747D,	0xE6A7},	// CJK UNIFIED IDEOGRAPH
	{0x747E,	0xBD40},	// CJK UNIFIED IDEOGRAPH
	{0x747F,	0xEA62},	// CJK UNIFIED IDEOGRAPH
	{0x7480,	0xBD41},	// CJK UNIFIED IDEOGRAPH
	{0x7481,	0xE6A6},	// CJK UNIFIED IDEOGRAPH
	{0x7483,	0xBCFE},	// CJK UNIFIED IDEOGRAPH
	{0x7485,	0xE6A8},	// CJK UNIFIED IDEOGRAPH
	{0x7486,	0xE6A5},	// CJK UNIFIED IDEOGRAPH
	{0x7487,	0xE6A2},	// CJK UNIFIED IDEOGRAPH
	{0x7488,	0xE6A9},	// CJK UNIFIED IDEOGRAPH
	{0x7489,	0xE6A3},	// CJK UNIFIED IDEOGRAPH
	{0x748A,	0xE6A4},	// CJK UNIFIED IDEOGRAPH
	{0x748B,	0xBCFD},	// CJK UNIFIED IDEOGRAPH
	{0x7490,	0xED69},	// CJK UNIFIED IDEOGRAPH
	{0x7492,	0xEA66},	// CJK UNIFIED IDEOGRAPH
	{0x7494,	0xEA65},	// CJK UNIFIED IDEOGRAPH
	{0x7495,	0xEA67},	// CJK UNIFIED IDEOGRAPH
	{0x7497,	0xED66},	// CJK UNIFIED IDEOGRAPH
	{0x7498,	0xBF5A},	// CJK UNIFIED IDEOGRAPH
	{0x749A,	0xEA63},	// CJK UNIFIED IDEOGRAPH
	{0x749C,	0xBF58},	// CJK UNIFIED IDEOGRAPH
	{0x749E,	0xBF5C},	// CJK UNIFIED IDEOGRAPH
	{0x749F,	0xBF5B},	// CJK UNIFIED IDEOGRAPH
	{0x74A0,	0xEA64},	// CJK UNIFIED IDEOGRAPH
	{0x74A1,	0xEA68},	// CJK UNIFIED IDEOGRAPH
	{0x74A3,	0xBF59},	// CJK UNIFIED IDEOGRAPH
	{0x74A5,	0xED6D},	// CJK UNIFIED IDEOGRAPH
	{0x74A6,	0xC0F5},	// CJK UNIFIED IDEOGRAPH
	{0x74A7,	0xC27A},	// CJK UNIFIED IDEOGRAPH
	{0x74A8,	0xC0F6},	// CJK UNIFIED IDEOGRAPH
	{0x74A9,	0xC0F3},	// CJK UNIFIED IDEOGRAPH
	{0x74AA,	0xED6A},	// CJK UNIFIED IDEOGRAPH
	{0x74AB,	0xED68},	// CJK UNIFIED IDEOGRAPH
	{0x74AD,	0xED6B},	// CJK UNIFIED IDEOGRAPH
	{0x74AF,	0xED6E},	// CJK UNIFIED IDEOGRAPH
	{0x74B0,	0xC0F4},	// CJK UNIFIED IDEOGRAPH
	{0x74B1,	0xED6C},	// CJK UNIFIED IDEOGRAPH
	{0x74B2,	0xED67},	// CJK UNIFIED IDEOGRAPH
	{0x74B5,	0xF042},	// CJK UNIFIED IDEOGRAPH
	{0x74B6,	0xF045},	// CJK UNIFIED IDEOGRAPH
	{0x74B7,	0xF275},	// CJK UNIFIED IDEOGRAPH
	{0x74B8,	0xF040},	// CJK UNIFIED IDEOGRAPH
	{0x74BA,	0xF46F},	// CJK UNIFIED IDEOGRAPH
	{0x74BB,	0xF046},	// CJK UNIFIED IDEOGRAPH
	{0x74BD,	0xC3A2},	// CJK UNIFIED IDEOGRAPH
	{0x74BE,	0xF044},	// CJK UNIFIED IDEOGRAPH
	{0x74BF,	0xC27B},	// CJK UNIFIED IDEOGRAPH
	{0x74C0,	0xF041},	// CJK UNIFIED IDEOGRAPH
	{0x74C1,	0xF043},	// CJK UNIFIED IDEOGRAPH
	{0x74C2,	0xF047},	// CJK UNIFIED IDEOGRAPH
	{0x74C3,	0xF276},	// CJK UNIFIED IDEOGRAPH
	{0x74C5,	0xF274},	// CJK UNIFIED IDEOGRAPH
	{0x74CA,	0xC3A3},	// CJK UNIFIED IDEOGRAPH
	{0x74CB,	0xF273},	// CJK UNIFIED IDEOGRAPH
	{0x74CF,	0xC46E},	// CJK UNIFIED IDEOGRAPH
	{0x74D4,	0xC4ED},	// CJK UNIFIED IDEOGRAPH
	{0x74D5,	0xF6F1},	// CJK UNIFIED IDEOGRAPH
	{0x74D6,	0xC4EC},	// CJK UNIFIED IDEOGRAPH
	{0x74D7,	0xF6F3},	// CJK UNIFIED IDEOGRAPH
	{0x74D8,	0xF6F0},	// CJK UNIFIED IDEOGRAPH
	{0x74D9,	0xF6F2},	// CJK UNIFIED IDEOGRAPH
	{0x74DA,	0xC5D0},	// CJK UNIFIED IDEOGRAPH
	{0x74DB,	0xF8B2},	// CJK UNIFIED IDEOGRAPH
	{0x74DC,	0xA5CA},	// CJK UNIFIED IDEOGRAPH
	{0x74DD,	0xCD6E},	// CJK UNIFIED IDEOGRAPH
	{0x74DE,	0xD2BC},	// CJK UNIFIED IDEOGRAPH
	{0x74DF,	0xD2BD},	// CJK UNIFIED IDEOGRAPH
	{0x74E0,	0xB27D},	// CJK UNIFIED IDEOGRAPH
	{0x74E1,	0xDEBF},	// CJK UNIFIED IDEOGRAPH
	{0x74E2,	0xBF5D},	// CJK UNIFIED IDEOGRAPH
	{0x74E3,	0xC3A4},	// CJK UNIFIED IDEOGRAPH
	{0x74E4,	0xC57B},	// CJK UNIFIED IDEOGRAPH
	{0x74E5,	0xF8B3},	// CJK UNIFIED IDEOGRAPH
	{0x74E6,	0xA5CB},	// CJK UNIFIED IDEOGRAPH
	{0x74E8,	0xCD6F},	// CJK UNIFIED IDEOGRAPH
	{0x74E9,	0xA260},	// CJK UNIFIED IDEOGRAPH
	{0x74EC,	0xCFD7},	// CJK UNIFIED IDEOGRAPH
	{0x74EE,	0xCFD8},	// CJK UNIFIED IDEOGRAPH
	{0x74F4,	0xD2BE},	// CJK UNIFIED IDEOGRAPH
	{0x74F5,	0xD2BF},	// CJK UNIFIED IDEOGRAPH
	{0x74F6,	0xB27E},	// CJK UNIFIED IDEOGRAPH
	{0x74F7,	0xB2A1},	// CJK UNIFIED IDEOGRAPH
	{0x74FB,	0xDAAB},	// CJK UNIFIED IDEOGRAPH
	{0x74FD,	0xDEC2},	// CJK UNIFIED IDEOGRAPH
	{0x74FE,	0xDEC1},	// CJK UNIFIED IDEOGRAPH
	{0x74FF,	0xDEC0},	// CJK UNIFIED IDEOGRAPH
	{0x7500,	0xE2D5},	// CJK UNIFIED IDEOGRAPH
	{0x7502,	0xE2D6},	// CJK UNIFIED IDEOGRAPH
	{0x7503,	0xE2D7},	// CJK UNIFIED IDEOGRAPH
	{0x7504,	0xBAC2},	// CJK UNIFIED IDEOGRAPH
	{0x7507,	0xE6AD},	// CJK UNIFIED IDEOGRAPH
	{0x7508,	0xE6AC},	// CJK UNIFIED IDEOGRAPH
	{0x750B,	0xEA69},	// CJK UNIFIED IDEOGRAPH
	{0x750C,	0xBF5E},	// CJK UNIFIED IDEOGRAPH
	{0x750D,	0xBF5F},	// CJK UNIFIED IDEOGRAPH
	{0x750F,	0xED72},	// CJK UNIFIED IDEOGRAPH
	{0x7510,	0xED6F},	// CJK UNIFIED IDEOGRAPH
	{0x7511,	0xED70},	// CJK UNIFIED IDEOGRAPH
	{0x7512,	0xED71},	// CJK UNIFIED IDEOGRAPH
	{0x7513,	0xF049},	// CJK UNIFIED IDEOGRAPH
	{0x7514,	0xF048},	// CJK UNIFIED IDEOGRAPH
	{0x7515,	0xC27C},	// CJK UNIFIED IDEOGRAPH
	{0x7516,	0xF277},	// CJK UNIFIED IDEOGRAPH
	{0x7517,	0xF5DE},	// CJK UNIFIED IDEOGRAPH
	{0x7518,	0xA5CC},	// CJK UNIFIED IDEOGRAPH
	{0x751A,	0xACC6},	// CJK UNIFIED IDEOGRAPH
	{0x751C,	0xB2A2},	// CJK UNIFIED IDEOGRAPH
	{0x751D,	0xDEC3},	// CJK UNIFIED IDEOGRAPH
	{0x751F,	0xA5CD},	// CJK UNIFIED IDEOGRAPH
	{0x7521,	0xD2C0},	// CJK UNIFIED IDEOGRAPH
	{0x7522,	0xB2A3},	// CJK UNIFIED IDEOGRAPH
	{0x7525,	0xB563},	// CJK UNIFIED IDEOGRAPH
	{0x7526,	0xB564},	// CJK UNIFIED IDEOGRAPH
	{0x7528,	0xA5CE},	// CJK UNIFIED IDEOGRAPH
	{0x7529,	0xA5CF},	// CJK UNIFIED IDEOGRAPH
	{0x752A,	0xCA46},	// CJK UNIFIED IDEOGRAPH
	{0x752B,	0xA86A},	// CJK UNIFIED IDEOGRAPH
	{0x752C,	0xA869},	// CJK UNIFIED IDEOGRAPH
	{0x752D,	0xACC7},	// CJK UNIFIED IDEOGRAPH
	{0x752E,	0xCFD9},	// CJK UNIFIED IDEOGRAPH
	{0x752F,	0xDAAC},	// CJK UNIFIED IDEOGRAPH
	{0x7530,	0xA5D0},	// CJK UNIFIED IDEOGRAPH
	{0x7531,	0xA5D1},	// CJK UNIFIED IDEOGRAPH
	{0x7532,	0xA5D2},	// CJK UNIFIED IDEOGRAPH
	{0x7533,	0xA5D3},	// CJK UNIFIED IDEOGRAPH
	{0x7537,	0xA86B},	// CJK UNIFIED IDEOGRAPH
	{0x7538,	0xA86C},	// CJK UNIFIED IDEOGRAPH
	{0x7539,	0xCB6E},	// CJK UNIFIED IDEOGRAPH
	{0x753A,	0xCB6D},	// CJK UNIFIED IDEOGRAPH
	{0x753D,	0xAAB6},	// CJK UNIFIED IDEOGRAPH
	{0x753E,	0xCD72},	// CJK UNIFIED IDEOGRAPH
	{0x753F,	0xCD70},	// CJK UNIFIED IDEOGRAPH
	{0x7540,	0xCD71},	// CJK UNIFIED IDEOGRAPH
	{0x7547,	0xCFDA},	// CJK UNIFIED IDEOGRAPH
	{0x7548,	0xCFDB},	// CJK UNIFIED IDEOGRAPH
	{0x754B,	0xACCB},	// CJK UNIFIED IDEOGRAPH
	{0x754C,	0xACC9},	// CJK UNIFIED IDEOGRAPH
	{0x754E,	0xACCA},	// CJK UNIFIED IDEOGRAPH
	{0x754F,	0xACC8},	// CJK UNIFIED IDEOGRAPH
	{0x7554,	0xAF60},	// CJK UNIFIED IDEOGRAPH
	{0x7559,	0xAF64},	// CJK UNIFIED IDEOGRAPH
	{0x755A,	0xAF63},	// CJK UNIFIED IDEOGRAPH
	{0x755B,	0xD2C1},	// CJK UNIFIED IDEOGRAPH
	{0x755C,	0xAF62},	// CJK UNIFIED IDEOGRAPH
	{0x755D,	0xAF61},	// CJK UNIFIED IDEOGRAPH
	{0x755F,	0xD2C2},	// CJK UNIFIED IDEOGRAPH
	{0x7562,	0xB2A6},	// CJK UNIFIED IDEOGRAPH
	{0x7563,	0xD67B},	// CJK UNIFIED IDEOGRAPH
	{0x7564,	0xD67A},	// CJK UNIFIED IDEOGRAPH
	{0x7565,	0xB2A4},	// CJK UNIFIED IDEOGRAPH
	{0x7566,	0xB2A5},	// CJK UNIFIED IDEOGRAPH
	{0x756A,	0xB566},	// CJK UNIFIED IDEOGRAPH
	{0x756B,	0xB565},	// CJK UNIFIED IDEOGRAPH
	{0x756C,	0xDAAE},	// CJK UNIFIED IDEOGRAPH
	{0x756F,	0xDAAD},	// CJK UNIFIED IDEOGRAPH
	{0x7570,	0xB2A7},	// CJK UNIFIED IDEOGRAPH
	{0x7576,	0xB7ED},	// CJK UNIFIED IDEOGRAPH
	{0x7577,	0xDEC5},	// CJK UNIFIED IDEOGRAPH
	{0x7578,	0xB7EE},	// CJK UNIFIED IDEOGRAPH
	{0x7579,	0xDEC4},	// CJK UNIFIED IDEOGRAPH
	{0x757D,	0xE2D8},	// CJK UNIFIED IDEOGRAPH
	{0x757E,	0xE6AE},	// CJK UNIFIED IDEOGRAPH
	{0x757F,	0xBD42},	// CJK UNIFIED IDEOGRAPH
	{0x7580,	0xEA6A},	// CJK UNIFIED IDEOGRAPH
	{0x7584,	0xED73},	// CJK UNIFIED IDEOGRAPH
	{0x7586,	0xC3A6},	// CJK UNIFIED IDEOGRAPH
	{0x7587,	0xC3A5},	// CJK UNIFIED IDEOGRAPH
	{0x758A,	0xC57C},	// CJK UNIFIED IDEOGRAPH
	{0x758B,	0xA5D4},	// CJK UNIFIED IDEOGRAPH
	{0x758C,	0xCD73},	// CJK UNIFIED IDEOGRAPH
	{0x758F,	0xB2A8},	// CJK UNIFIED IDEOGRAPH
	{0x7590,	0xE2D9},	// CJK UNIFIED IDEOGRAPH
	{0x7591,	0xBAC3},	// CJK UNIFIED IDEOGRAPH
	{0x7594,	0xCB6F},	// CJK UNIFIED IDEOGRAPH
	{0x7595,	0xCB70},	// CJK UNIFIED IDEOGRAPH
	{0x7598,	0xCD74},	// CJK UNIFIED IDEOGRAPH
	{0x7599,	0xAAB8},	// CJK UNIFIED IDEOGRAPH
	{0x759A,	0xAAB9},	// CJK UNIFIED IDEOGRAPH
	{0x759D,	0xAAB7},	// CJK UNIFIED IDEOGRAPH
	{0x75A2,	0xACCF},	// CJK UNIFIED IDEOGRAPH
	{0x75A3,	0xACD0},	// CJK UNIFIED IDEOGRAPH
	{0x75A4,	0xACCD},	// CJK UNIFIED IDEOGRAPH
	{0x75A5,	0xACCE},	// CJK UNIFIED IDEOGRAPH
	{0x75A7,	0xCFDC},	// CJK UNIFIED IDEOGRAPH
	{0x75AA,	0xCFDD},	// CJK UNIFIED IDEOGRAPH
	{0x75AB,	0xACCC},	// CJK UNIFIED IDEOGRAPH
	{0x75B0,	0xD2C3},	// CJK UNIFIED IDEOGRAPH
	{0x75B2,	0xAF68},	// CJK UNIFIED IDEOGRAPH
	{0x75B3,	0xAF69},	// CJK UNIFIED IDEOGRAPH
	{0x75B5,	0xB2AB},	// CJK UNIFIED IDEOGRAPH
	{0x75B6,	0xD2C9},	// CJK UNIFIED IDEOGRAPH
	{0x75B8,	0xAF6E},	// CJK UNIFIED IDEOGRAPH
	{0x75B9,	0xAF6C},	// CJK UNIFIED IDEOGRAPH
	{0x75BA,	0xD2CA},	// CJK UNIFIED IDEOGRAPH
	{0x75BB,	0xD2C5},	// CJK UNIFIED IDEOGRAPH
	{0x75BC,	0xAF6B},	// CJK UNIFIED IDEOGRAPH
	{0x75BD,	0xAF6A},	// CJK UNIFIED IDEOGRAPH
	{0x75BE,	0xAF65},	// CJK UNIFIED IDEOGRAPH
	{0x75BF,	0xD2C8},	// CJK UNIFIED IDEOGRAPH
	{0x75C0,	0xD2C7},	// CJK UNIFIED IDEOGRAPH
	{0x75C1,	0xD2C4},	// CJK UNIFIED IDEOGRAPH
	{0x75C2,	0xAF6D},	// CJK UNIFIED IDEOGRAPH
	{0x75C4,	0xD2C6},	// CJK UNIFIED IDEOGRAPH
	{0x75C5,	0xAF66},	// CJK UNIFIED IDEOGRAPH
	{0x75C7,	0xAF67},	// CJK UNIFIED IDEOGRAPH
	{0x75CA,	0xB2AC},	// CJK UNIFIED IDEOGRAPH
	{0x75CB,	0xD6A1},	// CJK UNIFIED IDEOGRAPH
	{0x75CC,	0xD6A2},	// CJK UNIFIED IDEOGRAPH
	{0x75CD,	0xB2AD},	// CJK UNIFIED IDEOGRAPH
	{0x75CE,	0xD67C},	// CJK UNIFIED IDEOGRAPH
	{0x75CF,	0xD67E},	// CJK UNIFIED IDEOGRAPH
	{0x75D0,	0xD6A4},	// CJK UNIFIED IDEOGRAPH
	{0x75D1,	0xD6A3},	// CJK UNIFIED IDEOGRAPH
	{0x75D2,	0xD67D},	// CJK UNIFIED IDEOGRAPH
	{0x75D4,	0xB2A9},	// CJK UNIFIED IDEOGRAPH
	{0x75D5,	0xB2AA},	// CJK UNIFIED IDEOGRAPH
	{0x75D7,	0xDAB6},	// CJK UNIFIED IDEOGRAPH
	{0x75D8,	0xB56B},	// CJK UNIFIED IDEOGRAPH
	{0x75D9,	0xB56A},	// CJK UNIFIED IDEOGRAPH
	{0x75DA,	0xDAB0},	// CJK UNIFIED IDEOGRAPH
	{0x75DB,	0xB568},	// CJK UNIFIED IDEOGRAPH
	{0x75DD,	0xDAB3},	// CJK UNIFIED IDEOGRAPH
	{0x75DE,	0xB56C},	// CJK UNIFIED IDEOGRAPH
	{0x75DF,	0xDAB4},	// CJK UNIFIED IDEOGRAPH
	{0x75E0,	0xB56D},	// CJK UNIFIED IDEOGRAPH
	{0x75E1,	0xDAB1},	// CJK UNIFIED IDEOGRAPH
	{0x75E2,	0xB567},	// CJK UNIFIED IDEOGRAPH
	{0x75E3,	0xB569},	// CJK UNIFIED IDEOGRAPH
	{0x75E4,	0xDAB5},	// CJK UNIFIED IDEOGRAPH
	{0x75E6,	0xDAB2},	// CJK UNIFIED IDEOGRAPH
	{0x75E7,	0xDAAF},	// CJK UNIFIED IDEOGRAPH
	{0x75ED,	0xDED2},	// CJK UNIFIED IDEOGRAPH
	{0x75EF,	0xDEC7},	// CJK UNIFIED IDEOGRAPH
	{0x75F0,	0xB7F0},	// CJK UNIFIED IDEOGRAPH
	{0x75F1,	0xB7F3},	// CJK UNIFIED IDEOGRAPH
	{0x75F2,	0xB7F2},	// CJK UNIFIED IDEOGRAPH
	{0x75F3,	0xB7F7},	// CJK UNIFIED IDEOGRAPH
	{0x75F4,	0xB7F6},	// CJK UNIFIED IDEOGRAPH
	{0x75F5,	0xDED3},	// CJK UNIFIED IDEOGRAPH
	{0x75F6,	0xDED1},	// CJK UNIFIED IDEOGRAPH
	{0x75F7,	0xDECA},	// CJK UNIFIED IDEOGRAPH
	{0x75F8,	0xDECE},	// CJK UNIFIED IDEOGRAPH
	{0x75F9,	0xDECD},	// CJK UNIFIED IDEOGRAPH
	{0x75FA,	0xB7F4},	// CJK UNIFIED IDEOGRAPH
	{0x75FB,	0xDED0},	// CJK UNIFIED IDEOGRAPH
	{0x75FC,	0xDECC},	// CJK UNIFIED IDEOGRAPH
	{0x75FD,	0xDED4},	// CJK UNIFIED IDEOGRAPH
	{0x75FE,	0xDECB},	// CJK UNIFIED IDEOGRAPH
	{0x75FF,	0xB7F5},	// CJK UNIFIED IDEOGRAPH
	{0x7600,	0xB7EF},	// CJK UNIFIED IDEOGRAPH
	{0x7601,	0xB7F1},	// CJK UNIFIED IDEOGRAPH
	{0x7603,	0xDEC9},	// CJK UNIFIED IDEOGRAPH
	{0x7608,	0xE2DB},	// CJK UNIFIED IDEOGRAPH
	{0x7609,	0xBAC7},	// CJK UNIFIED IDEOGRAPH
	{0x760A,	0xE2DF},	// CJK UNIFIED IDEOGRAPH
	{0x760B,	0xBAC6},	// CJK UNIFIED IDEOGRAPH
	{0x760C,	0xE2DC},	// CJK UNIFIED IDEOGRAPH
	{0x760D,	0xBAC5},	// CJK UNIFIED IDEOGRAPH
	{0x760F,	0xDEC8},	// CJK UNIFIED IDEOGRAPH
	{0x7610,	0xDECF},	// CJK UNIFIED IDEOGRAPH
	{0x7611,	0xE2DE},	// CJK UNIFIED IDEOGRAPH
	{0x7613,	0xBAC8},	// CJK UNIFIED IDEOGRAPH
	{0x7614,	0xE2E0},	// CJK UNIFIED IDEOGRAPH
	{0x7615,	0xE2DD},	// CJK UNIFIED IDEOGRAPH
	{0x7616,	0xE2DA},	// CJK UNIFIED IDEOGRAPH
	{0x7619,	0xE6B1},	// CJK UNIFIED IDEOGRAPH
	{0x761A,	0xE6B5},	// CJK UNIFIED IDEOGRAPH
	{0x761B,	0xE6B7},	// CJK UNIFIED IDEOGRAPH
	{0x761C,	0xE6B3},	// CJK UNIFIED IDEOGRAPH
	{0x761D,	0xE6B2},	// CJK UNIFIED IDEOGRAPH
	{0x761E,	0xE6B0},	// CJK UNIFIED IDEOGRAPH
	{0x761F,	0xBD45},	// CJK UNIFIED IDEOGRAPH
	{0x7620,	0xBD43},	// CJK UNIFIED IDEOGRAPH
	{0x7621,	0xBD48},	// CJK UNIFIED IDEOGRAPH
	{0x7622,	0xBD49},	// CJK UNIFIED IDEOGRAPH
	{0x7623,	0xE6B4},	// CJK UNIFIED IDEOGRAPH
	{0x7624,	0xBD46},	// CJK UNIFIED IDEOGRAPH
	{0x7625,	0xE6AF},	// CJK UNIFIED IDEOGRAPH
	{0x7626,	0xBD47},	// CJK UNIFIED IDEOGRAPH
	{0x7627,	0xBAC4},	// CJK UNIFIED IDEOGRAPH
	{0x7628,	0xE6B6},	// CJK UNIFIED IDEOGRAPH
	{0x7629,	0xBD44},	// CJK UNIFIED IDEOGRAPH
	{0x762D,	0xEA6C},	// CJK UNIFIED IDEOGRAPH
	{0x762F,	0xEA6B},	// CJK UNIFIED IDEOGRAPH
	{0x7630,	0xEA73},	// CJK UNIFIED IDEOGRAPH
	{0x7631,	0xEA6D},	// CJK UNIFIED IDEOGRAPH
	{0x7632,	0xEA72},	// CJK UNIFIED IDEOGRAPH
	{0x7633,	0xEA6F},	// CJK UNIFIED IDEOGRAPH
	{0x7634,	0xBF60},	// CJK UNIFIED IDEOGRAPH
	{0x7635,	0xEA71},	// CJK UNIFIED IDEOGRAPH
	{0x7638,	0xBF61},	// CJK UNIFIED IDEOGRAPH
	{0x763A,	0xBF62},	// CJK UNIFIED IDEOGRAPH
	{0x763C,	0xEA70},	// CJK UNIFIED IDEOGRAPH
	{0x763D,	0xEA6E},	// CJK UNIFIED IDEOGRAPH
	{0x7642,	0xC0F8},	// CJK UNIFIED IDEOGRAPH
	{0x7643,	0xED74},	// CJK UNIFIED IDEOGRAPH
	{0x7646,	0xC0F7},	// CJK UNIFIED IDEOGRAPH
	{0x7647,	0xED77},	// CJK UNIFIED IDEOGRAPH
	{0x7648,	0xED75},	// CJK UNIFIED IDEOGRAPH
	{0x7649,	0xED76},	// CJK UNIFIED IDEOGRAPH
	{0x764C,	0xC0F9},	// CJK UNIFIED IDEOGRAPH
	{0x7650,	0xF04D},	// CJK UNIFIED IDEOGRAPH
	{0x7652,	0xC2A1},	// CJK UNIFIED IDEOGRAPH
	{0x7653,	0xF04E},	// CJK UNIFIED IDEOGRAPH
	{0x7656,	0xC27D},	// CJK UNIFIED IDEOGRAPH
	{0x7657,	0xF04F},	// CJK UNIFIED IDEOGRAPH
	{0x7658,	0xC27E},	// CJK UNIFIED IDEOGRAPH
	{0x7659,	0xF04C},	// CJK UNIFIED IDEOGRAPH
	{0x765A,	0xF050},	// CJK UNIFIED IDEOGRAPH
	{0x765C,	0xF04A},	// CJK UNIFIED IDEOGRAPH
	{0x765F,	0xC3A7},	// CJK UNIFIED IDEOGRAPH
	{0x7660,	0xF278},	// CJK UNIFIED IDEOGRAPH
	{0x7661,	0xC3A8},	// CJK UNIFIED IDEOGRAPH
	{0x7662,	0xC46F},	// CJK UNIFIED IDEOGRAPH
	{0x7664,	0xF04B},	// CJK UNIFIED IDEOGRAPH
	{0x7665,	0xC470},	// CJK UNIFIED IDEOGRAPH
	{0x7669,	0xC4EE},	// CJK UNIFIED IDEOGRAPH
	{0x766A,	0xF5DF},	// CJK UNIFIED IDEOGRAPH
	{0x766C,	0xC57E},	// CJK UNIFIED IDEOGRAPH
	{0x766D,	0xF6F4},	// CJK UNIFIED IDEOGRAPH
	{0x766E,	0xC57D},	// CJK UNIFIED IDEOGRAPH
	{0x7670,	0xF7EA},	// CJK UNIFIED IDEOGRAPH
	{0x7671,	0xC5F5},	// CJK UNIFIED IDEOGRAPH
	{0x7672,	0xC5F6},	// CJK UNIFIED IDEOGRAPH
	{0x7675,	0xF9CC},	// CJK UNIFIED IDEOGRAPH
	{0x7678,	0xACD1},	// CJK UNIFIED IDEOGRAPH
	{0x7679,	0xCFDE},	// CJK UNIFIED IDEOGRAPH
	{0x767B,	0xB56E},	// CJK UNIFIED IDEOGRAPH
	{0x767C,	0xB56F},	// CJK UNIFIED IDEOGRAPH
	{0x767D,	0xA5D5},	// CJK UNIFIED IDEOGRAPH
	{0x767E,	0xA6CA},	// CJK UNIFIED IDEOGRAPH
	{0x767F,	0xCA47},	// CJK UNIFIED IDEOGRAPH
	{0x7681,	0xCB71},	// CJK UNIFIED IDEOGRAPH
	{0x7682,	0xA86D},	// CJK UNIFIED IDEOGRAPH
	{0x7684,	0xAABA},	// CJK UNIFIED IDEOGRAPH
	{0x7686,	0xACD2},	// CJK UNIFIED IDEOGRAPH
	{0x7687,	0xACD3},	// CJK UNIFIED IDEOGRAPH
	{0x7688,	0xACD4},	// CJK UNIFIED IDEOGRAPH
	{0x7689,	0xD6A6},	// CJK UNIFIED IDEOGRAPH
	{0x768A,	0xD2CB},	// CJK UNIFIED IDEOGRAPH
	{0x768B,	0xAF6F},	// CJK UNIFIED IDEOGRAPH
	{0x768E,	0xB2AE},	// CJK UNIFIED IDEOGRAPH
	{0x768F,	0xD6A5},	// CJK UNIFIED IDEOGRAPH
	{0x7692,	0xDAB8},	// CJK UNIFIED IDEOGRAPH
	{0x7693,	0xB571},	// CJK UNIFIED IDEOGRAPH
	{0x7695,	0xDAB7},	// CJK UNIFIED IDEOGRAPH
	{0x7696,	0xB570},	// CJK UNIFIED IDEOGRAPH
	{0x7699,	0xDED5},	// CJK UNIFIED IDEOGRAPH
	{0x769A,	0xBD4A},	// CJK UNIFIED IDEOGRAPH
	{0x769B,	0xE6BB},	// CJK UNIFIED IDEOGRAPH
	{0x769C,	0xE6B8},	// CJK UNIFIED IDEOGRAPH
	{0x769D,	0xE6B9},	// CJK UNIFIED IDEOGRAPH
	{0x769E,	0xE6BA},	// CJK UNIFIED IDEOGRAPH
	{0x76A4,	0xED78},	// CJK UNIFIED IDEOGRAPH
	{0x76A6,	0xF051},	// CJK UNIFIED IDEOGRAPH
	{0x76AA,	0xF471},	// CJK UNIFIED IDEOGRAPH
	{0x76AB,	0xF470},	// CJK UNIFIED IDEOGRAPH
	{0x76AD,	0xF6F5},	// CJK UNIFIED IDEOGRAPH
	{0x76AE,	0xA5D6},	// CJK UNIFIED IDEOGRAPH
	{0x76AF,	0xCD75},	// CJK UNIFIED IDEOGRAPH
	{0x76B0,	0xAF70},	// CJK UNIFIED IDEOGRAPH
	{0x76B4,	0xB572},	// CJK UNIFIED IDEOGRAPH
	{0x76B5,	0xDED6},	// CJK UNIFIED IDEOGRAPH
	{0x76B8,	0xE2E1},	// CJK UNIFIED IDEOGRAPH
	{0x76BA,	0xBD4B},	// CJK UNIFIED IDEOGRAPH
	{0x76BB,	0xEA74},	// CJK UNIFIED IDEOGRAPH
	{0x76BD,	0xF052},	// CJK UNIFIED IDEOGRAPH
	{0x76BE,	0xF472},	// CJK UNIFIED IDEOGRAPH
	{0x76BF,	0xA5D7},	// CJK UNIFIED IDEOGRAPH
	{0x76C2,	0xAABB},	// CJK UNIFIED IDEOGRAPH
	{0x76C3,	0xACD7},	// CJK UNIFIED IDEOGRAPH
	{0x76C4,	0xCFDF},	// CJK UNIFIED IDEOGRAPH
	{0x76C5,	0xACD8},	// CJK UNIFIED IDEOGRAPH
	{0x76C6,	0xACD6},	// CJK UNIFIED IDEOGRAPH
	{0x76C8,	0xACD5},	// CJK UNIFIED IDEOGRAPH
	{0x76C9,	0xD2CC},	// CJK UNIFIED IDEOGRAPH
	{0x76CA,	0xAF71},	// CJK UNIFIED IDEOGRAPH
	{0x76CD,	0xAF72},	// CJK UNIFIED IDEOGRAPH
	{0x76CE,	0xAF73},	// CJK UNIFIED IDEOGRAPH
	{0x76D2,	0xB2B0},	// CJK UNIFIED IDEOGRAPH
	{0x76D3,	0xD6A7},	// CJK UNIFIED IDEOGRAPH
	{0x76D4,	0xB2AF},	// CJK UNIFIED IDEOGRAPH
	{0x76DA,	0xDAB9},	// CJK UNIFIED IDEOGRAPH
	{0x76DB,	0xB2B1},	// CJK UNIFIED IDEOGRAPH
	{0x76DC,	0xB573},	// CJK UNIFIED IDEOGRAPH
	{0x76DD,	0xDED7},	// CJK UNIFIED IDEOGRAPH
	{0x76DE,	0xB7F8},	// CJK UNIFIED IDEOGRAPH
	{0x76DF,	0xB7F9},	// CJK UNIFIED IDEOGRAPH
	{0x76E1,	0xBAC9},	// CJK UNIFIED IDEOGRAPH
	{0x76E3,	0xBACA},	// CJK UNIFIED IDEOGRAPH
	{0x76E4,	0xBD4C},	// CJK UNIFIED IDEOGRAPH
	{0x76E5,	0xBF64},	// CJK UNIFIED IDEOGRAPH
	{0x76E6,	0xEA75},	// CJK UNIFIED IDEOGRAPH
	{0x76E7,	0xBF63},	// CJK UNIFIED IDEOGRAPH
	{0x76E9,	0xED79},	// CJK UNIFIED IDEOGRAPH
	{0x76EA,	0xC0FA},	// CJK UNIFIED IDEOGRAPH
	{0x76EC,	0xF053},	// CJK UNIFIED IDEOGRAPH
	{0x76ED,	0xF473},	// CJK UNIFIED IDEOGRAPH
	{0x76EE,	0xA5D8},	// CJK UNIFIED IDEOGRAPH
	{0x76EF,	0xA86E},	// CJK UNIFIED IDEOGRAPH
	{0x76F0,	0xCD78},	// CJK UNIFIED IDEOGRAPH
	{0x76F1,	0xCD77},	// CJK UNIFIED IDEOGRAPH
	{0x76F2,	0xAABC},	// CJK UNIFIED IDEOGRAPH
	{0x76F3,	0xCD76},	// CJK UNIFIED IDEOGRAPH
	{0x76F4,	0xAABD},	// CJK UNIFIED IDEOGRAPH
	{0x76F5,	0xCD79},	// CJK UNIFIED IDEOGRAPH
	{0x76F7,	0xCFE5},	// CJK UNIFIED IDEOGRAPH
	{0x76F8,	0xACDB},	// CJK UNIFIED IDEOGRAPH
	{0x76F9,	0xACDA},	// CJK UNIFIED IDEOGRAPH
	{0x76FA,	0xCFE7},	// CJK UNIFIED IDEOGRAPH
	{0x76FB,	0xCFE6},	// CJK UNIFIED IDEOGRAPH
	{0x76FC,	0xACDF},	// CJK UNIFIED IDEOGRAPH
	{0x76FE,	0xACDE},	// CJK UNIFIED IDEOGRAPH
	{0x7701,	0xACD9},	// CJK UNIFIED IDEOGRAPH
	{0x7703,	0xCFE1},	// CJK UNIFIED IDEOGRAPH
	{0x7704,	0xCFE2},	// CJK UNIFIED IDEOGRAPH
	{0x7705,	0xCFE3},	// CJK UNIFIED IDEOGRAPH
	{0x7707,	0xACE0},	// CJK UNIFIED IDEOGRAPH
	{0x7708,	0xCFE0},	// CJK UNIFIED IDEOGRAPH
	{0x7709,	0xACDC},	// CJK UNIFIED IDEOGRAPH
	{0x770A,	0xCFE4},	// CJK UNIFIED IDEOGRAPH
	{0x770B,	0xACDD},	// CJK UNIFIED IDEOGRAPH
	{0x7710,	0xD2CF},	// CJK UNIFIED IDEOGRAPH
	{0x7711,	0xD2D3},	// CJK UNIFIED IDEOGRAPH
	{0x7712,	0xD2D1},	// CJK UNIFIED IDEOGRAPH
	{0x7713,	0xD2D0},	// CJK UNIFIED IDEOGRAPH
	{0x7715,	0xD2D4},	// CJK UNIFIED IDEOGRAPH
	{0x7719,	0xD2D5},	// CJK UNIFIED IDEOGRAPH
	{0x771A,	0xD2D6},	// CJK UNIFIED IDEOGRAPH
	{0x771B,	0xD2CE},	// CJK UNIFIED IDEOGRAPH
	{0x771D,	0xD2CD},	// CJK UNIFIED IDEOGRAPH
	{0x771F,	0xAF75},	// CJK UNIFIED IDEOGRAPH
	{0x7720,	0xAF76},	// CJK UNIFIED IDEOGRAPH
	{0x7722,	0xD2D7},	// CJK UNIFIED IDEOGRAPH
	{0x7723,	0xD2D2},	// CJK UNIFIED IDEOGRAPH
	{0x7725,	0xD6B0},	// CJK UNIFIED IDEOGRAPH
	{0x7727,	0xD2D8},	// CJK UNIFIED IDEOGRAPH
	{0x7728,	0xAF77},	// CJK UNIFIED IDEOGRAPH
	{0x7729,	0xAF74},	// CJK UNIFIED IDEOGRAPH
	{0x772D,	0xD6AA},	// CJK UNIFIED IDEOGRAPH
	{0x772F,	0xD6A9},	// CJK UNIFIED IDEOGRAPH
	{0x7731,	0xD6AB},	// CJK UNIFIED IDEOGRAPH
	{0x7732,	0xD6AC},	// CJK UNIFIED IDEOGRAPH
	{0x7733,	0xD6AE},	// CJK UNIFIED IDEOGRAPH
	{0x7734,	0xD6AD},	// CJK UNIFIED IDEOGRAPH
	{0x7735,	0xD6B2},	// CJK UNIFIED IDEOGRAPH
	{0x7736,	0xB2B5},	// CJK UNIFIED IDEOGRAPH
	{0x7737,	0xB2B2},	// CJK UNIFIED IDEOGRAPH
	{0x7738,	0xB2B6},	// CJK UNIFIED IDEOGRAPH
	{0x7739,	0xD6A8},	// CJK UNIFIED IDEOGRAPH
	{0x773A,	0xB2B7},	// CJK UNIFIED IDEOGRAPH
	{0x773B,	0xD6B1},	// CJK UNIFIED IDEOGRAPH
	{0x773C,	0xB2B4},	// CJK UNIFIED IDEOGRAPH
	{0x773D,	0xD6AF},	// CJK UNIFIED IDEOGRAPH
	{0x773E,	0xB2B3},	// CJK UNIFIED IDEOGRAPH
	{0x7744,	0xDABC},	// CJK UNIFIED IDEOGRAPH
	{0x7745,	0xDABE},	// CJK UNIFIED IDEOGRAPH
	{0x7746,	0xDABA},	// CJK UNIFIED IDEOGRAPH
	{0x7747,	0xDABB},	// CJK UNIFIED IDEOGRAPH
	{0x774A,	0xDABF},	// CJK UNIFIED IDEOGRAPH
	{0x774B,	0xDAC1},	// CJK UNIFIED IDEOGRAPH
	{0x774C,	0xDAC2},	// CJK UNIFIED IDEOGRAPH
	{0x774D,	0xDABD},	// CJK UNIFIED IDEOGRAPH
	{0x774E,	0xDAC0},	// CJK UNIFIED IDEOGRAPH
	{0x774F,	0xB574},	// CJK UNIFIED IDEOGRAPH
	{0x7752,	0xDEDB},	// CJK UNIFIED IDEOGRAPH
	{0x7754,	0xDEE0},	// CJK UNIFIED IDEOGRAPH
	{0x7755,	0xDED8},	// CJK UNIFIED IDEOGRAPH
	{0x7756,	0xDEDC},	// CJK UNIFIED IDEOGRAPH
	{0x7759,	0xDEE1},	// CJK UNIFIED IDEOGRAPH
	{0x775A,	0xDEDD},	// CJK UNIFIED IDEOGRAPH
	{0x775B,	0xB7FA},	// CJK UNIFIED IDEOGRAPH
	{0x775C,	0xB843},	// CJK UNIFIED IDEOGRAPH
	{0x775E,	0xB7FD},	// CJK UNIFIED IDEOGRAPH
	{0x775F,	0xDED9},	// CJK UNIFIED IDEOGRAPH
	{0x7760,	0xDEDA},	// CJK UNIFIED IDEOGRAPH
	{0x7761,	0xBACE},	// CJK UNIFIED IDEOGRAPH
	{0x7762,	0xB846},	// CJK UNIFIED IDEOGRAPH
	{0x7763,	0xB7FE},	// CJK UNIFIED IDEOGRAPH
	{0x7765,	0xB844},	// CJK UNIFIED IDEOGRAPH
	{0x7766,	0xB7FC},	// CJK UNIFIED IDEOGRAPH
	{0x7767,	0xDEDF},	// CJK UNIFIED IDEOGRAPH
	{0x7768,	0xB845},	// CJK UNIFIED IDEOGRAPH
	{0x7769,	0xDEDE},	// CJK UNIFIED IDEOGRAPH
	{0x776A,	0xB841},	// CJK UNIFIED IDEOGRAPH
	{0x776B,	0xB7FB},	// CJK UNIFIED IDEOGRAPH
	{0x776C,	0xB842},	// CJK UNIFIED IDEOGRAPH
	{0x776D,	0xDEE2},	// CJK UNIFIED IDEOGRAPH
	{0x776E,	0xE2E6},	// CJK UNIFIED IDEOGRAPH
	{0x776F,	0xE2E8},	// CJK UNIFIED IDEOGRAPH
	{0x7779,	0xB840},	// CJK UNIFIED IDEOGRAPH
	{0x777C,	0xE2E3},	// CJK UNIFIED IDEOGRAPH
	{0x777D,	0xBACC},	// CJK UNIFIED IDEOGRAPH
	{0x777E,	0xE2E9},	// CJK UNIFIED IDEOGRAPH
	{0x777F,	0xBACD},	// CJK UNIFIED IDEOGRAPH
	{0x7780,	0xE2E7},	// CJK UNIFIED IDEOGRAPH
	{0x7781,	0xE2E2},	// CJK UNIFIED IDEOGRAPH
	{0x7782,	0xE2E5},	// CJK UNIFIED IDEOGRAPH
	{0x7783,	0xE2EA},	// CJK UNIFIED IDEOGRAPH
	{0x7784,	0xBACB},	// CJK UNIFIED IDEOGRAPH
	{0x7785,	0xE2E4},	// CJK UNIFIED IDEOGRAPH
	{0x7787,	0xBD4E},	// CJK UNIFIED IDEOGRAPH
	{0x7788,	0xE6BF},	// CJK UNIFIED IDEOGRAPH
	{0x7789,	0xE6BE},	// CJK UNIFIED IDEOGRAPH
	{0x778B,	0xBD51},	// CJK UNIFIED IDEOGRAPH
	{0x778C,	0xBD4F},	// CJK UNIFIED IDEOGRAPH
	{0x778D,	0xE6BC},	// CJK UNIFIED IDEOGRAPH
	{0x778E,	0xBD4D},	// CJK UNIFIED IDEOGRAPH
	{0x778F,	0xE6BD},	// CJK UNIFIED IDEOGRAPH
	{0x7791,	0xBD50},	// CJK UNIFIED IDEOGRAPH
	{0x7795,	0xEA7D},	// CJK UNIFIED IDEOGRAPH
	{0x7797,	0xEAA1},	// CJK UNIFIED IDEOGRAPH
	{0x7799,	0xEA7E},	// CJK UNIFIED IDEOGRAPH
	{0x779A,	0xEA76},	// CJK UNIFIED IDEOGRAPH
	{0x779B,	0xEA7A},	// CJK UNIFIED IDEOGRAPH
	{0x779C,	0xEA79},	// CJK UNIFIED IDEOGRAPH
	{0x779D,	0xEA77},	// CJK UNIFIED IDEOGRAPH
	{0x779E,	0xBF66},	// CJK UNIFIED IDEOGRAPH
	{0x779F,	0xBF67},	// CJK UNIFIED IDEOGRAPH
	{0x77A0,	0xBF65},	// CJK UNIFIED IDEOGRAPH
	{0x77A1,	0xEA78},	// CJK UNIFIED IDEOGRAPH
	{0x77A2,	0xEA7B},	// CJK UNIFIED IDEOGRAPH
	{0x77A3,	0xEA7C},	// CJK UNIFIED IDEOGRAPH
	{0x77A5,	0xBF68},	// CJK UNIFIED IDEOGRAPH
	{0x77A7,	0xC140},	// CJK UNIFIED IDEOGRAPH
	{0x77A8,	0xEDA3},	// CJK UNIFIED IDEOGRAPH
	{0x77AA,	0xC0FC},	// CJK UNIFIED IDEOGRAPH
	{0x77AB,	0xED7B},	// CJK UNIFIED IDEOGRAPH
	{0x77AC,	0xC0FE},	// CJK UNIFIED IDEOGRAPH
	{0x77AD,	0xC141},	// CJK UNIFIED IDEOGRAPH
	{0x77B0,	0xC0FD},	// CJK UNIFIED IDEOGRAPH
	{0x77B1,	0xEDA2},	// CJK UNIFIED IDEOGRAPH
	{0x77B2,	0xED7C},	// CJK UNIFIED IDEOGRAPH
	{0x77B3,	0xC0FB},	// CJK UNIFIED IDEOGRAPH
	{0x77B4,	0xEDA1},	// CJK UNIFIED IDEOGRAPH
	{0x77B5,	0xED7A},	// CJK UNIFIED IDEOGRAPH
	{0x77B6,	0xED7E},	// CJK UNIFIED IDEOGRAPH
	{0x77B7,	0xED7D},	// CJK UNIFIED IDEOGRAPH
	{0x77BA,	0xF055},	// CJK UNIFIED IDEOGRAPH
	{0x77BB,	0xC2A4},	// CJK UNIFIED IDEOGRAPH
	{0x77BC,	0xC2A5},	// CJK UNIFIED IDEOGRAPH
	{0x77BD,	0xC2A2},	// CJK UNIFIED IDEOGRAPH
	{0x77BF,	0xC2A3},	// CJK UNIFIED IDEOGRAPH
	{0x77C2,	0xF054},	// CJK UNIFIED IDEOGRAPH
	{0x77C4,	0xF27B},	// CJK UNIFIED IDEOGRAPH
	{0x77C7,	0xC3A9},	// CJK UNIFIED IDEOGRAPH
	{0x77C9,	0xF279},	// CJK UNIFIED IDEOGRAPH
	{0x77CA,	0xF27A},	// CJK UNIFIED IDEOGRAPH
	{0x77CC,	0xF474},	// CJK UNIFIED IDEOGRAPH
	{0x77CD,	0xF477},	// CJK UNIFIED IDEOGRAPH
	{0x77CE,	0xF475},	// CJK UNIFIED IDEOGRAPH
	{0x77CF,	0xF476},	// CJK UNIFIED IDEOGRAPH
	{0x77D0,	0xF5E0},	// CJK UNIFIED IDEOGRAPH
	{0x77D3,	0xC4EF},	// CJK UNIFIED IDEOGRAPH
	{0x77D4,	0xF7EB},	// CJK UNIFIED IDEOGRAPH
	{0x77D5,	0xF8B4},	// CJK UNIFIED IDEOGRAPH
	{0x77D7,	0xC5F7},	// CJK UNIFIED IDEOGRAPH
	{0x77D8,	0xF8F8},	// CJK UNIFIED IDEOGRAPH
	{0x77D9,	0xF8F9},	// CJK UNIFIED IDEOGRAPH
	{0x77DA,	0xC666},	// CJK UNIFIED IDEOGRAPH
	{0x77DB,	0xA5D9},	// CJK UNIFIED IDEOGRAPH
	{0x77DC,	0xACE1},	// CJK UNIFIED IDEOGRAPH
	{0x77DE,	0xDAC3},	// CJK UNIFIED IDEOGRAPH
	{0x77E0,	0xDEE3},	// CJK UNIFIED IDEOGRAPH
	{0x77E2,	0xA5DA},	// CJK UNIFIED IDEOGRAPH
	{0x77E3,	0xA86F},	// CJK UNIFIED IDEOGRAPH
	{0x77E5,	0xAABE},	// CJK UNIFIED IDEOGRAPH
	{0x77E7,	0xCFE8},	// CJK UNIFIED IDEOGRAPH
	{0x77E8,	0xCFE9},	// CJK UNIFIED IDEOGRAPH
	{0x77E9,	0xAF78},	// CJK UNIFIED IDEOGRAPH
	{0x77EC,	0xDAC4},	// CJK UNIFIED IDEOGRAPH
	{0x77ED,	0xB575},	// CJK UNIFIED IDEOGRAPH
	{0x77EE,	0xB847},	// CJK UNIFIED IDEOGRAPH
	{0x77EF,	0xC142},	// CJK UNIFIED IDEOGRAPH
	{0x77F0,	0xEDA4},	// CJK UNIFIED IDEOGRAPH
	{0x77F1,	0xF27C},	// CJK UNIFIED IDEOGRAPH
	{0x77F2,	0xF478},	// CJK UNIFIED IDEOGRAPH
	{0x77F3,	0xA5DB},	// CJK UNIFIED IDEOGRAPH
	{0x77F7,	0xCDA1},	// CJK UNIFIED IDEOGRAPH
	{0x77F8,	0xCD7A},	// CJK UNIFIED IDEOGRAPH
	{0x77F9,	0xCD7C},	// CJK UNIFIED IDEOGRAPH
	{0x77FA,	0xCD7E},	// CJK UNIFIED IDEOGRAPH
	{0x77FB,	0xCD7D},	// CJK UNIFIED IDEOGRAPH
	{0x77FC,	0xCD7B},	// CJK UNIFIED IDEOGRAPH
	{0x77FD,	0xAABF},	// CJK UNIFIED IDEOGRAPH
	{0x7802,	0xACE2},	// CJK UNIFIED IDEOGRAPH
	{0x7803,	0xCFF2},	// CJK UNIFIED IDEOGRAPH
	{0x7805,	0xCFED},	// CJK UNIFIED IDEOGRAPH
	{0x7806,	0xCFEA},	// CJK UNIFIED IDEOGRAPH
	{0x7809,	0xCFF1},	// CJK UNIFIED IDEOGRAPH
	{0x780C,	0xACE4},	// CJK UNIFIED IDEOGRAPH
	{0x780D,	0xACE5},	// CJK UNIFIED IDEOGRAPH
	{0x780E,	0xCFF0},	// CJK UNIFIED IDEOGRAPH
	{0x780F,	0xCFEF},	// CJK UNIFIED IDEOGRAPH
	{0x7810,	0xCFEE},	// CJK UNIFIED IDEOGRAPH
	{0x7811,	0xCFEB},	// CJK UNIFIED IDEOGRAPH
	{0x7812,	0xCFEC},	// CJK UNIFIED IDEOGRAPH
	{0x7813,	0xCFF3},	// CJK UNIFIED IDEOGRAPH
	{0x7814,	0xACE3},	// CJK UNIFIED IDEOGRAPH
	{0x781D,	0xAF7C},	// CJK UNIFIED IDEOGRAPH
	{0x781F,	0xAFA4},	// CJK UNIFIED IDEOGRAPH
	{0x7820,	0xAFA3},	// CJK UNIFIED IDEOGRAPH
	{0x7821,	0xD2E1},	// CJK UNIFIED IDEOGRAPH
	{0x7822,	0xD2DB},	// CJK UNIFIED IDEOGRAPH
	{0x7823,	0xD2D9},	// CJK UNIFIED IDEOGRAPH
	{0x7825,	0xAFA1},	// CJK UNIFIED IDEOGRAPH
	{0x7826,	0xD6B9},	// CJK UNIFIED IDEOGRAPH
	{0x7827,	0xAF7A},	// CJK UNIFIED IDEOGRAPH
	{0x7828,	0xD2DE},	// CJK UNIFIED IDEOGRAPH
	{0x7829,	0xD2E2},	// CJK UNIFIED IDEOGRAPH
	{0x782A,	0xD2E4},	// CJK UNIFIED IDEOGRAPH
	{0x782B,	0xD2E0},	// CJK UNIFIED IDEOGRAPH
	{0x782C,	0xD2DA},	// CJK UNIFIED IDEOGRAPH
	{0x782D,	0xAFA2},	// CJK UNIFIED IDEOGRAPH
	{0x782E,	0xD2DF},	// CJK UNIFIED IDEOGRAPH
	{0x782F,	0xD2DD},	// CJK UNIFIED IDEOGRAPH
	{0x7830,	0xAF79},	// CJK UNIFIED IDEOGRAPH
	{0x7831,	0xD2E5},	// CJK UNIFIED IDEOGRAPH
	{0x7832,	0xAFA5},	// CJK UNIFIED IDEOGRAPH
	{0x7833,	0xD2E3},	// CJK UNIFIED IDEOGRAPH
	{0x7834,	0xAF7D},	// CJK UNIFIED IDEOGRAPH
	{0x7835,	0xD2DC},	// CJK UNIFIED IDEOGRAPH
	{0x7837,	0xAF7E},	// CJK UNIFIED IDEOGRAPH
	{0x7838,	0xAF7B},	// CJK UNIFIED IDEOGRAPH
	{0x7843,	0xB2B9},	// CJK UNIFIED IDEOGRAPH
	{0x7845,	0xD6BA},	// CJK UNIFIED IDEOGRAPH
	{0x7848,	0xD6B3},	// CJK UNIFIED IDEOGRAPH
	{0x7849,	0xD6B5},	// CJK UNIFIED IDEOGRAPH
	{0x784A,	0xD6B7},	// CJK UNIFIED IDEOGRAPH
	{0x784C,	0xD6B8},	// CJK UNIFIED IDEOGRAPH
	{0x784D,	0xD6B6},	// CJK UNIFIED IDEOGRAPH
	{0x784E,	0xB2BA},	// CJK UNIFIED IDEOGRAPH
	{0x7850,	0xD6BB},	// CJK UNIFIED IDEOGRAPH
	{0x7852,	0xD6B4},	// CJK UNIFIED IDEOGRAPH
	{0x785C,	0xDAC8},	// CJK UNIFIED IDEOGRAPH
	{0x785D,	0xB576},	// CJK UNIFIED IDEOGRAPH
	{0x785E,	0xDAD0},	// CJK UNIFIED IDEOGRAPH
	{0x7860,	0xDAC5},	// CJK UNIFIED IDEOGRAPH
	{0x7862,	0xDAD1},	// CJK UNIFIED IDEOGRAPH
	{0x7864,	0xDAC6},	// CJK UNIFIED IDEOGRAPH
	{0x7865,	0xDAC7},	// CJK UNIFIED IDEOGRAPH
	{0x7868,	0xDACF},	// CJK UNIFIED IDEOGRAPH
	{0x7869,	0xDACE},	// CJK UNIFIED IDEOGRAPH
	{0x786A,	0xDACB},	// CJK UNIFIED IDEOGRAPH
	{0x786B,	0xB2B8},	// CJK UNIFIED IDEOGRAPH
	{0x786C,	0xB577},	// CJK UNIFIED IDEOGRAPH
	{0x786D,	0xDAC9},	// CJK UNIFIED IDEOGRAPH
	{0x786E,	0xDACC},	// CJK UNIFIED IDEOGRAPH
	{0x786F,	0xB578},	// CJK UNIFIED IDEOGRAPH
	{0x7870,	0xDACD},	// CJK UNIFIED IDEOGRAPH
	{0x7871,	0xDACA},	// CJK UNIFIED IDEOGRAPH
	{0x7879,	0xDEEE},	// CJK UNIFIED IDEOGRAPH
	{0x787B,	0xDEF2},	// CJK UNIFIED IDEOGRAPH
	{0x787C,	0xB84E},	// CJK UNIFIED IDEOGRAPH
	{0x787E,	0xE2F0},	// CJK UNIFIED IDEOGRAPH
	{0x787F,	0xB851},	// CJK UNIFIED IDEOGRAPH
	{0x7880,	0xDEF0},	// CJK UNIFIED IDEOGRAPH
	{0x7881,	0xF9D6},	// CJK UNIFIED IDEOGRAPH
	{0x7883,	0xDEED},	// CJK UNIFIED IDEOGRAPH
	{0x7884,	0xDEE8},	// CJK UNIFIED IDEOGRAPH
	{0x7885,	0xDEEA},	// CJK UNIFIED IDEOGRAPH
	{0x7886,	0xDEEB},	// CJK UNIFIED IDEOGRAPH
	{0x7887,	0xDEE4},	// CJK UNIFIED IDEOGRAPH
	{0x7889,	0xB84D},	// CJK UNIFIED IDEOGRAPH
	{0x788C,	0xB84C},	// CJK UNIFIED IDEOGRAPH
	{0x788E,	0xB848},	// CJK UNIFIED IDEOGRAPH
	{0x788F,	0xDEE7},	// CJK UNIFIED IDEOGRAPH
	{0x7891,	0xB84F},	// CJK UNIFIED IDEOGRAPH
	{0x7893,	0xB850},	// CJK UNIFIED IDEOGRAPH
	{0x7894,	0xDEE6},	// CJK UNIFIED IDEOGRAPH
	{0x7895,	0xDEE9},	// CJK UNIFIED IDEOGRAPH
	{0x7896,	0xDEF1},	// CJK UNIFIED IDEOGRAPH
	{0x7897,	0xB84A},	// CJK UNIFIED IDEOGRAPH
	{0x7898,	0xB84B},	// CJK UNIFIED IDEOGRAPH
	{0x7899,	0xDEEF},	// CJK UNIFIED IDEOGRAPH
	{0x789A,	0xDEE5},	// CJK UNIFIED IDEOGRAPH
	{0x789E,	0xE2F2},	// CJK UNIFIED IDEOGRAPH
	{0x789F,	0xBAD0},	// CJK UNIFIED IDEOGRAPH
	{0x78A0,	0xE2F4},	// CJK UNIFIED IDEOGRAPH
	{0x78A1,	0xDEEC},	// CJK UNIFIED IDEOGRAPH
	{0x78A2,	0xE2F6},	// CJK UNIFIED IDEOGRAPH
	{0x78A3,	0xBAD4},	// CJK UNIFIED IDEOGRAPH
	{0x78A4,	0xE2F7},	// CJK UNIFIED IDEOGRAPH
	{0x78A5,	0xE2F3},	// CJK UNIFIED IDEOGRAPH
	{0x78A7,	0xBAD1},	// CJK UNIFIED IDEOGRAPH
	{0x78A8,	0xE2EF},	// CJK UNIFIED IDEOGRAPH
	{0x78A9,	0xBAD3},	// CJK UNIFIED IDEOGRAPH
	{0x78AA,	0xE2EC},	// CJK UNIFIED IDEOGRAPH
	{0x78AB,	0xE2F1},	// CJK UNIFIED IDEOGRAPH
	{0x78AC,	0xE2F5},	// CJK UNIFIED IDEOGRAPH
	{0x78AD,	0xE2EE},	// CJK UNIFIED IDEOGRAPH
	{0x78B0,	0xB849},	// CJK UNIFIED IDEOGRAPH
	{0x78B2,	0xE2EB},	// CJK UNIFIED IDEOGRAPH
	{0x78B3,	0xBAD2},	// CJK UNIFIED IDEOGRAPH
	{0x78B4,	0xE2ED},	// CJK UNIFIED IDEOGRAPH
	{0x78BA,	0xBD54},	// CJK UNIFIED IDEOGRAPH
	{0x78BB,	0xE6C1},	// CJK UNIFIED IDEOGRAPH
	{0x78BC,	0xBD58},	// CJK UNIFIED IDEOGRAPH
	{0x78BE,	0xBD56},	// CJK UNIFIED IDEOGRAPH
	{0x78C1,	0xBACF},	// CJK UNIFIED IDEOGRAPH
	{0x78C3,	0xE6C8},	// CJK UNIFIED IDEOGRAPH
	{0x78C4,	0xE6C9},	// CJK UNIFIED IDEOGRAPH
	{0x78C5,	0xBD53},	// CJK UNIFIED IDEOGRAPH
	{0x78C8,	0xE6C7},	// CJK UNIFIED IDEOGRAPH
	{0x78C9,	0xE6CA},	// CJK UNIFIED IDEOGRAPH
	{0x78CA,	0xBD55},	// CJK UNIFIED IDEOGRAPH
	{0x78CB,	0xBD52},	// CJK UNIFIED IDEOGRAPH
	{0x78CC,	0xE6C3},	// CJK UNIFIED IDEOGRAPH
	{0x78CD,	0xE6C0},	// CJK UNIFIED IDEOGRAPH
	{0x78CE,	0xE6C5},	// CJK UNIFIED IDEOGRAPH
	{0x78CF,	0xE6C2},	// CJK UNIFIED IDEOGRAPH
	{0x78D0,	0xBD59},	// CJK UNIFIED IDEOGRAPH
	{0x78D1,	0xE6C4},	// CJK UNIFIED IDEOGRAPH
	{0x78D4,	0xE6C6},	// CJK UNIFIED IDEOGRAPH
	{0x78D5,	0xBD57},	// CJK UNIFIED IDEOGRAPH
	{0x78DA,	0xBF6A},	// CJK UNIFIED IDEOGRAPH
	{0x78DB,	0xEAA8},	// CJK UNIFIED IDEOGRAPH
	{0x78DD,	0xEAA2},	// CJK UNIFIED IDEOGRAPH
	{0x78DE,	0xEAA6},	// CJK UNIFIED IDEOGRAPH
	{0x78DF,	0xEAAC},	// CJK UNIFIED IDEOGRAPH
	{0x78E0,	0xEAAD},	// CJK UNIFIED IDEOGRAPH
	{0x78E1,	0xEAA9},	// CJK UNIFIED IDEOGRAPH
	{0x78E2,	0xEAAA},	// CJK UNIFIED IDEOGRAPH
	{0x78E3,	0xEAA7},	// CJK UNIFIED IDEOGRAPH
	{0x78E5,	0xEAA4},	// CJK UNIFIED IDEOGRAPH
	{0x78E7,	0xBF6C},	// CJK UNIFIED IDEOGRAPH
	{0x78E8,	0xBF69},	// CJK UNIFIED IDEOGRAPH
	{0x78E9,	0xEAA3},	// CJK UNIFIED IDEOGRAPH
	{0x78EA,	0xEAA5},	// CJK UNIFIED IDEOGRAPH
	{0x78EC,	0xBF6B},	// CJK UNIFIED IDEOGRAPH
	{0x78ED,	0xEAAB},	// CJK UNIFIED IDEOGRAPH
	{0x78EF,	0xC146},	// CJK UNIFIED IDEOGRAPH
	{0x78F2,	0xEDAA},	// CJK UNIFIED IDEOGRAPH
	{0x78F3,	0xEDA5},	// CJK UNIFIED IDEOGRAPH
	{0x78F4,	0xC145},	// CJK UNIFIED IDEOGRAPH
	{0x78F7,	0xC143},	// CJK UNIFIED IDEOGRAPH
	{0x78F9,	0xEDAC},	// CJK UNIFIED IDEOGRAPH
	{0x78FA,	0xC144},	// CJK UNIFIED IDEOGRAPH
	{0x78FB,	0xEDA8},	// CJK UNIFIED IDEOGRAPH
	{0x78FC,	0xEDA9},	// CJK UNIFIED IDEOGRAPH
	{0x78FD,	0xEDA6},	// CJK UNIFIED IDEOGRAPH
	{0x78FE,	0xEDAD},	// CJK UNIFIED IDEOGRAPH
	{0x78FF,	0xF056},	// CJK UNIFIED IDEOGRAPH
	{0x7901,	0xC147},	// CJK UNIFIED IDEOGRAPH
	{0x7902,	0xEDA7},	// CJK UNIFIED IDEOGRAPH
	{0x7904,	0xEDAE},	// CJK UNIFIED IDEOGRAPH
	{0x7905,	0xEDAB},	// CJK UNIFIED IDEOGRAPH
	{0x7909,	0xF05A},	// CJK UNIFIED IDEOGRAPH
	{0x790C,	0xF057},	// CJK UNIFIED IDEOGRAPH
	{0x790E,	0xC2A6},	// CJK UNIFIED IDEOGRAPH
	{0x7910,	0xF05B},	// CJK UNIFIED IDEOGRAPH
	{0x7911,	0xF05D},	// CJK UNIFIED IDEOGRAPH
	{0x7912,	0xF05C},	// CJK UNIFIED IDEOGRAPH
	{0x7913,	0xF058},	// CJK UNIFIED IDEOGRAPH
	{0x7914,	0xF059},	// CJK UNIFIED IDEOGRAPH
	{0x7917,	0xF2A3},	// CJK UNIFIED IDEOGRAPH
	{0x7919,	0xC3AA},	// CJK UNIFIED IDEOGRAPH
	{0x791B,	0xF27E},	// CJK UNIFIED IDEOGRAPH
	{0x791C,	0xF2A2},	// CJK UNIFIED IDEOGRAPH
	{0x791D,	0xF27D},	// CJK UNIFIED IDEOGRAPH
	{0x791E,	0xF2A4},	// CJK UNIFIED IDEOGRAPH
	{0x7921,	0xF2A1},	// CJK UNIFIED IDEOGRAPH
	{0x7923,	0xF47A},	// CJK UNIFIED IDEOGRAPH
	{0x7924,	0xF47D},	// CJK UNIFIED IDEOGRAPH
	{0x7925,	0xF479},	// CJK UNIFIED IDEOGRAPH
	{0x7926,	0xC471},	// CJK UNIFIED IDEOGRAPH
	{0x7927,	0xF47B},	// CJK UNIFIED IDEOGRAPH
	{0x7928,	0xF47C},	// CJK UNIFIED IDEOGRAPH
	{0x7929,	0xF47E},	// CJK UNIFIED IDEOGRAPH
	{0x792A,	0xC472},	// CJK UNIFIED IDEOGRAPH
	{0x792B,	0xC474},	// CJK UNIFIED IDEOGRAPH
	{0x792C,	0xC473},	// CJK UNIFIED IDEOGRAPH
	{0x792D,	0xF5E1},	// CJK UNIFIED IDEOGRAPH
	{0x792F,	0xF5E3},	// CJK UNIFIED IDEOGRAPH
	{0x7931,	0xF5E2},	// CJK UNIFIED IDEOGRAPH
	{0x7935,	0xF6F6},	// CJK UNIFIED IDEOGRAPH
	{0x7938,	0xF8B5},	// CJK UNIFIED IDEOGRAPH
	{0x7939,	0xF8FA},	// CJK UNIFIED IDEOGRAPH
	{0x793A,	0xA5DC},	// CJK UNIFIED IDEOGRAPH
	{0x793D,	0xCB72},	// CJK UNIFIED IDEOGRAPH
	{0x793E,	0xAAC0},	// CJK UNIFIED IDEOGRAPH
	{0x793F,	0xCDA3},	// CJK UNIFIED IDEOGRAPH
	{0x7940,	0xAAC1},	// CJK UNIFIED IDEOGRAPH
	{0x7941,	0xAAC2},	// CJK UNIFIED IDEOGRAPH
	{0x7942,	0xCDA2},	// CJK UNIFIED IDEOGRAPH
	{0x7944,	0xCFF8},	// CJK UNIFIED IDEOGRAPH
	{0x7945,	0xCFF7},	// CJK UNIFIED IDEOGRAPH
	{0x7946,	0xACE6},	// CJK UNIFIED IDEOGRAPH
	{0x7947,	0xACE9},	// CJK UNIFIED IDEOGRAPH
	{0x7948,	0xACE8},	// CJK UNIFIED IDEOGRAPH
	{0x7949,	0xACE7},	// CJK UNIFIED IDEOGRAPH
	{0x794A,	0xCFF4},	// CJK UNIFIED IDEOGRAPH
	{0x794B,	0xCFF6},	// CJK UNIFIED IDEOGRAPH
	{0x794C,	0xCFF5},	// CJK UNIFIED IDEOGRAPH
	{0x794F,	0xD2E8},	// CJK UNIFIED IDEOGRAPH
	{0x7950,	0xAFA7},	// CJK UNIFIED IDEOGRAPH
	{0x7951,	0xD2EC},	// CJK UNIFIED IDEOGRAPH
	{0x7952,	0xD2EB},	// CJK UNIFIED IDEOGRAPH
	{0x7953,	0xD2EA},	// CJK UNIFIED IDEOGRAPH
	{0x7954,	0xD2E6},	// CJK UNIFIED IDEOGRAPH
	{0x7955,	0xAFA6},	// CJK UNIFIED IDEOGRAPH
	{0x7956,	0xAFAA},	// CJK UNIFIED IDEOGRAPH
	{0x7957,	0xAFAD},	// CJK UNIFIED IDEOGRAPH
	{0x795A,	0xAFAE},	// CJK UNIFIED IDEOGRAPH
	{0x795B,	0xD2E7},	// CJK UNIFIED IDEOGRAPH
	{0x795C,	0xD2E9},	// CJK UNIFIED IDEOGRAPH
	{0x795D,	0xAFAC},	// CJK UNIFIED IDEOGRAPH
	{0x795E,	0xAFAB},	// CJK UNIFIED IDEOGRAPH
	{0x795F,	0xAFA9},	// CJK UNIFIED IDEOGRAPH
	{0x7960,	0xAFA8},	// CJK UNIFIED IDEOGRAPH
	{0x7961,	0xD6C2},	// CJK UNIFIED IDEOGRAPH
	{0x7963,	0xD6C0},	// CJK UNIFIED IDEOGRAPH
	{0x7964,	0xD6BC},	// CJK UNIFIED IDEOGRAPH
	{0x7965,	0xB2BB},	// CJK UNIFIED IDEOGRAPH
	{0x7967,	0xD6BD},	// CJK UNIFIED IDEOGRAPH
	{0x7968,	0xB2BC},	// CJK UNIFIED IDEOGRAPH
	{0x7969,	0xD6BE},	// CJK UNIFIED IDEOGRAPH
	{0x796A,	0xD6BF},	// CJK UNIFIED IDEOGRAPH
	{0x796B,	0xD6C1},	// CJK UNIFIED IDEOGRAPH
	{0x796D,	0xB2BD},	// CJK UNIFIED IDEOGRAPH
	{0x7970,	0xDAD5},	// CJK UNIFIED IDEOGRAPH
	{0x7972,	0xDAD4},	// CJK UNIFIED IDEOGRAPH
	{0x7973,	0xDAD3},	// CJK UNIFIED IDEOGRAPH
	{0x7974,	0xDAD2},	// CJK UNIFIED IDEOGRAPH
	{0x7979,	0xDEF6},	// CJK UNIFIED IDEOGRAPH
	{0x797A,	0xB852},	// CJK UNIFIED IDEOGRAPH
	{0x797C,	0xDEF3},	// CJK UNIFIED IDEOGRAPH
	{0x797D,	0xDEF5},	// CJK UNIFIED IDEOGRAPH
	{0x797F,	0xB853},	// CJK UNIFIED IDEOGRAPH
	{0x7981,	0xB854},	// CJK UNIFIED IDEOGRAPH
	{0x7982,	0xDEF4},	// CJK UNIFIED IDEOGRAPH
	{0x7988,	0xE341},	// CJK UNIFIED IDEOGRAPH
	{0x798A,	0xE2F9},	// CJK UNIFIED IDEOGRAPH
	{0x798B,	0xE2FA},	// CJK UNIFIED IDEOGRAPH
	{0x798D,	0xBAD7},	// CJK UNIFIED IDEOGRAPH
	{0x798E,	0xBAD5},	// CJK UNIFIED IDEOGRAPH
	{0x798F,	0xBAD6},	// CJK UNIFIED IDEOGRAPH
	{0x7990,	0xE343},	// CJK UNIFIED IDEOGRAPH
	{0x7992,	0xE342},	// CJK UNIFIED IDEOGRAPH
	{0x7993,	0xE2FE},	// CJK UNIFIED IDEOGRAPH
	{0x7994,	0xE2FD},	// CJK UNIFIED IDEOGRAPH
	{0x7995,	0xE2FC},	// CJK UNIFIED IDEOGRAPH
	{0x7996,	0xE2FB},	// CJK UNIFIED IDEOGRAPH
	{0x7997,	0xE340},	// CJK UNIFIED IDEOGRAPH
	{0x7998,	0xE2F8},	// CJK UNIFIED IDEOGRAPH
	{0x799A,	0xE6CB},	// CJK UNIFIED IDEOGRAPH
	{0x799B,	0xE6D0},	// CJK UNIFIED IDEOGRAPH
	{0x799C,	0xE6CE},	// CJK UNIFIED IDEOGRAPH
	{0x79A0,	0xE6CD},	// CJK UNIFIED IDEOGRAPH
	{0x79A1,	0xE6CC},	// CJK UNIFIED IDEOGRAPH
	{0x79A2,	0xE6CF},	// CJK UNIFIED IDEOGRAPH
	{0x79A4,	0xEAAE},	// CJK UNIFIED IDEOGRAPH
	{0x79A6,	0xBF6D},	// CJK UNIFIED IDEOGRAPH
	{0x79A7,	0xC148},	// CJK UNIFIED IDEOGRAPH
	{0x79A8,	0xEDB0},	// CJK UNIFIED IDEOGRAPH
	{0x79AA,	0xC149},	// CJK UNIFIED IDEOGRAPH
	{0x79AB,	0xEDAF},	// CJK UNIFIED IDEOGRAPH
	{0x79AC,	0xF05F},	// CJK UNIFIED IDEOGRAPH
	{0x79AD,	0xF05E},	// CJK UNIFIED IDEOGRAPH
	{0x79AE,	0xC2A7},	// CJK UNIFIED IDEOGRAPH
	{0x79B0,	0xF2A5},	// CJK UNIFIED IDEOGRAPH
	{0x79B1,	0xC3AB},	// CJK UNIFIED IDEOGRAPH
	{0x79B2,	0xF4A1},	// CJK UNIFIED IDEOGRAPH
	{0x79B3,	0xC5A1},	// CJK UNIFIED IDEOGRAPH
	{0x79B4,	0xF6F7},	// CJK UNIFIED IDEOGRAPH
	{0x79B6,	0xF8B7},	// CJK UNIFIED IDEOGRAPH
	{0x79B7,	0xF8B6},	// CJK UNIFIED IDEOGRAPH
	{0x79B8,	0xC9A8},	// CJK UNIFIED IDEOGRAPH
	{0x79B9,	0xACEA},	// CJK UNIFIED IDEOGRAPH
	{0x79BA,	0xACEB},	// CJK UNIFIED IDEOGRAPH
	{0x79BB,	0xD6C3},	// CJK UNIFIED IDEOGRAPH
	{0x79BD,	0xB856},	// CJK UNIFIED IDEOGRAPH
	{0x79BE,	0xA5DD},	// CJK UNIFIED IDEOGRAPH
	{0x79BF,	0xA872},	// CJK UNIFIED IDEOGRAPH
	{0x79C0,	0xA871},	// CJK UNIFIED IDEOGRAPH
	{0x79C1,	0xA870},	// CJK UNIFIED IDEOGRAPH
	{0x79C5,	0xCDA4},	// CJK UNIFIED IDEOGRAPH
	{0x79C8,	0xAAC4},	// CJK UNIFIED IDEOGRAPH
	{0x79C9,	0xAAC3},	// CJK UNIFIED IDEOGRAPH
	{0x79CB,	0xACEE},	// CJK UNIFIED IDEOGRAPH
	{0x79CD,	0xCFFA},	// CJK UNIFIED IDEOGRAPH
	{0x79CE,	0xCFFD},	// CJK UNIFIED IDEOGRAPH
	{0x79CF,	0xCFFB},	// CJK UNIFIED IDEOGRAPH
	{0x79D1,	0xACEC},	// CJK UNIFIED IDEOGRAPH
	{0x79D2,	0xACED},	// CJK UNIFIED IDEOGRAPH
	{0x79D5,	0xCFF9},	// CJK UNIFIED IDEOGRAPH
	{0x79D6,	0xCFFC},	// CJK UNIFIED IDEOGRAPH
	{0x79D8,	0xAFB5},	// CJK UNIFIED IDEOGRAPH
	{0x79DC,	0xD2F3},	// CJK UNIFIED IDEOGRAPH
	{0x79DD,	0xD2F5},	// CJK UNIFIED IDEOGRAPH
	{0x79DE,	0xD2F4},	// CJK UNIFIED IDEOGRAPH
	{0x79DF,	0xAFB2},	// CJK UNIFIED IDEOGRAPH
	{0x79E0,	0xD2EF},	// CJK UNIFIED IDEOGRAPH
	{0x79E3,	0xAFB0},	// CJK UNIFIED IDEOGRAPH
	{0x79E4,	0xAFAF},	// CJK UNIFIED IDEOGRAPH
	{0x79E6,	0xAFB3},	// CJK UNIFIED IDEOGRAPH
	{0x79E7,	0xAFB1},	// CJK UNIFIED IDEOGRAPH
	{0x79E9,	0xAFB4},	// CJK UNIFIED IDEOGRAPH
	{0x79EA,	0xD2F2},	// CJK UNIFIED IDEOGRAPH
	{0x79EB,	0xD2ED},	// CJK UNIFIED IDEOGRAPH
	{0x79EC,	0xD2EE},	// CJK UNIFIED IDEOGRAPH
	{0x79ED,	0xD2F1},	// CJK UNIFIED IDEOGRAPH
	{0x79EE,	0xD2F0},	// CJK UNIFIED IDEOGRAPH
	{0x79F6,	0xD6C6},	// CJK UNIFIED IDEOGRAPH
	{0x79F7,	0xD6C7},	// CJK UNIFIED IDEOGRAPH
	{0x79F8,	0xD6C5},	// CJK UNIFIED IDEOGRAPH
	{0x79FA,	0xD6C4},	// CJK UNIFIED IDEOGRAPH
	{0x79FB,	0xB2BE},	// CJK UNIFIED IDEOGRAPH
	{0x7A00,	0xB57D},	// CJK UNIFIED IDEOGRAPH
	{0x7A02,	0xDAD6},	// CJK UNIFIED IDEOGRAPH
	{0x7A03,	0xDAD8},	// CJK UNIFIED IDEOGRAPH
	{0x7A04,	0xDADA},	// CJK UNIFIED IDEOGRAPH
	{0x7A05,	0xB57C},	// CJK UNIFIED IDEOGRAPH
	{0x7A08,	0xB57A},	// CJK UNIFIED IDEOGRAPH
	{0x7A0A,	0xDAD7},	// CJK UNIFIED IDEOGRAPH
	{0x7A0B,	0xB57B},	// CJK UNIFIED IDEOGRAPH
	{0x7A0C,	0xDAD9},	// CJK UNIFIED IDEOGRAPH
	{0x7A0D,	0xB579},	// CJK UNIFIED IDEOGRAPH
	{0x7A10,	0xDF41},	// CJK UNIFIED IDEOGRAPH
	{0x7A11,	0xDEF7},	// CJK UNIFIED IDEOGRAPH
	{0x7A12,	0xDEFA},	// CJK UNIFIED IDEOGRAPH
	{0x7A13,	0xDEFE},	// CJK UNIFIED IDEOGRAPH
	{0x7A14,	0xB85A},	// CJK UNIFIED IDEOGRAPH
	{0x7A15,	0xDEFC},	// CJK UNIFIED IDEOGRAPH
	{0x7A17,	0xDEFB},	// CJK UNIFIED IDEOGRAPH
	{0x7A18,	0xDEF8},	// CJK UNIFIED IDEOGRAPH
	{0x7A19,	0xDEF9},	// CJK UNIFIED IDEOGRAPH
	{0x7A1A,	0xB858},	// CJK UNIFIED IDEOGRAPH
	{0x7A1B,	0xDF40},	// CJK UNIFIED IDEOGRAPH
	{0x7A1C,	0xB857},	// CJK UNIFIED IDEOGRAPH
	{0x7A1E,	0xB85C},	// CJK UNIFIED IDEOGRAPH
	{0x7A1F,	0xB85B},	// CJK UNIFIED IDEOGRAPH
	{0x7A20,	0xB859},	// CJK UNIFIED IDEOGRAPH
	{0x7A22,	0xDEFD},	// CJK UNIFIED IDEOGRAPH
	{0x7A26,	0xE349},	// CJK UNIFIED IDEOGRAPH
	{0x7A28,	0xE348},	// CJK UNIFIED IDEOGRAPH
	{0x7A2B,	0xE344},	// CJK UNIFIED IDEOGRAPH
	{0x7A2E,	0xBAD8},	// CJK UNIFIED IDEOGRAPH
	{0x7A2F,	0xE347},	// CJK UNIFIED IDEOGRAPH
	{0x7A30,	0xE346},	// CJK UNIFIED IDEOGRAPH
	{0x7A31,	0xBAD9},	// CJK UNIFIED IDEOGRAPH
	{0x7A37,	0xBD5E},	// CJK UNIFIED IDEOGRAPH
	{0x7A39,	0xE6D2},	// CJK UNIFIED IDEOGRAPH
	{0x7A3B,	0xBD5F},	// CJK UNIFIED IDEOGRAPH
	{0x7A3C,	0xBD5B},	// CJK UNIFIED IDEOGRAPH
	{0x7A3D,	0xBD5D},	// CJK UNIFIED IDEOGRAPH
	{0x7A3F,	0xBD5A},	// CJK UNIFIED IDEOGRAPH
	{0x7A40,	0xBD5C},	// CJK UNIFIED IDEOGRAPH
	{0x7A44,	0xEAAF},	// CJK UNIFIED IDEOGRAPH
	{0x7A46,	0xBF70},	// CJK UNIFIED IDEOGRAPH
	{0x7A47,	0xEAB1},	// CJK UNIFIED IDEOGRAPH
	{0x7A48,	0xEAB0},	// CJK UNIFIED IDEOGRAPH
	{0x7A4A,	0xE345},	// CJK UNIFIED IDEOGRAPH
	{0x7A4B,	0xBF72},	// CJK UNIFIED IDEOGRAPH
	{0x7A4C,	0xBF71},	// CJK UNIFIED IDEOGRAPH
	{0x7A4D,	0xBF6E},	// CJK UNIFIED IDEOGRAPH
	{0x7A4E,	0xBF6F},	// CJK UNIFIED IDEOGRAPH
	{0x7A54,	0xEDB5},	// CJK UNIFIED IDEOGRAPH
	{0x7A56,	0xEDB3},	// CJK UNIFIED IDEOGRAPH
	{0x7A57,	0xC14A},	// CJK UNIFIED IDEOGRAPH
	{0x7A58,	0xEDB4},	// CJK UNIFIED IDEOGRAPH
	{0x7A5A,	0xEDB6},	// CJK UNIFIED IDEOGRAPH
	{0x7A5B,	0xEDB2},	// CJK UNIFIED IDEOGRAPH
	{0x7A5C,	0xEDB1},	// CJK UNIFIED IDEOGRAPH
	{0x7A5F,	0xF060},	// CJK UNIFIED IDEOGRAPH
	{0x7A60,	0xC2AA},	// CJK UNIFIED IDEOGRAPH
	{0x7A61,	0xC2A8},	// CJK UNIFIED IDEOGRAPH
	{0x7A62,	0xC2A9},	// CJK UNIFIED IDEOGRAPH
	{0x7A67,	0xF2A6},	// CJK UNIFIED IDEOGRAPH
	{0x7A68,	0xF2A7},	// CJK UNIFIED IDEOGRAPH
	{0x7A69,	0xC3AD},	// CJK UNIFIED IDEOGRAPH
	{0x7A6B,	0xC3AC},	// CJK UNIFIED IDEOGRAPH
	{0x7A6C,	0xF4A3},	// CJK UNIFIED IDEOGRAPH
	{0x7A6D,	0xF4A4},	// CJK UNIFIED IDEOGRAPH
	{0x7A6E,	0xF4A2},	// CJK UNIFIED IDEOGRAPH
	{0x7A70,	0xF6F8},	// CJK UNIFIED IDEOGRAPH
	{0x7A71,	0xF6F9},	// CJK UNIFIED IDEOGRAPH
	{0x7A74,	0xA5DE},	// CJK UNIFIED IDEOGRAPH
	{0x7A75,	0xCA48},	// CJK UNIFIED IDEOGRAPH
	{0x7A76,	0xA873},	// CJK UNIFIED IDEOGRAPH
	{0x7A78,	0xCDA5},	// CJK UNIFIED IDEOGRAPH
	{0x7A79,	0xAAC6},	// CJK UNIFIED IDEOGRAPH
	{0x7A7A,	0xAAC5},	// CJK UNIFIED IDEOGRAPH
	{0x7A7B,	0xCDA6},	// CJK UNIFIED IDEOGRAPH
	{0x7A7E,	0xD040},	// CJK UNIFIED IDEOGRAPH
	{0x7A7F,	0xACEF},	// CJK UNIFIED IDEOGRAPH
	{0x7A80,	0xCFFE},	// CJK UNIFIED IDEOGRAPH
	{0x7A81,	0xACF0},	// CJK UNIFIED IDEOGRAPH
	{0x7A84,	0xAFB6},	// CJK UNIFIED IDEOGRAPH
	{0x7A85,	0xD2F8},	// CJK UNIFIED IDEOGRAPH
	{0x7A86,	0xD2F6},	// CJK UNIFIED IDEOGRAPH
	{0x7A87,	0xD2FC},	// CJK UNIFIED IDEOGRAPH
	{0x7A88,	0xAFB7},	// CJK UNIFIED IDEOGRAPH
	{0x7A89,	0xD2F7},	// CJK UNIFIED IDEOGRAPH
	{0x7A8A,	0xD2FB},	// CJK UNIFIED IDEOGRAPH
	{0x7A8B,	0xD2F9},	// CJK UNIFIED IDEOGRAPH
	{0x7A8C,	0xD2FA},	// CJK UNIFIED IDEOGRAPH
	{0x7A8F,	0xD6C8},	// CJK UNIFIED IDEOGRAPH
	{0x7A90,	0xD6CA},	// CJK UNIFIED IDEOGRAPH
	{0x7A92,	0xB2BF},	// CJK UNIFIED IDEOGRAPH
	{0x7A94,	0xD6C9},	// CJK UNIFIED IDEOGRAPH
	{0x7A95,	0xB2C0},	// CJK UNIFIED IDEOGRAPH
	{0x7A96,	0xB5A2},	// CJK UNIFIED IDEOGRAPH
	{0x7A97,	0xB5A1},	// CJK UNIFIED IDEOGRAPH
	{0x7A98,	0xB57E},	// CJK UNIFIED IDEOGRAPH
	{0x7A99,	0xDADB},	// CJK UNIFIED IDEOGRAPH
	{0x7A9E,	0xDF44},	// CJK UNIFIED IDEOGRAPH
	{0x7A9F,	0xB85D},	// CJK UNIFIED IDEOGRAPH
	{0x7AA0,	0xB85E},	// CJK UNIFIED IDEOGRAPH
	{0x7AA2,	0xDF43},	// CJK UNIFIED IDEOGRAPH
	{0x7AA3,	0xDF42},	// CJK UNIFIED IDEOGRAPH
	{0x7AA8,	0xE34A},	// CJK UNIFIED IDEOGRAPH
	{0x7AA9,	0xBADB},	// CJK UNIFIED IDEOGRAPH
	{0x7AAA,	0xBADA},	// CJK UNIFIED IDEOGRAPH
	{0x7AAB,	0xE34B},	// CJK UNIFIED IDEOGRAPH
	{0x7AAC,	0xE34C},	// CJK UNIFIED IDEOGRAPH
	{0x7AAE,	0xBD61},	// CJK UNIFIED IDEOGRAPH
	{0x7AAF,	0xBD60},	// CJK UNIFIED IDEOGRAPH
	{0x7AB1,	0xEAB5},	// CJK UNIFIED IDEOGRAPH
	{0x7AB2,	0xE6D3},	// CJK UNIFIED IDEOGRAPH
	{0x7AB3,	0xE6D5},	// CJK UNIFIED IDEOGRAPH
	{0x7AB4,	0xE6D4},	// CJK UNIFIED IDEOGRAPH
	{0x7AB5,	0xEAB4},	// CJK UNIFIED IDEOGRAPH
	{0x7AB6,	0xEAB2},	// CJK UNIFIED IDEOGRAPH
	{0x7AB7,	0xEAB6},	// CJK UNIFIED IDEOGRAPH
	{0x7AB8,	0xEAB3},	// CJK UNIFIED IDEOGRAPH
	{0x7ABA,	0xBF73},	// CJK UNIFIED IDEOGRAPH
	{0x7ABE,	0xEDB7},	// CJK UNIFIED IDEOGRAPH
	{0x7ABF,	0xC14B},	// CJK UNIFIED IDEOGRAPH
	{0x7AC0,	0xEDB8},	// CJK UNIFIED IDEOGRAPH
	{0x7AC1,	0xEDB9},	// CJK UNIFIED IDEOGRAPH
	{0x7AC4,	0xC2AB},	// CJK UNIFIED IDEOGRAPH
	{0x7AC5,	0xC2AC},	// CJK UNIFIED IDEOGRAPH
	{0x7AC7,	0xC475},	// CJK UNIFIED IDEOGRAPH
	{0x7ACA,	0xC5D1},	// CJK UNIFIED IDEOGRAPH
	{0x7ACB,	0xA5DF},	// CJK UNIFIED IDEOGRAPH
	{0x7AD1,	0xD041},	// CJK UNIFIED IDEOGRAPH
	{0x7AD8,	0xD2FD},	// CJK UNIFIED IDEOGRAPH
	{0x7AD9,	0xAFB8},	// CJK UNIFIED IDEOGRAPH
	{0x7ADF,	0xB3BA},	// CJK UNIFIED IDEOGRAPH
	{0x7AE0,	0xB3B9},	// CJK UNIFIED IDEOGRAPH
	{0x7AE3,	0xB5A4},	// CJK UNIFIED IDEOGRAPH
	{0x7AE4,	0xDADD},	// CJK UNIFIED IDEOGRAPH
	{0x7AE5,	0xB5A3},	// CJK UNIFIED IDEOGRAPH
	{0x7AE6,	0xDADC},	// CJK UNIFIED IDEOGRAPH
	{0x7AEB,	0xDF45},	// CJK UNIFIED IDEOGRAPH
	{0x7AED,	0xBADC},	// CJK UNIFIED IDEOGRAPH
	{0x7AEE,	0xE34D},	// CJK UNIFIED IDEOGRAPH
	{0x7AEF,	0xBADD},	// CJK UNIFIED IDEOGRAPH
	{0x7AF6,	0xC476},	// CJK UNIFIED IDEOGRAPH
	{0x7AF7,	0xF4A5},	// CJK UNIFIED IDEOGRAPH
	{0x7AF9,	0xA6CB},	// CJK UNIFIED IDEOGRAPH
	{0x7AFA,	0xAAC7},	// CJK UNIFIED IDEOGRAPH
	{0x7AFB,	0xCDA7},	// CJK UNIFIED IDEOGRAPH
	{0x7AFD,	0xACF2},	// CJK UNIFIED IDEOGRAPH
	{0x7AFF,	0xACF1},	// CJK UNIFIED IDEOGRAPH
	{0x7B00,	0xD042},	// CJK UNIFIED IDEOGRAPH
	{0x7B01,	0xD043},	// CJK UNIFIED IDEOGRAPH
	{0x7B04,	0xD340},	// CJK UNIFIED IDEOGRAPH
	{0x7B05,	0xD342},	// CJK UNIFIED IDEOGRAPH
	{0x7B06,	0xAFB9},	// CJK UNIFIED IDEOGRAPH
	{0x7B08,	0xD344},	// CJK UNIFIED IDEOGRAPH
	{0x7B09,	0xD347},	// CJK UNIFIED IDEOGRAPH
	{0x7B0A,	0xD345},	// CJK UNIFIED IDEOGRAPH
	{0x7B0E,	0xD346},	// CJK UNIFIED IDEOGRAPH
	{0x7B0F,	0xD343},	// CJK UNIFIED IDEOGRAPH
	{0x7B10,	0xD2FE},	// CJK UNIFIED IDEOGRAPH
	{0x7B11,	0xAFBA},	// CJK UNIFIED IDEOGRAPH
	{0x7B12,	0xD348},	// CJK UNIFIED IDEOGRAPH
	{0x7B13,	0xD341},	// CJK UNIFIED IDEOGRAPH
	{0x7B18,	0xD6D3},	// CJK UNIFIED IDEOGRAPH
	{0x7B19,	0xB2C6},	// CJK UNIFIED IDEOGRAPH
	{0x7B1A,	0xD6DC},	// CJK UNIFIED IDEOGRAPH
	{0x7B1B,	0xB2C3},	// CJK UNIFIED IDEOGRAPH
	{0x7B1D,	0xD6D5},	// CJK UNIFIED IDEOGRAPH
	{0x7B1E,	0xB2C7},	// CJK UNIFIED IDEOGRAPH
	{0x7B20,	0xB2C1},	// CJK UNIFIED IDEOGRAPH
	{0x7B22,	0xD6D0},	// CJK UNIFIED IDEOGRAPH
	{0x7B23,	0xD6DD},	// CJK UNIFIED IDEOGRAPH
	{0x7B24,	0xD6D1},	// CJK UNIFIED IDEOGRAPH
	{0x7B25,	0xD6CE},	// CJK UNIFIED IDEOGRAPH
	{0x7B26,	0xB2C5},	// CJK UNIFIED IDEOGRAPH
	{0x7B28,	0xB2C2},	// CJK UNIFIED IDEOGRAPH
	{0x7B2A,	0xD6D4},	// CJK UNIFIED IDEOGRAPH
	{0x7B2B,	0xD6D7},	// CJK UNIFIED IDEOGRAPH
	{0x7B2C,	0xB2C4},	// CJK UNIFIED IDEOGRAPH
	{0x7B2D,	0xD6D8},	// CJK UNIFIED IDEOGRAPH
	{0x7B2E,	0xB2C8},	// CJK UNIFIED IDEOGRAPH
	{0x7B2F,	0xD6D9},	// CJK UNIFIED IDEOGRAPH
	{0x7B30,	0xD6CF},	// CJK UNIFIED IDEOGRAPH
	{0x7B31,	0xD6D6},	// CJK UNIFIED IDEOGRAPH
	{0x7B32,	0xD6DA},	// CJK UNIFIED IDEOGRAPH
	{0x7B33,	0xD6D2},	// CJK UNIFIED IDEOGRAPH
	{0x7B34,	0xD6CD},	// CJK UNIFIED IDEOGRAPH
	{0x7B35,	0xD6CB},	// CJK UNIFIED IDEOGRAPH
	{0x7B38,	0xD6DB},	// CJK UNIFIED IDEOGRAPH
	{0x7B3B,	0xDADF},	// CJK UNIFIED IDEOGRAPH
	{0x7B40,	0xDAE4},	// CJK UNIFIED IDEOGRAPH
	{0x7B44,	0xDAE0},	// CJK UNIFIED IDEOGRAPH
	{0x7B45,	0xDAE6},	// CJK UNIFIED IDEOGRAPH
	{0x7B46,	0xB5A7},	// CJK UNIFIED IDEOGRAPH
	{0x7B47,	0xD6CC},	// CJK UNIFIED IDEOGRAPH
	{0x7B48,	0xDAE1},	// CJK UNIFIED IDEOGRAPH
	{0x7B49,	0xB5A5},	// CJK UNIFIED IDEOGRAPH
	{0x7B4A,	0xDADE},	// CJK UNIFIED IDEOGRAPH
	{0x7B4B,	0xB5AC},	// CJK UNIFIED IDEOGRAPH
	{0x7B4C,	0xDAE2},	// CJK UNIFIED IDEOGRAPH
	{0x7B4D,	0xB5AB},	// CJK UNIFIED IDEOGRAPH
	{0x7B4E,	0xDAE3},	// CJK UNIFIED IDEOGRAPH
	{0x7B4F,	0xB5AD},	// CJK UNIFIED IDEOGRAPH
	{0x7B50,	0xB5A8},	// CJK UNIFIED IDEOGRAPH
	{0x7B51,	0xB5AE},	// CJK UNIFIED IDEOGRAPH
	{0x7B52,	0xB5A9},	// CJK UNIFIED IDEOGRAPH
	{0x7B54,	0xB5AA},	// CJK UNIFIED IDEOGRAPH
	{0x7B56,	0xB5A6},	// CJK UNIFIED IDEOGRAPH
	{0x7B58,	0xDAE5},	// CJK UNIFIED IDEOGRAPH
	{0x7B60,	0xB861},	// CJK UNIFIED IDEOGRAPH
	{0x7B61,	0xDF50},	// CJK UNIFIED IDEOGRAPH
	{0x7B63,	0xDF53},	// CJK UNIFIED IDEOGRAPH
	{0x7B64,	0xDF47},	// CJK UNIFIED IDEOGRAPH
	{0x7B65,	0xDF4C},	// CJK UNIFIED IDEOGRAPH
	{0x7B66,	0xDF46},	// CJK UNIFIED IDEOGRAPH
	{0x7B67,	0xB863},	// CJK UNIFIED IDEOGRAPH
	{0x7B69,	0xDF4A},	// CJK UNIFIED IDEOGRAPH
	{0x7B6D,	0xDF48},	// CJK UNIFIED IDEOGRAPH
	{0x7B6E,	0xB862},	// CJK UNIFIED IDEOGRAPH
	{0x7B70,	0xDF4F},	// CJK UNIFIED IDEOGRAPH
	{0x7B71,	0xDF4E},	// CJK UNIFIED IDEOGRAPH
	{0x7B72,	0xDF4B},	// CJK UNIFIED IDEOGRAPH
	{0x7B73,	0xDF4D},	// CJK UNIFIED IDEOGRAPH
	{0x7B74,	0xDF49},	// CJK UNIFIED IDEOGRAPH
	{0x7B75,	0xBAE1},	// CJK UNIFIED IDEOGRAPH
	{0x7B76,	0xDF52},	// CJK UNIFIED IDEOGRAPH
	{0x7B77,	0xB85F},	// CJK UNIFIED IDEOGRAPH
	{0x7B78,	0xDF51},	// CJK UNIFIED IDEOGRAPH
	{0x7B82,	0xE35D},	// CJK UNIFIED IDEOGRAPH
	{0x7B84,	0xBAE8},	// CJK UNIFIED IDEOGRAPH
	{0x7B85,	0xE358},	// CJK UNIFIED IDEOGRAPH
	{0x7B87,	0xBAE7},	// CJK UNIFIED IDEOGRAPH
	{0x7B88,	0xE34E},	// CJK UNIFIED IDEOGRAPH
	{0x7B8A,	0xE350},	// CJK UNIFIED IDEOGRAPH
	{0x7B8B,	0xBAE0},	// CJK UNIFIED IDEOGRAPH
	{0x7B8C,	0xE355},	// CJK UNIFIED IDEOGRAPH
	{0x7B8D,	0xE354},	// CJK UNIFIED IDEOGRAPH
	{0x7B8E,	0xE357},	// CJK UNIFIED IDEOGRAPH
	{0x7B8F,	0xBAE5},	// CJK UNIFIED IDEOGRAPH
	{0x7B90,	0xE352},	// CJK UNIFIED IDEOGRAPH
	{0x7B91,	0xE351},	// CJK UNIFIED IDEOGRAPH
	{0x7B94,	0xBAE4},	// CJK UNIFIED IDEOGRAPH
	{0x7B95,	0xBADF},	// CJK UNIFIED IDEOGRAPH
	{0x7B96,	0xE353},	// CJK UNIFIED IDEOGRAPH
	{0x7B97,	0xBAE2},	// CJK UNIFIED IDEOGRAPH
	{0x7B98,	0xE359},	// CJK UNIFIED IDEOGRAPH
	{0x7B99,	0xE35B},	// CJK UNIFIED IDEOGRAPH
	{0x7B9B,	0xE356},	// CJK UNIFIED IDEOGRAPH
	{0x7B9C,	0xE34F},	// CJK UNIFIED IDEOGRAPH
	{0x7B9D,	0xBAE3},	// CJK UNIFIED IDEOGRAPH
	{0x7BA0,	0xBD69},	// CJK UNIFIED IDEOGRAPH
	{0x7BA1,	0xBADE},	// CJK UNIFIED IDEOGRAPH
	{0x7BA4,	0xE35C},	// CJK UNIFIED IDEOGRAPH
	{0x7BAC,	0xE6D9},	// CJK UNIFIED IDEOGRAPH
	{0x7BAD,	0xBD62},	// CJK UNIFIED IDEOGRAPH
	{0x7BAF,	0xE6DB},	// CJK UNIFIED IDEOGRAPH
	{0x7BB1,	0xBD63},	// CJK UNIFIED IDEOGRAPH
	{0x7BB4,	0xBD65},	// CJK UNIFIED IDEOGRAPH
	{0x7BB5,	0xE6DE},	// CJK UNIFIED IDEOGRAPH
	{0x7BB7,	0xE6D6},	// CJK UNIFIED IDEOGRAPH
	{0x7BB8,	0xBAE6},	// CJK UNIFIED IDEOGRAPH
	{0x7BB9,	0xE6DC},	// CJK UNIFIED IDEOGRAPH
	{0x7BBE,	0xE6D8},	// CJK UNIFIED IDEOGRAPH
	{0x7BC0,	0xB860},	// CJK UNIFIED IDEOGRAPH
	{0x7BC1,	0xBD68},	// CJK UNIFIED IDEOGRAPH
	{0x7BC4,	0xBD64},	// CJK UNIFIED IDEOGRAPH
	{0x7BC6,	0xBD66},	// CJK UNIFIED IDEOGRAPH
	{0x7BC7,	0xBD67},	// CJK UNIFIED IDEOGRAPH
	{0x7BC9,	0xBF76},	// CJK UNIFIED IDEOGRAPH
	{0x7BCA,	0xE6DD},	// CJK UNIFIED IDEOGRAPH
	{0x7BCB,	0xE6D7},	// CJK UNIFIED IDEOGRAPH
	{0x7BCC,	0xBD6A},	// CJK UNIFIED IDEOGRAPH
	{0x7BCE,	0xE6DA},	// CJK UNIFIED IDEOGRAPH
	{0x7BD4,	0xEAC0},	// CJK UNIFIED IDEOGRAPH
	{0x7BD5,	0xEABB},	// CJK UNIFIED IDEOGRAPH
	{0x7BD8,	0xEAC5},	// CJK UNIFIED IDEOGRAPH
	{0x7BD9,	0xBF74},	// CJK UNIFIED IDEOGRAPH
	{0x7BDA,	0xEABD},	// CJK UNIFIED IDEOGRAPH
	{0x7BDB,	0xBF78},	// CJK UNIFIED IDEOGRAPH
	{0x7BDC,	0xEAC3},	// CJK UNIFIED IDEOGRAPH
	{0x7BDD,	0xEABA},	// CJK UNIFIED IDEOGRAPH
	{0x7BDE,	0xEAB7},	// CJK UNIFIED IDEOGRAPH
	{0x7BDF,	0xEAC6},	// CJK UNIFIED IDEOGRAPH
	{0x7BE0,	0xC151},	// CJK UNIFIED IDEOGRAPH
	{0x7BE1,	0xBF79},	// CJK UNIFIED IDEOGRAPH
	{0x7BE2,	0xEAC2},	// CJK UNIFIED IDEOGRAPH
	{0x7BE3,	0xEAB8},	// CJK UNIFIED IDEOGRAPH
	{0x7BE4,	0xBF77},	// CJK UNIFIED IDEOGRAPH
	{0x7BE5,	0xEABC},	// CJK UNIFIED IDEOGRAPH
	{0x7BE6,	0xBF7B},	// CJK UNIFIED IDEOGRAPH
	{0x7BE7,	0xEAB9},	// CJK UNIFIED IDEOGRAPH
	{0x7BE8,	0xEABE},	// CJK UNIFIED IDEOGRAPH
	{0x7BE9,	0xBF7A},	// CJK UNIFIED IDEOGRAPH
	{0x7BEA,	0xEAC1},	// CJK UNIFIED IDEOGRAPH
	{0x7BEB,	0xEAC4},	// CJK UNIFIED IDEOGRAPH
	{0x7BF0,	0xEDCB},	// CJK UNIFIED IDEOGRAPH
	{0x7BF1,	0xEDCC},	// CJK UNIFIED IDEOGRAPH
	{0x7BF2,	0xEDBC},	// CJK UNIFIED IDEOGRAPH
	{0x7BF3,	0xEDC3},	// CJK UNIFIED IDEOGRAPH
	{0x7BF4,	0xEDC1},	// CJK UNIFIED IDEOGRAPH
	{0x7BF7,	0xC14F},	// CJK UNIFIED IDEOGRAPH
	{0x7BF8,	0xEDC8},	// CJK UNIFIED IDEOGRAPH
	{0x7BF9,	0xEABF},	// CJK UNIFIED IDEOGRAPH
	{0x7BFB,	0xEDBF},	// CJK UNIFIED IDEOGRAPH
	{0x7BFD,	0xEDC9},	// CJK UNIFIED IDEOGRAPH
	{0x7BFE,	0xC14E},	// CJK UNIFIED IDEOGRAPH
	{0x7BFF,	0xEDBE},	// CJK UNIFIED IDEOGRAPH
	{0x7C00,	0xEDBD},	// CJK UNIFIED IDEOGRAPH
	{0x7C01,	0xEDC7},	// CJK UNIFIED IDEOGRAPH
	{0x7C02,	0xEDC4},	// CJK UNIFIED IDEOGRAPH
	{0x7C03,	0xEDC6},	// CJK UNIFIED IDEOGRAPH
	{0x7C05,	0xEDBA},	// CJK UNIFIED IDEOGRAPH
	{0x7C06,	0xEDCA},	// CJK UNIFIED IDEOGRAPH
	{0x7C07,	0xC14C},	// CJK UNIFIED IDEOGRAPH
	{0x7C09,	0xEDC5},	// CJK UNIFIED IDEOGRAPH
	{0x7C0A,	0xEDCE},	// CJK UNIFIED IDEOGRAPH
	{0x7C0B,	0xEDC2},	// CJK UNIFIED IDEOGRAPH
	{0x7C0C,	0xC150},	// CJK UNIFIED IDEOGRAPH
	{0x7C0D,	0xC14D},	// CJK UNIFIED IDEOGRAPH
	{0x7C0E,	0xEDC0},	// CJK UNIFIED IDEOGRAPH
	{0x7C0F,	0xEDBB},	// CJK UNIFIED IDEOGRAPH
	{0x7C10,	0xEDCD},	// CJK UNIFIED IDEOGRAPH
	{0x7C11,	0xBF75},	// CJK UNIFIED IDEOGRAPH
	{0x7C19,	0xF063},	// CJK UNIFIED IDEOGRAPH
	{0x7C1C,	0xF061},	// CJK UNIFIED IDEOGRAPH
	{0x7C1D,	0xF067},	// CJK UNIFIED IDEOGRAPH
	{0x7C1E,	0xC2B0},	// CJK UNIFIED IDEOGRAPH
	{0x7C1F,	0xF065},	// CJK UNIFIED IDEOGRAPH
	{0x7C20,	0xF064},	// CJK UNIFIED IDEOGRAPH
	{0x7C21,	0xC2B2},	// CJK UNIFIED IDEOGRAPH
	{0x7C22,	0xF06A},	// CJK UNIFIED IDEOGRAPH
	{0x7C23,	0xC2B1},	// CJK UNIFIED IDEOGRAPH
	{0x7C25,	0xF06B},	// CJK UNIFIED IDEOGRAPH
	{0x7C26,	0xF068},	// CJK UNIFIED IDEOGRAPH
	{0x7C27,	0xC2AE},	// CJK UNIFIED IDEOGRAPH
	{0x7C28,	0xF069},	// CJK UNIFIED IDEOGRAPH
	{0x7C29,	0xF062},	// CJK UNIFIED IDEOGRAPH
	{0x7C2A,	0xC2AF},	// CJK UNIFIED IDEOGRAPH
	{0x7C2B,	0xC2AD},	// CJK UNIFIED IDEOGRAPH
	{0x7C2C,	0xF2AB},	// CJK UNIFIED IDEOGRAPH
	{0x7C2D,	0xF066},	// CJK UNIFIED IDEOGRAPH
	{0x7C30,	0xF06C},	// CJK UNIFIED IDEOGRAPH
	{0x7C33,	0xF2A8},	// CJK UNIFIED IDEOGRAPH
	{0x7C37,	0xC3B2},	// CJK UNIFIED IDEOGRAPH
	{0x7C38,	0xC3B0},	// CJK UNIFIED IDEOGRAPH
	{0x7C39,	0xF2AA},	// CJK UNIFIED IDEOGRAPH
	{0x7C3B,	0xF2AC},	// CJK UNIFIED IDEOGRAPH
	{0x7C3C,	0xF2A9},	// CJK UNIFIED IDEOGRAPH
	{0x7C3D,	0xC3B1},	// CJK UNIFIED IDEOGRAPH
	{0x7C3E,	0xC3AE},	// CJK UNIFIED IDEOGRAPH
	{0x7C3F,	0xC3AF},	// CJK UNIFIED IDEOGRAPH
	{0x7C40,	0xC3B3},	// CJK UNIFIED IDEOGRAPH
	{0x7C43,	0xC478},	// CJK UNIFIED IDEOGRAPH
	{0x7C45,	0xF4AA},	// CJK UNIFIED IDEOGRAPH
	{0x7C47,	0xF4A9},	// CJK UNIFIED IDEOGRAPH
	{0x7C48,	0xF4A7},	// CJK UNIFIED IDEOGRAPH
	{0x7C49,	0xF4A6},	// CJK UNIFIED IDEOGRAPH
	{0x7C4A,	0xF4A8},	// CJK UNIFIED IDEOGRAPH
	{0x7C4C,	0xC477},	// CJK UNIFIED IDEOGRAPH
	{0x7C4D,	0xC479},	// CJK UNIFIED IDEOGRAPH
	{0x7C50,	0xC4F0},	// CJK UNIFIED IDEOGRAPH
	{0x7C53,	0xF5E5},	// CJK UNIFIED IDEOGRAPH
	{0x7C54,	0xF5E4},	// CJK UNIFIED IDEOGRAPH
	{0x7C57,	0xF6FA},	// CJK UNIFIED IDEOGRAPH
	{0x7C59,	0xF6FC},	// CJK UNIFIED IDEOGRAPH
	{0x7C5A,	0xF6FE},	// CJK UNIFIED IDEOGRAPH
	{0x7C5B,	0xF6FD},	// CJK UNIFIED IDEOGRAPH
	{0x7C5C,	0xF6FB},	// CJK UNIFIED IDEOGRAPH
	{0x7C5F,	0xC5A3},	// CJK UNIFIED IDEOGRAPH
	{0x7C60,	0xC5A2},	// CJK UNIFIED IDEOGRAPH
	{0x7C63,	0xC5D3},	// CJK UNIFIED IDEOGRAPH
	{0x7C64,	0xC5D2},	// CJK UNIFIED IDEOGRAPH
	{0x7C65,	0xC5D4},	// CJK UNIFIED IDEOGRAPH
	{0x7C66,	0xF7ED},	// CJK UNIFIED IDEOGRAPH
	{0x7C67,	0xF7EC},	// CJK UNIFIED IDEOGRAPH
	{0x7C69,	0xF8FB},	// CJK UNIFIED IDEOGRAPH
	{0x7C6A,	0xF8B8},	// CJK UNIFIED IDEOGRAPH
	{0x7C6B,	0xF8FC},	// CJK UNIFIED IDEOGRAPH
	{0x7C6C,	0xC658},	// CJK UNIFIED IDEOGRAPH
	{0x7C6E,	0xC659},	// CJK UNIFIED IDEOGRAPH
	{0x7C6F,	0xF96D},	// CJK UNIFIED IDEOGRAPH
	{0x7C72,	0xC67E},	// CJK UNIFIED IDEOGRAPH
	{0x7C73,	0xA6CC},	// CJK UNIFIED IDEOGRAPH
	{0x7C75,	0xCDA8},	// CJK UNIFIED IDEOGRAPH
	{0x7C78,	0xD045},	// CJK UNIFIED IDEOGRAPH
	{0x7C79,	0xD046},	// CJK UNIFIED IDEOGRAPH
	{0x7C7A,	0xD044},	// CJK UNIFIED IDEOGRAPH
	{0x7C7D,	0xACF3},	// CJK UNIFIED IDEOGRAPH
	{0x7C7F,	0xD047},	// CJK UNIFIED IDEOGRAPH
	{0x7C80,	0xD048},	// CJK UNIFIED IDEOGRAPH
	{0x7C81,	0xD049},	// CJK UNIFIED IDEOGRAPH
	{0x7C84,	0xD349},	// CJK UNIFIED IDEOGRAPH
	{0x7C85,	0xD34F},	// CJK UNIFIED IDEOGRAPH
	{0x7C88,	0xD34D},	// CJK UNIFIED IDEOGRAPH
	{0x7C89,	0xAFBB},	// CJK UNIFIED IDEOGRAPH
	{0x7C8A,	0xD34B},	// CJK UNIFIED IDEOGRAPH
	{0x7C8C,	0xD34C},	// CJK UNIFIED IDEOGRAPH
	{0x7C8D,	0xD34E},	// CJK UNIFIED IDEOGRAPH
	{0x7C91,	0xD34A},	// CJK UNIFIED IDEOGRAPH
	{0x7C92,	0xB2C9},	// CJK UNIFIED IDEOGRAPH
	{0x7C94,	0xD6DE},	// CJK UNIFIED IDEOGRAPH
	{0x7C95,	0xB2CB},	// CJK UNIFIED IDEOGRAPH
	{0x7C96,	0xD6E0},	// CJK UNIFIED IDEOGRAPH
	{0x7C97,	0xB2CA},	// CJK UNIFIED IDEOGRAPH
	{0x7C98,	0xD6DF},	// CJK UNIFIED IDEOGRAPH
	{0x7C9E,	0xDAE8},	// CJK UNIFIED IDEOGRAPH
	{0x7C9F,	0xB5AF},	// CJK UNIFIED IDEOGRAPH
	{0x7CA1,	0xDAEA},	// CJK UNIFIED IDEOGRAPH
	{0x7CA2,	0xDAE7},	// CJK UNIFIED IDEOGRAPH
	{0x7CA3,	0xD6E1},	// CJK UNIFIED IDEOGRAPH
	{0x7CA5,	0xB5B0},	// CJK UNIFIED IDEOGRAPH
	{0x7CA7,	0xF9DB},	// CJK UNIFIED IDEOGRAPH
	{0x7CA8,	0xDAE9},	// CJK UNIFIED IDEOGRAPH
	{0x7CAF,	0xDF56},	// CJK UNIFIED IDEOGRAPH
	{0x7CB1,	0xB864},	// CJK UNIFIED IDEOGRAPH
	{0x7CB2,	0xDF54},	// CJK UNIFIED IDEOGRAPH
	{0x7CB3,	0xB865},	// CJK UNIFIED IDEOGRAPH
	{0x7CB4,	0xDF55},	// CJK UNIFIED IDEOGRAPH
	{0x7CB5,	0xB866},	// CJK UNIFIED IDEOGRAPH
	{0x7CB9,	0xBAE9},	// CJK UNIFIED IDEOGRAPH
	{0x7CBA,	0xE361},	// CJK UNIFIED IDEOGRAPH
	{0x7CBB,	0xE35E},	// CJK UNIFIED IDEOGRAPH
	{0x7CBC,	0xE360},	// CJK UNIFIED IDEOGRAPH
	{0x7CBD,	0xBAEA},	// CJK UNIFIED IDEOGRAPH
	{0x7CBE,	0xBAEB},	// CJK UNIFIED IDEOGRAPH
	{0x7CBF,	0xE35F},	// CJK UNIFIED IDEOGRAPH
	{0x7CC5,	0xE6DF},	// CJK UNIFIED IDEOGRAPH
	{0x7CC8,	0xE6E0},	// CJK UNIFIED IDEOGRAPH
	{0x7CCA,	0xBD6B},	// CJK UNIFIED IDEOGRAPH
	{0x7CCB,	0xE6E2},	// CJK UNIFIED IDEOGRAPH
	{0x7CCC,	0xE6E1},	// CJK UNIFIED IDEOGRAPH
	{0x7CCE,	0xA261},	// CJK UNIFIED IDEOGRAPH
	{0x7CD0,	0xEACA},	// CJK UNIFIED IDEOGRAPH
	{0x7CD1,	0xEACB},	// CJK UNIFIED IDEOGRAPH
	{0x7CD2,	0xEAC7},	// CJK UNIFIED IDEOGRAPH
	{0x7CD4,	0xEAC8},	// CJK UNIFIED IDEOGRAPH
	{0x7CD5,	0xBF7C},	// CJK UNIFIED IDEOGRAPH
	{0x7CD6,	0xBF7D},	// CJK UNIFIED IDEOGRAPH
	{0x7CD7,	0xEAC9},	// CJK UNIFIED IDEOGRAPH
	{0x7CD9,	0xC157},	// CJK UNIFIED IDEOGRAPH
	{0x7CDC,	0xC153},	// CJK UNIFIED IDEOGRAPH
	{0x7CDD,	0xC158},	// CJK UNIFIED IDEOGRAPH
	{0x7CDE,	0xC154},	// CJK UNIFIED IDEOGRAPH
	{0x7CDF,	0xC156},	// CJK UNIFIED IDEOGRAPH
	{0x7CE0,	0xC152},	// CJK UNIFIED IDEOGRAPH
	{0x7CE2,	0xC155},	// CJK UNIFIED IDEOGRAPH
	{0x7CE7,	0xC2B3},	// CJK UNIFIED IDEOGRAPH
	{0x7CE8,	0xEDCF},	// CJK UNIFIED IDEOGRAPH
	{0x7CEA,	0xF2AE},	// CJK UNIFIED IDEOGRAPH
	{0x7CEC,	0xF2AD},	// CJK UNIFIED IDEOGRAPH
	{0x7CEE,	0xF4AB},	// CJK UNIFIED IDEOGRAPH
	{0x7CEF,	0xC47A},	// CJK UNIFIED IDEOGRAPH
	{0x7CF0,	0xC47B},	// CJK UNIFIED IDEOGRAPH
	{0x7CF1,	0xF741},	// CJK UNIFIED IDEOGRAPH
	{0x7CF2,	0xF5E6},	// CJK UNIFIED IDEOGRAPH
	{0x7CF4,	0xF740},	// CJK UNIFIED IDEOGRAPH
	{0x7CF6,	0xF8FD},	// CJK UNIFIED IDEOGRAPH
	{0x7CF7,	0xF9A4},	// CJK UNIFIED IDEOGRAPH
	{0x7CF8,	0xA6CD},	// CJK UNIFIED IDEOGRAPH
	{0x7CFB,	0xA874},	// CJK UNIFIED IDEOGRAPH
	{0x7CFD,	0xCDA9},	// CJK UNIFIED IDEOGRAPH
	{0x7CFE,	0xAAC8},	// CJK UNIFIED IDEOGRAPH
	{0x7D00,	0xACF6},	// CJK UNIFIED IDEOGRAPH
	{0x7D01,	0xD04C},	// CJK UNIFIED IDEOGRAPH
	{0x7D02,	0xACF4},	// CJK UNIFIED IDEOGRAPH
	{0x7D03,	0xD04A},	// CJK UNIFIED IDEOGRAPH
	{0x7D04,	0xACF9},	// CJK UNIFIED IDEOGRAPH
	{0x7D05,	0xACF5},	// CJK UNIFIED IDEOGRAPH
	{0x7D06,	0xACFA},	// CJK UNIFIED IDEOGRAPH
	{0x7D07,	0xACF8},	// CJK UNIFIED IDEOGRAPH
	{0x7D08,	0xD04B},	// CJK UNIFIED IDEOGRAPH
	{0x7D09,	0xACF7},	// CJK UNIFIED IDEOGRAPH
	{0x7D0A,	0xAFBF},	// CJK UNIFIED IDEOGRAPH
	{0x7D0B,	0xAFBE},	// CJK UNIFIED IDEOGRAPH
	{0x7D0C,	0xD35A},	// CJK UNIFIED IDEOGRAPH
	{0x7D0D,	0xAFC7},	// CJK UNIFIED IDEOGRAPH
	{0x7D0E,	0xD353},	// CJK UNIFIED IDEOGRAPH
	{0x7D0F,	0xD359},	// CJK UNIFIED IDEOGRAPH
	{0x7D10,	0xAFC3},	// CJK UNIFIED IDEOGRAPH
	{0x7D11,	0xD352},	// CJK UNIFIED IDEOGRAPH
	{0x7D12,	0xD358},	// CJK UNIFIED IDEOGRAPH
	{0x7D13,	0xD356},	// CJK UNIFIED IDEOGRAPH
	{0x7D14,	0xAFC2},	// CJK UNIFIED IDEOGRAPH
	{0x7D15,	0xAFC4},	// CJK UNIFIED IDEOGRAPH
	{0x7D16,	0xD355},	// CJK UNIFIED IDEOGRAPH
	{0x7D17,	0xAFBD},	// CJK UNIFIED IDEOGRAPH
	{0x7D18,	0xD354},	// CJK UNIFIED IDEOGRAPH
	{0x7D19,	0xAFC8},	// CJK UNIFIED IDEOGRAPH
	{0x7D1A,	0xAFC5},	// CJK UNIFIED IDEOGRAPH
	{0x7D1B,	0xAFC9},	// CJK UNIFIED IDEOGRAPH
	{0x7D1C,	0xAFC6},	// CJK UNIFIED IDEOGRAPH
	{0x7D1D,	0xD351},	// CJK UNIFIED IDEOGRAPH
	{0x7D1E,	0xD350},	// CJK UNIFIED IDEOGRAPH
	{0x7D1F,	0xD357},	// CJK UNIFIED IDEOGRAPH
	{0x7D20,	0xAFC0},	// CJK UNIFIED IDEOGRAPH
	{0x7D21,	0xAFBC},	// CJK UNIFIED IDEOGRAPH
	{0x7D22,	0xAFC1},	// CJK UNIFIED IDEOGRAPH
	{0x7D28,	0xD6F0},	// CJK UNIFIED IDEOGRAPH
	{0x7D29,	0xD6E9},	// CJK UNIFIED IDEOGRAPH
	{0x7D2B,	0xB5B5},	// CJK UNIFIED IDEOGRAPH
	{0x7D2C,	0xD6E8},	// CJK UNIFIED IDEOGRAPH
	{0x7D2E,	0xB2CF},	// CJK UNIFIED IDEOGRAPH
	{0x7D2F,	0xB2D6},	// CJK UNIFIED IDEOGRAPH
	{0x7D30,	0xB2D3},	// CJK UNIFIED IDEOGRAPH
	{0x7D31,	0xB2D9},	// CJK UNIFIED IDEOGRAPH
	{0x7D32,	0xB2D8},	// CJK UNIFIED IDEOGRAPH
	{0x7D33,	0xB2D4},	// CJK UNIFIED IDEOGRAPH
	{0x7D35,	0xD6E2},	// CJK UNIFIED IDEOGRAPH
	{0x7D36,	0xD6E5},	// CJK UNIFIED IDEOGRAPH
	{0x7D38,	0xD6E4},	// CJK UNIFIED IDEOGRAPH
	{0x7D39,	0xB2D0},	// CJK UNIFIED IDEOGRAPH
	{0x7D3A,	0xD6E6},	// CJK UNIFIED IDEOGRAPH
	{0x7D3B,	0xD6EF},	// CJK UNIFIED IDEOGRAPH
	{0x7D3C,	0xB2D1},	// CJK UNIFIED IDEOGRAPH
	{0x7D3D,	0xD6E3},	// CJK UNIFIED IDEOGRAPH
	{0x7D3E,	0xD6EC},	// CJK UNIFIED IDEOGRAPH
	{0x7D3F,	0xD6ED},	// CJK UNIFIED IDEOGRAPH
	{0x7D40,	0xB2D2},	// CJK UNIFIED IDEOGRAPH
	{0x7D41,	0xD6EA},	// CJK UNIFIED IDEOGRAPH
	{0x7D42,	0xB2D7},	// CJK UNIFIED IDEOGRAPH
	{0x7D43,	0xB2CD},	// CJK UNIFIED IDEOGRAPH
	{0x7D44,	0xB2D5},	// CJK UNIFIED IDEOGRAPH
	{0x7D45,	0xD6E7},	// CJK UNIFIED IDEOGRAPH
	{0x7D46,	0xB2CC},	// CJK UNIFIED IDEOGRAPH
	{0x7D47,	0xD6EB},	// CJK UNIFIED IDEOGRAPH
	{0x7D4A,	0xD6EE},	// CJK UNIFIED IDEOGRAPH
	{0x7D4E,	0xDAFB},	// CJK UNIFIED IDEOGRAPH
	{0x7D4F,	0xDAF2},	// CJK UNIFIED IDEOGRAPH
	{0x7D50,	0xB5B2},	// CJK UNIFIED IDEOGRAPH
	{0x7D51,	0xDAF9},	// CJK UNIFIED IDEOGRAPH
	{0x7D52,	0xDAF6},	// CJK UNIFIED IDEOGRAPH
	{0x7D53,	0xDAEE},	// CJK UNIFIED IDEOGRAPH
	{0x7D54,	0xDAF7},	// CJK UNIFIED IDEOGRAPH
	{0x7D55,	0xB5B4},	// CJK UNIFIED IDEOGRAPH
	{0x7D56,	0xDAEF},	// CJK UNIFIED IDEOGRAPH
	{0x7D58,	0xDAEB},	// CJK UNIFIED IDEOGRAPH
	{0x7D5B,	0xB86C},	// CJK UNIFIED IDEOGRAPH
	{0x7D5C,	0xDAF4},	// CJK UNIFIED IDEOGRAPH
	{0x7D5E,	0xB5B1},	// CJK UNIFIED IDEOGRAPH
	{0x7D5F,	0xDAFA},	// CJK UNIFIED IDEOGRAPH
	{0x7D61,	0xB5B8},	// CJK UNIFIED IDEOGRAPH
	{0x7D62,	0xB5BA},	// CJK UNIFIED IDEOGRAPH
	{0x7D63,	0xDAED},	// CJK UNIFIED IDEOGRAPH
	{0x7D66,	0xB5B9},	// CJK UNIFIED IDEOGRAPH
	{0x7D67,	0xDAF0},	// CJK UNIFIED IDEOGRAPH
	{0x7D68,	0xB5B3},	// CJK UNIFIED IDEOGRAPH
	{0x7D69,	0xDAF8},	// CJK UNIFIED IDEOGRAPH
	{0x7D6A,	0xDAF1},	// CJK UNIFIED IDEOGRAPH
	{0x7D6B,	0xDAF5},	// CJK UNIFIED IDEOGRAPH
	{0x7D6D,	0xDAF3},	// CJK UNIFIED IDEOGRAPH
	{0x7D6E,	0xB5B6},	// CJK UNIFIED IDEOGRAPH
	{0x7D6F,	0xDAEC},	// CJK UNIFIED IDEOGRAPH
	{0x7D70,	0xB5BB},	// CJK UNIFIED IDEOGRAPH
	{0x7D71,	0xB2CE},	// CJK UNIFIED IDEOGRAPH
	{0x7D72,	0xB5B7},	// CJK UNIFIED IDEOGRAPH
	{0x7D73,	0xB5BC},	// CJK UNIFIED IDEOGRAPH
	{0x7D79,	0xB868},	// CJK UNIFIED IDEOGRAPH
	{0x7D7A,	0xDF5D},	// CJK UNIFIED IDEOGRAPH
	{0x7D7B,	0xDF5F},	// CJK UNIFIED IDEOGRAPH
	{0x7D7C,	0xDF61},	// CJK UNIFIED IDEOGRAPH
	{0x7D7D,	0xDF65},	// CJK UNIFIED IDEOGRAPH
	{0x7D7F,	0xDF5B},	// CJK UNIFIED IDEOGRAPH
	{0x7D80,	0xDF59},	// CJK UNIFIED IDEOGRAPH
	{0x7D81,	0xB86A},	// CJK UNIFIED IDEOGRAPH
	{0x7D83,	0xDF60},	// CJK UNIFIED IDEOGRAPH
	{0x7D84,	0xDF64},	// CJK UNIFIED IDEOGRAPH
	{0x7D85,	0xDF5C},	// CJK UNIFIED IDEOGRAPH
	{0x7D86,	0xDF58},	// CJK UNIFIED IDEOGRAPH
	{0x7D88,	0xDF57},	// CJK UNIFIED IDEOGRAPH
	{0x7D8C,	0xDF62},	// CJK UNIFIED IDEOGRAPH
	{0x7D8D,	0xDF5A},	// CJK UNIFIED IDEOGRAPH
	{0x7D8E,	0xDF5E},	// CJK UNIFIED IDEOGRAPH
	{0x7D8F,	0xB86B},	// CJK UNIFIED IDEOGRAPH
	{0x7D91,	0xB869},	// CJK UNIFIED IDEOGRAPH
	{0x7D92,	0xDF66},	// CJK UNIFIED IDEOGRAPH
	{0x7D93,	0xB867},	// CJK UNIFIED IDEOGRAPH
	{0x7D94,	0xDF63},	// CJK UNIFIED IDEOGRAPH
	{0x7D96,	0xE372},	// CJK UNIFIED IDEOGRAPH
	{0x7D9C,	0xBAEE},	// CJK UNIFIED IDEOGRAPH
	{0x7D9D,	0xE36A},	// CJK UNIFIED IDEOGRAPH
	{0x7D9E,	0xBD78},	// CJK UNIFIED IDEOGRAPH
	{0x7D9F,	0xE374},	// CJK UNIFIED IDEOGRAPH
	{0x7DA0,	0xBAF1},	// CJK UNIFIED IDEOGRAPH
	{0x7DA1,	0xE378},	// CJK UNIFIED IDEOGRAPH
	{0x7DA2,	0xBAF7},	// CJK UNIFIED IDEOGRAPH
	{0x7DA3,	0xE365},	// CJK UNIFIED IDEOGRAPH
	{0x7DA6,	0xE375},	// CJK UNIFIED IDEOGRAPH
	{0x7DA7,	0xE362},	// CJK UNIFIED IDEOGRAPH
	{0x7DA9,	0xE377},	// CJK UNIFIED IDEOGRAPH
	{0x7DAA,	0xE366},	// CJK UNIFIED IDEOGRAPH
	{0x7DAC,	0xBAFE},	// CJK UNIFIED IDEOGRAPH
	{0x7DAD,	0xBAFB},	// CJK UNIFIED IDEOGRAPH
	{0x7DAE,	0xE376},	// CJK UNIFIED IDEOGRAPH
	{0x7DAF,	0xE370},	// CJK UNIFIED IDEOGRAPH
	{0x7DB0,	0xBAED},	// CJK UNIFIED IDEOGRAPH
	{0x7DB1,	0xBAF5},	// CJK UNIFIED IDEOGRAPH
	{0x7DB2,	0xBAF4},	// CJK UNIFIED IDEOGRAPH
	{0x7DB4,	0xBAF3},	// CJK UNIFIED IDEOGRAPH
	{0x7DB5,	0xBAF9},	// CJK UNIFIED IDEOGRAPH
	{0x7DB7,	0xE363},	// CJK UNIFIED IDEOGRAPH
	{0x7DB8,	0xBAFA},	// CJK UNIFIED IDEOGRAPH
	{0x7DB9,	0xE371},	// CJK UNIFIED IDEOGRAPH
	{0x7DBA,	0xBAF6},	// CJK UNIFIED IDEOGRAPH
	{0x7DBB,	0xBAEC},	// CJK UNIFIED IDEOGRAPH
	{0x7DBC,	0xE373},	// CJK UNIFIED IDEOGRAPH
	{0x7DBD,	0xBAEF},	// CJK UNIFIED IDEOGRAPH
	{0x7DBE,	0xBAF0},	// CJK UNIFIED IDEOGRAPH
	{0x7DBF,	0xBAF8},	// CJK UNIFIED IDEOGRAPH
	{0x7DC0,	0xE368},	// CJK UNIFIED IDEOGRAPH
	{0x7DC1,	0xE367},	// CJK UNIFIED IDEOGRAPH
	{0x7DC2,	0xE364},	// CJK UNIFIED IDEOGRAPH
	{0x7DC4,	0xE36C},	// CJK UNIFIED IDEOGRAPH
	{0x7DC5,	0xE369},	// CJK UNIFIED IDEOGRAPH
	{0x7DC6,	0xE36D},	// CJK UNIFIED IDEOGRAPH
	{0x7DC7,	0xBAFD},	// CJK UNIFIED IDEOGRAPH
	{0x7DC9,	0xE379},	// CJK UNIFIED IDEOGRAPH
	{0x7DCA,	0xBAF2},	// CJK UNIFIED IDEOGRAPH
	{0x7DCB,	0xE36E},	// CJK UNIFIED IDEOGRAPH
	{0x7DCC,	0xE36F},	// CJK UNIFIED IDEOGRAPH
	{0x7DCE,	0xE36B},	// CJK UNIFIED IDEOGRAPH
	{0x7DD2,	0xBAFC},	// CJK UNIFIED IDEOGRAPH
	{0x7DD7,	0xE6E7},	// CJK UNIFIED IDEOGRAPH
	{0x7DD8,	0xBD70},	// CJK UNIFIED IDEOGRAPH
	{0x7DD9,	0xBD79},	// CJK UNIFIED IDEOGRAPH
	{0x7DDA,	0xBD75},	// CJK UNIFIED IDEOGRAPH
	{0x7DDB,	0xE6E4},	// CJK UNIFIED IDEOGRAPH
	{0x7DDD,	0xBD72},	// CJK UNIFIED IDEOGRAPH
	{0x7DDE,	0xBD76},	// CJK UNIFIED IDEOGRAPH
	{0x7DDF,	0xE6F0},	// CJK UNIFIED IDEOGRAPH
	{0x7DE0,	0xBD6C},	// CJK UNIFIED IDEOGRAPH
	{0x7DE1,	0xE6E8},	// CJK UNIFIED IDEOGRAPH
	{0x7DE3,	0xBD74},	// CJK UNIFIED IDEOGRAPH
	{0x7DE6,	0xE6EB},	// CJK UNIFIED IDEOGRAPH
	{0x7DE7,	0xE6E6},	// CJK UNIFIED IDEOGRAPH
	{0x7DE8,	0xBD73},	// CJK UNIFIED IDEOGRAPH
	{0x7DE9,	0xBD77},	// CJK UNIFIED IDEOGRAPH
	{0x7DEA,	0xE6E5},	// CJK UNIFIED IDEOGRAPH
	{0x7DEC,	0xBD71},	// CJK UNIFIED IDEOGRAPH
	{0x7DEE,	0xE6EF},	// CJK UNIFIED IDEOGRAPH
	{0x7DEF,	0xBD6E},	// CJK UNIFIED IDEOGRAPH
	{0x7DF0,	0xE6EE},	// CJK UNIFIED IDEOGRAPH
	{0x7DF1,	0xE6ED},	// CJK UNIFIED IDEOGRAPH
	{0x7DF2,	0xBD7A},	// CJK UNIFIED IDEOGRAPH
	{0x7DF3,	0xE572},	// CJK UNIFIED IDEOGRAPH
	{0x7DF4,	0xBD6D},	// CJK UNIFIED IDEOGRAPH
	{0x7DF6,	0xE6EC},	// CJK UNIFIED IDEOGRAPH
	{0x7DF7,	0xE6E3},	// CJK UNIFIED IDEOGRAPH
	{0x7DF9,	0xBD7B},	// CJK UNIFIED IDEOGRAPH
	{0x7DFA,	0xE6EA},	// CJK UNIFIED IDEOGRAPH
	{0x7DFB,	0xBD6F},	// CJK UNIFIED IDEOGRAPH
	{0x7E03,	0xE6E9},	// CJK UNIFIED IDEOGRAPH
	{0x7E08,	0xBFA2},	// CJK UNIFIED IDEOGRAPH
	{0x7E09,	0xBFA7},	// CJK UNIFIED IDEOGRAPH
	{0x7E0A,	0xBF7E},	// CJK UNIFIED IDEOGRAPH
	{0x7E0B,	0xEAD8},	// CJK UNIFIED IDEOGRAPH
	{0x7E0C,	0xEACF},	// CJK UNIFIED IDEOGRAPH
	{0x7E0D,	0xEADB},	// CJK UNIFIED IDEOGRAPH
	{0x7E0E,	0xEAD3},	// CJK UNIFIED IDEOGRAPH
	{0x7E0F,	0xEAD9},	// CJK UNIFIED IDEOGRAPH
	{0x7E10,	0xBFA8},	// CJK UNIFIED IDEOGRAPH
	{0x7E11,	0xBFA1},	// CJK UNIFIED IDEOGRAPH
	{0x7E12,	0xEACC},	// CJK UNIFIED IDEOGRAPH
	{0x7E13,	0xEAD2},	// CJK UNIFIED IDEOGRAPH
	{0x7E14,	0xEADC},	// CJK UNIFIED IDEOGRAPH
	{0x7E15,	0xEAD5},	// CJK UNIFIED IDEOGRAPH
	{0x7E16,	0xEADA},	// CJK UNIFIED IDEOGRAPH
	{0x7E17,	0xEACE},	// CJK UNIFIED IDEOGRAPH
	{0x7E1A,	0xEAD6},	// CJK UNIFIED IDEOGRAPH
	{0x7E1B,	0xBFA3},	// CJK UNIFIED IDEOGRAPH
	{0x7E1C,	0xEAD4},	// CJK UNIFIED IDEOGRAPH
	{0x7E1D,	0xBFA6},	// CJK UNIFIED IDEOGRAPH
	{0x7E1E,	0xBFA5},	// CJK UNIFIED IDEOGRAPH
	{0x7E1F,	0xEAD0},	// CJK UNIFIED IDEOGRAPH
	{0x7E20,	0xEAD1},	// CJK UNIFIED IDEOGRAPH
	{0x7E21,	0xEACD},	// CJK UNIFIED IDEOGRAPH
	{0x7E22,	0xEAD7},	// CJK UNIFIED IDEOGRAPH
	{0x7E23,	0xBFA4},	// CJK UNIFIED IDEOGRAPH
	{0x7E24,	0xEADE},	// CJK UNIFIED IDEOGRAPH
	{0x7E25,	0xEADD},	// CJK UNIFIED IDEOGRAPH
	{0x7E29,	0xEDDA},	// CJK UNIFIED IDEOGRAPH
	{0x7E2A,	0xEDD6},	// CJK UNIFIED IDEOGRAPH
	{0x7E2B,	0xC15F},	// CJK UNIFIED IDEOGRAPH
	{0x7E2D,	0xEDD0},	// CJK UNIFIED IDEOGRAPH
	{0x7E2E,	0xC159},	// CJK UNIFIED IDEOGRAPH
	{0x7E2F,	0xC169},	// CJK UNIFIED IDEOGRAPH
	{0x7E30,	0xEDDC},	// CJK UNIFIED IDEOGRAPH
	{0x7E31,	0xC161},	// CJK UNIFIED IDEOGRAPH
	{0x7E32,	0xC15D},	// CJK UNIFIED IDEOGRAPH
	{0x7E33,	0xEDD3},	// CJK UNIFIED IDEOGRAPH
	{0x7E34,	0xC164},	// CJK UNIFIED IDEOGRAPH
	{0x7E35,	0xC167},	// CJK UNIFIED IDEOGRAPH
	{0x7E36,	0xEDDE},	// CJK UNIFIED IDEOGRAPH
	{0x7E37,	0xC15C},	// CJK UNIFIED IDEOGRAPH
	{0x7E38,	0xEDD5},	// CJK UNIFIED IDEOGRAPH
	{0x7E39,	0xC165},	// CJK UNIFIED IDEOGRAPH
	{0x7E3A,	0xEDE0},	// CJK UNIFIED IDEOGRAPH
	{0x7E3B,	0xEDDD},	// CJK UNIFIED IDEOGRAPH
	{0x7E3C,	0xEDD1},	// CJK UNIFIED IDEOGRAPH
	{0x7E3D,	0xC160},	// CJK UNIFIED IDEOGRAPH
	{0x7E3E,	0xC15A},	// CJK UNIFIED IDEOGRAPH
	{0x7E3F,	0xC168},	// CJK UNIFIED IDEOGRAPH
	{0x7E40,	0xEDD8},	// CJK UNIFIED IDEOGRAPH
	{0x7E41,	0xC163},	// CJK UNIFIED IDEOGRAPH
	{0x7E42,	0xEDD2},	// CJK UNIFIED IDEOGRAPH
	{0x7E43,	0xC15E},	// CJK UNIFIED IDEOGRAPH
	{0x7E44,	0xEDDF},	// CJK UNIFIED IDEOGRAPH
	{0x7E45,	0xC162},	// CJK UNIFIED IDEOGRAPH
	{0x7E46,	0xC15B},	// CJK UNIFIED IDEOGRAPH
	{0x7E47,	0xEDD9},	// CJK UNIFIED IDEOGRAPH
	{0x7E48,	0xC166},	// CJK UNIFIED IDEOGRAPH
	{0x7E49,	0xEDD7},	// CJK UNIFIED IDEOGRAPH
	{0x7E4C,	0xEDDB},	// CJK UNIFIED IDEOGRAPH
	{0x7E50,	0xF06E},	// CJK UNIFIED IDEOGRAPH
	{0x7E51,	0xF074},	// CJK UNIFIED IDEOGRAPH
	{0x7E52,	0xC2B9},	// CJK UNIFIED IDEOGRAPH
	{0x7E53,	0xF077},	// CJK UNIFIED IDEOGRAPH
	{0x7E54,	0xC2B4},	// CJK UNIFIED IDEOGRAPH
	{0x7E55,	0xC2B5},	// CJK UNIFIED IDEOGRAPH
	{0x7E56,	0xF06F},	// CJK UNIFIED IDEOGRAPH
	{0x7E57,	0xF076},	// CJK UNIFIED IDEOGRAPH
	{0x7E58,	0xF071},	// CJK UNIFIED IDEOGRAPH
	{0x7E59,	0xC2BA},	// CJK UNIFIED IDEOGRAPH
	{0x7E5A,	0xC2B7},	// CJK UNIFIED IDEOGRAPH
	{0x7E5C,	0xF06D},	// CJK UNIFIED IDEOGRAPH
	{0x7E5E,	0xC2B6},	// CJK UNIFIED IDEOGRAPH
	{0x7E5F,	0xF073},	// CJK UNIFIED IDEOGRAPH
	{0x7E60,	0xF075},	// CJK UNIFIED IDEOGRAPH
	{0x7E61,	0xC2B8},	// CJK UNIFIED IDEOGRAPH
	{0x7E62,	0xF072},	// CJK UNIFIED IDEOGRAPH
	{0x7E63,	0xF070},	// CJK UNIFIED IDEOGRAPH
	{0x7E68,	0xF2B8},	// CJK UNIFIED IDEOGRAPH
	{0x7E69,	0xC3B7},	// CJK UNIFIED IDEOGRAPH
	{0x7E6A,	0xC3B8},	// CJK UNIFIED IDEOGRAPH
	{0x7E6B,	0xC3B4},	// CJK UNIFIED IDEOGRAPH
	{0x7E6D,	0xC3B5},	// CJK UNIFIED IDEOGRAPH
	{0x7E6F,	0xF2B4},	// CJK UNIFIED IDEOGRAPH
	{0x7E70,	0xF2B2},	// CJK UNIFIED IDEOGRAPH
	{0x7E72,	0xF2B6},	// CJK UNIFIED IDEOGRAPH
	{0x7E73,	0xC3BA},	// CJK UNIFIED IDEOGRAPH
	{0x7E74,	0xF2B7},	// CJK UNIFIED IDEOGRAPH
	{0x7E75,	0xF2B0},	// CJK UNIFIED IDEOGRAPH
	{0x7E76,	0xF2AF},	// CJK UNIFIED IDEOGRAPH
	{0x7E77,	0xF2B3},	// CJK UNIFIED IDEOGRAPH
	{0x7E78,	0xF2B1},	// CJK UNIFIED IDEOGRAPH
	{0x7E79,	0xC3B6},	// CJK UNIFIED IDEOGRAPH
	{0x7E7A,	0xF2B5},	// CJK UNIFIED IDEOGRAPH
	{0x7E7B,	0xF4AC},	// CJK UNIFIED IDEOGRAPH
	{0x7E7C,	0xC47E},	// CJK UNIFIED IDEOGRAPH
	{0x7E7D,	0xC47D},	// CJK UNIFIED IDEOGRAPH
	{0x7E7E,	0xF4AD},	// CJK UNIFIED IDEOGRAPH
	{0x7E80,	0xF4AF},	// CJK UNIFIED IDEOGRAPH
	{0x7E81,	0xF4AE},	// CJK UNIFIED IDEOGRAPH
	{0x7E82,	0xC4A1},	// CJK UNIFIED IDEOGRAPH
	{0x7E86,	0xF5EB},	// CJK UNIFIED IDEOGRAPH
	{0x7E87,	0xF5E8},	// CJK UNIFIED IDEOGRAPH
	{0x7E88,	0xF5E9},	// CJK UNIFIED IDEOGRAPH
	{0x7E8A,	0xF5E7},	// CJK UNIFIED IDEOGRAPH
	{0x7E8B,	0xF5EA},	// CJK UNIFIED IDEOGRAPH
	{0x7E8C,	0xC4F2},	// CJK UNIFIED IDEOGRAPH
	{0x7E8D,	0xF5EC},	// CJK UNIFIED IDEOGRAPH
	{0x7E8F,	0xC4F1},	// CJK UNIFIED IDEOGRAPH
	{0x7E91,	0xF742},	// CJK UNIFIED IDEOGRAPH
	{0x7E93,	0xC5D5},	// CJK UNIFIED IDEOGRAPH
	{0x7E94,	0xC5D7},	// CJK UNIFIED IDEOGRAPH
	{0x7E95,	0xF7EE},	// CJK UNIFIED IDEOGRAPH
	{0x7E96,	0xC5D6},	// CJK UNIFIED IDEOGRAPH
	{0x7E97,	0xF8B9},	// CJK UNIFIED IDEOGRAPH
	{0x7E98,	0xF940},	// CJK UNIFIED IDEOGRAPH
	{0x7E99,	0xF942},	// CJK UNIFIED IDEOGRAPH
	{0x7E9A,	0xF8FE},	// CJK UNIFIED IDEOGRAPH
	{0x7E9B,	0xF941},	// CJK UNIFIED IDEOGRAPH
	{0x7E9C,	0xC66C},	// CJK UNIFIED IDEOGRAPH
	{0x7F36,	0xA6CE},	// CJK UNIFIED IDEOGRAPH
	{0x7F38,	0xACFB},	// CJK UNIFIED IDEOGRAPH
	{0x7F39,	0xD26F},	// CJK UNIFIED IDEOGRAPH
	{0x7F3A,	0xAFCA},	// CJK UNIFIED IDEOGRAPH
	{0x7F3D,	0xB2DA},	// CJK UNIFIED IDEOGRAPH
	{0x7F3E,	0xDAFC},	// CJK UNIFIED IDEOGRAPH
	{0x7F3F,	0xDAFD},	// CJK UNIFIED IDEOGRAPH
	{0x7F43,	0xEADF},	// CJK UNIFIED IDEOGRAPH
	{0x7F44,	0xC16A},	// CJK UNIFIED IDEOGRAPH
	{0x7F45,	0xEDE1},	// CJK UNIFIED IDEOGRAPH
	{0x7F48,	0xC2BB},	// CJK UNIFIED IDEOGRAPH
	{0x7F4A,	0xF2BA},	// CJK UNIFIED IDEOGRAPH
	{0x7F4B,	0xF2B9},	// CJK UNIFIED IDEOGRAPH
	{0x7F4C,	0xC4A2},	// CJK UNIFIED IDEOGRAPH
	{0x7F4D,	0xF5ED},	// CJK UNIFIED IDEOGRAPH
	{0x7F4F,	0xF743},	// CJK UNIFIED IDEOGRAPH
	{0x7F50,	0xC5F8},	// CJK UNIFIED IDEOGRAPH
	{0x7F51,	0xCA49},	// CJK UNIFIED IDEOGRAPH
	{0x7F54,	0xAAC9},	// CJK UNIFIED IDEOGRAPH
	{0x7F55,	0xA875},	// CJK UNIFIED IDEOGRAPH
	{0x7F58,	0xD04D},	// CJK UNIFIED IDEOGRAPH
	{0x7F5B,	0xD360},	// CJK UNIFIED IDEOGRAPH
	{0x7F5C,	0xD35B},	// CJK UNIFIED IDEOGRAPH
	{0x7F5D,	0xD35F},	// CJK UNIFIED IDEOGRAPH
	{0x7F5E,	0xD35D},	// CJK UNIFIED IDEOGRAPH
	{0x7F5F,	0xAFCB},	// CJK UNIFIED IDEOGRAPH
	{0x7F60,	0xD35E},	// CJK UNIFIED IDEOGRAPH
	{0x7F61,	0xD35C},	// CJK UNIFIED IDEOGRAPH
	{0x7F63,	0xD6F1},	// CJK UNIFIED IDEOGRAPH
	{0x7F65,	0xDAFE},	// CJK UNIFIED IDEOGRAPH
	{0x7F66,	0xDB40},	// CJK UNIFIED IDEOGRAPH
	{0x7F67,	0xDF69},	// CJK UNIFIED IDEOGRAPH
	{0x7F68,	0xDF6A},	// CJK UNIFIED IDEOGRAPH
	{0x7F69,	0xB86E},	// CJK UNIFIED IDEOGRAPH
	{0x7F6A,	0xB86F},	// CJK UNIFIED IDEOGRAPH
	{0x7F6B,	0xDF68},	// CJK UNIFIED IDEOGRAPH
	{0x7F6C,	0xDF6B},	// CJK UNIFIED IDEOGRAPH
	{0x7F6D,	0xDF67},	// CJK UNIFIED IDEOGRAPH
	{0x7F6E,	0xB86D},	// CJK UNIFIED IDEOGRAPH
	{0x7F70,	0xBB40},	// CJK UNIFIED IDEOGRAPH
	{0x7F72,	0xB870},	// CJK UNIFIED IDEOGRAPH
	{0x7F73,	0xE37A},	// CJK UNIFIED IDEOGRAPH
	{0x7F75,	0xBD7C},	// CJK UNIFIED IDEOGRAPH
	{0x7F76,	0xE6F1},	// CJK UNIFIED IDEOGRAPH
	{0x7F77,	0xBD7D},	// CJK UNIFIED IDEOGRAPH
	{0x7F79,	0xBFA9},	// CJK UNIFIED IDEOGRAPH
	{0x7F7A,	0xEAE2},	// CJK UNIFIED IDEOGRAPH
	{0x7F7B,	0xEAE0},	// CJK UNIFIED IDEOGRAPH
	{0x7F7C,	0xEAE1},	// CJK UNIFIED IDEOGRAPH
	{0x7F7D,	0xEDE4},	// CJK UNIFIED IDEOGRAPH
	{0x7F7E,	0xEDE3},	// CJK UNIFIED IDEOGRAPH
	{0x7F7F,	0xEDE2},	// CJK UNIFIED IDEOGRAPH
	{0x7F83,	0xF2BB},	// CJK UNIFIED IDEOGRAPH
	{0x7F85,	0xC3B9},	// CJK UNIFIED IDEOGRAPH
	{0x7F86,	0xF2BC},	// CJK UNIFIED IDEOGRAPH
	{0x7F87,	0xF744},	// CJK UNIFIED IDEOGRAPH
	{0x7F88,	0xC5F9},	// CJK UNIFIED IDEOGRAPH
	{0x7F89,	0xF8BA},	// CJK UNIFIED IDEOGRAPH
	{0x7F8A,	0xA6CF},	// CJK UNIFIED IDEOGRAPH
	{0x7F8B,	0xAACB},	// CJK UNIFIED IDEOGRAPH
	{0x7F8C,	0xAACA},	// CJK UNIFIED IDEOGRAPH
	{0x7F8D,	0xD04F},	// CJK UNIFIED IDEOGRAPH
	{0x7F8E,	0xACFC},	// CJK UNIFIED IDEOGRAPH
	{0x7F91,	0xD04E},	// CJK UNIFIED IDEOGRAPH
	{0x7F92,	0xD362},	// CJK UNIFIED IDEOGRAPH
	{0x7F94,	0xAFCC},	// CJK UNIFIED IDEOGRAPH
	{0x7F95,	0xD6F2},	// CJK UNIFIED IDEOGRAPH
	{0x7F96,	0xD361},	// CJK UNIFIED IDEOGRAPH
	{0x7F9A,	0xB2DC},	// CJK UNIFIED IDEOGRAPH
	{0x7F9B,	0xD6F5},	// CJK UNIFIED IDEOGRAPH
	{0x7F9C,	0xD6F3},	// CJK UNIFIED IDEOGRAPH
	{0x7F9D,	0xD6F4},	// CJK UNIFIED IDEOGRAPH
	{0x7F9E,	0xB2DB},	// CJK UNIFIED IDEOGRAPH
	{0x7FA0,	0xDB42},	// CJK UNIFIED IDEOGRAPH
	{0x7FA1,	0xDB43},	// CJK UNIFIED IDEOGRAPH
	{0x7FA2,	0xDB41},	// CJK UNIFIED IDEOGRAPH
	{0x7FA4,	0xB873},	// CJK UNIFIED IDEOGRAPH
	{0x7FA5,	0xDF6D},	// CJK UNIFIED IDEOGRAPH
	{0x7FA6,	0xDF6C},	// CJK UNIFIED IDEOGRAPH
	{0x7FA7,	0xDF6E},	// CJK UNIFIED IDEOGRAPH
	{0x7FA8,	0xB872},	// CJK UNIFIED IDEOGRAPH
	{0x7FA9,	0xB871},	// CJK UNIFIED IDEOGRAPH
	{0x7FAC,	0xE6F2},	// CJK UNIFIED IDEOGRAPH
	{0x7FAD,	0xE6F4},	// CJK UNIFIED IDEOGRAPH
	{0x7FAF,	0xBD7E},	// CJK UNIFIED IDEOGRAPH
	{0x7FB0,	0xE6F3},	// CJK UNIFIED IDEOGRAPH
	{0x7FB1,	0xEAE3},	// CJK UNIFIED IDEOGRAPH
	{0x7FB2,	0xBFAA},	// CJK UNIFIED IDEOGRAPH
	{0x7FB3,	0xF079},	// CJK UNIFIED IDEOGRAPH
	{0x7FB5,	0xF078},	// CJK UNIFIED IDEOGRAPH
	{0x7FB6,	0xC3BB},	// CJK UNIFIED IDEOGRAPH
	{0x7FB7,	0xF2BD},	// CJK UNIFIED IDEOGRAPH
	{0x7FB8,	0xC3BD},	// CJK UNIFIED IDEOGRAPH
	{0x7FB9,	0xC3BC},	// CJK UNIFIED IDEOGRAPH
	{0x7FBA,	0xF4B0},	// CJK UNIFIED IDEOGRAPH
	{0x7FBB,	0xF5EE},	// CJK UNIFIED IDEOGRAPH
	{0x7FBC,	0xC4F3},	// CJK UNIFIED IDEOGRAPH
	{0x7FBD,	0xA6D0},	// CJK UNIFIED IDEOGRAPH
	{0x7FBE,	0xD050},	// CJK UNIFIED IDEOGRAPH
	{0x7FBF,	0xACFD},	// CJK UNIFIED IDEOGRAPH
	{0x7FC0,	0xD365},	// CJK UNIFIED IDEOGRAPH
	{0x7FC1,	0xAFCE},	// CJK UNIFIED IDEOGRAPH
	{0x7FC2,	0xD364},	// CJK UNIFIED IDEOGRAPH
	{0x7FC3,	0xD363},	// CJK UNIFIED IDEOGRAPH
	{0x7FC5,	0xAFCD},	// CJK UNIFIED IDEOGRAPH
	{0x7FC7,	0xD6FB},	// CJK UNIFIED IDEOGRAPH
	{0x7FC9,	0xD6FD},	// CJK UNIFIED IDEOGRAPH
	{0x7FCA,	0xD6F6},	// CJK UNIFIED IDEOGRAPH
	{0x7FCB,	0xD6F7},	// CJK UNIFIED IDEOGRAPH
	{0x7FCC,	0xB2DD},	// CJK UNIFIED IDEOGRAPH
	{0x7FCD,	0xD6F8},	// CJK UNIFIED IDEOGRAPH
	{0x7FCE,	0xB2DE},	// CJK UNIFIED IDEOGRAPH
	{0x7FCF,	0xD6FC},	// CJK UNIFIED IDEOGRAPH
	{0x7FD0,	0xD6F9},	// CJK UNIFIED IDEOGRAPH
	{0x7FD1,	0xD6FA},	// CJK UNIFIED IDEOGRAPH
	{0x7FD2,	0xB2DF},	// CJK UNIFIED IDEOGRAPH
	{0x7FD4,	0xB5BE},	// CJK UNIFIED IDEOGRAPH
	{0x7FD5,	0xB5BF},	// CJK UNIFIED IDEOGRAPH
	{0x7FD7,	0xDB44},	// CJK UNIFIED IDEOGRAPH
	{0x7FDB,	0xDF6F},	// CJK UNIFIED IDEOGRAPH
	{0x7FDC,	0xDF70},	// CJK UNIFIED IDEOGRAPH
	{0x7FDE,	0xE37E},	// CJK UNIFIED IDEOGRAPH
	{0x7FDF,	0xBB43},	// CJK UNIFIED IDEOGRAPH
	{0x7FE0,	0xBB41},	// CJK UNIFIED IDEOGRAPH
	{0x7FE1,	0xBB42},	// CJK UNIFIED IDEOGRAPH
	{0x7FE2,	0xE37B},	// CJK UNIFIED IDEOGRAPH
	{0x7FE3,	0xE37C},	// CJK UNIFIED IDEOGRAPH
	{0x7FE5,	0xE37D},	// CJK UNIFIED IDEOGRAPH
	{0x7FE6,	0xE6F9},	// CJK UNIFIED IDEOGRAPH
	{0x7FE8,	0xE6FA},	// CJK UNIFIED IDEOGRAPH
	{0x7FE9,	0xBDA1},	// CJK UNIFIED IDEOGRAPH
	{0x7FEA,	0xE6F7},	// CJK UNIFIED IDEOGRAPH
	{0x7FEB,	0xE6F6},	// CJK UNIFIED IDEOGRAPH
	{0x7FEC,	0xE6F8},	// CJK UNIFIED IDEOGRAPH
	{0x7FED,	0xE6F5},	// CJK UNIFIED IDEOGRAPH
	{0x7FEE,	0xBFAD},	// CJK UNIFIED IDEOGRAPH
	{0x7FEF,	0xEAE4},	// CJK UNIFIED IDEOGRAPH
	{0x7FF0,	0xBFAB},	// CJK UNIFIED IDEOGRAPH
	{0x7FF1,	0xBFAC},	// CJK UNIFIED IDEOGRAPH
	{0x7FF2,	0xEDE6},	// CJK UNIFIED IDEOGRAPH
	{0x7FF3,	0xC16B},	// CJK UNIFIED IDEOGRAPH
	{0x7FF4,	0xEDE5},	// CJK UNIFIED IDEOGRAPH
	{0x7FF5,	0xEFA8},	// CJK UNIFIED IDEOGRAPH
	{0x7FF7,	0xF07A},	// CJK UNIFIED IDEOGRAPH
	{0x7FF8,	0xF07B},	// CJK UNIFIED IDEOGRAPH
	{0x7FF9,	0xC2BC},	// CJK UNIFIED IDEOGRAPH
	{0x7FFB,	0xC2BD},	// CJK UNIFIED IDEOGRAPH
	{0x7FFC,	0xC16C},	// CJK UNIFIED IDEOGRAPH
	{0x7FFD,	0xF2BE},	// CJK UNIFIED IDEOGRAPH
	{0x7FFE,	0xF2BF},	// CJK UNIFIED IDEOGRAPH
	{0x7FFF,	0xF4B1},	// CJK UNIFIED IDEOGRAPH
	{0x8000,	0xC4A3},	// CJK UNIFIED IDEOGRAPH
	{0x8001,	0xA6D1},	// CJK UNIFIED IDEOGRAPH
	{0x8003,	0xA6D2},	// CJK UNIFIED IDEOGRAPH
	{0x8004,	0xACFE},	// CJK UNIFIED IDEOGRAPH
	{0x8005,	0xAACC},	// CJK UNIFIED IDEOGRAPH
	{0x8006,	0xAFCF},	// CJK UNIFIED IDEOGRAPH
	{0x8007,	0xD051},	// CJK UNIFIED IDEOGRAPH
	{0x800B,	0xB5C0},	// CJK UNIFIED IDEOGRAPH
	{0x800C,	0xA6D3},	// CJK UNIFIED IDEOGRAPH
	{0x800D,	0xAD41},	// CJK UNIFIED IDEOGRAPH
	{0x800E,	0xD052},	// CJK UNIFIED IDEOGRAPH
	{0x800F,	0xD053},	// CJK UNIFIED IDEOGRAPH
	{0x8010,	0xAD40},	// CJK UNIFIED IDEOGRAPH
	{0x8011,	0xAD42},	// CJK UNIFIED IDEOGRAPH
	{0x8012,	0xA6D4},	// CJK UNIFIED IDEOGRAPH
	{0x8014,	0xD054},	// CJK UNIFIED IDEOGRAPH
	{0x8015,	0xAFD1},	// CJK UNIFIED IDEOGRAPH
	{0x8016,	0xD366},	// CJK UNIFIED IDEOGRAPH
	{0x8017,	0xAFD3},	// CJK UNIFIED IDEOGRAPH
	{0x8018,	0xAFD0},	// CJK UNIFIED IDEOGRAPH
	{0x8019,	0xAFD2},	// CJK UNIFIED IDEOGRAPH
	{0x801B,	0xD741},	// CJK UNIFIED IDEOGRAPH
	{0x801C,	0xB2E0},	// CJK UNIFIED IDEOGRAPH
	{0x801E,	0xD740},	// CJK UNIFIED IDEOGRAPH
	{0x801F,	0xD6FE},	// CJK UNIFIED IDEOGRAPH
	{0x8021,	0xDF71},	// CJK UNIFIED IDEOGRAPH
	{0x8024,	0xE3A1},	// CJK UNIFIED IDEOGRAPH
	{0x8026,	0xBDA2},	// CJK UNIFIED IDEOGRAPH
	{0x8028,	0xBFAE},	// CJK UNIFIED IDEOGRAPH
	{0x8029,	0xEAE6},	// CJK UNIFIED IDEOGRAPH
	{0x802A,	0xEAE5},	// CJK UNIFIED IDEOGRAPH
	{0x802C,	0xEDE7},	// CJK UNIFIED IDEOGRAPH
	{0x8030,	0xF5EF},	// CJK UNIFIED IDEOGRAPH
	{0x8033,	0xA6D5},	// CJK UNIFIED IDEOGRAPH
	{0x8034,	0xCB73},	// CJK UNIFIED IDEOGRAPH
	{0x8035,	0xCDAA},	// CJK UNIFIED IDEOGRAPH
	{0x8036,	0xAD43},	// CJK UNIFIED IDEOGRAPH
	{0x8037,	0xD055},	// CJK UNIFIED IDEOGRAPH
	{0x8039,	0xD368},	// CJK UNIFIED IDEOGRAPH
	{0x803D,	0xAFD4},	// CJK UNIFIED IDEOGRAPH
	{0x803E,	0xD367},	// CJK UNIFIED IDEOGRAPH
	{0x803F,	0xAFD5},	// CJK UNIFIED IDEOGRAPH
	{0x8043,	0xD743},	// CJK UNIFIED IDEOGRAPH
	{0x8046,	0xB2E2},	// CJK UNIFIED IDEOGRAPH
	{0x8047,	0xD742},	// CJK UNIFIED IDEOGRAPH
	{0x8048,	0xD744},	// CJK UNIFIED IDEOGRAPH
	{0x804A,	0xB2E1},	// CJK UNIFIED IDEOGRAPH
	{0x804F,	0xDB46},	// CJK UNIFIED IDEOGRAPH
	{0x8050,	0xDB47},	// CJK UNIFIED IDEOGRAPH
	{0x8051,	0xDB45},	// CJK UNIFIED IDEOGRAPH
	{0x8052,	0xB5C1},	// CJK UNIFIED IDEOGRAPH
	{0x8056,	0xB874},	// CJK UNIFIED IDEOGRAPH
	{0x8058,	0xB875},	// CJK UNIFIED IDEOGRAPH
	{0x805A,	0xBB45},	// CJK UNIFIED IDEOGRAPH
	{0x805C,	0xE3A3},	// CJK UNIFIED IDEOGRAPH
	{0x805D,	0xE3A2},	// CJK UNIFIED IDEOGRAPH
	{0x805E,	0xBB44},	// CJK UNIFIED IDEOGRAPH
	{0x8064,	0xE6FB},	// CJK UNIFIED IDEOGRAPH
	{0x8067,	0xE6FC},	// CJK UNIFIED IDEOGRAPH
	{0x806C,	0xEAE7},	// CJK UNIFIED IDEOGRAPH
	{0x806F,	0xC170},	// CJK UNIFIED IDEOGRAPH
	{0x8070,	0xC16F},	// CJK UNIFIED IDEOGRAPH
	{0x8071,	0xC16D},	// CJK UNIFIED IDEOGRAPH
	{0x8072,	0xC16E},	// CJK UNIFIED IDEOGRAPH
	{0x8073,	0xC171},	// CJK UNIFIED IDEOGRAPH
	{0x8075,	0xF07C},	// CJK UNIFIED IDEOGRAPH
	{0x8076,	0xC2BF},	// CJK UNIFIED IDEOGRAPH
	{0x8077,	0xC2BE},	// CJK UNIFIED IDEOGRAPH
	{0x8078,	0xF2C0},	// CJK UNIFIED IDEOGRAPH
	{0x8079,	0xF4B2},	// CJK UNIFIED IDEOGRAPH
	{0x807D,	0xC5A5},	// CJK UNIFIED IDEOGRAPH
	{0x807E,	0xC5A4},	// CJK UNIFIED IDEOGRAPH
	{0x807F,	0xA6D6},	// CJK UNIFIED IDEOGRAPH
	{0x8082,	0xD1FB},	// CJK UNIFIED IDEOGRAPH
	{0x8084,	0xB877},	// CJK UNIFIED IDEOGRAPH
	{0x8085,	0xB5C2},	// CJK UNIFIED IDEOGRAPH
	{0x8086,	0xB876},	// CJK UNIFIED IDEOGRAPH
	{0x8087,	0xBB46},	// CJK UNIFIED IDEOGRAPH
	{0x8089,	0xA6D7},	// CJK UNIFIED IDEOGRAPH
	{0x808A,	0xC9A9},	// CJK UNIFIED IDEOGRAPH
	{0x808B,	0xA6D8},	// CJK UNIFIED IDEOGRAPH
	{0x808C,	0xA6D9},	// CJK UNIFIED IDEOGRAPH
	{0x808F,	0xCDAB},	// CJK UNIFIED IDEOGRAPH
	{0x8090,	0xCB76},	// CJK UNIFIED IDEOGRAPH
	{0x8092,	0xCB77},	// CJK UNIFIED IDEOGRAPH
	{0x8093,	0xA877},	// CJK UNIFIED IDEOGRAPH
	{0x8095,	0xCB74},	// CJK UNIFIED IDEOGRAPH
	{0x8096,	0xA876},	// CJK UNIFIED IDEOGRAPH
	{0x8098,	0xA879},	// CJK UNIFIED IDEOGRAPH
	{0x8099,	0xCB75},	// CJK UNIFIED IDEOGRAPH
	{0x809A,	0xA87B},	// CJK UNIFIED IDEOGRAPH
	{0x809B,	0xA87A},	// CJK UNIFIED IDEOGRAPH
	{0x809C,	0xCB78},	// CJK UNIFIED IDEOGRAPH
	{0x809D,	0xA878},	// CJK UNIFIED IDEOGRAPH
	{0x80A1,	0xAAD1},	// CJK UNIFIED IDEOGRAPH
	{0x80A2,	0xAACF},	// CJK UNIFIED IDEOGRAPH
	{0x80A3,	0xCDAD},	// CJK UNIFIED IDEOGRAPH
	{0x80A5,	0xAACE},	// CJK UNIFIED IDEOGRAPH
	{0x80A9,	0xAAD3},	// CJK UNIFIED IDEOGRAPH
	{0x80AA,	0xAAD5},	// CJK UNIFIED IDEOGRAPH
	{0x80AB,	0xAAD2},	// CJK UNIFIED IDEOGRAPH
	{0x80AD,	0xCDB0},	// CJK UNIFIED IDEOGRAPH
	{0x80AE,	0xCDAC},	// CJK UNIFIED IDEOGRAPH
	{0x80AF,	0xAAD6},	// CJK UNIFIED IDEOGRAPH
	{0x80B1,	0xAAD0},	// CJK UNIFIED IDEOGRAPH
	{0x80B2,	0xA87C},	// CJK UNIFIED IDEOGRAPH
	{0x80B4,	0xAAD4},	// CJK UNIFIED IDEOGRAPH
	{0x80B5,	0xCDAF},	// CJK UNIFIED IDEOGRAPH
	{0x80B8,	0xCDAE},	// CJK UNIFIED IDEOGRAPH
	{0x80BA,	0xAACD},	// CJK UNIFIED IDEOGRAPH
	{0x80C2,	0xD05B},	// CJK UNIFIED IDEOGRAPH
	{0x80C3,	0xAD47},	// CJK UNIFIED IDEOGRAPH
	{0x80C4,	0xAD48},	// CJK UNIFIED IDEOGRAPH
	{0x80C5,	0xD05D},	// CJK UNIFIED IDEOGRAPH
	{0x80C7,	0xD057},	// CJK UNIFIED IDEOGRAPH
	{0x80C8,	0xD05A},	// CJK UNIFIED IDEOGRAPH
	{0x80C9,	0xD063},	// CJK UNIFIED IDEOGRAPH
	{0x80CA,	0xD061},	// CJK UNIFIED IDEOGRAPH
	{0x80CC,	0xAD49},	// CJK UNIFIED IDEOGRAPH
	{0x80CD,	0xD067},	// CJK UNIFIED IDEOGRAPH
	{0x80CE,	0xAD4C},	// CJK UNIFIED IDEOGRAPH
	{0x80CF,	0xD064},	// CJK UNIFIED IDEOGRAPH
	{0x80D0,	0xD05C},	// CJK UNIFIED IDEOGRAPH
	{0x80D1,	0xD059},	// CJK UNIFIED IDEOGRAPH
	{0x80D4,	0xDB49},	// CJK UNIFIED IDEOGRAPH
	{0x80D5,	0xD062},	// CJK UNIFIED IDEOGRAPH
	{0x80D6,	0xAD44},	// CJK UNIFIED IDEOGRAPH
	{0x80D7,	0xD065},	// CJK UNIFIED IDEOGRAPH
	{0x80D8,	0xD056},	// CJK UNIFIED IDEOGRAPH
	{0x80D9,	0xD05F},	// CJK UNIFIED IDEOGRAPH
	{0x80DA,	0xAD46},	// CJK UNIFIED IDEOGRAPH
	{0x80DB,	0xAD4B},	// CJK UNIFIED IDEOGRAPH
	{0x80DC,	0xD060},	// CJK UNIFIED IDEOGRAPH
	{0x80DD,	0xAD4F},	// CJK UNIFIED IDEOGRAPH
	{0x80DE,	0xAD4D},	// CJK UNIFIED IDEOGRAPH
	{0x80E0,	0xD058},	// CJK UNIFIED IDEOGRAPH
	{0x80E1,	0xAD4A},	// CJK UNIFIED IDEOGRAPH
	{0x80E3,	0xD05E},	// CJK UNIFIED IDEOGRAPH
	{0x80E4,	0xAD4E},	// CJK UNIFIED IDEOGRAPH
	{0x80E5,	0xAD45},	// CJK UNIFIED IDEOGRAPH
	{0x80E6,	0xD066},	// CJK UNIFIED IDEOGRAPH
	{0x80ED,	0xAFDA},	// CJK UNIFIED IDEOGRAPH
	{0x80EF,	0xAFE3},	// CJK UNIFIED IDEOGRAPH
	{0x80F0,	0xAFD8},	// CJK UNIFIED IDEOGRAPH
	{0x80F1,	0xAFD6},	// CJK UNIFIED IDEOGRAPH
	{0x80F2,	0xD36A},	// CJK UNIFIED IDEOGRAPH
	{0x80F3,	0xAFDE},	// CJK UNIFIED IDEOGRAPH
	{0x80F4,	0xAFDB},	// CJK UNIFIED IDEOGRAPH
	{0x80F5,	0xD36C},	// CJK UNIFIED IDEOGRAPH
	{0x80F8,	0xAFDD},	// CJK UNIFIED IDEOGRAPH
	{0x80F9,	0xD36B},	// CJK UNIFIED IDEOGRAPH
	{0x80FA,	0xD369},	// CJK UNIFIED IDEOGRAPH
	{0x80FB,	0xD36E},	// CJK UNIFIED IDEOGRAPH
	{0x80FC,	0xAFE2},	// CJK UNIFIED IDEOGRAPH
	{0x80FD,	0xAFE0},	// CJK UNIFIED IDEOGRAPH
	{0x80FE,	0xDB48},	// CJK UNIFIED IDEOGRAPH
	{0x8100,	0xD36F},	// CJK UNIFIED IDEOGRAPH
	{0x8101,	0xD36D},	// CJK UNIFIED IDEOGRAPH
	{0x8102,	0xAFD7},	// CJK UNIFIED IDEOGRAPH
	{0x8105,	0xAFD9},	// CJK UNIFIED IDEOGRAPH
	{0x8106,	0xAFDC},	// CJK UNIFIED IDEOGRAPH
	{0x8108,	0xAFDF},	// CJK UNIFIED IDEOGRAPH
	{0x810A,	0xAFE1},	// CJK UNIFIED IDEOGRAPH
	{0x8115,	0xD74E},	// CJK UNIFIED IDEOGRAPH
	{0x8116,	0xB2E4},	// CJK UNIFIED IDEOGRAPH
	{0x8118,	0xD745},	// CJK UNIFIED IDEOGRAPH
	{0x8119,	0xD747},	// CJK UNIFIED IDEOGRAPH
	{0x811B,	0xD748},	// CJK UNIFIED IDEOGRAPH
	{0x811D,	0xD750},	// CJK UNIFIED IDEOGRAPH
	{0x811E,	0xD74C},	// CJK UNIFIED IDEOGRAPH
	{0x811F,	0xD74A},	// CJK UNIFIED IDEOGRAPH
	{0x8121,	0xD74D},	// CJK UNIFIED IDEOGRAPH
	{0x8122,	0xD751},	// CJK UNIFIED IDEOGRAPH
	{0x8123,	0xB2E5},	// CJK UNIFIED IDEOGRAPH
	{0x8124,	0xB2E9},	// CJK UNIFIED IDEOGRAPH
	{0x8125,	0xD746},	// CJK UNIFIED IDEOGRAPH
	{0x8127,	0xD74F},	// CJK UNIFIED IDEOGRAPH
	{0x8129,	0xB2E7},	// CJK UNIFIED IDEOGRAPH
	{0x812B,	0xB2E6},	// CJK UNIFIED IDEOGRAPH
	{0x812C,	0xD74B},	// CJK UNIFIED IDEOGRAPH
	{0x812D,	0xD749},	// CJK UNIFIED IDEOGRAPH
	{0x812F,	0xB2E3},	// CJK UNIFIED IDEOGRAPH
	{0x8130,	0xB2E8},	// CJK UNIFIED IDEOGRAPH
	{0x8139,	0xB5C8},	// CJK UNIFIED IDEOGRAPH
	{0x813A,	0xDB51},	// CJK UNIFIED IDEOGRAPH
	{0x813D,	0xDB4F},	// CJK UNIFIED IDEOGRAPH
	{0x813E,	0xB5CA},	// CJK UNIFIED IDEOGRAPH
	{0x8143,	0xDB4A},	// CJK UNIFIED IDEOGRAPH
	{0x8144,	0xDFA1},	// CJK UNIFIED IDEOGRAPH
	{0x8146,	0xB5C9},	// CJK UNIFIED IDEOGRAPH
	{0x8147,	0xDB4E},	// CJK UNIFIED IDEOGRAPH
	{0x814A,	0xDB4B},	// CJK UNIFIED IDEOGRAPH
	{0x814B,	0xB5C5},	// CJK UNIFIED IDEOGRAPH
	{0x814C,	0xB5CB},	// CJK UNIFIED IDEOGRAPH
	{0x814D,	0xDB50},	// CJK UNIFIED IDEOGRAPH
	{0x814E,	0xB5C7},	// CJK UNIFIED IDEOGRAPH
	{0x814F,	0xDB4D},	// CJK UNIFIED IDEOGRAPH
	{0x8150,	0xBB47},	// CJK UNIFIED IDEOGRAPH
	{0x8151,	0xB5C6},	// CJK UNIFIED IDEOGRAPH
	{0x8152,	0xDB4C},	// CJK UNIFIED IDEOGRAPH
	{0x8153,	0xB5CC},	// CJK UNIFIED IDEOGRAPH
	{0x8154,	0xB5C4},	// CJK UNIFIED IDEOGRAPH
	{0x8155,	0xB5C3},	// CJK UNIFIED IDEOGRAPH
	{0x815B,	0xDF77},	// CJK UNIFIED IDEOGRAPH
	{0x815C,	0xDF75},	// CJK UNIFIED IDEOGRAPH
	{0x815E,	0xDF7B},	// CJK UNIFIED IDEOGRAPH
	{0x8160,	0xDF73},	// CJK UNIFIED IDEOGRAPH
	{0x8161,	0xDFA2},	// CJK UNIFIED IDEOGRAPH
	{0x8162,	0xDF78},	// CJK UNIFIED IDEOGRAPH
	{0x8164,	0xDF72},	// CJK UNIFIED IDEOGRAPH
	{0x8165,	0xB87B},	// CJK UNIFIED IDEOGRAPH
	{0x8166,	0xB8A3},	// CJK UNIFIED IDEOGRAPH
	{0x8167,	0xDF7D},	// CJK UNIFIED IDEOGRAPH
	{0x8169,	0xDF76},	// CJK UNIFIED IDEOGRAPH
	{0x816B,	0xB87E},	// CJK UNIFIED IDEOGRAPH
	{0x816E,	0xB87C},	// CJK UNIFIED IDEOGRAPH
	{0x816F,	0xDF7E},	// CJK UNIFIED IDEOGRAPH
	{0x8170,	0xB879},	// CJK UNIFIED IDEOGRAPH
	{0x8171,	0xB878},	// CJK UNIFIED IDEOGRAPH
	{0x8172,	0xDF79},	// CJK UNIFIED IDEOGRAPH
	{0x8173,	0xB87D},	// CJK UNIFIED IDEOGRAPH
	{0x8174,	0xB5CD},	// CJK UNIFIED IDEOGRAPH
	{0x8176,	0xDF7C},	// CJK UNIFIED IDEOGRAPH
	{0x8177,	0xDF74},	// CJK UNIFIED IDEOGRAPH
	{0x8178,	0xB87A},	// CJK UNIFIED IDEOGRAPH
	{0x8179,	0xB8A1},	// CJK UNIFIED IDEOGRAPH
	{0x817A,	0xB8A2},	// CJK UNIFIED IDEOGRAPH
	{0x817F,	0xBB4C},	// CJK UNIFIED IDEOGRAPH
	{0x8180,	0xBB48},	// CJK UNIFIED IDEOGRAPH
	{0x8182,	0xBB4D},	// CJK UNIFIED IDEOGRAPH
	{0x8183,	0xE3A6},	// CJK UNIFIED IDEOGRAPH
	{0x8186,	0xE3A5},	// CJK UNIFIED IDEOGRAPH
	{0x8187,	0xE3A7},	// CJK UNIFIED IDEOGRAPH
	{0x8188,	0xBB4A},	// CJK UNIFIED IDEOGRAPH
	{0x8189,	0xE3A4},	// CJK UNIFIED IDEOGRAPH
	{0x818A,	0xBB4B},	// CJK UNIFIED IDEOGRAPH
	{0x818B,	0xE3AA},	// CJK UNIFIED IDEOGRAPH
	{0x818C,	0xE3A9},	// CJK UNIFIED IDEOGRAPH
	{0x818D,	0xE3A8},	// CJK UNIFIED IDEOGRAPH
	{0x818F,	0xBB49},	// CJK UNIFIED IDEOGRAPH
	{0x8195,	0xE741},	// CJK UNIFIED IDEOGRAPH
	{0x8197,	0xE744},	// CJK UNIFIED IDEOGRAPH
	{0x8198,	0xBDA8},	// CJK UNIFIED IDEOGRAPH
	{0x8199,	0xE743},	// CJK UNIFIED IDEOGRAPH
	{0x819A,	0xBDA7},	// CJK UNIFIED IDEOGRAPH
	{0x819B,	0xBDA3},	// CJK UNIFIED IDEOGRAPH
	{0x819C,	0xBDA4},	// CJK UNIFIED IDEOGRAPH
	{0x819D,	0xBDA5},	// CJK UNIFIED IDEOGRAPH
	{0x819E,	0xE740},	// CJK UNIFIED IDEOGRAPH
	{0x819F,	0xE6FE},	// CJK UNIFIED IDEOGRAPH
	{0x81A0,	0xBDA6},	// CJK UNIFIED IDEOGRAPH
	{0x81A2,	0xE742},	// CJK UNIFIED IDEOGRAPH
	{0x81A3,	0xE6FD},	// CJK UNIFIED IDEOGRAPH
	{0x81A6,	0xEAE9},	// CJK UNIFIED IDEOGRAPH
	{0x81A7,	0xEAF3},	// CJK UNIFIED IDEOGRAPH
	{0x81A8,	0xBFB1},	// CJK UNIFIED IDEOGRAPH
	{0x81A9,	0xBFB0},	// CJK UNIFIED IDEOGRAPH
	{0x81AB,	0xEAED},	// CJK UNIFIED IDEOGRAPH
	{0x81AC,	0xEAEF},	// CJK UNIFIED IDEOGRAPH
	{0x81AE,	0xEAEA},	// CJK UNIFIED IDEOGRAPH
	{0x81B0,	0xEAEE},	// CJK UNIFIED IDEOGRAPH
	{0x81B1,	0xEAE8},	// CJK UNIFIED IDEOGRAPH
	{0x81B2,	0xEAF1},	// CJK UNIFIED IDEOGRAPH
	{0x81B3,	0xBFAF},	// CJK UNIFIED IDEOGRAPH
	{0x81B4,	0xEAF0},	// CJK UNIFIED IDEOGRAPH
	{0x81B5,	0xEAEC},	// CJK UNIFIED IDEOGRAPH
	{0x81B7,	0xEAF2},	// CJK UNIFIED IDEOGRAPH
	{0x81B9,	0xEAEB},	// CJK UNIFIED IDEOGRAPH
	{0x81BA,	0xC174},	// CJK UNIFIED IDEOGRAPH
	{0x81BB,	0xEDE8},	// CJK UNIFIED IDEOGRAPH
	{0x81BC,	0xEDEE},	// CJK UNIFIED IDEOGRAPH
	{0x81BD,	0xC178},	// CJK UNIFIED IDEOGRAPH
	{0x81BE,	0xC17A},	// CJK UNIFIED IDEOGRAPH
	{0x81BF,	0xC177},	// CJK UNIFIED IDEOGRAPH
	{0x81C0,	0xC176},	// CJK UNIFIED IDEOGRAPH
	{0x81C2,	0xC175},	// CJK UNIFIED IDEOGRAPH
	{0x81C3,	0xC173},	// CJK UNIFIED IDEOGRAPH
	{0x81C4,	0xEDE9},	// CJK UNIFIED IDEOGRAPH
	{0x81C5,	0xEDEC},	// CJK UNIFIED IDEOGRAPH
	{0x81C6,	0xC172},	// CJK UNIFIED IDEOGRAPH
	{0x81C7,	0xEDED},	// CJK UNIFIED IDEOGRAPH
	{0x81C9,	0xC179},	// CJK UNIFIED IDEOGRAPH
	{0x81CA,	0xEDEB},	// CJK UNIFIED IDEOGRAPH
	{0x81CC,	0xEDEA},	// CJK UNIFIED IDEOGRAPH
	{0x81CD,	0xC2C0},	// CJK UNIFIED IDEOGRAPH
	{0x81CF,	0xC2C1},	// CJK UNIFIED IDEOGRAPH
	{0x81D0,	0xF0A1},	// CJK UNIFIED IDEOGRAPH
	{0x81D1,	0xF07D},	// CJK UNIFIED IDEOGRAPH
	{0x81D2,	0xF07E},	// CJK UNIFIED IDEOGRAPH
	{0x81D5,	0xF2C2},	// CJK UNIFIED IDEOGRAPH
	{0x81D7,	0xF2C1},	// CJK UNIFIED IDEOGRAPH
	{0x81D8,	0xC3BE},	// CJK UNIFIED IDEOGRAPH
	{0x81D9,	0xF4B4},	// CJK UNIFIED IDEOGRAPH
	{0x81DA,	0xC4A4},	// CJK UNIFIED IDEOGRAPH
	{0x81DB,	0xF4B3},	// CJK UNIFIED IDEOGRAPH
	{0x81DD,	0xF5F0},	// CJK UNIFIED IDEOGRAPH
	{0x81DE,	0xF745},	// CJK UNIFIED IDEOGRAPH
	{0x81DF,	0xC5A6},	// CJK UNIFIED IDEOGRAPH
	{0x81E0,	0xF943},	// CJK UNIFIED IDEOGRAPH
	{0x81E1,	0xF944},	// CJK UNIFIED IDEOGRAPH
	{0x81E2,	0xC5D8},	// CJK UNIFIED IDEOGRAPH
	{0x81E3,	0xA6DA},	// CJK UNIFIED IDEOGRAPH
	{0x81E5,	0xAAD7},	// CJK UNIFIED IDEOGRAPH
	{0x81E6,	0xDB52},	// CJK UNIFIED IDEOGRAPH
	{0x81E7,	0xBB4E},	// CJK UNIFIED IDEOGRAPH
	{0x81E8,	0xC17B},	// CJK UNIFIED IDEOGRAPH
	{0x81E9,	0xEDEF},	// CJK UNIFIED IDEOGRAPH
	{0x81EA,	0xA6DB},	// CJK UNIFIED IDEOGRAPH
	{0x81EC,	0xAFE5},	// CJK UNIFIED IDEOGRAPH
	{0x81ED,	0xAFE4},	// CJK UNIFIED IDEOGRAPH
	{0x81EE,	0xDB53},	// CJK UNIFIED IDEOGRAPH
	{0x81F2,	0xEAF4},	// CJK UNIFIED IDEOGRAPH
	{0x81F3,	0xA6DC},	// CJK UNIFIED IDEOGRAPH
	{0x81F4,	0xAD50},	// CJK UNIFIED IDEOGRAPH
	{0x81F7,	0xDB54},	// CJK UNIFIED IDEOGRAPH
	{0x81F8,	0xDB55},	// CJK UNIFIED IDEOGRAPH
	{0x81F9,	0xDB56},	// CJK UNIFIED IDEOGRAPH
	{0x81FA,	0xBB4F},	// CJK UNIFIED IDEOGRAPH
	{0x81FB,	0xBFB2},	// CJK UNIFIED IDEOGRAPH
	{0x81FC,	0xA6DD},	// CJK UNIFIED IDEOGRAPH
	{0x81FE,	0xAAD8},	// CJK UNIFIED IDEOGRAPH
	{0x81FF,	0xD068},	// CJK UNIFIED IDEOGRAPH
	{0x8200,	0xAFE6},	// CJK UNIFIED IDEOGRAPH
	{0x8201,	0xD370},	// CJK UNIFIED IDEOGRAPH
	{0x8202,	0xB2EA},	// CJK UNIFIED IDEOGRAPH
	{0x8204,	0xDB57},	// CJK UNIFIED IDEOGRAPH
	{0x8205,	0xB8A4},	// CJK UNIFIED IDEOGRAPH
	{0x8207,	0xBB50},	// CJK UNIFIED IDEOGRAPH
	{0x8208,	0xBFB3},	// CJK UNIFIED IDEOGRAPH
	{0x8209,	0xC17C},	// CJK UNIFIED IDEOGRAPH
	{0x820A,	0xC2C2},	// CJK UNIFIED IDEOGRAPH
	{0x820B,	0xF4B5},	// CJK UNIFIED IDEOGRAPH
	{0x820C,	0xA6DE},	// CJK UNIFIED IDEOGRAPH
	{0x820D,	0xAAD9},	// CJK UNIFIED IDEOGRAPH
	{0x8210,	0xAFE7},	// CJK UNIFIED IDEOGRAPH
	{0x8211,	0xD752},	// CJK UNIFIED IDEOGRAPH
	{0x8212,	0xB5CE},	// CJK UNIFIED IDEOGRAPH
	{0x8214,	0xBB51},	// CJK UNIFIED IDEOGRAPH
	{0x8215,	0xE3AB},	// CJK UNIFIED IDEOGRAPH
	{0x8216,	0xE745},	// CJK UNIFIED IDEOGRAPH
	{0x821B,	0xA6DF},	// CJK UNIFIED IDEOGRAPH
	{0x821C,	0xB5CF},	// CJK UNIFIED IDEOGRAPH
	{0x821D,	0xDFA3},	// CJK UNIFIED IDEOGRAPH
	{0x821E,	0xBB52},	// CJK UNIFIED IDEOGRAPH
	{0x821F,	0xA6E0},	// CJK UNIFIED IDEOGRAPH
	{0x8220,	0xCDB1},	// CJK UNIFIED IDEOGRAPH
	{0x8221,	0xD069},	// CJK UNIFIED IDEOGRAPH
	{0x8222,	0xAD51},	// CJK UNIFIED IDEOGRAPH
	{0x8225,	0xD372},	// CJK UNIFIED IDEOGRAPH
	{0x8228,	0xAFEA},	// CJK UNIFIED IDEOGRAPH
	{0x822A,	0xAFE8},	// CJK UNIFIED IDEOGRAPH
	{0x822B,	0xAFE9},	// CJK UNIFIED IDEOGRAPH
	{0x822C,	0xAFEB},	// CJK UNIFIED IDEOGRAPH
	{0x822F,	0xD371},	// CJK UNIFIED IDEOGRAPH
	{0x8232,	0xD757},	// CJK UNIFIED IDEOGRAPH
	{0x8233,	0xD754},	// CJK UNIFIED IDEOGRAPH
	{0x8234,	0xD756},	// CJK UNIFIED IDEOGRAPH
	{0x8235,	0xB2EB},	// CJK UNIFIED IDEOGRAPH
	{0x8236,	0xB2ED},	// CJK UNIFIED IDEOGRAPH
	{0x8237,	0xB2EC},	// CJK UNIFIED IDEOGRAPH
	{0x8238,	0xD753},	// CJK UNIFIED IDEOGRAPH
	{0x8239,	0xB2EE},	// CJK UNIFIED IDEOGRAPH
	{0x823A,	0xD755},	// CJK UNIFIED IDEOGRAPH
	{0x823C,	0xDB58},	// CJK UNIFIED IDEOGRAPH
	{0x823D,	0xDB59},	// CJK UNIFIED IDEOGRAPH
	{0x823F,	0xDB5A},	// CJK UNIFIED IDEOGRAPH
	{0x8240,	0xDFA6},	// CJK UNIFIED IDEOGRAPH
	{0x8242,	0xDFA7},	// CJK UNIFIED IDEOGRAPH
	{0x8244,	0xDFA5},	// CJK UNIFIED IDEOGRAPH
	{0x8245,	0xDFA8},	// CJK UNIFIED IDEOGRAPH
	{0x8247,	0xB8A5},	// CJK UNIFIED IDEOGRAPH
	{0x8249,	0xDFA4},	// CJK UNIFIED IDEOGRAPH
	{0x824B,	0xBB53},	// CJK UNIFIED IDEOGRAPH
	{0x824E,	0xE74A},	// CJK UNIFIED IDEOGRAPH
	{0x824F,	0xE746},	// CJK UNIFIED IDEOGRAPH
	{0x8250,	0xE749},	// CJK UNIFIED IDEOGRAPH
	{0x8251,	0xE74B},	// CJK UNIFIED IDEOGRAPH
	{0x8252,	0xE748},	// CJK UNIFIED IDEOGRAPH
	{0x8253,	0xE747},	// CJK UNIFIED IDEOGRAPH
	{0x8255,	0xEAF5},	// CJK UNIFIED IDEOGRAPH
	{0x8256,	0xEAF6},	// CJK UNIFIED IDEOGRAPH
	{0x8257,	0xEAF7},	// CJK UNIFIED IDEOGRAPH
	{0x8258,	0xBFB4},	// CJK UNIFIED IDEOGRAPH
	{0x8259,	0xBFB5},	// CJK UNIFIED IDEOGRAPH
	{0x825A,	0xEDF1},	// CJK UNIFIED IDEOGRAPH
	{0x825B,	0xEDF0},	// CJK UNIFIED IDEOGRAPH
	{0x825C,	0xEDF2},	// CJK UNIFIED IDEOGRAPH
	{0x825E,	0xF0A3},	// CJK UNIFIED IDEOGRAPH
	{0x825F,	0xF0A2},	// CJK UNIFIED IDEOGRAPH
	{0x8261,	0xF2C4},	// CJK UNIFIED IDEOGRAPH
	{0x8263,	0xF2C5},	// CJK UNIFIED IDEOGRAPH
	{0x8264,	0xF2C3},	// CJK UNIFIED IDEOGRAPH
	{0x8266,	0xC4A5},	// CJK UNIFIED IDEOGRAPH
	{0x8268,	0xF4B6},	// CJK UNIFIED IDEOGRAPH
	{0x8269,	0xF4B7},	// CJK UNIFIED IDEOGRAPH
	{0x826B,	0xF746},	// CJK UNIFIED IDEOGRAPH
	{0x826C,	0xF7EF},	// CJK UNIFIED IDEOGRAPH
	{0x826D,	0xF8BB},	// CJK UNIFIED IDEOGRAPH
	{0x826E,	0xA6E1},	// CJK UNIFIED IDEOGRAPH
	{0x826F,	0xA87D},	// CJK UNIFIED IDEOGRAPH
	{0x8271,	0xC17D},	// CJK UNIFIED IDEOGRAPH
	{0x8272,	0xA6E2},	// CJK UNIFIED IDEOGRAPH
	{0x8274,	0xD758},	// CJK UNIFIED IDEOGRAPH
	{0x8275,	0xDB5B},	// CJK UNIFIED IDEOGRAPH
	{0x8277,	0xC641},	// CJK UNIFIED IDEOGRAPH
	{0x8278,	0xCA4A},	// CJK UNIFIED IDEOGRAPH
	{0x827C,	0xCA4B},	// CJK UNIFIED IDEOGRAPH
	{0x827D,	0xCA4D},	// CJK UNIFIED IDEOGRAPH
	{0x827E,	0xA6E3},	// CJK UNIFIED IDEOGRAPH
	{0x827F,	0xCA4E},	// CJK UNIFIED IDEOGRAPH
	{0x8280,	0xCA4C},	// CJK UNIFIED IDEOGRAPH
	{0x8283,	0xCBA2},	// CJK UNIFIED IDEOGRAPH
	{0x8284,	0xCBA3},	// CJK UNIFIED IDEOGRAPH
	{0x8285,	0xCB7B},	// CJK UNIFIED IDEOGRAPH
	{0x828A,	0xCBA1},	// CJK UNIFIED IDEOGRAPH
	{0x828B,	0xA8A1},	// CJK UNIFIED IDEOGRAPH
	{0x828D,	0xA8A2},	// CJK UNIFIED IDEOGRAPH
	{0x828E,	0xCB7C},	// CJK UNIFIED IDEOGRAPH
	{0x828F,	0xCB7A},	// CJK UNIFIED IDEOGRAPH
	{0x8290,	0xCB79},	// CJK UNIFIED IDEOGRAPH
	{0x8291,	0xCB7D},	// CJK UNIFIED IDEOGRAPH
	{0x8292,	0xA87E},	// CJK UNIFIED IDEOGRAPH
	{0x8293,	0xCB7E},	// CJK UNIFIED IDEOGRAPH
	{0x8294,	0xD06A},	// CJK UNIFIED IDEOGRAPH
	{0x8298,	0xCDB6},	// CJK UNIFIED IDEOGRAPH
	{0x8299,	0xAADC},	// CJK UNIFIED IDEOGRAPH
	{0x829A,	0xCDB5},	// CJK UNIFIED IDEOGRAPH
	{0x829B,	0xCDB7},	// CJK UNIFIED IDEOGRAPH
	{0x829D,	0xAADB},	// CJK UNIFIED IDEOGRAPH
	{0x829E,	0xCDBC},	// CJK UNIFIED IDEOGRAPH
	{0x829F,	0xAADF},	// CJK UNIFIED IDEOGRAPH
	{0x82A0,	0xCDB2},	// CJK UNIFIED IDEOGRAPH
	{0x82A1,	0xCDC0},	// CJK UNIFIED IDEOGRAPH
	{0x82A2,	0xCDC6},	// CJK UNIFIED IDEOGRAPH
	{0x82A3,	0xAAE6},	// CJK UNIFIED IDEOGRAPH
	{0x82A4,	0xCDC3},	// CJK UNIFIED IDEOGRAPH
	{0x82A5,	0xAAE3},	// CJK UNIFIED IDEOGRAPH
	{0x82A7,	0xCDB9},	// CJK UNIFIED IDEOGRAPH
	{0x82A8,	0xCDBF},	// CJK UNIFIED IDEOGRAPH
	{0x82A9,	0xCDC1},	// CJK UNIFIED IDEOGRAPH
	{0x82AB,	0xCDB4},	// CJK UNIFIED IDEOGRAPH
	{0x82AC,	0xAAE2},	// CJK UNIFIED IDEOGRAPH
	{0x82AD,	0xAADD},	// CJK UNIFIED IDEOGRAPH
	{0x82AE,	0xCDBA},	// CJK UNIFIED IDEOGRAPH
	{0x82AF,	0xAAE4},	// CJK UNIFIED IDEOGRAPH
	{0x82B0,	0xAAE7},	// CJK UNIFIED IDEOGRAPH
	{0x82B1,	0xAAE1},	// CJK UNIFIED IDEOGRAPH
	{0x82B3,	0xAADA},	// CJK UNIFIED IDEOGRAPH
	{0x82B4,	0xCDBE},	// CJK UNIFIED IDEOGRAPH
	{0x82B5,	0xCDB8},	// CJK UNIFIED IDEOGRAPH
	{0x82B6,	0xCDC5},	// CJK UNIFIED IDEOGRAPH
	{0x82B7,	0xAAE9},	// CJK UNIFIED IDEOGRAPH
	{0x82B8,	0xAAE5},	// CJK UNIFIED IDEOGRAPH
	{0x82B9,	0xAAE0},	// CJK UNIFIED IDEOGRAPH
	{0x82BA,	0xCDBD},	// CJK UNIFIED IDEOGRAPH
	{0x82BB,	0xAFEC},	// CJK UNIFIED IDEOGRAPH
	{0x82BC,	0xCDBB},	// CJK UNIFIED IDEOGRAPH
	{0x82BD,	0xAADE},	// CJK UNIFIED IDEOGRAPH
	{0x82BE,	0xAAE8},	// CJK UNIFIED IDEOGRAPH
	{0x82C0,	0xCDB3},	// CJK UNIFIED IDEOGRAPH
	{0x82C2,	0xCDC2},	// CJK UNIFIED IDEOGRAPH
	{0x82C3,	0xCDC4},	// CJK UNIFIED IDEOGRAPH
	{0x82D1,	0xAD62},	// CJK UNIFIED IDEOGRAPH
	{0x82D2,	0xAD5C},	// CJK UNIFIED IDEOGRAPH
	{0x82D3,	0xAD64},	// CJK UNIFIED IDEOGRAPH
	{0x82D4,	0xAD61},	// CJK UNIFIED IDEOGRAPH
	{0x82D5,	0xD071},	// CJK UNIFIED IDEOGRAPH
	{0x82D6,	0xD074},	// CJK UNIFIED IDEOGRAPH
	{0x82D7,	0xAD5D},	// CJK UNIFIED IDEOGRAPH
	{0x82D9,	0xD06B},	// CJK UNIFIED IDEOGRAPH
	{0x82DB,	0xAD56},	// CJK UNIFIED IDEOGRAPH
	{0x82DC,	0xAD60},	// CJK UNIFIED IDEOGRAPH
	{0x82DE,	0xAD63},	// CJK UNIFIED IDEOGRAPH
	{0x82DF,	0xAD65},	// CJK UNIFIED IDEOGRAPH
	{0x82E0,	0xD0A2},	// CJK UNIFIED IDEOGRAPH
	{0x82E1,	0xD077},	// CJK UNIFIED IDEOGRAPH
	{0x82E3,	0xAD55},	// CJK UNIFIED IDEOGRAPH
	{0x82E4,	0xD0A1},	// CJK UNIFIED IDEOGRAPH
	{0x82E5,	0xAD59},	// CJK UNIFIED IDEOGRAPH
	{0x82E6,	0xAD57},	// CJK UNIFIED IDEOGRAPH
	{0x82E7,	0xAD52},	// CJK UNIFIED IDEOGRAPH
	{0x82E8,	0xD06F},	// CJK UNIFIED IDEOGRAPH
	{0x82EA,	0xD07E},	// CJK UNIFIED IDEOGRAPH
	{0x82EB,	0xD073},	// CJK UNIFIED IDEOGRAPH
	{0x82EC,	0xD076},	// CJK UNIFIED IDEOGRAPH
	{0x82ED,	0xD0A5},	// CJK UNIFIED IDEOGRAPH
	{0x82EF,	0xAD66},	// CJK UNIFIED IDEOGRAPH
	{0x82F0,	0xD07D},	// CJK UNIFIED IDEOGRAPH
	{0x82F1,	0xAD5E},	// CJK UNIFIED IDEOGRAPH
	{0x82F2,	0xD078},	// CJK UNIFIED IDEOGRAPH
	{0x82F3,	0xD0A4},	// CJK UNIFIED IDEOGRAPH
	{0x82F4,	0xD075},	// CJK UNIFIED IDEOGRAPH
	{0x82F5,	0xD079},	// CJK UNIFIED IDEOGRAPH
	{0x82F6,	0xD07C},	// CJK UNIFIED IDEOGRAPH
	{0x82F9,	0xD06D},	// CJK UNIFIED IDEOGRAPH
	{0x82FA,	0xD0A3},	// CJK UNIFIED IDEOGRAPH
	{0x82FB,	0xD07B},	// CJK UNIFIED IDEOGRAPH
	{0x82FE,	0xD06C},	// CJK UNIFIED IDEOGRAPH
	{0x8300,	0xD070},	// CJK UNIFIED IDEOGRAPH
	{0x8301,	0xAD5F},	// CJK UNIFIED IDEOGRAPH
	{0x8302,	0xAD5A},	// CJK UNIFIED IDEOGRAPH
	{0x8303,	0xAD53},	// CJK UNIFIED IDEOGRAPH
	{0x8304,	0xAD58},	// CJK UNIFIED IDEOGRAPH
	{0x8305,	0xAD54},	// CJK UNIFIED IDEOGRAPH
	{0x8306,	0xAD67},	// CJK UNIFIED IDEOGRAPH
	{0x8307,	0xD06E},	// CJK UNIFIED IDEOGRAPH
	{0x8308,	0xD3A5},	// CJK UNIFIED IDEOGRAPH
	{0x8309,	0xAD5B},	// CJK UNIFIED IDEOGRAPH
	{0x830C,	0xD07A},	// CJK UNIFIED IDEOGRAPH
	{0x830D,	0xCE41},	// CJK UNIFIED IDEOGRAPH
	{0x8316,	0xD3A8},	// CJK UNIFIED IDEOGRAPH
	{0x8317,	0xAFFA},	// CJK UNIFIED IDEOGRAPH
	{0x8319,	0xD376},	// CJK UNIFIED IDEOGRAPH
	{0x831B,	0xD3A3},	// CJK UNIFIED IDEOGRAPH
	{0x831C,	0xD37D},	// CJK UNIFIED IDEOGRAPH
	{0x831E,	0xD3B2},	// CJK UNIFIED IDEOGRAPH
	{0x8320,	0xD3AA},	// CJK UNIFIED IDEOGRAPH
	{0x8322,	0xD37E},	// CJK UNIFIED IDEOGRAPH
	{0x8324,	0xD3A9},	// CJK UNIFIED IDEOGRAPH
	{0x8325,	0xD378},	// CJK UNIFIED IDEOGRAPH
	{0x8326,	0xD37C},	// CJK UNIFIED IDEOGRAPH
	{0x8327,	0xD3B5},	// CJK UNIFIED IDEOGRAPH
	{0x8328,	0xAFFD},	// CJK UNIFIED IDEOGRAPH
	{0x8329,	0xD3AD},	// CJK UNIFIED IDEOGRAPH
	{0x832A,	0xD3A4},	// CJK UNIFIED IDEOGRAPH
	{0x832B,	0xAFED},	// CJK UNIFIED IDEOGRAPH
	{0x832C,	0xD3B3},	// CJK UNIFIED IDEOGRAPH
	{0x832D,	0xD374},	// CJK UNIFIED IDEOGRAPH
	{0x832F,	0xD3AC},	// CJK UNIFIED IDEOGRAPH
	{0x8331,	0xAFFC},	// CJK UNIFIED IDEOGRAPH
	{0x8332,	0xAFF7},	// CJK UNIFIED IDEOGRAPH
	{0x8333,	0xD373},	// CJK UNIFIED IDEOGRAPH
	{0x8334,	0xAFF5},	// CJK UNIFIED IDEOGRAPH
	{0x8335,	0xAFF4},	// CJK UNIFIED IDEOGRAPH
	{0x8336,	0xAFF9},	// CJK UNIFIED IDEOGRAPH
	{0x8337,	0xD3AB},	// CJK UNIFIED IDEOGRAPH
	{0x8338,	0xAFF1},	// CJK UNIFIED IDEOGRAPH
	{0x8339,	0xAFF8},	// CJK UNIFIED IDEOGRAPH
	{0x833A,	0xD072},	// CJK UNIFIED IDEOGRAPH
	{0x833B,	0xDB5C},	// CJK UNIFIED IDEOGRAPH
	{0x833C,	0xD3A6},	// CJK UNIFIED IDEOGRAPH
	{0x833F,	0xD37A},	// CJK UNIFIED IDEOGRAPH
	{0x8340,	0xAFFB},	// CJK UNIFIED IDEOGRAPH
	{0x8341,	0xD37B},	// CJK UNIFIED IDEOGRAPH
	{0x8342,	0xD3A1},	// CJK UNIFIED IDEOGRAPH
	{0x8343,	0xAFFE},	// CJK UNIFIED IDEOGRAPH
	{0x8344,	0xD375},	// CJK UNIFIED IDEOGRAPH
	{0x8345,	0xD3AF},	// CJK UNIFIED IDEOGRAPH
	{0x8347,	0xD3AE},	// CJK UNIFIED IDEOGRAPH
	{0x8348,	0xD3B6},	// CJK UNIFIED IDEOGRAPH
	{0x8349,	0xAFF3},	// CJK UNIFIED IDEOGRAPH
	{0x834A,	0xAFF0},	// CJK UNIFIED IDEOGRAPH
	{0x834B,	0xD3B4},	// CJK UNIFIED IDEOGRAPH
	{0x834C,	0xD3B0},	// CJK UNIFIED IDEOGRAPH
	{0x834D,	0xD3A7},	// CJK UNIFIED IDEOGRAPH
	{0x834E,	0xD3A2},	// CJK UNIFIED IDEOGRAPH
	{0x834F,	0xAFF6},	// CJK UNIFIED IDEOGRAPH
	{0x8350,	0xAFF2},	// CJK UNIFIED IDEOGRAPH
	{0x8351,	0xD377},	// CJK UNIFIED IDEOGRAPH
	{0x8352,	0xAFEE},	// CJK UNIFIED IDEOGRAPH
	{0x8353,	0xD3B1},	// CJK UNIFIED IDEOGRAPH
	{0x8354,	0xAFEF},	// CJK UNIFIED IDEOGRAPH
	{0x8356,	0xD379},	// CJK UNIFIED IDEOGRAPH
	{0x8373,	0xD75E},	// CJK UNIFIED IDEOGRAPH
	{0x8374,	0xD760},	// CJK UNIFIED IDEOGRAPH
	{0x8375,	0xD765},	// CJK UNIFIED IDEOGRAPH
	{0x8376,	0xD779},	// CJK UNIFIED IDEOGRAPH
	{0x8377,	0xB2FC},	// CJK UNIFIED IDEOGRAPH
	{0x8378,	0xB2F2},	// CJK UNIFIED IDEOGRAPH
	{0x837A,	0xD75D},	// CJK UNIFIED IDEOGRAPH
	{0x837B,	0xB2FD},	// CJK UNIFIED IDEOGRAPH
	{0x837C,	0xB2FE},	// CJK UNIFIED IDEOGRAPH
	{0x837D,	0xD768},	// CJK UNIFIED IDEOGRAPH
	{0x837E,	0xD76F},	// CJK UNIFIED IDEOGRAPH
	{0x837F,	0xD775},	// CJK UNIFIED IDEOGRAPH
	{0x8381,	0xD762},	// CJK UNIFIED IDEOGRAPH
	{0x8383,	0xD769},	// CJK UNIFIED IDEOGRAPH
	{0x8386,	0xB340},	// CJK UNIFIED IDEOGRAPH
	{0x8387,	0xD777},	// CJK UNIFIED IDEOGRAPH
	{0x8388,	0xD772},	// CJK UNIFIED IDEOGRAPH
	{0x8389,	0xB2FA},	// CJK UNIFIED IDEOGRAPH
	{0x838A,	0xB2F8},	// CJK UNIFIED IDEOGRAPH
	{0x838B,	0xD76E},	// CJK UNIFIED IDEOGRAPH
	{0x838C,	0xD76A},	// CJK UNIFIED IDEOGRAPH
	{0x838D,	0xD75C},	// CJK UNIFIED IDEOGRAPH
	{0x838E,	0xB2EF},	// CJK UNIFIED IDEOGRAPH
	{0x838F,	0xD761},	// CJK UNIFIED IDEOGRAPH
	{0x8390,	0xD759},	// CJK UNIFIED IDEOGRAPH
	{0x8392,	0xB2F7},	// CJK UNIFIED IDEOGRAPH
	{0x8393,	0xB2F9},	// CJK UNIFIED IDEOGRAPH
	{0x8394,	0xD766},	// CJK UNIFIED IDEOGRAPH
	{0x8395,	0xD763},	// CJK UNIFIED IDEOGRAPH
	{0x8396,	0xB2F4},	// CJK UNIFIED IDEOGRAPH
	{0x8397,	0xD773},	// CJK UNIFIED IDEOGRAPH
	{0x8398,	0xB2F1},	// CJK UNIFIED IDEOGRAPH
	{0x8399,	0xD764},	// CJK UNIFIED IDEOGRAPH
	{0x839A,	0xD77A},	// CJK UNIFIED IDEOGRAPH
	{0x839B,	0xD76C},	// CJK UNIFIED IDEOGRAPH
	{0x839D,	0xD76B},	// CJK UNIFIED IDEOGRAPH
	{0x839E,	0xB2F0},	// CJK UNIFIED IDEOGRAPH
	{0x83A0,	0xB2FB},	// CJK UNIFIED IDEOGRAPH
	{0x83A2,	0xB2F3},	// CJK UNIFIED IDEOGRAPH
	{0x83A3,	0xD75A},	// CJK UNIFIED IDEOGRAPH
	{0x83A4,	0xD75F},	// CJK UNIFIED IDEOGRAPH
	{0x83A5,	0xD770},	// CJK UNIFIED IDEOGRAPH
	{0x83A6,	0xD776},	// CJK UNIFIED IDEOGRAPH
	{0x83A7,	0xB341},	// CJK UNIFIED IDEOGRAPH
	{0x83A8,	0xD75B},	// CJK UNIFIED IDEOGRAPH
	{0x83A9,	0xD767},	// CJK UNIFIED IDEOGRAPH
	{0x83AA,	0xD76D},	// CJK UNIFIED IDEOGRAPH
	{0x83AB,	0xB2F6},	// CJK UNIFIED IDEOGRAPH
	{0x83AE,	0xD778},	// CJK UNIFIED IDEOGRAPH
	{0x83AF,	0xD771},	// CJK UNIFIED IDEOGRAPH
	{0x83B0,	0xD774},	// CJK UNIFIED IDEOGRAPH
	{0x83BD,	0xB2F5},	// CJK UNIFIED IDEOGRAPH
	{0x83BF,	0xDB6C},	// CJK UNIFIED IDEOGRAPH
	{0x83C0,	0xDB60},	// CJK UNIFIED IDEOGRAPH
	{0x83C1,	0xB5D7},	// CJK UNIFIED IDEOGRAPH
	{0x83C2,	0xDB7D},	// CJK UNIFIED IDEOGRAPH
	{0x83C3,	0xDBA7},	// CJK UNIFIED IDEOGRAPH
	{0x83C4,	0xDBAA},	// CJK UNIFIED IDEOGRAPH
	{0x83C5,	0xB5D5},	// CJK UNIFIED IDEOGRAPH
	{0x83C6,	0xDB68},	// CJK UNIFIED IDEOGRAPH
	{0x83C7,	0xDBA3},	// CJK UNIFIED IDEOGRAPH
	{0x83C8,	0xDB69},	// CJK UNIFIED IDEOGRAPH
	{0x83C9,	0xDB77},	// CJK UNIFIED IDEOGRAPH
	{0x83CA,	0xB5E2},	// CJK UNIFIED IDEOGRAPH
	{0x83CB,	0xDB73},	// CJK UNIFIED IDEOGRAPH
	{0x83CC,	0xB5DF},	// CJK UNIFIED IDEOGRAPH
	{0x83CE,	0xDB74},	// CJK UNIFIED IDEOGRAPH
	{0x83CF,	0xDB5D},	// CJK UNIFIED IDEOGRAPH
	{0x83D1,	0xDBA4},	// CJK UNIFIED IDEOGRAPH
	{0x83D4,	0xB5E8},	// CJK UNIFIED IDEOGRAPH
	{0x83D5,	0xDBA1},	// CJK UNIFIED IDEOGRAPH
	{0x83D6,	0xDB75},	// CJK UNIFIED IDEOGRAPH
	{0x83D7,	0xDBAC},	// CJK UNIFIED IDEOGRAPH
	{0x83D8,	0xDB70},	// CJK UNIFIED IDEOGRAPH
	{0x83D9,	0xDFC8},	// CJK UNIFIED IDEOGRAPH
	{0x83DB,	0xDBAF},	// CJK UNIFIED IDEOGRAPH
	{0x83DC,	0xB5E6},	// CJK UNIFIED IDEOGRAPH
	{0x83DD,	0xDB6E},	// CJK UNIFIED IDEOGRAPH
	{0x83DE,	0xDB7A},	// CJK UNIFIED IDEOGRAPH
	{0x83DF,	0xB5E9},	// CJK UNIFIED IDEOGRAPH
	{0x83E0,	0xB5D4},	// CJK UNIFIED IDEOGRAPH
	{0x83E1,	0xDB72},	// CJK UNIFIED IDEOGRAPH
	{0x83E2,	0xDBAD},	// CJK UNIFIED IDEOGRAPH
	{0x83E3,	0xDB6B},	// CJK UNIFIED IDEOGRAPH
	{0x83E4,	0xDB64},	// CJK UNIFIED IDEOGRAPH
	{0x83E5,	0xDB6F},	// CJK UNIFIED IDEOGRAPH
	{0x83E7,	0xDB63},	// CJK UNIFIED IDEOGRAPH
	{0x83E8,	0xDB61},	// CJK UNIFIED IDEOGRAPH
	{0x83E9,	0xB5D0},	// CJK UNIFIED IDEOGRAPH
	{0x83EA,	0xDBA5},	// CJK UNIFIED IDEOGRAPH
	{0x83EB,	0xDB6A},	// CJK UNIFIED IDEOGRAPH
	{0x83EC,	0xDBA8},	// CJK UNIFIED IDEOGRAPH
	{0x83EE,	0xDBA9},	// CJK UNIFIED IDEOGRAPH
	{0x83EF,	0xB5D8},	// CJK UNIFIED IDEOGRAPH
	{0x83F0,	0xB5DD},	// CJK UNIFIED IDEOGRAPH
	{0x83F1,	0xB5D9},	// CJK UNIFIED IDEOGRAPH
	{0x83F2,	0xB5E1},	// CJK UNIFIED IDEOGRAPH
	{0x83F3,	0xDB7E},	// CJK UNIFIED IDEOGRAPH
	{0x83F4,	0xB5DA},	// CJK UNIFIED IDEOGRAPH
	{0x83F5,	0xDB76},	// CJK UNIFIED IDEOGRAPH
	{0x83F6,	0xDB66},	// CJK UNIFIED IDEOGRAPH
	{0x83F8,	0xB5D2},	// CJK UNIFIED IDEOGRAPH
	{0x83F9,	0xDB5E},	// CJK UNIFIED IDEOGRAPH
	{0x83FA,	0xDBA2},	// CJK UNIFIED IDEOGRAPH
	{0x83FB,	0xDBAB},	// CJK UNIFIED IDEOGRAPH
	{0x83FC,	0xDB65},	// CJK UNIFIED IDEOGRAPH
	{0x83FD,	0xB5E0},	// CJK UNIFIED IDEOGRAPH
	{0x83FE,	0xDBB0},	// CJK UNIFIED IDEOGRAPH
	{0x83FF,	0xDB71},	// CJK UNIFIED IDEOGRAPH
	{0x8401,	0xDB6D},	// CJK UNIFIED IDEOGRAPH
	{0x8403,	0xB5D1},	// CJK UNIFIED IDEOGRAPH
	{0x8404,	0xB5E5},	// CJK UNIFIED IDEOGRAPH
	{0x8406,	0xDB7C},	// CJK UNIFIED IDEOGRAPH
	{0x8407,	0xB5E7},	// CJK UNIFIED IDEOGRAPH
	{0x8409,	0xDB78},	// CJK UNIFIED IDEOGRAPH
	{0x840A,	0xB5DC},	// CJK UNIFIED IDEOGRAPH
	{0x840B,	0xB5D6},	// CJK UNIFIED IDEOGRAPH
	{0x840C,	0xB5DE},	// CJK UNIFIED IDEOGRAPH
	{0x840D,	0xB5D3},	// CJK UNIFIED IDEOGRAPH
	{0x840E,	0xB5E4},	// CJK UNIFIED IDEOGRAPH
	{0x840F,	0xDB79},	// CJK UNIFIED IDEOGRAPH
	{0x8410,	0xDB67},	// CJK UNIFIED IDEOGRAPH
	{0x8411,	0xDB7B},	// CJK UNIFIED IDEOGRAPH
	{0x8412,	0xDB62},	// CJK UNIFIED IDEOGRAPH
	{0x8413,	0xDBA6},	// CJK UNIFIED IDEOGRAPH
	{0x841B,	0xDBAE},	// CJK UNIFIED IDEOGRAPH
	{0x8423,	0xDB5F},	// CJK UNIFIED IDEOGRAPH
	{0x8429,	0xDFC7},	// CJK UNIFIED IDEOGRAPH
	{0x842B,	0xDFDD},	// CJK UNIFIED IDEOGRAPH
	{0x842C,	0xB855},	// CJK UNIFIED IDEOGRAPH
	{0x842D,	0xDFCC},	// CJK UNIFIED IDEOGRAPH
	{0x842F,	0xDFCA},	// CJK UNIFIED IDEOGRAPH
	{0x8430,	0xDFB5},	// CJK UNIFIED IDEOGRAPH
	{0x8431,	0xB8A9},	// CJK UNIFIED IDEOGRAPH
	{0x8432,	0xDFC5},	// CJK UNIFIED IDEOGRAPH
	{0x8433,	0xDFD9},	// CJK UNIFIED IDEOGRAPH
	{0x8434,	0xDFC1},	// CJK UNIFIED IDEOGRAPH
	{0x8435,	0xB8B1},	// CJK UNIFIED IDEOGRAPH
	{0x8436,	0xDFD8},	// CJK UNIFIED IDEOGRAPH
	{0x8437,	0xDFBF},	// CJK UNIFIED IDEOGRAPH
	{0x8438,	0xB5E3},	// CJK UNIFIED IDEOGRAPH
	{0x8439,	0xDFCF},	// CJK UNIFIED IDEOGRAPH
	{0x843A,	0xDFC0},	// CJK UNIFIED IDEOGRAPH
	{0x843B,	0xDFD6},	// CJK UNIFIED IDEOGRAPH
	{0x843C,	0xB8B0},	// CJK UNIFIED IDEOGRAPH
	{0x843D,	0xB8A8},	// CJK UNIFIED IDEOGRAPH
	{0x843F,	0xDFAA},	// CJK UNIFIED IDEOGRAPH
	{0x8440,	0xDFB2},	// CJK UNIFIED IDEOGRAPH
	{0x8442,	0xDFCB},	// CJK UNIFIED IDEOGRAPH
	{0x8443,	0xDFC3},	// CJK UNIFIED IDEOGRAPH
	{0x8444,	0xDFDC},	// CJK UNIFIED IDEOGRAPH
	{0x8445,	0xDFC6},	// CJK UNIFIED IDEOGRAPH
	{0x8446,	0xB8B6},	// CJK UNIFIED IDEOGRAPH
	{0x8447,	0xDFD7},	// CJK UNIFIED IDEOGRAPH
	{0x8449,	0xB8AD},	// CJK UNIFIED IDEOGRAPH
	{0x844B,	0xDFC9},	// CJK UNIFIED IDEOGRAPH
	{0x844C,	0xDFD1},	// CJK UNIFIED IDEOGRAPH
	{0x844D,	0xDFB6},	// CJK UNIFIED IDEOGRAPH
	{0x844E,	0xDFD0},	// CJK UNIFIED IDEOGRAPH
	{0x8450,	0xDFE1},	// CJK UNIFIED IDEOGRAPH
	{0x8451,	0xDFB1},	// CJK UNIFIED IDEOGRAPH
	{0x8452,	0xDFD2},	// CJK UNIFIED IDEOGRAPH
	{0x8454,	0xDFDF},	// CJK UNIFIED IDEOGRAPH
	{0x8456,	0xDFAB},	// CJK UNIFIED IDEOGRAPH
	{0x8457,	0xB5DB},	// CJK UNIFIED IDEOGRAPH
	{0x8459,	0xDFB9},	// CJK UNIFIED IDEOGRAPH
	{0x845A,	0xDFB8},	// CJK UNIFIED IDEOGRAPH
	{0x845B,	0xB8AF},	// CJK UNIFIED IDEOGRAPH
	{0x845D,	0xDFBC},	// CJK UNIFIED IDEOGRAPH
	{0x845E,	0xDFBE},	// CJK UNIFIED IDEOGRAPH
	{0x845F,	0xDFCD},	// CJK UNIFIED IDEOGRAPH
	{0x8460,	0xDFDE},	// CJK UNIFIED IDEOGRAPH
	{0x8461,	0xB8B2},	// CJK UNIFIED IDEOGRAPH
	{0x8463,	0xB8B3},	// CJK UNIFIED IDEOGRAPH
	{0x8465,	0xDFB0},	// CJK UNIFIED IDEOGRAPH
	{0x8466,	0xB8AB},	// CJK UNIFIED IDEOGRAPH
	{0x8467,	0xDFB4},	// CJK UNIFIED IDEOGRAPH
	{0x8468,	0xDFDA},	// CJK UNIFIED IDEOGRAPH
	{0x8469,	0xB8B4},	// CJK UNIFIED IDEOGRAPH
	{0x846B,	0xB8AC},	// CJK UNIFIED IDEOGRAPH
	{0x846C,	0xB8A